<?php
include("../../../lib/Sistema.php");

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB(){
    $clase = new Sistema();
    $conexion = mysqli_connect($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion
////////////////////////////////////////////////////////////////////////////////////////////////////o
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_row($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$periodo  = $_GET['periodo'];

if($periodo != "")
{
    $criterio = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);
    $sql = "SELECT DV.diaoperativo , SUM(D.total) ventageneral , 
            (SELECT COALESCE(ROUND(SUM(valorventa)),0) FROM bonificado WHERE fecha = STR_TO_DATE(DV.diaoperativo, '%d/%m/%Y')) ventaespecial , 
            (SELECT SUM(DDX.valtotal) FROM dedocumentos DDX INNER JOIN documentos DX ON (DDX.docuid = DX.docuid) 
             INNER JOIN docuventa DVX ON (DX.docuid = DVX.docuid) INNER JOIN productos PX ON (PX.productoid = DDX.productoid) 
             WHERE DX.tipodoc = 'FVE' AND DVX.diaoperativo = DV.diaoperativo AND DX.fecasentado <> '0000-00-00' AND PX.codigo IN ('R1000','R1001')) recargas,
            (SELECT SUM(DX.total) FROM documentos DX  INNER JOIN docudevolucion DDX ON (DX.docuid = DDX.docuid)
             WHERE DX.tipodoc = 'DVE' AND DX.fecasentado <> '0000-00-00' AND DDX.diaoperativo = DV.diaoperativo ) devoluciones
            FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
            WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."'
            GROUP BY 1 ORDER BY 1 ASC";
   //   echo $sql;      
    $myArray = getArraySQL($sql);
    
    /// Salida al Navegador
    header('Content-type: application/json; charset=utf-8');
    echo json_encode($myArray, JSON_PRETTY_PRINT);
}
else
{
    $code = 400;
    $message = "Periodo Incorrecto. Deve enviar el Periodo en Formato MM YYYY ---- URL Example : dropos/wsjson/dropos20/ventasucursal/?periodo=062021";
    $myArray = array("code" => $code , "message" => $message);
    
    /// Salida al Navegador
    header('Content-type: application/json; charset=utf-8');
    echo json_encode($myArray);
}
?>