<?php

error_reporting(E_ALL);
ini_set('display_errors', FALSE);
ini_set('display_startup_errors', FALSE);

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{
    $db = parse_ini_file("../../../lib/datasource.ini");
    //echo $db['ServidorBD'];
    $conexion = mysqli_connect($db['ServidorBD'],"DROPOS2.0",$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_array($result))
       $retorno = $row[0];
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$data = "";
$numero = @$_GET['numero'];
if($numero != "")
{
    $docuid = SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'TRB' AND prefijo = 'REM' AND numero = '".$numero."'");
    if($docuid != "")
    {
        $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.nrodocref PedidoAsociado , HT.inicio MomentoInicio , HT.fin MomentoFin , 
                 D.codigo1 CodRemisiono , D.codigo2 CodSeparo , D.codigo3 CodFacturo , D.totalitems , D.total VlrTotalRem , 
                 B1.codbodega CodBodOri , B1.nombodega NomBodOri , B2.codbodega CodBodDes , B2.nombodega NomBodDes , P.codigo CodBarra , P.descripcion NomProducto , 
                 HT.bolsa bolsas , HT.caja cajas , HT.canastilla canastas , HT.agua aguas , SUM(DD.cantidad) cantidad  
                 FROM documentos D
                 INNER JOIN docutranfe DT ON (D.docuid = DT.docuid)
                 INNER JOIN bodegas B1 ON (B1.bodegaid = DT.bodegaidori) 
                 INNER JOIN bodegas B2 ON (B2.bodegaid = DT.bodegaiddes) 
                 INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
                 INNER JOIN productos P ON (P.productoid = DD.productoid)
                 LEFT JOIN horasxtranfe HT ON (HT.docuid = D.docuid) 
                 WHERE D.docuid = '".$docuid."'
                 GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22";      
        
        $data = getArraySQL($vsql);
        if($data)
        {
            $code = 200;
            $message = "Datos del Usuario Exitosos";    
        }
        else
        {
            $code = 400;
            $message = "No existen datos de la Persona";
        }
    }
    else
    {
        $code = 400;
        $message = "Documento NO Existe";
    }
}
else
{
    $code = 400;
    $message = "Documento NO Existe";
    $data = "";
}


header('Content-type: application/json; charset=utf-8');
echo json_encode($data);
?>