<?php

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{    
    $db = parse_ini_file("../../lib/datasource.ini");
    $conexion = mysqli_connect($db['ServidorBD'],$db['UsuarioBD'],$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    $retorno = "";
    if($row = mysqli_fetch_array($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////

try{

    $array = json_decode(file_get_contents('php://input'), true);
    //print_r($array);

    $i=0;
    $detalles = "";
    $code = 0;
    $message = "";
    $diaoperativo = ""; $codsucursal = "";

    /// Mensaje de Respuesta 
    $code = 200;
    $message = "Devolucion Recibida con Exito.";    

    foreach($array as $registros)
    {
        foreach($registros as $producto)
        {
            ////  Documento  
            $docuid       = $producto['docuid'];                     $tipodoc      = $producto['tipodoc'];                   $prefijo      = $producto['prefijo'];
            $numero       = $producto['numero'];                     $periodo      = $producto['periodo'];                   $observacion  = $producto['observacion'];
            $base         = $producto['base'];                       $iva          = $producto['iva'];                       $total        = $producto['total'];
            $totalitems   = $producto['totalitems'];                 $sucursalid   = $producto['sucursalid'];                $creador      = $producto['creador'];
            $momento      = $producto['momento'];
                            
            ////  Docutranfe                
            $bodori   = $producto['bodegaidori'];                    $boddes   = $producto['bodegaiddes'];
            
            //// Dedocumentos
            $productoid = $producto['productoid'];                   $bodegaid = $producto['bodegaid'];                      $cantidad = $producto['cantidad'];
            $valuni     = $producto['valunitario'];                  $valpar   = $producto['valparcial'];                    
           
            if($i == 0)
            {
                ///////////////////////////////////////////////////////
                //// Primero Valido que el Documento NO EXISTA
                //echo "SELECT docuid FROM documentos WHERE tipodoc = 'TXC' AND prefijo = '".$prefijo."' AND numero = '".$numero."'";
                $existe = SeleccionarUno("SELECT docuid FROM documentos WHERE (tipodoc = 'TXC' or tipodoc = 'TRB') AND prefijo = '".$prefijo."' AND numero = '".$numero."'");
                if($existe == "")
                {
                    //// 1. Inserto en Documentos 
                    $vsql = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,formapago,nrodocref,
                             terid1,terid2,terid3,codigo1,codigo2,codigo3,observacion,base,iva,total,totalitems,sucursalid,creador,momento) 
                             VALUES('TXC','".$prefijo."','".$numero."','".$periodo."',CURRENT_DATE,CURRENT_DATE,'CO','DEVEXCESOS',
                             1,1,1,'0','0','0','".$observacion."',0,0,0,'".$totalitems."','".$sucursalid."','".$creador."','".$momento."')";
                    //echo $vsql;         
                    EjecutarSQL($vsql);  
                    
                    /// Recupero el Docuid
                    $NDOCUID = SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'TXC' AND prefijo = '".$prefijo."' AND numero = '".$numero."'");
                }
                else
                    $NDOCUID = $existe;
                
                //echo $NDOCUID."*<br>";    
                //// 2. Inserto en Docutranfe    
                $existe = SeleccionarUno("SELECT COUNT(*) FROM docutranfe WHERE docuid = ".$docuid);
                if($existe > 0)
                  EjecutarSQL("DELETE FROM docutranfe WHERE docuid = ".$NDOCUID);  

                $vsql = "INSERT INTO docutranfe(docuid,bodegaidori,bodegaiddes,kardexori,kardexdes,enviado,cargadodestino) 
                         VALUES('".$NDOCUID."','".$bodori."','".$boddes."','S','S',CURRENT_TIMESTAMP,'CHECKED')";
                EjecutarSQL($vsql); 
                
                /// 3. Limpio los Dedocumentos
                EjecutarSQL("DELETE FROM dedocumentos WHERE docuid = ".$NDOCUID);       
            }   

            ///// Inserto en DeDocumentos
            $vsql = "INSERT INTO dedocumentos(docuid,bodegaid,productoid,cantidad,unidades,tipund,costoprod,valunitario,valparcial,porciva,valbase,valtotal,unicom,unifra) 
                        VALUES('".$NDOCUID."','".$bodegaid."','".$productoid."','".$cantidad."','".$cantidad."','D',0,'".$valuni."','".$valpar."',0,'".$valpar."','".$valpar."','".$cantidad."',0)";
            EjecutarSQL($vsql);                 
            //echo $vsql."<br>";

            //// Next
            $i++;            
        }       
    }    

    if(strlen($NDOCUID)>0)
    {
        $code    = "200";
        $message = "Devolucion Excesos Generada con Exito";
        $docuid  = $NDOCUID;
        $numero  = 'TXC '.$prefijo.' '.$numero;
    }
    else
    {
        $code    = "400";
        $message = "Error al Generar la Devolucion";
        $docuid  = "";
        $numero  = "";
    }
        
    //// Retorno los Datos
    $response = array("code" => $code , "Mensaje" => $message , "Docuid" => $docuid , "Numero" => $numero);
    header('Content-type: application/json; charset=utf-8');
    echo json_encode($response);

 } catch (Exception $e) {
    echo 'Excepción capturada: ',  $e->getMessage(), "\n";
 }

?>