<?php
error_reporting(0);
ini_set('display_errors', FALSE);
ini_set('display_startup_errors', FALSE);
//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{    
    $db = parse_ini_file("../../lib/datasource.ini");
    $conexion = mysqli_connect($db['ServidorBD'],$db['UsuarioBD'],$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    return $rawdata[0]; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////$
$codsucursal    = strtoupper(trim($_GET['codsucursal']));  
$observaciones  = strtoupper(trim($_GET['observaciones']));
$nrosoporte     = strtoupper(trim($_GET['nrosoporte']));  
$codfuncionario = strtoupper(trim($_GET['codfuncionario'])); 
$valorbase      = strtoupper(trim($_GET['valorbase'])); 
$valoriva       = strtoupper(trim($_GET['valoriva'])); 
$valortotal     = 0+strtoupper(trim($_GET['valortotal'])); 
$docuidgenera   = strtoupper(trim($_GET['docuidgenera'])); 
$formapago      = strtoupper(trim($_GET['formapago'])); 
$username       = strtoupper(trim($_GET['username'])); 

//// Valido que la autorizcion de Compra No Existe antes de crearla
$res = SeleccionarUno("SELECT COUNT(*) FROM autorizacionesadecuaciones WHERE codsucursal = '".$codsucursal."' AND valortotal = '".$valortotal."' AND nrosoporte = '".$nrosoporte."'");
/*
echo "SELECT COUNT(*) FROM autorizacionesadecuaciones WHERE codsucursal = '".$codsucursal."' AND valortotal = '".$valortotal."' AND nrosoporte = '".$nrosoporte."'<br>";
$existe = $res[0];
*/
$existe = 0;

//// Si NO existe - La crea
if($existe == 0)
{
    //// Inserto el registro
    $vsql = "INSERT INTO autorizacionesadecuaciones(codconcepto,codsucursal,observaciones,proveedor,autorizado,codfuncionario,valorbase,valoriva,valortotal,formapago) 
             VALUES('".$codconcepto."', '".$codsucursal."','".$observaciones."','".$proveedor."','".$autorizado."','".$codfuncionario."','".$valorbase."','".$valoriva."','".$valorbase."','".$formapago."')";
    $autorizaid = EjecutarSQL($vsql);

    //// Asocio el ArchivoDigital a esa Autorización
    //// Primer Caso : Autorizacion Montada en Sucursal
    //// Segundo Caso : Autorizacion Montada en Servidores
    if(($username == "ADMINISTRADOR")||($username == "VENDEDOR")||($username == ""))    
       $hecho = EjecutarSQL("UPDATE deautorizaadecuaciones SET autorizaid = ".$autorizaid."  WHERE autorizaid = 0 AND codsucursal = '".$codsucursal."'");
    else
       $hecho = EjecutarSQL("UPDATE deautorizaadecuaciones SET autorizaid = ".$autorizaid." ,  codsucursal = '".$codsucursal."' WHERE autorizaid = 0 AND usuariocreador = '".$username."'");
    
    /// Armo la Respuesta segun el caso
    if($autorizaid  != "")
    {
        $code = 200;
        $message = "Autorizacion registrada con Exito";    
    }
    else
    {
        $code = 400;
        $message = "Se ha producido un Error al Registrar la Autorizacion";    
    }
}
else
{
    $code = 400;
    $message = "Autorizacion ya existe";    
}

/// Retorno la respuesta correspondiente
$response = array("code" => $code , "autorizacionid" => $autorizaid , "message" => $message);
header('Content-type: application/json; charset=utf-8');
echo json_encode($response);
?>