<?php
header('Access-Control-Allow-Origin: *');
/**
 * Ejemplo simple de Uso de un Webservice
 * @author Said Rodriguez
 * @version v1.0
 * @return  Datos del Producto en Formato JSON
 **/

// Vinculo el Archivo de la API
require_once 'api.php';

// Crea una nueva Instancia de la API del Producto
$api = new api();

// message to return
$message = array();

// Capturo el Metodo -> GET -> POST -> PUT -> DELETE
$method = $_SERVER['REQUEST_METHOD'];

//// Parametros que se le pasan a los métodos del WebService
$params = array();

switch($method)
{
	///////////////////////////////////////////////////////////////////////////////////////
	///// GET -> Obtiene la Lista de Productos o los datos de un producto con id = ID
	case 'GET':
	
	    $params['token']        = $_GET["token"];
		$params['documento']    = $_GET["documento"];
		$params['email']        = $_GET["email"];
		$params['plataforma']   = $_GET["plataforma"];
		$params['nombres']      = $_GET["nombres"];
		$params['apellidos']    = $_GET["apellidos"];
		$params['celular']      = $_GET["celular"];
		$params['fecnaci']      = $_GET["fecnaci"];

		if((strlen($_GET["documento"]) != "")||(strlen($_GET["email"]) != "")||(strlen($_GET["token"]) != ""))
        {
            $data = $api->getRegistro($params);
			$message["message"] = "Usuario Encontrado";
			$message["data"] = $data;
			response(200,"sucess",$message["message"],$data);		
		}
		
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// POST -> Crear Nuevo Producto
    case 'POST':
		    $data = "ERROR : No está Admitida la creacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["data"] = $data;		  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// PUT -> Actualizar Datos del Producto
    case 'PUT':
		    $data = "ERROR : No está Admitida la Actualizacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["message"] = $data;	
		 	response(400,"error",$message["message"],$data);			  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// POST -> Crear Nuevo Producto
    case 'DELETE':
		    $data = "ERROR : No está Admitida la creacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["message"] = $data;	
		 	response(400,"error",$message["message"],$data);				  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// En caso de no ser ninguno de los Metodos permitidos muestro el error
	default://metodo NO soportado
       echo 'METODO NO SOPORTADO';
    break;
}

//////////////////////////////////////////////////////////////
//// Genera la Respuesta en Formato JSON
//////////////////////////////////////////////////////////////
function response($code=200, $status="", $message="" , $data="") 
{
    $status = strtolower($status);
	$response = array("code" => $code , "status" => $status ,"message" => $message , "data" => $data);
	header('Content-type: application/json; charset=utf-8');
    echo json_encode($response);
}   

?>

