<?php

include("../../lib/Sistema.php");

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB(){
    $clase = new Sistema();
    $conexion = mysqli_connect($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion
////////////////////////////////////////////////////////////////////////////////////////////////////o
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_row($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$obj = json_decode( file_get_contents('php://input'));   

/// Lo convierto en un Array para verificar la estructura
$objArr = (array)$obj;

$i=0;
$PEIDDOID = "";

//// Valido si ese Pedido de Cruce ya está
$vsql = "SELECT COUNT(*) FROM pedidocruce WHERE tipodoc = '".$objArr[0]->tipodoc."' AND docuidlocal = ".$objArr[0]->pedidoid." AND bodegadestino = ".$objArr[0]->bodegadestino;
$yaexiste = SeleccionarUno($vsql);

if($yaexiste == 0)
{
    while($objArr[$i]->pedidoid)
    {
        if($i == 0)
        {
            ///// Inserto el Encabezado del Documento
            $vsql = "INSERT INTO pedidocruce(tipodoc,prefijo,docuidlocal,fechadoc,fecasentado,bodegaorigen,bodegadestino,codvende,observacion,creador,momento) 
                    VALUES('".$objArr[$i]->tipodoc."','".$objArr[$i]->prefijo."','".$objArr[$i]->pedidoid."','".$objArr[$i]->fechadoc."',CURRENT_DATE,'".$objArr[$i]->bodegaorigen ."','".$objArr[$i]->bodegadestino ."','".$objArr[$i]->codvende."','".$objArr[$i]->observacion."','SYSTEM',CURRENT_TIMESTAMP)";      
            $PEDIDOID = EjecutarSQL($vsql);
        }
        
        if($PEDIDOID != "")
        {
            $valunitario    = 0+$objArr[$i]->valunitario;
            $valtotal       = 0+$objArr[$i]->valtotal;
            $valpresupuesto = 0+$objArr[$i]->valpresupuesto;

            $vsql = "INSERT INTO detallecruce(pedidoid,productoid,cantidad,unicom,unifra,valunitario,valtotal,valpresupuesto) 
                    VALUES(".$PEDIDOID.",'".$objArr[$i]->productoid."','".$objArr[$i]->cantidad ."','".$objArr[$i]->unicom ."','".$objArr[$i]->unifra."','".$valunitario."','".$valtotal."','".$valpresupuesto."')";      
            EjecutarSQL($vsql);
        }
    
        $i++;
    }

    //// Finalizo generando la respuesta
    if($i>0)
    {
        $code = 200;
        $message = "Documento Creado con Exito";
        $myArray = array("code" => $code , "message" => $message , "pedidoid" => $PEDIDOID);
    }
    else
    {
        $code = 400;
        $message = "Error al Crear el Documento";
        $myArray = array("code" => $code , "message" => $message);
    }
}
else
{
    $code = 400;
    $message = "Pedido de Cruce ya se encuentra en el Sistema";
    $myArray = array("code" => $code , "message" => $message);
}

/// Salida al Navegador
header('Content-type: application/json; charset=utf-8');
echo json_encode($myArray, JSON_PRETTY_PRINT);
?>