<?php
include("../../lib/Sistema.php");

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB(){
    $clase = new Sistema();
    $conexion = mysqli_connect($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion
////////////////////////////////////////////////////////////////////////////////////////////////////o
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_row($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$codsucursal  = $_GET['codsucursal'];
$tipodoc = "TRB";
$prefijo = "COD";
$Ndocuid = "";

if($codsucursal != "")
{
    $vsqlbuscar = "SELECT D.docuid FROM documentos D INNER JOIN docutranfe DT ON (D.docuid = DT.docuid) INNER JOIN bodegas B ON (B.bodegaid = DT.bodegaidori) 
                   WHERE D.tipodoc = '".$tipodoc."' AND D.prefijo = '".$prefijo."' AND D.fecasentado = '0000-00-00' AND B.codbodega = '".$codsucursal."' AND D.fechadoc > '2021-09-08'";
    $docabierto = SeleccionarUno($vsqlbuscar);
    
    ////////////////////////////////////////////////////////////
    //// Si no hay Documentos pendientes -> Inserta 
    if($docabierto == "")
    {
        //// Inserto el encabezado del Documento
        $sucursalid = SeleccionarUno("SELECT sucursalid FROM sucursales WHERE codigo = '".$codsucursal."'");
        $bodegaid   = SeleccionarUno("SELECT bodegaid FROM bodegas WHERE codbodega = '".$codsucursal."'");
        $diaoperativo = SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab = 'G_DIAOPERATIVO'");
        $periodo = date("mY");

        //// Aparto el Consecutivo
        $numero = SeleccionarUno("SELECT numero FROM consecutivos WHERE tipodoc = '".$tipodoc."' AND prefijo = '".$prefijo."'");
        $numero2 = str_pad($numero + 1,5,0,STR_PAD_LEFT);
        EjecutarSQL("UPDATE consecutivos SET numero = '".$numero2."' WHERE tipodoc = '".$tipodoc."' AND prefijo = '".$prefijo."'");

        //// Teniendo el Consecutivo se Inserta el CRU
        if($numero!="")
        {
            /// Deshaiblito el Modo Estricto
            EjecutarSQL("SET sql_mode =''");

            $vsql = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,fecanulado,fecvence,terid1,total,impreso,totalitems,sucursalid,creador,momento,formapago,observacion,nrodocref) 
                     VALUES('".$tipodoc."','".$prefijo."','".$numero."','".$periodo."',CURRENT_TIMESTAMP,'0000-00-00','0000-00-00','0000-00-00',1,0,'N',0,".$sucursalid.",'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP,'CO','','WS-TRB-CRU')";
            EjecutarSQL($vsql);
            
            /// Busco el Maximo Docuid - El recien insertado
            $Ndocuid = SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = '".$tipodoc."' AND prefijo = '".$prefijo."' AND numero = '".$numero."'");
            
            /// Inserto el Docutranfe
            $vsql = "INSERT IGNORE INTO docutranfe(docuid,diaoperativo,bodegaidori,bodegaiddes,kardexori,kardexdes) VALUES(".$docuid.",'".$diaoperativo."',".$bodegaid.",".$bodegaid.",'N','N')";
            EjecutarSQL($vsql);

            /// Preparo la Respuesta 
            $code = 200;
            $message = "TRB COD Creado con Exito";
            $myArray = array("code" => $code , "message" => $message , "docuid" => $Ndocuid);
        }    
        else
        {
            $code = 400;
            $message = "Error al Cargar un Consecutivo Valido para TRB ".$prefijo;
            $myArray = array("code" => $code , "message" => $message , "docuid" => $Ndocuid);
        }          
    }
    else
    {
        $code = 400;
        $message = "NO se puede Insertar el TRB COD porque tiene uno en proceso";
        $myArray = array("code" => $code , "message" => $message , "docuid" => $Ndocuid);
    }
    
}
else
{
    $code = 400;
    $message = "Debe indicar el Codigo de la Sucursal";
    $myArray = array("code" => $code , "message" => $message , "docuid" => $Ndocuid);
}

/// Salida al Navegador
header('Content-type: application/json; charset=utf-8');
echo json_encode($myArray, JSON_PRETTY_PRINT);
?>