<?php
 session_start(); 
 include("../lib/Sistema.php");
 
/* 
 * Clase de acceso a datos del Webservice
 * @author Ing. Said Rodriguez
 * @version: 31/08/2016
 */

class WebServiceDB 
{
    protected $mysqli;
    
    /**
     * Constructor de clase
     */
    public function __construct() 
    {           
        $clase = new Sistema();         
        try{
            //conexión a base de datos
            $this->mysqli = new mysqli($clase->ServidorBD , $clase->UsuarioBD , $clase->ClaveBD , $clase->NombreBD);
        }catch (mysqli_sql_exception $e){
            //Si no se puede realizar la conexión          
            http_response_code(400);
            exit;
        }  
    } 
    
    /**
     * obtiene un solo registro dado su ID
     * @param int $id identificador unico de registro
     * @return Array array con los registros obtenidos de la base de datos
     */
    public function getUsuario($id=0){      
        $stmt = $this->mysqli->prepare("SELECT * FROM usuarios WHERE usuid=? ; ");
        $stmt->bind_param('s', $id);
        $stmt->execute();
        $result = $stmt->get_result();        
        $peoples = $result->fetch_all(MYSQLI_ASSOC); 
        $stmt->close();
        return $peoples;              
    }
    
    /**
     * obtiene todos los registros de la tabla "people"
     * @return Array array con los registros obtenidos de la base de datos
     */
    public function getUsuarios(){        
        $result = $this->mysqli->query('SELECT * FROM usuarios');          
        $peoples = $result->fetch_all(MYSQLI_ASSOC);          
        $result->close();
        return $peoples; 
    }
    
    /**
     * añade un nuevo registro en la tabla persona
     * @param String $name nombre completo de persona
     * @return bool TRUE|FALSE 
     */
    public function insert($name='',$pass=''){
        $stmt = $this->mysqli->prepare("INSERT INTO usuarios(username,clave,rol) VALUES (?,?,'ADM'); ");
        $stmt->bind_param('ss', $name , $pass);
        $r = $stmt->execute(); 
        $stmt->close();
        return $r;        
    }
    
    /**
     * elimina un registro dado el ID
     * @param int $id Identificador unico de registro
     * @return Bool TRUE|FALSE
     */
    public function delete($id=0) {
        $stmt = $this->mysqli->prepare("DELETE FROM usuarios WHERE usuid = ? ; ");
        $stmt->bind_param('s', $id);
        $r = $stmt->execute(); 
        $stmt->close();
        return $r;
    }
    
    /**
     * Actualiza registro dado su ID
     * @param int $id Description
     */
    public function update($id, $newName , $newPass) {
        if($this->checkID($id)){
            $stmt = $this->mysqli->prepare("UPDATE usuarios SET username=? , clave = ? WHERE usuid = ? ; ");
            $stmt->bind_param('sss', $newName,$newPass,$id);
            $r = $stmt->execute(); 
            $stmt->close();
            return $r;    
        }
        return false;
    }
    
    /**
     * verifica si un ID existe
     * @param int $id Identificador unico de registro
     * @return Bool TRUE|FALSE
     */
    public function checkID($id){
        $stmt = $this->mysqli->prepare("SELECT * FROM usuarios WHERE usuid=?");
        $stmt->bind_param("s", $id);
        if($stmt->execute()){
            $stmt->store_result();    
            if ($stmt->num_rows == 1){                
                return true;
            }
        }        
        return false;
    }
    
}
?>