<?php

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{
    $db = parse_ini_file("../../lib/datasource.ini");
    $conexion = mysqli_connect($db['ServidorBD'],$db['UsuarioBD'],$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_array($result))
       $retorno = $row[0];
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$id  = $_GET['id'];
$suc = $_GET['sucursal'];
$dia = $_GET['diaoperativo'];


$vsql = "UPDATE transabancos SET sucaplica = '".$suc."' , momaplica = CURRENT_TIMESTAMP , usuaplica = 'SYSTEM' , diaopeaplica = '".$dia."' WHERE id = ".$id;
$data = getArraySQL($vsql);

/// La Busco - Si No Existe la Creo
$existe = SeleccionarUno("SELECT COUNT(*) FROM consignacionespapeleria WHERE transabancoid = ".$id);
if($existe == 0)
{
    //// La Inserto en Papeleria
    $numtra = SeleccionarUno("SELECT numerotran FROM transabancos WHERE id = ".$id);
    $feccon = SeleccionarUno("SELECT fecconsigna FROM transabancos WHERE id = ".$id);
    $valtra = SeleccionarUno("SELECT valortran FROM transabancos WHERE id = ".$id);
    $bantra = SeleccionarUno("SELECT bancotran FROM transabancos WHERE id = ".$id);
    
    $vsql2 = "INSERT INTO consignacionespapeleria(tipo,diaoperativo,fechaconsigna,numconsigna,detalles,valor,creador,momento,codsucursal,cuentaid,transabancoid,transabancoid2)
              VALUES('TRA','".$dia."','".$feccon."','".$numtra."','','".$valtra."','SYSTEM',CURRENT_TIMESTAMP,'".$suc."','".$bantra."',".$id.",".$id.")";
    EjecutarSQL($vsql2);
}


/*******************************************************************/
/// Recalculo los datos del Dia
/*******************************************************************/
//// Proceso para Reflejar en el Dia Consignaciones y Transferencias
$existecierre = SeleccionarUno("SELECT COUNT(*) FROM cierresucursales WHERE codsucursal = '".$suc."' AND diaoperativo = '".$dia."'");
if($existecierre == 0)
{
	$campocontrol = $suc."|".$dia;
    $vsqlc = "INSERT INTO cierresucursales(codsucursal,diaoperativo,creador,momento,campocontrol) VALUES('".$suc."','".$dia."','SYSTEM',CURRENT_TIMESTAMP,'".$campocontrol."')";
    EjecutarSQL($vsqlc);
}

$vsql = "SELECT SUM(valor) FROM consignacionespapeleria WHERE tipo = 'CON' AND codsucursal = '".$suc."' AND diaoperativo = '".$dia."'";
$NuevoTotal = 0+SeleccionarUno($vsql);
$vsql = "SELECT SUM(valor) FROM consignacionespapeleria WHERE tipo = 'TRA' AND codsucursal = '".$suc."' AND diaoperativo = '".$dia."'";
$Transferencias = 0+SeleccionarUno($vsql);

/// Actualizo los totales de Consignaciones y Transferencias
$vsql2 = "UPDATE cierresucursales SET totefectivo = '".$NuevoTotal."' , consignado = '".$NuevoTotal."' , valtransferencias = '".$Transferencias."' WHERE codsucursal = '".$suc."' AND diaoperativo = '".$dia."'";
EjecutarSQL($vsql2);                 
/*******************************************************************/

/// Retorno la respuesta
if($data)
{
    $code = 200;
    $message = "Datos de la Sucursal";    
}
else
{
    $code = 400;
    $message = "No existen datos de esta sucursal";
}

header('Content-type: application/json; charset=utf-8');
echo json_encode($data);
?>