<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Existencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-28
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene la existencia en Sucursales del Producto consultado
	 * @param ID del Producto	 
	 * @return Lista de Existencia por Bodegas en Formato JSON
	 */
	function getSaldoCreditos($params)
	{
		/// Variable de Retorno del Servicio
		$retorno = 0;

		$clase = new Sistema();
        $periodo = date("mY");
		
		//// Evaluamos si tiene Facturas Vencidas
		/*
		$tieneVencidas = $clase->SeleccionarUno("SELECT COUNT(*) FROM documentos D INNER JOIN terceros T ON (D.terid1 = T.terid) WHERE D.tipodoc = 'CXC' AND D.saldo > 0 AND T.dni = '".$params['id']."' AND DATEDIFF(CURRENT_DATE,D.fecvence)>0");
        if($tieneVencidas > 0)
		    $retorno = 0;
		else
		{
			*/
			//// Evaluamos si está inactivo 
			$estainactivo = $clase->SeleccionarUno("SELECT inactivo FROM terceros WHERE dni = '".$params['id']."'");
            if($estainactivo == 'CHECKED')
		       $retorno = 0;
			else
			{
				/// Evaluamos las condiciones de Credito (Cupo y habilitacion)
				$condicredito = $clase->SeleccionarUno("SELECT COUNT(*) FROM terceros WHERE dni = '".$params['id']."' AND cupocredito > 0 AND (escliente = 'CHECKED' OR ventascredito = 'CHECKED')");
				if($condicredito == 0)
				   $retorno = 0;
				else
				{
						//// Evaluamos si Tiene Cupo
						$terid   = $clase->BDLockup($params['id'],"terceros","dni","terid");
						$compra  = $params['valor'];
						
						$query = "SELECT terid , cupocredito ,  
								(SELECT SUM(saldo) FROM documentos WHERE tipodoc = 'CXC' AND terid1 = T.terid) comprado
								FROM terceros T WHERE dni = '".$params['id']."'";
						$list = array();
						$result = $this->db->query($query);
						if($row = $result->fetch_assoc())
						{
							$cupo    = $row['cupocredito'];
							$acumula = $row['comprado'];
						}
				
						//// Valido si se puede aceptar la transaccion o NO
						if(($cupo-$acumula)>=$compra) 
						{
							$retorno = 1; 
						}
						else	
						    $retorno = 0;
				}		
			}
		//}  

		return($retorno);
	}

} /// Fin de la Clase API
