<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Existencias
 * Desde WebService
 * @author Milagros Rodriguez
 * @version 2017-01-28
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene si el tercero tiene puntos disponibles para redimir
	 * @param Documento del cliente y valor de la compra a canjear
	 * @return Si puede canjear o no
	 */
	function getRedimirPuntos($params)
	{
		/// Variable de Retorno del Servicio
		$retorno = 0;
		$clase = new Sistema();
        $periodo = date("mY");
		
        //// Evaluamos si es cliente 
		$escliente = $clase->SeleccionarUno("SELECT escliente FROM terceros WHERE dni = '".$params['id']."'");

		//// Evaluamos si es empleado
		$esempleado = $clase->SeleccionarUno("SELECT esempleado FROM terceros WHERE dni = '".$params['id']."'");
		if(($escliente == 'CHECKED')&&($esempleado != 'CHECKED')){
			//// Evaluamos si Tiene Puntos
			$terid   = $clase->BDLockup($params['id'],"terceros","dni","terid");
			$compra  = $params['valor'];
			
			$query = "SELECT documento, totalpuntos   
					FROM afiliado  WHERE documento = '".$params['id']."'";
			$list = array();
			$result = $this->db->query($query);
			if($row = $result->fetch_assoc())
			{
				$cupo    = $row['totalpuntos'];
			}
	
			//// Valido si se puede aceptar la transaccion o NO
			if(($cupo)>=($compra*100)) {
				$disponible = ($cupo - ($compra*100));
				// Actualizo los puntos disponibles en la tabla de afiliado
				$clase->EjecutarSQL("UPDATE afiliado SET totalpuntos = $disponible WHERE documento = '".$params['id']."' ");
				$retorno = 1;
			}
			else{
				$retorno = 0;
			}
				
		}
		else
        { 
			$retorno = 0;
        }		
        
		

		return($retorno);
	}

} /// Fin de la Clase API
