<?php

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{    
    $db = parse_ini_file("../../lib/datasource.ini");
    $conexion = mysqli_connect($db['ServidorBD'],$db['UsuarioBD'],$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_array($result))
    {
        $datoretorno = $row[0];
        $i++;
    }
    return $datoretorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////$
//cierreid='.urlencode($cierreid).'&totalarqueo='.urlencode($totarq).'&devoluciones='.urlencode($devolu).'&faltante='.urlencode($faltante).'&sobrante='.urlencode($sobrante).'&valdatafono='.urlencode($valdat));   
$codsucursal  = strtoupper(trim($_GET['codsucursal']));  
$diaoperativo = strtoupper(trim($_GET['diaoperativo'])); 
$totalarqueo  = strtoupper(trim($_GET['totalarqueo']));  
$devoluciones = strtoupper(trim($_GET['devoluciones']));  
$faltante     = strtoupper(trim($_GET['faltante']));  
$sobrante     = strtoupper(trim($_GET['sobrante']));
$valdatafono  = strtoupper(trim($_GET['valdatafono']));  
$credit       = 0+$_GET['totcreditos']; 
$venexc       = 0+$_GET['ventaexcluida'];       
$base19       = 0+$_GET['valbase19'];       
$iva19        = 0+$_GET['valiva19'];       
$base05       = 0+$_GET['valbase05'];
$iva05        = 0+$_GET['valiva05'];   

$valgas       = 0+$_GET['valgastos'];     
$valcom       = 0+$_GET['valcompras'];   
$valter       = 0+$_GET['valterceros'];   
$valpuntos    = 0+$_GET['valpuntos'];  

$cierreidlocal = 0+$_GET['cierreidlocal'];  
$vengencon     = 0+$_GET['vegecon'];  
$venespcon     = 0+$_GET['veescon'];  

$valrappi      = 0+$_GET['valrappi'];  
$valpasarela   = 0+$_GET['valpasarela'];  
$valbilleteras = 0+$_GET['valbilleteras'];  

///// Obtengo el CierreID
$cierreid = SeleccionarUno("SELECT cierreid FROM cierresucursales WHERE codsucursal = '".$codsucursal."' AND diaoperativo = '".$diaoperativo."'");

//// Si no existe registro del Cierre -> Lo Inserto el registro
$campocontrol = $codsucursal."|".$diaoperativo;

if($cierreid == "")
{
    $vsql = "INSERT INTO cierresucursales(codsucursal,diaoperativo,totalarqueo,devoluciones,faltante,sobrante,valdatafono,totcreditos,ventaexcluida,valbase19,valiva19,valbase05,
             valiva05,valgastos,valcompras,valterceros,totpuntos,cierreidlocal,vengencon,venespcon,creador,momento,campocontrol,ingresosrappi,ingresospasarela,ingresosbilleteras) 
             VALUE ('".$codsucursal."','".$diaoperativo."','".$totalarqueo."','".$devoluciones."','".$faltante."','".$sobrante."','".$valdatafono."','".$credit."','".$venexc.
             "','".$base19."','".$iva19."','".$base05."','".$iva05."','".$valgas."','".$valcom."','".$valter."','".$valpuntos."','".$cierreidlocal."','".$vengencon."','".$venespcon."',
             'ADMINISTRADOR',CURRENT_TIMESTAMP,'".$campocontrol."','".$valrappi."','".$valpasarela."','".$valbilleteras."')";     
    $autorizaid = EjecutarSQL($vsql);    
}
else
{
    $vsql = "UPDATE cierresucursales SET codsucursal = '".$codsucursal."' , diaoperativo = '".$diaoperativo."' , totalarqueo = '".$totalarqueo."' , devoluciones = '".$devoluciones."' , 
             faltante = '".$faltante."' , sobrante = '".$sobrante."' , valdatafono = '".$valdatafono."' , totcreditos = '".$credit."' , ventaexcluida = '".$venexc."' , valbase19 = '".$base19."' , campocontrol = '".$campocontrol."' , 
             valiva19 = '".$iva19."' , valbase05 = '".$base05."' , valiva05 = '".$iva05."' , totpuntos = '".$valpuntos."' , cierreidlocal = '".$cierreidlocal."' , vengencon = '".$vengencon."' , 
             venespcon = '".$venespcon."' , ingresosrappi = '".$valrappi."' , ingresospasarela = '".$valpasarela."' , ingresosbilleteras = '".$valbilleteras."' 
             WHERE cierreid = ".$cierreid;   

    $autorizaid = EjecutarSQL($vsql);
    $autorizaid = $cierreid;
}

//// SD Nuevos dias - Ahora los campos estarán en Ceros
$vsql = "UPDATE cierresucursales SET valdatafono = 0 , valgastos = 0 , valcompras = 0 , totcreditos = 0 WHERE codsucursal = '".$codsucursal."' AND diaoperativo = '".$diaoperativo."'"; 
EjecutarSQL($vsql);

/// Armo la Respuesta segun el casos
if($autorizaid  != "")
{
    $code = 200;
    $message = "Cierre Registrado con Exito";    
}
else
{
    $code = 400;
    $message = "Se ha producido un Error al Registrar el Cierre";    
}

/// Retorno la respuesta correspondiente
$response = array("code" => $code , "cierreid" => $autorizaid , "message" => $cierreid);
header('Content-type: application/json; charset=utf-8');
echo json_encode($response);
?>