<?php
    include("../../lib/Sistema.php");

    //////////////////////////////////////////////////////////////////////////////////////////////////////
    function connectDB(){
        $clase = new Sistema();
        $conexion = mysqli_connect($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
        if(!$conexion){
            echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
        }   
        return $conexion;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    function disconnectDB($conexion){
        $close = mysqli_close($conexion);
        if(!$close){
            echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
        }   
        return $close;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    //// Funciones para Gestionar la Conexion
    ////////////////////////////////////////////////////////////////////////////////////////////////////o
    function getArraySQL($sql){
        //Creamos la conexión con la función anterior
        $conexion = connectDB();
        //generamos la consulta
        mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
        if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
        $rawdata = array(); //creamos un array
        //guardamos en un array multidimensional todos los datos de la consulta
        $i=0;
        while($row = mysqli_fetch_array($result))
        {
            $rawdata[$i] = $row;
            $i++;
        }
        disconnectDB($conexion); //desconectamos la base de datos
        return $rawdata; //devolvemos el array
    }


    ////////////////////////////////////////////////////////////////////////////////////////////////////
    //// Funciones para Gestionar la Conexion - SELECCIONAR UNO
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    function SeleccionarUno($sql)
    {
        //Creamos la conexión con la función anterior
        $conexion = connectDB();
        //generamos la consulta
        mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
        if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
        $rawdata = array(); //creamos un array
        //guardamos en un array multidimensional todos los datos de la consulta
        $i=0;
        if($row = mysqli_fetch_array($result))
        {
            $rawdata[$i] = $row;
            $i++;
        }
        return $rawdata[0]; //devolvemos el array
        disconnectDB($conexion); //desconectamos la base de datos    
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    //// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
    ///////////////////////////////////////////////////////////////////////////////////////////////////
    function EjecutarSQL($sql)
    {
        //Creamos la conexión con la función anterior
        $conexion = connectDB();
        //generamos la consulta
        mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
        $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
        if(strtoupper(substr($sql,0,6)) == "INSERT")
            $retorno = mysqli_insert_id($conexion);
        disconnectDB($conexion); //desconectamos la base de datos
        return($retorno);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    ////  Muestro la DATA en Pantalla
    //////////////////////////////////////////////////////////////////////////////////////////////////
    $movil   = $_GET['movil'];
    $mensaje = $_GET['mensaje'];
    $token   = $_GET['token'];

    $medio   = "WHA";
    $errores = 0;

    //// Token Activos solo z6xfmjheyrxvbo51 y z6xfmjheyr20xvbo
    $usuario = "";
    if($token == "z6xfmjheyrxvbo51")  $usuario = "DROPOSERP";
    if($token == "z6xfmjheyr20xvbo")  $usuario = "DROPOS20";

    //// Validacion del Usuario que envia
    if($usuario == "")
    {
        $errores++;
        $code = 400;
        $message = "Token NO AUTORIZADO o NO Puede ser vacio";
        $myArray = array("code" => $code , "message" => $message);
        header('Content-type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode($myArray, JSON_PRETTY_PRINT);
        exit;                
    }
    else
    {
        if($usuario == "DROPOS20")
        {
            $tiempoespera  = rand(10,20);
            sleep($tiempoespera);
        }
    }
        
    //// Validacion del Numero del Movil
    if(substr($movil,0,1) != "3")
    {
        $errores++;
        $code = 400;
        $message = "Numero de Movil No Valido. Debe iniciar por el Numero 3";
        $myArray = array("code" => $code , "message" => $message);
        header('Content-type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode($myArray, JSON_PRETTY_PRINT);
        exit;                
    }

    //// Validacion del Numero del Movil
    if((strlen($movil)<10)||(strlen($movil)>10))
    {
        $errores++;
        $code = 400;
        $message = "Longitud del Numero de Movil debe ser de 10 Caracteres";
        $myArray = array("code" => $code , "message" => $message);
        header('Content-type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode($myArray, JSON_PRETTY_PRINT);
        exit;                
    }

    //// Validacion del Mensaje
    if(strlen($mensaje)<3)
    {
        $errores++;
        $code = 400;
        $message = "Mensaje debe tener minimo 3 y maximo 200 caracteres";
        $myArray = array("code" => $code , "message" => $message);
        header('Content-type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode($myArray, JSON_PRETTY_PRINT);
        exit;   
    }

    //// Si no hay errores Envio el Mensaje
    if($errores == 0)
    {
        //// Envio el Mensaje
        $celular = trim($movil);
        $celular = str_replace(" ","",$celular);     
        $celularenvio = "57".$celular;
        $tiempoespera  = rand(5,12);

        //// Espero el Tiempo Prodencial para que no nos bloqueen
        sleep($tiempoespera);

        $codigoproceso = rand(100000, 999999);
        $mensaje = "C" . $codigoproceso . " " . $mensaje;   

        //// Envio el Mensaje por Isyscol
        $params=array(
            'token' => 'z6xfmjheyr02xvbo',
            'to' => '+'.$celularenvio,
            'body' => $mensaje
            );

            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => "https://api.ultramsg.com/instance29975/messages/chat",
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => "",
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 30,
              CURLOPT_SSL_VERIFYHOST => 0,
              CURLOPT_SSL_VERIFYPEER => 0,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => "POST",
              CURLOPT_POSTFIELDS => http_build_query($params),
              CURLOPT_HTTPHEADER => array(
                "content-type: application/x-www-form-urlencoded"
              ),
            ));
            
            $response = curl_exec($curl);
            $err = curl_error($curl);
            
            curl_close($curl);
            
            if ($err) {
              echo "cURL Error #:" . $err;
            }
        
        //// Registro el Envio del Mensaje    
        $vsql = "INSERT INTO mensajesenviados(tipomensaje,origen,telefonodestino,contenidomensaje,usuario) 
                 VALUES('WHA','API','".$celularenvio."','".$mensaje."','".$usuario."')";
        EjecutarSQL($vsql);

        //// Genero la Respuesta del JSON
        $code = 200;
        $message = "Mensaje de WhatsApp enviado con Exito a ".$celular;
        $myArray = array("code" => $code , "message" => $message , "response" => $response );
        header('Content-type: application/json; charset=utf-8');
        http_response_code(200);
        echo json_encode($myArray, JSON_PRETTY_PRINT);
        exit;   
    }
    
?>