<?php
header('Access-Control-Allow-Origin: *');
/**
 * Ejemplo simple de Uso de un Webservice
 * @author Said Rodriguez
 * @version v1.0
 * @return  Datos del Producto en Formato JSON
 **/

// Vinculo el Archivo de la API
require_once 'api.php';

// Crea una nueva Instancia de la API del Producto
$api = new api();

// message to return
$message = array();

// Capturo el Metodo -> GET -> POST -> PUT -> DELETE
$method = $_SERVER['REQUEST_METHOD'];

//// Parametros que se le pasan a los métodos del WebService
$params = array();

switch($method)
{
	///////////////////////////////////////////////////////////////////////////////////////
	///// GET -> Obtiene la Lista de Productos o los datos de un producto con id = ID
	case 'GET':
	
		$params['documento']  = $_GET["documento"];
		$params['email']      = $_GET["email"];
		if((strlen($_GET["documento"]) != "")||(strlen($_GET["email"]) != ""))
        {
          if (is_array($data = $api->getPuntos($params))) 
		  {
			if($data == "")
			{
				$message["code"] = "99";
			    $message["message"] = "No se encontro informacion con ese criterio";
			    response(400,"error",$message["message"],$data);		
			}
			else
			{
				$message["message"] = "Puntos Encontrados";
			 	$message["data"] = $data;
			 	response(200,"sucess",$message["message"],$data);		
			}

		  } else {
			$message["code"] = "99";
			$message["message"] = "No se encontro informacion con ese criterio";
			response(400,"error",$message["message"],$data);		
		  }	
        }
		else
		{
            $message["code"] = "400";
		 	$message["data"] = "ERROR : Es obligatorio Enviar un Parametro para consultar Existencia";
		 	response(400,"error",$message["message"],$data);		
		}

	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// POST -> Crear Nuevo Producto
    case 'POST':
		    $data = "ERROR : No está Admitida la creacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["data"] = $data;		  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// PUT -> Actualizar Datos del Producto
    case 'PUT':
		    $data = "ERROR : No está Admitida la Actualizacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["message"] = $data;	
		 	response(400,"error",$message["message"],$data);			  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// POST -> Crear Nuevo Producto
    case 'DELETE':
		    $data = "ERROR : No está Admitida la creacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["message"] = $data;	
		 	response(400,"error",$message["message"],$data);				  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// En caso de no ser ninguno de los Metodos permitidos muestro el error
	default://metodo NO soportado
       echo 'METODO NO SOPORTADO';
    break;
}

//////////////////////////////////////////////////////////////
//// Genera la Respuesta en Formato JSON
//////////////////////////////////////////////////////////////
function response($code=200, $status="", $message="" , $data="") 
{
    $status = strtolower($status);
    $response = array("code" => $code , "status" => $status ,"message" => $message , "data" => $data);
    echo json_encode($response);
}   

?>
