<?php
include("../../../lib/Sistema.php");

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB(){
    $clase = new Sistema();
    $conexion = mysqli_connect($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion
////////////////////////////////////////////////////////////////////////////////////////////////////o
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_row($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}


//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$inicio    = @$_GET['inicio'];
$registros = @$_GET['registros'];
$region    = @trim($_GET['region']);

if($inicio == "")      $inicio = 0;
if($registros == "")   $registros = 500;

///// Registro el Uso de la API
$urlapi = $_SERVER['PHP_SELF'];

////// Proceso de la API
$vsql = "INSERT INTO estadisticasconsumosapi(urlapi,momento) VALUES('".$urlapi."',CURRENT_TIMESTAMP)";
EjecutarSQL($vsql);

/// Busco la Fecha hace 5 dias
$fechahace4dias = SeleccionarUno("SELECT DATE_SUB(CURDATE(), INTERVAL 3 DAY)");

/// Borro lo de hace 5 dias
$vsql = "DELETE FROM transitosucursales WHERE fecinicio < '".$fechahace4dias."'";
EjecutarSQL($vsql);

//// Selecciono el Transito
if($region == "")
   $sql = "SELECT productoid , codsucursal , SUM(cantidad) canti FROM transitosucursales WHERE cantidad>0 GROUP BY 1,2 ORDER BY 2 ASC , 3 DESC LIMIT ".$inicio.",".$registros;
else
   $sql = "SELECT TS.productoid , TS.codsucursal , SUM(TS.cantidad) canti 
           FROM transitosucursales TS INNER JOIN sucursales S ON (TS.codsucursal = S.codigo) 
           INNER JOIN zonas Z ON (Z.codzona = S.zona) 
           WHERE TS.cantidad>0 AND Z.codregion = '".$region."' 
           GROUP BY 1,2 ORDER BY 2 ASC , 3 DESC LIMIT ".$inicio.",".$registros;   
$myArray = getArraySQL($sql);

/// Salida al Navegador
header('Content-type: application/json; charset=utf-8');
echo json_encode($myArray, JSON_PRETTY_PRINT);

?>