<?php

include("../../lib/Sistema.php");

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB(){
    $clase = new Sistema();
    $conexion = mysqli_connect($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion
////////////////////////////////////////////////////////////////////////////////////////////////////o
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_row($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funcion que genera el JSON de la Transferencia
///////////////////////////////////////////////////////////////////////////////////////////////////
function GenerarJSONTransferencia($docuid)
{
    $message = Array();				$jsontotal = "";
    $encab = "";             		$detalle = Array();

    //Creamos la Conexion a la BD
    $conexion = connectDB();
    
    //Se inicializa la Conexion
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8


    //// Consulta SQL para el Encabezado del Documento
    $vsql2 = "SELECT D.docuid , D.tipodoc,D.prefijo,D.numero, D.periodo, D.fechadoc, D.fecvence, D.fecasentado, D.fecanulado, D.formapago, D.nrodocref , D.importado, D.terid1,D.terid2, D.terid3, 
                D.codigo1, D.codigo2, D.codigo3, '' as observacion , D.observacion2 , D.retefuente, D.reteiva, D.reteica, D.descuentogen,  D.ajustebase, D.ajusteiva, D.ajusteneto, D.base, D.iva, 
                D.impoconsumo, D.total, D.saldo, D.anticipo, D.impreso, D.totalitems, D.sucursalid, D.creador, D. momento,  D.contabilizado,  D.numcomprobante,  
                D.estadosincro,  D.sincronizado,  D.autoimpreso,  D.regenerado,  D.auditado , DT.*
                FROM documentos D INNER JOIN docutranfe DT ON (D.docuid = DT.docuid) WHERE D.docuid = ".$docuid;
    if(!$result = mysqli_query($conexion, $vsql2)) die(); //si la conexión cancelar programa
    while($row = mysqli_fetch_array($result))
    {
        $encab = $row;
    }

    //// Ahora el Detalle
    $vsql2 = "SELECT docuid,  productoid,  bodegaid, tipund,  costoprod,  valunitario, porciva,  valbase, diasrecor,  obsrecor,  numlinea, docuref,  observalinea,  
              SUM(valiva) valiva , SUM(valico) valico , SUM(valtotal) valtotal ,  SUM(unicom) unicom ,  SUM(unifra) unifra , SUM(cantidad) cantidad ,  
              SUM(unidades) unidades , SUM(valparcial) valparcial   
              FROM dedocumentos  
              WHERE docuid = ".$docuid." 
              GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13";
    if(!$result = mysqli_query($conexion, $vsql2)) die(); //si la conexión cancelar programa
    while($row2 = mysqli_fetch_array($result))
    {
        $detalle[] = $row2;
    }

    /// Ahora saco los detalles
    $message["code"] = "20";
    $message["encabezado"] = $encab;
    $message["detalle"] = $detalle;
    $jsontotal = json_encode($message);
    
    /// Lo guardo en el Documento
    $confirmacion = EjecutarSQL("UPDATE documentos SET documentojson = '".$jsontotal."' WHERE docuid = ".$docuid);
  
    $prefijo = SeleccionarUno("SELECT prefijo FROM documentos WHERE docuid = ".$docuid);
    $numero  = SeleccionarUno("SELECT numero FROM documentos WHERE docuid = ".$docuid);
    $bodegaidori = SeleccionarUno("SELECT bodegaidori FROM docutranfe WHERE docuid = ".$docuid);
    $bodegaiddes = SeleccionarUno("SELECT bodegaiddes FROM docutranfe WHERE docuid = ".$docuid);
    $codbodegaori = SeleccionarUno("SELECT codbodega FROM bodegas WHERE bodegaid = ".$bodegaidori);
    $codbodegades = SeleccionarUno("SELECT codbodega FROM bodegas WHERE bodegaid = ".$bodegaiddes);
    
    //// Lo guardo en la nueva Tabla
    EjecutarSQL("DELETE FROM documentosxdescargar WHERE docuid = ".$docuid);
    $vsqlnew = "INSERT INTO documentosxdescargar(docuid,numerodoc,bodegaidori,codbodegaori,bodegaiddes,codbodegades,documentojson) 
                VALUES(".$docuid.",'TRB".$prefijo.$numero."',".$bodegaidori.",'".$codbodegaori."',".$bodegaiddes.",'".$codbodegades."','".$jsontotal."')";
    EjecutarSQL($vsqlnew); 

    /// Retorno
    return(1);

} /// Fin de la Funcion GenerarJSON


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funcion que genera la Autorizacion de la Transferencia CODB y CODC
///////////////////////////////////////////////////////////////////////////////////////////////////
function GenerarAutorizacionCompra($docuid)
{

      $vsql2 = "SELECT S.codigo CodSucursal , T.dni CodPro , D.* FROM documentos D 
                INNER JOIN terceros T ON (T.terid = D.terid1) INNER JOIN sucursales S ON (S.sucursalid = D.sucursalid) WHERE D.docuid = ".$docuid;

      //Creamos la Conexion a la BD
      $conexion = connectDB();
      //Se inicializa la Conexion
      mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
      
      if(!$result = mysqli_query($conexion, $vsql2)) die(); //si la conexión cancelar programa
      $list = array();
      
      while($row = mysqli_fetch_array($result))
      {
         $tip   = "COMPRA";  
         $csu   = strtoupper(trim($row['CodSucursal']));  
         $obs   = strtoupper(trim($row['observacion']));
         $pro   = strtoupper(trim($row['CodPro']));  
         $dia   = date("d/m/Y");  
         $nro   = strtoupper(trim($row['nrodocref']));  
         $cfu   = strtoupper(trim($row['codigo1'])); 
         $bas   = strtoupper(trim($row['base'])); 
         $iva   = strtoupper(trim($row['iva'])); 
         $did   = strtoupper(trim($row['docuid'])); 
         $fop   = strtoupper($row['formapago']);            
         $aid   = strtoupper($row['archivoid']);      
      }  

      /// Consumo el Webservice para Eliminar
      $json = file_get_contents('http://192.168.14.244:9999/dropos/wsjson/autorizaciongastos/nuevaautorizacion.php?tipo='.urlencode($tip).'&codsucursal='.urlencode($csu).'&observaciones='.urlencode($obs).'&diaoperativo='.urlencode($dia).'&nrosoporte='.urlencode($nro).'&codfuncionario='.urlencode($cfu).'&valorbase='.urlencode($bas).'&valoriva='.urlencode($iva).'&valortotal='.urlencode($tot).'&formapago='.urlencode($fop).'&proveedor='.urlencode($pro).'&docuidgenera='.urlencode($did).'&archivoid='.urlencode($aid));   
      $resultado = json_decode($json);  

      return;

} /// Fin de la Funcion GenerarAutorizacionCompra



//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$obj = json_decode( file_get_contents('php://input'));   

/// Lo convierto en un Array para verificar la estructura
$objArr = (array)$obj;

$i=0;
$PEIDDOID = "";
$prefijo = "";
//print_R($objArr); echo"<br>";


///// Registro el Uso de la API
$urlapi = $_SERVER['PHP_SELF'];
$vsql = "INSERT INTO estadisticasconsumosapi(urlapi,momento) VALUES('".$urlapi."',CURRENT_TIMESTAMP)";
EjecutarSQL($vsql);



$NDOCUID = "";   $NUMDOCUMENTO = "";
//if(($objArr[$i]->tipodoc == "TRB")&&($objArr[$i]->prefijo == "CRU"))    //// Control para que solo admita cruces
if($objArr[$i]->tipodoc == "TRB")
{
    while($objArr[$i]->pedidoid)
    {
        //// Si i==0 - Inserto el Encabezado
        if($i == 0)
        {
            $periodo   = date("mY");                             
		    $fechadoc  = date("Y-n-d");
		    $fechanull = "0000-00-00";
            $formapago = $objArr[$i]->formapago;
            if($formapago == "") $formapago = "CO";

            $prefijo = $objArr[$i]->prefijo;
            $sucursalid  = SeleccionarUno("SELECT sucursalid FROM bodegas WHERE bodegaid = ".$objArr[$i]->bodegadestino);
            $teridprov   = SeleccionarUno("SELECT terid FROM terceros WHERE dni = '".$objArr[$i]->dni."'");
            if($teridprov == "") $teridprov = SeleccionarUno("SELECT terid FROM terceros WHERE codigo = '99'");

            ///// Reservo el Consecutivo
            $numero    = SeleccionarUno("SELECT numero FROM consecutivos WHERE tipodoc = '".$objArr[$i]->tipodoc."' AND prefijo = '".$objArr[$i]->prefijo."'");
		    $numerosig = str_pad($numero + 1,5,0,STR_PAD_LEFT);
            EjecutarSQL("UPDATE consecutivos SET numero = '".$numerosig."' WHERE tipodoc = '".$objArr[$i]->tipodoc."' AND prefijo = '".$objArr[$i]->prefijo."'");

            ///// Inserto el Encabezado del Documento
            $vsql = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,fecanulado,importado,terid1,total,impreso,totalitems,sucursalid,creador,momento,formapago,observacion,nrodocref,archivoid) 
					 VALUES('".$objArr[$i]->tipodoc."','".$objArr[$i]->prefijo."','".$numerosig."','".$periodo."',CURRENT_TIMESTAMP,'".$fechanull."','".$fechanull."','S',".$teridprov.",0,'N',0,".
                     $sucursalid.",'SYSTEM',CURRENT_TIMESTAMP,'".$formapago."','".$objArr[$i]->observacion."','".$objArr[$i]->nrodocref."','".$objArr[$i]->archivoid."')";
            //echo "<BR>".$vsql."<br><br>";         
			$NDOCUID = EjecutarSQL($vsql);

            //// Obtengo el Docuid ReConfirmando el Numero
            $NDOCUID = SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = '".$objArr[$i]->tipodoc."' AND prefijo = '".$objArr[$i]->prefijo."' AND numero = '".$numerosig."' AND observacion = '".$objArr[$i]->observacion."' AND nrodocref = '".$objArr[$i]->nrodocref."'");
            $NUMDOCUMENTO =  $objArr[$i]->tipodoc.$objArr[$i]->prefijo.$numerosig;

            ///// Inserto el Registro Docutranfe
            if($objArr[$i]->prefijo == "CODC")
            {
                $vsql2 = "INSERT INTO docutranfe(docuid,bodegaidori,bodegaiddes,kardexori,kardexdes,codbarra,enviado,usuconfirma,planogen)
                        VALUES (".$NDOCUID.",448,".$objArr[$i]->bodegadestino.",'S','S','',CURRENT_TIMESTAMP,'SYSTEM','S')";
                //echo "<BR>".$vsql2."<br><br>";         
                EjecutarSQL($vsql2);    
            }
            else
            {
                $vsql2 = "INSERT INTO docutranfe(docuid,bodegaidori,bodegaiddes,kardexori,kardexdes,codbarra,enviado,usuconfirma,planogen)
                        VALUES (".$NDOCUID.",".$objArr[$i]->bodegaorigen.",".$objArr[$i]->bodegadestino.",'S','S','',CURRENT_TIMESTAMP,'SYSTEM','S')";
                //echo "<BR>".$vsql2."<br><br>";         
                EjecutarSQL($vsql2);    
            }

            ///// Inserto el Registro Docutranfe
            $vsql3 = "UPDATE archivodigital SET docuid3 = ".$NDOCUID." WHERE archivoid = ".$objArr[$i]->archivoid;
            //echo "<BR>".$vsql3."<br><br>";         
			EjecutarSQL($vsql3);                        
        }
        
        //// Si Insertó el encabezado - Inserte los detalles
        if($NDOCUID != "")
        {
            $cantidad       = 0+$objArr[$i]->cantidad;
            $costoprod      = 0;
            $porciva        = SeleccionarUno("SELECT porciva FROM productos WHERE productoid = ".$objArr[$i]->productoid);
            $valunitario    = 0+$objArr[$i]->valunitario;
            $valparcial     = 0+($cantidad*$valunitario);
            
            $valbase        = 0+$objArr[$i]->valtotal;
            $valiva         = 0;
            $valtotal       = 0+$objArr[$i]->valtotal;

            $unicom         = 0+$objArr[$i]->unicom;
            $unifra         = 0+$objArr[$i]->unifra;
                
            $vsql2 = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,valunitario,valparcial,porciva,valbase,
                      valiva,valtotal,unicom,unifra) VALUES(".$NDOCUID.",".$objArr[$i]->productoid.",".$objArr[$i]->bodegaorigen.",".$cantidad.",".$cantidad.",'D',".
                      $costoprod.",".$valunitario.",".$valparcial.",".$porciva.",".$valbase.",".$valiva.",".$valtotal.",".$unicom.",".$unifra.")";
            //echo $vsql2."<br><br>";          
            EjecutarSQL($vsql2);   
        }
            
        $i++;
    }

    //// Finalmente - Despues de estar Listo el Documento - Lo Asiento
    if($NDOCUID != "")
    {
        /// Recalculo los Valores Internos
        EjecutarSQL("PA_CalValoresFCO(".$NDOCUID.")");
        /// Lo Asiento
        EjecutarSQL('UPDATE documentos SET fecasentado = CURRENT_DATE  WHERE docuid = '.$NDOCUID);	
        /// Le Genero el JSON
        GenerarJSONTransferencia($NDOCUID);
        
        if($prefijo == "CODC")   
           GenerarAutorizacionCompra($NDOCUID);        
    }

    //// Finalizo generando la respuesta
    if($NDOCUID != "")
    {
        $code = 200;
        $message = "Documento Creado con Exito";
        $myArray = array("code" => $code , "message" => $message , "docuid" => $NDOCUID , "documento" => $NUMDOCUMENTO , "numero" => $numerosig);
    }
    else
    {
        $code = 400;
        $message = "Error al Crear el Documento";
        $myArray = array("code" => $code , "message" => $message);
    }
}
else
{
    $code = 400;
    $message = "Documento ya se encuentra en el Sistema";
    $myArray = array("code" => $code , "message" => $message);
}

/// Salida al Navegador
header('Content-type: application/json; charset=utf-8');
echo json_encode($myArray, JSON_PRETTY_PRINT);
?>