<?php
include("../../lib/Sistema.php");

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB(){
    $clase = new Sistema();
    $conexion = mysqli_connect($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion
////////////////////////////////////////////////////////////////////////////////////////////////////o
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_row($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$codsucursal  = $_GET['codsucursal'];
$docuid       = $_GET['docuid'];


///// Registro el Uso de la API
$urlapi = $_SERVER['PHP_SELF'];
$vsql = "INSERT INTO estadisticasconsumosapi(urlapi,momento) VALUES('".$urlapi."',CURRENT_TIMESTAMP)";
EjecutarSQL($vsql);


if(($codsucursal != "")&&($docuid != ""))
{
    $observacion = "%TEMPORAL%".$codsucursal."%".$docuid."%";
    $archivoid = SeleccionarUno("SELECT archivoid FROM archivodigital WHERE observacion = '".$observacion."'");
    $filename  = SeleccionarUno("SELECT filename FROM archivodigital WHERE observacion = '".$observacion."'");

    if($archivoid == "")
    {
        /// Preparo la Respuesta 
        $code = 400;
        $message = "Documento NO Encontrado";
        $myArray = array("code" => $code , "message" => $message , "docuid" => $archivoid);
    }
    else
    {
        /// Preparo la Respuesta 
        $code = 200;
        $message = "http://dromedicas.sytes.net:9996/dropos/media/docudigital/cargas/".$filename;
        $myArray = array("code" => $code , "message" => $message , "docuid" => $archivoid);
    }
}
else
{
    $code = 400;
    $archivoid = 0;
    $message = "Debe Ingresar Cod Sucursal y Documento ID";

    $myArray = array("code" => $code , "message" => $message , "docuid" => $archivoid);
}




/// Salida al Navegador
header('Content-type: application/json; charset=utf-8');
echo json_encode($myArray, JSON_PRETTY_PRINT);
?>