<?PHP
    @session_start();
    include("lib/Sistema.php");
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanaterceros
    // Creación: 05/09/2022		última modificación: 18/10/2022
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana donde se selecciona el tercero para editar
    // Última modificación: Inclusión de la lista de empleados en el periodo actual
    //                      (12/09/2022)
    //                      Validación de la existencia de empleados en el periodo
    //                      (04/10/2022)
    //                      Inclusión en el encabezado del número de empleados en el periodo
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "ventanaterceros")
    {
        // Consulta para el id del periodo
        $vsqlperiodoid  = "SELECT periodoid 
                             FROM periodosnomina 
                            WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsqlperiodoid);

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Variable para el nombre de empleado
        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                           FROM tercerosactual 
                          WHERE pernominaid = ".$periodoid."";
        
        $params = ' class="Texto11" ';

        // Valido que el periodo tenga empleados para ser editados
        $vsql2 = "SELECT COUNT(*) AS numregactual FROM tercerosactual WHERE pernominaid = ".$periodoid;
        $numregactual = $clase->SeleccionarUno($vsql2);

        if($numregactual > 0)
        {
            $disabled = '';
            $numeroempper = '<font color="green">'.$numregactual.'<br> empleados</font>';

            $vsql3 = "SELECT COUNT(*) AS numempadm 
                        FROM tercerosactual 
                       WHERE pernominaid = ".$periodoid." 
                             AND areaid = 1
                             AND (esempleadoactivo = 'CHECKED' AND extralegal = '') ";
            $numempadm = $clase->SeleccionarUno($vsql3);

            $numempadm2 = '<font color="blue">'.$numempadm.'<br> administraci&oacute;n</font>';

            $vsql4 = "SELECT COUNT(*) AS numempvts 
                        FROM tercerosactual 
                       WHERE pernominaid = ".$periodoid." 
                             AND areaid = 2
                             AND (esempleadoactivo = 'CHECKED' AND extralegal = '') ";
            $numempvts = $clase->SeleccionarUno($vsql4);

            $numempvts2 = '<font color="#CC66FF">'.$numempvts.'<br> ventas</font>';

            $vsql5 = "SELECT COUNT(*) AS numempext 
                        FROM tercerosactual 
                       WHERE pernominaid = ".$periodoid." 
                             AND (esempleadoactivo = 'CHECKED' AND extralegal = 'CHECKED')";
            $numempext = $clase->SeleccionarUno($vsql5);

            $numempext2 = '<font color="red">'.$numempext.'<br> extralegal</font>';
        }
        else
        {
            $disabled = 'disabled';
            $numeroempper = '';
            $numempadm2 = '';
            $numempvts2 = '';
            $numempext2 = '';
        }

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/terceros.png" width="32" height="32" border="0"> </td>
                  <td width="600"> <b>Editar terceros del periodo <br> <font color="blue">'.$descripcion.'</font></b> </td>
                  <td width="14"> &nbsp; </td>
                  <td width="120" align="right"> &nbsp; </td> 
                  <td width="120" align="right"> &nbsp; </td> 
                  <td width="60" align="right"> &nbsp; </td> 
                  <td width="80" align="right"> &nbsp; </td> 
                  <td width="25"> &nbsp; </td>
                 </tr> 
                </table>';
        
        $vienede = "tercerosactual";
        $cont.='<form action="?opcion=editartercero" name="y" method="POST">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <input type="hidden" name="vienede" value="'.$vienede.'">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="30"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="623">
                   <label class="Texto12">Empleado(a):</label>'.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","",$params,480).'
                  </td>
                  <td width="100" align="center"> 
                   <input type="submit" value="aceptar" class="button blue" '.$disabled.'>
                   </form> 
                  </td> 
                  <td width="90" align="right"> '.$numeroempper.' </td> 
                  <td width="120" align="right"> '.$numempadm2.' </td> 
                  <td width="60" align="right"> '.$numempvts2.' </td> 
                  <td width="80" align="right"> '.$numempext2.' </td>
                  <td width="15"> &nbsp; </td>
                 </tr> 
                </table>';

        // Consulta de empleados del periodo actual
        $vsql = "SELECT ta.dni, CONCAT(ta.primernombre,' ',ta.segundonombre,' ',ta.primerapellido,' ',ta.segundoapellido) AS nombreemp, 
                        c.descripcioncargo, ta.basico
                   FROM tercerosactual ta                  
                        INNER JOIN cargos c ON (ta.cargoid = c.cargoid)
                  WHERE ta.pernominaid = ".$periodoid." 
               ORDER BY ta.primernombre";

        // Conexión a la base de datos
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);

        // Validación de la ejecución del ciclo
        if($cant>0)
        {
            // Tabla de los datos de terceros del periodo actual
            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="12"> &nbsp; </td>
                       <td width="190" align="left"> Documento </td>
                       <td width="400" align="left"> Nombre </td>
                       <td width="245" align="left"> Cargo </td>
                       <td width="165" align="right"> B&aacute;sico </td>
                       <td width="23"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:455px; overflow-Y:scroll">';
    
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';

                $cont.=' <td width="12"> &nbsp; </td>
                         <td width="190" align="left"> '.$row['dni'].' </td>
                         <td width="400" align="left"> '.$row['nombreemp'].' </td>
                         <td width="245" align="left"> '.$row['descripcioncargo'].' </td>
                         <td width="165" align="right"> '.number_format($row['basico']).' </td>
                         <td width="20"> &nbsp; </td>
                        </tr>';
            }            
            $cont.=' </tbody>
                    </table>';

            $cont.='<table width="100%"> <tr class="TituloTabla"> <td width="1608"> &nbsp; </td> </tr> </table>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editartercero
    // Creación: 05/09/2022		última modificación: 18/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción donde se editan los datos del empleado
    // Última modificación: Inclusión del check para grabar los datos en la tabla terceros
    //                      (09/11/2022)
    //                      Se incluyó el parámetro para indicar el formulario predecesor
    //                      y el redireccionamiento hacia atrás (19/01/2023)
    //                      Ajuste de los estilos de las cajas de texto y fecha (16/04/2024)
    //                      Inclusión del campo tipo de documento
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editartercero")
    {
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];
        $vienede = $_GET['vienede'];
        
        if(strlen($terid)==0)                   $terid = $_GET['terid'];
        if(strlen($periodoid)==0)               $periodoid = $_GET['periodoid'];
        if(strlen($vienede)==0)                 $vienede = $_POST['vienede'];        

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // configuración de los combos
        $params = ' class="Texto11" style="height: 32px;" ';

        // Datos del empleado
        $primernombre = $clase->BDLockup($terid,'tercerosactual','terid','primernombre');
        $segundonombre = $clase->BDLockup($terid,'tercerosactual','terid','segundonombre');
        $primerapellido = $clase->BDLockup($terid,'tercerosactual','terid','primerapellido');
        $segundoapellido = $clase->BDLockup($terid,'tercerosactual','terid','segundoapellido');

        // Nombre completo del empleado
        $nombreemp = $primernombre.' '.$segundonombre.' '.$primerapellido.' '.$segundoapellido;

        // Documento del empleado
        $dni = $clase->BDLockup($terid,'tercerosactual','terid','dni');

        // Salario básico
        $basico = $clase->BDLockup($terid,'tercerosactual','terid','basico');

        // fecha de ingreso
        $fecingreso = $clase->BDLockup($terid,'tercerosactual','terid','fecingreso');

        // fecha de retiro
        $fecharetiro = $clase->BDLockup($terid,'tercerosactual','terid','fecharetiro');

        // eps
        $epsidemp  = $clase->BDLockup($terid,'tercerosactual','terid','epsid');
        $vsqlcomboeps = "SELECT epsid, descripcioneps FROM eps ORDER BY epsid ASC";
        $comboeps  = $clase->CrearComboBuscar("epsid",$vsqlcomboeps,"descripcioneps","epsid",$epsidemp,"N",$params,270);

        // fondos de pensiones
        $pensionesidemp  = $clase->BDLockup($terid,'tercerosactual','terid','pensionesid');
        $vsqlcomboafp = "SELECT pensionesid, descripcionafp FROM pensiones ORDER BY pensionesid ASC";
        $comboafp  = $clase->CrearComboBuscar("pensionesid",$vsqlcomboafp,"descripcionafp","pensionesid",$pensionesidemp,"N",$params,200);

        // fondos de cesantías
        $cesantiasidemp  = $clase->BDLockup($terid,'tercerosactual','terid','cesantiasid');
        $vsqlcombocesantias = "SELECT cesantiasid, descripcion FROM cesantias ORDER BY cesantiasid ASC";
        $combocesantias  = $clase->CrearComboBuscar("cesantiasid",$vsqlcombocesantias,"descripcion","cesantiasid",$cesantiasidemp,"N",$params,220);

        // caja de compensación
        $cajaidemp  = $clase->BDLockup($terid,'tercerosactual','terid','idcajacomp');
        $vsqlcombocajas = "SELECT idcajacomp, nombrecaja FROM cajascompensacion ORDER BY idcajacomp ASC";
        $combocajas  = $clase->CrearComboBuscar("idcajacomp",$vsqlcombocajas,"nombrecaja","idcajacomp",$cajaidemp,"N",$params,280);

        // área
        $areaidemp = $clase->BDLockup($terid,'tercerosactual','terid','areaid');
        $vsqlcomboarea = "SELECT areaid, descripcionarea FROM areanomina ORDER BY areaid ASC";
        $comboarea = $clase->CrearComboBuscar("areaid",$vsqlcomboarea,"descripcioncargo","areaid",$areaidemp,"N",$params,200);

        // sección del empleado
        $seccionidemp = $clase->BDLockup($terid,'tercerosactual','terid','seccionid');
        $vsqlcombosec = "SELECT seccionid, descripcionsec FROM seccion ORDER BY seccionid ASC";
        $comboseccion = $clase->CrearComboBuscar("seccionid",$vsqlcombosec,"descripcionsec","seccionid",$seccionidemp,"N",$params,250);

        // cargo
        $cargoidemp = $clase->BDLockup($terid,'tercerosactual','terid','cargoid');
        $vsqlcombocargo = "SELECT cargoid, descripcioncargo FROM cargos ORDER BY cargoid ASC";
        $combocargo = $clase->CrearComboBuscar("cargoid",$vsqlcombocargo,"descripcioncargo","cargoid",$cargoidemp,"N",$params,270);
        
        // banco
        $bancoidemp = $clase->BDLockup($terid,'tercerosactual','terid','bancoid');
        $vsqlcombobanco = "SELECT bancoid, descripcion FROM bancos ORDER BY bancoid ASC";
        $combobanco = $clase->CrearComboBuscar("bancoid",$vsqlcombobanco,"descripcion","bancoid",$bancoidemp,"N",$params,250);
        
        // cuenta bancaria
        $numcuenta = $clase->BDLockup($terid,'tercerosactual','terid','numcuenta');

        // estatus
        $extralegal = $clase->BDLockup($terid,'tercerosactual','terid','extralegal');        
        $esempleadoactivo = $clase->BDLockup($terid,'tercerosactual','terid','esempleadoactivo');
        $codvende = $clase->BDLockup($terid,'tercerosactual','terid','codvende');

        // idteract
        $vsql = "SELECT idteract
                   FROM tercerosactual 
                  WHERE pernominaid = ".$periodoid."
                        AND terid = ".$terid;
        $idteract = $clase->SeleccionarUno($vsql);

        // tipo de documento
        $tipodoc = $clase->BDLockup($terid,'tercerosactual','terid','tipodoc');
        $vsqlcombotipodoc = "SELECT codigo, CONCAT(codigo,' - ',descripcion) descripcion FROM tipodocumento ORDER BY codigo ASC";
        $combotipodoc = $clase->CrearComboBuscar("codigo",$vsqlcombotipodoc,"descripcion","codigo",$tipodoc,"N",$params,300);

        // Variable para controlar si guarda en la tabla terceros
        $afectaterceros = "";
        $recalcularempleado = "";
        $retiro = "";

        // Control del redireccionamiento hacia atrás
        if($vienede == "tercerosactual")            $hrefatras = '<a href="tercerosactual.php?opcion=ventanaterceros">';
        if($vienede == "ajustenomina")              $hrefatras = '<a href="ajustenomina.php?opcion=ventanareprocesar&terid='.$terid.'&periodoid='.$periodoid.'">';
        
        // Pinto la ventana
        $cont = $clase->Header("S","W");

        // encabezado
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/terceros.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b> Editar terceros del periodo <font color="blue"> '.$descripcion.' </font> </b> </td>
                  <td width="24"> &nbsp; </td>
                  <td width="24"> &nbsp; </td> 
                  <td width="20">
                   <a href="recibodepago.php?opcion=reciboindividual&terid='.$terid.'&periodoid='.$periodoid.'" target="_blank">
                    <img src="images/iconos/pdf.png" title="Recibo" border="0" width="32" height="32">
                   </a>
                  </td>                   
                  <td width="10"> &nbsp; </td>
                  <td width="24"> '.$hrefatras.' <input type="button" value="<<" class="button blue"> </a> </td>
                  <td width="10"> &nbsp; </td> 
                 </tr> 
                </table>';

        // datos del empleado
        $cont.='<form action="?opcion=guardarteract" name="y" method="POST">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="idteract" value="'.$idteract.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <input type="hidden" name="nombreemp" value="'.$nombreemp.'">
                <input type="hidden" name="vienede" value="'.$vienede.'">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323"><label class="Texto12">Empleado(a):</label> <br>'.$nombreemp.'</td>
                  <td width="317"> &nbsp; </td>                  
                  <td width="359"> &nbsp; </td>                  
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">
                   <label class="Texto11">Tipo de documento: <br> </label>
                   '.$combotipodoc.'
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">C&eacute;dula:</label>
                   <input type="text" name="dni" class="Texto11New" size="20" style="width:200px;height:25px;" autocomplete="off" title="documento" value="'.$dni.'">
                  </td>
                  <td width="359" align="left">
                   <label class="Texto11">Primer nombre:</label>
                   <input type="text" name="primernombre" class="Texto11New" size="20" style="width:200px;height:25px;" autocomplete="off" title="primer nombre" value="'.$primernombre.'">
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">
                   <label class="Texto11">Segundo nombre:</label>
                   <input type="text" name="segundonombre" class="Texto11New" size="20" style="width:200px;height:25px;" autocomplete="off" title="segundo nombre" value="'.$segundonombre.'"> 
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">Primer apellido:</label>
                   <input type="text" name="primerapellido" class="Texto11New" size="20" style="width:200px;height:25px;" autocomplete="off" title="primer apellido" value="'.$primerapellido.'">                   
                  </td>
                  <td width="359" align="left">
                   <label class="Texto11">Segundo apellido:</label>
                   <input type="text" name="segundoapellido" class="Texto11New" size="20" style="width:200px;height:25px;" autocomplete="off" title="segundo apellido" value="'.$segundoapellido.'">
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">
                   <label class="Texto11">B&aacute;sico:</label>
                   <input type="number" name="basico" min="1" class="Texto11New" size="20" style="width:120px;height:25px;" autocomplete="off" title="sueldo base" value="'.$basico.'"> 
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">Fecha de ingreso:</label>
                   <input type="date" class="Texto11New" name="fecingreso" size="10" style="width:110px;height:25px;" maxlenght="10" value="'.substr($fecingreso,0,10).'">
                  </td>
                  <td width="359" align="left">
                   <label class="Texto11">Fecha de retiro:</label>
                   <input type="date" class="Texto11New" name="fecharetiro" size="10" style="width:110px;height:25px;" maxlenght="10" value="'.substr($fecharetiro,0,10).'">
                   <input type="checkbox" value="CHECKED" name="retiro" class="Texto11" '.$retiro.'> retiro
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">   
                   <label class="Texto11">E.P.S:</label>
                   '.$comboeps.'
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">A.F.P:</label>
                   '.$comboafp.'
                  </td>
                  <td width="359" align="left">  
                   <label class="Texto11">Cesant&iacute;as:</label>
                   '.$combocesantias.'
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">                   
                   <label class="Texto11">&Aacute;rea:</label>
                   '.$comboarea.' 
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">Secci&oacute;n:</label>
                   '.$comboseccion.'
                  </td>
                  <td width="359" align="left">  
                   <label class="Texto11">Cargo:</label>
                   '.$combocargo.'
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">  
                   <label class="Texto11">Banco:</label>
                   '.$combobanco.'
                  </td>
                  <td width="317" align="left">
                   <label class="Texto11">N&uacute;mero de cuenta:</label>
                   <input type="text" name="numcuenta" class="Texto11New" size="20" style="width:190px;height:25px;" autocomplete="off" title="ingreso solo números" value="'.$numcuenta.'">                   
                  </td>
                  <td width="359" align="left">  
                   <label class="Texto11">C&oacute;digo Vendedor:</label>
                   <input type="number" name="codvende" class="Texto11New" size="4" style="width:80px;height:25px;" autocomplete="off" value="'.$codvende.'">                   
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">    
                   <label class="Texto11">Cajas de compensaci&oacute;n:</label>
                   '.$combocajas.'                                      
                  </td>
                  <td width="317" align="left"> 
                   <input type="checkbox" value="CHECKED" name="esempleadoactivo" class="Texto11" '.$esempleadoactivo.'> Activo n&oacute;mina                   
                  </td>
                  <td width="359" align="left">                    
                   <input type="checkbox" value="CHECKED" name="extralegal" class="Texto11" '.$extralegal.'> Extralegal
                  </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="323" align="left">   
                   <input type="checkbox" value="CHECKED" name="recalcularempleado" class="Texto11" '.$recalcularempleado.'> Recalcular sueldo
                  </td>
                  <td width="317" align="left"> 
                   <input type="checkbox" value="CHECKED" name="afectaterceros" class="Texto11" '.$afectaterceros.'> Cambios afectar&aacute;n ficha terceros
                   <img src="images/basicas/guardar.png" border="0">                  
                  </td>
                  <td width="359" align="left"> &nbsp; </td>
                 </tr>
                </table>';        

        // botón de aceptar
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <center>                  
                  <td width="657" align="center">                    
                   <br><br>
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                  </center>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>                 
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarteract
    // Creación: 07/09/2022		última modificación: 18/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda la información editada en la tabla tercerosactual
    // Última modificación: Almacenamiento de los datos en la tabla terceros en caso de ser 
    //                      necesario (09/11/2022)
    //                      Se optimizó el redireccionamiento del formulario de acuerdo al 
    //                      formulario predecesor y el mensaje de información del proceso
    //                      (19/01/2023)
    //                      Recalculo de la quincena (15/04/2024)
    //                      Optimización del redireccionamiento (16/04/2024)
    //                      Inclusión del campo tipo de documento
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarteract")
    {
        $idteract = $_POST['idteract'];                         $terid = $_POST['terid'];                               $periodoid = $_POST['periodoid'];
        $nombreemp = $_POST['nombreemp'];                       $dni = $_POST['dni'];                                   $primernombre = $_POST['primernombre'];
        $segundonombre = $_POST['segundonombre'];               $primerapellido = $_POST['primerapellido'];             $segundoapellido = $_POST['segundoapellido'];
        $basico = $_POST['basico'];                             $fecingreso = $_POST['fecingreso'];                     $epsid = $_POST['epsid'];
        $pensionesid = $_POST['pensionesid'];                   $cesantiasid = $_POST['cesantiasid'];                   $areaid = $_POST['areaid'];
        $seccionid = $_POST['seccionid'];                       $cargoid = $_POST['cargoid'];                           $bancoid = $_POST['bancoid'];
        $numcuenta = $_POST['numcuenta'];                       $esempleadoactivo = $_POST['esempleadoactivo'];         $extralegal = $_POST['extralegal'];
        $codvende = $_POST['codvende'];                         $idcajacomp = $_POST['idcajacomp'];                     $afectaterceros = $_POST['afectaterceros'];
        $vienede = $_POST['vienede'];                           $recalcularempleado = $_POST['recalcularempleado'];     $codigo = $_POST['codigo'];
        $fecharetiro = $_POST['fecharetiro'];                   $retiro = $_POST['retiro'];
        
        if($fecharetiro == "")
            $fecharetiro = "0000-00-00";
        
        // Valido que la fecha desde sea menor que la fecha hasta            
        require_once("classes/class_validaciones.php");         // Clase para la validación de las fechas
        $io_fecha=new class_validaciones();
        
        $lb_valido=false;
        $lb_valido=$io_fecha->uf_comparar_fecha($fecingreso,$fecharetiro);   // llamdo al procedimiento de validación de la fecha
        if((!$lb_valido) && ($fecharetiro != "0000-00-00"))
        {
            $clase->Aviso(3,"La fecha retiro debe ser mayor a la fecha de ingreso");
            header("Location: tercerosactual.php?opcion=editartercero&terid=$terid&periodoid=$periodoid&vienede=$vienede");
        }
        else
        {
            $lbgrabaterceros = false;
            $lbgrabatercerosactual = false;
    
            // Guardo en la tabla terceros en caso de ser seleccionado
            if($afectaterceros=="CHECKED")
            {
                // Almaceno la información
                $vsql = "UPDATE terceros SET 
                                esempleadoactivo = '".$esempleadoactivo."',
                                extralegal = '".$extralegal."',
                                areaid = ".$areaid.",
                                seccionid = ".$seccionid.",
                                cargoid = ".$cargoid.",
                                bancoid = ".$bancoid.",
                                numcuenta = '".$numcuenta."',
                                fecingreso = '".$fecingreso."',
                                fecharetiro = '".$fecharetiro."',
                                basico = ".$basico.",
                                codvende = '".$codvende."',
                                dni = '".$dni."',
                                tipodoc = '".$codigo."',
                                primernombre = '".$primernombre."',
                                segundonombre = '".$segundonombre."',
                                primerapellido = '".$primerapellido."',
                                segundoapellido = '".$segundoapellido."',
                                idcajacomp = ".$idcajacomp.",
                                epsid = ".$epsid.",
                                pensionesid = ".$pensionesid."
                          WHERE terid = ".$terid;
                $clase->EjecutarSQL($vsql);
    
                if(($fecharetiro != "0000-00-00") && ($retiro))
                {
                    // Procedo a pasar el empleado a retiro
    
                    if($cargoid==70)
                        $idcondicion = 1;
                    elseif($cargoid==71)
                        $idcondicion = 2;
                    elseif(($extralegal=="CHECKED")&&($esempleadoactivo=="CHECKED"))
                        $idcondicion = 3;
                    elseif(($extralegal!="CHECKED")&&($esempleadoactivo=="CHECKED"))
                        $idcondicion = 4;
    
                    // Cambio el estatus de empleado en la tabla terceros
                    $esempleadoter = "";
                    $esempleadoactivoter = "";
                    $enliquidacionter = "CHECKED";
    
                    $vsql = "UPDATE terceros SET 
                                    esempleado = '".$esempleadoter."',
                                    esempleadoactivo = '".$esempleadoactivoter."',                                    
                                    fecharetiro = '".$fecharetiro."', 
                                    enliquidacion = '".$enliquidacionter."',
                                    idcondicion = ".$idcondicion."
                              WHERE terid = ".$terid;
                    $clase->EjecutarSQL($vsql);
                    
                    // Calculo el nuevo ID del histórico de contrato
                    $vsql = "SELECT max(id) FROM histcontrato";
                    $numid = $clase->SeleccionarUno($vsql);
                    $numid++;
    
                    $vsql = "INSERT INTO histcontrato (id,terid,fecingreso,fecretiro,ultsueldo,idcondicion)
                                            VALUES (".$numid.",".$terid.",'".$fecingreso."','".$fecharetiro."',".$basico.",".$idcondicion.")";
                    $clase->EjecutarSQL($vsql);
    
                    // Elimino el empleado de la tabla de enlace sección terceros
                    $vsqld = "DELETE FROM seccionterceros WHERE terid = ".$terid;
                    $clase->EjecutarSQL($vsqld);
                }
    
                if(mysql_affected_rows() >= 1)
                    $lbgrabaterceros = true;
            }
    
            // Almaceno la información en la tabla tercerosactual
            $vsql = "UPDATE tercerosactual SET 
                            pernominaid = ".$periodoid.",
                            terid = ".$terid.",
                            esempleadoactivo = '".$esempleadoactivo."',
                            extralegal = '".$extralegal."',
                            areaid = ".$areaid.",
                            seccionid = ".$seccionid.",
                            cargoid = ".$cargoid.",
                            bancoid = ".$bancoid.",
                            numcuenta = '".$numcuenta."',
                            fecingreso = '".$fecingreso."',
                            fecharetiro = '".$fecharetiro."',
                            basico = ".$basico.",
                            codvende = '".$codvende."',
                            dni = '".$dni."',
                            tipodoc = '".$codigo."',
                            primernombre = '".$primernombre."',
                            segundonombre = '".$segundonombre."',
                            primerapellido = '".$primerapellido."',
                            segundoapellido = '".$segundoapellido."',
                            idcajacomp = ".$idcajacomp.",
                            epsid = ".$epsid.",
                            pensionesid = ".$pensionesid."
                      WHERE idteract = ".$idteract;
            $clase->EjecutarSQL($vsql);
    
            if(mysql_affected_rows() >= 1)
                $lbgrabatercerosactual = true;
    
            // --------------------------------------------------------------------------------------------------------------------------------- //
            // recalculo del empleado según los cambios realizados
            if($recalcularempleado)
            {
                // inicialización de variables
                $idsueldo = 0;                  $smlv = $_SESSION['N_SALMIN2020'];                  $diastrab = 0;
                $sueldo = 0;                    $cant2 = 0;                                         $idtransporte = 0;
                $auxtrans = $_SESSION['N_AUXTRANS2020'];                                            $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
    
                // formula del concepto
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                $formulatransporte = $clase->SeleccionarUno($vsql);            
    
                // // cargo y basico
                // $cargoid = $clase->BDLockup($terid,'tercerosactual','terid','cargoid');
                // $basico = $clase->BDLockup($terid,'tercerosactual','terid','basico');
    
                // recalculo el sueldo
                $vsql = "SELECT detalleid idsueldo FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                $idsueldo = $clase->SeleccionarUno($vsql);
    
                if($idsueldo > 0)
                {
                    // Obtengo la formula del sueldo
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                    $formulabasico = $clase->SeleccionarUno($vsql);
    
                    // días trabajados
                    $vsql = "SELECT valor diastrab FROM detallenomina WHERE detalleid = ".$idsueldo;
                    $diastrab = $clase->SeleccionarUno($vsql);
    
                    // ---------------------------------------------------------------------------------------------------------------------- //
                    $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                    $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                    $cambiodias = false;
    
                    if(($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta))
                    {
                        $diastrab = 0;
    
                        // Procedo a calcular los días que trabajó durante el periodo
                        $fecha1= new DateTime($fecingreso);
                        $fecha2= new DateTime($fechasta);
                        $diff = $fecha1->diff($fecha2);
                        
                        $difendias = $diff->days;
                        $diastrab = $difendias + 1;
    
                        $diadesde = substr($fecdesde, -2);
                        if($diadesde=="16")
                        {
                            $fechaEntera = strtotime($fechasta);
                            $valdias = date("d", $fechaEntera);
                            if($valdias=="28")          $diastrab += 2;
                            if($valdias=="29")          $diastrab += 1;
                            if($valdias=="31")          $diastrab -= 1;
                        }
    
                        $cambiodias = true;
                    }
    
                    // Valido si la fecha de retiro está dentro del rango de periodo
                    if(($fecharetiro>=$fecdesde)&&($fecharetiro<=$fechasta))
                    {
                        $diastrab = 0;
    
                        // Procedo a calcular los días que trabajó durante el periodo
                        $fecha1= new DateTime($fecdesde);
                        $fecha2= new DateTime($fecharetiro);
                        $diff = $fecha1->diff($fecha2);
                        
                        $difendias = $diff->days;
                        $diastrab = $difendias + 1;
    
                        $cambiodias = true;
                    }
    
                    // valido si el empleado tiene fecha de ingreso y retiro dentro del periodo
                    if((($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta)) && (($fecharetiro>=$fecdesde)&&($fecharetiro<=$fechasta)))
                    {
                        $diastrab = 0;
    
                        // Procedo a calcular los días que trabajó durante el periodo
                        $fecha1= new DateTime($fecingreso);
                        $fecha2= new DateTime($fecharetiro);
                        $diff = $fecha1->diff($fecha2);
                        
                        $difendias = $diff->days;
                        $diastrab = $difendias + 1;
    
                        $cambiodias = true;
                    }
    
                    if($cambiodias)
                    {
                        $vsql7 = "UPDATE detallenomina SET valor = ".$diastrab." WHERE detalleid = ".$idsueldo;
                        $clase->EjecutarSQL($vsql7);
                    }
                    // ---------------------------------------------------------------------------------------------------------------------- //
    
                    // Calculo el sueldo básico
                    eval("\$sueldo = $formulabasico;");
                    $sueldo = round($sueldo,0);
    
                    // grabo la modificación
                    $vsql = "UPDATE detallenomina SET devengados = ".$sueldo.", saldo = ".$basico." WHERE detalleid = ".$idsueldo."";
                    $clase->EjecutarSQL($vsql);
                }
    
                // recalculo las licencias remuneradas
                $vsql6 = "SELECT d.detalleid, d.conceptoid, d.valor, c.formula  
                            FROM detallenomina d
                                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                           WHERE d.terid = ".$terid."
                                 AND d.pernominaid = ".$periodoid." 
                                 AND (c.eslicencia = 'CHECKED' AND c.tipodc = 'C')";
                $conex  = $clase->Conectar();
                $result2 = mysql_query($vsql6,$conex);
                $cant2 = mysql_num_rows($result2);
    
                if($cant2 > 0)
                {
                    $montolicencia = 0;
                    $porcbasico = 0;
                    
                    while($row2 = mysql_fetch_array($result2))
                    {
                        $detalleid = $row2['detalleid'];
                        $conceptoid = $row2['conceptoid'];
                        $dias = $row2['valor'];
                        $formulalice = $row2['formula'];                    
    
                        // Calculo la licencia
                        if($conceptoid!=10)
                        {
                            eval("\$montolicencia = $formulalice;");
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {                        
                            // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                            if($basico<=$smlv)
                            {                            
                                $montolicencia = ($smlv*$dias)/30;
                                $montolicencia = round($montolicencia,0);
                            }
                            else
                            {
                                $porcbasico = ($basico*66.67)/100;
                                $porcbasico = round($porcbasico,0);
    
                                // Calculo la incapacidad si el básico sea mayor al mínimo 
                                if($porcbasico>$smlv)
                                {
                                    $montolicencia = ($porcbasico*$dias)/30;
                                    $montolicencia = round($montolicencia,0);
                                }
                                else
                                {
                                    if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                    if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;
    
                                    $montolicencia = round($montolicencia,0);
                                }
                            }
                        }
    
                        // guardo el nuevo monto
                        $vsql = "UPDATE detallenomina SET devengados = ".$montolicencia.", saldo = ".$basico." WHERE detalleid = ".$detalleid;
                        $clase->EjecutarSQL($vsql);
                    }
                }
    
                // recalculo el subsidio de transporte
                $valsubtrasp = $smlv * 2;
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');
    
                $vsql = "SELECT detalleid idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                $idtransporte = $clase->SeleccionarUno($vsql);
    
                if(($basico > $valsubtrasp) || ($aplicatransporte == ""))
                {
                    if(strlen($idtransporte) > 0)
                    {
                        $vsql = "DELETE FROM detallenomina WHERE detalleid = ".$idtransporte;
                        $clase->EjecutarSQL($vsql);
                    }
                }
                else
                {
                    if($diastrab == 0)
                        $subsidiotransporte = 0;
                    else
                    {
                        // Calculo el subsidio de transporte
                        eval("\$subsidiotransporte = $formulatransporte;");
                        $subsidiotransporte = round($subsidiotransporte,0);
    
                        if(strlen($idtransporte) > 0)
                            $vsql = "UPDATE detallenomina SET devengados = ".$subsidiotransporte.", valor = ".$diastrab." WHERE detalleid = ".$idtransporte;
                        else
                        {
                            $vsql = "SELECT max(detalleid) FROM detallenomina";
                            $numreg = $clase->SeleccionarUno($vsql);
        
                            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                        }
                        $clase->EjecutarSQL($vsql);
                    }
                }
    
                // recalculo pensión y salud
                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                $totnovedades = $clase->SeleccionarUno($vsql);

                $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                            FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                        WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                $totrecargos = $clase->SeleccionarUno($vsql);

                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
                    
                // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
                if($extralegal=="CHECKED")
                {
                    $pension = 0;
                    $salud = 0;
                }
                else
                {
                    // Recalculo pensión y salud
                    if(($pensionesid==5)||($aplicapension!="CHECKED"))
                        $pension = 0;
                    else
                    {
                        // Obtengo la formula para el descuento por pensión
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                        $formulapension = $clase->SeleccionarUno($vsql);
    
                        // Calculo la pensión
                        eval("\$pension = $formulapension;");
                        $pension = round($pension,0);
                    }
    
                    if(($epsid==37)||($aplicasalud!="CHECKED"))
                        $salud = 0;
                    else
                    {
                        // Obtengo la formula para el descuento de salud
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                        $formulasalud = $clase->SeleccionarUno($vsql);
                        
                        // Calculo la salud
                        eval("\$salud = $formulasalud;");
                        $salud = round($salud,0);
                    }
                }
    
                //  ID pensión
                $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                $idpension = $clase->SeleccionarUno($vsql);
    
                // Grabo la pensión
                if($idpension!="")
                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$pension.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idpension;
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
    
                // ID salud
                $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                $idsalud = $clase->SeleccionarUno($vsql);
    
                // Grabo la salud
                if($idsalud!="")
                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$salud.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idsalud;
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
                
                // Aquí depuro los conceptos que estén en cero
                $vsql = "DELETE FROM detallenomina WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                $clase->EjecutarSQL($vsql);            
            }

            // --------------------------------------------------------------------------------------------------------------------------------- //
            // valido que se almacenen los datos para emitir el mensaje correspondiente
    
            if($lbgrabaterceros || $lbgrabatercerosactual)
                $clase->Aviso(1,"Los datos de $nombreemp fueron modificados satisfactoriamente");
            else
                $clase->Aviso(3,"No se modificaron los datos de $nombreemp");
    
            // redirecciono el formulario
            if(($vienede == "tercerosactual") && (!$recalcularempleado))
                header("Location: tercerosactual.php?opcion=ventanaterceros");
            
            if(($vienede == "tercerosactual") && ($recalcularempleado))
                header("Location: tercerosactual.php?opcion=editartercero&terid=$terid&periodoid=$periodoid&vienede=$vienede");
    
            if($vienede == "ajustenomina")
                header("Location: ajustenomina.php?opcion=ventanareprocesar&terid=$terid&periodoid=$periodoid");
        }
    }

    ////////////////////////////////
    echo $cont.$clase->PiePagina();
?>