<?PHP
    session_start();
    include("lib/Sistema.php");

    $clase = new Sistema();
    
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardareditado y guardarnuevo
    // Creación: 29/09/2020		última modificación: 26/12/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opciones para incluir y modificar conceptos de nómina
    // Última modificación: Se incluyó el campo areaid (20/10/2020)
    //                      Validación de que un líder no pueda ser miembro de otra sección
    //                      e inclusión del proceso para quitar al líder de la sección
    //                      (29/07/2021)
    //                      Reformulación de la validación del líder de la sección
    //                      (20/05/2022)
    //                      Eliminación de los campos zona, ciudad y área
    ////////////////////////////////////////////////////////////////////////////////////////
    if(($opcion == "guardareditado")||($opcion == "guardarnuevo"))
    {
        $seccionid      = $_POST['seccionid'];
        $codseccion     = strtoupper(trim($_POST['codseccion']));
        $descripcionsec = strtoupper(trim($_POST['descripcionsec']));
        // $codzona        = $_POST['codzona'];
        // $ciudadid       = $_POST['ciudadid'];
        // $areaid         = $_POST['areaid'];

        $codzona        = 0;
        $ciudadid       = 0;
        $areaid         = 0;

        $idlider        = $_POST['idlider'];
        $quitarlider    = $_POST['quitarlider'];

        if($idlider=="")
            $idlider = 0;

        if($quitarlider=="CHECKED")
            $idlider = 0;

        // Valido que todos los campos tengan datos
        if(($codseccion == "")||($descripcionsec == ""))
        {
            $clase->Aviso(3,"Los datos código y descripción no pueden estar vacíos, verifique por favor.");
            header("Location: seccion.php");
        }
        else
        {
            // Opción para guardar una nueva sección
            if($opcion == "guardarnuevo")
            {
                // Validación de que el código ya exista
                $vsqlx = "SELECT COUNT(codseccion) FROM seccion WHERE codseccion ='".$codseccion."'";
                $valor = $clase->SeleccionarUno($vsqlx);

                if($valor>=1)
                {
                    $clase->Aviso(3,"El código <b> $codseccion </b> ya existe, verifíquelo por favor");
                    header("Location: seccion.php");
                }
                else
                {
                    // Validación de la existencia de la descripción de la sección
                    $vsqlx = "SELECT COUNT(descripcionsec) FROM seccion WHERE descripcionsec ='".$descripcionsec."'";
                    $valordesc = $clase->SeleccionarUno($vsqlx);

                    if($valordesc>=1)
                    {
                        $clase->Aviso(3,"La descripción <b> $descripcionsec </b> ya existe, verifíquela por favor");
                        header("Location: seccion.php");
                    }
                    else
                    {
                        // Valido que el líder no sea miembro de otra sección
                        // $vsqlx = "SELECT COUNT(*) AS vallider FROM seccionterceros WHERE terid =".$idlider;

                        $vsqlx = "SELECT COUNT(*) AS vallider 
                                    FROM seccionterceros 
                                   WHERE terid = ".$idlider."
                                         AND seccionid <> ".$seccionid."
                                         AND terid NOT IN (SELECT terid
                                                             FROM seccion
                                                            WHERE idlider = ".$idlider.")";
                        $vallider = $clase->SeleccionarUno($vsqlx);

                        if($vallider>=1)
                        {
                            // Nombre de empleado
                            $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreld FROM terceros WHERE terid = ".$idlider;
                            $nombreld = $clase->SeleccionarUno($vsqldatos);
                            $vsqldatos = "";

                            // Sección a la cual pertenece
                            $vsqldatos = "SELECT s.descripcionsec AS nombsec 
                                            FROM seccionterceros st
                                                 INNER JOIN seccion s ON (st.seccionid = s.seccionid)
                                           WHERE st.terid = ".$idlider;
                            $nombsec = $clase->SeleccionarUno($vsqldatos);
                            $vsqldatos = "";

                            $clase->Aviso(3,"$nombreld no puede ser líder de esta sección porque pertenece a la sección $nombsec");
                            header("Location: seccion.php");
                        }
                        else
                        {
                            // Almaceno el nuevo concepto
                            $vsql = "INSERT INTO seccion (codseccion, descripcionsec, codzona, ciudadid, areaid,idlider) 
                                        VALUES ('".$codseccion."','".$descripcionsec."','".$codzona."',".$ciudadid.",".$areaid.",".$idlider.")";
                            $cant = $clase->EjecutarSQL($vsql);
        
                            // valido que se almacenen los datos para emitir el mensaje correspondiente
                            if(mysql_affected_rows() < 1)
                                $clase->Aviso(3,"No se incluyó la sección");
                            else
                                $clase->Aviso(1,"Sección creada exitosamente");

                            header("Location: seccion.php");
                        }
                    }
                }
            }

            // Opción para modificar una sección
            if($opcion == "guardareditado")
            {
                // ---------------------------------------------------------------------------------------------- //
                // Proceso para validar si el código introducido ya existe
                $lb_codigodiferente=false;
                $lb_codigonuevoexiste=false;
                $valorcod = 0;

                $codnuevo = trim($codseccion);
                $vsqly = "SELECT codseccion FROM seccion WHERE seccionid=".$seccionid;
                $codanterior = $clase->SeleccionarUno($vsqly);
                
                if($codnuevo!=$codanterior)
                    $lb_codigodiferente=true;

                if($lb_codigodiferente)
                {
                    // Validación de la existencia del código de la sección
                    $vsqlx = "SELECT COUNT(codseccion) FROM seccion WHERE codseccion ='".$codnuevo."'";
                    $valorcod = $clase->SeleccionarUno($vsqlx);

                    if($valorcod>=1)
                        $lb_codigonuevoexiste=true;
                }
                // ---------------------------------------------------------------------------------------------- //
                // Proceso para validar si la descripción introducida ya existe
                $lb_descripciondiferente=false;
                $lb_descripcionnuevoexiste=false;
                $valordes = 0;

                $desnueva = trim($descripcionsec);
                $vsqly = "SELECT descripcionsec FROM seccion WHERE seccionid=".$seccionid;
                $desanterior = $clase->SeleccionarUno($vsqly);
                
                if($desnueva!=$desanterior)
                    $lb_descripciondiferente=true;

                if($lb_descripciondiferente)
                {
                    // Validación de la existencia de la descripción de la sección
                    $vsqlx = "SELECT COUNT(descripcionsec) FROM seccion WHERE descripcionsec ='".$desnueva."'";
                    $valordes = $clase->SeleccionarUno($vsqlx);

                    if($valordes>=1)
                        $lb_descripcionnuevoexiste=true;
                }

                // ---------------------------------------------------------------------------------------------- //
                // Ejecuto las validaciones
                if(($lb_codigodiferente)&&($lb_codigonuevoexiste))
                {
                    $clase->Aviso(3,"El código <b> $codnuevo </b> ya existe, verifíquelo por favor");
                    header("Location: seccion.php?opcion=detalles&seccionid=$seccionid");
                }
                else
                {
                    if(($lb_descripciondiferente)&&($lb_descripcionnuevoexiste))
                    {
                        $clase->Aviso(3,"La descripción <b> $descripcionsec </b> ya existe, verifíquela por favor");
                        header("Location: seccion.php?opcion=detalles&seccionid=$seccionid");
                    }
                    else
                    {
                        // Valido que el líder no sea miembro de otra sección
                        // $vsqlx = "SELECT COUNT(*) AS vallider FROM seccionterceros WHERE terid =".$idlider;

                        $vsqlx = "SELECT COUNT(*) AS vallider 
                                    FROM seccionterceros 
                                   WHERE terid = ".$idlider."
                                         AND seccionid <> ".$seccionid."
                                         AND terid NOT IN (SELECT terid
                                                             FROM seccion
                                                            WHERE idlider = ".$idlider.")";
                        $vallider = $clase->SeleccionarUno($vsqlx);

                        if($vallider>=1)
                        {
                            // Nombre de empleado
                            $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreld FROM terceros WHERE terid = ".$idlider;
                            $nombreld = $clase->SeleccionarUno($vsqldatos);
                            $vsqldatos = "";

                            // Sección a la cual pertenece
                            $vsqldatos = "SELECT s.descripcionsec AS nombsec 
                                            FROM seccionterceros st
                                                 INNER JOIN seccion s ON (st.seccionid = s.seccionid)
                                           WHERE st.terid = ".$idlider;
                            $nombsec = $clase->SeleccionarUno($vsqldatos);
                            $vsqldatos = "";

                            $clase->Aviso(3,"$nombreld no puede ser líder de esta sección porque pertenece a la sección $nombsec");
                            header("Location: seccion.php?opcion=detalles&seccionid=$seccionid");
                        }
                        else
                        {
                            // Almaceno la modificación
                            $vsql = "UPDATE seccion SET 
                                            codseccion = '".$codseccion."', 
                                            descripcionsec = '".$descripcionsec."',
                                            codzona = '".$codzona."', 
                                            ciudadid = ".$ciudadid.",
                                            areaid = ".$areaid.",   
                                            idlider = ".$idlider."
                                      WHERE seccionid = ".$seccionid;
                            $clase->EjecutarSQL($vsql);
            
                            // valido que se almacenen los datos para emitir el mensaje correspondiente
                            if(mysql_affected_rows() < 1)
                                $clase->Aviso(3,"No se modificó la sección");
                            else
                                $clase->Aviso(1,"Sección modificada exitosamente");

                            header("Location: seccion.php?opcion=detalles&seccionid=$seccionid");
                        }
                    }
                }
            }
            // header("Location: seccion.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nuevo
    // Creación: 29/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para incluir una nueva sección enviándola 
    //              a la opción "guardarnuevo" para almacenarlo
    // Última modificación: Se incluyó el campo areaid (20/10/2020)
    //                      Inclusión del departamento en el combo de ciudades (28/01/2021)
    //                      Inclusión del combo para el líder del departamento (12/07/2021)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Eliminación de los campos zona, ciudad y área
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevo")
    {
        // Consultas para los combos de zona, ciudad, área y empleados para los líderes
        $vsqlcombozona = "SELECT codzona, CONCAT(codzona,' - ',nombre) FROM zonas ORDER BY codzona ASC";
        $vsqlcombociudad = "SELECT ciudadid, CONCAT(codigo,' - ',nombre,' - ',departamento) FROM ciudades ORDER BY codigo ASC";
        $vsqlcomboarea = "SELECT areaid, CONCAT(areaid,' - ',descripcionarea) FROM areanomina ORDER BY areaid ASC";
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                           FROM terceros 
                          WHERE esempleadoactivo='CHECKED' 
                                AND basico > 0
                                AND (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";
        $params = ' class="Texto11" ';

        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/mapa.png" width="32" height="32" border="0"> </td>
                  <td width="1050"> <b>Nueva Sección</b> </td>
                  <td width="20"> <a href="terceros.php" target="blank"><input type="button" value="terceros" class="button red"></a> </td>
                  <td><a href="seccion.php"><input type="button" value="<<" class="button"></a></td>
                  <td width="8"> &nbsp; </td>
                 </tr>	 			   
                </table>';

        $cont.='<center>
                <form action="?opcion=guardarnuevo" method="POST">
                <!-- <fieldset style="width: 530px; height: 430px;" class="grupos"> -->
                <fieldset style="width: 530px; height: 270px;" class="grupos">
                 <legend class="titgrupos"> Datos </legend>
                 <table width="350">
                  <tr height="55">
                   <td> <label class="Texto12"> <b>C&oacute;digo</b></label><br> 
                    <input type="text" name="codseccion" class="Texto15" size="10" maxlength="10" id="default" autocomplete="off"> 
                   </td>
                  </tr>
                  <tr height="55">
                   <td> <label class="Texto12"> <b>Descripci&oacute;n:</b></label><br>
                    <input type="text" name="descripcionsec" class="Texto15"  maxlength="80" size="50" autocomplete="off"> 
                   </td>
                  </tr>
                  <!--
                  <tr height="55">
                   <td> <label class="Texto12"> <b>Zonas:</b></label><br>
                    '.$clase->CrearComboBuscar("codzona",$vsqlcombozona,"nombre","codzona","","N",$params,400).'   
                   </td>                   
                  </tr>                    
                  <tr height="55">
                   <td> <label class="Texto12"> <b>Ciudad:</b></label><br>
                    '.$clase->CrearComboBuscar("ciudadid",$vsqlcombociudad,"nombre","codigo","","N",$params,400).'
                   </td>
                  </tr>                    
                  <tr height="55">
                   <td> <label class="Texto12"> <b>&Aacute;rea:</b></label><br>
                    '.$clase->CrearComboBuscar("areaid",$vsqlcomboarea,"descripcionarea","areaid","","N",$params,400).'
                   </td>
                  </tr>                    
                  -->
                  <tr height="55">
                   <td> <label class="Texto12"> <b>L&iacute;der:</b></label><br>
                    '.$clase->CrearComboBuscar("idlider",$vsqlcomboemp,"nombreemp","terid","","S",$params,500).'
                   </td>
                  </tr>
                  <tr height="55">
                   <td align="center"><br><br> 
                    <input type="submit" value="guardar" class="button blue"> 
                   </td>
                  </tr>
                 </table>
                 <br><br>
                 </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacion
    // Creación: 29/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de una sección
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacion")
    {
        $seccionid  = $_GET['seccionid'];
        $descripcionsec = $clase->BDLockup($seccionid,'seccion','seccionid','descripcionsec');
        $cont='<table width="500">
                <tr class="CabezoteTabla"> 
                 <td align="center"> <br> <label class="Texto12"> <b>Eliminar una sección</b> </label> <br><br> </td> 
                </tr> 
               </table>
               <table width="500">
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center"> <label class="Texto12"> ¿Confirma que desea eliminar la sección <br><b> '.$descripcionsec.'</b>? </label> <br></td>       
                </tr>
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center"><br><br>
                  <form action="?opcion=eliminar" method="POST">
                   <input type="hidden" name="seccionid" value="'.$seccionid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                    <a href="seccion.php" ><input type="button" value="CANCELAR" class="button blue"></a>
                  </form>
                  <br>
                 </td>        
                </tr>
               </table><br>';
        echo $cont; 
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminar
    // Creación: 18/09/2020		última modificación: 29/07/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que elimina físicamente una sección
    // Última modificación: Validación de que no existan empleados asociados a la sección
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminar")
    {
        $seccionid = $_POST['seccionid'];
        $valor = 0;
        $nroempls = 0;
        $descripcionsec = $clase->BDLockup($seccionid,'seccion','seccionid','descripcionsec');

        // Valido que la sección no esté asociada con ningún cargo
        $vsqlx = "SELECT COUNT(seccionid) FROM cargos WHERE seccionid =".$seccionid;
        $valor = $clase->SeleccionarUno($vsqlx);
   
        if($valor>=1)
        {
            $clase->Aviso(3,"No se puede eliminar la sección $descripcionsec porque existen cargos asociados a ella");
            header("Location: seccion.php");
        }
        else
        {
            // Valido que no existan empleados miembros de esta sección
            $vsql = "SELECT COUNT(*) AS nroempls  
                       FROM seccionterceros 
                      WHERE seccionid = ".$seccionid."";
            $nroempls = $clase->SeleccionarUno($vsql);

            if($nroempls>0)
            {
                $clase->Aviso(3,"No se puede eliminar la sección $descripcionsec porque existen empleados asociados a ella");
                header("Location: seccion.php");
            }
            else
            {
                $vsql = "DELETE FROM seccion WHERE seccionid = ".$seccionid;
                $clase->EjecutarSQL($vsql);
    
                // valido que se almacenen los datos para emitir el mensaje correspondiente
                if(mysql_affected_rows() < 1)
                    $clase->Aviso(3,"No se eliminó la sección");
                else
                    $clase->Aviso(1,"Sección eliminada exitosamente");
    
                header("Location: seccion.php");
            }
        }
    }
  
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detalles
    // Creación: 29/09/2020		última modificación: 26/12/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana de modificación de una sección llevándola a 
    //              la opción "guardareditado" donde almacena los datos
    // Última modificación: Se incluyó el campo areaid (20/10/2020)
    //                      Inclusión del combo para el líder del departamento (12/07/2021)
    //                      Inclusión del checkbox para quitar al líder de la sección
    //                      (29/07/2021)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Eliminación de los campos zona, ciudad y área
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "detalles")
    {
        $seccionid = $_GET['seccionid'];
        $params = ' class="Texto11" ';
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/mapa.png" width="32" height="32" border="0"> </td>
                  <td width="990"> <b>Editar Secci&oacute;n </b> </td>
                  <td width="20"> <a href="terceros.php" target="blank"><input type="button" value="terceros" class="button red"></a> </td>
                  <form action="seccion.php?opcion=miembros&seccionid='.$seccionid.'" method="POST" name="x">
                  <input type="hidden" name="seccionid" value="'.$seccionid.'">
                  <td width="20"> <input type="submit" value="miembros" class="button blue"> </td>
                  </form>
                  <td width="24"> <a href="seccion.php"><input type="button" value="<<" class="button"></a> </td>
                 </tr> 
                </table>
                <br><center>';
        
        $vsql = "SELECT * FROM seccion WHERE seccionid = ".$seccionid;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        if($row = mysql_fetch_array($result))
        {
            $seccionid = $row['seccionid'];

            // Variables para la zona
            $codzona = $clase->BDLockup($seccionid,'seccion','seccionid','codzona');
            $vsqlcombozona = "SELECT codzona, nombre FROM zonas ORDER BY codzona ASC";
            $combozona = $clase->CrearComboBuscar("codzona",$vsqlcombozona,"nombre","codzona",$codzona,"N",$params,400);

            // Variables para la ciudad
            $ciudadid = $clase->BDLockup($seccionid,'seccion','seccionid','ciudadid');
            $vsqlcombociudad = "SELECT ciudadid, nombre FROM ciudades ORDER BY ciudadid ASC";
            $combociudad  = $clase->CrearComboBuscar("ciudadid",$vsqlcombociudad,"nombre","codigo",$ciudadid,"N",$params,400);

            // Variables para el área
            $areaid = $clase->BDLockup($seccionid,'seccion','seccionid','areaid');
            $vsqlcomboarea = "SELECT areaid, descripcionarea FROM areanomina ORDER BY areaid ASC";
            $comboarea  = $clase->CrearComboBuscar("areaid",$vsqlcomboarea,"descripcionarea","areaid",$areaid,"N",$params,400);

            // Variables para el líder de la sección
            $idlider = $clase->BDLockup($seccionid,'seccion','seccionid','idlider');

            if($idlider==0)
                $disabledchk = "disabled";
            else
                $disabledchk = "";

            // combo de empleado
            $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                               FROM terceros 
                              WHERE esempleadoactivo='CHECKED' 
                                    AND basico > 0
                                    AND (primernombre <> '' AND primerapellido <> '')
                           ORDER BY primernombre";
            $comboemp  = $clase->CrearComboBuscar("idlider",$vsqlcomboemp,"nombreemp","idlider",$idlider,"S",$params,500);

            $cont.='<center>
                    <form action="?opcion=guardareditado" method="POST">
                    <input type="hidden" name="seccionid" value="'.$seccionid.'">
                    <!-- <fieldset style="width: 530px; height: 480px;" class="grupos"> -->
                    <fieldset style="width: 530px; height: 310px;" class="grupos">
                    <legend class="titgrupos"> Datos </legend>
                    <table width="350">
                     <tr height="55">
                      <td> 
                       <label class="Texto12"> <b>C&oacute;digo</b></label><br> 
                       <input type="text" name="codseccion" class="Texto15" size="10" maxlength="10" id="default" value="'.$row['codseccion'].'" autocomplete="off"> 
                      </td>
                     </tr>
                     <tr height="55">
                      <td> 
                       <label class="Texto12"> <b>Descripci&oacute;n:</b></label><br>
                       <input type="text" name="descripcionsec" class="Texto15" style="width:400px;height:25px;" maxlength="50" size="50" value="'.$row['descripcionsec'].'" autocomplete="off"> 
                      </td>
                     </tr>
                     <!--
                     <tr height="55">
                      <td> 
                       <label class="Texto12"> <b>Zona:</b></label><br>  
                       '.$combozona.'
                      </td>
                     </tr> 
                     <tr height="55">
                      <td> 
                       <label class="Texto12"> <b>Ciudad:</b></label><br>  
                       '.$combociudad.'
                      </td>
                     </tr>
                     <tr height="55">
                      <td>
                       <label class="Texto12"> <b>&Aacute;rea:</b></label><br>  
                       '.$comboarea.'
                      </td>
                     </tr>
                     -->
                     <tr height="55">
                      <td> 
                       <label class="Texto12"> <b>L&iacute;der:</b></label><br>  
                       '.$comboemp.'
                      </td>
                     </tr>
                     <tr height="55">
                      <td> <label class="Texto12"> quitar l&iacute;der </label>';

            // Check para quitar el líder de la sección
            $cont.='<input type="checkbox" name="quitarlider" id="quitarlider" value="CHECKED" '.$disabledchk.'>';
            
            // Botón de guardar
            $cont.='  </td>
                     </tr>
                    </table>
                    <table width="350">			    
                     <tr height="55">
                      <td align="center">                         
                       <input type="submit" value="guardar" class="button blue"> 
                      </td>
                     </tr>						
                    </table>
                    <br>
                    </fieldset>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: miembros
    // Creación: 12/07/2021		última modificación: 20/05/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que actualiza los miembros de una sección    
    // Última modificación: Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Inclusión del acceso a la ficha de terceros para cada miembro 
    //                      de la sección (26/08/2021)
    //                      Se quitó la validación de que el líder no pueda ser miembro de 
    //                      la sección
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "miembros")
    {
        // id de la sección
        $seccionid = $_POST['seccionid'];
        
        if($seccionid == "")
            $seccionid = $_GET['seccionid'];

        // nombre de la sección
        $descripcionsec = $clase->BDLockup($seccionid,'seccion','seccionid','descripcionsec');

        // id del líder
        $idlider = $clase->BDLockup($seccionid,'seccion','seccionid','idlider');
        
        // nombre del lider
        if(($idlider==NULL)||($idlider==0))
            $nombrelider = "No tiene líder asignado";
        else
        {
            $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombrelider FROM terceros WHERE terid = ".$idlider;
            $nombrelider = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
        }

        // Combo de empleados
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                           FROM terceros 
                          WHERE esempleadoactivo='CHECKED' 
                                AND basico > 0
                                AND (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/terceros.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Miembros de la secci&oacute;n '.$descripcionsec.'</b> </td>
                  <td width="24"> <a href="seccion.php?opcion=detalles&seccionid='.$seccionid.'"> <input type="button" value="<<" class="button"></a> </td>
                  <td width="12"> &nbsp; </td>
                 </tr> 
                </table>';

        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="640"><label class="Texto12">L&iacute;der:</label> '.$nombrelider.' </td>                 
                  <td width="359"> &nbsp; </td>
                 </tr> 
                 <tr class="CabezoteTabla">
                  <form action="?opcion=guardarmiembro&terid='.$terid.'&seccionid='.$seccionid.'" name="y" method="POST">
                  <input type="hidden" name="seccionid" value="'.$seccionid.'">
                  <input type="hidden" name="idlider" value="'.$idlider.'">
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>                 
                  <td width="640"> 
                   <label class="Texto12">Empleado:</label>'.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombreemp","terid","","N",$params,500).'
                  </td>
                  <td width="359">
                   <input type="submit" value="aceptar" class="button blue">
                  </td>
                 </tr>
                </table>
                </form>';

        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <center>
                  <td width="657" align="center"> <b>Miembros</b> </td>
                 </tr>
                 </center>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="30"> &nbsp; </td>
                   <td width="100" align="left"> Documento </td>
                   <td width="390" align="left"> Nombre </td>
                   <td width="510 align="left"> Cargo </td>			                                      
                   <td width="30"> &nbsp; </td>
                   <td width="30"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:250px; overflow-Y:scroll">';

        // Consulta para mostrar lo miembros de la sección
        $vsql = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombre,
                        c.descripcioncargo AS cargo, st.secciontercerosid, t.terid 
                   FROM seccionterceros st
			            INNER JOIN terceros t ON (st.terid = t.terid)
					    INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE st.seccionid = ".$seccionid."
                        AND t.esempleadoactivo='CHECKED' 
               ORDER BY st.secciontercerosid";

        $i = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cargo = $row['cargo'];
            
            if($cargo=="")
                $cargo = "NO TIENE CARGO ASIGNADO";

            $secciontercerosid = $row['secciontercerosid'];

            $cont.=' <td width="30"> &nbsp; </td>
                     <td width="100" align="left"> '.$row['dni'].' </td>
                     <td width="390" align="left"> '.$row['nombre'].' </td>
                     <td width="510" align="left"> '.$cargo.' </td>
                     <td width="30" align="center"> 
                      <a href="?opcion=valborrarmiembro&secciontercerosid='.$secciontercerosid.'&seccionid='.$seccionid.'" rel="facebox" title="eliminar miembro">
                       <img src="images/basicas/iconoborrar.png" border="0">
                      </a>
                     </td>
                     <td width="30" align="center">
                      <a href="terceros.php?opcion=detalles2&id='.$row['terid'].'" target="_blank"> 
                       <img src="images/basicas/iconobuscar.png" border="0">
                      </a>
                     </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>';

        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="30"> &nbsp; </td>
                  <td width="441"> &nbsp; </td>
                  <td width="255" align="right"> &nbsp; </td>
                  <td width="255" align="right"> &nbsp; </td>
                  <td width="255" align="right"> &nbsp; </td>
                  <td width="402"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarmiembro
    // Creación: 13/07/2021		última modificación: 20/05/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que almacena un nuevo miembro a una sección
    // Última modificación: validación de la no inclusión de un empleado en una sección 
    //                      cuando ya pertenece a otra, validación para que no se incluya 
    //                      a un líder como miembro de otra sección (14/07/2021)
    //                      Actualizo la sección en la tabla terceros (26/07/2021)
    //                      Se quitó la validación de que el líder no pueda ser miembro de 
    //                      la sección
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarmiembro")
    {
        // id del empleado
        $terid = $_POST['terid'];
        $seccionid = $_POST['seccionid'];

        // Nombre del empleado
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);

        // Inicialización de variables
        $repetido = 0;
        $tieneseccion = 0;
        $eslider = 0;
        
        // Valido que el empleado ya existe como miembro de esta sección
        $vsql = "SELECT COUNT(*) AS repetido 
                   FROM seccionterceros 
                  WHERE terid = ".$terid."
                        AND seccionid = ".$seccionid."";
        $repetido = $clase->SeleccionarUno($vsql);

        if($repetido>0)
            $clase->Aviso(3,"<b>$nombreemp</b> ya pertenece a esta sección");
        else
        {
            // Ahora valido que el empleado no pertenezca a otra sección
            $vsql = "SELECT COUNT(*) AS tieneseccion 
                       FROM seccionterceros 
                      WHERE terid = ".$terid;
            $tieneseccion = $clase->SeleccionarUno($vsql);

            if($tieneseccion>0)
            {
                // Id de la sección a la que ya pertenece
                $seccionidanterior = $clase->BDLockup($terid,'seccionterceros','terid','seccionid');

                // Nombre de la sección anterior
                $nombreseccion = $clase->BDLockup($seccionidanterior,'seccion','seccionid','descripcionsec');

                // Mensaje correspondiente
                $clase->Aviso(3,"<b>$nombreemp</b> ya pertenece la sección <b>$nombreseccion</b>");
            }
            else
            {
                // Valido que el empleado no sea líder de una sección
                $vsql = "SELECT COUNT(*) AS eslider 
                           FROM seccion 
                          WHERE idlider = ".$terid."
                                AND seccionid <> ".$seccionid." ";
                $eslider = $clase->SeleccionarUno($vsql);

                if($eslider>0)
                {
                    // Nombre de la sección
                    $descripcionsec = $clase->BDLockup($terid,'seccion','idlider','descripcionsec');

                    // Mensaje correspondiente
                    $clase->Aviso(3,"<b>$nombreemp</b> es líder de la sección <b>$descripcionsec</b>");
                }
                else
                {
                    // Actualizo la información en la tabla terceros
                    $vsql = "UPDATE terceros SET 
                                    seccionid = ".$seccionid."
                              WHERE terid = ".$terid."";
                    $clase->EjecutarSQL($vsql);

                    // Obtengo el número de registros de la tabla seccionterceros
                    $vsql = "SELECT MAX(secciontercerosid) FROM seccionterceros";
                    $secciontercerosid = $clase->SeleccionarUno($vsql);

                    // Incremento el ID
                    $secciontercerosid++;

                    $vsql = "INSERT INTO seccionterceros (secciontercerosid,seccionid, terid) 
                                  VALUES ($secciontercerosid,".$seccionid.",".$terid.")";
                    $clase->EjecutarSQL($vsql);

                    // Envío el mensaje correspondiente
                    if(mysql_affected_rows() < 1)
                        $clase->Aviso(3,"No se incluyó el miembro");
                    else
                        $clase->Aviso(1,"<b>$nombreemp</b> incluido(a) satisfactoriamente");
                }
            }
        }
        header("Location: seccion.php?opcion=miembros&seccionid=$seccionid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: valborrarmiembro
    // Creación: 13/07/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de un miembro de una sección
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "valborrarmiembro")
    {
        $secciontercerosid = $_GET['secciontercerosid'];
        $seccionid = $_GET['seccionid'];
        $terid = $clase->BDLockup($secciontercerosid,'seccionterceros','secciontercerosid','terid');

        // nombre del miembro
		$vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);

        $cont='<table width="500">
                <tr class="CabezoteTabla"> 
                 <td align="center"><br><b>Eliminar miembro</b><br><br></td> 
                </tr> 
               </table>
               <table width="500">
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center">¿Confirma que desea eliminar a <br><b>'.trim($nombreemp).'</b>? <br></td> 
                </tr>
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center"><br><br>                  
                  <form action="?opcion=borrarmiembro&secciontercerosid='.$secciontercerosid.'&seccionid='.$seccionid.'" method="POST">
                   <input type="hidden" name="secciontercerosid" value="'.$secciontercerosid.'">                   
                   <input type="hidden" name="seccionid" value="'.$seccionid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="seccion.php?opcion=miembros&seccionid='.$seccionid.'" >
                    <input type="button" value="CANCELAR" class="button blue">
                   </a>
                  </form><br>
                 </td>        
                </tr>
               </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: borrarmiembro
    // Creación: 13/07/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elina a un miembro de una sección
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "borrarmiembro")
    {
        $secciontercerosid = $_POST['secciontercerosid'];
        $seccionid = $_POST['seccionid'];

        // Elimino el miembro de la sección
        $vsql = "DELETE FROM seccionterceros WHERE secciontercerosid = ".$secciontercerosid;
        $clase->EjecutarSQL($vsql);

        // emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Miembro eliminado satisfactoriamente");
        else
            $clase->Aviso(3,"No se eliminó correctamente el miembro");        

        // Redirecciono el formulario
        header("Location: seccion.php?opcion=miembros&seccionid=$seccionid");        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtro
    // Creación: 02/10/2020		última modificación: 11/12/2020
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para hacer una búsqueda avanzada por uno 
    //              o varios criterios
    // Última modificación: Se incluyó el campo área (20/10/2020)
    //                      Se ajustó para hacer un formulario parte para poder ver 
    //                      correctamente los combos incluyendo el botón hacia atrás
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "filtro")
    {
        // Variables para los combos de zona y ciudad
        $vsqlcombozona = "SELECT codzona, CONCAT(codzona,' - ',nombre) FROM zonas ORDER BY codzona ASC";
        $vsqlcombociudad = "SELECT ciudadid, CONCAT(codigo,' - ',nombre) FROM ciudades ORDER BY codigo ASC";
        $vsqlcomboarea = "SELECT areaid, CONCAT(areaid,' - ',descripcionarea) FROM areanomina ORDER BY areaid ASC";
        $params = ' class="Texto11" ';

        $cont = $clase->Header("S","W");
        $cont.='<form action="?opcion=filtrar" method="POST" name="x">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Filtrar b&uacute;squeda de secciones </b> </td> 
                  <td width="10%" align="center"> <a href="seccion.php"> <input type="button" class="button" value="<<"> </a></td>
                 </tr> 
                </table>
                <table width="100%">
                 <tr class="TablaDocsImPar">				
                  <td width="180" align="right"> C&oacute;digo:&nbsp </td> 			  
                  <td width="220">
                   <input type="text" class="Texto11" name="codseccion" size="10" maxlenght="10" value="" style="width:120px;height:25px;text-transform:uppercase!Important;" autocomplete="off">
                  </td>	
                 </tr>	
                 <tr class="TablaDocsImPar">				
                  <td width="180" align="right"> Nombre:&nbsp </td> 			  
                  <td width="220">
                   <input type="text" class="Texto11" name="descripcionsec" size="40" maxlenght="50" value="" style="width:300px;height:25px;text-transform:uppercase!Important;" autocomplete="off">
                  </td>	
                 </tr>
                 <!--	
                 <tr class="TablaDocsImPar">				
                  <td width="180" align="right"> Zonas: &nbsp; </td>		
                  <td width="220">
                   '.$clase->CrearComboBuscar("codzona",$vsqlcombozona,"nombre","codzona","","S",$params,300).'
                  </td>	
                 </tr>
                 <tr class="TablaDocsImPar">				
                  <td width="180" align="right"> Ciudad: &nbsp; </td>
                  <td width="220">
                   '.$clase->CrearComboBuscar("ciudadid",$vsqlcombociudad,"nombre","codigo","","S",$params,300).'
                  </td>
                 </tr>                    
                 <tr class="TablaDocsImPar">				
                  <td width="180" align="right"> &Aacute;rea: &nbsp; </td>
                  <td width="220">
                   '.$clase->CrearComboBuscar("areaid",$vsqlcomboarea,"descripcionarea","areaid","","S",$params,300).'
                  </td>
                 </tr>
                 -->
                </table>
                <center><br>
                <table width="400">
                 <input type="submit" value="filtrar secciones" class="button red">
                </table>
                </form><br>';
        echo $cont;
        exit();
    }

    ///////////////////////////////////////////////////////////////////////////////////////////  
    // Opción: filtrar
    // Creación: 02/10/2020		última modificación: 26/12/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que aplica los criterios de filtro para la consulta
    // Última modificación: Se incluyó el campo área (20/10/2020)
    //                      Eliminación de los campos zona, ciudad y área
    ///////////////////////////////////////////////////////////////////////////////////////////  
    if($opcion == "filtrar")
    {
        // Variables para filtrar la consulta
        $codseccion     = strtoupper($_POST['codseccion']);
        $descripcionsec = strtoupper($_POST['descripcionsec']);
        // $codzona 	    = $_POST['codzona'];
        // $ciudadid 	    = $_POST['ciudadid'];
        // $areaid         = $_POST['areaid'];

        $cwhere = "codseccion <> '' ";    // Inicialización de la variable para filtrar la consulta

        // Aplicación de los filtros seleccionados
        if(strlen($codseccion)>0)       $cwhere.=" AND s.codseccion LIKE '%".$codseccion."%' ";
        if(strlen($descripcionsec)>0)	$cwhere.=" AND s.descripcionsec LIKE '%".$descripcionsec."%' ";
        // if(strlen($codzona)>0)	        $cwhere.=" AND s.codzona LIKE '%".$codzona."%' ";
        // if(strlen($ciudadid)>0)	        $cwhere.=" AND s.ciudadid = ".$ciudadid." ";
        // if(strlen($areaid)>0)	        $cwhere.=" AND s.areaid = ".$areaid." ";

        // Construcción de la consulta
        // $vsql = "SELECT s.seccionid, s.codseccion, s.descripcionsec, c.nombre, a.descripcionarea,
        //                 (SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)
        //                    FROM terceros
        //                   WHERE terid = s.idlider) AS nombrelider
        //            FROM seccion s
        //                 INNER JOIN ciudades c ON (s.ciudadid = c.ciudadid)
        //                 INNER JOIN areanomina a ON (s.areaid = a.areaid)
        //           WHERE ".$cwhere."
        //        ORDER BY s.seccionid";

        $vsql = "SELECT s.seccionid, s.codseccion, s.descripcionsec, 
                        (SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)
                           FROM terceros
                          WHERE terid = s.idlider) AS nombrelider
                   FROM seccion s
                  WHERE ".$cwhere."
               ORDER BY s.seccionid";
        
        // Envío de la información
        $_SESSION['SQL_SECCION'] = $vsql;
        header("Location: seccion.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: encontrar
    // Creación: 30/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que encuentra un concepto buscándolo por código o descripción
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio  = $_POST['criterio'];
        $arreglado = str_replace(" ","%",$criterio);

        $vsql = "SELECT s.seccionid, s.codseccion, s.descripcionsec, c.nombre, a.descripcionarea,
                        (SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)
                           FROM terceros
                          WHERE terid = s.idlider) AS nombrelider
                   FROM seccion s
                        INNER JOIN ciudades c ON (s.ciudadid = c.ciudadid)
                        INNER JOIN areanomina a ON (s.areaid = a.areaid)
                  WHERE s.codseccion LIKE '%".$criterio."%' OR 
                        s.descripcionsec LIKE '%".$criterio."%'                         
               ORDER BY s.codseccion ASC";

        $_SESSION['SQL_SECCION'] = $vsql;
        header("Location: seccion.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 30/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que anula la búsqueda realizada por la opción “encontrar”
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $vsql = "SELECT s.seccionid, s.codseccion, s.descripcionsec, 
                        (SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)
                           FROM terceros
                          WHERE terid = s.idlider) AS nombrelider
                   FROM seccion s
               ORDER BY s.seccionid";
        $_SESSION['SQL_SECCION'] = "";
        header("Location: seccion.php");
    }
  
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 30/09/2020		última modificación: 26/12/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal del formulario
    // Última modificación: Se incluyó el campo área (20/10/2020)
    //                      Optimización de la consulta de la vista (21/05/2022)
    //                      Botón para la salida a Excel de las secciones (16/11/2022)
    //                      Eliminación de los campos zona, ciudad y área
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/mapa.png" width="32" height="32" border="0"> </td>
                  <td width="800"> <b>Secciones</b> </td>
                  <td width="30"> 
                   <a href="?opcion=seccionespdf" title="informe de secciones en pdf" target="_blank"> 
                    <img src="images/iconos/exportarpdf2.png" border="0" width="32" height="32"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=seccionesxls" title="informe de secciones en excel" target="_blank"> 
                    <img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=filtro">
                    <img src="images/iconos/vistaprevia.png" title="b&uacute;squeda avanzada" border="0" width="32" height="32"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=nuevo"> 
                    <img src="images/iconos/nuevodoc.png" border="0" title="nueva secci&oacute;n" border="0" width="32" height="32"> 
                   </a> 
                  </td>
                  <!--
                  <form action="?opcion=encontrar" method="POST" name="x">
                  <td> <input type="text" name="criterio" size="20" placeholder="Criterio a Buscar" tabindex="1" id="default"> </td>
                  <td> <input type="submit" value="Encontrar" class="button"> </form> </td>
                  -->';

        if($_SESSION['SQL_SECCION'] != "")
            $cont.='<td width="10"> &nbsp; </td>
                    <td width="30"> <a href="?opcion=nofiltro"> <img src="images/iconos/devoluciones.png" width="32" height="32" border="0" title="anular &uacute;ltima b&uacute;squeda""> </a> </td>';
  
        $cont.='  <td width="8"> &nbsp; </td>
                 </tr>	 			   
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="11">&nbsp;</td>
                   <td width="125" align="left"> C&oacute;digo </td>
                   <td width="180" align="left"> Nombre </td>			                    
                   <td width="35" align="left"> &nbsp; </td>
                   <td width="159" align="left"> L&iacute;der </td>
                   <td width="183" align="left"> &nbsp; </td>
                   <td width="12"> &nbsp; </td>	
                   <td width="190" align="left"> &nbsp; </td>
                   <td width="20"> &nbsp; </td>
                   <td width="6"> &nbsp; </td>
                   <td width="32"> &nbsp; </td>
                   <td width="32"> &nbsp; </td>
                   <td width="26"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';        

        if($_SESSION['SQL_SECCION'] == "")
            $vsql = "SELECT s.seccionid, s.codseccion, s.descripcionsec, 
                            (SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)
                               FROM terceros
                              WHERE terid = s.idlider) AS nombrelider 
                       FROM seccion s
                   ORDER BY s.seccionid";
        else
            $vsql = $_SESSION['SQL_SECCION'];        

        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $lider = $row['nombrelider'];
            if($lider=="")
                $lider = "NO TIENE LIDER ASIGNADO";

            $cont.=' <td width="20">&nbsp;</td>
                     <td width="11">&nbsp;</td>
                     <td width="120" align="left"> '.$row['codseccion'].' </td>
                     <td width="210" align="left"> '.$row['descripcionsec'].' </td>                     
                     <td width="17"> &nbsp; </td>
                     <td width="300" align="left"> '.substr($lider,0,60).' </td>                     
                     <td width="133" align="left"> &nbsp; </td>
                     <td width="12"> &nbsp; </td>
                     <td width="218" align="left"> &nbsp; </td>
                     <td width="14"> &nbsp; </td>
                     <td width="6" align="center"> &nbsp; </td> 
                     <td width="30" align="center"> 
                      <a href="?opcion=confirmacion&seccionid='.$row['seccionid'].'" rel="facebox">
                       <img src="images/basicas/iconoborrar.png" title="eliminar secci&oacute;n" border="0">
                      </a>
                     </td> 
                     <td width="30" align="center"> 
                      <a href="?opcion=detalles&seccionid='.$row['seccionid'].'">
                       <img src="images/basicas/iconobuscar.png" title="editar secci&oacute;n" border="0">
                      </a>
                     </td>
                    </tr>';
        }
        $cont.=' </tbody>
                </table>
                <table width="100%"> <tr class="TituloTabla"> <td width="1608"> &nbsp; </td> </tr> </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: seccionesxls
    // Creación: 16/11/2022		última modificación: 23/11/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera la salida a Excel de las secciones
    // Última modificación: Se incluyó la comilla simple para los códigos que comiencen en 
    //                      cero
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "seccionesxls")
    {
        $vsql = "SELECT codseccion, descripcionsec FROM seccion ORDER BY seccionid";

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Secciones de nomina - DROPOS")
                                     ->setSubject("Secciones de nomina - DROPOS")
                                     ->setDescription("Secciones de nomina - DROPOS")
                                     ->setKeywords("Secciones de nomina - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'INFORME DE SECCIONES')                    
                    ->setCellValue('A3', 'CODIGO')
                    ->setCellValue('B3', 'NOMBRE');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);        
        $i = 4;
        while($row = mysql_fetch_array($result))
        {
            $codseccion = $row['codseccion'];
            if(substr($codseccion,0,1) == "0")          $codseccion="'".$codseccion;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $codseccion)
                        ->setCellValue('B'.$i, $row['descripcionsec']);
            $i++;
        }

        $rangoEncabezado = 'A3:B3';
        $rangoCeldas     = 'A3:B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('secciones');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //                
        $nombrearcexcel = "informe de secciones.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: seccionespdf
    // Creación: 17/11/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida en pdf de las secciones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "seccionespdf")
    {
        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        // Procedo a construir el encabezado del recibo
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();
        
        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

        // Imprimo el encabezado del informe
        $x = 25;
        $y = 13;
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+124,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "INFORME DE SECCIONES";            $pdf->Text($x,$y+5,$enc);

        // Encabezado del informe
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(5,28,200,8,'F');
        $pdf->SetFont('Arial','B',9);

        $enc= "CODIGO";                         $pdf->Text($x-17,$y+20,$enc);
        $enc= "SECCION";                        $pdf->Text($x+17,$y+20,$enc);

        // consulta del informe
        $vsql = "SELECT codseccion, descripcionsec FROM seccion ORDER BY seccionid";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $x = 8;
        $y = 41;
        $i = 0;
        $linea = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%38==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "INFORME DE SECCIONES";           $pdf->Text($x,$y+5,$enc);

                // Encabezado del informe
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,28,200,8,'F');
                $pdf->SetFont('Arial','B',9);

                $enc= "CODIGO";                         $pdf->Text($x-17,$y+20,$enc);
                $enc= "SECCION";                        $pdf->Text($x+17,$y+20,$enc);

                $x = 8;
                $y = 41;
            }

            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y,$row['codseccion']);
            $pdf->Text($x+34,$y,$row['descripcionsec']);

            $y+=6;
        }
        
        $pdf->Output();
    }    

    ////////////////////////////////
    echo $cont.$clase->PiePagina();  
?> 