<?PHP
    @session_start(); 
    include("lib/Sistema.php");    
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 13/11/2020		última modificación: 24/05/2021
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que pinta la ventana para la captación de datos del informe  
    //              general de nómina
    // Última modificación: Se incluyó el combo para el tipo de nómina a emitir: empleados 
    //                      o extralegal (27/11/2020)
    //                      Inclusión de la opción todos en el tipo de nómina (16/12/2020)
    //                      El combo de periodos despliega únicamente los periodos cerrados 
    //                      y el actual
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codigo, CONCAT(codigo,' - ',descripcion) 
                                FROM periodosnomina 
                               WHERE cerrado ='CHECKED' OR 
                                     periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')                                    
                            ORDER BY periodoid ASC";
    
        $cont = $clase->Header("S","W");    
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/informes.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Informe general de nómina </b></td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';    
        
        $cont.='<form action="repgennomina.php?opcion=listadonomina" method="POST" name="x" target="_blank">
                 <center>
                 <table width="100%">
                  <tr class="BarraDocumentos">
                   <td align="center"><br><br><b> Datos del informe <br><br></td>
                  </tr>
                 </table>  
                 <table width="100%">
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Periodo: </td>
                   <td width="120">';

        $cont.= $clase->CrearComboBuscar("codigo",$vsqlcomboperiodo,"descripcion","codigo","","N",$params,400);
                    
        $cont.='   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Tipo: </td>
                   <td width="120"> 
                    <SELECT name="tiponomina" id="tiponomina" style="width:120px;height:20px">
                     <option value="todos" SELECTED> Todos </option>               
                     <option value="empleados"> Empleados </option>               
                     <option value="extralegal"> Extralegal </option>
                    </SELECT> 
                   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                 </table>                   
                 <table width="100%">                     
                  <tr class="BarraDocumentos"> 
                   <td width="371" height="50" align="center">&nbsp;  </td>      
                   <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"></td>
                   <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"></td>
                   <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"></td>
                   <td width="380" height="50" align="center">&nbsp;  </td>
                  </tr>
                 </table> 
                </form>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                </table>';
        echo $cont;  
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: listadonomina
    // Creación: 13/11/2020		última modificación: 26/05/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que imprime el informe de general de nómina de acuerdo al 
    //              tipo de salida que se seleccione en la opción “ventanadatos” 
    //              (vista, PDF o Excel)
    // Última modificación: Se corrigió la consulta para que no sumara en los descuentos 
    //                      las licencias no remuneradas y las suspensiones, en la salida 
    //                      tipo vista se incluyó el total en color rojo si el monto es 
    //                      negativo (25/11/2020)
    //                      Inclusión del filtro para el tipo de nómina de empleados o 
    //                      extralegal (27/11/2020)
    //                      Inclusión de páginas adicionales después de la uno y numeración 
    //                      de las mismas en la opción tipo PDF (11/12/2020)
    //                      Inclusión de la opción todos en el tipo de nómina (16/12/2020)
    //                      Se incorporó el campo de empleado activo en la nómina
    //                      (11/08/2021)
    //                      Se optimizó a consulta, en la salida html se reorganizaron las 
    //                      columnas, en la salida pdf se incorporaron nuevas longitudes a 
    //                      las cantidades y totales y en la salida a Excel se incluyeron 
    //                      los totales y se cambió en nombre de archivo xls
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion=="listadonomina")
    {
        $codigo  = $_POST['codigo'];            // Variable para filtrar el periodo        
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará
        $tiponomina = $_POST["tiponomina"];     // Variable para el tipo de nómina

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($codigo,'periodosnomina','codigo','descripcion');

        // Variable para el ID del periodo
        $periodoid  = $clase->BDLockup($codigo,'periodosnomina','codigo','periodoid');

        $vsql = "SELECT CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS totdevengado, 
                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS totdescuento,
                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS total
                   FROM detallenomina d
                        INNER JOIN terceros t ON (d.terid = t.terid)
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                  WHERE d.pernominaid = ".$periodoid;

        switch($tiponomina)
        {
            case 'empleados':
                $vsql.= " AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL)) ";
                break;
            case 'extralegal':
                $vsql.= " AND t.extralegal = 'CHECKED' ";
                break;
            case 'todos':
                $vsql.= " AND t.esempleadoactivo='CHECKED' ";
                break;
            default:
                break;
        }
        $vsql.= " GROUP BY t.terid";

        // ------------------------------------------------------------------------------------------------------------------------------------------ //
        // Muestra el informe en una vista del sistema
        if($tiposalida=="vista")
        {
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/informes.png" width="32" height="32" border="0"> </td>
                      <td width="840"> <b> Informe general de n&oacute;mina </b></td>
                      <td> &nbsp; </td>
                      <td width="8"> &nbsp; </td>
                     </tr>           
                    </table>';

            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="840"> <b> Periodo: </b> '.$descripcion.' <b>tipo:</b> '.strtoupper($tiponomina).' </td>
                      <td> &nbsp; </td>
                      <td width="8"> &nbsp; </td>
                     </tr>           
                    </table>';

            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                     <table width="100%" class="sortable">
                      <thead> 
                       <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                        <td width="27">&nbsp; </td>
                        <td width="335" align="left"> Nombre </td>
                        <td width="219"> &nbsp; </td>                        
                        <td width="296" align="right"> Total devengado </td>			                        
                        <td width="308" align="right"> Total descuento </td>                        
                        <td width="11"> &nbsp; </td>
                        <td width="80"> &nbsp; </td> 
                        <td width="222" align="right"> Neto a pagar </td>                      
                        <td width="40">&nbsp; </td>
                       </tr>
                      </thead>
                      <tbody style="display:block; width:1050px; height:400px; overflow-Y:scroll">';

            // Impresión del detalle del informe
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $total = 0;
            $totaldev = 0;
            $totaldesc = 0;
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';

                $cont.=' <td width="27">&nbsp; </td>
                         <td width="535" align="left">'.$row['nombreemp'].'</td>                         
                         <td width="336" align="right">'.number_format($row['totdevengado']).'</td>                          
                         <td width="330" align="right">'.number_format($row['totdescuento']).'</td>
                         <td width="90"> &nbsp; </td>';

                if($row['total']>=0)
                    $cont.='<td width="232" align="right">'.number_format($row['total']).' </td>';
                else
                    $cont.='<td width="232" align="right"> <font color="RED">'.number_format($row['total']).' </font> </td>';

                $cont.=' <td width="10"> &nbsp; </td>
                        </tr>';

                // Incremento los totales
                $totaldev += $row['totdevengado'];
                $totaldesc += $row['totdescuento'];
                $total += $row['total'];
            }

            $cont.=' </tbody>
                    </table>';

            // Impresión de los totales
            $cont.='<table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="20"> &nbsp; </td>
                      <td width="467"> <b> TOTALES</b></td>
                      <td width="120" align="right"> <font color="WHITE"> '.number_format($totaldev).' </font> </td>
                      <td width="100"> &nbsp; </td>
                      <td width="120" align="right"> <font color="WHITE"> '.number_format($totaldesc).' </font> </td>
                      <td width="80"> &nbsp; </td>
                      <td width="120" align="right"> <font color="WHITE"> '.number_format($total).' </font> </td>
                      <td width="30"> &nbsp; </td>
                     </tr>
                    </table>';            

            echo $cont.$clase->PiePagina();
        }

        // ------------------------------------------------------------------------------------------------------------------------------------------ //
        // Muestra el informe en formato PDF
        if($tiposalida=="pdf")
        {
            // Inicializo las variables
            $longitud = 0;
            $lineatotales = 0;
            $mesimp = "";
            $fechoraimp = "";
            $tipodc = "";
            $enc = "";
            $pie = "";

            // Traducción al español del mes que devuelve la función date()
            $mesimp = date('F');
            if($mesimp=="January")       $mesimp = "Enero";
            if($mesimp=="February")      $mesimp = "Febrero";
            if($mesimp=="March")         $mesimp = "Marzo";
            if($mesimp=="April")         $mesimp = "Abril";
            if($mesimp=="May")           $mesimp = "Mayo";
            if($mesimp=="June")          $mesimp = "Junio";
            if($mesimp=="July")          $mesimp = "Julio";
            if($mesimp=="August")        $mesimp = "Agosto";
            if($mesimp=="September")     $mesimp = "Septiembre";
            if($mesimp=="October")       $mesimp = "Octubre";
            if($mesimp=="November")      $mesimp = "Noviembre";
            if($mesimp=="December")      $mesimp = "Diciembre";            

            // Procedo a construir el encabezado del recibo
            ini_set("memory_limit","200M");
            require('lib/fpdf/fpdf.php');
            $pdf=new FPDF();
        
            // Página nueva
            $pdf->AddPage("");
            $pagina = 1;

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

            // Imprimo el encabezado del informe
            $x = 25;
            $y = 13;
            $pdf->SetFont('Arial','B',10);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x+124,$y,$fechoraimp);

            $pdf->SetFont('Arial','B',10);
            $pdf->Text($x,$y,$enc);
            $enc= "INFORME GENERAL DE NOMINA";
            $pdf->Text($x,$y+5,$enc);

            $enc= "PERIODO: ";
            $pdf->Text($x,$y+10,$enc);
            $pdf->SetFont('Arial','',10);
            $enc=strtoupper($descripcion);
            $pdf->Text($x+19,$y+10,$enc);

            $pdf->SetFont('Arial','B',10);
            $enc= "TIPO: ";
            $pdf->Text($x,$y+15,$enc);
            $pdf->SetFont('Arial','',10);
            $enc=strtoupper($tiponomina);
            $pdf->Text($x+12,$y+15,$enc);

            $pdf->SetFillColor(220,220,220);
            $pdf->Rect(5,33,200,8,'F');
            $pdf->SetFont('Arial','B',9);
            $enc= "EMPLEADO";
            $pdf->Text($x-17,$y+25,$enc);
            $enc= "DEVENGADO";
            $pdf->Text($x+70,$y+25,$enc);
            $enc= "DESCUENTO";
            $pdf->Text($x+110,$y+25,$enc);
            $enc= "NETO A PAGAR";
            $pdf->Text($x+152,$y+25,$enc);

            // Impresión del detalle del informe
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $total = 0;
            $x = 8;
            $y = 46;
            $i = 0;
            $totaldev = 0;
            $totaldesc = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%38==0)
                {
                    // Página nueva
                    $pdf->AddPage("");
                    $pagina++;

                    // Logo Dromedicas
                    $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                    // Imprimo el encabezado del informe
                    $x = 25;
                    $y = 13;
                    $pdf->SetFont('Arial','B',10);
                    $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                    $pdf->Text($x,$y,$enc);

                    // Fecha y hora de impresión
                    $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                    $pdf->SetFont('Arial','',8);
                    $pdf->Text($x+124,$y,$fechoraimp);

                    $pdf->SetFont('Arial','B',10);                    

                    $enc= "INFORME GENERAL DE NOMINA";
                    $pdf->Text($x,$y+5,$enc);

                    $enc= "PERIODO: ";
                    $pdf->Text($x,$y+10,$enc);
                    $pdf->SetFont('Arial','',10);
                    $enc=strtoupper($descripcion);
                    $pdf->Text($x+19,$y+10,$enc);

                    $pdf->SetFont('Arial','B',10);
                    $enc= "TIPO: ";
                    $pdf->Text($x,$y+15,$enc);
                    $pdf->SetFont('Arial','',10);
                    $enc=strtoupper($tiponomina);
                    $pdf->Text($x+12,$y+15,$enc);

                    $pdf->SetFillColor(220,220,220);
                    $pdf->Rect(5,33,200,8,'F');
                    $pdf->SetFont('Arial','B',9);
                    $enc= "EMPLEADO";
                    $pdf->Text($x-17,$y+25,$enc);
                    $enc= "DEVENGADO";
                    $pdf->Text($x+70,$y+25,$enc);
                    $enc= "DESCUENTO";
                    $pdf->Text($x+110,$y+25,$enc);
                    $enc= "NETO A PAGAR";
                    $pdf->Text($x+152,$y+25,$enc);

                    $x = 8;
                    $y = 46;        
                }

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x,$y,$row['nombreemp']);

                // Alineación de los montos correspondientes
                $longitud = strlen($row['totdevengado']);

                if($longitud==1)        $pdf->Text($x+106,$y,number_format($row['totdevengado']));
                if($longitud==2)        $pdf->Text($x+105,$y,number_format($row['totdevengado']));
                if($longitud==3)        $pdf->Text($x+103,$y,number_format($row['totdevengado']));
                if($longitud==4)        $pdf->Text($x+101,$y,number_format($row['totdevengado']));
                if($longitud==5)        $pdf->Text($x+99,$y,number_format($row['totdevengado']));
                if($longitud==6)        $pdf->Text($x+97,$y,number_format($row['totdevengado']));
                if($longitud==7)        $pdf->Text($x+95,$y,number_format($row['totdevengado']));

                $totaldev += $row['totdevengado'];

                // Alineación de los montos correspondientes
                $longitud = strlen($row['totdescuento']);

                if($longitud==1)        $pdf->Text($x+145,$y,number_format($row['totdescuento']));
                if($longitud==2)        $pdf->Text($x+144,$y,number_format($row['totdescuento']));
                if($longitud==3)        $pdf->Text($x+142,$y,number_format($row['totdescuento']));
                if($longitud==4)        $pdf->Text($x+140,$y,number_format($row['totdescuento']));
                if($longitud==5)        $pdf->Text($x+138,$y,number_format($row['totdescuento']));
                if($longitud==6)        $pdf->Text($x+136,$y,number_format($row['totdescuento']));

                $totaldesc += $row['totdescuento'];

                // Alineación de los montos correspondientes
                $longitud = strlen($row['total']);

                if($longitud==1)        $pdf->Text($x+192,$y,number_format($row['total']));
                if($longitud==2)        $pdf->Text($x+191,$y,number_format($row['total']));
                if($longitud==3)        $pdf->Text($x+189,$y,number_format($row['total']));
                if($longitud==4)        $pdf->Text($x+187,$y,number_format($row['total']));
                if($longitud==5)        $pdf->Text($x+185,$y,number_format($row['total']));
                if($longitud==6)        $pdf->Text($x+183,$y,number_format($row['total']));
                if($longitud==7)        $pdf->Text($x+181,$y,number_format($row['total']));

                $total += $row['total'];
                $y+=6;
            }

            // Impresión del pie de página del informe

            // Totales
            $lineatotales = $y;
            $pdf->SetFillColor(220,220,220);
            $pdf->Rect(5,$lineatotales,200,8,'F');

            $pdf->SetFont('Arial','B',10);
            $pie= "TOTALES: ";
            $pdf->Text($x,$y+5,$pie);

            // Alineación de los montos correspondientes
            $longitud = strlen(intval($totaldev));

            if($longitud==5)        $pdf->Text($x+96,$y+5,number_format($totaldev));
            if($longitud==6)        $pdf->Text($x+94,$y+5,number_format($totaldev));
            if($longitud==7)        $pdf->Text($x+92,$y+5,number_format($totaldev));
            if($longitud==8)        $pdf->Text($x+90,$y+5,number_format($totaldev));
            if($longitud==9)        $pdf->Text($x+88,$y+5,number_format($totaldev));
            if($longitud==10)       $pdf->Text($x+86,$y+5,number_format($totaldev));                

            $longitud = strlen(intval($totaldesc));
            
            if($longitud==5)        $pdf->Text($x+135,$y+5,number_format($totaldesc));
            if($longitud==6)        $pdf->Text($x+133,$y+5,number_format($totaldesc));
            if($longitud==7)        $pdf->Text($x+131,$y+5,number_format($totaldesc));
            if($longitud==8)        $pdf->Text($x+129,$y+5,number_format($totaldesc));
            if($longitud==9)        $pdf->Text($x+127,$y+5,number_format($totaldesc));
            if($longitud==10)       $pdf->Text($x+125,$y+5,number_format($totaldesc));

            $longitud = strlen(intval($total));

            if($longitud==5)        $pdf->Text($x+182,$y+5,number_format($total));
            if($longitud==6)        $pdf->Text($x+180,$y+5,number_format($total));
            if($longitud==7)        $pdf->Text($x+178,$y+5,number_format($total));
            if($longitud==8)        $pdf->Text($x+176,$y+5,number_format($total));
            if($longitud==9)        $pdf->Text($x+174,$y+5,number_format($total));
            if($longitud==10)       $pdf->Text($x+172,$y+5,number_format($total));
            
            $pdf->Output();
        }

        // ------------------------------------------------------------------------------------------------------------------------------------------ //
        // El informe es mostrado en una salida a Excel
        if($tiposalida=="excel")
        {
            require_once 'lib/PHPExcel.php';
            $clase = new Sistema();
            $clase->Conectar();
            ini_set("memory_limit","100M");
            
            // Preparación del entorno para la salida a Excel
            $clase = new Sistema();
            $clase->Nombredb = $_SESSION['DBNOMBRE'];
            error_reporting(E_ALL);
            ini_set('display_errors', TRUE);
            ini_set('display_startup_errors', TRUE);
            date_default_timezone_set('Europe/London');
        
            if (PHP_SAPI == 'cli')
                die('This example should only be run from a Web Browser');
        
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
        
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                         ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                         ->setTitle("Periodo por concepto - DROPOS")
                                         ->setSubject("Periodo por concepto - DROPOS")
                                         ->setDescription("Periodo por concepto - DROPOS")
                                         ->setKeywords("Periodo por concepto - DROPOS")
                                         ->setCategory("Categoria General");

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'INFORME GENERAL DE NOMINA')
                        ->setCellValue('A2', 'PERIODO: '.$descripcion)
                        ->setCellValue('A3', 'TIPO: '.strtoupper($tiponomina))
                        ->setCellValue('A4', 'EMPLEADO')
                        ->setCellValue('B4', 'DEVENGADO')
                        ->setCellValue('C4', 'DESCUENTO')
                        ->setCellValue('D4', 'TOTAL');
            
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant   = mysql_num_rows($result);
            $i=5;
            $totaldev = 0;
            $totaldesc = 0;
            $total = 0;
            while($row = mysql_fetch_array($result))
            {
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $row['nombreemp'])
                            ->setCellValue('B'.$i, number_format($row['totdevengado']))
                            ->setCellValue('C'.$i, number_format($row['totdescuento']))
                            ->setCellValue('D'.$i, number_format($row['total']));

                $totaldev += $row['totdevengado'];
                $totaldesc += $row['totdescuento'];
                $total += $row['total'];
                $i++;
            }

            $i--;
            $rangoEncabezado = 'A4:D4';
            $rangoCeldas     = 'A4:D'.($i);

            // Impresión de los totales
            $y = $i + 1;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$y, "TOTALES:")
                        ->setCellValue('B'.$y, number_format($totaldev))                        
                        ->setCellValue('C'.$y, number_format($totaldesc))
                        ->setCellValue('D'.$y, number_format($total));
            
            // Formato de Encabezado y Celdas
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
            
            $EstiloCeldas = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ),
                ),
            );
            $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
            /// Formato de Encabezados 
            $EstiloEncabezado = array(
            'font' => array(
                'bold' => true,
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
            ),
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ),
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'rotation' => 90,
                'startcolor' => array(
                    'argb' => '00FFFFCC',
                ),
                'endcolor' => array(
                    'argb' => 'FFFFFF',
                ),
                ),
            );
            $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('Informe general de nomina');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Redirect output to a client’s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            $nombrearcexcel = "informe general de nómina ".strtolower($descripcion).".xls";
            header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
            header('Cache-Control: max-age=0');
            /// Genero la Salida
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            exit;
        }
    }
?>