<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 17/02/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana con el filtro de periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo FROM periodos WHERE orden >= 99 ORDER BY orden";
        $vsqlcombosucursal = "SELECT codigo, descripcion FROM sucursales";
        $vsqlcombozona = "SELECT codzona, nombre FROM zonas ORDER BY codzona";

        $vsqlcomboregion = "SELECT codregion,CONCAT(nomcorto,' - REGION ',codregion) as nomcorto FROM regiones where codregion<>00 ORDER BY 1 ASC";                     
        $comboregion = $clase->CrearComboEsp("region",$vsqlcomboregion,"nomcorto","codregion","","S",$params);        
    
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/devoluciones.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Reporte de devoluciones </b><td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';

        $cont.='<form action="?opcion=infdevxper" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos">
                  <td align="center"><br><br><b> Detalle del informe <br><br></td>
                 </tr>
                </table>  
                <table width="100%">
                 <tr class="BarraDocumentos"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Periodo: </td>
                  <td width="120">';

        $cont.= $clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400);
                   
        $cont.='  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Sucursal: </td>
                  <td width="120">';

        $cont.= $clase->CrearComboBuscar("codigoini",$vsqlcombosucursal,"descripcion","codigo","","S",$params,300);

        $cont.='  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Zona: </td>
                  <td width="120">';
        
        $cont.= $clase->CrearComboBuscar("zona",$vsqlcombozona,"nombre","codzona","","S",$params,250);

        $cont.='  </td> 
                  <td width="180"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos"> 
                  <td width="220">  </td>
                  <td width="20"> Regi&oacute;n: </td>
                  <td width="120"> '.$comboregion.' </td>
                  <td width="220"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> &nbsp; </td>
                  <td width="120"> &nbsp; </td>
                  <td width="220"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20">  </td>
                  <td width="120" alling="center">
                   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                   <input type="submit" value="Generar Informe" class="button red">
                   </form>
                  </td>
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<table width="100%"> 
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
               </table>';                
        echo $cont;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infdevxper
    // Creación: 17/02/2022		última modificación: 21/02/2022
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que emite el informe con salida html de los motivos de las 
    //              devoluciones de periodo
    // Última modificación: Inclusión de los filtros del informe
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "infdevxper")
    {
        $codperiodo = $_POST['codperiodo'];
        $codigoini = $_POST['codigoini'];
        $region = $_POST['region'];
        $zona = $_POST['zona'];
        $desperiodo  = $clase->BDLockup($codperiodo,"periodos","codperiodo","desperiodo");
        $descripcion  = $clase->BDLockup($codigoini,"sucursales","sucursalid","descripcion");
        $nomregion  = $clase->BDLockup($region,"regiones","codregion","nomregion");
        $nombre  = $clase->BDLockup($zona,"zonas","codzona","nombre");

        // pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/devoluciones.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Reporte de devoluciones </b><br> Periodo: '.$desperiodo.'';
            
        if(strlen($codigoini)>0)        $cont.='<br> Sucursal '.$descripcion.'';
        if(strlen($region)>0)           $cont.='<br> Regi&oacute;n: '.$nomregion.'';
        if(strlen($zona)>0)             $cont.='<br> Zona: '.$nombre.'';
                  
        $cont.='  <td>
                  <td align="right"> 
                   <a href="?opcion=devxperpdf&codperiodo='.$codperiodo.'&codigoini='.$codigoini.'&region='.$region.'&zona='.$zona.'" target="_blank"> 
                    <img src="images/iconos/exportarpdf2.png" border="0"> 
                   </a> 
                  </td>
                  <td width="8"> &nbsp; </td>
                  <td width="10"> 
                   <a href="?opcion=devxperxls&codperiodo='.$codperiodo.'&codigoini='.$codigoini.'&region='.$region.'&zona='.$zona.'" target="_blank"> 
                    <img src="images/iconos/exportarexcel2.png" border="0"> 
                   </a> 
                  </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';

        // Consulta del informe
        if((strlen($codigoini) == 0) && (strlen($region) == 0) && (strlen($zona) == 0))
            $vsql = "SELECT M.desmotivo, ROUND(SUM(C.DECANTIDAD)) CANPRODUCTOS,  ROUND(SUM(C.DEVALTOTAL)) VALDEVOLUCIONES, M.codmotivo
                       FROM consolida1 C 
                            LEFT JOIN motivodevolucion M ON (C.OBSERVACION2 = M.codmotivo) 
                      WHERE C.TIPODOC = 'DVE' 
                            AND C.PERIODODOC = '".$codperiodo."'
                      GROUP BY 1
                   ORDER BY M.codmotivo ASC";
        else
        {
            $vsql = "SELECT M.desmotivo, ROUND(SUM(C.DECANTIDAD)) CANPRODUCTOS,  ROUND(SUM(C.DEVALTOTAL)) VALDEVOLUCIONES, M.codmotivo,
                            s.descripcion, z.nombre
                       FROM consolida1 C 
                            LEFT JOIN motivodevolucion M ON (C.OBSERVACION2 = M.codmotivo) 
                            INNER JOIN sucursales s ON (C.SUCURSALID = s.sucursalid)
                            INNER JOIN zonas z ON (s.zona = z.codzona)
                      WHERE C.TIPODOC = 'DVE' 
                            AND C.PERIODODOC = '".$codperiodo."'";

            if(strlen($codigoini)>0)
                $vsql.= " AND C.SUCURSALID = ".$codigoini." ";
            
            if(strlen($zona)>0)
                $vsql.= " AND z.codzona = ".$zona." ";

            if(strlen($region)>0)
                $vsql.= " AND z.codregion = ".$region." ";

            $vsql.= "GROUP BY 1
                     ORDER BY M.codmotivo ASC";
        }

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;"> 
                   <td width="30">&nbsp; </td>
                   <td width="368" align="left">Motivo </td>				 
                   <td width="164" align="left">Productos </td>
                   <td width="449" align="left">Total </td>
                   <td width="162" align="left">&nbsp; </td>
                   <td width="13" align="left">&nbsp; </td>   
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050; height:400px; overflow-Y:scroll">';

        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $motivo = $row['desmotivo'];
            $codmotivo = $row['codmotivo'];

            if($motivo == "")       $motivo = "NO ESPECIFICA";

            $cont.=' <td width="30">&nbsp; </td>
                     <td width="368" align="left"> 
                      <a href="?opcion=detallemotivo&codperiodo='.$codperiodo.'&codmotivo='.$codmotivo.'&codigoini='.$codigoini.'&region='.$region.'&zona='.$zona.'" target="_blank">'.$motivo.'</a>
                     </td>
                     <td width="164" align="left">'.number_format($row['CANPRODUCTOS']).'</td>
                     <td width="449" align="left">'.number_format($row['VALDEVOLUCIONES']).' </td>
                     <td width="162" align="left">&nbsp; </td>
                    </tr>';
        }

        $cont.=' </tbody> 
                </table>';

        echo $cont;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detallemotivo
    // Creación: 17/02/2022		última modificación: 21/02/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Salida en pdf del detalle de cada motivo de las devoluciones    
    // Última modificación: Inclusión de los filtros del informe
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "detallemotivo")
    {
        $codperiodo = $_GET['codperiodo'];
        $codmotivo = $_GET['codmotivo'];
        $codigoini = $_GET['codigoini'];
        $region = $_GET['region'];
        $zona = $_GET['zona'];

        $desperiodo  = $clase->BDLockup($codperiodo,"periodos","codperiodo","desperiodo");
        $desmotivo  = $clase->BDLockup($codmotivo,"motivodevolucion","codmotivo","desmotivo");

        $desperiodo  = $clase->BDLockup($codperiodo,"periodos","codperiodo","desperiodo");
        $descripcion  = $clase->BDLockup($codigoini,"sucursales","sucursalid","descripcion");
        $nomregion  = $clase->BDLockup($region,"regiones","codregion","nomregion");
        $nombre  = $clase->BDLockup($zona,"zonas","codzona","nombre");        

        if($desmotivo == "")        $desmotivo = "NO ESPECIFICA";

        // Filtros del informe
        if((strlen($codigoini)>0) || (strlen($region)>0) || (strlen($zona)>0))
        {
            $filtro = "FILTRADO POR ";
            if(strlen($codigoini)>0)        $filtro.= "Sucursal: ".$descripcion." ";
            if(strlen($region)>0)           $filtro.= "Region: ".$nomregion." ";
            if(strlen($zona)>0)             $filtro.= "Zona: ".$nombre;
        }
        else
            $filtro = "";        

        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        $clase = new Sistema();
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf = new FPDF('L','mm','legal');

        $pdf->AddPage("");

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

        $x = 35;
        $y = 15;
        $pagina = 1;

        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+250,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "REPORTE DE DEVOLUCIONES";
        $pdf->Text($x,$y+7,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "PERIODO: ".$desperiodo;
        $pdf->Text($x,$y+14,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "MOTIVO: ".$desmotivo;
        $pdf->Text($x,$y+21,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= $filtro;
        $pdf->Text($x,$y+27,$enc);

        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(7,$y+28,340,8,'F');

        $enc= "PREFIJO";
        $pdf->Text(10,$y+33,$enc);

        $enc= "DOCUMENTO";
        $pdf->Text(28,$y+33,$enc);

        $enc= "DIA OPE";
        $pdf->Text(54,$y+33,$enc);

        $enc= "CLIENTE";
        $pdf->Text(76,$y+33,$enc);

        $enc= "CODVENDE";
        $pdf->Text(140,$y+33,$enc);

        $enc= "VENDEDOR";
        $pdf->Text(163,$y+33,$enc);

        $enc= "CAJAS";
        $pdf->Text(220,$y+33,$enc);

        $enc= "UNIDS";
        $pdf->Text(235,$y+33,$enc);

        $enc= "PRODUCTO";
        $pdf->Text(248,$y+33,$enc);

        // consulta del detalle
        $vsql = "SELECT C.TIPODOC, C.PREFIJODOC, C.NUMERODOC, C.DDDIAOPE, C.NOMBRESCLIDOC, C.APECLIDOC, C.CODVENDOC, C.NOMVENDOC, 
                        C.APEVENDOC, C.DEUNICOM cajas, C.DEUNIFRA unidades, C.NOMPRODUCTO
                   FROM consolida1 C 
                  WHERE C.TIPODOC = 'DVE' 
                        AND C.PERIODODOC = '".$codperiodo."' 
                        AND C.OBSERVACION2 = '".$codmotivo."'";

        $x = 10;
        $y = 56;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            $pdf->SetFont('Arial','',10);
            
            $pdf->Text($x,$y,$row['PREFIJODOC']);
            $pdf->Text($x+18,$y,$row['NUMERODOC']);
            $pdf->Text($x+44,$y,$row['DDDIAOPE']);

            $nombcliente = $row['NOMBRESCLIDOC'].' '.$row['APECLIDOC'];
            $pdf->Text($x+66,$y,substr(strtoupper($nombcliente),0,29));

            $longitud = strlen($row['CODVENDOC']);
            if($longitud==3)    $pdf->Text($x+136,$y,$row['CODVENDOC']);
            if($longitud==4)    $pdf->Text($x+135,$y,$row['CODVENDOC']);

            $nombvendedor = $row['NOMVENDOC'].' '.$row['APEVENDOC'];
            $pdf->Text($x+153,$y,substr(strtoupper($nombvendedor),0,25));

            $pdf->Text($x+215,$y,$row['cajas']);
            $pdf->Text($x+230,$y,$row['unidades']);
            $pdf->Text($x+238,$y,substr($row['NOMPRODUCTO'],0,46));

            $y+=6;

            if($i%25 == 0)
            {
                $pdf->AddPage("");

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                $x = 35;
                $y = 15;
                $pagina++;
                
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);
        
                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
        
                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+250,$y,$fechoraimp);
        
                $pdf->SetFont('Arial','B',10);
                $enc= "REPORTE DE DEVOLUCIONES";
                $pdf->Text($x,$y+7,$enc);
        
                $pdf->SetFont('Arial','B',10);
                $enc= "PERIODO: ".$desperiodo;
                $pdf->Text($x,$y+14,$enc);
        
                $pdf->SetFont('Arial','B',10);
                $enc= "MOTIVO: ".$desmotivo;
                $pdf->Text($x,$y+21,$enc);

                $pdf->SetFont('Arial','B',10);
                $enc= $filtro;
                $pdf->Text($x,$y+27,$enc);                
        
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,$y+28,340,8,'F');
        
                $enc= "PREFIJO";
                $pdf->Text(10,$y+33,$enc);
        
                $enc= "DOCUMENTO";
                $pdf->Text(28,$y+33,$enc);
        
                $enc= "DIA OPE";
                $pdf->Text(54,$y+33,$enc);
        
                $enc= "CLIENTE";
                $pdf->Text(76,$y+33,$enc);
        
                $enc= "CODVENDE";
                $pdf->Text(140,$y+33,$enc);
        
                $enc= "VENDEDOR";
                $pdf->Text(163,$y+33,$enc);
        
                $enc= "CAJAS";
                $pdf->Text(220,$y+33,$enc);
        
                $enc= "UNIDS";
                $pdf->Text(235,$y+33,$enc);
        
                $enc= "PRODUCTO";
                $pdf->Text(248,$y+33,$enc);
                
                $x = 10;
                $y = 56;                
            }
        }
        
        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: devxperpdf
    // Creación: 18/02/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que genera la salida en formato PDF de las devoluciones de un 
    //              periodo
    // Última modificación: Inclusión de los filtros del informe
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "devxperpdf")
    {
        $codperiodo = $_GET['codperiodo'];
        $codigoini = $_GET['codigoini'];
        $region = $_GET['region'];
        $zona = $_GET['zona'];
        $desperiodo  = $clase->BDLockup($codperiodo,"periodos","codperiodo","desperiodo");
        $descripcion  = $clase->BDLockup($codigoini,"sucursales","sucursalid","descripcion");
        $nomregion  = $clase->BDLockup($region,"regiones","codregion","nomregion");
        $nombre  = $clase->BDLockup($zona,"zonas","codzona","nombre");

        // Filtros del informe
        if((strlen($codigoini)>0) || (strlen($region)>0) || (strlen($zona)>0))
        {
            $filtro = "FILTRADO POR ";
            if(strlen($codigoini)>0)        $filtro.= "Sucursal: ".$descripcion." ";
            if(strlen($region)>0)           $filtro.= "Region: ".$nomregion." ";
            if(strlen($zona)>0)             $filtro.= "Zona: ".$nombre;
        }
        else
            $filtro = "";        

        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        $clase = new Sistema();
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();

        $pdf->AddPage("");

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

        $x = 35;
        $y = 15;
        $pagina = 1;

        // titulo del informe
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+110,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "REPORTE DE DEVOLUCIONES";
        $pdf->Text($x,$y+7,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "PERIODO: ".$desperiodo;
        $pdf->Text($x,$y+14,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= $filtro;
        $pdf->Text($x,$y+21,$enc);

        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(7,$y+28,195,8,'F');

        $enc= "MOTIVO";
        $pdf->Text(9,$y+33,$enc);

        $enc= "PRODUCTOS";
        $pdf->Text(90,$y+33,$enc);

        $enc= "TOTAL";
        $pdf->Text(187,$y+33,$enc);

        // Consulta del informe
        if((strlen($codigoini) == 0) && (strlen($region) == 0) && (strlen($zona) == 0))
            $vsql = "SELECT M.desmotivo, ROUND(SUM(C.DECANTIDAD)) CANPRODUCTOS,  ROUND(SUM(C.DEVALTOTAL)) VALDEVOLUCIONES, M.codmotivo
                       FROM consolida1 C 
                            LEFT JOIN motivodevolucion M ON (C.OBSERVACION2 = M.codmotivo) 
                      WHERE C.TIPODOC = 'DVE' 
                            AND C.PERIODODOC = '".$codperiodo."'
                      GROUP BY 1
                   ORDER BY M.codmotivo ASC";
        else
        {
            $vsql = "SELECT M.desmotivo, ROUND(SUM(C.DECANTIDAD)) CANPRODUCTOS,  ROUND(SUM(C.DEVALTOTAL)) VALDEVOLUCIONES, M.codmotivo,
                            s.descripcion, z.nombre
                       FROM consolida1 C 
                            LEFT JOIN motivodevolucion M ON (C.OBSERVACION2 = M.codmotivo) 
                            INNER JOIN sucursales s ON (C.SUCURSALID = s.sucursalid)
                            INNER JOIN zonas z ON (s.zona = z.codzona)
                      WHERE C.TIPODOC = 'DVE' 
                            AND C.PERIODODOC = '".$codperiodo."'";

            if(strlen($codigoini)>0)
                $vsql.= " AND C.SUCURSALID = ".$codigoini." ";
            
            if(strlen($zona)>0)
                $vsql.= " AND z.codzona = ".$zona." ";

            if(strlen($region)>0)
                $vsql.= " AND z.codregion = ".$region." ";

            $vsql.= "GROUP BY 1
                     ORDER BY M.codmotivo ASC";
        }
        
        $x = 5;
        $y = 56;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            $pdf->SetFont('Arial','',10);

            $motivo = $row['desmotivo'];
            if($motivo == "")       $motivo = "NO ESPECIFICA";
            
            $pdf->Text($x+4,$y,$motivo);

            $longitud = strlen($row['CANPRODUCTOS']);
            if($longitud==1)    $pdf->Text($x+105,$y,number_format($row['CANPRODUCTOS']));
            if($longitud==2)    $pdf->Text($x+103,$y,number_format($row['CANPRODUCTOS']));
            if($longitud==3)    $pdf->Text($x+101,$y,number_format($row['CANPRODUCTOS']));
            if($longitud==4)    $pdf->Text($x+99,$y,number_format($row['CANPRODUCTOS']));
            if($longitud==5)    $pdf->Text($x+97,$y,number_format($row['CANPRODUCTOS']));

            $longitud = strlen($row['VALDEVOLUCIONES']);
            if($longitud==1)    $pdf->Text($x+192,$y,number_format($row['VALDEVOLUCIONES']));
            if($longitud==2)    $pdf->Text($x+190,$y,number_format($row['VALDEVOLUCIONES']));
            if($longitud==3)    $pdf->Text($x+188,$y,number_format($row['VALDEVOLUCIONES']));
            if($longitud==4)    $pdf->Text($x+186,$y,number_format($row['VALDEVOLUCIONES']));
            if($longitud==5)    $pdf->Text($x+184,$y,number_format($row['VALDEVOLUCIONES']));
            if($longitud==6)    $pdf->Text($x+182,$y,number_format($row['VALDEVOLUCIONES']));
            if($longitud==7)    $pdf->Text($x+179,$y,number_format($row['VALDEVOLUCIONES']));
            if($longitud==8)    $pdf->Text($x+177,$y,number_format($row['VALDEVOLUCIONES']));

            $y+=6;

            // salto de página
            if($i%35 == 0)
            {
                $pdf->AddPage("");

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                $x = 35;
                $y = 15;
                $pagina++;

                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+110,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "REPORTE DE DEVOLUCIONES";
                $pdf->Text($x,$y+7,$enc);
        
                $pdf->SetFont('Arial','B',10);
                $enc= "PERIODO: ".$desperiodo;
                $pdf->Text($x,$y+14,$enc);

                $pdf->SetFont('Arial','B',10);
                $enc= $filtro;
                $pdf->Text($x,$y+21,$enc);                
        
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,$y+28,195,8,'F');
        
                $enc= "MOTIVO";
                $pdf->Text(9,$y+33,$enc);
        
                $enc= "PRODUCTOS";
                $pdf->Text(90,$y+33,$enc);
        
                $enc= "TOTAL";
                $pdf->Text(187,$y+33,$enc);

                $x = 5;
                $y = 56;
            }
        }

        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: devxperxls
    // Creación: 18/02/2022		última modificación: 21/02/2022
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que genera la salida a Excel de las devoluciones de un periodo
    // Última modificación: Inclusión de los filtros del informe
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "devxperxls")
    {
        $codperiodo = $_GET['codperiodo'];
        $codigoini = $_GET['codigoini'];
        $region = $_GET['region'];
        $zona = $_GET['zona'];
        $desperiodo  = $clase->BDLockup($codperiodo,"periodos","codperiodo","desperiodo");
        $descripcion  = $clase->BDLockup($codigoini,"sucursales","sucursalid","descripcion");
        $nomregion  = $clase->BDLockup($region,"regiones","codregion","nomregion");
        $nombre  = $clase->BDLockup($zona,"zonas","codzona","nombre");

        // Filtros del informe
        if((strlen($codigoini)>0) || (strlen($region)>0) || (strlen($zona)>0))
        {
            $filtro = "FILTRADO POR ";
            if(strlen($codigoini)>0)        $filtro.= "Sucursal: ".$descripcion." ";
            if(strlen($region)>0)           $filtro.= "Región: ".$nomregion." ";
            if(strlen($zona)>0)             $filtro.= "Zona: ".$nombre;
        }
        else
            $filtro = "";

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Reporte de devoluciones - DROPOS")
                                     ->setSubject("Reporte de devoluciones - DROPOS")
                                     ->setDescription("Reporte de devoluciones - DROPOS")
                                     ->setKeywords("Reporte de devoluciones - DROPOS")
                                     ->setCategory("Categoria General");

        // encabezado
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'REPORTE DE DEVOLUCIONES')
                    ->setCellValue('A2', 'PERIODO: '.strtoupper($desperiodo))
                    ->setCellValue('A3', $filtro)
                    ->setCellValue('A4', 'MOTIVO')
                    ->setCellValue('B4', 'PRODUCTOS')
                    ->setCellValue('C4', 'TOTAL');        

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);        
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);

        // Consulta del informe
        if((strlen($codigoini) == 0) && (strlen($region) == 0) && (strlen($zona) == 0))
            $vsql = "SELECT M.desmotivo, ROUND(SUM(C.DECANTIDAD)) CANPRODUCTOS,  ROUND(SUM(C.DEVALTOTAL)) VALDEVOLUCIONES, M.codmotivo
                       FROM consolida1 C 
                            LEFT JOIN motivodevolucion M ON (C.OBSERVACION2 = M.codmotivo) 
                      WHERE C.TIPODOC = 'DVE' 
                            AND C.PERIODODOC = '".$codperiodo."'
                      GROUP BY 1
                   ORDER BY M.codmotivo ASC";
        else
        {
            $vsql = "SELECT M.desmotivo, ROUND(SUM(C.DECANTIDAD)) CANPRODUCTOS,  ROUND(SUM(C.DEVALTOTAL)) VALDEVOLUCIONES, M.codmotivo,
                            s.descripcion, z.nombre
                       FROM consolida1 C 
                            LEFT JOIN motivodevolucion M ON (C.OBSERVACION2 = M.codmotivo) 
                            INNER JOIN sucursales s ON (C.SUCURSALID = s.sucursalid)
                            INNER JOIN zonas z ON (s.zona = z.codzona)
                      WHERE C.TIPODOC = 'DVE' 
                            AND C.PERIODODOC = '".$codperiodo."'";

            if(strlen($codigoini)>0)
                $vsql.= " AND C.SUCURSALID = ".$codigoini." ";
            
            if(strlen($zona)>0)
                $vsql.= " AND z.codzona = ".$zona." ";

            if(strlen($region)>0)
                $vsql.= " AND z.codregion = ".$region." ";

            $vsql.= "GROUP BY 1
                     ORDER BY M.codmotivo ASC";
        }

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);                
        $i = 5;

        // Detalle del informe
        while($row = mysql_fetch_array($result))
        {
            $motivo = $row['desmotivo'];
            if($motivo == "")       $motivo = "NO ESPECIFICA";

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $motivo)
                        ->setCellValue('B'.$i, number_format($row['CANPRODUCTOS']))
                        ->setCellValue('C'.$i, number_format($row['VALDEVOLUCIONES']));            
            $i++;
        }

        $rangoEncabezado = 'A4:C4';
        $rangoCeldas     = 'A4:C'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //                
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('reporte de devoluciones');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        // header('Content-Disposition: attachment;filename="planillanom.xls"');
        $nombrearcexcel = "reporte de devoluciones ".strtolower($desperiodo).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }
?>