<?php
//echo"Aqui"; exit;
    error_reporting(E_ALL);
    ini_set('display_errors', true);
    ini_set('display_startup_errors', true);
// =======================================
//  Configuración
// =======================================

// URL del WSDL del servicio
$wsdl = "https://app4.comfiar.co/ws/WSComfiar.asmx?WSDL";

// Credenciales para iniciar sesión
$usuarioId = "wsdromedicas";
$password  = "Eks$184184";

// CUIT para consultar el semáforo
$cuitId = 900265730;

// =======================================
//  Crear cliente SOAP
// =======================================

$client = new SoapClient(
    $wsdl,
    array(
        'trace' => 1,
        'exceptions' => 1,
        'cache_wsdl' => WSDL_CACHE_NONE
    )
);

try {

    echo "============================================\n";
    echo "1) INVOCANDO IniciarSesion\n";
    echo "============================================\n";

    // --- Llamada a IniciarSesion ---
    $loginParams = array(
        "usuarioId" => $usuarioId,
        "password"  => $password
    );

    $loginResponse = $client->IniciarSesion($loginParams);

    // El resultado es un TokenWS
    $token = $loginResponse->IniciarSesionResult;

    echo "SesionId: " . $token->SesionId . "\n";
    echo "FechaVencimiento: " . $token->FechaVencimiento . "\n\n";


    echo "============================================\n";
    echo "2) INVOCANDO EstadoSemaforo\n";
    echo "============================================\n";

    // --- Llamada a EstadoSemaforo ---
    $paramsSem = array(
        "cuitId" => $cuitId,
        "token" => array(
            "SesionId" => $token->SesionId,
            "FechaVencimiento" => $token->FechaVencimiento
        )
    );

    $respSem = $client->EstadoSemaforo($paramsSem);

    echo "Resultado EstadoSemaforo: " . $respSem->EstadoSemaforoResult . "\n\n";


} catch (SoapFault $fault) {

    echo "\n============================================\n";
    echo "❌ ERROR SOAP\n";
    echo "============================================\n";
    echo "Mensaje: " . $fault->getMessage() . "\n";

    echo "\n--- REQUEST ---\n";
    echo $client->__getLastRequest() . "\n";

    echo "\n--- RESPONSE ---\n";
    echo $client->__getLastResponse() . "\n";
}

?>
