<?PHP
    @session_start();
    include("lib/Sistema.php");

	require_once("classes/class_validaciones.php");         // Clase para la validación de las fechas
	$io_fecha=new class_validaciones();
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 17/01/2024		última modificación: 27/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la venta principal del formulario
    // Última modificación: Nuevo campo sucursal, validación de los botones de ver errores 
    //                      y limpiar y casilla de verificación para eliminar registros 
    //                      masivamente
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
		// consulta del formulario
		if($_SESSION['SQL_PROEXCLROTA'] == "")
			$vsql = "SELECT per.excluidosid, p.codigo, p.descripcion, per.fecdesde, per.fechasta, s.descripcion sucursal 
                       FROM productosexcluidosrotacion per 
                            INNER JOIN productos p ON (per.productoid = p.productoid)
                            INNER JOIN sucursales s ON (per.sucursalid = s.sucursalid)
                   ORDER BY p.codigo, sucursal";
		else
			$vsql = $_SESSION['SQL_PROEXCLROTA'];

		// inicializo las variables
        $det = '';
		$pie.=' </tbody>
			   </table>';

        // valido que el archivo de mostrar errores exista
        $archivoerror = "reportes/erroresexcluidos.txt";
        if (file_exists ($archivoerror))
            $htmlarchivoerror = '<a href="?opcion=vererrores" rel="facebox">
                                  <img src="images/iconos/notas.png" border="0" width="38" height="38" title="c&oacute;digos de productos no guardados en el &uacute;ltimo proceso de importaci&oacute;n">
                                 </a>';
        else
            $htmlarchivoerror = '<img src="images/iconos/notas.png" border="0" width="38" height="38" title="c&oacute;digos de productos no guardados en el &uacute;ltimo proceso de importaci&oacute;n">';

        // Validación del botón de limpiar lista de productos excluidos de rotación
        $vsql32 = "SELECT COUNT(*) numprodexcl FROM productosexcluidosrotacion";
        $numprodexcl = $clase->SeleccionarUno($vsql32);

        if($numprodexcl > 0)
            $htmllimpiar = ' <a href="?opcion=confirmarlimpiar" rel="facebox">
                              <img src="images/iconos/anulardoc.png" border="0" width="38" height="38" title="limpiar toda la lista de productos excluidos de rotaci&oacute;n">
                             </a>';
        else
            $htmllimpiar = '<img src="images/iconos/anulardoc.png" border="0" width="38" height="38" title="limpiar toda la lista de productos excluidos de rotaci&oacute;n">';

		// pinto la ventana
		$enc =  $clase->HeaderBlanco("Consumos Almacenados");
		$enc.=' <table width="1300">
		         <tr class="CabezoteTabla"> 
		          <td width="10"> &nbsp; </td>
		          <td width="37"> <img src="images/iconos/cuotas.png" width="32" height="32" border="0"> </td>
		          <td width="870"> <b> Productos excluidos de rotaci&oacute;n </b> </td>
                  <form action="?opcion=encontrar" method="POST" name="x">
                  <td> <input type="text" name="criterio" size="12" style="width:250px;height:25px" placeholder="c&oacute;digo o nombre del producto a buscar" tabindex="1" id="default"> </td>
				  <td width="5"> &nbsp; </td>
                  <td> <input type="submit" value="buscar" class="button"> </form> </td>';

		if($_SESSION['SQL_PROEXCLROTA'] != "")
		   $enc.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/iconos/devoluciones.png" width="32" height="32" border="0" title="anular &uacute;ltima b&uacute;squeda"> </a> </td>';        

		$enc.='   <td width="10"> &nbsp; </td>
                  <td width="30">
                   <a href="?opcion=ventananuevoexcluido" rel="facebox">
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="incluir un nuevo registro"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
		          <td width="30">
		           <a href="?opcion=importarexcel1" rel="facebox">
		            <img src="images/iconos/cargar.png" width="34" height="34" border="0" title="importar productos desde una hoja de Excel">
		           </a>
		          </td>
		          <td width="10"> &nbsp; </td>
				  <td width="30"> 
				   '.$htmlarchivoerror.'
				  </td>
		          <td width="10"> &nbsp; </td>
				  <td width="30"> 
                   '.$htmllimpiar.'
				  </td>
				  <td width="10"> &nbsp; </td>
		          <td width="50" align="center"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td> 
		          <td width="8"> &nbsp; </td>
		         </tr>
	            </table>
                <script language="javascript">
                <!--
                    function seleccionar_todo()
                    { 
                        valor = document.f2.todos.checked;
                        if(valor)
                            marcartodo();
                        else
                            desmarcartodo();
                    } 

                    function marcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox")  
                           document.f2.elements[i].checked = 1;
                    }

                    function desmarcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                         if(document.f2.elements[i].type == "checkbox") 
                          document.f2.elements[i].checked = 0;
                    }
                -->
                </script>
                <script type="text/javascript" src="lib/sorttable.js"></script>
                <form action="?opcion=eliminarexcluidos" method="POST" name="f2">
	            <table id="fixTableV" class="sortable">
		         <tr class="TituloTabla">
		          <th width="40"> # </th>
		          <th width="120"> C&oacute;digo </th>
		          <th width="470"> Producto </th>
		          <th width="90"> Fecha desde </th>
		          <th width="90"> Fecha hasta </th>
                  <th width="110"> Sucursal </th>                  
                  <th width="30"> &nbsp; </th>
                  <th width="30"> &nbsp; </th>
                  <th width="30"> <input type="checkbox" name="todos" value="S" style="width:18px;height:20px;" onClick="javascript:seleccionar_todo();"> </th>
		         </tr>';

        // impresión del detalle
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $det.='<tr class="TablaDocsPar">';
            else
                $det.='<tr class="TablaDocsImPar">';

			$xdesde  = substr($row['fecdesde'],8,2)."/".substr($row['fecdesde'],5,2)."/".substr($row['fecdesde'],0,4);
			$xhasta  = substr($row['fechasta'],8,2)."/".substr($row['fechasta'],5,2)."/".substr($row['fechasta'],0,4);
			
            $det.=' <td align="center"> '.$i.' </td>
                     <td align="center"> '.$row['codigo'].' </td>
                     <td align="center"> '.$row['descripcion'].' </td>
                     <td align="center"> '.$xdesde.' </td>
                     <td align="center"> '.$xhasta.' </td>
                     <td align="center"> '.$row['sucursal'].' </td>
                     <td align="center"> 
					  <a href="?opcion=confirmareliminar&excluidosid='.$row['excluidosid'].'" rel="facebox">
					   <img src="images/basicas/iconoborrar.png" title="eliminar producto excluido" border="0" width="20" height="20">
					  </a>
					 </td>
                     <td align="center">
					  <a href="?opcion=editarexluido&excluidosid='.$row['excluidosid'].'" rel="facebox"> 
					   <img src="images/basicas/iconobuscar.png" title="editar producto excluido" border="0" width="20" height="20"> 
					  </a> 
					 </td>
                     <td align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['excluidosid'].'" style="width:18px;height:20px;" value="S"> </td>
                    </tr>';
        }

		$totales = '<table width="100%"> 
		             <tr class="TituloTabla"> 
					  <td width="20"> &nbsp; </td> 
					  <td width="1588"> <font color="white"> <b> Total productos excluidos: '.number_format($i).' </b> </font> </td> 
					 </tr>
					</table>
                    <br>
                    <table width="100%"> 
                     <tr class="TablaDocsImPar">
                      <td width="1600" align="right"> <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="eliminar"> </a> </form> </td> 
                      <td width="8"> &nbsp; </td> 
                     </tr>
                    </table>';

		// Construyo el contenido del formulario
        $cont = $enc.$det.$pie.$totales;

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventananuevoexcluido
    // Creación: 17/01/2024		última modificación: 26/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para los datos de un nuevo producto excluido
    // Última modificación: Inclusión del combo para la droguería y la casilla de 
    //                      verificación para todas las droguerías
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventananuevoexcluido")
    {
        // Inicialización de variables
        $fecdesde = date('Y-m-01');
        $fechasta = date("Y-m-t", strtotime(date('Y-m-d')));
        $todassuc = "";

        // combo de sucursales
        $params = ' class="Texto11" ';
        $vsqlcombosucursal = "SELECT sucursalid , descripcion FROM sucursales WHERE 1 ORDER BY descripcion ASC";
        $combosucursales = $clase->CrearComboBuscar("sucursalid",$vsqlcombosucursal,"descripcion","sucursalid","","n",$params,300);

		// pinto la ventana
		$cont ='<table width="400">
				 <tr class="CabezoteTabla">
				  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
				  <td width="350" align="center"> <b>Incluir Producto</b> <br> </td>
				 </tr> 
				</table>
				<form action="?opcion=guardarnewexclusion" method="POST" name="x">
				<table width="400">
				 <center><br>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"><label class="Texto12"> Producto: </label>&nbsp;</td>
				  <td width="300">				   
                   <!-- ************************************************************************************************ -->
                   <!-- AJAX AUTOSUGGEST SCRIPT -->
                   <script type="text/javascript" src="lib/ajax_framework8.js"></script>
                   <style type="text/css">
                   #search-wrap8 input{font-size:12px; text-transform:Capitalize; background-color:#D6F0FE; border-style:groove;}
                   #res8{width:195px; border:solid 1px #DEDEDE; display:none;}
                   #res8 ul, #res8 li{padding:0; margin:0; border:0; list-style:none; background:#F6F6F6;}
                   #res8 li {border-top:solid 1px #DEDEDE; background:#CEEAF5;}
                   #res8 li a{display:block; padding:2px; text-decoration:none; color:#000000; font-weight:bold; font-size:10px; font-family:Verdana;}
                   #res8 li a small{display:block; text-decoration:none; color:#999999; font-weight:normal; font-size:9px;font-family:Verdana;}
                   #res8 li a:hover{background:#FFFFFF;}
                   #res8 ul {padding:4px;}
                   </style>
                   <div id="search-wrap8">
                   <input name="producto" autocomplete="off" onkeypress="return TabulaEnter(this, event)" id="search-q8" type="text" onkeyup="javascript:autosuggest8();" maxlength="33" size="33" autocomplete="off" tabindex="1"/>
                   <div id="res8"></div>
                   </div>
                   <!-- AJAX AUTOSUGGEST SCRIPT -->
                   <!-- ************************************************************************************************ -->
				  </td>
				 </tr>	
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"><label class="Texto12"> Fecha desde: </label>&nbsp; </td>
				  <td width="300">
                   <input type="date" name="fecdesde" size="30" style="width:116px;height:25px" tabindex="1" id="default" value="'.$fecdesde.'">
				  </td>
				 </tr>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"><label class="Texto12"> Fecha hasta: </label>&nbsp; </td>
				  <td width="300">
				   <input type="date" name="fechasta" size="30" style="width:116px;height:25px" tabindex="1" id="default" value="'.$fechasta.'">
				  </td>
				 </tr>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"><label class="Texto12"> Sucursal: </label>&nbsp; </td>
				  <td width="300"> '.$combosucursales.' </td>
				 </tr>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"> &nbsp; </td>
				  <td width="300"> 
                   <input type="checkbox" value="CHECKED" name="todassuc" id="todassuc" class="Texto11" style="width:18px;height:20px" '.$todassuc.'> <label class="Texto12"> todas las sucursales </label> 
                  </td>
				 </tr>
				</table>
				<br>
				<center>
				<input type="submit" value="aceptar" class="button blue">
				<a href="productosexcluidosrotacion.php"><input type="button" value="CANCELAR" class="button red"></a>
				</form><br>';
		echo $cont;
		exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnewexclusion
    // Creación: 18/01/2024		última modificación: 26/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que almacena un nuevo producto excluido
    // Última modificación: Almacenamiento del campo para la droguería y llamado a la 
    //                      función para grabar el producto en todas las droguerías
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnewexclusion")
    {
        $producto = $_POST['producto'];
		$fecdesde = $_POST['fecdesde'];
		$fechasta = $_POST['fechasta'];
        $sucursalid = $_POST['sucursalid'];
        $todassuc = $_POST['todassuc'];

		// Inicialización de variable
		$valproducto = 0;
        $drogincluidas = 0;
        $descripcionprod = $clase->BDLockup($productoid,'productos','productoid','descripcion');

		// Valido que todos los datos estén llenos
		if((strlen($producto) == 0) || (strlen($fecdesde) == 0) || (strlen($fechasta) == 0))
		{
			echo'<SCRIPT languague="javascript">
				 <!--
					alert("Se deben llenar todos los datos");
					window.history.back();
				 -->
				 </SCRIPT>';
			exit;
		}
		else
		{
			// obtengo el id del producto
			$productoid = $clase->BDLockup($producto,'productos','codigo','productoid');

			if(strlen($productoid) == 0)
			{
				echo'<SCRIPT languague="javascript">
					 <!--
						alert("Producto no existe");
						window.history.back();
					 -->
					 </SCRIPT>';
		  		exit;
			}
			else
			{
				// Valido que el producto no esté incluido ya en esa sucursal
				$vsql2 = "SELECT COUNT($productoid) AS valproducto FROM productosexcluidosrotacion WHERE productoid = ".$productoid." AND sucursalid = ".$sucursalid;
				$valproducto = $clase->SeleccionarUno($vsql2);
				
				if($valproducto > 0)
				{
                    $descripcionsuc = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');

					echo'<SCRIPT languague="javascript">
						 <!--
							alert("'.$descripcionprod.' ya está excluido de rotación en la "'.$descripcionsuc.'");
							window.history.back();
						 -->
						 </SCRIPT>';
					exit;
				}
				else
				{
                    // Valido que la fecha desde sea menor a la fecha hasta
                    $lb_valido = false;
                    $lb_valido=$io_fecha->uf_comparar_fecha($fecdesde,$fechasta);   // llamado a la función de validación de las fechas

                    if(!$lb_valido)	
                    {
                        echo'<SCRIPT languague="javascript">
                                <!--
                                alert("La fecha hasta debe ser mayor a la fecha desde");
                                window.history.back();
                                -->
                                </SCRIPT>';
                        exit;
                    }
                    else
                    {
                        // Determino si se grabará una droguería o una sola
                        if($todassuc == "CHECKED")
                        {
                            // llamado a la función que guarda en todas las droguerías
                            $drogincluidas = todaslasdroguerias($productoid,$fecdesde,$fechasta);
    
                            // mensaje correspondiente
                            echo'<SCRIPT languague="javascript">
                                 <!--
                                    alert("incluidas todas droguerías incluidas para el producto");
                                    window.history.back();
                                 -->
                                </SCRIPT>';
                            exit;
                        }
                        else
                        {
                            // Inserto el nuevo registro
                            $vsql = "INSERT INTO productosexcluidosrotacion (productoid, fecdesde, fechasta, sucursalid, creador, momento) 
                                           VALUE (".$productoid.",'".$fecdesde."','".$fechasta."',".$sucursalid.",'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
                            $clase->EjecutarSQL($vsql);
    
                            // mensaje correspondiente
                            echo'<SCRIPT languague="javascript">
                                 <!--
                                    alert("Producto incluido satisfactoriamente");
                                    window.history.back();
                                 -->
                                 </SCRIPT>';
                            exit;
                        }
                    }
				}
			}
		}

		// redirecciono el formulario
		header("Location: productosexcluidosrotacion.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmareliminar
    // Creación: 18/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de un producto 
	//              excluido
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmareliminar")
    {
        $excluidosid = $_GET['excluidosid'];

		// Obtengo el nombre del producto
		$productoid = $clase->BDLockup($excluidosid,'productosexcluidosrotacion','excluidosid','productoid');
		$descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar producto </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">¿Confirma que desea eliminar <br> <b>'.trim($descripcion).'</b> <br> de la lista de productos excluidos del c&aacute;lculo de rotaci&oacute;n? </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarexcluido" method="POST">
                   <input type="hidden" name="excluidosid" value="'.$excluidosid.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="productosexcluidosrotacion.php" > <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarexcluido
    // Creación: 18/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina físicamente un producto excluido
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarexcluido")
    {
        $excluidosid = $_POST['excluidosid'];

		// Obtengo el nombre del producto
		$productoid = $clase->BDLockup($excluidosid,'productosexcluidosrotacion','excluidosid','productoid');
		$descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');

		// Elimino el prodcuto
		$vsql = "DELETE FROM productosexcluidosrotacion WHERE excluidosid = ".$excluidosid;
		$clase->EjecutarSQL($vsql);

		// emito el mensaje correspondiente
		echo'<SCRIPT languague="javascript">
			 <!--
				alert("'.$descripcion.' eliminado de la lista de producto excluidos de rotación");
				window.history.back();
			 -->
			 </SCRIPT>';
	 	exit;

		// redirecciono el formulario
		header("Location: productosexcluidosrotacion.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarexluido
    // Creación: 18/01/2024		última modificación: 26/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la venta para editar un producto excluido
    // Última modificación: Inclusión del combo para la droguería y la casilla de 
    //                      verificación para todas las droguerías
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarexluido")
    {
        $excluidosid = $_GET['excluidosid'];

		// Obtengo el nombre del producto
		$productoid = $clase->BDLockup($excluidosid,'productosexcluidosrotacion','excluidosid','productoid');
		$descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');

		// obtengo los valores de las fechas
		$fecdesde = $clase->BDLockup($excluidosid,'productosexcluidosrotacion','excluidosid','fecdesde');
		$fechasta = $clase->BDLockup($excluidosid,'productosexcluidosrotacion','excluidosid','fechasta');

        // combo de sucursales
        $params = ' class="Texto11" ';
        $sucursalid = $clase->BDLockup($excluidosid,'productosexcluidosrotacion','excluidosid','sucursalid');
        $vsqlcombosucursal = "SELECT sucursalid , descripcion FROM sucursales WHERE 1 ORDER BY descripcion ASC";
        $combosucursales = $clase->CrearComboBuscar("sucursalid",$vsqlcombosucursal,"descripcion","sucursalid",$sucursalid,"n",$params,300);        
		
		// pinto la ventana
        $cont ='<table width="400">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td width="350" align="center"> <label class="Texto12"> <b>Editar producto <br> <font color="blue"> '.$descripcion.' </font> </b> </label> <br> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardaredicionexcl" method="POST" name="x">
                <input type="hidden" name="excluidosid" value="'.$excluidosid.'">
                <table width="400">
                 <center><br>
                 <tr class="TablaDocsImPar">
                  <td width="100" align="right"> <label class="Texto12"> Fecha desde: </label> &nbsp; </td>
                  <td width="300">
				   <input type="date" name="fecdesde" size="30" style="width:116px;height:25px" tabindex="1" id="default" value="'.$fecdesde.'">
                  </td>
                 </tr>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"> <label class="Texto12"> Fecha hasta: </label> &nbsp; </td>
				  <td width="300">
				   <input type="date" name="fechasta" size="30" style="width:116px;height:25px" tabindex="1" id="default" value="'.$fechasta.'">
				  </td>
				 </tr>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"><label class="Texto12"> Sucursal: </label>&nbsp; </td>
				  <td width="300"> '.$combosucursales.' </td>
				 </tr>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"> &nbsp; </td>
				  <td width="300"> 
                   <input type="checkbox" value="CHECKED" name="todassuc" id="todassuc" class="Texto11" style="width:18px;height:20px" '.$todassuc.'> <label class="Texto12"> todas las sucursales </label> 
                  </td>
				 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="productosexcluidosrotacion.php" > <input type="button" value="CANCELAR" class="button red"> </a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardaredicionexcl
    // Creación: 18/01/2024		última modificación: 26/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que almacena la modificación de un producto excluido
    // Última modificación: Inclusión del combo para la droguería y la casilla de 
    //                      verificación para todas las droguerías
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardaredicionexcl")
    {
        $excluidosid = $_POST['excluidosid'];
		$fecdesde = $_POST['fecdesde'];
		$fechasta = $_POST['fechasta'];
        $sucursalid = $_POST['sucursalid'];
        $todassuc = $_POST['todassuc'];

		// Valido que todos los datos estén llenos
		if((strlen($fecdesde) == 0) || (strlen($fechasta) == 0))
		{            
			echo'<SCRIPT languague="javascript">
				 <!--
					alert("Debe ingresar ambas fechas");
					window.history.back();
				 -->
				 </SCRIPT>';
			exit;
		}
		else
		{
			// Valido que la fecha desde sea menor a la fecha hasta
			$lb_valido = false;
			$lb_valido=$io_fecha->uf_comparar_fecha($fecdesde,$fechasta);   // llamado a la función de validación de las fechas

			if(!$lb_valido)	
			{
				echo'<SCRIPT languague="javascript">
					 <!--
						alert("La fecha hasta debe ser mayor a la fecha desde");
						window.history.back();
					 -->
					 </SCRIPT>';
				exit;
			}
			else
			{
                // Valido la existencia del producto y la sucursal                
                $productoid = $clase->BDLockup($excluidosid,'productosexcluidosrotacion','excluidosid','productoid');
                $sucursalidactual = $clase->BDLockup($excluidosid,'productosexcluidosrotacion','excluidosid','sucursalid');
                $descripcionprod = $clase->BDLockup($productoid,'productos','productoid','descripcion');

                if($sucursalidactual != $sucursalid)
                    $lbcambiasucrursal = true;
                else
                    $lbcambiasucrursal = false;

				// Valido que el producto no esté incluido ya en esa sucursal
				$vsql2 = "SELECT COUNT($productoid) AS valproducto FROM productosexcluidosrotacion WHERE productoid = ".$productoid." AND sucursalid = ".$sucursalid;
				$valproducto = $clase->SeleccionarUno($vsql2);
				
				if(($valproducto > 0) && $lbcambiasucrursal)
				{   
                    $descripcionsuc = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');                    

					echo'<SCRIPT languague="javascript">
						 <!--
							alert("'.$descripcionprod.' ya está excluido de rotación en la '.$descripcionsuc.'");
							window.history.back();
						 -->
						 </SCRIPT>';
					exit;
				}
				else
                {
                    // Determino si se grabará una droguería o una sola
                    if($todassuc == "CHECKED")
                    {
                        // llamado a la función que guarda en todas las droguerías
                        $drogincluidas = todaslasdroguerias($productoid,$fecdesde,$fechasta);

                        // mensaje correspondiente
                        echo'<SCRIPT languague="javascript">
                             <!--
                                alert("incluidas todas droguerías incluidas para el producto '.$descripcionprod.'");
                                window.history.back();
                             -->
                             </SCRIPT>';
                        exit;
                    }
                    else
                    {
                        // guardo los cambios
                        $vsql = "UPDATE productosexcluidosrotacion SET 
                                        fecdesde = '".$fecdesde."',
                                        fechasta = '".$fechasta."',
                                        sucursalid = ".$sucursalid.",
                                        creador = '".$_SESSION['USERNAME']."',
                                        momento = CURRENT_TIMESTAMP 
                                  WHERE excluidosid = ".$excluidosid;
                        $clase->EjecutarSQL($vsql);

                        echo'<SCRIPT languague="javascript">
                            <!--
                                alert("Producto editado satisfactoriamente");
                                window.history.back();
                            -->
                            </SCRIPT>';
                        exit;
                    }                    
                }
			}
		}

		// redirecciono el formulario
		header("Location: productosexcluidosrotacion.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: encontrar
    // Creación: 18/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que busca un producto por código o descripción
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT per.excluidosid, p.codigo, p.descripcion, per.fecdesde, per.fechasta, s.descripcion sucursal 
                   FROM productosexcluidosrotacion per 
                        INNER JOIN productos p ON (per.productoid = p.productoid)
                        INNER JOIN sucursales s ON (per.sucursalid = s.sucursalid)
		          WHERE p.descripcion LIKE '%".$criterio."%' 
				        OR p.codigo LIKE '%".$criterio."%' 
                  ORDER BY p.codigo, sucursal";
        $_SESSION['SQL_PROEXCLROTA'] = $vsql;
        header("Location: productosexcluidosrotacion.php");
	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 18/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que anula la última búsqueda realizada y muestra todos los 
	//              productos excluidos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT per.excluidosid, p.codigo, p.descripcion, per.fecdesde, per.fechasta, s.descripcion sucursal 
                   FROM productosexcluidosrotacion per 
                        INNER JOIN productos p ON (per.productoid = p.productoid)
                        INNER JOIN sucursales s ON (per.sucursalid = s.sucursalid)
                  ORDER BY p.codigo, sucursal";
        $_SESSION['SQL_PROEXCLROTA'] = "";
        header("Location: productosexcluidosrotacion.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel1
    // Creación: 18/01/2024		última modificación: 27/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para seleccionar la hoja de Excel de la cual 
	//              se importarán productos excluidos
    // Última modificación: Inclusión del código de la sucursal
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel1")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="productosexcluidosrotacion.php" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr" value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
        else
        {
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar productos para ser excluidos <br> del c&aacute;lculo de rotaci&oacute;n </b> <br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importarexcel2" id="theform" enctype="multipart/form-data">                       
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
    
			// Impresión de la imagen de ejemplo
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&oacute;digo del producto </td> </tr>
					 <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Fecha desde (formato aaaa-mm-dd) </td> </tr>
					 <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Fecha hasta (formato aaaa-mm-dd) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: C&oacute;digo de la sucursal </td> </tr>
                    </table>';
    
			// Botón de ejecutar
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemploexcluidos.png" width="300" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensi&oacute;n .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel2
    // Creación: 18/01/2024		última modificación: 27/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para seleccionar la hoja de Excel de la cual 
	//              se importarán productos excluidos
    // Última modificación: Inclusión del código de la sucursal
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel2")
    {
		set_time_limit(0);
		extract($_POST);		
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;
        
        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            echo'<SCRIPT languague="javascript">
                 <!--
                    alert("El archivo debe tener extensión .xlsx");
                    window.history.back();
                 -->
                 </SCRIPT>';
            exit;
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['codigo'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
					$_DATOS_EXCEL[$i]['fecdesde'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
					$_DATOS_EXCEL[$i]['fechasta'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['codigosuc'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['codigo']) == 0) || (strlen($_DATOS_EXCEL[$i]['fecdesde']) == 0) || (strlen($_DATOS_EXCEL[$i]['fechasta']) == 0) || (strlen($_DATOS_EXCEL[$i]['codigosuc']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocodigos = 'PRODUCTOS EXCLUIDOS DE ROTACION'.Chr(13).Chr(10);
            $nocodigos.= 'CODIGOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocodigos.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $valproducto = 0;
                $motivo = "";
                $codigo = $_DATOS_EXCEL[$j]['codigo'];

                // Valido que el producto exista
                if($codigo != "")
                {
                    $productoid = $clase->BDLockup($codigo,"productos","codigo","productoid");
                    
                    if($productoid != "")
                    {
                        // Valido que la sucursal exista
                        $codigosuc = $_DATOS_EXCEL[$j]['codigosuc'];

                        $sucursalid = $clase->BDLockup($codigosuc,"sucursales","codigo","sucursalid");

                        if($sucursalid != "")
                        {
                            // Valido que el producto ya exista en la sucursal
                            $vsql2 = "SELECT COUNT(*) AS valproducto FROM productosexcluidosrotacion WHERE productoid = ".$productoid." AND sucursalid = ".$sucursalid;
                            $valproducto = $clase->SeleccionarUno($vsql2);

                            if($valproducto == 0)
                            {
                                // Valido el formato de la fecha
                                $fecdesde = $_DATOS_EXCEL[$j]['fecdesde'];
                                $fechasta = $_DATOS_EXCEL[$j]['fechasta'];
        
                                $lb_validafd = validateDate($fecdesde, 'Y-m-d');
                                $lb_validafh = validateDate($fechasta, 'Y-m-d');
    
                                if($lb_validafd && $lb_validafh)
                                {
                                    // Valido que la fecha desde sea menor a la fecha hasta
                                    $lb_valido = false;
                                    $lb_valido = $io_fecha->uf_comparar_fecha($fecdesde,$fechasta);   // llamado a la función de validación de las fechas
            
                                    if($lb_valido)
                                    {
                                        // Inserto el nuevo registro
                                        $vsql = "INSERT INTO productosexcluidosrotacion (productoid, fecdesde, fechasta, sucursalid, creador, momento) 
                                                       VALUE (".$productoid.",'".$fecdesde."','".$fechasta."',".$sucursalid.",'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
                                        $clase->EjecutarSQL($vsql);
    
                                        if(mysql_affected_rows() >= 1)
                                        {
                                            $grabados++;
                                            $lbgrabo = true;
                                        }
                                    }
                                    else
                                        $motivo = "rango de fecha invalido";
                                }
                                else
                                    $motivo = "formato de fecha invalido";
                            }
                            else
                                $motivo = "producto y sucursal ya existen";
                        }
                        else
                            $motivo = "sucursal no existe";
                    }
                    else
                        $motivo = "producto no existe";
                }
                else
                    $motivo = "codigo en blanco";

                // Almaceno en un archivo de texto las códigos que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocodigos.= str_pad($codigo,1,"").' -- '.str_pad($motivo,1,"").Chr(13).Chr(10);        // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresexcluidos.txt";                                                      // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                                         // se abre el archivo para escribir
                    fwrite($fd, $nocodigos);                                                                // Grabas
                    fclose($fd);                                                                            // Cierras el archivo
                }
            }

            // --------------------------------------------------------------------------------------------------------------- //
            // Impresión de la fecha del último proceso ejecutado
            $mesimp = date('F');
            if($mesimp == "January")       $mesimp = "enero";
            if($mesimp == "February")      $mesimp = "febrero";
            if($mesimp == "March")         $mesimp = "marzo";
            if($mesimp == "April")         $mesimp = "abril";
            if($mesimp == "May")           $mesimp = "mayo";
            if($mesimp == "June")          $mesimp = "junio";
            if($mesimp == "July")          $mesimp = "julio";
            if($mesimp == "August")        $mesimp = "agosto";
            if($mesimp == "September")     $mesimp = "septiembre";
            if($mesimp == "October")       $mesimp = "octubre";
            if($mesimp == "November")      $mesimp = "noviembre";
            if($mesimp == "December")      $mesimp = "diciembre";

            $dayweek = date("l");
            if($dayweek == "Monday")       $dayweek = "lunes";
            if($dayweek == "Tuesday")      $dayweek = "martes";
            if($dayweek == "Wednesday")    $dayweek = "miércoles";
            if($dayweek == "Thursday")     $dayweek = "jueves";
            if($dayweek == "Friday")       $dayweek = "viernes";
            if($dayweek == "Saturday")     $dayweek = "sábado";
            if($dayweek == "Sunday")       $dayweek = "domingo";

            $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');

            $nocodigos.= ''.Chr(13).Chr(10);
            $nocodigos.= str_pad($fechoraimp,1,"").''.Chr(13).Chr(10);      // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresexcluidos.txt";                              // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                 // se abre el archivo para escribir
            fwrite($fd, $nocodigos);                                        // Grabas
            fclose($fd);                                                    // Cierras el archivo
            // --------------------------------------------------------------------------------------------------------------- //
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
			{
				echo'<SCRIPT languague="javascript">
					 <!--
						alert("No se cargaron los productos");
						window.history.back();
					 -->
					 </SCRIPT>';
		   		exit;
			}                
            else
			{
				echo'<SCRIPT languague="javascript">
					 <!--
						alert("Se cargaron '.$grabados.' productos a la lista de productos excluidos");
						window.history.back();
					 -->
					 </SCRIPT>';
		   		exit;
			}                
    
            // Redirecciona el formulario
            header("Location: productosexcluidosrotacion.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererrores
    // Creación: 18/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la venta para ver los productos que no fueron 
	//              almacenados en el último proceso de importación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererrores")
    {
        // Inicialización de variables
        $archivoerror = "reportes/erroresexcluidos.txt";
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        $txt = trim(str_replace("<br />","",$txt));
        $txt = trim(str_replace(" -- codigo en blanco","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Documentos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
				  <a href="productosexcluidosrotacion.php"> <input type="button" value="aceptar" class="button blue"> </a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarlimpiar
    // Creación: 26/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de todos los
    //              productos exclusión de rotación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiar")
    {
        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/anulardoc.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar todos los productos <br> excluidos de rotaci&oacute;n </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">
                   ¿Confirma que desea eliminar todos los productos excluidos de rotaci&oacute;n? <br> Esta opci&oacute;n no podr&aacute; ser revertida
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=limpiarrotacion" method="POST">                   
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="productosexcluidosrotacion.php" > <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: limpiarrotacion
    // Creación: 26/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina todos los productos exclusión de rotación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "limpiarrotacion")
    {
		// Elimino el prodcuto
		$vsql = "DELETE FROM productosexcluidosrotacion";
		$clase->EjecutarSQL($vsql);

		// emito el mensaje correspondiente
		echo'<SCRIPT languague="javascript">
			 <!--
				alert("Eliminados todos los productos excluidos de rotación");
				window.history.back();
			 -->
			 </SCRIPT>';
	 	exit;

		// redirecciono el formulario
		header("Location: productosexcluidosrotacion.php");        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarexcluidos
    // Creación: 27/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina los productos previamente seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "eliminarexcluidos")
    {
        // Construyo la lista de registros que serán eliminados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT excluidosid FROM productosexcluidosrotacion";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result)) 
        {
            if($_POST['LIN-'.$row['excluidosid']] == "S")
            {
                $lista.= $row['excluidosid'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // Elimino los registros
        $vsql2 = "DELETE FROM productosexcluidosrotacion WHERE excluidosid IN (".$lista.")";
        $clase->EjecutarSQL($vsql2);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
        {
            echo'<SCRIPT languague="javascript">
                 <!--
                    alert("'.$numeli.' registros eliminados exitosamente");
                    window.history.back();
                 -->
                 </SCRIPT>';
            exit;
        }
        else
        {
            echo'<SCRIPT languague="javascript">
                 <!--
                    alert("No se eliminaron los registros");
                    window.history.back();
                 -->
                 </SCRIPT>';
            exit;            
        }           

        // Redirecciono el formulario
        header("Location: productosexcluidosrotacion.php");        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función validateDate
    // Parámetro de entrada:    $date     --> fecha a evaluar
    //                          $format   --> formato de fecha
    // Valor de retorno:        $d        --> resultado de la verificación
    // Descripción: Función que evalúa el formato de fecha de una variable
    ////////////////////////////////////////////////////////////////////////////////////////
	function validateDate($date, $format = 'Y-m-d H:i:s')
	{
		$d = DateTime::createFromFormat($format, $date);
		return $d && $d->format($format) == $date;
	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función todaslasdroguerias
    // Parámetro de entrada:    $productoid   --> id del producto
    //                          $fecdesde     --> fecha desde
    //                          $fechasta     --> fecha hasta
    // Valor de retorno:        $droggrabadas --> número de droguerías incluidas en la tabla
    //                                            productosexcluidosrotacion
    // Descripción: Función que incluye un producto con rotación excluida en todas las 
    //              droguerías
    ////////////////////////////////////////////////////////////////////////////////////////    
    function todaslasdroguerias($productoid,$fecdesde,$fechasta)
    {
        $clase2 = new Sistema();

        $valrepetido = 0;
        $droggrabadas = 0;

        $vsql3 = "SELECT sucursalid FROM sucursales ORDER BY 1";

        $conex  = $clase2->Conectar();
        $result2 = @mysql_query($vsql3,$conex);
        while($row2 = mysql_fetch_array($result2))
        {
            $sucursalid2 = $row2['sucursalid'];

            // Valido que el producto no esté incluido ya en esa sucursal
            $vsql2 = "SELECT COUNT(*) AS valrepetido FROM productosexcluidosrotacion WHERE productoid = ".$productoid." AND sucursalid = ".$sucursalid2;
            $valrepetido = $clase2->SeleccionarUno($vsql2);

            if($valrepetido == 0)
            {
                $vsql = "INSERT INTO productosexcluidosrotacion (productoid, fecdesde, fechasta, sucursalid, creador, momento) 
                               VALUE (".$productoid.",'".$fecdesde."','".$fechasta."',".$sucursalid2.",'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
                $clase2->EjecutarSQL($vsql);

                $droggrabadas++;
            }
        }
        return($droggrabadas);
    }
?>