<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 27/12/2021		última modificación: 21/07/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal del informe
    // Última modificación: Inclusión del combo para el tipo de empleados (14/01/2022)
    //                      Eliminación del combo para el tipo de empleado
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo FROM periodos WHERE mesperiodo IN (6,12) AND anoperiodo >= 2021 AND orden > 91 ORDER BY orden";
    
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/consignaciones.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Primas canceladas por periodo </b><td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';
        
        $cont.='<form action="primasxperiodo.php?opcion=infprixper" method="POST" name="x" target="_blank">
                 <center>
                 <table width="100%">
                  <tr class="BarraDocumentos">
                   <td align="center"><br><br><b> Datos del informe <br><br></td>
                  </tr>
                 </table>  
                 <table width="100%">
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Periodo: </td>
                   <td width="120">';

        $cont.= $clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400);
                    
        $cont.='   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                  <!-- ------------------------------------------------------------------------------
                   Esto se usará posteriormente

                  ------------------------------------------------------------------------------ -->

                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Tipo: </td>
                   <td width="120">
                    <SELECT name="tiponomina" id="tiponomina" style="width:120px;height:20px">
                     <option value="todos" SELECTED> todos </option>               
                     <option value="nomina"> n&oacute;mina </option>               
                     <option value="extralegal"> extralegal </option>
                    </SELECT>
                   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>

                 </table>                   
                 <table width="100%">                     
                  <tr class="BarraDocumentos"> 
                   <td width="371" height="50" align="center">&nbsp;  </td>      
                   <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"></td>
                   <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"></td>
                   <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"></td> 
                   <td width="380" height="50" align="center">&nbsp;  </td>
                  </tr>
                 </table> 
                </form>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                </table>';
        echo $cont;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infprixper
    // Creación: 27/12/2021		última modificación: 23/12/2022
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que genera el informe de primas por periodo de acuerdo al tipo 
    //              de salida seleccionado
    // Última modificación: Inclusión del filtro de tipo de empleado (14/01/2022)
    //                      Inclusión de los botones de eliminar y editar prima (06/07/2022)
    //                      Reformulación de la consulta para incluir los registros pre 
    //                      configurados en la tabla noliquida (21/07/2022)
    //                      Modificación de la consulta para incluir a los empleados con dos 
    //                      primas en el mismo periodo
    ////////////////////////////////////////////////////////////////////////////////////////            
    if($opcion=="infprixper")
    {
        $codperiodo  = $_POST['codperiodo'];    // Variable para filtrar el periodo
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará
        $tiponomina = $_POST["tiponomina"];     // Variable para el tipo de nómina

        // Variable para el nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');        

        // Valido que el periodo tenga datos para emitir el reporte
        $vsqldatos = "SELECT COUNT(*) AS numreg 
                        FROM liquidacion 
                       WHERE periodonomina = '".$codperiodo."' 
                             AND (tipo = 'primas' AND pago > 0)";
        $numreg = $clase->SeleccionarUno($vsqldatos);        

        if($numreg==0)
        {
            $clase->Aviso(3,"No existen primas canceladas en el periodo $desperiodo");
            header("Location: primasxperiodo.php?opcion=ventanadatos");
        }
        else
        {
            // Consulta del informe
            $vsql = "SELECT t.dni, 
                            CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                            l.pago, t.terid, 
                            (SELECT COUNT(*) 
                               FROM liquidacion 
                              WHERE liquidacion.terid = l.terid 
                                    AND liquidacion.periodonomina = '".$codperiodo."') AS numreg, 0 numprimas,
                            l.idliquidacion 
                       FROM terceros t 
                            INNER JOIN liquidacion l ON (t.terid = l.terid) 
                      WHERE l.periodonomina = '".$codperiodo."' 
                            AND (l.tipo = 'primas' AND l.pago > 0) 
                     HAVING numreg = 1           
                     UNION           
                     SELECT t.dni, 
                            CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                            l.pago, t.terid, 
                            (SELECT COUNT(*) 
                               FROM liquidacion 
                              WHERE liquidacion.terid = l.terid 
                                    AND liquidacion.periodonomina = '".$codperiodo."') AS numreg, 0 numprimas,
                            l.idliquidacion 
                       FROM terceros t 
                            INNER JOIN liquidacion l ON (t.terid = l.terid) 
                      WHERE l.periodonomina = '".$codperiodo."' 
                            AND (l.tipo = 'primas' AND l.pago > 0)
                            AND t.terid IN (SELECT terid 
                                              FROM noliquida 
                                             WHERE noliquida.periodonomina = '".$codperiodo."' 
                                                   AND noliquida.terid = t.terid 
                                                   AND noliquida.tipo = 'primas')
                     UNION
                     SELECT t.dni, 
                            CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                            l.pago, t.terid, 
                            (SELECT COUNT(*) 
                               FROM liquidacion 
                              WHERE liquidacion.terid = l.terid 
                                    AND liquidacion.periodonomina = '".$codperiodo."') AS numreg,             
                            (SELECT MIN(liquidacion.pago)
                               FROM liquidacion 
                              WHERE liquidacion.terid = l.terid 
                                    AND liquidacion.periodonomina = '".$codperiodo."') AS numprimas,
                            l.idliquidacion 
                       FROM terceros t 
                            INNER JOIN liquidacion l ON (t.terid = l.terid) 
                      WHERE l.periodonomina = '".$codperiodo."' 
                            AND (l.tipo = 'primas' AND l.pago > 0) 
                     HAVING numreg = 4 AND l.pago = numprimas";

            // Salida en vista html
            if($tiposalida=="vista")
            {
                $cont = $clase->Header("S","W");
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> <img src="images/iconos/consignaciones.png" width="32" height="32" border="0"> </td>
                          <td width="840"> <b> Primas canceladas </b> <br> <b> Periodo:</b> '.$desperiodo.' <b> Filtro:</b> '.strtoupper($tiponomina).'</td>
                          <td> &nbsp; </td>
                          <td width="8"> &nbsp; </td>
                         </tr>
                        </table>';                

                $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                        <table width="100%" class="sortable">
                         <thead> 
                          <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                           <td width="23">&nbsp;</td>                           
                           <td width="143" align="left"><p>Documento</p></td>
                           <td width="794" align="left">Nombre </td>			
                           <td width="194" align="right">Monto </td>			
                           <td width="82">&nbsp;</td>
                           <td width="26">&nbsp;</td>
                          </tr>
                         </thead>
                         <tbody style="display:block; width:1050px; height:600px; overflow-Y:scroll">';

                $i = 0;
                $totalpagado = 0;
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                while($row = mysql_fetch_array($result))
                {
                    // Valido el filtro del tipo de empleado
                    $imprime = false;
                    if($tiponomina == "todos")
                        $imprime = true;
                    else
                    {
                        $terid = $row['terid'];
                        $vsql2 = "SELECT esempleadoactivo FROM primasterceros WHERE periodonomina = '".$codperiodo."' AND tipo = 'primas' AND terid = ".$terid;
                        $esempleadoactivo = $clase->SeleccionarUno($vsql2);
                        $vsql3 = "SELECT extralegal FROM primasterceros WHERE periodonomina = '".$codperiodo."' AND tipo = 'primas' AND terid = ".$terid;
                        $extralegal = $clase->SeleccionarUno($vsql3);

                        if(($tiponomina == "nomina") && ($extralegal!='CHECKED'))                   $imprime = true;
                        if(($tiponomina == "extralegal") && ($extralegal=='CHECKED'))               $imprime = true;
                    }                   

                    if($imprime)
                    {
                        $i++;
                        if($i%2 == 0)
                            $cont.='<tr class="TablaDocsPar">';
                        else
                            $cont.='<tr class="TablaDocsImPar">';
    
                        $idliquidacion = $row['idliquidacion'];
    
                        $cont.=' <td width="23">&nbsp;</td>
                                 <td width="143" align="left">'.$row['dni'].'</td>
                                 <td width="794" align="left">'.$row['nombreemp'].' </td>
                                 <td width="194" align="right">'.number_format($row['pago']).' </td>
                                 <td width="36" align="center">  
                                  <a href="primasxperiodo.php?opcion=reciboprimas&desperiodo='.$desperiodo.'&terid='.$row['terid'].'&pago='.$row['pago'].'&codperiodo='.$codperiodo.'" target="_blank">
                                   <img src="images/basicas/pdf.png" title="Recibo" border="0">
                                  </a>                             
                                 </td>                                 
                                 <td width="20" align="center">
                                  <a href="?opcion=valborrarprima&idliquidacion='.$idliquidacion.'" rel="facebox" title="eliminar prima">
                                   <img src="images/basicas/iconoborrar.png" border="0">
                                  </a>
                                 </td>
                                 <td width="20" align="center">
                                  <a href="?opcion=editarprima&idliquidacion='.$idliquidacion.'" title="modificar prima" rel="facebox">
                                   <img src="images/basicas/iconobuscar.png" border="0">
                                  </a>
                                 </td>
                                </tr>';
    
                        // incremento del total
                        $totalpagado += $row['pago'];
                    }                    
                }
                $cont.=' </tbody> 
                        </table>';

                // impresión del total
                $cont.='<table width="100%">
                         <tr class="TituloTabla"> 
                          <td width="391"> &nbsp; </td>
                          <td width="375" align="right"> &nbsp; </td>
                          <td width="375" align="right"> &nbsp; </td>
                          <td width="375" align="right"> <font color="WHITE"> <b> Total pagado: </b> '.number_format($totalpagado).' </font> </td>
                          <td width="92"> &nbsp; </td>
                         </tr>
                        </table>';                        

                echo $cont.$clase->PiePagina();
            }

            // vista en formato pdf
            if($tiposalida=="pdf")
            {
                // Traducción al español del mes que devuelve la función date()
                $mesimp = date('F');
                if($mesimp=="January")       $mesimp = "Enero";
                if($mesimp=="February")      $mesimp = "Febrero";
                if($mesimp=="March")         $mesimp = "Marzo";
                if($mesimp=="April")         $mesimp = "Abril";
                if($mesimp=="May")           $mesimp = "Mayo";
                if($mesimp=="June")          $mesimp = "Junio";
                if($mesimp=="July")          $mesimp = "Julio";
                if($mesimp=="August")        $mesimp = "Agosto";
                if($mesimp=="September")     $mesimp = "Septiembre";
                if($mesimp=="October")       $mesimp = "Octubre";
                if($mesimp=="November")      $mesimp = "Noviembre";
                if($mesimp=="December")      $mesimp = "Diciembre";

                $clase = new Sistema();
                ini_set("memory_limit","200M");
                require('lib/fpdf/fpdf.php');
                $pdf=new FPDF();

                $pdf->AddPage("");

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                $x = 35;
                $y = 15;
                $pagina = 1;

                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+110,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "PRIMAS CANCELADAS EN EL PERIODO ".$desperiodo;
                $pdf->Text($x,$y+7,$enc);
                // $enc= "TIPO: ".strtoupper($tiponomina);
                // $pdf->Text($x,$y+14,$enc);

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,$y+28,195,8,'F');

                $enc= "DOCUMENTO";
                $pdf->Text(9,$y+33,$enc);

                $enc= "NOMBRE";
                $pdf->Text(38,$y+33,$enc);

                $enc= "MONTO";
                $pdf->Text(185,$y+33,$enc);

                $pdf->SetFont('Arial','',8);                

                // inicialización de variables
                $x = 9;
                $y = 56;
                $i = 0;

                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                while($row = mysql_fetch_array($result))
                {
                    $i++;

                    // Impresión de documento y nombre
                    $pdf->Text($x,$y,$row['dni']);
                    $pdf->Text($x+28,$y,$row['nombreemp']);

                    // impresión del monto
                    $longitud = strlen($row['pago']);

                    if($longitud==1)    $pdf->Text($x+189,$y,number_format($row['pago']));
                    if($longitud==2)    $pdf->Text($x+187,$y,number_format($row['pago']));
                    if($longitud==3)    $pdf->Text($x+185,$y,number_format($row['pago']));
                    if($longitud==4)    $pdf->Text($x+183,$y,number_format($row['pago']));
                    if($longitud==5)    $pdf->Text($x+181,$y,number_format($row['pago']));
                    if($longitud==6)    $pdf->Text($x+179,$y,number_format($row['pago']));
                    if($longitud==7)    $pdf->Text($x+177,$y,number_format($row['pago']));
                    if($longitud==8)    $pdf->Text($x+175,$y,number_format($row['pago']));
                    if($longitud==9)    $pdf->Text($x+179,$y,number_format($row['pago']));

                    // salto de línea
                    $y+=6;

                    // incremento del total
                    $totalpagado += $row['pago'];

                    if($i%35 == 0)
                    {
                        $pdf->AddPage("");

                        // Logo Dromedicas
                        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                        $x = 35;
                        $y = 15;
                        $pagina++;

                        $pdf->SetFont('Arial','B',10);
                        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                        $pdf->Text($x,$y,$enc);
        
                        // Fecha y hora de impresión
                        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
        
                        $pdf->SetFont('Arial','',8);
                        $pdf->Text($x+110,$y,$fechoraimp);
        
                        $pdf->SetFont('Arial','B',10);
                        $enc= "PRIMAS CANCELADAS EN EL PERIODO ".$desperiodo;
                        $pdf->Text($x,$y+7,$enc);
        
                        $pdf->SetFillColor(220,220,220);
                        $pdf->Rect(7,$y+28,195,8,'F');
        
                        $enc= "DOCUMENTO";
                        $pdf->Text(9,$y+33,$enc);
        
                        $enc= "NOMBRE";
                        $pdf->Text(38,$y+33,$enc);
        
                        $enc= "MONTO";
                        $pdf->Text(185,$y+33,$enc);
        
                        $pdf->SetFont('Arial','',8);
        
                        // inicialización de variables
                        $x = 9;
                        $y = 56;
                    }                    
                }
                
                // Impresión del total a pagar
                $y+=6;
                $pdf->SetFont('Arial','B',10);

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,$y-5,195,8,'F');
                
                $longitud = strlen($totalpagado);
                if($longitud==8)     $pdf->Text(150,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==9)     $pdf->Text(148,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==10)    $pdf->Text(146,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==11)    $pdf->Text(144,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==12)    $pdf->Text(142,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));                
                if($longitud==13)    $pdf->Text(140,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));

                $pdf->Output();
            }

            // salida a excel
            if($tiposalida=="excel")
            {
                require_once 'lib/PHPExcel.php';
                $clase = new Sistema();
                $clase->Conectar();
                ini_set("memory_limit","100M");

                // Preparación del entorno para la salida a Excel
                $clase = new Sistema();
                $clase->Nombredb = $_SESSION['DBNOMBRE'];
                error_reporting(E_ALL);
                ini_set('display_errors', TRUE);
                ini_set('display_startup_errors', TRUE);
                date_default_timezone_set('Europe/London');
            
                if (PHP_SAPI == 'cli')
                    die('This example should only be run from a Web Browser');
            
                // Create new PHPExcel object
                $objPHPExcel = new PHPExcel();
            
                // Set document properties
                $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                             ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                             ->setTitle("Primas por periodo - DROPOS")
                                             ->setSubject("Primas por periodo - DROPOS")
                                             ->setDescription("Primas por periodo - DROPOS")
                                             ->setKeywords("Primas por periodo - DROPOS")
                                             ->setCategory("Categoria General");

                // encabezado
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A1', 'PRIMAS CANCELADAS POR PERIODO')
                            ->setCellValue('A2', $desperiodo)
                            ->setCellValue('A4', 'DOCUMENTO')
                            ->setCellValue('B4', 'NOMBRE')
                            ->setCellValue('C4', 'MONTO');                

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);

                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                $cant   = mysql_num_rows($result);                
                $i=5;
                $totalpagado = 0;
                
                // Detalle del informe
                while($row = mysql_fetch_array($result))
                {
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A'.$i, $row['dni'])
                                ->setCellValue('B'.$i, $row['nombreemp'])
                                ->setCellValue('C'.$i, number_format($row['pago']));

                    $totalpagado += $row['pago'];
                    $i++;
                }

                // Impresión del último total
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, '')
                            ->setCellValue('B'.$i, 'TOTAL:')
                            ->setCellValue('C'.$i, number_format($totalpagado));

                $rangoEncabezado = 'A4:C4';
                $rangoCeldas     = 'A4:C'.($i-1);

                // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //                
                // Formato de Encabezado y Celdas
                $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
                
                $EstiloCeldas = array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                    ),
                );
                // $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
                /// Formato de Encabezados 
                $EstiloEncabezado = array(
                'font' => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
                ),
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                ),
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'rotation' => 90,
                    'startcolor' => array(
                        'argb' => '00FFFFCC',
                    ),
                    'endcolor' => array(
                        'argb' => 'FFFFFF',
                    ),
                    ),
                );
                // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
                // Rename worksheet
                $objPHPExcel->getActiveSheet()->setTitle('Reportados por periodo');
                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);
                // Redirect output to a client’s web browser (Excel5)
                header('Content-Type: application/vnd.ms-excel');
                // --------------------------------------------------------------------- //
                // header('Content-Disposition: attachment;filename="planillanom.xls"');
                $nombrearcexcel = "primas del periodo ".strtolower($desperiodo).".xls";
                header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
                // --------------------------------------------------------------------- //
                header('Cache-Control: max-age=0');
                /// Genero la Salida
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
                $objWriter->save('php://output');
                exit;
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: reciboprimas
    // Creación: 27/12/2021		última modificación: 31/12/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera el recibo de pago de la prima de un empleado
    // Última modificación: Toma de datos de la tala de enlace entre primas y terceros
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion=="reciboprimas")
    {
        $desperiodo = $_GET['desperiodo'];
        $terid = $_GET['terid'];
        $pago = $_GET['pago'];
        $codperiodo = $_GET['codperiodo'];

        // El código del empleado
        $vsqldatos = "SELECT codvende FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
        $codvende = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // documento
        $vsqldatos = "SELECT dni FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
        $dni = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // sueldo básico
        $vsqldatos = "SELECT basico FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
        $basico = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";        

        // Fecha de ingreso
        $vsqldatos = "SELECT fecingreso FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
        $fecingreso = $clase->SeleccionarUno($vsqldatos);
        $fecingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
        $vsqldatos = "";

        // El nombre del empleado
        $vsqldatos = "SELECT nombre
                        FROM primasterceros 
                       WHERE terid = ".$terid." 
                             AND periodonomina = '".$codperiodo."'
                             AND tipo = 'primas'";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // El cargo
        $vsqldatos = "SELECT c.descripcioncargo 
                        FROM primasterceros t
                             INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                       WHERE t.terid = ".$terid."
                             AND t.periodonomina = '".$codperiodo."'
                             AND t.tipo = 'primas'";
        $cargo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // La sección
        $vsqldatos = "SELECT s.descripcionsec 
                        FROM primasterceros t
                             INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                       WHERE t.terid = ".$terid."
                             AND t.periodonomina = '".$codperiodo."'
                             AND t.tipo = 'primas'";
        $seccion = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Determino si el empleado es de condición extralegal
        $vsqldatos = "SELECT extralegal FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
        $extralegal = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($extralegal=="CHECKED")
            $area = "EXTRALEGALES";
        else
        {
            // El área
            $vsqldatos = "SELECT a.descripcionarea 
                            FROM primasterceros t
                                 INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                           WHERE t.terid = ".$terid."
                                 AND t.periodonomina = '".$codperiodo."'
                                 AND t.tipo = 'primas'";
            $area = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
        }

        // El banco
        $vsqldatos = "SELECT b.descripcion 
                        FROM primasterceros t
                             INNER JOIN bancos b ON (t.bancoid = b.bancoid) 
                       WHERE t.terid = ".$terid."
                             AND t.periodonomina = '".$codperiodo."'
                             AND t.tipo = 'primas'";
        $banco = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Número de cuenta bancaria
        $vsqldatos = "SELECT numcuenta FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
        $numcuenta = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // mes del periodo
        $mesper = substr($codperiodo,0,2);        

        // Procedo a construir el encabezado del recibo
        $clase = new Sistema();
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF('L','mm','A6');       // Recibo a media página
    
        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
        $pdf->SetFont('Arial','',8);
        $pdf->Text(147,14,$fechoraimp);

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

        $x = 35;
        $y = 15;
        $pdf->SetFont('Arial','B',10);
        $enc= "COMPROBANTE DE PAGO";
        $pdf->Text($x,$y,$enc);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y+7,$enc);
        $enc= "NOMINA: ";
        $pdf->Text($x,$y+14,$enc);

        // Determino el nombre de la nómina
        if($mesper=="06")       $nombnomina = "PRIMAS PRIMER SEMESTRE ".substr($desperiodo,-4);
        if($mesper=="12")       $nombnomina = "PRIMAS SEGUNDO SEMESTRE ".substr($desperiodo,-4);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($nombnomina);
        $pdf->Text($x+18,$y+14,$enc);

        $x = 10;
        $y = 40;
        $pdf->SetFont('Arial','B',10);

        // Datos del empleado
        $enc= "CODIGO: ";
        $pdf->Text($x,$y,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=$codvende;
        $pdf->Text($x+28,$y,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "NOMBRE: ";
        $pdf->Text($x+60,$y,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($nombreemp);
        $pdf->Text($x+80,$y,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "DOCUMENTO: ";
        $pdf->Text($x,$y+7,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=$dni;
        $pdf->Text($x+28,$y+7,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "CARGO: ";
        $pdf->Text($x+60,$y+7,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($cargo);
        $pdf->Text($x+80,$y+7,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "BASICO: ";
        $pdf->Text($x,$y+14,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=number_format($basico,2);
        $pdf->Text($x+28,$y+14,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "SECCION: ";
        $pdf->Text($x+60,$y+14,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($seccion);
        $pdf->Text($x+80,$y+14,$enc);

        // $pdf->SetFont('Arial','B',10);
        // $enc= "FEC INGRESO: ";
        // $pdf->Text($x,$y+21,$enc);

        // $pdf->SetFont('Arial','',10);
        // $enc=$fecingreso;
        // $pdf->Text($x+28,$y+21,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "AREA: ";
        $pdf->Text($x+60,$y+21,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($area);
        $pdf->Text($x+80,$y+21,$enc);

        // Títulos del detalle
        $x = 10;
        $y = 68;
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(7,63,195,8,'F');
        $pdf->SetFont('Arial','B',9);
        $pdf->Text($x,$y,"CONCEPTO");
        $pdf->Text($x+20,$y,"");
        $pdf->Text($x+75,$y,"");
        $pdf->Text($x+105,$y,"DEVENGADOS");
        $pdf->Text($x+135,$y,"DESCUENTOS");
        $pdf->Text($x+170,$y,"");

        // Detalle del recibo
        $x = 10;
        $y = 76;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x,$y,$nombnomina);       

        // Alineación de los montos correspondientes
        $longitud = strlen($pago);
        if($longitud==1)    $pdf->Text($x+126,$y,number_format($pago,0));
        if($longitud==2)    $pdf->Text($x+124,$y,number_format($pago,0));
        if($longitud==3)    $pdf->Text($x+122,$y,number_format($pago,0));
        if($longitud==4)    $pdf->Text($x+120,$y,number_format($pago,0));
        if($longitud==5)    $pdf->Text($x+118,$y,number_format($pago,0));
        if($longitud==6)    $pdf->Text($x+117,$y,number_format($pago,0));
        if($longitud==7)    $pdf->Text($x+115,$y,number_format($pago,0));

        // salto de línea
        $y+=6;

        // Imprimo los totales
        $lineatotales = $y;
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(7,$lineatotales,195,8,'F');

        $pdf->SetFont('Arial','B',10);
        $pie= "TOTALES: ";
        $pdf->Text($x+70,$y+5,$pie);

        $pdf->SetFont('Arial','',8);
        
        // Alineación de los montos correspondientes
        if($longitud==1)    $pdf->Text($x+101,$y+5,number_format($pago));
        if($longitud==2)    $pdf->Text($x+105,$y+5,number_format($pago));
        if($longitud==4)    $pdf->Text($x+109,$y+5,number_format($pago));
        if($longitud==5)    $pdf->Text($x+113,$y+5,number_format($pago));
        if($longitud==6)    $pdf->Text($x+117,$y+5,number_format($pago));
        if($longitud==7)    $pdf->Text($x+114,$y+5,number_format($pago));

        // Impresión del banco y cuenta a la cual se le consigna
        $pdf->SetFont('Arial','',8);
        $pie= "                                                                                                                                                                     __________________________";
        $pdf->Text($x,$y+35,$pie);
        $pie= "                                                                                                                                                                     RECIBI CONFORME";
        $pdf->Text($x,$y+40,$pie);

        if($extralegal=="CHECKED")
            $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
        else
        {
            if(($numcuenta=="")||($numcuenta==NULL))
                $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
            else
                $pie= "CONSIGNADO EN: ".strtoupper($banco)."                      CUENTA NO. ".$numcuenta."                            C.C.";
        }
        
        $pdf->Text($x,$y+45,$pie);
        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: valborrarprima
    // Creación: 06/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de una prima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "valborrarprima")
    {
        $idliquidacion = $_GET['idliquidacion'];

        $terid = $clase->BDLockup($idliquidacion,'liquidacion','idliquidacion','terid');

        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);

        $pago = $clase->BDLockup($idliquidacion,'liquidacion','idliquidacion','pago');

        $cont='<table width="500">
                <tr class="CabezoteTabla"> 
                 <td align="center"><br><b>Eliminar una prima</b><br><br><td> 
                </tr> 
               </table>
               <table width="500">
                <tr class="TablaDocsImPar">       
                <td width="400" align="center">¿Confirma que desea eliminar la prima de <br><b>'.$nombreemp.'</b> <br>
                por <b>'.number_format($pago).'</b> pesos?</td>
                </tr>
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center"><br><br>                  
                  <form action="?opcion=elimminarprima&idliquidacion='.$idliquidacion.'" method="POST">
                   <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                  </form>                  
                 </td>        
                </tr>
               </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: elimminarprima
    // Creación: 06/07/2022		última modificación: 27/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para eliminar una prima
    // Última modificación: Eliminación del registro en la tala primasterceros
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "elimminarprima")
    {
        $idliquidacion = $_POST['idliquidacion'];

        $terid = $clase->BDLockup($idliquidacion,'liquidacion','idliquidacion','terid');
        $periodonomina = $clase->BDLockup($idliquidacion,'liquidacion','idliquidacion','periodonomina');

        // Elimino el concepto en la tabla detallenomina
        $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Prima eliminada satisfactoriamente");
        else
            $clase->Aviso(3,"No se eliminó la prima");

        // Elimino el concepto en la tabla detallenomina
        $vsql2 = "DELETE FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$periodonomina."' AND tipo = 'primas'";
        $clase->EjecutarSQL($vsql2);

        // Redirecciono el formulario
        header("Location: primasxperiodo.php?opcion=ventanadatos");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarprima
    // Creación: 06/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que edita el monto de la prima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarprima")
    {
        $idliquidacion = $_GET['idliquidacion'];

        $terid = $clase->BDLockup($idliquidacion,'liquidacion','idliquidacion','terid');

        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);

        $pago = $clase->BDLockup($idliquidacion,'liquidacion','idliquidacion','pago');

        $cont='<table width="400">
                <tr class="CabezoteTabla"> 
                 <td align="center"> <b>Editar prima</b> </td>                  
                </tr>
                <tr class="CabezoteTabla"> 
                 <td align="center"> Empleado(a): '.$nombreemp.' </td>                  
                </tr>
               </table>
               <form action="primasxperiodo.php?opcion=guardarprima" method="POST" name="x">                
                <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">                
                <table width="400">
                <center>
                <br>
                <tr class="TablaDocsImPar">				
                 <td width="150" align="right"> Monto: &nbsp;</td> 			  
                 <td width="250"> <input type="number" name="pago" class="Texto12New" size="4" min="1" maxlength="4" autocomplete="off" value="'.$pago.'"></td>
                </tr>
               </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
               </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarprima
    // Creación: 06/07/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena la modificación de la prima de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarprima")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $pago = $_POST['pago'];

        // Modifico el monto en la tabla detallenomina
        $vsql = "UPDATE liquidacion SET pago = ".$pago." WHERE idliquidacion = ".$idliquidacion;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Prima editada satisfactoriamente");
        else
            $clase->Aviso(3,"No se editó la prima");

        // Redirecciono el formulario
        header("Location: primasxperiodo.php?opcion=ventanadatos");
    }
?>