<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 01/06/2023		última modificación: 02/06/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal del formulario
    // Última modificación: Búsqueda por sucursal y producto
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/combos.png" width="32" height="32" border="0"> </td>
                  <td width="720"> <b>Precios especiales</b> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="?opcion=filtro" rel="facebox">
                    <img src="images/iconos/vistaprevia.png" border="0" title="filtrar precios especiales"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="?opcion=inclprecioespecial" rel="facebox">
                    <img src="images/iconos/nuevodoc.png" border="0" title="incluir precio especial"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="?opcion=ventanaimportarexcel" rel="facebox">
                    <img src="images/iconos/cargar.png" border="0" title="importar desde una hoja de Excel"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="?opcion=vererrores" rel="facebox">
                    <img src="images/iconos/notas.png" border="0" title="Precios especiales no guardados en el &uacute;ltimo proceso ejecutado"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="?opcion=preciosespxls" target="_blank">
                    <img src="images/iconos/exportarexcel2.png" border="0" title="exportar a una hoja de Excel"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>';

        if($_SESSION['SQL_PRECIOESP'] != "")
            $cont.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/basicas/nofiltro.png"> </a> </td>';

        $cont.='  <td width="24"> <a href="principal.php"> <input type="button" value="<<" class="button" title="ventana principal"> </a> </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';        

        // detalle de la ventana
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:35px;">
                   <td width="11"> &nbsp; </td>
                   <td width="120" align="left"> Sucursal </td>
                   <td width="120" align="left"> C&oacute;digo </td>
                   <td width="420" align="left"> Producto </td>
                   <td width="104" align="right"> Precio<br>Actual </td>
                   <td width="104" align="right"> Precio<br>con Dscto </td>
                   <td width="104" align="right"> Diferencia </td>                   
                   <td width="50" align="right"> Porc </td>          
                   <td width="60"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';

        // Consulta de los precios especiales
        if($_SESSION['SQL_PRECIOESP'] == "")
            $vsql = "SELECT S.codigo codsuc , S.descripcion nomsuc , P.codigo , P.descripcion , P.precio1m precioactual , PE.precio1m preciodcto, PE.precioid   
                       FROM preciosespeciales PE 
                            INNER JOIN productos P ON (PE.productoid = P.productoid) 
                            INNER JOIN sucursales S ON (S.sucursalid = PE.sucursalid) 
                   ORDER BY 1 ASC , 4 ASC";
        else
            $vsql = $_SESSION['SQL_PRECIOESP'];

        $_SESSION['SQL_PRECIOESPECIALXLS'] = $vsql;

        $i = 0;
        $diferencia = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
                
            $diferencia = $row['precioactual'] - $row['preciodcto'];
            $porcentaje = (($diferencia*100)/$row['precioactual']);
            if($porcentaje>15)
               $porcentajex = "<b><font color='red'>".number_format((($diferencia*100)/$row['precioactual']),1)."</font></b>";
            else
               $porcentajex = "<b><font color='green'>".number_format((($diferencia*100)/$row['precioactual']),1)."</font></b>";   

            $cont.=' <td width="11"> &nbsp; </td>
                     <td width="120" align="left"> '.$row['nomsuc'].' </td>
                     <td width="120" align="left"> '.$row['codigo'].' </td>
                     <td width="418" align="left"> '.$row['descripcion'].' </td>
                     <td width="104" align="right"> '.number_format($row['precioactual']).' </td>
                     <td width="104" align="right"> '.number_format($row['preciodcto']).' </td>';

            if($diferencia >= 0)
                $cont.=' <td width="100" align="right"> <font color=green> '.number_format($diferencia).' </font> </td>';
            else
                $cont.=' <td width="100" align="right"> <font color=red> '.number_format($diferencia).' </font> </td>';

            $cont.=' <td width="50" align="right"> '.$porcentajex.' </td>
                     <td width="26" align="center"> 
                      <a href="?opcion=confirmareliminar&precioid='.$row['precioid'].'" rel="facebox">
                       <img src="images/basicas/iconoborrar.png" title="eliminar precio especial" border="0">
                      </a> 
                     </td>
                     <td width="26" align="center">
                      <a href="?opcion=venteditarprecioesp&precioid='.$row['precioid'].'" rel="facebox">
                       <img src="images/basicas/iconobuscar.png" title="editar precio especial" border="0">
                      </a>
                     </td>
                    </tr>';
        }

        $cont.=' </tbody>
                 </table>';
  
        // pie de página
        $cont.='<table width="100%"> <tr class="TituloTabla"> <td width="1608"> &nbsp; </td> </tr> </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: inclprecioespecial
    // Creación: 01/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para incluir un precio especial
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "inclprecioespecial")
    {
        // Configuración de combos
        $params = ' class="Texto11" ';
        $vsqlcombosucursal = "SELECT codigo , descripcion FROM sucursales";
        $vsqlcomboproducto = "SELECT productoid, CONCAT(codigo,' - ',descripcion) FROM productos WHERE 1 ORDER BY productoid ASC";
        $precio1m = 0;
        
        // pinto la ventana
        $cont ='<table width="800">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
                  <td width="750" align="center"> <b>Incluir precio especial</b> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardarnnuevoprecioesp" method="POST" name="x">
                <table width="800">
                 <center>
                 <tr class="TablaDocsImPar">
                  <td width="80" align="right"><label class="Texto12"> Sucursal: </label></td>
                  <td width="720">
                   &nbsp;&nbsp;
                   '.$clase->CrearComboBuscar("codsucursal",$vsqlcombosucursal,"descripcion","codigo","","S",$params,250).' 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="80" align="right"><label class="Texto12"> Producto: </label></td>
                  <td width="720">
                   &nbsp;&nbsp;
                   '.$clase->CrearComboBuscar("productoid",$vsqlcomboproducto,"descripcion","productoid","","S",$params,620).'
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="80" align="right"><label class="Texto12"> Precio: </label></td>
                  <td width="720">
                   &nbsp;&nbsp;
                   <input type="number" name="precio1m" class="Texto12New" size="4" min="1" maxlength="10" autocomplete="off" value="'.$precio1m.'">
                  </td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="preciosespeciales.php"><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnnuevoprecioesp
    // Creación: 01/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena un nuevo precio especial
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnnuevoprecioesp")
    {
        $codsucursal = $_POST['codsucursal'];
        $productoid = $_POST['productoid'];
        $precio1m = $_POST['precio1m'];
        $numreg = 0;
        $vsql3 = "";

        // Valido la entrada de todos los datos
        if((strlen($codsucursal) == 0)||(strlen($productoid) == 0)||(strlen($precio1m) == 0))
            $clase->Aviso(3,"Debe ingresar todos los datos");
        else
        {
            $sucursalid = $clase->BDLockup($codsucursal,'sucursales','codigo','sucursalid');

            // Valido que el producto no esté ya con precio especial en la sucursal
            $vsql3 = "SELECT COUNT(*) AS numreg FROM preciosespeciales WHERE productoid = ".$productoid." AND sucursalid = ".$sucursalid;
            $numreg = $clase->SeleccionarUno($vsql3);

            if($numreg > 0)
            {
                $descripcionproducto = $clase->BDLockup($productoid,'productos','productoid','descripcion');
                $descripcionsucursal = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');

                $clase->Aviso(3,"$descripcionproducto ya tiene asignado un precio especial en $descripcionsucursal");
            }
            else
            {
                $precio1d = 0;
                $porcenespe = 0;

                // Almaceno la nueva lista especial
                $vsql = "INSERT INTO preciosespeciales (productoid,sucursalid,precio1d,precio1m,porcenespe,creador,momento,ultcambio) 
                              VALUES (".$productoid.",".$sucursalid.",".$precio1d.",".$precio1m.",".$porcenespe.",'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP)";
                $clase->EjecutarSQL($vsql);
    
                // Emito el mensaje correspondiente
                if(mysql_affected_rows() >= 1)
                    $clase->Aviso(1,"Datos almacenados satisfactoriamente");
                else
                    $clase->Aviso(3,"No se almacenaron los datos");
            }
        }

        // Redirecciono el formulario
        header("Location: preciosespeciales.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: venteditarprecioesp
    // Creación: 01/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para editar un precio especial
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "venteditarprecioesp")
    {
        $precioid = $_GET['precioid'];

        // Obtención de datos
        $productoid = $clase->BDLockup($precioid,'preciosespeciales','precioid','productoid');
        $sucursalid = $clase->BDLockup($precioid,'preciosespeciales','precioid','sucursalid');
        $precio1m = $clase->BDLockup($precioid,'preciosespeciales','precioid','precio1m');

        $descripcionproducto = $clase->BDLockup($productoid,'productos','productoid','descripcion');
        $descripcionsucursal = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');

        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><label class="Texto12"> <b>Editar precio especial</b> </label> </td>
                 </tr> 
                </table>
                <form action="?opcion=almacenarprecioeditado" method="POST" name="x">
                <input type="hidden" name="precioid" value="'.$precioid.'">
                <table width="500">
                 <center>
                 <tr class="TablaDocsImPar">
                  <td width="80" align="right"><label class="Texto12"> Sucursal:</label> </td>
                  <td width="420">
                   &nbsp;&nbsp;
                   '.$descripcionsucursal.'
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="80" align="right"><label class="Texto12"> Producto:</label> </td>
                  <td width="420">
                   &nbsp;&nbsp;
                   '.substr($descripcionproducto,0,58).'
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="80" align="right"><label class="Texto12"> Precio:</label> </td>
                  <td width="420">
                   &nbsp;&nbsp;
                   <input type="number" name="precio1m" class="Texto12New" size="4" min="1" maxlength="10" autocomplete="off" value="'.$precio1m.'">
                  </td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="preciosespeciales.php" ><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: almacenarprecioeditado
    // Creación: 01/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para guardar un precio especial editado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "almacenarprecioeditado")
    {
        $precioid = $_POST['precioid'];
        $precio1m = $_POST['precio1m'];

        // Guardo los cambios
        $vsql = "UPDATE preciosespeciales SET precio1m = ".$precio1m." WHERE precioid = ".$precioid;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Datos editados satisfactoriamente");
        else
            $clase->Aviso(3,"No se editaron los datos");

        // Redirecciono el formulario
        header("Location: preciosespeciales.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmareliminar
    // Creación: 01/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para eliminar un precio especial
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confirmareliminar")
    {
        $precioid = $_GET['precioid'];

        // Obtención de datos
        $productoid = $clase->BDLockup($precioid,'preciosespeciales','precioid','productoid');
        $sucursalid = $clase->BDLockup($precioid,'preciosespeciales','precioid','sucursalid');
        $precio1m = $clase->BDLockup($precioid,'preciosespeciales','precioid','precio1m');

        $descripcionproducto = $clase->BDLockup($productoid,'productos','productoid','descripcion');
        $descripcionsucursal = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><label class="Texto12"><b>Eliminar precio especial</b></label><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <br>
                   <label class="Texto12">¿Confirma que desea eliminar el precio especial del producto <br><b>'.trim($descripcionproducto).'</b> <br> en <b>'.trim($descripcionsucursal).'</b> <br> por un monto de <br> <b>'.number_format($precio1m).'</b> pesos?</label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarprecioesp&precioid='.$precioid.'" method="POST">
                   <input type="hidden" name="precioid" value="'.$precioid.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="preciosespeciales.php" ><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarprecioesp
    // Creación: 01/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina físicamente un precio especial
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarprecioesp")
    {
        $precioid = $_POST['precioid'];

        // Elimino la lista
        $vsql = "DELETE FROM preciosespeciales WHERE precioid = ".$precioid;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Precio especial eliminado satisfactoriamente");
        else
            $clase->Aviso(3,"No se eliminó el precio especial");

        // Redirecciono el formulario
        header("Location: preciosespeciales.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaimportarexcel
    // Creación: 01/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la venta donde se capta la hoja de Excel desde la cual 
    //              se importarán listas especiales
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaimportarexcel")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="preciosespeciales.php" id="theform" enctype="multipart/form-data">
                       <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
        else
        {
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                    $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar precios especiales </b> <br> </td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importarexcel" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
    
            // estructura de la hoja de excel
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&oacute;digo de la sucursal </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: C&oacute;digo del producto </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Precio </td> </tr>
                    </table>';
    
            // ejemplo de como será la hoja de excel
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemploprecioespecial.png" width="320" height="200" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel
    // Creación: 01/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para almacenar las listas especiales desde una hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel")
    {
		set_time_limit(0);
		extract($_POST);
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: preciosespeciales.php");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['codsucursal'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['codigo'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['precio1m'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();                    
                
                    if((strlen($_DATOS_EXCEL[$i]['codsucursal']) == 0) || (strlen($_DATOS_EXCEL[$i]['codigo']) == 0) || (strlen($_DATOS_EXCEL[$i]['precio1m']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            
            $carpetaactual = 'reportes/';
            $noprecioesp = '';

            for($j=1; $j < $i; $j++)
            {
                // obtengo los datos del registro
                $codsucursal = $_DATOS_EXCEL[$j]['codsucursal'];
                $codigo = $_DATOS_EXCEL[$j]['codigo'];
                $precio1m = $_DATOS_EXCEL[$j]['precio1m'];

                // Inicialización de variables
                $lbgrabo = false;
                $codigosucursal = "";
                $sucursalid = 0;
                $codigoproducto = "";
                $vsql6 = "";
                $numpreciosesp = 0;
                $precioid = 0;
                $vsql7 = "";
                $vsql = "";
                $nombresucursal = "";

                // Valido que la sucursal exista
                $codigosucursal = $clase->BDLockup($codsucursal,'sucursales','codigo','codigo');

                if($codigosucursal != "")
                {
                    $sucursalid = $clase->BDLockup($codsucursal,'sucursales','codigo','sucursalid');

                    // Valido que el producto exista
                    $codigoproducto = $clase->BDLockup($codigo,'productos','codigo','codigo');
                    if($codigoproducto != "")
                    {
                        $productoid = $clase->BDLockup($codigoproducto,'productos','codigo','productoid');

                        // Determino si el producto tiene precio especial en esta sucursal
                        $vsql6 = "SELECT COUNT(*) AS numpreciosesp FROM preciosespeciales WHERE productoid = ".$productoid." AND sucursalid = ".$sucursalid;
                        $numpreciosesp = $clase->SeleccionarUno($vsql6);

                        if($numpreciosesp == 0)
                        {
                            // incluyo un nuevo precio especial
                            $precio1d = 0;
                            $porcenespe = 0;

                            // Almaceno la nueva lista especial
                            $vsql = "INSERT INTO preciosespeciales (productoid,sucursalid,precio1d,precio1m,porcenespe,creador,momento,ultcambio) 
                                        VALUES (".$productoid.",".$sucursalid.",".$precio1d.",".$precio1m.",".$porcenespe.",'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP)";
                        }
                        else
                        {
                            // ubico el id del precio especial
                            $vsql7 = "SELECT precioid FROM preciosespeciales WHERE productoid = ".$productoid." AND sucursalid = ".$sucursalid;
                            $precioid = $clase->SeleccionarUno($vsql7);

                            // almaceno la modificación
                            $vsql = "UPDATE preciosespeciales SET precio1m = ".$precio1m." WHERE precioid = ".$precioid;
                        }
                        $clase->EjecutarSQL($vsql);

                        if(mysql_affected_rows() >= 1)
                        {
                            $grabados++;
                            $lbgrabo = true;
                        }
                    }
                }

                if(!$lbgrabo)
                {
                    $nombresucursal = "FARMANORTE ".$codsucursal;

                    $noprecioesp.= str_pad($nombresucursal,1,"").'         CODIGO: '.str_pad($codigo,1,"").Chr(13).Chr(10);                 // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresprecioesp.txt";                                                                                      // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                                                                         // se abre el archivo para escribir
                    fwrite($fd, $noprecioesp);                                                                                              // Grabas
                    fclose($fd);                                                                                                            // Cierras el archivo
                }
            }

            $noprecioesp = str_replace('FARMANORTE          CODIGO: ','',$noprecioesp);
            $fechoraimp = fechayhoraejecucion();

            $noprecioesp.= ''.Chr(13).Chr(10);
            $noprecioesp.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);               // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresprecioesp.txt";                                                      // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                                         // se abre el archivo para escribir
            fwrite($fd, $noprecioesp);                                                              // Grabas
            fclose($fd);                                                                            // Cierras el archivo

            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los precios especiales");
            else
                $clase->Aviso(1,"Se cargaron satisfactoriamente $grabados precios especiales");
    
            // Redirecciono el formulario
            header("Location: preciosespeciales.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererrores
    // Creación: 29/05/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para emitir la información del archivo de 
    //              texto erroresprecioesp.txt
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "vererrores")
    {
        // Inicialización de variables
        $archivoerror = "reportes/erroresprecioesp.txt";
        $btnaceptar = '<a href="preciosespeciales.php">';
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("No se han generado errores en la importación de estos datos");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        // echo $txt; exit();
        $txt = trim(str_replace("<br />","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Precios especiales no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
                   '.$btnaceptar.'<input type="button" value="aceptar" class="button blue"></a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: preciosespxls
    // Creación: 29/05/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera una hoja de Excel con los precios especiales de la 
    //              vista principal
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "preciosespxls")
    {
        // Consulta para la salida a Excel
        $vsql = $_SESSION['SQL_PRECIOESPECIALXLS'];

        // preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("precios especiales - DROPOS")
                                     ->setSubject("precios especiales - DROPOS")
                                     ->setDescription("precios especiales - DROPOS")
                                     ->setKeywords("precios especiales - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'PRECIOS ESPECIALES')
                    ->setCellValue('A3', 'CODSUC')
                    ->setCellValue('B3', 'SUCURSAL')
                    ->setCellValue('C3', 'CODIGO')
                    ->setCellValue('D3', 'PRODUCTO')
                    ->setCellValue('E3', 'PRECIO ACTUAL')
                    ->setCellValue('F3', 'PRECIO DESCUENTO')
                    ->setCellValue('G3', 'DIFERENCIA');
             
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        $i=4;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $cant   = @mysql_num_rows($result);
        while($row = @mysql_fetch_array($result))
        {
            $diferencia = $row['precioactual'] - $row['preciodcto'];

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['codsuc'])
                        ->setCellValue('B'.$i, $row['nomsuc'])
                        ->setCellValue('C'.$i, $row['codigo'])
                        ->setCellValue('D'.$i, $row['descripcion'])
                        ->setCellValue('E'.$i, number_format($row['precioactual']))
                        ->setCellValue('F'.$i, number_format($row['preciodcto']))
                        ->setCellValue('G'.$i, number_format($diferencia));
            $i++;
        }

        $rangoEncabezado = 'A3:G3';
        $rangoCeldas     = 'A3:G'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('precios especiales');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        $nombrearcexcel = "precios especiales.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtro
    // Creación: 02/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para una búsqueda por sucursal y/o producto
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtro")
    {
        $params = ' class="Texto11" ';
        $vsqlcombosucursal = "SELECT codigo , descripcion FROM sucursales";
        $vsqlcomboproducto = "SELECT productoid, CONCAT(codigo,' - ',descripcion) FROM productos WHERE 1 ORDER BY productoid ASC";

        $cont ='<form action="?opcion=filtrar" method="POST" name="x">
                <table width="600">
                 <tr class="CabezoteTabla"> 
                  <td width="50" align="left"> <img src="images/iconos/vistaprevia.png" width="32" height="32" border="0"> </td>
                  <td width="550" align="center"> <b> Filtrar precios especiales </b> </td> 
                 </tr> 
                </table>
                <table width="600">
                 <tr class="TablaDocsImPar">				
                  <td width="80" align="right"> <label class="Texto12"> Sucursal: </label></td> 			  
                  <td width="520" align="left">
                   &nbsp;&nbsp;
                   '.$clase->CrearComboBuscar("codsucursal",$vsqlcombosucursal,"descripcion","codigo","","S",$params,200).'                    
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">				
                  <td width="80" align="right"> <label class="Texto12"> Producto: </label></td> 			  
                  <td width="520" align="left">
                   &nbsp;&nbsp;
                   '.$clase->CrearComboBuscar("productoid",$vsqlcomboproducto,"descripcion","productoid","","S",$params,500).'
                  </td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="preciosespeciales.php"><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrar
    // Creación: 02/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que realiza la búsqueda enviada desde la opción filtro
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrar")
    {
        $codsucursal = $_POST['codsucursal'];
        $productoid = $_POST['productoid'];

        $cwhere = " WHERE PE.precioid > 0 ";        

        // filtro por sucursal
        if(strlen($codsucursal)>0)
        {
            $sucursalid = $clase->BDLockup($codsucursal,'sucursales','codigo','sucursalid');
            $cwhere.= " AND PE.sucursalid = ".$sucursalid." ";
        }

        // filtro por producto
        if(strlen($productoid)>0)
            $cwhere.= " AND PE.productoid = ".$productoid." ";

        // Construyo la consulta con todos los filtros necesarios para la misma
        $vsql = "SELECT S.codigo codsuc , S.descripcion nomsuc , P.codigo , P.descripcion , P.precio1m precioactual , PE.precio1m preciodcto, PE.precioid   
                   FROM preciosespeciales PE 
                        INNER JOIN productos P ON (PE.productoid = P.productoid) 
                        INNER JOIN sucursales S ON (S.sucursalid = PE.sucursalid) 
                ".$cwhere."
               ORDER BY 1 ASC , 4 ASC";
        
        // redirecciono a la vista principal
        $_SESSION['SQL_PRECIOESP'] = $vsql;
        header("Location: preciosespeciales.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 02/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que anula la búsqueda de la opción filtrar
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "nofiltro")
    {
        $vsql = "SELECT S.codigo codsuc , S.descripcion nomsuc , P.codigo , P.descripcion , P.precio1m precioactual , PE.precio1m preciodcto, PE.precioid   
                   FROM preciosespeciales PE 
                        INNER JOIN productos P ON (PE.productoid = P.productoid) 
                        INNER JOIN sucursales S ON (S.sucursalid = PE.sucursalid) 
               ORDER BY 1 ASC , 4 ASC";
      $_SESSION['SQL_PRECIOESP'] = "";
      header("Location: preciosespeciales.php");    
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función fechayhoraejecucion
    // Parámetro de entrada:    Ninguno
    // Valor de retorno:        $fechoraimp --> día, fecha y hora
    // Descripción: Función que devuelve la fecha con día, fecha y hora de ejecución del 
    //              último proceso
    ////////////////////////////////////////////////////////////////////////////////////////
    function fechayhoraejecucion()
    {
        $mesimp = date('F');
        if($mesimp == "January")       $mesimp = "enero";
        if($mesimp == "February")      $mesimp = "febrero";
        if($mesimp == "March")         $mesimp = "marzo";
        if($mesimp == "April")         $mesimp = "abril";
        if($mesimp == "May")           $mesimp = "mayo";
        if($mesimp == "June")          $mesimp = "junio";
        if($mesimp == "July")          $mesimp = "julio";
        if($mesimp == "August")        $mesimp = "agosto";
        if($mesimp == "September")     $mesimp = "septiembre";
        if($mesimp == "October")       $mesimp = "octubre";
        if($mesimp == "November")      $mesimp = "noviembre";
        if($mesimp == "December")      $mesimp = "diciembre";

        $dayweek = date("l");
        if($dayweek == "Monday")       $dayweek = "lunes";
        if($dayweek == "Tuesday")      $dayweek = "martes";
        if($dayweek == "Wednesday")    $dayweek = "miércoles";
        if($dayweek == "Thursday")     $dayweek = "jueves";
        if($dayweek == "Friday")       $dayweek = "viernes";
        if($dayweek == "Saturday")     $dayweek = "sábado";
        if($dayweek == "Sunday")       $dayweek = "domingo";

        $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');
        return($fechoraimp);
    }

    echo $cont.$clase->PiePagina();
?>