<?PHP
  @session_start(); 
  include("lib/Sistema.php");  
  
  $clase = new Sistema();
  $clase->Nombredb = $_SESSION['DBNOMBRE'];  
  $avisos = ""; 
  $opcion = "";
  $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 05/12/2020		última modificación: 19/3/2021
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para la captación de datos del informe  
    //              planilla de nómina
    // Última modificación: Optimización del combo de periodos filtrando los periodos 
    //                      cerrados y el actual.
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codigo, CONCAT(codigo,' - ',descripcion) 
                                FROM periodosnomina 
                               WHERE cerrado ='CHECKED' OR 
                                     periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')                                    
                            ORDER BY periodoid ASC";

        $excel = "excel";
    
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/boletines.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Planilla de nómina </b></td>
                  <td width="50" align="center"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';    
        
        $cont.='<form action="planillanom.php?opcion=planillanomina" method="POST" name="x" target="_blank">
                 <center>
                 <table width="100%">
                  <tr class="BarraDocumentos">
                   <td align="center"><br><br><b> Datos del informe <br><br></td>
                  </tr>
                 </table>  
                 <table width="100%">
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Periodo: </td>
                   <td width="120">';

        $cont.= $clase->CrearComboBuscar("codigo",$vsqlcomboperiodo,"descripcion","codigo","","N",$params,400);
                    
        $cont.='   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                 </table>                   
                 <table width="100%">                     
                  <tr class="BarraDocumentos"> 
                   <td width="371" height="50" align="center">&nbsp;  </td>      
                   <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"></td>
                   <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"></td>
                   <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"></td> 
                   <td width="380" height="50" align="center">&nbsp;  </td>
                  </tr>
                 </table> 
                </form>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                </table>';
        echo $cont.$clase->PiePagina();  
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: planillanomina
    // Creación: 05/12/2020		última modificación: 12/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que imprime el informe planilla de nómina de acuerdo al 
    //              tipo de salida que se seleccione en la opción “ventanadatos” 
    //              (vista, PDF o Excel)
    // Última modificación: Opción de la salida en PDF (09/12/2020)
    //                      salida en vista del sistema (14/12/2020)
    //                      salida en una hoja de excel (15/12/2020)
    //                      Exclusión en la sumatoria de descuentos de las licencias no 
    //                      remuneradas y las suspensiones (19/02/2021)
    //                      Nombre del periodo en la salida a Excel (10/07/2021)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Se incorporaron los totales de cada área y de ambas áreas en la 
    //                      salida a Excel (18/08/2021)
    //                      Inclusión de los campos: días y valor de incapacidad, licencias 
    //                      remuneradas, suspensión y licencias no remuneradas, incapacidad 
    //                      superior a 180 días y cargo (19/04/2024)
    //                      Inclusión de la licencia día de la familia en los días y valores 
    //                      de las licencias remuneradas (20/05/2024)
    //                      En la salida a Excel se incluyeron las columnas para los 
    //                      conceptos tipo recargos
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion=="planillanomina")
    {
        $codigo  = $_POST['codigo'];            // Variable para filtrar el periodo        
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($codigo,'periodosnomina','codigo','descripcion');

        // Variable para el ID del periodo
        $periodoid  = $clase->BDLockup($codigo,'periodosnomina','codigo','periodoid');

        // Valido que el periodo tenga datos para emitir el reporte
        $vsqldatos = "SELECT COUNT(*) AS numreg FROM detallenomina WHERE pernominaid = ".$periodoid."";
        $numreg = $clase->SeleccionarUno($vsqldatos);

        if($numreg==0)
        {
            $clase->Aviso(3,"El periodo $descripcion no posee información");
            header("Location: planillanom.php?opcion=ventanadatos");
        }
        else
        {
            // Validación de que el periodo esté calculado
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado!="CHECKED")
            {
                // Mensaje correspondiente
                $clase->Aviso(3,"No se puede emitir el reporte del periodo $descripcion porque no está calculado");
    
                // Redirecciona el formulario
                header("Location: repconceptoporperiodo.php?opcion=ventanadatos");            
            }
            else
            {
                // Variable para determinar si el periodo está abierto o cerrado
                $cerrado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');
    
                if($tiposalida=="vista")
                {
                    $cont = Encabezado2("Planilla de nómina",$descripcion);
    
                    // Datos del área de administración
                    $cont.='<table width="1300">                         
                             <tr class="CabezoteTabla">
                              <td width="10">&nbsp;</td>
                              <td width="220" align="center"> AREA: ADMINISTRACION </td>		 				   
                              <td width="120" align="right"> &nbsp; </td>
                              <td width="120" align="right"> &nbsp; </td>	
                              <td width="120" align="right"> &nbsp; </td>	
                              <td width="120" align="right"> &nbsp; </td>
                              <td width="120" align="right"> &nbsp; </td>
                              <td width="140" align="right"> &nbsp; </td>
                              <td width="140" align="right"> &nbsp; </td>
                              <td width="150" align="right"> &nbsp; </td>
                              <td width="250" align="center">&nbsp; </td>
                              <td width="10"> &nbsp; </td>		
                             </tr>
                            </table>';
    
                    $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                            <table width="1250" class="sortable">
                             <thead> 
                              <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                               <td width="6">&nbsp;</td>
                               <td width="43" align="center"> Cod </td>				 				 
                               <td width="171" align="left"><p>Nombre Empleado</p></td>				 				                  
                               <td width="45" align="center">Días</B> </td>			
                               <td width="105" align="right">Básico</B> </td>			
                               <td width="90" align="right"><p>Salario </p></td>					
                               <td width="93" align="right">Transporte</B> </td>			
                               <td width="111" align="right">Devengado</B> </td>					
                               <td width="103" align="right">Descuentos</B> </td>			
                               <td width="87" align="right">Salud</B> </td>					
                               <td width="107" align="right">Pensión</td>							 	 
                               <td width="105" align="right">Deducción</td>
                               <td width="102" align="right">Neto a pagar</td>
                               <td width="22">&nbsp;</td>					
                              </tr>
                             </thead>
                             <tbody style="display:block; width:1200px; height:400px; overflow-Y:scroll">                         ';                
    
                    // Consulta para los empleados del área de administración
                    if($cerrado=="CHECKED")
                        $vsql = "SELECT p.areaid, a.descripcionarea, p.codvende, p.nombre AS nombreemp, 
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, p.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM periodoterceros p          
                                        INNER JOIN hisdetallenomina d ON (p.terid = d.terid)          
                                        INNER JOIN areanomina a ON (p.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND p.pernominaid = ".$periodoid."
                                        AND (p.esempleadoactivo='CHECKED' AND (p.extralegal = '' OR p.extralegal IS NULL))
                                        AND p.areaid = 1                                     
                               GROUP BY p.terid";
                    else
                        $vsql = "SELECT t.areaid, a.descripcionarea, t.codvende, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, t.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM tercerosactual t          
                                        INNER JOIN detallenomina d ON (t.terid = d.terid)          
                                        INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                                        AND t.areaid = 1 
                               GROUP BY t.terid";
    
                    // Inicializo las variables
                    $i = 0;
                    $totsalarioadm = 0;
                    $tottrasporteadm = 0;
                    $totdevengadoadm = 0;
                    $totdescuentosadm = 0;
                    $totsaludadm = 0;
                    $totpensionadm = 0;
                    $totdeduccionadm = 0;
                    $totnetoadm = 0;
                    $longitud = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        $i++;
                        if($i%2 == 0)
                            $cont.='<tr class="TablaDocsPar">';
                        else
                            $cont.='<tr class="TablaDocsImPar">';
    
                        $cont.=' <td width="6">&nbsp;</td>
                                 <td width="43" align="center"> '.$row['codvende'].' </td>				 				 
                                 <td width="171" align="left">'.$row['nombreemp'].'</td>				 				                  
                                 <td width="45" align="center">'.number_format($row['dias']).'</td>			
                                 <td width="105" align="right">'.number_format($row['basico']).'</td>			
                                 <td width="90" align="right">'.number_format($row['salario']).'</td>					
                                 <td width="93" align="right">'.number_format($row['transporte']).' </td>			
                                 <td width="111" align="right">'.number_format($row['devengado']).' </td>					
                                 <td width="103" align="right">'.number_format($row['descuentos']).' </td>			
                                 <td width="87" align="right">'.number_format($row['salud']).' </td>					
                                 <td width="107" align="right">'.number_format($row['pension']).'</td>							 	 
                                 <td width="105" align="right">'.number_format($row['deduccion']).'</td>
                                 <td width="102" align="right">'.number_format($row['neto']).'</td>
                                 <td width="22">&nbsp;</td>					
                                </tr>';
    
                        // Incremento de los totales
                        $totsalarioadm += $row['salario'];
                        $tottrasporteadm += $row['transporte'];
                        $totdevengadoadm += $row['devengado'];
                        $totdescuentosadm += $row['descuentos'];
                        $totsaludadm += $row['salud'];
                        $totpensionadm += $row['pension'];
                        $totdeduccionadm += $row['deduccion'];
                        $totnetoadm += $row['neto'];
                    }
    
                    $cont.=' </tbody> 
                            </table>';
    
                    // Impresión del total
                    $cont.='<table width="1200">
                             <tr class="TituloTabla"> 
                              <td width="6"> &nbsp; </td>
                              <td width="45" align="center"> &nbsp;</td>			
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>                          
                              <td width="105" align="right"> <b>Totales:</b> </td>			
                              <td width="90" align="right"> '.number_format($totsalarioadm).'</td>					
                              <td width="93" align="right">'.number_format($tottrasporteadm).'</td>			
                              <td width="111" align="right">'.number_format($totdevengadoadm).'</td>					
                              <td width="103" align="right">'.number_format($totdescuentosadm).'</td>			
                              <td width="87" align="right">'.number_format($totsaludadm).' </td>					
                              <td width="107" align="right">'.number_format($totpensionadm).'</td>							 	 
                              <td width="105" align="right">'.number_format($totdeduccionadm).'</td>
                              <td width="102" align="right">'.number_format($totnetoadm).'</td>
                              <td width="22"> &nbsp; </td>                          
                             </tr>
                            </table>';
    
                    // // Datos del área de ventas
                    $cont.='<table width="1300">                         
                             <tr class="CabezoteTabla">
                              <td width="10">&nbsp;</td>
                              <td width="220" align="center"> AREA: VENTAS </td>				 				   
                              <td width="120" align="right"> &nbsp; </td>			
                              <td width="120" align="right"> &nbsp; </td>			
                              <td width="120" align="right"> &nbsp; </td>					
                              <td width="120" align="right"> &nbsp; </td>			
                              <td width="120" align="right"> &nbsp; </td>					
                              <td width="140" align="right"> &nbsp; </td>			
                              <td width="140" align="right"> &nbsp; </td>					
                              <td width="150" align="right"> &nbsp; </td>							 	 
                              <td width="250" align="center">&nbsp;  </td>							 	     		     
                              <td width="10"> &nbsp; </td>					
                             </tr>
                            </table>';
    
                    $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                            <table width="1250" class="sortable">
                            <thead> 
                            <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                              <td width="6">&nbsp;</td>
                              <td width="43" align="center"> Cod </td>				 				 
                              <td width="171" align="left"><p>Nombre Empleado</p></td>				 				                  
                              <td width="45" align="center">Días</B> </td>			
                              <td width="105" align="right">Básico</B> </td>			
                              <td width="90" align="right"><p>Salario </p></td>					
                              <td width="93" align="right">Transporte</B> </td>			
                              <td width="111" align="right">Devengado</B> </td>					
                              <td width="103" align="right">Descuentos</B> </td>			
                              <td width="87" align="right">Salud</B> </td>					
                              <td width="107" align="right">Pensión</td>							 	 
                              <td width="105" align="right">Deducción</td>
                              <td width="102" align="right">Neto a pagar</td>
                              <td width="22">&nbsp;</td>					
                             </tr>
                             </thead>
                             <tbody style="display:block; width:1200px; height:400px; overflow-Y:scroll">                         ';                
    
                    // Consulta para los empleados del área de ventas
                    if($cerrado=="CHECKED")
                        $vsql = "SELECT p.areaid, a.descripcionarea, p.codvende, p.nombre AS nombreemp,  
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, p.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM periodoterceros p          
                                        INNER JOIN hisdetallenomina d ON (p.terid = d.terid)          
                                        INNER JOIN areanomina a ON (p.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND p.pernominaid = ".$periodoid."
                                        AND (p.esempleadoactivo='CHECKED' AND (p.extralegal = '' OR p.extralegal IS NULL))
                                        AND p.areaid = 2 
                               GROUP BY p.terid";                
                    else
                        $vsql = "SELECT t.areaid, a.descripcionarea, t.codvende, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,  
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, t.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM tercerosactual t          
                                        INNER JOIN detallenomina d ON (t.terid = d.terid)          
                                        INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                                        AND t.areaid = 2 
                            GROUP BY t.terid";
    
                    // Inicializo las variables
                    $i = 0;
                    $totsalariovts = 0;
                    $tottrasportevts = 0;
                    $totdevengadovts = 0;
                    $totdescuentosvts = 0;
                    $totsaludvts = 0;
                    $totpensionvts = 0;
                    $totdeduccionvts = 0;
                    $totnetovts = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        $i++;
                        if($i%2 == 0)
                            $cont.='<tr class="TablaDocsPar">';
                        else
                            $cont.='<tr class="TablaDocsImPar">';
    
                        $cont.=' <td width="6">&nbsp;</td>
                                 <td width="43" align="center"> '.$row['codvende'].' </td>				 				 
                                 <td width="171" align="left">'.$row['nombreemp'].'</td>				 				                  
                                 <td width="45" align="center">'.number_format($row['dias']).'</td>			
                                 <td width="105" align="right">'.number_format($row['basico']).'</td>			
                                 <td width="90" align="right">'.number_format($row['salario']).'</td>					
                                 <td width="93" align="right">'.number_format($row['transporte']).' </td>			
                                 <td width="111" align="right">'.number_format($row['devengado']).' </td>					
                                 <td width="103" align="right">'.number_format($row['descuentos']).' </td>			
                                 <td width="87" align="right">'.number_format($row['salud']).' </td>					
                                 <td width="107" align="right">'.number_format($row['pension']).'</td>							 	 
                                 <td width="105" align="right">'.number_format($row['deduccion']).'</td>
                                 <td width="102" align="right">'.number_format($row['neto']).'</td>
                                 <td width="22">&nbsp;</td>					
                                </tr>';
    
                        // Incremento de los totales
                        $totsalariovts += $row['salario'];
                        $tottrasportevts += $row['transporte'];
                        $totdevengadovts += $row['devengado'];
                        $totdescuentosvts += $row['descuentos'];
                        $totsaludvts += $row['salud'];
                        $totpensionvts += $row['pension'];
                        $totdeduccionvts += $row['deduccion'];
                        $totnetovts += $row['neto'];
                    }
    
                    $cont.=' </tbody> 
                            </table>';
    
                    // Impresión del total
                    $cont.='<table width="1200">
                             <tr class="TituloTabla"> 
                              <td width="6"> &nbsp; </td>
                              <td width="45" align="center"> &nbsp;</td>		
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>                                                    	
                              <td width="105" align="right"> <b>Totales:</b> </td>			
                              <td width="90" align="right"> '.number_format($totsalariovts).'</td>					
                              <td width="93" align="right">'.number_format($tottrasportevts).'</td>			
                              <td width="111" align="right">'.number_format($totdevengadovts).'</td>					
                              <td width="103" align="right">'.number_format($totdescuentosvts).'</td>			
                              <td width="87" align="right">'.number_format($totsaludvts).' </td>					
                              <td width="107" align="right">'.number_format($totpensionvts).'</td>							 	 
                              <td width="105" align="right">'.number_format($totdeduccionvts).'</td>
                              <td width="102" align="right">'.number_format($totnetovts).'</td>
                              <td width="22"> &nbsp; </td>                          
                             </tr>
                            </table>';
    
                    // Totales de ambas áreas
                    $totsalario = $totsalarioadm + $totsalariovts;
                    $tottrasporte = $tottrasporteadm + $tottrasportevts;
                    $totdevengado = $totdevengadoadm + $totdevengadovts;
                    $totdescuentos = $totdescuentosadm + $totdescuentosvts;
                    $totsalud = $totsaludadm + $totsaludvts;
                    $totpension = $totpensionadm + $totpensionvts;
                    $totdeduccion = $totdeduccionadm + $totdeduccionvts;
                    $totneto = $totnetoadm + $totnetovts;
    
                    $cont.='<table width="1200">
                             <tr class="TituloTabla"> 
                              <td width="6"> &nbsp; </td>
                              <td width="45" align="center"> &nbsp;</td>			
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>
                              <td width="45" align="center"> &nbsp;</td>                                                    
                              <td width="105" align="right"> <b>Totales:</b> </td>			
                              <td width="90" align="right"> '.number_format($totsalario).'</td>					
                              <td width="93" align="right">'.number_format($tottrasporte).'</td>			
                              <td width="111" align="right">'.number_format($totdevengado).'</td>					
                              <td width="103" align="right">'.number_format($totdescuentos).'</td>			
                              <td width="87" align="right">'.number_format($totsalud).' </td>					
                              <td width="107" align="right">'.number_format($totpension).'</td>							 	 
                              <td width="105" align="right">'.number_format($totdeduccion).'</td>
                              <td width="102" align="right">'.number_format($totneto).'</td>
                              <td width="22"> &nbsp; </td>                          
                             </tr>
                            </table>';
    
                    echo $cont;
                }
    
                if($tiposalida=="pdf")
                {
                    // Traducción al español del mes que devuelve la función date()
                    $mesimp = date('F');
                    if($mesimp=="January")       $mesimp = "Enero";
                    if($mesimp=="February")      $mesimp = "Febrero";
                    if($mesimp=="March")         $mesimp = "Marzo";
                    if($mesimp=="April")         $mesimp = "Abril";
                    if($mesimp=="May")           $mesimp = "Mayo";
                    if($mesimp=="June")          $mesimp = "Junio";
                    if($mesimp=="July")          $mesimp = "Julio";
                    if($mesimp=="August")        $mesimp = "Agosto";
                    if($mesimp=="September")     $mesimp = "Septiembre";
                    if($mesimp=="October")       $mesimp = "Octubre";
                    if($mesimp=="November")      $mesimp = "Noviembre";
                    if($mesimp=="December")      $mesimp = "Diciembre";
    
                    // Inicialización de totales
                    $totsalario = 0;
                    $tottrasporte = 0;
                    $totdevengado = 0;
                    $totdescuentos = 0;
                    $totsalud = 0;
                    $totpension = 0;
                    $totdeduccion = 0;
                    $totneto = 0;
                    $item = 0;
    
                    $clase = new Sistema();
                    ini_set("memory_limit","200M");
                    require('lib/fpdf/fpdf.php');
                    $pdf = new FPDF('L','mm','legal');
    
                    $pdf->AddPage("");
    
                    // Logo Dromedicas
                    $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
                    $x = 35;
                    $y = 15;
                    $pagina = 1;
    
                    // Impresión de la planilla de nómina para el área de administración
                    $pdf->SetFont('Arial','B',10);
                    $enc= "PLANILLA DE NOMINA";
                    $pdf->Text($x,$y,$enc);
                    
                    // Fecha y hora de impresión
                    $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                    $pdf->SetFont('Arial','',8);
                    $pdf->Text($x+250,$y,$fechoraimp);
    
                    $pdf->SetFont('Arial','B',10);
                    $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                    $pdf->Text($x,$y+7,$enc);
                    
                    $enc= "NOMINA: ";
                    $pdf->Text(35,$y+14,$enc);
        
                    $pdf->SetFont('Arial','',10);
                    $enc=strtoupper($descripcion);
                    $pdf->Text($x+18,$y+14,$enc);
    
                    $pdf->SetFont('Arial','B',10);
                    $enc= "AREA: ADMINISTRACION";
                    $pdf->Text(10,$y+26,$enc);
    
                    $pdf->SetFillColor(220,220,220);
                    $pdf->Rect(7,$y+28,340,8,'F');
                    
                    $enc= "COD";
                    $pdf->Text(16,$y+33,$enc);
                    
                    $enc= "NOMBRE EMPLEADO";
                    $pdf->Text(28,$y+33,$enc);
    
                    $enc= "DIAS";
                    $pdf->Text(90,$y+33,$enc);
    
                    $enc= "BASICO";
                    $pdf->Text(108,$y+33,$enc);
    
                    $enc= "SALARIO";
                    $pdf->Text(130,$y+33,$enc);
    
                    $enc= "TRANSPORTE";
                    $pdf->Text(153,$y+33,$enc);
    
                    $enc= "DEVENGADO";
                    $pdf->Text(186,$y+33,$enc);
    
                    $enc= "DESCUENTOS";
                    $pdf->Text(218,$y+33,$enc);
    
                    $enc= "SALUD";
                    $pdf->Text(250,$y+33,$enc);
    
                    $enc= "PENSION";
                    $pdf->Text(268,$y+33,$enc);
    
                    $enc= "DEDUCCION";
                    $pdf->Text(290,$y+33,$enc);
    
                    $enc= "NETO A PAGAR";
                    $pdf->Text(318,$y+33,$enc);
                    
                    // Consulta del informe con los datos, cálculos y filtros correspondientes
                    if($cerrado=="CHECKED")
                        $vsql = "SELECT p.areaid, a.descripcionarea, p.codvende, p.nombre AS nombreemp, 
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, p.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM periodoterceros p          
                                        INNER JOIN hisdetallenomina d ON (p.terid = d.terid)          
                                        INNER JOIN areanomina a ON (p.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND p.pernominaid = ".$periodoid."
                                        AND (p.esempleadoactivo='CHECKED' AND (p.extralegal = '' OR p.extralegal IS NULL))
                                        AND p.areaid = 1                                     
                               GROUP BY p.terid";
                    else
                        $vsql = "SELECT t.areaid, a.descripcionarea, t.codvende, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, t.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM tercerosactual t          
                                        INNER JOIN detallenomina d ON (t.terid = d.terid)          
                                        INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                                        AND t.areaid = 1                                    
                               GROUP BY t.terid";
    
                    // Inicializo las variables
                    $i = 0;
                    $totsalarioadm = 0;
                    $tottrasporteadm = 0;
                    $totdevengadoadm = 0;
                    $totdescuentosadm = 0;
                    $totsaludadm = 0;
                    $totpensionadm = 0;
                    $totdeduccionadm = 0;
                    $totnetoadm = 0;
                    $longitud = 0;
                    $x = 10;
                    $y = 56;
    
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        // Imprimo los datos de los empleados
                        $i++;
                        $pdf->SetFont('Arial','',8);
    
                        // Consecutivo de empleados
                        $longitud = strlen($i);
                        if($longitud==1)
                            $pdf->Text($x+3,$y,$i);
    
                        if($longitud==2)
                            $pdf->Text($x+2,$y,$i);
    
                        if($longitud==3)
                            $pdf->Text($x+1,$y,$i);
    
                        // Código y nombre del empleado
                        $pdf->Text($x+7,$y,$row['codvende']);
                        $pdf->Text($x+18,$y,$row['nombreemp']);
    
                        // Días trabajados
                        $longitud = strlen($row['dias']);
                        if($longitud==1)
                            $pdf->Text($x+87,$y,$row['dias']);
    
                        if($longitud==2)
                            $pdf->Text($x+85,$y,$row['dias']);
    
                        // Salario básico
                        $longitud = strlen($row['basico']);
                        if($longitud==6)
                            $pdf->Text($x+100,$y,number_format($row['basico'],0));
    
                        if($longitud==7)
                            $pdf->Text($x+98,$y,number_format($row['basico'],0));
    
                        // Salario en el periodo
                        if($row['salario']!=0)
                        {
                            $longitud = strlen($row['salario']);
                            if($longitud==1)
                                $pdf->Text($x+135,$y,number_format($row['salario'],0));
    
                            if($longitud==2)
                                $pdf->Text($x+133,$y,number_format($row['salario'],0));
    
                            if($longitud==3)
                                $pdf->Text($x+131,$y,number_format($row['salario'],0));
    
                            if($longitud==4)
                                $pdf->Text($x+129,$y,number_format($row['salario'],0));
    
                            if($longitud==5)
                                $pdf->Text($x+127,$y,number_format($row['salario'],0));
    
                            if($longitud==6)
                                $pdf->Text($x+125,$y,number_format($row['salario'],0));
        
                            if($longitud==7)
                                $pdf->Text($x+123,$y,number_format($row['salario'],0));
                                
                            $totsalarioadm += $row['salario'];             // Incremento del total
                        }
    
                        // Subsidio de transporte
                        if($row['transporte']!=0)
                        {
                            $longitud = strlen($row['transporte']);
                            if($longitud==1)
                                $pdf->Text($x+166,$y,number_format($row['transporte'],0));
    
                            if($longitud==2)
                                $pdf->Text($x+164,$y,number_format($row['transporte'],0));
    
                            if($longitud==3)
                                $pdf->Text($x+162,$y,number_format($row['transporte'],0));
    
                            if($longitud==4)
                                $pdf->Text($x+160,$y,number_format($row['transporte'],0));
    
                            if($longitud==5)
                                $pdf->Text($x+158,$y,number_format($row['transporte'],0));
                                
                            $tottrasporteadm += $row['transporte'];        // Incremento del total
                        }
    
                        // Devengado
                        $longitud = strlen($row['devengado']);
                        $pdf->SetFont('Arial','B',8);
                        if($longitud==1)
                            $pdf->Text($x+198,$y,number_format($row['devengado'],0));
    
                        if($longitud==2)
                            $pdf->Text($x+196,$y,number_format($row['devengado'],0));
    
                        if($longitud==3)
                            $pdf->Text($x+194,$y,number_format($row['devengado'],0));
    
                        if($longitud==4)
                            $pdf->Text($x+192,$y,number_format($row['devengado'],0));
    
                        if($longitud==5)
                            $pdf->Text($x+190,$y,number_format($row['devengado'],0));
    
                        if($longitud==6)
                            $pdf->Text($x+188,$y,number_format($row['devengado'],0));
    
                        if($longitud==7)
                            $pdf->Text($x+186,$y,number_format($row['devengado'],0));
    
                        $totdevengadoadm += $row['devengado'];             // Incremento del total
    
                        // Descuentos
                        $pdf->SetFont('Arial','',8);
                        if($row['descuentos']!=0)
                        {
                            $longitud = strlen($row['descuentos']);
                            if($longitud==1)
                                $pdf->Text($x+231,$y,number_format($row['descuentos'],0));
    
                            if($longitud==2)
                                $pdf->Text($x+229,$y,number_format($row['descuentos'],0));
    
                            if($longitud==3)
                                $pdf->Text($x+227,$y,number_format($row['descuentos'],0));
    
                            if($longitud==4)
                                $pdf->Text($x+225,$y,number_format($row['descuentos'],0));
    
                            if($longitud==5)
                                $pdf->Text($x+223,$y,number_format($row['descuentos'],0));
        
                            if($longitud==6)
                                $pdf->Text($x+221,$y,number_format($row['descuentos'],0));
    
                            $totdescuentosadm += $row['descuentos'];       // Incremento del total
                        }
    
                        // Descuentos por salud
                        $longitud = strlen($row['salud']);
                        if($longitud==1)
                            $pdf->Text($x+251,$y,number_format($row['salud'],0));
    
                        if($longitud==2)
                            $pdf->Text($x+249,$y,number_format($row['salud'],0));
    
                        if($longitud==3)
                            $pdf->Text($x+247,$y,number_format($row['salud'],0));
    
                        if($longitud==4)
                            $pdf->Text($x+245,$y,number_format($row['salud'],0));
    
                        if($longitud==5)
                            $pdf->Text($x+243,$y,number_format($row['salud'],0));
    
                        if($longitud==6)
                            $pdf->Text($x+241,$y,number_format($row['salud'],0));
                        
                        $totsaludadm += $row['salud'];                     // Incremento del total
    
                        // Descuento por pensión
                        $longitud = strlen($row['pension']);
                        if($longitud==1)
                            $pdf->Text($x+273,$y,number_format($row['pension'],0));
                        
                        if($longitud==2)
                            $pdf->Text($x+271,$y,number_format($row['pension'],0));
    
                        if($longitud==3)
                            $pdf->Text($x+269,$y,number_format($row['pension'],0));
    
                        if($longitud==4)
                            $pdf->Text($x+267,$y,number_format($row['pension'],0));
    
                        if($longitud==5)
                            $pdf->Text($x+265,$y,number_format($row['pension'],0));
    
                        $totpensionadm += $row['pension'];                 // Incremento del total
    
                        // Total deducción
                        $longitud = strlen($row['deduccion']);
                        $pdf->SetFont('Arial','B',8);
                        if($longitud==1)
                            $pdf->Text($x+301,$y,number_format($row['deduccion'],0));
    
                        if($longitud==2)
                            $pdf->Text($x+299,$y,number_format($row['deduccion'],0));
    
                        if($longitud==3)
                            $pdf->Text($x+297,$y,number_format($row['deduccion'],0));
    
                        if($longitud==4)
                            $pdf->Text($x+295,$y,number_format($row['deduccion'],0));
    
                        if($longitud==5)
                            $pdf->Text($x+293,$y,number_format($row['deduccion'],0));
    
                        if($longitud==6)
                            $pdf->Text($x+291,$y,number_format($row['deduccion'],0));
    
                        $totdeduccionadm += $row['deduccion'];             // Incremento del total
    
                        // Neto a pagar
                        $longitud = strlen($row['neto']);
                        if($longitud==1)
                            $pdf->Text($x+334,$y,number_format($row['neto'],0));
    
                        if($longitud==2)
                            $pdf->Text($x+333,$y,number_format($row['neto'],0));
    
                        if($longitud==3)
                            $pdf->Text($x+331,$y,number_format($row['neto'],0));
    
                        if($longitud==4)
                            $pdf->Text($x+329,$y,number_format($row['neto'],0));
    
                        if($longitud==5)
                            $pdf->Text($x+327,$y,number_format($row['neto'],0));
    
                        if($longitud==6)
                            $pdf->Text($x+325,$y,number_format($row['neto'],0));
    
                        if($longitud==7)
                            $pdf->Text($x+323,$y,number_format($row['neto'],0));
    
                        $totnetoadm += $row['neto'];                       // Incremento del total
    
                        $pdf->SetFont('Arial','',8);
                        $y+=6;
                        
                        if($i%25 == 0)
                        {
                            $pdf->AddPage("");
    
                            // Logo Dromedicas
                            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
                            $x = 35;
                            $y = 15;
                            $pagina++;
    
                            $pdf->SetFont('Arial','B',10);
                            $enc= "PLANILLA DE NOMINA";
                            $pdf->Text($x,$y,$enc);
                            
                            // Fecha y hora de impresión
                            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                            $pdf->SetFont('Arial','',8);
                            $pdf->Text($x+250,$y,$fechoraimp);
    
                            $pdf->SetFont('Arial','B',10);
                            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                            $pdf->Text($x,$y+7,$enc);
                            
                            $enc= "NOMINA: ";
                            $pdf->Text(35,$y+14,$enc);
                
                            $pdf->SetFont('Arial','',10);
                            $enc=strtoupper($descripcion);
                            $pdf->Text($x+18,$y+14,$enc);
    
                            $pdf->SetFont('Arial','B',10);
                            $enc= "AREA: ADMINISTRACION";
                            $pdf->Text(10,$y+26,$enc);
    
                            $pdf->SetFillColor(220,220,220);
                            $pdf->Rect(7,$y+28,340,8,'F');
                            
                            $enc= "COD";
                            $pdf->Text(16,$y+33,$enc);
                            
                            $enc= "NOMBRE EMPLEADO";
                            $pdf->Text(28,$y+33,$enc);
    
                            $enc= "DIAS";
                            $pdf->Text(90,$y+33,$enc);
    
                            $enc= "BASICO";
                            $pdf->Text(108,$y+33,$enc);
    
                            $enc= "SALARIO";
                            $pdf->Text(130,$y+33,$enc);
    
                            $enc= "TRANSPORTE";
                            $pdf->Text(153,$y+33,$enc);
    
                            $enc= "DEVENGADO";
                            $pdf->Text(186,$y+33,$enc);
    
                            $enc= "DESCUENTOS";
                            $pdf->Text(218,$y+33,$enc);
    
                            $enc= "SALUD";
                            $pdf->Text(250,$y+33,$enc);
    
                            $enc= "PENSION";
                            $pdf->Text(268,$y+33,$enc);
    
                            $enc= "DEDUCCION";
                            $pdf->Text(290,$y+33,$enc);
    
                            $enc= "NETO A PAGAR";
                            $pdf->Text(318,$y+33,$enc);
    
                            $x = 10;
                            $y = 56;        
                        }
                    }
    
                    // ----------------------------------------------------------------------------------- //
                    // Impresión de los totales
                    $pdf->SetFillColor(180,180,180);
                    $pdf->Rect(100,$y-3,248,8,'F');
    
                    $pdf->SetFont('Arial','B',10);
                    $enc= "TOTALES:";
                    $pdf->Text($x+93,$y+2,$enc);
    
                    // Total salario
                    $longitud = strlen($totsalarioadm);
                    if($longitud==7)
                        $pdf->Text($x+120,$y+2,number_format($totsalarioadm));
    
                    if($longitud==8)
                        $pdf->Text($x+118,$y+2,number_format($totsalarioadm));
    
                    if($longitud==9)
                        $pdf->Text($x+116,$y+2,number_format($totsalarioadm));
    
                    // Total subsidio de transporte
                    $longitud = strlen($tottrasporteadm);
                    if($longitud==7)
                        $pdf->Text($x+151,$y+2,number_format($tottrasporteadm));
    
                    if($longitud==8)
                        $pdf->Text($x+149,$y+2,number_format($tottrasporteadm));
    
                    // Total devengado
                    $longitud = strlen($totdevengadoadm);
                    if($longitud==8)
                        $pdf->Text($x+180,$y+2,number_format($totdevengadoadm));
    
                    if($longitud==9)
                        $pdf->Text($x+178,$y+2,number_format($totdevengadoadm));
    
                    // Total descuentos
                    $longitud = strlen($totdescuentosadm);                
    
                    if($longitud==4)
                        $pdf->Text($x+223,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==5)
                        $pdf->Text($x+221,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==6)
                        $pdf->Text($x+219,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==7)
                        $pdf->Text($x+217,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==8)
                        $pdf->Text($x+215,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==9)
                        $pdf->Text($x+212,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==10)
                        $pdf->Text($x+211,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==11)
                        $pdf->Text($x+209,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==12)
                        $pdf->Text($x+207,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==13)
                        $pdf->Text($x+205,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==14)
                        $pdf->Text($x+203,$y+2,number_format($totdescuentosadm));
    
                    if($longitud==15)
                        $pdf->Text($x+201,$y+2,number_format($totdescuentosadm));
    
    
                    // Total salud
                    $longitud = strlen($totsaludadm);
                    if($longitud==7)
                        $pdf->Text($x+236,$y+2,number_format($totsaludadm));
    
                    if($longitud==8)
                        $pdf->Text($x+234,$y+2,number_format($totsaludadm));
    
                    // Total pensión
                    $longitud = strlen($totpensionadm);
                    if($longitud==7)
                        $pdf->Text($x+258,$y+2,number_format($totpensionadm));
    
                    if($longitud==8)
                        $pdf->Text($x+256,$y+2,number_format($totpensionadm));
    
                    // Total deducción
                    $longitud = strlen($totdeduccionadm);                
    
                    if($longitud==7)
                        $pdf->Text($x+286,$y+2,number_format($totdeduccionadm));
    
                    if($longitud==8)
                        $pdf->Text($x+284,$y+2,number_format($totdeduccionadm));
    
                    if($longitud==9)
                        $pdf->Text($x+282,$y+2,number_format($totdeduccionadm));
    
                    if($longitud==10)
                        $pdf->Text($x+280,$y+2,number_format($totdeduccionadm));
    
                    if($longitud==11)
                        $pdf->Text($x+278,$y+2,number_format($totdeduccionadm));
    
                    if($longitud==12)
                        $pdf->Text($x+276,$y+2,number_format($totdeduccionadm));
    
                    if($longitud==13)
                        $pdf->Text($x+274,$y+2,number_format($totdeduccionadm));
    
                    if($longitud==14)
                        $pdf->Text($x+272,$y+2,number_format($totdeduccionadm));
    
                    if($longitud==15)
                        $pdf->Text($x+284,$y+2,number_format($totdeduccionadm));
    
    
                    // Total del neto a pagar
                    $longitud = strlen($totnetoadm);
    
                    if($longitud==8)
                        $pdf->Text($x+317,$y+2,number_format($totnetoadm));
    
                    if($longitud==9)
                        $pdf->Text($x+315,$y+2,number_format($totnetoadm));
    
                    if($longitud==10)
                        $pdf->Text($x+313,$y+2,number_format($totnetoadm));
    
                    if($longitud==11)
                        $pdf->Text($x+311,$y+2,number_format($totnetoadm));
    
                    if($longitud==12)
                        $pdf->Text($x+309,$y+2,number_format($totnetoadm));
    
                    if($longitud==13)
                        $pdf->Text($x+307,$y+2,number_format($totnetoadm));
    
                    if($longitud==14)
                        $pdf->Text($x+305,$y+2,number_format($totnetoadm));
    
                    if($longitud==15)
                        $pdf->Text($x+317,$y+2,number_format($totnetoadm));
    
                    // ----------------------------------------------------------------------------------- //
                    // Impresión de la planilla de nómina para el área de ventas
    
                    $pdf->AddPage("");
    
                    // Logo Dromedicas
                    $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
                    $x = 35;
                    $y = 15;
                    $pagina++;
    
                    // Impresión de la planilla de nómina para el área de administración
                    $pdf->SetFont('Arial','B',10);
                    $enc= "PLANILLA DE NOMINA";
                    $pdf->Text($x,$y,$enc);
                    
                    // Fecha y hora de impresión
                    $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                    $pdf->SetFont('Arial','',8);
                    $pdf->Text($x+250,$y,$fechoraimp);
    
                    $pdf->SetFont('Arial','B',10);
                    $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                    $pdf->Text($x,$y+7,$enc);
                    
                    $enc= "NOMINA: ";
                    $pdf->Text(35,$y+14,$enc);
        
                    $pdf->SetFont('Arial','',10);
                    $enc=strtoupper($descripcion);
                    $pdf->Text($x+18,$y+14,$enc);
    
                    $pdf->SetFont('Arial','B',10);
                    $enc= "AREA: VENTAS";
                    $pdf->Text(10,$y+26,$enc);
    
                    $pdf->SetFillColor(220,220,220);
                    $pdf->Rect(7,$y+28,340,8,'F');
                    
                    $enc= "COD";
                    $pdf->Text(16,$y+33,$enc);
                    
                    $enc= "NOMBRE EMPLEADO";
                    $pdf->Text(28,$y+33,$enc);
    
                    $enc= "DIAS";
                    $pdf->Text(90,$y+33,$enc);
    
                    $enc= "BASICO";
                    $pdf->Text(108,$y+33,$enc);
    
                    $enc= "SALARIO";
                    $pdf->Text(130,$y+33,$enc);
    
                    $enc= "TRANSPORTE";
                    $pdf->Text(153,$y+33,$enc);
    
                    $enc= "DEVENGADO";
                    $pdf->Text(186,$y+33,$enc);
    
                    $enc= "DESCUENTOS";
                    $pdf->Text(218,$y+33,$enc);
    
                    $enc= "SALUD";
                    $pdf->Text(250,$y+33,$enc);
    
                    $enc= "PENSION";
                    $pdf->Text(268,$y+33,$enc);
    
                    $enc= "DEDUCCION";
                    $pdf->Text(290,$y+33,$enc);
    
                    $enc= "NETO A PAGAR";
                    $pdf->Text(318,$y+33,$enc);
    
                    if($cerrado=="CHECKED")
                        $vsql = "SELECT p.areaid, a.descripcionarea, p.codvende, p.nombre AS nombreemp,  
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, p.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM periodoterceros p          
                                        INNER JOIN hisdetallenomina d ON (p.terid = d.terid)          
                                        INNER JOIN areanomina a ON (p.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND p.pernominaid = ".$periodoid."
                                        AND (p.esempleadoactivo='CHECKED' AND (p.extralegal = '' OR p.extralegal IS NULL))
                                        AND p.areaid = 2 
                               GROUP BY p.terid";
                    else
                        $vsql = "SELECT t.areaid, a.descripcionarea, t.codvende, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,  
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, t.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto
                                   FROM tercerosactual t          
                                        INNER JOIN detallenomina d ON (t.terid = d.terid)          
                                        INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                                        AND t.areaid = 2 
                               GROUP BY t.terid";
    
                    // Inicializo las variables
                    $j = 0;
                    $totsalariovts = 0;
                    $tottrasportevts = 0;
                    $totdevengadovts = 0;
                    $totdescuentosvts = 0;
                    $totsaludvts = 0;
                    $totpensionvts = 0;
                    $totdeduccionvts = 0;
                    $totnetovts = 0;
                    $longitud = 0;
                    $x = 10;
                    $y = 56;
    
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        // Imprimo los datos de los empleados
                        $j++;
                        $pdf->SetFont('Arial','',8);
    
                        // Consecutivo de empleados
                        $longitud = strlen($j);
                        if($longitud==1)
                            $pdf->Text($x+3,$y,$j);
    
                        if($longitud==2)
                            $pdf->Text($x+2,$y,$j);
    
                        if($longitud==3)
                            $pdf->Text($x+1,$y,$j);
    
                        if($longitud==4)
                            $pdf->Text($x,$y,$j);                        
    
                        // Código y nombre del empleado
                        $pdf->Text($x+7,$y,$row['codvende']);
                        $pdf->Text($x+18,$y,$row['nombreemp']);
    
                        // Días trabajados
                        $longitud = strlen($row['dias']);
                        if($longitud==1)
                            $pdf->Text($x+87,$y,$row['dias']);
    
                        if($longitud==2)
                            $pdf->Text($x+85,$y,$row['dias']);
    
                        // Salario básico
                        $longitud = strlen($row['basico']);
                        if($longitud==6)
                            $pdf->Text($x+100,$y,number_format($row['basico'],0));
    
                        if($longitud==7)
                            $pdf->Text($x+98,$y,number_format($row['basico'],0));
    
                        // Salario en el periodo
                        if($row['salario']!=0)
                        {
                            $longitud = strlen($row['salario']);
                            if($longitud==1)
                                $pdf->Text($x+135,$y,number_format($row['salario'],0));
    
                            if($longitud==2)
                                $pdf->Text($x+133,$y,number_format($row['salario'],0));
    
                            if($longitud==3)
                                $pdf->Text($x+131,$y,number_format($row['salario'],0));
    
                            if($longitud==4)
                                $pdf->Text($x+129,$y,number_format($row['salario'],0));                        
                            
                            if($longitud==5)
                                $pdf->Text($x+127,$y,number_format($row['salario'],0));
    
                            if($longitud==6)
                                $pdf->Text($x+125,$y,number_format($row['salario'],0));
        
                            if($longitud==7)
                                $pdf->Text($x+123,$y,number_format($row['salario'],0));
                                
                            $totsalariovts += $row['salario'];             // Incremento del total
                        }
    
                        // Subsidio de transporte
                        if($row['transporte']!=0)
                        {
                            $longitud = strlen($row['transporte']);
                            if($longitud==1)
                                $pdf->Text($x+166,$y,number_format($row['transporte'],0));
    
                            if($longitud==2)
                                $pdf->Text($x+164,$y,number_format($row['transporte'],0));
    
                            if($longitud==3)
                                $pdf->Text($x+162,$y,number_format($row['transporte'],0));
    
                            if($longitud==4)
                                $pdf->Text($x+160,$y,number_format($row['transporte'],0));
    
                            if($longitud==5)
                                $pdf->Text($x+158,$y,number_format($row['transporte'],0));
                                
                            $tottrasportevts += $row['transporte'];        // Incremento del total
                        }
    
                        // Devengado
                        $longitud = strlen($row['devengado']);
                        $pdf->SetFont('Arial','B',8);
                        if($longitud==1)
                            $pdf->Text($x+198,$y,number_format($row['devengado'],0));
    
                        if($longitud==2)
                            $pdf->Text($x+196,$y,number_format($row['devengado'],0));
    
                        if($longitud==3)
                            $pdf->Text($x+194,$y,number_format($row['devengado'],0));                    
    
                        if($longitud==4)
                            $pdf->Text($x+192,$y,number_format($row['devengado'],0));
    
                        if($longitud==5)
                            $pdf->Text($x+190,$y,number_format($row['devengado'],0));
    
                        if($longitud==6)
                            $pdf->Text($x+188,$y,number_format($row['devengado'],0));
    
                        if($longitud==7)
                            $pdf->Text($x+186,$y,number_format($row['devengado'],0));
    
                        $totdevengadovts += $row['devengado'];             // Incremento del total
    
                        // Descuentos
                        $pdf->SetFont('Arial','',8);
                        if($row['descuentos']!=0)
                        {
                            $longitud = strlen($row['descuentos']);
                            if($longitud==1)
                                $pdf->Text($x+231,$y,number_format($row['descuentos'],0));
    
                            if($longitud==2)
                                $pdf->Text($x+229,$y,number_format($row['descuentos'],0));
    
                            if($longitud==3)
                                $pdf->Text($x+227,$y,number_format($row['descuentos'],0));
    
                            if($longitud==4)
                                $pdf->Text($x+225,$y,number_format($row['descuentos'],0));
    
                            if($longitud==5)
                                $pdf->Text($x+223,$y,number_format($row['descuentos'],0));
        
                            if($longitud==6)
                                $pdf->Text($x+221,$y,number_format($row['descuentos'],0));
    
                            $totdescuentosvts += $row['descuentos'];       // Incremento del total
                        }
    
                        // Descuentos por salud
                        $longitud = strlen($row['salud']);
                        if($longitud==1)
                            $pdf->Text($x+251,$y,number_format($row['salud'],0));
    
                        if($longitud==2)
                            $pdf->Text($x+249,$y,number_format($row['salud'],0));
    
                        if($longitud==3)
                            $pdf->Text($x+247,$y,number_format($row['salud'],0));
    
                        if($longitud==4)
                            $pdf->Text($x+245,$y,number_format($row['salud'],0));
    
                        if($longitud==5)
                            $pdf->Text($x+243,$y,number_format($row['salud'],0));
    
                        if($longitud==6)
                            $pdf->Text($x+241,$y,number_format($row['salud'],0));
                        
                        $totsaludvts += $row['salud'];                     // Incremento del total
    
                        // Descuento por pensión
                        $longitud = strlen($row['pension']);
                        if($longitud==1)
                            $pdf->Text($x+273,$y,number_format($row['pension'],0));
                        
                        if($longitud==2)
                            $pdf->Text($x+271,$y,number_format($row['pension'],0));
    
                        if($longitud==3)
                            $pdf->Text($x+269,$y,number_format($row['pension'],0));
    
                        if($longitud==4)
                            $pdf->Text($x+267,$y,number_format($row['pension'],0));
    
                        if($longitud==5)
                            $pdf->Text($x+265,$y,number_format($row['pension'],0));
    
                        $totpensionvts += $row['pension'];                 // Incremento del total
    
                        // Total deducción
                        $longitud = strlen($row['deduccion']);
                        $pdf->SetFont('Arial','B',8);
                        if($longitud==1)
                            $pdf->Text($x+301,$y,number_format($row['deduccion'],0));
    
                        if($longitud==2)
                            $pdf->Text($x+299,$y,number_format($row['deduccion'],0));
    
                        if($longitud==3)
                            $pdf->Text($x+297,$y,number_format($row['deduccion'],0));
    
                        if($longitud==4)
                            $pdf->Text($x+295,$y,number_format($row['deduccion'],0));
    
                        if($longitud==5)
                            $pdf->Text($x+293,$y,number_format($row['deduccion'],0));
    
                        if($longitud==6)
                            $pdf->Text($x+291,$y,number_format($row['deduccion'],0));
    
                        $totdeduccionvts += $row['deduccion'];             // Incremento del total
    
                        // Neto a pagar
                        $longitud = strlen($row['neto']);
                        if($longitud==1)
                            $pdf->Text($x+334,$y,number_format($row['neto'],0));
    
                        if($longitud==2)
                            $pdf->Text($x+333,$y,number_format($row['neto'],0));
    
                        if($longitud==3)
                            $pdf->Text($x+331,$y,number_format($row['neto'],0));
                            
                        if($longitud==4)
                            $pdf->Text($x+329,$y,number_format($row['neto'],0));
    
                        if($longitud==5)
                            $pdf->Text($x+327,$y,number_format($row['neto'],0));
    
                        if($longitud==6)
                            $pdf->Text($x+325,$y,number_format($row['neto'],0));
    
                        if($longitud==7)
                            $pdf->Text($x+323,$y,number_format($row['neto'],0));
    
                        $totnetovts += $row['neto'];                       // Incremento del total
    
                        $pdf->SetFont('Arial','',8);
                        $y+=6;
                        
                        if($j%25 == 0)
                        {
                            $pdf->AddPage("");
    
                            // Logo Dromedicas
                            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
                            $x = 35;
                            $y = 15;
                            $pagina++;
    
                            $pdf->SetFont('Arial','B',10);
                            $enc= "PLANILLA DE NOMINA";
                            $pdf->Text($x,$y,$enc);
                            
                            // Fecha y hora de impresión
                            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                            $pdf->SetFont('Arial','',8);
                            $pdf->Text($x+250,$y,$fechoraimp);
    
                            $pdf->SetFont('Arial','B',10);
                            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                            $pdf->Text($x,$y+7,$enc);
                            
                            $enc= "NOMINA: ";
                            $pdf->Text(35,$y+14,$enc);
                
                            $pdf->SetFont('Arial','',10);
                            $enc=strtoupper($descripcion);
                            $pdf->Text($x+18,$y+14,$enc);
    
                            $pdf->SetFont('Arial','B',10);
                            $enc= "AREA: VENTAS";
                            $pdf->Text(10,$y+26,$enc);
    
                            $pdf->SetFillColor(220,220,220);
                            $pdf->Rect(7,$y+28,340,8,'F');
                            
                            $enc= "COD";
                            $pdf->Text(16,$y+33,$enc);
                            
                            $enc= "NOMBRE EMPLEADO";
                            $pdf->Text(28,$y+33,$enc);
    
                            $enc= "DIAS";
                            $pdf->Text(90,$y+33,$enc);
    
                            $enc= "BASICO";
                            $pdf->Text(108,$y+33,$enc);
    
                            $enc= "SALARIO";
                            $pdf->Text(130,$y+33,$enc);
    
                            $enc= "TRANSPORTE";
                            $pdf->Text(153,$y+33,$enc);
    
                            $enc= "DEVENGADO";
                            $pdf->Text(186,$y+33,$enc);
    
                            $enc= "DESCUENTOS";
                            $pdf->Text(218,$y+33,$enc);
    
                            $enc= "SALUD";
                            $pdf->Text(250,$y+33,$enc);
    
                            $enc= "PENSION";
                            $pdf->Text(268,$y+33,$enc);
    
                            $enc= "DEDUCCION";
                            $pdf->Text(290,$y+33,$enc);
    
                            $enc= "NETO A PAGAR";
                            $pdf->Text(318,$y+33,$enc);
    
                            $x = 10;
                            $y = 56;        
                        }
                    }
    
                    // ----------------------------------------------------------------------------------- //
                    // Impresión de los totales
                    $pdf->SetFillColor(180,180,180);
                    $pdf->Rect(100,$y-3,247,8,'F');
    
                    $pdf->SetFont('Arial','B',10);
    
                    $enc= "TOTALES:";
                    $pdf->Text($x+93,$y+2,$enc);
    
                    // Total salario
                    $longitud = strlen($totsalariovts);
                    if($longitud==7)
                        $pdf->Text($x+120,$y+2,number_format($totsalariovts));
    
                    if($longitud==8)
                        $pdf->Text($x+118,$y+2,number_format($totsalariovts));
    
                    if($longitud==9)
                        $pdf->Text($x+116,$y+2,number_format($totsalariovts));
    
                    // Total subsidio de transporte
                    $longitud = strlen($tottrasportevts);
                    if($longitud==7)
                        $pdf->Text($x+151,$y+2,number_format($tottrasportevts));
    
                    if($longitud==8)
                        $pdf->Text($x+149,$y+2,number_format($tottrasportevts));
    
                    // Total devengado
                    $longitud = strlen($totdevengadovts);
                    if($longitud==8)
                        $pdf->Text($x+180,$y+2,number_format($totdevengadovts));
    
                    if($longitud==9)
                        $pdf->Text($x+178,$y+2,number_format($totdevengadovts));
    
                    // Total descuentos
                    $longitud = strlen($totdescuentosvts);                
    
                    if($longitud==5)
                        $pdf->Text($x+221,$y+2,number_format($totdescuentosvts));
    
                    if($longitud==6)
                        $pdf->Text($x+219,$y+2,number_format($totdescuentosvts));
    
                    if($longitud==7)
                        $pdf->Text($x+217,$y+2,number_format($totdescuentosvts));
    
                    if($longitud==8)
                        $pdf->Text($x+215,$y+2,number_format($totdescuentosvts));
    
                    if($longitud==9)
                        $pdf->Text($x+213,$y+2,number_format($totdescuentosvts));
    
                    if($longitud==10)
                        $pdf->Text($x+211,$y+2,number_format($totdescuentosvts));
    
                    if($longitud==11)
                        $pdf->Text($x+209,$y+2,number_format($totdescuentosvts));
    
                    if($longitud==12)
                        $pdf->Text($x+207,$y+2,number_format($totdescuentosvts));
    
                    if($longitud==13)
                        $pdf->Text($x+205,$y+2,number_format($totdescuentosvts));
    
                    // Total salud
                    $longitud = strlen($totsaludvts);
                    if($longitud==7)
                        $pdf->Text($x+236,$y+2,number_format($totsaludvts));
    
                    if($longitud==8)
                        $pdf->Text($x+234,$y+2,number_format($totsaludvts));
    
                    // Total pensión
                    $longitud = strlen($totpensionvts);
                    if($longitud==7)
                        $pdf->Text($x+258,$y+2,number_format($totpensionvts));
    
                    if($longitud==8)
                        $pdf->Text($x+256,$y+2,number_format($totpensionvts));
    
                    // Total deducción
                    $longitud = strlen($totdeduccionvts);
                    if($longitud==7)
                        $pdf->Text($x+286,$y+2,number_format($totdeduccionvts));
    
                    if($longitud==8)
                        $pdf->Text($x+284,$y+2,number_format($totdeduccionvts));
    
                    if($longitud==9)
                        $pdf->Text($x+282,$y+2,number_format($totdeduccionvts));
    
                    if($longitud==10)
                        $pdf->Text($x+280,$y+2,number_format($totdeduccionvts));
    
                    if($longitud==11)
                        $pdf->Text($x+278,$y+2,number_format($totdeduccionvts));
    
                    // Total del neto a pagar
                    $longitud = strlen($totnetovts);
                    if($longitud==8)
                        $pdf->Text($x+317,$y+2,number_format($totnetovts));
    
                    if($longitud==9)
                        $pdf->Text($x+315,$y+2,number_format($totnetovts));
    
                    // ------------------------------------------------------------------ //
                    // Impresión de los totales de ambas áreas
                    $item = $i + $j;
                    $totsalario = $totsalarioadm + $totsalariovts;
                    $tottrasporte = $tottrasporteadm + $tottrasportevts;
                    $totdevengado = $totdevengadoadm + $totdevengadovts;
                    $totdescuentos = $totdescuentosadm + $totdescuentosvts;
                    $totsalud = $totsaludadm + $totsaludvts;
                    $totpension = $totpensionadm + $totpensionvts;
                    $totdeduccion = $totdeduccionadm + $totdeduccionvts;
                    $totneto = $totnetoadm + $totnetovts;
    
                    $pdf->SetFillColor(160,160,160);
                    $pdf->Rect(7,$y+6,340,8,'F');
    
                    $enc= "ITEMS:";
                    $pdf->Text(10,$y+11,$enc);
                    $pdf->Text(25,$y+11,$item);
    
                    $enc= "TOTALES:";
                    $pdf->Text(90,$y+11,$enc);
    
                    // Total salarios
                    $longitud = strlen($totsalario);
                    if($longitud==8)
                        $pdf->Text($x+118,$y+11,number_format($totsalario));
    
                    if($longitud==9)
                        $pdf->Text($x+116,$y+11,number_format($totsalario));

                    if($longitud==10)
                        $pdf->Text($x+114,$y+11,number_format($totsalario));                        
    
                    // Total subsidio de transporte
                    $longitud = strlen($tottrasporte);
                    if($longitud==7)
                        $pdf->Text($x+151,$y+11,number_format($tottrasporte));
    
                    if($longitud==8)
                        $pdf->Text($x+149,$y+11,number_format($tottrasporte));
    
                    if($longitud==9)
                        $pdf->Text($x+147,$y+11,number_format($tottrasporte));
    
                    // Total devengado
                    $longitud = strlen($totdevengado);
                    if($longitud==7)
                        $pdf->Text($x+182,$y+11,number_format($totdevengado));
    
                    if($longitud==8)
                        $pdf->Text($x+180,$y+11,number_format($totdevengado));
    
                    if($longitud==9)
                        $pdf->Text($x+178,$y+11,number_format($totdevengado));

                    if($longitud==10)
                        $pdf->Text($x+176,$y+11,number_format($totdevengado));                        
    
                    // Total descuentos
                    $longitud = strlen($totdescuentos);               
    
                    if($longitud==5)
                        $pdf->Text($x+221,$y+11,number_format($totdescuentos));
    
                    if($longitud==6)
                        $pdf->Text($x+219,$y+11,number_format($totdescuentos));
    
                    if($longitud==7)
                        $pdf->Text($x+217,$y+11,number_format($totdescuentos));
    
                    if($longitud==8)
                        $pdf->Text($x+215,$y+11,number_format($totdescuentos));
    
                    if($longitud==9)
                        $pdf->Text($x+213,$y+11,number_format($totdescuentos));
    
                    if($longitud==15)
                        $pdf->Text($x+213,$y+11,number_format($totdescuentos));
    
                    // Total salud
                    $longitud = strlen($totsalud);
                    if($longitud==7)
                        $pdf->Text($x+236,$y+11,number_format($totsalud));
    
                    if($longitud==8)
                        $pdf->Text($x+234,$y+11,number_format($totsalud));
    
                    // Total pensión
                    $longitud = strlen($totpension);
                    if($longitud==7)
                        $pdf->Text($x+258,$y+11,number_format($totpension));
    
                    if($longitud==8)
                        $pdf->Text($x+256,$y+11,number_format($totpension));
    
                    // Total deducción
                    $longitud = strlen($totdeduccion);
    
                    // echo $longitud; exit();
    
                    if($longitud==7)                
                        $pdf->Text($x+286,$y+11,number_format($totdeduccion));
    
                    if($longitud==8)
                        $pdf->Text($x+284,$y+11,number_format($totdeduccion));
    
                    if($longitud==9)
                        $pdf->Text($x+282,$y+11,number_format($totdeduccion));
    
                    if($longitud==10)
                        $pdf->Text($x+280,$y+11,number_format($totdeduccion));
    
                    if($longitud==11)
                        $pdf->Text($x+278,$y+11,number_format($totdeduccion));
    
                    if($longitud==12)
                        $pdf->Text($x+276,$y+11,number_format($totdeduccion));
    
                    if($longitud==15)
                        $pdf->Text($x+282,$y+11,number_format($totdeduccion));
    
                    // Total del neto a pagar
                    $longitud = strlen($totneto);                
    
                    if($longitud==8)
                        $pdf->Text($x+317,$y+11,number_format($totneto));
    
                    if($longitud==9)
                        $pdf->Text($x+315,$y+11,number_format($totneto));

                    if($longitud==10)
                        $pdf->Text($x+313,$y+11,number_format($totneto));                        
    
                    if($longitud==15)
                        $pdf->Text($x+315,$y+11,number_format($totneto));
    
                    $pdf->Output();
                }
    
                // Salida en una hoja de Excel
                if($tiposalida=="excel")
                {
                    require_once 'lib/PHPExcel.php';
                    $clase = new Sistema();
                    $clase->Conectar();
                    ini_set("memory_limit","100M");
        
                    // Consulta para el área de administración
                    if($cerrado=="CHECKED")
                        $vsql = "SELECT p.areaid, a.descripcionarea, p.codvende, p.nombre AS nombreemp, 
                                        b.codbanco, p.numcuenta, p.dni, 
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, p.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension, 
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto, 
                                        SUM(IF(d.conceptoid=10,d.valor,0)) AS diasincapacidad, SUM(IF(d.conceptoid=10,d.devengados,0)) AS valorincapacidad,
                                        SUM(IF(d.conceptoid IN (12,11,13,23,40,31,46),d.valor,0)) AS diaslicenciaremunerada, SUM(IF(d.conceptoid IN (12,11,13,23,40,31,46),d.devengados,0)) AS valorlicenciaremunerada,
                                        SUM(IF(d.conceptoid IN (6,9),d.valor,0)) AS diaslicencianoremunerada, SUM(IF(d.conceptoid IN (6,9),d.descuentos,0)) AS valorlicencianoremunerada,
                                        SUM(IF(d.conceptoid = 43,d.valor,0)) AS diasinc180, SUM(IF(d.conceptoid = 43,d.descuentos,0)) AS valorinc180, 
                                        SUM(IF(d.conceptoid = 47,d.devengados,0)) AS recargonoc, SUM(IF(d.conceptoid = 49,d.devengados,0)) AS horaextradiura, 
                                        SUM(IF(d.conceptoid = 50,d.devengados,0)) AS horaextranocturna, SUM(IF(d.conceptoid = 51,d.devengados,0)) AS horaextradiuradom, 
                                        SUM(IF(d.conceptoid = 52,d.devengados,0)) AS horaextranocturnadomfes, SUM(IF(d.conceptoid = 53,d.devengados,0)) AS domingofestivo, 
                                        SUM(IF(d.conceptoid = 54,d.devengados,0)) AS recargonocdomfes, cg.descripcioncargo  
                                   FROM periodoterceros p 
                                        INNER JOIN hisdetallenomina d ON (p.terid = d.terid)          
                                        INNER JOIN areanomina a ON (p.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                        INNER JOIN entidadesbancarias b ON (p.bancoid = b.bancoid) 
                                        INNER JOIN cargos cg ON (p.cargoid = cg.cargoid)
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND p.pernominaid = ".$periodoid."
                                        AND (p.esempleadoactivo = 'CHECKED' AND (p.extralegal = '' OR p.extralegal IS NULL))
                                        AND p.areaid = 1 
                               GROUP BY p.terid";
                    else
                        $vsql = "SELECT t.areaid, a.descripcionarea, t.codvende, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                        b.codbanco, t.numcuenta, t.dni, 
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, t.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto, 
                                        SUM(IF(d.conceptoid=10,d.valor,0)) AS diasincapacidad, SUM(IF(d.conceptoid=10,d.devengados,0)) AS valorincapacidad,
                                        SUM(IF(d.conceptoid IN (12,11,13,23,40,31,46),d.valor,0)) AS diaslicenciaremunerada, SUM(IF(d.conceptoid IN (12,11,13,23,40,31,46),d.devengados,0)) AS valorlicenciaremunerada,
                                        SUM(IF(d.conceptoid IN (6,9),d.valor,0)) AS diaslicencianoremunerada, SUM(IF(d.conceptoid IN (6,9),d.descuentos,0)) AS valorlicencianoremunerada,
                                        SUM(IF(d.conceptoid = 43,d.valor,0)) AS diasinc180, SUM(IF(d.conceptoid = 43,d.descuentos,0)) AS valorinc180, 
                                        SUM(IF(d.conceptoid = 47,d.devengados,0)) AS recargonoc, SUM(IF(d.conceptoid = 49,d.devengados,0)) AS horaextradiura, 
                                        SUM(IF(d.conceptoid = 50,d.devengados,0)) AS horaextranocturna, SUM(IF(d.conceptoid = 51,d.devengados,0)) AS horaextradiuradom, 
                                        SUM(IF(d.conceptoid = 52,d.devengados,0)) AS horaextranocturnadomfes, SUM(IF(d.conceptoid = 53,d.devengados,0)) AS domingofestivo, 
                                        SUM(IF(d.conceptoid = 54,d.devengados,0)) AS recargonocdomfes, cg.descripcioncargo  
                                   FROM tercerosactual t 
                                        INNER JOIN detallenomina d ON (t.terid = d.terid)          
                                        INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                        INNER JOIN entidadesbancarias b ON (t.bancoid = b.bancoid)
                                        INNER JOIN cargos cg ON (t.cargoid = cg.cargoid)
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                                        AND t.areaid = 1 
                               GROUP BY t.terid";
                    
                    // Preparación del entorno para la salida a Excel
                    $clase = new Sistema();
                    $clase->Nombredb = $_SESSION['DBNOMBRE'];
                    error_reporting(E_ALL);
                    ini_set('display_errors', TRUE);
                    ini_set('display_startup_errors', TRUE);
                    date_default_timezone_set('Europe/London');
                
                    if (PHP_SAPI == 'cli')
                        die('This example should only be run from a Web Browser');
                
                    // Create new PHPExcel object
                    $objPHPExcel = new PHPExcel();
                
                    // Set document properties
                    $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                                 ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                                 ->setTitle("Planilla de nomina - DROPOS")
                                                 ->setSubject("Planilla de nomina - DROPOS")
                                                 ->setDescription("Planilla de nomina - DROPOS")
                                                 ->setKeywords("Planilla de nomina - DROPOS")
                                                 ->setCategory("Categoria General");

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A1', 'PLANILLA DE NOMINA')
                                ->setCellValue('A2', 'PERIODO: '.$descripcion)
                                ->setCellValue('A4', 'AREA ADMINISTRACION')
                                ->setCellValue('A5', 'COD')
                                ->setCellValue('B5', 'DOCUMENTO')
                                ->setCellValue('C5', 'NOMBRE EMPLEADO')
                                ->setCellValue('D5', 'BANCO')
                                ->setCellValue('E5', 'CUENTA')
                                ->setCellValue('F5', 'DIAS')
                                ->setCellValue('G5', 'DIAS INCAPACIDAD')
                                ->setCellValue('H5', 'VALOR INCAPACIDAD')
                                ->setCellValue('I5', 'DIAS LICENCIAS REMUNERADAS')
                                ->setCellValue('J5', 'VALOR LICENCIAS REMUNERADAS')
                                ->setCellValue('K5', 'DIAS SUSPENSION Y LNR')
                                ->setCellValue('L5', 'VALOR SUSPENSION Y LNR') 
                                ->setCellValue('M5', 'DIAS LICENCIA SUPERIOR 180 DIAS')
                                ->setCellValue('N5', 'VALOR LICENCIA SUPERIOR 180 DIAS') 
                                ->setCellValue('O5', 'RECARGO NOCTURNO') 
                                ->setCellValue('P5', 'HORA EXTRA DIURA') 
                                ->setCellValue('Q5', 'HORA EXTRA NOCTURNA') 
                                ->setCellValue('R5', 'HORA EXTRA DIURNA DOMINICAL') 
                                ->setCellValue('S5', 'HORA EXTRA NOCTURNA DOMINICAL Y FESTIVO') 
                                ->setCellValue('T5', 'DOMINGOS Y FESTIVOS') 
                                ->setCellValue('U5', 'RECARGO NOCTURNO DOMINICAL Y FESTIVO') 
                                ->setCellValue('V5', 'CARGO')
                                ->setCellValue('W5', 'BASICO')
                                ->setCellValue('X5', 'SALARIO')
                                ->setCellValue('Y5', 'TRANSPORTE')
                                ->setCellValue('Z5', 'DEVENGADO')
                                ->setCellValue('AA5', 'DESCUENTOS')
                                ->setCellValue('AB5', 'SALUD')
                                ->setCellValue('AC5', 'PENSION')
                                ->setCellValue('AD5', 'DEDUCCION')
                                ->setCellValue('AE5', 'NETO A PAGAR');
                    
                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);                
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setAutoSize(true);                    $objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setAutoSize(true);                    $objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setAutoSize(true);
    
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    $cant   = mysql_num_rows($result);
    
                    // Inicialización de los totales
                    $totsalarioadm = 0;                     $tottrasporteadm = 0;                       $totdevengadoadm = 0;
                    $totdescuentosadm = 0;                  $totsaludadm = 0;                           $totpensionadm = 0;
                    $totdeduccionadm = 0;                   $totnetoadm = 0;                            $codvende = "";
                    $codbanco = "";                         $numcuenta = "";
    
                    $i=6;
                    while($row = mysql_fetch_array($result))
                    {
                        $codvende = $row['codvende'];
                        if(substr($codvende,0,1) == "0")
                            $codvende = "'".$codvende;

                        $codbanco = $row['codbanco'];
                        if(substr($codbanco,0,1) == "0")
                            $codbanco = "'".$codbanco;

                        $numcuenta = $row['numcuenta'];

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$i, trim($codvende))
                                    ->setCellValue('B'.$i, $row['dni'])                                    
                                    ->setCellValue('C'.$i, $row['nombreemp'])
                                    ->setCellValue('D'.$i, $codbanco)
                                    ->setCellValue('E'.$i, $numcuenta)
                                    ->setCellValue('F'.$i, number_format($row['dias']))
                                    ->setCellValue('G'.$i, number_format($row['diasincapacidad']))
                                    ->setCellValue('H'.$i, number_format($row['valorincapacidad']))
                                    ->setCellValue('I'.$i, number_format($row['diaslicenciaremunerada']))
                                    ->setCellValue('J'.$i, number_format($row['valorlicenciaremunerada']))
                                    ->setCellValue('K'.$i, number_format($row['diaslicencianoremunerada']))
                                    ->setCellValue('L'.$i, number_format($row['valorlicencianoremunerada']))
                                    ->setCellValue('M'.$i, number_format($row['diasinc180']))
                                    ->setCellValue('N'.$i, number_format($row['valorinc180']))
                                    ->setCellValue('O'.$i, number_format($row['recargonoc']))
                                    ->setCellValue('P'.$i, number_format($row['horaextradiura']))
                                    ->setCellValue('Q'.$i, number_format($row['horaextranocturna']))
                                    ->setCellValue('R'.$i, number_format($row['horaextradiuradom']))
                                    ->setCellValue('S'.$i, number_format($row['horaextranocturnadomfes']))
                                    ->setCellValue('T'.$i, number_format($row['domingofestivo']))
                                    ->setCellValue('U'.$i, number_format($row['recargonocdomfes']))
                                    ->setCellValue('V'.$i, $row['descripcioncargo'])
                                    ->setCellValue('W'.$i, number_format($row['basico']))
                                    ->setCellValue('X'.$i, number_format($row['salario']))
                                    ->setCellValue('Y'.$i, number_format($row['transporte']))
                                    ->setCellValue('Z'.$i, number_format($row['devengado']))
                                    ->setCellValue('AA'.$i, number_format($row['descuentos']))
                                    ->setCellValue('AB'.$i, number_format($row['salud']))
                                    ->setCellValue('AC'.$i, number_format($row['pension']))
                                    ->setCellValue('AD'.$i, number_format($row['deduccion']))
                                    ->setCellValue('AE'.$i, number_format($row['neto']));
    
                        // Incremento de los totales
                        $totsalarioadm += $row['salario'];
                        $tottrasporteadm += $row['transporte'];
                        $totdevengadoadm += $row['devengado'];
                        $totdescuentosadm += $row['descuentos'];
                        $totsaludadm += $row['salud'];
                        $totpensionadm += $row['pension'];
                        $totdeduccionadm += $row['deduccion'];
                        $totnetoadm += $row['neto'];
                            
                        $i++;
                    }
    
                    // Impresión de los totales
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('B'.$i, "TOTAL AREA DE ADMINISTRACION:")
                                ->setCellValue('X'.$i, number_format($totsalarioadm))
                                ->setCellValue('Y'.$i, number_format($tottrasporteadm))
                                ->setCellValue('Z'.$i, number_format($totdevengadoadm))
                                ->setCellValue('AA'.$i, number_format($totdescuentosadm))
                                ->setCellValue('AB'.$i, number_format($totsaludadm))
                                ->setCellValue('AC'.$i, number_format($totpensionadm))
                                ->setCellValue('AD'.$i, number_format($totdeduccionadm))
                                ->setCellValue('AE'.$i, number_format($totnetoadm));
                    
                    $rangoEncabezado = 'A4:AE4';
                    $rangoCeldas     = 'A4:AE'.($i-1);    

                    // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
                    // Consulta para el área de ventas
                    if($cerrado=="CHECKED")
                        $vsql = "SELECT p.areaid, a.descripcionarea, p.codvende, p.nombre AS nombreemp,  
                                        b.codbanco, p.numcuenta, p.dni, 
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, p.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto,
                                        SUM(IF(d.conceptoid=10,d.valor,0)) AS diasincapacidad, SUM(IF(d.conceptoid=10,d.devengados,0)) AS valorincapacidad,
                                        SUM(IF(d.conceptoid IN (12,11,13,23,40,31,46),d.valor,0)) AS diaslicenciaremunerada, SUM(IF(d.conceptoid IN (12,11,13,23,40,31,46),d.devengados,0)) AS valorlicenciaremunerada,
                                        SUM(IF(d.conceptoid IN (6,9),d.valor,0)) AS diaslicencianoremunerada, SUM(IF(d.conceptoid IN (6,9),d.descuentos,0)) AS valorlicencianoremunerada,
                                        SUM(IF(d.conceptoid = 43,d.valor,0)) AS diasinc180, SUM(IF(d.conceptoid = 43,d.descuentos,0)) AS valorinc180, 
                                        SUM(IF(d.conceptoid = 47,d.devengados,0)) AS recargonoc, SUM(IF(d.conceptoid = 49,d.devengados,0)) AS horaextradiura, 
                                        SUM(IF(d.conceptoid = 50,d.devengados,0)) AS horaextranocturna, SUM(IF(d.conceptoid = 51,d.devengados,0)) AS horaextradiuradom, 
                                        SUM(IF(d.conceptoid = 52,d.devengados,0)) AS horaextranocturnadomfes, SUM(IF(d.conceptoid = 53,d.devengados,0)) AS domingofestivo, 
                                        SUM(IF(d.conceptoid = 54,d.devengados,0)) AS recargonocdomfes, cg.descripcioncargo  
                                   FROM periodoterceros p          
                                        INNER JOIN hisdetallenomina d ON (p.terid = d.terid)          
                                        INNER JOIN areanomina a ON (p.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                        INNER JOIN entidadesbancarias b ON (p.bancoid = b.bancoid) 
                                        INNER JOIN cargos cg ON (p.cargoid = cg.cargoid)
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND p.pernominaid = ".$periodoid."
                                        AND (p.esempleadoactivo = 'CHECKED' AND (p.extralegal = '' OR p.extralegal IS NULL))
                                        AND p.areaid = 2 
                               GROUP BY p.terid";                
                    else
                        $vsql = "SELECT t.areaid, a.descripcionarea, t.codvende, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,  
                                        b.codbanco, t.numcuenta, t.dni, 
                                        SUM(IF(d.conceptoid=1,d.valor,0)) AS dias, t.basico, SUM(IF(d.conceptoid=1,d.devengados,0)) AS salario, 
                                        SUM(IF(d.conceptoid=3,d.devengados,0)) AS transporte, 
                                        SUM(IF(c.tipodc = 'C',d.devengados,0)) AS devengado,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (4,5,6,9,28,43,58),d.descuentos,0)) AS descuentos, 
                                        SUM(IF(d.conceptoid=5,d.descuentos,0)) AS salud, 
                                        SUM(IF(d.conceptoid=4,d.descuentos,0)) AS pension,
                                        SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0)) AS deduccion,
                                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS neto, 
                                        SUM(IF(d.conceptoid=10,d.valor,0)) AS diasincapacidad, SUM(IF(d.conceptoid=10,d.devengados,0)) AS valorincapacidad,
                                        SUM(IF(d.conceptoid IN (12,11,13,23,40,31,46),d.valor,0)) AS diaslicenciaremunerada, SUM(IF(d.conceptoid IN (12,11,13,23,40,31,46),d.devengados,0)) AS valorlicenciaremunerada,
                                        SUM(IF(d.conceptoid IN (6,9),d.valor,0)) AS diaslicencianoremunerada, SUM(IF(d.conceptoid IN (6,9),d.descuentos,0)) AS valorlicencianoremunerada,
                                        SUM(IF(d.conceptoid = 43,d.valor,0)) AS diasinc180, SUM(IF(d.conceptoid = 43,d.descuentos,0)) AS valorinc180, 
                                        SUM(IF(d.conceptoid = 47,d.devengados,0)) AS recargonoc, SUM(IF(d.conceptoid = 49,d.devengados,0)) AS horaextradiura, 
                                        SUM(IF(d.conceptoid = 50,d.devengados,0)) AS horaextranocturna, SUM(IF(d.conceptoid = 51,d.devengados,0)) AS horaextradiuradom, 
                                        SUM(IF(d.conceptoid = 52,d.devengados,0)) AS horaextranocturnadomfes, SUM(IF(d.conceptoid = 53,d.devengados,0)) AS domingofestivo, 
                                        SUM(IF(d.conceptoid = 54,d.devengados,0)) AS recargonocdomfes, cg.descripcioncargo  
                                   FROM tercerosactual t          
                                        INNER JOIN detallenomina d ON (t.terid = d.terid)          
                                        INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                        INNER JOIN entidadesbancarias b ON (t.bancoid = b.bancoid) 
                                        INNER JOIN cargos cg ON (t.cargoid = cg.cargoid)
                                  WHERE d.pernominaid = ".$periodoid."
                                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                                        AND t.areaid = 2 
                            GROUP BY t.terid";
    
                    $j = $i + 3;

                    $celda1="A".strval($j);                 $celda2="B".strval($j);                 $celda3="C".strval($j);                 $celda4="D".strval($j);                 $celda5="E".strval($j);
                    $celda6="F".strval($j);                 $celda7="G".strval($j);                 $celda8="H".strval($j);                 $celda9="I".strval($j);                 $celda10="J".strval($j);
                    $celda11="K".strval($j);                $celda12="L".strval($j);                $celda13="M".strval($j);                $celda14="N".strval($j);                $celda15="O".strval($j);
                    $celda16="P".strval($j);                $celda17="Q".strval($j);                $celda18="R".strval($j);                $celda19="S".strval($j);                $celda20="T".strval($j);
                    $celda21="U".strval($j);                $celda22="V".strval($j);                $celda23="W".strval($j);                $celda24="X".strval($j);                $celda25="Y".strval($j);
                    $celda26="Z".strval($j);                $celda27="AA".strval($j);               $celda28="AB".strval($j);               $celda29="AC".strval($j);               $celda30="AD".strval($j);
                    $celda31="AE".strval($j);
    
                    $celda32="A".strval($j-1);
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda32, 'AREA DE VENTAS');

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda1, 'COD')
                                ->setCellValue($celda2, 'DOCUMENTO')
                                ->setCellValue($celda3, 'NOMBRE EMPLEADO')
                                ->setCellValue($celda4, 'BANCO')
                                ->setCellValue($celda5, 'CUENTA')
                                ->setCellValue($celda6, 'DIAS')
                                ->setCellValue($celda7, 'DIAS INCAPACIDAD')
                                ->setCellValue($celda8, 'VALOR INCAPACIDAD')
                                ->setCellValue($celda9, 'DIAS LICENCIAS REMUNERADAS')
                                ->setCellValue($celda10, 'VALOR LICENCIAS REMUNERADAS')
                                ->setCellValue($celda11, 'DIAS SUSPENSION Y LNR')
                                ->setCellValue($celda12, 'VALOR SUSPENSION Y LNR')
                                ->setCellValue($celda13, 'DIAS LICENCIA SUPERIOR 180 DIAS')
                                ->setCellValue($celda14, 'VALOR LICENCIA SUPERIOR 180 DIAS')
                                ->setCellValue($celda15, 'RECARGO NOCTURNO') 
                                ->setCellValue($celda16, 'HORA EXTRA DIURA') 
                                ->setCellValue($celda17, 'HORA EXTRA NOCTURNA') 
                                ->setCellValue($celda18, 'HORA EXTRA DIURNA DOMINICAL') 
                                ->setCellValue($celda19, 'HORA EXTRA NOCTURNA DOMINICAL Y FESTIVO') 
                                ->setCellValue($celda20, 'DOMINGOS Y FESTIVOS') 
                                ->setCellValue($celda21, 'RECARGO NOCTURNO DOMINICAL Y FESTIVO') 
                                ->setCellValue($celda22, 'CARGO')
                                ->setCellValue($celda23, 'BASICO')
                                ->setCellValue($celda24, 'SALARIO')
                                ->setCellValue($celda25, 'TRANSPORTE')
                                ->setCellValue($celda26, 'DEVENGADO')
                                ->setCellValue($celda27, 'DESCUENTOS')
                                ->setCellValue($celda28, 'SALUD')
                                ->setCellValue($celda29, 'PENSION')
                                ->setCellValue($celda30, 'DEDUCCION')
                                ->setCellValue($celda31, 'NETO A PAGAR');
                    $j++;
    
                    // Inicialización de los totales
                    $totsalariovts = 0;                     $tottrasportevts = 0;                       $totdevengadovts = 0;
                    $totdescuentosvts = 0;                  $totsaludvts = 0;                           $totpensionvts = 0;
                    $totdeduccionvts = 0;                   $totnetovts = 0;                            $codvende = "";
                    $codbanco = "";                         $numcuenta = "";
    
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    $cant   = mysql_num_rows($result);                
                    while($row = mysql_fetch_array($result))
                    {
                        $codvende = $row['codvende'];
                        if(substr($codvende,0,1) == "0")
                            $codvende = "'".$codvende;

                        $codbanco = $row['codbanco'];
                        if(substr($codbanco,0,1) == "0")
                            $codbanco = "'".$codbanco;

                        $numcuenta = $row['numcuenta'];
                        if(substr($numcuenta,0,1) == "0")
                            $numcuenta = "'".$numcuenta;

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$j, trim($codvende))
                                    ->setCellValue('B'.$j, $row['dni'])                                    
                                    ->setCellValue('C'.$j, $row['nombreemp'])
                                    ->setCellValue('D'.$j, $codbanco)
                                    ->setCellValue('E'.$j, $numcuenta)
                                    ->setCellValue('F'.$j, number_format($row['dias']))
                                    ->setCellValue('G'.$j, number_format($row['diasincapacidad']))
                                    ->setCellValue('H'.$j, number_format($row['valorincapacidad']))
                                    ->setCellValue('I'.$j, number_format($row['diaslicenciaremunerada']))
                                    ->setCellValue('J'.$j, number_format($row['valorlicenciaremunerada']))
                                    ->setCellValue('K'.$j, number_format($row['diaslicencianoremunerada']))
                                    ->setCellValue('L'.$j, number_format($row['valorlicencianoremunerada']))
                                    ->setCellValue('M'.$j, number_format($row['diasinc180']))
                                    ->setCellValue('N'.$j, number_format($row['valorinc180']))
                                    ->setCellValue('O'.$j, number_format($row['recargonoc']))
                                    ->setCellValue('P'.$j, number_format($row['horaextradiura']))
                                    ->setCellValue('Q'.$j, number_format($row['horaextranocturna']))
                                    ->setCellValue('R'.$j, number_format($row['horaextradiuradom']))
                                    ->setCellValue('S'.$j, number_format($row['horaextranocturnadomfes']))
                                    ->setCellValue('T'.$j, number_format($row['domingofestivo']))
                                    ->setCellValue('U'.$j, number_format($row['recargonocdomfes']))
                                    ->setCellValue('V'.$j, $row['descripcioncargo'])
                                    ->setCellValue('W'.$j, number_format($row['basico']))
                                    ->setCellValue('X'.$j, number_format($row['salario']))
                                    ->setCellValue('Y'.$j, number_format($row['transporte']))
                                    ->setCellValue('Z'.$j, number_format($row['devengado']))
                                    ->setCellValue('AA'.$j, number_format($row['descuentos']))
                                    ->setCellValue('AB'.$j, number_format($row['salud']))
                                    ->setCellValue('AC'.$j, number_format($row['pension']))
                                    ->setCellValue('AD'.$j, number_format($row['deduccion']))
                                    ->setCellValue('AE'.$j, number_format($row['neto']));
    
                        // Incremento de los totales                                
                        $totsalariovts += $row['salario'];
                        $tottrasportevts += $row['transporte'];
                        $totdevengadovts += $row['devengado'];
                        $totdescuentosvts += $row['descuentos'];
                        $totsaludvts += $row['salud'];
                        $totpensionvts += $row['pension'];
                        $totdeduccionvts += $row['deduccion'];
                        $totnetovts += $row['neto'];
    
                        $j++;
                    }
    
                    // Impresión de los totales
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('B'.$j, "TOTAL AREA DE VENTAS:")
                                ->setCellValue('X'.$j, number_format($totsalariovts))
                                ->setCellValue('Y'.$j, number_format($tottrasportevts))
                                ->setCellValue('Z'.$j, number_format($totdevengadovts))
                                ->setCellValue('AA'.$j, number_format($totdescuentosvts))
                                ->setCellValue('AB'.$j, number_format($totsaludvts))
                                ->setCellValue('AC'.$j, number_format($totpensionvts))
                                ->setCellValue('AD'.$j, number_format($totdeduccionvts))
                                ->setCellValue('AE'.$j, number_format($totnetovts));
    
                    $rangoEncabezado2 = $celda1.':'.$celda31;
                    $rangoCeldas2     = $celda1.($j-1);
    
                    // Totales de ambas áreas
                    $totsalario = $totsalarioadm + $totsalariovts;
                    $tottrasporte = $tottrasporteadm + $tottrasportevts;
                    $totdevengado = $totdevengadoadm + $totdevengadovts;
                    $totdescuentos = $totdescuentosadm + $totdescuentosvts;
                    $totsalud = $totsaludadm + $totsaludvts;
                    $totpension = $totpensionadm + $totpensionvts;
                    $totdeduccion = $totdeduccionadm + $totdeduccionvts;
                    $totneto = $totnetoadm + $totnetovts;
    
                    $k = $j + 2;
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('B'.$k, "TOTAL AMBAS AREAS:")
                                ->setCellValue('X'.$k, number_format($totsalario))
                                ->setCellValue('Y'.$k, number_format($tottrasporte))
                                ->setCellValue('Z'.$k, number_format($totdevengado))
                                ->setCellValue('AA'.$k, number_format($totdescuentos))
                                ->setCellValue('AB'.$k, number_format($totsalud))
                                ->setCellValue('AC'.$k, number_format($totpension))
                                ->setCellValue('AD'.$k, number_format($totdeduccion))
                                ->setCellValue('AE'.$k, number_format($totneto));
    
                    // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
                    
                    // Formato de Encabezado y Celdas
                    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
                    
                    $EstiloCeldas = array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('argb' => '00000000'),
                        ),
                        ),
                    );
                    // $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
                    /// Formato de Encabezados 
                    $EstiloEncabezado = array(
                    'font' => array(
                        'bold' => true,
                    ),
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                        'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
                    ),
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('argb' => '00000000'),
                        ),
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'rotation' => 90,
                        'startcolor' => array(
                            'argb' => '00FFFFCC',
                        ),
                        'endcolor' => array(
                            'argb' => 'FFFFFF',
                        ),
                        ),
                    );
                    // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
                    // Rename worksheet
                    $objPHPExcel->getActiveSheet()->setTitle('Planilla de nomina');
                    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                    $objPHPExcel->setActiveSheetIndex(0);
                    // Redirect output to a client’s web browser (Excel5)
                    header('Content-Type: application/vnd.ms-excel');
                    // --------------------------------------------------------------------- //
                    $nombrearcexcel = "planilla de nomina ".strtolower($descripcion).".xls";
                    header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
                    // --------------------------------------------------------------------- //
                    header('Cache-Control: max-age=0');
                    /// Genero la Salida
                    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
                    $objWriter->save('php://output');
                    exit;
                }
            }            
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función Encabezado2
    // Parámetro de entrada:    $titulo --> título del informe
    //                          $filtros --> periodo de la planilla    
    // Valor de retorno:        $cont --> tabla con en encabezado del informe
    // Descripción: Función que pinta el encabezado del informe
    ////////////////////////////////////////////////////////////////////////////////////////    
    function Encabezado2($titulo,$filtros)
    {
        $clase = new Sistema();
        $cont.= $clase->HeaderBlanco($titulo);
        $cont.='<table width="1300">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> </td>
                  <td width="37"> <img src="images/iconos/boletines.png" width="32" height="32" border="0"> </td>
                  <td width="900"><b>'.$titulo.'</b> '.$filtros.' <td>
                  <td width="50"> &nbsp; <td>    				 				 				 				
                  <td width="30" align="center"> &nbsp; </td> 
                  <td width="30" align="center"> &nbsp; </td>
                  <td width="30" align="center"> &nbsp; </td>				
                  <td width="10">&nbsp;<td>    				 				 				 				 
                 </tr>	 			   
               </table>';	
       return($cont);
    }
?>