<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarxtipo
    // Creación: 24/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que envía a la vista principal el filtro del año
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarxtipo")
    {
        $filtro = $_POST['filtro'];
        header("Location: periodosnominaadm.php?filtro=$filtro");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 24/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana con lo periodos de nómina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        // if(($_SESSION["SUPERUSUARIO"] != "CHECKED")&&($_SESSION['USERNAME'] != "DROPOS.NOMINA"))

        if(($_SESSION["SUPERUSUARIO"] != "CHECKED")&&($_SESSION['USERNAME'] != "DROPOS.NOMINA")&&($_SESSION['USERNAME'] != "LFLOREZ"))
        {
            $clase->Aviso(2,"Acceso No Permitido"); 
            header("Location: principal.php");
        }
        else
        {
            $filtro  = $_GET['filtro'];
            $yeartoday = date("Y");
    
            if(strlen($filtro) == 0)
                $filtro = $yeartoday;
    
            // inicialización de variables
            $selected2021 = '';
            $selected2022 = '';
            $selected2023 = '';
            $selected2024 = '';
            $selected2025 = '';
    
            // selección del combo por defecto
            switch($filtro)
            {
                case 2021:
                    $selected2021 = 'selected';
                    break;
                case 2022:
                    $selected2022 = 'selected';
                    break;
                case 2023:
                    $selected2023 = 'selected';
                    break;
                case 2024:
                    $selected2024 = 'selected';
                    break;
                case 2025:
                    $selected2025 = 'selected';
                    break;
                default:
                    break;
            }
    
            // combo de años
            $years = '<option value="2021" '.$selected2021.'> 2021 </option>
                      <option value="2022" '.$selected2022.'> 2022 </option>
                      <option value="2023" '.$selected2023.'> 2023 </option>
                      <option value="2024" '.$selected2024.'> 2024 </option>
                      <option value="2025" '.$selected2025.'> 2025 </option>';
    
            // Pinto la ventana
            $cont = $clase->Header("S","W");
            $cont.='<form action="periodosnominaadm.php?opcion=filtrarxtipo" method="POST" name="z">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/configuracion.png" width="32" height="32" border="0"> </td>
                      <td width="180"> <b>Periodos de n&oacute;mina año:</b> </td>
                      <td width="100"> 
                       <select class="Texto11" name="filtro" style="width:60px;height:25px" OnChange="z.submit();">
                        '.$years.'
                       </select> 
                      </td>
                      <td width="620"> &nbsp; </td>
                      <td width="24">  &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="8"> &nbsp;</td>
                     </tr>	 			   
                    </table>';
    
            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                     <table width="100%" class="sortable">
                      <thead> 
                       <tr class="TituloTabla" style="display:block;padding-top:5px;height:21px;">
                        <td width="20"> &nbsp; </td>
                        <td width="80"> C&oacute;digo </td>
                        <td width="320"> Descripci&oacute;n </td>			
                        <td width="75"> Desde </td>
                        <td width="45"> &nbsp; </td>
                        <td width="75"> Hasta </td>	
                        <td width="300"> &nbsp; </td>
                       </tr>
                      </thead>
                      <tbody style="display:block; width:1050px; height:690px; overflow-Y:scroll">';
    
            $filtro2 = strval($filtro);
            $stryearact = strval($yeartoday);
    
            $vsql = "SELECT periodoid, codigo, descripcion, fecdesde, fechasta, cerrado, transmitido FROM periodosnomina";
    
            if($filtro == 0)
                $vsql.= " WHERE SUBSTR(descripcion, -4) = '".$stryearact."' ";
            else
                $vsql.= " WHERE SUBSTR(descripcion, -4) = '".$filtro2."' ";
    
            $vsql.= " ORDER BY periodoid";
    
            $i = 0;
            $conex  = $clase->Conectar();
            $result = @mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
    
                // Asigno formato a las fechas
                $fecdesde  = substr($row['fecdesde'],8,2)."/".substr($row['fecdesde'],5,2)."/".substr($row['fecdesde'],0,4);
                $fechasta  = substr($row['fechasta'],8,2)."/".substr($row['fechasta'],5,2)."/".substr($row['fechasta'],0,4);
                
                // Valido que esté cerrado el anterior
                $periodoidactual = $row['periodoid'];
    
                if(($i==1)&&($filtro2==$stryearact))
                    $cerradoant="CHECKED";
                else
                {
                    $vsql = "SELECT cerrado 
                               FROM periodosnomina 
                              WHERE periodoid = (SELECT MAX(periodoid) FROM periodosnomina WHERE periodoid < $periodoidactual)";
                    $cerradoant = $clase->SeleccionarUno($vsql);
                }
                
                // Obtengo el valor del campo calculado
                $calculado = $clase->BDLockup($periodoidactual,'periodosnomina','periodoid','calculado');
    
                if($calculado=="CHECKED")
                    $tabla = "tercerosactual";
                else
                    $tabla = "terceros";
    
                // Determino si tiene empleados en negativo
                $ldtienenegativos = false;
    
                if($row['cerrado']!='CHECKED')
                {
                    $vsql2 = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                                     SUM(d.devengados) - SUM(d.descuentos) AS total
                                FROM detallenomina d
                                     INNER JOIN $tabla t ON (d.terid = t.terid)
                               WHERE d.pernominaid = ".$periodoidactual."  
                                     AND d.conceptoid NOT IN (6, 9, 43, 58)                                 
                            GROUP BY t.dni, nombreemp";
                    $conex2  = $clase->Conectar();
                    $result2 = mysql_query($vsql2,$conex2);
        
                    // Recorro la consulta para buscar negativos
                    while($row2 = mysql_fetch_array($result2))
                    {
                        if($row2['total']<0)
                            $ldtienenegativos = true;
                    }
                }
                // --------------------------------------------------------------------------------------------------------------- //
                        
                $cont.=' <td width="20"> </td>
                         <td width="90"> '.$row['codigo'].' </td>';
    
                if(($ldtienenegativos)&&($calculado=="CHECKED"))
                    $cont.='<td width="360"> <font color="RED">'.$row['descripcion'].'</font> </td>';
                else
                    $cont.='<td width="360"> '.$row['descripcion'].' </td>';
    
                $cont.=' <td width="80"> '.$fecdesde.' </td>
                         <td width="50"> &nbsp; </td>
                         <td width="85"> '.$fechasta.' </td>
                         <td width="50"> &nbsp; </td>';
    
                if(($ldtienenegativos)&&($calculado=="CHECKED"))
                    $cont.='<td width="300"> <font color="RED">Tiene empleados en negativo</font> </td>';
                else
                    $cont.='<td width="300"> &nbsp; </td>';
    
                // --------------------------------------------------------------------------------------------------------------------------------------------------------- //            
                if($row['cerrado']=='CHECKED')
                {
                    if(($row['transmitido']=='CHECKED')  || ($periodoidactual >= 1 && $periodoidactual <= 27))
                        $btnreabrir = '<img src="images/basicas/bloqueado.png" title="periodo reportado a la dian" border="0" width="20" height="20">';
                    else
                    {
                        $origen = "superusu";
                        $btnreabrir='<a href="?opcion=venteditarperant&periodoid='.$row['periodoid'].'&origen='.$origen.'" title="editar periodo cerrado" rel="facebox">
                                      <img src="images/basicas/calc.png" title="recibo" border="0" width="20" height="20">
                                     </a>';
                    }
                    
                    $cont.='  <td width="30"> &nbsp; </td>
                              <td width="30"> &nbsp; </td>
                              <td width="30"> &nbsp; </td>
                              <td width="30"> &nbsp; </td>
                              <td width="30" align="center"> '.$btnreabrir.' </td>
                              <td width="30" align="center"> 
                               <a href="?opcion=pedircedula&periodoid='.$row['periodoid'].'" target="_blank">
                                <img src="images/basicas/pdf.png" title="recibo" border="0" width="20" height="20">
                               </a>
                              </td>';
                }
                else
                {
                    if($cerradoant=='CHECKED')
                    {
                        $cont.='  <td width="30"> &nbsp; </td>
                                  <td width="30"> &nbsp; </td>
                                  <td width="30"> &nbsp; </td>';
    
                        if($ldtienenegativos)
                            $cont.='  <td width="30"> &nbsp; </td>
                                      <td width="30"> 
                                       <a href="?opcion=valnegativo&periodoid='.$periodoidactual.'" target="_blank">
                                        <img src="images/basicas/arreglar.png" title="ver empleados en negativo" border="0" width="20" height="20">
                                       </a>
                                      </td>';
                        else
                        {
                            if($calculado=="CHECKED")
                                $cont.='  <td width="30"> &nbsp; </td>
                                          <td width="30" align="center"> 
                                           <a href="?opcion=confirmacerrarperiodo&periodoid='.$row['periodoid'].'" rel="facebox">
                                            <img src="images/basicas/close.gif" title="cerrar periodo" border="0" width="20" height="20">
                                           </a>
                                          </td>';
                            else
                                $cont.='  <td width="30"> &nbsp; </td>
                                          <td width="30"> &nbsp; </td>';
                        }
    
                        if($calculado=="CHECKED")
                            $cont.='  <td width="30" align="center">
                                       <a href="?opcion=pedircedula&periodoid='.$row['periodoid'].'" target="_blank">
                                        <img src="images/basicas/pdf.png" title="recibo" border="0" width="20" height="20">
                                       </a>
                                      </td>';
                        else
                            $cont.='  <td width="30" align="center"> &nbsp; </td>';
                    }
                    else
                        $cont.='  <td width="30"> &nbsp; </td>
                                  <td width="30"> &nbsp; </td>
                                  <td width="30"> &nbsp; </td>
                                  <td width="30"> &nbsp; </td>
                                  <td width="30"> &nbsp; </td>
                                  <td width="30" align="center"> &nbsp; </td>';
                }           
                
                $cont.='  <td width="10"> &nbsp; </td> 
                         </tr>';
            }
            $cont.=' </tbody>
                    </table>
                    <table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="261"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="222"> &nbsp; </td>
                     </tr>
                    </table>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: pedircedula
    // Creación: 24/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana que lee la cédula del empleado para la 
    //              impresión del recibo de pago
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "pedircedula")
    {
        $periodoid = $_GET['periodoid'];

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado != "CHECKED")
        {
            // Emito el mensaje correspondiente
            $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $clase->Aviso(3,"El periodo $descripcion no está calculado");

            // Redirecciono el formulario
            header("Location: periodosnominaadm.php");
        }
        else
        {
            // Combo de empleados
            $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                               FROM terceros 
                              WHERE basico > 0
                           ORDER BY nombres";
            $params = ' class="Texto11" ';
    
            $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
            // Pinto la ventana
            $cont = $clase->Header("S","W");
            $cont.='<form action="recibodepago.php?opcion=reciboindividual" method="POST" name="x" target="_blank">
                    <input type="hidden" name="periodoid" value="'.$periodoid.'">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Imprimir recibo de pago del periodo <font color="BLUE">'.$descripcion.'</font> </b> </td> 
                      <td width="10%" align="right"> <a href="periodosnominaadm.php"> <input type="button" class="button" value="<<"> </a></td>
                     </tr> 
                    </table>
                    <table width="100%">
                     <tr class="TablaDocsPar">				
                      <td width="160" align="right"> <label class="Texto13"> Nombre:&nbsp </label> </td> 			  
                      <td width="240">'.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,500).'</td>
                     </tr>
                    </table>
                    <center>                    
                    <table width="100%">
                     <tr class="CabezoteTabla">
                      <td align="center">
                       <input type="submit" value="aceptar" class="button blue">
                       </form>
                      </td>
                     </tr>
                    </table>';

            // Pie de página
            $cont.='<table width="100%"> 
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
    
            echo $cont.$clase->PiePagina();
            exit();
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: valnegativo
    // Creación: 24/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite una lista de empleados con saldo negativo de un periodo 
    //              de presentarse el caso
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "valnegativo")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $ldtienenegativos = false;

        // Nueva consulta con los nuevos campos para el nombre
        $vsql = "SELECT t.dni, t.terid, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                        SUM(d.devengados) - SUM(d.descuentos) AS total  
                   FROM detallenomina d
                        INNER JOIN terceros t ON (d.terid = t.terid)
                  WHERE d.pernominaid = ".$periodoid."
                        AND d.conceptoid NOT IN (6, 9, 43, 58) 
               GROUP BY t.dni, t.terid, nombreemp";        

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);   
        $i = 0;

        // Recorro la consulta para buscar negativos
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($row['total']<0)            
                $ldtienenegativos = true;            
        }

        // En caso de no tenerlos emito el mensaje correspondiente
        if(!$ldtienenegativos)
        {
            $clase->Aviso(2,"El periodo <b>$descripcion</b> no tiene empleados con saldo negativo");
            header("Location: periodosnominaadm.php");            
        }
        else
        {
            // Imprimo la lista de empleados con saldo negativo
            $_SESSION['SQL_NEGATIVOS'] = $vsql;

            // Pinto la ventana donde aparecerán los empleados con negativo
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/remisionesen.png" width="32" height="32" border="0"> </td>
                      <td width="535"> <b>Empleados con saldo negativo del periodo '.$descripcion.'</b> </td>
                      <td width="20"> &nbsp; </td>
                      <td width="24"> <a href="periodosnominaadm.php"><input type="button" value="<<" class="button"></a> </td>
                     </tr>	 			   
                    </table>';

            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                       <td width="20"> &nbsp; </td>
                       <td width="110"> C&eacute;dula </td>
                       <td width="320"> Nombre </td>			
                       <td width="75"> &nbsp; </td>
                       <td width="75"> &nbsp; </td>	
                       <td width="45"> &nbsp; </td>
                       <td width="50"> &nbsp; </td>
                       <td width="50"> &nbsp; </td>
                       <td width="60"> &nbsp; </td>                                              
                       <td width="150" align="right"> Saldo </td>
                       <td width="30"> &nbsp; </td>
                       <td width="40"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:690px; overflow-Y:scroll">';

            $tipoimpresion="negativo";

            $conex  = $clase->Conectar();
            $result = @mysql_query($vsql,$conex);
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                // Imprimo el empleado con saldo negativo
                if($row['total']<0)
                {                        
                    $i++;
                    if($i%2 == 0)
                        $cont.='<tr class="TablaDocsPar">';
                    else
                        $cont.='<tr class="TablaDocsImPar">';

                    $cont.=' <td width="20"> &nbsp; </td>
                             <td width="110"> '.$row['dni'].' </td>
                             <td width="320"> '.$row['nombreemp'].' </td>
                             <td width="80"> &nbsp; </td>
                             <td width="85"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="40"> &nbsp; </td>
                             <td width="20"> <font color="red">'.number_format($row['total']).'</font></td>
                             <td width="30"> &nbsp; </td>
                             <td width="40">  
                              <a href="recibodepago.php?opcion=negativo&periodoid='.$periodoid.'&dni='.$row['dni'].'" target="_blank">
                              <img src="images/basicas/pdf.png" title="Recibo" border="0"></a>                             
                             </td>
                            </tr>';
                }
            }
            
            $cont.=' </tbody>
                    </table>';

            // Totales
            $cont.='<table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="20"> &nbsp; </td>
                      <td width="1588" align="left"> <font color="white"> <b> Total negativos: </b> '.number_format($i).' </font> </td>
                     </tr>
                    </table>';                    
        }
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacerrarperiodo
    // Creación: 24/02/2024		última modificación: 29/01/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que confirma el cierre definitivo de un periodo
    // Última modificación: Impresión de los empleados que serán dados de baja durante el 
    //                      proceso de cierre
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacerrarperiodo")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Consulta para buscar diferencias
        $vsql3= "SELECT COUNT(d.detalleid) AS numdiferencias
                   FROM detallenomina d 
                        INNER JOIN tercerosactual t ON (d.terid = t.terid)
                  WHERE d.pernominaid = ".$periodoid." 
                        AND d.conceptoid = 1 
                        AND d.saldo <> t.basico";
        $numdiferencias = $clase->SeleccionarUno($vsql3);

        // Pinto la ventana
        $cont= '<table width="580">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <br> <b>Cerrar periodo de nómina</b> <br><br> </td> 
                 </tr> 
                </table>
                <table width="580">
                 <tr class="BarraDocumentos" style="height:50px;Important!">       
                  <td width="580" align="center">
                   <label class="Texto12"> ¿Confirma que desea cerrar el periodo de n&oacute;mina<br><b> '.$descripcion.'</b>? </label> <br> </td>       
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">       
                  <td width="580" align="center"><br><br>
                   <form action="?opcion=cerrarperiodo" method="POST">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="periodosnominaadm.php" ><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table>';

        // consulta para los empleados que serán dados de baja
        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

        $vsql4 = "SELECT dni, codvende, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp, esempleadoactivo, fecharetiro 
                    FROM terceros 
                   WHERE fecharetiro BETWEEN '".$fecdesde."' AND '".$fechasta."'  
                         AND basico > 0 
                         AND esempleadoactivo = 'CHECKED'
	                     AND terid IN (SELECT terid FROM `tercerosactual` WHERE pernominaid = ".$periodoid.")";        

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql4,$conex);
        $cant   = mysql_num_rows($result);

        if($cant > 0)
        {
            $cont.='<table width="580">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b>Empleados que ser&aacute;n inactivados</b> <br><br> </td> 
                     </tr> 
                    </table>
                    <script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="580" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="20"> &nbsp; </td>
                       <td width="100"> Documento </td>
                       <td width="390"> Nombre </td>
                       <td width="70"> Retiro </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:580px; height:200px; overflow-Y:scroll">';                    

            // impresión del detalle
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';

                $fecharetiro = substr($row['fecharetiro'],8,2)."/".substr($row['fecharetiro'],5,2)."/".substr($row['fecharetiro'],0,4);

                $cont.=' <td width="20"> &nbsp; </td>
                         <td width="100" align="left"> '.$row['dni'].' </td>
                         <td width="380" align="left"> '.$row['nombreemp'].' </td>
                         <td width="80" align="right"> '.$fecharetiro.' </td>
                         <td width="10"> &nbsp; </td>
                        </tr>';
            }

            $cont.=' </tbody>
                    </table>
                    <table width="580"> <tr class="TituloTabla"> <td width="580"> &nbsp; </td> </tr> </table>';
        }

        echo $cont; 
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cerrarperiodo
    // Creación: 24/02/2024		última modificación: 27/03/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que cierra un periodo de nómina
    // Última modificación: Pase a retiro de los empleados con fecha de retiro dentro del 
    //                      periodo (21/03/2024)
    //                      Anulación del proceso para dar de baja a los empleados con fecha 
    //                      de retiro dentro del periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "cerrarperiodo")
    {
        $periodoid = $_POST['periodoid'];

        // Obtengo el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $valor = 0;
        $valor2 = 0;
        $cerradoper = "";
        $numdiferencias = 0;

        // Valido que el periodo no esté procesado en la tabla detalle de nómina
        $vsql = "SELECT COUNT(*) 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $valor = $clase->SeleccionarUno($vsql);

        if($valor==0)
        {
            $clase->Aviso(3,"El periodo <b> $descripcion </b> no puede ser cerrado porque no ha sido procesado");
            header("Location: periodosnominaadm.php");
        }
        else
        {
            // Valido que la tabla tercerosactual tenga datos
            $vsql = "SELECT COUNT(*) 
                       FROM tercerosactual
                      WHERE pernominaid = ".$periodoid;
            $valor2 = $clase->SeleccionarUno($vsql);

            if($valor2==0)
            {
                $clase->Aviso(3,"No existen empleados cargados en el periodo <b> $descripcion </b>");
                header("Location: periodosnominaadm.php");
            }
            else
            {
                // Determino si tiene empleados en negativo
                $ldtienenegativos = false;
    
                $vsql3 = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                                 SUM(d.devengados) - SUM(d.descuentos) AS total
                            FROM detallenomina d
                                 INNER JOIN tercerosactual t ON (d.terid = t.terid)
                           WHERE d.pernominaid = ".$periodoid." 
                                 AND d.conceptoid NOT IN (6, 9, 43, 58) 
                        GROUP BY t.dni, nombreemp";
    
                $conex3  = $clase->Conectar();
                $result3 = mysql_query($vsql3,$conex3);
    
                // Recorro la consulta para buscar negativos
                while($row3 = mysql_fetch_array($result3))
                {
                    if($row3['total'] < 0)
                        $ldtienenegativos = true;
                }
    
                if($ldtienenegativos)
                {
                    $clase->Aviso(3,"No se puede cerrar el periodo <b> $descripcion </b> porque tiene empleados en negativo");
                    header("Location: periodosnominaadm.php");
                }
                else
                {
                    // Guardo el cambio de estatus
                    $cerrado = 'CHECKED';
                    $vsql = "UPDATE periodosnomina SET 
                                    cerrado = '".$cerrado."'
                              WHERE periodoid = ".$periodoid."";
                    $clase->EjecutarSQL($vsql);

                    $vsql13 = "SELECT cerrado FROM periodosnomina WHERE periodoid = ".$periodoid;
                    $cerradoper = $clase->SeleccionarUno($vsql13);

                    if($cerradoper =="CHECKED")
                    {
                        // Validación de acuerdo a la configuración del sistema
                        $cal_libranza = $_SESSION['G_CAL_LIBRANZA'];
    
                        if($cal_libranza=="CHECKED")
                        {
                            $vsql = "SELECT l.libranzaid, l.cuotaspagadas, d.terid
                                       FROM detallenomina d 
                                            INNER JOIN libranzas l ON (d.conceptoid = l.conceptoid AND d.terid = l.terid)
                                      WHERE d.pernominaid = ".$periodoid."
                                            AND l.cuotaspagadas < l.totalcuotas";
        
                            $conex  = $clase->Conectar();
                            $result = mysql_query($vsql,$conex);
                            $cant   = mysql_num_rows($result);
                            if($cant>0)
                            {
                                while($row = mysql_fetch_array($result))
                                {
                                    $libranzaid = $row['libranzaid'];
                                    $cuotaspagadas = $row['cuotaspagadas'];
                                    $cuotaspagadas++;
        
                                    $vsql2 = "UPDATE libranzas SET 
                                                     cuotaspagadas = ".$cuotaspagadas."
                                               WHERE libranzaid = ".$libranzaid."";
                                    $clase->EjecutarSQL($vsql2);
                                }
                            }
                        }
    
                        // Carga de datos en la tabla de enlace entre detallenomina y terceros
                        $vsql = "INSERT INTO periodoterceros (pernominaid, terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid, 
                                             cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, nombre, epsid,pensionesid) 
                                      SELECT pernominaid, terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                             cargoid, bancoid, numcuenta, fecingreso, basico, codvende,
                                             dni, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre,
                                             epsid, pensionesid 
                                        FROM tercerosactual
                                       WHERE pernominaid = ".$periodoid;
                        $clase->EjecutarSQL($vsql);
    
                        // Paso a histórico el periodo ya cerrado
                        $vsql = "INSERT INTO hisdetallenomina (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo)
                                      SELECT d.terid, d.conceptoid, d.pernominaid, d.devengados, d.descuentos, d.valor, d.saldo 
                                        FROM detallenomina d 
                                       WHERE d.pernominaid = ".$periodoid;
                        $clase->EjecutarSQL($vsql);
    
                        if(mysql_affected_rows() >= 1)
                            $lbcierrecorrecto = true;
                        else
                            $lbcierrecorrecto = false;
    
                        // -------------------------------------------------------------------------------------------------------------------- //
                        // Depuro la tabla hisdetallenomina eliminando los registros que no tengan relación con periodoterceros
                        $numbasura = 0;
                        $vsql4 = "SELECT DISTINCT terid 
                                    FROM hisdetallenomina
                                   WHERE pernominaid = ".$periodoid." AND 
                                         terid NOT IN (SELECT terid
                                                         FROM periodoterceros
                                                        WHERE periodoterceros.pernominaid = ".$periodoid.")";
                        $conex  = $clase->Conectar();
                        $result4 = mysql_query($vsql4,$conex);
                        $numbasura = mysql_num_rows($result4);
    
                        if($numbasura>0)
                        {
                            while($row4 = mysql_fetch_array($result4))
                            {
                                $terid = $row4['terid'];
        
                                $vsql5 = "DELETE FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                                $clase->EjecutarSQL($vsql5);
        
                                $vsql6 = "DELETE FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                                $clase->EjecutarSQL($vsql6);
                            }
                        }

                        // Proceso para inactivar los empleados con fecha de retiro durante el periodo
                        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

                        $vsql49 = "SELECT terid, fecingreso, fecharetiro 
                                     FROM terceros 
                                    WHERE fecharetiro BETWEEN '".$fecdesde."' AND '".$fechasta."'  
                                          AND basico > 0 
                                          AND esempleadoactivo = 'CHECKED'
                                          AND terid IN (SELECT terid FROM `tercerosactual` WHERE pernominaid = ".$periodoid.")";
                
                        $conex  = $clase->Conectar();
                        $result49 = mysql_query($vsql49,$conex);
                        $cant   = mysql_num_rows($result49);                        
                
                        if($cant > 0)
                        {
                            while($row49 = mysql_fetch_array($result49))
                            {
                                $terid = $row49['terid'];
                                $fecingreso = $row49['fecingreso'];
                                $fecharetiro = $row49['fecharetiro'];

                                if((strlen($fecingreso) > 0) && (strlen($fecharetiro) > 0))
                                    pasearetiro($terid,$fecingreso,$fecharetiro);
                            }
                        }

                        // -------------------------------------------------------------------------------------------------------------------- //
                        // Limpio la tabla tercerosactual
                        $vsql = "DELETE FROM tercerosactual";
                        $clase->EjecutarSQL($vsql);

                        // -------------------------------------------------------------------------------------------------------------------- //
                        // Corrijo los registros con diferencias en saldo/base en caso de ser necesario
                        $vsql33 = "SELECT COUNT(d.detalleid) AS numdiferencias
                                     FROM hisdetallenomina d 
                                          INNER JOIN periodoterceros t ON (d.terid = t.terid AND d.pernominaid = t.pernominaid) 
                                    WHERE d.pernominaid = ".$periodoid." 
                                          AND d.conceptoid = 1 
                                          AND d.saldo <> t.basico";
                        $numdiferencias = $clase->SeleccionarUno($vsql33);

                        if($numdiferencias > 0)
                        {
                            $vsql34 = "SELECT d.detalleid, t.basico, d.terid  
                                         FROM hisdetallenomina d 
                                              INNER JOIN periodoterceros t ON (d.terid = t.terid AND d.pernominaid = t.pernominaid) 
                                        WHERE d.pernominaid = ".$periodoid." 
                                              AND d.conceptoid = 1 
                                              AND d.saldo <> t.basico";

                            $conex = $clase->Conectar();
                            $result34 = @mysql_query($vsql34,$conex);
                            while($row34 = mysql_fetch_array($result34))
                            {
                                $detalleid = $row34['detalleid'];
                                $basico = $row34['basico'];
                                $terid = $row34['terid'];
                    
                                // Corrijo en el historial
                                $vsql44 = "UPDATE hisdetallenomina SET saldo = ".$basico." WHERE detalleid = ".$detalleid;
                                $clase->EjecutarSQL($vsql44);
                    
                                // Corrijo en la tabla detallenomina
                                $vsql24 = "SELECT detalleid AS detalleidant FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                                $detalleidant = $clase->SeleccionarUno($vsql24);
                    
                                $vsql35 = "UPDATE detallenomina SET saldo = ".$basico." WHERE detalleid = ".$detalleidant;
                                $clase->EjecutarSQL($vsql35);
                            }
                        }

                        if($lbcierrecorrecto)
                            $clase->Aviso(1,"Periodo <b> $descripcion </b> cerrado exitosamente");
                        else
                            $clase->Aviso(3,"No se cerró el periodo correctamente <b> $descripcion </b>, comuníquese con el administrador del sistema ERROR 1524");

                        header("Location: periodosnominaadm.php");
                    }
                }
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: venteditarperant
    // Creación: 26/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana que capta el motivo por el cual se 
    //              modificarán los datos de un empleado en un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "venteditarperant")
    {
        $periodoid  = $_GET['periodoid'];
        $origen = $_GET['origen'];        

        $cont.='<form action="ajusteextemporaneo.php" method="POST">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <input type="hidden" name="origen" value="'.$origen.'">
                <table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Digite el motivo del cambio que se realizar&aacute; </b> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="motivo" cols="50" rows="5"></textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <input type="submit" value="Guardar y Continuar" class="button"> </form> </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////
    echo $cont.$clase->PiePagina();

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función pasearetiro
    // Parámetro de entrada:    $terid       --> Id del empleado
    //                          $fecingreso  --> Fecha de ingreso
    //                          $fecharetiro --> Fecha de retiro
    // Valor de retorno:        Ninguno
    // Descripción: Función que pasa a retiro al empleado cuando tiene en blanco el campo 
    //              esempleadoactivo
    ////////////////////////////////////////////////////////////////////////////////////////
    function pasearetiro($terid,$fecingreso,$fecharetiro)
    {
        $clase2 = new Sistema();

        // Determino qué condición de empleado posee
        $cargoid = $clase2->BDLockup($terid,'terceros','terid','cargoid');
        $extralegal = $clase2->BDLockup($terid,'terceros','terid','extralegal');
        $esempleadoactivo = $clase2->BDLockup($terid,'terceros','terid','esempleadoactivo');
        $basico = $clase2->BDLockup($terid,'terceros','terid','basico');
        $idcondicionact = $clase2->BDLockup($terid,'terceros','terid','idcondicion');
        $cupocredito = $clase2->BDLockup($terid,'terceros','terid','cupocredito');

        if($idcondicionact == 0)
        {
            $idcondicion = 0;
    
            if($cargoid==70)
                $idcondicion = 1;
            elseif($cargoid==71)
                $idcondicion = 2;
            elseif(($extralegal=="CHECKED")&&($esempleadoactivo=="CHECKED"))
                $idcondicion = 3;
            elseif(($extralegal!="CHECKED")&&($esempleadoactivo=="CHECKED"))
                $idcondicion = 4;
        }
        else
            $idcondicion = $idcondicionact; 

        $lb_valido = false;
        $lb_valido = compararfecha($fecingreso,$fecharetiro);   // llamado al procedimiento de validación de la fecha

        if($lb_valido)
        {
            // Cambio el estatus de empleado en la tabla terceros
            $esempleado = "";
            $esempleadoactivo = "";
            $enliquidacion = "CHECKED";

            $vsql = "UPDATE terceros SET 
                            esempleado = '".$esempleado."',
                            esempleadoactivo = '".$esempleadoactivo."',                            
                            enliquidacion = '".$enliquidacion."',
                            idcondicion = ".$idcondicion."
                      WHERE terid = ".$terid;
            $clase2->EjecutarSQL($vsql);

            // previsión para el cupo de crédito            
            if(($cupocredito == 0) || ($cupocredito == NULL))
            {
                $newcupo = 200000;
                $clase2->EjecutarSQL("UPDATE terceros SET cupocredito = ".$newcupo." WHERE terid = ".$terid."");
            }

            // Calculo el nuevo ID del histórico de contrato
            $vsql = "SELECT MAX(id) FROM histcontrato";
            $numid = $clase2->SeleccionarUno($vsql);
            $numid++;

            $vsql = "INSERT INTO histcontrato (id,terid,fecingreso,fecretiro,ultsueldo,idcondicion) VALUES (".$numid.",".$terid.",'".$fecingreso."','".$fecharetiro."',".$basico.",".$idcondicion.")";
            $clase2->EjecutarSQL($vsql);
            
            // Elimino el empleado de la tabla de enlace sección terceros
            $vsqld = "DELETE FROM seccionterceros WHERE terid = ".$terid;
            $clase2->EjecutarSQL($vsqld);

            $cal_libranza = $_SESSION['G_CAL_LIBRANZA'];
            $cal_permanente = $_SESSION['G_CAL_PERMANENTE'];
            
            // ---------------------------------------------------------------------------------------------------------------------------------------- //
            // Deshabilito las libranzas que este empleado pueda tener
            if($cal_libranza=="CHECKED")
            {
                $totalcuotas = 0;
                $libranzaid = 0;
                $cant = 0;
    
                $vsql2 = "SELECT libranzaid, totalcuotas 
                            FROM libranzas 
                           WHERE terid = ".$terid." AND cuotaspagadas < totalcuotas";

                $conex  = $clase2->Conectar();
                $result2 = mysql_query($vsql2,$conex);
                $cant   = mysql_num_rows($result2);
                if($cant>0)
                {
                    while($row2 = mysql_fetch_array($result2))
                    {
                        $totalcuotas = $row2['totalcuotas'];
                        $libranzaid = $row2['libranzaid'];
    
                        $vsql = "UPDATE libranzas SET 
                                        cuotaspagadas = ".$totalcuotas."
                                  WHERE libranzaid = ".$libranzaid;
                        $clase2->EjecutarSQL($vsql);
                    }
                }
            }

            // Deshabilito los descuentos permanentes que este empleado pueda tener
            if($cal_permanente=="CHECKED")
            {
                $cant = 0;
                $permanenteid = 0;
    
                $vsql3 = "SELECT permanenteid 
                            FROM descuentospermanente 
                           WHERE terid = ".$terid;
                $conex  = $clase2->Conectar();
                $result3 = mysql_query($vsql3,$conex);
                $cant   = mysql_num_rows($result3);
                if($cant>0)
                {
                    while($row3 = mysql_fetch_array($result3))
                    {
                        $permanenteid = $row3['permanenteid'];
                        $vsql4 = "DELETE FROM descuentospermanente WHERE permanenteid = ".$permanenteid;
                        $clase2->EjecutarSQL($vsql4);
                    }
                }
            }
        }
        return(true);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función compararfecha
    // Parámetro de entrada:    $ad_desde --> fecah desde
    //                          $ad_hasta --> fecha hasta
    // Valor de retorno:        $lb_fechavalida --> fecha valida (true or false)
    // Descripción: Función que determina si la fecha de inicio es menor a la fecha final
    ////////////////////////////////////////////////////////////////////////////////////////
    function compararfecha($ad_desde,$ad_hasta)
    {
        $lb_fechavalida=false;
        $ld_desdeaux = convert_date($ad_desde);
        $ld_hastaaux = convert_date($ad_hasta);
          
        if(($ld_desdeaux=="")||($ld_hastaaux==""))
        {
            $lb_fechavalida=false;
        }
        else
        {
            $ld_anod= substr($ld_desdeaux,0,4);
            $ld_mesd= substr($ld_desdeaux,5,2);
            $ld_diad= substr($ld_desdeaux,8,2);
            $ld_anoh= substr($ld_hastaaux,0,4);
            $ld_mesh= substr($ld_hastaaux,5,2);
            $ld_diah= substr($ld_hastaaux,8,2);
              
            if($ld_anod<$ld_anoh)
                {$lb_fechavalida=true;}
            elseif($ld_anod==$ld_anoh)
            {
                if($ld_mesd<$ld_mesh)
                    {$lb_fechavalida=true;}
                elseif($ld_mesd==$ld_mesh)
                {
                    if($ld_diad<=$ld_diah)
                        {$lb_fechavalida=true;}
                }
            }
        }
        return $lb_fechavalida;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función convert_date
    // Parámetro de entrada:    $as_cadena --> cadena de la fecha    
    // Valor de retorno:        $ls_fecreg --> fecha covertida
    // Descripción: Función que convierte un formato de fecha
    ////////////////////////////////////////////////////////////////////////////////////////
    function convert_date($as_cadena)
    {
        $ls_fecreg=""; 
        $li_pos=strpos($as_cadena,"/");
        $li_pos2=strpos($as_cadena,"-");
        
        if(($li_pos==2)||($li_pos2==2))
        {
            $ls_fecreg=(substr($as_cadena,6,4)."-".substr($as_cadena,3,2)."-".substr($as_cadena,0,2)); 
        }
        elseif(($li_pos==4)||($li_pos2==4))
        {
            $ls_fecreg=$as_cadena;
        }
        return $ls_fecreg;
    }

?>