<?PHP
    session_start(); 
    include("lib/Sistema.php");

    $clase = new Sistema();
    
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    // -------------------------------------------------------------------------- //
    // Oración a san Miguel arcángel
    // 
    // San Miguel arcángel, defiéndenos en batalla,
    // sé nuestro amparo contra las maldades y acechanzas del diablo,
    // que Dios le reprenda, es nuestra humilde súplica;
    // y tú, Príncipe de las huestes celestiales,
    // por el poder de Dios,
    // arroja al Infierno a Satanás y a los demás espíritus malignos,
    // que rondan por el mundo buscando la ruina de las almas.
    // Amén.
    // -------------------------------------------------------------------------- //
  
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: menu
    // Creación: 07/10/2020		última modificación: 18/12/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para las opciones de cada periodo de nómina
    // Última modificación: Inclusión de las opciones básicos, licencias, compras a crédito, 
    //                      libranzas, recibos individuales, deshacer nómina, cerrar 
    //                      periodo y eliminar concepto a un empleado.
    //                      (10/11/2020)
    //                      Se eliminó la opción de libranzas para ser procesadas fuera del 
    //                      periodo (23/11/2020)
    //                      Inclusión de la opción para la consulta de empleados con saldo 
    //                      negativo (25/11/2020)
    //                      Inclusión de la nueva opción de libranzas por lotes (03/12/2020)
    //                      Inclusión de la opción para el registro extemporáneo 
    //                      (26/03/2021)
    //                      Cambio de la opción de calcular nómina direccionando este a la 
    //                      ventana donde se indica que se está haciendo el cálculo 
    //                      respectivo (11/05/2021)
    //                      Validación de la opción generar macro cuando el periodo tiene 
    //                      empleados en negativo (27/08/2021)
    //                      Opción de empleados en el periodo (03/10/2022)
    //                      Inclusión de la opción libranzas y descuentos permanentes
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "menu")
    {
        $periodoid   = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado=="CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        // --------------------------------------------------------------------------------------------------------------- //
        // Determino si tiene empleados en negativo
        $ldtienenegativos = false;

        $vsql2 = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                         SUM(d.devengados) - SUM(d.descuentos) AS total
                    FROM detallenomina d
                         INNER JOIN ".$tabla." t ON (d.terid = t.terid)
                   WHERE d.pernominaid = ".$periodoid." 
                         AND d.conceptoid NOT IN (6, 9, 43, 58) 
                GROUP BY t.dni, nombreemp";

                // echo $vsql2; exit();

        $conex2  = $clase->Conectar();
        $result2 = mysql_query($vsql2,$conex2);

        // Recorro la consulta para buscar negativos
        while($row2 = mysql_fetch_array($result2))
        {
            if($row2['total']<0)
                $ldtienenegativos = true;
        }
        // --------------------------------------------------------------------------------------------------------------- //
        if($ldtienenegativos)
            $contnegativos = '<a href="?opcion=valnegativo&periodoid='.$periodoid.'" target="_blank"> Empleados en negativo </a>';
        else
            $contnegativos = ' Empleados en negativo ';
        // --------------------------------------------------------------------------------------------------------------- //
        // Número de empleados en el periodo actual
        $vsql = "SELECT COUNT(*) AS numteract
                   FROM tercerosactual 
                  WHERE pernominaid = ".$periodoid;
        $numteract = $clase->SeleccionarUno($vsql);

        if($numteract > 0)
            $contempper = ' <td width="360"> 
                             <a href="tercerosactual.php?opcion=ventanaterceros" title="editar los terceros del periodo actual" target="_blank">
                              Empleados del periodo actual
                             </a> 
                            </td>';
        else
            $contempper = ' <td width="360"> Empleados del periodo actual </td>';
        // --------------------------------------------------------------------------------------------------------------- //

        $cont ='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Men&uacute; del Periodo <br> <font color="blue"> '.$descripcion.' </font> </b> </td> 
                 </tr> 
                </table>
                <table width="400">                 
                 <tr class="TablaDocsImPar">
                  <td width="40" align="center"> <img src="images/basicas/actualizar.png" border="0"> </td> 
                  <td width="360"> 
                    <a href="?opcion=confirmarcalculo&periodoid='.$periodoid.'" target="_blank"> Calcular n&oacute;mina </a> 
                  </td>
                 </tr>
                 <tr class="TablaDocsPar">
                  <td width="40" align="center"> <img src="images/basicas/codigobarras.png" border="0"> </td> 
                  <td width="360"> 
                   <a href="?opcion=ventanalicencias&periodoid='.$periodoid.'" target="_blank"> Novedades </a>
                  </td>                   
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="40" align="center"> <img src="images/basicas/facturar.png" border="0"> </td> 
                  <td width="360"> 
                   <a href="periodosnomina.php?opcion=ventanaocasionales&periodoid='.$periodoid.'" target="_blank"> Ocasionales </a>
                  </td> 
                 </tr>
                 <tr class="TablaDocsPar">
                  <td width="40" align="center"> <img src="images/basicas/facturar.png" border="0"> </td> 
                  <td width="360"> 
                   <a href="periodosnomina.php?opcion=ventanapermanentes&periodoid='.$periodoid.'" target="_blank"> Libranzas y descuentos permanentes </a>
                  </td> 
                 </tr>
                 <tr class="TablaDocsimPar">
                  <td width="40" align="center"> <img src="images/basicas/iconoborrar.png" border="0"> </td> 
                  <td width="360"> 
                   <a href="?opcion=venteliminaconceptoemp&periodoid='.$periodoid.'" target="_blank"> Eliminar concepto de un empleado </a>
                  </td>
                 </tr>
                 <!-- -------------------------------------------------------------------------------------------------
                 <tr class="TablaDocsPar">
                  <td width="40" align="center"> <img src="images/basicas/regenerar.png" border="0"> </td> 
                  <td width="360"> 
                   <a href="?opcion=compraslote&periodoid='.$periodoid.'" target="_blank"> Ocasionales por lotes </a>                    
                  </td>
                 </tr>
                 -------------------------------------------------------------------------------------------------- -->
                 <tr class="TablaDocsPar">
                  <td width="40" align="center"> <img src="images/basicas/encompra.png" border="0"> </td> 
                  <td width="360"> 
                   <a href="libranzas.php?opcion=libranzaslote&periodoid='.$periodoid.'" target="_blank"> Libranzas por lotes </a>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="40" align="center"> <img src="images/basicas/error.png" border="0"> </td> 
                  <td width="360"> ';                   
                   
        $cont.= $contnegativos;

        $cont.='  </td>
                 </tr>';
                 
        if($ldtienenegativos)
            $cont.='<tr class="TablaDocsPar">
                     <td width="40" align="center"> <img src="images/basicas/excel.png" border="0"> </td> 
                     <td width="360"> <font color="RED"> Generar macro (existen empleados con saldo negativo) </font> </td>
                    </tr>';
        else
            $cont.='<tr class="TablaDocsPar">
                     <td width="40" align="center"> <img src="images/basicas/excel.png" border="0"> </td> 
                     <td width="360">  <a href="?opcion=arhivoexcel1&periodoid='.$periodoid.'" target="_blank"> Generar macro </a> </td>
                    </tr>';

        $cont.=' <tr class="TablaDocsImPar">
                  <td width="40" align="center"> <img src="images/basicas/nofiltro.png" border="0"> </td> 
                  <td width="360">                    
                   <a href="?opcion=ventanalimconp&periodoid='.$periodoid.'" target="_blank"> Limpiar concepto </a>
                  </td>
                 </tr>
                 <tr class="TablaDocsPar">
                  <td width="40" align="center"> <img src="images/basicas/nopagado.png" border="0"> </td> 
                  <td width="360">                    
                   <a href="?opcion=ventanaextemporaneo&periodoid='.$periodoid.'" target="_blank"> Registro extempor&aacute;neo </a>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="40" align="center"> <img src="images/basicas/excel.png" border="0"> </td> 
                  <td width="360">                    
                   <a href="importacionexcelnom.php?opcion=ventanaimportacion" target="_blank"> Cargas masivas </a>
                  </td>
                 </tr>
                 <tr class="TablaDocsPar">
                  <td width="40" align="center"> 
                   <img src="images/basicas/persona.png" border="0"> 
                  </td> ';

        $cont.= $contempper;

        $cont.=' </tr>
                </table>';

        echo $cont;	
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: precalcular
    // Creación: 11/05/2021		última modificación: 12/05/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana que le indica al usuario que se está 
    //              calculando la nómina
    // Última modificación: Inclusión del contador de tiempo 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "precalcular")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
     
        $cont.= $clase->Header("S","W");
        $cont.='<form name="x" method="POST" action="periodosnomina.php?opcion=calbasicos&periodoid='.$periodoid.'">                  
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/infventaspos.png" width="32" height="32" border="0"> </td>
                  <td width="707"> <b> Calculando n&oacute;mina </b> </td>
                  <td width="183" align="right"> Por favor espere ... </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>
                <br>
                <center>
                <h3> Calculando el periodo <font color="BLUE">'.$descripcion.'</font> </h3><br>
                Por favor no interrumpa el proceso mientras se realizan <br>todos los c&aacute;lculos b&aacute;sicos de los empleados<br><br><br>
                <img src="images/basicas/cargando.gif" border="0">
                <script language="Javascript">
                 function redireccionar() {  
                  setTimeout("location.href=\'periodosnomina.php?opcion=calbasicos&periodoid='.$periodoid.'\'", 3000);
                 }
                 redireccionar();
                </script>
                <br><br><br>                   
                <!-- Contador de tiempo -->
                <div style="margin: 0px auto; text-align: center; width: 250px;">
                 <img src="images/basicas/1.gif" border="0">
                 <img src="images/basicas/2.gif" border="0">
                 <img src="images/basicas/3.gif" border="0">
                 <img src="images/basicas/4.gif" border="0">
                 <img src="images/basicas/5.gif" border="0">
                </div>';
        echo $cont.$clase->PiePagina;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: confirmarcalculo
    // Creación: 06/07/2021		última modificación: 17/03/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta una ventana para la confirmación del cálculo de la 
    //              nómina y muestra el mensaje correspondiente cuando el periodo ha sido 
    //              procesado y cuando no.
    // Última modificación: Advertencia de las licencias pendientes
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarcalculo")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Verifico si existen licencias pendientes para ser procesadas
        $vsql2 = "SELECT COUNT(l.terid) vallicpen 
                    FROM licenciaspendiente l
                         INNER JOIN terceros t ON (l.terid = t.terid)
                   WHERE l.dias > 0
                         AND t.esempleadoactivo = 'CHECKED'";
        $numlicenciaspen = $clase->SeleccionarUno($vsql2);

        if($numlicenciaspen > 0)
            $advertenciapend = ' <tr class="TablaDocsImPar">				
                                  <td width="400" align="center"> 
                                   <img src="images/basicas/alerta.png" border="0"> &nbsp;
                                   <label class="Texto12"><font color="red"><b>Existen '.$numlicenciaspen.' licencias pendientes que ser&aacute;n calculadas en este proceso </b></font></label>
                                  </td>
                                 </tr> ';
        else
            $advertenciapend = '';

        // Consulta para saber si el periodo ya ha sido procesado
        $vsql = "SELECT COUNT(*) AS numregperiodo
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $numregperiodo = $clase->SeleccionarUno($vsql);

        $cont = $clase->Header("S","W");

        if($numregperiodo==0)
        {
            $cont.='<form action="periodosnomina.php?opcion=precalcular&periodoid='.$periodoid.'" method="POST" name="x">
                     <table width="100%">
                      <input type="hidden" name="periodoid" value="'.$periodoid.'">                      
                      <tr class="CabezoteTabla"> 
                       <td width="10%" align="center"> &nbsp; </td> 
                       <td align="center"> <label class="Texto12"> <b> Confirmaci&oacute;n de c&aacute;lculo de la n&oacute;mina </b> </label></td> 
                       <td width="10%" align="center"> 
                        <a href="periodosnomina.php"> 
                        <input type="button" class="button blue" value="<<"> </a>
                       </td>
                      </tr> 
                     </table>
                     <table width="100%">
                      '.$advertenciapend.'
                      <tr class="BarraDocumentos" style="height:50px;Important!"> 
                       <td width="400" align="center"> <label class="Texto12">¿Confirma que desea calcular el periodo de nómina<br><b> '.$descripcion.'</b></label>? </td> 
                      </tr>
                     </table>
                     <center>                     
                     <table width="100%">
                      <tr class="BarraDocumentos" style="height:50px;Important!"> 
                       <td align="center">
                        <input type="submit" value="aceptar" class="button blue">
                        </form>
                       </td>
                      </tr>
                     </table>';

            // Pie de página
            $cont.='<table width="100%"> 
                     <tr class="BarraDocumentos" style="height:50px;Important!">  <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!">  <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!">  <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!">  <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!">  <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!">  <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!">  <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!">  <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!">  <td align="center"> &nbsp; </td> </tr>
                    </table>';
        }
        else
        {
            // Chequeo si el periodo tiene datos básicos
            $vsql = "SELECT count(*) AS registrosper 
                       FROM detallenomina 
                      WHERE pernominaid = ".$periodoid." 
                            AND conceptoid IN (1,3,4,5)";
            $registrosper = $clase->SeleccionarUno($vsql);

            if($registrosper==0)
                $cont.='<form action="periodosnomina.php?opcion=precalcular&periodoid='.$periodoid.'" method="POST" name="x">';
            else
                $cont.='<form action="ajustenomina.php?opcion=prerecalcularperiodo&periodoid='.$periodoid.'" method="POST" name="x">';

            // pinto la ventana
            $cont.='<table width="100%">
                     <input type="hidden" name="periodoid" value="'.$periodoid.'">
                     <tr class="CabezoteTabla"> 
                      <td width="10%" align="center"> &nbsp; </td> 
                      <td align="center"> <label class="Texto12"><b> Confirmaci&oacute;n de c&aacute;lculo de la n&oacute;mina </b> </label></td> 
                      <td width="10%" align="center"> 
                       <a href="periodosnomina.php"> <input type="button" class="button blue" value="<<"> </a>
                      </td>
                     </tr> 
                    </table>
                    <table width="100%">
                     <tr class="BarraDocumentos" style="height:40px;Important!">
                      <td width="400" align="center"> <label class="Texto12">El periodo ya posee algunos datos pre cargados </label></td>
                     </tr>
                     '.$advertenciapend.'
                     <tr class="BarraDocumentos" style="height:40px;Important!">
                      <td width="400" align="center"> <label class="Texto12">¿Confirma que desea recalcular el periodo de nómina<br><b>'.$descripcion.'</b></label>? </td> 
                     </tr>
                    </table>
                    <table width="100%">
                     <tr class="BarraDocumentos" style="height:40px;Important!"> 
                      <td width="400" align="center"> <input type="submit" value="aceptar" class="button blue"> </form> </td> 
                     </tr>                     
                    </table>';

            // Pie de página
            $cont.='<table width="100%"> 
                     <tr class="BarraDocumentos" style="height:40px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:40px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:40px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:40px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:40px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:40px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:40px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:40px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:40px;Important!"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
        }

        echo $cont.$clase->PiePagina();
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventascredito
    // Creación: 11/11/2020		última modificación: 11/08/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para los datos de las compras a crédito 
    //              para empleados
    // Última modificación: Se incorporó el campo de empleado activo en la nómina
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "ventascredito")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',nombres, ' ',apellidos) FROM terceros WHERE esempleadoactivo='CHECKED' ORDER BY nombres";
        $params = ' class="Texto11" ';
        $monto = 1;
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Compras a cr&eacute;dito</b> del periodo '.$descripcion.' </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=guardarcompracredito" method="POST">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                  <fieldset style="width: 530px; height: 250px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Empleado: </b></label><br>';                                
        
        $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,420);

        $cont.='   </td>                   
                  </tr>                    
                  <tr height="55">
                   <td> <label class="Texto12"> <b>Monto:</b></label><br>
                    <input type="number" name="monto" min="1" class="Texto12New" size="20" autocomplete="off" title="monto a descontar" value="'.$monto.'"> 
                   </td>                   
                  </tr>                    
                  <tr height="55">
                   <td align="center"><br><br> 
                    <input type="submit" value="guardar" class="button blue"> 
                   </td>
                  </tr>
                 </table>
                 </form>
                 <br><br>
                 </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarcompracredito
    // Creación: 11/11/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que guarda el nuevo concepto de ventas a crédito en la tabla 
    //              detallenomina como un descuento
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarcompracredito")
    { 
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $monto = $_POST['monto'];

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Valido que el periodo no esté procesado en la tabla detalle de nómina
        $vsql = "SELECT count(*) 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $valor = $clase->SeleccionarUno($vsql);

        if($valor==0)
        {
            $clase->Aviso(3,"No se puede procesar este concepto porque el periodo $descripcion no ha sido procesado");
            header("Location: periodosnomina.php");
        }
        else
        {
            // Obtengo el número de registros de la tabla detallenomina
            $vsql = "SELECT MAX(detalleid) FROM detallenomina";
            $numeroid = $clase->SeleccionarUno($vsql);
    
            // Incremento el ID
            $numeroid++;
    
            // Almaceno en la tabla el concepto de compras a crédito para el trabajador
            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) VALUES ($numeroid,".$terid.",8,".$periodoid.",0,".$monto.",0,0)";
            $clase->EjecutarSQL($vsql);
    
            // Envío el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se procesó la compra a crédito, verifique por favor");
            else
                $clase->Aviso(1,"Compra a crédito procesada exitosamente");
    
            // Redirecciono el formulario
            header("Location: periodosnomina.php?opcion=ventascredito&periodoid=$periodoid");
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanalicencias
    // Creación: 11/11/2020		última modificación: 10/07/2023
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que pinta la ventana para los datos de las licencias
    // Última modificación: Inclusión de la fecha desde para calcular los posibles excesos
    //                      (21/11/2020)
    //                      Se cambió el combo de empleados por el combo con los cuatro 
    //                      campos nuevos (17/02/2021)
    //                      Se incorporó el campo de empleado activo en la nómina
    //                      (11/08/2021)
    //                      Validación del uso de la fecha (13/04/2023)
    //                      Incorporación del código de vendedor en la búsqueda de empleados
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "ventanalicencias")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado=="CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        $vsqlcomboemp = "SELECT terid,  CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                           FROM $tabla 
                          WHERE esempleadoactivo = 'CHECKED' 
                                AND basico > 0
                       ORDER BY primernombre";

        $vsqlcombolic = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE eslicencia='CHECKED' ORDER BY conceptoid";
        $params = ' class="Texto11" ';
        $dias = 1;
        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

        $incapacidadarl = "";
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/egresos.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Novedades del periodo <font color="BLUE"> '.$descripcion.'</font> </b> </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=guardarlicencias" method="POST">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <fieldset style="width: 530px; height: 325px;" class="grupos">
                <legend class="titgrupos"> Datos </legend>
                <table width="350">
                 <tr height="55">
                  <td> 
                   <label class="Texto12"> <b>Empleado: </b></label><br>
                   '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,420).'    
                  </td>
                 </tr>
                 <tr height="55">
                  <td> 
                   <label class="Texto12"> <b>Licencia:</b></label><br>
                   '.$clase->CrearComboBuscar("conceptoid",$vsqlcombolic,"nombres","conceptoid","","N",$params,420).'
                  </td>
                 </tr>
                 <tr height="55">
                  <td>';

        $variab = 'G_NOFECHALIC';
        $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

        if($nofechalic == "CHECKED")
            $cont.=' <label class="Texto12"> <b><font color="gray">Fecha desde:</label></b></label><br> 
                     <input type="date" name="fecdesde" class="Texto12New" autocomplete="off" value = "'.$fecdesde.'" disabled>';
        else
            $cont.=' <label class="Texto12"> <b>Fecha desde:</b></label><br>
                     <input type="date" name="fecdesde" class="Texto12New" autocomplete="off" min="'.$fecdesde.'" max = "'.$fechasta.'">';

        $cont.='  </td>
                 </tr>
                 <tr height="55">
                  <td> <label class="Texto12"> <b>D&iacute;as:</b></label><br>
                   <input type="number" name="dias" min="1" max="180" class="Texto12New" size="12" autocomplete="off" title="días de la licencia" value="'.$dias.'"> 
                  </td>
                 </tr>
                 <tr height="55">
                  <td align="center"><br>
                   <input type="submit" value="guardar" class="button blue"> 
                  </td>
                 </tr>
                </table>
                </form>
                <br><br>
                </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarlicencias
    // Creación: 11/11/2020		última modificación: 16/10/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda el nuevo concepto de licencia en la tabla 
    //              detallenomina     
    // Última modificación: Cálculo de licencia no remunerada, incapacidad, suspensiones, 
    //                      licencia por maternidad, licencia por paternidad y luto
    //                      (12/12/2020)
    //                      Validación para que no se repita un concepto a un empleado en 
    //                      un mismo periodo
    //                      (14/11/2020)
    //                      Inclusión de la fecha desde para calcular los posibles excesos 
    //                      en días que pasarán a licencias pendientes (21/11/2020)
    //                      Se cambiaron los cálculos de la libranza y de devengados por 
    //                      novedades (30/12/2020)
    //                      Modificación de una licencia en caso de que ya exista 
    //                      (23/03/2021)
    //                      Cálculo de la incapacidad cuando el básico no exceda del salario 
    //                      mínimo (24/03/2021)
    //                      Inclusión de los cálculos de transporte y seguridad social con 
    //                      los nuevos campos de la tabla cargos (20/08/2021)
    //                      Validación de la tabla a utilizar para el sueldo básico 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "guardarlicencias")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $dias = $_POST['dias'];
        $conceptoid = $_POST['conceptoid'];
        $fecdesde = $_POST['fecdesde'];

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');        

        // Inicialización de variables
        $valorperiodo = 0;
        $valorconcepto = 0;
        $diff = 0;
        $difendias = 0;
        $diaspendiente = 0;

        // Valido que el periodo esté procesado en la tabla detalle de nómina
        $vsql = "SELECT count(*) 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $valorperiodo = $clase->SeleccionarUno($vsql);

        if($valorperiodo==0)
        {
            $clase->Aviso(3,"No se puede procesar este concepto porque el periodo $descripcion no ha sido procesado");
            header("Location: periodosnomina.php");
        }
        else
        {
            $lbpendiente = false;
            $periodoapagar = 0;
            $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

            // Calculo la diferencia en días
            $fecha1= new DateTime($fecdesde);
            $fecha2= new DateTime($fechasta);
            $diff = $fecha1->diff($fecha2);
            
            $difendias = $diff->days;
            $difendias += 1;

            // ---------------------------------------------------------------------- //
            $suma = "+".strval($dias-1)." day";
            $date_fin = strtotime(".$suma.", strtotime($fecdesde));
            $date_fin = date('Y-m-d', $date_fin);
            
            if($date_fin > $fechasta)
            {
                // ---------------------------------------------------------------------- //
                // Aquí guardo en la tabla correspondiente el exceso en días 
                // para ser calculado en próximos periodos    
                $diaspendiente = $dias - $difendias;

                // --------------------------------------------------------------------------------------------------------- //
                $feciniper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                $diadesde = substr($feciniper, -2);

                if($diadesde=="16")
                {
                    $fecfinper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                    $fechaEntera = strtotime($fecfinper);
                    $valdias = date("d", $fechaEntera);

                    if($valdias=="28")                        
                        $diaspendiente -= 2;

                    if($valdias=="29")
                        $diaspendiente -= 1;

                    if($valdias=="31")
                        $diaspendiente += 1;
                }
                // --------------------------------------------------------------------------------------------------------- //

                $dias -= $diaspendiente;

                $procesado = "";
                $vsql = "SELECT periodoid 
                           FROM periodosnomina 
                          WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE periodoid > $periodoid)";
                $periodoapagar = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO licenciaspendiente (terid,conceptoid,dias,periodoapagar,procesado) VALUES (".$terid.",".$conceptoid.",".$diaspendiente.",".$periodoapagar.",'".$procesado."')";
                $clase->EjecutarSQL($vsql);
                $lbpendiente = true;
            }

            // Inicializo las variables
            $basico = 0;                            $formulabasico = "";                            $diastrab = 0;
            $detalleid = 0;                         $sueldo = 0;                                    $numid = 0;
            $licencianorem = 0;                     $formulatransporte = "";                        $subsidiotransporte = 0;
            $lbpaso = false;                        $formulasuspencion = "";                        $suspension = 0;
            $formulaincapacidad = "";               $incapacidad = 0;                               $formulapaternidad = "";
            $paternidad = 0;                        $totnovedades = 0;                              $sueldostr = "";
            $centenas = "";                         $centenasnum = 0;                               $sueldodeducciones = 0;
            $formulapension = "";                   $pension = 0;                                   $detalleid = 0;
            $formulasalud = "";                     $salud = 0;                

            // Obtengo el salario básico del empleado
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado == "CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            $basico = $clase->BDLockup($terid,$tabla,'terid','basico');

            // Obtengo la formula del sueldo
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
            $formulabasico = $clase->SeleccionarUno($vsql);

            // Obtengo los días trabajados en el periodo
            $vsql = "SELECT valor
                       FROM detallenomina 
                      WHERE conceptoid = 1  
                            AND pernominaid = ".$periodoid."
                            AND terid = ".$terid."";
            $diastrab = $clase->SeleccionarUno($vsql);            

            // Obtengo el ID del registro que se modificará
            $vsql = "SELECT detalleid
                       FROM detallenomina 
                      WHERE conceptoid = 1  
                            AND pernominaid = ".$periodoid."
                            AND terid = ".$terid."";
            $detalleid = $clase->SeleccionarUno($vsql);

            // ------------------------------------------------------------------------ //
            $diastrab -= $dias;

            eval("\$sueldo = $formulabasico;");
            $sueldo = round($sueldo,0);

            // Almaceno en nuevo sueldo
            $vsql = "UPDATE detallenomina SET 
                            devengados = ".$sueldo.", 
                            valor = ".$diastrab."
                      WHERE detalleid = ".$detalleid."";
            $clase->EjecutarSQL($vsql);

            // // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
            // if(mysqli_affected_rows() < 1)
            //     $clase->Aviso(3,"No se procesó correctamente la licencia, comuníquese con el administrador del sistema ERROR 1520");
            // else
            // {

            $vsql32 = "SELECT devengados AS sueldodev FROM detallenomina WHERE detalleid = ".$detalleid;
            $sueldodev = $clase->SeleccionarUno($vsql32);

            if($sueldodev >= 0)
            {
                // Calculo el nuevo ID
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numid = $clase->SeleccionarUno($vsql);
                $numid++;                    

                // Inserto la nueva licencia

                // Obtengo la formula de la licencia
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                $formulalice = $clase->SeleccionarUno($vsql);

                // Calculo la licencia
                if($conceptoid!=10)
                {
                    eval("\$montolicencia = $formulalice;");
                    $montolicencia = round($montolicencia,0);
                }
                else
                {
                    // Calculo la incapacidad                        

                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];

                    // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                    if($basico<=$smlv)
                    {                            
                        $montolicencia = ($smlv*$dias)/30;
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        $porcbasico = ($basico*66.67)/100;
                        $porcbasico = round($porcbasico,0);

                        // Calculo la incapacidad si el básico sea mayor al mínimo 
                        if($porcbasico>$smlv)
                        {
                            $montolicencia = ($porcbasico*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            // $montolicencia = ($smlv*$dias)/30;
                            // $montolicencia = round($montolicencia,0);

                            if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                            if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                            $montolicencia = round($montolicencia,0);
                        }
                    }
                }

                // ------------------------------------------------------------------------------------------------------------------- //                    
                // Obtengo el tipo de licencia
                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                // ------------------------------------------------------------------------------------------------------------------- //
                // Determino si el registro existe para modificarlo o incluirlo
                $vsql = "SELECT COUNT(*) AS repetida 
                           FROM detallenomina
                          WHERE pernominaid = ".$periodoid."
                                AND conceptoid = ".$conceptoid."
                                AND terid = ".$terid."";
                $repetida = $clase->SeleccionarUno($vsql);

                // ------------------------------------------------------------------------------------------------------------------- //
                if($repetida==0)
                {
                    if($tipodc=="C")
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                    else
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
                }
                else 
                {
                    // Determino el id del registro
                    $vsql = "SELECT detalleid AS detalleid 
                               FROM detallenomina
                              WHERE pernominaid = ".$periodoid."
                                    AND conceptoid = ".$conceptoid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);

                    $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
                    $valor += $dias;

                    // Actualizo la licencia
                    if($tipodc=="C")
                    {
                        $devengados = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
                        $devengados += $montolicencia;
                        
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$devengados.", 
                                        valor = ".$valor."
                                  WHERE detalleid = ".$detalleid."";
                    }
                    else
                    {
                        $descuentos = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
                        $descuentos += $montolicencia;

                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$descuentos.", 
                                        valor = ".$valor."
                                  WHERE detalleid = ".$detalleid."";
                    }
                }

                $clase->EjecutarSQL($vsql);

                if(mysql_affected_rows() < 1)
                    $clase->Aviso(3,"No se procesó correctamente la licencia");
                else
                {
                    $clase->Aviso(1,"Licencia procesada exitosamente");
                    $lbpaso = true;
                }
            }

            // ---------------------------------------------------------------------------------------------------------- //
            // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos

            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];

            $cargoid = $clase->BDLockup($terid,'tercerosactual','terid','cargoid');                       // Obtengo el cargo del empleado
            $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte                

            if($diastrab > 0)
            {
                // Variable para la validación del auxilio de transporte
                $valsubtrasp = $smlv * 2;
    
                if(($lbpaso == true)&&($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                {
                    // Obtengo el ID del registro que se modificará
                    $vsql = "SELECT detalleid
                               FROM detallenomina 
                              WHERE conceptoid = 3  
                                    AND pernominaid = ".$periodoid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);
    
                    // Obtengo la formula del subsidio de transporte
                    $auxtrans = $_SESSION['N_AUXTRANS2020'];
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                    $formulatransporte = $clase->SeleccionarUno($vsql);
    
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);
                }
                else
                    $subsidiotransporte = 0;
            }
            else
                $subsidiotransporte = 0;

            // ID transporte
            $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
            $idtransporte = $clase->SeleccionarUno($vsql);
    
            if($idtransporte!="")        
                // Grabo el subsidio de transporte
                $vsql = "UPDATE detallenomina SET 
                                devengados = ".$subsidiotransporte.",
                                valor = ".$diastrab."
                          WHERE detalleid = ".$idtransporte."";        
            else
            {
                // Obtengo el valor del subsidio de transporte
                $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
    
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";            
            }            
    
            $clase->EjecutarSQL($vsql);

            // ----------------------------------------------------------------------------------------------------------- //
            // Obtengo el total devengado por novedades
            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";                
            $totnovedades = $clase->SeleccionarUno($vsql);

            $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
            $totrecargos = $clase->SeleccionarUno($vsql);

            // Actualizo el sueldo
            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

            $extralegal = $clase->BDLockup($terid,'tercerosactual','terid','extralegal');
            $epsid = $clase->BDLockup($terid,'tercerosactual','terid','epsid');
            $pensionesid = $clase->BDLockup($terid,'tercerosactual','terid','pensionesid');
            
            if($epsid==NULL)                $epsid=0;
            if($pensionesid==NULL)          $pensionesid=0;

            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');   // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');   // Obtengo el control del cálculo de salud

            if($extralegal=="CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);

                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }

                if(($epsid==37)||($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }                    
            }                

            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);

            if($idpension!="")            
                // Grabo la pensión
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }

            $clase->EjecutarSQL($vsql);

            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);

            if($idsalud!="")
                // Grabo la salud
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }

            $clase->EjecutarSQL($vsql);

            // ----------------------------------------------------------------------------------------------------------- //
            
            // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
            $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid;
            $clase->EjecutarSQL($vsql);            

            // Redirecciono el formulario
            header("Location: periodosnomina.php?opcion=ventanalicencias&periodoid=$periodoid");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: venteliminaconceptoemp
    // Creación: 12/11/2020		última modificación: 10/07/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para eliminarle un concepto a un empleado
    // Última modificación: Se cambió la consulta del combo de conceptos por el nuevo campo 
    //                      eslicencia (30/12/2020)
    //                      Se cambió el combo de empleados por el combo con los cuatro 
    //                      campos nuevos (17/02/2021)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Incorporación del código de vendedor en la búsqueda de empleados
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "venteliminaconceptoemp")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado=="CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        // Combo para los empleados
        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                           FROM $tabla 
                          WHERE esempleadoactivo = 'CHECKED' 
                                AND basico > 0
                       ORDER BY primernombre";

        // Consulta para los conceptos
        $vsqlcombocon = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) 
                           FROM conceptosnomina 
                          WHERE eslicencia='CHECKED' 
                                OR eslibranza ='CHECKED' 
                                OR montoocasional ='CHECKED' 
                                OR montopermanente ='CHECKED' 
                       ORDER BY conceptoid";

        $params = ' class="Texto11" ';
        $dias = 1;
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/anulardoc.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Eliminar un concepto a un empleado del periodo <font color="blue">'.$descripcion.'</font></b></td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=eliminaconpemp" method="POST">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                  <fieldset style="width: 530px; height: 240px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> 
                     <label class="Texto12"> <b>Empleado: </b></label><br>
                      '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,420).'
                    </td>                   
                  </tr>                    
                  <tr height="55">
                   <td> 
                    <label class="Texto12"> <b>Concepto:</b></label><br>
                     '.$clase->CrearComboBuscar("conceptoid",$vsqlcombocon,"nombres","conceptoid","","N",$params,420).'
                   </td>                   
                  </tr>
                  <tr height="55">
                   <td align="center"><br><br> 
                    <input type="submit" value="aceptar" class="button blue"> 
                   </td>
                  </tr>
                 </table>
                </form>
                <br><br>
                </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: eliminaconpemp
    // Creación: 12/11/2020		última modificación: 30/08/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda la eliminación de un concepto a un empleado
    // Última modificación: Cálculo del subsidio de transporte y validación de las compras 
    //                      a crédito (13/11/2020)
    //                      Impresión del nombre del empleado y el nombre del concepto en 
    //                      el mensaje de conformación
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminaconpemp")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $conceptoid = $_POST['conceptoid'];

        // Inicializo las variables
        $diasconcepto = 0;                          $diastrab = 0;                      $detalleid = 0;
        $formulabasico = "";                        $sueldo = 0;                        $basico = 0;
        $smlv = 0;                                  $valsubtrasp = 0;                   $auxtrans = 0;
        $formulatransporte = "";                    $subsidiotransporte = 0;            $lb_grabosueldo = false;
        $numlicpendientes = 0;

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado=="CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        // Nombre del empleado
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                   FROM ".$tabla." 
                  WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql);

        // Nombre del concepto
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');

        // Obtengo los días del concepto que se eliminará
        $vsql = "SELECT SUM(valor) AS diasconcepto FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $diasconcepto = $clase->SeleccionarUno($vsql);

        $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminó el concepto $nomconcepto al empleado $nombreemp");
        else
        {
            // Determino el ámbito del concepto
            $eslibranza = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','eslibranza');
            $eslicencia = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','eslicencia');
            $montoocasional = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','montoocasional');
            $montopermanente = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','montopermanente');

            // Valido si es una libranza o licencia para recalcular lo correspondiente a ese caso
            if($eslicencia=="CHECKED")
            {
                // Obtengo el salario básico del empleado
                $basico = $clase->BDLockup($terid,'tercerosactual','terid','basico');
    
                // Obtengo los días trabajados en el periodo
                $vsql = "SELECT valor
                           FROM detallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $diastrab = $clase->SeleccionarUno($vsql);
    
                // Obtengo el ID del registro que se modificará
                $vsql = "SELECT detalleid
                           FROM detallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $detalleid = $clase->SeleccionarUno($vsql);
    
                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
    
                // Recalculo el sueldo del periodo
                $diastrab = $diastrab + $diasconcepto;
                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
    
                // Almaceno en nuevo sueldo
                $vsql = "UPDATE detallenomina SET 
                                devengados = ".$sueldo.", 
                                valor = ".$diastrab."
                          WHERE detalleid = ".$detalleid."";
                $clase->EjecutarSQL($vsql);
    
                // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
                if(mysql_affected_rows() < 1)
                    $clase->Aviso(3,"No se procesó correctamente la eliminación del concepto, comuníquese con el administrador del sistema ERROR 1541");
                else
                {
                    // Ahora voy a recalcular el subsidio de transporte si es necesario
                    $lb_grabosueldo=true;       // Variable que controla el mensaje correspondiente
        
                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];
        
                    // Variable para la validación del auxilio de transporte
                    $valsubtrasp = $smlv * 2;

                    $cargoid = $clase->BDLockup($terid,'tercerosactual','terid','cargoid');                       // Obtengo el cargo del empleado
                    $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte

                    if(($basico <= $valsubtrasp) && ($aplicatransporte=="CHECKED"))
                    {
                        // Obtengo el ID del registro que se modificará
                        $vsql = "SELECT detalleid
                                   FROM detallenomina 
                                  WHERE conceptoid = 3  
                                        AND pernominaid = ".$periodoid."
                                        AND terid = ".$terid."";
                        $detalleid = $clase->SeleccionarUno($vsql);
        
                        // Obtengo la formula del subsidio de transporte
                        $auxtrans = $_SESSION['N_AUXTRANS2020'];
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                        $formulatransporte = $clase->SeleccionarUno($vsql);
        
                        eval("\$subsidiotransporte = $formulatransporte;");
                        $subsidiotransporte = round($subsidiotransporte,0);
                    }
                    else
                        $subsidiotransporte = 0;
            
                    // ID transporte
                    $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                    $idtransporte = $clase->SeleccionarUno($vsql);
            
                    if($idtransporte!="")
                        // Grabo el subsidio de transporte
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$subsidiotransporte.",
                                        valor = ".$diastrab."
                                  WHERE detalleid = ".$idtransporte."";
                    else
                    {
                        // Obtengo el valor del subsidio de transporte
                        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
            
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
            
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                    }
                    $clase->EjecutarSQL($vsql);

                    // ----------------------------- //
                    // Recalculo la pensión
                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                    $totnovedades = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);

                    // Actualizo el sueldo
                    // $sueldo += $totnovedades;
                    $sueldo  = $sueldo + $totnovedades + $totrecargos;
                    $sueldodeducciones = $sueldo;

                    // ------------------------------------------------------------------------------------------------------------- //
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);

                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);

                    // Determino si el empleado es de condición extralegal
                    $extralegal = $clase->BDLockup($terid,'tercerosactual','terid','extralegal');
                    $epsid = $clase->BDLockup($terid,'tercerosactual','terid','epsid');
                    $pensionesid = $clase->BDLockup($terid,'tercerosactual','terid','pensionesid');
                    
                    if($epsid==NULL)
                        $epsid=0;
                    if($pensionesid==NULL)
                        $pensionesid=0;

                    // ----------------------------------------------------------------------------------------------------------- //
                    $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                    $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
        
                    if($extralegal=="CHECKED")
                    {
                        $pension = 0;
                        $salud = 0;
                    }
                    else
                    {
                        // Recalculo pensión y salud
                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                            $pension = 0;
                        else
                        {
                            // Obtengo la formula para el descuento por pensión
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                            $formulapension = $clase->SeleccionarUno($vsql);
        
                            // Calculo la pensión
                            eval("\$pension = $formulapension;");
                            $pension = round($pension,0);
                        }
        
                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                            $salud = 0;
                        else
                        {
                            // Obtengo la formula para el descuento de salud
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                            $formulasalud = $clase->SeleccionarUno($vsql);
                            
                            // Calculo la salud
                            eval("\$salud = $formulasalud;");
                            $salud = round($salud,0);
                        }
                    }
        
                    //  ID pensión
                    $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                    $idpension = $clase->SeleccionarUno($vsql);
        
                    if($idpension!="")
                        // Grabo la pensión
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$pension.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idpension."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                    }
                    $clase->EjecutarSQL($vsql);
        
                    // ID salud
                    $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                    $idsalud = $clase->SeleccionarUno($vsql);
        
                    if($idsalud!="")
                        // Grabo la salud
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$salud.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idsalud."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                    }
        
                    $clase->EjecutarSQL($vsql);
                    // ----------------------------------------------------------------------------------------------------------- //                    

                    // ------------------------------------------------------------------------------------------------------------- //
                    // Obtengo el id del pendiente
                    $vsql3 = "SELECT MAX(pendienteid) AS pendienteid 
                                FROM licenciaspendiente 
                               WHERE terid = ".$terid."
                                     AND conceptoid = ".$conceptoid."";
                    $pendienteid = $clase->SeleccionarUno($vsql3);

                    $vsql = "DELETE FROM licenciaspendiente WHERE pendienteid = ".$pendienteid."";
                    $clase->EjecutarSQL($vsql);
                }
                $lb_grabosueldo=true;
            }
            else
            {
                $vsql = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoid." AND terid = ".$terid." AND conceptoid = ".$conceptoid."";
                $clase->EjecutarSQL($vsql);

                $lb_grabosueldo=true;
            }
        }

        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
        $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid = ".$terid."";
        $clase->EjecutarSQL($vsql);

        if($lb_grabosueldo==true)
            $clase->Aviso(1,"Se eliminó exitosamente el concepto $nomconcepto al empleado $nombreemp");

        header("Location: periodosnomina.php?opcion=venteliminaconceptoemp&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: licenciaslote
    // Creación: 14/11/2020		última modificación: 11/08/2021
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que pinta la ventana para los datos de las licencias por lotes
    // Última modificación: Inclusión de los datos de los empleados y los días (17/11/2020)
    //                      Se incorporó el campo de empleado activo en la nómina
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "licenciaslote")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $vsqlcombolic = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE eslicencia='CHECKED' ORDER BY conceptoid";
        $params = ' class="Texto11" ';
        $dias = 0;
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/egresos.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Novedades</b> del periodo '.$descripcion.' </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <form action="?opcion=guardarliclote" method="POST" name="x">
                  <input type="hidden" name="periodoid" value="'.$periodoid.'">
                  <td width="900"> <label class="Texto12"> <b>Licencia:</b></label>';

        $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombolic,"nombres","conceptoid","","N",$params,420);

        $cont.='  </td>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="20"> &nbsp; </td>
                   <td width="320"> Nombre </td>
                   <td width="110"> &nbsp; </td>			
                   <td width="75"> &nbsp; </td>
                   <td width="75"> &nbsp; </td>	
                   <td width="45"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="60"> &nbsp; </td>
                   <td width="110"> &nbsp; </td>                    
                   <td width="50"> &nbsp; </td>
                   <td width="20" align="right"> D&iacute;as </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:500px; overflow-Y:scroll">';

        // Consulta para procesar la licencia
        $vsql = "SELECT terid, codigo, dni, CONCAT(nombres,' ', apellidos) AS nombreemp 
                   FROM terceros 
                  WHERE esempleadoactivo='CHECKED'
               ORDER BY nombres";

        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
                
            $cont.=' <td width="20"> &nbsp; </td>
                     <td width="360"> '.$row['nombreemp'].' </td>
                     <td width="90"> &nbsp; </td>
                     <td width="80"> &nbsp; </td>
                     <td width="85"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="80"> &nbsp; </td>
                     <td width="20"> &nbsp;                       
                      <input type="number" name="LIN-'.$row['terid'].'" min="0" max="15" class="Texto12New" size="2" autocomplete="off" title="días de la licencia" value="0"> 
                     </td>
                     <td width="30"> &nbsp; </td>
                    </tr>';
        }

        $cont.='  </tbody>
                 </table>';

        $cont.='<table width="100%">
                 <center>
                 <input type="submit" value="aceptar" class="button blue">
                </table>
                </form>
                <br>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarliclote
    // Creación: 17/11/2020		última modificación: 11/08/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda la licencia en un proceso en el cual se ven 
    //              involucrados más de un empleado
    // Última modificación: Se incorporó el campo de empleado activo en la nómina
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "guardarliclote")
    {
        $periodoid  = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];

        // Inicializo las variables
        $dias = 0;
        $terid = 0;
        $valorconcepto = 0;

        // Valido que el periodo esté procesado en la tabla detalle de nómina
        $vsql = "SELECT count(*) 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $valorperiodo = $clase->SeleccionarUno($vsql);

        if($valorperiodo==0)
        {
            $clase->Aviso(3,"No se puede procesar este concepto porque el periodo $descripcion no ha sido procesado");
            header("Location: periodosnomina.php");
        }
        else
        {
            // Consulta para el procesamiento por lotes
            $vsql = "SELECT terid 
                       FROM terceros 
                      WHERE esempleadoactivo='CHECKED'
                   ORDER BY nombres";
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
    
            while($row = mysql_fetch_array($result))
            {
                $dias = $_POST['LIN-'.$row['terid']];
                if($_POST['LIN-'.$row['terid']] > 0)
                {
                    $terid = $row['terid'];

                    // Valido que a un empleado no se le procese una misma licencia más de una vez
                    $vsql = "SELECT count(*) 
                               FROM detallenomina 
                              WHERE terid = ".$terid." 
                                    AND conceptoid = ".$conceptoid." 
                                    AND pernominaid = ".$periodoid;
                    $valorconcepto = $clase->SeleccionarUno($vsql);

                    if($valorconcepto==0)
                    {
                        // -------------------------------------------------------------------------------------------------------------------------------- //
                        // Inicializo las variables
                        $basico = 0;
                        $formulabasico = "";
                        $diastrab = 0;
                        $detalleid = 0;
                        $sueldo = 0;
                        $numid = 0;
                        $licencianorem = 0;
                        $formulatransporte = "";
                        $subsidiotransporte = 0;
                        $lbpaso = false;
                        $formulasuspencion = "";
                        $suspension = 0;
                        $formulaincapacidad = "";
                        $incapacidad = 0;
                        $formulapaternidad = "";
                        $paternidad = 0;
            
                        // Obtengo el salario básico del empleado
                        $basico = $clase->BDLockup($terid,'terceros','terid','basico');
            
                        // Obtengo la formula del sueldo
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                        $formulabasico = $clase->SeleccionarUno($vsql);
            
                        // Obtengo los días trabajados en el periodo
                        $vsql = "SELECT valor
                                   FROM detallenomina 
                                  WHERE conceptoid = 1  
                                        AND pernominaid = ".$periodoid."
                                        AND terid = ".$terid."";
                        $diastrab = $clase->SeleccionarUno($vsql);
            
                        // Obtengo el ID del registro que se modificará
                        $vsql = "SELECT detalleid
                                   FROM detallenomina 
                                  WHERE conceptoid = 1  
                                        AND pernominaid = ".$periodoid."
                                        AND terid = ".$terid."";
                        $detalleid = $clase->SeleccionarUno($vsql);
            
                        // Recalculo el sueldo del periodo
                        $diastrab = $diastrab - $dias;
                        eval("\$sueldo = $formulabasico;");
                        $sueldo = round($sueldo,0);
            
                        // Almaceno en nuevo sueldo
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$sueldo.", 
                                        valor = ".$diastrab."
                                  WHERE detalleid = ".$detalleid."";
                        $clase->EjecutarSQL($vsql);
            
                        // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
                        if(mysql_affected_rows() < 1)
                            $clase->Aviso(3,"No se procesó correctamente la licencia, comuníquese con el administrador del sistema ERROR 1550");
                        else
                        {                    
                            // Calculo el nuevo ID
                            $vsql = "SELECT max(detalleid) FROM detallenomina";
                            $numid = $clase->SeleccionarUno($vsql);
                            $numid++;
                            
                            // Inserto el nuevo concepto licencia no remunerada en la tabla detallenomina como un descuento
                            if($conceptoid==6)
                            {
                                // Obtengo la formula de la licencia no remunerada
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                $formulalicnorem = $clase->SeleccionarUno($vsql);
            
                                // Calculo la licencia no remunerada
                                eval("\$licencianorem = $formulalicnorem;");
                                $licencianorem = round($licencianorem,0);
            
                                // Almaceno el nuevo concepto licencia no remunerada
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$licencianorem.",".$dias.",".$basico.")";
                                $clase->EjecutarSQL($vsql);
            
                                // Envío el mensaje correspondiente
                                if(mysql_affected_rows() < 1)
                                    $clase->Aviso(3,"No se procesó correctamente la licencia no remunerada, comuníquese con el administrador del sistema ERROR 1551");
                                else
                                {
                                    $clase->Aviso(1,"Licencia no remunerada procesada exitosamente");
                                    $lbpaso = true;
                                }
                            }
            
                            // Inserto el nuevo concepto suspensión en la tabla detallenomina como un descuento
                            if($conceptoid==9)
                            {
                                // Obtengo la formula de la suspensión
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                $formulasuspencion = $clase->SeleccionarUno($vsql);
            
                                // Calculo la suspensión
                                eval("\$suspension = $formulasuspencion;");
                                $suspension = round($suspension,0);
            
                                // Almaceno el nuevo concepto suspensión
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$suspension.",".$dias.",".$basico.")";
                                $clase->EjecutarSQL($vsql);
                                
                                // Envío el mensaje correspondiente
                                if(mysql_affected_rows() < 1)
                                    $clase->Aviso(3,"No se procesó correctamente la suspensión, comuníquese con el administrador del sistema ERROR 1552");
                                else
                                {
                                    $clase->Aviso(1,"Suspensión procesada exitosamente");
                                    $lbpaso = true;
                                }
                            }
            
                            // Inserto el nuevo concepto incapacidad en la tabla detallenomina como un devengado
                            if($conceptoid==10)
                            {
                                // Obtengo la formula de la suspensión
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                $formulaincapacidad = $clase->SeleccionarUno($vsql);
            
                                // Calculo la incpacidad
                                eval("\$incapacidad = $formulaincapacidad;");
                                $incapacidad = round($incapacidad,0);
            
                                // Almaceno el nuevo concepto suspensión
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$incapacidad.",0,".$dias.",".$basico.")";
                                $clase->EjecutarSQL($vsql);
                                
                                // Envío el mensaje correspondiente
                                if(mysql_affected_rows() < 1)
                                    $clase->Aviso(3,"No se procesó correctamente la incapacidad, comuníquese con el administrador del sistema ERROR 1553");
                                else
                                {
                                    $clase->Aviso(1,"Incapacidad procesada exitosamente");
                                    $lbpaso = true;
                                }
                            }
            
                            // Inserto el nuevo concepto licencia por maternidad en la tabla detallenomina como un devengado
                            if($conceptoid==11)
                            {
                                // Obtengo la formula de la licencia por maternidad
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                $formulamaternidad = $clase->SeleccionarUno($vsql);
            
                                // Calculo la incpacidad
                                eval("\$maternidad = $formulamaternidad;");
                                $maternidad = round($maternidad,0);
            
                                // Almaceno el nuevo concepto suspensión
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$maternidad.",0,".$dias.",".$basico.")";
                                $clase->EjecutarSQL($vsql);
                                
                                // Envío el mensaje correspondiente
                                if(mysql_affected_rows() < 1)
                                    $clase->Aviso(3,"No se procesó correctamente la licencia por maternidad, comuníquese con el administrador del sistema ERROR 1554");
                                else
                                {
                                    $clase->Aviso(1,"Licencia por maternidad procesada exitosamente");
                                    $lbpaso = true;
                                }                    
                            }
            
                            // Inserto el nuevo concepto licencia por paternidad en la tabla detallenomina como un devengado
                            if($conceptoid==12)
                            {
                                // Obtengo la formula de la licencia por paternidad
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                $formulapaternidad = $clase->SeleccionarUno($vsql);
            
                                // Calculo la incapacidad
                                eval("\$paternidad = $formulapaternidad;");
                                $paternidad = round($paternidad,0);
            
                                // Almaceno el nuevo concepto suspensión
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$paternidad.",0,".$dias.",".$basico.")";
                                $clase->EjecutarSQL($vsql);
                                
                                // Envío el mensaje correspondiente
                                if(mysql_affected_rows() < 1)
                                    $clase->Aviso(3,"No se procesó correctamente la licencia por paternidad, comuníquese con el administrador del sistema ERROR 1555");
                                else
                                {
                                    $clase->Aviso(1,"Licencia por paternidad procesada exitosamente");
                                    $lbpaso = true;
                                }
                            }
            
                            // Inserto el nuevo concepto de luto en la tabla detallenomina como un devengado
                            if($conceptoid==13)
                            {
                                // Obtengo la formula de la licencia por luto
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                $formulaluto = $clase->SeleccionarUno($vsql);
            
                                // Calculo la incpacidad
                                eval("\$luto = $formulaluto;");
                                $luto = round($luto,0);
            
                                // Almaceno el nuevo concepto suspensión
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$luto.",0,".$dias.",".$basico.")";
                                $clase->EjecutarSQL($vsql);
                                
                                // Envío el mensaje correspondiente
                                if(mysql_affected_rows() < 1)
                                    $clase->Aviso(3,"No se procesó correctamente la licencia por luto, comuníquese con el administrador del sistema ERROR 1556");
                                else
                                {
                                    $clase->Aviso(1,"Licencia por luto procesada exitosamente");
                                    $lbpaso = true;
                                }
                            }
                        }
            
                        // ---------------------------------------------------------------------------------------------------------- //
                        // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos
            
                        // Obtengo el salario mínimo legal vigente
                        $smlv = $_SESSION['N_SALMIN2020'];
            
                        // Variable para la validación del auxilio de transporte
                        $valsubtrasp = $smlv * 2;
            
                        if(($lbpaso == true)&&($basico <= $valsubtrasp))
                        {
                            // Obtengo el ID del registro que se modificará
                            $vsql = "SELECT detalleid
                                       FROM detallenomina 
                                      WHERE conceptoid = 3  
                                            AND pernominaid = ".$periodoid."
                                            AND terid = ".$terid."";
                            $detalleid = $clase->SeleccionarUno($vsql);
            
                            // Obtengo la formula del subsidio de transporte
                            $auxtrans = $_SESSION['N_AUXTRANS2020'];
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                            $formulatransporte = $clase->SeleccionarUno($vsql);
            
                            eval("\$subsidiotransporte = $formulatransporte;");
                            $subsidiotransporte = round($subsidiotransporte,0);
            
                            // Almaceno en nuevo subsidio de transporte
                            $vsql = "UPDATE detallenomina SET 
                                            devengados = ".$subsidiotransporte.", 
                                            valor = ".$diastrab."
                                      WHERE detalleid = ".$detalleid."";
                            $clase->EjecutarSQL($vsql);
            
                            // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
                            if(mysql_affected_rows() < 1)
                                $clase->Aviso(3,"No se procesó correctamente la licencia, comuníquese con el administrador del sistema ERROR 1557");
                        }                                    
                        // -------------------------------------------------------------------------------------------------------------------------------- //
                    }
                }
                $diaslicencia = 0;

                if($lbpaso == true)
                    $clase->Aviso(1,"Licencia procesada exitosamente");
                else
                    $clase->Aviso(3,"No se procesó la licencia");

                header("Location: periodosnomina.php?opcion=licenciaslote&periodoid=$periodoid");
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: licenciaslotefec
    // Creación: 18/11/2020		última modificación: 11/08/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para los datos de las licencias por lotes 
    //              incluyendo la fecha de inicio
    // Última modificación: Se cambió la consulta del combo de conceptos por el nuevo campo 
    //                      eslicencia (30/12/2020)
    //                      Se incluyó la columna código del empleado (24/02/2021)
    //                      Se incorporó el campo de empleado activo en la nómina
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "licenciaslotefec")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
        $vsqlcombolic = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE eslicencia='CHECKED' ORDER BY conceptoid";
        $params = ' class="Texto11" ';
        $dias = 0;
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/egresos.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Novedades del periodo </b>'.$descripcion.' </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <form action="?opcion=almliclote" method="POST" name="x">                  
                  <input type="hidden" name="periodoid" value="'.$periodoid.'">
                  <td width="900"> <label class="Texto12"> <b>Licencia:</b></label>';

        $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombolic,"nombres","conceptoid","","N",$params,420);

        $cont.='  </td>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="20"> &nbsp; </td>
                   <td width="70"> C&oacute;digo </td>
                   <td width="320"> Nombre </td>
                   <td width="110"> &nbsp; </td>			
                   <td width="75"> &nbsp; </td>
                   <td width="85"> &nbsp; </td>	
                   <td width="130"> &nbsp; </td>                    
                   <td width="100"> Fecha desde </td>                   
                   <td width="40"> &nbsp; </td>
                   <td width="20" align="right"> D&iacute;as </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:500px; overflow-Y:scroll">';

        // Consulta para procesar la licencia
        $vsql = "SELECT terid, codigo, dni, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp, codvende 
                   FROM terceros 
                  WHERE esempleadoactivo='CHECKED'
                        AND basico > 0
               ORDER BY nombres";

        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
                
            $cont.=' <td width="20"> &nbsp; </td>
                     <td width="80"> '.$row['codvende'].' </td>
                     <td width="360"> '.$row['nombreemp'].' </td>
                     <td width="80" style="display:none;"> '.$row['terid'].' </td>
                     <td width="85"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>                     
                     <td width="80"> 
                      <input type="date" name="fecdesde-'.$row['terid'].'" class="Texto12New" autocomplete="off" min="'.$fecdesde.'" max = "'.$fechasta.'">
                     </td>
                     <td width="50"> &nbsp; </td>
                     <td width="20"> 
                      <input type="number" name="dias-'.$row['terid'].'" min="0" max="180" class="Texto12New" size="2" autocomplete="off" title="días de la licencia" value="0"> 
                     </td>
                     <td width="30"> &nbsp; </td>
                    </tr>';
        }

        $cont.='  </tbody>
                 </table>';

        $cont.='<table width="100%">
                 <center>
                 <input type="submit" value="aceptar" class="button blue">
                </table>
                </form>
                <br>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: almliclote
    // Creación: 18/11/2020		última modificación: 11/08/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda la licencia en un proceso en el cual se ven 
    //              involucrados más de un empleado incluyendo la fecha de inicio
    // Última modificación: Se cambiaron los cálculos de la libranza y de devengados por 
    //                      novedades (30/12/2020)
    //                      Se inhabilitó la validación de la no repetición de conceptos en 
    //                      un periodo para un mismo empleado y se optimizó el cálculo de 
    //                      días pendientes restando uno a la diferencia en días (24/02/2021)
    //                      Se incorporó el campo de empleado activo en la nómina
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "almliclote")
    {
        $periodoid  = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];

        // Inicializo las variables
        $dias = 0;        
        $valorconcepto = 0;
        $valorperiodo = 0;
        $lbpaso = false;
        $difendias = 0;
        $diff = 0;
        $diaspendiente = 0;
        $mensajeerror = 0;
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Valido que el periodo esté procesado en la tabla detalle de nómina
        $vsql = "SELECT count(*) AS valorperiodo
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $valorperiodo = $clase->SeleccionarUno($vsql);

        if($valorperiodo==0)
            $clase->Aviso(3,"No se puede procesar este concepto porque el periodo $descripcion no ha sido procesado");
        else
        {
            // Consulta para el procesamiento por lotes
            $vsql = "SELECT terid 
                       FROM terceros 
                      WHERE esempleadoactivo='CHECKED' 
                            AND basico > 0
                   ORDER BY nombres";            
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
    
            while($row = mysql_fetch_array($result))
            {
                $dias = $_POST['dias-'.$row['terid']];
                $fecdesde = $_POST['fecdesde-'.$row['terid']];
                $terid = $row['terid'];

                // --------------------------------------------------------------------------------------------------------------------------------------------------- //
                if(($terid>0)&&($dias>0)&&($fecdesde!=""))
                {
                    $lbpendiente = false;
                    $periodoapagar = 0;
                    $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
    
                    // Calculo la diferencia en días
                    $fecha1= new DateTime($fecdesde);
                    $fecha2= new DateTime($fechasta);
                    $diff = $fecha1->diff($fecha2);
                    
                    $difendias = $diff->days;
                    $difendias += 1;
    
                    // ---------------------------------------------------------------------- //
                    $suma = "+".strval($dias-1)." day";
                    $date_fin = strtotime(".$suma.", strtotime($fecdesde));
                    $date_fin = date('Y-m-d', $date_fin);
                    // ---------------------------------------------------------------------- //
    
                    // if($dias > $difendias)
                    if($date_fin > $fechasta)
                    {
                        // Aquí guardo en la tabla correspondiente el exceso en días 
                        // para ser calculado en próximos periodos
    
                        $diaspendiente = $dias - $difendias;
    
                        // --------------------------------------------------------------------------------------------------------- //
                        $feciniper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                        $diadesde = substr($feciniper, -2);
    
                        if($diadesde=="16")
                        {
                            $fecfinper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                            $fechaEntera = strtotime($fecfinper);
                            $valdias = date("d", $fechaEntera);
    
                            if($valdias=="28")
                                $diaspendiente -= 2;
    
                            if($valdias=="29")
                                $diaspendiente -= 1;
    
                            if($valdias=="31")
                                $diaspendiente += 1;
                        }
                        // --------------------------------------------------------------------------------------------------------- //
    
                        $dias -= $diaspendiente;
    
                        $procesado = "";
                        $vsql = "SELECT periodoid 
                                   FROM periodosnomina 
                                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE periodoid > $periodoid)";
                        $periodoapagar = $clase->SeleccionarUno($vsql);
    
                        $vsql = "INSERT INTO licenciaspendiente (terid,conceptoid,dias,periodoapagar,procesado) VALUES (".$terid.",".$conceptoid.",".$diaspendiente.",".$periodoapagar.",'".$procesado."')";
                        $clase->EjecutarSQL($vsql);
                        $lbpendiente = true;
                    }
    
                    // Inicializo las variables
                    $basico = 0;
                    $formulabasico = "";
                    $diastrab = 0;
                    $detalleid = 0;
                    $sueldo = 0;
                    $numid = 0;
                    $licencianorem = 0;
                    $formulatransporte = "";
                    $subsidiotransporte = 0;
                    $lbpaso = false;
                    $formulasuspencion = "";
                    $suspension = 0;
                    $formulaincapacidad = "";
                    $incapacidad = 0;
                    $formulapaternidad = "";
                    $paternidad = 0;
                    $totnovedades = 0;
                    $sueldostr = "";
                    $centenas = "";
                    $centenasnum = 0;
                    $sueldodeducciones = 0;
                    $formulapension = "";
                    $pension = 0;
                    $detalleid = 0;
                    $formulasalud = "";
                    $salud = 0;
        
                    // Obtengo el salario básico del empleado
                    $basico = $clase->BDLockup($terid,'terceros','terid','basico');
        
                    // Obtengo la formula del sueldo
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                    $formulabasico = $clase->SeleccionarUno($vsql);
        
                    // Obtengo los días trabajados en el periodo
                    $vsql = "SELECT valor
                               FROM detallenomina 
                              WHERE conceptoid = 1  
                                    AND pernominaid = ".$periodoid."
                                    AND terid = ".$terid."";
                    $diastrab = $clase->SeleccionarUno($vsql);
        
                    // Obtengo el ID del registro que se modificará
                    $vsql = "SELECT detalleid
                               FROM detallenomina 
                              WHERE conceptoid = 1  
                                    AND pernominaid = ".$periodoid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);

                    $diastrab -= $dias;
    
                    eval("\$sueldo = $formulabasico;");
                    $sueldo = round($sueldo,0);
        
                    // Almaceno en nuevo sueldo
                    $vsql = "UPDATE detallenomina SET 
                                    devengados = ".$sueldo.", 
                                    valor = ".$diastrab."
                              WHERE detalleid = ".$detalleid."";
                    $clase->EjecutarSQL($vsql);
        
                    // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
                    if(mysql_affected_rows() < 1)
                        $clase->Aviso(3,"No se procesó correctamente la licencia, comuníquese con el administrador del sistema ERROR 1520");
                    else
                    {
                        // Calculo el nuevo ID
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numid = $clase->SeleccionarUno($vsql);
                        $numid++;                    
    
                        // Inserto la nueva licencia
    
                        // Obtengo la formula de la licencia
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                        $formulalice = $clase->SeleccionarUno($vsql);
    
                        // Calculo la licencia
                        if($conceptoid!=10)
                        {
                            eval("\$montolicencia = $formulalice;");
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            // Calculo la incapacidad                        
    
                            // Obtengo el salario mínimo legal vigente
                            $smlv = $_SESSION['N_SALMIN2020'];
    
                            // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                            if($basico<=$smlv)
                            {
                                // eval("\$montolicencia = $formulalice;");
                                $montolicencia = ($smlv*$dias)/30;
                                $montolicencia = round($montolicencia,0);
                            }
                            else
                            {
                                $porcbasico = ($basico*66.67)/100;
                                $porcbasico = round($porcbasico,0);
    
                                // Calculo la incapacidad si el básico sea mayor al mínimo 
                                if($porcbasico>$smlv)
                                {
                                    $montolicencia = ($porcbasico*$dias)/30;
                                    $montolicencia = round($montolicencia,0);
                                }
                                else
                                {
                                    $montolicencia = ($smlv*$dias)/30;
                                    $montolicencia = round($montolicencia,0);
                                }
                            }
                        }
    
                        // ------------------------------------------------------------------------------------------------------------------- //                    
                        // Obtengo el tipo de licencia
                        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                        // ------------------------------------------------------------------------------------------------------------------- //
                        // Determino si el registro existe para modificarlo o incluirlo
                        $vsql = "SELECT COUNT(*) AS repetida 
                                   FROM detallenomina
                                  WHERE pernominaid = ".$periodoid."
                                        AND conceptoid = ".$conceptoid."
                                        AND terid = ".$terid."";
                        $repetida = $clase->SeleccionarUno($vsql);
                        // ------------------------------------------------------------------------------------------------------------------- //

                        if($repetida==0)
                        {
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                            else
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
                        }
                        else 
                        {
                            // Determino el id del registro
                            $vsql = "SELECT detalleid AS detalleid 
                                       FROM detallenomina
                                      WHERE pernominaid = ".$periodoid."
                                            AND conceptoid = ".$conceptoid."
                                            AND terid = ".$terid."";
                            $detalleid = $clase->SeleccionarUno($vsql);
    
                            $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
                            $valor += $dias;
    
                            // Actualizo la licencia
                            if($tipodc=="C")
                            {
                                $devengados = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
                                $devengados += $montolicencia;
                                
                                $vsql = "UPDATE detallenomina SET 
                                                devengados = ".$devengados.", 
                                                valor = ".$valor."
                                          WHERE detalleid = ".$detalleid."";
                            }
                            else
                            {
                                $descuentos = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
                                $descuentos += $montolicencia;
    
                                $vsql = "UPDATE detallenomina SET 
                                                descuentos = ".$descuentos.", 
                                                valor = ".$valor."
                                          WHERE detalleid = ".$detalleid."";
                            }
                        }    
                        $clase->EjecutarSQL($vsql);
    
                        if(mysql_affected_rows() < 1)
                            $clase->Aviso(3,"No se procesó correctamente la licencia");
                        else
                        {
                            $clase->Aviso(1,"Licencia procesada exitosamente");
                            $lbpaso = true;
                        }
                    }
        
                    // ---------------------------------------------------------------------------------------------------------- //
                    // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos
        
                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];
        
                    // Variable para la validación del auxilio de transporte
                    $valsubtrasp = $smlv * 2;
        
                    if(($lbpaso == true)&&($basico <= $valsubtrasp))
                    {
                        // Obtengo el ID del registro que se modificará
                        $vsql = "SELECT detalleid
                                   FROM detallenomina 
                                  WHERE conceptoid = 3  
                                        AND pernominaid = ".$periodoid."
                                        AND terid = ".$terid."";
                        $detalleid = $clase->SeleccionarUno($vsql);
        
                        // Obtengo la formula del subsidio de transporte
                        $auxtrans = $_SESSION['N_AUXTRANS2020'];
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                        $formulatransporte = $clase->SeleccionarUno($vsql);
        
                        eval("\$subsidiotransporte = $formulatransporte;");
                        $subsidiotransporte = round($subsidiotransporte,0);
        
                        // Almaceno en nuevo subsidio de transporte
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$subsidiotransporte.", 
                                        valor = ".$diastrab."
                                  WHERE detalleid = ".$detalleid."";
                        $clase->EjecutarSQL($vsql);
        
                        // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
                        if(mysql_affected_rows() < 1)
                            $clase->Aviso(3,"No se procesó correctamente la licencia, comuníquese con el administrador del sistema ERROR 1521");
                    }
    
                    // Ahora recalculo la pensión y la salud
    
                    // Obtengo el total devengado por novedades
                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";                
                    $totnovedades = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);
            
                    // Actualizo el sueldo
                    $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;                    
    
                    // $sueldo += $totnovedades;
                    // $sueldodeducciones = $sueldo;
                    // $sueldodeducciones = $sueldo + $totnovedades;
    
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);
    
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
    
                    // Obtengo el ID del registro que voy a modificar
                    $vsql = "SELECT detalleid
                               FROM detallenomina 
                              WHERE conceptoid = 4  
                                    AND pernominaid = ".$periodoid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);
    
                    // Almaceno en nuevo monto de la pensión
                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$pension.", 
                                    saldo = ".$sueldodeducciones." 
                              WHERE detalleid = ".$detalleid."";
                    $clase->EjecutarSQL($vsql);
                    
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
    
                    // Recalculo el descuento por salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($pension,0);
    
                    // Obtengo el ID del registro que voy a modificar
                    $vsql = "SELECT detalleid
                               FROM detallenomina 
                              WHERE conceptoid = 5  
                                    AND pernominaid = ".$periodoid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);
    
                    // Almaceno en nuevo monto de la pensión
                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$salud.", 
                                    saldo = ".$sueldodeducciones." 
                              WHERE detalleid = ".$detalleid."";
                    $clase->EjecutarSQL($vsql);
    
                    // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                    $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid;
                    $clase->EjecutarSQL($vsql);
                }                
                // --------------------------------------------------------------------------------------------------------------------------------------------------- //
            }

            $clase->Aviso(1,"Licencia procesada exitosamente");
            header("Location: periodosnomina.php?opcion=licenciaslotefec&periodoid=$periodoid");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: compraslote
    // Creación: 17/11/2020		última modificación: 11/08/2021
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para los datos de las compras a crédito 
    //              por lotes
    // Última modificación: Inclusión de la columna para la cédula (23/04/2021)
    //                      Se incorporó el campo de empleado activo en la nómina
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "compraslote")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');        
        $params = ' class="Texto11" ';        
        $vsqlcombodes = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE montoocasional='CHECKED' ORDER BY conceptoid";
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/efectivo.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Descuentos ocasionales del periodo <font color="BLUE">'.$descripcion.'</font></b></td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <form action="?opcion=guardarcomplote" method="POST" name="x">                  
                  <input type="hidden" name="periodoid" value="'.$periodoid.'">
                  <td width="900"> <label class="Texto12"> <b>Descuento:</b></label>';

       $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombodes,"nombres","conceptoid","","N",$params,420);

       $cont.='   </td>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="20"> &nbsp; </td>
                   <td width="110"> Documento </td>			
                   <td width="320"> Nombre </td>
                   <td width="75"> &nbsp; </td>
                   <td width="75"> &nbsp; </td>	
                   <td width="45"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="60"> &nbsp; </td>
                   <td width="110"> &nbsp; </td>                    
                   <td width="50"> &nbsp; </td>
                   <td width="20" align="right"> Monto </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:500px; overflow-Y:scroll">';        

        // Consulta para procesar la licencia
        $vsql = "SELECT terid, codigo, dni, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                   FROM terceros 
                  WHERE esempleadoactivo='CHECKED'                       
                        AND basico > 0
               ORDER BY primernombre";

        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $i = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="20"> &nbsp; </td>
                     <td width="90"> '.$row['dni'].' </td>
                     <td width="360"> '.$row['nombreemp'].' </td>
                     <td width="80"> &nbsp; </td>
                     <td width="85"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="80"> &nbsp; </td>
                     <td width="20">              
                      <input type="number" name="monto-'.$row['terid'].'" min="0" class="Texto12New" size="6" autocomplete="off" title="Monto a descontar" value="0">                       
                     </td>
                     <td width="30"> &nbsp; </td>
                    </tr>';
        }

        $cont.='  </tbody>
                 </table>';

        $cont.='<table width="100%">
                 <center>
                 <input type="submit" value="aceptar" class="button blue">
                </table>
                </form>
                <br>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarcomplote
    // Creación: 17/11/2020		última modificación: 11/08/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda el proceso por lotes de las compras a crédito
    // Última modificación: Inclusión del proceso para actualizar el monto en caso de que 
    //                      ya exista (20/04/2021)
    //                      Se incorporó el campo de empleado activo en la nómina
    ////////////////////////////////////////////////////////////////////////////////////////            
    if($opcion == "guardarcomplote")
    {
        $periodoid = $_POST['periodoid'];
        $monto = $_POST['monto'];
        $conceptoid = $_POST['conceptoid'];

        // Inicializo las variables
        $valorconcepto = 0;
        $valorperiodo = 0;
        $lb_guardo = false;

        // Valido que el periodo esté procesado en la tabla detalle de nómina
        $vsqldatos = "SELECT count(*) 
                        FROM detallenomina
                       WHERE pernominaid = ".$periodoid;
        $valorperiodo = $clase->SeleccionarUno($vsqldatos);

        if($valorperiodo==0)
        {
            $clase->Aviso(3,"No se puede procesar este concepto porque el periodo $descripcion no ha sido procesado");
            header("Location: periodosnomina.php");
        }
        else
        {
            // Consulta para el procesamiento por lotes
            $vsql = "SELECT terid 
                       FROM terceros 
                      WHERE esempleadoactivo='CHECKED'
                            AND basico > 0
                   ORDER BY primernombre";

            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);    
            while($row = mysql_fetch_array($result))
            {
                $monto = $_POST['monto-'.$row['terid']];
                $terid = $row['terid'];

                if(($terid>0)&&($monto>0))
                {
                    // Valido que a un empleado no se le procese una mismo descuento más de una vez
                    $vsql2 = "SELECT count(*) AS valorconcepto 
                                FROM detallenomina 
                               WHERE terid = ".$terid." 
                                     AND conceptoid = ".$conceptoid." 
                                     AND pernominaid = ".$periodoid;
                    $valorconcepto = $clase->SeleccionarUno($vsql2);

                    if($valorconcepto==0)
                    {
                        // Obtengo el número de registros de la tabla detallenomina
                        $vsql3 = "SELECT MAX(detalleid) AS numeroid FROM detallenomina";
                        $numeroid = $clase->SeleccionarUno($vsql3);
                
                        // Incremento el ID
                        $numeroid++;
                
                        // Almaceno en la tabla el concepto de compras a crédito para el trabajador
                        $vsql4 = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                     VALUES (".$numeroid.",".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                        $clase->EjecutarSQL($vsql4);
                
                        // Variable que controla el mensaje correcto
                        if(mysql_affected_rows() >= 1)
                            $lb_guardo = true;

                        $vsql2 = "";
                        $vsql3 = "";
                        $vsql4 = "";
                    }
                    else
                    {
                        // Obtengo el id del concepto
                        $vsql5 = "SELECT detalleid FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
                        $detalleid = $clase->SeleccionarUno($vsql5);

                        // Obtengo el monto del descuento
                        $vsql6 = "SELECT descuentos FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
                        $descuentos = $clase->SeleccionarUno($vsql6);

                        // Calculo el nuevo monto
                        $descuentos += $monto;

                        // Almaceno el nuevo monto
                        $vsql7 = "UPDATE detallenomina SET 
                                         descuentos = ".$descuentos."
                                   WHERE detalleid = ".$detalleid;
                        $clase->EjecutarSQL($vsql7);

                        // Variable que controla el mensaje correcto
                        if(mysql_affected_rows() >= 1)
                            $lb_guardo = true;

                        $vsql5 = "";
                        $vsql6 = "";
                        $vsql7 = "";
                    }
                }
            }
        }

        if($lb_guardo == true)
            $clase->Aviso(1,"Compras a crédito procesadas exitosamente");
        else
            $clase->Aviso(3,"No se procesaron compras a crédito");

        // Redirecciono el formulario
        header("Location: periodosnomina.php?opcion=compraslote&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: encontrarconcepto
    // Creación: 14/11/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que busca un concepto de licencia para ser procesado por lote
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "encontrarconcepto")
    {
        // Nueva consulta con los nuevos campos para el nombre
        $vsql = "SELECT CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                        IFNULL(d.valor,0)
                   FROM terceros t 
                        INNER JOIN detallenomina d ON (t.terid = d.terid)
                  WHERE d.terid = ".$terid." 
                        AND d.conceptoid = ".$conceptoid." 
                        AND d.pernominaid = ".$periodoid;

        $_SESSION['SQL_CONCEPTOLIC'] = $vsql;
        header("Location: periodosnomina.php"); 
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardareditado y guardarnuevo
    // Creación: 15/09/2020		última modificación: 18/09/2020
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opciones para incluir y modificar periodos de nómina
    // Última modificación: Se validaron la entrada del código, la descripción y las fechas  
    //                      para que no sean repetidas
    ////////////////////////////////////////////////////////////////////////////////////////
    if(($opcion == "guardareditado")||($opcion == "guardarnuevo"))
    {
        $periodoid   = $_POST['periodoid'];
        $codigo      = strtoupper(trim($_POST['codigo']));
        $descripcion = strtoupper(trim($_POST['descripcion']));
        $fecdesde    = $_POST['fecdesde'];
        $fechasta    = $_POST['fechasta'];

        // Valido que todos los campos tengan datos
        if(($codigo == "")||($descripcion == "")||($fecdesde == "")||($fechasta == ""))
        {
            $clase->Aviso(3,"Debe llenar todos los datos");
            header("Location: periodosnomina.php");
        }
        else
        {
            // Valido que la fecha desde sea menor que la fecha hasta            
            require_once("classes/class_validaciones.php");         // Clase para la validación de las fechas
            $io_fecha=new class_validaciones();
            
            $lb_valido=false;
            $lb_valido=$io_fecha->uf_comparar_fecha($fecdesde,$fechasta);   // llamdo al procedimiento de validación de la fecha
            if(!$lb_valido)
            {
                $clase->Aviso(3,"La fecha hasta debe ser mayor a la fecha desde");
                header("Location: periodosnomina.php");                
            }
            else
            {
                // Opción para guardar un nuevo periodo
                if($opcion == "guardarnuevo")
                {
                    // Validación de que el código ya exista
                    $vsqlx = "SELECT COUNT(codigo) FROM periodosnomina WHERE codigo ='".$codigo."'";
                    $valor = $clase->SeleccionarUno($vsqlx);
    
                    if($valor>=1)
                    {
                        $clase->Aviso(3,"El código <b> $codigo </b> ya existe, verifíquelo por favor");
                        header("Location: periodosnomina.php");
                    }
                    else
                    {
                        // Validación de la existencia de la descripción del periodo
                        $vsqlx = "SELECT COUNT(descripcion) FROM periodosnomina WHERE descripcion ='".$descripcion."'";
                        $valordesc = $clase->SeleccionarUno($vsqlx);

                        if($valordesc>=1)
                        {
                            $clase->Aviso(3,"La descripción <b> $descripcion </b> ya existe, verifíquela por favor");
                            header("Location: periodosnomina.php");
                        }
                        else
                        {
                            // Validación para que la fecha no se repita
                            $vsqlx = "SELECT COUNT(*)
                                        FROM periodosnomina 
                                       WHERE fecdesde = '".$fecdesde."' OR 
                                             fecdesde = '".$fechasta."' OR
                                             fechasta = '".$fechasta."' OR
                                             fechasta = '".$fecdesde."'";
                            $valorfecha = $clase->SeleccionarUno($vsqlx);

                            if($valorfecha>=1)
                            {
                                $clase->Aviso(3,"Alguna de las fechas introducidas ya se encuentra asignadas a otro periodo, verifique por favor");
                                header("Location: periodosnomina.php");
                            }
                            else
                            {
                                // Almaceno el nuevo periodo
                                $vsql = "INSERT INTO periodosnomina (codigo,descripcion,fecdesde,fechasta,creador,momento) 
                                              VALUES ('".$codigo."','".$descripcion."','".$fecdesde."','".$fechasta."',
                                                      '".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
                                $cant = $clase->EjecutarSQL($vsql);
            
                                // valido que se almacenen los datos para emitir el mensaje correspondiente
                                if(mysql_affected_rows() < 1)
                                {
                                    $clase->Aviso(3,"No se incluyó el periodo");  	
                                }
                                else
                                {
                                    $clase->Aviso(1,"Periodo creado exitosamente");
                                }
                            }
                        }
                    }
                }

                // Opción para modificar un periodo
                if($opcion == "guardareditado")
                {
                    // ---------------------------------------------------------------------------------------------- //
                    // Proceso para validar si el código introducido ya existe
                    $lb_codigodiferente=false;
                    $lb_codigonuevoexiste=false;
                    $valorcod = 0;

                    $codnuevo = trim($codigo);
                    $vsqly = "SELECT codigo FROM periodosnomina WHERE periodoid=".$periodoid;
                    $codanterior = $clase->SeleccionarUno($vsqly);
                    
                    if($codnuevo!=$codanterior)
                        $lb_codigodiferente=true;

                    if($lb_codigodiferente)
                    {
                        // Validación de la existencia del código del periodo
                        $vsqlx = "SELECT COUNT(codigo) FROM periodosnomina WHERE codigo ='".$codnuevo."'";
                        $valorcod = $clase->SeleccionarUno($vsqlx);

                        if($valorcod>=1)
                            $lb_codigonuevoexiste=true;
                    }
                    // ---------------------------------------------------------------------------------------------- //
                    // Proceso para validar si la descripción introducida ya existe
                    $lb_descripciondiferente=false;
                    $lb_descripcionnuevoexiste=false;
                    $valordes = 0;

                    $desnueva = trim($descripcion);
                    $vsqly = "SELECT descripcion FROM periodosnomina WHERE periodoid=".$periodoid;
                    $desanterior = $clase->SeleccionarUno($vsqly);                    
                    
                    if($desnueva!=$desanterior)
                        $lb_descripciondiferente=true;

                    if($lb_descripciondiferente)
                    {
                        // Validación de la existencia del código del periodo
                        $vsqlx = "SELECT COUNT(descripcion) FROM periodosnomina WHERE descripcion ='".$desnueva."'";
                        $valordes = $clase->SeleccionarUno($vsqlx);

                        if($valordes>=1)
                            $lb_descripcionnuevoexiste=true;
                    }

                    // ---------------------------------------------------------------------------------------------- //
                    // Ejecuto las validaciones
                    if(($lb_codigodiferente)&&($lb_codigonuevoexiste))
                    {
                        $clase->Aviso(3,"El código <b> $codnuevo </b> ya existe, verifíquelo por favor");
                        header("Location: periodosnomina.php");
                    }
                    else
                    {
                        if(($lb_descripciondiferente)&&($lb_descripcionnuevoexiste))
                        {
                            $clase->Aviso(3,"La descripción <b> $descripcion </b> ya existe, verifíquela por favor");
                            header("Location: periodosnomina.php");
                        }
                        else
                        {
                            // Validación de la fecha
                            $vsqlx = "SELECT COUNT(*)
                                        FROM periodosnomina 
                                       WHERE (periodoid <> ".$periodoid.") AND
                                             (fecdesde = '".$fecdesde."' OR 
                                             fecdesde = '".$fechasta."' OR
                                             fechasta = '".$fechasta."' OR
                                             fechasta = '".$fecdesde."')";
                            $valorfecha = $clase->SeleccionarUno($vsqlx);

                            if($valorfecha>=1)
                            {
                                $clase->Aviso(3,"Alguna de las fechas introducidas ya se encuentra asignadas a otro periodo, verifique por favor");
                                header("Location: periodosnomina.php");
                            }
                            else
                            {
                                // Almaceno la modificación
                                $vsql = "UPDATE periodosnomina SET 
                                                codigo = '".$codigo."', 
                                                descripcion = '".$descripcion."',
                                                fecdesde = '".$fecdesde."', 
                                                fechasta = '".$fechasta."'
                                          WHERE periodoid = ".$periodoid."";
                                $clase->EjecutarSQL($vsql);
                
                                // valido que se almacenen los datos para emitir el mensaje correspondiente
                                if(mysql_affected_rows() < 1)
                                    $clase->Aviso(3,"No se modificó el periodo");
                                else
                                    $clase->Aviso(1,"Periodo modificado exitosamente");
                            }
                        }
                    }
                }
            }
            header("Location: periodosnomina.php");
        }	 
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nuevo
    // Creación: 15/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para incluir un nuevo periodo enviándolo 
    //              a la opción "guardarnuevo" para almacenarlo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevo")
    {
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/periodos.png" width="32" height="32" border="0"> </td>
                  <td width="1050"> <b>Nuevo Periodo de nómina</b> </td>
                  <td> <a href="periodosnomina.php"> <input type="button" value="<<" class="button"> </a> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>	 			   
                </table>';
        
        $cont.='<center>
                <form action="?opcion=guardarnuevo" method="POST">
                 <fieldset style="width: 530px; height: 350px;" class="grupos">
                 <legend class="titgrupos"> Datos </legend>
                 <table width="350">
                  <tr height="55">
                   <td> <label class="Texto12"> <b>C&oacute;digo</b></label><br> 
                    <input type="text" name="codigo" class="Texto15" size="10" maxlength="10" id="default" autocomplete="off"> 
                   </td>
                  </tr>
                  <tr height="55">
                   <td> <label class="Texto12"> <b>Descripci&oacute;n</b></label><br>
                    <input type="text" name="descripcion" class="Texto15"  maxlength="35" size="35" autocomplete="off"> 
                   </td>
                  </tr>
                  <tr height="55">
                   <td> <label class="Texto12"> <b>Fecha desde:</b></label><br>
                   <input type="date" name="fecdesde" class="Texto11"  tabindex="4" autocomplete="off">
                   </td>
                  </tr>                    
                  <tr height="55">
                   <td> <label class="Texto12"> <b>Fecha hasta:</b></label><br>
                   <input type="date" name="fechasta" class="Texto11"  tabindex="4" autocomplete="off">
                   </td>
                  </tr>
                  <tr height="55">
                   <td align="center"><br><br> 
                    <input type="submit" value="crear nuevo periodo" class="button blue"> 
                   </td>
                  </tr>
                 </table>
                 <br><br>
                 </fieldset></form>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacion
    // Creación: 15/09/2020		última modificación: 17/09/2020
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción para confirmar la eliminación de un periodo de nómina
    // Última modificación: Se incluyó la impresión de la descripción de periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacion")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br> <b>Eliminar un periodo de nómina </b> <br><br> </td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">¿Confirma que desea eliminar el periodo de nómina<br><b> '.$descripcion.'</b>? <br></td>       
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminar" method="POST">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                    <a href="periodosnomina.php" ><input type="button" value="CANCELAR" class="button blue"> </a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table><br>';		
        echo $cont; 
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminar
    // Creación: 15/09/2020		última modificación: 10/11/2020
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que elimina físicamente un periodo de nómina
    // Última modificación: Se incluyeron los mensajes correspondientes si se eliminó o no 
    //                      el periodo (17/09/2020)
    //                      Se incluyó la validación que no existan registros de este 
    //                      periodo en la tabla detallenomina lo cual indica que ha sido 
    //                      procesado
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminar")
    {
        $periodoid = $_POST['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        
        // Valido que el periodo no esté procesado en la tabla detalle de nómina
        $vsql = "SELECT count(*) 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $valor = $clase->SeleccionarUno($vsql);

        if($valor>=1)
        {
            $clase->Aviso(3,"El periodo <b> $descripcion </b> no puede ser eliminado porque ya ha sido procesado");
            header("Location: periodosnomina.php");
        }
        else
        {
            $vsql = "DELETE FROM periodosnomina WHERE periodoid = ".$periodoid;
            $clase->EjecutarSQL($vsql);
    
            // valido que se almacenen los datos para emitir el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó el periodo $descripcion");
            else
                $clase->Aviso(1,"Periodo $descripcion eliminado exitosamente");
    
            header("Location: periodosnomina.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacerrarperiodo
    // Creación: 10/11/2020		última modificación: 30/08/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que confirma el cierre definitivo de un periodo
    // Última modificación: Advertencia de empleados con diferencias saldo/base con sueldo 
    //                      básico
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacerrarperiodo")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Consulta para buscar diferencias
        $vsql3= "SELECT COUNT(d.detalleid) AS numdiferencias
                   FROM detallenomina d 
                        INNER JOIN tercerosactual t ON (d.terid = t.terid)
                  WHERE d.pernominaid = ".$periodoid." 
                        AND d.conceptoid = 1 
                        AND d.saldo <> t.basico";
        $numdiferencias = $clase->SeleccionarUno($vsql3);

        // Pinto la ventana
        $cont= '<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Cerrar un periodo de nómina</b><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">
                   <label class="Texto12"> ¿Confirma que desea cerrar el periodo de nómina<br><b> '.$descripcion.'</b>? </label> <br> </td>       
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=cerrarperiodo" method="POST">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="periodosnomina.php" ><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table>';

        // // Muestro la advertencia en caso de ser necesario
        // if($numdiferencias > 0)
        //     $cont.='<table width="500">
        //              <tr class="TablaDocsImPar">       
        //               <td width="50" align="left"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td>
        //               <td width="450" align="center"> 
        //                <label class="Texto12"> <b>Advertencia</b> <br> Existen '.$numdiferencias.' empleados con diferencias en el saldo/base <br> y sueldo b&aacute;sico, comun&iacute;quese con el departamento de sistemas. </label>
        //               </td>
        //              </tr>
        //             </table>';

        echo $cont; 
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cerrarperiodo
    // Creación: 10/11/2020		última modificación: 11/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que cierra un periodo de nómina
    // Última modificación: Se incluyó el proceso para pasar a histórico los datos del 
    //                      periodo que se está cerrando (12/11/2020)
    //                      Actualización de la tabla de licencias pendientes asignando el 
    //                      estatus procesado (20/11/2020)
    //                      Actualización de la tabla de libranzas pendientes asignando el
    //                      estatus procesado (24/11/2020)
    //                      Se suprimió el proceso en la tabla libranzaspendientes debido a 
    //                      que esta fue sustituida por la tabla libranzas y se realizó el 
    //                      nuevo proceso correspondiente (22/12/2020)
    //                      Inclusión de proceso para quitarle el estatus de empleado a 
    //                      aquellos que saldrán de vacaciones en el actual periodo
    //                      (08/03/2021)
    //                      Optimización del proceso de actualización en la tabla de 
    //                      libranzas: se procesarán solo las libranzas calculadas en el 
    //                      periodo actual (15/03/2021)
    //                      Carga de datos en la tabla de enlace entre detallenomina y 
    //                      periodosnomina (29/03/2021)
    //                      Se inhabilitó el proceso en el cual se cambia el estatus de no 
    //                      empleado a quienes se van de vacaciones (07/05/2021)
    //                      Se incorporó el campo de empleado activo en la nómina
    //                      (11/08/2021)
    //                      Validación de empleados en negativo (27/08/2021)
    //                      Depuración del histórico de nómina eliminando los registros sin 
    //                      relación con la tabla periodosnomina (25/04/2022)
    //                      Validación del proceso para calcular las cuotas pagadas en base 
    //                      a la configuración del sistema (02/09/2022)
    //                      Cambio de la tabla terceros por tercerosactual (29/09/2022)
    //                      Exclusión de las validaciones con el número de filas afectadas
    //                      (15/05/2022)
    //                      Reformulación de proceso para pasar a histórico excluyendo el 
    //                      id del detalle (05/07/2023)
    //                      Reajuste de los saldos/base en caso de existir diferencias
    //                      (14/10/2023)
    //                      No aplicar el descuento a la incapacidad superior a 180 días
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "cerrarperiodo")
    {
        $periodoid = $_POST['periodoid'];

        // Obtengo el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $valor = 0;
        $valor2 = 0;
        $cerradoper = "";
        $numdiferencias = 0;

        // Valido que el periodo no esté procesado en la tabla detalle de nómina
        $vsql = "SELECT count(*) 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $valor = $clase->SeleccionarUno($vsql);

        if($valor==0)
        {
            $clase->Aviso(3,"El periodo <b> $descripcion </b> no puede ser cerrado porque no ha sido procesado");
            header("Location: periodosnomina.php");
        }
        else
        {
            // Valido que la tabla tercerosactual tenga datos
            $vsql = "SELECT count(*) 
                       FROM tercerosactual
                      WHERE pernominaid = ".$periodoid;
            $valor2 = $clase->SeleccionarUno($vsql);

            if($valor2==0)
            {
                $clase->Aviso(3,"No existen empleados cargados en el periodo <b> $descripcion </b>");
                header("Location: periodosnomina.php");
            }
            else
            {
                // Determino si tiene empleados en negativo
                $ldtienenegativos = false;
    
                $vsql3 = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                                 SUM(d.devengados) - SUM(d.descuentos) AS total
                            FROM detallenomina d
                                 INNER JOIN tercerosactual t ON (d.terid = t.terid)
                           WHERE d.pernominaid = ".$periodoid." 
                                 AND d.conceptoid NOT IN (6, 9, 43, 58) 
                        GROUP BY t.dni, nombreemp";
    
                $conex3  = $clase->Conectar();
                $result3 = mysql_query($vsql3,$conex3);
    
                // Recorro la consulta para buscar negativos
                while($row3 = mysql_fetch_array($result3))
                {
                    if($row3['total'] < 0)
                        $ldtienenegativos = true;
                }
    
                if($ldtienenegativos)
                {
                    $clase->Aviso(3,"No se puede cerrar el periodo <b> $descripcion </b> porque tiene empleados en negativo");
                    header("Location: periodosnomina.php");
                }
                else
                {
                    // Guardo el cambio de estatus
                    $cerrado = 'CHECKED';
                    $vsql = "UPDATE periodosnomina SET 
                                    cerrado = '".$cerrado."'
                              WHERE periodoid = ".$periodoid."";
                    $clase->EjecutarSQL($vsql);

                    $vsql13 = "SELECT cerrado FROM periodosnomina WHERE periodoid = ".$periodoid;
                    $cerradoper = $clase->SeleccionarUno($vsql13);

                    if($cerradoper == "CHECKED")
                    {
                        // Validación de a cuerdo a la configuración del sistema
                        $cal_libranza = $_SESSION['G_CAL_LIBRANZA'];
    
                        if($cal_libranza=="CHECKED")
                        {
                            $vsql = "SELECT l.libranzaid, l.cuotaspagadas, d.terid
                                       FROM detallenomina d 
                                            INNER JOIN libranzas l ON (d.conceptoid = l.conceptoid AND d.terid = l.terid)
                                      WHERE d.pernominaid = ".$periodoid."
                                            AND l.cuotaspagadas < l.totalcuotas";
        
                            $conex  = $clase->Conectar();
                            $result = mysql_query($vsql,$conex);
                            $cant   = mysql_num_rows($result);
                            if($cant>0)
                            {
                                while($row = mysql_fetch_array($result))
                                {
                                    $libranzaid = $row['libranzaid'];
                                    $cuotaspagadas = $row['cuotaspagadas'];
                                    $cuotaspagadas++;
        
                                    $vsql2 = "UPDATE libranzas SET 
                                                     cuotaspagadas = ".$cuotaspagadas."
                                               WHERE libranzaid = ".$libranzaid."";
                                    $clase->EjecutarSQL($vsql2);
                                }
                            }
                        }
    
                        // Carga de datos en la tabla de enlace entre detallenomina y terceros
                        $vsql = "INSERT INTO periodoterceros (pernominaid, terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid, 
                                             cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, nombre, epsid,pensionesid) 
                                      SELECT d.pernominaid, t.terid, t.esempleado, t.esempleadoactivo, t.extralegal, t.areaid, t.seccionid,
                                             t.cargoid, t.bancoid, t.numcuenta, t.fecingreso, t.basico, t.codvende,
                                             t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombre,
                                             t.epsid, t.pensionesid 
                                        FROM detallenomina d 
                                             INNER JOIN tercerosactual t ON (d.terid = t.terid)
                                       WHERE d.pernominaid = ".$periodoid." 
                                             AND t.esempleadoactivo='CHECKED'
                                             AND t.basico > 0 
                                    GROUP BY t.terid, t.esempleado, t.esempleadoactivo, t.extralegal, t.areaid, t.seccionid,
                                             t.cargoid, t.bancoid, t.numcuenta, t.fecingreso, t.basico,
                                             t.codvende, t.dni, nombre, t.epsid, t.pensionesid";
                        $clase->EjecutarSQL($vsql);
    
                        // Paso a histórico el periodo ya cerrado                        
                        // $vsql = "INSERT INTO hisdetallenomina SELECT * FROM detallenomina WHERE pernominaid = ".$periodoid;

                        $vsql = "INSERT INTO hisdetallenomina (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo)
                                      SELECT d.terid, d.conceptoid, d.pernominaid, d.devengados, d.descuentos, d.valor, d.saldo 
                                        FROM detallenomina d 
                                       WHERE d.pernominaid = ".$periodoid;
                        $clase->EjecutarSQL($vsql);
    
                        if(mysql_affected_rows() >= 1)
                            $clase->Aviso(1,"Periodo <b>$descripcion</b> cerrado exitosamente");
                        else
                            $clase->Aviso(3,"No se cerró el periodo correctamente <b>$descripcion</b>, comuníquese con el administrador del sistema ERROR 1524");
    
                        // -------------------------------------------------------------------------------------------------------------------- //
                        // Depuro la tabla hisdetallenomina eliminando los registros que no tengan relación con periodoterceros
                        $numbasura = 0;
                        $vsql4 = "SELECT DISTINCT terid 
                                    FROM hisdetallenomina
                                   WHERE pernominaid = ".$periodoid." AND 
                                         terid NOT IN (SELECT terid
                                                         FROM periodoterceros
                                                        WHERE periodoterceros.pernominaid = ".$periodoid.")";
                        $conex  = $clase->Conectar();
                        $result4 = mysql_query($vsql4,$conex);
                        $numbasura = mysql_num_rows($result4);
    
                        if($numbasura>0)
                        {
                            while($row4 = mysql_fetch_array($result4))
                            {
                                $terid = $row4['terid'];
        
                                $vsql5 = "DELETE FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                                $clase->EjecutarSQL($vsql5);
        
                                $vsql6 = "DELETE FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                                $clase->EjecutarSQL($vsql6);
                            }
                        }
                        // -------------------------------------------------------------------------------------------------------------------- //
                        // Limpio la tabla tercerosactual
                        $vsql = "DELETE FROM tercerosactual";
                        $clase->EjecutarSQL($vsql);
                        // -------------------------------------------------------------------------------------------------------------------- //
                        // Corrijo los registros con diferencias en saldo/base en caso de ser necesario
                        $vsql33 = "SELECT COUNT(d.detalleid) AS numdiferencias
                                     FROM hisdetallenomina d 
                                          INNER JOIN periodoterceros t ON (d.terid = t.terid AND d.pernominaid = t.pernominaid) 
                                    WHERE d.pernominaid = ".$periodoid." 
                                          AND d.conceptoid = 1 
                                          AND d.saldo <> t.basico";
                        $numdiferencias = $clase->SeleccionarUno($vsql33);

                        if($numdiferencias > 0)
                        {
                            $vsql34 = "SELECT d.detalleid, t.basico, d.terid  
                                         FROM hisdetallenomina d 
                                              INNER JOIN periodoterceros t ON (d.terid = t.terid AND d.pernominaid = t.pernominaid) 
                                        WHERE d.pernominaid = ".$periodoid." 
                                              AND d.conceptoid = 1 
                                              AND d.saldo <> t.basico";

                            $conex = $clase->Conectar();
                            $result34 = @mysql_query($vsql34,$conex);
                            while($row34 = mysql_fetch_array($result34))
                            {
                                $detalleid = $row34['detalleid'];
                                $basico = $row34['basico'];
                                $terid = $row34['terid'];
                    
                                // Corrijo en el historial
                                $vsql44 = "UPDATE hisdetallenomina SET saldo = ".$basico." WHERE detalleid = ".$detalleid;
                                $clase->EjecutarSQL($vsql44);
                    
                                // Corrijo en la tabla detallenomina
                                $vsql24 = "SELECT detalleid AS detalleidant FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                                $detalleidant = $clase->SeleccionarUno($vsql24);
                    
                                $vsql35 = "UPDATE detallenomina SET saldo = ".$basico." WHERE detalleid = ".$detalleidant;
                                $clase->EjecutarSQL($vsql35);
                            }
                        }
                        // -------------------------------------------------------------------------------------------------------------------- //
                        header("Location: periodosnomina.php");
                    }
                }
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarlimpiarper
    // Creación: 10/11/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que confirma si se eliminarán los registros de la tabla 
    //              detallenomina de un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiarper")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><label class="Texto12"> <b>Limpiar periodo de nómina</b></label><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">
                   <label class="Texto12"> 
                   ¿Confirma que desea limpiar el periodo de nómina<br><b> '.$descripcion.'</b>? <br><br> Este proceso borrar&aacute; todo lo que se ha procesado <br>y no podr&aacute; ser revertido 
                   </label>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=limpiarperiodo" method="POST">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                    <a href="periodosnomina.php" ><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table>';		
        echo $cont; 
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: limpiarperiodo
    // Creación: 10/11/2020		última modificación: 31/01/2024
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que elimina los registros de la tabla detallenomina de un periodo 
    //              determinado
    // Última modificación: Eliminación de las licencias pendientes del periodo (20/11/2020)
    //                      Inclusión de la limpieza la tabla de enlace entre terceros y 
    //                      detallenomina (19/03/2021)
    //                      Se invirtió el orden de los procesos colocando el 
    //                      restablecimiento de las licencias pendientes en primer lugar y 
    //                      después las otras tareas (26/08/2021)
    //                      Asignación del estatus pendiente a todas las pre novedades del 
    //                      periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "limpiarperiodo")
    {
        $periodoid = $_POST['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Consulta para determinar las licencias pendientes procesadas en el periodo
        $vsql2 = "SELECT d.terid, c.conceptoid, d.valor  
                    FROM detallenomina d
                         INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                   WHERE d.pernominaid = ".$periodoid."
                         AND c.eslicencia ='CHECKED'";

        $conex  = $clase->Conectar();
        $result2 = mysql_query($vsql2,$conex);
        $cant   = mysql_num_rows($result2);
        if($cant>0)
        {
            while($row2 = mysql_fetch_array($result2))
            {
                $terid = $row2['terid'];
                $conceptoid = $row2['conceptoid'];
                $dias = $row2['valor'];
                
                // Obtengo el id del pendiente
                $vsql3 = "SELECT MAX(pendienteid) AS pendienteid 
                            FROM licenciaspendiente 
                           WHERE terid = ".$terid."
                                 AND conceptoid = ".$conceptoid."";
                $pendienteid = $clase->SeleccionarUno($vsql3);

                // Obtengo los días que tenía al liquidar la nómina
                $vsql3 = "SELECT dias AS diaslic 
                            FROM licenciaspendiente 
                           WHERE pendienteid = ".$pendienteid."";
                $diaslic = $clase->SeleccionarUno($vsql3);

                // Actualizo los días pendientes
                $dias += $diaslic;

                // Almaceno en nuevo sueldo
                $vsql4 = "UPDATE licenciaspendiente SET
                                 dias = ".$dias."
                           WHERE pendienteid = ".$pendienteid."";
                $clase->EjecutarSQL($vsql4);
            }
        }

        // Elimino los registros de la tabla detallenomina
        $vsql = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoid;
        $clase->EjecutarSQL($vsql);

        // Limpio la tabla de enlace entre terceros y detallenomina
        $vsql = "DELETE FROM periodoterceros WHERE pernominaid = ".$periodoid;
        $clase->EjecutarSQL($vsql);

        // Limpio la tabla tercerosactual
        $vsql = "DELETE FROM tercerosactual";
        $clase->EjecutarSQL($vsql);

        // Actualizo el campo calculado en la tabla periodosnomina
        $calculado = "";

        $vsql = "UPDATE periodosnomina SET 
                        calculado = '".$calculado."'
                  WHERE periodoid = ".$periodoid;
        $clase->EjecutarSQL($vsql);

        // Asigno estatus pendiente a todas las pre novedades
        $estatus = "PENDIENTE";

        $vsql = "UPDATE prenovedades SET estatus = '".$estatus."' WHERE pernominaid = ".$periodoid;
        $clase->EjecutarSQL($vsql);

        // Mensaje correspondiente
        $clase->Aviso(1,"Periodo $descripcion limpiado exitosamente");

        // Redireccionamiento del formulario
        header("Location: periodosnomina.php");
    }
  
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detalles
    // Creación: 15/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana de modificación de un periodo llevándolo a 
    //              la opción "guardareditado" donde almacena los datos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "detalles")
    {		  
        $periodoid = $_GET['periodoid'];
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/periodos.png" width="32" height="32" border="0"> </td>
                  <td width="990"> <b>Modificar periodo de nómina </b></td>
                  <td width="20"> &nbsp; </td>
                  <td width="24"> <a href="periodosnomina.php"><input type="button" value="<<" class="button"></a> </td>
                 </tr> 
                </table>
                <br>
                <center>';			   
        
        $vsql = "SELECT * FROM periodosnomina WHERE periodoid = '".$periodoid."'";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        if($row = mysql_fetch_array($result))
        {
            $cont.='<center>
                    <form action="?opcion=guardareditado" method="POST">
                     <input type="hidden" name="periodoid" value="'.$periodoid.'">
                     <fieldset style="width: 530px; height: 330px;" class="grupos">
                     <legend class="titgrupos"> Datos </legend>
                     <table width="350">
                      <tr height="45">
                       <td> <label class="Texto12"> <b>C&oacute;digo</b></label><br> 
                        <input type="text" name="codigo" class="Texto15" size="10" maxlength="10" id="default" value="'.$row['codigo'].'" autocomplete="off"> 
                       </td>
                      </tr>
                      <tr height="45">
                       <td> <label class="Texto12"> <b>Descripci&oacute;n</b></label><br>
                        <input type="text" name="descripcion" class="Texto15"  maxlength="35" size="35" value="'.$row['descripcion'].'" autocomplete="off"> 
                       </td>
                      </tr>
                      <tr height="45">
                       <td> <label class="Texto12"> <b>Fecha desde:</b></label><br> 
                        <input type="date" class="Texto11" name="fecdesde" size="10" maxlenght="10" value="'.substr($row['fecdesde'],0,10).'">
                       </td>
                      </tr>
                      <tr height="45">
                       <td> <label class="Texto12"> <b>Fecha hasta:</b></label><br> 
                        <input type="date" class="Texto11" name="fechasta" size="10" maxlenght="10" value="'.substr($row['fechasta'],0,10).'">
                       </td>
                      </tr>
                     </table>
                     <table width="350">			    
                      <tr height="45">
                       <td align="center">
                        <br><br> 
                        <input type="submit" value="modificar periodo" class="button blue"> 
                       </td>
                      </tr>						
                     </table>
                     <br>
                     </fieldset></form>';  
        }	
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: encontrar
    // Creación: 15/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que encuentra un periodo buscándolo por código o descripción
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio  = $_POST['criterio'];
        $arreglado = str_replace(" ","%",$criterio);
        $vsql = "SELECT periodoid, codigo, descripcion, fecdesde, fechasta
                   FROM periodosnomina
                  WHERE codigo LIKE '%".$criterio."%' OR 
                        descripcion LIKE '%".$criterio."%'                         
               ORDER BY codigo ASC LIMIT 0,".$_SESSION["NUMREGISTROSXCONSULTA"];
        $_SESSION['SQL_PERIODOS'] = $vsql;
        header("Location: periodosnomina.php");
    }


    if($opcion == "encontrarempleado")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT terid, dni, nombres, apellidos
                   FROM terceros
                  WHERE esempleadoactivo='CHECKED' AND 
                        (dni LIKE '%".$criterio."%' OR 
                         nombres LIKE '%".$criterio."%' OR 
                         apellidos LIKE '%".$criterio."%') ";
        $_SESSION['SQL_DEDUCCION'] = $vsql;
        header("Location: periodosnomina.php");
    }


    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 15/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que anula la búsqueda realizada por la opción “encontrar”
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $vsql = "SELECT periodoid, codigo, descripcion, fecdesde, fechasta 
                   FROM periodosnomina 
               ORDER BY codigo ASC limit 0,".$_SESSION["NUMREGISTROSXCONSULTA"];
        $_SESSION['SQL_PERIODOS'] = "";
        header("Location: periodosnomina.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: pre-desbloquear
    // Creación: 13/10/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana donde se digita el motivo del desbloqueo del 
    //              periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "pre-desbloquear")
    {
        $periodoid  = $_GET['periodoid'];
        $cont='<form action="?opcion=reabrirpeiodo" method="POST">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Digite el Motivo</b> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="motivo" cols="50" rows="5"></textarea>  </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <input type="submit" value="Guardar y Continuar" class="button">  </td> 
                 </tr>
                </table>
               </form>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: reabrirpeiodo
    // Creación: 13/10/2020		última modificación: 04/02/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para reabrir un periodo ya procesado
    // Última modificación: Al reabrir un periodo se eliminan sus datos de la tabla 
    //                      histórica (12/11/2020)
    //                      Se cambia el estatus de no procesada en la tabla de licencias 
    //                      pendientes (20/11/2020)
    //                      Se cambia el estatus de no procesada en la tabla de libranzas
    //                      pendientes (24/11/2020)
    //                      Se suprimió el proceso en la tabla libranzaspendientes debido a 
    //                      que esta fue sustituida por la tabla libranzas y se realizó el 
    //                      nuevo proceso correspondiente (22/12/2020)
    //                      Optimización del proceso de actualización en la tabla de 
    //                      libranzas: se procesarán solo las libranzas calculadas en el 
    //                      periodo actual (15/03/2021)
    //                      Inclusión de la rutina optimizada para actualizar las licencias 
    //                      pendientes y se desactivaron las rutinas de actualizar licencias 
    //                      pendientes y libranzas (01/09/2021)
    //                      Eliminación de los registros del registro actual en la tabla 
    //                      periodoterceros
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "reabrirpeiodo")
    {
        $periodoid  = $_POST['periodoid'];
        $motivo  = $_POST['motivo'];

        // Valido que el motivo sea lo suficientemente explícito
        if(strlen($motivo)<8)
            $clase->Aviso(3,"<b>ERROR :</b> El motivo es incorrecto, debe ser más explícito.");
        else
        {
            // Almaceno en la tabla de cambios
            $vsql = "INSERT INTO logcambios(tabla,campo,valor,motivo,creador,momento) 
                          VALUES ('periodosnomina','periodoid',".$periodoid.",'".$motivo."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
            $clase->EjecutarSQL($vsql);

            // Obtengo el nombre del periodo
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            // Guardo el cambio de estatus
            $cerrado = '';
            $vsql = "UPDATE periodosnomina SET 
                            cerrado = '".$cerrado."'
                      WHERE periodoid = ".$periodoid."";
            $clase->EjecutarSQL($vsql);

            // Envío el mensaje correspondiente 
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se desbloqueó el periodo <b> $descripcion </b>, comuníquese con el administrador del sistema ERROR 1525");
            else
            {
                // -------------------------------------------------------------------------------------------------------------------------------------------------- //
                // // Consulta para determinar las licencias pendientes procesadas en el periodo
                // $vsql2 = "SELECT d.terid, c.conceptoid, d.valor  
                //             FROM detallenomina d
                //                  INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                //            WHERE d.pernominaid = ".$periodoid."
                //                  AND c.eslicencia ='CHECKED'";

                // $conex  = $clase->Conectar();
                // $result2 = mysql_query($vsql2,$conex);
                // $cant   = mysql_num_rows($result2);
                // if($cant>0)
                // {
                //     while($row2 = mysql_fetch_array($result2))
                //     {
                //         $terid = $row2['terid'];
                //         $conceptoid = $row2['conceptoid'];
                //         $dias = $row2['valor'];
                        
                //         // Obtengo el id del pendiente
                //         $vsql3 = "SELECT MAX(pendienteid) AS pendienteid 
                //                     FROM licenciaspendiente 
                //                    WHERE terid = ".$terid."
                //                          AND conceptoid = ".$conceptoid."";
                //         $pendienteid = $clase->SeleccionarUno($vsql3);

                //         // Obtengo los días que tenía al liquidar la nómina
                //         $vsql3 = "SELECT dias AS diaslic 
                //                     FROM licenciaspendiente 
                //                    WHERE pendienteid = ".$pendienteid."";
                //         $diaslic = $clase->SeleccionarUno($vsql3);

                //         // Actualizo los días pendientes
                //         $dias += $diaslic;

                //         // Almaceno en nuevo sueldo
                //         $vsql4 = "UPDATE licenciaspendiente SET
                //                          dias = ".$dias."
                //                    WHERE pendienteid = ".$pendienteid."";
                //         $clase->EjecutarSQL($vsql4);
                //     }
                // }

                // // -------------------------------------------------------------------------------------------------------------------------------------------------- //
                // // Proceso para actualizar las libranzas
                // $vsql = "SELECT l.libranzaid
                //            FROM detallenomina d 
                //                 INNER JOIN libranzas l ON (d.conceptoid = l.conceptoid AND d.terid = l.terid)
                //           WHERE d.pernominaid = ".$periodoid."";

                // $conex  = $clase->Conectar();
                // $result = mysql_query($vsql,$conex);
                // $cant   = mysql_num_rows($result);
                // if($cant>0)
                // {
                //     while($row = mysql_fetch_array($result))
                //     {
                //         $libranzaid = $row['libranzaid'];
                //         $cuotaspagadas = $row['cuotaspagadas'];
                //         $cuotaspagadas--;

                //         $vsql2 = "UPDATE libranzas SET 
                //                          cuotaspagadas = ".$cuotaspagadas."
                //                    WHERE libranzaid = ".$libranzaid."";
                //         $clase->EjecutarSQL($vsql2);
                //     }
                // }

                // -------------------------------------------------------------------------------------------------------------------------------------------------- //
                // Elimino del histórico este periodo
                $vsql = "DELETE FROM hisdetallenomina WHERE pernominaid = ".$periodoid;
                $clase->EjecutarSQL($vsql);

                if(mysql_affected_rows() < 1)                
                    $clase->Aviso(3,"No se abrió el periodo <b>$descripcion</b>, comuníquese con el administrador del sistema ERROR 1526");
                else
                {
                    // Elimino del histórico este periodo
                    $vsql = "DELETE FROM periodoterceros WHERE pernominaid = ".$periodoid;
                    $clase->EjecutarSQL($vsql);

                    // emito el mensaje correspondiente
                    $clase->Aviso(1,"Periodo <b> $descripcion </b> abierto exitosamente");
                }
                // -------------------------------------------------------------------------------------------------------------------------------------------------- //
            }                
        }
        header("Location: periodosnomina.php");
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: valnegativo
    // Creación: 25/11/2020		última modificación: 11/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que emite una lista de empleados con saldo negativo de un periodo 
    //              de presentarse el caso
    // Última modificación: Inclusión del acceso directo al recibo de pago de los empleados 
    //                      con saldo negativo (28/08/2021)
    //                      Exclusión de la incapacidad superior a 180 días en la consulta 
    //                      de empleados
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "valnegativo")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $ldtienenegativos = false;

        // Nueva consulta con los nuevos campos para el nombre
        $vsql = "SELECT t.dni, t.terid, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                        SUM(d.devengados) - SUM(d.descuentos) AS total  
                   FROM detallenomina d
                        INNER JOIN terceros t ON (d.terid = t.terid)
                  WHERE d.pernominaid = ".$periodoid."
                        AND d.conceptoid NOT IN (6, 9, 43, 58) 
               GROUP BY t.dni, t.terid, nombreemp";        

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);   
        $i = 0;

        // Recorro la consulta para buscar negativos
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($row['total']<0)            
                $ldtienenegativos = true;            
        }

        // En caso de no tenerlos emito el mensaje correspondiente
        if(!$ldtienenegativos)
        {
            $clase->Aviso(2,"El periodo <b>$descripcion</b> no tiene empleados con saldo negativo");
            header("Location: periodosnomina.php");            
        }
        else
        {
            // Imprimo la lista de empleados con saldo negativo
            $_SESSION['SQL_NEGATIVOS'] = $vsql;

            // Pinto la ventana donde aparecerán los empleados con negativo
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/remisionesen.png" width="32" height="32" border="0"> </td>
                      <td width="535"> <b>Empleados con saldo negativo del periodo '.$descripcion.'</b> </td>
                      <td width="20"> &nbsp; </td>
                      <td width="24"> <a href="periodosnomina.php"><input type="button" value="<<" class="button"></a> </td>
                     </tr>	 			   
                    </table>';

            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                       <td width="20"> &nbsp; </td>
                       <td width="110"> C&eacute;dula </td>
                       <td width="320"> Nombre </td>			
                       <td width="75"> &nbsp; </td>
                       <td width="75"> &nbsp; </td>	
                       <td width="45"> &nbsp; </td>
                       <td width="50"> &nbsp; </td>
                       <td width="50"> &nbsp; </td>
                       <td width="60"> &nbsp; </td>                                              
                       <td width="150" align="right"> Saldo </td>
                       <td width="30"> &nbsp; </td>
                       <td width="40"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:690px; overflow-Y:scroll">';

            $tipoimpresion="negativo";

            $conex  = $clase->Conectar();
            $result = @mysql_query($vsql,$conex);
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                // Imprimo el empleado con saldo negativo
                if($row['total']<0)
                {                        
                    $i++;
                    if($i%2 == 0)
                        $cont.='<tr class="TablaDocsPar">';
                    else
                        $cont.='<tr class="TablaDocsImPar">';

                    $cont.=' <td width="20"> &nbsp; </td>
                             <td width="110"> '.$row['dni'].' </td>
                             <td width="320"> '.$row['nombreemp'].' </td>
                             <td width="80"> &nbsp; </td>
                             <td width="85"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="50"> &nbsp; </td>
                             <td width="40"> &nbsp; </td>
                             <td width="20"> <font color="RED">'.number_format($row['total']).'</font></td>
                             <td width="30"> &nbsp; </td>
                             <td width="40">  
                              <a href="recibodepago.php?opcion=negativo&periodoid='.$periodoid.'&dni='.$row['dni'].'" target="_blank">
                              <img src="images/basicas/pdf.png" title="Recibo" border="0"></a>                             
                             </td>
                            </tr>';
                }
            }
            
            $cont.=' </tbody>
                    </table>';

            // Totales
            $cont.='<table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="20"> &nbsp; </td>
                      <td width="1588" align="left"> <font color="WHITE"> <b> Total negativos: </b> '.number_format($i).' </font> </td>
                     </tr>
                    </table>';                    
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: arhivoexcel1
    // Creación: 05/03/2021		última modificación: 11/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para seleccionar el banco para generar la 
    //              macro de pago
    // Última modificación: Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Validación de empleados en negativo (27/08/2021)
    //                      Cambio de la tabla terceros a la tercerosactual (03/10/2022)
    //                      Exclusión de la incapacidad superior a 180 días en la consulta 
    //                      de empleados en negativo                          
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "arhivoexcel1")
    {
        $periodoid  = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Valido que existan datos en el periodo
        $vsql = "SELECT count(*) AS numregistros 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $numregistros = $clase->SeleccionarUno($vsql);

        if($numregistros==0)
        {
            $clase->Aviso(3,"Imposible generar el archivo de Excel para el periodo $descripcion porque no ha sido procesado");
            header("Location: periodosnomina.php");
        }
        else
        {
            // Determino si tiene empleados en negativo
            $ldtienenegativos = false;

            $vsql3 = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                             SUM(d.devengados) - SUM(d.descuentos) AS total
                        FROM detallenomina d
                             INNER JOIN tercerosactual t ON (d.terid = t.terid)
                       WHERE d.pernominaid = ".$periodoid." 
                             AND d.conceptoid NOT IN (6, 9, 43, 58) 
                    GROUP BY t.dni, nombreemp";

            $conex3  = $clase->Conectar();
            $result3 = mysql_query($vsql3,$conex3);

            // Recorro la consulta para buscar negativos
            while($row3 = mysql_fetch_array($result3))
            {
                if($row3['total']<0)
                    $ldtienenegativos = true;
            }

            if($ldtienenegativos)
            {
                $clase->Aviso(3,"Imposible generar el archivo de Excel para el periodo <b> $descripcion </b> porque tiene empleados en negativo");
                header("Location: periodosnomina.php");
            }
            else
            {

                // // Validación de los empleados sin banco
                // $vsql22 = "SELECT COUNT(*) AS numsinbanco 
                //              FROM tercerosactual 
                //             WHERE (bancoid IS NULL OR bancoid = 0)
                //                   AND (numcuenta = '' OR numcuenta IS NULL)";
                // $numsinbanco = $clase->SeleccionarUno($vsql22);

                // echo $numsinbanco; exit();

                // if($numsinbanco > 0)
                // {
                //     $clase->Aviso(3,"Existen empleados sin banco y cuenta asignada en el periodo <b> $descripcion </b>");
                //     header("Location: periodosnomina.php");
                // }
                // else
                // {

                    $numsincuenta = 0;

                    // Empleados sin cuenta bancaria
                    $vsql11 = "SELECT COUNT(*) numsincuenta FROM tercerosactual WHERE numcuenta = '' OR numcuenta IS NULL";
                    $numsincuenta = $clase->SeleccionarUno($vsql11);

                    // combo de bancos
                    $params = ' class="Texto11" ';
                    $vsqlbancos = "SELECT b.bancoid, b.descripcion 
                                     FROM bancos b 
                                    WHERE b.bancoid IN (SELECT DISTINCT bancoid 
                                                          FROM tercerosactual)
                                          AND b.bancoid NOT IN (7,8)";
                    $vsqlcombobancos = $clase->CrearComboBuscar("bancoid",$vsqlbancos,"descripcion","bancoid","","N",$params,400);                    

                    // pinto la ventana
                    $cont = $clase->Header("S","W");
                    $cont.='<table width="100%">
                             <tr class="CabezoteTabla"> 
                              <td width="10"> &nbsp; </td>
                              <td width="37"> <img src="images/iconos/exportarexcel2.png" width="32" height="32" border="0"> </td> 
                              <td width="840"> <b> Generar macro para bancos <br> <font color="blue"> '.$descripcion.' </font> </b> </td>
                              <td width="50" align="center"> <input type="button" class="button" value="<<" OnClick="document.location=\'periodosnomina.php\'"> </td>
                              <td width="10"> &nbsp; </td>
                             </tr>
                            </table>';

                    // combo y botón de aceptar
                    $cont.='<form action="?opcion=arhivoexcel3" method="POST" name="x" target="_blank">
                            <input type="hidden" name="periodoid" value="'.$periodoid.'">                            
                            <center>
                            <table width="100%">
                             <tr class="BarraDocumentos" style="height:50px;Important!">  
                              <td width="220"> &nbsp; </td>
                              <td width="20"> Banco: </td>
                              <td width="120"> '.$vsqlcombobancos.' </td> 
                              <td width="220"> &nbsp; </td>
                             </tr>
                            </table>
                            <table width="100%">
                             <tr class="BarraDocumentos" style="height:50px;Important!"> 
                              <td align="center">
                               <input type="submit" value="aceptar" class="button blue">
                               </form>
                              </td>
                             </tr>
                            </table>';

                    // Muestro el mensaje de empleados sin cuenta bancaria
                    if($numsincuenta > 0)
                        $cont.='<table width="100%"> <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr> </table>
                                <table width="100%">
                                 <tr class="BarraDocumentos" style="height:50px;Important!">  
                                  <td width="180"> &nbsp; </td>                                  
                                  <td width="180" align="center"> 
                                   <label class="Texto12"> <font color="red"> Existen empleados sin cuenta bancaria </font> </label> <br>
                                   <a href="?opcion=versincuenta&periodoid='.$periodoid.'" rel="facebox"> 
                                    <img src="images/iconos/auditoria.png" width="32" height="32" border="0" title="ver empleados sin cuenta"> 
                                   </a>
                                  </td> 
                                  <td width="220"> &nbsp; </td>
                                 </tr>
                                </table>';

                    // Pie de página
                    $cont.='<table width="100%"> 
                             <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                            </table>';
                // }
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanalimconp
    // Creación: 05/03/2021		última modificación: 12/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para eliminar un concepto a todos los empleados en el periodo
    // Última modificación: En el combo de concepto se quitaron las licencias y el sueldo
    //                      (07/07/2021)
    //                      Inclusión del subsidio de transporte y eliminación de la 
    //                      validación de periodo procesado (10/11/2022)
    //                      Validación del periodo procesado
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "ventanalimconp")
    {
        $periodoid  = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Valido que existan datos en el periodo
        $vsql = "SELECT count(*) AS numregistros 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $numregistros = $clase->SeleccionarUno($vsql);

        if($numregistros == 0)
        {
            $clase->Aviso(3,"El periodo $descripcion no ha sido procesado");
            header("Location: periodosnomina.php");
        }
        else
        {
            // Combo de los conceptos que se pueden eliminar
            // $vsqlcomboconcepto = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) 
            //                         FROM conceptosnomina 
            //                        WHERE (eslicencia <> 'CHECKED' AND esdeley <> 'CHECKED')
            //                              OR conceptoid = 3
            //                     ORDER BY conceptoid";

            $vsqlcomboconcepto = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) nomconcepto
                                    FROM conceptosnomina 
                                   WHERE (eslicencia <> 'CHECKED' AND esdeley <> 'CHECKED')
                                         OR conceptoid = 3
                                         OR recargo = 'CHECKED' 
                                ORDER BY conceptoid";            
    
            // Parámetro del combo de conceptos
            $params = ' class="Texto11" ';
    
            // Pinto la ventana para eliminar el concepto
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/anulardoc.png" width="32" height="32" border="0"> </td>
                      <td width="535"> <b>Limpiar concepto del periodo <font color="BLUE">'.$descripcion.'</font></b> </td>
                      <td width="20"> &nbsp; </td>
                      <td width="24"> <a href="periodosnomina.php"><input type="button" value="<<" class="button"></a> </td>
                     </tr>	 			   
                    </table>';
    
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <form action="?opcion=confirmarelimconcp" method="POST" name="x">                  
                      <input type="hidden" name="periodoid" value="'.$periodoid.'">
                      <td width="900"> <label class="Texto12">Concepto:</label>
                       '.$clase->CrearComboBuscar("conceptoid",$vsqlcomboconcepto,"nombres","conceptoid","","S",$params,420).'
                      </td>
                     </tr>
                    </table>';
    
            $cont.='<table width="100%">                     
                     <tr class="CabezoteTabla">
                      <td align="center">
                       <input type="submit" value="aceptar" class="button blue">
                       </form>
                      </td>                       
                     </tr> 
                    </table>';

            // Pie de página
            $cont.='<table width="100%"> 
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarelimconcp
    // Creación: 05/03/2021		última modificación: 10/11/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que confirma la eliminación de un concepto en un periodo
    // Última modificación: Validación del número de empleados para ejecutar el proceso
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "confirmarelimconcp")
    {
        $periodoid = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];
        $lonconcepto = strlen($conceptoid);

        // Validación del concepto
        if($lonconcepto==0)
        {
            $clase->Aviso(3,"Debe introducir el concepto");
            header("Location: periodosnomina.php?opcion=ventanalimconp&periodoid=$periodoid");
        }
        else
        {
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');

            // Número de registros que se van a eliminar
            $vsql = "SELECT count(*) AS nroconcepto 
                       FROM detallenomina 
                      WHERE conceptoid = ".$conceptoid."   
                            AND pernominaid = ".$periodoid."";
            $nroconcepto = $clase->SeleccionarUno($vsql);

            if($nroconcepto==0)
            {
                $clase->Aviso(3,"No existen empleados con $nomconcepto en el periodo $descripcion");
                header("Location: periodosnomina.php?opcion=ventanalimconp&periodoid=$periodoid");
            }
            else
            {
                $cont = $clase->Header("S","W");
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td align="center"><br><b>Eliminar un concepto en un periodo</b><br><br></td> 
                         </tr> 
                        </table>
                        <table width="100%">
                         <tr class="TablaDocsPar">
                          <td width="400" align="center">¿Confirma que desea limpiar el concepto<b> '.$nomconcepto.'</b><br></td>
                         </tr>
                         <tr class="TablaDocsPar">
                          <td width="400" align="center">del periodo <b> '.$descripcion.'</b>? <br></td>
                         </tr>
                         <tr class="TablaDocsPar">
                          <td width="400" align="center"><b>'.$nroconcepto.'</b> emplado(s) serán afectados, recuerde que esta acción no podrá ser revertida <br></td>
                         </tr>
                         <tr class="TablaDocsPar">       
                          <td width="400" align="center"><br><br>
                           <form action="?opcion=limpiarconcepto" method="POST">
                            <input type="hidden" name="periodoid" value="'.$periodoid.'">
                            <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                            <input type="submit" value="ACEPTAR" class="button red">
                             <a href="periodosnomina.php?opcion=ventanalimconp&periodoid='.$periodoid.'">
                              <input type="button" value="CANCELAR" class="button blue">
                             </a>
                           </form>
                           <br>
                          </td>
                         </tr>
                        </table><br>';
                echo $cont;
                exit();
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaextemporaneo
    // Creación: 26/03/2021		última modificación: 12/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se selecciona el empleado al cual se 
    //              le realizará el registro extemporáneo
    // Última modificación: Inclusión de la opción para eliminar un empleado de un periodo
    //                      (29/03/2021)
    //                      En el combo de empleados se validó que filtrara los terceros que 
    //                      son empleados y con el sueldo mayor a cero (07/07/2021)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Inclusión en el combo de acción de la opción de incluir en el 
    //                      periodo anterior si es administrador del sistema (01/11/2022)
    //                      Opción para incluir empleado en el periodo más anterior
    //                      (07/12/2023)
    //                      Validación del combo de acción y de botón aceptar de acuerdo a 
    //                      los periodos transmitidos
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaextemporaneo")
    {
        $periodoid  = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Valido que existan datos en el periodo
        $vsql = "SELECT count(*) AS numregistros 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $numregistros = $clase->SeleccionarUno($vsql);

        // Variable para el combo de empleados
        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                           FROM terceros 
                          WHERE esempleadoactivo='CHECKED'
                                AND basico > 0  
                       ORDER BY nombres";
        $params = ' class="Texto11" ';

        // opereaciones de periodo actual
        if($numregistros == 0)
            $opcionperact = '';
        else
            $opcionperact = ' <option value="incluir" SELECTED> incluir </option>
                              <option value="eliminar"> eliminar </option>';

        // Validación de los periodos en los cuales se incluirá o se eliminarán empleados
        $vsql2 = "SELECT periodoid
                    FROM periodosnomina 
                    WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoidactualw = $clase->SeleccionarUno($vsql2);

        $segundaq = ($periodoidactualw - 1);
        $primeraq = ($periodoidactualw - 2);

        $vsql35 = "SELECT COUNT(*) AS permodact FROM periodosnomina WHERE periodoid IN ($primeraq,$segundaq) AND transmitido <> 'CHECKED'";
        $permodact = $clase->SeleccionarUno($vsql35);
        
        if((($_SESSION['USERNAME'] == "LFLOREZ") || ($_SESSION['USERNAME'] == "SAIDRODRIGUEZ") || ($_SESSION["SUPERUSUARIO"] == "CHECKED") || ($_SESSION['USERNAME'] == 'DROPOS.NOMINA')) && ($permodact > 0))
        {
            if($permodact == 1)
                $opcionperant = '<option value="incluirant"> incluir periodo anterior </option>';

            if($permodact == 2)
                $opcionperant = '<option value="incluirant"> incluir periodo anterior </option>
                                 <option value="incluirmasant"> incluir periodo m&aacute;s anterior </option>';
        }
        else
            $opcionperant = '';

        // validación del combo de empleados
        if(($opcionperact == "") && ($opcionperant == ""))
            $comboempl = '&nbsp;';
        else
            $comboempl = $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,500);

        // Pinto la ventana para el registro extemporáneo
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/horas.png" width="32" height="32" border="0"> </td>
                  <td width="535"> <b> Procesar registro extempor&aacute;neo del periodo <font color="blue"> '.$descripcion.' </font> </b> </td>
                  <td width="20"> <a href="terceros.php" target="blank"> <input type="button" value="terceros" class="button red"> </a> </td>
                  <td width="24"> <a href="periodosnomina.php"> <input type="button" value="<<" class="button"> </a> </td>
                 </tr>
                </table>';

        $cont.='<form action="?opcion=regextemporaneo" method="POST" name="x">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="100%">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td width="53"> &nbsp; </td>
                  <td width="900"> <label class="Texto12"> Acci&oacute;n:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </label>
                   <select name="accion" id="accion" style="width:160px;height:25px;"> 
                    '.$opcionperact.'
                    '.$opcionperant.'
                   </select>
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td width="53"> &nbsp; </td>
                  <td width="900"> <label class="Texto12">Empleado: </label>
                   '.$comboempl.'
                  </td>
                 </tr>
                </table>';

        // validación del botón de aceptar
        if(($opcionperact == "") && ($opcionperant == ""))
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla">
                      <td align="center">
                       <input type="submit" value="aceptar" class="button gray" disabled>
                       </form>
                      </td>
                     </tr>
                    </table>';
        else
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla">
                      <td align="center">
                       <input type="submit" value="aceptar" class="button blue">
                       </form>
                      </td>
                     </tr>
                    </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: regextemporaneo
    // Creación: 26/03/2021		última modificación: 07/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que ingresa de forma extemporánea a un empleado en un periodo
    // Última modificación: Inclusión de la opción para eliminar un empleado de un periodo
    //                      (29/03/2021)
    //                      Se incorporó el campo de empleado activo en la nómina
    //                      (11/08/2021)
    //                      Inclusión de los cálculos de transporte y seguridad social con 
    //                      los nuevos campos de la tabla cargos (20/08/2021)
    //                      Validación de que el empleado esté activo en la nómina 
    //                      (21/08/2021)
    //                      Opción para calcular e incluir un nuevo empleado en el periodo 
    //                      anterior (01/11/2022)
    //                      Validación para las opciones incluir y eliminar que el periodo 
    //                      esté calculado (09/11/2022)
    //                      Validación que el periodo no esté reportado en nómina 
    //                      electrónica (18/08/2023)
    //                      Optimización de la ventana de eliminación extemporánea
    //                      (29/08/2023)
    //                      Incluir empleado en el periodo más anterior
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "regextemporaneo")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $accion = $_POST['accion'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        // ------------------------------------------------------------------------------------------------------------------------------------------------------ //
        // Valido que el periodo no haya sido reportado en nómina electrónica
        $lb_reportado = false;
        $consecutivone = "";

        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $diadesde = substr($fecdesde, -2);
        
        if($diadesde=="16")
            $consecutivone = $clase->BDLockup($periodoid,'periodosnomina','periodoid','consecutivone');        

        if(strlen($consecutivone)>0)
            $lb_reportado = true;        

        // Valido que el periodo a modificar no esté reportado
        if($lb_reportado)
        {
            // nombre del periodo
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            // emito el mensaje correspondiente
            $clase->Aviso(3,"El periodo $descripcion ya ha sido reportado en nómina electrónica");
            
            // Redirecciono a la ventana de ajustes
            header("Location: periodosnomina.php?opcion=ventanaextemporaneo&periodoid=$periodoid");
        }
        else
        {
            // ------------------------------------------------------------------------------------------------------------------------------------------------------ //
            // Incluir empleado
            if($accion=="incluir")
            {
                // Valido que el periodo esté calculado
                if($calculado!="CHECKED")
                {
                    $clase->Aviso(3,"No se pueden incluir empleados porque el periodo $descripcion no ha sido calculado");
                    header("Location: periodosnomina.php");                
                }
                else
                {
                    // Valido que el empleado no esté ya procesado en el periodo
                    $vsql = "SELECT count(*) AS numregistros 
                               FROM detallenomina
                              WHERE pernominaid = ".$periodoid."
                                    AND terid = ".$terid."";
                    $numregistros = $clase->SeleccionarUno($vsql);
            
                    // Nombre del empleado
                    $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                               FROM terceros 
                              WHERE terid = ".$terid."";
                    $nombreemp = $clase->SeleccionarUno($vsql);
        
                    if($numregistros>0)
                    {
                        $clase->Aviso(3,"$nombreemp ya ha sido procesado(a) en el periodo $descripcion");
                        header("Location: periodosnomina.php");
                    }
                    else 
                    {
                        // Valido que el empleado esté activo en nómina para poder procesarlo
                        $vsql = "SELECT esempleadoactivo 
                                   FROM terceros 
                                  WHERE terid = ".$terid;
                        $esempleadoactivo = $clase->SeleccionarUno($vsql);
        
                        if($esempleadoactivo!="CHECKED")
                        {
                            $clase->Aviso(3,"$nombreemp no está activo(a) en nómina");
                            header("Location: periodosnomina.php");
                        }
                        else
                        {
                            // Obtengo el salario mínimo legal vigente
                            $smlv = $_SESSION['N_SALMIN2020'];
                
                            // Obtengo el valor del subsidio de transporte
                            $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
                
                            // Obtengo la formula del sueldo
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                            $formulabasico = $clase->SeleccionarUno($vsql);
                            
                            // Obtengo la formula para el subsidio de transporte
                            $auxtrans = $_SESSION['N_AUXTRANS2020'];
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                            $formulatransporte = $clase->SeleccionarUno($vsql);
                
                            // Obtengo la formula para el descuento por pensión
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                            $formulapension = $clase->SeleccionarUno($vsql);
                
                            // Obtengo la formula para el descuento de salud
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                            $formulasalud = $clase->SeleccionarUno($vsql);
                
                            // Variable para la validación del auxilio de transporte
                            $valsubtrasp = $smlv * 2;
                            
                            // Proceso el sueldo
                            // Obtengo el sueldo básico
                            $basico = $clase->BDLockup($terid,'terceros','terid','basico');
        
                            // Nuevas configuraciones para las importaciones desde Excel
                            $cal_libranza = $_SESSION['G_CAL_LIBRANZA'];
                            $cal_permanente = $_SESSION['G_CAL_PERMANENTE'];
        
                            // ------------------------------------------------------- //
                            // Determino si el empleado tiene licencias pendientes 
                            // para ser calculadas en este periodo
                
                            $diastrab=15;       // días trabajados por defecto
                            $vsql = "SELECT count(*) AS valpendiente 
                                       FROM licenciaspendiente 
                                      WHERE terid = ".$terid."   
                                            AND periodoapagar = ".$periodoid."
                                            AND dias > 0";
                            $valpendiente = $clase->SeleccionarUno($vsql);
                
                            if($valpendiente>0)
                            {
                                $vsql = "SELECT dias AS diaspendiente 
                                           FROM licenciaspendiente 
                                          WHERE terid = ".$terid."   
                                                AND periodoapagar = ".$periodoid."
                                                AND dias > 0";                    
                                $diaspendiente = $clase->SeleccionarUno($vsql);
                
                                if($diaspendiente >= 15)
                                    $diastrab=0;
                                else
                                    $diastrab -= $diaspendiente;
                
                                $vsql = "SELECT conceptoid
                                           FROM licenciaspendiente 
                                          WHERE terid = ".$terid."   
                                                AND periodoapagar = ".$periodoid."
                                                AND dias > 0";
                                $conceptoid = $clase->SeleccionarUno($vsql);
                
                                // Obtengo del ID del pendiente
                                $vsql = "SELECT pendienteid 
                                           FROM licenciaspendiente 
                                          WHERE terid = ".$terid."   
                                                AND periodoapagar = ".$periodoid."
                                                AND dias > 0";
                                $pendienteid = $clase->SeleccionarUno($vsql);
                
                                $lbtienependiente = true;
                            }
                            else
                            {
                                $diastrab=15;
                                $lbtienependiente = false;
                            }
                
                            // ------------------------------------------------------- //
                            // Cálculo los días trabajados en caso de que el empleado 
                            // haya ingresado durante este periodo
                
                            // Obtengo las fechas de ingreso, comienzo y fin del periodo
                            // $fecingreso = $clase->BDLockup($terid,'terceros','terid','fecingreso');
                            $fecingreso = $row['fecingreso'];
                            $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                            $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

                            if(($fecingreso>$fecdesde)&&($fecingreso<$fechasta))
                            {
                                // Procedo a calcular los días que trabajó durante el periodo
                                $fecha1= new DateTime($fecingreso);
                                $fecha2= new DateTime($fechasta);
                                $diff = $fecha1->diff($fecha2);
                                
                                $difendias = $diff->days;
                                $diastrab = $difendias + 1;
            
                                $diadesde = substr($fecdesde, -2);
                                if($diadesde=="16")
                                {
                                    $fechaEntera = strtotime($fechasta);
                                    $valdias = date("d", $fechaEntera);
                                    if($valdias=="28")          $diastrab += 2;
                                    if($valdias=="29")          $diastrab += 1;
                                    if($valdias=="31")          $diastrab -= 1;
                                }
                            }                            
                            // -------------------------------------------------------------- //
                            $fecretiro = $clase->BDLockup($terid,'terceros','terid','fecharetiro');
                            if(($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta))
                            {
                                // Procedo a calcular los días que trabajó durante el periodo                
                                $fecha1= new DateTime($fecdesde);
                                $fecha2= new DateTime($fecretiro);
                                $diff = $fecha1->diff($fecha2);
                                
                                $difendias = $diff->days;
                                $diastrab = $difendias + 1;
                            }
                            // -------------------------------------------------------------- //
                            // valido si el empleado tiene fecha de ingreso y retiro dentro del periodo
                            if((($fecingreso>$fecdesde)&&($fecingreso<$fechasta)) && (($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta)))
                            {
                                // Procedo a calcular los días que trabajó durante el periodo
                                $fecha1= new DateTime($fecingreso);
                                $fecha2= new DateTime($fecretiro);
                                $diff = $fecha1->diff($fecha2);
                                
                                $difendias = $diff->days;
                                $diastrab = $difendias + 1;
                            }
                            // -------------------------------------------------------------- //
                
                            // Calculo el sueldo básico
                            eval("\$sueldo = $formulabasico;");
                            $sueldo = round($sueldo,0);
                
                            // Valido que el básico no sea más de dos salarios mínimos para el subsidio de transporte
                            // y que el empleado no sea un practicante SENA
                            $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');       // Obtengo el cargo del empleado
            
                            $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte
            
                            if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                            {
                                // Calculo el subsidio de transporte
                                eval("\$subsidiotransporte = $formulatransporte;");
                                $subsidiotransporte = round($subsidiotransporte,0);
                            }
                            else
                                $subsidiotransporte = 0;
                            
                            // ------------------------------------------------------------------------------ //
                            //  Cálculo del sueldo para las deducciones                    
                            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                       FROM detallenomina d
                                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                      WHERE d.terid = ".$terid."
                                            AND d.pernominaid = ".$periodoid." 
                                            AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                            $totnovedades = $clase->SeleccionarUno($vsql);

                            $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                                       FROM detallenomina d
                                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                      WHERE d.terid = ".$terid."
                                            AND d.pernominaid = ".$periodoid." 
                                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                            $totrecargos = $clase->SeleccionarUno($vsql);
                    
                            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
                
                            // Determino si el empleado es de condición extralegal
                            $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                            $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                            $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                            
                            if($epsid==NULL)
                                $epsid=0;
                            if($pensionesid==NULL)
                                $pensionesid=0;
                
                            // ----------------------------------------------------------------------------------------------------------- //
                            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');   // Obtengo el control del cálculo de pensión
                            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');   // Obtengo el control del cálculo de salud                    
            
                            if($extralegal=="CHECKED")
                            {
                                $pension = 0;
                                $salud = 0;
                            }
                            else
                            {
                                // Recalculo pensión y salud
                                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                    $pension = 0;
                                else
                                {
                                    // Obtengo la formula para el descuento por pensión
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                    $formulapension = $clase->SeleccionarUno($vsql);
                
                                    // Calculo la pensión
                                    eval("\$pension = $formulapension;");
                                    $pension = round($pension,0);
                                }
                
                                if(($epsid==37)||($aplicasalud!="CHECKED"))
                                    $salud = 0;
                                else
                                {
                                    // Obtengo la formula para el descuento de salud
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                    $formulasalud = $clase->SeleccionarUno($vsql);
                                    
                                    // Calculo la salud
                                    eval("\$salud = $formulasalud;");
                                    $salud = round($salud,0);
                                }
                            }
                
                            // ----------------------------------------------------------------------------------------------------------- //                
                            // Grabo en la tabla detalle de nómina
                            $vsql = "SELECT max(detalleid) FROM detallenomina";
                            $numreg = $clase->SeleccionarUno($vsql);
                
                            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico), 
                                                                      ($numreg+2,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte), 
                                                                      ($numreg+3,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones), 
                                                                      ($numreg+4,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones) ";
                            $clase->EjecutarSQL($vsql);
        
                            // --------------------------------------------------------------------------------------------------------------------------- //
                            // Incluyo en la tabla tercerosactual el nuevo registro
                            $vsql = "INSERT INTO tercerosactual (pernominaid, terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid, 
                                                                 cargoid, bancoid, numcuenta, fecingreso, fecharetiro, basico, codvende, dni, primernombre, 
                                                                 segundonombre, primerapellido, segundoapellido, idcajacomp, epsid, pensionesid) 
                                          SELECT ".$periodoid.", terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                                 cargoid, bancoid, numcuenta, fecingreso, fecharetiro, basico, codvende,
                                                 dni, primernombre, segundonombre, primerapellido, segundoapellido,
                                                 idcajacomp, epsid, pensionesid 
                                            FROM terceros
                                           WHERE terid = ".$terid;
                            $clase->EjecutarSQL($vsql);
                            // --------------------------------------------------------------------------------------------------------------------------- //
                            // Ahora debo actualizar las licencias pendientes
                            if($lbtienependiente == true)
                            {
                                $dias = $diaspendiente;
                                if($diaspendiente <= 15)
                                    $diaspendiente = 0;
                                else
                                    $diaspendiente -= 15;
                
                                // Actualizo los días pendientes
                                $vsql = "UPDATE licenciaspendiente SET                                         
                                                dias = ".$diaspendiente."
                                          WHERE pendienteid = ".$pendienteid."";
                                $clase->EjecutarSQL($vsql);
                
                                // Inserto la nueva licencia
                
                                // Obtengo la formula de la licencia
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                $formulalice = $clase->SeleccionarUno($vsql);
                
                                // Calculo la licencia
                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);
                
                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
                
                                // Calculo el nuevo ID
                                $vsql = "SELECT max(detalleid) FROM detallenomina";
                                $numid = $clase->SeleccionarUno($vsql);
                                $numid++;
                
                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
                
                                $clase->EjecutarSQL($vsql);
                            }
                            
                            // Nuevo proceso para las libranzas utilizando la nueva tabla “libranzas”
                            if($cal_libranza=="CHECKED")
                            {
                                $vsql2 = "SELECT conceptoid, monto, tipoquincena
                                            FROM libranzas 
                                           WHERE terid = ".$terid."
                                                 AND (cuotaspagadas < totalcuotas)";
                    
                                $conex  = $clase->Conectar();
                                $result2 = mysql_query($vsql2,$conex);
                                $cant = mysql_num_rows($result2);
                                if($cant>0)
                                {
                                    while($row2 = mysql_fetch_array($result2))
                                    {
                                        // Calculo el nuevo ID
                                        $vsql3 = "SELECT max(detalleid) FROM detallenomina";
                                        $numid = $clase->SeleccionarUno($vsql3);
                                        $numid++;
                    
                                        // Obtengo el monto a descontar por concepto de esta libranza
                                        $monto = $row2['monto'];
                                        $conceptoid = $row2['conceptoid'];
                                        $tipoquincena = $row2['tipoquincena'];
                    
                                        // Valido si la libranza se puede descontar en esta quincena
                                        if($tipoquincena=="ambas")
                                        {
                                            // Almaceno el nuevo concepto por libranza
                                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                            $clase->EjecutarSQL($vsql);
                                        }
                                        else
                                        {
                                            $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                                            $diadesde = substr($fecdesde, -2);
                    
                                            if(($tipoquincena=="primera")&&($diadesde=="01"))
                                            {
                                                // Almaceno el nuevo concepto por libranza
                                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                                $clase->EjecutarSQL($vsql);
                                            }
                    
                                            if(($tipoquincena=="segunda")&&($diadesde=="16"))
                                            {
                                                // Almaceno el nuevo concepto por libranza
                                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                                $clase->EjecutarSQL($vsql);
                                            }
                                        }
                                    }
                                }
                            }                    
                
                            // ---------------------------------------------------------------------------------------------------------- //
                            // Verifico si tiene conceptos permanentes
                            if($cal_permanente=="CHECKED")
                            {
                                $vsql4 = "SELECT conceptoid, monto, tipoquincena 
                                            FROM descuentospermanente 
                                           WHERE terid = ".$terid."";
                    
                                $conex  = $clase->Conectar();
                                $result4 = mysql_query($vsql4,$conex);
                                $cant   = mysql_num_rows($result4);
                                if($cant>0)
                                {
                                    while($row4 = mysql_fetch_array($result4))
                                    {
                                        // Calculo el nuevo ID
                                        $vsql5 = "SELECT max(detalleid) FROM detallenomina";
                                        $numid = $clase->SeleccionarUno($vsql5);
                                        $numid++;
                    
                                        // Obtengo el monto a descontar por concepto de este concepto
                                        $monto = $row4['monto'];
                                        $conceptoid = $row4['conceptoid'];
                                        $tipoquincena = $row4['tipoquincena'];
                    
                                        // Valido si el concepto se puede descontar en esta quincena
                                        if($tipoquincena=="ambas")
                                        {
                                            // Almaceno el nuevo concepto permanente
                                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                            $clase->EjecutarSQL($vsql);
                                        }
                                        else
                                        {
                                            $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                                            $diadesde = substr($fecdesde, -2);
                    
                                            if(($tipoquincena=="primera")&&($diadesde=="01"))
                                            {
                                                // Almaceno el nuevo concepto permanente
                                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                                $clase->EjecutarSQL($vsql);
                                            }
                    
                                            if(($tipoquincena=="segunda")&&($diadesde=="16"))
                                            {
                                                // Almaceno el nuevo concepto permanente
                                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                                $clase->EjecutarSQL($vsql);
                                            }
                                        }
                                    }
                                }
                            }
                
                            // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                            $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid = ".$terid."";
                            $clase->EjecutarSQL($vsql);
        
                            // ------------------------------------------------------------------------- //
                            $clase->Aviso(1,"Proceso culminado satisfactoriamente");
                            header("Location: periodosnomina.php");
                        }
                    }
                }
            }
    
            // ------------------------------------------------------------------------------------------------------------------------------------------------------ //
            // Eliminar empleado
            if($accion=="eliminar")
            {
                // Valido que el periodo esté calculado
                if($calculado!="CHECKED")
                {
                    $clase->Aviso(3,"No se pueden eliminar empleados porque el periodo $descripcion no ha sido calculado");
                    header("Location: periodosnomina.php");                
                }
                else
                {
                    // Variable para el nombre del empleado
                    $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
                    $nombreemp = $clase->SeleccionarUno($vsqldatos);
        
                    $cont = $clase->Header("S","W");
                    $cont.='<form action="periodosnomina.php?opcion=eliminarempper" method="POST" name="x" target="_blank">
                            <table width="100%">
                             <input type="hidden" name="terid" value="'.$terid.'">
                             <input type="hidden" name="periodoid" value="'.$periodoid.'">
                             <tr class="CabezoteTabla"> 
                              <td align="center"> <b> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                               Confirmaci&oacute;n de eliminaci&oacute;n de un empleado </b> </td> 
                              <td width="10%" align="center"> 
                               <a href="periodosnomina.php?opcion=ventanaextemporaneo&periodoid='.$periodoid.'""> 
                               <input type="button" class="button" value="<<"> </a>
                              </td>
                             </tr> 
                            </table>
                            <table width="100%">
                             <tr class="BarraDocumentos">
                              <td width="400" align="center"> ¿Confirma que desea eliminar al empleado(a) <br><b>'.$nombreemp.'</b> </td> 
                             </tr>
                             <tr class="BarraDocumentos">
                              <td width="400" align="center"> del periodo <b>'.$descripcion.'</b>? </td>
                             </tr>
                            </table>
                            <center>
                            <table width="100%">
                             <tr class="BarraDocumentos">
                              <td align="center">
                               <br>
                               <input type="submit" value="aceptar" class="button blue">
                               </form>
                              </td>
                             </tr>
                            </table>';

                    // Pie de página
                    $cont.='<table width="100%"> 
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                             <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                            </table>';
                    echo $cont.$clase->PiePagina();
                    exit();                
                }
            }
    
            // ------------------------------------------------------------------------------------------------------------------------------------------------------ //
            // Periodo anterior
            if(($accion=="incluirant")||($accion=="incluirmasant"))
            {
                // Periodo anterior
                $vsql = "SELECT periodoid 
                           FROM periodosnomina 
                          WHERE periodoid = (SELECT MAX(periodoid) FROM periodosnomina WHERE cerrado = 'CHECKED')";
                $periodoid = $clase->SeleccionarUno($vsql);

                if($accion=="incluirmasant")
                    $periodoid--;                
    
                // nombre del periodo
                $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
                // Valido que el empleado no esté ya procesado en el periodo
                $vsql = "SELECT count(*) AS numregistros 
                           FROM hisdetallenomina
                          WHERE pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $numregistros = $clase->SeleccionarUno($vsql);
    
                if($numregistros>0)
                {
                    // Nombre del empleado
                    $vsql = "SELECT nombre FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                    $nombreemp = $clase->SeleccionarUno($vsql);
    
                    $clase->Aviso(3,"$nombreemp ya ha sido procesado(a) en el periodo $descripcion");
                    header("Location: periodosnomina.php");
                }
                else
                {
                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];
        
                    // Obtengo el valor del subsidio de transporte
                    $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
        
                    // Obtengo la formula del sueldo
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                    $formulabasico = $clase->SeleccionarUno($vsql);
                    
                    // Obtengo la formula para el subsidio de transporte
                    $auxtrans = $_SESSION['N_AUXTRANS2020'];
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                    $formulatransporte = $clase->SeleccionarUno($vsql);
        
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);
        
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
        
                    // Variable para la validación del auxilio de transporte
                    $valsubtrasp = $smlv * 2;
    
                    // ------------------------------------- //
                    // Proceso el sueldo
    
                    // Salario básico
                    $vsqldatos = "SELECT basico FROM terceros WHERE terid = ".$terid;
                    $basico = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";                
    
                    // días trabajados
                    $diastrab=15;
    
                    // ------------------------------------------------------- //
                    // Cálculo los días trabajados en caso de que el empleado
                    // haya ingresado durante este periodo
    
                    // Salario básico
                    $vsqldatos = "SELECT fecingreso FROM terceros WHERE terid = ".$terid;
                    $fecingreso = $clase->SeleccionarUno($vsqldatos);
                    $vsqldatos = "";
    
                    // Obtengo las fechas de ingreso, comienzo y fin del periodo
                    $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                    $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
    
                    if(($fecingreso>$fecdesde)&&($fecingreso<$fechasta))
                    {
                        // Procedo a calcular los días que trabajó durante el periodo
        
                        $fecha1= new DateTime($fecingreso);
                        $fecha2= new DateTime($fechasta);
                        $diff = $fecha1->diff($fecha2);
                        
                        $difendias = $diff->days;
                        $diastrab = $difendias + 1;
                    }
                    // ------------------------------------------------------- //
                    
                    // Calculo el sueldo básico
                    eval("\$sueldo = $formulabasico;");
                    $sueldo = round($sueldo,0);
        
                    // Valido que el básico no sea más de dos salarios mínimos para el subsidio de transporte
                    // y que el empleado no sea un practicante SENA
                    $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
                    $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte
    
                    if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                    {
                        // Calculo el subsidio de transporte
                        eval("\$subsidiotransporte = $formulatransporte;");
                        $subsidiotransporte = round($subsidiotransporte,0);
                    }
                    else
                        $subsidiotransporte = 0;
                        
                    // en detallenomina
    
                    //  Cálculo del sueldo para las deducciones                    
                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                    $totnovedades = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);
            
                    $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
        
                    $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                    $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                    $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                    
                    if($epsid==NULL)                    $epsid=0;
                    if($pensionesid==NULL)              $pensionesid=0;
        
                    // ----------------------------------------------------------------------------------------------------------- //
                    $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                    $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
                    if($extralegal=="CHECKED")
                    {
                        $pension = 0;
                        $salud = 0;
                    }
                    else
                    {
                        // Recalculo pensión y salud
                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                            $pension = 0;
                        else
                        {
                            // Obtengo la formula para el descuento por pensión
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                            $formulapension = $clase->SeleccionarUno($vsql);
        
                            // Calculo la pensión
                            eval("\$pension = $formulapension;");
                            $pension = round($pension,0);
                        }
        
                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                            $salud = 0;
                        else
                        {
                            // Obtengo la formula para el descuento de salud
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                            $formulasalud = $clase->SeleccionarUno($vsql);
                            
                            // Calculo la salud
                            eval("\$salud = $formulasalud;");
                            $salud = round($salud,0);
                        }
                    }
        
                    // ----------------------------------------------------------------------------------------------------------- //                
                    // Grabo en la tabla detalle de nómina
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",".$basico."), 
                                                              ($numreg+2,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte), 
                                                              ($numreg+3,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones), 
                                                              ($numreg+4,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones) ";
    
                    // echo $vsql; exit();
    
                    $clase->EjecutarSQL($vsql);
    
                    // en hisdetallenomina
    
                    //  Cálculo del sueldo para las deducciones                    
                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM hisdetallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                    $totnovedades = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);
            
                    $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
        
                    $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                    $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                    $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                    
                    if($epsid==NULL)                        $epsid=0;
                    if($pensionesid==NULL)                  $pensionesid=0;
        
                    // ----------------------------------------------------------------------------------------------------------- //
                    $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                    $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
                    if($extralegal=="CHECKED")
                    {
                        $pension = 0;
                        $salud = 0;
                    }
                    else
                    {
                        // Recalculo pensión y salud
                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                            $pension = 0;
                        else
                        {
                            // Obtengo la formula para el descuento por pensión
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                            $formulapension = $clase->SeleccionarUno($vsql);
        
                            // Calculo la pensión
                            eval("\$pension = $formulapension;");
                            $pension = round($pension,0);
                        }
        
                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                            $salud = 0;
                        else
                        {
                            // Obtengo la formula para el descuento de salud
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                            $formulasalud = $clase->SeleccionarUno($vsql);
                            
                            // Calculo la salud
                            eval("\$salud = $formulasalud;");
                            $salud = round($salud,0);
                        }
                    }
        
                    // ----------------------------------------------------------------------------------------------------------- //                
                    // Grabo en la tabla detalle de nómina
                    $vsql = "SELECT max(detalleid) FROM hisdetallenomina";
                    $numregh = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO hisdetallenomina VALUES ($numregh+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",".$basico."), 
                                                                 ($numregh+2,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte), 
                                                                 ($numregh+3,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones), 
                                                                 ($numregh+4,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones) ";
                    $clase->EjecutarSQL($vsql);
    
                    if(mysql_affected_rows() >= 1)
                        $lb_grabo = true;
                    else
                        $lb_grabo = false;
    
                    // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                    $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid = ".$terid."";
                    $clase->EjecutarSQL($vsql);
    
                    // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                    $vsql = "DELETE FROM hisdetallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid = ".$terid."";
                    $clase->EjecutarSQL($vsql);
    
                    // Carga de datos en la tabla de enlace entre hisdetallenomina y terceros
                    $vsql = "INSERT INTO periodoterceros (pernominaid, terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid, 
                                         cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, nombre, epsid,pensionesid) 
                                  SELECT d.pernominaid, t.terid, t.esempleado, t.esempleadoactivo, t.extralegal, t.areaid, t.seccionid,
                                         t.cargoid, t.bancoid, t.numcuenta, t.fecingreso, t.basico, t.codvende,
                                         t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombre,
                                         t.epsid, t.pensionesid 
                                    FROM hisdetallenomina d 
                                         INNER JOIN terceros t ON (d.terid = t.terid)
                                   WHERE d.pernominaid = ".$periodoid." 
                                         AND t.terid = ".$terid."  
                                         AND t.esempleadoactivo = 'CHECKED'
                                         AND t.basico > 0 
                                GROUP BY t.terid, t.esempleado, t.esempleadoactivo, t.extralegal, t.areaid, t.seccionid,
                                         t.cargoid, t.bancoid, t.numcuenta, t.fecingreso, t.basico,
                                         t.codvende, t.dni, nombre, t.epsid, t.pensionesid";
                    $clase->EjecutarSQL($vsql);                
                    
                    // Emito el mensaje correspondiente
                    if($lb_grabo)
                        $clase->Aviso(1,"Proceso culminado satisfactoriamente");
                    else
                        $clase->Aviso(3,"No se guardó el empleado");
    
                    // Redirecciono a la ventana de ajustes
                    header("Location: periodosnomina.php?opcion=ventanaextemporaneo&periodoid=$periodoid");
                }
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: limpiarconcepto
    // Creación: 05/03/2021		última modificación: 10/11/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que elimina el concepto a todos los empleados en un periodo
    // Última modificación: Optimización de los mensajes y redireccionamiento del formulario
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "limpiarconcepto")
    {
        $periodoid = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');        

        $vsql = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoid." AND conceptoid = ".$conceptoid."";
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminaron registros de $nomconcepto para el periodo $descripcion");
        else
            $clase->Aviso(1,"$nomconcepto eliminado satisfactoriamente del periodo $descripcion");

        header("Location: periodosnomina.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarempper
    // Creación: 29/03/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un empleado de un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarempper")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];

        // Nombre del empleado
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                   FROM terceros 
                  WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql);

        $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminó el empleado $nombreemp");
        else
            $clase->Aviso(1,"$nombreemp eliminado satisfactoriamente");

        $vsql = "DELETE FROM tercerosactual WHERE terid = ".$terid." AND pernominaid = ".$periodoid."";
        $clase->EjecutarSQL($vsql);            

        header("Location: periodosnomina.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: calbasicos
    // Creación: 10/11/2020		última modificación: 28/01/2025
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que realiza los cálculos básicos del periodo correspondiente que 
    //              son los quince días laborados, el sueldo, subsidio de transporte, 
    //              pensión y salud; asumiendo que el empleado trabajó todos los días en 
    //              este lapso de tiempo.
    // Última modificación: Cálculo de las licencias pendientes (19/11/2020)
    //                      Cálculo de días trabajados en caso de que el empleado haya 
    //                      ingresado durante el periodo y omisión del cálculo de la pensión 
    //                      y la salud en caso de ser de condición extralegal (28/11/2020)
    //                      Limpio totalmente el periodo para procesarlo nuevamente
    //                      (03/12/2020)
    //                      Se sustituyó el proceso de calcular las libranzas a través de 
    //                      la nueva tabla libranzas que sustituye a la tabla 
    //                      libranzaspendientes (22/12/2020)
    //                      Sustitución del cálculo de licencias pendientes por otro sin 
    //                      usar el número del concepto (21/01/2021)
    //                      Validación para que no calcule la salud si el empleado es 
    //                      régimen especial y pensión si ya es pensionado (25/01/2021)
    //                      Se optimizó la validación del periodo anterior cerrado para que 
    //                      no afecte al primero (15/01/2021)
    //                      Corrección del cálculo de días trabajados cuando el empleado 
    //                      ingresa en el periodo calculado (16/02/2021)
    //                      Inclusión del proceso de conceptos permanentes (27/02/2021)
    //                      Validación para que no calcule el auxilio de transporte si el 
    //                      empleado es practicante (05/03/2021)
    //                      Se recalculó la salud y la pensión cuando se ingresa una 
    //                      licencia que viene arrastrada del periodo anterior (27/03/2021)
    //                      Previsión del cálculo de días trabajados cuando el mes es 
    //                      febrero y cuando la fecha de retiro está dentro del periodo 
    //                      (30/03/2021)
    //                      Se cambió la consulta para que no procese a los empleados que 
    //                      salieron por vacaciones (07/05/2021)
    //                      Se validó que si el periodo ya ha sido calculado no se eliminen 
    //                      los descuentos ocasionales (06/07/2021)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Inclusión de los cálculos de transporte y seguridad social con 
    //                      los nuevos campos de la tabla cargos (18/08/2021)
    //                      Se excluyeron del procesamiento los empleados con fecha de 
    //                      ingreso superior a la fecha límite del periodo actual  
    //                      (03/09/2021)
    //                      Validación del cálculo de las libranzas y descuentos permanentes 
    //                      de acuerdo a la configuración (04/08/2022)
    //                      Validación del cálculo de licencias pendientes de acuerdo a la 
    //                      configuración especificada (17/08/2022)
    //                      Exclusión de las validaciones con el número de filas afectadas
    //                      (15/05/2023)
    //                      Inclusión de la fecha de retiro para el cálculo de días 
    //                      trabajados
    //                      Inclusión de los registros con fecha de retiro dentro del 
    //                      periodo (02/04/2024)
    //                      Actualización del campo calculado en la tabla periodo antes de 
    //                      comenzar el ciclo
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "calbasicos")
    {
        $periodoid  = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $vsql = "SELECT COUNT(detalleid) AS detalleid FROM detallenomina";
        $detalleid = $clase->SeleccionarUno($vsql);

        if($detalleid==0)
            $cerrado = 'CHECKED';
        else
        {
            // Valido que el periodo anterior esté cerrado para poder procesar el actual
            $vsql = "SELECT cerrado 
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MAX(periodoid) FROM periodosnomina WHERE periodoid < $periodoid)";
            $cerrado = $clase->SeleccionarUno($vsql);
        }

        if($cerrado!='CHECKED')
        {
            $clase->Aviso(3,"El periodo <b>$descripcion</b> no puede ser procesado hasta que el anterior esté cerrado");
            header("Location: periodosnomina.php");
        }
        else
        {
            // // Determino si el periodo tiene pre cargados descuentos ocasionales
            // $listaocasionales = "";

            // $vsql = "SELECT d.detalleid
            //            FROM detallenomina d 
            //                 INNER JOIN conceptosnomina c ON (c.conceptoid = d.conceptoid)
            //           WHERE d.pernominaid = ".$periodoid." 
            //                 AND c.montoocasional ='CHECKED'";
            // $conex  = $clase->Conectar();
            // $result = mysql_query($vsql,$conex);
            // $cantocasionales = mysql_num_rows($result);

            // if($cantocasionales>0)
            // {
            //     while($row = mysql_fetch_array($result))  
            //     {
            //         $listaocasionales.= $row['detalleid'].",";
            //     }
            //     $listaocasionales = substr($listaocasionales, 0, -1);

            //     $vsql = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoid." AND detalleid NOT IN ($listaocasionales)";
            //     $clase->EjecutarSQL($vsql);
            // }
            // else
            // {
            //     $vsql = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoid;
            //     $clase->EjecutarSQL($vsql);
            // }
            // --------------------------------------------------------------------------------------------- //

            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];

            // Obtengo el valor del subsidio de transporte
            $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

            // Obtengo la formula del sueldo
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
            $formulabasico = $clase->SeleccionarUno($vsql);
            
            // Obtengo la formula para el subsidio de transporte
            $auxtrans = $_SESSION['N_AUXTRANS2020'];
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
            $formulatransporte = $clase->SeleccionarUno($vsql);

            // Obtengo la formula para el descuento por pensión
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
            $formulapension = $clase->SeleccionarUno($vsql);

            // Obtengo la formula para el descuento de salud
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
            $formulasalud = $clase->SeleccionarUno($vsql);

            // Determino los empleados a los cuales se les procesarán los cálculos básicos
            $fecdesdeper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
            $fechastaper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

            // --------------------------------------------------------------------------------------------------- //
            // $vsql = "SELECT terid, basico 
            //            FROM terceros 		     
            //           WHERE esempleadoactivo='CHECKED'
            //                 AND basico > 0
            //                 AND terid NOT IN (SELECT terid
            //                                     FROM histcontrato
            //                                    WHERE fecretiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."')
            //                 AND fecingreso <= '".$fechastaper."'
            //        ORDER BY terid";

            // $vsql = "SELECT terid, basico 
            //            FROM terceros 		     
            //           WHERE esempleadoactivo='CHECKED'
            //                 AND basico > 0
            //                 AND terid NOT IN (SELECT terid
            //                                     FROM histcontrato
            //                                    WHERE fecretiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."')
            //                 AND fecingreso <= '".$fechastaper."'
            //          UNION
            //          SELECT terid, basico 
            //            FROM terceros 
            //           WHERE esempleadoactivo = '' 
            //                 AND basico > 0 
            //                 AND terid IN (SELECT terid
            //                                 FROM histcontrato 
            //                                WHERE fecingreso BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
            //                                      AND fecretiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."')
            //        ORDER BY terid";

            $vsql = "SELECT terid, basico, fecingreso, fecharetiro, cargoid, extralegal, epsid, pensionesid   
                       FROM terceros 		     
                      WHERE esempleadoactivo = 'CHECKED'
                            AND basico > 0
                            AND fecingreso <= '".$fechastaper."'
                     UNION
                     SELECT terid, basico, fecingreso, fecharetiro, cargoid, extralegal, epsid, pensionesid   
                       FROM terceros 		     
                      WHERE fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                            AND basico > 0
                            AND extralegal = 'CHECKED'
                   ORDER BY 1";           
                   
            // --------------------------------------------------------------------------------------------------- //
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant   = mysql_num_rows($result);

            // actualización del campo calculado
            if($cant > 0)
                $clase->EjecutarSQL("UPDATE periodosnomina SET calculado = 'CHECKED' WHERE periodoid = ".$periodoid."");            
            
            $valor = 0;
            $valsubtrasp = $smlv * 2;       // Variable para la validación del auxilio de transporte

            // Inicialización de variables
            $lbgrabo=false;
            $diasrestantes = 0;
            $periodoapagar = 0;
            $numid = 0;
            $vallibrpen = 0;
            $numregitrosper = 0;
            $cal_libranza = $_SESSION['G_CAL_LIBRANZA'];
            $cal_permanente = $_SESSION['G_CAL_PERMANENTE'];

            while($row = mysql_fetch_array($result))
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                // Proceso el sueldo
                $terid = $row['terid'];
                $basico = $row['basico'];

                // ------------------------------------------------------- //
                // determino si el empleado tiene licencias importadas 
                // previamente desde una hoja de Excel

                $diastrab = 15;       // días trabajados por defecto

                $vsql = "SELECT IFNULL(d.valor,0) AS diaslicenciaimportada 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.pernominaid = ".$periodoid." 
                                AND c.eslicencia = 'CHECKED' 
                                AND d.terid = ".$terid;
                $diaslicenciaimportada = $clase->SeleccionarUno($vsql);

                $diastrab -= $diaslicenciaimportada;

                // ------------------------------------------------------- //
                // Determino si el empleado tiene licencias pendientes 
                // para ser calculadas en este periodo

                $vsql = "SELECT count(*) AS valpendiente 
                           FROM licenciaspendiente 
                          WHERE terid = ".$terid."
                                AND dias > 0";
                $valpendiente = $clase->SeleccionarUno($vsql);

                if($valpendiente>0)
                {
                    $vsql = "SELECT dias AS diaspendiente 
                               FROM licenciaspendiente 
                              WHERE terid = ".$terid."
                                    AND dias > 0";                    
                    $diaspendiente = $clase->SeleccionarUno($vsql);

                    if($diaspendiente >= 15)
                        $diastrab=0;
                    else
                        $diastrab -= $diaspendiente;

                    $vsql = "SELECT pendienteid 
                               FROM licenciaspendiente 
                              WHERE terid = ".$terid."
                                    AND dias > 0";
                    $pendienteid = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT conceptoid
                               FROM licenciaspendiente 
                              WHERE pendienteid = ".$pendienteid;
                    $conceptoid = $clase->SeleccionarUno($vsql);

                    $lbtienependiente = true;
                }
                else
                {
                    // $diastrab=15;
                    $lbtienependiente = false;
                }

                // ------------------------------------------------------- //
                // Cálculo los días trabajados en caso de que el empleado 
                // haya ingresado durante este periodo

                // Obtengo las fechas de ingreso, comienzo y fin del periodo                
                // $fecingreso = $clase->BDLockup($terid,'terceros','terid','fecingreso');
                $fecingreso = $row['fecingreso'];

                $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

                if(($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta))
                {
                    // Procedo a calcular los días que trabajó durante el periodo
                    $fecha1= new DateTime($fecingreso);
                    $fecha2= new DateTime($fechasta);
                    $diff = $fecha1->diff($fecha2);
                    
                    $difendias = $diff->days;
                    $diastrab = $difendias + 1;

                    $diadesde = substr($fecdesde, -2);
                    if($diadesde=="16")
                    {
                        $fechaEntera = strtotime($fechasta);
                        $valdias = date("d", $fechaEntera);
                        if($valdias=="28")          $diastrab += 2;
                        if($valdias=="29")          $diastrab += 1;
                        if($valdias=="31")          $diastrab -= 1;
                    }
                }
                // ------------------------------------------------------------------------------------ //
                // Valido si la fecha de retiro está dentro del rango de periodo
                // $vsql = "SELECT MAX(fecretiro) AS fecretiro FROM histcontrato WHERE terid = ".$terid;
                // $fecretiro = $clase->SeleccionarUno($vsql);

                $fecretiro = $row['fecharetiro'];

                if(($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta))
                {
                    // Procedo a calcular los días que trabajó durante el periodo
                    $fecha1= new DateTime($fecdesde);
                    $fecha2= new DateTime($fecretiro);
                    $diff = $fecha1->diff($fecha2);
                    
                    $difendias = $diff->days;
                    $diastrab = $difendias + 1;
                }
                // ------------------------------------------------------------------------------------ //
                // valido si el empleado tiene fecha de ingreso y retiro dentro del periodo
                if((($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta)) && (($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta)))
                {
                    // Procedo a calcular los días que trabajó durante el periodo
                    $fecha1= new DateTime($fecingreso);
                    $fecha2= new DateTime($fecretiro);
                    $diff = $fecha1->diff($fecha2);
                    
                    $difendias = $diff->days;
                    $diastrab = $difendias + 1;
                }

                // ------------------------------------------------------------------------------------ //

                // Calculo el sueldo básico
                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);

                // ------------------------------------------------------------------------------------------------------------------------------------ //
                // Valido que el básico no sea más de dos salarios mínimos para el subsidio de transporte
                // y que el empleado no sea un practicante SENA                
                
                $cargoid = $row['cargoid'];                                                                 // Obtengo el cargo del empleado
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');       // Obtengo el control del cálculo de subsidio de transporte
    
                if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                {            
                    // Calculo el subsidio de transporte
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);
                }
                else
                    $subsidiotransporte = 0;
                // ------------------------------------------------------------ //
                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                $totnovedades = $clase->SeleccionarUno($vsql);

                $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                $totrecargos = $clase->SeleccionarUno($vsql);

                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
                // ------------------------------------------------------------------------------ //

                // Determino si el empleado es de condición extralegal
                $extralegal = $row['extralegal'];
                $epsid = $row['epsid'];
                $pensionesid = $row['pensionesid'];
                
                if($epsid==NULL)
                    $epsid=0;
                if($pensionesid==NULL)
                    $pensionesid=0;

                // ----------------------------------------------------------------------------------------------------------- //
                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');   // Obtengo el control del cálculo de pensión
                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');   // Obtengo el control del cálculo de salud
    
                if($extralegal=="CHECKED")
                {
                    $pension = 0;
                    $salud = 0;
                }
                else
                {
                    // Recalculo pensión y salud
                    if(($pensionesid==5)||($aplicapension!="CHECKED"))
                        $pension = 0;
                    else
                    {
                        // Obtengo la formula para el descuento por pensión
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                        $formulapension = $clase->SeleccionarUno($vsql);
    
                        // Calculo la pensión
                        eval("\$pension = $formulapension;");
                        $pension = round($pension,0);
                    }
    
                    if(($epsid==37)||($aplicasalud!="CHECKED"))
                        $salud = 0;
                    else
                    {   
                        // Obtengo la formula para el descuento de salud
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                        $formulasalud = $clase->SeleccionarUno($vsql);
                        
                        // Calculo la salud
                        eval("\$salud = $formulasalud;");
                        $salud = round($salud,0);
                    }                    
                }

                // ----------------------------------------------------------------------------------------------------------- //                
                // Grabo en la tabla detalle de nómina
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico), 
                                                          ($numreg+2,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte), 
                                                          ($numreg+3,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones), 
                                                          ($numreg+4,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones) ";
                $clase->EjecutarSQL($vsql);

                if(mysql_affected_rows() >= 1)
                    $lbgrabo=true;
                // --------------------------------------------------------------------------------------------------------------------------- //
                // Ahora debo actualizar las licencias pendientes
                if($lbtienependiente == true)
                {
                    $dias = $diaspendiente;
                    if($diaspendiente <= 15)
                        $diaspendiente = 0;
                    else
                        $diaspendiente -= 15;

                    if($dias>15)
                        $dias = 15;

                    // Actualizo los días pendientes
                    $vsql = "UPDATE licenciaspendiente SET                                         
                                    dias = ".$diaspendiente."
                              WHERE pendienteid = ".$pendienteid."";
                    $clase->EjecutarSQL($vsql);

                    // Inserto la nueva licencia

                    // Obtengo la formula de la licencia
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                    $formulalice = $clase->SeleccionarUno($vsql);

                    // Calculo la licencia
                    if($conceptoid!=10)
                    {
                        eval("\$montolicencia = $formulalice;");
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        // Calculo la incapacidad                        

                        // Obtengo el salario mínimo legal vigente
                        $smlv = $_SESSION['N_SALMIN2020'];

                        // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                        if($basico<=$smlv)
                        {
                            $montolicencia = ($smlv*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            $porcbasico = ($basico*66.67)/100;
                            $porcbasico = round($porcbasico,0);

                            // Calculo la incapacidad si el básico sea mayor al mínimo 
                            if($porcbasico>$smlv)
                            {
                                $montolicencia = ($porcbasico*$dias)/30;
                                $montolicencia = round($montolicencia,0);
                            }
                            else
                            {
                                if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                                $montolicencia = round($montolicencia,0);
                            }
                        }
                    }

                    // Obtengo el tipo de licencia
                    $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                    // Calculo el nuevo ID
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numid = $clase->SeleccionarUno($vsql);
                    $numid++;

                    if($tipodc=="C")
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                    else
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";

                    $clase->EjecutarSQL($vsql);

                    if(mysql_affected_rows() >= 1)
                        $lbpaso = true;

                    // --------------------------------------------------------------------------------------------------------------------------------- //
                    // Aquí debo recalcular la salud y la pensión                    

                    // Sueldo para las deducciones
                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                    $totnovedades = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);
            
                    $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
                    // --------------------------------------------------------------------------------------------------------------------------------- //
                    if($extralegal!="CHECKED")
                    {
                        // Recalculo pensión y salud
                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                            $pension = 0;
                        else
                        {
                            // Obtengo la formula para el descuento por pensión
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                            $formulapension = $clase->SeleccionarUno($vsql);
        
                            // Calculo la pensión
                            eval("\$pension = $formulapension;");
                            $pension = round($pension,0);
                        }
        
                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                            $salud = 0;
                        else
                        {   
                            // Obtengo la formula para el descuento de salud
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                            $formulasalud = $clase->SeleccionarUno($vsql);
                            
                            // Calculo la salud
                            eval("\$salud = $formulasalud;");
                            $salud = round($pension,0);
                        }

                        //  ID pensión
                        $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                        $idpension = $clase->SeleccionarUno($vsql);

                        // Grabo la pensión
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$pension.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idpension."";
                        $clase->EjecutarSQL($vsql);

                        // ID salud
                        $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                        $idsalud = $clase->SeleccionarUno($vsql);

                        // Grabo la salud
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$salud.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idsalud."";
                        $clase->EjecutarSQL($vsql);
                    }
                    // --------------------------------------------------------------------------------------------------------------------------------- //
                }

                // --------------------------------------------------------------------------------------------------------------------------------- //
                if($cal_libranza=="CHECKED")
                {
                    // Nuevo proceso para las libranzas utilizando la nueva tabla “libranzas”
                    $vsql2 = "SELECT conceptoid, monto, tipoquincena
                                FROM libranzas 
                               WHERE terid = ".$terid."
                                     AND (cuotaspagadas < totalcuotas)";
    
                    $conex  = $clase->Conectar();
                    $result2 = mysql_query($vsql2,$conex);
                    $cant   = mysql_num_rows($result2);
                    if($cant>0)
                    {
                        while($row2 = mysql_fetch_array($result2))
                        {
                            // Calculo el nuevo ID
                            $vsql3 = "SELECT max(detalleid) FROM detallenomina";
                            $numid = $clase->SeleccionarUno($vsql3);
                            $numid++;
    
                            // Obtengo el monto a descontar por concepto de esta libranza
                            $monto = $row2['monto'];
                            $conceptoid = $row2['conceptoid'];
                            $tipoquincena = $row2['tipoquincena'];
    
                            // Valido si la libranza se puede descontar en esta quincena
                            if($tipoquincena=="ambas")
                            {
                                // Almaceno el nuevo concepto por libranza
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
                            else
                            {
                                $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                                $diadesde = substr($fecdesde, -2);
    
                                if(($tipoquincena=="primera")&&($diadesde=="01"))
                                {
                                    // Almaceno el nuevo concepto por libranza
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
    
                                if(($tipoquincena=="segunda")&&($diadesde=="16"))
                                {
                                    // Almaceno el nuevo concepto por libranza
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
                            }
                        }
                    }
                }
                // ---------------------------------------------------------------------------------------------------------- //
                if($cal_permanente=="CHECKED")
                {
                    // Verifico si tiene conceptos permanentes
                    $vsql4 = "SELECT conceptoid, monto, tipoquincena 
                                FROM descuentospermanente 
                               WHERE terid = ".$terid."";
    
                    $conex  = $clase->Conectar();
                    $result4 = mysql_query($vsql4,$conex);
                    $cant   = mysql_num_rows($result4);
                    if($cant>0)
                    {
                        while($row4 = mysql_fetch_array($result4))
                        {
                            // Calculo el nuevo ID
                            $vsql5 = "SELECT max(detalleid) FROM detallenomina";
                            $numid = $clase->SeleccionarUno($vsql5);
                            $numid++;
    
                            // Obtengo el monto a descontar por concepto de este concepto
                            $monto = $row4['monto'];
                            $conceptoid = $row4['conceptoid'];
                            $tipoquincena = $row4['tipoquincena'];
    
                            // Valido si el concepto se puede descontar en esta quincena
                            if($tipoquincena=="ambas")
                            {
                                // Almaceno el nuevo concepto permanente
                                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                $clase->EjecutarSQL($vsql);
                            }
                            else
                            {
                                $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                                $diadesde = substr($fecdesde, -2);
    
                                if(($tipoquincena=="primera")&&($diadesde=="01"))
                                {
                                    // Almaceno el nuevo concepto permanente
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
    
                                if(($tipoquincena=="segunda")&&($diadesde=="16"))
                                {
                                    // Almaceno el nuevo concepto permanente
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
                            }
                        }
                    }
                }

                // Almaceno en la tabla tercerosactual
                $vsql = "INSERT INTO tercerosactual (pernominaid, terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid, 
                                                     cargoid, bancoid, numcuenta, fecingreso, fecharetiro, basico, codvende, tipodoc, dni, primernombre, 
                                                     segundonombre, primerapellido, segundoapellido, idcajacomp, epsid, pensionesid) 
                              SELECT ".$periodoid.", terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                     cargoid, bancoid, numcuenta, fecingreso, fecharetiro, basico, codvende, tipodoc, 
                                     dni, primernombre, segundonombre, primerapellido, segundoapellido,
                                     idcajacomp, epsid, pensionesid 
                                FROM terceros
                               WHERE terid = ".$terid;
                $clase->EjecutarSQL($vsql);                
            }

            $vsql12 = "SELECT COUNT(*) AS numregitrosper FROM detallenomina WHERE pernominaid = ".$periodoid;
            $numregitrosper = $clase->SeleccionarUno($vsql12);

            // if($lbgrabo)

            if($numregitrosper > 0)
            {
                $clase->Aviso(1,"La nómina se calculó satisfactoriamente");
    
                // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoid;
                $clase->EjecutarSQL($vsql);

                // // Almaceno en la tabla tercerosactual
                // $vsql = "INSERT INTO tercerosactual (pernominaid, terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid, 
                //                                      cargoid, bancoid, numcuenta, fecingreso, fecharetiro, basico, codvende, dni, primernombre, 
                //                                      segundonombre, primerapellido, segundoapellido, idcajacomp, epsid, pensionesid) 
                //               SELECT d.pernominaid, t.terid, t.esempleado, t.esempleadoactivo, t.extralegal, t.areaid, t.seccionid,
                //                      t.cargoid, t.bancoid, t.numcuenta, t.fecingreso, fecharetiro, t.basico, t.codvende,
                //                      t.dni, t.primernombre, t.segundonombre, t.primerapellido, t.segundoapellido,
                //                      t.idcajacomp, t.epsid, t.pensionesid 
                //                 FROM detallenomina d 
                //                      INNER JOIN terceros t ON (d.terid = t.terid)
                //                WHERE d.pernominaid = ".$periodoid." 
                //                      AND t.esempleadoactivo = 'CHECKED'
                //                      AND t.basico > 0 
                //                      OR t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."' 
                //             GROUP BY t.terid, t.esempleado, t.esempleadoactivo, t.extralegal, t.areaid, t.seccionid,
                //                      t.cargoid, t.bancoid, t.numcuenta, t.fecingreso, fecharetiro, t.basico,
                //                      t.codvende, t.dni, t.primernombre, t.segundonombre, t.primerapellido, t.segundoapellido, 
                //                      t.idcajacomp, t.epsid, t.pensionesid";
                // $clase->EjecutarSQL($vsql);

                // $vsql = "UPDATE tercerosactual SET pernominaid = ".$periodoid;
                // $clase->EjecutarSQL($vsql);

                // Actualizo el campo calculado en la tabla periodosnomina
                $calculado = "CHECKED";

                $vsql = "UPDATE periodosnomina SET 
                                calculado = '".$calculado."'
                          WHERE periodoid = ".$periodoid;
                $clase->EjecutarSQL($vsql);
            }
            else
                $clase->Aviso(3,"No se calculó la nómina, comuníquese con el administrador del sistema");
            
            header("Location: periodosnomina.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: pedircedula
    // Creación: 05/11/2020		última modificación: 15/08/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana que lee la cédula del empleado para la 
    //              impresión del recibo de pago
    // Última modificación: Inclusión del combo del nombre del usuario para la búsqueda
    //                      (09/12/2020)
    //                      Inclusión del combo del tipo de impresión (recibo sencillo o 
    //                      nómina electrónica) (04/02/2021)
    //                      Validación del cálculo del periodo (25/02/2023)
    //                      Incorporación del código de vendedor en la búsqueda de empleados
    //                      (10/07/2023)
    //                      Incorporación del pie de página
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "pedircedula")
    {
        $periodoid = $_GET['periodoid'];

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado != "CHECKED")
        {
            // Emito el mensaje correspondiente
            $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $clase->Aviso(3,"El periodo $descripcion no está calculado");

            // Redirecciono el formulario
            header("Location: periodosnomina.php");
        }
        else
        {
            // Combo de empleados
            $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                               FROM terceros 
                              WHERE basico > 0
                           ORDER BY nombres";
            $params = ' class="Texto11" ';
    
            $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
            // Pinto la ventana
            $cont = $clase->Header("S","W");
            $cont.='<form action="recibodepago.php?opcion=reciboindividual" method="POST" name="x" target="_blank">
                    <input type="hidden" name="periodoid" value="'.$periodoid.'">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Imprimir recibo de pago del periodo <font color="BLUE">'.$descripcion.'</font> </b> </td> 
                      <td width="10%" align="center"> <a href="periodosnomina.php"> <input type="button" class="button blue" value="<<"> </a></td>
                     </tr> 
                    </table>
                    <table width="100%">
                     <tr class="BarraDocumentos" style="height:50px;Important!">				
                      <td width="160" align="right"> <label class="Texto13"> Nombre:&nbsp </label> </td> 			  
                      <td width="240">'.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,500).'</td>
                     </tr>
                    </table>
                    <center>                    
                    <table width="100%">
                     <tr class="BarraDocumentos" style="height:50px;Important!">
                      <td align="center">
                       <input type="submit" value="aceptar" class="button blue">
                       </form>
                      </td>
                     </tr>
                    </table>';

            // Pie de página
            $cont.='<table width="100%"> 
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>                     
                    </table>';
    
            echo $cont.$clase->PiePagina();
            exit();
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanaocasionales
    // Creación: 26/02/2021		última modificación: 10/07/2023
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que pinta la ventana para los datos de los conceptos ocasionales
    // Última modificación: Se cambió el título de descuentos por conceptos debido a que 
    //                      ahora existen devengados en los ocasionales (18/11/2021)
    //                      Incorporación del código de vendedor en la búsqueda de empleados
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "ventanaocasionales")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado=="CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                           FROM $tabla 
                          WHERE esempleadoactivo = 'CHECKED' 
                                AND basico > 0
                       ORDER BY primernombre";

        $vsqlcombooca = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE montoocasional='CHECKED' ORDER BY conceptoid";
        $params = ' class="Texto11" ';
        $monto = 1;
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/egresos.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Conceptos ocasionales para el periodo <font color="BLUE">'.$descripcion.'</font></b> </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=guardarocasionales" method="POST">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                  <fieldset style="width: 530px; height: 280px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Empleado: </b></label><br>';
        
        $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,420);

        $cont.='    </td>                   
                   </tr>                    
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Licencia:</b></label><br>';

        $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombooca,"nombres","conceptoid","","N",$params,420);

        $cont.='    </td>                   
                   </tr>
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Monto:</b></label><br>
                     <input type="number" name="monto" min="1" class="Texto12New" size="20" autocomplete="off" title="monto a descontar" value="'.$monto.'"> 
                    </td>                   
                   </tr>                    
                   <tr height="55">
                    <td align="center"><br><br> 
                     <input type="submit" value="guardar" class="button blue"> 
                    </td>
                   </tr>
                  </table>
                 </form>
                 <br><br>
                 </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarocasionales
    // Creación: 26/02/2021		última modificación: 18/11/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda el nuevo concepto ocasional en la tabla detallenomina
    //              como un descuento
    // Última modificación: Se le deshabilitó la validación del periodo procesado 
    //                      (07/07/2021)
    //                      Se adaptó para incluir conceptos de ambos tipos: devengado y 
    //                      descuentos.
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarocasionales")
    { 
        $periodoid = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];
        $terid = $_POST['terid'];
        $monto = $_POST['monto'];

        // Nombre de periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Obtengo el número de registros de la tabla detallenomina
        $vsql = "SELECT MAX(detalleid) FROM detallenomina";
        $numeroid = $clase->SeleccionarUno($vsql);

        // Incremento el ID
        $numeroid++;

        // Obtengo el tipo de concepto
        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

        // Almaceno en la tabla el concepto de compras a crédito para el trabajador
        if($tipodc=="C")
            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                        VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
        else
            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                        VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";

        $clase->EjecutarSQL($vsql);

        // Envío el mensaje correspondiente
        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se procesó el concepto, verifique por favor");
        else
            $clase->Aviso(1,"Concepto procesado exitosamente");

        // Redirecciono el formulario
        header("Location: periodosnomina.php?opcion=ventanaocasionales&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanapermanentes
    // Creación: 18/12/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para los datos de las libranzas y descuentos 
    //              permanentes
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanapermanentes")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado=="CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                           FROM $tabla 
                          WHERE esempleadoactivo = 'CHECKED' 
                                AND basico > 0
                       ORDER BY primernombre";

        $vsqlcomboper = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) 
                          FROM conceptosnomina 
                         WHERE montopermanente = 'CHECKED' OR eslibranza = 'CHECKED'
                      ORDER BY conceptoid";
        $params = ' class="Texto11" ';
        $monto = 1;
        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/egresos.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Libranzas y descuentos permanentes para el periodo <font color="BLUE">'.$descripcion.'</font></b> </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<center>
                <form action="?opcion=guardarpermanentes" method="POST">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                  <fieldset style="width: 530px; height: 280px;" class="grupos">
                  <legend class="titgrupos"> Datos </legend>
                  <table width="350">
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Empleado: </b></label><br>';
        
        $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,420);

        $cont.='    </td>                   
                   </tr>                    
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Concepto:</b></label><br>';

        $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcomboper,"nombres","conceptoid","","N",$params,420);

        $cont.='    </td>                   
                   </tr>
                   <tr height="55">
                    <td> <label class="Texto12"> <b>Monto:</b></label><br>
                     <input type="number" name="monto" min="1" class="Texto12New" size="20" autocomplete="off" title="monto a descontar" value="'.$monto.'"> 
                    </td>                   
                   </tr>                    
                   <tr height="55">
                    <td align="center"><br><br> 
                     <input type="submit" value="guardar" class="button blue"> 
                    </td>
                   </tr>
                  </table>
                 </form>
                 <br><br>
                 </fieldset>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarpermanentes
    // Creación: 18/12/2022		última modificación: 
    // Creador: Luis Flórez		modificado por:
    // Descripción: Opción que guarda el nuevo concepto ocasional en la tabla detallenomina
    //              como una libranzas y descuentos permanentes
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarpermanentes")
    { 
        $periodoid = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];
        $terid = $_POST['terid'];
        $monto = $_POST['monto'];

        // Nombre de periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Obtengo el número de registros de la tabla detallenomina
        $vsql = "SELECT MAX(detalleid) FROM detallenomina";
        $numeroid = $clase->SeleccionarUno($vsql);

        // Incremento el ID
        $numeroid++;

        // Obtengo el tipo de concepto
        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

        // Almaceno en la tabla el concepto de compras a crédito para el trabajador
        if($tipodc=="C")
            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                        VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
        else
            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                        VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";

        $clase->EjecutarSQL($vsql);

        // Envío el mensaje correspondiente
        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se procesó el concepto, verifique por favor");
        else
            $clase->Aviso(1,"Concepto procesado exitosamente");

        // Redirecciono el formulario
        header("Location: periodosnomina.php?opcion=ventanapermanentes&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel
    // Creación: 05/01/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para seleccionar la hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
	if($opcion == "importarexcel")
	{
        $periodoid = $_GET['periodoid'];

        $vsqlcombooca = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE montoocasional='CHECKED' ORDER BY conceptoid";
        $params = ' class="Texto11" ';

        $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                <script>
                    $(function()
                    {
                    $("#enviarr").on("click",function()
                    {
                    $(this).val("Espere por favor ...")
                    .attr("disabled","disabled");
                    $("#theform").submit();
                    });

                    });
                </script>
                <table width="400">
                <tr class="CabezoteTabla"> 
                 <td align="center"> Importar primas  </td> 
                </tr> 
                </table>
                <table width="400">
                 <tr class="TablaDocsPar">        
                  <td width="100%" align="center"> 
                   <form name="importa" method="post" action="periodosnomina.php?opcion=importarexcel2" id="theform" enctype="multipart/form-data">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="file" name="excel" /><br><br><br>
                   Concepto:';

        $cont.= $clase->CrearComboBuscar("conceptoid",$vsqlcombooca,"nombres","conceptoid","","N",$params,300);

        $cont.='   <br><br><br>
                   <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                   <input type="hidden" value="upload" name="action" />                  
                   </form>
                  </td>    
                 </tr>
                 <tr class="TablaDocsPar">
                  <td width="100%" align="center"> <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font></td>    
                 </tr>
                </table><br>'; 
        echo $cont; 
        exit();
	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel2
    // Creación: 05/01/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para grabar los datos importados de la hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
	if($opcion == "importarexcel2")
	{
        $conceptoid = $_POST['conceptoid'];
        $periodoid = $_POST['periodoid'];

		set_time_limit(0);
		extract($_POST);
		$docuid = $_POST["docuid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");            
            header("Location: periodosnomina.php?opcion=ventanaocasionales&periodoid=$periodoid");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();  
                $recorrer = true;  $i = 1;
                while($recorrer)
                {              
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();                    
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)&&(strlen($_DATOS_EXCEL[$i]['monto']) == 0)) 
                        $recorrer = false;             
                    
                    $i++;
                } /// Fin del While   
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;
            $numeroid = 0;
            for($j=1; $j < $i; $j++)
            {
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");                
                
                if($terid != "")
                {
                    $monto    = $_DATOS_EXCEL[$j]['monto'];

                    // Obtengo el número de registros de la tabla detallenomina
                    $vsql2 = "SELECT MAX(detalleid) FROM detallenomina";
                    $numeroid = $clase->SeleccionarUno($vsql2);
            
                    // Incremento el ID
                    $numeroid++;

                    // Obtengo el tipo de concepto
                    $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
            
                    // Almaceno en la tabla el concepto de compras a crédito para el trabajador
                    if($tipodc=="C")
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
                    else
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";

                    $clase->EjecutarSQL($vsql);
    
                    if(mysql_affected_rows() >= 1)
                        $grabados++;                    
                } 
            }    
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los conceptos ocasionales");
            else
            {
                $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
                $nomconcepto  = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
                $nomconcepto = strtolower($nomconcepto);                
                $clase->Aviso(1,"Se cargaron $grabados $nomconcepto para el periodo $descripcion");
            }
    
            // Redirecciona el formulario
            header("Location: periodosnomina.php?opcion=ventanaocasionales&periodoid=$periodoid");
        }
  	}


    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarxtipo
    // Creación: 23/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que envía a la vista principal el filtro del año
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarxtipo")
    {
        $filtro = $_POST['filtro'];
        header("Location: periodosnomina.php?filtro=$filtro");
    } 
  
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 15/09/2020		última modificación: 03/12/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal del formulario
    // Última modificación: Inclusión de la búsqueda simple por código y descripción
    //                      (23/09/2020)
    //                      Inclusión de menú de opciones para un periodo 10/11/2020
    //                      Adecuación para que en el primer periodo coloque la opción de 
    //                      imprimir recibo (19/02/2021)
    //                      Se quitaron las opciones de procesamiento de periodo a las 
    //                      quincenas que no están abiertas y que solo se reabriera el 
    //                      periodo inmediatamente inferior al actual (01/09/2021)
    //                      Se incorporó el combo para filtrar los periodos por año 
    //                      eliminando la búsqueda de periodo (23/12/2021)
    //                      Optimización de encabezado (16/12/2022)
    //                      Validación del botón eliminar cuando el periodo esté calculado
    //                      (15/11/2023)
    //                      Creación de los nuevos periodos de nómina año 2025
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        $filtro  = $_GET['filtro'];
        $yeartoday = date("Y");

        if(strlen($filtro) == 0)
            $filtro = $yeartoday;

        // inicialización de variables
        $selected2021 = '';
        $selected2022 = '';
        $selected2023 = '';
        $selected2024 = '';
        $selected2025 = '';

        // selección del combo por defecto
        switch($filtro)
        {
            case 2021:
                $selected2021 = 'selected';
                break;
            case 2022:
                $selected2022 = 'selected';
                break;
            case 2023:
                $selected2023 = 'selected';
                break;
            case 2024:
                $selected2024 = 'selected';
                break;
            case 2025:
                $selected2025 = 'selected';
                break;
            default:
                break;
        }

        // combo de años
        $years = '<option value="2021" '.$selected2021.'> 2021 </option>
                  <option value="2022" '.$selected2022.'> 2022 </option>
                  <option value="2023" '.$selected2023.'> 2023 </option>
                  <option value="2024" '.$selected2024.'> 2024 </option>
                  <option value="2025" '.$selected2025.'> 2025 </option>';

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<form action="periodosnomina.php?opcion=filtrarxtipo" method="POST" name="z">
                  <table width="100%">
                   <tr class="CabezoteTabla"> 
                    <td width="10"> &nbsp; </td>
                    <td width="37"> <img src="images/iconos/periodos.png" width="32" height="32" border="0"> </td>
                    <td width="180"> <b>Periodos de n&oacute;mina año:</b> </td>
                    <td width="100"> 
                     <select class="Texto11" name="filtro" style="width:60px;height:25px" OnChange="z.submit();">
                      '.$years.'
                     </select> 
                    </td>
                    <td width="620"> &nbsp; </td>
                    <td width="24"> <a href="?opcion=nuevo"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="nuevo periodo"> </a> </td>';

        if($_SESSION['SQL_PERIODOS'] != "")
            $cont.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/basicas/nofiltro.png"> </a> </td>';
        
        $cont.='  <td width="8"> &nbsp;</td>
                 </tr>	 			   
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                 <table width="100%" class="sortable">
                  <thead> 
                   <tr class="TituloTabla" style="display:block;padding-top:5px;height:21px;">
                    <td width="20"> &nbsp; </td>
                    <td width="80"> C&oacute;digo </td>
                    <td width="320"> Descripci&oacute;n </td>			
                    <td width="75"> Desde </td>
                    <td width="45"> &nbsp; </td>
                    <td width="75"> Hasta </td>	
                    <td width="300"> &nbsp; </td>
                   </tr>
                  </thead>
                  <tbody style="display:block; width:1050px; height:690px; overflow-Y:scroll">';

        $filtro2 = strval($filtro);
        $stryearact = strval($yeartoday);

        $vsql = "SELECT periodoid, codigo, descripcion, fecdesde, fechasta, cerrado FROM periodosnomina";

        if($filtro == 0)
            $vsql.= " WHERE SUBSTR(descripcion, -4) = '".$stryearact."' ";
        else
            $vsql.= " WHERE SUBSTR(descripcion, -4) = '".$filtro2."' ";

        $vsql.= " ORDER BY periodoid";

        $i = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            // Asigno formato a las fechas
            $fecdesde  = substr($row['fecdesde'],8,2)."/".substr($row['fecdesde'],5,2)."/".substr($row['fecdesde'],0,4);
            $fechasta  = substr($row['fechasta'],8,2)."/".substr($row['fechasta'],5,2)."/".substr($row['fechasta'],0,4);
            
            // Valido que esté cerrado el anterior
            $periodoidactual = $row['periodoid'];

            if(($i==1) && ($filtro2==$stryearact))
                $cerradoant="CHECKED";
            else
            {
                $vsql = "SELECT cerrado 
                           FROM periodosnomina 
                          WHERE periodoid = (SELECT MAX(periodoid) FROM periodosnomina WHERE periodoid < $periodoidactual)";
                $cerradoant = $clase->SeleccionarUno($vsql);
            }
            
            // Obtengo el valor del campo calculado
            $calculado = $clase->BDLockup($periodoidactual,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            // Determino si tiene empleados en negativo
            $ldtienenegativos = false;

            if($row['cerrado']!='CHECKED')
            {
                $vsql2 = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                                 SUM(d.devengados) - SUM(d.descuentos) AS total
                            FROM detallenomina d
                                 INNER JOIN $tabla t ON (d.terid = t.terid)
                           WHERE d.pernominaid = ".$periodoidactual."  
                                 AND d.conceptoid NOT IN (6, 9, 43, 58)                                 
                        GROUP BY t.dni, nombreemp";
                $conex2  = $clase->Conectar();
                $result2 = mysql_query($vsql2,$conex2);
    
                // Recorro la consulta para buscar negativos
                while($row2 = mysql_fetch_array($result2))
                {
                    if($row2['total']<0)
                        $ldtienenegativos = true;
                }
            }
            // --------------------------------------------------------------------------------------------------------------- //
                    
            $cont.=' <td width="20"> </td>
                     <td width="90"> '.$row['codigo'].' </td>';

            if(($ldtienenegativos)&&($calculado=="CHECKED"))
                $cont.='<td width="360"> <font color="RED">'.$row['descripcion'].'</font> </td>';
            else
                $cont.='<td width="360"> '.$row['descripcion'].' </td>';

            $cont.=' <td width="80"> '.$fecdesde.' </td>
                     <td width="50"> &nbsp; </td>
                     <td width="85"> '.$fechasta.' </td>
                     <td width="50"> &nbsp; </td>';

            if(($ldtienenegativos)&&($calculado=="CHECKED"))
                $cont.='<td width="300"> <font color="RED">Tiene empleados en negativo</font> </td>';
            else
                $cont.='<td width="300"> &nbsp; </td>';

            // --------------------------------------------------------------------------------------------------------------------------------------------------------- //            
            if($row['cerrado']=='CHECKED')            
                $cont.=' <td width="30"> &nbsp; </td>
                         <td width="30"> &nbsp; </td>
                         <td width="30"> &nbsp; </td>
                         <td width="30"> &nbsp; </td>
                         <td width="30"> &nbsp; </td>
                         <td width="30" align="center"> 
                          <a href="?opcion=pedircedula&periodoid='.$row['periodoid'].'" target="_blank">
                           <img src="images/basicas/pdf.png" title="recibo" border="0" width="20" height="20">
                          </a>
                         </td>';
            else
            {
                if($cerradoant=='CHECKED')
                {
                    // ------------------------------------------------------------------------------------------------------- //
                    // $cont.='<td width="30">
                    //          <a href="?opcion=confirmarlimpiarper&periodoid='.$row['periodoid'].'" rel="facebox">
                    //          <img src="images/basicas/reconciliar.png" title="limpiar periodo" border="0"></a>
                    //         </td>';

                    // if($ldtienenegativos)
                    //     $cont.='<td width="30"> &nbsp; </td>';
                    // else
                    //     $cont.='<td width="30">
                    //              <a href="?opcion=confirmacerrarperiodo&periodoid='.$row['periodoid'].'" rel="facebox">
                    //              <img src="images/basicas/close.gif" title="cerrar periodo" border="0"></a>
                    //             </td>';
                    // ------------------------------------------------------------------------------------------------------- //
                    // if($calculado=="CHECKED")
                    //     $cont.='<td width="30"> &nbsp; </td>
                    //             <td width="30">
                    //              <a href="?opcion=confirmarlimpiarper&periodoid='.$row['periodoid'].'" rel="facebox">
                    //               <img src="images/basicas/reconciliar.png" title="limpiar periodo" border="0">
                    //              </a>
                    //             </td>';
                    // else
                    //     $cont.='<td width="30"> &nbsp; </td>
                    //             <td width="30"> <img src="images/basicas/reconciliar.png" title="limpiar periodo" border="0"> </td>';

                    // // ------------------------------------------------------------------------------------------------------- //
                    // // $cont.='<td width="30">                          
                    // //          <a href="?opcion=menu&periodoid='.$row['periodoid'].'" rel="facebox"> 
                    // //          <img src="images/basicas/funciones.png" title="menú" border="0"></a>
                    // //         </td>
                    // //         <td width="30">                                 
                    // //          <a href="?opcion=pedircedula&periodoid='.$row['periodoid'].'" target="_blank">
                    // //          <img src="images/basicas/pdf.png" title="recibo" border="0"></a>
                    // //         </td>';
                    // // -------------------------------------------------------------------------------------------------------- //

                    // if($calculado=="CHECKED")
                    //     $cont.='  <td width="30" align="left">
                    //                <a href="?opcion=pedircedula&periodoid='.$row['periodoid'].'" target="_blank">
                    //                 <img src="images/basicas/pdf.png" title="recibo" border="0">
                    //                </a>
                    //               </td>';
                    // else
                    //     $cont.='  <td width="30" align="left"> <img src="images/basicas/pdf.png" title="periodo no calculado" border="0"> </td>';

                    if($calculado=="CHECKED")
                        $cont.='<td width="30"> &nbsp; </td>
                                <td width="30">
                                 <a href="?opcion=confirmarlimpiarper&periodoid='.$row['periodoid'].'" rel="facebox">
                                  <img src="images/basicas/reconciliar.png" title="limpiar periodo" border="0" width="20" height="20">
                                 </a>
                                </td>
                                <td width="30" align="left">
                                 <a href="?opcion=pedircedula&periodoid='.$row['periodoid'].'" target="_blank">
                                  <img src="images/basicas/pdf.png" title="recibo" border="0" width="20" height="20">
                                 </a>
                                </td>';
                    else
                        $cont.='<td width="30"> &nbsp; </td>
                                <td width="30"> &nbsp; </td>
                                <td width="30"> &nbsp; </td>';

                    // -------------------------------------------------------------------------------------------------------- //
                    $cont.='<td width="30">
                             <a href="?opcion=menu&periodoid='.$row['periodoid'].'" rel="facebox"> <img src="images/basicas/funciones.png" title="menú" border="0" width="20" height="20"> </a>
                            </td>';

                    if($calculado=="CHECKED")
                        $cont.='<td width="30"> &nbsp; </td>
                                <td width="30"> &nbsp; </td>';
                    else
                        $cont.='<td width="30">
                                 <a href="?opcion=confirmacion&periodoid='.$row['periodoid'].'" rel="facebox"> <img src="images/basicas/iconoborrar.png" title="eliminar" border="0" width="20" height="20"> </a>
                                </td>
                                <td width="30" align="center">
                                 <a href="?opcion=detalles&periodoid='.$row['periodoid'].'"> <img src="images/basicas/iconobuscar.png" title="editar" border="0" width="20" height="20"> </a>
                                </td>';
                }
                else
                    $cont.='<td width="30"> &nbsp; </td>
                            <td width="30"> &nbsp; </td>
                            <td width="30"> &nbsp; </td>
                            <td width="30"> &nbsp; </td>
                            <td width="30">
                             <a href="?opcion=confirmacion&periodoid='.$row['periodoid'].'" rel="facebox"> <img src="images/basicas/iconoborrar.png" title="eliminar" border="0" width="20" height="20"> </a>
                            </td>
                            <td width="30" align="center">
                             <a href="?opcion=detalles&periodoid='.$row['periodoid'].'"> <img src="images/basicas/iconobuscar.png" title="editar" border="0" width="20" height="20"> </a>
                            </td>';
            }
            
            $cont.=' <td width="10"> &nbsp; </td> 
                    </tr>';
        }
        $cont.=' </tbody>
                </table>                
                <table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: arhivoexcel2
    // Creación: 14/03/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera el archivo de Excel que es enviado al banco para 
    //              consignar la nómina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "arhivoexcel2")
    {
        $periodoid = $_POST['periodoid'];
        $bancoid = $_POST['bancoid'];

        // Consulta de los empleados a los cuales se les consignará
        // $vsql = "SELECT '2' AS tipo, t.dni AS cedula, CONCAT(t.primernombre,' ',t.segundonombre,' ') AS nombres, 
        //                 CONCAT(t.primerapellido,' ',t.segundoapellido) AS apellidos,   
        //                 '51' AS codbanco, 'CA' AS tiposer, t.numcuenta AS cuenta, 
        //                 (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43),d.descuentos,0))) AS consignar 
        //            FROM tercerosactual t          
        //                 INNER JOIN detallenomina d ON (t.terid = d.terid)          
        //                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
        //           WHERE d.pernominaid = ".$periodoid."
        //                 AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
        //                 AND (t.numcuenta <> '' AND t.numcuenta IS NOT NULL)
        //                 AND t.bancoid = ".$bancoid."
        //        GROUP BY t.terid";

        $vsql = "SELECT '2' AS tipo, t.dni AS cedula, CONCAT(t.primernombre,' ',t.segundonombre,' ') AS nombres, 
                        CONCAT(t.primerapellido,' ',t.segundoapellido) AS apellidos,   
                        codbanco, 'CA' AS tiposer, t.numcuenta AS cuenta, 
                        (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) AS consignar 
                   FROM tercerosactual t          
                        INNER JOIN detallenomina d ON (t.terid = d.terid)          
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                  WHERE d.pernominaid = ".$periodoid."
                        AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND (t.numcuenta <> '' AND t.numcuenta IS NOT NULL)
                        AND t.bancoid = ".$bancoid."
               GROUP BY t.terid";        

        // nombres del periodo y del banco
        $descripcionperiodo = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $descripcionbanco = $clase->BDLockup($bancoid,'bancos','bancoid','descripcion');

        // nombre de la hoja de excel
        $nombrearchivo = $descripcionperiodo." ".$descripcionbanco.".xls";
        $nombrearchivo = strtolower($nombrearchivo);

        // Preparación del entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Planilla de nomina - DROPOS")
                                     ->setSubject("Planilla de nomina - DROPOS")
                                     ->setDescription("Planilla de nomina - DROPOS")
                                     ->setKeywords("Planilla de nomina - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'TIPO')
                    ->setCellValue('B1', 'CEDULA')
                    ->setCellValue('C1', 'NOMBRES')
                    ->setCellValue('D1', 'APELLIDOS')
                    ->setCellValue('E1', 'CODBANCO')
                    ->setCellValue('F1', 'TIPOSER')
                    ->setCellValue('G1', 'CUENTA')
                    ->setCellValue('H1', 'CONSIGNAR');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        $i=2;
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['tipo'])
                        ->setCellValue('B'.$i, $row['cedula'])
                        ->setCellValue('C'.$i, $row['nombres'])
                        ->setCellValue('D'.$i, $row['apellidos'])
                        ->setCellValue('E'.$i, $row['codbanco'])
                        ->setCellValue('F'.$i, $row['tiposer'])
                        ->setCellValue('G'.$i, strval($row['cuenta']))
                        ->setCellValue('H'.$i, $row['consignar']);
            $i++;
            $cant++;
        }

        $rangoEncabezado = 'A4:G4';
        $rangoCeldas     = 'A4:G'.($cant+1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(20);

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('macro');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$nombrearchivo.'"');
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;               
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: arhivoexcel3
    // Creación: 12/04/2024		última modificación: 18/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que emite la macro que va a los diferentes bancos
    // Última modificación: Macro para el banco de Bogotá (16/04/2024)
    //                      Macro para el BBVA (17/04/2024)
    //                      Tipo de identificación de acuerdo con el tipo de documento por 
    //                      banco
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "arhivoexcel3")
    {
        $periodoid = $_POST['periodoid'];
        $bancoid = $_POST['bancoid'];

        // proceso la macro del banco davivienda
        if(($bancoid == 1) || ($bancoid == 8))
        {
            // Consulta para los empleados de Davivienda
            $vsql = "SELECT ta.dni, CONCAT(ta.primernombre,' ',ta.segundonombre,' ',ta.primerapellido,' ',ta.segundoapellido) AS nombre, 
                            ta.numcuenta,  
                            CASE
                              WHEN ta.bancoid = 1 THEN 'CA'
                              WHEN ta.bancoid = 8 THEN 'DP'
                            END tipo, 
                            eb.codbanco,        
                            (SELECT (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ta.terid
                                    AND d.pernominaid = ".$periodoid.") valor, 
                            (SELECT IFNULL(macrodavivienda,'') FROM tipodocumento WHERE codigo = ta.tipodoc) tipoidentificacion 
                       FROM tercerosactual ta
                            INNER JOIN entidadesbancarias eb ON (ta.bancoid = eb.bancoid)
                      WHERE ta.bancoid IN (1,8) 
                            AND (ta.numcuenta <> '' AND ta.numcuenta IS NOT NULL)
                            AND (ta.esempleadoactivo = 'CHECKED' AND (ta.extralegal = '' OR ta.extralegal IS NULL))
                            AND ta.pernominaid = ".$periodoid."
                     HAVING valor > 0";

            // nombres del periodo y del banco
            $descripcionperiodo = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $descripcionbanco = $clase->BDLockup($bancoid,'bancos','bancoid','descripcion');

            // nombre de la hoja de excel
            $nombrearchivo = $descripcionperiodo." ".$descripcionbanco.".xls";
            $nombrearchivo = strtolower($nombrearchivo);

            // Preparación del entorno
            require_once 'lib/PHPExcel.php';
            $clase = new Sistema();
            $clase->Conectar();
            ini_set("memory_limit","100M");

            // Preparación del entorno para la salida a Excel
            $clase = new Sistema();
            $clase->Nombredb = $_SESSION['DBNOMBRE'];
            error_reporting(E_ALL);
            ini_set('display_errors', TRUE);
            ini_set('display_startup_errors', TRUE);
            date_default_timezone_set('Europe/London');
        
            if (PHP_SAPI == 'cli')
                die('This example should only be run from a Web Browser');
        
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
        
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                         ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                         ->setTitle("Davivienda - DROPOS")
                                         ->setSubject("Davivienda - DROPOS")
                                         ->setDescription("Davivienda - DROPOS")
                                         ->setKeywords("Davivienda - DROPOS")
                                         ->setCategory("Categoria General");

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'DOCUMENTO')
                        ->setCellValue('B1', 'TIPO IDENTIFICACION')
                        ->setCellValue('C1', 'NOMBRES')
                        ->setCellValue('D1', 'CUENTA')
                        ->setCellValue('E1', 'TIPO')
                        ->setCellValue('F1', 'CODBANCO')
                        ->setCellValue('G1', 'MONTO');

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);            

            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant   = mysql_num_rows($result);
            $i = 2;
            while($row = mysql_fetch_array($result))
            {
                // tipo de indentificación
                if($row['tipoidentificacion'] != "")
                    $tipoidentificacion = "'".$row['tipoidentificacion'];
                else
                    $tipoidentificacion = "";

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $row['dni'])
                            ->setCellValue('B'.$i, $tipoidentificacion)
                            ->setCellValue('C'.$i, $row['nombre'])
                            ->setCellValue('D'.$i, $row['numcuenta'])
                            ->setCellValue('E'.$i, $row['tipo'])
                            ->setCellValue('F'.$i, $row['codbanco'])                            
                            ->setCellValue('G'.$i, $row['valor']);
                $i++;
                $cant++;
            }

            $rangoEncabezado = 'A4:G4';
            $rangoCeldas     = 'A4:G'.($cant+1);
    
            // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
            // Formato de Encabezado y Celdas
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(20);

            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('davivienda');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Redirect output to a client’s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="'.$nombrearchivo.'"');
            header('Cache-Control: max-age=0');
            /// Genero la Salida
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            exit;
        }
        
        // proceso la macro del banco de Bogotá
        if($bancoid == 2)
        {
            // Consulta para los empleados del banco de Bogotá
            $vsql = "SELECT 'R' R, ta.numcuenta, 'Cuenta de Ahorros' tipocuenta, 
                            (SELECT (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ta.terid
                                    AND d.pernominaid = ".$periodoid.") valor, 
                            eb.codbanco, ta.dni, 'Cédula de Ciudadanía' cedula, 
                            CONCAT(ta.primernombre,' ',ta.segundonombre,' ',ta.primerapellido,' ',ta.segundoapellido) AS nombre, 
                            'Activo' statuscuenta,                                     
                            (SELECT IFNULL(macrobogota,'') FROM tipodocumento WHERE codigo = ta.tipodoc) tipoidentificacion 
                       FROM tercerosactual ta
                            INNER JOIN entidadesbancarias eb ON (ta.bancoid = eb.bancoid) 
                      WHERE ta.bancoid = ".$bancoid."   
                            AND (ta.numcuenta <> '' AND ta.numcuenta IS NOT NULL) 
                            AND (ta.esempleadoactivo = 'CHECKED' AND (ta.extralegal = '' OR ta.extralegal IS NULL)) 
                            AND ta.pernominaid = ".$periodoid."
                     HAVING valor > 0";

            // nombres del periodo y del banco
            $descripcionperiodo = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $descripcionbanco = $clase->BDLockup($bancoid,'bancos','bancoid','descripcion');

            // nombre de la hoja de excel
            $nombrearchivo = $descripcionperiodo." ".$descripcionbanco.".xls";
            $nombrearchivo = strtolower($nombrearchivo);

            // Preparación del entorno
            require_once 'lib/PHPExcel.php';
            $clase = new Sistema();
            $clase->Conectar();
            ini_set("memory_limit","100M");

            // Preparación del entorno para la salida a Excel
            $clase = new Sistema();
            $clase->Nombredb = $_SESSION['DBNOMBRE'];
            error_reporting(E_ALL);
            ini_set('display_errors', TRUE);
            ini_set('display_startup_errors', TRUE);
            date_default_timezone_set('Europe/London');
        
            if (PHP_SAPI == 'cli')
                die('This example should only be run from a Web Browser');
        
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
        
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                         ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                         ->setTitle("Banco Bogota - DROPOS")
                                         ->setSubject("Banco Bogota - DROPOS")
                                         ->setDescription("Banco Bogota - DROPOS")
                                         ->setKeywords("Banco Bogota - DROPOS")
                                         ->setCategory("Categoria General");

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'R')
                        ->setCellValue('B1', 'CUENTA')
                        ->setCellValue('C1', 'CUENTA')
                        ->setCellValue('D1', 'MONTO')
                        ->setCellValue('E1', 'CODBANCO')
                        ->setCellValue('F1', 'DOCUMENTO')
                        ->setCellValue('G1', 'DOCUMENTO')
                        ->setCellValue('H1', 'NOMBRES')
                        ->setCellValue('I1', 'STATUS');

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);

            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant = mysql_num_rows($result);
            $i = 2;
            while($row = mysql_fetch_array($result))
            {
                // código del banco
                $codbanco = $row['codbanco'];

                if(substr($codbanco,0,1) == "0")
                    $codbanco = "'0".$codbanco;

                // tipo de indentificación
                if($row['tipoidentificacion'] != "")
                    $tipoidentificacion = "'".$row['tipoidentificacion'];
                else
                    $tipoidentificacion = "";                    

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $row['R'])
                            ->setCellValue('B'.$i, $row['numcuenta'])
                            ->setCellValue('C'.$i, $row['tipocuenta'])
                            ->setCellValue('D'.$i, $row['valor'])
                            ->setCellValue('E'.$i, $codbanco)
                            ->setCellValue('F'.$i, $row['dni'])                            
                            ->setCellValue('G'.$i, $tipoidentificacion)
                            ->setCellValue('H'.$i, $row['nombre'])
                            ->setCellValue('I'.$i, $row['statuscuenta']);
                $i++;
                $cant++;
            }

            $rangoEncabezado = 'A4:I4';
            $rangoCeldas     = 'A4:I'.($cant+1);
            // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
            
            // Formato de Encabezado y Celdas
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(20);

            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('Bogota');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Redirect output to a client’s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="'.$nombrearchivo.'"');
            header('Cache-Control: max-age=0');
            /// Genero la Salida
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            exit;
        }

        // proceso la macro del BBVA
        if($bancoid == 3)
        {
            // Consulta para los empleados del BBVA
            $vsql = "SELECT 'OK' seleccion, ta.dni, '01' tipoid, '0' digitov, 
                            CONCAT(ta.primernombre,' ',ta.segundonombre,' ',ta.primerapellido,' ',ta.segundoapellido) AS nombre, 
                            '1' formadepago, eb.codbanco, '02' tipocuenta, ta.numcuenta, 
                            (SELECT (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ta.terid
                                    AND d.pernominaid = ".$periodoid.") valor,                                     
                            (SELECT IFNULL(macrobbva,'') FROM tipodocumento WHERE codigo = ta.tipodoc) tipoidentificacion                  
                       FROM tercerosactual ta
                            INNER JOIN entidadesbancarias eb ON (ta.bancoid = eb.bancoid)
                      WHERE ta.bancoid = ".$bancoid." 
                            AND (ta.numcuenta <> '' AND ta.numcuenta IS NOT NULL)
                            AND ta.pernominaid = ".$periodoid."
                     HAVING valor > 0";

            // nombres del periodo y del banco
            $descripcionperiodo = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $descripcionbanco = $clase->BDLockup($bancoid,'bancos','bancoid','descripcion');

            // nombre de la hoja de excel
            $nombrearchivo = $descripcionperiodo." ".$descripcionbanco.".xls";
            $nombrearchivo = strtolower($nombrearchivo);

            // Preparación del entorno
            require_once 'lib/PHPExcel.php';
            $clase = new Sistema();
            $clase->Conectar();
            ini_set("memory_limit","100M");

            // Preparación del entorno para la salida a Excel
            $clase = new Sistema();
            $clase->Nombredb = $_SESSION['DBNOMBRE'];
            error_reporting(E_ALL);
            ini_set('display_errors', TRUE);
            ini_set('display_startup_errors', TRUE);
            date_default_timezone_set('Europe/London');
        
            if (PHP_SAPI == 'cli')
                die('This example should only be run from a Web Browser');
        
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
        
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                         ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                         ->setTitle("BBVA - DROPOS")
                                         ->setSubject("BBVA - DROPOS")
                                         ->setDescription("BBVA - DROPOS")
                                         ->setKeywords("BBVA - DROPOS")
                                         ->setCategory("Categoria General");

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'SELECCION')
                        ->setCellValue('B1', 'IDENTIFICACION')
                        ->setCellValue('C1', 'TIPO ID')
                        ->setCellValue('D1', 'DIGITO V')
                        ->setCellValue('E1', 'APELLIDOS Y NOMBRES')
                        ->setCellValue('F1', 'FORMA PAGO')
                        ->setCellValue('G1', 'BANCO')
                        ->setCellValue('H1', 'TIPO CUENTA')
                        ->setCellValue('I1', 'NO. CUENTA')
                        ->setCellValue('J1', 'MONTO');

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);

            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant = mysql_num_rows($result);
            $i = 2;
            while($row = mysql_fetch_array($result))
            {
                // documento
                $dni = $row['dni'];

                if(strlen($dni) == 1)           $dni = "'00000000000000".$dni;
                if(strlen($dni) == 2)           $dni = "'0000000000000".$dni;
                if(strlen($dni) == 3)           $dni = "'000000000000".$dni;
                if(strlen($dni) == 4)           $dni = "'00000000000".$dni;
                if(strlen($dni) == 5)           $dni = "'0000000000".$dni;
                if(strlen($dni) == 6)           $dni = "'000000000".$dni;
                if(strlen($dni) == 7)           $dni = "'00000000".$dni;
                if(strlen($dni) == 8)           $dni = "'0000000".$dni;
                if(strlen($dni) == 9)           $dni = "'000000".$dni;
                if(strlen($dni) == 10)          $dni = "'00000".$dni;
                if(strlen($dni) == 11)          $dni = "'0000".$dni;
                if(strlen($dni) == 12)          $dni = "'000".$dni;
                if(strlen($dni) == 13)          $dni = "'00".$dni;
                if(strlen($dni) == 14)          $dni = "'0".$dni;

                // código del banco
                $codbanco = "'00".$row['codbanco'];

                // tipo id
                $tipoid = "'".$row['tipoid'];

                // tipo cuenta
                $tipocuenta = "'".$row['tipocuenta'];

                // tipo de indentificación
                if($row['tipoidentificacion'] != "")
                    $tipoidentificacion = "'".$row['tipoidentificacion'];
                else
                    $tipoidentificacion = "";                

                // impresión del detalle
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $row['seleccion'])
                            ->setCellValue('B'.$i, $dni)
                            ->setCellValue('C'.$i, $tipoidentificacion)
                            ->setCellValue('D'.$i, $row['digitov'])
                            ->setCellValue('E'.$i, $row['nombre'])
                            ->setCellValue('F'.$i, $row['formadepago'])
                            ->setCellValue('G'.$i, $codbanco)
                            ->setCellValue('H'.$i, $tipocuenta)
                            ->setCellValue('I'.$i, $row['numcuenta'])
                            ->setCellValue('J'.$i, $row['valor']);
                $i++;
                $cant++;
            }

            $rangoEncabezado = 'A4:J4';
            $rangoCeldas     = 'A4:J'.($cant+1);
            // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
            
            // Formato de Encabezado y Celdas
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(20);

            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('BBVA');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Redirect output to a client’s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="'.$nombrearchivo.'"');
            header('Cache-Control: max-age=0');
            /// Genero la Salida
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            exit;
        }

        // opción para los bancos no desarrollados
        if(($bancoid != 1) && ($bancoid != 2) && ($bancoid != 3))
        {
            $clase->Aviso(2,"Esta opción está en construcción");
            header("Location: periodosnomina.php?opcion=arhivoexcel1&periodoid=$periodoid");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: versincuenta
    // Creación: 12/04/2024		última modificación: 19/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para visualizar los empleados sin cuenta 
    //              bancaria
    // Última modificación: Inclusión de la sección, el valor a pagar y el botón para 
    //                      descargar la hoja de Excel
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "versincuenta")
    {
        $periodoid = $_GET['periodoid'];

        $cont ='<table width="900">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Empleados sin cuenta bancaria </b> </td> 
                 </tr> 
                </table>
                <table width="900" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                   <td width="10" align="left"> &nbsp; </td> 
                   <td width="140" align="left"> Documento </td> 
                   <td width="80" align="left"> C&oacute;digo </td> 
                   <td width="280" align="left"> Nombre </td> 
                   <td width="170" align="left"> Banco </td>
                   <td width="170" align="left"> Secci&oacute;n </td>
                   <td width="100" align="right"> Valor </td>
                   <td width="25" align="right"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; height:500px; overflow-Y:scroll">';

        // consulta de la ventana
        $vsql= "SELECT ta.dni, ta.codvende, CONCAT(ta.primernombre,' ',ta.segundonombre,' ',ta.primerapellido,' ',ta.segundoapellido) AS nombre,  
                       b.descripcion banco, s.descripcionsec seccionempleado, 
                       (SELECT (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) 
                          FROM detallenomina d
                               INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                         WHERE d.terid = ta.terid
                               AND d.pernominaid = ".$periodoid.") valor  
                  FROM tercerosactual ta
                       INNER JOIN bancos b ON (ta.bancoid = b.bancoid)
                       INNER JOIN seccion s ON (ta.seccionid = s.seccionid)
                 WHERE ta.numcuenta = '' OR ta.numcuenta IS NULL
                       AND ta.extralegal <> 'CHECKED' 
              ORDER BY ta.bancoid";

        // impresión del detalle
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="10" align="left"> &nbsp; </td> 
                     <td width="140" align="left"> '.$row['dni'].' </td> 
                     <td width="80" align="left"> '.$row['codvende'].' </td> 
                     <td width="280" align="left"> '.$row['nombre'].' </td> 
                     <td width="170" align="left"> '.$row['banco'].' </td>
                     <td width="170" align="left"> '.$row['seccionempleado'].' </td>
                     <td width="100" align="right"> '.number_format($row['valor']).' </td>
                    </tr>';
        }

        $cont.=' </tbody> 
                </table>
                <table width="900"> <tr class="TituloTabla"> <td width="1608"> &nbsp; </td>  </tr> </table>
                <table width="900">
                 <center>
                 <br>
                 <a href="periodosnomina.php?opcion=arhivoexcel1&periodoid='.$periodoid.'">
                  <input type="button" value="aceptar" class="button blue">
                 </a>
                 &nbsp;
                 <a href="periodosnomina.php?opcion=descargarsincuenta&periodoid='.$periodoid.'">
                  <input type="button" value="descargar" class="button red">
                 </a>
                </table>';

        echo $cont; exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: versincuenta
    // Creación: 12/04/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para visualizar los empleados sin cuenta 
    //              bancaria
    // Última modificación: Opción que genera la hoja de Excel con la información de los 
    //                      empleados sin cuenta bancaria
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "descargarsincuenta")
    {
        $periodoid = $_GET['periodoid'];
        
        // nombre del periodo
        $descripcionperiodo = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // nombre de la hoja de excel
        $nombrearchivo = "empleados sin cuenta bancaria ".strtolower($descripcionperiodo).".xls";
        
        // consulta de la hoja de Excel
        $vsql= "SELECT ta.dni, ta.codvende, CONCAT(ta.primernombre,' ',ta.segundonombre,' ',ta.primerapellido,' ',ta.segundoapellido) AS nombre,  
                       b.descripcion banco, s.descripcionsec seccionempleado, 
                       (SELECT (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) 
                          FROM detallenomina d
                               INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                         WHERE d.terid = ta.terid
                               AND d.pernominaid = ".$periodoid.") valor  
                  FROM tercerosactual ta
                       INNER JOIN bancos b ON (ta.bancoid = b.bancoid)
                       INNER JOIN seccion s ON (ta.seccionid = s.seccionid)
                 WHERE ta.numcuenta = '' OR ta.numcuenta IS NULL
                       AND ta.extralegal <> 'CHECKED' 
              ORDER BY ta.bancoid";

        // Preparación del entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("sin cuenta bancaria - DROPOS")
                                     ->setSubject("sin cuenta bancaria - DROPOS")
                                     ->setDescription("sin cuenta bancaria - DROPOS")
                                     ->setKeywords("sin cuenta bancaria - DROPOS")
                                     ->setCategory("Categoria General");        

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'EMPLEADOS SIN CUENTA BANCARIA')
                    ->setCellValue('A2', $descripcionperiodo)
                    ->setCellValue('A4', 'DOCUMENTO')
                    ->setCellValue('B4', 'CODIGO')
                    ->setCellValue('C4', 'NOMBRE')
                    ->setCellValue('D4', 'BANCO')
                    ->setCellValue('E4', 'SECCION')
                    ->setCellValue('F4', 'VALOR');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);                    

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,5);
        
        $i = 5;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);        
        while($row = mysql_fetch_array($result))
        {
            $codvende = $row['codvende'];
            if(substr($codvende,0,1) == "0")
                $codvende="'".$codvende;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['dni'])
                        ->setCellValue('B'.$i, $codvende)
                        ->setCellValue('C'.$i, $row['nombre'])
                        ->setCellValue('D'.$i, $row['banco'])
                        ->setCellValue('E'.$i, $row['seccionempleado'])
                        ->setCellValue('F'.$i, number_format($row['valor']));
            $i++;
            $cant++;
        }

        $rangoEncabezado = 'A4:F4';
        $rangoCeldas     = 'A4:F'.($cant+1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(20);

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('sin cuenta');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$nombrearchivo.'"');
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }    

    ////////////////////////////////
    echo $cont.$clase->PiePagina();

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función comprasperiodo
    // Parámetro de entrada:    $terid     --> ID del empleado
    //                          $periodoid --> ID del periodo    
    // Valor de retorno:        $compra    --> Monto de la compra del empleado en el periodo 
    // Descripción: Función que determina el monto de compra a crédito de un empleado en un 
    //              periodo
    ////////////////////////////////////////////////////////////////////////////////////////      
    function comprasperiodo($terid,$periodoid)
    {
        $clase2 = new Sistema();

        // Obtengo la cédula de empleado y la fecha del de inicio del periodo
        $dni = $clase2->BDLockup($terid,'terceros','terid','dni');
        $fecdesde = $clase2->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');

        // Determino el mes de periodo
        $mesperiodo = date('m', strtotime($fecdesde));

        // Cálculo el mes anterior al periodo
        $mes = intval($mesperiodo);
        $mes--;
        $mesanterior = strval($mes);

        if(strlen($mesanterior)==1)
            $mesanterior = "0".$mesanterior;

        // Año actual
        $yeartoday = date("Y");

        // Construyo las fechas inicio y fin de la consulta
        $fechades = $yeartoday."-".$mesanterior."-20 00:00:00";
        $fechasta = $yeartoday."-".$mesperiodo."-20 23:59:59";

        // Consulta de la cual obtendremos la compra
        $vsql2 = "SELECT ROUND(SUM(devaltotal)) AS vrtotal  
                    FROM consolida1
                   WHERE tipodoc = 'FVE' 
                         AND formapagodoc = 'CR'
                         AND dniclidoc = '".$dni."'
                         AND fechadoc BETWEEN '".$fechades."' AND '".$fechasta."'";

        // Determino el monto de la compra
        $conex = $clase2->Conectar();
        $result2 = mysql_query($vsql2,$conex);
        $cant = mysql_num_rows($result2);

        if($cant>0)
            $compra = $clase2->SeleccionarUno($vsql2);
        else
            $compra = 0;

        return($compra);
    }    
?> 