<?PHP
    session_start(); 
    include("lib/Sistema.php");
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE']; 
    
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardareditado y guardarnuevo
    // Creación: 09/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opciones para validar y almacenar los cambios realizados a los fondos 
    //              de pensiones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if(($opcion == "guardareditado")||($opcion == "guardarnuevo"))
    {
        $pensionesid  = $_POST['pensionesid'];
        $codpensiones = $_POST['codpensiones'];
        $descripcionafp = strtoupper($_POST['descripcionafp']);

        // Valido que sean introducidos los datos necesarios
        if(($codpensiones == "")||($descripcionafp == ""))
        {
            $clase->Aviso(2,"El código y la descripción no pueden estar vacíos &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
            header("Location: pensiones.php");
            exit();
        }
        else
        {
            if($opcion == "guardarnuevo")
            {
                // Validación de que el código ya exista
                $vsqlx = "SELECT COUNT(codpensiones) FROM pensiones WHERE codpensiones ='".trim($codpensiones)."'";
                $valor = $clase->SeleccionarUno($vsqlx);

                if($valor>=1)
                {
                    $clase->Aviso(2,"El código <b> $codpensiones </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                    header("Location: pensiones.php");
                    exit();
                }
                else
                {
                    // Validación de la existencia de descripción de la AFP
                    $vsqlx = "SELECT COUNT(descripcionafp) FROM pensiones WHERE descripcionafp ='".trim($descripcionafp)."'";
                    $valor = $clase->SeleccionarUno($vsqlx);

                    if($valor>=1)
                    {
                        $clase->Aviso(3,"La descripción de la AFP ya existe, verifique por favor");
                        header("Location: pensiones.php");
                    }
                    else
                    {
                        // Almaceno la nueva EPS
                        $vsql = "INSERT INTO pensiones (codpensiones,descripcionafp)
                                        values ('".$codpensiones."','".$descripcionafp."')";
                        $cant = $clase->EjecutarSQL($vsql);

                        // valido que se almacenen los datos para emitir el mensaje correspondiente
                        if(mysql_affected_rows() < 1)
                            $clase->Aviso(3,"No se incluyó el fondo de pensiones");
                        else
                            $clase->Aviso(1,"Fondo de pensiones creado exitosamente");
                    }
                }
            }            

            if($opcion == "guardareditado")
            {
                // ---------------------------------------------------------------------------------------------- //
                // Proceso para validar si el código introducido ya existe
                $lb_codigodiferente=false;
                $lb_codigonuevoexiste=false;
                $valorcod = 0;

                $codnuevo = trim($codpensiones);
                $vsqly = "SELECT codpensiones FROM pensiones WHERE pensionesid=".$pensionesid;
                $codanterior = $clase->SeleccionarUno($vsqly);
                
                if($codnuevo!=$codanterior)
                    $lb_codigodiferente=true;

                if($lb_codigodiferente)
                {
                    // Validación de la existencia del código del concepto
                    $vsqlx = "SELECT COUNT(codpensiones) FROM pensiones WHERE codpensiones ='".$codnuevo."'";
                    $valorcod = $clase->SeleccionarUno($vsqlx);

                    if($valorcod>=1)
                        $lb_codigonuevoexiste=true;
                }

                // ---------------------------------------------------------------------------------------------- //
                if($lb_codigonuevoexiste)
                {
                    $clase->Aviso(2,"El código <b> $codpensiones </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                    header("Location: pensiones.php");
                    exit();
                }
                else
                {
                    // Proceso para validar si la descripción introducida ya existe
                    $lb_descripciondiferente=false;
                    $lb_descripcionnuevoexiste=false;
                    $valordes = 0;

                    $desnueva = trim($descripcionafp);
                    $vsqly = "SELECT descripcionafp FROM pensiones WHERE pensionesid=".$pensionesid;
                    $desanterior = $clase->SeleccionarUno($vsqly);
                    
                    if($desnueva!=$desanterior)
                        $lb_descripciondiferente=true;

                    if($lb_descripciondiferente)
                    {
                        // Validación de la existencia del código del periodo
                        $vsqlx = "SELECT COUNT(descripcionafp) FROM pensiones WHERE descripcionafp ='".$desnueva."'";
                        $valordes = $clase->SeleccionarUno($vsqlx);

                        if($valordes>=1)
                            $lb_descripcionnuevoexiste=true;
                    }
                    
                    if(($lb_descripciondiferente)&&($lb_descripcionnuevoexiste))
                    {
                        $clase->Aviso(2,"La descripción <b> $descripcionafp </b> ya existe &nbsp; <a href=\"javascript:history.back(-1);\"> click aquí para intentar de nuevo </a>");
                        header("Location: pensiones.php");
                        exit();
                    }
                    else
                    {
                        // Almaceno los cambios de la AFP
                        $vsql = "UPDATE pensiones SET
                                        codpensiones = '".$codpensiones."', 
                                        descripcionafp = '".$descripcionafp."'
                                WHERE pensionesid = ".$pensionesid;
                        $clase->EjecutarSQL($vsql);	
                        
                        // valido que se almacenen los datos para emitir el mensaje correspondiente
                        if(mysql_affected_rows() < 1)
                            $clase->Aviso(3,"No se modificó la AFP");
                        else
                            $clase->Aviso(1,"La AFP modificada exitosamente");
                    }
                }
            }		
        }	
        
        header("Location: pensiones.php");
    }
  
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 09/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción pinta la ventana para la inclusión de fondos de pensiones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevo")
    {
        $cont = $clase->Header("S","W"); ;  	 
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp;</td>
                  <td width="37"> <img src="images/iconos/cierreparcial.png" width="32" height="32" border="0"> </td>
                  <td width="840"> Nueva Administradora de Fondos de Pensiones <td>
                  <td align="right"><a href="pensiones.php"><input type="button" value="<<" class="button"></a></td>
                  <td width="8"> &nbsp; </td>
                 </tr>	 			   
                </table>';		
        
        $cont.='<br>
                <center>                
                <fieldset style="width: 530px; height: 200px;" class="grupos">
                <legend class="titgrupos"> Administradora de Fondos de Pensiones </legend>
                <form action="?opcion=guardarnuevo" method="POST">
                 <table width="200">
                  <tr height="55">
                   <td> <label class="Texto12"> <b> C&oacute;digo: </b></label><br>
                    <input type="text" autocomplete="off" name="codpensiones" class="Texto15" maxlength="10" size="10"> 
                   </td>
                  </tr>                 
                  <tr height="55"><td> <label class="Texto12"> <b> Descripci&oacute;n: </b></label>
                   <br>
                   <input type="text" autocomplete="off" name="descripcionafp" class="Texto15" maxlength="100" size="50"> </td>
                  </tr>
                  <tr height="55"><td align="center"><br><br> <input type="submit" value="crear AFP" class="button blue"> </td>
                  </tr>			                  
                 </table>
                </form>
                <br>
                <br>
                </fieldset>';  	
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detalles
    // Creación: 10/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción pinta la ventana para la modificación de los fondos de pensiones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "detalles")
    {
        $pensionesid = $_GET['pensionesid'];
        $cont = $clase->Header("S","W"); ;  	 
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cierreparcial.png" width="32" height="32" border="0"> </td>
                  <td width="750"> Modificar Administradora de Fondos de Pensiones <td>                
                  <td align="right"> <a href="pensiones.php?opcion=confirmacion&pensionesid='.$pensionesid.'" rel="facebox"><input type="button" value="eliminar" class="button red"></a></td>
                  <td> <a href="pensiones.php"><input type="button" value="<<" class="button"></a> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>	 			   
                </table>';		
        
        $vsql = "SELECT * FROM pensiones WHERE pensionesid=".$pensionesid;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);

        if($row = mysql_fetch_array($result))
        {
            $cont.='<br><br><br><center>
                    <form action="?opcion=guardareditado" method="POST">
                     <input type="hidden" name="pensionesid" value="'.$pensionesid.'">                    
                     <fieldset style="width: 530px; height: 220px;" class="grupos">
                     <legend class="titgrupos"> Modificar Administradora de Fondos de Pensiones </legend>
                     <table width="400">
                      <tr height="55"><td> <label class="Texto12"> <b>C&oacute;digo: </b></label><br>
                       <input type="text" autocomplete="off" name="codpensiones" class="Texto15"  maxlength="10" size="10" value="'.$row['codpensiones'].'"> </td>
                      </tr>
                      <tr height="55"><td> <label class="Texto12"> <b>Descripci&oacute;n: </b></label><br>
                       <input type="text" autocomplete="off" name="descripcionafp" class="Texto15"  maxlength="100" size="50" value="'.$row['descripcionafp'].'"> </td>
                      </tr>
                      <tr height="55"><td align="center"><br><br> <input type="submit" value="modificar AFP" class="button blue"> </td></tr>			
                     </table>
                    </form> 
                    <br><br>
                    </fieldset>'; 
        }
        mysql_free_result($result); 
        mysql_close($conex);			  
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: encontrar
    // Creación: 10/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para realizar una búsqueda de fondos de pensiones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT * 
                  FROM pensiones 
                 WHERE codpensiones like '%".$criterio."%' 
                       OR descripcionafp like '%".$criterio."%' 
              ORDER BY pensionesid ASC Limit 0,".$_SESSION["NUMREGISTROSXCONSULTA"];
        $_SESSION['SQL_AFP'] = $vsql;
        header("Location: pensiones.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 10/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que revierte los resultados de una búsqueda
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT * FROM pensiones ORDER BY pensionesid ASC limit 0,30";
        $_SESSION['SQL_AFP'] = "";
        header("Location: pensiones.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 09/09/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción pinta la ventana principal de formulario de pensiones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        if(($_SESSION["ROL"] == 'SAD')||($_SESSION["ROL"] == 'SUP'))
        {
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> </td>
                      <td width="37"> <img src="images/iconos/cierreparcial.png" width="32" height="32" border="0"> </td>
                      <td width="800"> <b>Administradoras de Fondos de Pensiones</b> <td>';

            // ------------------------------------------------------------------------------------------------------------------------ //
            /*
            $agregar = $clase->GetPermiso("EPS",$_SESSION['USERNAME'],"agregar");
            if(($agregar == "CHECKED")&&($_SESSION['G_MODOTRABAJO'] == 'SERVIDOR'))
                $cont.='<td width="24"> <a href="?opcion=nuevo"> <img src="images/basicas/icononuevo.png" border="0"> </a> </td>';
            */
            // ------------------------------------------------------------------------------------------------------------------------ //
            $cont.='<td width="24"> <a href="?opcion=nuevo"> <img src="images/basicas/icononuevo.png" border="0"> </a> </td>';
            // ------------------------------------------------------------------------------------------------------------------------ //
              
            //	$buscar = $clase->GetPermiso("PLANCUENTAS",$_SESSION['USERNAME'],"buscar");
            //	if($buscar == "CHECKED")
            //	{ 			 
            $cont.='<form action="?opcion=encontrar" method="POST" name="x">
                     <td> <input type="text" name="criterio" size="30" placeholder="Criterio a Buscar" tabindex="1" id="default"> </td>
                     <td> <input type="submit" value="Encontrar" class="button"></form> </td> ';
          
            if($_SESSION['SQL_AFP'] != "")
                $cont.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/basicas/nofiltro.png"> </a> </td>';           

            $cont.=' </form> 
                      <td width="8"> &nbsp; </td>
                     </tr>	 			   
                    </table> ';		
      
            if($_SESSION['SQL_AFP'] == "")
                $vsql = "SELECT * FROM pensiones ORDER BY pensionesid ASC";
            else
                $vsql = $_SESSION['SQL_AFP'];

            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                    <thead> 
                     <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;"> 
                      <td width="15"> &nbsp; </td>
                      <td width="150" align="left"> C&oacute;digo </td>				 
                      <td width="350" align="left"> Descripci&oacute;n </td>
                      <td width="150" align="left"> &nbsp; </td>			
                      <td width="350" align="left"> &nbsp; </td>		
                      <td width="50" align="left"> &nbsp; </td>	
                      <td width="45"> &nbsp; </td>
                      <td width="45"> &nbsp; </td>				 
                      <td width="45"> &nbsp; </td>
                     </tr>
                    </thead>
                    <tbody style="display:block; width:1050; height:690px; overflow-Y:scroll">';	
          
            $i = 0;      
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result)) 
            {
                $pensionesid =  $row['pensionesid'];

                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
                  
                $cont.=' <td width="15">&nbsp;</td>
                         <td width="140"> '.$row['codpensiones'].' </td>
                         <td width="360"> <b>'.$row['descripcionafp'].'</b> </td>
                         <td width="150"> &nbsp; </td>				  				  
                         <td width="350"> &nbsp; </td>	                         
                         <td width="30"> <a href="?opcion=confirmacion&pensionesid='.$row['pensionesid'].'" rel="facebox"><img src="images/basicas/iconoborrar.png" title="Eliminar" border="0"></a> </td>                         
                         <td width="35"> <a href="?opcion=detalles&pensionesid='.$pensionesid.'"> <img src="images/basicas/iconobuscar.png" border="0"> </td>
                        </tr>';
            }
        
            $cont.=' </tbody> 
                    </table> 
                    <br>';
            
            mysql_free_result($result); 
            mysql_close($conex);			  
        }
        else
        {
            $clase->Aviso(3,'No tiene permisos suficientes para realizar esta operación');	   	  
            header("Location: principal.php");
        }	      
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacion
    // Creación: 09/09/2020		última modificación: 18/09/2020
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para confirmar la eliminación de una AFP
    // Última modificación: Se incluyó la impresión de la descripción del fondo de pensiones
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacion")
    {
        $pensionesid = $_GET['pensionesid'];
        $descripcion  = $clase->BDLockup($pensionesid,'pensiones','pensionesid','descripcionafp');
        $cont='<table width="500">
                <tr class="CabezoteTabla"> 
                 <td align="center"><br><b>Eliminar AFP</b><br><br><td> 
                </tr> 
               </table>
               <table width="500">
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center">¿Confirma que desea eliminar la AFP<br><b> '.$descripcion.'</b>? <br></td>       
                </tr>
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center"><br><br>
                 <form action="?opcion=eliminar" method="POST">
                  <input type="hidden" name="pensionesid" value="'.$pensionesid.'">
                  <input type="submit" value="ACEPTAR" class="button red">
                   <a href="pensiones.php" ><input type="button" value="CANCELAR" class="button blue"></a>
                 </form>
                 <br>
                 </td>        
                </tr>
               </table><br>';		
        echo $cont; 
        exit();
    }  

    ///////////////////////////////////////////////////////////////////////////
    // Opción: eliminar
    // Creación: 09/09/2020     última modificación: 30/08/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para eliminar una AFP
    // Última modificación: Validación de la no eliminación del registro 
    //                      pensionado
    ///////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminar")
    {		  
        $pensionesid = $_POST['pensionesid'];
        $valor = 0;
        $descripcionafp = $clase->BDLockup($pensionesid,'pensiones','pensionesid','descripcionafp');

   	  	// Valido que la AFP no tenga empleados asociados a ella
        $vsqlx = "SELECT COUNT(pensionesid) FROM terceros WHERE pensionesid ='".$pensionesid."'";
        $valor = $clase->SeleccionarUno($vsqlx);
   
        if($valor>=1)
            $clase->Aviso(3,"No se puede eliminar la AFP $descripcionafp porque existen empleados asociados a ella");
        else
        {
            if($pensionesid==5)
                $clase->Aviso(3,"No se puede eliminar el registro PENSIONADO");
            else
                $vsql = "DELETE FROM pensiones WHERE pensionesid=".$pensionesid;
                $clase->EjecutarSQL($vsql);
                
                // valido que se almacenen los datos para emitir el mensaje correspondiente
                if(mysql_affected_rows() < 1)
                    $clase->Aviso(3,"No se eliminó la AFP $descripcionafp");
                else
                    $clase->Aviso(1,"La AFP $descripcionafp eliminada exitosamente");
        }

        header("Location: pensiones.php");
    }

    // ------------------------------------ //
    echo $cont.$clase->PiePagina();  
?> 