<?PHP
    @session_start(); 

    require_once("classes/class_validaciones.php");
    $io_fecha=new class_validaciones();

    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarporperiodo
    // Creación: 09/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que filtra por periodo la opción ventanaparametros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarporperiodo")
    {
        $codperiodo = $_POST['codperiodo'];        
        header("Location: parametroventa.php?opcion=ventanaparametros&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaparametros
    // Creación: 09/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana principal del crud de parámetros de venta
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaparametros")
    {
        $codperiodo = $_GET['codperiodo'];

        if(strlen($codperiodo) == 0)
            $codperiodo = date("m").date("Y");

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // detalle de la vista
        $det = '';

        // consulta de la vista
        $vsql = "SELECT P.idparametro, S.descripcion sucursal, P.parametro
                   FROM parametroventa P
                        INNER JOIN sucursales S ON (P.codsucursal = S.codigo) 
                  WHERE P.codperiodo = '".$codperiodo."' 
                ORDER BY S.sucursalid";

        // variable de sesión para la salida a Excel
        $_SESSION['SQL_PARAMETROSVTAXLS'] = $vsql;

        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);

        // validación de los parámetros
        if($cant == 0)
            $det.= '<table width="100%">
                     <tr class="BarraDocumentos" style="height:50px;Important!">
                      <td width="20"> &nbsp; </td>
                      <td width="750" align="center"> 
                       <h2> No existen par&aacute;metros de venta <br> en el periodo '.$desperiodo.' </h2>
                     </tr>
                    </table>
                    <table width="100%"> 
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                    </table>'; 
        else
        {
            $det.= '<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table id="fixTableV" class="sortable">
                     <tr class="TituloTabla">                      
                      <th width="600"> Sucursal </th>
                      <th width="120"> Par&aacute;metro </th>
                      <th width="30"> &nbsp; </th>
                      <th width="30"> &nbsp; </th>
                     </tr>';

            // imprimo el detalle
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $det.='<tr class="TablaDocsPar">';
                else
                    $det.='<tr class="TablaDocsImPar">';

                $det.=' <td width="600"> '.$row['sucursal'].' </td>
                        <td width="120"> '.number_format($row['parametro']).' </td>
                        <td width="30">
                         <a href="?opcion=editarparametro&idparametro='.$row['idparametro'].'" rel="facebox">
                          <img src="images/basicas/iconobuscar.png" border="0" width="24" height="24">
                         </a>
                        </td>
                        <td width="30">  
                         <a href="?opcion=confirmarelimparametro&idparametro='.$row['idparametro'].'" rel="facebox">
                          <img src="images/basicas/iconoborrar.png" title="eliminar par&aacute;metro" border="0" width="24" height="24">
                         </a>
                        </td>
                       </tr>';
            }
        }

        // valido que el archivo de mostrar errores exista
        $archivoerror = "reportes/erroresparametros.txt";
        if (file_exists ($archivoerror))
            $htmlarchivoerror = '<a href="?opcion=vererrores&codperiodo='.$codperiodo.'" rel="facebox">
                                  <img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&oacute;digos de excluidos no guardados en el &uacute;ltimo proceso de importaci&oacute;n">
                                 </a>';
        else
            $htmlarchivoerror = '<img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&oacute;digos de excluidos no guardados en el &uacute;ltimo proceso de importaci&oacute;n">';

        // Validación del botón de limpiar la lista de parámetros de un periodo y su botón para la salida a Excel
        $numprodexcl = $clase->SeleccionarUno("SELECT COUNT(*) numprodexcl FROM parametroventa WHERE codperiodo = '".$codperiodo."'");

        if($numprodexcl > 0)
        {
            $htmllimpiar = ' <a href="?opcion=confirmarlimpiar&codperiodo='.$codperiodo.'" rel="facebox">
                              <img src="images/iconos/anulardoc.png" border="0" width="32" height="32" title="limpiar toda la lista de par&aacute;metros">
                             </a>';
            $htmlsalidaxls = '<a href="?opcion=parametrosxls&codperiodo='.$codperiodo.'" target="_blank"> 
                               <img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32" title="exportar a una hoja de Excel"> 
                              </a>';
        }
        else
        {
            $htmllimpiar = '<img src="images/iconos/anulardoc.png" border="0" width="32" height="32" title="limpiar toda la lista de par&aacute;metros">';
            $htmlsalidaxls = '<img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32" title="exportar a una hoja de Excel">';
        }

        // combo de periodos
        $yeartoday = date("Y");
        $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." ORDER BY orden DESC";
        $params    = ' class="Texto11" style="width:140px;height:25px" OnChange="x.submit();"';

        // validación del botón para importar parámetros de periodo anterior
        $orden = $clase->BDLockup($codperiodo,'periodos','codperiodo','orden');
        $orden--;
        $codperanterior = $clase->SeleccionarUno("SELECT codperiodo FROM periodos WHERE orden = '".$orden."'");
        $cantidadperant = $clase->SeleccionarUno("SELECT COUNT(*) cantidadperant FROM parametroventa WHERE codperiodo = '".$codperanterior."'");

        if(($cant == 0) && ($cantidadperant > 0))
        {
            $desperiodoanterior = $clase->BDLockup($codperanterior,'periodos','codperiodo','desperiodo');
            $botonimportatperant = '<td width="30"> 
                                     <!-- <a href="?opcion=importarperiodoanterior&codperiodo='.$codperiodo.'&codperanterior='.$codperanterior.'" rel="facebox"> -->

                                     <a href="?opcion=confirmarimportacionant&codperiodo='.$codperiodo.'&codperanterior='.$codperanterior.'" rel="facebox">
                                      <img src="images/iconos/devoluciones.png" width="32" height="32" border="0" title="importar par&aacute;metros del periodo '.$desperiodoanterior.'">
                                     </a>                                    
                                    </td>
                                    <td width="10"> &nbsp; </td>';
        }
        else
            $botonimportatperant = '';        
        
        // pinto la ventana
        $cont = $clase->Header("S","W");

        // encabezado
        $cont.='<form action="?opcion=filtrarporperiodo" method="POST" name="x">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="20"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/analicostos.png" width="32" height="32" border="0"> </td> 
                  <td width="390"> <b> Par&aacute;metros de venta <br> <font color="blue"> '.$desperiodo.' </font> </b> </td>
                  <td width="280" align="right"> '.$clase->CrearComboEsp("codperiodo",$vsqlcombo,"codperiodo","nomperiodo",$codperiodo,"N",$params).' </form> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30">
                   <a href="?opcion=ventananuevoparametro&codperiodo='.$codperiodo.'" rel="facebox">
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="incluir un nuevo registro"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
		          <td width="30">
		           <a href="?opcion=importarexcel1&codperiodo='.$codperiodo.'" rel="facebox">
		            <img src="images/iconos/cargar.png" width="32" height="32" border="0" title="importar excluidos desde una hoja de Excel">
		           </a>
		          </td>
		          <td width="10"> &nbsp; </td>
				  <td width="30"> '.$htmlarchivoerror.' </td>
		          <td width="10"> &nbsp; </td>
				  <td width="30"> '.$htmllimpiar.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> '.$htmlsalidaxls.' </td>
				  <td width="10"> &nbsp; </td>
                  '.$botonimportatperant.'
                  <td width="20" align="center"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td> 
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>
                '.$det.'';

        echo $cont.$clase->PiePagina();
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventananuevoparametro
    // Creación: 09/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar los datos de la inclusión de
    //              un parámetro de venta
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventananuevoparametro")
    {
        $codperiodo = $_GET['codperiodo'];

        // preparación de los combos
        $params    = ' class="Texto11" style="width:140px;height:30px" ';
        $vsqlcombosucursal = "SELECT codigo , descripcion FROM sucursales WHERE 1 ORDER BY codigo ASC";
        $combosucursales = $clase->CrearComboBuscar("codigo",$vsqlcombosucursal,"descripcion","codigo","","n",$params,300);

        $yeartoday = date("Y");
        $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." ORDER BY orden DESC";
        $comboperiodo = $clase->CrearComboEsp("codperiodo",$vsqlcombo,"codperiodo","nomperiodo",$codperiodo,"N",$params);

        $parametro = 1;

		// pinto la ventana
		$cont ='<table width="500">
				 <tr class="CabezoteTabla">
				  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
				  <td width="450" align="center"> <b> Incluir Par&aacute;metro </b> <br> </td>
				 </tr> 
				</table>                
				<form action="?opcion=guardarnewparametro" method="POST" name="x">                
				<table width="500">				 
                 <tr class="BarraDocumentos" style="height:50px;Important!">                  
                  <td width="20"> &nbsp; </td> 
                  <td width="100" align="left"> <label class="Texto12"> Sucursal: </label> </td>
                  <td width="380" align="left"> '.$combosucursales.' </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">                  
                  <td width="20"> &nbsp; </td> 
                  <td width="100" align="left"> <label class="Texto12"> Periodo: </label> </td>
                  <td width="380" align="left"> '.$comboperiodo.' </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">                  
                  <td width="20"> &nbsp; </td> 
                  <td width="100" align="left"> <label class="Texto12"> Par&aacute;metro: </label> </td>
                  <td width="380" align="left"> <input type="number" name="parametro" class="Texto12New" size="12" min="1" style="width:140px;height:25px" value="'.$parametro.'"> </td>
                 </tr>
				</table>				
                <table width="500">
                 <tr class="BarraDocumentos" style="height:50px;Important!">                  
                  <td width="100" align="center"> 
                   <a href="?opcion=ventanaparametros&codperiodo='.$codperiodo.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
		echo $cont;
		exit();
    }   
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnewparametro
    // Creación: 09/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena un parámetro de venta
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnewparametro")
    {
        $codigo = $_POST['codigo'];
        $codperiodo = $_POST['codperiodo'];
        $parametro = $_POST['parametro'];

        // valido que el parámetro exista
        $numreg = $clase->SeleccionarUno("SELECT COUNT(*) numreg FROM parametroventa WHERE codsucursal = '".$codigo."' AND codperiodo = '".$codperiodo."'");

        if($numreg == 0)
        {
            $clase->EjecutarSQL("INSERT INTO parametroventa (codsucursal,codperiodo,parametro) VALUE ('".$codigo."','".$codperiodo."',".$parametro.")");
            $clase->Aviso(1,"Par&aacute;metro incluido satisfactoriamente");
        }
        else
        {
            // obtengo el id del registro
            $idparametro = $clase->SeleccionarUno("SELECT idparametro FROM parametroventa WHERE codsucursal = '".$codigo."' AND codperiodo = '".$codperiodo."'");

            $clase->EjecutarSQL("UPDATE parametroventa SET parametro = ".$parametro." WHERE idparametro = ".$idparametro."");
            $clase->Aviso(1,"Par&aacute;metro actualizado satisfactoriamente");
        }

        // redirecciono el formulario
        header("Location: parametroventa.php?opcion=ventanaparametros&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarelimparametro
    // Creación: 10/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación del parámetro
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarelimparametro")
    {
        $idparametro = $_GET['idparametro'];

        // obtengo los datos del registro
        $codsucursal = $clase->BDLockup($idparametro,'parametroventa','idparametro','codsucursal');
        $sucursal = $clase->BDLockup($codsucursal,'sucursales','codigo','descripcion');
        $codperiodo = $clase->BDLockup($idparametro,'parametroventa','idparametro','codperiodo');
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $parametro = $clase->BDLockup($idparametro,'parametroventa','idparametro','parametro');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar Par&aacute;metro </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="500" align="center">
                   <label class="Texto12"> ¿Confirma que desea eliminar el par&aacute;metro de la sucursal <br> <b> '.trim($sucursal).' </b> <br> en el periodo <br> <b> '.trim($desperiodo).' </b> 
                   <br> por un valor de <br> <b>'.number_format($parametro).'</b>? </label> 
                  </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">   
                  <td width="500" align="center">
                   <br>
                   <form action="?opcion=eliminarparametro" method="POST">
                   <input type="hidden" name="idparametro" value="'.$idparametro.'"> 
                   <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                   <a href="?opcion=ventanaparametros&codperiodo='.$codperiodo.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   <input type="submit" value="ACEPTAR" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarparametro
    // Creación: 10/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un parámetro de venta
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarparametro")
    {
        $idparametro = $_POST['idparametro'];
        $codperiodo = $_POST['codperiodo'];

        // elimino el registro
        $clase->EjecutarSQL("DELETE FROM parametroventa WHERE idparametro = ".$idparametro."");
        $clase->Aviso(1,"Par&aacute;metro eliminado satisfactoriamente");

        // redirecciono el formulario
        header("Location: parametroventa.php?opcion=ventanaparametros&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarparametro
    // Creación: 10/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para editar los datos de un parámetro
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarparametro")
    {
        $idparametro = $_GET['idparametro'];

        // obtengo los datos del registro
        $codsucursal = $clase->BDLockup($idparametro,'parametroventa','idparametro','codsucursal');
        $codperiodo = $clase->BDLockup($idparametro,'parametroventa','idparametro','codperiodo');
        $parametro = $clase->BDLockup($idparametro,'parametroventa','idparametro','parametro');

        // preparación de los combos
        $params    = ' class="Texto11" style="width:140px;height:30px" ';
        $vsqlcombosucursal = "SELECT codigo , descripcion FROM sucursales WHERE 1 ORDER BY codigo ASC";
        $combosucursales = $clase->CrearComboBuscar("codigo",$vsqlcombosucursal,"descripcion","codigo",$codsucursal,"N",$params,300);

        $yeartoday = date("Y");
        $vsqlcombo = "SELECT * FROM periodos WHERE anoperiodo = ".$yeartoday." ORDER BY orden DESC";
        $comboperiodo = $clase->CrearComboEsp("codperiodo",$vsqlcombo,"codperiodo","nomperiodo",$codperiodo,"N",$params);        

		// pinto la ventana
		$cont ='<table width="500">
				 <tr class="CabezoteTabla">
				  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
				  <td width="450" align="center"> <b> Incluir Par&aacute;metro </b> <br> </td>
				 </tr> 
				</table>                
				<form action="?opcion=guardarparametroeditado" method="POST" name="x">
                <input type="hidden" name="idparametro" value="'.$idparametro.'">
				<table width="500">				 
                 <tr class="BarraDocumentos" style="height:50px;Important!">                  
                  <td width="20"> &nbsp; </td> 
                  <td width="100" align="left"> <label class="Texto12"> Sucursal: </label> </td>
                  <td width="380" align="left"> '.$combosucursales.' </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">                  
                  <td width="20"> &nbsp; </td> 
                  <td width="100" align="left"> <label class="Texto12"> Periodo: </label> </td>
                  <td width="380" align="left"> '.$comboperiodo.' </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">                  
                  <td width="20"> &nbsp; </td> 
                  <td width="100" align="left"> <label class="Texto12"> Par&aacute;metro: </label> </td>
                  <td width="380" align="left"> <input type="number" name="parametro" class="Texto12New" size="12" min="1" style="width:140px;height:25px" value="'.$parametro.'"> </td>
                 </tr>
				</table>				
                <table width="500">
                 <tr class="BarraDocumentos" style="height:50px;Important!">                  
                  <td width="100" align="center"> 
                   <a href="?opcion=ventanaparametros&codperiodo='.$codperiodo.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
		echo $cont;
		exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarparametroeditado
    // Creación: 10/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que modifica los datos editados de un parámetro
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarparametroeditado")
    {
        $idparametro = $_POST['idparametro'];
        $codigo = $_POST['codigo'];
        $codperiodo = $_POST['codperiodo'];
        $parametro = $_POST['parametro'];

        // actualizo la información
        $clase->EjecutarSQL("UPDATE parametroventa SET codsucursal = '".$codigo."', codperiodo = '".$codperiodo."', parametro = ".$parametro." WHERE idparametro = ".$idparametro."");
        $clase->Aviso(1,"Par&aacute;metro actualizado satisfactoriamente");

        // redirecciono el formulario
        header("Location: parametroventa.php?opcion=ventanaparametros&codperiodo=$codperiodo");
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel1
    // Creación: 10/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel para subir 
    //              masivamente los parámetros de ventas
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel1")
    {
        $codperiodo = $_GET['codperiodo'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor dir&iacute;jase al servidor </font> <br>
                       <a href="http://192.168.14.248:9999/dropos/login/" target="_blank"> 
                        <font color=blue> 192.168.14.248:9999 </font> <br>                        
                       </a>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="parametroventa.php?opcion=ventanaparametros&codperiodo='.$codperiodo.'" id="theform" enctype="multipart/form-data">
                       <input type="submit" name="enviar" id="enviarr" value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
        else
        {
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar Par&aacute;metros de Venta</b> <br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="parametroventa.php?opcion=importarexcel2" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
    
			// Impresión de la imagen de ejemplo
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&oacute;digo de la sucursal </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: C&oacute;digo del periodo </td> </tr>
					 <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: P&aacute;rametro de venta </td> </tr>
                    </table>';
    
			// Botón de ejecutar
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> <img src="images/iconos/ejemploparametrosvta.png" width="320" height="190" border="0"> </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensi&oacute;n .xlsx </font> </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel2
    // Creación: 10/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que actualiza masivamente los parámetros de ventas mediante una
    //              hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel2")
    {
		set_time_limit(0);
		extract($_POST);
        $codperiodo = $_POST["codperiodo"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;
        
        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['codsucursal'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
					$_DATOS_EXCEL[$i]['codperiodonew'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
					$_DATOS_EXCEL[$i]['parametro'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['codsucursal']) == 0) || (strlen($_DATOS_EXCEL[$i]['codperiodonew']) == 0) || (strlen($_DATOS_EXCEL[$i]['parametro']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocodigos = 'PARAMETROS DE VENTA'.Chr(13).Chr(10);
            $nocodigos.= 'SUCURSALES NO GRABADAS:'.Chr(13).Chr(10);
            $nocodigos.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                // inicialización de variable
                $lbgrabo = false;
                $motivo = "";
                $lb_valido1 = false;
                $lb_valido2 = false;
                $lb_valido3 = false;
                $codperiodonewval = "";
                $numreg = 0;
                $idparametro = 0;

                // valido el formato de la sucursal
                $codsucursal = $_DATOS_EXCEL[$j]['codsucursal'];

                if(substr($codsucursal,0,1) == "'")
                    $codsucursal = substr($codsucursal,1,lenstr($codsucursal));

                $lb_valido1 = $io_fecha->uf_solo_numeros($codsucursal);

                if(!$lb_valido1)
                    $motivo = "Formato de la sucursal invalido";
                else
                {
                    // valido que la sucursal exista
                    $codigo = $clase->BDLockup($codsucursal,'sucursales','codigo','codigo');                    

                    if($codigo == "")
                        $motivo = "Sucursal no existe";
                    else
                    {
                        // valido el formato de la sucursal
                        $codperiodonew = $_DATOS_EXCEL[$j]['codperiodonew'];

                        if(substr($codperiodonew,0,1) == "'")
                            $codperiodonew = substr($codperiodonew,1,lenstr($codperiodonew));

                        $lb_valido2 = $io_fecha->uf_solo_numeros($codperiodonew);                        

                        if(!$lb_valido2)
                            $motivo = "Formato del periodo invalido";
                        else
                        {
                            // valido que el periodo exista
                            $codperiodonewval = $clase->BDLockup($codperiodonew,'periodos','codperiodo','codperiodo');                            

                            if($codperiodonewval == "")
                                $motivo = "Periodo no existe";
                            else
                            {
                                // valido el formato del parámetro
                                $parametro = $_DATOS_EXCEL[$j]['parametro'];
                                $lb_valido3 = $io_fecha->uf_solo_numeros($parametro);                                

                                if(!$lb_valido3)
                                    $motivo = "Formato del parámetro invalido";
                                else
                                {
                                    // verifico si el parámetro ya existe
                                    $numreg = $clase->SeleccionarUno("SELECT COUNT(*) numreg FROM parametroventa WHERE codsucursal = '".$codsucursal."' AND codperiodo = '".$codperiodonew."'");

                                    // echo $numreg; exit();

                                    if($numreg == 0)                                    
                                        $clase->EjecutarSQL("INSERT INTO parametroventa (codsucursal,codperiodo,parametro) VALUE ('".$codsucursal."','".$codperiodonew."',".$parametro.")");                                    
                                    else
                                    {
                                        // obtengo el id del registro
                                        $idparametro = $clase->SeleccionarUno("SELECT idparametro FROM parametroventa WHERE codsucursal = '".$codsucursal."' AND codperiodo = '".$codperiodonew."'");
                                        $clase->EjecutarSQL("UPDATE parametroventa SET parametro = ".$parametro." WHERE idparametro = ".$idparametro."");
                                    }

                                    if(mysql_affected_rows() >= 1)
                                    {
                                        $grabados++;
                                        $lbgrabo = true;
                                    }
                                }
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las códigos que no fueron grabados en este proceso
                if(($codsucursal != "") && ($codperiodonew != "") && ($motivo != "")) 
                {
                    $nocodigos.= str_pad($codsucursal,1,"").' -- '.str_pad($codperiodonew,1,"").' -- '.str_pad($motivo,1,"").Chr(13).Chr(10);           // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresparametros.txt";                                                                                                    // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                                                                                     // se abre el archivo para escribir
                    fwrite($fd, $nocodigos);                                                                                                            // Grabas
                    fclose($fd);                                                                                                                        // Cierras el archivo
                }
            }

            // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
            // Impresión de la fecha del último proceso ejecutado
            $mesimp = date('F');
            if($mesimp == "January")       $mesimp = "enero";
            if($mesimp == "February")      $mesimp = "febrero";
            if($mesimp == "March")         $mesimp = "marzo";
            if($mesimp == "April")         $mesimp = "abril";
            if($mesimp == "May")           $mesimp = "mayo";
            if($mesimp == "June")          $mesimp = "junio";
            if($mesimp == "July")          $mesimp = "julio";
            if($mesimp == "August")        $mesimp = "agosto";
            if($mesimp == "September")     $mesimp = "septiembre";
            if($mesimp == "October")       $mesimp = "octubre";
            if($mesimp == "November")      $mesimp = "noviembre";
            if($mesimp == "December")      $mesimp = "diciembre";

            $dayweek = date("l");
            if($dayweek == "Monday")       $dayweek = "lunes";
            if($dayweek == "Tuesday")      $dayweek = "martes";
            if($dayweek == "Wednesday")    $dayweek = "miércoles";
            if($dayweek == "Thursday")     $dayweek = "jueves";
            if($dayweek == "Friday")       $dayweek = "viernes";
            if($dayweek == "Saturday")     $dayweek = "sábado";
            if($dayweek == "Sunday")       $dayweek = "domingo";

            $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');

            $nocodigos.= ''.Chr(13).Chr(10);
            $nocodigos.= str_pad($fechoraimp,1,"").''.Chr(13).Chr(10);          // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresparametros.txt";                                 // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                     // se abre el archivo para escribir
            fwrite($fd, $nocodigos);                                            // Grabas
            fclose($fd);                                                        // Cierras el archivo
            // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los par&aacute;metros de ventas");
            else
                $clase->Aviso(1,"Se cargaron $grabados par&aacute;metros de ventas");
        }        

        // Redirecciona el formulario
        header("Location: parametroventa.php?opcion=ventanaparametros&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel2
    // Creación: 10/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que actualiza masivamente los parámetros de ventas mediante una
    //              hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererrores")
    {
        $codperiodo = $_GET['codperiodo'];

        // Inicialización de variables
        $archivoerror = "reportes/erroresparametros.txt";
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        $txt = trim(str_replace("<br />","",$txt));
        $txt = trim(str_replace(" --  -- Sucursal no existe","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Documentos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled>'.$txt.'</textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
				   <a href="?opcion=ventanaparametros&codperiodo='.$codperiodo.'"> <input type="button" value="aceptar" class="button blue"> </a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarlimpiar
    // Creación: 12/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para conformar la eliminación de todos los 
    //              parámetros de venta en un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiar")
    {
        $codperiodo = $_GET['codperiodo'];

        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $numprodexcl = $clase->SeleccionarUno("SELECT COUNT(*) numprodexcl FROM parametroventa WHERE codperiodo = '".$codperiodo."'");

        if($numprodexcl > 0)        
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                      <td width="350" align="center"> <br> <label class="Texto12"> <b> Eliminar Par&aacute;metros de Venta </b> </label> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar"> 
                      <td width="400" align="center">
                       <br>
                       <label class="Texto12">¿Confirma que desea eliminar <b> '.$numprodexcl.' </b> par&aacute;metros de venta <br> del periodo <b> '.$desperiodo.' </b>? </label> 
                      </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"><br><br> 
                       <form action="?opcion=limpiarparametrosvta" method="POST">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">                     
                       <a href="?opcion=ventanaparametros&codperiodo='.$codperiodo.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                       <input type="submit" value="ACEPTAR" class="button blue">                   
                       </form>
                      </td> 
                     </tr>
                    </table>';
        else
            $cont ='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>No existen registros</b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> No existen par&aacute;metros de venta en el periodo <b> '.$desperiodo.' </b> <br> </font><br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="parametroventa.php?opcion=ventanaparametros&codperiodo='.$codperiodo.'" id="theform" enctype="multipart/form-data">
                       <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';

        echo $cont;
        exit();        
    } 

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: limpiarparametrosvta
    // Creación: 12/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina los parámetros de venta de un periodo seleccionado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "limpiarparametrosvta")
    {
        $codperiodo = $_POST['codperiodo'];

        // obtengo el nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Elimino los parámetros de venta del periodo
        $clase->EjecutarSQL("DELETE FROM parametroventa WHERE codperiodo = '".$codperiodo."'");

        // Emito el mensaje correspondiente        
        $clase->Aviso(1,"Par&aacute;metro de venta eliminados satisfactoriamente del periodo <b> $desperiodo </b>");

        // Redirecciona el formulario
        header("Location: parametroventa.php?opcion=ventanaparametros&codperiodo=$codperiodo");
    }  

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: parametrosxls
    // Creación: 12/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite la salida a Excel del informe de parámetros de venta
    //              de un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "parametrosxls")
    {
        $codperiodo = $_GET['codperiodo'];

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');        

        // consulta del informe
        $vsql = $_SESSION['SQL_PARAMETROSVTAXLS'];

        // preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');

        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');

        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Parámetros de ventas - DROPOS")
                                     ->setSubject("Parámetros de ventas - DROPOS")
                                     ->setDescription("Parámetros de ventas - DROPOS")
                                     ->setKeywords("Parámetros de ventas - DROPOS")
                                     ->setCategory("Parámetros de ventas");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'PARÁMETROS DE VENTAS')
                    ->setCellValue('A2', $desperiodo)
                    ->setCellValue('A3', 'SUCURSAL')
                    ->setCellValue('B3', 'PARAMETRO');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);        

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        // Detalle del informe
        $i = 4;
        $numlinea = 1;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['sucursal'])
                        ->setCellValue('B'.$i, number_format($row['parametro']));
            $i++;
            $numlinea++;
        }

        $rangoEncabezado = 'A3:B3';
        $rangoCeldas     = 'A3:B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('parametros de ventas');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // -------------------------------------------------------------------------------------------- //
        $nombrearcexcel = "parametros de ventas ".strtolower($desperiodo).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // -------------------------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarimportacionant
    // Creación: 16/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la importación de los 
    //              parámetros de venta del periodo anterior
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarimportacionant")
    {
        $codperiodo = $_GET['codperiodo'];
        $codperanterior = $_GET['codperanterior'];
        
        // nombre de periodo anterior
        $desperiodoanterior = $clase->BDLockup($codperanterior,'periodos','codperiodo','desperiodo');

        // pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Importar Par&aacute;metros </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="500" align="center">
                   <label class="Texto12"> ¿Confirma que desea importar los par&aacute;metros de venta <br> del periodo <b>'.trim($desperiodoanterior).'</b>?  </label> 
                  </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">   
                  <td width="500" align="center">
                   <br>
                   <form action="?opcion=importarperiodoanterior" method="POST">
                   <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                   <input type="hidden" name="codperanterior" value="'.$codperanterior.'"> 
                   <a href="?opcion=ventanaparametros&codperiodo='.$codperiodo.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   <input type="submit" value="ACEPTAR" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarperiodoanterior
    // Creación: 16/05/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que realiza el proceso de importación de los parámetros de venta 
    //              del periodo anterior
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarperiodoanterior")
    {
        $codperiodo = $_POST['codperiodo'];
        $codperanterior = $_POST['codperanterior'];

        // importo los parámetros del periodo anterior
        $clase->EjecutarSQL("INSERT INTO parametroventa (codsucursal,codperiodo,parametro) SELECT codsucursal, '".$codperiodo."', parametro FROM parametroventa WHERE codperiodo = '".$codperanterior."'");

        // Emito el mensaje correspondiente        
        $clase->Aviso(1,"Par&aacute;metro de venta importados satisfactoriamente");        

        // redirecciono el formulario
        header("Location: parametroventa.php?opcion=ventanaparametros&codperiodo=$codperiodo");
    }

?>