<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmaraplicacion
    // Creación: 27/07/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción par conforma la aplicación de una pre novedad
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confirmaraplicacion")
    {
        $idnovedad  = $_GET['idnovedad'];

        // Nombre del empleado
        $terid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','terid');        

        if(strlen($terid) == 0)
            header("Location: novedades.php?filtro=TODAS");
        else
        {
            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid."";
            $nombreemp = $clase->SeleccionarUno($vsql);
    
            // Nombre de la novedad
            $conceptoid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','conceptoid');
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
    
            // Días de la novedad
            $dias = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','dias');
    
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <label class="Texto12"> <b> Aplicar una pre novedad </b> </label> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center">
                       <label class="Texto12">
                       ¿Confirma que desea aplicar la novedad <br><b> '.$nomconcepto.'</b><br> al empleado(a) <br><b> '.$nombreemp.'</b><br> por <b> '.$dias.'</b> d&iacute;a(s)?
                       </label>
                      </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"><br><br>
                       <form action="?opcion=aplicarnovedad" method="POST">
                       <input type="hidden" name="idnovedad" value="'.$idnovedad.'">                   
                       <input type="submit" value="ACEPTAR" class="button blue">
                       <a href="novedades.php" ><input type="button" value="CANCELAR" class="button red"></a>
                       </form>
                       <br>
                      </td>        
                     </tr>
                    </table>';
            echo $cont;
            exit();
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: aplicarnovedad
    // Creación: 27/07/2021		última modificación: 15/02/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que procesa la pre novedad y la convierte en novedad
    // Última modificación: Inclusión de los cálculos de transporte y seguridad social con 
    //                      los nuevos campos de la tabla cargos (20/08/2021)
    //                      Procesamiento de las novedades tanto antes como después del 
    //                      cálculo del periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "aplicarnovedad")
    {
        $idnovedad  = $_POST['idnovedad'];

        // Valido que la nómina esté calculada para poder procesar la novedad
        $pernominaid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','pernominaid');

        if(strlen($pernominaid) == 0)
            header("Location: novedades.php?filtro=TODAS");
        else
        {
            // Datos de la novedad
            $terid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','terid');
            $conceptoid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','conceptoid');
            $fecdesde = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','fechanov');
            $dias = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','dias');
            $periodoid = $pernominaid;
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado == "CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";
            
            // Valido que el empleado tenga datos en el periodo
            $vsql = "SELECT count(*) AS numregemp 
                       FROM detallenomina 
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid." 
                            AND conceptoid IN (1,3,4,5)";
            $numregemp = $clase->SeleccionarUno($vsql);

            if($numregemp == 0)
            {
                // Calculo el nuevo ID
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numid = $clase->SeleccionarUno($vsql);
                $numid++;

                // Inserto la nueva licencia

                // Obtengo la formula de la licencia
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                $formulalice = $clase->SeleccionarUno($vsql);

                $basico = $clase->BDLockup($terid,$tabla,'terid','basico');             // salario básico

                // Calculo la licencia
                if($conceptoid!=10)
                {
                    eval("\$montolicencia = $formulalice;");
                    $montolicencia = round($montolicencia,0);
                }
                else
                {
                    // Calculo la incapacidad

                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];

                    // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                    if($basico<=$smlv)
                    {
                        $montolicencia = ($smlv*$dias)/30;
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        $porcbasico = ($basico*66.67)/100;
                        $porcbasico = round($porcbasico,0);

                        // Calculo la incapacidad si el básico sea mayor al mínimo
                        if($porcbasico>$smlv)
                        {
                            $montolicencia = ($porcbasico*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                            if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                            $montolicencia = round($montolicencia,0);
                        }
                    }
                }

                // Obtengo el tipo de licencia
                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                if($tipodc=="C")
                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                else
                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";

                $clase->EjecutarSQL($vsql);
            }
            else
            {
                $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                $fecdesde2 = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                $fecdesde3 = $fecdesde;

                // inicialización de variables
                $difendias = 0;                         $basico = 0;                        $diastrab = 0;
                $detalleid = 0;                         $numid = 0;                         $formulabasico = "";
                $formulalice = "";                      $montolicencia = 0;                 $porcbasico = 0;
                $tipodc = "";                           $repetida = 0;                      $valor = 0;
                $descuentos = 0;                        $smlv = 0;                          $cargoid = 0;
                $aplicatransporte = "";                 $auxtrans = 0;                      $formulatransporte = "";
                $subsidiotransporte = 0;                $numreg = 0;                        $totnovedades = 0;
                $sueldodeducciones = 0;                 $sueldo = 0;                        $epsid = 0;
                $pensionesid = 0;                       $aplicapension = "";                $aplicasalud = "";
                $pension = 0;                           $salud = 0;                         $formulapension = "";
                $formulasalud = "";                     $idpension = 0;                     $idsalud = 0;
                $diaspendiente = 0;

                // días de la licencia
                $fecha1= new DateTime($fecdesde3);
                $fecha2= new DateTime($fechasta);
                $diff = $fecha1->diff($fecha2);
                
                $difendias = $diff->days;
                $difendias += 1;

                // ----------------------------------------------------------------------------------------------------------------------------- //
                $suma = "+".strval($dias-1)." day";
                $date_fin = strtotime(".$suma.", strtotime($fecdesde3));
                $date_fin = date('Y-m-d', $date_fin);

                if($date_fin > $fechasta)
                {
                    // Aquí guardo en la tabla correspondiente el exceso en días 
                    // para ser calculado en próximos periodos

                    $diaspendiente = $dias - $difendias;

                    // --------------------------------------------------------------------------------------------------------- //
                    $feciniper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                    $diadesde = substr($feciniper, -2);

                    if($diadesde=="16")
                    {
                        $fecfinper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                        $fechaEntera = strtotime($fecfinper);
                        $valdias = date("d", $fechaEntera);

                        if($valdias=="28")              $diaspendiente -= 2;
                        if($valdias=="29")              $diaspendiente -= 1;
                        if($valdias=="31")              $diaspendiente += 1;
                    }
                    // --------------------------------------------------------------------------------------------------------- //
                    $dias -= $diaspendiente;

                    $procesado = "";
                    $vsql = "SELECT periodoid 
                               FROM periodosnomina 
                              WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE periodoid > $periodoid)";
                    $periodoapagar = $clase->SeleccionarUno($vsql);

                    $vsql = "INSERT INTO licenciaspendiente (terid,conceptoid,dias,periodoapagar,procesado) 
                                                     VALUES (".$terid.",".$conceptoid.",".$diaspendiente.",".$periodoapagar.",'".$procesado."')";
                    $clase->EjecutarSQL($vsql);
                }
                // ----------------------------------------------------------------------------------------------------------------------------- //

                // Obtengo el salario básico del empleado
                $basico = $clase->BDLockup($terid,$tabla,'terid','basico');
    
                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
    
                // Obtengo los días trabajados en el periodo
                $vsql = "SELECT valor
                           FROM detallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $diastrab = $clase->SeleccionarUno($vsql);

                // Obtengo el ID del registro que se modificará
                $vsql = "SELECT detalleid
                           FROM detallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $detalleid = $clase->SeleccionarUno($vsql);

                $diastrab -= $dias;

                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
    
                // Almaceno en nuevo sueldo
                $vsql = "UPDATE detallenomina SET 
                                devengados = ".$sueldo.", 
                                valor = ".$diastrab."
                          WHERE detalleid = ".$detalleid."";
                $clase->EjecutarSQL($vsql);

                // Calculo el nuevo ID
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numid = $clase->SeleccionarUno($vsql);
                $numid++;

                // Inserto la nueva licencia

                // Obtengo la formula de la licencia
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                $formulalice = $clase->SeleccionarUno($vsql);

                // Calculo la licencia
                if($conceptoid!=10)
                {
                    eval("\$montolicencia = $formulalice;");
                    $montolicencia = round($montolicencia,0);
                }
                else
                {
                    // Calculo la incapacidad

                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];

                    // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                    if($basico<=$smlv)
                    {
                        $montolicencia = ($smlv*$dias)/30;
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        $porcbasico = ($basico*66.67)/100;
                        $porcbasico = round($porcbasico,0);

                        // Calculo la incapacidad si el básico sea mayor al mínimo
                        if($porcbasico>$smlv)
                        {
                            $montolicencia = ($porcbasico*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                            if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                            $montolicencia = round($montolicencia,0);
                        }
                    }
                }

                // Obtengo el tipo de licencia
                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                // ------------------------------------------------------------------------------------------------------------------- //
                // Determino si el registro existe para modificarlo o incluirlo
                $vsql = "SELECT COUNT(*) AS repetida 
                           FROM detallenomina
                          WHERE pernominaid = ".$periodoid."
                                AND conceptoid = ".$conceptoid."
                                AND terid = ".$terid."";
                $repetida = $clase->SeleccionarUno($vsql);

                if($repetida==0)
                {
                    if($tipodc=="C")
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                    else
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
                }
                else
                {
                    // Determino el id del registro
                    $vsql = "SELECT detalleid AS detalleid 
                               FROM detallenomina
                              WHERE pernominaid = ".$periodoid."
                                    AND conceptoid = ".$conceptoid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);

                    $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
                    $valor += $dias;

                    // Actualizo la licencia
                    if($tipodc=="C")
                    {
                        $devengados = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
                        $devengados += $montolicencia;
                        
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$devengados.", 
                                        valor = ".$valor."
                                  WHERE detalleid = ".$detalleid."";
                    }
                    else
                    {
                        $descuentos = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
                        $descuentos += $montolicencia;

                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$descuentos.", 
                                        valor = ".$valor."
                                  WHERE detalleid = ".$detalleid."";
                    }
                }
                $clase->EjecutarSQL($vsql);

                if(mysql_affected_rows() < 1)
                    $lbpaso = false;
                else
                    $lbpaso = true;

                if($lbpaso)
                {
                    // ---------------------------------------------------------------------------------------------------------- //
                    // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos

                    $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');                           // Obtengo el cargo del empleado
                    $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte

                    $smlv = $_SESSION['N_SALMIN2020'];
        
                    // Variable para la validación del auxilio de transporte
                    $valsubtrasp = $smlv * 2;
        
                    if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                    {
                        // Obtengo el ID del registro que se modificará
                        $vsql = "SELECT detalleid
                                   FROM detallenomina 
                                  WHERE conceptoid = 3  
                                        AND pernominaid = ".$periodoid."
                                        AND terid = ".$terid."";
                        $detalleid = $clase->SeleccionarUno($vsql);
        
                        // Obtengo la formula del subsidio de transporte
                        $auxtrans = $_SESSION['N_AUXTRANS2020'];
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                        $formulatransporte = $clase->SeleccionarUno($vsql);
        
                        eval("\$subsidiotransporte = $formulatransporte;");
                        $subsidiotransporte = round($subsidiotransporte,0);
                    }
                    else
                        $subsidiotransporte = 0;

                    // ID transporte
                    $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                    $idtransporte = $clase->SeleccionarUno($vsql);
            
                    // Grabo el subsidio de transporte
                    if($idtransporte!="")
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$subsidiotransporte.",
                                        valor = ".$diastrab."
                                  WHERE detalleid = ".$idtransporte."";
                    else
                    {
                        // Obtengo el valor del subsidio de transporte
                        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
            
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
            
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                    }
                    $clase->EjecutarSQL($vsql);

                    // ----------------------------------------------------------------------------------------------------------- //
                    // Ahora recalculo la pensión y la salud

                    // ----------------------------------------------------------------------------------------------------------- //
                    // Obtengo el total devengado por novedades
                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                    $totnovedades = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                            WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);
            
                    // Actualizo el sueldo
                    $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                    $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                    $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
                    $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
                    
                    if($epsid==NULL)                $epsid=0;
                    if($pensionesid==NULL)          $pensionesid=0;

                    $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                    $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

                    if($extralegal=="CHECKED")
                    {
                        $pension = 0;
                        $salud = 0;
                    }
                    else
                    {
                        // Recalculo pensión y salud
                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                            $pension = 0;
                        else
                        {
                            // Obtengo la formula para el descuento por pensión
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                            $formulapension = $clase->SeleccionarUno($vsql);
        
                            // Calculo la pensión
                            eval("\$pension = $formulapension;");
                            $pension = round($pension,0);
                        }
        
                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                            $salud = 0;
                        else
                        {
                            // Obtengo la formula para el descuento de salud
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                            $formulasalud = $clase->SeleccionarUno($vsql);
                            
                            // Calculo la salud
                            eval("\$salud = $formulasalud;");
                            $salud = round($salud,0);
                        }
                    }

                    //  ID pensión
                    $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                    $idpension = $clase->SeleccionarUno($vsql);
        
                    // Grabo la pensión
                    if($idpension!="")
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$pension.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idpension."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                    }
                    $clase->EjecutarSQL($vsql);

                    // ID salud
                    $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                    $idsalud = $clase->SeleccionarUno($vsql);
        
                    // Grabo la salud
                    if($idsalud!="")
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$salud.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idsalud."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                    }
                    $clase->EjecutarSQL($vsql);

                    // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                    $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid;
                    $clase->EjecutarSQL($vsql);
                }
            }

            // Actualizo el estatus en la tabla de pre novedades
            $estatus = "PROCESADA";

            $vsql = "UPDATE prenovedades SET 
                            estatus = '".$estatus."' 
                      WHERE idnovedad = ".$idnovedad."";
            $clase->EjecutarSQL($vsql);

            // Redirecciono el formulario
            $clase->Aviso(1,"Novedad procesada satisfactoriamente");
            header("Location: novedades.php");
            // --------------------------------------------------------------------------------------------------------------------------------------- //
        }
        // }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarnovedad
    // Creación: 28/07/2021		última modificación: 29/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para editar una pre novedad
    // Última modificación: Ajuste de la fecha de acuerdo a la configuración establecida
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarnovedad")
    {
        $idnovedad  = $_GET['idnovedad'];

        // Datos de la novedad
        $terid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','terid');

        if(strlen($terid) == 0)
            header("Location: novedades.php?filtro=TODAS");
        else
        {
            $conceptoid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','conceptoid');
            $pernominaid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','pernominaid');
            $fecdesde = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','fechanov');
            $dias = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','dias');
    
            $fecdesdeper = $clase->BDLockup($pernominaid,'periodosnomina','periodoid','fecdesde');
            $fechastaper = $clase->BDLockup($pernominaid,'periodosnomina','periodoid','fechasta');
    
            // Nombre del empleado
            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nomempleado FROM terceros WHERE terid = ".$terid;
            $nomempleado = $clase->SeleccionarUno($vsql);
    
            // Combo del concepto
            $params = ' class="Texto11" style="height: 40px;" ';
            $vsqlcombocconp = "SELECT conceptoid, nomconcepto FROM conceptosnomina WHERE eslicencia='CHECKED' ORDER BY conceptoid ASC";
            $comboconcepto  = $clase->CrearComboBuscar("conceptoid",$vsqlcombocconp,"nomconcepto","conceptoid",$conceptoid,"N",$params,270);

            // Validación de la fecha del movimiento
            $variab = 'G_NOFECHALIC';
            $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

            if($nofechalic != "CHECKED")
                $fechahtml = ' <tr class="TablaDocsImPar">
                                <td width="150" align="right"><label class="Texto12"> Fecha:</label> &nbsp; </td>
                                <td width="250">                  
                                 <input type="date" name="fecdesde" class="Texto12New" autocomplete="off" min="'.$fecdesdeper.'" max = "'.$fechastaper.'" value="'.$fecdesde.'">
                                </td>
                               </tr>';
            else
                $fechahtml = '<input type="hidden" name="fecdesde" value="'.$fecdesde.'">';
    
            $cont ='<table width="400">
                     <tr class="CabezoteTabla">
                      <td align="left"> <img src="images/iconos/notificaciones.png" width="32" height="32" border="0"> </td>
                      <td align="center"> <label class="Texto12"> <b> Editar y procesar novedad </b> </label> <br> </td>
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <label class="Texto12"> <font color="blue"> <b>'.$nomempleado.'</b> </font> </label> </td> 
                     </tr>
                    </table>
                    <form action="?opcion=guardarnovedad" method="POST" name="x">                
                    <input type="hidden" name="idnovedad" value="'.$idnovedad.'">
                    <input type="hidden" name="terid" value="'.$terid.'">
                    <input type="hidden" name="pernominaid" value="'.$pernominaid.'">
                    <table width="400">
                     <center>
                     <tr class="TablaDocsImPar">
                      <td width="150" align="right"><label class="Texto12"> Concepto: </label>&nbsp;</td>
                      <td width="250">'.$comboconcepto.'</td>
                     </tr>	
                      '.$fechahtml.'
                     <tr class="TablaDocsImPar">
                      <td width="150" align="right"> <label class="Texto12"> D&iacute;as:</label> &nbsp; </td>
                      <td width="250"> <input type="number" name="dias" class="Texto12New" style="width:60px;height:25px;" size="2" min="1" maxlength="2" autocomplete="off" value="'.$dias.'"> </td>
                     </tr>	
                    </table>
                    <br>
                    <center>
                    <input type="submit" value="aceptar" class="button blue">
                    <a href="novedades.php?filtro=TODAS"> <input type="button" value="CANCELAR" class="button red"> </a>
                    </form><br>';
            echo $cont;
            exit();
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnovedad
    // Creación: 28/07/2021		última modificación: 20/08/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que procesa una pre novedad previamente editada
    // Última modificación: Inclusión de los cálculos de transporte y seguridad social con 
    //                      los nuevos campos de la tabla cargos
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarnovedad")
    {
        $idnovedad = $_POST['idnovedad'];
        $terid  = $_POST['terid'];
        $conceptoid  = $_POST['conceptoid'];
        $pernominaid  = $_POST['pernominaid'];
        $fecdesde  = $_POST['fecdesde'];
        $dias  = $_POST['dias'];
        $periodoid = $pernominaid;

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado == "CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        // --------------------------------------------------------------------------------------------------------------------------------------- //
        // Guardo en la tabla de enlace las modificaciones realizadas
        $estatus = "PROCESADA";

        $vsql = "UPDATE prenovedades SET 
                        conceptoid = ".$conceptoid.",
                        pernominaid = ".$pernominaid.",
                        fechanov = '".$fecdesde."',
                        pernominaid = ".$pernominaid.",
                        dias = ".$dias.",
                        estatus = '".$estatus."'
                  WHERE idnovedad = ".$idnovedad."";
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() == 0)
        {
            $clase->Aviso(3,"No se actualizaron los datos ni se procesó la novedad");
            header("Location: novedades.php?filtro=TODAS");
        }
        else
        {
            // Determino si el empleado ya fue procesado en el periodo
            $vsql = "SELECT count(*) AS numregemp 
                       FROM detallenomina 
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid." 
                            AND conceptoid IN (1,3,4,5)";
            $numregemp = $clase->SeleccionarUno($vsql);

            if($numregemp == 0)
            {
                // Calculo el nuevo ID
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numid = $clase->SeleccionarUno($vsql);
                $numid++;

                // Inserto la nueva licencia

                // Obtengo la formula de la licencia
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                $formulalice = $clase->SeleccionarUno($vsql);

                $basico = $clase->BDLockup($terid,$tabla,'terid','basico');             // salario básico

                // Calculo la licencia
                if($conceptoid!=10)
                {
                    eval("\$montolicencia = $formulalice;");
                    $montolicencia = round($montolicencia,0);
                }
                else
                {
                    // Calculo la incapacidad

                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];

                    // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                    if($basico<=$smlv)
                    {
                        $montolicencia = ($smlv*$dias)/30;
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        $porcbasico = ($basico*66.67)/100;
                        $porcbasico = round($porcbasico,0);

                        // Calculo la incapacidad si el básico sea mayor al mínimo
                        if($porcbasico>$smlv)
                        {
                            $montolicencia = ($porcbasico*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                            if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                            $montolicencia = round($montolicencia,0);
                        }
                    }
                }

                // Obtengo el tipo de licencia
                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                if($tipodc=="C")
                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                else
                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";

                $clase->EjecutarSQL($vsql);
            }
            else
            {
                $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                $fecdesde2 = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                $fecdesde3 = $fecdesde;

                // inicialización de variables
                $difendias = 0;                         $basico = 0;                        $diastrab = 0;
                $detalleid = 0;                         $numid = 0;                         $formulabasico = "";
                $formulalice = "";                      $montolicencia = 0;                 $porcbasico = 0;
                $tipodc = "";                           $repetida = 0;                      $valor = 0;
                $descuentos = 0;                        $smlv = 0;                          $cargoid = 0;
                $aplicatransporte = "";                 $auxtrans = 0;                      $formulatransporte = "";
                $subsidiotransporte = 0;                $numreg = 0;                        $totnovedades = 0;
                $sueldodeducciones = 0;                 $sueldo = 0;                        $epsid = 0;
                $pensionesid = 0;                       $aplicapension = "";                $aplicasalud = "";
                $pension = 0;                           $salud = 0;                         $formulapension = "";
                $formulasalud = "";                     $idpension = 0;                     $idsalud = 0;
                $diaspendiente = 0;

                // días de la licencia
                $fecha1= new DateTime($fecdesde3);
                $fecha2= new DateTime($fechasta);
                $diff = $fecha1->diff($fecha2);
                
                $difendias = $diff->days;
                $difendias += 1;

                // ----------------------------------------------------------------------------------------------------------------------------- //
                $suma = "+".strval($dias-1)." day";
                $date_fin = strtotime(".$suma.", strtotime($fecdesde3));
                $date_fin = date('Y-m-d', $date_fin);

                if($date_fin > $fechasta)
                {
                    // Aquí guardo en la tabla correspondiente el exceso en días 
                    // para ser calculado en próximos periodos

                    $diaspendiente = $dias - $difendias;

                    // --------------------------------------------------------------------------------------------------------- //
                    $feciniper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                    $diadesde = substr($feciniper, -2);

                    if($diadesde=="16")
                    {
                        $fecfinper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                        $fechaEntera = strtotime($fecfinper);
                        $valdias = date("d", $fechaEntera);

                        if($valdias=="28")              $diaspendiente -= 2;
                        if($valdias=="29")              $diaspendiente -= 1;
                        if($valdias=="31")              $diaspendiente += 1;
                    }
                    // --------------------------------------------------------------------------------------------------------- //
                    $dias -= $diaspendiente;

                    $procesado = "";
                    $vsql = "SELECT periodoid 
                               FROM periodosnomina 
                              WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE periodoid > $periodoid)";
                    $periodoapagar = $clase->SeleccionarUno($vsql);

                    $vsql = "INSERT INTO licenciaspendiente (terid,conceptoid,dias,periodoapagar,procesado) 
                                                     VALUES (".$terid.",".$conceptoid.",".$diaspendiente.",".$periodoapagar.",'".$procesado."')";
                    $clase->EjecutarSQL($vsql);
                }
                // ----------------------------------------------------------------------------------------------------------------------------- //

                // Obtengo el salario básico del empleado
                $basico = $clase->BDLockup($terid,$tabla,'terid','basico');
    
                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
    
                // Obtengo los días trabajados en el periodo
                $vsql = "SELECT valor
                           FROM detallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $diastrab = $clase->SeleccionarUno($vsql);

                // Obtengo el ID del registro que se modificará
                $vsql = "SELECT detalleid
                           FROM detallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $detalleid = $clase->SeleccionarUno($vsql);

                $diastrab -= $dias;

                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
    
                // Almaceno en nuevo sueldo
                $vsql = "UPDATE detallenomina SET 
                                devengados = ".$sueldo.", 
                                valor = ".$diastrab."
                          WHERE detalleid = ".$detalleid."";
                $clase->EjecutarSQL($vsql);

                // Calculo el nuevo ID
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numid = $clase->SeleccionarUno($vsql);
                $numid++;

                // Inserto la nueva licencia

                // Obtengo la formula de la licencia
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                $formulalice = $clase->SeleccionarUno($vsql);

                // Calculo la licencia
                if($conceptoid!=10)
                {
                    eval("\$montolicencia = $formulalice;");
                    $montolicencia = round($montolicencia,0);
                }
                else
                {
                    // Calculo la incapacidad

                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];

                    // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                    if($basico<=$smlv)
                    {
                        $montolicencia = ($smlv*$dias)/30;
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        $porcbasico = ($basico*66.67)/100;
                        $porcbasico = round($porcbasico,0);

                        // Calculo la incapacidad si el básico sea mayor al mínimo
                        if($porcbasico>$smlv)
                        {
                            $montolicencia = ($porcbasico*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                            if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                            $montolicencia = round($montolicencia,0);
                        }
                    }
                }

                // Obtengo el tipo de licencia
                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                // ------------------------------------------------------------------------------------------------------------------- //
                // Determino si el registro existe para modificarlo o incluirlo
                $vsql = "SELECT COUNT(*) AS repetida 
                           FROM detallenomina
                          WHERE pernominaid = ".$periodoid."
                                AND conceptoid = ".$conceptoid."
                                AND terid = ".$terid."";
                $repetida = $clase->SeleccionarUno($vsql);

                if($repetida==0)
                {
                    if($tipodc=="C")
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                    else
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
                }
                else
                {
                    // Determino el id del registro
                    $vsql = "SELECT detalleid AS detalleid 
                               FROM detallenomina
                              WHERE pernominaid = ".$periodoid."
                                    AND conceptoid = ".$conceptoid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);

                    $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
                    $valor += $dias;

                    // Actualizo la licencia
                    if($tipodc=="C")
                    {
                        $devengados = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
                        $devengados += $montolicencia;
                        
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$devengados.", 
                                        valor = ".$valor."
                                  WHERE detalleid = ".$detalleid."";
                    }
                    else
                    {
                        $descuentos = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
                        $descuentos += $montolicencia;

                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$descuentos.", 
                                        valor = ".$valor."
                                  WHERE detalleid = ".$detalleid."";
                    }
                }
                $clase->EjecutarSQL($vsql);

                if(mysql_affected_rows() < 1)
                    $lbpaso = false;
                else
                    $lbpaso = true;

                if($lbpaso)
                {
                    // ---------------------------------------------------------------------------------------------------------- //
                    // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos

                    $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');                           // Obtengo el cargo del empleado
                    $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte

                    $smlv = $_SESSION['N_SALMIN2020'];
        
                    // Variable para la validación del auxilio de transporte
                    $valsubtrasp = $smlv * 2;
        
                    if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                    {
                        // Obtengo el ID del registro que se modificará
                        $vsql = "SELECT detalleid
                                   FROM detallenomina 
                                  WHERE conceptoid = 3  
                                        AND pernominaid = ".$periodoid."
                                        AND terid = ".$terid."";
                        $detalleid = $clase->SeleccionarUno($vsql);
        
                        // Obtengo la formula del subsidio de transporte
                        $auxtrans = $_SESSION['N_AUXTRANS2020'];
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                        $formulatransporte = $clase->SeleccionarUno($vsql);
        
                        eval("\$subsidiotransporte = $formulatransporte;");
                        $subsidiotransporte = round($subsidiotransporte,0);
                    }
                    else
                        $subsidiotransporte = 0;

                    // ID transporte
                    $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                    $idtransporte = $clase->SeleccionarUno($vsql);
            
                    // Grabo el subsidio de transporte
                    if($idtransporte!="")
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$subsidiotransporte.",
                                        valor = ".$diastrab."
                                  WHERE detalleid = ".$idtransporte."";
                    else
                    {
                        // Obtengo el valor del subsidio de transporte
                        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
            
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
            
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                    }
                    $clase->EjecutarSQL($vsql);

                    // ----------------------------------------------------------------------------------------------------------- //
                    // Ahora recalculo la pensión y la salud

                    // ----------------------------------------------------------------------------------------------------------- //
                    // Obtengo el total devengado por novedades
                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                    $totnovedades = $clase->SeleccionarUno($vsql);
                    
                    $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);
            
                    // Actualizo el sueldo
                    $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                    $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                    $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
                    $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
                    
                    if($epsid==NULL)                $epsid=0;
                    if($pensionesid==NULL)          $pensionesid=0;

                    $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                    $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

                    if($extralegal=="CHECKED")
                    {
                        $pension = 0;
                        $salud = 0;
                    }
                    else
                    {
                        // Recalculo pensión y salud
                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                            $pension = 0;
                        else
                        {
                            // Obtengo la formula para el descuento por pensión
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                            $formulapension = $clase->SeleccionarUno($vsql);
        
                            // Calculo la pensión
                            eval("\$pension = $formulapension;");
                            $pension = round($pension,0);
                        }
        
                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                            $salud = 0;
                        else
                        {
                            // Obtengo la formula para el descuento de salud
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                            $formulasalud = $clase->SeleccionarUno($vsql);
                            
                            // Calculo la salud
                            eval("\$salud = $formulasalud;");
                            $salud = round($salud,0);
                        }
                    }

                    //  ID pensión
                    $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                    $idpension = $clase->SeleccionarUno($vsql);
        
                    // Grabo la pensión
                    if($idpension!="")
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$pension.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idpension."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                    }
                    $clase->EjecutarSQL($vsql);

                    // ID salud
                    $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                    $idsalud = $clase->SeleccionarUno($vsql);
        
                    // Grabo la salud
                    if($idsalud!="")
                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$salud.",
                                        saldo = ".$sueldodeducciones."
                                  WHERE detalleid = ".$idsalud."";
                    else
                    {
                        $vsql = "SELECT max(detalleid) FROM detallenomina";
                        $numreg = $clase->SeleccionarUno($vsql);
        
                        $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                    }
                    $clase->EjecutarSQL($vsql);

                    // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                    $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid;
                    $clase->EjecutarSQL($vsql);

                    // Redirecciono el formulario
                    $clase->Aviso(1,"Novedad procesada satisfactoriamente");                    
                }
            }
            header("Location: novedades.php");
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarxtipo
    // Creación: 29/07/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que envía a la vista principal el filtro de las pre novedades
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarxtipo")
    {
        $filtro = $_POST['filtro'];
        $conceptoid = $_POST['conceptoid'];
        header("Location: novedades.php?filtro=$filtro&conceptoid=$conceptoid");        
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 26/07/2021		última modificación: 28/02/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para procesar las pre novedades
    // Última modificación: Combo para filtrar por estatus de la pre novedad (29/07/2021)
    //                      Validación del perfil de nómina para entrar al formulario
    //                      (15/02/2023)
    //                      Inclusión del recibo de pago en las novedades procesadas
    //                      (16/02/2023)
    //                      Validación del cálculo del periodo para emitir el recibo de pago
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        // Validación del perfil de nómina
        $vsql = "SELECT COUNT(*) AS valnomina 
                   FROM usuariosxgrupos 
                  WHERE nomusuario = '".$_SESSION['USERNAME']."' 
                        AND (nomgrupo LIKE '%NOMINA%' OR nomgrupo LIKE '%PERFILNOMINA%')";
        $valnomina = $clase->SeleccionarUno($vsql);

        if(($valnomina == 0) || ($_SESSION["SUPERUSUARIO"] != "CHECKED"))
        {
            $clase->Aviso(2,"No tiene permiso para acceder a este formulario");
            header("Location: principal.php");
        }
        else
        {
            $filtro  = $_GET['filtro'];
            
            if($filtro == "")
                header("Location: novedades.php?filtro=TODAS");

            $conceptoid = $_GET['conceptoid'];
    
            // Nombre del periodo
            $vsql = "SELECT periodoid 
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);
    
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            // Combo de licencias
            $vsqlcombolic = "SELECT conceptoid, nomconcepto FROM conceptosnomina WHERE eslicencia = 'CHECKED' ORDER BY conceptoid";
            $params = ' class="Texto11" style="width:180px;height:25px" OnChange="z.submit();"';
    
            // Pinto la ventana
            $cont = $clase->Header("S","W");
            $cont.='<form action="novedades.php?opcion=filtrarxtipo" method="POST" name="z">
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/terceros.png" width="32" height="32" border="0"> </td>
                      <td width="630"> <b> Pre novedades del periodo <font color="blue">'.$descripcion.'</font> </b> </td>
                      <td width="10" align="center"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="10" align="center"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="10" align="center"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                      <td width="140" align="right"> &nbsp; </td> 
                      <td width="20"> &nbsp; </td>
                     </tr>
                    </table>
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="10" align="center"> 
                       <a href="novedades.php?filtro=TODAS" title="refrescar la ventana"> 
                        <img src="images/iconos/refrescar.png" border="0" width="32" height="32"> 
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="10" align="center"> 
                       <a href="?opcion=prenovedadespdf&periodoid='.$periodoid.'" title="salida en pdf del informe de pre novedades" target="_blank"> 
                        <img src="images/iconos/exportarpdf2.png" border="0" width="32" height="32"> 
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="10" align="center"> 
                       <a href="?opcion=prenovedadesxls&periodoid='.$periodoid.'" title="salida en Excel del informe de pre novedades" target="_blank"> 
                        <img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32"> 
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="140" align="right"> 
                       <select class="Texto11" name="filtro" style="width:180px;height:25px"s OnChange="z.submit();">';
    
            // Combo del filtro de pre novedades
            if($filtro == "TODAS")
            {
                $cont.='<option value="TODAS" selected>';
                $wherex =" AND p.estatus LIKE '%%' ";
            }
            else
                $cont.='<option value="TODAS">';
                
            $cont.='Ver todas las pre novedades </option>';
    
            if($filtro == "PENDI")
            {
                $cont.='<option value="PENDI" selected>';
                $wherex =" AND p.estatus ='PENDIENTE' ";
            }
            else
                $cont.='<option value="PENDI">';
                
            $cont.='Solo novedades pendientes </option>';

            // filtro del concepto
            if(strlen($conceptoid) > 0)
                $wherex.= " AND p.conceptoid = ".$conceptoid." ";

            $cont.='   </select>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="140" align="right"> 
                       '.$clase->CrearComboEsp("conceptoid",$vsqlcombolic,"codconcepto","nomconcepto",$conceptoid,"S",$params).'
                       </form>
                      </td>
                      <td width="517"> &nbsp; </td>
                      <td width="20"> &nbsp; </td>
                     </tr>
                    </table>';

            // Validación de la fecha del movimiento
            $variab = 'G_NOFECHALIC';
            $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

            if($nofechalic != "CHECKED")
                $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                        <table width="100%" class="sortable">
                         <thead> 
                          <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                           <td width="20"> &nbsp; </td>
                           <td width="295" align="left"> Nombre </td>
                           <td width="210" align="left"> Secci&oacute;n </td>
                           <td width="210" align="left"> Concepto </td>	
                           <td width="82" align="left"> Fecha inicio </td>
                           <td width="50" align="center"> D&iacute;as </td>
                           <td width="98" align="center"> Estatus </td>
                           <td width="32"> &nbsp; </td>
                           <td width="33"> &nbsp; </td>
                          </tr>
                         </thead>
                         <tbody style="display:block; width:1050px; height:560px; overflow-Y:scroll">';
            else
                $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                        <table width="100%" class="sortable">
                         <thead> 
                          <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                           <td width="20"> &nbsp; </td>
                           <td width="295" align="left"> Nombre </td>
                           <td width="210" align="left"> Secci&oacute;n </td>
                           <td width="292" align="left"> Concepto </td>
                           <td width="50" align="center"> D&iacute;as </td>
                           <td width="98" align="center"> Estatus </td>
                           <td width="32"> &nbsp; </td>
                           <td width="33"> &nbsp; </td>
                          </tr>
                         </thead>
                        <tbody style="display:block; width:1050px; height:560px; overflow-Y:scroll">';

            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado == "CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";
    
            // Consulta para procesar las pre novedades
            $vsql = "SELECT CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombre, 
                            c.nomconcepto AS concepto, p.fechanov AS fecha, p.dias, p.idnovedad, sc.descripcionsec, 
                            p.estatus, t.dni, p.pernominaid, p.conceptoid, p.terid, t.dni 
                       FROM prenovedades p 
                            INNER JOIN conceptosnomina c ON (p.conceptoid = c.conceptoid) 
                            INNER JOIN ".$tabla." t ON (p.terid = t.terid) 
                            INNER JOIN seccionterceros s ON (t.terid = s.terid) 
                            INNER JOIN seccion sc ON (s.seccionid = sc.seccionid) 
                      WHERE p.pernominaid = ".$periodoid." ";
            $vsql.= $wherex;
            $vsql.= " ORDER BY t.seccionid, t.primernombre, t.primerapellido";
    
            $i = 0;
            $nropendiente = 0;
            $nroprocesadas = 0;
            $conex  = $clase->Conectar();
            $result = @mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
    
                $dias = number_format($row['dias']);
                $fecha = substr($row['fecha'],8,2)."/".substr($row['fecha'],5,2)."/".substr($row['fecha'],0,4);
    
                if($row['estatus'] == "PENDIENTE")
                {
                    $estatus = '<font color="Red">PENDIENTE</font>';
                    $nropendiente++;
                }
    
                if($row['estatus'] == "PROCESADA")
                {
                    $estatus = '<font color="Green">PROCESADA</font>';
                    $nroprocesadas++;
                }
    
                if($nofechalic != "CHECKED")
                    $cont.=' <td width="20">&nbsp; </td>
                             <td width="300" align="left"> 
                              <b> '.substr($row['nombre'],0,37).' </b>
                              <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                             </td>
                             <td width="210" align="left"> '.$row['descripcionsec'].' </td>
                             <td width="210" align="left"> '.$row['concepto'].' </td>
                             <td width="77" align="left"> '.$fecha.' </td>
                             <td width="50" align="center"> '.$dias.' </td> 
                             <td width="98" align="center"> '.$estatus.' </td>';
                else
                    $cont.=' <td width="20">&nbsp; </td>
                             <td width="300" align="left"> 
                              <b> '.substr($row['nombre'],0,37).' </b>
                              <br> c&eacute;dula: <span> <font color="#CC66FF"> '.$row['dni'].' </font> </span>
                             </td>
                             <td width="210" align="left"> '.$row['descripcionsec'].' </td>
                             <td width="287" align="left"> '.$row['concepto'].' </td>
                             <td width="50" align="center"> '.$dias.' </td> 
                             <td width="98" align="center"> '.$estatus.' </td>';

                if($row['estatus'] == "PENDIENTE")
                    $cont.=' <td width="25" align="center"> 
                              <a href="?opcion=confirmacion&idnovedad='.$row['idnovedad'].'&idlider='.$idlider.'" rel="facebox">
                               <img src="images/basicas/iconoborrar.png" title="eliminar pre novedad" border="0">
                              </a> 
                             </td> 
                             <td width="25" align="center"> 
                              <a href="?opcion=confirmaraplicacion&idnovedad='.$row['idnovedad'].'" rel="facebox">
                               <img src="images/basicas/actualizar.png" title="aplicar pre novedad" border="0">
                              </a> 
                             </td>
                             <td width="25" align="center"> 
                              <a href="?opcion=editarnovedad&idnovedad='.$row['idnovedad'].'" rel="facebox">
                               <img src="images/basicas/iconobuscar.png" title="editar y aplicar" border="0">
                              </a> 
                             </td>
                            </tr>';

                if($row['estatus'] == "PROCESADA")
                {
                    $calculado = $clase->BDLockup($row['pernominaid'],'periodosnomina','periodoid','calculado');

                    if($calculado == "CHECKED")
                        $vrecibo = '<a href="recibodepago.php?opcion=negativo&periodoid='.$row['pernominaid'].'&dni='.$row['dni'].'" target="_blank">
                                     <img src="images/basicas/pdf.png" title="recibo de pago" border="0">
                                    </a>';
                    else
                        $vrecibo = '<a href="?opcion=nocalculado&periodoid='.$row['pernominaid'].'" rel="facebox"> 
                                     <img src="images/basicas/pdf.png" title="periodo no calculado" border="0">
                                    </a>';

                    $cont.=' <td width="25" align="center"> &nbsp; </td>
                             <td width="25" align="center">
                              <a href="?opcion=confirmareversar&periodoid='.$row['pernominaid'].'&terid='.$row['terid'].'&conceptoid='.$row['conceptoid'].'&idnovedad='.$row['idnovedad'].'" rel="facebox">
                               <img src="images/basicas/reconciliar.png" title="reversar novedad" border="0">
                              </a>
                             </td>
                             <td width="25" align="center"> '.$vrecibo.' </td>
                            </tr>';
                }
            }
    
            $cont.=' </tbody>
                    </table>';
    
            // Totales
            if($filtro == "TODAS")
                $cont.='<table width="100%">
                         <tr class="TituloTabla"> 
                          <td width="30"> &nbsp; </td>
                          <td width="321"> <font color="WHITE"> <b>Totales</b> </font> </td>
                          <td width="295" align="right"> <font color="WHITE"> <b> Novedades: </b> '.number_format($nropendiente+$nroprocesadas).' </font> </td>
                          <td width="295" align="right"> <font color="WHITE"> <b> Pendientes: </b> '.number_format($nropendiente).' </font> </td>
                          <td width="295" align="right"> <font color="WHITE"> <b> Procesadas: </b> '.number_format($nroprocesadas).' </font> </td>
                          <td width="402"> &nbsp; </td>
                         </tr>
                        </table>';
            else
                $cont.='<table width="100%">
                         <tr class="TituloTabla"> 
                          <td width="30"> &nbsp; </td>
                          <td width="321"> <font color="WHITE"> <b>Total</b> </font> </td>
                          <td width="295" align="right"> <font color="WHITE"> <b> Pendientes: </b> '.number_format($nropendiente).' </font> </td>
                          <td width="295" align="right"> &nbsp; </td>
                          <td width="295" align="right"> &nbsp; </td>
                          <td width="402"> &nbsp; </td>
                         </tr>
                        </table>';

            // Botón para aplicar todas las pre novedades
            $vsql2 = "SELECT COUNT(*) AS numpendiente FROM prenovedades WHERE pernominaid = ".$periodoid." AND estatus = 'PENDIENTE' ";

            if(strlen($conceptoid) > 0)
                $vsql2.= " AND conceptoid = ".$conceptoid;

            $numpendiente = $clase->SeleccionarUno($vsql2);
            
            if($numpendiente > 0)
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td align="center">
                           <br>
                           <a href="?opcion=confirmaraplicatodos&periodoid='.$periodoid.'&conceptoid='.$conceptoid.'" rel="facebox">
                            <input type="button" value="APLICAR TODOS" class="button blue">
                           </a> 
                          </td>
                         </tr>
                        </table>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmaraplicatodos
    // Creación: 17/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que confirma el procesamiento de todas las pre novedades 
    //              pendientes
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmaraplicatodos")
    {
        $periodoid  = $_GET['periodoid'];
        $conceptoid  = $_GET['conceptoid'];

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $vsql = "SELECT COUNT(*) AS numpendiente 
                  FROM prenovedades 
                 WHERE pernominaid = ".$periodoid." 
                       AND estatus = 'PENDIENTE' ";

        if(strlen($conceptoid) > 0)
        {
            $vsql.= " AND conceptoid = ".$conceptoid." ";
            $lbtieneconcepto = true;
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        }
        else
            $lbtieneconcepto = false;
                
        $numpendiente = $clase->SeleccionarUno($vsql);

        // Validación de pre novedades pendientes
        if($numpendiente == 0)
        {
            if($lbtieneconcepto)
                $cont.='<table width="400">
                         <tr class="CabezoteTabla"> 
                          <td align="center"> <font color="red"><label class="Texto12"><b>Imposible procesar pre novedades</b></font></label></td>
                         </tr> 
                         <tr class="CabezoteTabla"> 
                          <td align="center"> 
                           <label class="Texto12">
                           No existen pre novedades <br>'.$nomconcepto.' <br>pendientes en el periodo <br><font color="BLUE">'.$descripcion.'</font>
                           </label>
                           <br><br><br>
                          </td> 
                         </tr>
                         <tr class="TablaDocsPar">        
                          <td width="100%" align="center"> 
                           <form name="importa" method="post" action="novedades.php?filtro=TODAS" id="theform" enctype="multipart/form-data">
                           <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                           </form> 
                          </td>    
                         </tr>
                        </table>';
            else
                $cont.='<table width="400">
                         <tr class="CabezoteTabla"> 
                          <td align="center"> <label class="Texto12"><font color="red"><b>Imposible procesar pre novedades</b></font></label></td>
                         </tr> 
                         <tr class="CabezoteTabla"> 
                          <td align="center"> 
                           <label class="Texto12">
                           No existen pre novedades pendientes en el periodo <br><font color="BLUE">'.$descripcion.'</font>
                           </label>
                           <br><br><br>
                          </td> 
                         </tr>
                         <tr class="TablaDocsPar">        
                          <td width="100%" align="center"> 
                           <form name="importa" method="post" action="novedades.php?filtro=TODAS" id="theform" enctype="multipart/form-data">
                           <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                           </form> 
                          </td>    
                         </tr>
                        </table>';
        }
        else
        {
            if($lbtieneconcepto)
                $cont.='<table width="600">
                         <tr class="CabezoteTabla"> 
                          <td align="center"> <label class="Texto12"><b>Confirmaci&oacute;n de aplicación de pre novedades</b></label></td>
                         </tr> 
                         <tr class="CabezoteTabla"> 
                          <td align="center"> 
                           <label class="Texto12">
                           ¿est&aacute; seguro que desea procesar '.$numpendiente.' '.$nomconcepto.' pendientes del periodo <br><font color="BLUE">'.$descripcion.'</font>?
                           </label>
                           <br><br>
                          </td> 
                         </tr>
                         <tr class="TablaDocsPar">        
                          <td width="100%" align="center"> 
                           <form action="?opcion=aplicartodas" name="y" method="POST">
                           <input type="hidden" name="periodoid" value="'.$periodoid.'">
                           <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                           <input type="submit" value="aceptar" class="button blue">
                           <a href="novedades.php?filtro=TODAS"><input type="button" value="CANCELAR" class="button red"></a>
                           </form> 
                          </td>    
                         </tr>
                        </table>';
            else
                $cont.='<table width="600">
                         <tr class="CabezoteTabla"> 
                          <td align="center"><label class="Texto12"> <b>Confirmaci&oacute;n de aplicación de pre novedades</b></label></td>
                         </tr> 
                         <tr class="CabezoteTabla"> 
                          <td align="center">
                           <label class="Texto12"> 
                           ¿est&aacute; seguro que desea procesar '.$numpendiente.' pre novedades pendientes del periodo <br><font color="BLUE">'.$descripcion.'</font>?
                           </label>
                           <br><br>
                          </td> 
                         </tr>
                         <tr class="TablaDocsPar">        
                          <td width="100%" align="center"> 
                           <form action="?opcion=aplicartodas" name="y" method="POST">
                           <input type="hidden" name="periodoid" value="'.$periodoid.'">
                           <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                           <input type="submit" value="aceptar" class="button blue">
                           <a href="novedades.php?filtro=TODAS"><input type="button" value="CANCELAR" class="button red"></a>
                           </form> 
                          </td>    
                         </tr>
                        </table>';
        }
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: aplicartodas
    // Creación: 17/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que procesa todas las pre novedades con estatus pendiente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "aplicartodas")
    {
        $periodoid  = $_POST['periodoid'];
        $conceptoid  = $_POST['conceptoid'];

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $vsql4 = "SELECT COUNT(*) AS numpendiente 
                    FROM prenovedades 
                   WHERE pernominaid = ".$periodoid." 
                         AND estatus = 'PENDIENTE' ";

        if(strlen($conceptoid) > 0)
            $vsql4.= " AND conceptoid = ".$conceptoid." ";

        $numpendiente = $clase->SeleccionarUno($vsql4);

        // Validación de pre novedades pendientes
        if($numpendiente == 0)
            $clase->Aviso(3,"No existen pre novedades pendientes en el periodo $descripcion");
        else
        {
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado == "CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            $vsql5 = "SELECT idnovedad, terid, conceptoid, fechanov, dias 
                        FROM prenovedades 
                       WHERE pernominaid = ".$periodoid." 
                             AND estatus = 'PENDIENTE' ";

            if(strlen($conceptoid) > 0)
                $vsql5.= " AND conceptoid = ".$conceptoid." ";

            $conex  = $clase->Conectar();
            $result = @mysql_query($vsql5,$conex);
            while($row = mysql_fetch_array($result))
            {
                $terid = $row['terid'];
                $conceptoid = $row['conceptoid'];
                $fecdesde = $row['fechanov'];
                $dias = $row['dias'];
                $idnovedad = $row['idnovedad'];

                // Determino si el empleado ya fue procesado en el periodo
                $vsql6 = "SELECT count(*) AS numregemp 
                            FROM detallenomina 
                           WHERE terid = ".$terid." 
                                 AND pernominaid = ".$periodoid." 
                                 AND conceptoid IN (1,3,4,5)";
                $numregemp = $clase->SeleccionarUno($vsql6);

                if($numregemp == 0)
                {
                    // Calculo el nuevo ID
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numid = $clase->SeleccionarUno($vsql);
                    $numid++;

                    // Inserto la nueva licencia

                    // Obtengo la formula de la licencia
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                    $formulalice = $clase->SeleccionarUno($vsql);

                    $basico = $clase->BDLockup($terid,$tabla,'terid','basico');             // salario básico

                    // Calculo la licencia
                    if($conceptoid!=10)
                    {
                        eval("\$montolicencia = $formulalice;");
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        // Calculo la incapacidad

                        // Obtengo el salario mínimo legal vigente
                        $smlv = $_SESSION['N_SALMIN2020'];

                        // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                        if($basico<=$smlv)
                        {
                            $montolicencia = ($smlv*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            $porcbasico = ($basico*66.67)/100;
                            $porcbasico = round($porcbasico,0);

                            // Calculo la incapacidad si el básico sea mayor al mínimo
                            if($porcbasico>$smlv)
                            {
                                $montolicencia = ($porcbasico*$dias)/30;
                                $montolicencia = round($montolicencia,0);
                            }
                            else
                            {
                                if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                                $montolicencia = round($montolicencia,0);
                            }
                        }
                    }

                    // Obtengo el tipo de licencia
                    $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                    if($tipodc=="C")
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                    else
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";

                    $clase->EjecutarSQL($vsql);

                    // Actualizo en la tabla de pre novedades
                    $estatus = "PROCESADA";

                    $vsql7 = "UPDATE prenovedades SET 
                                     estatus = '".$estatus."'
                               WHERE idnovedad = ".$idnovedad."";
                    $clase->EjecutarSQL($vsql7);
                }
                else
                {
                    $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                    $fecdesde2 = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                    $fecdesde3 = $fecdesde;
    
                    // inicialización de variables
                    $difendias = 0;                         $basico = 0;                        $diastrab = 0;
                    $detalleid = 0;                         $numid = 0;                         $formulabasico = "";
                    $formulalice = "";                      $montolicencia = 0;                 $porcbasico = 0;
                    $tipodc = "";                           $repetida = 0;                      $valor = 0;
                    $descuentos = 0;                        $smlv = 0;                          $cargoid = 0;
                    $aplicatransporte = "";                 $auxtrans = 0;                      $formulatransporte = "";
                    $subsidiotransporte = 0;                $numreg = 0;                        $totnovedades = 0;
                    $sueldodeducciones = 0;                 $sueldo = 0;                        $epsid = 0;
                    $pensionesid = 0;                       $aplicapension = "";                $aplicasalud = "";
                    $pension = 0;                           $salud = 0;                         $formulapension = "";
                    $formulasalud = "";                     $idpension = 0;                     $idsalud = 0;
                    $diaspendiente = 0;
    
                    // días de la licencia
                    $fecha1= new DateTime($fecdesde3);
                    $fecha2= new DateTime($fechasta);
                    $diff = $fecha1->diff($fecha2);
                    
                    $difendias = $diff->days;
                    $difendias += 1;
    
                    // ----------------------------------------------------------------------------------------------------------------------------- //
                    $suma = "+".strval($dias-1)." day";
                    $date_fin = strtotime(".$suma.", strtotime($fecdesde3));
                    $date_fin = date('Y-m-d', $date_fin);
    
                    if($date_fin > $fechasta)
                    {
                        // Aquí guardo en la tabla correspondiente el exceso en días 
                        // para ser calculado en próximos periodos
    
                        $diaspendiente = $dias - $difendias;
    
                        // --------------------------------------------------------------------------------------------------------- //
                        $feciniper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                        $diadesde = substr($feciniper, -2);
    
                        if($diadesde=="16")
                        {
                            $fecfinper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                            $fechaEntera = strtotime($fecfinper);
                            $valdias = date("d", $fechaEntera);
    
                            if($valdias=="28")              $diaspendiente -= 2;
                            if($valdias=="29")              $diaspendiente -= 1;
                            if($valdias=="31")              $diaspendiente += 1;
                        }
                        // --------------------------------------------------------------------------------------------------------- //
                        $dias -= $diaspendiente;
    
                        $procesado = "";
                        $vsql = "SELECT periodoid 
                                   FROM periodosnomina 
                                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE periodoid > $periodoid)";
                        $periodoapagar = $clase->SeleccionarUno($vsql);
    
                        $vsql = "INSERT INTO licenciaspendiente (terid,conceptoid,dias,periodoapagar,procesado) 
                                                         VALUES (".$terid.",".$conceptoid.",".$diaspendiente.",".$periodoapagar.",'".$procesado."')";
                        $clase->EjecutarSQL($vsql);
                    }
                    // ----------------------------------------------------------------------------------------------------------------------------- //
    
                    // Obtengo el salario básico del empleado
                    $basico = $clase->BDLockup($terid,$tabla,'terid','basico');
        
                    // Obtengo la formula del sueldo
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                    $formulabasico = $clase->SeleccionarUno($vsql);
        
                    // Obtengo los días trabajados en el periodo
                    $vsql = "SELECT valor
                               FROM detallenomina 
                              WHERE conceptoid = 1  
                                    AND pernominaid = ".$periodoid."
                                    AND terid = ".$terid."";
                    $diastrab = $clase->SeleccionarUno($vsql);
    
                    // Obtengo el ID del registro que se modificará
                    $vsql = "SELECT detalleid
                               FROM detallenomina 
                              WHERE conceptoid = 1  
                                    AND pernominaid = ".$periodoid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);
    
                    $diastrab -= $dias;
    
                    eval("\$sueldo = $formulabasico;");
                    $sueldo = round($sueldo,0);
        
                    // Almaceno en nuevo sueldo
                    $vsql = "UPDATE detallenomina SET 
                                    devengados = ".$sueldo.", 
                                    valor = ".$diastrab."
                              WHERE detalleid = ".$detalleid."";
                    $clase->EjecutarSQL($vsql);
    
                    // Calculo el nuevo ID
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numid = $clase->SeleccionarUno($vsql);
                    $numid++;
    
                    // Inserto la nueva licencia
    
                    // Obtengo la formula de la licencia
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                    $formulalice = $clase->SeleccionarUno($vsql);
    
                    // Calculo la licencia
                    if($conceptoid!=10)
                    {
                        eval("\$montolicencia = $formulalice;");
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        // Calculo la incapacidad
    
                        // Obtengo el salario mínimo legal vigente
                        $smlv = $_SESSION['N_SALMIN2020'];
    
                        // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                        if($basico<=$smlv)
                        {
                            $montolicencia = ($smlv*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            $porcbasico = ($basico*66.67)/100;
                            $porcbasico = round($porcbasico,0);
    
                            // Calculo la incapacidad si el básico sea mayor al mínimo
                            if($porcbasico>$smlv)
                            {
                                $montolicencia = ($porcbasico*$dias)/30;
                                $montolicencia = round($montolicencia,0);
                            }
                            else
                            {
                                if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;
    
                                $montolicencia = round($montolicencia,0);
                            }
                        }
                    }
    
                    // Obtengo el tipo de licencia
                    $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                    // ------------------------------------------------------------------------------------------------------------------- //
                    // Determino si el registro existe para modificarlo o incluirlo
                    $vsql = "SELECT COUNT(*) AS repetida 
                               FROM detallenomina
                              WHERE pernominaid = ".$periodoid."
                                    AND conceptoid = ".$conceptoid."
                                    AND terid = ".$terid."";
                    $repetida = $clase->SeleccionarUno($vsql);
    
                    if($repetida==0)
                    {
                        if($tipodc=="C")
                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                        else
                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
                    }
                    else
                    {
                        // Determino el id del registro
                        $vsql = "SELECT detalleid AS detalleid 
                                   FROM detallenomina
                                  WHERE pernominaid = ".$periodoid."
                                        AND conceptoid = ".$conceptoid."
                                        AND terid = ".$terid."";
                        $detalleid = $clase->SeleccionarUno($vsql);
    
                        $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
                        $valor += $dias;
    
                        // Actualizo la licencia
                        if($tipodc=="C")
                        {
                            $devengados = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
                            $devengados += $montolicencia;
                            
                            $vsql = "UPDATE detallenomina SET 
                                            devengados = ".$devengados.", 
                                            valor = ".$valor."
                                      WHERE detalleid = ".$detalleid."";
                        }
                        else
                        {
                            $descuentos = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
                            $descuentos += $montolicencia;
    
                            $vsql = "UPDATE detallenomina SET 
                                            descuentos = ".$descuentos.", 
                                            valor = ".$valor."
                                      WHERE detalleid = ".$detalleid."";
                        }
                    }
                    $clase->EjecutarSQL($vsql);
    
                    if(mysql_affected_rows() < 1)
                        $lbpaso = false;
                    else
                        $lbpaso = true;
    
                    if($lbpaso)
                    {
                        // ---------------------------------------------------------------------------------------------------------- //
                        // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos
    
                        $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');                           // Obtengo el cargo del empleado
                        $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte
    
                        $smlv = $_SESSION['N_SALMIN2020'];
            
                        // Variable para la validación del auxilio de transporte
                        $valsubtrasp = $smlv * 2;
            
                        if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                        {
                            // Obtengo el ID del registro que se modificará
                            $vsql = "SELECT detalleid
                                       FROM detallenomina 
                                      WHERE conceptoid = 3  
                                            AND pernominaid = ".$periodoid."
                                            AND terid = ".$terid."";
                            $detalleid = $clase->SeleccionarUno($vsql);
            
                            // Obtengo la formula del subsidio de transporte
                            $auxtrans = $_SESSION['N_AUXTRANS2020'];
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                            $formulatransporte = $clase->SeleccionarUno($vsql);
            
                            eval("\$subsidiotransporte = $formulatransporte;");
                            $subsidiotransporte = round($subsidiotransporte,0);
                        }
                        else
                            $subsidiotransporte = 0;
    
                        // ID transporte
                        $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                        $idtransporte = $clase->SeleccionarUno($vsql);
                
                        // Grabo el subsidio de transporte
                        if($idtransporte!="")
                            $vsql = "UPDATE detallenomina SET 
                                            devengados = ".$subsidiotransporte.",
                                            valor = ".$diastrab."
                                      WHERE detalleid = ".$idtransporte."";
                        else
                        {
                            // Obtengo el valor del subsidio de transporte
                            $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
                
                            $vsql = "SELECT max(detalleid) FROM detallenomina";
                            $numreg = $clase->SeleccionarUno($vsql);
                
                            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                        }
                        $clase->EjecutarSQL($vsql);
    
                        // ----------------------------------------------------------------------------------------------------------- //
                        // Ahora recalculo la pensión y la salud
    
                        // ----------------------------------------------------------------------------------------------------------- //
                        // Obtengo el total devengado por novedades
                        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                   FROM detallenomina d
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                  WHERE d.terid = ".$terid."
                                        AND d.pernominaid = ".$periodoid." 
                                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                        $totnovedades = $clase->SeleccionarUno($vsql);

                        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                   FROM detallenomina d
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                  WHERE d.terid = ".$terid."
                                        AND d.pernominaid = ".$periodoid." 
                                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                        $totrecargos = $clase->SeleccionarUno($vsql);
                
                        // Actualizo el sueldo
                        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
    
                        $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                        $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
                        $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
                        
                        if($epsid==NULL)                $epsid=0;
                        if($pensionesid==NULL)          $pensionesid=0;
    
                        $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                        $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
                        if($extralegal=="CHECKED")
                        {
                            $pension = 0;
                            $salud = 0;
                        }
                        else
                        {
                            // Recalculo pensión y salud
                            if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                $pension = 0;
                            else
                            {
                                // Obtengo la formula para el descuento por pensión
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                $formulapension = $clase->SeleccionarUno($vsql);
            
                                // Calculo la pensión
                                eval("\$pension = $formulapension;");
                                $pension = round($pension,0);
                            }
            
                            if(($epsid==37)||($aplicasalud!="CHECKED"))
                                $salud = 0;
                            else
                            {
                                // Obtengo la formula para el descuento de salud
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                $formulasalud = $clase->SeleccionarUno($vsql);
                                
                                // Calculo la salud
                                eval("\$salud = $formulasalud;");
                                $salud = round($salud,0);
                            }
                        }
    
                        //  ID pensión
                        $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                        $idpension = $clase->SeleccionarUno($vsql);
            
                        // Grabo la pensión
                        if($idpension!="")
                            $vsql = "UPDATE detallenomina SET 
                                            descuentos = ".$pension.",
                                            saldo = ".$sueldodeducciones."
                                      WHERE detalleid = ".$idpension."";
                        else
                        {
                            $vsql = "SELECT max(detalleid) FROM detallenomina";
                            $numreg = $clase->SeleccionarUno($vsql);
            
                            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                        }
                        $clase->EjecutarSQL($vsql);
    
                        // ID salud
                        $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                        $idsalud = $clase->SeleccionarUno($vsql);
            
                        // Grabo la salud
                        if($idsalud!="")
                            $vsql = "UPDATE detallenomina SET 
                                            descuentos = ".$salud.",
                                            saldo = ".$sueldodeducciones."
                                      WHERE detalleid = ".$idsalud."";
                        else
                        {
                            $vsql = "SELECT max(detalleid) FROM detallenomina";
                            $numreg = $clase->SeleccionarUno($vsql);
            
                            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                        }
                        $clase->EjecutarSQL($vsql);
    
                        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                        $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid;
                        $clase->EjecutarSQL($vsql);

                        // Actualizo en la tabla de pre novedades
                        $estatus = "PROCESADA";

                        $vsql7 = "UPDATE prenovedades SET 
                                         estatus = '".$estatus."'
                                   WHERE idnovedad = ".$idnovedad."";
                        $clase->EjecutarSQL($vsql7);
                    }
                }
            }
        }

        $clase->Aviso(1,"Proceso culminado satisfactoriamente");
        header("Location: novedades.php?filtro=TODAS");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: prenovedadesxls
    // Creación: 17/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite la salida a Excel de las pre novedades de un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "prenovedadesxls")
    {
        $periodoid  = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Validación de las pre novedades pendientes
        $vsql2 = "SELECT COUNT(*) AS numpendiente FROM prenovedades WHERE pernominaid = ".$periodoid." AND estatus = 'PENDIENTE'";
        $numpendiente = $clase->SeleccionarUno($vsql2);
        
        if($numpendiente == 0)
        {
            $clase->Aviso(3,"No existen pre novedades pendientes en el periodo $descripcion");
            header("Location: novedades.php?filtro=TODAS");
        }
        else
        {
            require_once 'lib/PHPExcel.php';
            $clase = new Sistema();
            $clase->Conectar();
            ini_set("memory_limit","100M");
            
            // Consulta para procesar las pre novedades
            $vsql = "SELECT t.dni, t.codvende, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombre, 
                            c.nomconcepto AS concepto, p.fechanov AS fecha, p.dias, sc.descripcionsec, p.estatus 
                       FROM prenovedades p 
                            INNER JOIN conceptosnomina c ON (p.conceptoid = c.conceptoid) 
                            INNER JOIN terceros t ON (p.terid = t.terid) 
                            INNER JOIN seccionterceros s ON (t.terid = s.terid) 
                            INNER JOIN seccion sc ON (s.seccionid = sc.seccionid) 
                      WHERE p.pernominaid = ".$periodoid." 
                   ORDER BY t.seccionid, t.primernombre, t.primerapellido";
    
            // Preparación del entorno para la salida a Excel
            $clase = new Sistema();
            $clase->Nombredb = $_SESSION['DBNOMBRE'];
            error_reporting(E_ALL);
            ini_set('display_errors', TRUE);
            ini_set('display_startup_errors', TRUE);
            date_default_timezone_set('Europe/London');
        
            if (PHP_SAPI == 'cli')
                die('This example should only be run from a Web Browser');
        
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
        
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                         ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                         ->setTitle("pre novedades - DROPOS")
                                         ->setSubject("pre novedades - DROPOS")
                                         ->setDescription("pre novedades - DROPOS")
                                         ->setKeywords("pre novedades - DROPOS")
                                         ->setCategory("Categoria General");
    
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'INFORME DE PRE NOVEDADES DEL PERIODO '.strtoupper($descripcion))
                        ->setCellValue('A3', 'DOCUMENTO')
                        ->setCellValue('B3', 'CODIGO')
                        ->setCellValue('C3', 'NOMBRE')
                        ->setCellValue('D3', 'SECCION')
                        ->setCellValue('E3', 'CONCEPTO')
                        ->setCellValue('F3', 'FECHA')
                        ->setCellValue('G3', 'DIAS')
                        ->setCellValue('H3', 'ESTATUS');

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);

            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant   = mysql_num_rows($result);
            $i = 4;
            while($row = mysql_fetch_array($result))
            {
                $codvende = $row['codvende'];
                if(substr($codvende,0,1) == "0")            $codvende="'".$codvende;

                $fecha = substr($row['fecha'],8,2)."/".substr($row['fecha'],5,2)."/".substr($row['fecha'],0,4);

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $row['dni'])
                            ->setCellValue('B'.$i, $codvende)
                            ->setCellValue('C'.$i, $row['nombre'])
                            ->setCellValue('D'.$i, $row['descripcionsec'])
                            ->setCellValue('E'.$i, $row['concepto'])
                            ->setCellValue('F'.$i, $fecha)
                            ->setCellValue('G'.$i, $row['dias'])
                            ->setCellValue('H'.$i, $row['estatus']);
                $i++;
            }

            $rangoEncabezado = 'A3:H3';
            $rangoCeldas     = 'A3:h'.($i-1);
            
            // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
            // Formato de Encabezado y Celdas
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
            
            $EstiloCeldas = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ),
                ),
            );
            /// Formato de Encabezados 
            $EstiloEncabezado = array(
            'font' => array(
                'bold' => true,
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
            ),
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ),
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'rotation' => 90,
                'startcolor' => array(
                    'argb' => '00FFFFCC',
                ),
                'endcolor' => array(
                    'argb' => 'FFFFFF',
                ),
                ),
            );
            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('pre novedades');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Redirect output to a client’s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            // --------------------------------------------------------------------------- //
            // header('Content-Disposition: attachment;filename="planillanom.xls"');
            $nombrearcexcel = "pre novedades del periodo ".strtolower($descripcion).".xls";
            header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
            // --------------------------------------------------------------------------- //
            header('Cache-Control: max-age=0');
            /// Genero la Salida
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            exit;
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: prenovedadespdf
    // Creación: 17/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite la salida en pdf de las pre novedades de un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "prenovedadespdf")
    {
        $periodoid  = $_GET['periodoid'];        
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";
        
        // Procedo a construir el encabezado del recibo
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();
        
        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

        // Imprimo el encabezado del informe
        $x = 25;
        $y = 13;
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+124,$y,$fechoraimp);

        // Encabezado del informe
        $pdf->SetFont('Arial','B',10);
        $enc= "INFORME DE PRE NOVEDADES DEL PERIODO";               $pdf->Text($x,$y+5,$enc);
        $enc= $descripcion;                                         $pdf->Text($x,$y+10,$enc);
        
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(5,28,200,8,'F');
        $pdf->SetFont('Arial','B',9);

        $enc= "NOMBRE";                         $pdf->Text($x-17,$y+20,$enc);
        $enc= "SECCION";                        $pdf->Text($x+27,$y+20,$enc);
        $enc= "CONCEPTO";                       $pdf->Text($x+73,$y+20,$enc);
        $enc= "FECHA";                          $pdf->Text($x+125,$y+20,$enc);
        $enc= "DIAS";                           $pdf->Text($x+145,$y+20,$enc);
        $enc= "ESTATUS";                        $pdf->Text($x+160,$y+20,$enc);

        // Consulta para procesar las pre novedades
        $vsql = "SELECT t.dni, t.codvende, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombre, 
                        c.nomconcepto AS concepto, p.fechanov AS fecha, p.dias, sc.descripcionsec, p.estatus 
                   FROM prenovedades p 
                        INNER JOIN conceptosnomina c ON (p.conceptoid = c.conceptoid) 
                        INNER JOIN terceros t ON (p.terid = t.terid) 
                        INNER JOIN seccionterceros s ON (t.terid = s.terid) 
                        INNER JOIN seccion sc ON (s.seccionid = sc.seccionid) 
                  WHERE p.pernominaid = ".$periodoid." 
               ORDER BY t.seccionid, t.primernombre, t.primerapellido";

        $x = 8;
        $y = 41;
        $i = 0;
        $linea = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%38==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "INFORME DE PRE NOVEDADES DEL PERIODO";               $pdf->Text($x,$y+5,$enc);
                $enc= $descripcion;                                         $pdf->Text($x,$y+10,$enc);
        
                // Encabezado del informe
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,28,200,8,'F');
                $pdf->SetFont('Arial','B',9);
        
                $enc= "NOMBRE";                         $pdf->Text($x-17,$y+20,$enc);
                $enc= "SECCION";                        $pdf->Text($x+27,$y+20,$enc);
                $enc= "CONCEPTO";                       $pdf->Text($x+73,$y+20,$enc);
                $enc= "FECHA";                          $pdf->Text($x+125,$y+20,$enc);
                $enc= "DIAS";                           $pdf->Text($x+145,$y+20,$enc);
                $enc= "ESTATUS";                        $pdf->Text($x+160,$y+20,$enc);

                $x = 8;
                $y = 41;
            }

            // Impresión del detalle
            $linea++;

            $fecha = substr($row['fecha'],8,2)."/".substr($row['fecha'],5,2)."/".substr($row['fecha'],0,4);

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y,substr($row['nombre'],0,22));
            $pdf->Text($x+45,$y,$row['descripcionsec']);
            $pdf->Text($x+90,$y,$row['concepto']);
            $pdf->Text($x+142,$y,$fecha);

            $longitud = strlen($row['dias']);
            if($longitud == 1)            $pdf->Text($x+168,$y,$row['dias']);
            if($longitud == 2)            $pdf->Text($x+165,$y,$row['dias']);

            $pdf->Text($x+177,$y,$row['estatus']);

            $y+=6;
        }
        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacion
    // Creación: 17/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para confirmar la eliminación de una pre novedad
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacion")
    {
        $idnovedad  = $_GET['idnovedad'];

        $estatus = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','estatus');

        if($estatus == "PROCESADA")
        {
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="left"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td> 
                      <td align="center"> <label class="Texto12"> <font color="red"> <b> Esta pre novedad ya ha sido procesada </b> </font> </label> <br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="500" align="center"> <br> <br>
                       <form action="novedades.php?filtro=TODAS" method="POST">
                       <input type="submit" value="ACEPTAR" class="button red">                      
                       </form>                      
                      </td>        
                     </tr>
                    </table>';
            echo $cont; 
            exit();
        }
        else
        {
            // Nombre del empleado
            $terid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','terid');
            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid."";
            $nombreemp = $clase->SeleccionarUno($vsql);

            // días de la pre novedad
            $dias = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','dias');

            // nombre de la novedad
            $conceptoid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','conceptoid');
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
    
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <label class="Texto12"> <b> Eliminar una pre novedad </b> </label> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center">
                       <label class="Texto12">
                       ¿Confirma que desea eliminar en concepto <br> <b> '.$nomconcepto.' </b> a <br> <b> '.$nombreemp.'</b> <br> por <b> '.number_format($dias).' <b> d&iacute;as? 
                       </label>
                       <br>
                      </td>       
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>
                       <form action="?opcion=eliminar" method="POST">
                       <input type="hidden" name="idnovedad" value="'.$idnovedad.'">
                       <input type="submit" value="ACEPTAR" class="button blue">
                       <a href="novedades.php?filtro=TODAS"> <input type="button" value="CANCELAR" class="button red"> </a>
                       </form>
                       <br>
                      </td>
                     </tr>
                    </table>';
            echo $cont;
            exit();
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminar
    // Creación: 17/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina físicamente una pre novedad
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminar")
    {
        $idnovedad = $_POST['idnovedad'];

        $estatus = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','estatus');

        if($estatus == "PROCESADA")
            $clase->Aviso(3,"No se puede eliminar esta novedad porque ya ha sido procesada");
        else
        {
            $vsql = "DELETE FROM prenovedades WHERE idnovedad = ".$idnovedad;
            $clase->EjecutarSQL($vsql);
    
            // valido que se almacenen los datos para emitir el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó pre novedad");
            else
                $clase->Aviso(1,"Pre novedad eliminada exitosamente");
        }

        // redirecciono el formulario
        header("Location: novedades.php?filtro=TODAS");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmareversar
    // Creación: 17/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar el reverso de una licencia procesada
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmareversar")
    {
        $periodoid  = $_GET['periodoid'];
        $terid  = $_GET['terid'];
        $conceptoid  = $_GET['conceptoid'];
        $idnovedad  = $_GET['idnovedad'];

        // Datos para la confirmación
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid."";
        $nombreemp = $clase->SeleccionarUno($vsql);
        $dias = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','dias');

        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <br> <label class="Texto12"> <b> Reversar una pre novedad </b> </label> <br><br> </td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">
                   <label class="Texto12">
                   ¿Confirma que desea reversar la novedad <br><b> '.$nomconcepto.'</b><br> al empleado(a) <br><b> '.$nombreemp.'</b><br> por <b> '.$dias.'</b> d&iacute;a(s)?
                   </label>
                  </td>       
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=reversarnovedad" method="POST">
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="hidden" name="terid" value="'.$terid.'">
                   <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                   <input type="hidden" name="idnovedad" value="'.$idnovedad.'">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="novedades.php" ><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: reversarnovedad
    // Creación: 17/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que reversa una licencia previamente procesada
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "reversarnovedad")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $conceptoid = $_POST['conceptoid'];
        $idnovedad = $_POST['idnovedad'];
        
        // actualizo el estatus de la pre novedad
        $estatus = "PENDIENTE";

        $vsql = "UPDATE prenovedades SET 
                        estatus = '".$estatus."' 
                  WHERE idnovedad = ".$idnovedad."";
        $clase->EjecutarSQL($vsql);

        // Proceso a eliminar de acuerdo a si tiene o no datos básicos
        $vsql = "SELECT count(*) AS numregemp 
                   FROM detallenomina 
                  WHERE terid = ".$terid." 
                        AND pernominaid = ".$periodoid." 
                        AND conceptoid IN (1,3,4,5)";
        $numregemp = $clase->SeleccionarUno($vsql);

        if($numregemp == 0)
        {
            $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
            $clase->EjecutarSQL($vsql);
        }
        else
        {
            // Inicializo las variables
            $diasconcepto = 0;                          $diastrab = 0;                      $detalleid = 0;
            $formulabasico = "";                        $sueldo = 0;                        $basico = 0;
            $smlv = 0;                                  $valsubtrasp = 0;                   $auxtrans = 0;
            $formulatransporte = "";                    $subsidiotransporte = 0;            $lb_grabosueldo = false;
            $numlicpendientes = 0;

            // Obtengo los días del concepto que se eliminará
            $vsql = "SELECT SUM(valor) AS diasconcepto FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
            $diasconcepto = $clase->SeleccionarUno($vsql);

            $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
            $clase->EjecutarSQL($vsql);

            // Obtengo el salario básico del empleado
            $basico = $clase->BDLockup($terid,'tercerosactual','terid','basico');

            // Obtengo los días trabajados en el periodo
            $vsql = "SELECT valor
                       FROM detallenomina 
                      WHERE conceptoid = 1  
                            AND pernominaid = ".$periodoid."
                            AND terid = ".$terid."";
            $diastrab = $clase->SeleccionarUno($vsql);

            // Obtengo el ID del registro que se modificará
            $vsql = "SELECT detalleid
                       FROM detallenomina 
                      WHERE conceptoid = 1  
                            AND pernominaid = ".$periodoid."
                            AND terid = ".$terid."";
            $detalleid = $clase->SeleccionarUno($vsql);

            // Obtengo la formula del sueldo
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
            $formulabasico = $clase->SeleccionarUno($vsql);

            // Recalculo el sueldo del periodo
            $diastrab = $diastrab + $diasconcepto;
            eval("\$sueldo = $formulabasico;");
            $sueldo = round($sueldo,0);

            // Almaceno en nuevo sueldo
            $vsql = "UPDATE detallenomina SET 
                            devengados = ".$sueldo.", 
                            valor = ".$diastrab."
                      WHERE detalleid = ".$detalleid."";
            $clase->EjecutarSQL($vsql);

            // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se procesó correctamente la eliminación del concepto, comuníquese con el administrador del sistema ERROR 1541");
            else
            {
                // Ahora voy a recalcular el subsidio de transporte si es necesario
                $lb_grabosueldo=true;       // Variable que controla el mensaje correspondiente
    
                // Obtengo el salario mínimo legal vigente
                $smlv = $_SESSION['N_SALMIN2020'];
    
                // Variable para la validación del auxilio de transporte
                $valsubtrasp = $smlv * 2;

                $cargoid = $clase->BDLockup($terid,'tercerosactual','terid','cargoid');                         // Obtengo el cargo del empleado
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');           // Obtengo el control del cálculo de subsidio de transporte

                if(($basico <= $valsubtrasp) && ($aplicatransporte=="CHECKED"))
                {
                    // Obtengo el ID del registro que se modificará
                    $vsql = "SELECT detalleid
                               FROM detallenomina 
                              WHERE conceptoid = 3  
                                    AND pernominaid = ".$periodoid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);
    
                    // Obtengo la formula del subsidio de transporte
                    $auxtrans = $_SESSION['N_AUXTRANS2020'];
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                    $formulatransporte = $clase->SeleccionarUno($vsql);
    
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);
                }
                else
                    $subsidiotransporte = 0;
        
                // ID transporte
                $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                $idtransporte = $clase->SeleccionarUno($vsql);
        
                // Grabo el subsidio de transporte
                if($idtransporte!="")
                    $vsql = "UPDATE detallenomina SET 
                                    devengados = ".$subsidiotransporte.",
                                    valor = ".$diastrab."
                              WHERE detalleid = ".$idtransporte."";
                else
                {
                    // Obtengo el valor del subsidio de transporte
                    $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
        
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                }
                $clase->EjecutarSQL($vsql);

                // ----------------------------- //
                // Recalculo la pensión
                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                $totnovedades = $clase->SeleccionarUno($vsql);

                $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                $totrecargos = $clase->SeleccionarUno($vsql);

                // Actualizo el sueldo
                // $sueldo += $totnovedades;
                $sueldo = $sueldo + $totnovedades + $totrecargos;
                $sueldodeducciones = $sueldo;

                // ------------------------------------------------------------------------------------------------------------- //
                // Obtengo la formula para el descuento por pensión
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                $formulapension = $clase->SeleccionarUno($vsql);

                // Obtengo la formula para el descuento de salud
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                $formulasalud = $clase->SeleccionarUno($vsql);

                // Determino si el empleado es de condición extralegal
                $extralegal = $clase->BDLockup($terid,'tercerosactual','terid','extralegal');
                $epsid = $clase->BDLockup($terid,'tercerosactual','terid','epsid');
                $pensionesid = $clase->BDLockup($terid,'tercerosactual','terid','pensionesid');
                
                if($epsid==NULL)
                    $epsid=0;
                if($pensionesid==NULL)
                    $pensionesid=0;

                // ----------------------------------------------------------------------------------------------------------- //
                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
                if($extralegal=="CHECKED")
                {
                    $pension = 0;
                    $salud = 0;
                }
                else
                {
                    // Recalculo pensión y salud
                    if(($pensionesid==5)||($aplicapension!="CHECKED"))
                        $pension = 0;
                    else
                    {
                        // Obtengo la formula para el descuento por pensión
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                        $formulapension = $clase->SeleccionarUno($vsql);
    
                        // Calculo la pensión
                        eval("\$pension = $formulapension;");
                        $pension = round($pension,0);
                    }
    
                    if(($epsid==37)||($aplicasalud!="CHECKED"))
                        $salud = 0;
                    else
                    {
                        // Obtengo la formula para el descuento de salud
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                        $formulasalud = $clase->SeleccionarUno($vsql);
                        
                        // Calculo la salud
                        eval("\$salud = $formulasalud;");
                        $salud = round($salud,0);
                    }
                }
    
                //  ID pensión
                $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                $idpension = $clase->SeleccionarUno($vsql);
    
                // Grabo la pensión
                if($idpension!="")
                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$pension.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idpension."";
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
    
                // ID salud
                $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                $idsalud = $clase->SeleccionarUno($vsql);
    
                // Grabo la salud
                if($idsalud!="")
                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$salud.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idsalud."";
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                }    
                $clase->EjecutarSQL($vsql);
                // ------------------------------------------------------------------------------------------------------------- //

                // Obtengo el id del pendiente
                $vsql3 = "SELECT MAX(pendienteid) AS pendienteid 
                            FROM licenciaspendiente 
                           WHERE terid = ".$terid."
                                 AND conceptoid = ".$conceptoid."";
                $pendienteid = $clase->SeleccionarUno($vsql3);

                $vsql = "DELETE FROM licenciaspendiente WHERE pendienteid = ".$pendienteid."";
                $clase->EjecutarSQL($vsql);
            }

            // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
            $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid = ".$terid."";
            $clase->EjecutarSQL($vsql);
        }
        
        // Redirecciono el formulario
        $clase->Aviso(1,"Novedad reversada satisfactoriamente");
        header("Location: novedades.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nocalculado
    // Creación: 28/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite la ventana de error de periodo calculado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "nocalculado")
    {
        $periodoid  = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="left"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td> 
                  <td align="center">
                   <label class="Texto12"> <b> <font color="red"> No se puede emitir el recibo de pago porque la <br> '.$descripcion.' no est&aacute; calculada </font> </b> </label>
                   <br>
                  </td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="500" align="center"><br>
                   <form action="novedades.php?filtro=TODAS" method="POST">
                   <input type="submit" value="ACEPTAR" class="button blue">                      
                   </form>                      
                  </td>        
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////
    echo $cont.$clase->PiePagina();
?>