<?PHP
    @session_start(); 

    require_once("classes/class_validaciones.php");
    $io_fecha=new class_validaciones();

    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detalles
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para el control de las sucursales 
	//              pertenecientes a una nota de débito
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "detalles")
    {
        $docuid = $_GET['docuid'];

        // para las pruebas
//        $docuid = 50000;

        // consulta de la vista
        $vsql = "SELECT sxn.*, s.descripcion, s.codigo FROM sucursalesxnota sxn INNER JOIN sucursales s ON (sxn.sucursalid = s.sucursalid) WHERE sxn.docuid = ".$docuid;

		// inicializo las variables
        $det = '';
		$pie.=' </tbody>
			   </table>';

        // valido que el archivo de mostrar errores exista
        $archivoerror = "reportes/erroresnotas.txt";
        if (file_exists ($archivoerror))
            $htmlarchivoerror = '<a href="?opcion=vererrores&docuid='.$docuid.'" rel="facebox">
                                  <img src="images/iconos/notas.png" border="0" width="38" height="38" title="c&oacute;digos de sucursales no guardados en el &uacute;ltimo proceso de importaci&oacute;n">
                                 </a>';
        else
            $htmlarchivoerror = '<img src="images/iconos/notas.png" border="0" width="38" height="38" title="c&oacute;digos de sucursales no guardados en el &uacute;ltimo proceso de importaci&oacute;n">';

        // Validación del botón de limpiar lista de productos excluidos de rotación
        $vsql32 = "SELECT COUNT(*) numnotas FROM sucursalesxnota";
        $numnotas = $clase->SeleccionarUno($vsql32);

        if($numnotas > 0)
            $htmllimpiar = ' <a href="?opcion=confirmarlimpiar&docuid='.$docuid.'" rel="facebox">
                              <img src="images/iconos/anulardoc.png" border="0" width="38" height="38" title="limpiar toda la lista de sucursales">
                             </a>';
        else
            $htmllimpiar = '<img src="images/iconos/anulardoc.png" border="0" width="38" height="38" title="limpiar toda la lista de sucursales">';

		// pinto la ventana
		$enc =  $clase->HeaderBlanco("Sucursales por nota");
		$enc.=' <table width="1300">
		         <tr class="CabezoteTabla"> 
		          <td width="10"> &nbsp; </td>
		          <td width="37"> <img src="images/iconos/informe2.png" width="32" height="32" border="0"> </td>
		          <td width="870"> <b> Sucursales por notas </b> </td>
                  <form action="?opcion=encontrar" method="POST" name="x">
                  <td> &nbsp; </td>
				  <td width="5"> &nbsp; </td>
                  <td> &nbsp; </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30">
                   <a href="?opcion=ventananuevasucursalnota&docuid='.$docuid.'" rel="facebox">
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="incluir una sucursal"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
		          <td width="30">
		           <a href="?opcion=importarexcel1&docuid='.$docuid.'" rel="facebox">
		            <img src="images/iconos/cargar.png" width="34" height="34" border="0" title="importar sucursales desde una hoja de Excel">
		           </a>
		          </td>
		          <td width="10"> &nbsp; </td>
				  <td width="30"> 
				   '.$htmlarchivoerror.'
				  </td>
		          <td width="10"> &nbsp; </td>
				  <td width="30"> 
                   '.$htmllimpiar.'
				  </td>
				  <td width="10"> &nbsp; </td>
		          <td width="50" align="center"> <a href="cuentasporpagar.php?opcion=crearndbespecial&docuid='.$docuid.'"> <input type="button" value="<<" class="button blue"> </a> </td> 
		          <td width="8"> &nbsp; </td>
		         </tr>
                 
	            </table>
                <script type="text/javascript" src="lib/sorttable.js"></script>                
	            <table id="fixTableV" class="sortable">
		         <tr class="TituloTabla">
		          <th width="40"> # </th>
		          <th width="120"> C&oacute;digo </th>
		          <th width="470"> Sucursal </th>
		          <th width="90"> Valor </th>
                  <th width="30"> &nbsp; </th>
                  <th width="30"> &nbsp; </th>                  
		         </tr>';        

        // impresión del detalle
        $totmontos = 0;
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $det.='<tr class="TablaDocsPar">';
            else
                $det.='<tr class="TablaDocsImPar">';                

            $det.=' <td align="center"> '.$i.' </td>
                    <td align="center"> '.$row['codigo'].' </td>
                    <td align="center"> '.$row['descripcion'].' </td>
                    <td align="center"> '.number_format($row['valor']).' </td>
                    <td align="center"> 
                     <a href="?opcion=confirmareliminar&id='.$row['id'].'" rel="facebox">
                      <img src="images/basicas/iconoborrar.png" title="eliminar la sucursal" border="0" width="20" height="20">
                     </a>
                    </td>
                    <td align="center">
                     <a href="?opcion=editarsucnota&id='.$row['id'].'" rel="facebox"> 
                      <img src="images/basicas/iconobuscar.png" title="editar la sucursal" border="0" width="20" height="20"> 
                     </a> 
                    </td>                    
                   </tr>';

            $totmontos += $row['valor'];
        }

        // barra de totales
		$totales = '<table width="100%"> 
		             <tr class="TituloTabla"> 
					  <td width="20"> &nbsp; </td> 
					  <td width="800"> <font color="white"> <b> Sucursales: '.number_format($i).' </b> </font> </td>
                      <td width="200"> <font color="white"> <b> '.number_format($totmontos).' </b> </font> </td>
					 </tr>
					</table>';

		// Construyo el contenido del formulario
        $cont = $enc.$det.$pie.$totales;

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel1
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para seleccionar la hoja de Excel desde la 
	//              cual se importarán las sucursales para una nota de débito
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel1")
    {
        $docuid = $_GET['docuid'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=detalles&docuid='.$docuid.'" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr" value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
        else
        {
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Importar sucursales para <br> la nota de d&eacute;bito <br> <font color="blue"> '.$docuid.' </font> </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importarexcel2" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="docuid" value="'.$docuid.'">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
    
			// Impresión de la imagen de ejemplo
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&oacute;digo de la sucursal </td> </tr>
					 <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Valor (solo n&uacute;meros) </td> </tr>
                    </table>';
    
			// Botón de ejecutar
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplonotasespeciales.png" width="300" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensi&oacute;n .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel2
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que realiza el proceso de importación de las sucursales desde una 
	//              hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel2")
    {
		set_time_limit(0);
		extract($_POST);
        $docuid = $_POST["docuid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;
        
        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            echo'<SCRIPT languague="javascript">
                 <!--
                    alert("El archivo debe tener extensión .xlsx");
                    window.history.back();
                 -->
                 </SCRIPT>';
            exit;
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['codigo'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
					$_DATOS_EXCEL[$i]['valor'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['codigo']) == 0) || (strlen($_DATOS_EXCEL[$i]['valor']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocodigos = 'SUCURSALES PARA LA NOTA '.$docuid.Chr(13).Chr(10);
            $nocodigos.= 'CODIGOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocodigos.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                // inicialización de variables
                $lbgrabo = false;
                $valcodigo = 0;
                $numsucursal = 0;
                $motivo = "";
                $lb_valido = false;
                $codigo = $_DATOS_EXCEL[$j]['codigo'];

                // valido que el código de la sucursal exista
                $vsql11 = "SELECT COUNT(codigo) valcodigo FROM sucursales WHERE codigo = '".$codigo."'";
                $valcodigo = $clase->SeleccionarUno($vsql11);

                if($valcodigo == 0)
                    $motivo = "Código no existe";
                else
                {
                    // Valido que la sucursal no esté repetida
                    $sucursalid = $clase->BDLockup($codigo,'sucursales','codigo','sucursalid');

                    $vsql22 = "SELECT COUNT($sucursalid) numsucursal FROM sucursalesxnota WHERE docuid = ".$docuid." AND sucursalid = ".$sucursalid;
                    $numsucursal = $clase->SeleccionarUno($vsql22);

                    if($numsucursal > 0)
                        $motivo = "Código ya existe para esta nota";
                    else
                    {
                        $valor = $_DATOS_EXCEL[$j]['valor'];
    
                        // Valido el formato numérico del valor
                        $lb_valido = $io_fecha->uf_solo_numeros($valor);
    
                        if(!$lb_valido)
                            $motivo = "Formato de valor incorrecto";
                        else
                        {
                            $vsql = "INSERT INTO sucursalesxnota (docuid, sucursalid, valor) VALUE (".$docuid.",".$sucursalid.",".$valor.")";
                            $clase->EjecutarSQL($vsql);
    
                            if(mysql_affected_rows() >= 1)
                            {
                                $grabados++;
                                $lbgrabo = true;
                            }                            
                        }
                    }
                }

                // Almaceno en un archivo de texto las códigos que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocodigos.= str_pad($codigo,1,"").' -- '.str_pad($motivo,1,"").Chr(13).Chr(10);        // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresnotas.txt";                                                          // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                                         // se abre el archivo para escribir
                    fwrite($fd, $nocodigos);                                                                // Grabas
                    fclose($fd);                                                                            // Cierras el archivo
                }
            }

            // --------------------------------------------------------------------------------------------------------------- //
            // Impresión de la fecha del último proceso ejecutado
            $mesimp = date('F');
            if($mesimp == "January")       $mesimp = "enero";
            if($mesimp == "February")      $mesimp = "febrero";
            if($mesimp == "March")         $mesimp = "marzo";
            if($mesimp == "April")         $mesimp = "abril";
            if($mesimp == "May")           $mesimp = "mayo";
            if($mesimp == "June")          $mesimp = "junio";
            if($mesimp == "July")          $mesimp = "julio";
            if($mesimp == "August")        $mesimp = "agosto";
            if($mesimp == "September")     $mesimp = "septiembre";
            if($mesimp == "October")       $mesimp = "octubre";
            if($mesimp == "November")      $mesimp = "noviembre";
            if($mesimp == "December")      $mesimp = "diciembre";

            $dayweek = date("l");
            if($dayweek == "Monday")       $dayweek = "lunes";
            if($dayweek == "Tuesday")      $dayweek = "martes";
            if($dayweek == "Wednesday")    $dayweek = "miércoles";
            if($dayweek == "Thursday")     $dayweek = "jueves";
            if($dayweek == "Friday")       $dayweek = "viernes";
            if($dayweek == "Saturday")     $dayweek = "sábado";
            if($dayweek == "Sunday")       $dayweek = "domingo";

            $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');

            $nocodigos.= ''.Chr(13).Chr(10);
            $nocodigos.= str_pad($fechoraimp,1,"").''.Chr(13).Chr(10);      // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresnotas.txt";                                  // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                 // se abre el archivo para escribir
            fwrite($fd, $nocodigos);                                        // Grabas
            fclose($fd);                                                    // Cierras el archivo
            // --------------------------------------------------------------------------------------------------------------- //
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
			{
				echo'<SCRIPT languague="javascript">
					 <!--
						alert("No se cargaron las sucursales");
						window.history.back();
					 -->
					 </SCRIPT>';
		   		exit;
			}                
            else
			{
				echo'<SCRIPT languague="javascript">
					 <!--
						alert("Se cargaron '.$grabados.' sucursales a la nota '.$docuid.'");
						window.history.back();
					 -->
					 </SCRIPT>';
		   		exit;
			}                
    
            // Redirecciona el formulario
            header("Location: notasespeciales.php?opcion=detalles&docuid=$docuid");
        }
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererrores
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para ver los códigos que no fueron 
    //              almacenados en el último proceso de importación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererrores")
    {
        $docuid = $_GET['docuid'];

        // Inicialización de variables
        $archivoerror = "reportes/erroresnotas.txt";
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        $txt = trim(str_replace("<br />","",$txt));
        $txt = trim(str_replace(" -- Código no existe","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> C&oacute;digos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
				  <a href="?opcion=detalles&docuid='.$docuid.'"> <input type="button" value="aceptar" class="button blue"> </a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventananuevasucursalnota
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar los datos de una nueva sucursal 
    //              para la nota especial
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventananuevasucursalnota")
    {
        $docuid = $_GET['docuid'];

        // Inicialización de variables
        $valor = 0;

        // combo de sucursales
        $params = ' class="Texto11" ';
        $vsqlcombosucursal = "SELECT sucursalid , descripcion FROM sucursales WHERE 1 ORDER BY orden ASC";
        $combosucursales = $clase->CrearComboBuscar("sucursalid",$vsqlcombosucursal,"descripcion","sucursalid","01","n",$params,300);

		// pinto la ventana
		$cont ='<table width="400">
				 <tr class="CabezoteTabla">
				  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
				  <td width="350" align="center"> <b> Incluir sucursal </b> <br> </td>
				 </tr> 
				</table>
				<form action="?opcion=guardarnewnotaespecial" method="POST" name="x">
                <input type="hidden" name="docuid" value="'.$docuid.'">
				<table width="400">
				 <center><br>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"> <label class="Texto12"> Sucursal: </label>&nbsp; </td>
				  <td width="300"> '.$combosucursales.' </td>
				 </tr>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"> <label class="Texto12"> Monto: </label>&nbsp; </td>
				  <td width="300"> 
                  <input type="number" name="valor" min="1" class="Texto12" style="width:150px;height:25px;" autocomplete="off" title="monto" value="'.$valor.'"> 
                  </td>
				 </tr>
				</table>
				<br>
				<center>
				<input type="submit" value="aceptar" class="button blue">
				<a href="?opcion=detalles&docuid='.$docuid.'"><input type="button" value="CANCELAR" class="button red"></a>
				</form><br>';
		echo $cont;
		exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnewnotaespecial
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los datos de una nueva sucursal para una nota 
    //              especial
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnewnotaespecial")
    {
        $docuid = $_POST["docuid"];
        $sucursalid = $_POST["sucursalid"];
        $valor = $_POST["valor"];

        // obtengo el nombre de la sucursal
        $descripcion = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');

        $vsql22 = "SELECT COUNT($sucursalid) numsucursal FROM sucursalesxnota WHERE docuid = ".$docuid." AND sucursalid = ".$sucursalid;
        $numsucursal = $clase->SeleccionarUno($vsql22);

        if($numsucursal > 0)
        {
            echo'<SCRIPT languague="javascript">
                 <!--
                  alert("'.$descripcion.' ya está incluida en la nota '.$docuid.'");
                  window.history.back();
                 -->
                </SCRIPT>';
            exit;
        }
        else
        {
            $vsql = "INSERT INTO sucursalesxnota (docuid, sucursalid, valor) VALUE (".$docuid.",".$sucursalid.",".$valor.")";
            $clase->EjecutarSQL($vsql);

            echo'<SCRIPT languague="javascript">
                 <!--
                  alert("'.$descripcion.' incluida en la nota '.$docuid.'");
                  window.history.back();
                 -->
                </SCRIPT>';
            exit;
        }

        // Redirecciona el formulario
        header("Location: notasespeciales.php?opcion=detalles&docuid=$docuid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarlimpiar
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de todas las 
    //              sucursales de una nota
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiar")
    {
        $docuid = $_GET['docuid'];

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/anulardoc.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar todas las sucursales </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">
                   ¿Confirma que desea eliminar todas las sucursales de la nota <b> '.$docuid.'</b>? <br> Esta opci&oacute;n no podr&aacute; ser revertida
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=limpiarsucnota" method="POST"> 
                   <input type="hidden" name="docuid" value="'.$docuid.'">                  
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="?opcion=detalles&docuid='.$docuid.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: limpiarsucnota
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina todas las sucursales de una nota
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "limpiarsucnota")
    {
        $docuid = $_POST["docuid"];

		// Elimino el prodcuto
		$vsql = "DELETE FROM sucursalesxnota WHERE docuid = ".$docuid;        
		$clase->EjecutarSQL($vsql);

		// emito el mensaje correspondiente
		echo'<SCRIPT languague="javascript">
			 <!--
				alert("Eliminadas todas las sucursales de la nota '.$docuid.'");
				window.history.back();
			 -->
			 </SCRIPT>';
	 	exit;

        // Redirecciona el formulario
        header("Location: notasespeciales.php?opcion=detalles&docuid=$docuid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmareliminar
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de una 
    //              sucursal de una nota especial
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmareliminar")
    {
        $id = $_GET['id'];

		// Obtengo los datos de la nota
        $docuid = $clase->BDLockup($id,'sucursalesxnota','id','docuid');
		$sucursalid = $clase->BDLockup($id,'sucursalesxnota','id','sucursalid');
		$descripcion = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar sucursal </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">¿Confirma que desea eliminar la sucursal <br> <b>'.trim($descripcion).'</b> <br> de la nota <b>'.trim($docuid).'</b>? </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarsucnota" method="POST">
                   <input type="hidden" name="id" value="'.$id.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="?opcion=detalles&docuid='.$docuid.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarsucnota
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina una sucursal de una nota especial
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarsucnota")
    {
        $id = $_POST["id"];

		// Obtengo los datos de la nota
        $docuid = $clase->BDLockup($id,'sucursalesxnota','id','docuid');
		$sucursalid = $clase->BDLockup($id,'sucursalesxnota','id','sucursalid');
		$descripcion = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');

		// Elimino el prodcuto
		$vsql = "DELETE FROM sucursalesxnota WHERE id = ".$id;
		$clase->EjecutarSQL($vsql);

		// emito el mensaje correspondiente
		echo'<SCRIPT languague="javascript">
			 <!--
				alert("'.$descripcion.' eliminada de la nota '.$docuid.'");
				window.history.back();
			 -->
			 </SCRIPT>';
	 	exit;

		// redirecciono el formulario
		header("Location: notasespeciales.php?opcion=detalles&docuid=$docuid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarsucnota
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar los datos para editar la 
    //              sucursal perteneciente a la nota
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarsucnota")
    {
        $id = $_GET['id'];

		// Obtengo los datos de la nota
        $docuid = $clase->BDLockup($id,'sucursalesxnota','id','docuid');
        $valor = $clase->BDLockup($id,'sucursalesxnota','id','valor');
		$sucursalid = $clase->BDLockup($id,'sucursalesxnota','id','sucursalid');
		$descripcion = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');

		// pinto la ventana
        $cont ='<table width="400">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td width="350" align="center"> <label class="Texto12"> <b>Editar nota <br> <font color="blue"> '.$docuid.' <br> '.$descripcion.' </font> </label> </b> <br> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardaredicionsucnota" method="POST" name="x">
                <input type="hidden" name="id" value="'.$id.'">
                <table width="400">
                 <center><br>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"> <label class="Texto12"> Valor: </label> &nbsp;&nbsp; </td>
				  <td width="300"> 
                   <input type="number" name="valor" min="1" class="Texto12" style="width:150px;height:25px;" autocomplete="off" title="valor para la sucursal" value="'.$valor.'"> 
                  </td>
				 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="?opcion=detalles&docuid='.$docuid.'"><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardaredicionsucnota
    // Creación: 21/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para almacenar la modificación del valor de una sucursal de una 
    //              nota
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardaredicionsucnota")
    {
        $id = $_POST["id"];
        $valor = $_POST["valor"];

		$sucursalid = $clase->BDLockup($id,'sucursalesxnota','id','sucursalid');
		$descripcion = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');        

        // guardo los cambios
        $vsql = "UPDATE sucursalesxnota SET valor = ".$valor." WHERE id = ".$id;
        $clase->EjecutarSQL($vsql);

        echo'<SCRIPT languague="javascript">
             <!--
                alert("'.$descripcion.' editada satisfactoriamente");
                window.history.back();
             -->
            </SCRIPT>';
        exit;
    }
?>