<?PHP
    @session_start();
    include("lib/Sistema.php");
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 15/10/2021		última modificación: 08/08/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para la captación de datos de la nómina 
    //              electrónica
    // Última modificación: Se rediseñó para que se indicara únicamente el mes que se debe 
    //                      reportar y validar que ambos periodos estén cerrados 
    //                      (25/10/2021)
    //                      Validación de los botones para la ejecución de los procesos 
    //                      inherentes a este formulario (27/03/2023)
    //                      Llamado a la opción para mostrar el reloj en la generación de la 
    //                      hoja de Excel
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
	    // Control de Permisos
	    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED")) 
        {
            // Preparo las variables para el combo del mes
            $yeartoday = date("Y");
    
            // ------------------------------------------------------------- //
            $monthtoday = date("m");
            $daytoday = date("j");
            if(($monthtoday=="01")&&($daytoday<=16))        $yeartoday--;
            // ------------------------------------------------------------- //            
    
            // -------------------------------------------------------------------------------------------------------------------- //
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
    
            $vsqlcodmesrep  = "SELECT codperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $vsqlcodmesrep = "SELECT codperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }        
    
            $vsqldesmesrep = "SELECT desperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
            $desmesrep = $clase->SeleccionarUno($vsqldesmesrep);
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
            $mesperiodo = substr($desperiodo,0,-5);
    
            // fechas del periodo
            $fecinicio = substr($desperiodo,-4)."-".substr($codperiodo,0,2)."-01";
            $fecfinal = date("Y-m-t", strtotime($fecinicio));
    
            // Consulta de los periodos de nómina que se van a consultar
            $vsql = "SELECT periodoid 
                       FROM periodosnomina 
                      WHERE descripcion LIKE '%".$mesperiodo."%' 
                            AND descripcion LIKE '%".$yeartoday."%'";
    
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $periodosreportar = mysql_num_rows($result);
    
            // Periodos a procesar
            if($periodosreportar>0)
            {
                $j = 0;
                while($row = mysql_fetch_array($result))
                {
                    $listaperiodos.= $row['periodoid'].",";
                    $segundaquinper = $row['periodoid'];
    
                    $j++;
                    if($j==1)   $pquin = $row['periodoid'];
                    if($j==2)   $squin = $row['periodoid'];
                }
                $listaperiodos = substr($listaperiodos, 0, -1);
            }
    
            // Consulta para determinar los empleados procesados en el periodo seleccionado
            $vsql2 = "SELECT DISTINCT terid
                        FROM hisdetallenomina 
                       WHERE pernominaid IN ($listaperiodos)";
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql2,$conex);
            $numempleados = mysql_num_rows($result);
    
            // -------------------------------------------------------------------------------------------------------------------- //
            // Validación que ambos periodos estén cerrados
            $vsqlvalcerrados = "SELECT COUNT(*) AS amboscerrados
                                  FROM periodosnomina 
                                 WHERE periodoid IN ($listaperiodos)
                                       AND cerrado = 'CHECKED'";
            $amboscerrados = $clase->SeleccionarUno($vsqlvalcerrados);

            // -------------------------------------------------------------------------------------------------------------------- //
            // Validación de la ejecución de los procesos
            if($amboscerrados==2)
            {
                $salidaxls = ' <a href="?opcion=prexls&codperiodo='.$codperiodo.'" title="hoja para le revisi&oacute;n del periodo" target="_blank"> 
                                <img src="images/iconos/exportarexcel2.png" border="0"> 
                               </a>';

                $crudperiodos = ' <a href="?opcion=crudperiodos&codperiodo='.$codperiodo.'" title="crud de periodos" target="_blank"> 
                                   <img src="images/iconos/guardardoc.png" border="0"> 
                                  </a>';

                $corregirnom = ' <a href="?opcion=corregirnom" title="corregir registros del periodo" target="_blank"> 
                                  <img src="images/iconos/aspectos.png" border="0"> 
                                 </a>';

                $btonodebensalir = ' <a href="?opcion=ventnodebensalir&codperiodo='.$codperiodo.'" title="desincorporaci&oacute;n de empleados" target="_blank"> 
                                      <img src="images/iconos/retirados.png" border="0"> 
                                     </a>';
            }
            else
            {
                $salidaxls = '';
                $crudperiodos = '';
                $corregirnom = '';
                $btonodebensalir = '';
            }
    
            // Pinto la vista de la ventana
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/ventatouch.png" width="32" height="32" border="0"> </td>
                      <td width="820"> <b> N&oacute;mina electr&oacute;nica </b> </td>
                      <td width="10"> &nbsp; </td>
                      <td width="10"> '.$salidaxls.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="10"> '.$btonodebensalir.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="10"> '.$crudperiodos.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="10"> '.$corregirnom.' </td>
                      <td width="10"> &nbsp; </td>
                     </tr> 
                    </table>';
            
            // Validación de las quincenas cerradas
            if($amboscerrados==2)
            {
                $token = "";
                $cont.='<form action="nominaelectronica.php?opcion=validatoken" method="POST" name="x" target="_blank">
                        <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                        <center>
                        <table width="100%">
                         <tr class="BarraDocumentos">
                          <td align="center"><br><br><b> Mes a reportar <font color="BLUE"> '.$desmesrep.' </font> </b> </td>
                         </tr>
                        </table>';
                        
                $cont.='<table width="100%">
                         <tr class="BarraDocumentos"> 
                          <td align="center">
                           <br>
                           <label class="Texto12">Token</label><br>
                           <textarea name="token" class="Texto11" cols="120" rows="4" tabindex="4" placeholder="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJEaXNwYXBlbGVzIFMuQS5TIiwiaWF0IjoxNjQ0NTEyNzk2LCJleHAiOjE2NDQ1OTkxOTYsInN1YiI6IjE1MzYiLCJjb250ZXh0Ijp7InVzZXIiOnsidXNlcm5hbWUiOiJVU0RST01FRElDQVNPUklFTlRFIiwiZGlzcGxheU5hbWUiOiJEUk9NRURJQ0FTIERFTCBPUklFTlRFIFMuQS5TIn19fQ.xOJVD6rnlBDcxlAdJyKIWhxp6rL_Ubb1iKP48ygAdxU">'.$token.'</textarea>
                          </td> 
                         </tr>
                         <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                         <tr class="BarraDocumentos"> 
                          <td align="center"> <input type="submit" value="aceptar" class="button blue"> </td>
                         </tr> 
                         <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                        </table>
                        </form>';
            }
            else
                $cont.='<center>
                        <table width="100%">
                         <tr class="BarraDocumentos">
                          <td align="center"><br><br><b> Mes a reportar <font color="BLUE"> '.$desmesrep.' </font> </b> </td>
                         </tr>
                         <tr class="BarraDocumentos"> 
                          <td align="center"> <br> <font color="RED">Este mes no puede ser reportado porque ambas quincenas no han sido cerradas</font> <br> </td>
                         </tr>
                        </table>';
    
            $cont.='<table width="100%"> 
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                     <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                    </table>';
            
            echo $cont;
        }
        else
        {
            $clase->Aviso(2,"Acceso No Permitido");
            header("Location: principal.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: validatoken
    // Creación: 03/03/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que valida la entrada del token para procesar los archivos json
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "validatoken")
    {
        $codperiodo = $_POST['codperiodo'];        
        $token = $_POST['token'];

        if($token=="")
        {
            $clase->Aviso(3,"Debe introducir un token");
            header("Location: nominaelectronica.php?opcion=ventanadatos");
        }
        else
            header("Location: nominaelectronica.php?opcion=confirmarnomina&codperiodo=$codperiodo&token=$token");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarnomina
    // Creación: 16/10/2021		última modificación: 03/03/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que confirma el reporte de nómina electrónica de periodo 
    //              seleccionado
    // Última modificación: Impresión del token en la ventana de confirmación
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarnomina")
    {
        $codperiodo = $_POST['codperiodo'];
        $token = $_POST['token'];

        if($codperiodo=="")         $codperiodo = $_GET['codperiodo'];
        if($token=="")              $token = $_GET['token'];

        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $longtoken = strlen($token);
        $caract = 0;

        // Pinto la vista correspondiente
        $cont = $clase->Header("S","W");
        $cont.='<form action="nominaelectronica.php?opcion=prereportar&codperiodo='.$codperiodo.'&token='.$token.'" method="POST" name="x">
                <table width="100%">
                 <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                 <input type="hidden" name="token" value="'.$token.'">
                 <tr class="CabezoteTabla"> 
                  <td width="10%" align="center"> &nbsp; </td> 
                  <td align="center"> <b> Confirmaci&oacute;n del reporte de n&oacute;mina electr&oacute;nica </b> </td> 
                  <td width="10%" align="center"> 
                   <a href="nominaelectronica.php?opcion=ventanadatos"> 
                    <input type="button" class="button" value="<<"> 
                   </a>
                  </td>
                 </tr> 
                </table>
                <table width="100%">
                 <tr class="CabezoteTabla">	
                  <td width="400" align="center"> 
                   Mediante este proceso se generar&aacute;n los archivos en formato json, <br> 
                   en caso de existir estos se sobrescribir&aacute;n, esta acci&oacute;n no puede ser revertida.
                  </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="400" align="center"> &nbsp; </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="400" align="center"> 
                   Token: '.substr($token,0,80).' <br>';

        // Ciclo para imprimir el token
        while($caract <= $longtoken)
        {
            $caract += 81;
            $cont.=''.substr($token,$caract,80).' <br>';
        }

        $cont.='  </td> 
                 </tr>
                </table>
                <table width="100%">
                 <tr class="CabezoteTabla">				
                  <td width="400" align="center"> ¿Confirma que desea reportar el periodo <b> '.$desperiodo.'</b>? </td> 
                 </tr>
                </table>
                <table width="100%">                 
                 <tr class="CabezoteTabla">                   
                  <td align="center"> <input type="submit" value="aceptar" class="button blue"> </td>
                 </tr> 
                 <tr class="CabezoteTabla"> <td align="center">&nbsp;</td> </tr>
                 <tr class="CabezoteTabla"> <td align="center">&nbsp;</td> </tr>
                 <tr class="CabezoteTabla"> <td align="center">&nbsp;</td> </tr>
                 <tr class="CabezoteTabla"> <td align="center">&nbsp;</td> </tr>
                 <tr class="CabezoteTabla"> <td align="center">&nbsp;</td> </tr>
                 <tr class="CabezoteTabla"> <td align="center">&nbsp;</td> </tr>
                 <tr class="CabezoteTabla"> <td align="center">&nbsp;</td> </tr>
                 <tr class="CabezoteTabla"> <td align="center">&nbsp;</td> </tr>
                </table>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: prereportar
    // Creación: 19/10/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana que le indica al usuario que se está 
    //              reportando la nómina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////      
    if($opcion == "prereportar")
    {
        $codperiodo = $_POST['codperiodo'];
        $token = $_POST['token'];
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
     
        // Pinto la vista correspondiente
        $cont = $clase->Header("S","W");
        $cont.= '<form name="x" method="POST" action="nominaelectronica.php?opcion=generarnomina&codperiodo='.$codperiodo.'&token='.$token.'">
                  <div style="overflow:auto; height:500px;width:950px;">
                   <table width="100%">
                    <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                    <input type="hidden" name="token" value="'.$token.'">
                    <tr class="CabezoteTabla"> 
                     <td width="10"> &nbsp; </td>
                     <td width="37"> <img src="images/iconos/infventaspos.png" width="32" height="32" border="0"> </td>
                     <td width="707"> <b> Reportando n&oacute;mina electr&oacute;nica </b> </td>
                     <td width="183" align="right"> Por favor espere ... </td>
                    </tr>
                   </table>
                   <br>
                   <center>
                   <h3> Reportando el periodo <font color="BLUE">'.$desperiodo.'</font> </h3><br>
                   Por favor no interrumpa el proceso mientras se generan <br>todos los archivos de los empleados<br><br><br>
                   <img src="images/basicas/cargando.gif" border="0">
                   <script language="Javascript">
                    function redireccionar() {  
                     setTimeout("location.href=\'nominaelectronica.php?opcion=generarnomina&codperiodo='.$codperiodo.'&token='.$token.'\'", 3000);
                    }
                    redireccionar();
                   </script>
                   <br><br><br>                   
                   <!-- Contador de tiempo -->
                   <div style="margin: 0px auto; text-align: center; width: 250px;">
                    <img src="images/basicas/1.gif" border="0">
                    <img src="images/basicas/2.gif" border="0">
                    <img src="images/basicas/3.gif" border="0">
                    <img src="images/basicas/4.gif" border="0">
                    <img src="images/basicas/5.gif" border="0">
                   </div>
                  </div>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarxls
    // Creación: 04/11/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que confirma la generación de la hoja de Excel de la nómina 
    //              electrónica
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarxls")
    {
        $codperiodo = $_GET['codperiodo'];
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Pinto la vista correspondiente
        $cont = $clase->Header("S","W");
        $cont.='<form action="nominaelectronica.php?opcion=presalexcel&codperiodo='.$codperiodo.'" method="POST" name="x">
                <table width="100%">
                 <input type="hidden" name="codperiodo" value="'.$codperiodo.'">                      
                 <tr class="CabezoteTabla"> 
                  <td width="10%" align="center"> &nbsp; </td> 
                  <td align="center"> <b> Confirmaci&oacute;n de la salida a Excel de la n&oacute;mina electr&oacute;nica </b> </td> 
                  <td width="10%" align="center"> 
                   <a href="nominaelectronica.php?opcion=ventanadatos"> 
                   <input type="button" class="button" value="<<"> </a>
                  </td>
                 </tr> 
                </table>
                <table width="100%">
                 <tr class="TablaDocsPar">				
                  <td width="400" align="center"> Mediante este proceso se generar&aacute; una hoja de Excel con los </td> 
                 </tr>
                 <tr class="TablaDocsPar">				
                  <td width="400" align="center"> empleados que se reportar&aacute;n en la n&oacute;mina electr&oacute;nica. </td> 
                 </tr>
                 <tr class="TablaDocsPar"> 
                  <td width="400" align="center"> &nbsp; </td> 
                 </tr>
                </table>
                <table width="100%">
                 <tr class="TablaDocsPar">				
                  <td width="400" align="center"> ¿Confirma que desea generar la hoja de Excel del periodo <b> '.$desperiodo.'</b>? </td> 
                 </tr>
                </table>
                <table width="100%">
                 <tr class="TablaDocsPar"> <td align="center">&nbsp;</td> </tr>
                 <tr class="TablaDocsPar">                   
                  <td align="center"> <input type="submit" value="aceptar" class="button blue"> </td>
                 </tr> 
                 <tr class="TablaDocsPar"> <td align="center"> &nbsp; </td> </tr>
                </table>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: presalexcel
    // Creación: 04/11/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para visualizar el contador de tiempo mientras se genera la 
    //              salida a Excel de la nómina electrónica
    // Última modificación:     
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "presalexcel")
    {
        $codperiodo = $_GET['codperiodo'];
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
     
        // Pinto la vista correspondiente
        $cont = $clase->Header("S","W");
        $cont.= '<form name="x" method="POST" action="nominaelectronica.php?opcion=salidaxls&codperiodo='.$codperiodo.'">
                  <div style="overflow:auto; height:500px;width:950px;">
                   <table width="100%">
                    <tr class="CabezoteTabla"> 
                     <td width="10"> &nbsp; </td>
                     <td width="37"> <img src="images/iconos/exportarexcel.png" width="32" height="32" border="0"> </td>
                     <td width="707"> <b> N&oacute;mina electr&oacute;nica en Excel </b> </td>
                     <td width="183" align="right"> Por favor espere ... </td>                     
                    </tr>
                   </table>
                   <br>
                   <center>
                   <h3> Generando el archivo en formato de Excel <br>para el periodo <font color="BLUE">'.$desperiodo.'</font> </h3><br>
                   Por favor no interrumpa el proceso <br><br><br>
                   <img src="images/basicas/cargando.gif" border="0">
                   <script language="Javascript">
                    function redireccionar() {  
                     setTimeout("location.href=\'nominaelectronica.php?opcion=salidaxls&codperiodo='.$codperiodo.'\'", 3000);
                    }
                    redireccionar();
                   </script>
                   <br><br><br>                   
                   <!-- Contador de tiempo -->
                   <div style="margin: 0px auto; text-align: center; width: 250px;">
                    <img src="images/basicas/1.gif" border="0">
                    <img src="images/basicas/2.gif" border="0">
                    <img src="images/basicas/3.gif" border="0">
                    <img src="images/basicas/4.gif" border="0">
                    <img src="images/basicas/5.gif" border="0">
                   </div>
                  </div>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: generarnomina
    // Creación: 15/10/2021		última modificación: 23/07/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera los archivos que se reportarán en la nómina 
    //              electrónica
    // Última modificación: Nuevo ciclo para los empleados con dos quincenas laboradas y 
    //                      liquidación también (01/03/2022)
    //                      Incorporación del ciclo para los empleados solo con liquidación 
    //                      en el periodo (13/12/2022)
    //                      Incorporación del filtro de los empleados excluidos del 
    //                      (12/10/2023)
    //                      Validación de la fecha de ingreso para que no sea mayor al 
    //                      periodo reportado
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "generarnomina")
    {
        // Obtengo el código de periodo
        $codperiodo = $_POST['codperiodo'];
        $token = $_POST['token'];

        if($codperiodo=="")         $codperiodo = $_GET['codperiodo'];
        if($token=="")              $token = $_GET['token'];

        $listadereportados = "";
        $nodebensalir = "";

        // Mes y año del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $mesperiodo = substr($desperiodo,0,-5);
        $yeartoday = date("Y");

        // validación para el caso del año anterior
        if(intval(substr($codperiodo,-4)) != $yeartoday)
            $yeartoday--;

        // fechas del periodo
        $fecinicio = substr($desperiodo,-4)."-".substr($codperiodo,0,2)."-01";
        $fecfinal = date("Y-m-t", strtotime($fecinicio));

        // Consulta de los periodos de nómina que se van a consultar
        $vsql = "SELECT periodoid 
                   FROM periodosnomina 
                  WHERE descripcion LIKE '%".$mesperiodo."%' AND descripcion LIKE '%".$yeartoday."%'";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $periodosreportar = mysql_num_rows($result);

        // Periodos a procesar
        if($periodosreportar>0)
        {
            while($row = mysql_fetch_array($result))
            {
                $listaperiodos.= $row['periodoid'].",";
                $segundaquinper = $row['periodoid'];
            }
            $listaperiodos = substr($listaperiodos, 0, -1);
        }

        // Determino si existen empleados excluidos en el periodo
        $vsql250 = "SELECT terid 
                      FROM noliquida 
                     WHERE periodonomina = '".$codperiodo."' 
                       AND tipo = 'nominaelec'";

        $conex  = $clase->Conectar();
        $result250 = mysql_query($vsql250,$conex);
        $hayexcluidos = mysql_num_rows($result250);

        if($hayexcluidos > 0)
        {
            while($row250 = mysql_fetch_array($result250))
            {
                $nodebensalir.= $row250['terid'].",";
            }
            $nodebensalir = substr($nodebensalir, 0, -1);
        }

        $yearperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','anoperiodo');
        $mesperiodo2 = substr($codperiodo,0,2);

        // Valido si existe la carpeta donde se almacenarán los datos
        $ruta = 'nominaelectronica/';
        $carpetaactual = $ruta.$codperiodo."/";

        if(!file_exists($carpetaactual))
        {
            if ( is_dir( $ruta ) ) 
                mkdir( $carpetaactual );
        }

        $vsql2 = "SELECT DISTINCT terid 
                    FROM hisdetallenomina 
                   WHERE pernominaid IN ($listaperiodos)";

        if(strlen($nodebensalir) > 0)
            $vsql2.= " AND terid NOT IN ($nodebensalir) ";

        // ------------------------------------------------------------------------------------ //
        $conex  = $clase->Conectar();
        $result2 = mysql_query($vsql2,$conex);
        $empleadosreportar = mysql_num_rows($result2);

        // $empleadosreportar = 0;

        if($empleadosreportar>0) 
        {
            // Inicialización de variables
            $consecutivo = 0;                                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $newconsecutivo = "";                                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                                  $vsqlnumcuenta = "";                            $sumar = 0;
            $vsqldotaciones = "";                                           $montodotacion = 0;                             $vsqlnumvacaciones2 = "";
            $numvacaciones2 = 0;                                            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;
            $recargonoc = 0;                                                $recargonocliq = 0;                             $cantidadrn = 0;
            $valorhisdetallenomina = 0;                                     $valordetalleliquidacion = 0;                   $pagorn = 0;
            $devengadoshisdetallenomina = 0;                                $devengadosdetalleliquidacion = 0;              $cantidadhenliq = 0;
            $recargonocdomfes = 0;                                          $recargonocdomfesliq = 0;                       $cantidadhen = 0;
            $cantidaddehen = 0;                                             $montohoraextnocturna = 0;                      $montohoraextnocturnaliq = 0;
            $cantidadhedd = 0;                                              $cantidadheddliq = 0;                           $cantidaddehedd = 0;
            $montohoraextddomliq = 0;                                       $montohoraextdiudom = 0;                        $cantidadhendf = 0;
            $cantidaddehendf = 0;                                           $montohendf = 0;                                $montohendfliq = 0;
            $cantidaddomfes = 0;                                            $cantidaddomfesliq = 0;                         $cantidaddedomfes = 0;
            $montodomfesliq = 0;                                            $montodedomfes = 0;                             $cantidadrecnocdonfes = 0;                      
            $cantidadderecnocdonfes = 0;                                    $montorecnocdonfes = 0;                         $montorecnocdonfesliq = 0;
            $montohorextnoc = 0;                                            $montohoraextddom = 0;                          $cantidadhendfliq = 0;
            $montodehendf = 0;                                              $montodomfes = 0;                               $cantidadrecnocdonfesliq = 0;
            $montoderecnocdonfes = 0;                                       $numrecargos = 0;
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;            

            while($row2 = mysql_fetch_array($result2))
            {
                // id del empleado
                $terid = $row2['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal ='CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);

                if($numnomext<2)
                {
                    // Días trabajados                    
                    $vsqldias = "SELECT SUM(IF(conceptoid = 1,valor,0)) AS diastrab 
                                   FROM hisdetallenomina 
                                  WHERE pernominaid IN ($listaperiodos) 
                                        AND terid = ".$terid."
                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                  FROM periodoterceros
                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                       AND pernominaid IN ($listaperiodos)
                                                                       AND extralegal = 'CHECKED')";
                    $diastrab = $clase->SeleccionarUno($vsqldias);

                    if(($numnomext==1)&&($diastrab==0))
                    {
                        $laboro = false;

                        $vsqlnuminc = "SELECT COUNT(*) AS numinc
                                         FROM periodoterceros pt 
                                              INNER JOIN hisdetallenomina h ON (pt.terid = h.terid AND pt.pernominaid = h.pernominaid) 
                                        WHERE pt.terid = ".$terid." 
                                              AND pt.extralegal <> 'CHECKED' 
                                              AND (h.conceptoid = 10 AND h.valor = 15)";
                        $numincsolo = $clase->SeleccionarUno($vsqlnuminc);

                        $vsqlnumlnr = "SELECT COUNT(*) AS numlnr 
                                         FROM periodoterceros pt 
                                              INNER JOIN hisdetallenomina h ON (pt.terid = h.terid AND pt.pernominaid = h.pernominaid) 
                                        WHERE pt.terid = ".$terid." 
                                              AND pt.extralegal <> 'CHECKED' 
                                              AND (h.conceptoid = 6 AND h.valor = 15)
                                              AND h.pernominaid IN ($listaperiodos)
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid."  
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')";
                        $numlnrsolo = $clase->SeleccionarUno($vsqlnumlnr);

                        if(($numincsolo == 1) || ($numlnrsolo == 1))
                            $laboro = true;
                    }
                    else
                        $laboro = true;

                    if($laboro)
                    {
                        // ----------------------------------------------------------------------------------------------- //
                        $sumar = 0;
                        $numlibranzasliq = 0;
                        $vsqlrep = "SELECT COUNT(*) AS sumar
                                      FROM detalleliquidacion
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos)";
                        $sumar = $clase->SeleccionarUno($vsqlrep);

                        // ----------------------------------------------------------------------------------------------- //
                        // Actualizo los días trabajados
                        if($sumar>0)
                        {
                            $vsqldiasliq = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrabliq 
                                              FROM detalleliquidacion 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND terid = ".$terid."
                                                   AND conceptoid = 1";
                            $diastrabliq = $clase->SeleccionarUno($vsqldiasliq);
                            $diastrab += $diastrabliq;
                        }

                        // Documento del empleado
                        $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                        // Primer apellido
                        $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                        // Segundo apellido
                        $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                        // Primer nombre
                        $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                        // Segundo nombre
                        $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                        // Sueldo básico
                        $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                        // Código del trabajador
                        $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                        // Correo electrónico
                        $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                        // Teléfono
                        $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                        // Número de cuenta
                        $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
    
                        // Tipo de documento
                        $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                        // Banco
                        $vsqlbanco = "SELECT b.descripcion AS banco
                                        FROM periodoterceros p
                                             INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                       WHERE p.terid = ".$terid;
                        $banco = $clase->SeleccionarUno($vsqlbanco);
                        $banco = trim(str_replace("BANCO ","",$banco));
    
                        // cargo del empleado
                        $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');

                        // sueldo del periodo
                        $vsqlsueldo = "SELECT SUM(IF(conceptoid=1,devengados,0)) AS sueldoper 
                                         FROM hisdetallenomina 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid = ".$terid."
                                              AND pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND pernominaid IN ($listaperiodos)
                                                                             AND extralegal = 'CHECKED')";
                        $sueldoper = $clase->SeleccionarUno($vsqlsueldo);

                        if($sumar>0)
                        {
                            $vsqlsueldoliq = "SELECT devengados AS sueldoliq
                                                FROM detalleliquidacion
                                               WHERE terid = ".$terid."
                                                     AND conceptoid = 1
                                                     AND pernominaid IN ($listaperiodos)";
                            $sueldoliq = $clase->SeleccionarUno($vsqlsueldoliq);
                            $sueldoper += $sueldoliq;
                        }
    
                        // Auxilio de transporte
                        $vsqltrasp = "SELECT SUM(IF(conceptoid IN (3,45),devengados,0)) AS auxtransp 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal = 'CHECKED')";
                        $auxtransp = $clase->SeleccionarUno($vsqltrasp);

                        if($sumar>0)
                        {
                            $vsqltransliq = "SELECT devengados AS transliq
                                               FROM detalleliquidacion
                                              WHERE terid = ".$terid."
                                                    AND conceptoid = 3
                                                    AND pernominaid IN ($listaperiodos)";
                            $transliq = $clase->SeleccionarUno($vsqltransliq);
                            $auxtransp += $transliq;
                        }

                        // Recargo nocturno
                        $vsqlrecargonoc = "SELECT SUM(IF(conceptoid IN (47,56,59),devengados,0)) AS recargonoc 
                                             FROM hisdetallenomina 
                                            WHERE pernominaid IN ($listaperiodos) 
                                                  AND terid = ".$terid."
                                                  AND pernominaid NOT IN (SELECT pernominaid 
                                                                            FROM periodoterceros 
                                                                           WHERE periodoterceros.terid = ".$terid." 
                                                                                 AND pernominaid IN ($listaperiodos)
                                                                                 AND extralegal = 'CHECKED')";
                        $recargonoc = $clase->SeleccionarUno($vsqlrecargonoc);

                        if($sumar>0)
                        {
                            $vsqlrecargonocliq = "SELECT devengados AS recargonocliq
                                                    FROM detalleliquidacion
                                                   WHERE terid = ".$terid."
                                                         AND conceptoid IN (47,56,59) 
                                                         AND pernominaid IN ($listaperiodos)";
                            $recargonocliq = $clase->SeleccionarUno($vsqlrecargonocliq);
     
                            $recargonoc += $recargonocliq;
                        }

                        // hora extra diurna
                        $horaextradiurna = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 49,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $horaextradiurnaliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 49 AND pernominaid IN ($listaperiodos)");
                            $horaextradiurna += $horaextradiurnaliq;
                        }

                        // hora extra nocturna
                        $horaextranocturna = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 50,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $horaextranocturnaliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 50 AND pernominaid IN ($listaperiodos)");
                            $horaextranocturna += $horaextranocturnaliq;
                        }

                        // hora extra diurna dominical
                        $horaextradiurnadom = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 51,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $horaextradiurnadomliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 51 AND pernominaid IN ($listaperiodos)");
                            $horaextradiurnadom += $horaextradiurnadomliq;
                        }

                        // hora extra nocturna dominical y festivo
                        $horaextradnocturnadomfes = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 52,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $horaextradnocturnadomfesliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 52 AND pernominaid IN ($listaperiodos)");
                            $horaextradnocturnadomfes += $horaextradnocturnadomfesliq;
                        }

                        // domingos y festivos
                        $domingosyfestivos = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 53,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $domingosyfestivosliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 53 AND pernominaid IN ($listaperiodos)");
                            $domingosyfestivos += $domingosyfestivosliq;
                        }

                        // recargo nocturno dominical y festivo
                        $recargonocdomfes = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 54,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $recargonocdomfesliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 54 AND pernominaid IN ($listaperiodos)");
                            $recargonocdomfes += $recargonocdomfesliq;
                        }

                        // total de recargos
                        $numrecargos = $recargonoc + $horaextradiurna + $horaextranocturna + $horaextradiurnadom + $horaextradnocturnadomfes + $domingosyfestivos + $recargonocdomfes;
    
                        // Embargo                        
                        $vsqlembg = "SELECT SUM(IF(conceptoid = 30,descuentos,0)) AS embargo 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND pernominaid IN ($listaperiodos)
                                                                           AND extralegal = 'CHECKED')";
                        $embargo = $clase->SeleccionarUno($vsqlembg);

                        if($sumar>0)
                        {
                            $vsqlembliq = "SELECT descuentos AS embliq
                                             FROM detalleliquidacion
                                            WHERE terid = ".$terid."
                                                  AND conceptoid = 30
                                                  AND pernominaid IN ($listaperiodos)";
                            $embliq = $clase->SeleccionarUno($vsqlembliq);
                            $embargo += $embliq;
                        }
    
                        // Salud                        
                        $vsqlsalud = "SELECT SUM(IF(conceptoid = 5,descuentos,0)) AS salud 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal = 'CHECKED')";
                        $salud = $clase->SeleccionarUno($vsqlsalud);

                        if($sumar>0)
                        {
                            $vsqlsaludliq = "SELECT descuentos AS saludliq
                                               FROM detalleliquidacion
                                              WHERE terid = ".$terid."
                                                    AND conceptoid = 5
                                                    AND pernominaid IN ($listaperiodos)";
                            $saludliq = $clase->SeleccionarUno($vsqlsaludliq);
                            $salud += $saludliq;
                        }
    
                        // Pensión                        
                        $vsqlpension = "SELECT SUM(IF(conceptoid = 4,descuentos,0)) AS pension 
                                          FROM hisdetallenomina 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                        $pension = $clase->SeleccionarUno($vsqlpension);

                        if($sumar>0)
                        {
                            $vsqlpesionliq = "SELECT descuentos AS pesionliq
                                                FROM detalleliquidacion
                                               WHERE terid = ".$terid."
                                                     AND conceptoid = 4
                                                     AND pernominaid IN ($listaperiodos)";
                            $pesionliq = $clase->SeleccionarUno($vsqlpesionliq);
                            $pension += $pesionliq;
                        }

                        // ------------------------------------------------------------------------------------------------------- //                        
                        // total devengado
                        $vsqldev = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                      FROM hisdetallenomina 
                                     WHERE terid = ".$terid."
                                           AND pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND pernominaid IN ($listaperiodos)
                                                                          AND extralegal = 'CHECKED')";
                        $devengados = $clase->SeleccionarUno($vsqldev);

                        if($sumar>0)
                        {
                            $vsqldevliq = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                             FROM detalleliquidacion 
                                            WHERE terid = ".$terid."";
                            $devengadosliq = $clase->SeleccionarUno($vsqldevliq);
                            $devengados += $devengadosliq;
                        }
    
                        // total descuentos                        
                        $vsqldesc = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND pernominaid IN ($listaperiodos)
                                                                           AND extralegal = 'CHECKED')";
                        $descuentos = $clase->SeleccionarUno($vsqldesc);

                        if($sumar>0)
                        {
                            $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                              FROM detalleliquidacion 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND terid = ".$terid."";
                            $descuentosliq = $clase->SeleccionarUno($vsqldescliq);
                            $descuentos += $descuentosliq;
                        }
                        // ------------------------------------------------------------------------------------------------------- //
                        $neto = $devengados - $descuentos;
    
                        // Obtengo la fecha de ingreso del empleado
                        $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');

                        $fechaEntera = strtotime($fecingreso);
                        $mesfecingreso = date("m", $fechaEntera);
                        $yeaarfecingreso = date("Y", $fechaEntera);

                        if(($mesfecingreso > $mesperiodo2) && (intval($yearperiodo) == intval($yeaarfecingreso)))
                        {
                            // fechas de ingreso y retiro
                            $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                            $idhistorico = $clase->SeleccionarUno($vsql18);

                            $vsql21 = "SELECT hc.fecingreso 
                                         FROM histcontrato hc 
                                        WHERE hc.terid = ".$terid." 
                                              AND hc.id = ".$idhistorico;
                            $fecingreso = $clase->SeleccionarUno($vsql21);

                            if($fecingreso == "")
                                $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
                        }
    
                        // ------------------------------------------------------------------------------------------------------------------------------------------------------- //
                        // Nota: esto en temporal mientras se implementa el registro de fechas de las incapacidades en un periodo
                        // Incapacidades del periodo
                        $vsqlincapacidad = "SELECT COUNT(*) AS numincap 
                                              FROM hisdetallenomina 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND conceptoid IN (10,40,43)
                                                   AND terid = ".$terid."
                                                   AND pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal = 'CHECKED')";
                        $numincap = $clase->SeleccionarUno($vsqlincapacidad);

                        $vsqlincapacidad2 = "SELECT COUNT(*) AS numincap
                                               FROM detalleliquidacion 
                                              WHERE pernominaid IN ($listaperiodos) 
                                                    AND terid = ".$terid."
                                                    AND conceptoid IN (10,40,43)";
                        $numincap2 = $clase->SeleccionarUno($vsqlincapacidad2);
    
                        if($numincap>0)
                        {
                            // Cantidad de la incapacidad
                            $vsqlcantincap = "SELECT SUM(valor) AS diasincap 
                                                FROM hisdetallenomina 
                                               WHERE pernominaid IN ($listaperiodos) 
                                                     AND conceptoid IN (10,40,43) 
                                                     AND terid = ".$terid."
                                                     AND pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND pernominaid IN ($listaperiodos)
                                                                                    AND extralegal = 'CHECKED')";
                            $diasincap = $clase->SeleccionarUno($vsqlcantincap);

                            $vsqlcantincap2 = "SELECT IFNULL(SUM(valor),0) AS diasincap 
                                                 FROM detalleliquidacion 
                                                WHERE pernominaid IN ($listaperiodos) 
                                                      AND terid = ".$terid."
                                                      AND conceptoid IN (10,40,43)";
                            $diasincap2 = $clase->SeleccionarUno($vsqlcantincap2);

                            $diasincap += $diasincap2;
    
                            // Fecha de inicio
                            $feciniincap = $fecinicio;
    
                            // Fecha final
                            $fecfinincap = date("Y-m-d",strtotime($feciniincap."+ $diasincap days"));
                        }
                        
                        // ------------------------------------------------------------------------------------------------------------------------------------------------------- //
                        // Licencias del periodo
                        $vsqlincapacidad = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                              FROM hisdetallenomina h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND c.eslicencia ='CHECKED' 
                                                   AND c.tipodc = 'C' 
                                                   AND h.conceptoid NOT IN (10,9,43,40,58) 
                                                   AND h.terid = ".$terid."
                                                   AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND pernominaid IN ($listaperiodos)
                                                                                    AND extralegal = 'CHECKED')";
                        $numlicencias = $clase->SeleccionarUno($vsqlincapacidad);

                        $vsqlincapacidad2 = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                               FROM detalleliquidacion h
                                                    INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                              WHERE h.pernominaid IN ($listaperiodos)
                                                    AND c.eslicencia = 'CHECKED' 
                                                    AND c.tipodc = 'C' 
                                                    AND h.conceptoid NOT IN (10,9,43,40,58) 
                                                    AND h.terid = ".$terid;
                        $numlicencias2 = $clase->SeleccionarUno($vsqlincapacidad2);

                        // $numlicencias += $numlicencias2;
                        
                        // Libranzas del periodo
                        $vsqllibranzas = "SELECT COUNT(h.conceptoid) AS numlibranzas 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                                 AND h.terid = ".$terid."
                                                 AND c.conceptoid NOT IN (10,30)
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal = 'CHECKED')";
                        $numlibranzas = $clase->SeleccionarUno($vsqllibranzas);

                        if($sumar>0)
                        {
                            $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                                   FROM detalleliquidacion h
                                                        INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                                  WHERE h.pernominaid IN ($listaperiodos)
                                                        AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                                        AND h.terid=".$terid."
                                                        AND c.conceptoid NOT IN (10,30)";
                            $numlibranzasliq = $clase->SeleccionarUno($vsqllibranzasliq);
                        }
    
                        // Sanciones del periodo
                        $vsqlsanciones = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid = 9
                                                 AND h.terid = ".$terid."
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal = 'CHECKED')";
                        $numsanciones = $clase->SeleccionarUno($vsqlsanciones);

                        // Otras deducciones
                        // Estas incluyen: LICENCIA NO REMUNERADA, CAMISETAS, PLAN TELEFONIA MOVIL, PRESTAMOS PERSONALES, AJUSTE SALARIO SENA, 
                        // CREDITOS OTROS NEGOCIOS, DESCUENTO SP, MANGAS, CAFETERIA, MACROPAPELES, COMPRAS A CREDITO, OTROS E INCAPACIDAD SUPERIOR A 180 DÍAS,
                        // DIAS NO LABORADOS SIN JUSTIFICACION
                        $vsqlotrasdeduc = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                                  AND h.terid = ".$terid."
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND pernominaid IN ($listaperiodos)
                                                                                   AND extralegal = 'CHECKED')";
                        $numotrasded = $clase->SeleccionarUno($vsqlotrasdeduc);

                        if($sumar>0)
                        {
                            $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                                    FROM detalleliquidacion h
                                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                                   WHERE h.pernominaid IN ($listaperiodos)
                                                         AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                                         AND h.terid = ".$terid."";
                            $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);
                        }

                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Conceptos de liquidación

                        // Vacaciones
                        $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'vacaciones'";
                        $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                        // Vacaciones pagadas en quincenas
                        $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2 
                                                 FROM hisdetallenomina 
                                                WHERE terid = ".$terid."
                                                      AND conceptoid = 38 
                                                      AND pernominaid IN ($listaperiodos)";
                        $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                        $numvacacionest = $numvacaciones1 + $numvacaciones2;

                        // Primas
                        $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $numprimas = $clase->SeleccionarUno($vsqlnumprimas);

                        // Cesantías
                        $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);

                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                        // Indemnización
                        $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Otros conceptos devengados
                        $vsqlotrosdeven = "SELECT COUNT(h.conceptoid) AS numotrosdeven
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid IN (37,48) 
                                                  AND h.terid = ".$terid."
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND pernominaid IN ($listaperiodos)
                                                                                   AND extralegal = 'CHECKED')";
                        $numotrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Dotaciones 
                        $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                             FROM dotaciones
                                            WHERE periodonomina = '".$codperiodo."'
                                                  AND terid = ".$terid."";
                        $montodotacion = $clase->SeleccionarUno($vsqldotaciones);

                        // ------------------------------------------------------------------------------------------------------------------------------------ //    
                        // Genero el código consecutivo de nómina electrónica
                        $consecutivone = $clase->BDLockup($segundaquinper,'periodosnomina','periodoid','consecutivone');
    
                        // Valido si es el primero o el siguiente
                        if($consecutivone=="")
                        {
                            $newper = substr($codperiodo,0,2).substr($codperiodo,-2);
                            $newcod = $newper."00001";
                            $newconsecutivo = "NE".$newcod;
                        }
                        else
                        {
                            // Incremento el consecutivo
                            $numconsn = intval(substr($consecutivone,-5));
                            $numconsn++;
                            $newcod = strval($numconsn);
    
                            // Relleno con ceros
                            if(strlen($newcod)==1)      $newcod = "0000".$newcod;
                            if(strlen($newcod)==2)      $newcod = "000".$newcod;
                            if(strlen($newcod)==3)      $newcod = "00".$newcod;
                            if(strlen($newcod)==4)      $newcod = "0".$newcod;

                            $newper = substr($codperiodo,0,2).substr($codperiodo,-2);
                            $newcod = $newper.$newcod;
    
                            // Construyo el nuevo consecutivo
                            $newconsecutivo = "NE".$newcod;
                        }
    
                        // Almacenos en la tabla el nuevo consecutivo
                        $vsqlactcons = "UPDATE periodosnomina SET 
                                               consecutivone = '".$newconsecutivo."'
                                         WHERE periodoid = ".$segundaquinper;
                        $clase->EjecutarSQL($vsqlactcons);
    
                        $prefijo = substr($newconsecutivo,0,2);
                        
                        // ------------------------------------------------------------------------------------------------------------------------------------------------------- //
                        // Construyo el json con los datos del empleado
                        $json='{'.Chr(13).Chr(10);
                        $json.= Chr(9).'"idEmpresa": "1536",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"token": "'.str_pad($token,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"tipoDocumento": "1",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'"tipoNotaDocumento": "",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"almacenamiento": "1",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'"redondeo": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'"devengadosTotal": "'.str_pad(number_format($devengados,0),1,"").'",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'"deduccionesTotal": "'.str_pad(number_format($descuentos,0),1,"").'",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'"comprobanteTotal": "'.str_pad(number_format($neto,0),1,"").'",'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'"listaNotas": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'],'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"listaFechaPago": ['.Chr(13).Chr(10);
                        $json.= Chr(9).'  "'.str_pad($fecinicio,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "'.str_pad($fecfinal,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'],'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"periodo": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaIngreso": "'.str_pad($fecingreso,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaLiquidacionInicio": "'.str_pad($fecinicio,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaLiquidacionFin": "'.str_pad($fecfinal,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tiempoLaborado": "'.str_pad($diastrab,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaGen": "'.str_pad($fechaAct,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"numeroSecuenciaXML": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "prefijo": "'.str_pad($prefijo,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "consecutivo": "'.str_pad($newcod,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"lugarGeneracionXML": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "pais": "CO",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "departamentoEstado": "54",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "municipioCiudad": "54001",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "idioma": "es"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"informacionGeneral": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaGen": "'.str_pad($fechaAct,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "horaGen": "'.str_pad($horaAct,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "periodoNomina": "5",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "tipoMoneda": "COP",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "trm": ""'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tipoMoneda": "COP"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"trabajador": {'.Chr(13).Chr(10);
    
                        // // determino el tipo de trabajador de acuerdo al cargo
                        // switch($cargoid)
                        // {
                        //     case 71:
                        //         $json.= Chr(9).'  "tipoTrabajador": "19",'.Chr(13).Chr(10);
                        //         break;
                        //     case 70:
                        //         $json.= Chr(9).'  "tipoTrabajador": "12",'.Chr(13).Chr(10);
                        //         break;
                        //     default:
                        //         $json.= Chr(9).'  "tipoTrabajador": "01",'.Chr(13).Chr(10);
                        //         break;
                        // }

                        $json.= Chr(9).'  "tipoTrabajador": "01",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "subTipoTrabajador": "00",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "altoRiesgoPension": "true",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tipoDocumento": "13",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "numeroDocumento": "'.str_pad($dni,1,"").'",'.Chr(13).Chr(10);
                        if($primerapellido!="")      $json.= Chr(9).'  "primerApellido": "'.str_pad($primerapellido,1,"").'",'.Chr(13).Chr(10);
                        if($segundoapellido!="")     $json.= Chr(9).'  "segundoApellido": "'.str_pad($segundoapellido,1,"").'",'.Chr(13).Chr(10);
                        if($primernombre!="")        $json.= Chr(9).'  "primerNombre": "'.str_pad($primernombre,1,"").'",'.Chr(13).Chr(10);
                        if(trim($segundonombre)!="") $json.= Chr(9).'  "otrosNombres": "'.str_pad($segundonombre,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoPais": "CO",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoDepartamentoEstado": "54",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoMunicipioCiudad": "54001",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoDireccion": "AVENIDA 7A # 0BN38 BARRIO SEVILLA",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "salarioIntegral": "false",'.Chr(13).Chr(10);
    
                        // determino el tipo de contrato de acuerdo al cargo
                        $json.= Chr(9).'  "tipoContrato": "1",'.Chr(13).Chr(10);
                        // if(($cargoid==38)||($cargoid==44))
                        //     $json.= Chr(9).'  "tipoContrato": "5",'.Chr(13).Chr(10);
                        // else
                        //     $json.= Chr(9).'  "tipoContrato": "1",'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'  "sueldo": "'.str_pad($basico,1,"").'"'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "codigoTrabajador": "'.str_pad($codvende,1,"").'"'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "correoElectronico": "'.str_pad($email,1,"").'",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "telefono": "'.str_pad($telmovil,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        // valido que el número de cuenta esté vacío
                        $json.= Chr(9).'"pago": {'.Chr(13).Chr(10);
                        if($numcuenta!="")
                        {
                            $json.= Chr(9).'  "forma": "1",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "metodo": "45",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "banco": "'.str_pad($banco,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "tipoCuenta": "AHORROS",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "numeroCuenta": "'.str_pad($numcuenta,1,"").'"'.Chr(13).Chr(10);
                        }
                        else
                        {                            
                            $json.= Chr(9).'  "forma": "1",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "metodo": "10"'.Chr(13).Chr(10);
                        }
                        
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
                        $json.= Chr(9).'"devengados": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "dotacion": "",'.Chr(13).Chr(10);
                        if($montodotacion>0)
                        {
                            $json.= Chr(9).'   "dotacion": "'.str_pad($montodotacion,1,"").'",'.Chr(13).Chr(10);
                            $devengados += $montodotacion;
                        }

                        // $json.= Chr(9).'  "apoyoSost": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "teletrabajo": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "bonifRetiro": "",'.Chr(13).Chr(10);

                        if($numindemnizacion>0)
                        {
                            // Pago por la indemnización
                            $vsqlindemnizacion = "SELECT pago AS pagoindemnizacion
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'indemnizacion'";
                            $pagoindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);

                            // Imprimo la indemnización
                            $json.= Chr(9).'  "indemnizacion": "'.str_pad($pagoindemnizacion,1,"").'",'.Chr(13).Chr(10);

                            // Incremento del devengado
                            $devengados += $pagoindemnizacion;
                        }

                        // $json.= Chr(9).'  "indemnizacion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "reintegro": "",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "basico": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'     "diasTrabajados": "'.str_pad($diastrab,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'     "sueldoTrabajado": "'.str_pad($sueldoper,1,"").'"'.Chr(13).Chr(10);

                        if(($auxtransp>0)||($numrecargos>0)||($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0)||($numpagocesan>0))
                            $json.= Chr(9).'  },'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'  }'.Chr(13).Chr(10);                        
                        
                        if($auxtransp>0)
                        {
                            $json.= Chr(9).'  "transporte": ['.Chr(13).Chr(10);
                            $json.= Chr(9).'     {'.Chr(13).Chr(10);
                            $json.= Chr(9).'       "auxilioTransporte": "'.str_pad($auxtransp,1,"").'"'.Chr(13).Chr(10);
                            $json.= Chr(9).'     }'.Chr(13).Chr(10);

                            if(($numrecargos>0)||($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0)||($numpagocesan>0))
                                $json.= Chr(9).'  ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'  ]'.Chr(13).Chr(10);
                        }

                        // Recargo nocturno
                        if($numrecargos > 0)
                        {
                            $json.= Chr(9).'   "listaHeR": ['.Chr(13).Chr(10);

                            $vsql30  = "SELECT SUM(valor) AS cantidad, 
                                               CASE
                                                 WHEN conceptoid = 47 THEN '35.00'
                                                 WHEN conceptoid = 49 THEN '25.00'
                                                 WHEN conceptoid = 50 THEN '75.00'           
                                                 WHEN conceptoid = 51 THEN '105.00' 
                                                 WHEN conceptoid = 52 THEN '155.00'
                                                 WHEN conceptoid = 53 THEN '80.00'         
                                                 WHEN conceptoid = 54 THEN '115.00'
                                                 WHEN conceptoid = 56 THEN '35.00'
                                                 WHEN conceptoid = 59 THEN '35.00'
                                               END porcentaje,
                                               SUM(devengados) AS pago,  
                                               CASE
                                                 WHEN conceptoid = 47 THEN '3'
                                                 WHEN conceptoid = 49 THEN '1'
                                                 WHEN conceptoid = 50 THEN '2'           
                                                 WHEN conceptoid = 51 THEN '4' 
                                                 WHEN conceptoid = 52 THEN '6'
                                                 WHEN conceptoid = 53 THEN '5'         
                                                 WHEN conceptoid = 54 THEN '7'
                                                 WHEN conceptoid = 56 THEN '3'
                                                 WHEN conceptoid = 59 THEN '3'
                                               END tipoHeR,
                                               CASE
                                                 WHEN conceptoid = 47 THEN 'Hora Recargo Nocturno'
                                                 WHEN conceptoid = 49 THEN 'Hora Extra Diurna'
                                                 WHEN conceptoid = 50 THEN 'Hora Extra Nocturna'           
                                                 WHEN conceptoid = 51 THEN 'Hora Extra Diurna Dominical y Festivos' 
                                                 WHEN conceptoid = 52 THEN 'Hora Extra Nocturna Dominical y Festivos'
                                                 WHEN conceptoid = 53 THEN 'Hora Recargo Diurno Dominical y Festivos'         
                                                 WHEN conceptoid = 54 THEN 'Hora Recargo Nocturno Dominical y Festivos'
                                                 WHEN conceptoid = 56 THEN 'Hora Recargo Nocturno'
                                                 WHEN conceptoid = 59 THEN 'Hora Recargo Nocturno'
                                               END descripcion            
                                          FROM hisdetallenomina 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND conceptoid IN (47,49,50,51,52,53,54,56,59) 
                                               AND terid = ".$terid." 
                                               AND pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros p
                                                                        WHERE p.terid = ".$terid."  
                                                                              AND p.pernominaid IN ($listaperiodos)
                                                                              AND p.extralegal = 'CHECKED')
                                      GROUP BY conceptoid";

                            $conex  = $clase->Conectar();
                            $result30 = mysql_query($vsql30,$conex);
                            $cant1 = mysql_num_rows($result30);             $cant2 = 0;
                            while($row30 = mysql_fetch_array($result30))
                            {                                
                                $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "cantidad": "'.str_pad($row30['cantidad'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "porcentaje": "'.str_pad($row30['porcentaje'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "pago": "'.str_pad($row30['pago'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "tipoHeR": "'.str_pad($row30['tipoHeR'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "descripcion": "'.str_pad($row30['descripcion'],1,"").'"'.Chr(13).Chr(10);                                

                                $cant2++;

                                if($cant2 < $cant1)
                                    $json.= Chr(9).'         },'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'         }'.Chr(13).Chr(10);
                            }
                            // -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------//                            

                            if(($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0)||($numpagocesan>0))
                                $json.= Chr(9).'  ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'  ]'.Chr(13).Chr(10);
                            // -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------//
                        }

                        // primas del empleado
                        if($numprimas>0)
                        {
                            $json.= Chr(9).'"  primas": {'.Chr(13).Chr(10);

                            // Días de la prima
                            $vsqlcanprimas = "SELECT cantidad AS canprimas
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'primas'";
                            $canprimas = $clase->SeleccionarUno($vsqlcanprimas);

                            // Pago de la prima
                            $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                                 FROM liquidacion
                                                WHERE terid = ".$terid."
                                                      AND periodonomina = '".$codperiodo."' 
                                                      AND tipo = 'primas'";
                            $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);

                            $json.= Chr(9).'     "cantidad": "'.str_pad($canprimas,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'     "pago": "'.str_pad($pagoprimas,1,"").'"'.Chr(13).Chr(10);
                                                          
                            if(($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0)||($numpagocesan>0))
                                $json.= Chr(9).'   },'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'   }'.Chr(13).Chr(10);

                            // Incremento el total devengado
                            $devengados += $pagoprimas;
                        }

                        // $json.= Chr(9).'"  primas": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'     "cantidad": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'     "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'     "pagoNS": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   },'.Chr(13).Chr(10);

                        // Cesantías del empleado
                        if($numcesantias>0)
                        {                                
                            // Pago de la cesantía
                            $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);

                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia += $montopagocesan;
                            }

                            // Porcentaje cesantía
                            $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);

                            // Pago de intereses de cesantías
                            $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'cesantias'";
                            $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);

                            $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "pago": "'.str_pad($pagocesantia,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "porcentaje": "'.str_pad(number_format($porccesantia,2),1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "pagoIntereses": "'.str_pad($pagointereses,1,"").'"'.Chr(13).Chr(10);
                               
                            if(($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0))
                                $json.= Chr(9).'   },'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'   }'.Chr(13).Chr(10);

                            // Incremento el total devengado
                            $devengados += $pagocesantia;
                            $devengados += $pagointereses;
                        }
                        else
                        {
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia = $montopagocesan;

                                $porccesantia = 0;
                                $pagointereses = 0;
    
                                $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                                $json.= Chr(9).'      "pago": "'.str_pad($pagocesantia,1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'      "porcentaje": "'.str_pad(number_format($porccesantia,2),1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'      "pagoIntereses": "'.str_pad($pagointereses,1,"").'"'.Chr(13).Chr(10);
    
                                if(($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0))
                                    $json.= Chr(9).'   },'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                                // Incremento el total devengado
                                $devengados += $pagocesantia;
                            }
                        }

                        // $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "porcentaje": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "pagoIntereses": ""'.Chr(13).Chr(10);

                        // if($numvacaciones==0)
                        //     $json.= Chr(9).'   },'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'   "listaHeR": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "horaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "horaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "cantidad": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "porcentaje": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "tipoHeR": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "horaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "horaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "cantidad": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "porcentaje": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "tipoHeR": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "horaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "horaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "cantidad": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "porcentaje": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'          "tipoHeR": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      ],'.Chr(13).Chr(10);

                        // Vacaciones del empleado
                        if($numvacacionest>0)
                        {
                            $json.= Chr(9).'      "listaVacaciones": ['.Chr(13).Chr(10);
                            $json.= Chr(9).'         {'.Chr(13).Chr(10);

                            if($numvacaciones1 > 0)
                            {
                                // Días de vacaciones
                                $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                        FROM liquidacion
                                                       WHERE terid=".$terid."
                                                             AND periodonomina = '".$codperiodo."' 
                                                             AND tipo = 'vacaciones'";
                                $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                                // Pago de vacaciones
                                $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                                   FROM liquidacion
                                                  WHERE terid=".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'vacaciones'";
                                $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                            }
                            else
                            {
                                $canvacaciones = 0;
                                $pagovaca1 = 0;
                            }

                            if($numvacaciones2>0)
                            {
                                $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                    FROM hisdetallenomina  
                                                   WHERE terid = ".$terid."
                                                         AND conceptoid = 38 
                                                         AND pernominaid IN ($listaperiodos)";
                                $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                            }
                            else
                                $pagovaca2 = 0;
                            
                            if($canvacaciones == 0)               $canvacaciones = 1;
                            $pagovaca = $pagovaca1 + $pagovaca2;

                            $json.= Chr(9).'            "cantidad": "'.str_pad($canvacaciones,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "pago": "'.str_pad($pagovaca,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "tipoVacacion": "1"'.Chr(13).Chr(10);
                            $json.= Chr(9).'         }'.Chr(13).Chr(10);
                               
                            if(($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0))
                                $json.= Chr(9).'],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).']'.Chr(13).Chr(10);

                            // Incremento el total devengado
                            $devengados += $pagovaca1;
                        }
                        
                        // $json.= Chr(9).'      "listaVacaciones": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "cantidad": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoVacacion": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "cantidad": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoVacacion": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "cantidad": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoVacacion": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'],'.Chr(13).Chr(10);
                        
                        // Incluyo las incapacidades
                        if(($numincap>0) || ($numincap2>0))
                        {
                            $json.= Chr(9).'      "listaIncapacidades": ['.Chr(13).Chr(10);
                            
                            if($numincap>0)
                            {
                                $i = 0;

                                // Consulta con los datos que se incluirán en el json
                                $vsql5 = "SELECT valor, devengados
                                            FROM hisdetallenomina 
                                           WHERE pernominaid IN ($listaperiodos) 
                                                 AND conceptoid IN (10,40) 
                                                 AND terid = ".$terid."
                                                 AND pernominaid NOT IN (SELECT pernominaid 
                                                                           FROM periodoterceros
                                                                          WHERE periodoterceros.terid = ".$terid." 
                                                                                AND pernominaid IN ($listaperiodos)
                                                                                AND extralegal = 'CHECKED')";
                                $conex  = $clase->Conectar();
                                $result5 = mysql_query($vsql5,$conex);
                                while($row5 = mysql_fetch_array($result5))
                                {
                                    $feciniincap = $fecinicio;
                                    $diasincap = $row5['valor'];
                                    $fecfinincap = date("Y-m-d",strtotime($feciniincap."+ $diasincap days"));
        
                                    $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                    // $json.= Chr(9).'            "fechaInicio": "'.str_pad($feciniincap,1,"").'",'.Chr(13).Chr(10);
                                    // $json.= Chr(9).'            "fechaFin": "'.str_pad($fecfinincap,1,"").'",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "cantidad": "'.str_pad($row5['valor'],1,"").'",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "tipo": "3",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "pago": "'.str_pad($row5['devengados'],1,"").'"'.Chr(13).Chr(10);
        
                                    $i++;
                                    if(($i==$numincap) && ($numincap2==0))
                                        $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'         },'.Chr(13).Chr(10);
                                }
                            }

                            if($numincap2>0)
                            {
                                $i = 0;

                                // Consulta con los datos que se incluirán en el json
                                $vsql5 = "SELECT valor, devengados
                                            FROM detalleliquidacion  
                                           WHERE pernominaid IN ($listaperiodos) 
                                                 AND conceptoid IN (10,40) 
                                                 AND terid = ".$terid;
                                $conex  = $clase->Conectar();
                                $result5 = mysql_query($vsql5,$conex);
                                while($row5 = mysql_fetch_array($result5))
                                {
                                    $feciniincap = $fecinicio;
                                    $diasincap = $row5['valor'];
                                    $fecfinincap = date("Y-m-d",strtotime($feciniincap."+ $diasincap days"));
        
                                    $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "cantidad": "'.str_pad($row5['valor'],1,"").'",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "tipo": "3",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "pago": "'.str_pad($row5['devengados'],1,"").'"'.Chr(13).Chr(10);
        
                                    $i++;
                                    if($i==$numincap2)
                                        $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'         },'.Chr(13).Chr(10);
                                }
                            }

                            if(($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0))
                                $json.= Chr(9).'      ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'      ]'.Chr(13).Chr(10);

                        }
                        
                        // Incluyo las licencias                        
                        if(($numlicencias>0) || ($numlicencias2>0))
                        {
                            $json.= Chr(9).'      "listaLicencias": ['.Chr(13).Chr(10);

                            if($numlicencias>0)
                            {
                                $i = 0;
    
                                // Consulta con los datos que se incluirán en el json
                                $vsql3 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND c.eslicencia = 'CHECKED' 
                                                 AND c.tipodc = 'C' 
                                                 AND h.conceptoid NOT IN (10,9,43,40,58) 
                                                 AND h.terid = ".$terid."
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                  AND periodoterceros.extralegal ='CHECKED')";
                                $conex  = $clase->Conectar();
                                $result3 = mysql_query($vsql3,$conex);
        
                                while($row3 = mysql_fetch_array($result3))
                                {
                                    $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "cantidad": "'.str_pad($row3['valor'],1,"").'",'.Chr(13).Chr(10);
        
                                    if($row3['tipodc']=="C")
                                        $json.= Chr(9).'            "pago": "'.str_pad($row3['devengados'],1,"").'",'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'            "pago": "'.str_pad($row3['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                    
                                    // Licencias de maternidad o paternidad
                                    if(($row3['conceptoid']==11)||($row3['conceptoid']==12))
                                        $json.= Chr(9).'            "tipoLicencia": "1"'.Chr(13).Chr(10);
    
                                    // Licencias remunerada
                                    if(($row3['conceptoid']==10)||($row3['conceptoid']==13)||($row3['conceptoid']==23)||($row3['conceptoid']==31)||($row3['conceptoid']==40)||($row3['conceptoid']==46))
                                        $json.= Chr(9).'            "tipoLicencia": "2"'.Chr(13).Chr(10);
                                    
                                    // Licencias no remunerada
                                    if(($row3['conceptoid']==6)||($row3['conceptoid']==9)||($row3['conceptoid']==43)||($row3['conceptoid']==58))
                                        $json.= Chr(9).'            "tipoLicencia": "3"'.Chr(13).Chr(10);

                                    $i++;
                                    if(($i==$numlicencias) && ($numlicencias2==0))
                                        $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'         },'.Chr(13).Chr(10);
                                }
                            }

                            if($numlicencias2>0)
                            {
                                $i = 0;
    
                                // Consulta con los datos que se incluirán en el json
                                $vsql3 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND c.eslicencia ='CHECKED' 
                                                 AND c.tipodc = 'C' 
                                                 AND h.conceptoid NOT IN (10,9,43,40,58) 
                                                 AND h.terid = ".$terid;
                                $conex  = $clase->Conectar();
                                $result3 = mysql_query($vsql3,$conex);
        
                                while($row3 = mysql_fetch_array($result3))
                                {
                                    $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "cantidad": "'.str_pad($row3['valor'],1,"").'",'.Chr(13).Chr(10);
        
                                    if($row3['tipodc']=="C")
                                        $json.= Chr(9).'            "pago": "'.str_pad($row3['devengados'],1,"").'",'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'            "pago": "'.str_pad($row3['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                    
                                    // Licencias de maternidad o paternidad
                                    if(($row3['conceptoid']==11)||($row3['conceptoid']==12))
                                        $json.= Chr(9).'            "tipoLicencia": "1"'.Chr(13).Chr(10);
    
                                    // Licencias remunerada
                                    if(($row3['conceptoid']==10)||($row3['conceptoid']==13)||($row3['conceptoid']==23)||($row3['conceptoid']==31)||($row3['conceptoid']==40)||($row3['conceptoid']==46))
                                        $json.= Chr(9).'            "tipoLicencia": "2"'.Chr(13).Chr(10);
                                    
                                    // Licencias no remunerada
                                    if(($row3['conceptoid']==6)||($row3['conceptoid']==9)||($row3['conceptoid']==43)||($row3['conceptoid']==58))
                                        $json.= Chr(9).'            "tipoLicencia": "3"'.Chr(13).Chr(10);
    
                                    $i++;
                                    if($i==$numlicencias2)
                                        $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'         },'.Chr(13).Chr(10);
                                }                                
                            }

                            if($numotrosdeven>0)
                                $json.= Chr(9).'      ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                        }

                        // Otros conceptos devengados
                        if($numotrosdeven>0)
                        {
                            $json.= Chr(9).'      "listaOtrosConceptos": ['.Chr(13).Chr(10);
                            $i = 0;

                            // Consulta con los datos que se incluirán en el json
                            $vsql12 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid IN (37,48) 
                                              AND h.terid = ".$terid;
                            $conex  = $clase->Conectar();
                            $result12 = mysql_query($vsql12,$conex);

                            while($row12 = mysql_fetch_array($result12))
                            {
                                $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "descripcionConcepto": "'.str_pad($row12['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "pago": "'.str_pad($row12['devengados'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "tipoConcepto": "1"'.Chr(13).Chr(10);

                                $i++;
                                if($i==$numotrosdeven)
                                    $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'         },'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                        }

                        
                        // Cierre de la lista de devengados
                        $json.= Chr(9).'      },'.Chr(13).Chr(10);

                        // $json.= Chr(9).'      "listaLicencias": '.str_pad($numlicencias,1,"").'['.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "cantidad": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoLicencia": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "cantidad": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoLicencia": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "cantidad": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoLicencia": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      ],'.Chr(13).Chr(10);
    
                        // Esto no se utilizará
                        // $json.= Chr(9).'      "listaBonificaciones": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoBonificacion": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoBonificacion": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoBonificacion": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      ],'.Chr(13).Chr(10);
    
                        // Esto no se utilizará
                        // $json.= Chr(9).'      "listaAuxilios": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoAuxilio": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoAuxilio": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoAuxilio": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      ],'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'      "listaHuelgasLegales": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "cantidad": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "cantidad": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaInicio": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "fechaFin": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "cantidad": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      ],'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'      "listaOtrosConceptos": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "descripcionConcepto": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoConcepto": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "descripcionConcepto": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoConcepto": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "descripcionConcepto": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoConcepto": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      ],'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'      "listaCompensaciones": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoCompensacion": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoCompensacion": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoCompensacion": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      ],'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'     "listaBonosEPCTV": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'        {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoBono": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoBono": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "pago": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'            "tipoBono": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'     ],'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'     "listaComisiones": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'        "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'     ],'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'     "listaPagosTerceros": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'        "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'     ],'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'     "listaAnticipos": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'        "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'        ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'     ]'.Chr(13).Chr(10);
                        // $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"deducciones": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "pensionVoluntaria": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "retencionFuente": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "afc": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "cooperativa": "",'.Chr(13).Chr(10);
                        if($embargo>0)      $json.= Chr(9).'   "embargoFiscal": "'.str_pad($embargo,1,"").'",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "planComplementarios": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "educacion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "reintegro": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "deuda": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "listaPagosTerceros": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "listaAnticipos": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   ],'.Chr(13).Chr(10);

                        // if($numotrasded>0)
                        // {
                        //     $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);

                        //     $i = 0;
                        //     // Consulta con los datos que se incluirán en el json
                        //     $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                        //                  FROM hisdetallenomina h
                        //                       INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                        //                 WHERE h.pernominaid IN ($listaperiodos)
                        //                       AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36)
                        //                       AND h.terid=".$terid."
                        //                       AND h.pernominaid NOT IN (SELECT pernominaid 
                        //                                                   FROM periodoterceros
                        //                                                  WHERE periodoterceros.terid = ".$terid." 
                        //                                                        AND pernominaid IN ($listaperiodos)
                        //                                                        AND extralegal ='CHECKED')";

                        //     $conex  = $clase->Conectar();
                        //     $result7 = mysql_query($vsql7,$conex);
    
                        //     while($row7 = mysql_fetch_array($result7))
                        //     {
                        //         $i++;
                        //         if($i==$numotrasded)
                        //             $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'"'.Chr(13).Chr(10);
                        //         else
                        //             $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                        //     }
                        //     // $json.= Chr(9).'   ],'.Chr(13).Chr(10);

                        //     if(($salud>0)||($pension>0)||($numsanciones>0)||($numlibranzas>0))
                        //         $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                        //     else
                        //         $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        // }

                        if($sumar==0)
                        {
                            if($numotrasded>0)
                            {
                                $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);    
                                $i = 0;

                                // Consulta con los datos que se incluirán en el json
                                $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                                 AND h.terid = ".$terid."
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal ='CHECKED')";
    
                                $conex  = $clase->Conectar();
                                $result7 = mysql_query($vsql7,$conex);
        
                                while($row7 = mysql_fetch_array($result7))
                                {
                                    $i++;
                                    if($i==$numotrasded)
                                        $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                }
                                $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                            }
                        }
                        else
                        {                             
                            if(($numotrasded>0)&&($numotrasdedliq>0))
                            {
                                $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
                                
                                // Consulta con los datos que se incluirán en el json
                                $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                                 AND h.terid = ".$terid."
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal ='CHECKED')";    
                                $conex  = $clase->Conectar();
                                $result7 = mysql_query($vsql7,$conex);
        
                                while($row7 = mysql_fetch_array($result7))
                                {
                                    $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                }

                                $i = 0;
                                // Consulta con los datos que se incluirán en el json
                                $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                             FROM detalleliquidacion h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                                  AND h.terid = ".$terid."";
    
                                $conex  = $clase->Conectar();
                                $result77 = mysql_query($vsql77,$conex);
        
                                while($row77 = mysql_fetch_array($result77))
                                {
                                    $i++;
                                    if($i==$numotrasdedliq)
                                        $json.= Chr(9).'      "'.str_pad($row77['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'      "'.str_pad($row77['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                }
                                $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                            }

                            if(($numotrasded==0)&&($numotrasdedliq>0))
                            {
                                $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
                                $i = 0;

                                // Consulta con los datos que se incluirán en el json
                                $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                                 AND h.terid = ".$terid."";
    
                                $conex  = $clase->Conectar();
                                $result7 = mysql_query($vsql7,$conex);
        
                                while($row7 = mysql_fetch_array($result7))
                                {
                                    $i++;
                                    if($i==$numotrasdedliq)
                                        $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                }
                                $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                            }

                            if(($numotrasded>0)&&($numotrasdedliq==0))
                            {
                                $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
                                $i = 0;

                                // Consulta con los datos que se incluirán en el json
                                $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                                 AND h.terid = ".$terid."
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal ='CHECKED')";
    
                                $conex  = $clase->Conectar();
                                $result7 = mysql_query($vsql7,$conex);
        
                                while($row7 = mysql_fetch_array($result7))
                                {
                                    $i++;
                                    if($i==$numotrasded)
                                        $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                }
                                $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                            }
                        }

                        // $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   ],'.Chr(13).Chr(10);

                        // $json.= Chr(9).'   "salud": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "porcentaje": "'.str_pad($por_sal_tra,1,"").'",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "deduccion": "'.str_pad($salud,1,"").'"'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "fondoPension": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "porcentaje": "'.str_pad($por_pen_tra,1,"").'",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "deduccion": "'.str_pad($pension,1,"").'"'.Chr(13).Chr(10);

                        // Descuento por concepto de salud
                        $json.= Chr(9).'   "salud": {'.Chr(13).Chr(10);
                        if($salud>0)
                        {
                            $json.= Chr(9).'      "porcentaje": "'.str_pad($por_sal_tra,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "'.str_pad($salud,1,"").'"'.Chr(13).Chr(10);
                        }
                        else
                        {                            
                            $json.= Chr(9).'      "porcentaje": "0",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "0"'.Chr(13).Chr(10);
                        }

                        $json.= Chr(9).'   },'.Chr(13).Chr(10);

                        // Descuento por concepto de pensión
                        $json.= Chr(9).'   "fondoPension": {'.Chr(13).Chr(10);
                        if($pension>0)
                        {
                            $json.= Chr(9).'      "porcentaje": "'.str_pad($por_pen_tra,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "'.str_pad($pension,1,"").'"'.Chr(13).Chr(10);
                        }
                        else
                        {                            
                            $json.= Chr(9).'      "porcentaje": "0",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "0"'.Chr(13).Chr(10);
                        }

                        if(($numsanciones>0)||($numlibranzas>0)||($numlibranzasliq>0))
                            $json.= Chr(9).'   },'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'   "fondoSP": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "porcentaje": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "deduccionSP": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "porcentajeSub": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      "deduccionSub": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   },'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'   "listaSindicatos": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "porcentaje": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "deduccion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "porcentaje": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "deduccion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "porcentaje": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "deduccion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   ],'.Chr(13).Chr(10);
    
                        // Incluyo las sanciones
                        if($numsanciones>0)
                        {
                            $json.= Chr(9).'   "listaSanciones": ['.Chr(13).Chr(10);
                            $i = 0;

                            // Consulta con los datos que se incluirán en el json
                            $vsql6 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid = 9
                                             AND h.terid = ".$terid;
                            $conex  = $clase->Conectar();
                            $result6 = mysql_query($vsql6,$conex);
    
                            while($row6 = mysql_fetch_array($result6))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "valorSancion": "'.str_pad($row6['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "tipoSancion": "2"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numsanciones)
                                    $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
                            
                            if(($numlibranzas>0)||($numlibranzasliq>0))
                                $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        }
    
                        // $json.= Chr(9).'   "listaSanciones": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "valorSancion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "tipoSancion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "valorSancion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "tipoSancion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "valorSancion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "tipoSancion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   ],'.Chr(13).Chr(10);
    
                        // Incluyo las libranzas
                        // if($numlibranzas>0)
                        // {
                        //     $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
    
                        //     $i = 0;
                        //     // Consulta con los datos que se incluirán en el json
                        //     $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                        //                 FROM hisdetallenomina h
                        //                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                        //                WHERE h.pernominaid IN ($listaperiodos)
                        //                      AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                        //                      AND h.terid=".$terid."
                        //                      AND c.conceptoid NOT IN (10,30)
                        //                      AND h.pernominaid NOT IN (SELECT pernominaid 
                        //                                                  FROM periodoterceros
                        //                                                 WHERE terid = ".$terid." 
                        //                                                       AND pernominaid IN ($listaperiodos)
                        //                                                       AND extralegal ='CHECKED')";
                        //     $conex  = $clase->Conectar();
                        //     $result4 = mysql_query($vsql4,$conex);
    
                        //     while($row4 = mysql_fetch_array($result4))
                        //     {
                        //         $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        //         $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                        //         $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
    
                        //         $i++;
                        //         if($i==$numlibranzas)
                        //             $json.= Chr(9).'      }'.Chr(13).Chr(10);
                        //         else
                        //             $json.= Chr(9).'      },'.Chr(13).Chr(10);
                        //     }                            
                        //     $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        // }

                        if($sumar==0)
                        {
                            if($numlibranzas>0)
                            {                                
                                $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);        
                                $i = 0;

                                // Consulta con los datos que se incluirán en el json
                                $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                                 AND h.terid = ".$terid."
                                                 AND c.conceptoid NOT IN (10,30)
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal ='CHECKED')";
                                $conex  = $clase->Conectar();
                                $result4 = mysql_query($vsql4,$conex);
        
                                while($row4 = mysql_fetch_array($result4))
                                {
                                    $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
        
                                    $i++;
                                    if($i==$numlibranzas)
                                        $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'      },'.Chr(13).Chr(10);
                                }
                                $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                            }
                        }
                        else
                        {
                            if(($numlibranzas>0)&&($numlibranzasliq>0))
                            {                                
                                $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
                                
                                // Consulta con los datos que se incluirán en el json
                                $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                                 AND h.terid = ".$terid."
                                                 AND c.conceptoid NOT IN (10,30)
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal ='CHECKED')";
                                $conex  = $clase->Conectar();
                                $result4 = mysql_query($vsql4,$conex);
        
                                while($row4 = mysql_fetch_array($result4))
                                {
                                    $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
                                }

                                $i = 0;
                                // Consulta con los datos que se incluirán en el json
                                $vsql44 = "SELECT c.nomconcepto, h.descuentos  
                                             FROM detalleliquidacion h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                                  AND h.terid = ".$terid."
                                                  AND c.conceptoid NOT IN (10,30)
                                                  AND h.pernominaid IN ($listaperiodos)";

                                $conex = $clase->Conectar();
                                $result44 = mysql_query($vsql44,$conex);
        
                                while($row44 = mysql_fetch_array($result44))
                                {
                                    $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'         "descripcion": "'.str_pad($row44['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'         "deduccion": "'.str_pad($row44['descuentos'],1,"").'"'.Chr(13).Chr(10);
        
                                    $i++;
                                    if($i==$numlibranzasliq)
                                        $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'      },'.Chr(13).Chr(10);
                                }
                                $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                            }
                            
                            if(($numlibranzas==0)&&($numlibranzasliq>0))
                            {                                
                                $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
                                $i = 0;
                                
                                // Consulta con los datos que se incluirán en el json
                                $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED') 
                                                 AND h.terid = ".$terid."
                                                 AND c.conceptoid NOT IN (10,30)";
                                $conex  = $clase->Conectar();
                                $result4 = mysql_query($vsql4,$conex);
        
                                while($row4 = mysql_fetch_array($result4))
                                {
                                    $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
        
                                    $i++;
                                    if($i==$numlibranzasliq)
                                        $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'      },'.Chr(13).Chr(10);
                                }
                                $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                            }

                            if(($numlibranzas>0)&&($numlibranzasliq==0))
                            {
                                $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
                                $i = 0;

                                // Consulta con los datos que se incluirán en el json
                                $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                                 AND h.terid = ".$terid."
                                                 AND c.conceptoid NOT IN (10,30)
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal ='CHECKED')";
                                $conex  = $clase->Conectar();
                                $result4 = mysql_query($vsql4,$conex);
        
                                while($row4 = mysql_fetch_array($result4))
                                {
                                    $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
        
                                    $i++;
                                    if($i==$numlibranzas)
                                        $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'      },'.Chr(13).Chr(10);
                                }
                                $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                            }
                        }
    
                        // $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "descripcion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "deduccion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "descripcion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "deduccion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      },'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "descripcion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'         "deduccion": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'      }'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   ]'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'},'.Chr(13).Chr(10);

                        // if(($embargo>0)||($numotrasded>0)||($salud>0)||($pension>0)||($numsanciones>0)||($numlibranzas>0))
                        //     $json.= Chr(9).'},'.Chr(13).Chr(10);
                        // else
                        //     $json.= Chr(9).'}'.Chr(13).Chr(10);

                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        // $json.= Chr(9).'"nominaAModificar": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "numeroPred": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "cunePred": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "fechaGenPred": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'},'.Chr(13).Chr(10);
                        // $json.= Chr(9).'"novedad": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "novedadNov": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "numeroNov": "",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'   "cuneNov": ""'.Chr(13).Chr(10);
                        // $json.= Chr(9).'},'.Chr(13).Chr(10);
                        // $json.= Chr(9).'"canal": ""'.Chr(13).Chr(10);

                        if(($numvacacionest>0)||($numprimas>0)||($numcesantias>0)||($numindemnizacion>0)||($numotrosdeven>0)||($montodotacion>0)||($numpagocesan>0))
                            $neto = $devengados - $descuentos;
    
                        $json.= Chr(9).'"devengadosTotal": "'.str_pad($devengados,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"deduccionesTotal": "'.str_pad($descuentos,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"comprobanteTotal": "'.str_pad($neto,1,"").'"'.Chr(13).Chr(10);
    
                        $json.='}'.Chr(13).Chr(10);
    
                        // ----------------------------------------------------------------------------------------------------- //
                        // Grabo en el archivo correspondiente la información de empleado
                        $archivo = trim($dni).".json";  //  nombre del archivo
                        $fd = fopen ($carpetaactual."/".$archivo, "w"); // se abre el archivo para escribir
                        fwrite($fd, $json); // Grabas
                        fclose($fd); // Cierras el archivo
                        $listadereportados.= $terid.",";
                    }
                }
            }
            $listadereportados = substr($listadereportados, 0, -1);
        }

        // ---------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Ciclo para procesar a los empleados liquidados que trabajaron una quincena unido con los empleados que trabajaron la primera quincena como extralegal y 
        // tienen una liquidación en la segunda

        $primquin = substr($listaperiodos,0,2);
        $segnquin = substr($listaperiodos,-2);

        $vsqlliq ="SELECT DISTINCT terid 
                     FROM detalleliquidacion 
                    WHERE pernominaid IN ($listaperiodos)
                          AND terid NOT IN (SELECT terid
                                              FROM hisdetallenomina
                                             WHERE pernominaid IN ($listaperiodos))";

        if(strlen($listadereportados)>0)
            $vsqlliq.= " AND terid NOT IN ($listadereportados) ";

        if(strlen($nodebensalir) > 0)
            $vsqlliq.= " AND terid NOT IN ($nodebensalir) ";            

        $vsqlliq.= " UNION ALL
                    SELECT p.terid
                      FROM periodoterceros p
                     WHERE p.extralegal = 'CHECKED'
                           AND p.pernominaid IN ($listaperiodos)
                           AND p.terid IN (SELECT terid
                                             FROM detalleliquidacion
                                            WHERE terid = p.terid
                                                  AND pernominaid IN ($listaperiodos))";

        if(strlen($listadereportados)>0)
            $vsqlliq.= " AND p.terid NOT IN ($listadereportados)";

        if(strlen($nodebensalir) > 0)
            $vsqlliq.= " AND p.terid NOT IN ($nodebensalir) ";

        $conex  = $clase->Conectar();
        $resultliq = mysql_query($vsqlliq,$conex);
        $empleadosreportar = mysql_num_rows($resultliq);

        // $empleadosreportar = 0;

        if($empleadosreportar>0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";                            $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $listadereportados.= ",";                       $vsqlvextralegal = "";
            $numnomext = 0;                                 $vsqlnumvacaciones2 = "";                       $numvacaciones2 = 0;
            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;                                 $vsqlincapacidad = "";
            $numlicencias = 0;                              $vsqlincapacidad = "";                          $cantidadhenliq = 0;
            $recargonocliq = 0;                             $vsqlrecargonocliq = "";                        $cantidadrn = 0;
            $valordetalleliquidacion = 0;                   $pagorn = 0;                                    $devengadosdetalleliquidacion = 0;            
            $recargonocdomfes = 0;                          $recargonocdomfesliq = 0;                       $cantidadhen = 0;
            $cantidaddehen = 0;                             $montohoraextnocturna = 0;                      $montohoraextnocturnaliq = 0;
            $cantidadhedd = 0;                              $cantidadheddliq = 0;                           $cantidaddehedd = 0;
            $montohoraextddomliq = 0;                       $montohoraextdiudom = 0;                        $cantidadhendf = 0;
            $cantidaddehendf = 0;                           $montohendf = 0;                                $montohendfliq = 0;
            $cantidaddomfes = 0;                            $cantidaddomfesliq = 0;                         $cantidaddedomfes = 0;
            $montodomfesliq = 0;                            $montodedomfes = 0;                             $cantidadrecnocdonfes = 0;                      
            $cantidadderecnocdonfes = 0;                    $montorecnocdonfes = 0;                         $montorecnocdonfesliq = 0;
            $montohorextnoc = 0;                            $montohoraextddom = 0;                          $cantidadhendfliq = 0;
            $montodehendf = 0;                              $montodomfes = 0;                               $cantidadrecnocdonfesliq = 0;
            $montoderecnocdonfes = 0;                       $numrecargos = 0;                               
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;

            while($rowliq = mysql_fetch_array($resultliq))
            {
                // id del empleado
                $terid = $rowliq['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal = 'CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);
                
                $vsqlexiste = "SELECT COUNT(*) existe FROM terceros WHERE terid = ".$terid;
                $existe = $clase->SeleccionarUno($vsqlexiste);
                
                if(($numnomext<2) && ($existe > 0))
                {
                    // días trabajados
                    $vsqldiasliq = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrabliq 
                                      FROM detalleliquidacion 
                                     WHERE pernominaid IN ($listaperiodos) 
                                           AND terid = ".$terid."";
                    $diastrabliq = $clase->SeleccionarUno($vsqldiasliq);
    
                    // Documento del empleado
                    $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                    // Primer apellido
                    $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                    // Segundo apellido
                    $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                    // Primer nombre
                    $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                    // Segundo nombre
                    $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                    // Sueldo básico
                    $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                    // Código del trabajador
                    $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                    // Correo electrónico
                    $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                    // Teléfono
                    $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                    // Número de cuenta
                    $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
    
                    // Tipo de documento
                    $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                    // Banco
                    $vsqlbanco = "SELECT b.descripcion AS banco
                                    FROM periodoterceros p
                                         INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                   WHERE p.terid = ".$terid;
                    $banco = $clase->SeleccionarUno($vsqlbanco);
                    $banco = trim(str_replace("BANCO ","",$banco));
    
                    // cargo del empleado
                    $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
    
                    $vsqlsueldoliq = "SELECT IFNULL(devengados,0) AS sueldoliq
                                        FROM detalleliquidacion
                                       WHERE terid = ".$terid."
                                             AND conceptoid = 1
                                             AND pernominaid IN ($listaperiodos)";
                    $sueldoliq = $clase->SeleccionarUno($vsqlsueldoliq);
                    if($sueldoliq=="")          $sueldoliq = 0;
    
                    // auxilio de transporte
                    $vsqltransliq = "SELECT IFNULL(devengados,0) AS transliq
                                       FROM detalleliquidacion
                                      WHERE terid = ".$terid."
                                            AND conceptoid IN (3,45)
                                            AND pernominaid IN ($listaperiodos)";
                    $transliq = $clase->SeleccionarUno($vsqltransliq);
                    if($transliq=="")  $transliq = 0;

                    // Recargo nocturno
                    $vsqlrecargonocliq = "SELECT COUNT(*) AS recargonocliq
                                            FROM detalleliquidacion
                                           WHERE terid = ".$terid."
                                                 AND conceptoid IN (47,56,59) 
                                                 AND pernominaid IN ($listaperiodos)";
                    $recargonocliq = $clase->SeleccionarUno($vsqlrecargonocliq);

                    // hora extra diurna
                    $horaextradiurnaliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 49,devengados,0)) AS horaextradiurnaliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                    // hora extra nocturna
                    $horaextranocturnaliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 50,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                    // hora extra diurna dominical
                    $horaextradiurnadomliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 51,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                    // hora extra nocturna dominical y festivo
                    $horaextradnocturnadomfesliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 52,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                    // domingos y festivos
                    $domingosyfestivosliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 53,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                    // recargo nocturno dominical y festivo
                    $recargonocdomfesliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 54,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");
                    
                    // total de recargos
                    $numrecargos = $recargonoc + $horaextradiurna + $horaextranocturna + $horaextradiurnadom + $horaextradnocturnadomfes + $domingosyfestivos + $recargonocdomfes;
    
                    // embargo
                    $vsqlembliq = "SELECT descuentos AS embliq
                                     FROM detalleliquidacion
                                    WHERE terid = ".$terid."
                                          AND conceptoid = 30
                                          AND pernominaid IN ($listaperiodos)";
                    $embliq = $clase->SeleccionarUno($vsqlembliq);
    
                    // salud
                    $vsqlsaludliq = "SELECT IFNULL(descuentos,0) AS saludliq
                                       FROM detalleliquidacion
                                      WHERE terid = ".$terid."
                                            AND conceptoid = 5
                                            AND pernominaid IN ($listaperiodos)";
                    $saludliq = $clase->SeleccionarUno($vsqlsaludliq);
                    if($saludliq=="")  $saludliq = 0;
    
                    // pensión
                    $vsqlpesionliq = "SELECT IFNULL(descuentos,0) AS pesionliq
                                        FROM detalleliquidacion
                                       WHERE terid = ".$terid." 
                                             AND conceptoid = 4
                                             AND pernominaid IN ($listaperiodos)";
                    $pesionliq = $clase->SeleccionarUno($vsqlpesionliq);
                    if($pesionliq=="")  $pesionliq = 0;
    
                    // total devengado
                    $vsqldevliq = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                     FROM detalleliquidacion 
                                    WHERE terid = ".$terid."";
                    $devengados = $clase->SeleccionarUno($vsqldevliq);
    
                    // total descuentos
                    $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                      FROM detalleliquidacion 
                                     WHERE pernominaid IN ($listaperiodos) 
                                           AND terid = ".$terid."";
                    $descuentos = $clase->SeleccionarUno($vsqldescliq);
    
                    // neto a pagar
                    $neto = $devengados - $descuentos;
    
                    // Obtengo la fecha de ingreso del empleado
                    $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');

                    $fechaEntera = strtotime($fecingreso);
                    $mesfecingreso = date("m", $fechaEntera);
                    $yeaarfecingreso = date("Y", $fechaEntera);

                    if(($mesfecingreso > $mesperiodo2) && (intval($yearperiodo) == intval($yeaarfecingreso)))
                    {
                        // fechas de ingreso y retiro
                        $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                        $idhistorico = $clase->SeleccionarUno($vsql18);

                        $vsql21 = "SELECT hc.fecingreso 
                                     FROM histcontrato hc 
                                    WHERE hc.terid = ".$terid." 
                                          AND hc.id = ".$idhistorico;
                        $fecingreso = $clase->SeleccionarUno($vsql21);

                        if($fecingreso == "")
                            $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
                    }                    
    
                    // libranzas
                    $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                           FROM detalleliquidacion h
                                                INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                          WHERE h.pernominaid IN ($listaperiodos)
                                                AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                                                AND h.terid = ".$terid."
                                                AND c.conceptoid NOT IN (10,30)";
                    $numlibranzasliq = $clase->SeleccionarUno($vsqllibranzasliq);
    
                    // otras deducciones
                    $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,58)
                                                 AND h.terid = ".$terid."";
                    $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);
    
                    // Vacaciones
                    $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                            FROM liquidacion
                                        WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'vacaciones'";
                    $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                    // Vacaciones pagadas en quincenas
                    $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2 
                                             FROM hisdetallenomina 
                                            WHERE terid = ".$terid."
                                                 AND conceptoid = 38 
                                                 AND pernominaid IN ($listaperiodos)";
                    $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                    $numvacacionest = $numvacaciones1 + $numvacaciones2;
    
                    // Primas
                    $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                        FROM liquidacion
                                       WHERE terid = ".$terid." 
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'primas'";
                    $numprimas = $clase->SeleccionarUno($vsqlnumprimas);
    
                    // Cesantías
                    $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                           FROM liquidacion
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'cesantias'";
                    $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);
    
                    // Pagos del fondo de cesantías
                    $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                           FROM pagocesantias
                                          WHERE terid = ".$terid." 
                                                AND periodonomina = '".$codperiodo."'";
                    $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                    // Indemnización
                    $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                            FROM liquidacion
                                           WHERE terid = ".$terid." 
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'indemnizacion'";
                    $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                    // Otros conceptos devengados
                    $vsqlotrosdevenliq = "SELECT COUNT(h.conceptoid) AS numotrosdevenliq
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid IN (37,48) 
                                                 AND h.terid = ".$terid."";
                    $numotrosdevenliq = $clase->SeleccionarUno($vsqlotrosdevenliq);
    
                    // Dotaciones 
                    $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                         FROM dotaciones
                                        WHERE periodonomina = '".$codperiodo."'
                                              AND terid = ".$terid."";
                    $montodotacion = $clase->SeleccionarUno($vsqldotaciones);

                    // Licencias
                    $vsqlincapacidad = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND c.eslicencia = 'CHECKED' 
                                               AND c.tipodc = 'C' 
                                               AND h.conceptoid NOT IN (10,9,43,40,58) 
                                               AND h.terid = ".$terid."";
                    $numlicencias = $clase->SeleccionarUno($vsqlincapacidad);
                    
                    // Incapacidades del periodo
                    $vsqlincapacidad = "SELECT COUNT(*) AS numincap
                                          FROM detalleliquidacion 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND conceptoid IN (10,43,40)";
                    $numincap = $clase->SeleccionarUno($vsqlincapacidad);
    
                    // Genero el código consecutivo de nómina electrónica
                    $consecutivone = $clase->BDLockup($segundaquinper,'periodosnomina','periodoid','consecutivone');
    
                    // Valido si es el primero o el siguiente
                    if($consecutivone=="")
                    {
                        $newper = substr($codperiodo,0,2).substr($codperiodo,-2);
                        $newcod = $newper."00001";
                        $newconsecutivo = "NE".$newcod;
                    }
                    else
                    {
                        // Incremento el consecutivo
                        $numconsn = intval(substr($consecutivone,-5));
                        $numconsn++;
                        $newcod = strval($numconsn);
    
                        // Relleno con ceros
                        if(strlen($newcod)==1)      $newcod = "0000".$newcod;
                        if(strlen($newcod)==2)      $newcod = "000".$newcod;
                        if(strlen($newcod)==3)      $newcod = "00".$newcod;
                        if(strlen($newcod)==4)      $newcod = "0".$newcod;
                        
                        $newper = substr($codperiodo,0,2).substr($codperiodo,-2);
                        $newcod = $newper.$newcod;
    
                        // Construyo el nuevo consecutivo
                        $newconsecutivo = "NE".$newcod;
                    }
    
                    // Almacenos en la tabla el nuevo consecutivo
                    $vsqlactcons = "UPDATE periodosnomina SET 
                                           consecutivone = '".$newconsecutivo."'
                                     WHERE periodoid = ".$segundaquinper;
                    $clase->EjecutarSQL($vsqlactcons);
    
                    $prefijo = substr($newconsecutivo,0,2);
    
                    // ------------------------------------------------------------------------------------------------------------------------------------------------------- //
                    // Construyo el json con los datos del empleado
                    $json='{'.Chr(13).Chr(10);
                    $json.= Chr(9).'"idEmpresa": "1536",'.Chr(13).Chr(10);
                    $json.= Chr(9).'"token": "'.str_pad($token,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'"tipoDocumento": "1",'.Chr(13).Chr(10);
                    $json.= Chr(9).'"almacenamiento": "1",'.Chr(13).Chr(10);
    
                    $json.= Chr(9).'"listaFechaPago": ['.Chr(13).Chr(10);
                    $json.= Chr(9).'  "'.str_pad($fecinicio,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "'.str_pad($fecfinal,1,"").'"'.Chr(13).Chr(10);
                    $json.= Chr(9).'],'.Chr(13).Chr(10);
    
                    $json.= Chr(9).'"periodo": {'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "fechaIngreso": "'.str_pad($fecingreso,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "fechaLiquidacionInicio": "'.str_pad($fecinicio,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "fechaLiquidacionFin": "'.str_pad($fecfinal,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "tiempoLaborado": "'.str_pad($diastrabliq,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "fechaGen": "'.str_pad($fechaAct,1,"").'"'.Chr(13).Chr(10);
                    $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                    $json.= Chr(9).'"numeroSecuenciaXML": {'.Chr(13).Chr(10);
                    // $json.= Chr(9).'  "prefijo": "'.str_pad($prefijo,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "consecutivo": "'.str_pad($newcod,1,"").'"'.Chr(13).Chr(10);
                    $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                    $json.= Chr(9).'"lugarGeneracionXML": {'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "pais": "CO",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "departamentoEstado": "54",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "municipioCiudad": "54001",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "idioma": "es"'.Chr(13).Chr(10);
                    $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                    $json.= Chr(9).'"informacionGeneral": {'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "fechaGen": "'.str_pad($fechaAct,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "horaGen": "'.str_pad($horaAct,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "periodoNomina": "5",'.Chr(13).Chr(10);
                    // $json.= Chr(9).'  "tipoMoneda": "COP",'.Chr(13).Chr(10);
                    // $json.= Chr(9).'  "trm": ""'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "tipoMoneda": "COP"'.Chr(13).Chr(10);
                    $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                    $json.= Chr(9).'"trabajador": {'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "tipoTrabajador": "01",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "subTipoTrabajador": "00",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "altoRiesgoPension": "true",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "tipoDocumento": "13",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "numeroDocumento": "'.str_pad($dni,1,"").'",'.Chr(13).Chr(10);
                    if($primerapellido!="")      $json.= Chr(9).'  "primerApellido": "'.str_pad($primerapellido,1,"").'",'.Chr(13).Chr(10);
                    if($segundoapellido!="")     $json.= Chr(9).'  "segundoApellido": "'.str_pad($segundoapellido,1,"").'",'.Chr(13).Chr(10);
                    if($primernombre!="")        $json.= Chr(9).'  "primerNombre": "'.str_pad($primernombre,1,"").'",'.Chr(13).Chr(10);
                    if(trim($segundonombre)!="") $json.= Chr(9).'  "otrosNombres": "'.str_pad($segundonombre,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "lugarTrabajoPais": "CO",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "lugarTrabajoDepartamentoEstado": "54",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "lugarTrabajoMunicipioCiudad": "54001",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "lugarTrabajoDireccion": "AVENIDA 7A # 0BN38 BARRIO SEVILLA",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "salarioIntegral": "false",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "tipoContrato": "1",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "sueldo": "'.str_pad($basico,1,"").'"'.Chr(13).Chr(10);
                    // $json.= Chr(9).'  "codigoTrabajador": "'.str_pad($codvende,1,"").'"'.Chr(13).Chr(10);
                    $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                    // valido que el número de cuenta esté vacío
                    $json.= Chr(9).'"pago": {'.Chr(13).Chr(10);
                    if($numcuenta!="")
                    {
                        $json.= Chr(9).'  "forma": "1",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "metodo": "45",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "banco": "'.str_pad($banco,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tipoCuenta": "AHORROS",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "numeroCuenta": "'.str_pad($numcuenta,1,"").'"'.Chr(13).Chr(10);
                    }
                    else
                    {                    
                        $json.= Chr(9).'  "forma": "1",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "metodo": "10"'.Chr(13).Chr(10);
                    }
                    
                    $json.= Chr(9).'},'.Chr(13).Chr(10);
                    $json.= Chr(9).'"devengados": {'.Chr(13).Chr(10);
    
                    if($montodotacion>0)
                    {
                        $json.= Chr(9).'   "dotacion": "'.str_pad($montodotacion,1,"").'",'.Chr(13).Chr(10);
                        $devengados += $montodotacion;
                    }
    
                    if($numindemnizacion>0)                     
                    {
                        // Pago por la indemnización
                        $vsqlindemnizacion = "SELECT pago AS pagoindemnizacion
                                                FROM liquidacion
                                               WHERE terid=".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $pagoindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                        // Imprimo la indemnización
                        $json.= Chr(9).'  "indemnizacion": "'.str_pad($pagoindemnizacion,1,"").'",'.Chr(13).Chr(10);
    
                        // Incremento del devengado
                        $devengados += $pagoindemnizacion;
                    }
    
                    $json.= Chr(9).'  "basico": {'.Chr(13).Chr(10);
                    $json.= Chr(9).'     "diasTrabajados": "'.str_pad($diastrabliq,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'     "sueldoTrabajado": "'.str_pad($sueldoliq,1,"").'"'.Chr(13).Chr(10);
    
                    if(($transliq>0)||($numrecargos>0)||($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numotrosdevenliq>0)||($numpagocesan>0)||($numincap>0)||($numlicencias>0))
                        $json.= Chr(9).'  },'.Chr(13).Chr(10);
                    else
                        $json.= Chr(9).'  }'.Chr(13).Chr(10);                
    
                    // auxilio de transporte
                    if($transliq>0)
                    {
                        $json.= Chr(9).'  "transporte": ['.Chr(13).Chr(10);
                        $json.= Chr(9).'     {'.Chr(13).Chr(10);
                        $json.= Chr(9).'       "auxilioTransporte": "'.str_pad($transliq,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'     }'.Chr(13).Chr(10);
    
                        if(($numrecargos>0)||($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numotrosdevenliq>0)||($numpagocesan>0)||($numincap>0)||($numlicencias>0))
                            $json.= Chr(9).'  ],'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'  ]'.Chr(13).Chr(10);
                    }

                    // Recargo nocturno
                    if($numrecargos > 0)
                    {
                        $json.= Chr(9).'   "listaHeR": ['.Chr(13).Chr(10);

                        $vsql30  = "SELECT SUM(valor) AS cantidad, 
                                           CASE
                                            WHEN conceptoid = 47 THEN '35.00'
                                            WHEN conceptoid = 49 THEN '25.00'
                                            WHEN conceptoid = 50 THEN '75.00'           
                                            WHEN conceptoid = 51 THEN '105.00' 
                                            WHEN conceptoid = 52 THEN '155.00'
                                            WHEN conceptoid = 53 THEN '80.00'         
                                            WHEN conceptoid = 54 THEN '115.00'
                                            WHEN conceptoid = 56 THEN '35.00'
                                            WHEN conceptoid = 59 THEN '35.00'
                                           END porcentaje,
                                           SUM(devengados) AS pago,  
                                           CASE
                                             WHEN conceptoid = 47 THEN '3'
                                             WHEN conceptoid = 49 THEN '1'
                                             WHEN conceptoid = 50 THEN '2'           
                                             WHEN conceptoid = 51 THEN '4' 
                                             WHEN conceptoid = 52 THEN '6'
                                             WHEN conceptoid = 53 THEN '5'         
                                             WHEN conceptoid = 54 THEN '7'
                                             WHEN conceptoid = 56 THEN '3'
                                             WHEN conceptoid = 59 THEN '3'
                                           END tipoHeR,
                                           CASE
                                             WHEN conceptoid = 47 THEN 'Hora Recargo Nocturno'
                                             WHEN conceptoid = 49 THEN 'Hora Extra Diurna'
                                             WHEN conceptoid = 50 THEN 'Hora Extra Nocturna'           
                                             WHEN conceptoid = 51 THEN 'Hora Extra Diurna Dominical y Festivos' 
                                             WHEN conceptoid = 52 THEN 'Hora Extra Nocturna Dominical y Festivos'
                                             WHEN conceptoid = 53 THEN 'Hora Recargo Diurno Dominical y Festivos'         
                                             WHEN conceptoid = 54 THEN 'Hora Recargo Nocturno Dominical y Festivos'
                                             WHEN conceptoid = 56 THEN 'Hora Recargo Nocturno'
                                             WHEN conceptoid = 59 THEN 'Hora Recargo Nocturno'
                                           END descripcion            
                                      FROM detalleliquidacion 
                                     WHERE pernominaid IN ($listaperiodos) 
                                           AND conceptoid IN (47,49,50,51,52,53,54,56,59) 
                                           AND terid = ".$terid."
                                  GROUP BY conceptoid";

                        $conex  = $clase->Conectar();
                        $result30 = mysql_query($vsql30,$conex);
                        $cant1 = mysql_num_rows($result30);             $cant2 = 0;
                        while($row30 = mysql_fetch_array($result30))
                        {                            
                            $json.= Chr(9).'         {'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "cantidad": "'.str_pad($row30['cantidad'],1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "porcentaje": "'.str_pad($row30['porcentaje'],1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "pago": "'.str_pad($row30['pago'],1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "tipoHeR": "'.str_pad($row30['tipoHeR'],1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "descripcion": "'.str_pad($row30['descripcion'],1,"").'"'.Chr(13).Chr(10);

                            $cant2++;

                            if($cant2 < $cant1)
                                $json.= Chr(9).'         },'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'         }'.Chr(13).Chr(10);
                        }
                        // -------------------------------------------------------------------------------------------------- //
                        
                        if(($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numotrosdevenliq>0)||($numpagocesan>0)||($numincap>0)||($numlicencias>0))
                            $json.= Chr(9).'  ],'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'  ]'.Chr(13).Chr(10);
                    }
    
                    // primas del empleado
                    if($numprimas>0)
                    {
                        $json.= Chr(9).'"  primas": {'.Chr(13).Chr(10);
    
                        // Días de la prima
                        $vsqlcanprimas = "SELECT cantidad AS canprimas
                                            FROM liquidacion
                                           WHERE terid=".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                        // Pago de la prima
                        $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                             FROM liquidacion
                                            WHERE terid=".$terid."
                                                  AND periodonomina = '".$codperiodo."' 
                                                  AND tipo = 'primas'";
                        $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);
    
                        $json.= Chr(9).'     "cantidad": "'.str_pad($canprimas,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'     "pago": "'.str_pad($pagoprimas,1,"").'"'.Chr(13).Chr(10);
    
                        if(($numcesantias>0)||($numvacacionest>0)||($numotrosdevenliq>0)||($numpagocesan>0)||($numincap>0)||($numlicencias>0))
                            $json.= Chr(9).'   },'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                        // Incremento el total devengado
                        $devengados += $pagoprimas;
                    }
    
                    // Cesantías del empleado
                    if($numcesantias>0)
                    {       
                        // Pago de la cesantía
                        $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                               FROM liquidacion
                                              WHERE terid=".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);
    
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid=".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        if($numpagocesan>0)
                        {
                            $vsqlnumpagocesan = "";
                            $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                   FROM pagocesantias
                                                  WHERE terid=".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                            $pagocesantia += $montopagocesan;
                        }                                    
    
                        // Porcentaje cesantía
                        $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                               FROM liquidacion
                                              WHERE terid=".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);
    
                        // Pago de intereses de cesantías
                        $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                FROM liquidacion
                                               WHERE terid=".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'cesantias'";
                        $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);
    
                        $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'      "pago": "'.str_pad($pagocesantia,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'      "porcentaje": "'.str_pad(number_format($porccesantia,2),1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'      "pagoIntereses": "'.str_pad($pagointereses,1,"").'"'.Chr(13).Chr(10);
                           
                        if(($numvacacionest>0)||($numotrosdevenliq>0)||($numincap>0)||($numlicencias))
                            $json.= Chr(9).'   },'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                        // Incremento el total devengado
                        $devengados += $pagocesantia;
                        $devengados += $pagointereses;
                    }
                    else
                    {
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid=".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        if($numpagocesan>0)
                        {
                            $vsqlnumpagocesan = "";
                            $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                   FROM pagocesantias
                                                  WHERE terid=".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                            $pagocesantia = $montopagocesan;
    
                            $porccesantia = 0;
                            $pagointereses = 0;
    
                            $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "pago": "'.str_pad($pagocesantia,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "porcentaje": "'.str_pad(number_format($porccesantia,2),1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "pagoIntereses": "'.str_pad($pagointereses,1,"").'"'.Chr(13).Chr(10);
    
                            if(($numvacacionest>0)||($numotrosdevenliq>0)||($numincap>0)||($numlicencias))
                                $json.= Chr(9).'   },'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                            // Incremento el total devengado
                            $devengados += $pagocesantia;
                        }
                    }
    
                    // Vacaciones del empleado
                    if($numvacacionest>0)                
                    {
                        $json.= Chr(9).'      "listaVacaciones": ['.Chr(13).Chr(10);
                        $json.= Chr(9).'         {'.Chr(13).Chr(10);    
                        
                        if($numvacaciones1 > 0)
                        {
                            // Días de vacaciones
                            $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                    FROM liquidacion
                                                   WHERE terid=".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'vacaciones'";
                            $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                            // Pago de vacaciones
                            $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                               FROM liquidacion
                                              WHERE terid=".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'vacaciones'";
                            $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                        }
                        else
                        {
                            $canvacaciones = 0;
                            $pagovaca1 = 0;
                        }

                        if($numvacaciones2>0)
                        {
                            $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                FROM hisdetallenomina  
                                               WHERE terid = ".$terid."
                                                     AND conceptoid = 38 
                                                     AND pernominaid IN ($listaperiodos)";
                            $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                        }
                        else
                            $pagovaca2 = 0;
                        
                        if($canvacaciones == 0)               $canvacaciones = 1;
                        $pagovaca = $pagovaca1 + $pagovaca2;
    
                        $json.= Chr(9).'            "cantidad": "'.str_pad($canvacaciones,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "pago": "'.str_pad($pagovaca,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "tipoVacacion": "1"'.Chr(13).Chr(10);
                        $json.= Chr(9).'         }'.Chr(13).Chr(10);
    
                        if(($numotrosdevenliq>0)||($numincap>0)||($numlicencias>0))
                            $json.= Chr(9).'],'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).']'.Chr(13).Chr(10);
    
                        // Incremento el total devengado
                        $devengados += $pagovaca1;
                    }

                    // Incluyo las incapacidades
                    if($numincap>0)
                    {
                        $json.= Chr(9).'      "listaIncapacidades": ['.Chr(13).Chr(10);

                        $i = 0;

                        // Consulta con los datos que se incluirán en el json
                        $vsql5 = "SELECT valor, devengados
                                    FROM detalleliquidacion  
                                   WHERE pernominaid IN ($listaperiodos) 
                                         AND conceptoid IN (10,40) 
                                         AND terid = ".$terid;
                        $conex  = $clase->Conectar();
                        $result5 = mysql_query($vsql5,$conex);
                        while($row5 = mysql_fetch_array($result5))
                        {
                            $feciniincap = $fecinicio;
                            $diasincap = $row5['valor'];
                            $fecfinincap = date("Y-m-d",strtotime($feciniincap."+ $diasincap days"));

                            $json.= Chr(9).'         {'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "cantidad": "'.str_pad($row5['valor'],1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "tipo": "3",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "pago": "'.str_pad($row5['devengados'],1,"").'"'.Chr(13).Chr(10);

                            $i++;
                            if($i==$numincap)
                                $json.= Chr(9).'         }'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'         },'.Chr(13).Chr(10);

                        }                        

                        if(($numotrosdevenliq>0)||($numlicencias>0))
                            $json.= Chr(9).'      ],'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                    }

                    // Incluyo las licencias
                    if($numlicencias>0)
                    {
                        $json.= Chr(9).'      "listaLicencias": ['.Chr(13).Chr(10);

                        // Consulta con los datos que se incluirán en el json
                        $vsql3 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND c.eslicencia = 'CHECKED' 
                                         AND c.tipodc = 'C' 
                                         AND h.conceptoid NOT IN (10,9,43,40,58) 
                                         AND h.terid = ".$terid;
                        $conex  = $clase->Conectar();
                        $result3 = mysql_query($vsql3,$conex);
                        $i = 0;
                        while($row3 = mysql_fetch_array($result3))
                        {
                            $json.= Chr(9).'         {'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "cantidad": "'.str_pad($row3['valor'],1,"").'",'.Chr(13).Chr(10);

                            if($row3['tipodc']=="C")
                                $json.= Chr(9).'            "pago": "'.str_pad($row3['devengados'],1,"").'",'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'            "pago": "'.str_pad($row3['descuentos'],1,"").'",'.Chr(13).Chr(10);
                            
                            // Licencias de maternidad o paternidad
                            if(($row3['conceptoid']==11)||($row3['conceptoid']==12))
                                $json.= Chr(9).'            "tipoLicencia": "1"'.Chr(13).Chr(10);

                            // Licencias remunerada
                            if(($row3['conceptoid']==10)||($row3['conceptoid']==13)||($row3['conceptoid']==23)||($row3['conceptoid']==31)||($row3['conceptoid']==46))
                                $json.= Chr(9).'            "tipoLicencia": "2"'.Chr(13).Chr(10);
                            
                            // Licencias no remunerada
                            if(($row3['conceptoid']==6)||($row3['conceptoid']==9)||($row3['conceptoid']==43)||($row3['conceptoid']==43))
                                $json.= Chr(9).'            "tipoLicencia": "3"'.Chr(13).Chr(10);

                            $i++;
                            if($i==$numlicencias)
                                $json.= Chr(9).'         }'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        }

                        if($numotrosdevenliq>0)
                            $json.= Chr(9).'      ],'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                    }
    
                    // Otros conceptos devengados
                    if($numotrosdevenliq>0)
                    {
                        $json.= Chr(9).'      "listaOtrosConceptos": ['.Chr(13).Chr(10);
                        $i = 0;
    
                        // Consulta con los datos que se incluirán en el json
                        $vsql12 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                     FROM detalleliquidacion h
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid IN (37,48) 
                                          AND h.terid = ".$terid;
                        $conex  = $clase->Conectar();
                        $result12 = mysql_query($vsql12,$conex);
    
                        while($row12 = mysql_fetch_array($result12))
                        {
                            $json.= Chr(9).'         {'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "descripcionConcepto": "'.str_pad($row12['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "pago": "'.str_pad($row12['devengados'],1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "tipoConcepto": "1"'.Chr(13).Chr(10);
    
                            $i++;
                            if($i==$numotrosdevenliq)
                                $json.= Chr(9).'         }'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        }
                        $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                    }
    
                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
    
                    $json.= Chr(9).'"deducciones": {'.Chr(13).Chr(10);
                    if($embliq>0)      $json.= Chr(9).'   "embargoFiscal": "'.str_pad($embliq,1,"").'",'.Chr(13).Chr(10);
    
                    // otras deducciones
                    if($numotrasdedliq>0)
                    {
                        $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
                        $i = 0;
    
                        // Consulta con los datos que se incluirán en el json
                        $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                         AND h.terid = ".$terid."";
    
                        $conex  = $clase->Conectar();
                        $result7 = mysql_query($vsql7,$conex);
    
                        while($row7 = mysql_fetch_array($result7))
                        {
                            $i++;
                            if($i==$numotrasdedliq)
                                $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'"'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                        }
                        $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                    }
    
                    // descuento por concepto de salud
                    $json.= Chr(9).'   "salud": {'.Chr(13).Chr(10);
                    if($saludliq>0)
                    {
                        $json.= Chr(9).'      "porcentaje": "'.str_pad($por_sal_tra,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'      "deduccion": "'.str_pad($saludliq,1,"").'"'.Chr(13).Chr(10);
                    }
                    else
                    {                    
                        $json.= Chr(9).'      "porcentaje": "0",'.Chr(13).Chr(10);
                        $json.= Chr(9).'      "deduccion": "0"'.Chr(13).Chr(10);
                    }
                    $json.= Chr(9).'   },'.Chr(13).Chr(10);
    
                    // Descuento por concepto de pensión
                    $json.= Chr(9).'   "fondoPension": {'.Chr(13).Chr(10);
                    if($pesionliq>0)
                    {
                        $json.= Chr(9).'      "porcentaje": "'.str_pad($por_pen_tra,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'      "deduccion": "'.str_pad($pesionliq,1,"").'"'.Chr(13).Chr(10);
                    }
                    else
                    {                    
                        $json.= Chr(9).'      "porcentaje": "0",'.Chr(13).Chr(10);
                        $json.= Chr(9).'      "deduccion": "0"'.Chr(13).Chr(10);
                    }
    
                    if(($numlibranzasliq>0))
                        $json.= Chr(9).'   },'.Chr(13).Chr(10);
                    else
                        $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                    // libranzas
                    if($numlibranzasliq>0)
                    {
                        $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
                        $i = 0;
    
                        // Consulta con los datos que se incluirán en el json
                        $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                                         AND h.terid = ".$terid."
                                         AND c.conceptoid NOT IN (10,30)";
                        $conex  = $clase->Conectar();
                        $result4 = mysql_query($vsql4,$conex);
    
                        while($row4 = mysql_fetch_array($result4))
                        {
                            $json.= Chr(9).'      {'.Chr(13).Chr(10);
                            $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
    
                            $i++;
                            if($i==$numlibranzasliq)
                                $json.= Chr(9).'      }'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'      },'.Chr(13).Chr(10);
                        }
                        $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                    }
    
                    $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                    if(($numvacacionest>0)||($numprimas>0)||($numcesantias>0)||($numindemnizacion>0)||($numotrosdevenliq>0)||($montodotacion>0)||($numpagocesan>0))
                        $neto = $devengados - $descuentos;
    
                    $json.= Chr(9).'"devengadosTotal": "'.str_pad($devengados,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'"deduccionesTotal": "'.str_pad($descuentos,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'"comprobanteTotal": "'.str_pad($neto,1,"").'"'.Chr(13).Chr(10);
    
                    $json.='}'.Chr(13).Chr(10);
    
                    // ----------------------------------------------------------------------------------------------------- //
                    // Grabo en el archivo correspondiente la información de empleado
                    $archivo = trim($dni).".json";  //  nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w"); // se abre el archivo para escribir
                    fwrite($fd, $json); // Grabas
                    fclose($fd); // Cierras el archivo
                    $listadereportados.= $terid.",";
                }
            }
            $listadereportados = substr($listadereportados, 0, -1);
        }

        // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Ciclo para los empleados que trabajaron ambas quincenas y también tienen liquidación y son empleados activos, esto es para el caso que uno o varios 
        // empleados hayan tenido cambio de cargo

        $primquin = substr($listaperiodos,0,2);
        $segnquin = substr($listaperiodos,-2);

        $vsqlcambiocargo = "SELECT DISTINCT d.terid,  
                                   CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                   t.esempleadoactivo, t.extralegal
                              FROM detallenomina d
                                   INNER JOIN terceros t ON (d.terid = t.terid)
                             WHERE d.pernominaid = ".$primquin."
                                   AND d.terid IN (SELECT terid
                                                     FROM hisdetallenomina 
                                                    WHERE pernominaid = ".$segnquin.") 
                                   AND d.terid IN (SELECT terid
                                                     FROM detalleliquidacion 
                                                    WHERE pernominaid IN ($listaperiodos))                      
                                   AND d.terid IN (SELECT terid
                                                     FROM liquidacion 
                                                    WHERE periodonomina = '".$codperiodo."')  
                                   AND t.esempleadoactivo = 'CHECKED'
                                   AND t.extralegal <> 'CHECKED'";

        if(strlen($listadereportados)>0)            $vsqlcambiocargo.= " AND d.terid NOT IN ($listadereportados) ";

        if(strlen($nodebensalir) > 0)
            $vsqlcambiocargo.= " AND d.terid NOT IN ($nodebensalir) ";

        $conex  = $clase->Conectar();
        $resultcam = mysql_query($vsqlcambiocargo,$conex);
        $empleadoscambiados = mysql_num_rows($resultcam);

        // $empleadoscambiados = 0;

        if($empleadoscambiados > 0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";                            $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $listadereportados.= ",";                       $vsqlvextralegal = "";
            $numnomext = 0;                                 $vsqlnumvacaciones2 = "";                       $numvacaciones2 = 0;
            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;                                 $vsqlrecargonoc = "";
            $recargonoc = 0;                                $vsqlrecargonocliq = "";                        $recargonocliq = 0;
            $cantidadrn = 0;                                $valorhisdetallenomina = 0;                     $valordetalleliquidacion = 0;
            $pagorn = 0;                                    $devengadoshisdetallenomina = 0;                $devengadosdetalleliquidacion = 0;
            $horaextradiurna = 0;                           $horaextradiurnaliq = 0;                        $montorecnocdonfesliq = 0;
            $horaextradiurna = 0;                           $horaextranocturna = 0;                         $horaextranocturnaliq = 0;
            $horaextranocturna = 0;                         $horaextradiurnadom = 0;                        $horaextradiurnadomliq = 0;
            $horaextradiurnadom = 0;                        $horaextradnocturnadomfes = 0;                  $horaextradnocturnadomfesliq = 0;
            $horaextradnocturnadomfes = 0;                  $cantidadhed = 0;                               $cantidadhedliq = 0;
            $cantidaddehed = 0;                             $montohoraextdiurna = 0;                        $montohoraextdiurnaliq = 0;
            $montodehorasextrasdiura = 0;                   $cantidadhen = 0;                               $cantidadhenliq = 0;
            $cantidaddehen = 0;                             $montohoraextnocturna = 0;                      $montohoraextnocturnaliq = 0;
            $montohorextnoc = 0;                            $cantidadhedd = 0;                              $cantidadheddliq = 0;
            $cantidaddehedd = 0;                            $montohoraextddom = 0;                          $montohoraextddomliq = 0;
            $montohoraextdiudom = 0;                        $cantidadhendf = 0;                             $cantidadhendfliq = 0;
            $cantidaddehendf = 0;                           $montohendf = 0;                                $montohendfliq = 0;
            $montodehendf = 0;                              $cantidaddomfes = 0;                            $cantidaddomfesliq = 0;
            $cantidaddedomfes = 0;                          $montodomfes = 0;                               $montodomfesliq = 0;
            $montodedomfes = 0;                             $cantidadrecnocdonfes = 0;                      $cantidadrecnocdonfesliq = 0;
            $cantidadderecnocdonfes = 0;                    $montorecnocdonfes = 0;
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;

            while($rowcambio = mysql_fetch_array($resultcam))
            {
                // id del empleado
                $terid = $rowcambio['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal = 'CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);
                
                if($numnomext<2)
                {
                    // Documento del empleado
                    $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                    // Ruta del directorio donde están los archivos
                    $path = $ruta.$codperiodo;
    
                    // Arreglo con todos los nombres de los archivos
                    $files = array_diff(scandir($path), array('.', '..'));
    
                    // Inicializo el contador de repetidos
                    $cambiorepetido = 0;
    
                    // Verifico que el documento no se haya procesado
                    foreach($files as $file)
                    {
                        // Divides en dos el nombre de tu archivo utilizando el . 
                        $data = explode(".", $file);
    
                        // Nombre del archivo
                        $fileName = $data[0];
    
                        // Extensión del archivo 
                        $fileExtension = $data[1];
    
                        if($dni == $fileName)
                            $cambiorepetido++;
                    }
    
                    // Genero el archivo json siempre y cuando el archivo no esté repetido
                    if($cambiorepetido==0)
                    {
                        // Días trabajados                    
                        $vsqldias = "SELECT SUM(IF(conceptoid = 1,valor,0)) AS diastrab 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid." 
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                        $diastrab = $clase->SeleccionarUno($vsqldias);
    
                        // Días trabajados en la liquidación
                        $vsqldiasliq = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrabliq 
                                          FROM detalleliquidacion 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND conceptoid = 1";
                        $diastrabliq = $clase->SeleccionarUno($vsqldiasliq);
    
                        $diastrab += $diastrabliq;
    
                        // Documento del empleado
                        $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                        // Primer apellido
                        $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                        // Segundo apellido
                        $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                        // Primer nombre
                        $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                        // Segundo nombre
                        $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                        // Sueldo básico
                        $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                        // Código del trabajador
                        $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                        // Correo electrónico
                        $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                        // Teléfono
                        $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                        // Número de cuenta
                        $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
    
                        // Tipo de documento
                        $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                        // Banco
                        $vsqlbanco = "SELECT b.descripcion AS banco
                                        FROM periodoterceros p
                                             INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                       WHERE p.terid = ".$terid;
                        $banco = $clase->SeleccionarUno($vsqlbanco);
                        $banco = trim(str_replace("BANCO ","",$banco));
    
                        // cargo del empleado
                        $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
    
                        // sueldo del periodo
                        $vsqlsueldo = "SELECT SUM(IF(conceptoid=1,devengados,0)) AS sueldoper 
                                         FROM hisdetallenomina 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid = ".$terid."
                                              AND pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                             AND periodoterceros.extralegal = 'CHECKED')";
                        $sueldoper = $clase->SeleccionarUno($vsqlsueldo);
    
                        $vsqlsueldoliq = "SELECT devengados AS sueldoliq
                                            FROM detalleliquidacion
                                           WHERE terid = ".$terid."
                                                 AND conceptoid = 1
                                                 AND pernominaid IN ($listaperiodos)";
                        $sueldoliq = $clase->SeleccionarUno($vsqlsueldoliq);
    
                        $sueldoper += $sueldoliq;
    
                        // Auxilio de transporte                        
                        $vsqltrasp = "SELECT SUM(IF(conceptoid IN (3,45),devengados,0)) AS auxtransp 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                        $auxtransp = $clase->SeleccionarUno($vsqltrasp);
    
                        $vsqltransliq = "SELECT devengados AS transliq
                                           FROM detalleliquidacion
                                          WHERE terid = ".$terid." 
                                                AND conceptoid = 3
                                                AND pernominaid IN ($listaperiodos)";
                        $transliq = $clase->SeleccionarUno($vsqltransliq);
    
                        $auxtransp += $transliq;

                        // Recargo nocturno
                        $vsqlrecargonoc = "SELECT COUNT(*) AS recargonoc 
                                             FROM hisdetallenomina 
                                            WHERE pernominaid IN ($listaperiodos) 
                                                  AND terid = ".$terid."
                                                  AND conceptoid IN (47,56,59) 
                                                  AND pernominaid NOT IN (SELECT pernominaid 
                                                                            FROM periodoterceros 
                                                                           WHERE periodoterceros.terid = ".$terid." 
                                                                                 AND pernominaid IN ($listaperiodos)
                                                                                 AND extralegal = 'CHECKED')";
                        $recargonoc = $clase->SeleccionarUno($vsqlrecargonoc);

                        $vsqlrecargonocliq = "SELECT COUNT(*) AS recargonocliq
                                                FROM detalleliquidacion
                                               WHERE terid = ".$terid."
                                                     AND conceptoid IN (47,56,59) 
                                                     AND pernominaid IN ($listaperiodos)";
                        $recargonocliq = $clase->SeleccionarUno($vsqlrecargonocliq);

                        $recargonoc += $recargonocliq;

                        // hora extra diurna
                        $horaextradiurna = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 49,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $horaextradiurnaliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 49 AND pernominaid IN ($listaperiodos)");
                        $horaextradiurna += $horaextradiurnaliq;

                        // hora extra nocturna
                        $horaextranocturna = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 50,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $horaextranocturnaliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 50 AND pernominaid IN ($listaperiodos)");
                        $horaextranocturna += $horaextranocturnaliq;

                        // hora extra diurna dominical
                        $horaextradiurnadom = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 51,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $horaextradiurnadomliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 51 AND pernominaid IN ($listaperiodos)");
                        $horaextradiurnadom += $horaextradiurnadomliq;

                        // hora extra nocturna dominical y festivo
                        $horaextradnocturnadomfes = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 52,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $horaextradnocturnadomfesliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 52 AND pernominaid IN ($listaperiodos)");
                        $horaextradnocturnadomfes += $horaextradnocturnadomfesliq;

                        // domingos y festivos
                        $domingosyfestivos = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 53,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $domingosyfestivosliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 53 AND pernominaid IN ($listaperiodos)");
                        $domingosyfestivos += $domingosyfestivosliq;

                        // recargo nocturno dominical y festivo
                        $recargonocdomfes = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 54,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $recargonocdomfesliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 54 AND pernominaid IN ($listaperiodos)");
                        $recargonocdomfes += $recargonocdomfesliq;

                        // total de recargos
                        $numrecargos = $recargonoc + $horaextradiurna + $horaextranocturna + $horaextradiurnadom + $horaextradnocturnadomfes + $domingosyfestivos + $recargonocdomfes;                        
    
                        // Embargo
                        $vsqlembg = "SELECT SUM(IF(conceptoid=30,descuentos,0)) AS embargo 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                        $embargo = $clase->SeleccionarUno($vsqlembg);
    
                        $vsqlembliq = "SELECT descuentos AS embliq
                                         FROM detalleliquidacion
                                        WHERE terid = ".$terid."
                                              AND conceptoid = 30
                                              AND pernominaid IN ($listaperiodos)";
                        $embliq = $clase->SeleccionarUno($vsqlembliq);
    
                        $embargo += $embliq;
    
                        // Salud                        
                        $vsqlsalud = "SELECT SUM(IF(conceptoid=5,descuentos,0)) AS salud 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                        $salud = $clase->SeleccionarUno($vsqlsalud);
    
                        $vsqlsaludliq = "SELECT descuentos AS saludliq
                                           FROM detalleliquidacion
                                          WHERE terid = ".$terid." 
                                                AND conceptoid = 5
                                                AND pernominaid IN ($listaperiodos)";
                        $saludliq = $clase->SeleccionarUno($vsqlsaludliq);
    
                        $salud += $saludliq;
    
                        // Pensión                        
                        $vsqlpension = "SELECT SUM(IF(conceptoid=4,descuentos,0)) AS pension 
                                          FROM hisdetallenomina 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
                        $pension = $clase->SeleccionarUno($vsqlpension);
    
                        $vsqlpesionliq = "SELECT descuentos AS pesionliq
                                            FROM detalleliquidacion
                                           WHERE terid = ".$terid." 
                                                 AND conceptoid = 4
                                                 AND pernominaid IN ($listaperiodos)";
                        $pesionliq = $clase->SeleccionarUno($vsqlpesionliq);
    
                        $pension += $pesionliq;
    
                        // total devengado
                        $vsqldev = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                      FROM hisdetallenomina 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                          AND periodoterceros.extralegal = 'CHECKED')";
                        $devengados = $clase->SeleccionarUno($vsqldev);
    
                        $vsqldevliq = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                         FROM detalleliquidacion 
                                        WHERE terid=".$terid;
                        $devengadosliq = $clase->SeleccionarUno($vsqldevliq);
    
                        $devengados += $devengadosliq;
    
                        // total descuentos
                        $vsqldesc = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                        $descuentos = $clase->SeleccionarUno($vsqldesc);
    
                        $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                          FROM detalleliquidacion 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid;
                        $descuentosliq = $clase->SeleccionarUno($vsqldescliq);
    
                        $descuentos += $descuentosliq;
    
                        $neto = $devengados - $descuentos;
        
                        // Obtengo la fecha de ingreso del empleado
                        $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');

                        $fechaEntera = strtotime($fecingreso);
                        $mesfecingreso = date("m", $fechaEntera);
                        $yeaarfecingreso = date("Y", $fechaEntera);

                        if(($mesfecingreso > $mesperiodo2) && (intval($yearperiodo) == intval($yeaarfecingreso)))
                        {
                            // fechas de ingreso y retiro
                            $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                            $idhistorico = $clase->SeleccionarUno($vsql18);

                            $vsql21 = "SELECT hc.fecingreso 
                                         FROM histcontrato hc 
                                        WHERE hc.terid = ".$terid." 
                                              AND hc.id = ".$idhistorico;
                            $fecingreso = $clase->SeleccionarUno($vsql21);

                            if($fecingreso == "")
                                $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
                        }                        
    
                        // Incapacidades del periodo                        
                        $vsqlincapacidad = "SELECT COUNT(*) AS numincap 
                                              FROM hisdetallenomina 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND conceptoid IN (10,40)
                                                   AND terid = ".$terid." 
                                                   AND pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                  AND periodoterceros.extralegal = 'CHECKED')";
                        $numincap = $clase->SeleccionarUno($vsqlincapacidad);

                        $vsqlincapacidad2 = "SELECT COUNT(*) AS numincap
                                               FROM detalleliquidacion 
                                              WHERE pernominaid IN ($listaperiodos) 
                                                    AND terid = ".$terid."
                                                    AND conceptoid IN (10,43,40)";
                        $numincap2 = $clase->SeleccionarUno($vsqlincapacidad2);

                        $numincap += $numincap2;                        
    
                        // Licencias del periodo
                        $vsqlincapacidad = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                              FROM hisdetallenomina h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND c.eslicencia = 'CHECKED' 
                                                   AND c.tipodc = 'C' 
                                                   AND h.conceptoid NOT IN (10,9,43,40,58)                                           
                                                   AND h.terid = ".$terid."
                                                   AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                    AND periodoterceros.extralegal = 'CHECKED')";
                        $numlicencias = $clase->SeleccionarUno($vsqlincapacidad);

                        $vsqlincapacidad2 = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                               FROM detalleliquidacion h
                                                    INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                              WHERE h.pernominaid IN ($listaperiodos)
                                                    AND c.eslicencia = 'CHECKED' 
                                                    AND c.tipodc = 'C' 
                                                    AND h.conceptoid NOT IN (10,9,43,40,58)                                         
                                                    AND h.terid = ".$terid;
                        $numlicencias2 = $clase->SeleccionarUno($vsqlincapacidad2);

                        $numlicencias += $numlicencias2;                        
    
                        // Libranzas del periodo
                        $vsqllibranzas = "SELECT COUNT(h.conceptoid) AS numlibranzas 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                                 AND h.terid = ".$terid."
                                                 AND c.conceptoid NOT IN (10,30)
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                  AND periodoterceros.extralegal = 'CHECKED')";
                        $numlibranzas = $clase->SeleccionarUno($vsqllibranzas);
    
                        // Libranzas en liquidación
                        $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                               FROM detalleliquidacion h
                                                    INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                              WHERE h.pernominaid IN ($listaperiodos)
                                                    AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                                    AND h.terid = ".$terid."
                                                    AND c.conceptoid NOT IN (10,30)";
                        $numlibranzasliq = $clase->SeleccionarUno($vsqllibranzasliq);
    
                        // Sanciones del periodo
                        $vsqlsanciones = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid = 9
                                                 AND h.terid = ".$terid." 
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                  AND periodoterceros.extralegal = 'CHECKED')";
                        $numsanciones = $clase->SeleccionarUno($vsqlsanciones);
    
                        // Otras deducciones
                        // Estas incluyen: LICENCIA NO REMUNERADA, CAMISETAS, PLAN TELEFONIA MOVIL, PRESTAMOS PERSONALES, AJUSTE SALARIO SENA, 
                        // CREDITOS OTROS NEGOCIOS, DESCUENTO SP, MANGAS, CAFETERIA, MACROPAPELES y COMPRAS A CREDITO, OTROS E INCAPACIDAD SUPERIOR A 180 DÍAS,
                        // DIAS NO LABORADOS SIN JUSTIFICACION
                        $vsqlotrasdeduc = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                                  AND h.terid = ".$terid." 
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                        $numotrasded = $clase->SeleccionarUno($vsqlotrasdeduc);
    
                        // otras deducciones en liquidación
                        $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                                FROM detalleliquidacion h
                                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                               WHERE h.pernominaid IN ($listaperiodos)
                                                     AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                                     AND h.terid = ".$terid;
                        $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);
    
                        // Vacaciones
                        $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'vacaciones'";
                        $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                        // Vacaciones pagadas en quincenas
                        $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2 
                                                 FROM hisdetallenomina 
                                                WHERE terid = ".$terid."
                                                      AND conceptoid = 38 
                                                      AND pernominaid IN ($listaperiodos)";
                        $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                        $numvacacionest = $numvacaciones1 + $numvacaciones2;
    
                        // Primas
                        $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid." 
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $numprimas = $clase->SeleccionarUno($vsqlnumprimas);
    
                        // Cesantías
                        $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                               FROM liquidacion
                                              WHERE terid = ".$terid." 
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);
    
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid." 
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        // Indemnización
                        $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                                FROM liquidacion
                                               WHERE terid = ".$terid." 
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                        // Otros conceptos devengados
                        $vsqlotrosdeven = "SELECT COUNT(h.conceptoid) AS numotrosdeven
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid IN (37,48) 
                                                  AND h.terid = ".$terid." 
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                        $numotrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
    
                        // Dotaciones 
                        $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                             FROM dotaciones
                                            WHERE periodonomina = '".$codperiodo."'
                                                  AND terid = ".$terid."";
                        $montodotacion = $clase->SeleccionarUno($vsqldotaciones);
    
                        // Genero el código consecutivo de nómina electrónica
                        $consecutivone = $clase->BDLockup($segundaquinper,'periodosnomina','periodoid','consecutivone');
    
                        // Valido si es el primero o el siguiente
                        if($consecutivone=="")
                        {
                            $newper = substr($codperiodo,0,2).substr($codperiodo,-2);
                            $newcod = $newper."00001";
                            $newconsecutivo = "NE".$newcod;
                        }
                        else
                        {
                            // Incremento el consecutivo
                            $numconsn = intval(substr($consecutivone,-5));
                            $numconsn++;
                            $newcod = strval($numconsn);
    
                            // Relleno con ceros
                            if(strlen($newcod)==1)      $newcod = "0000".$newcod;
                            if(strlen($newcod)==2)      $newcod = "000".$newcod;
                            if(strlen($newcod)==3)      $newcod = "00".$newcod;
                            if(strlen($newcod)==4)      $newcod = "0".$newcod;
                            
                            $newper = substr($codperiodo,0,2).substr($codperiodo,-2);
                            $newcod = $newper.$newcod;
    
                            // Construyo el nuevo consecutivo
                            $newconsecutivo = "NE".$newcod;
                        }
    
                        // Almacenos en la tabla el nuevo consecutivo
                        $vsqlactcons = "UPDATE periodosnomina SET 
                                               consecutivone = '".$newconsecutivo."'
                                         WHERE periodoid = ".$segundaquinper;
                        $clase->EjecutarSQL($vsqlactcons);
    
                        $prefijo = substr($newconsecutivo,0,2);
    
                        // ------------------------------------------------------------------------------------------------------------------------------------------------------- //
                        // Construyo el json con los datos del empleado
                        $json='{'.Chr(13).Chr(10);
                        $json.= Chr(9).'"idEmpresa": "1536",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"token": "'.str_pad($token,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"tipoDocumento": "1",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"almacenamiento": "1",'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"listaFechaPago": ['.Chr(13).Chr(10);
                        $json.= Chr(9).'  "'.str_pad($fecinicio,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "'.str_pad($fecfinal,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'],'.Chr(13).Chr(10);
                        
                        $json.= Chr(9).'"periodo": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaIngreso": "'.str_pad($fecingreso,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaLiquidacionInicio": "'.str_pad($fecinicio,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaLiquidacionFin": "'.str_pad($fecfinal,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tiempoLaborado": "'.str_pad($diastrab,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaGen": "'.str_pad($fechaAct,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"numeroSecuenciaXML": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "prefijo": "'.str_pad($prefijo,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "consecutivo": "'.str_pad($newcod,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"lugarGeneracionXML": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "pais": "CO",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "departamentoEstado": "54",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "municipioCiudad": "54001",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "idioma": "es"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"informacionGeneral": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaGen": "'.str_pad($fechaAct,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "horaGen": "'.str_pad($horaAct,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "periodoNomina": "5",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "tipoMoneda": "COP",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "trm": ""'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tipoMoneda": "COP"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"trabajador": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "subTipoTrabajador": "00",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "altoRiesgoPension": "true",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tipoDocumento": "13",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "numeroDocumento": "'.str_pad($dni,1,"").'",'.Chr(13).Chr(10);
                        if($primerapellido!="")      $json.= Chr(9).'  "primerApellido": "'.str_pad($primerapellido,1,"").'",'.Chr(13).Chr(10);
                        if($segundoapellido!="")     $json.= Chr(9).'  "segundoApellido": "'.str_pad($segundoapellido,1,"").'",'.Chr(13).Chr(10);
                        if($primernombre!="")        $json.= Chr(9).'  "primerNombre": "'.str_pad($primernombre,1,"").'",'.Chr(13).Chr(10);
                        if(trim($segundonombre)!="") $json.= Chr(9).'  "otrosNombres": "'.str_pad($segundonombre,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoPais": "CO",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoDepartamentoEstado": "54",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoMunicipioCiudad": "54001",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoDireccion": "AVENIDA 7A # 0BN38 BARRIO SEVILLA",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "salarioIntegral": "false",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tipoContrato": "1",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "sueldo": "'.str_pad($basico,1,"").'"'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "codigoTrabajador": "'.str_pad($codvende,1,"").'"'.Chr(13).Chr(10);
                        
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
        
                        // valido que el número de cuenta esté vacío
                        $json.= Chr(9).'"pago": {'.Chr(13).Chr(10);
                        if($numcuenta!="")
                        {
                            $json.= Chr(9).'  "forma": "1",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "metodo": "45",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "banco": "'.str_pad($banco,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "tipoCuenta": "AHORROS",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "numeroCuenta": "'.str_pad($numcuenta,1,"").'"'.Chr(13).Chr(10);
                        }
                        else
                        {                        
                            $json.= Chr(9).'  "forma": "1",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "metodo": "10"'.Chr(13).Chr(10);
                        }
                        
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
                        $json.= Chr(9).'"devengados": {'.Chr(13).Chr(10);
    
                        // dotaciones
                        if($montodotacion>0)
                        {
                            $json.= Chr(9).'   "dotacion": "'.str_pad($montodotacion,1,"").'",'.Chr(13).Chr(10);
                            $devengados += $montodotacion;
                        }
    
                        if ($numindemnizacion>0)
                        {
                            // Pago por la indemnización
                            $vsqlindemnizacion = "SELECT pago AS pagoindemnizacion
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid." 
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'indemnizacion'";
                            $pagoindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                            // Imprimo la indemnización
                            $json.= Chr(9).'  "indemnizacion": "'.str_pad($pagoindemnizacion,1,"").'",'.Chr(13).Chr(10);
    
                            // Incremento del devengado
                            $devengados += $pagoindemnizacion;
                        }
    
                        $json.= Chr(9).'  "basico": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'     "diasTrabajados": "'.str_pad($diastrab,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'     "sueldoTrabajado": "'.str_pad($sueldoper,1,"").'"'.Chr(13).Chr(10);
    
                        if(($auxtransp>0)||($numrecargos>0)||($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0)||($numpagocesan>0))
                            $json.= Chr(9).'  },'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'  }'.Chr(13).Chr(10);
                        
                        if($auxtransp>0)
                        {
                            $json.= Chr(9).'  "transporte": ['.Chr(13).Chr(10);
                            $json.= Chr(9).'     {'.Chr(13).Chr(10);
                            $json.= Chr(9).'       "auxilioTransporte": "'.str_pad($auxtransp,1,"").'"'.Chr(13).Chr(10);
                            $json.= Chr(9).'     }'.Chr(13).Chr(10);
    
                            if(($numrecargos>0)||($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0)||($numpagocesan>0))
                                $json.= Chr(9).'  ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'  ]'.Chr(13).Chr(10);
                        }

                        // Recargo nocturno
                        if($numrecargos > 0)
                        {
                            $json.= Chr(9).'   "listaHeR": ['.Chr(13).Chr(10);

                            $vsql30  = "SELECT SUM(valor) AS cantidad, 
                                               CASE
                                                 WHEN conceptoid = 47 THEN '35.00'
                                                 WHEN conceptoid = 49 THEN '25.00'
                                                 WHEN conceptoid = 50 THEN '75.00'           
                                                 WHEN conceptoid = 51 THEN '105.00' 
                                                 WHEN conceptoid = 52 THEN '155.00'
                                                 WHEN conceptoid = 53 THEN '80.00'         
                                                 WHEN conceptoid = 54 THEN '115.00'
                                                 WHEN conceptoid = 56 THEN '35.00'
                                                 WHEN conceptoid = 59 THEN '35.00'
                                               END porcentaje,
                                               SUM(devengados) AS pago,  
                                               CASE
                                                 WHEN conceptoid = 47 THEN '3'
                                                 WHEN conceptoid = 49 THEN '1'
                                                 WHEN conceptoid = 50 THEN '2'           
                                                 WHEN conceptoid = 51 THEN '4' 
                                                 WHEN conceptoid = 52 THEN '6'
                                                 WHEN conceptoid = 53 THEN '5'         
                                                 WHEN conceptoid = 54 THEN '7'
                                                 WHEN conceptoid = 56 THEN '3'
                                                 WHEN conceptoid = 59 THEN '3'
                                               END tipoHeR,
                                               CASE
                                                 WHEN conceptoid = 47 THEN 'Hora Recargo Nocturno'
                                                 WHEN conceptoid = 49 THEN 'Hora Extra Diurna'
                                                 WHEN conceptoid = 50 THEN 'Hora Extra Nocturna'           
                                                 WHEN conceptoid = 51 THEN 'Hora Extra Diurna Dominical y Festivos' 
                                                 WHEN conceptoid = 52 THEN 'Hora Extra Nocturna Dominical y Festivos'
                                                 WHEN conceptoid = 53 THEN 'Hora Recargo Diurno Dominical y Festivos'         
                                                 WHEN conceptoid = 54 THEN 'Hora Recargo Nocturno Dominical y Festivos'
                                                 WHEN conceptoid = 56 THEN 'Hora Recargo Nocturno'
                                                 WHEN conceptoid = 59 THEN 'Hora Recargo Nocturno'
                                               END descripcion            
                                          FROM hisdetallenomina 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND conceptoid IN (47,49,50,51,52,53,54,56,59) 
                                               AND terid = ".$terid." 
                                               AND pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros p
                                                                        WHERE p.terid = ".$terid."  
                                                                              AND p.pernominaid IN ($listaperiodos)
                                                                              AND p.extralegal = 'CHECKED')
                                      GROUP BY conceptoid";

                            $conex  = $clase->Conectar();
                            $result30 = mysql_query($vsql30,$conex);
                            $cant1 = mysql_num_rows($result30);             $cant2 = 0;
                            while($row30 = mysql_fetch_array($result30))
                            {                                
                                $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "cantidad": "'.str_pad($row30['cantidad'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "porcentaje": "'.str_pad($row30['porcentaje'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "pago": "'.str_pad($row30['pago'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "tipoHeR": "'.str_pad($row30['tipoHeR'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "descripcion": "'.str_pad($row30['descripcion'],1,"").'"'.Chr(13).Chr(10);

                                $cant2++;

                                if($cant2 < $cant1)
                                    $json.= Chr(9).'         },'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'         }'.Chr(13).Chr(10);
                            }
                            // ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ //

                            if(($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0)||($numpagocesan>0))
                                $json.= Chr(9).'  ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'  ]'.Chr(13).Chr(10);
                        }
    
                        // primas de periodo
                        if($numprimas>0)
                        {
                            $json.= Chr(9).'"  primas": {'.Chr(13).Chr(10);
    
                            // Días de la prima
                            $vsqlcanprimas = "SELECT cantidad AS canprimas
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'primas'";
                            $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                            // Pago de la prima
                            $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                                 FROM liquidacion
                                                WHERE terid = ".$terid." 
                                                      AND periodonomina = '".$codperiodo."' 
                                                      AND tipo = 'primas'";
                            $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);
    
                            $json.= Chr(9).'     "cantidad": "'.str_pad($canprimas,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'     "pago": "'.str_pad($pagoprimas,1,"").'"'.Chr(13).Chr(10);
    
                            if(($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0)||($numpagocesan>0))
                                $json.= Chr(9).'   },'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                            // Incremento el total devengado
                            $devengados += $pagoprimas;
                        }
    
                        // Cesantías del empleado
                        if($numcesantias>0)
                        {       
                            // Pago de la cesantía
                            $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);
    
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid." 
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia += $montopagocesan;
                            }
    
                            // Porcentaje cesantía
                            $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);
    
                            // Pago de intereses de cesantías
                            $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'cesantias'";
                            $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);
                            
                            $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "pago": "'.str_pad($pagocesantia,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "porcentaje": "'.str_pad(number_format($porccesantia,2),1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "pagoIntereses": "'.str_pad($pagointereses,1,"").'"'.Chr(13).Chr(10);    
                               
                            if(($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0))
                                $json.= Chr(9).'   },'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                            // Incremento el total devengado
                            $devengados += $pagocesantia;
                            $devengados += $pagointereses;
                        }
                        else
                        {
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia = $montopagocesan;
    
                                $porccesantia = 0;
                                $pagointereses = 0;
    
                                $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                                $json.= Chr(9).'      "pago": "'.str_pad($pagocesantia,1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'      "porcentaje": "'.str_pad(number_format($porccesantia,2),1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'      "pagoIntereses": "'.str_pad($pagointereses,1,"").'"'.Chr(13).Chr(10);    
                                   
                                if(($numvacacionest>0)||($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0))
                                    $json.= Chr(9).'   },'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                                // Incremento el total devengado
                                $devengados += $pagocesantia;
                            }
                        }
    
                        // Vacaciones del empleado
                        if($numvacacionest>0)
                        {
                            $json.= Chr(9).'      "listaVacaciones": ['.Chr(13).Chr(10); 
                            $json.= Chr(9).'         {'.Chr(13).Chr(10);
    
                            if($numvacaciones1 > 0)
                            {
                                // Días de vacaciones
                                $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                        FROM liquidacion
                                                       WHERE terid = ".$terid."
                                                             AND periodonomina = '".$codperiodo."' 
                                                             AND tipo = 'vacaciones'";
                                $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                                // Pago de vacaciones
                                $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'vacaciones'";
                                $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                            }
                            else
                            {
                                $canvacaciones = 0;
                                $pagovaca1 = 0;
                            }

                            if($numvacaciones2>0)
                            {
                                $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                    FROM hisdetallenomina  
                                                   WHERE terid = ".$terid."
                                                         AND conceptoid = 38 
                                                         AND pernominaid IN ($listaperiodos)";
                                $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                            }
                            else
                                $pagovaca2 = 0;
                            
                            if($canvacaciones == 0)               $canvacaciones = 1;
                            $pagovaca = $pagovaca1 + $pagovaca2;
    
                            $json.= Chr(9).'            "cantidad": "'.str_pad($canvacaciones,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "pago": "'.str_pad($pagovaca,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "tipoVacacion": "1"'.Chr(13).Chr(10);
                            $json.= Chr(9).'         }'.Chr(13).Chr(10);    
                               
                            if(($numincap>0)||($numincap2>0)||($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0))
                                $json.= Chr(9).'],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).']'.Chr(13).Chr(10);
    
                            // Incremento el total devengado
                            $devengados += $pagovaca1;
                        }
    
                        // Incluyo las incapacidades
                        if(($numincap>0) || ($numincap2>0))
                        {
                            $json.= Chr(9).'      "listaIncapacidades": ['.Chr(13).Chr(10);

                            if($numincap>0)
                            {
                                $i = 0;
                                // Consulta con los datos que se incluirán en el json
                                $vsql5 = "SELECT valor, devengados
                                            FROM hisdetallenomina 
                                           WHERE pernominaid IN ($listaperiodos) 
                                                 AND conceptoid IN (10,40) 
                                                 AND terid = ".$terid." 
                                                 AND pernominaid NOT IN (SELECT pernominaid 
                                                                           FROM periodoterceros
                                                                          WHERE periodoterceros.terid = ".$terid." 
                                                                                AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                AND periodoterceros.extralegal = 'CHECKED')";
                                $conex  = $clase->Conectar();
                                $result5 = mysql_query($vsql5,$conex);
                                while($row5 = mysql_fetch_array($result5))
                                {
                                    $feciniincap = $fecinicio;
                                    $diasincap = $row5['valor'];
                                    $fecfinincap = date("Y-m-d",strtotime($feciniincap."+ $diasincap days"));
        
                                    $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "cantidad": "'.str_pad($row5['valor'],1,"").'",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "tipo": "3",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "pago": "'.str_pad($row5['devengados'],1,"").'"'.Chr(13).Chr(10);
        
                                    $i++;
                                    if(($i==$numincap) && ($numincap2==0))
                                        $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'         },'.Chr(13).Chr(10);
                                }
                            }

                            if($numincap2>0)
                            {
                                $i = 0;

                                // Consulta con los datos que se incluirán en el json
                                $vsql5 = "SELECT valor, devengados
                                            FROM detalleliquidacion  
                                           WHERE pernominaid IN ($listaperiodos) 
                                                 AND conceptoid IN (10,40) 
                                                 AND terid = ".$terid;
                                $conex  = $clase->Conectar();
                                $result5 = mysql_query($vsql5,$conex);
                                while($row5 = mysql_fetch_array($result5))
                                {
                                    $feciniincap = $fecinicio;
                                    $diasincap = $row5['valor'];
                                    $fecfinincap = date("Y-m-d",strtotime($feciniincap."+ $diasincap days"));
        
                                    $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "cantidad": "'.str_pad($row5['valor'],1,"").'",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "tipo": "3",'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "pago": "'.str_pad($row5['devengados'],1,"").'"'.Chr(13).Chr(10);
        
                                    $i++;
                                    if($i==$numincap2)
                                        $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'         },'.Chr(13).Chr(10);
                                }
                            }
                               
                            if(($numlicencias>0)||($numlicencias2>0)||($numotrosdeven>0))
                                $json.= Chr(9).'      ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                        }
    
                        // Incluyo las licencias
                        if($numlicencias>0)
                        {
                            $json.= Chr(9).'      "listaLicencias": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql3 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND c.eslicencia = 'CHECKED' 
                                             AND c.tipodc = 'C' 
                                             AND h.conceptoid NOT IN (10,9,43,40,58)
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result3 = mysql_query($vsql3,$conex);
    
                            while($row3 = mysql_fetch_array($result3))
                            {
                                $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "cantidad": "'.str_pad($row3['valor'],1,"").'",'.Chr(13).Chr(10);
    
                                if($row3['tipodc']=="C")
                                    $json.= Chr(9).'            "pago": "'.str_pad($row3['devengados'],1,"").'",'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'            "pago": "'.str_pad($row3['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                
                                // Licencias de maternidad o paternidad
                                if(($row3['conceptoid']==11)||($row3['conceptoid']==12))
                                    $json.= Chr(9).'            "tipoLicencia": "1"'.Chr(13).Chr(10);
    
                                // Licencias remunerada
                                if(($row3['conceptoid']==10)||($row3['conceptoid']==13)||($row3['conceptoid']==23)||($row3['conceptoid']==31)||($row3['conceptoid']==40)||($row3['conceptoid']==46))
                                    $json.= Chr(9).'            "tipoLicencia": "2"'.Chr(13).Chr(10);
                                
                                // Licencias no remunerada
                                if(($row3['conceptoid']==6)||($row3['conceptoid']==9)||($row3['conceptoid']==43)||($row3['conceptoid']==58))
                                    $json.= Chr(9).'            "tipoLicencia": "3"'.Chr(13).Chr(10);
    
                                $i++;
                                if(($i==$numlicencias) && ($numlicencias2==0))
                                    $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'         },'.Chr(13).Chr(10);

                                if($numlicencias2==0)
                                {
                                    if($numotrosdeven>0)
                                        $json.= Chr(9).'      ],'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                                }                                    
                            }

                            if($numlicencias2>0)
                            {
                                $i = 0;
    
                                // Consulta con los datos que se incluirán en el json
                                $vsql3 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND c.eslicencia = 'CHECKED' 
                                                 AND c.tipodc = 'C' 
                                                 AND h.conceptoid NOT IN (10,9,43,40,58) 
                                                 AND h.terid = ".$terid;
                                $conex  = $clase->Conectar();
                                $result3 = mysql_query($vsql3,$conex);
        
                                while($row3 = mysql_fetch_array($result3))
                                {
                                    $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                    $json.= Chr(9).'            "cantidad": "'.str_pad($row3['valor'],1,"").'",'.Chr(13).Chr(10);
        
                                    if($row3['tipodc']=="C")
                                        $json.= Chr(9).'            "pago": "'.str_pad($row3['devengados'],1,"").'",'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'            "pago": "'.str_pad($row3['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                    
                                    // Licencias de maternidad o paternidad
                                    if(($row3['conceptoid']==11)||($row3['conceptoid']==12))
                                        $json.= Chr(9).'            "tipoLicencia": "1"'.Chr(13).Chr(10);
    
                                    // Licencias remunerada
                                    if(($row3['conceptoid']==10)||($row3['conceptoid']==13)||($row3['conceptoid']==23)||($row3['conceptoid']==31)||($row3['conceptoid']==46))
                                        $json.= Chr(9).'            "tipoLicencia": "2"'.Chr(13).Chr(10);
                                    
                                    // Licencias no remunerada
                                    if(($row3['conceptoid']==6)||($row3['conceptoid']==9)||($row3['conceptoid']==43)||($row3['conceptoid']==58))
                                        $json.= Chr(9).'            "tipoLicencia": "3"'.Chr(13).Chr(10);
    
                                    $i++;
                                    if($i==$numlicencias2)
                                        $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                    else
                                        $json.= Chr(9).'         },'.Chr(13).Chr(10);
                                }   

                                if($numotrosdeven>0)
                                    $json.= Chr(9).'      ],'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                            }
                        }
    
                        // Otros conceptos devengados
                        if($numotrosdeven>0)
                        {
                            $json.= Chr(9).'      "listaOtrosConceptos": ['.Chr(13).Chr(10);                        
                            $i = 0;
    
                            // Consulta con los datos que se incluirán en el json
                            $vsql12 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid IN (37,48) 
                                              AND h.terid = ".$terid."
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid." 
                                                                               AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                               AND periodoterceros.extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result12 = mysql_query($vsql12,$conex);
    
                            while($row12 = mysql_fetch_array($result12))
                            {
                                $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "descripcionConcepto": "'.str_pad($row12['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "pago": "'.str_pad($row12['devengados'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "tipoConcepto": "1"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numotrosdeven)
                                    $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'         },'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                        }
    
                        $json.= Chr(9).'      },'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"deducciones": {'.Chr(13).Chr(10);
                        if($embargo>0)      $json.= Chr(9).'   "embargoFiscal": "'.str_pad($embargo,1,"").'",'.Chr(13).Chr(10);
    
                        // otras deducciones
                        if(($numotrasded>0)&&($numotrasdedliq>0))
                        {
                            $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
                            
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                             AND h.terid = ".$terid." 
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
    
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                            }
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                              AND h.terid = ".$terid."";
    
                            $conex  = $clase->Conectar();
                            $result77 = mysql_query($vsql77,$conex);
    
                            while($row77 = mysql_fetch_array($result77))
                            {
                                $i++;
                                if($i==$numotrasdedliq)
                                    $json.= Chr(9).'      "'.str_pad($row77['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      "'.str_pad($row77['descuentos'],1,"").'",'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                        }
    
                        if(($numotrasded==0)&&($numotrasdedliq>0))
                        {
                            $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                             AND h.terid = ".$terid;
    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
    
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $i++;
                                if($i==$numotrasdedliq)
                                    $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                        }
    
                        if(($numotrasded>0)&&($numotrasdedliq==0))
                        {
                            $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
    
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $i++;
                                if($i==$numotrasded)
                                    $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                        }
    
                        // Descuento por concepto de salud
                        $json.= Chr(9).'   "salud": {'.Chr(13).Chr(10);
                        if($salud>0)
                        {
                            $json.= Chr(9).'      "porcentaje": "'.str_pad($por_sal_tra,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "'.str_pad($salud,1,"").'"'.Chr(13).Chr(10);
                        }
                        else
                        {                        
                            $json.= Chr(9).'      "porcentaje": "0",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "0"'.Chr(13).Chr(10);
                        }
                        $json.= Chr(9).'   },'.Chr(13).Chr(10);
    
                        // Descuento por concepto de pensión
                        $json.= Chr(9).'   "fondoPension": {'.Chr(13).Chr(10);
                        if($pension>0)
                        {
                            $json.= Chr(9).'      "porcentaje": "'.str_pad($por_pen_tra,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "'.str_pad($pension,1,"").'"'.Chr(13).Chr(10);
                        }
                        else
                        {                        
                            $json.= Chr(9).'      "porcentaje": "0",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "0"'.Chr(13).Chr(10);
                        }
    
                        if(($numsanciones>0)||($numlibranzas>0)||($numlibranzasliq>0))
                            $json.= Chr(9).'   },'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                        // Incluyo las sanciones
                        if($numsanciones>0)
                        {
                            $json.= Chr(9).'   "listaSanciones": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql6 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid = 9
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result6 = mysql_query($vsql6,$conex);
    
                            while($row6 = mysql_fetch_array($result6))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "valorSancion": "'.str_pad($row6['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "tipoSancion": "2"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numsanciones)
                                    $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
                            
                            if(($numlibranzas>0)||($numlibranzasliq>0))
                                $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        }
    
                        // libranzas
                        if(($numlibranzas>0)&&($numlibranzasliq>0))
                        {                                
                            $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
                            
                            // Consulta con los datos que se incluirán en el json
                            $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                             AND h.terid = ".$terid." 
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result4 = mysql_query($vsql4,$conex);
    
                            while($row4 = mysql_fetch_array($result4))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql44 = "SELECT c.nomconcepto, h.descuentos  
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                              AND h.terid = ".$terid." 
                                              AND c.conceptoid NOT IN (10,30)
                                              AND h.pernominaid IN ($listaperiodos)";
    
                            $conex  = $clase->Conectar();
                            $result44 = mysql_query($vsql44,$conex);
    
                            while($row44 = mysql_fetch_array($result44))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "descripcion": "'.str_pad($row44['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "deduccion": "'.str_pad($row44['descuentos'],1,"").'"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numlibranzasliq)
                                    $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        }
                        
                        if(($numlibranzas==0)&&($numlibranzasliq>0))
                        {                                
                            $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                             AND h.terid = ".$terid." 
                                             AND c.conceptoid NOT IN (10,30)";
                            $conex  = $clase->Conectar();

                            $result4 = mysql_query($vsql4,$conex);
    
                            while($row4 = mysql_fetch_array($result4))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numlibranzasliq)
                                    $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        }
    
                        if(($numlibranzas>0)&&($numlibranzasliq==0))
                        {
                            $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
        
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                             AND h.terid = ".$terid." 
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result4 = mysql_query($vsql4,$conex);
    
                            while($row4 = mysql_fetch_array($result4))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numlibranzas)
                                    $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        }
    
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        if(($numvacacionest>0)||($numprimas>0)||($numcesantias>0)||($numindemnizacion>0)||($numotrosdeven>0)||($montodotacion>0)||($numpagocesan>0))
                            $neto = $devengados - $descuentos;
    
                        $json.= Chr(9).'"devengadosTotal": "'.str_pad($devengados,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"deduccionesTotal": "'.str_pad($descuentos,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"comprobanteTotal": "'.str_pad($neto,1,"").'"'.Chr(13).Chr(10);
    
                        $json.='}'.Chr(13).Chr(10);
    
                        // ----------------------------------------------------------------------------------------------------- //
                        // Grabo en el archivo correspondiente la información de empleado
                        $archivo = trim($dni).".json";  //  nombre del archivo
                        $fd = fopen ($carpetaactual."/".$archivo, "w"); // se abre el archivo para escribir
                        fwrite($fd, $json); // Grabas
                        fclose($fd); // Cierras el archivo
                        $listadereportados.= $terid.",";
                    }
                }                
            }
            $listadereportados = substr($listadereportados, 0, -1);
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Ciclo para los empleados que no trabajaron ninguna quincena y tienen una liquidación
        $vsqlsololiquidacion = "SELECT DISTINCT terid
                                  FROM liquidacion 
                                 WHERE periodonomina = '".$codperiodo."'
                                       AND terid NOT IN (SELECT terid
                                                           FROM detalleliquidacion 
                                                          WHERE pernominaid IN ($listaperiodos))";

        if(strlen($listadereportados)>0)            $vsqlsololiquidacion.= " AND terid NOT IN ($listadereportados)";

        if(strlen($nodebensalir) > 0)
            $vsqlsololiquidacion.= " AND terid NOT IN ($nodebensalir) ";
        
        $conex  = $clase->Conectar();
        $resultsololiq = mysql_query($vsqlsololiquidacion,$conex);
        $empleadossololiq = mysql_num_rows($resultsololiq);

        // $empleadossololiq = 0;

        if($empleadossololiq > 0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";                            $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $listadereportados.= ",";                       $vsqlvextralegal = "";
            $numnomext = 0;                                 $vsqlnumvacaciones2 = "";                       $numvacaciones2 = 0;
            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;            

            while($rowsololiq = mysql_fetch_array($resultsololiq))
            {
                // id del empleado
                $terid = $rowsololiq['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal = 'CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);
                
                if($numnomext<2)                
                {
                    // Documento del empleado
                    $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                    // Ruta del directorio donde están los archivos
                    $path = $ruta.$codperiodo;
    
                    // Arreglo con todos los nombres de los archivos
                    $files = array_diff(scandir($path), array('.', '..'));
    
                    // Inicializo el contador de repetidos
                    $cambiorepetido = 0;
    
                    // Verifico que el documento no se haya procesado
                    foreach($files as $file)
                    {
                        // Divides en dos el nombre de tu archivo utilizando el . 
                        $data = explode(".", $file);
    
                        // Nombre del archivo
                        $fileName = $data[0];
    
                        // Extensión del archivo 
                        $fileExtension = $data[1];
    
                        if($dni == $fileName)
                            $cambiorepetido++;
                    }
    
                    // Genero el archivo json siempre y cuando el archivo no esté repetido
                    if($cambiorepetido==0)
                    {
                        // Primer apellido
                        $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                        // Segundo apellido
                        $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                        // Primer nombre
                        $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                        // Segundo nombre
                        $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                        // Sueldo básico
                        $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                        // Código del trabajador
                        $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                        // Correo electrónico
                        $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                        // Teléfono
                        $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                        // Número de cuenta
                        $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
    
                        // Tipo de documento
                        $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                        // Banco
                        $vsqlbanco = "SELECT b.descripcion AS banco
                                        FROM periodoterceros p
                                             INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                       WHERE p.terid = ".$terid;
                        $banco = $clase->SeleccionarUno($vsqlbanco);
                        $banco = trim(str_replace("BANCO ","",$banco));
    
                        // cargo del empleado
                        $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
    
                        $sueldoper = 0;                     $auxtransp = 0;                 $embargo = 0;
                        $salud = 0;                         $pension = 0;                   $devengados = 0;
                        $descuentos = 0;
    
                        // Obtengo la fecha de ingreso del empleado
                        $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');

                        $fechaEntera = strtotime($fecingreso);
                        $mesfecingreso = date("m", $fechaEntera);
                        $yeaarfecingreso = date("Y", $fechaEntera);

                        if(($mesfecingreso > $mesperiodo2) && (intval($yearperiodo) == intval($yeaarfecingreso)))
                        {
                            // fechas de ingreso y retiro
                            $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                            $idhistorico = $clase->SeleccionarUno($vsql18);

                            $vsql21 = "SELECT hc.fecingreso 
                                         FROM histcontrato hc 
                                        WHERE hc.terid = ".$terid." 
                                              AND hc.id = ".$idhistorico;
                            $fecingreso = $clase->SeleccionarUno($vsql21);

                            if($fecingreso == "")
                                $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
                        }                        
    
                        $numincap = 0;                      $numlicencias = 0;                      $numlibranzas = 0;
                        $numlibranzasliq = 0;               $numsanciones = 0;                      $numotrasded = 0;
                        $numotrasdedliq = 0;

                        // Incapacidades del periodo
                        $vsqlincapacidad = "SELECT COUNT(*) AS numincap
                                              FROM detalleliquidacion 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                  AND terid = ".$terid."
                                                  AND conceptoid IN (10,43,40)";
                        $numincap = $clase->SeleccionarUno($vsqlincapacidad);

                        // Embargo
                        $vsqlembliq = "SELECT IFNULL(SUM(descuentos),0) AS embliq
                                         FROM detalleliquidacion
                                        WHERE terid = ".$terid."
                                              AND conceptoid = 30
                                              AND pernominaid IN ($listaperiodos)";
                        $embargo = $clase->SeleccionarUno($vsqlembliq);
    
                        // Vacaciones
                        $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'vacaciones'";
                        $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                        // Vacaciones pagadas en quincenas
                        $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2 
                                                 FROM hisdetallenomina 
                                                WHERE terid = ".$terid."
                                                      AND conceptoid = 38 
                                                      AND pernominaid IN ($listaperiodos)";
                        $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                        $numvacacionest = $numvacaciones1 + $numvacaciones2;
    
                        // Primas
                        $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $numprimas = $clase->SeleccionarUno($vsqlnumprimas);
    
                        // Cesantías
                        $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                               FROM liquidacion
                                              WHERE terid = ".$terid." 
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);
    
                        // Indemnización
                        $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                                FROM liquidacion
                                               WHERE terid = ".$terid." 
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);                
    
                        $numotrosdevenliq = 0;
                        $numotrosdeven = 0;
    
                        // Dotaciones 
                        $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                             FROM dotaciones
                                            WHERE periodonomina = '".$codperiodo."'
                                                  AND terid = ".$terid."";
                        $montodotacion = $clase->SeleccionarUno($vsqldotaciones);
    
                        // Genero el código consecutivo de nómina electrónica
                        $consecutivone = $clase->BDLockup($segundaquinper,'periodosnomina','periodoid','consecutivone');
    
                        // Valido si es el primero o el siguiente
                        if($consecutivone=="")
                        {
                            $newper = substr($codperiodo,0,2).substr($codperiodo,-2);
                            $newcod = $newper."00001";
                            $newconsecutivo = "NE".$newcod;
                        }
                        else
                        {
                            // Incremento el consecutivo
                            $numconsn = intval(substr($consecutivone,-5));
                            $numconsn++;
                            $newcod = strval($numconsn);
    
                            // Relleno con ceros
                            if(strlen($newcod)==1)      $newcod = "0000".$newcod;
                            if(strlen($newcod)==2)      $newcod = "000".$newcod;
                            if(strlen($newcod)==3)      $newcod = "00".$newcod;
                            if(strlen($newcod)==4)      $newcod = "0".$newcod;
                            
                            $newper = substr($codperiodo,0,2).substr($codperiodo,-2);
                            $newcod = $newper.$newcod;
    
                            // Construyo el nuevo consecutivo
                            $newconsecutivo = "NE".$newcod;
                        }
    
                        // Almacenos en la tabla el nuevo consecutivo
                        $vsqlactcons = "UPDATE periodosnomina SET 
                                               consecutivone = '".$newconsecutivo."'
                                         WHERE periodoid = ".$segundaquinper;
                        $clase->EjecutarSQL($vsqlactcons);
    
                        $prefijo = substr($newconsecutivo,0,2);
    
                        // ------------------------------------------------------------------------------------------------------------------------------------------------------- //
                        // Construyo el json con los datos del empleado
                        $json='{'.Chr(13).Chr(10);
                        $json.= Chr(9).'"idEmpresa": "1536",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"token": "'.str_pad($token,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"tipoDocumento": "1",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"almacenamiento": "1",'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"listaFechaPago": ['.Chr(13).Chr(10);
                        $json.= Chr(9).'  "'.str_pad($fecinicio,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "'.str_pad($fecfinal,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'],'.Chr(13).Chr(10);
                        
                        $json.= Chr(9).'"periodo": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaIngreso": "'.str_pad($fecingreso,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaLiquidacionInicio": "'.str_pad($fecinicio,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaLiquidacionFin": "'.str_pad($fecfinal,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tiempoLaborado": "'.str_pad($diastrab,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaGen": "'.str_pad($fechaAct,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"numeroSecuenciaXML": {'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "prefijo": "'.str_pad($prefijo,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "consecutivo": "'.str_pad($newcod,1,"").'"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"lugarGeneracionXML": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "pais": "CO",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "departamentoEstado": "54",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "municipioCiudad": "54001",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "idioma": "es"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"informacionGeneral": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "fechaGen": "'.str_pad($fechaAct,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "horaGen": "'.str_pad($horaAct,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "periodoNomina": "5",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "tipoMoneda": "COP",'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "trm": ""'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tipoMoneda": "COP"'.Chr(13).Chr(10);
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"trabajador": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "subTipoTrabajador": "00",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "altoRiesgoPension": "true",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tipoDocumento": "13",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "numeroDocumento": "'.str_pad($dni,1,"").'",'.Chr(13).Chr(10);
                        if($primerapellido!="")      $json.= Chr(9).'  "primerApellido": "'.str_pad($primerapellido,1,"").'",'.Chr(13).Chr(10);
                        if($segundoapellido!="")     $json.= Chr(9).'  "segundoApellido": "'.str_pad($segundoapellido,1,"").'",'.Chr(13).Chr(10);
                        if($primernombre!="")        $json.= Chr(9).'  "primerNombre": "'.str_pad($primernombre,1,"").'",'.Chr(13).Chr(10);
                        if(trim($segundonombre)!="") $json.= Chr(9).'  "otrosNombres": "'.str_pad($segundonombre,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoPais": "CO",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoDepartamentoEstado": "54",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoMunicipioCiudad": "54001",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "lugarTrabajoDireccion": "AVENIDA 7A # 0BN38 BARRIO SEVILLA",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "salarioIntegral": "false",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "tipoContrato": "1",'.Chr(13).Chr(10);
                        $json.= Chr(9).'  "sueldo": "'.str_pad($basico,1,"").'"'.Chr(13).Chr(10);
                        // $json.= Chr(9).'  "codigoTrabajador": "'.str_pad($codvende,1,"").'"'.Chr(13).Chr(10);
                        
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
        
                        // valido que el número de cuenta esté vacío
                        $json.= Chr(9).'"pago": {'.Chr(13).Chr(10);
                        if($numcuenta!="")
                        {
                            $json.= Chr(9).'  "forma": "1",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "metodo": "45",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "banco": "'.str_pad($banco,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "tipoCuenta": "AHORROS",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "numeroCuenta": "'.str_pad($numcuenta,1,"").'"'.Chr(13).Chr(10);
                        }
                        else
                        {                        
                            $json.= Chr(9).'  "forma": "1",'.Chr(13).Chr(10);
                            $json.= Chr(9).'  "metodo": "10"'.Chr(13).Chr(10);
                        }
                        
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
                        $json.= Chr(9).'"devengados": {'.Chr(13).Chr(10);
    
                        // dotaciones
                        if($montodotacion>0)
                        {
                            $json.= Chr(9).'   "dotacion": "'.str_pad($montodotacion,1,"").'",'.Chr(13).Chr(10);
                            $devengados += $montodotacion;
                        }
    
                        if($numindemnizacion>0)
                        {
                            // Pago por la indemnización
                            $vsqlindemnizacion = "SELECT pago AS pagoindemnizacion
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'indemnizacion'";
                            $pagoindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                            // Imprimo la indemnización
                            $json.= Chr(9).'  "indemnizacion": "'.str_pad($pagoindemnizacion,1,"").'",'.Chr(13).Chr(10);
    
                            // Incremento del devengado
                            $devengados += $pagoindemnizacion;
                        }
    
                        $json.= Chr(9).'  "basico": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'     "diasTrabajados": "'.str_pad($diastrab,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'     "sueldoTrabajado": "'.str_pad($sueldoper,1,"").'"'.Chr(13).Chr(10);
    
                        if(($auxtransp>0)||($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numlicencias>0)||($numotrosdeven>0)||($numpagocesan>0))
                            $json.= Chr(9).'  },'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'  }'.Chr(13).Chr(10);                    
                        
                        if($auxtransp>0)
                        {
                            $json.= Chr(9).'  "transporte": ['.Chr(13).Chr(10);
                            $json.= Chr(9).'     {'.Chr(13).Chr(10);
                            $json.= Chr(9).'       "auxilioTransporte": "'.str_pad($auxtransp,1,"").'"'.Chr(13).Chr(10);
                            $json.= Chr(9).'     }'.Chr(13).Chr(10);
    
                            if(($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numlicencias>0)||($numotrosdeven>0)||($numpagocesan>0))
                                $json.= Chr(9).'  ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'  ]'.Chr(13).Chr(10);
                        }
    
                        // primas de periodo
                        if($numprimas>0)
                        {
                            $json.= Chr(9).'"  primas": {'.Chr(13).Chr(10);
    
                            // Días de la prima
                            $vsqlcanprimas = "SELECT cantidad AS canprimas
                                                FROM liquidacion
                                               WHERE terid = ".$terid." 
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'primas'";
                            $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                            // Pago de la prima
                            $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                                 FROM liquidacion
                                                WHERE terid = ".$terid." 
                                                      AND periodonomina = '".$codperiodo."' 
                                                      AND tipo = 'primas'";
                            $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);
    
                            $json.= Chr(9).'     "cantidad": "'.str_pad($canprimas,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'     "pago": "'.str_pad($pagoprimas,1,"").'"'.Chr(13).Chr(10);
    
                            if(($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numlicencias>0)||($numotrosdeven>0)||($numpagocesan>0))
                                $json.= Chr(9).'   },'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                            // Incremento el total devengado
                            $devengados += $pagoprimas;
                        }
    
                        // Cesantías del empleado
                        if($numcesantias>0)
                        {       
                            // Pago de la cesantía
                            $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid." 
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);
    
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid." 
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia += $montopagocesan;
                            }
    
                            // Porcentaje cesantía
                            $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid." 
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);
    
                            // Pago de intereses de cesantías
                            $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid." 
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'cesantias'";
                            $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);
                            
                            $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "pago": "'.str_pad($pagocesantia,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "porcentaje": "'.str_pad(number_format($porccesantia,2),1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "pagoIntereses": "'.str_pad($pagointereses,1,"").'"'.Chr(13).Chr(10);    
                               
                            if(($numvacacionest>0)||($numincap>0)||($numlicencias>0)||($numotrosdeven>0))
                                $json.= Chr(9).'   },'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                            // Incremento el total devengado
                            $devengados += $pagocesantia;
                            $devengados += $pagointereses;
                        }
                        else
                        {
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid." 
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia = $montopagocesan;
    
                                $porccesantia = 0;
                                $pagointereses = 0;
    
                                $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                                $json.= Chr(9).'      "pago": "'.str_pad($pagocesantia,1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'      "porcentaje": "'.str_pad(number_format($porccesantia,2),1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'      "pagoIntereses": "'.str_pad($pagointereses,1,"").'"'.Chr(13).Chr(10);
    
                                if(($numvacacionest>0)||($numincap>0)||($numlicencias>0)||($numotrosdeven>0))
                                    $json.= Chr(9).'   },'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                                // Incremento el total devengado
                                $devengados += $pagocesantia;
                            }
                        }
    
                        // Vacaciones del empleado
                        if($numvacacionest>0)
                        {
                            $json.= Chr(9).'      "listaVacaciones": ['.Chr(13).Chr(10); 
                            $json.= Chr(9).'         {'.Chr(13).Chr(10);
    
                            if($numvacaciones1 > 0)
                            {
                                // Días de vacaciones
                                $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                        FROM liquidacion
                                                       WHERE terid = ".$terid."
                                                             AND periodonomina = '".$codperiodo."' 
                                                             AND tipo = 'vacaciones'";
                                $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                                // Pago de vacaciones
                                $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid." 
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'vacaciones'";
                                $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                            }
                            else
                            {
                                $canvacaciones = 0;
                                $pagovaca1 = 0;
                            }

                            if($numvacaciones2>0)
                            {
                                $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                    FROM hisdetallenomina  
                                                   WHERE terid = ".$terid."
                                                         AND conceptoid = 38 
                                                         AND pernominaid IN ($listaperiodos)";
                                $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                            }
                            else
                                $pagovaca2 = 0;
                            
                            if($canvacaciones == 0)               $canvacaciones = 1;
                            $pagovaca = $pagovaca1 + $pagovaca2;
    
                            $json.= Chr(9).'            "cantidad": "'.str_pad($canvacaciones,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "pago": "'.str_pad($pagovaca,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'            "tipoVacacion": "1"'.Chr(13).Chr(10);
                            $json.= Chr(9).'         }'.Chr(13).Chr(10);
    
                            if(($numincap>0)||($numlicencias>0)||($numotrosdeven>0))
                                $json.= Chr(9).'],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).']'.Chr(13).Chr(10);
    
                            // Incremento el total devengado
                            $devengados += $pagovaca1;
                        }
    
                        // Incluyo las incapacidades
                        if($numincap>0)
                        {
                            $json.= Chr(9).'      "listaIncapacidades": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql5 = "SELECT valor, devengados
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND conceptoid IN (10,40)
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result5 = mysql_query($vsql5,$conex);
                            while($row5 = mysql_fetch_array($result5))
                            {
                                $feciniincap = $fecinicio;
                                $diasincap = $row5['valor'];
                                $fecfinincap = date("Y-m-d",strtotime($feciniincap."+ $diasincap days"));
    
                                $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "cantidad": "'.str_pad($row5['valor'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "tipo": "3",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "pago": "'.str_pad($row5['devengados'],1,"").'"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numincap)
                                    $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'         },'.Chr(13).Chr(10);
                            }
    
                            if(($numlicencias>0)||($numotrosdeven>0))
                                $json.= Chr(9).'      ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                        }
    
                        // Incluyo las licencias
                        if($numlicencias>0)
                        {
                            $json.= Chr(9).'      "listaLicencias": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql3 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND c.eslicencia = 'CHECKED' 
                                             AND c.tipodc = 'C' 
                                             AND h.conceptoid NOT IN (10,9,40) 
                                             AND h.terid = ".$terid." 
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result3 = mysql_query($vsql3,$conex);
    
                            while($row3 = mysql_fetch_array($result3))
                            {
                                $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "cantidad": "'.str_pad($row3['valor'],1,"").'",'.Chr(13).Chr(10);
    
                                if($row3['tipodc']=="C")
                                    $json.= Chr(9).'            "pago": "'.str_pad($row3['devengados'],1,"").'",'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'            "pago": "'.str_pad($row3['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                
                                // Licencias de maternidad o paternidad
                                if(($row3['conceptoid']==11)||($row3['conceptoid']==12))
                                    $json.= Chr(9).'            "tipoLicencia": "1"'.Chr(13).Chr(10);
    
                                // Licencias remunerada
                                if(($row3['conceptoid']==10)||($row3['conceptoid']==13)||($row3['conceptoid']==23)||($row3['conceptoid']==31)||($row3['conceptoid']==40)||($row3['conceptoid']==46))
                                    $json.= Chr(9).'            "tipoLicencia": "2"'.Chr(13).Chr(10);
                                
                                // Licencias no remunerada
                                if(($row3['conceptoid']==6)||($row3['conceptoid']==9)||($row3['conceptoid']==43)||($row3['conceptoid']==58))
                                    $json.= Chr(9).'            "tipoLicencia": "3"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numlicencias)
                                    $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'         },'.Chr(13).Chr(10);
                            }
    
                            if($numotrosdeven>0)
                                $json.= Chr(9).'      ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                        }
    
                        // Otros conceptos devengados
                        if($numotrosdeven>0)
                        {
                            $json.= Chr(9).'      "listaOtrosConceptos": ['.Chr(13).Chr(10);                        
                            $i = 0;
    
                            // Consulta con los datos que se incluirán en el json
                            $vsql12 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid IN (37,48) 
                                              AND h.terid = ".$terid." 
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid." 
                                                                               AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                               AND periodoterceros.extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result12 = mysql_query($vsql12,$conex);
    
                            while($row12 = mysql_fetch_array($result12))
                            {
                                $json.= Chr(9).'         {'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "descripcionConcepto": "'.str_pad($row12['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "pago": "'.str_pad($row12['devengados'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'            "tipoConcepto": "1"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numotrosdeven)
                                    $json.= Chr(9).'         }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'         },'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                        }
    
                        $json.= Chr(9).'      },'.Chr(13).Chr(10);
    
                        $json.= Chr(9).'"deducciones": {'.Chr(13).Chr(10);
                        if($embargo>0)      $json.= Chr(9).'   "embargoFiscal": "'.str_pad($embargo,1,"").'",'.Chr(13).Chr(10);
    
                        // otras deducciones
                        if(($numotrasded>0)&&($numotrasdedliq>0))
                        {
                            $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
                            
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                             AND h.terid = ".$terid." 
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
    
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                            }
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                              AND h.terid = ".$terid;
    
                            $conex  = $clase->Conectar();
                            $result77 = mysql_query($vsql77,$conex);
    
                            while($row77 = mysql_fetch_array($result77))
                            {
                                $i++;
                                if($i==$numotrasdedliq)
                                    $json.= Chr(9).'      "'.str_pad($row77['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      "'.str_pad($row77['descuentos'],1,"").'",'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                        }
    
                        if(($numotrasded==0)&&($numotrasdedliq>0))
                        {
                            $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                             AND h.terid = ".$terid;
    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
    
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $i++;
                                if($i==$numotrasdedliq)
                                    $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                        }
    
                        if(($numotrasded>0)&&($numotrasdedliq==0))
                        {
                            $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                             AND h.terid = ".$terid." 
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
    
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $i++;
                                if($i==$numotrasded)
                                    $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      "'.str_pad($row7['descuentos'],1,"").'",'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                        }
    
                        // Descuento por concepto de salud
                        $json.= Chr(9).'   "salud": {'.Chr(13).Chr(10);
                        if($salud>0)
                        {
                            $json.= Chr(9).'      "porcentaje": "'.str_pad($por_sal_tra,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "'.str_pad($salud,1,"").'"'.Chr(13).Chr(10);
                        }
                        else
                        {                        
                            $json.= Chr(9).'      "porcentaje": "0",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "0"'.Chr(13).Chr(10);
                        }
                        $json.= Chr(9).'   },'.Chr(13).Chr(10);
    
                        // Descuento por concepto de pensión
                        $json.= Chr(9).'   "fondoPension": {'.Chr(13).Chr(10);
                        if($pension>0)
                        {
                            $json.= Chr(9).'      "porcentaje": "'.str_pad($por_pen_tra,1,"").'",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "'.str_pad($pension,1,"").'"'.Chr(13).Chr(10);
                        }
                        else
                        {                        
                            $json.= Chr(9).'      "porcentaje": "0",'.Chr(13).Chr(10);
                            $json.= Chr(9).'      "deduccion": "0"'.Chr(13).Chr(10);
                        }
    
                        if(($numsanciones>0)||($numlibranzas>0)||($numlibranzasliq>0))
                            $json.= Chr(9).'   },'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'   }'.Chr(13).Chr(10);
    
                        // Incluyo las sanciones
                        if($numsanciones>0)
                        {
                            $json.= Chr(9).'   "listaSanciones": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql6 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid = 9
                                             AND h.terid = ".$terid." 
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result6 = mysql_query($vsql6,$conex);
    
                            while($row6 = mysql_fetch_array($result6))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "valorSancion": "'.str_pad($row6['descuentos'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "tipoSancion": "2"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numsanciones)
                                    $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
                            
                            if(($numlibranzas>0)||($numlibranzasliq>0))
                                $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                            else
                                $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        }
    
                        // libranzas
                        if(($numlibranzas>0)&&($numlibranzasliq>0))
                        {                                
                            $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
                            
                            // Consulta con los datos que se incluirán en el json
                            $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                             AND h.terid = ".$terid."
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result4 = mysql_query($vsql4,$conex);
    
                            while($row4 = mysql_fetch_array($result4))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
                                $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql44 = "SELECT c.nomconcepto, h.descuentos  
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                              AND h.terid = ".$terid." 
                                              AND c.conceptoid NOT IN (10,30)
                                              AND h.pernominaid IN ($listaperiodos)";
    
                            $conex  = $clase->Conectar();
                            $result44 = mysql_query($vsql44,$conex);
    
                            while($row44 = mysql_fetch_array($result44))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "descripcion": "'.str_pad($row44['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "deduccion": "'.str_pad($row44['descuentos'],1,"").'"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numlibranzasliq)
                                    $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        }
                        
                        if(($numlibranzas==0)&&($numlibranzasliq>0))
                        {                                
                            $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
    
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                             AND h.terid = ".$terid." 
                                             AND c.conceptoid NOT IN (10,30)";
                            $conex  = $clase->Conectar();
                            $result4 = mysql_query($vsql4,$conex);
    
                            while($row4 = mysql_fetch_array($result4))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numlibranzasliq)
                                    $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        }
    
                        if(($numlibranzas>0)&&($numlibranzasliq==0))
                        {
                            $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);
        
                            $i = 0;
                            // Consulta con los datos que se incluirán en el json
                            $vsql4 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                             AND h.terid = ".$terid."
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result4 = mysql_query($vsql4,$conex);
    
                            while($row4 = mysql_fetch_array($result4))
                            {
                                $json.= Chr(9).'      {'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "descripcion": "'.str_pad($row4['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                                $json.= Chr(9).'         "deduccion": "'.str_pad($row4['descuentos'],1,"").'"'.Chr(13).Chr(10);
    
                                $i++;
                                if($i==$numlibranzas)
                                    $json.= Chr(9).'      }'.Chr(13).Chr(10);
                                else
                                    $json.= Chr(9).'      },'.Chr(13).Chr(10);
                            }
                            $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                        }
    
                        $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                        if(($numvacacionest>0)||($numprimas>0)||($numcesantias>0)||($numindemnizacion>0)||($numotrosdeven>0)||($montodotacion>0)||($numpagocesan>0))
                            $neto = $devengados - $descuentos;
    
                        $json.= Chr(9).'"devengadosTotal": "'.str_pad($devengados,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"deduccionesTotal": "'.str_pad($descuentos,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'"comprobanteTotal": "'.str_pad($neto,1,"").'"'.Chr(13).Chr(10);
    
                        $json.='}'.Chr(13).Chr(10);                    
    
                        // ----------------------------------------------------------------------------------------------------- //
                        // Grabo en el archivo correspondiente la información de empleado
                        $archivo = trim($dni).".json";  //  nombre del archivo
                        $fd = fopen ($carpetaactual."/".$archivo, "w"); // se abre el archivo para escribir
                        fwrite($fd, $json); // Grabas
                        fclose($fd); // Cierras el archivo
                        $listadereportados.= $terid.",";
                    }
                }
            }
            $listadereportados = substr($listadereportados, 0, -1);
        }

        // ------------------------------------------------------------------------------------------------------- //
        // ciclo de los empleados con una quincena como extra legal y una liquidación
        $vsqlliquidacionsolo = "SELECT DISTINCT terid 
                                  FROM liquidacion 
                                 WHERE periodonomina = '".$codperiodo."'  
                                       AND terid IN (SELECT terid 
                                                       FROM periodoterceros 
                                                      WHERE pernominaid = ".$primquin." 
                                                            AND extralegal = 'CHECKED')
                                       AND terid IN (SELECT terid 
                                                       FROM detalleliquidacion 
                                                      WHERE pernominaid = ".$segnquin.")";

        if(strlen($listadereportados)>0)
            $vsqlliquidacionsolo.= " AND terid NOT IN ($listadereportados) ";

        if(strlen($nodebensalir) > 0)
            $vsqlliquidacionsolo.= " AND terid NOT IN ($nodebensalir) "; 

        $conex  = $clase->Conectar();
        $resultliquidacionsolo = mysql_query($vsqlliquidacionsolo,$conex);
        $empleadosliquidacionsolo = mysql_num_rows($resultliquidacionsolo);

        // $empleadosliquidacionsolo = 0;        

        if($empleadosliquidacionsolo > 0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";                            $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $listadereportados.= ",";                       $vsqlvextralegal = "";
            $numnomext = 0;                                 $vsqlnumvacaciones2 = "";                       $numvacaciones2 = 0;
            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;                                 $descuentos = 0;
            $devengadosdetalleliquidacion = 0;              $numlicencias = 0;                              $numlibranzas = 0;
            $numlibranzasliq = 0;                           $numsanciones = 0;                              $numotrasded = 0;
            $numotrasdedliq = 0;                            $diasrecnoc = 0;                                $montorecargonoc = 0;
            $sueldoper = 0;                                 $auxtransp = 0;                                 $embargo = 0;
            $salud = 0;                                     $pension = 0;                                   $devengados = 0;
            $cantidadrn = 0;                                $valordetalleliquidacion = 0;                   $pagorn = 0;            
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;            

            while($rowliqsolo = mysql_fetch_array($resultliquidacionsolo))
            {
                // id del empleado
                $terid = $rowliqsolo['terid'];

                // Documento del empleado
                $dni = $clase->BDLockup($terid,'terceros','terid','dni');

                // Primer apellido
                $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');

                // Segundo apellido
                $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');

                // Primer nombre
                $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');

                // Segundo nombre
                $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');

                // Sueldo básico
                $basico = $clase->BDLockup($terid,'terceros','terid','basico');

                // Código del trabajador
                $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');

                // Correo electrónico
                $email = $clase->BDLockup($terid,'terceros','terid','email');

                // Teléfono
                $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');

                // Número de cuenta
                $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');

                // Tipo de documento
                $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');

                // Banco
                $vsqlbanco = "SELECT b.descripcion AS banco
                                FROM periodoterceros p
                                     INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                               WHERE p.terid = ".$terid;
                $banco = $clase->SeleccionarUno($vsqlbanco);
                $banco = trim(str_replace("BANCO ","",$banco));

                // cargo del empleado
                $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');

                // Obtengo la fecha de ingreso del empleado
                $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
                
                $fechaEntera = strtotime($fecingreso);
                $mesfecingreso = date("m", $fechaEntera);
                $yeaarfecingreso = date("Y", $fechaEntera);

                if(($mesfecingreso > $mesperiodo2) && (intval($yearperiodo) == intval($yeaarfecingreso)))
                {
                    // fechas de ingreso y retiro
                    $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                    $idhistorico = $clase->SeleccionarUno($vsql18);

                    $vsql21 = "SELECT hc.fecingreso 
                                 FROM histcontrato hc 
                                WHERE hc.terid = ".$terid." 
                                      AND hc.id = ".$idhistorico;
                    $fecingreso = $clase->SeleccionarUno($vsql21);

                    if($fecingreso == "")
                        $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
                }                

                // ------------------------------------------------------------------------------------------------------------------------------------------ //
                // Días trabajados en la liquidación
                $vsqldiasliq = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrabliq 
                                  FROM detalleliquidacion 
                                 WHERE pernominaid = ".$segnquin."  
                                       AND terid = ".$terid." 
                                       AND conceptoid = 1";
                $diastrab = $clase->SeleccionarUno($vsqldiasliq);

                // sueldo del periodo
                $vsqlsueldoliq = "SELECT devengados AS sueldoliq
                                    FROM detalleliquidacion
                                   WHERE terid = ".$terid."
                                         AND conceptoid = 1
                                         AND pernominaid = ".$segnquin;
                $sueldoper = $clase->SeleccionarUno($vsqlsueldoliq);

                // Auxilio de transporte     
                $vsqltransliq = "SELECT devengados AS transliq
                                   FROM detalleliquidacion
                                  WHERE terid = ".$terid."
                                        AND conceptoid = 3
                                        AND pernominaid = ".$segnquin;
                $auxtransp = $clase->SeleccionarUno($vsqltransliq);

                // Recargo nocturno
                $vsqlrecargonocliq = "SELECT devengados AS recargonocliq
                                        FROM detalleliquidacion
                                       WHERE terid = ".$terid."
                                             AND conceptoid IN (47,56,59) 
                                             AND pernominaid = ".$segnquin;
                $$recargonoc = $clase->SeleccionarUno($vsqlrecargonocliq);

                // hora extra diurna
                $horaextradiurnaliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 49,devengados,0)) AS horaextradiurnaliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // hora extra nocturna
                $horaextranocturnaliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 50,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // hora extra diurna dominical
                $horaextradiurnadomliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 51,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // hora extra nocturna dominical y festivo
                $horaextradnocturnadomfesliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 52,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // domingos y festivos
                $domingosyfestivosliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 53,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // recargo nocturno dominical y festivo
                $recargonocdomfesliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 54,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // total de recargos
                $numrecargos = $recargonoc + $horaextradiurnaliq + $horaextranocturnaliq + $horaextradiurnadomliq + $horaextradnocturnadomfesliq + $domingosyfestivosliq + $recargonocdomfesliq;                

                // Salud
                $vsqlsaludliq = "SELECT descuentos AS saludliq
                                   FROM detalleliquidacion
                                  WHERE terid = ".$terid."
                                        AND conceptoid = 5
                                        AND pernominaid = ".$segnquin;
                $salud = $clase->SeleccionarUno($vsqlsaludliq);

                // Pensión  
                $vsqlpesionliq = "SELECT descuentos AS pesionliq
                                    FROM detalleliquidacion
                                   WHERE terid = ".$terid."
                                         AND conceptoid = 4
                                         AND pernominaid = ".$segnquin;
                $pension = $clase->SeleccionarUno($vsqlpesionliq);

                // total devengado
                $vsqldevliq = "SELECT SUM(IF(pernominaid = ".$segnquin." ,devengados,0)) AS devengados 
                                 FROM detalleliquidacion 
                                WHERE terid = ".$terid;
                $devengados = $clase->SeleccionarUno($vsqldevliq);

                // total descuentos
                $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                  FROM detalleliquidacion 
                                 WHERE pernominaid = ".$segnquin."  
                                       AND terid = ".$terid."";
                $descuentos = $clase->SeleccionarUno($vsqldescliq);

                // Incapacidades del periodo
                $vsqlincapacidad2 = "SELECT COUNT(*) AS numincap
                                       FROM detalleliquidacion 
                                      WHERE pernominaid = ".$segnquin."  
                                            AND terid = ".$terid."
                                            AND conceptoid IN (10,43,40)";
                $numincap = $clase->SeleccionarUno($vsqlincapacidad2);

                // Licencias del periodo
                $vsqlincapacidad2 = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                       FROM detalleliquidacion h
                                            INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                      WHERE h.pernominaid = ".$segnquin." 
                                            AND c.eslicencia = 'CHECKED' 
                                            AND c.tipodc = 'C' 
                                            AND h.conceptoid NOT IN (10,9,43,40,58) 
                                            AND h.terid = ".$terid;
                $numlicencias = $clase->SeleccionarUno($vsqlincapacidad2);

                // licencias
                $vsqllicnoremuneradas2 = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND c.eslicencia = 'CHECKED' 
                                                 AND c.tipodc = 'C' 
                                                 AND h.conceptoid NOT IN (10,9,43,40,58) 
                                                 AND h.terid = ".$terid;
                $numlicencias = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                // Libranzas del periodo
                $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                       FROM detalleliquidacion h
                                            INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                      WHERE h.pernominaid = ".$segnquin." 
                                            AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED') 
                                            AND h.terid = ".$terid."
                                            AND c.conceptoid NOT IN (10,30)";
                $numlibranzas = $clase->SeleccionarUno($vsqllibranzasliq);

                // Sanciones del periodo
                $vsqlsanciones = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid = ".$segnquin." 
                                         AND h.conceptoid = 9
                                         AND h.terid = ".$terid;
                $numsanciones = $clase->SeleccionarUno($vsqlsanciones);                

                // otras deducciones en liquidación
                $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid = ".$segnquin." 
                                             AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                             AND h.terid = ".$terid;
                $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);

                // Otros conceptos devengados
                $vsqlotrosdevenliq = "SELECT COUNT(h.conceptoid) AS numotrosdevenliq
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid = ".$segnquin." 
                                             AND h.conceptoid IN (37,48) 
                                             AND h.terid = ".$terid;
                $numotrosdevenliq = $clase->SeleccionarUno($vsqlotrosdevenliq);
                // ------------------------------------------------------------------------------------------------------------------------------------------ //
                // Embargo
                $vsqlembliq = "SELECT IFNULL(SUM(descuentos),0)  AS embliq
                                 FROM detalleliquidacion
                                WHERE terid = ".$terid."
                                      AND conceptoid = 30
                                      AND pernominaid = ".$segnquin;
                $embargo = $clase->SeleccionarUno($vsqlembliq);

                // Vacaciones
                $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                        FROM liquidacion
                                       WHERE terid = ".$terid."
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'vacaciones'";
                $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                // Vacaciones pagadas en quincenas
                $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2
                                         FROM detalleliquidacion 
                                        WHERE terid = ".$terid."
                                              AND conceptoid = 38 
                                              AND pernominaid = ".$segnquin;
                $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                $numvacacionest = $numvacaciones1 + $numvacaciones2;

                // Primas
                $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                    FROM liquidacion
                                   WHERE terid = ".$terid."
                                         AND periodonomina = '".$codperiodo."' 
                                         AND tipo = 'primas'";
                $numprimas = $clase->SeleccionarUno($vsqlnumprimas);

                // Cesantías
                $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                       FROM liquidacion
                                      WHERE terid = ".$terid."
                                            AND periodonomina = '".$codperiodo."' 
                                            AND tipo = 'cesantias'";
                $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);

                // Indemnización
                $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                        FROM liquidacion
                                       WHERE terid = ".$terid."
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'indemnizacion'";
                $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);

                // $numotrosdevenliq = 0;
                $numotrosdeven = 0;

                // Dotaciones 
                $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                     FROM dotaciones
                                    WHERE periodonomina = '".$codperiodo."'
                                          AND terid = ".$terid."";
                $montodotacion = $clase->SeleccionarUno($vsqldotaciones);

                // Genero el código consecutivo de nómina electrónica
                $consecutivone = $clase->BDLockup($segundaquinper,'periodosnomina','periodoid','consecutivone');

                // Valido si es el primero o el siguiente
                if($consecutivone=="")
                {
                    $newper = substr($codperiodo,0,2).substr($codperiodo,-2);
                    $newcod = $newper."00001";
                    $newconsecutivo = "NE".$newcod;
                }
                else
                {
                    // Incremento el consecutivo
                    $numconsn = intval(substr($consecutivone,-5));
                    $numconsn++;
                    $newcod = strval($numconsn);

                    // Relleno con ceros
                    if(strlen($newcod)==1)      $newcod = "0000".$newcod;
                    if(strlen($newcod)==2)      $newcod = "000".$newcod;
                    if(strlen($newcod)==3)      $newcod = "00".$newcod;
                    if(strlen($newcod)==4)      $newcod = "0".$newcod;
                    
                    $newper = substr($codperiodo,0,2).substr($codperiodo,-2);
                    $newcod = $newper.$newcod;

                    // Construyo el nuevo consecutivo
                    $newconsecutivo = "NE".$newcod;
                }

                // Almacenos en la tabla el nuevo consecutivo
                $vsqlactcons = "UPDATE periodosnomina SET 
                                       consecutivone = '".$newconsecutivo."'
                                 WHERE periodoid = ".$segundaquinper;
                $clase->EjecutarSQL($vsqlactcons);

                $prefijo = substr($newconsecutivo,0,2);

                // Construyo el json con los datos del empleado
                $json='{'.Chr(13).Chr(10);
                $json.= Chr(9).'"idEmpresa": "1536",'.Chr(13).Chr(10);
                $json.= Chr(9).'"token": "'.str_pad($token,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'"tipoDocumento": "1",'.Chr(13).Chr(10);
                $json.= Chr(9).'"almacenamiento": "1",'.Chr(13).Chr(10);

                $json.= Chr(9).'"listaFechaPago": ['.Chr(13).Chr(10);
                $json.= Chr(9).'  "'.str_pad($fecinicio,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "'.str_pad($fecfinal,1,"").'"'.Chr(13).Chr(10);
                $json.= Chr(9).'],'.Chr(13).Chr(10);
                
                $json.= Chr(9).'"periodo": {'.Chr(13).Chr(10);
                $json.= Chr(9).'  "fechaIngreso": "'.str_pad($fecingreso,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "fechaLiquidacionInicio": "'.str_pad($fecinicio,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "fechaLiquidacionFin": "'.str_pad($fecfinal,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "tiempoLaborado": "'.str_pad($diastrab,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "fechaGen": "'.str_pad($fechaAct,1,"").'"'.Chr(13).Chr(10);
                $json.= Chr(9).'},'.Chr(13).Chr(10);

                $json.= Chr(9).'"numeroSecuenciaXML": {'.Chr(13).Chr(10);
                $json.= Chr(9).'  "consecutivo": "'.str_pad($newcod,1,"").'"'.Chr(13).Chr(10);
                $json.= Chr(9).'},'.Chr(13).Chr(10);

                $json.= Chr(9).'"lugarGeneracionXML": {'.Chr(13).Chr(10);
                $json.= Chr(9).'  "pais": "CO",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "departamentoEstado": "54",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "municipioCiudad": "54001",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "idioma": "es"'.Chr(13).Chr(10);
                $json.= Chr(9).'},'.Chr(13).Chr(10);

                $json.= Chr(9).'"informacionGeneral": {'.Chr(13).Chr(10);
                $json.= Chr(9).'  "fechaGen": "'.str_pad($fechaAct,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "horaGen": "'.str_pad($horaAct,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "periodoNomina": "5",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "tipoMoneda": "COP"'.Chr(13).Chr(10);
                $json.= Chr(9).'},'.Chr(13).Chr(10);

                $json.= Chr(9).'"trabajador": {'.Chr(13).Chr(10);
                $json.= Chr(9).'  "subTipoTrabajador": "00",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "altoRiesgoPension": "true",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "tipoDocumento": "13",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "numeroDocumento": "'.str_pad($dni,1,"").'",'.Chr(13).Chr(10);
                if($primerapellido!="")      $json.= Chr(9).'  "primerApellido": "'.str_pad($primerapellido,1,"").'",'.Chr(13).Chr(10);
                if($segundoapellido!="")     $json.= Chr(9).'  "segundoApellido": "'.str_pad($segundoapellido,1,"").'",'.Chr(13).Chr(10);
                if($primernombre!="")        $json.= Chr(9).'  "primerNombre": "'.str_pad($primernombre,1,"").'",'.Chr(13).Chr(10);
                if(trim($segundonombre)!="") $json.= Chr(9).'  "otrosNombres": "'.str_pad($segundonombre,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "lugarTrabajoPais": "CO",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "lugarTrabajoDepartamentoEstado": "54",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "lugarTrabajoMunicipioCiudad": "54001",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "lugarTrabajoDireccion": "AVENIDA 7A # 0BN38 BARRIO SEVILLA",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "salarioIntegral": "false",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "tipoContrato": "1",'.Chr(13).Chr(10);
                $json.= Chr(9).'  "sueldo": "'.str_pad($basico,1,"").'"'.Chr(13).Chr(10);
                
                $json.= Chr(9).'},'.Chr(13).Chr(10);

                // valido que el número de cuenta esté vacío
                $json.= Chr(9).'"pago": {'.Chr(13).Chr(10);
                if($numcuenta!="")
                {
                    $json.= Chr(9).'  "forma": "1",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "metodo": "45",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "banco": "'.str_pad($banco,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "tipoCuenta": "AHORROS",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "numeroCuenta": "'.str_pad($numcuenta,1,"").'"'.Chr(13).Chr(10);
                }
                else
                {                        
                    $json.= Chr(9).'  "forma": "1",'.Chr(13).Chr(10);
                    $json.= Chr(9).'  "metodo": "10"'.Chr(13).Chr(10);
                }
                
                $json.= Chr(9).'},'.Chr(13).Chr(10);
                $json.= Chr(9).'"devengados": {'.Chr(13).Chr(10);

                // dotaciones
                if($montodotacion>0)
                {
                    $json.= Chr(9).'   "dotacion": "'.str_pad($montodotacion,1,"").'",'.Chr(13).Chr(10);
                    $devengados += $montodotacion;
                }

                // Indemnización
                if ($numindemnizacion>0)
                {
                    // Pago por la indemnización
                    $vsqlindemnizacion = "SELECT pago AS pagoindemnizacion
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'indemnizacion'";
                    $pagoindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);

                    // Imprimo la indemnización
                    $json.= Chr(9).'  "indemnizacion": "'.str_pad($pagoindemnizacion,1,"").'",'.Chr(13).Chr(10);

                    // Incremento del devengado
                    $devengados += $pagoindemnizacion;
                }

                $json.= Chr(9).'  "basico": {'.Chr(13).Chr(10);
                $json.= Chr(9).'     "diasTrabajados": "'.str_pad($diastrab,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'     "sueldoTrabajado": "'.str_pad($sueldoper,1,"").'"'.Chr(13).Chr(10);

                if(($auxtransp>0)||($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numlicencias>0)||($numrecargos>0))
                    $json.= Chr(9).'  },'.Chr(13).Chr(10);
                else
                    $json.= Chr(9).'  }'.Chr(13).Chr(10);

                if($auxtransp>0)
                {
                    $json.= Chr(9).'  "transporte": ['.Chr(13).Chr(10);
                    $json.= Chr(9).'     {'.Chr(13).Chr(10);
                    $json.= Chr(9).'       "auxilioTransporte": "'.str_pad($auxtransp,1,"").'"'.Chr(13).Chr(10);
                    $json.= Chr(9).'     }'.Chr(13).Chr(10);

                    if(($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numlicencias>0)||($numrecargos>0))
                        $json.= Chr(9).'  ],'.Chr(13).Chr(10);
                    else
                        $json.= Chr(9).'  ]'.Chr(13).Chr(10);
                }

                // Recargo nocturno de la liquidación
                if($numrecargos > 0)
                {
                    $json.= Chr(9).'         }'.Chr(13).Chr(10);

                    $vsql30  = "SELECT SUM(valor) AS cantidad, 
                                       CASE
                                         WHEN conceptoid = 47 THEN '35.00'
                                         WHEN conceptoid = 49 THEN '25.00'
                                         WHEN conceptoid = 50 THEN '75'           
                                         WHEN conceptoid = 51 THEN '100' 
                                         WHEN conceptoid = 52 THEN '150'
                                         WHEN conceptoid = 53 THEN '80.00'         
                                         WHEN conceptoid = 54 THEN '110'
                                         WHEN conceptoid = 56 THEN '35.00'
                                       END porcentaje,
                                       SUM(devengados) AS pago,  
                                       CASE
                                         WHEN conceptoid = 47 THEN '3'
                                         WHEN conceptoid = 49 THEN '1'
                                         WHEN conceptoid = 50 THEN '2'           
                                         WHEN conceptoid = 51 THEN '4' 
                                         WHEN conceptoid = 52 THEN '6'
                                         WHEN conceptoid = 53 THEN '5'         
                                         WHEN conceptoid = 54 THEN '7'
                                         WHEN conceptoid = 56 THEN '3'
                                       END tipoHeR,
                                       CASE
                                         WHEN conceptoid = 47 THEN 'Hora Recargo Nocturno'
                                         WHEN conceptoid = 49 THEN 'Hora Extra Diurna'
                                         WHEN conceptoid = 50 THEN 'Hora Extra Nocturna'           
                                         WHEN conceptoid = 51 THEN 'Hora Extra Diurna Dominical y Festivos' 
                                         WHEN conceptoid = 52 THEN 'Hora Extra Nocturna Dominical y Festivos'
                                         WHEN conceptoid = 53 THEN 'Hora Recargo Diurno Dominical y Festivos' 
                                         WHEN conceptoid = 54 THEN 'Hora Recargo Nocturno Dominical y Festivos'
                                         WHEN conceptoid = 56 THEN 'Hora Recargo Nocturno'
                                       END descripcion 
                                  FROM detalleliquidacion 
                                 WHERE pernominaid IN ($listaperiodos) 
                                       AND conceptoid IN (47,49,50,51,52,53,54,56) 
                                       AND terid = ".$terid."
                              GROUP BY conceptoid";

                    $conex  = $clase->Conectar();
                    $result30 = mysql_query($vsql30,$conex);
                    $cant1 = mysql_num_rows($result30);             $cant2 = 0;
                    while($row30 = mysql_fetch_array($result30))
                    {                        
                        $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "cantidad": "'.str_pad($row30['cantidad'],1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "porcentaje": "'.str_pad($row30['porcentaje'],1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "pago": "'.str_pad($row30['pago'],1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "tipoHeR": "'.str_pad($row30['tipoHeR'],1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "descripcion": "'.str_pad($row30['descripcion'],1,"").'"'.Chr(13).Chr(10);                     

                        $cant2++;

                        if($cant2 < $cant1)
                            $json.= Chr(9).'         },'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'         }'.Chr(13).Chr(10);
                    }
                    // ----------------------------------------------------------------------------------------------------------------------------------- //
                    
                    if(($numprimas>0)||($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numlicencias>0)||($numpagocesan>0))
                        $json.= Chr(9).'  ],'.Chr(13).Chr(10);
                    else
                        $json.= Chr(9).'  ]'.Chr(13).Chr(10);
                }

                // primas de periodo
                if($numprimas>0)
                {
                    $json.= Chr(9).'"  primas": {'.Chr(13).Chr(10);

                    // Días de la prima
                    $vsqlcanprimas = "SELECT cantidad AS canprimas
                                        FROM liquidacion
                                       WHERE terid = ".$terid."
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'primas'";
                    $canprimas = $clase->SeleccionarUno($vsqlcanprimas);

                    // Pago de la prima
                    $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                         FROM liquidacion
                                        WHERE terid = ".$terid."
                                              AND periodonomina = '".$codperiodo."' 
                                              AND tipo = 'primas'";
                    $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);

                    $json.= Chr(9).'     "cantidad": "'.str_pad($canprimas,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'     "pago": "'.str_pad($pagoprimas,1,"").'"'.Chr(13).Chr(10);

                    if(($numcesantias>0)||($numvacacionest>0)||($numincap>0)||($numlicencias>0))
                        $json.= Chr(9).'   },'.Chr(13).Chr(10);
                    else
                        $json.= Chr(9).'   }'.Chr(13).Chr(10);

                    // Incremento el total devengado
                    $devengados += $pagoprimas;
                }

                // Cesantías del empleado
                if($numcesantias>0)
                {       
                    // Pago de la cesantía
                    $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                           FROM liquidacion
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'cesantias'";
                    $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);

                    // Pagos del fondo de cesantías
                    $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                           FROM pagocesantias
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."'";
                    $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                    if($numpagocesan>0)
                    {
                        $vsqlnumpagocesan = "";
                        $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                        $pagocesantia += $montopagocesan;
                    }

                    // Porcentaje cesantía
                    $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                           FROM liquidacion
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'cesantias'";
                    $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);

                    // Pago de intereses de cesantías
                    $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'cesantias'";
                    $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);
                    
                    $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                    $json.= Chr(9).'      "pago": "'.str_pad($pagocesantia,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'      "porcentaje": "'.str_pad(number_format($porccesantia,2),1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'      "pagoIntereses": "'.str_pad($pagointereses,1,"").'"'.Chr(13).Chr(10);

                    if(($numvacacionest>0)||($numincap>0)||($numlicencias>0))
                        $json.= Chr(9).'   },'.Chr(13).Chr(10);
                    else
                        $json.= Chr(9).'   }'.Chr(13).Chr(10);

                    // Incremento el total devengado
                    $devengados += $pagocesantia;
                    $devengados += $pagointereses;
                }
                else
                {
                    // Pagos del fondo de cesantías
                    $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                           FROM pagocesantias
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."'";
                    $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                    if($numpagocesan>0)
                    {
                        $vsqlnumpagocesan = "";
                        $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                        $pagocesantia = $montopagocesan;

                        $porccesantia = 0;
                        $pagointereses = 0;

                        $json.= Chr(9).'   "cesantias": {'.Chr(13).Chr(10);
                        $json.= Chr(9).'      "pago": "'.str_pad($pagocesantia,1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'      "porcentaje": "'.str_pad(number_format($porccesantia,2),1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'      "pagoIntereses": "'.str_pad($pagointereses,1,"").'"'.Chr(13).Chr(10);

                        if(($numvacacionest>0)||($numincap>0)||($numlicencias>0))
                            $json.= Chr(9).'   },'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'   }'.Chr(13).Chr(10);

                        // Incremento el total devengado
                        $devengados += $pagocesantia;
                    }
                }

                // Vacaciones del empleado
                if($numvacacionest>0)
                {
                    $json.= Chr(9).'      "listaVacaciones": ['.Chr(13).Chr(10); 
                    $json.= Chr(9).'         {'.Chr(13).Chr(10);

                    if($numvacaciones1 > 0)
                    {
                        // Días de vacaciones
                        $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'vacaciones'";
                        $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                        // Pago de vacaciones
                        $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                           FROM liquidacion
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'vacaciones'";
                        $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                    }
                    else
                    {
                        $canvacaciones = 0;
                        $pagovaca1 = 0;
                    }

                    if($numvacaciones2>0)
                    {
                        $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                            FROM hisdetallenomina  
                                           WHERE terid = ".$terid."
                                                 AND conceptoid = 38 
                                                 AND pernominaid IN ($listaperiodos)";
                        $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                    }
                    else
                        $pagovaca2 = 0;
                    
                    if($canvacaciones == 0)               $canvacaciones = 1;
                    $pagovaca = $pagovaca1 + $pagovaca2;

                    $json.= Chr(9).'            "cantidad": "'.str_pad($canvacaciones,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'            "pago": "'.str_pad($pagovaca,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'            "tipoVacacion": "1"'.Chr(13).Chr(10);
                    $json.= Chr(9).'         }'.Chr(13).Chr(10);

                    if(($numincap>0)||($numlicencias>0))
                        $json.= Chr(9).'],'.Chr(13).Chr(10);
                    else
                        $json.= Chr(9).']'.Chr(13).Chr(10);

                    // Incremento el total devengado
                    $devengados += $pagovaca1;
                }

                // Incluyo las incapacidades
                if($numincap>0)
                {
                    $i = 0;

                    // Consulta con los datos que se incluirán en el json
                    $vsql5 = "SELECT valor, devengados
                                FROM detalleliquidacion  
                               WHERE pernominaid IN ($listaperiodos) 
                                     AND conceptoid IN (10,40) 
                                     AND terid = ".$terid;
                    $conex  = $clase->Conectar();
                    $result5 = mysql_query($vsql5,$conex);
                    while($row5 = mysql_fetch_array($result5))
                    {
                        $feciniincap = $fecinicio;
                        $diasincap = $row5['valor'];
                        $fecfinincap = date("Y-m-d",strtotime($feciniincap."+ $diasincap days"));

                        $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "cantidad": "'.str_pad($row5['valor'],1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "tipo": "3",'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "pago": "'.str_pad($row5['devengados'],1,"").'"'.Chr(13).Chr(10);

                        $i++;
                        if($i==$numincap)
                            $json.= Chr(9).'         }'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'         },'.Chr(13).Chr(10);
                    }

                    if($numlicencias>0)
                        $json.= Chr(9).'      ],'.Chr(13).Chr(10);
                    else
                        $json.= Chr(9).'      ]'.Chr(13).Chr(10);
                }

                // Incluyo las licencias
                if($numlicencias>0)
                {
                    $json.= Chr(9).'      "listaLicencias": ['.Chr(13).Chr(10);

                    $i = 0;

                    // Consulta con los datos que se incluirán en el json
                    $vsql3 = "SELECT c.tipodc, h.devengados, h.descuentos, h.valor, c.nomconcepto, c.conceptoid  
                                FROM detalleliquidacion h
                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                               WHERE h.pernominaid IN ($listaperiodos)
                                     AND c.eslicencia = 'CHECKED' 
                                     AND c.tipodc = 'C' 
                                     AND h.conceptoid NOT IN (10,9,43,40,58) 
                                     AND h.terid = ".$terid;
                    $conex  = $clase->Conectar();
                    $result3 = mysql_query($vsql3,$conex);

                    while($row3 = mysql_fetch_array($result3))
                    {
                        $json.= Chr(9).'         {'.Chr(13).Chr(10);
                        $json.= Chr(9).'            "cantidad": "'.str_pad($row3['valor'],1,"").'",'.Chr(13).Chr(10);

                        if($row3['tipodc']=="C")
                            $json.= Chr(9).'            "pago": "'.str_pad($row3['devengados'],1,"").'",'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'            "pago": "'.str_pad($row3['descuentos'],1,"").'",'.Chr(13).Chr(10);
                        
                        // Licencias de maternidad o paternidad
                        if(($row3['conceptoid']==11)||($row3['conceptoid']==12))
                            $json.= Chr(9).'            "tipoLicencia": "1"'.Chr(13).Chr(10);

                        // Licencias remunerada
                        if(($row3['conceptoid']==10)||($row3['conceptoid']==13)||($row3['conceptoid']==23)||($row3['conceptoid']==31)||($row3['conceptoid']==40)||($row3['conceptoid']==46))
                            $json.= Chr(9).'            "tipoLicencia": "2"'.Chr(13).Chr(10);
                        
                        // Licencias no remunerada
                        if(($row3['conceptoid']==6)||($row3['conceptoid']==9)||($row3['conceptoid']==43)||($row3['conceptoid']==58))
                            $json.= Chr(9).'            "tipoLicencia": "3"'.Chr(13).Chr(10);

                        $i++;
                        if($i==$numlicencias)
                            $json.= Chr(9).'         }'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'         },'.Chr(13).Chr(10);
                    }
                    $json.= Chr(9).'      ]'.Chr(13).Chr(10);                            
                }

                $json.= Chr(9).'      },'.Chr(13).Chr(10);
    
                $json.= Chr(9).'"deducciones": {'.Chr(13).Chr(10);
                if($embargo>0)      $json.= Chr(9).'   "embargoFiscal": "'.str_pad($embargo,1,"").'",'.Chr(13).Chr(10);

                // otras deducciones
                if($numotrasdedliq>0)
                {
                    $json.= Chr(9).'   "listaOtrasDeducciones": ['.Chr(13).Chr(10);

                    $i = 0;
                    // Consulta con los datos que se incluirán en el json
                    $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                 FROM detalleliquidacion h
                                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                WHERE h.pernominaid IN ($listaperiodos)
                                      AND h.conceptoid IN (6,8,24,25,26,28,32,33,34,35,36,41,43,58)
                                      AND h.terid = ".$terid."";

                    $conex  = $clase->Conectar();
                    $result77 = mysql_query($vsql77,$conex);

                    while($row77 = mysql_fetch_array($result77))
                    {
                        $i++;
                        if($i==$numotrasdedliq)
                            $json.= Chr(9).'      "'.str_pad($row77['descuentos'],1,"").'"'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'      "'.str_pad($row77['descuentos'],1,"").'",'.Chr(13).Chr(10);
                    }
                    $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                }

                // Descuento por concepto de salud
                $json.= Chr(9).'   "salud": {'.Chr(13).Chr(10);
                if($salud>0)
                {
                    $json.= Chr(9).'      "porcentaje": "'.str_pad($por_sal_tra,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'      "deduccion": "'.str_pad($salud,1,"").'"'.Chr(13).Chr(10);
                }
                else
                {                        
                    $json.= Chr(9).'      "porcentaje": "0",'.Chr(13).Chr(10);
                    $json.= Chr(9).'      "deduccion": "0"'.Chr(13).Chr(10);
                }
                $json.= Chr(9).'   },'.Chr(13).Chr(10);

                // Descuento por concepto de pensión
                $json.= Chr(9).'   "fondoPension": {'.Chr(13).Chr(10);
                if($pension>0)
                {
                    $json.= Chr(9).'      "porcentaje": "'.str_pad($por_pen_tra,1,"").'",'.Chr(13).Chr(10);
                    $json.= Chr(9).'      "deduccion": "'.str_pad($pension,1,"").'"'.Chr(13).Chr(10);
                }
                else
                {                        
                    $json.= Chr(9).'      "porcentaje": "0",'.Chr(13).Chr(10);
                    $json.= Chr(9).'      "deduccion": "0"'.Chr(13).Chr(10);
                }

                if(($numsanciones>0)||($numlibranzas>0))
                    $json.= Chr(9).'   },'.Chr(13).Chr(10);
                else
                    $json.= Chr(9).'   }'.Chr(13).Chr(10);

                // Incluyo las sanciones
                if($numsanciones>0)
                {
                    $json.= Chr(9).'   "listaSanciones": ['.Chr(13).Chr(10);

                    $i = 0;
                    // Consulta con los datos que se incluirán en el json
                    $vsql6 = "SELECT c.nomconcepto, h.descuentos 
                                FROM detalleliquidacion h
                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                               WHERE h.pernominaid IN ($listaperiodos)
                                     AND h.conceptoid = 9
                                     AND h.terid = ".$terid;
                    $conex  = $clase->Conectar();
                    $result6 = mysql_query($vsql6,$conex);

                    while($row6 = mysql_fetch_array($result6))
                    {
                        $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        $json.= Chr(9).'         "valorSancion": "'.str_pad($row6['descuentos'],1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'         "tipoSancion": "2"'.Chr(13).Chr(10);

                        $i++;
                        if($i==$numsanciones)
                            $json.= Chr(9).'      }'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'      },'.Chr(13).Chr(10);
                    }
                    
                    if(($numlibranzas>0))
                        $json.= Chr(9).'   ],'.Chr(13).Chr(10);
                    else
                        $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                }

                // libranzas
                if($numlibranzas>0)
                {                                
                    $json.= Chr(9).'   "listaLibranzas": ['.Chr(13).Chr(10);

                    $i = 0;
                    // Consulta con los datos que se incluirán en el json
                    $vsql44 = "SELECT c.nomconcepto, h.descuentos  
                                 FROM detalleliquidacion h
                                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                WHERE h.pernominaid IN ($listaperiodos)
                                      AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                      AND h.terid = ".$terid."
                                      AND c.conceptoid NOT IN (10,30)
                                      AND h.pernominaid IN ($listaperiodos)";

                    $conex  = $clase->Conectar();
                    $result44 = mysql_query($vsql44,$conex);

                    while($row44 = mysql_fetch_array($result44))
                    {
                        $json.= Chr(9).'      {'.Chr(13).Chr(10);
                        $json.= Chr(9).'         "descripcion": "'.str_pad($row44['nomconcepto'],1,"").'",'.Chr(13).Chr(10);
                        $json.= Chr(9).'         "deduccion": "'.str_pad($row44['descuentos'],1,"").'"'.Chr(13).Chr(10);

                        $i++;
                        if($i==$numlibranzas)
                            $json.= Chr(9).'      }'.Chr(13).Chr(10);
                        else
                            $json.= Chr(9).'      },'.Chr(13).Chr(10);
                    }
                    $json.= Chr(9).'   ]'.Chr(13).Chr(10);
                }

                $json.= Chr(9).'},'.Chr(13).Chr(10);
    
                if(($numvacacionest>0)||($numprimas>0)||($numcesantias>0)||($numindemnizacion>0)||($montodotacion>0))
                    $neto = $devengados - $descuentos;

                $json.= Chr(9).'"devengadosTotal": "'.str_pad($devengados,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'"deduccionesTotal": "'.str_pad($descuentos,1,"").'",'.Chr(13).Chr(10);
                $json.= Chr(9).'"comprobanteTotal": "'.str_pad($neto,1,"").'"'.Chr(13).Chr(10);

                $json.='}'.Chr(13).Chr(10);

                // ----------------------------------------------------------------------------------------------------- //
                // Grabo en el archivo correspondiente la información de empleado
                $archivo = trim($dni).".json";                  //  nombre del archivo
                $fd = fopen ($carpetaactual."/".$archivo, "w"); // se abre el archivo para escribir
                fwrite($fd, $json);                             // Grabas
                fclose($fd);                                    // Cierras el archivo
                $listadereportados.= $terid.",";
            }
            $listadereportados = substr($listadereportados, 0, -1);   
        }

        $clase->Aviso(2,"Archivos de nómina electrónica generados exitosamente");
        header("Location: principal.php?");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: salidaxls
    // Creación: 03/11/2021		última modificación: 12/10/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera la salida a Excel de los empleados que se reportarán 
    //              en la nómina electrónica
    // Última modificación: Nuevo ciclo para los empleados con dos quincenas laboradas y 
    //                      liquidación también (03/03/2022)
    //                      Incorporación del ciclo para los empleados solo con liquidación 
    //                      en el periodo (12/12/2022)
    //                      Incorporación del filtro de los empleados excluidos del periodo
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion=="salidaxls")
    {
        // Código del periodo
        $codperiodo  = $_GET['codperiodo'];

        $listadereportados = "";
        $nodebensalir = "";        

        // Mes y año del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $mesperiodo = substr($desperiodo,0,-5);
        $yeartoday = date("Y");
        
        // validación para el caso del año anterior
        if(intval(substr($codperiodo,-4)) != $yeartoday)
            $yeartoday--;

        // fechas del periodo
        $fecinicio = substr($desperiodo,-4)."-".substr($codperiodo,0,2)."-01";
        $fecfinal = date("Y-m-t", strtotime($fecinicio));

        // Consulta de los periodos de nómina que se van a consultar
        $vsql = "SELECT periodoid 
                   FROM periodosnomina 
                  WHERE descripcion LIKE '%".$mesperiodo."%' AND descripcion LIKE '%".$yeartoday."%'";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $periodosreportar = mysql_num_rows($result);

        // Periodos a procesar
        if($periodosreportar>0)
        {
            while($row = mysql_fetch_array($result))
            {
                $listaperiodos.= $row['periodoid'].",";
                $segundaquinper = $row['periodoid'];
            }
            $listaperiodos = substr($listaperiodos, 0, -1);
        }

        // ---------------------------------------------------------------------------------------------------------------------------- //
        // Determino si existen empleados excluidos en el periodo

        $vsql250 = "SELECT terid 
                      FROM noliquida 
                     WHERE periodonomina = '".$codperiodo."' 
                       AND tipo = 'nominaelec'";

        $conex  = $clase->Conectar();
        $result250 = mysql_query($vsql250,$conex);
        $hayexcluidos = mysql_num_rows($result250);

        if($hayexcluidos > 0)
        {
            while($row250 = mysql_fetch_array($result250))
            {
                $nodebensalir.= $row250['terid'].",";
            }
            $nodebensalir = substr($nodebensalir, 0, -1);
        }
        // ---------------------------------------------------------------------------------------------------------------------------- //

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Consulta para determinar los empleados procesados en el periodo seleccionado
        $vsql2 = "SELECT DISTINCT terid FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos)";

        if(strlen($nodebensalir) > 0)
            $vsql2.= " AND terid NOT IN ($nodebensalir) ";

        $conex  = $clase->Conectar();
        $result2 = mysql_query($vsql2,$conex);
        $empleadosreportar = mysql_num_rows($result2);

        // ----------------------------------------------------------------- //
        // $empleadosreportar = 0;       $i = 1;

        // require_once 'lib/PHPExcel.php';
        // $clase = new Sistema();
        // $clase->Conectar();
        // ini_set("memory_limit","100M");   
        
        // // Preparación del entorno para la salida a Excel
        // $clase = new Sistema();
        // $clase->Nombredb = $_SESSION['DBNOMBRE'];
        // error_reporting(E_ALL);
        // ini_set('display_errors', TRUE);
        // ini_set('display_startup_errors', TRUE);
        // date_default_timezone_set('Europe/London');
    
        // if (PHP_SAPI == 'cli')
        //     die('This example should only be run from a Web Browser');
    
        // // Create new PHPExcel object
        // $objPHPExcel = new PHPExcel();
    
        // // Set document properties
        // $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
        //                              ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
        //                              ->setTitle("Planilla de nomina - DROPOS")
        //                              ->setSubject("Planilla de nomina - DROPOS")
        //                              ->setDescription("Planilla de nomina - DROPOS")
        //                              ->setKeywords("Planilla de nomina - DROPOS")
        //                              ->setCategory("Categoria General");
                                         
        // $objPHPExcel->setActiveSheetIndex(0)
        //             ->setCellValue('A1', 'NOMINA ELECTRÓNICA DEL PERIODO '.$desperiodo)                        
        //             ->setCellValue('A3', 'idEmpresa: 1536')
        //             ->setCellValue('A4', 'tipoDocumento: 1')
        //             ->setCellValue('A5', 'almacenamiento: 1')
        //             ->setCellValue('A6', 'Fecha de inicio: '.$fecinicio)
        //             ->setCellValue('A7', 'Fecha final: '.$fecfinal)                        
        //             ->setCellValue('A9', 'fechaIngreso')
        //             ->setCellValue('B9', 'tipoTrabajador')
        //             ->setCellValue('C9', 'subTipoTrabajador')
        //             ->setCellValue('D9', 'altoRiesgoPension')
        //             ->setCellValue('E9', 'tipoDocumento')
        //             ->setCellValue('F9', 'numeroDocumento')
        //             ->setCellValue('G9', 'primerApellido')
        //             ->setCellValue('H9', 'segundoApellido')
        //             ->setCellValue('I9', 'primerNombre')
        //             ->setCellValue('J9', 'otrosNombres')
        //             ->setCellValue('K9', 'sueldo')
        //             ->setCellValue('L9', 'codigoTrabajador')
        //             ->setCellValue('M9', 'formapago')
        //             ->setCellValue('N9', 'metodopago')
        //             ->setCellValue('O9', 'banco')
        //             ->setCellValue('P9', 'tipoCuenta')
        //             ->setCellValue('Q9', 'numeroCuenta')
        //             ->setCellValue('R9', 'diasTrabajados')
        //             ->setCellValue('S9', 'sueldoTrabajado')
        //             ->setCellValue('T9', 'transporte')
        //             ->setCellValue('U9', 'incapacidadcantidad')
        //             ->setCellValue('V9', 'incapacidadtipo')
        //             ->setCellValue('W9', 'incapacidadpago')
        //             ->setCellValue('X9', 'licenciadescripcion')
        //             ->setCellValue('Y9', 'licenciacantidad')
        //             ->setCellValue('Z9', 'licenciapago')
        //             ->setCellValue('AA9', 'embargo')
        //             ->setCellValue('AB9', 'OtrasDeducciones')
        //             ->setCellValue('AC9', 'MontoOtrasDeducciones')
        //             ->setCellValue('AD9', 'porcentajesalud')
        //             ->setCellValue('AE9', 'deduccionsalud')
        //             ->setCellValue('AF9', 'porcentajepension')
        //             ->setCellValue('AG9', 'deduccionpension')
        //             ->setCellValue('AH9', 'valorSancion')
        //             ->setCellValue('AI9', 'tipoSancion')
        //             ->setCellValue('AJ9', 'libranzadescripcion')
        //             ->setCellValue('AK9', 'libranzadeduccion')
        //             ->setCellValue('AL9', 'díasdeprima')
        //             ->setCellValue('AM9', 'montoprima')
        //             ->setCellValue('AN9', 'pagocesantias')
        //             ->setCellValue('AO9', 'porcentajecesantias')
        //             ->setCellValue('AP9', 'pagointereses')
        //             ->setCellValue('AQ9', 'díasvacaciones')
        //             ->setCellValue('AR9', 'montovacaciones') 
        //             ->setCellValue('AS9', 'indemnizacion')
        //             ->setCellValue('AT9', 'otrosdevengados')
        //             ->setCellValue('AU9', 'devengadosTotal')
        //             ->setCellValue('AV9', 'deduccionesTotal')
        //             ->setCellValue('AW9', 'comprobanteTotal');

        // $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);            
        // $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);            
        // $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setAutoSize(true);            
        // $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AG')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AH')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AI')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AJ')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AK')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AL')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AM')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AN')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AO')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AP')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AQ')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AR')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AS')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AT')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AU')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AV')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('AW')->setAutoSize(true);

        // $i=10;
        // $k = $i;
        // ----------------------------------------------------------------- //     

        if($empleadosreportar>0)
        {
            require_once 'lib/PHPExcel.php';
            $clase = new Sistema();
            $clase->Conectar();
            ini_set("memory_limit","100M");

            // Inicialización de variables
            $consecutivo = 0;                           $dni = "";                              $primerapellido = "";                           $segundoapellido = "";
            $primernombre = "";                         $segundonombre = "";                    $basico = 0;                                    $codvende = "";
            $email = "";                                $telmovil = "";                         $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                            $banco = "";                            $vsqldias = "";                                 $diastrab = 0;
            $vsqltrasp = "";                            $auxtransp = 0;                         $vsqldev = "";                                  $devengados = 0;
            $vsqldesc = "";                             $descuentos = 0;                        $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                            $salud = 0;                             $por_sal_tra = 0;                               $vsqlpension = "";
            $pension = 0;                               $por_pen_tra = 0;                       $neto = 0;                                      $fecingreso = "";
            $vsqlincapacidad = "";                      $numincap = 0;                          $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                          $fecfinincap = "";                      $vsqlpagoincap = "";                            $pagoincap = 0;
            $fechaAct = date("Y-m-d");                  $horaAct = date("H:i:s");               $newconsecutivo = "";                           $vsqlsanciones = "";
            $numsanciones = 0;                          $prefijo = "";                          $vsqlnumcuenta = "";                            $vsqldotaciones = "";
            $vsqlnumpagocesan = "";                     $numpagocesan = 0;                      $montopagocesan = 0;                            $vsqlnumvacaciones2 = "";
            $numvacaciones2 = 0;                        $vsqlpagovaca2 = "";                    $pagovaca2 = 0;                                 $vsqlincapacidad2 = "";
            $montodotacion = 0;                         $numincap2 = 0;                         $vsqlrecargonoc = "";                           $recargonoc = 0;
            $vsqlrecargonocliq = "";                    $recargonocliq = 0;                     $horaextradiurnaliq = 0;                        $horaextradiurna = 0;
            $horaextranocturna = 0;                     $horaextranocturnaliq = 0;              $horaextradiurnadom = 0;                        $horaextradiurnadomliq = 0;
            $horaextradnocturnadomfes = 0;              $horaextradnocturnadomfesliq = 0;       $domingosyfestivos = 0;                         $domingosyfestivosliq = 0;
            $recargonocdomfes = 0;                      $recargonocdomfesliq = 0;               $cantidadhen = 0;                               $cantidadhenliq = 0;
            $cantidaddehen = 0;                         $montohoraextnocturna = 0;              $montohoraextnocturnaliq = 0;                   $montohorextnoc = 0;
            $cantidadhedd = 0;                          $cantidadheddliq = 0;                   $cantidaddehedd = 0;                            $montohoraextddom = 0;
            $montohoraextddomliq = 0;                   $montohoraextdiudom = 0;                $cantidadhendf = 0;                             $cantidadhendfliq = 0;
            $cantidaddehendf = 0;                       $montohendf = 0;                        $montohendfliq = 0;                             $montodehendf = 0;
            $cantidaddomfes = 0;                        $cantidaddomfesliq = 0;                 $cantidaddedomfes = 0;                          $montodomfes = 0;
            $montodomfesliq = 0;                        $montodedomfes = 0;                     $cantidadrecnocdonfes = 0;                      $cantidadrecnocdonfesliq = 0;
            $cantidadderecnocdonfes = 0;                $montorecnocdonfes = 0;                 $montorecnocdonfesliq = 0;                      $montoderecnocdonfes = 0;
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;

            // Preparación del entorno para la salida a Excel
            $clase = new Sistema();
            $clase->Nombredb = $_SESSION['DBNOMBRE'];
            error_reporting(E_ALL);
            ini_set('display_errors', TRUE);
            ini_set('display_startup_errors', TRUE);
            date_default_timezone_set('Europe/London');
        
            if (PHP_SAPI == 'cli')
                die('This example should only be run from a Web Browser');
        
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
        
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                         ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                         ->setTitle("Planilla de nomina - DROPOS")
                                         ->setSubject("Planilla de nomina - DROPOS")
                                         ->setDescription("Planilla de nomina - DROPOS")
                                         ->setKeywords("Planilla de nomina - DROPOS")
                                         ->setCategory("Categoria General");

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'NOMINA ELECTRÓNICA DEL PERIODO '.$desperiodo)                        
                        ->setCellValue('A3', 'idEmpresa: 1536')
                        ->setCellValue('A4', 'tipoDocumento: 1')
                        ->setCellValue('A5', 'almacenamiento: 1')
                        ->setCellValue('A6', 'Fecha de inicio: '.$fecinicio)
                        ->setCellValue('A7', 'Fecha final: '.$fecfinal)                        
                        ->setCellValue('A9', 'fechaIngreso')
                        ->setCellValue('B9', 'tipoTrabajador')
                        ->setCellValue('C9', 'subTipoTrabajador')
                        ->setCellValue('D9', 'altoRiesgoPension')
                        ->setCellValue('E9', 'tipoDocumento')
                        ->setCellValue('F9', 'numeroDocumento')
                        ->setCellValue('G9', 'primerApellido')
                        ->setCellValue('H9', 'segundoApellido')
                        ->setCellValue('I9', 'primerNombre')
                        ->setCellValue('J9', 'otrosNombres')
                        ->setCellValue('K9', 'sueldo')
                        ->setCellValue('L9', 'codigoTrabajador')
                        ->setCellValue('M9', 'formapago')
                        ->setCellValue('N9', 'metodopago')
                        ->setCellValue('O9', 'banco')
                        ->setCellValue('P9', 'tipoCuenta')
                        ->setCellValue('Q9', 'numeroCuenta')
                        ->setCellValue('R9', 'diasTrabajados')
                        ->setCellValue('S9', 'sueldoTrabajado')
                        ->setCellValue('T9', 'transporte')
                        ->setCellValue('U9', 'DiasRecargoNoc')
                        ->setCellValue('V9', 'RecargoNocturno')
                        ->setCellValue('W9', 'CantidadHorasExtDiurna')
                        ->setCellValue('X9', 'MontoHorasExtDiurna')
                        ->setCellValue('Y9', 'CantidadHorasExtNocturna')
                        ->setCellValue('Z9', 'MontoHorasExtNocturna')
                        ->setCellValue('AA9', 'CantidadHorasExtDiurnaDom')
                        ->setCellValue('AB9', 'MontoHorasExtDiurnaDom')
                        ->setCellValue('AC9', 'CantidadHorasExtNocDomFes')
                        ->setCellValue('AD9', 'MontoHorasExtNocDomFes')
                        ->setCellValue('AE9', 'CantidadDomingosyFestivos')
                        ->setCellValue('AF9', 'MontoDomingosyFestivos')
                        ->setCellValue('AG9', 'CantidadRecargoNocturnoDomFes')
                        ->setCellValue('AH9', 'MontoRecagoNocturnoDomFes')
                        ->setCellValue('AI9', 'incapacidadcantidad')
                        ->setCellValue('AJ9', 'incapacidadtipo')
                        ->setCellValue('AK9', 'incapacidadpago')
                        ->setCellValue('AL9', 'licenciadescripcion')
                        ->setCellValue('AM9', 'licenciacantidad')
                        ->setCellValue('AN9', 'licenciapago')
                        ->setCellValue('AO9', 'embargo')
                        ->setCellValue('AP9', 'OtrasDeducciones')
                        ->setCellValue('AQ9', 'MontoOtrasDeducciones')
                        ->setCellValue('AR9', 'porcentajesalud')
                        ->setCellValue('AS9', 'deduccionsalud')
                        ->setCellValue('AT9', 'porcentajepension')
                        ->setCellValue('AU9', 'deduccionpension')
                        ->setCellValue('AV9', 'valorSancion')
                        ->setCellValue('AW9', 'tipoSancion')
                        ->setCellValue('AX9', 'libranzadescripcion')
                        ->setCellValue('AY9', 'libranzadeduccion')
                        ->setCellValue('AZ9', 'díasdeprima')
                        ->setCellValue('BA9', 'montoprima')
                        ->setCellValue('BB9', 'pagocesantias')
                        ->setCellValue('BC9', 'porcentajecesantias')
                        ->setCellValue('BD9', 'pagointereses')
                        ->setCellValue('BE9', 'díasvacaciones')
                        ->setCellValue('BF9', 'montovacaciones') 
                        ->setCellValue('BG9', 'indemnizacion')
                        ->setCellValue('BH9', 'otrosdevengados')
                        ->setCellValue('BI9', 'dotaciones')
                        ->setCellValue('BJ9', 'devengadosTotal')
                        ->setCellValue('BK9', 'deduccionesTotal')
                        ->setCellValue('BL9', 'comprobanteTotal');            

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AG')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AH')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AI')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AJ')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AK')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AL')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AM')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AN')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AO')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AP')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AQ')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AR')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AS')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AT')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AU')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AV')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AW')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AX')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AY')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AZ')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('BA')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('BB')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('BC')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('BD')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('BE')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('BF')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('BG')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('BH')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('BI')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('BJ')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('BK')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('BL')->setAutoSize(true);

            $i=10;
            while($row2 = mysql_fetch_array($result2))
            {
                // id del empleado
                $terid = $row2['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal = 'CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);
                
                if($numnomext<2)
                {
                    // Días trabajados
                    $vsqldias = "SELECT SUM(IF(conceptoid = 1,valor,0)) AS diastrab 
                                   FROM hisdetallenomina 
                                  WHERE pernominaid IN ($listaperiodos) 
                                        AND terid = ".$terid." 
                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                  FROM periodoterceros
                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                       AND pernominaid IN ($listaperiodos)
                                                                       AND extralegal = 'CHECKED')";
                    $diastrab = $clase->SeleccionarUno($vsqldias);

                    if(($numnomext==1)&&($diastrab==0))
                    {
                        $laboro = false;

                        $vsqlnuminc = "SELECT COUNT(*) AS numinc
                                         FROM periodoterceros pt 
                                              INNER JOIN hisdetallenomina h ON (pt.terid = h.terid AND pt.pernominaid = h.pernominaid) 
                                        WHERE pt.terid = ".$terid." 
                                              AND pt.extralegal <> 'CHECKED' 
                                              AND (h.conceptoid = 10 AND h.valor = 15)";
                        $numincsolo = $clase->SeleccionarUno($vsqlnuminc);

                        $vsqlnumlnr = "SELECT COUNT(*) AS numlnr 
                                         FROM periodoterceros pt 
                                              INNER JOIN hisdetallenomina h ON (pt.terid = h.terid AND pt.pernominaid = h.pernominaid) 
                                        WHERE pt.terid = ".$terid." 
                                              AND pt.extralegal <> 'CHECKED' 
                                              AND (h.conceptoid = 6 AND h.valor = 15)
                                              AND h.pernominaid IN ($listaperiodos)
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid."  
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')";
                        $numlnrsolo = $clase->SeleccionarUno($vsqlnumlnr);

                        if(($numincsolo == 1) || ($numlnrsolo == 1))
                            $laboro = true;
                    }
                    else
                        $laboro = true;                    

                    if($laboro)
                    {
                        // ----------------------------------------------------------------------------------------------- //                        
                        $sumar = 0;
                        $numlibranzasliq = 0;
                        $vsqlrep = "SELECT COUNT(*) AS sumar FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)";
                        $sumar = $clase->SeleccionarUno($vsqlrep);
                        // ----------------------------------------------------------------------------------------------- //

                        // Actualizo los días trabajados
                        if($sumar>0)
                        {
                            $vsqldiasliq = "SELECT SUM(IF(conceptoid = 1,valor,0)) AS diastrabliq 
                                              FROM detalleliquidacion 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND terid = ".$terid."
                                                   AND conceptoid = 1";
                            $diastrabliq = $clase->SeleccionarUno($vsqldiasliq);

                            $diastrab += $diastrabliq;
                        }

                        // Documento del empleado
                        $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                        // Primer apellido
                        $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                        // Segundo apellido
                        $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                        // Primer nombre
                        $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                        // Segundo nombre
                        $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                        // Sueldo básico
                        $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                        // Código del trabajador
                        $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                        // Correo electrónico
                        $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                        // Teléfono
                        $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                        // Número de cuenta
                        $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
                        
                        // Tipo de documento
                        $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                        // Banco
                        $vsqlbanco = "SELECT b.descripcion AS banco
                                        FROM periodoterceros p
                                             INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                       WHERE p.terid = ".$terid;
                        $banco = $clase->SeleccionarUno($vsqlbanco);
                        $banco = trim(str_replace("BANCO ","",$banco));
    
                        // cargo del empleado
                        $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');

                        // sueldo del periodo
                        $vsqlsueldo = "SELECT SUM(IF(conceptoid=1,devengados,0)) AS sueldoper 
                                         FROM hisdetallenomina 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid = ".$terid."
                                              AND pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND pernominaid IN ($listaperiodos)
                                                                             AND extralegal = 'CHECKED')";
                        $sueldoper = $clase->SeleccionarUno($vsqlsueldo);

                        if($sumar>0)
                        {
                            $vsqlsueldoliq = "SELECT devengados AS sueldoliq
                                                FROM detalleliquidacion
                                               WHERE terid = ".$terid." 
                                                     AND conceptoid = 1
                                                     AND pernominaid IN ($listaperiodos)";
                            $sueldoliq = $clase->SeleccionarUno($vsqlsueldoliq);

                            $sueldoper += $sueldoliq;
                        }

                        // Auxilio de transporte
                        $vsqltrasp = "SELECT SUM(IF(conceptoid IN (3,45),devengados,0)) AS auxtransp 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros 
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal = 'CHECKED')";
                        $auxtransp = $clase->SeleccionarUno($vsqltrasp);

                        if($sumar>0)
                        {
                            $vsqltransliq = "SELECT devengados AS transliq
                                               FROM detalleliquidacion
                                              WHERE terid = ".$terid."
                                                    AND conceptoid = 3
                                                    AND pernominaid IN ($listaperiodos)";
                            $transliq = $clase->SeleccionarUno($vsqltransliq);

                            $auxtransp += $transliq;
                        }

                        // Recargo nocturno
                        $vsqlrecargonoc = "SELECT SUM(IF(conceptoid IN (47,56,59),devengados,0)) AS recargonoc 
                                             FROM hisdetallenomina 
                                            WHERE pernominaid IN ($listaperiodos) 
                                                  AND terid = ".$terid."
                                                  AND pernominaid NOT IN (SELECT pernominaid 
                                                                            FROM periodoterceros 
                                                                           WHERE periodoterceros.terid = ".$terid." 
                                                                                 AND pernominaid IN ($listaperiodos)
                                                                                 AND extralegal = 'CHECKED')";
                        $recargonoc = $clase->SeleccionarUno($vsqlrecargonoc);

                        if($sumar>0)
                        {
                            $vsqlrecargonocliq = "SELECT devengados AS recargonocliq
                                                    FROM detalleliquidacion
                                                   WHERE terid = ".$terid."
                                                         AND conceptoid IN (47,56,59) 
                                                         AND pernominaid IN ($listaperiodos)";
                            $recargonocliq = $clase->SeleccionarUno($vsqlrecargonocliq);
     
                            $recargonoc += $recargonocliq;
                        }

                        // hora extra diurna
                        $horaextradiurna = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 49,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $horaextradiurnaliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 49 AND pernominaid IN ($listaperiodos)");
                            $horaextradiurna += $horaextradiurnaliq;
                        }

                        // hora extra nocturna
                        $horaextranocturna = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 50,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $horaextranocturnaliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 50 AND pernominaid IN ($listaperiodos)");
                            $horaextranocturna += $horaextranocturnaliq;
                        }

                        // hora extra diurna dominical
                        $horaextradiurnadom = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 51,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $horaextradiurnadomliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 51 AND pernominaid IN ($listaperiodos)");
                            $horaextradiurnadom += $horaextradiurnadomliq;
                        }

                        // hora extra nocturna dominical y festivo
                        $horaextradnocturnadomfes = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 52,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $horaextradnocturnadomfesliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 52 AND pernominaid IN ($listaperiodos)");
                            $horaextradnocturnadomfes += $horaextradnocturnadomfesliq;
                        }

                        // domingos y festivos
                        $domingosyfestivos = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 53,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $domingosyfestivosliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 53 AND pernominaid IN ($listaperiodos)");
                            $domingosyfestivos += $domingosyfestivosliq;
                        }

                        // recargo nocturno dominical y festivo
                        $recargonocdomfes = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 54,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");

                        if($sumar>0)
                        {
                            $recargonocdomfesliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 54 AND pernominaid IN ($listaperiodos)");
                            $recargonocdomfes += $recargonocdomfesliq;
                        }

                        // Embargo
                        $vsqlembg = "SELECT SUM(IF(conceptoid = 30,descuentos,0)) AS embargo 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND pernominaid IN ($listaperiodos)
                                                                           AND extralegal = 'CHECKED')";
                        $embargo = $clase->SeleccionarUno($vsqlembg);

                        if($sumar>0)
                        {
                            $vsqlembliq = "SELECT descuentos AS embliq
                                             FROM detalleliquidacion
                                            WHERE terid = ".$terid."
                                                  AND conceptoid = 30
                                                  AND pernominaid IN ($listaperiodos)";
                            $embliq = $clase->SeleccionarUno($vsqlembliq);

                            $embargo += $embliq;
                        }

                        // Salud
                        $vsqlsalud = "SELECT SUM(IF(conceptoid = 5,descuentos,0)) AS salud 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal = 'CHECKED')";
                        $salud = $clase->SeleccionarUno($vsqlsalud);

                        if($sumar>0)
                        {
                            $vsqlsaludliq = "SELECT descuentos AS saludliq
                                               FROM detalleliquidacion
                                              WHERE terid = ".$terid."
                                                    AND conceptoid = 5
                                                    AND pernominaid IN ($listaperiodos)";
                            $saludliq = $clase->SeleccionarUno($vsqlsaludliq);

                            $salud += $saludliq;
                        }

                        // Pensión
                        $vsqlpension = "SELECT SUM(IF(conceptoid = 4,descuentos,0)) AS pension 
                                          FROM hisdetallenomina 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                        $pension = $clase->SeleccionarUno($vsqlpension);

                        if($sumar>0)
                        {
                            $vsqlpesionliq = "SELECT descuentos AS pesionliq
                                                FROM detalleliquidacion
                                               WHERE terid = ".$terid."
                                                     AND conceptoid = 4
                                                     AND pernominaid IN ($listaperiodos)";
                            $pesionliq = $clase->SeleccionarUno($vsqlpesionliq);

                            $pension += $pesionliq;
                        }

                        // total devengado
                        $vsqldev = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                      FROM hisdetallenomina 
                                     WHERE terid = ".$terid."
                                           AND pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND pernominaid IN ($listaperiodos)
                                                                          AND extralegal = 'CHECKED')";
                        $devengados = $clase->SeleccionarUno($vsqldev);

                        if($sumar>0)
                        {
                            $vsqldevliq = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                             FROM detalleliquidacion 
                                            WHERE terid = ".$terid."";
                            $devengadosliq = $clase->SeleccionarUno($vsqldevliq);

                            $devengados += $devengadosliq;
                        }
                        
                        // total descuentos
                        $vsqldesc = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND pernominaid IN ($listaperiodos)
                                                                           AND extralegal = 'CHECKED')";
                        $descuentos = $clase->SeleccionarUno($vsqldesc);

                        if($sumar>0)
                        {
                            $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                              FROM detalleliquidacion 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND terid = ".$terid."";
                            $descuentosliq = $clase->SeleccionarUno($vsqldescliq);

                            $descuentos += $descuentosliq;
                        }

                        $neto = $devengados - $descuentos;

                        // Obtengo la fecha de ingreso del empleado
                        $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');

                        // Incapacidades del periodo
                        $vsqlincapacidad = "SELECT COUNT(*) AS numincap 
                                              FROM hisdetallenomina 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND conceptoid IN (10,40,43)
                                                   AND terid = ".$terid."
                                                   AND pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal = 'CHECKED')";
                        $numincap = $clase->SeleccionarUno($vsqlincapacidad);

                        $vsqlincapacidad2 = "SELECT COUNT(*) AS numincap
                                               FROM detalleliquidacion 
                                              WHERE pernominaid IN ($listaperiodos) 
                                                    AND terid = ".$terid."
                                                    AND conceptoid IN (10,40,43)";
                        $numincap2 = $clase->SeleccionarUno($vsqlincapacidad2);

                        $numincap += $numincap2;

                        if($numincap>0)
                        {
                            // Cantidad de la incapacidad                            
                            $vsqlcantincap = "SELECT IFNULL(SUM(valor),0) AS diasincap 
                                                FROM hisdetallenomina 
                                               WHERE pernominaid IN ($listaperiodos) 
                                                     AND conceptoid IN (10,40,43)  
                                                     AND terid = ".$terid."
                                                     AND pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND pernominaid IN ($listaperiodos)
                                                                                    AND extralegal = 'CHECKED')";
                            $diasincap = $clase->SeleccionarUno($vsqlcantincap);

                            $vsqlcantincap2 = "SELECT IFNULL(SUM(valor),0) AS diasincap 
                                                 FROM detalleliquidacion 
                                                WHERE pernominaid IN ($listaperiodos) 
                                                      AND terid = ".$terid."
                                                      AND conceptoid IN (10,40,43)";
                            $diasincap2 = $clase->SeleccionarUno($vsqlcantincap2);

                            $diasincap += $diasincap2;
    
                            // Fecha de inicio
                            $feciniincap = $fecinicio;
    
                            // Fecha final
                            $fecfinincap = date("Y-m-d",strtotime($feciniincap."+ $diasincap days"));
                        }

                        // Licencias del periodo
                        $vsqlincapacidad = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                              FROM hisdetallenomina h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND c.eslicencia = 'CHECKED' 
                                                   AND c.tipodc = 'C' 
                                                   AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                                   AND h.terid = ".$terid."
                                                   AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND pernominaid IN ($listaperiodos)
                                                                                    AND extralegal = 'CHECKED')";
                        $numlicencias = $clase->SeleccionarUno($vsqlincapacidad);

                        // --------------------------------------------------------------------------------------------------- //
                        // inclusión de las licencas no remuneradas en este renglón solo para la salida a excel
                        $vsqllicnoremuneradas = "SELECT COUNT(conceptoid) AS licnoremuneradas 
                                                   FROM hisdetallenomina 
                                                  WHERE pernominaid IN ($listaperiodos)
                                                        AND conceptoid = 6
                                                        AND terid = ".$terid."
                                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND pernominaid IN ($listaperiodos)
                                                                                       AND extralegal = 'CHECKED')";
                        $licnoremuneradas = $clase->SeleccionarUno($vsqllicnoremuneradas);
                        $numlicencias += $licnoremuneradas;
                        // --------------------------------------------------------------------------------------------------- //

                        $vsqlincapacidad2 = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                               FROM detalleliquidacion h
                                                    INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                              WHERE h.pernominaid IN ($listaperiodos)
                                                    AND c.eslicencia = 'CHECKED' 
                                                    AND c.tipodc = 'C' 
                                                    AND h.conceptoid NOT IN (10,9,43,40,58) 
                                                    AND h.terid = ".$terid;
                        $numlicencias2 = $clase->SeleccionarUno($vsqlincapacidad2);

                        // --------------------------------------------------------------------------------------------------- //
                        // inclusión de las licencas no remuneradas en este renglón solo para la salida a excel
                        $vsqllicnoremuneradas2 = "SELECT COUNT(conceptoid) AS licnoremuneradas2 
                                                    FROM detalleliquidacion 
                                                   WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid."
                                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                                   FROM periodoterceros
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND pernominaid IN ($listaperiodos)
                                                                                        AND extralegal = 'CHECKED')";
                        $licnoremuneradas2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);
                        $numlicencias2 += $licnoremuneradas2;
                        // --------------------------------------------------------------------------------------------------- //

                        $numlicencias += $numlicencias2;

                        // Libranzas del periodo
                        $vsqllibranzas = "SELECT COUNT(h.conceptoid) AS numlibranzas 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND (c.eslibranza ='CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                                 AND h.terid = ".$terid."
                                                 AND c.conceptoid NOT IN (10,30)
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal = 'CHECKED')";
                        $numlibranzas = $clase->SeleccionarUno($vsqllibranzas);

                        if($sumar>0)
                        {
                            $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                                   FROM detalleliquidacion h
                                                        INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                                  WHERE h.pernominaid IN ($listaperiodos)
                                                        AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                                        AND h.terid = ".$terid."
                                                        AND c.conceptoid NOT IN (10,30)";
                            $numlibranzasliq = $clase->SeleccionarUno($vsqllibranzasliq);
                        }

                        // Sanciones del periodo
                        $vsqlsanciones = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid = 9
                                                 AND h.terid = ".$terid."
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal = 'CHECKED')";
                        $numsanciones = $clase->SeleccionarUno($vsqlsanciones);

                        // Otras deducciones
                        // Estas incluyen: CAMISETAS, PLAN TELEFONIA MOVIL, PRESTAMOS PERSONALES, AJUSTE SALARIO SENA, 
                        // CREDITOS OTROS NEGOCIOS, DESCUENTO SP, MANGAS, CAFETERIA, COMPRAS A CREDITO, OTROS
                        $vsqlotrasdeduc = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                  AND h.terid = ".$terid."
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND pernominaid IN ($listaperiodos)
                                                                                   AND extralegal = 'CHECKED')";
                        $numotrasded = $clase->SeleccionarUno($vsqlotrasdeduc);

                        if($sumar>0)
                        {
                            $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                                    FROM detalleliquidacion h
                                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                                   WHERE h.pernominaid IN ($listaperiodos)
                                                         AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                         AND h.terid = ".$terid."";
                            $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);
                        }

                        // Vacaciones
                        $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'vacaciones'";
                        $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                        // Vacaciones pagadas en quincenas
                        $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2 
                                                 FROM hisdetallenomina 
                                                WHERE terid = ".$terid."
                                                      AND conceptoid = 38 
                                                      AND pernominaid IN ($listaperiodos)";
                        $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                        $numvacacionest = $numvacaciones1 + $numvacaciones2;

                        // Primas
                        $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $numprimas = $clase->SeleccionarUno($vsqlnumprimas);

                        // Cesantías
                        $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);

                        // Indemnización
                        $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Otros conceptos devengados
                        $vsqlotrosdeven = "SELECT COUNT(h.conceptoid) AS numotrosdeven
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid IN (37,48)
                                                  AND h.terid = ".$terid."
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND pernominaid IN ($listaperiodos)
                                                                                   AND extralegal = 'CHECKED')";
                        $numotrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);

                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Dotaciones 
                        $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                             FROM dotaciones
                                            WHERE periodonomina = '".$codperiodo."'
                                                  AND terid = ".$terid."";
                        $montodotacion = $clase->SeleccionarUno($vsqldotaciones);
                        
                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Escribo en la hoja de Excel
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$i, $fecingreso)
                                    ->setCellValue('B'.$i, '01')
                                    ->setCellValue('C'.$i, '00')
                                    ->setCellValue('D'.$i, 'true')
                                    ->setCellValue('E'.$i,'13')
                                    ->setCellValue('F'.$i, $dni)
                                    ->setCellValue('G'.$i, $primerapellido)
                                    ->setCellValue('H'.$i, $segundoapellido)
                                    ->setCellValue('I'.$i, $primernombre)
                                    ->setCellValue('J'.$i, $segundonombre)
                                    ->setCellValue('K'.$i, number_format($basico))
                                    ->setCellValue('L'.$i, $codvende)
                                    ->setCellValue('M'.$i, '1');

                        // Identifico la forma de pago
                        if($numcuenta!="")
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('N'.$i, '45')
                                        ->setCellValue('O'.$i, $banco)
                                        ->setCellValue('P'.$i, 'AHORROS')
                                        ->setCellValue('Q'.$i, $numcuenta);
                        }
                        else
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('N'.$i, '10')
                                        ->setCellValue('O'.$i, 'NINGUNO')
                                        ->setCellValue('P'.$i, 'NINGUNO')
                                        ->setCellValue('Q'.$i, 'NINGUNA');
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('R'.$i, $diastrab)
                                    ->setCellValue('S'.$i, number_format($sueldoper))
                                    ->setCellValue('T'.$i, number_format($auxtransp));

                        // Incluyo los recargos nocturnos
                        if($recargonoc > 0)
                        {
                            // Días de recargo nocturno
                            $vsql30 = "SELECT IFNULL(SUM(valor),0) AS valor
                                         FROM hisdetallenomina 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND conceptoid IN (47,56,59)  
                                              AND terid = ".$terid."
                                              AND pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND pernominaid IN ($listaperiodos)
                                                                             AND extralegal = 'CHECKED')";
                            $diasrecnoc = $clase->SeleccionarUno($vsql30);

                            $vsql31 = "SELECT IFNULL(SUM(valor),0) AS valor
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid = ".$terid."
                                              AND conceptoid IN (47,56,59)";
                            $diasrecnoc2 = $clase->SeleccionarUno($vsql31);

                            $diasrecnoc += $diasrecnoc2;

                            // Montos de los recargos nocturnos
                            $vsql33 = "SELECT IFNULL(SUM(devengados),0) AS devengados 
                                         FROM hisdetallenomina 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND conceptoid IN (47,56,59) 
                                              AND terid = ".$terid."
                                              AND pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND pernominaid IN ($listaperiodos)
                                                                             AND extralegal = 'CHECKED')";
                            $montorecargonoc = $clase->SeleccionarUno($vsql33);

                            $vsql34 = "SELECT IFNULL(SUM(devengados),0) AS devengados 
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid = ".$terid."
                                              AND conceptoid IN (47,56,59)";
                            $montorecargonoc2 = $clase->SeleccionarUno($vsql34);

                            $montorecargonoc += $montorecargonoc2;
                        }
                        else
                        {
                            $diasrecnoc = 0;
                            $montorecargonoc = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('U'.$i, $diasrecnoc)
                                    ->setCellValue('V'.$i, number_format($montorecargonoc));

                        // hora extra diurna
                        if($horaextradiurna > 0)
                        {
                            // cantidades
                            $cantidadhed = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 49 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidadhedliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 49");
                            $cantidaddehed = $cantidadhed + $cantidadhedliq;

                            // Montos
                            $montohoraextdiurna = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 49 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montohoraextdiurnaliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 49");
                            $montodehorasextrasdiura = $montohoraextdiurna + $montohoraextdiurnaliq;
                        }
                        else
                        {
                            $cantidaddehed = 0;
                            $montodehorasextrasdiura = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('W'.$i, $cantidaddehed)
                                    ->setCellValue('X'.$i, number_format($montodehorasextrasdiura));

                        // hora extra nocturna
                        if($horaextranocturna > 0)
                        {
                            // cantidades
                            $cantidadhen = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 50 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidadhenliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 50");
                            $cantidaddehen = $cantidadhen + $cantidadhenliq;

                            // Montos
                            $montohoraextnocturna = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 50 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montohoraextnocturnaliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 50");
                            $montohorextnoc = $montohoraextnocturna + $montohoraextnocturnaliq;
                        }
                        else
                        {
                            $cantidaddehen = 0;
                            $montohorextnoc = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('Y'.$i, $cantidaddehen)
                                    ->setCellValue('Z'.$i, number_format($montohorextnoc));

                        // hora extra diurna dominical
                        if($horaextradiurnadom > 0)
                        {
                            // cantidades
                            $cantidadhedd = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 51 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidadheddliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 51");
                            $cantidaddehedd = $cantidadhedd + $cantidadheddliq;

                            // Montos
                            $montohoraextddom = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 51 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montohoraextddomliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 51");
                            $montohoraextdiudom = $montohoraextddom + $montohoraextddomliq;
                        }
                        else
                        {
                            $cantidaddehedd = 0;
                            $montohoraextdiudom = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AA'.$i, $cantidaddehedd)
                                    ->setCellValue('AB'.$i, number_format($montohoraextdiudom));

                        // hora extra nocturna dominical y festivo
                        if($horaextradnocturnadomfes > 0)
                        {
                            // cantidades
                            $cantidadhendf = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 52 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidadhendfliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 52");
                            $cantidaddehendf = $cantidadhendf + $cantidadhendfliq;

                            // Montos
                            $montohendf = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 52 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montohendfliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 52");

                            $montodehendf = $montohendf + $montohendfliq;
                        }
                        else
                        {
                            $cantidaddehendf = 0;
                            $montodehendf = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AC'.$i, $cantidaddehendf)
                                    ->setCellValue('AD'.$i, number_format($montodehendf));

                        // domingos y festivos
                        if($domingosyfestivos > 0)
                        {
                            // cantidades
                            $cantidaddomfes = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 53 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidaddomfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 53");
                            $cantidaddedomfes = $cantidaddomfes + $cantidaddomfesliq;

                            // Montos
                            $montodomfes = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 53 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montodomfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 53");

                            $montodedomfes = $montodomfes + $montodomfesliq;
                        }
                        else
                        {
                            $cantidaddedomfes = 0;
                            $montodedomfes = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AE'.$i, $cantidaddedomfes)
                                    ->setCellValue('AF'.$i, number_format($montodedomfes));

                        // recargo nocturno dominical y festivo
                        if($recargonocdomfes > 0)
                        {
                            // cantidades
                            $cantidadrecnocdonfes = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 54 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidadrecnocdonfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 54");
                            $cantidadderecnocdonfes = $cantidadrecnocdonfes + $cantidadrecnocdonfesliq;

                            // Montos
                            $montorecnocdonfes = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 54 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montorecnocdonfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 54");

                            $montoderecnocdonfes = $montorecnocdonfes + $montorecnocdonfesliq;
                        }
                        else
                        {
                            $cantidadderecnocdonfes = 0;
                            $montoderecnocdonfes = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AG'.$i, $cantidadderecnocdonfes)
                                    ->setCellValue('AH'.$i, number_format($montoderecnocdonfes));

                        // Incluyo las incapacidades
                        if($numincap>0)
                        {
                            // Días de la(s) incapacidad(es)
                            $vsql5 = "SELECT IFNULL(SUM(valor),0) AS valor
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND conceptoid IN (10,40,43)
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal = 'CHECKED')";
                            $valorinc = $clase->SeleccionarUno($vsql5);

                            $vsql52 = "SELECT IFNULL(SUM(valor),0) AS valor
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid = ".$terid."
                                              AND conceptoid IN (10,40,43)";
                            $valorinc2 = $clase->SeleccionarUno($vsql52);

                            $valorinc += $valorinc2;

                            // Monto de la(s) incapacidad(es)
                            $vsql6 = "SELECT IFNULL(SUM(devengados),0) AS devengados 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND conceptoid IN (10,40)
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal = 'CHECKED')";
                            $devengadosinc = $clase->SeleccionarUno($vsql6);

                            $vsql62 = "SELECT IFNULL(SUM(devengados),0) AS devengados 
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid = ".$terid."
                                              AND conceptoid IN (10,40)";
                            $devengadosinc2 = $clase->SeleccionarUno($vsql62);

                            $devengadosinc += $devengadosinc2;

                            // --------------------------------------------------------------------------------------- //
                            $vsql105 = "SELECT c.nomconcepto AS nombreincapacidad
                                          FROM hisdetallenomina h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos) 
                                               AND c.conceptoid IN (10,40,43)
                                               AND h.terid = ".$terid."
                                               AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                           FROM periodoterceros
                                                                          WHERE periodoterceros.terid = ".$terid." 
                                                                                AND pernominaid IN ($listaperiodos)
                                                                                AND extralegal = 'CHECKED')
                                         UNION ALL
                                        SELECT c.nomconcepto AS nombreincapacidad
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos) 
                                               AND c.conceptoid IN (10,40,43)
                                               AND h.terid = ".$terid."";
                            $conex  = $clase->Conectar();
                            $result105 = mysql_query($vsql105,$conex);

                            $nombreincapacidad = "";
                            while($row105 = mysql_fetch_array($result105))
                            {
                                $nombreincapacidad.= $row105['nombreincapacidad'].", ";
                            }
                            $nombreincapacidad = substr($nombreincapacidad, 0, -2);
                            // --------------------------------------------------------------------------------------- //

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AI'.$i, $valorinc)
                                        ->setCellValue('AJ'.$i, $nombreincapacidad)
                                        ->setCellValue('AK'.$i, number_format($devengadosinc));
                        }
                        else
                        {
                            $valorinc = 0;
                            $devengadosinc = 0;
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AI'.$i, $valorinc)
                                        ->setCellValue('AJ'.$i, 'NINGUNA')
                                        ->setCellValue('AK'.$i, number_format($devengadosinc));
                        }

                        // Incluyo las licencias
                        if($numlicencias>0)
                        {
                            // Días de la(s) licencia(s)
                            $vsql3 = "SELECT IFNULL(SUM(h.valor),0) AS valorlic
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND c.eslicencia ='CHECKED' 
                                             AND c.tipodc = 'C' 
                                             AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $valorlic = $clase->SeleccionarUno($vsql3);

                            // -------------------------------------------------------------------------------------------------- //
                            $vsqllicnoremuneradas = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem
                                                       FROM hisdetallenomina 
                                                      WHERE pernominaid IN ($listaperiodos)
                                                        AND conceptoid = 6
                                                        AND terid = ".$terid."
                                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND pernominaid IN ($listaperiodos)
                                                                                       AND extralegal = 'CHECKED')";
                            $valorlicnorem = $clase->SeleccionarUno($vsqllicnoremuneradas);

                            $valorlic += $valorlicnorem;
                            // -------------------------------------------------------------------------------------------------- //

                            $vsql32 = "SELECT SUM(h.valor) AS valorlic
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia = 'CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                              AND h.terid = ".$terid;
                            $valorlic2 = $clase->SeleccionarUno($vsql32);

                            if($valorlic2==NULL)
                                $valorlic2 = 0;

                            // -------------------------------------------------------------------------------------------------- //
                            $vsqllicnoremuneradas2 = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem2
                                                        FROM detalleliquidacion 
                                                       WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid."
                                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                                   FROM periodoterceros
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND pernominaid IN ($listaperiodos)
                                                                                        AND extralegal = 'CHECKED')";
                            $valorlicnorem2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                            $valorlic2 += $valorlicnorem2;
                            // -------------------------------------------------------------------------------------------------- //

                            $valorlic += $valorlic2;

                            // Monto de la(s) licencia(s)
                            $vsql4 = "SELECT IFNULL(SUM(h.devengados),0) AS devengadoslic
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND c.eslicencia = 'CHECKED' 
                                             AND c.tipodc = 'C' 
                                             AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $devengadoslic = $clase->SeleccionarUno($vsql4);

                            $vsql42 = "SELECT IFNULL(SUM(h.devengados),0) AS devengadoslic
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia = 'CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                              AND h.terid = ".$terid;
                            $devengadoslic2 = $clase->SeleccionarUno($vsql42);

                            $devengadoslic += $devengadoslic2;

                            // Construyo la descripción de todas las licencias en el periodo
                            $vsql10 = "SELECT c.nomconcepto AS nombrelicencia
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia = 'CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58) 
                                              AND h.terid = ".$terid."
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')
                                        UNION ALL
                                       SELECT c.nomconcepto AS nombrelicencia
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia = 'CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58) 
                                              AND h.terid = ".$terid."
                                        UNION ALL
                                       SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia
                                         FROM hisdetallenomina h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid = 6
                                              AND h.terid = ".$terid."
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')
                                        UNION ALL
                                       SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid = 6
                                              AND h.terid = ".$terid."
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result10 = mysql_query($vsql10,$conex);

                            $nombrelicencia = "";
                            while($row10 = mysql_fetch_array($result10))
                            {
                                if($row10['nombrelicencia'] != "")
                                {
                                    if($row10['nombrelicencia'] != NULL)
                                        $nombrelicencia.= $row10['nombrelicencia'].", ";
                                }
                            }
                            $nombrelicencia = substr($nombrelicencia, 0, -2);

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AL'.$i, $nombrelicencia)
                                        ->setCellValue('AM'.$i, $valorlic)
                                        ->setCellValue('AN'.$i, number_format($devengadoslic));
                        }
                        else
                        {
                            $valorlic = 0;
                            $devengadoslic = 0;
                            $nombrelicencia = "NINGUNA";

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AL'.$i, $nombrelicencia)
                                        ->setCellValue('AM'.$i, $valorlic)
                                        ->setCellValue('AN'.$i, number_format($devengadoslic));
                        }

                        // Embargo
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AO'.$i, number_format($embargo));

                        // Otras deducciones
                        if($numotrasded>0)
                        {
                            // Monto de las otras deducciones
                            $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                              FROM hisdetallenomina h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                   AND h.terid = ".$terid."
                                                   AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND pernominaid IN ($listaperiodos)
                                                                                    AND extralegal = 'CHECKED')";
                            $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);

                            // Descripción de las deducciones
                            $vsql11 = "SELECT c.nomconcepto, h.descuentos
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                              AND h.terid = ".$terid."
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result11 = mysql_query($vsql11,$conex);

                            $nombreoc = "";                            
                            while($row11 = mysql_fetch_array($result11))
                            {
                                $nombreoc.= $row11['nomconcepto']." (".number_format($row11['descuentos'])."), ";
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
                        }
                        else
                        {
                            $nombreoc = "NINGUNO";
                            $montootrasdeduc = 0;
                        }

                        // ------------------------------------------------------------------------------------------------------------------------ //
                        // Otras deducciones en la tabla de liquidaciones
                        $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                     FROM detalleliquidacion h
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                          AND h.terid = ".$terid."";

                        $conex  = $clase->Conectar();
                        $result77 = mysql_query($vsql77,$conex);
                        $tienedesliq = mysql_num_rows($result77);

                        if($tienedesliq>0)
                        {
                            if($nombreoc=="NINGUNO")
                                $nombreoc = "";
                            else
                                $nombreoc.=", ";

                            while($row77 = mysql_fetch_array($result77))
                            {
                                $nombreoc.= $row77['nomconcepto']." (".number_format($row77['descuentos'])."), ";
                                $montootrasdeduc += $row77['descuentos'];
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AP'.$i, $nombreoc)
                                    ->setCellValue('AQ'.$i, number_format($montootrasdeduc));
                        // ------------------------------------------------------------------------------------------------------------------------ //

                        // Continuamos con salud y pensión
                        $objPHPExcel->setActiveSheetIndex(0)                                    
                                    ->setCellValue('AR'.$i, $por_sal_tra)
                                    ->setCellValue('AS'.$i, number_format($salud))
                                    ->setCellValue('AT'.$i, $por_pen_tra)
                                    ->setCellValue('AU'.$i, number_format($pension));

                        // Incluyo las sanciones
                        if($numsanciones>0)
                        {
                            // Valor de la sanción
                            $vsql6 = "SELECT SUM(h.descuentos) AS montosancion
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid = 9
                                             AND h.terid = ".$terid;
                            $montosancion = $clase->SeleccionarUno($vsql6);

                            // Monto de la sanción
                            $vsql7 = "SELECT c.nomconcepto
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid = 9
                                             AND h.terid = ".$terid;
                            $conceptosancion = $clase->SeleccionarUno($vsql7);

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AV'.$i, number_format($montosancion))
                                        ->setCellValue('AW'.$i, $conceptosancion);
                        }
                        else
                        {
                            $montosancion = 0;
                            $conceptosancion = "NINGUNA";

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AV'.$i, number_format($montosancion))
                                        ->setCellValue('AW'.$i, $conceptosancion);
                        }

                        // Incluyo las libranzas
                        if($numlibranzas>0)
                        {
                            $vsql8 = "SELECT SUM(h.descuentos) AS montolibranza
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED') 
                                             AND h.terid = ".$terid."
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $montolibranza = $clase->SeleccionarUno($vsql8);

                            $vsql9 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED') 
                                             AND h.terid = ".$terid."
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result9 = mysql_query($vsql9,$conex);
                            $nombrelibranza = "";
                            while($row9 = mysql_fetch_array($result9))
                            {
                                $nombrelibranza.= $row9['nomconcepto']." (".number_format($row9['descuentos'])."), ";
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
                        }
                        else
                        {
                            $montolibranza = 0;
                            $nombrelibranza = "NINGUNA";
                        }

                        // libranzas en liquidación
                        $vsql888 = "SELECT c.nomconcepto, h.descuentos  
                                      FROM detalleliquidacion h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid IN ($listaperiodos)
                                           AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                           AND h.terid = ".$terid."
                                           AND c.conceptoid NOT IN (10,30)";

                        $conex  = $clase->Conectar();
                        $result88 = mysql_query($vsql888,$conex);
                        $tienelibliq = mysql_num_rows($result88);

                        if($tienelibliq>0)
                        {
                            if($nombrelibranza=="NINGUNA")
                                $nombrelibranza = "";
                            else
                                $nombrelibranza.=", ";

                            while($row88 = mysql_fetch_array($result88))
                            {
                                $nombrelibranza.= $row88['nomconcepto']." (".number_format($row88['descuentos'])."), ";
                                $montolibranza += $row88['descuentos'];
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
                        }                        

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AX'.$i, $nombrelibranza)
                                    ->setCellValue('AY'.$i, number_format($montolibranza));

                        // Aquí obtengo los valores de la liquidación

                        // Primas
                        $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $numprimas = $clase->SeleccionarUno($vsqlnumprimas);

                        if($numprimas>0)
                        {
                            // Días de la prima
                            $vsqlcanprimas = "SELECT cantidad AS canprimas
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'primas'";
                            $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                            // Pago de la prima
                            $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                                 FROM liquidacion
                                                WHERE terid = ".$terid."
                                                      AND periodonomina = '".$codperiodo."' 
                                                      AND tipo = 'primas'";
                            $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);

                            $devengados += $pagoprimas;
                        }
                        else
                        {
                            $canprimas = 0;
                            $pagoprimas = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AZ'.$i, number_format($canprimas))
                                    ->setCellValue('BA'.$i, number_format($pagoprimas));

                        // Cesantías
                        $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);

                        if($numcesantias>0)
                        {
                            // Pago de la cesantía
                            $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);

                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia += $montopagocesan;
                            }

                            // Porcentaje cesantía
                            $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);

                            // Pago de intereses de cesantías
                            $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'cesantias'";
                            $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);

                            $devengados += $pagocesantia;
                            $devengados += $pagointereses;
                        }
                        else
                        {
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia = $montopagocesan;
                                $devengados += $pagocesantia;
                            }
                            else
                                $pagocesantia = 0;
                            
                            $porccesantia = 0;
                            $pagointereses = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('BB'.$i, number_format($pagocesantia))
                                    ->setCellValue('BC'.$i, number_format($porccesantia))
                                    ->setCellValue('BD'.$i, number_format($pagointereses));

                        // Vacaciones                            
                        if($numvacacionest>0)
                        {
                            if($numvacaciones1 > 0)
                            {
                                // Días de vacaciones
                                $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                        FROM liquidacion
                                                       WHERE terid = ".$terid."
                                                             AND periodonomina = '".$codperiodo."' 
                                                             AND tipo = 'vacaciones'";
                                $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                                // Pago de vacaciones
                                $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'vacaciones'";
                                $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                            }
                            else
                            {
                                $canvacaciones = 0;
                                $pagovaca1 = 0;
                            }

                            if($numvacaciones2>0)
                            {
                                $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                    FROM hisdetallenomina  
                                                   WHERE terid = ".$terid."
                                                         AND conceptoid = 38 
                                                         AND pernominaid IN ($listaperiodos)";
                                $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                            }
                            else
                                $pagovaca2 = 0;
                            
                            if($canvacaciones == 0)               $canvacaciones = 1;
                            $pagovaca = $pagovaca1 + $pagovaca2;

                            $devengados += $pagovaca1;
                        }
                        else
                        {
                            $canvacaciones = 0;
                            $pagovaca = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('BE'.$i, number_format($canvacaciones,2))
                                    ->setCellValue('BF'.$i, number_format($pagovaca));

                        // indemnización
                        if($numindemnizacion>0)
                        {
                            $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                                    FROM liquidacion
                                                   WHERE terid=".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'indemnizacion'";
                            $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);

                            $devengados += $indemnizacion;
                        }
                        else
                            $indemnizacion = 0;

                        $objPHPExcel->setActiveSheetIndex(0)                                    
                                    ->setCellValue('BG'.$i, number_format($indemnizacion));

                        // otros devengados
                        if($numotrosdeven>0)
                        {
                            $vsqlotrosdeven = "SELECT SUM(IF(h.conceptoid IN (37,48),h.devengados,0)) AS otrosdeven
                                                 FROM hisdetallenomina h
                                                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                                WHERE h.pernominaid IN ($listaperiodos)                                                      
                                                      AND h.terid = ".$terid."
                                                      AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND pernominaid IN ($listaperiodos)
                                                                                       AND extralegal = 'CHECKED')";
                            $otrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
                        }
                        else
                            $otrosdeven = 0;

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('BH'.$i, number_format($otrosdeven));

                        // dotaciones
                        if(strlen($montodotacion)>0)
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('BI'.$i, number_format($montodotacion));
                            $devengados += $montodotacion;
                        }
                        else
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('BI'.$i, 0);

                        $neto = $devengados - $descuentos;

                        // Totales
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('BJ'.$i, number_format($devengados))
                                    ->setCellValue('BK'.$i, number_format($descuentos))
                                    ->setCellValue('BL'.$i, number_format($neto));

                        // Incremento el contador de líneas
                        $i++;
                        $listadereportados.= $terid.",";
                    }
                }
            }
            $listadereportados = substr($listadereportados, 0, -1);

            $rangoEncabezado = 'A9:BL9';
            $rangoCeldas     = 'A9:BL'.($i-1);
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Ciclo para procesar a los empleados liquidados que trabajaron una quincena

        $primquin = substr($listaperiodos,0,2);
        $segnquin = substr($listaperiodos,-2);

        $vsqlliq ="SELECT DISTINCT terid 
                     FROM detalleliquidacion 
                    WHERE pernominaid IN ($listaperiodos)
                          AND terid NOT IN (SELECT terid
                                              FROM hisdetallenomina
                                             WHERE pernominaid IN ($listaperiodos)) ";

        if(strlen($listadereportados)>0)
            $vsqlliq.= " AND terid NOT IN ($listadereportados) ";

        if(strlen($nodebensalir) > 0)
            $vsqlliq.= " AND terid NOT IN ($nodebensalir) ";            

        $vsqlliq.= " UNION ALL 
                    SELECT p.terid
                      FROM periodoterceros p
                     WHERE p.extralegal = 'CHECKED'
                           AND p.pernominaid IN ($listaperiodos)
                           AND p.terid IN (SELECT terid
                                             FROM detalleliquidacion
                                            WHERE terid = p.terid
                                                  AND pernominaid IN ($listaperiodos))";
        // ---------------------------------------------------------------------------------- //

        if(strlen($listadereportados)>0)
            $vsqlliq.= " AND p.terid NOT IN ($listadereportados) ";

        if(strlen($nodebensalir) > 0)
            $vsqlliq.= " AND p.terid NOT IN ($nodebensalir) ";

        $conex  = $clase->Conectar();
        $resultliq = mysql_query($vsqlliq,$conex);
        $empleadosreportarliq = mysql_num_rows($resultliq);

        // $empleadosreportarliq = 0;      $j = 2;
        $j = $i;

        if($empleadosreportarliq>0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";                            $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $numlicencias = 0;                              $listadereportados.= ",";
            $vsqlvextralegal = "";                          $numnomext = 0;                                 $vsqlnumvacaciones2 = "";
            $numvacaciones2 = 0;                            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;
            $vsqlrecargonoc = "";                           $recargonoc = 0;                                $vsqlrecargonocliq = "";
            $recargonocliq = 0;                             $vsqlexiste = "";                               $existe = 0;
            $horaextradiurnaliq = 0;                        $horaextranocturnaliq = 0;                      $horaextradiurnadomliq = 0;
            $horaextradnocturnadomfesliq = 0;               $domingosyfestivosliq = 0;
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;

            while($rowliq = mysql_fetch_array($resultliq))
            {
                // id del empleado
                $terid = $rowliq['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal = 'CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);

                $vsqlexiste = "SELECT COUNT(*) existe FROM terceros WHERE terid = ".$terid;
                $existe = $clase->SeleccionarUno($vsqlexiste);
                
                if(($numnomext<2) && ($existe > 0))
                {
                    // días trabajados
                    $vsqldiasliq = "SELECT SUM(IF(conceptoid = 1,valor,0)) AS diastrabliq 
                                      FROM detalleliquidacion 
                                     WHERE pernominaid IN ($listaperiodos) 
                                           AND terid = ".$terid."";
                    $diastrabliq = $clase->SeleccionarUno($vsqldiasliq);
    
                    // Documento del empleado
                    $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                    // Primer apellido
                    $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                    // Segundo apellido
                    $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                    // Primer nombre
                    $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                    // Segundo nombre
                    $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                    // Sueldo básico
                    $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                    // Código del trabajador
                    $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                    // Correo electrónico
                    $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                    // Teléfono
                    $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                    // Número de cuenta
                    $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
    
                    // Tipo de documento
                    $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                    // Banco
                    $vsqlbanco = "SELECT b.descripcion AS banco
                                    FROM periodoterceros p
                                         INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                   WHERE p.terid = ".$terid;
                    $banco = $clase->SeleccionarUno($vsqlbanco);
                    $banco = trim(str_replace("BANCO ","",$banco));
    
                    // cargo del empleado
                    $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
    
                    $vsqlsueldoliq = "SELECT IFNULL(devengados,0) AS sueldoliq
                                        FROM detalleliquidacion
                                       WHERE terid = ".$terid."
                                             AND conceptoid = 1
                                             AND pernominaid IN ($listaperiodos)";
                    $sueldoliq = $clase->SeleccionarUno($vsqlsueldoliq);
                    if($sueldoliq=="")          $sueldoliq = 0;
    
                    // auxilio de transporte
                    $vsqltransliq = "SELECT IFNULL(devengados,0) AS transliq
                                       FROM detalleliquidacion
                                      WHERE terid = ".$terid."
                                            AND conceptoid IN (3,45)
                                            AND pernominaid IN ($listaperiodos)";
                    $transliq = $clase->SeleccionarUno($vsqltransliq);
                    if($transliq=="")  $transliq = 0;

                    // Recargo nocturno
                    $vsqlrecargonocliq = "SELECT IFNULL(devengados,0) AS transliq
                                            FROM detalleliquidacion
                                           WHERE terid = ".$terid."
                                                 AND conceptoid IN (47,56,59) 
                                                 AND pernominaid IN ($listaperiodos)";
                    $recargonocliq = $clase->SeleccionarUno($vsqlrecargonocliq);

                    if($recargonocliq=="")  $recargonocliq = 0;

                    // hora extra diurna
                    $horaextradiurnaliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 49,devengados,0)) AS horaextradiurnaliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                    // hora extra nocturna
                    $horaextranocturnaliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 50,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                    // hora extra diurna dominical
                    $horaextradiurnadomliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 51,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                    // hora extra nocturna dominical y festivo
                    $horaextradnocturnadomfesliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 52,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                    // domingos y festivos
                    $domingosyfestivosliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 53,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                    // recargo nocturno dominical y festivo
                    $recargonocdomfesliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 54,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");
    
                    // embargo
                    $vsqlembliq = "SELECT IFNULL(SUM(descuentos),0) AS embliq
                                     FROM detalleliquidacion
                                    WHERE terid = ".$terid."
                                          AND conceptoid = 30
                                          AND pernominaid IN ($listaperiodos)";
                    $embliq = $clase->SeleccionarUno($vsqlembliq);                    
    
                    // salud
                    $vsqlsaludliq = "SELECT IFNULL(descuentos,0) AS saludliq
                                       FROM detalleliquidacion
                                      WHERE terid = ".$terid."
                                            AND conceptoid = 5
                                            AND pernominaid IN ($listaperiodos)";
                    $saludliq = $clase->SeleccionarUno($vsqlsaludliq);
                    if($saludliq=="")  $saludliq = 0;
    
                    // pensión
                    $vsqlpesionliq = "SELECT IFNULL(descuentos,0) AS pesionliq
                                        FROM detalleliquidacion
                                       WHERE terid = ".$terid."
                                             AND conceptoid = 4
                                             AND pernominaid IN ($listaperiodos)";
                    $pesionliq = $clase->SeleccionarUno($vsqlpesionliq);
                    if($pesionliq=="")  $pesionliq = 0;
    
                    // total devengado
                    $vsqldevliq = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                     FROM detalleliquidacion 
                                    WHERE terid = ".$terid."
                                          AND pernominaid IN ($listaperiodos) ";
                    $devengados = $clase->SeleccionarUno($vsqldevliq);
    
                    // total descuentos
                    $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                      FROM detalleliquidacion 
                                     WHERE pernominaid IN ($listaperiodos) 
                                           AND terid = ".$terid."";
                    $descuentos = $clase->SeleccionarUno($vsqldescliq);
    
                    // neto a pagar
                    $neto = $devengados - $descuentos;
    
                    // Obtengo la fecha de ingreso del empleado
                    $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
    
                    // libranzas
                    $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                           FROM detalleliquidacion h
                                                INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                          WHERE h.pernominaid IN ($listaperiodos)
                                                AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                                AND h.terid = ".$terid."
                                                AND c.conceptoid NOT IN (10,30)";
                    $numlibranzasliq = $clase->SeleccionarUno($vsqllibranzasliq);
    
                    // otras deducciones
                    $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41,43,58)
                                                 AND h.terid = ".$terid."";
                    $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);
    
                    // Vacaciones
                    $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'vacaciones'";
                    $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                    // Vacaciones pagadas en quincenas
                    $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2
                                             FROM hisdetallenomina 
                                            WHERE terid = ".$terid."
                                                  AND conceptoid = 38 
                                                  AND pernominaid IN ($listaperiodos)";
                    $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                    $numvacacionest = $numvacaciones1 + $numvacaciones2;                    
    
                    // Primas
                    $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                        FROM liquidacion
                                       WHERE terid = ".$terid."
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'primas'";
                    $numprimas = $clase->SeleccionarUno($vsqlnumprimas);
    
                    // Cesantías
                    $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                           FROM liquidacion
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'cesantias'";
                    $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);
    
                    // indemnización
                    $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'indemnizacion'";
                    $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                    // Otros conceptos devengados
                    $vsqlotrosdevenliq = "SELECT COUNT(h.conceptoid) AS numotrosdevenliq
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid IN (37,48) 
                                                 AND h.terid = ".$terid."";
                    $numotrosdevenliq = $clase->SeleccionarUno($vsqlotrosdevenliq);
    
                    // ------------------------------------------------------------------------------------------------------------------------------------ //
                    // Dotaciones 
                    $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                         FROM dotaciones
                                        WHERE periodonomina = '".$codperiodo."'
                                              AND terid = ".$terid."";
                    $montodotacion = $clase->SeleccionarUno($vsqldotaciones);
    
                    // Licencias
                    $vsqlincapacidad = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND c.eslicencia = 'CHECKED' 
                                               AND c.tipodc = 'C' 
                                               AND h.conceptoid NOT IN (10,9,43,40,58) 
                                               AND h.terid = ".$terid."";
                    $numlicencias = $clase->SeleccionarUno($vsqlincapacidad);

                    $vsqllicnoremuneradas2 = "SELECT COUNT(conceptoid) AS licnoremuneradas2 
                                                FROM detalleliquidacion 
                                               WHERE pernominaid IN ($listaperiodos)
                                                     AND conceptoid = 6
                                                     AND terid = ".$terid;
                    $licnoremuneradas2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                    $numlicencias += $licnoremuneradas2;

                    // Incapacidades del periodo
                    $vsqlincapacidad = "SELECT COUNT(*) AS numincap
                                          FROM detalleliquidacion 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND conceptoid IN (10,43,40)";
                    $numincap = $clase->SeleccionarUno($vsqlincapacidad);
    
                    // $j = $i;

                    $celda1="A".strval($j);             $celda2="B".strval($j);             $celda3="C".strval($j);             $celda4="D".strval($j);
                    $celda5="E".strval($j);             $celda6="F".strval($j);             $celda7="G".strval($j);             $celda8="H".strval($j);
                    $celda9="I".strval($j);             $celda10="J".strval($j);            $celda11="K".strval($j);            $celda12="L".strval($j);
                    $celda13="M".strval($j);            $celda14="N".strval($j);            $celda15="O".strval($j);            $celda16="P".strval($j);
                    $celda17="Q".strval($j);            $celda18="R".strval($j);            $celda19="S".strval($j);            $celda20="T".strval($j);
                    $celda21="U".strval($j);            $celda22="V".strval($j);            $celda23="W".strval($j);            $celda24="X".strval($j);
                    $celda25="Y".strval($j);            $celda26="Z".strval($j);            $celda27="AA".strval($j);           $celda28="AB".strval($j);
                    $celda29="AC".strval($j);           $celda30="AD".strval($j);           $celda31="AE".strval($j);           $celda32="AF".strval($j);
                    $celda33="AG".strval($j);           $celda34="AH".strval($j);           $celda35="AI".strval($j);           $celda36="AJ".strval($j);
                    $celda37="AK".strval($j);           $celda38="AL".strval($j);           $celda39="AM".strval($j);           $celda40="AN".strval($j);
                    $celda41="AO".strval($j);           $celda42="AP".strval($j);           $celda43="AQ".strval($j);           $celda44="AR".strval($j);
                    $celda45="AS".strval($j);           $celda46="AT".strval($j);           $celda47="AU".strval($j);           $celda48="AV".strval($j);
                    $celda49="AW".strval($j);           $celda50="AX".strval($j);           $celda51="AY".strval($j);           $celda52="AZ".strval($j);
                    $celda53="BA".strval($j);           $celda54="BB".strval($j);           $celda55="BC".strval($j);           $celda56="BD".strval($j);
                    $celda57="BE".strval($j);           $celda58="BF".strval($j);           $celda59="BG".strval($j);           $celda60="BH".strval($j);
                    $celda61="BI".strval($j);           $celda62="BJ".strval($j);           $celda63="BK".strval($j);           $celda64="BL".strval($j);
    
                    // Escribo en la hoja de Excel
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda1, $fecingreso)
                                ->setCellValue($celda2, '01')
                                ->setCellValue($celda3, '00')
                                ->setCellValue($celda4, 'true')
                                ->setCellValue($celda5,'13')
                                ->setCellValue($celda6, $dni)
                                ->setCellValue($celda7, $primerapellido)
                                ->setCellValue($celda8, $segundoapellido)
                                ->setCellValue($celda9, $primernombre)
                                ->setCellValue($celda10, $segundonombre)
                                ->setCellValue($celda11, number_format($basico))
                                ->setCellValue($celda12, $codvende)
                                ->setCellValue($celda13, '1');
    
                    // Identifico la forma de pago
                    if($numcuenta!="")
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda14, '45')
                                    ->setCellValue($celda15, $banco)
                                    ->setCellValue($celda16, 'AHORROS')
                                    ->setCellValue($celda17, $numcuenta);
                    }
                    else
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda14, '10')
                                    ->setCellValue($celda15, 'NINGUNO')
                                    ->setCellValue($celda16, 'NINGUNO')
                                    ->setCellValue($celda17, 'NINGUNA');
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda18, $diastrabliq)
                                ->setCellValue($celda19, number_format($sueldoliq))
                                ->setCellValue($celda20, number_format($transliq));

                    // Incluyo los recargos nocturnos
                    if($recargonocliq > 0)
                    {
                        // Días de recargo nocturno
                        $vsql30 = "SELECT IFNULL(SUM(valor),0) AS valor
                                     FROM detalleliquidacion 
                                    WHERE pernominaid IN ($listaperiodos) 
                                          AND conceptoid IN (47,56,59) 
                                          AND terid = ".$terid;
                        $diasrecnoc = $clase->SeleccionarUno($vsql30);

                        $vsql33 = "SELECT IFNULL(SUM(devengados),0) AS devengados 
                                     FROM detalleliquidacion 
                                    WHERE pernominaid IN ($listaperiodos) 
                                          AND conceptoid IN (47,56,59)  
                                          AND terid = ".$terid;
                        $montorecargonoc = $clase->SeleccionarUno($vsql33);
                    }
                    else
                    {
                        $diasrecnoc = 0;
                        $montorecargonoc = 0;
                    }

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda21, $diasrecnoc)
                                ->setCellValue($celda22, number_format($montorecargonoc));

                    // hora extra diurna
                    if($horaextradiurnaliq > 0)
                    {
                        $cantidadhedliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 49");
                        $montohoraextdiurnaliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 49");
                    }
                    else
                    {
                        $cantidadhedliq = 0;
                        $montohoraextdiurnaliq = 0;
                    }

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda23, $cantidadhedliq)
                                ->setCellValue($celda24, number_format($montohoraextdiurnaliq));

                    // hora extra nocturna
                    if($horaextranocturnaliq > 0)
                    {
                        $cantidadhenliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 50");
                        $montohoraextnocturnaliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 50");
                    }
                    else
                    {
                        $cantidadhenliq = 0;
                        $montohoraextnocturnaliq = 0;
                    }

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda25, $cantidadhenliq)
                                ->setCellValue($celda26, number_format($montohoraextnocturnaliq));

                    // hora extra diurna dominical
                    if($horaextradiurnadomliq > 0)
                    {
                        $cantidadheddliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 51");
                        $montohoraextddomliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 51");
                    }
                    else
                    {
                        $cantidadheddliq = 0;
                        $montohoraextddomliq = 0;
                    }

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda27, $cantidadheddliq)
                                ->setCellValue($celda28, number_format($montohoraextddomliq));

                    // hora extra nocturna dominical y festivo
                    if($horaextradnocturnadomfesliq > 0)
                    {
                        $cantidadhendfliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 52");
                        $montohendfliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 52");
                    }
                    else
                    {
                        $cantidadhendfliq = 0;
                        $montohendfliq = 0;
                    }                    

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda29, $cantidadhendfliq)
                                ->setCellValue($celda30, number_format($montohendfliq));

                    // domingos y festivos
                    if($domingosyfestivosliq > 0)
                    {
                        $cantidaddomfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 53");
                        $montodomfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 53");
                    }
                    else
                    {
                        $cantidaddomfesliq = 0;
                        $montodomfesliq = 0;
                    }

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda31, $cantidaddomfesliq)
                                ->setCellValue($celda32, number_format($montodomfesliq));

                    // recargo nocturno dominical y festivo
                    if($recargonocdomfesliq > 0)
                    {
                        $cantidadrecnocdonfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 54");
                        $montorecnocdonfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 54");
                    }
                    else
                    {
                        $cantidadrecnocdonfesliq = 0;
                        $montorecnocdonfesliq = 0;
                    }

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda33, $cantidadrecnocdonfesliq)
                                ->setCellValue($celda34, number_format($montorecnocdonfesliq));
    
                    // Incluyo las incapacidades
                    if($numincap>0)
                    {
                        // Días de la(s) incapacidad(es)
                        $vsql5 = "SELECT IFNULL(SUM(valor),0) AS valor
                                    FROM detalleliquidacion 
                                   WHERE pernominaid IN ($listaperiodos) 
                                         AND conceptoid IN (10,43,40) 
                                         AND terid = ".$terid;
                        $valorinc = $clase->SeleccionarUno($vsql5);
    
                        // Monto de la(s) incapacidad(es)
                        $vsql6 = "SELECT IFNULL(SUM(devengados),0) AS devengados 
                                    FROM detalleliquidacion 
                                   WHERE pernominaid IN ($listaperiodos) 
                                         AND conceptoid IN (10,43,40)
                                         AND terid = ".$terid;
                        $devengadosinc = $clase->SeleccionarUno($vsql6);

                        // --------------------------------------------------------------------------------------- //
                        $vsql105 = "SELECT c.nomconcepto AS nombreincapacidad
                                      FROM detalleliquidacion h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid IN ($listaperiodos) 
                                           AND c.conceptoid IN (10,43,40)
                                           AND h.terid = ".$terid."";
                        $conex  = $clase->Conectar();
                        $result105 = mysql_query($vsql105,$conex);

                        $nombreincapacidad = "";
                        while($row105 = mysql_fetch_array($result105))
                        {
                            $nombreincapacidad.= $row105['nombreincapacidad'].", ";
                        }
                        $nombreincapacidad = substr($nombreincapacidad, 0, -2);
                        // --------------------------------------------------------------------------------------- //
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda35, $valorinc)
                                    ->setCellValue($celda36, $nombreincapacidad)
                                    ->setCellValue($celda37, number_format($devengadosinc));
                    }
                    else
                    {
                        $valorinc = 0;
                        $devengadosinc = 0;
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda35, $valorinc)
                                    ->setCellValue($celda36, 'NINGUNA')
                                    ->setCellValue($celda37, number_format($devengadosinc));
                    }
    
                    // Incluyo las licencias
                    if($numlicencias>0)
                    {
                        // Días de la(s) licencia(s)
                        $vsql3 = "SELECT IFNULL(SUM(h.valor),0) AS valorlic
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND c.eslicencia = 'CHECKED' 
                                         AND c.tipodc = 'C' 
                                         AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                         AND h.terid = ".$terid;
                        $valorlic = $clase->SeleccionarUno($vsql3);

                        $vsqllicnoremuneradas2 = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem2
                                                    FROM detalleliquidacion 
                                                   WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid;
                        $valorlicnorem2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                        $valorlic += $valorlicnorem2;
    
                        // Monto de la(s) licencia(s)
                        $vsql4 = "SELECT IFNULL(SUM(h.devengados),0) AS devengadoslic
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND c.eslicencia = 'CHECKED' 
                                         AND c.tipodc = 'C' 
                                         AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                         AND h.terid = ".$terid;
                        $devengadoslic = $clase->SeleccionarUno($vsql4);
    
                        // Construyo la descripción de todas las licencias en el periodo
                        $vsql10 = "SELECT c.nomconcepto AS nombrelicencia
                                     FROM detalleliquidacion h
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND c.eslicencia = 'CHECKED' 
                                          AND c.tipodc = 'C' 
                                          AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                          AND h.terid = ".$terid."
                                    UNION ALL
                                   SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia
                                     FROM detalleliquidacion h 
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid = 6
                                          AND h.terid = ".$terid;
                                            
                        $conex  = $clase->Conectar();
                        $result10 = mysql_query($vsql10,$conex);
    
                        $nombrelicencia = "";
                        while($row10 = mysql_fetch_array($result10))
                        {
                            $nombrelicencia.= $row10['nombrelicencia'].", ";
                        }
                        $nombrelicencia = substr($nombrelicencia, 0, -2);
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda38, $nombrelicencia)
                                    ->setCellValue($celda39, $valorlic)
                                    ->setCellValue($celda40, number_format($devengadoslic));
                    }
                    else
                    {
                        $valorlic = 0;
                        $devengadoslic = 0;
                        $nombrelicencia = "NINGUNA";
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda38, $nombrelicencia)
                                    ->setCellValue($celda39, $valorlic)
                                    ->setCellValue($celda40, number_format($devengadoslic));
                    }
    
                    // Embargo
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda41, number_format($embliq));
    
                    // Otras deducciones
                    if($numotrasdedliq>0)
                    {
                        // Monto de las otras deducciones
                        $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                               AND h.terid = ".$terid;
                        $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                        // Descripción de las deducciones
                        $vsql11 = "SELECT c.nomconcepto, h.descuentos
                                     FROM detalleliquidacion h
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                          AND h.terid = ".$terid;
                        $conex  = $clase->Conectar();
                        $result11 = mysql_query($vsql11,$conex);
    
                        $nombreoc = "";
                        while($row11 = mysql_fetch_array($result11))
                        {
                            $nombreoc.= $row11['nomconcepto']." (".number_format($row11['descuentos'])."), ";
                        }
                        $nombreoc = substr($nombreoc, 0, -2);
                    }
                    else
                    {
                        $nombreoc = "NINGUNO";
                        $montootrasdeduc = 0;
                    }
                    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda42, $nombreoc)
                                ->setCellValue($celda43, number_format($montootrasdeduc));
    
                    // Continuamos con salud y pensión
                    $objPHPExcel->setActiveSheetIndex(0)                                    
                                ->setCellValue($celda44, $por_sal_tra)
                                ->setCellValue($celda45, number_format($saludliq))
                                ->setCellValue($celda46, $por_pen_tra)
                                ->setCellValue($celda47, number_format($pesionliq));
    
                    // sanciones
                    $montosancion = 0;
                    $conceptosancion = "NINGUNA";
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda48, number_format($montosancion))
                                ->setCellValue($celda49, $conceptosancion);
    
                    if($numlibranzasliq>0)
                    {
                        $vsql8 = "SELECT SUM(h.descuentos) AS montolibranza
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                         AND h.terid = ".$terid."
                                         AND c.conceptoid NOT IN (10,30)";
                        $montolibranza = $clase->SeleccionarUno($vsql8);
    
                        $vsql9 = "SELECT c.nomconcepto, h.descuentos  
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                         AND h.terid = ".$terid."
                                         AND c.conceptoid NOT IN (10,30)";
    
                        $conex  = $clase->Conectar();
                        $result9 = mysql_query($vsql9,$conex);
    
                        $nombrelibranza = "";
                        while($row9 = mysql_fetch_array($result9))
                        {
                            $nombrelibranza.= $row9['nomconcepto']." (".number_format($row9['descuentos'])."), ";
                        }
                        $nombrelibranza = substr($nombrelibranza, 0, -2);
                    }
                    else
                    {
                        $nombrelibranza = "NINGUNA";
                        $montolibranza = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda50, $nombrelibranza)
                                ->setCellValue($celda51, number_format($montolibranza));
    
                    // primas
                    if($numprimas>0)
                    {
                        // Días de la prima
                        $vsqlcanprimas = "SELECT cantidad AS canprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                        // Pago de la prima
                        $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                             FROM liquidacion
                                            WHERE terid = ".$terid."
                                                  AND periodonomina = '".$codperiodo."' 
                                                  AND tipo = 'primas'";
                        $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);
    
                        $devengados += $pagoprimas;
                    }
                    else
                    {
                        $canprimas = 0;
                        $pagoprimas = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda52, number_format($canprimas))
                                ->setCellValue($celda53, number_format($pagoprimas));
    
                    // Cesantías
                    if($numcesantias>0)
                    {
                        // Pago de la cesantía
                        $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);
    
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        if($numpagocesan>0)
                        {
                            $vsqlnumpagocesan = "";
                            $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                            $pagocesantia += $montopagocesan;
                        }
    
                        // Porcentaje cesantía
                        $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);
    
                        // Pago de intereses de cesantías
                        $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'cesantias'";
                        $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);
    
                        $devengados += $pagocesantia;
                        $devengados += $pagointereses;
                    }
                    else
                    {
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        if($numpagocesan>0)
                        {
                            $vsqlnumpagocesan = "";
                            $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                            $pagocesantia = $montopagocesan;
                            $devengados += $pagocesantia;
                        }
                        else
                            $pagocesantia = 0;
    
                        $porccesantia = 0;
                        $pagointereses = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda54, number_format($pagocesantia))
                                ->setCellValue($celda55, number_format($porccesantia))
                                ->setCellValue($celda56, number_format($pagointereses));
    
                    // vacaciones
                    if($numvacacionest>0)
                    {
                        if($numvacaciones1 > 0)
                        {
                            // Días de vacaciones
                            $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'vacaciones'";
                            $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                            // Pago de vacaciones
                            $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'vacaciones'";
                            $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                        }
                        else
                        {
                            $canvacaciones = 0;
                            $pagovaca1 = 0;
                        }

                        if($numvacaciones2>0)
                        {
                            $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                FROM hisdetallenomina  
                                               WHERE terid = ".$terid."
                                                     AND conceptoid = 38 
                                                     AND pernominaid IN ($listaperiodos)";
                            $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                        }
                        else
                            $pagovaca2 = 0;
                        
                        if($canvacaciones == 0)               $canvacaciones = 1;
                        $pagovaca = $pagovaca1 + $pagovaca2;    
                        $devengados += $pagovaca1;
                    }
                    else
                    {
                        $canvacaciones = 0;
                        $pagovaca = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda57, number_format($canvacaciones,2))
                                ->setCellValue($celda58, number_format($pagovaca));
    
                    // indemnización
                    if($numindemnizacion>0)
                    {
                        $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                        $devengados += $indemnizacion;
                    }
                    else
                        $indemnizacion = 0;
    
                    $objPHPExcel->setActiveSheetIndex(0)                                    
                                ->setCellValue($celda59, number_format($indemnizacion));
    
                    // otros devengados
                    if($numotrosdevenliq>0)
                    {
                        $vsqlotrosdeven = "SELECT SUM(IF(h.conceptoid IN (37,48),h.devengados,0)) AS otrosdeven
                                             FROM detalleliquidacion h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)                                                      
                                                  AND h.terid=".$terid;
                        $otrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
                    }
                    else                        
                        $otrosdeven = 0;
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda60, number_format($otrosdeven));
    
                    // dotaciones
                    if(strlen($montodotacion)>0)
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda61, number_format($montodotacion));
                        $devengados += $montodotacion;
                    }
                    else
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda61, 0);

                    $neto = $devengados - $descuentos;
    
                    // Totales
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda62, number_format($devengados))
                                ->setCellValue($celda63, number_format($descuentos))
                                ->setCellValue($celda64, number_format($neto));
    
                    // Incremento el contador de líneas
                    $j++;
                    $listadereportados.= $terid.",";
                }
            }

            $listadereportados = substr($listadereportados, 0, -1);

            $rangoEncabezado = 'A9:BL9';
            $rangoCeldas     = 'A9:BL'.($j-1);
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Ciclo para los empleados que trabajaron ambas quincenas y también tienen liquidación y son empleados activos, esto es para el caso que uno o varios 
        // empleados hayan tenido cambio de cargo
        
        $primquin = substr($listaperiodos,0,2);
        $segnquin = substr($listaperiodos,-2);

        $vsqlcambiocargo = "SELECT DISTINCT d.terid,  
                                   CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                   t.esempleadoactivo, t.extralegal
                              FROM detallenomina d
                                   INNER JOIN terceros t ON (d.terid = t.terid)
                             WHERE d.pernominaid = ".$primquin."
                                   AND d.terid IN (SELECT terid
                                                     FROM hisdetallenomina 
                                                    WHERE pernominaid = ".$segnquin.") 
                                   AND d.terid IN (SELECT terid
                                                     FROM detalleliquidacion 
                                                    WHERE pernominaid IN ($listaperiodos))                      
                                   AND d.terid IN (SELECT terid
                                                     FROM liquidacion 
                                                    WHERE periodonomina = '".$codperiodo."')  
                                   AND t.esempleadoactivo = 'CHECKED'
                                   AND t.extralegal <> 'CHECKED'";

        if(strlen($listadereportados)>0)            $vsqlcambiocargo.= " AND d.terid NOT IN ($listadereportados) ";

        if(strlen($nodebensalir) > 0)
            $vsqlcambiocargo.= " AND d.terid NOT IN ($nodebensalir) ";

        $k = $j;

        $conex  = $clase->Conectar();
        $resultcam = mysql_query($vsqlcambiocargo,$conex);
        $empleadoscambiados = mysql_num_rows($resultcam);

        // $empleadoscambiados = 0;

        if($empleadoscambiados > 0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";                            $montoderecnocdonfes = 0;
            $celda1="";                                     $celda2="";                                     $celda3="";
            $celda4="";                                     $celda5="";                                     $celda6="";
            $celda7="";                                     $celda8="";                                     $celda9="";
            $celda10="";                                    $celda11="";                                    $celda12="";
            $celda13="";                                    $celda14="";                                    $celda15="";
            $celda16="";                                    $celda17="";                                    $celda18="";
            $celda19="";                                    $celda20="";                                    $celda21="";
            $celda22="";                                    $celda23="";                                    $celda24="";
            $celda25="";                                    $celda26="";                                    $celda27="";
            $celda28="";                                    $celda29="";                                    $celda30="";
            $celda31="";                                    $celda32="";                                    $celda33="";
            $celda34="";                                    $celda35="";                                    $celda36="";
            $celda37="";                                    $celda38="";                                    $celda39="";
            $celda40="";                                    $celda41="";                                    $celda42="";
            $celda43="";                                    $celda44="";                                    $celda45="";
            $celda46="";                                    $celda47="";                                    $celda48="";
            $celda49="";                                    $celda50="";                                    $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $listadereportados.= ",";                       $vsqlvextralegal = "";
            $numnomext = 0;                                 $vsqlnumvacaciones2 = "";                       $numvacaciones2 = 0;
            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;                                 $celda51="";            
            $celda52="";                                    $horaextradiurna = 0;                           $horaextradiurnaliq = 0;
            $horaextradiurna = 0;                           $horaextranocturna = 0;                         $horaextranocturnaliq = 0;
            $horaextranocturna = 0;                         $horaextradiurnadom = 0;                        $horaextradiurnadomliq = 0;
            $horaextradiurnadom = 0;                        $horaextradnocturnadomfes = 0;                  $horaextradnocturnadomfesliq = 0;
            $horaextradnocturnadomfes = 0;                  $cantidadhed = 0;                               $cantidadhedliq = 0;
            $cantidaddehed = 0;                             $montohoraextdiurna = 0;                        $montohoraextdiurnaliq = 0;
            $montodehorasextrasdiura = 0;                   $cantidadhen = 0;                               $cantidadhenliq = 0;
            $cantidaddehen = 0;                             $montohoraextnocturna = 0;                      $montohoraextnocturnaliq = 0;
            $montohorextnoc = 0;                            $cantidadhedd = 0;                              $cantidadheddliq = 0;
            $cantidaddehedd = 0;                            $montohoraextddom = 0;                          $montohoraextddomliq = 0;
            $montohoraextdiudom = 0;                        $cantidadhendf = 0;                             $cantidadhendfliq = 0;
            $cantidaddehendf = 0;                           $montohendf = 0;                                $montohendfliq = 0;
            $montodehendf = 0;                              $cantidaddomfes = 0;                            $cantidaddomfesliq = 0;
            $cantidaddedomfes = 0;                          $montodomfes = 0;                               $montodomfesliq = 0;
            $montodedomfes = 0;                             $cantidadrecnocdonfes = 0;                      $cantidadrecnocdonfesliq = 0;
            $cantidadderecnocdonfes = 0;                    $montorecnocdonfes = 0;                         $montorecnocdonfesliq = 0;
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;            

            // $k = $j;

            while($rowcambio = mysql_fetch_array($resultcam))
            {
                // id del empleado
                $terid = $rowcambio['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal ='CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);
                
                if($numnomext<2)
                {
                    // Documento del empleado
                    $dni = $clase->BDLockup($terid,'terceros','terid','dni');
                    $cambiorepetido = 0;
    
                    // Genero el registro en la hoja de Excel
                    if($cambiorepetido==0)
                    {
                        // Días trabajados                    
                        $vsqldias = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrab 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid." 
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                        $diastrab = $clase->SeleccionarUno($vsqldias);
    
                        // Días trabajados en la liquidación
                        $vsqldiasliq = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrabliq 
                                          FROM detalleliquidacion 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND conceptoid = 1";
                        $diastrabliq = $clase->SeleccionarUno($vsqldiasliq);
    
                        $diastrab += $diastrabliq;
    
                        // Documento del empleado
                        $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                        // Primer apellido
                        $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                        // Segundo apellido
                        $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                        // Primer nombre
                        $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                        // Segundo nombre
                        $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                        // Sueldo básico
                        $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                        // Código del trabajador
                        $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                        // Correo electrónico
                        $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                        // Teléfono
                        $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                        // Número de cuenta
                        $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
    
                        // Tipo de documento
                        $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                        // Banco
                        $vsqlbanco = "SELECT b.descripcion AS banco
                                        FROM periodoterceros p
                                             INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                       WHERE p.terid = ".$terid;
                        $banco = $clase->SeleccionarUno($vsqlbanco);
                        $banco = trim(str_replace("BANCO ","",$banco));
    
                        // cargo del empleado
                        $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
    
                        // sueldo del periodo
                        $vsqlsueldo = "SELECT SUM(IF(conceptoid=1,devengados,0)) AS sueldoper 
                                         FROM hisdetallenomina 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid = ".$terid." 
                                              AND pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                             AND periodoterceros.extralegal = 'CHECKED')";
                        $sueldoper = $clase->SeleccionarUno($vsqlsueldo);
    
                        $vsqlsueldoliq = "SELECT devengados AS sueldoliq
                                            FROM detalleliquidacion
                                           WHERE terid = ".$terid."
                                                 AND conceptoid = 1
                                                 AND pernominaid IN ($listaperiodos)";
                        $sueldoliq = $clase->SeleccionarUno($vsqlsueldoliq);
    
                        $sueldoper += $sueldoliq;
    
                        // Auxilio de transporte                        
                        $vsqltrasp = "SELECT SUM(IF(conceptoid IN (3,45),devengados,0)) AS auxtransp 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid = ".$terid." 
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                        $auxtransp = $clase->SeleccionarUno($vsqltrasp);
    
                        $vsqltransliq = "SELECT devengados AS transliq
                                           FROM detalleliquidacion
                                          WHERE terid = ".$terid." 
                                                AND conceptoid = 3
                                                AND pernominaid IN ($listaperiodos)";
                        $transliq = $clase->SeleccionarUno($vsqltransliq);
    
                        $auxtransp += $transliq;

                        // Recargo nocturno
                        $vsqlrecargonoc = "SELECT SUM(IF(conceptoid IN (47,56,59),devengados,0)) AS auxtransp 
                                             FROM hisdetallenomina 
                                            WHERE pernominaid IN ($listaperiodos) 
                                                  AND terid = ".$terid." 
                                                  AND pernominaid NOT IN (SELECT pernominaid 
                                                                            FROM periodoterceros
                                                                           WHERE periodoterceros.terid = ".$terid." 
                                                                                 AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                 AND periodoterceros.extralegal = 'CHECKED')";
                        $recargonoc = $clase->SeleccionarUno($vsqlrecargonoc);

                        $vsqlrecargonocliq = "SELECT devengados AS recargonocliq
                                                FROM detalleliquidacion
                                               WHERE terid = ".$terid."
                                                     AND conceptoid IN (47,56,59) 
                                                     AND pernominaid IN ($listaperiodos)";
                        $recargonocliq = $clase->SeleccionarUno($vsqlrecargonocliq);

                        $recargonoc += $recargonocliq;

                        // hora extra diurna
                        $horaextradiurna = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 49,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $horaextradiurnaliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 49 AND pernominaid IN ($listaperiodos)");
                        $horaextradiurna += $horaextradiurnaliq;

                        // hora extra nocturna
                        $horaextranocturna = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 50,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $horaextranocturnaliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 50 AND pernominaid IN ($listaperiodos)");
                        $horaextranocturna += $horaextranocturnaliq;

                        // hora extra diurna dominical
                        $horaextradiurnadom = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 51,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $horaextradiurnadomliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 51 AND pernominaid IN ($listaperiodos)");
                        $horaextradiurnadom += $horaextradiurnadomliq;

                        // hora extra nocturna dominical y festivo
                        $horaextradnocturnadomfes = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 52,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $horaextradnocturnadomfesliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 52 AND pernominaid IN ($listaperiodos)");
                        $horaextradnocturnadomfes += $horaextradnocturnadomfesliq;

                        // domingos y festivos
                        $domingosyfestivos = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 53,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $domingosyfestivosliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 53 AND pernominaid IN ($listaperiodos)");
                        $domingosyfestivos += $domingosyfestivosliq;

                        // recargo nocturno dominical y festivo
                        $recargonocdomfes = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 54,devengados,0)) AS recargonoc FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                        $recargonocdomfesliq = $clase->SeleccionarUno("SELECT devengados AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 54 AND pernominaid IN ($listaperiodos)");
                        $recargonocdomfes += $recargonocdomfesliq;
    
                        // Embargo
                        $vsqlembg = "SELECT SUM(IF(conceptoid=30,descuentos,0)) AS embargo 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid." 
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                        $embargo = $clase->SeleccionarUno($vsqlembg);
    
                        $vsqlembliq = "SELECT descuentos AS embliq
                                         FROM detalleliquidacion
                                        WHERE terid = ".$terid." 
                                              AND conceptoid = 30
                                              AND pernominaid IN ($listaperiodos)";
                        $embliq = $clase->SeleccionarUno($vsqlembliq);
    
                        $embargo += $embliq;
    
                        // Salud                        
                        $vsqlsalud = "SELECT SUM(IF(conceptoid = 5,descuentos,0)) AS salud 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid = ".$terid." 
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                        $salud = $clase->SeleccionarUno($vsqlsalud);
    
                        $vsqlsaludliq = "SELECT descuentos AS saludliq
                                           FROM detalleliquidacion
                                          WHERE terid = ".$terid."
                                                AND conceptoid = 5
                                                AND pernominaid IN ($listaperiodos)";
                        $saludliq = $clase->SeleccionarUno($vsqlsaludliq);
    
                        $salud += $saludliq;
    
                        // Pensión                        
                        $vsqlpension = "SELECT SUM(IF(conceptoid = 4,descuentos,0)) AS pension 
                                          FROM hisdetallenomina 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid." 
                                               AND pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
                        $pension = $clase->SeleccionarUno($vsqlpension);
    
                        $vsqlpesionliq = "SELECT descuentos AS pesionliq
                                            FROM detalleliquidacion
                                           WHERE terid = ".$terid."
                                                 AND conceptoid = 4
                                                 AND pernominaid IN ($listaperiodos)";
                        $pesionliq = $clase->SeleccionarUno($vsqlpesionliq);
    
                        $pension += $pesionliq;
    
                        // total devengado
                        $vsqldev = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                      FROM hisdetallenomina 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                          AND periodoterceros.extralegal = 'CHECKED')";
                        $devengados = $clase->SeleccionarUno($vsqldev);
    
                        $vsqldevliq = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                         FROM detalleliquidacion 
                                        WHERE terid = ".$terid."";
                        $devengadosliq = $clase->SeleccionarUno($vsqldevliq);
    
                        $devengados += $devengadosliq;
    
                        // total descuentos
                        $vsqldesc = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid." 
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                        $descuentos = $clase->SeleccionarUno($vsqldesc);
    
                        $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                          FROM detalleliquidacion 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid=".$terid."";
                        $descuentosliq = $clase->SeleccionarUno($vsqldescliq);
    
                        $descuentos += $descuentosliq;
        
                        // Obtengo la fecha de ingreso del empleado
                        $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
    
                        // Incapacidades del periodo
                        $vsqlincapacidad = "SELECT COUNT(*) AS numincap 
                                              FROM hisdetallenomina 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND conceptoid IN (10,43,40)
                                                   AND terid = ".$terid."
                                                   AND pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                  AND periodoterceros.extralegal = 'CHECKED')";
                        $numincap = $clase->SeleccionarUno($vsqlincapacidad);

                        $vsqlincapacidad2 = "SELECT COUNT(*) AS numincap
                                               FROM detalleliquidacion 
                                              WHERE pernominaid IN ($listaperiodos) 
                                                    AND terid = ".$terid."
                                                    AND conceptoid IN (10,43,40)";
                        $numincap2 = $clase->SeleccionarUno($vsqlincapacidad2);

                        $numincap += $numincap2;
    
                        // Licencias del periodo
                        $vsqlincapacidad = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                              FROM hisdetallenomina h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND c.eslicencia = 'CHECKED' 
                                                   AND c.tipodc = 'C' 
                                                   AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                                   AND h.terid = ".$terid."
                                                   AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                    AND periodoterceros.extralegal = 'CHECKED')";
                        $numlicencias = $clase->SeleccionarUno($vsqlincapacidad);

                        $vsqlincapacidad2 = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                              FROM detalleliquidacion h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND c.eslicencia = 'CHECKED' 
                                                   AND c.tipodc = 'C' 
                                                   AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                                   AND h.terid = ".$terid;
                        $numlicencias2 = $clase->SeleccionarUno($vsqlincapacidad2);

                        $numlicencias += $numlicencias2;

                        // ---------------------------------------------------------------------------------------------------------- //
                        $vsqllicnoremuneradas2 = "SELECT COUNT(conceptoid) AS licnoremuneradas2 
                                                    FROM detalleliquidacion 
                                                   WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid."
                                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                                   FROM periodoterceros
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND pernominaid IN ($listaperiodos)
                                                                                        AND extralegal = 'CHECKED')";
                        $licnoremuneradas2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);
                        $numlicencias += $licnoremuneradas2;
                        // ---------------------------------------------------------------------------------------------------------- //
    
                        // Libranzas del periodo
                        $vsqllibranzas = "SELECT COUNT(h.conceptoid) AS numlibranzas 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                                                 AND h.terid = ".$terid."
                                                 AND c.conceptoid NOT IN (10,30)
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                  AND periodoterceros.extralegal = 'CHECKED')";
                        $numlibranzas = $clase->SeleccionarUno($vsqllibranzas);
    
                        // Libranzas en liquidación
                        $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                               FROM detalleliquidacion h
                                                    INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                              WHERE h.pernominaid IN ($listaperiodos)
                                                    AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                                    AND h.terid = ".$terid."
                                                    AND c.conceptoid NOT IN (10,30)";
                        $numlibranzasliq = $clase->SeleccionarUno($vsqllibranzasliq);
    
                        // Sanciones del periodo
                        $vsqlsanciones = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid = 9
                                                 AND h.terid = ".$terid."
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                  AND periodoterceros.extralegal = 'CHECKED')";
                        $numsanciones = $clase->SeleccionarUno($vsqlsanciones);
    
                        // Otras deducciones
                        // Estas incluyen: CAMISETAS, PLAN TELEFONIA MOVIL, PRESTAMOS PERSONALES, AJUSTE SALARIO SENA, 
                        // CREDITOS OTROS NEGOCIOS, DESCUENTO SP, MANGAS, CAFETERIA, COMPRAS A CREDITO, OTROS E INCAPACIDAD SUPERIOR A 180 DÍAS
                        $vsqlotrasdeduc = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                  AND h.terid = ".$terid."
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                        $numotrasded = $clase->SeleccionarUno($vsqlotrasdeduc);
    
                        // otras deducciones en liquidación
                        $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                                FROM detalleliquidacion h
                                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                               WHERE h.pernominaid IN ($listaperiodos)
                                                     AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                     AND h.terid = ".$terid."";
                        $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);
    
                        // Vacaciones
                        $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'vacaciones'";
                        $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                        // Vacaciones pagadas en quincenas
                        $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2
                                                 FROM hisdetallenomina 
                                                WHERE terid = ".$terid."
                                                      AND conceptoid = 38 
                                                      AND pernominaid IN ($listaperiodos)";
                        $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                        $numvacacionest = $numvacaciones1 + $numvacaciones2;

                        // Primas
                        $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $numprimas = $clase->SeleccionarUno($vsqlnumprimas);
    
                        // Cesantías
                        $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);
    
                        // Indemnización
                        $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                        // Otros conceptos devengados
                        $vsqlotrosdevenliq = "SELECT COUNT(h.conceptoid) AS numotrosdevenliq
                                                FROM detalleliquidacion h
                                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                               WHERE h.pernominaid IN ($listaperiodos)
                                                     AND h.conceptoid IN (37,48) 
                                                     AND h.terid = ".$terid."";
                        $numotrosdevenliq = $clase->SeleccionarUno($vsqlotrosdevenliq);
    
                        // Otros conceptos devengados
                        $vsqlotrosdeven = "SELECT COUNT(h.conceptoid) AS numotrosdeven
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid = 37
                                                  AND h.terid = ".$terid." 
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                        $numotrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
    
                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Dotaciones 
                        $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                             FROM dotaciones
                                            WHERE periodonomina = '".$codperiodo."'
                                                  AND terid = ".$terid."";
                        $montodotacion = $clase->SeleccionarUno($vsqldotaciones);
    
                        $celda1="A".strval($k);         $celda2="B".strval($k);         $celda3="C".strval($k);         $celda4="D".strval($k);         $celda5="E".strval($k);
                        $celda6="F".strval($k);         $celda7="G".strval($k);         $celda8="H".strval($k);         $celda9="I".strval($k);         $celda10="J".strval($k);
                        $celda11="K".strval($k);        $celda12="L".strval($k);        $celda13="M".strval($k);        $celda14="N".strval($k);        $celda15="O".strval($k);
                        $celda16="P".strval($k);        $celda17="Q".strval($k);        $celda18="R".strval($k);        $celda19="S".strval($k);        $celda20="T".strval($k);
                        $celda21="U".strval($k);        $celda22="V".strval($k);        $celda23="W".strval($k);        $celda24="X".strval($k);        $celda25="Y".strval($k);
                        $celda26="Z".strval($k);        $celda27="AA".strval($k);       $celda28="AB".strval($k);       $celda29="AC".strval($k);       $celda30="AD".strval($k);
                        $celda31="AE".strval($k);       $celda32="AF".strval($k);       $celda33="AG".strval($k);       $celda34="AH".strval($k);       $celda35="AI".strval($k);
                        $celda36="AJ".strval($k);       $celda37="AK".strval($k);       $celda38="AL".strval($k);       $celda39="AM".strval($k);       $celda40="AN".strval($k);
                        $celda41="AO".strval($k);       $celda42="AP".strval($k);       $celda43="AQ".strval($k);       $celda44="AR".strval($k);       $celda45="AS".strval($k);
                        $celda46="AT".strval($k);       $celda47="AU".strval($k);       $celda48="AV".strval($k);       $celda49="AW".strval($k);       $celda50="AX".strval($k);
                        $celda51="AY".strval($k);       $celda52="AZ".strval($k);       $celda53="BA".strval($k);       $celda54="BB".strval($k);       $celda55="BC".strval($k);
                        $celda56="BD".strval($k);       $celda57="BE".strval($k);       $celda58="BF".strval($k);       $celda59="BG".strval($k);       $celda60="BH".strval($k);
                        $celda61="BI".strval($k);       $celda62="BJ".strval($k);       $celda63="BK".strval($k);       $celda64="BL".strval($k);
    
                        // Escribo en la hoja de Excel
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda1, $fecingreso)
                                    ->setCellValue($celda2, '01')
                                    ->setCellValue($celda3, '00')
                                    ->setCellValue($celda4, 'true')
                                    ->setCellValue($celda5,'13')
                                    ->setCellValue($celda6, $dni)
                                    ->setCellValue($celda7, $primerapellido)
                                    ->setCellValue($celda8, $segundoapellido)
                                    ->setCellValue($celda9, $primernombre)
                                    ->setCellValue($celda10, $segundonombre)
                                    ->setCellValue($celda11, number_format($basico))
                                    ->setCellValue($celda12, $codvende)
                                    ->setCellValue($celda13, '1');
    
                        // Identifico la forma de pago
                        if($numcuenta!="")
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda14, '45')
                                        ->setCellValue($celda15, $banco)
                                        ->setCellValue($celda16, 'AHORROS')
                                        ->setCellValue($celda17, $numcuenta);
                        }
                        else
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda14, '10')
                                        ->setCellValue($celda15, 'NINGUNO')
                                        ->setCellValue($celda16, 'NINGUNO')
                                        ->setCellValue($celda17, 'NINGUNA');
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda18, $diastrab)
                                    ->setCellValue($celda19, number_format(intval($sueldoper)))
                                    ->setCellValue($celda20, number_format(intval($auxtransp)));

                        // Incluyo los recargos nocturnos
                        if($recargonoc > 0)
                        {
                            // Días de recargos
                            $vsql30 = "SELECT IFNULL(SUM(valor),0) AS valor
                                         FROM hisdetallenomina 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND conceptoid IN (47,56,59)
                                              AND terid = ".$terid." 
                                              AND pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                             AND periodoterceros.extralegal = 'CHECKED')";
                            $diasrecnoc = $clase->SeleccionarUno($vsql30);

                            $vsql33 = "SELECT IFNULL(SUM(valor),0) AS valor
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND conceptoid IN (47,56,59) 
                                              AND terid = ".$terid;
                            $diasrecnoc2 = $clase->SeleccionarUno($vsql33);

                            $diasrecnoc += $diasrecnoc2;

                            // Monto de los recargos nocturnos
                            $vsql35 = "SELECT devengados
                                         FROM hisdetallenomina 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND conceptoid IN (47,56,59)
                                              AND terid = ".$terid."
                                              AND pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                             AND periodoterceros.extralegal = 'CHECKED')";
                            $montorecargonoc = $clase->SeleccionarUno($vsql35);

                            $vsql36 = "SELECT devengados
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND conceptoid IN (47,56,59) 
                                              AND terid = ".$terid;
                            $montorecargonoc2 = $clase->SeleccionarUno($vsql36);

                            $montorecargonoc += $montorecargonoc2;
                        }
                        else
                        {
                            $diasrecnoc = 0;
                            $montorecargonoc = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda21, $diasrecnoc)
                                    ->setCellValue($celda22, number_format($montorecargonoc));

                        // hora extra diurna
                        if($horaextradiurna > 0)
                        {
                            // cantidades
                            $cantidadhed = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 49 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidadhedliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 49");
                            $cantidaddehed = $cantidadhed + $cantidadhedliq;

                            // Montos
                            $montohoraextdiurna = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 49 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montohoraextdiurnaliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 49");
                            $montodehorasextrasdiura = $montohoraextdiurna + $montohoraextdiurnaliq;
                        }
                        else
                        {
                            $cantidaddehed = 0;
                            $montodehorasextrasdiura = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda23, $cantidaddehed)
                                    ->setCellValue($celda24, number_format($montodehorasextrasdiura));

                        // hora extra nocturna
                        if($horaextranocturna > 0)
                        {
                            // cantidades
                            $cantidadhen = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 50 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidadhenliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 50");
                            $cantidaddehen = $cantidadhen + $cantidadhenliq;

                            // Montos
                            $montohoraextnocturna = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 50 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montohoraextnocturnaliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 50");
                            $montohorextnoc = $montohoraextnocturna + $montohoraextnocturnaliq;
                        }
                        else
                        {
                            $cantidaddehen = 0;
                            $montohorextnoc = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda25, $cantidaddehen)
                                    ->setCellValue($celda26, number_format($montohorextnoc));

                        // hora extra diurna dominical
                        if($horaextradiurnadom > 0)
                        {
                            // cantidades
                            $cantidadhedd = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 51 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidadheddliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 51");
                            $cantidaddehedd = $cantidadhedd + $cantidadheddliq;

                            // Montos
                            $montohoraextddom = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 51 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montohoraextddomliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 51");
                            $montohoraextdiudom = $montohoraextddom + $montohoraextddomliq;
                        }
                        else
                        {
                            $cantidaddehedd = 0;
                            $montohoraextdiudom = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda27, $cantidaddehedd)
                                    ->setCellValue($celda28, number_format($montohoraextdiudom));

                        // hora extra nocturna dominical y festivo
                        if($horaextradnocturnadomfes > 0)
                        {
                            // cantidades
                            $cantidadhendf = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 52 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidadhendfliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 52");
                            $cantidaddehendf = $cantidadhendf + $cantidadhendfliq;

                            // Montos
                            $montohendf = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 52 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montohendfliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 52");
                            $montodehendf = $montohendf + $montohendfliq;
                        }
                        else
                        {
                            $cantidaddehendf = 0;
                            $montodehendf = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda29, $cantidaddehendf)
                                    ->setCellValue($celda30, number_format($montodehendf));

                        // domingos y festivos
                        if($domingosyfestivos > 0)
                        {
                            // cantidades
                            $cantidaddomfes = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 53 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidaddomfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 53");
                            $cantidaddedomfes = $cantidaddomfes + $cantidaddomfesliq;

                            // Montos
                            $montodomfes = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 53 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montodomfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 53");
                            $montodedomfes = $montodomfes + $montodomfesliq;
                        }
                        else
                        {
                            $cantidaddedomfes = 0;
                            $montodedomfes = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda31, $cantidaddedomfes)
                                    ->setCellValue($celda32, number_format($montodedomfes));

                        // recargo nocturno dominical y festivo
                        if($recargonocdomfes > 0)
                        {
                            // cantidades
                            $cantidadrecnocdonfes = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 54 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $cantidadrecnocdonfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 54");
                            $cantidadderecnocdonfes = $cantidadrecnocdonfes + $cantidadrecnocdonfesliq;

                            // Montos
                            $montorecnocdonfes = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM hisdetallenomina WHERE pernominaid IN ($listaperiodos) AND conceptoid = 54 AND terid = ".$terid." AND pernominaid NOT IN (SELECT pernominaid FROM periodoterceros WHERE periodoterceros.terid = ".$terid." AND pernominaid IN ($listaperiodos) AND extralegal = 'CHECKED')");
                            $montorecnocdonfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 54");
                            $montoderecnocdonfes = $montorecnocdonfes + $montorecnocdonfesliq;
                        }
                        else
                        {
                            $cantidadderecnocdonfes = 0;
                            $montoderecnocdonfes = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda33, $cantidadderecnocdonfes)
                                    ->setCellValue($celda34, number_format($montoderecnocdonfes));

    
                        // Incluyo las incapacidades
                        if($numincap>0)
                        {
                            // Días de la(s) incapacidad(es)
                            $vsql5 = "SELECT IFNULL(SUM(valor),0) AS valor
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND conceptoid IN (10,43,40) 
                                             AND terid = ".$terid." 
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                            $valorinc = $clase->SeleccionarUno($vsql5);

                            $vsql52 = "SELECT IFNULL(SUM(valor),0) AS valor
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND conceptoid IN (10,43,40)
                                              AND terid = ".$terid;
                            $valorinc2 = $clase->SeleccionarUno($vsql52);

                            $valorinc += $valorinc2;
    
                            // Monto de la(s) incapacidad(es)
                            $vsql6 = "SELECT devengados
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND conceptoid = 10 
                                             AND terid = ".$terid." 
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                            $devengadosinc = $clase->SeleccionarUno($vsql6);

                            $vsql62 = "SELECT devengados
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND conceptoid = 10  
                                              AND terid = ".$terid;
                            $devengadosinc2 = $clase->SeleccionarUno($vsql62);

                            $devengadosinc += $devengadosinc2;

                            // --------------------------------------------------------------------------------------- //
                            $vsql105 = "SELECT c.nomconcepto AS nombreincapacidad
                                          FROM hisdetallenomina h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos) 
                                               AND c.conceptoid IN (10,43,40)
                                               AND h.terid = ".$terid."
                                               AND pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')
                                         UNION ALL
                                        SELECT c.nomconcepto AS nombreincapacidad
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos) 
                                               AND c.conceptoid IN (10,43,40)
                                               AND h.terid = ".$terid."";
                            $conex  = $clase->Conectar();
                            $result105 = mysql_query($vsql105,$conex);

                            $nombreincapacidad = "";
                            while($row105 = mysql_fetch_array($result105))
                            {
                                $nombreincapacidad.= $row105['nombreincapacidad'].", ";                                
                            }
                            $nombreincapacidad = substr($nombreincapacidad, 0, -2);
                            // --------------------------------------------------------------------------------------- //                        
    
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda35, $valorinc)
                                        ->setCellValue($celda36, $nombreincapacidad)
                                        ->setCellValue($celda37, number_format($devengadosinc));
                        }
                        else
                        {
                            $valorinc = 0;
                            $devengadosinc = 0;
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda35, $valorinc)
                                        ->setCellValue($celda36, 'NINGUNA')
                                        ->setCellValue($celda37, number_format($devengadosinc));
                        }
    
                        // Incluyo las licencias
                        if($numlicencias>0)
                        {
                            // Días de la(s) licencia(s)
                            $vsql3 = "SELECT SUM(h.valor) AS valorlic
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND c.eslicencia = 'CHECKED' 
                                             AND c.tipodc = 'C' 
                                             AND h.conceptoid NOT IN (10,9,43,40,58) 
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
                            $valorlic = $clase->SeleccionarUno($vsql3);

                            if($valorlic==NULL)
                                $valorlic = 0;

                            // -------------------------------------------------------------------------------------------------- //
                            $vsqllicnoremuneradas = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem
                                                       FROM hisdetallenomina 
                                                      WHERE pernominaid IN ($listaperiodos)
                                                        AND conceptoid = 6
                                                        AND terid = ".$terid."
                                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND pernominaid IN ($listaperiodos)
                                                                                       AND extralegal = 'CHECKED')";
                            $valorlicnorem = $clase->SeleccionarUno($vsqllicnoremuneradas);

                            $valorlic += $valorlicnorem;
                            // -------------------------------------------------------------------------------------------------- //                                

                            $vsql32 = "SELECT IFNULL(SUM(h.valor),0) AS valorlic
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia = 'CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                              AND h.terid = ".$terid;
                            $valorlic2 = $clase->SeleccionarUno($vsql32);

                            // -------------------------------------------------------------------------------------------------- //
                            $vsqllicnoremuneradas2 = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem2
                                                        FROM detalleliquidacion 
                                                       WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid."
                                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                                   FROM periodoterceros
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND pernominaid IN ($listaperiodos)
                                                                                        AND extralegal = 'CHECKED')";
                            $valorlicnorem2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                            $valorlic2 += $valorlicnorem2;
                            // -------------------------------------------------------------------------------------------------- //

                            $valorlic += $valorlic2;
    
                            // Monto de la(s) licencia(s)
                            $vsql4 = "SELECT IFNULL(SUM(h.devengados),0) AS devengadoslic
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND c.eslicencia = 'CHECKED' 
                                             AND c.tipodc = 'C' 
                                             AND h.conceptoid NOT IN (9,43,40,58)                                          
                                             AND h.terid = ".$terid;
                            $devengadoslic = $clase->SeleccionarUno($vsql4);

                            $vsql42 = "SELECT IFNULL(SUM(h.devengados),0) AS devengadoslic
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia = 'CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                              AND h.terid = ".$terid;
                            $devengadoslic2 = $clase->SeleccionarUno($vsql42);

                            $devengadoslic += $devengadoslic2;                            
    
                            // Construyo la descripción de todas las licencias en el periodo
                            $vsql10 = "SELECT c.nomconcepto AS nombrelicencia
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia = 'CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                              AND h.terid = ".$terid."
                                        UNION ALL
                                       SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia 
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid = 6
                                              AND h.terid = ".$terid."";
                            $conex  = $clase->Conectar();
                            $result10 = mysql_query($vsql10,$conex);
    
                            $nombrelicencia = "";
                            while($row10 = mysql_fetch_array($result10))
                            {
                                if($row10['nombrelicencia'] != "")
                                {
                                    if($row10['nombrelicencia'] != NULL)
                                        $nombrelicencia.= $row10['nombrelicencia'].", ";
                                }
                            }
                            $nombrelicencia = substr($nombrelicencia, 0, -2);
    
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda38, $nombrelicencia)
                                        ->setCellValue($celda39, $valorlic)
                                        ->setCellValue($celda40, number_format($devengadoslic));
                        }
                        else
                        {
                            $valorlic = 0;
                            $devengadoslic = 0;
                            $nombrelicencia = "NINGUNA";
        
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda38, $nombrelicencia)
                                        ->setCellValue($celda39, $valorlic)
                                        ->setCellValue($celda40, number_format($devengadoslic));
                        }
    
                        // Embargo
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda41, number_format($embargo));
    
                        // otras deducciones
                        if(($numotrasded>0)&&($numotrasdedliq>0))
                        {
                            // Monto de las otras deducciones
                            $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                              FROM detalleliquidacion h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                   AND h.terid = ".$terid;
                            $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                            $vsqlmontood2 = "SELECT SUM(h.descuentos) as montootrasdeduc2
                                               FROM hisdetallenomina h
                                                    INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                              WHERE h.pernominaid IN ($listaperiodos)
                                                AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                AND h.terid = ".$terid." 
                                                AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                            FROM periodoterceros
                                                                           WHERE periodoterceros.terid = ".$terid." 
                                                                                 AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                 AND periodoterceros.extralegal = 'CHECKED')";
                            $montootrasdeduc2 = $clase->SeleccionarUno($vsqlmontood);
                            $montootrasdeduc += $montootrasdeduc2;
    
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
    
                            $nombreoc = "";
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
    
                            $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                              AND h.terid = ".$terid."";
    
                            $conex  = $clase->Conectar();
                            $result77 = mysql_query($vsql77,$conex);
    
                            $nombreoc = "";
                            while($row77 = mysql_fetch_array($result77))
                            {
                                $nombreoc.= $row77['nomconcepto']." (".number_format($row77['descuentos'])."), ";
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
                        }
    
                        if(($numotrasded==0)&&($numotrasdedliq>0))
                        {
                            $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                              FROM detalleliquidacion h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                   AND h.terid = ".$terid;
                            $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                             AND h.terid = ".$terid;
    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
                            $nombreoc = "";
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
                        }
    
                        if(($numotrasded>0)&&($numotrasdedliq==0))
                        {
                            // Monto de las otras deducciones
                            $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                              FROM detalleliquidacion h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                   AND h.terid = ".$terid;
                            $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                             AND h.terid = ".$terid." 
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
                            $nombreoc = "";
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
                        }
    
                        if(($numotrasded==0)&&($numotrasdedliq==0))
                        {
                            $nombreoc = "NINGUNO";
                            $montootrasdeduc = 0;
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda42, $nombreoc)
                                    ->setCellValue($celda43, number_format($montootrasdeduc));
    
                        // Continuamos con salud y pensión
                        $objPHPExcel->setActiveSheetIndex(0)                                    
                                    ->setCellValue($celda44, $por_sal_tra)
                                    ->setCellValue($celda45, number_format(intval($salud)))
                                    ->setCellValue($celda46, $por_pen_tra)
                                    ->setCellValue($celda47, number_format(intval($pension)));
    
                        // sanciones
                        if($numsanciones>0)
                        {
                            $vsql66a = "SELECT h.descuentos AS montosancion 
                                          FROM hisdetallenomina h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND h.conceptoid = 9
                                               AND h.terid = ".$terid."
                                               AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                           FROM periodoterceros
                                                                          WHERE periodoterceros.terid = ".$terid." 
                                                                                AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                AND periodoterceros.extralegal = 'CHECKED')";
                            $montosancion = $clase->SeleccionarUno($vsql66a);
                            $conceptosancion = "SUSPENCION";
                        }
                        else
                        {
                            $montosancion = 0;
                            $conceptosancion = "NINGUNA";
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda48, number_format($montosancion))
                                    ->setCellValue($celda49, $conceptosancion);
    
                        // libranzas
                        if(($numlibranzas>0)&&($numlibranzasliq>0))
                        {
                            $vsql82 = "SELECT SUM(h.descuentos) AS montolibranza
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                              AND h.terid = ".$terid." 
                                              AND c.conceptoid NOT IN (10,30)
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')";
                            $montolibranza = $clase->SeleccionarUno($vsql82);
    
                            $vsql83 = "SELECT SUM(h.descuentos) AS montolibranza2
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                              AND h.terid = ".$terid;
                            $montolibranza2 = $clase->SeleccionarUno($vsql83);
    
                            $montolibranza += $montolibranza2;
    
                            $vsql9 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                             AND h.terid = ".$terid." 
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result9 = mysql_query($vsql9,$conex);
        
                            $nombrelibranza = "";
                            while($row9 = mysql_fetch_array($result9))
                            {
                                $nombrelibranza.= $row9['nomconcepto']." (".number_format($row9['descuentos'])."), ";
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
    
                            $vsql99 = "SELECT c.nomconcepto, h.descuentos  
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                              AND h.terid = ".$terid."
                                              AND c.conceptoid NOT IN (10,30)";
                            $conex  = $clase->Conectar();
                            $result99 = mysql_query($vsql99,$conex);
        
                            $nombrelibranza = "";
                            while($row99 = mysql_fetch_array($result99))
                            {
                                $nombrelibranza.= $row99['nomconcepto']." (".number_format($row99['descuentos'])."), ";
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
                        }
    
                        if(($numlibranzas==0)&&($numlibranzasliq>0))
                        {
                            $vsql83 = "SELECT SUM(h.descuentos) AS montolibranza
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                              AND h.terid = ".$terid;
                            $montolibranza = $clase->SeleccionarUno($vsql83);
    
                            $vsql99 = "SELECT c.nomconcepto, h.descuentos  
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                              AND h.terid = ".$terid." 
                                              AND c.conceptoid NOT IN (10,30)";
                            $conex  = $clase->Conectar();
                            $result99 = mysql_query($vsql99,$conex);
        
                            $nombrelibranza = "";
                            while($row99 = mysql_fetch_array($result99))
                            {
                                $nombrelibranza.= $row99['nomconcepto']." (".number_format($row99['descuentos'])."), ";
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
                        }
    
                        if(($numlibranzas>0)&&($numlibranzasliq==0))
                        {
                            $vsql82 = "SELECT SUM(h.descuentos) AS montolibranza
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                              AND h.terid = ".$terid." 
                                              AND c.conceptoid NOT IN (10,30)
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')";
                            $montolibranza = $clase->SeleccionarUno($vsql82);
    
                            $vsql9 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                             AND h.terid = ".$terid."
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result9 = mysql_query($vsql9,$conex);
        
                            $nombrelibranza = "";
                            while($row9 = mysql_fetch_array($result9))
                            {
                                $nombrelibranza.= $row9['nomconcepto']." (".number_format($row9['descuentos'])."), ";
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
                        }
    
                        if(($numlibranzas==0)&&($numlibranzasliq==0))
                        {
                            $nombrelibranza = "NINGUNA";
                            $montolibranza = 0;
                        }
        
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda50, $nombrelibranza)
                                    ->setCellValue($celda51, number_format($montolibranza));
    
                        // primas
                        if($numprimas>0)
                        {
                            // Días de la prima
                            $vsqlcanprimas = "SELECT cantidad AS canprimas
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'primas'";
                            $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                            // Pago de la prima
                            $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                                 FROM liquidacion
                                                WHERE terid = ".$terid."
                                                      AND periodonomina = '".$codperiodo."' 
                                                      AND tipo = 'primas'";
                            $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);
    
                            $devengados += $pagoprimas;
                        }                
                        else
                        {
                            $canprimas = 0;
                            $pagoprimas = 0;
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda52, number_format($canprimas))
                                    ->setCellValue($celda53, number_format($pagoprimas));
    
                        // Cesantías
                        if($numcesantias>0)
                        {
                            // Pago de la cesantía
                            $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);
    
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid." 
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid." 
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia += $montopagocesan;
                            }
    
                            // Porcentaje cesantía
                            $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);
    
                            // Pago de intereses de cesantías
                            $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'cesantias'";
                            $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);
    
                            $devengados += $pagocesantia;
                            $devengados += $pagointereses;
                        }
                        else
                        {
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid." 
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia = $montopagocesan;
                                $devengados += $pagocesantia;
                            }
                            else
                                $pagocesantia = 0;
                            
                            $porccesantia = 0;
                            $pagointereses = 0;
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda54, number_format($pagocesantia))
                                    ->setCellValue($celda55, number_format($porccesantia))
                                    ->setCellValue($celda56, number_format($pagointereses));
    
                        // vacaciones
                        if($numvacacionest>0)
                        {
                            if($numvacaciones1 > 0)
                            {
                                // Días de vacaciones
                                $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                        FROM liquidacion
                                                       WHERE terid = ".$terid."
                                                             AND periodonomina = '".$codperiodo."' 
                                                             AND tipo = 'vacaciones'";
                                $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                                // Pago de vacaciones
                                $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'vacaciones'";
                                $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                            }
                            else
                            {
                                $canvacaciones = 0;
                                $pagovaca1 = 0;
                            }

                            if($numvacaciones2>0)
                            {
                                $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                    FROM hisdetallenomina  
                                                   WHERE terid = ".$terid."
                                                         AND conceptoid = 38 
                                                         AND pernominaid IN ($listaperiodos)";
                                $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                            }
                            else
                                $pagovaca2 = 0;
                            
                            if($canvacaciones == 0)               $canvacaciones = 1;
                            $pagovaca = $pagovaca1 + $pagovaca2;    
                            $devengados += $pagovaca1;
                        }
                        else
                        {
                            $canvacaciones = 0;
                            $pagovaca = 0;
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda57, number_format($canvacaciones,2))
                                    ->setCellValue($celda58, number_format($pagovaca));
    
                        // indemnización                    
                        if($numindemnizacion>0)
                        {
                            $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'indemnizacion'";
                            $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                            $devengados += $indemnizacion;
                        }
                        else
                            $indemnizacion = 0;
    
                        $objPHPExcel->setActiveSheetIndex(0)                                    
                                    ->setCellValue($celda59, number_format($indemnizacion));
    
                        // otros devengados
                        if($numotrosdevenliq>0)
                        {
                            $vsqlotrosdeven = "SELECT SUM(IF(h.conceptoid IN (37,48),h.devengados,0)) AS otrosdeven
                                                 FROM detalleliquidacion h
                                                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                                WHERE h.pernominaid IN ($listaperiodos)                                                      
                                                      AND h.terid = ".$terid;
                            $otrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
    
                            $devengados += $otrosdeven;
                        }
                        else                        
                            $otrosdeven = 0;
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda60, number_format($otrosdeven));
    
                        // dotaciones
                        if(strlen($montodotacion)>0)
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda61, number_format($montodotacion));
                            $devengados += $montodotacion;
                        }
                        else
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda61, 0);
    
                        $neto = $devengados - $descuentos;
    
                        // Totales
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda62, number_format($devengados))
                                    ->setCellValue($celda63, number_format($descuentos))
                                    ->setCellValue($celda64, number_format($neto));
    
                        // Incremento el contador de líneas
                        $k++;
                        $listadereportados.= $terid.",";
                    }
                }                
            }

            $listadereportados = substr($listadereportados, 0, -1);

            $rangoEncabezado = 'A9:BL9';
            $rangoCeldas     = 'A9:BL'.($k-1);
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Ciclo para los empleados que no trabajaron ninguna quincena y tienen una liquidación

        $vsqlsololiquidacion = "SELECT DISTINCT terid
                                  FROM liquidacion 
                                 WHERE periodonomina = '".$codperiodo."'
                                       AND terid NOT IN (SELECT terid
                                                           FROM detalleliquidacion 
                                                          WHERE pernominaid IN ($listaperiodos))";

        if(strlen($listadereportados)>0)            $vsqlsololiquidacion.= " AND terid NOT IN ($listadereportados) ";

        if(strlen($nodebensalir) > 0)
            $vsqlsololiquidacion.= " AND terid NOT IN ($nodebensalir) ";

        $l = $k;
        $conex  = $clase->Conectar();
        $resultsololiq = mysql_query($vsqlsololiquidacion,$conex);
        $empleadossololiq = mysql_num_rows($resultsololiq);

        // $empleadossololiq = 0;

        if($empleadossololiq > 0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";
            $celda1="";                                     $celda2="";                                     $celda3="";
            $celda4="";                                     $celda5="";                                     $celda6="";
            $celda7="";                                     $celda8="";                                     $celda9="";
            $celda10="";                                    $celda11="";                                    $celda12="";
            $celda13="";                                    $celda14="";                                    $celda15="";
            $celda16="";                                    $celda17="";                                    $celda18="";
            $celda19="";                                    $celda20="";                                    $celda21="";
            $celda22="";                                    $celda23="";                                    $celda24="";
            $celda25="";                                    $celda26="";                                    $celda27="";
            $celda28="";                                    $celda29="";                                    $celda30="";
            $celda31="";                                    $celda32="";                                    $celda33="";
            $celda34="";                                    $celda35="";                                    $celda36="";
            $celda37="";                                    $celda38="";                                    $celda39="";
            $celda40="";                                    $celda41="";                                    $celda42="";
            $celda43="";                                    $celda44="";                                    $celda45="";
            $celda46="";                                    $celda47="";                                    $celda48="";
            $celda49="";                                    $celda50="";                                    $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $listadereportados.= ",";                       $vsqlvextralegal = "";
            $numnomext = 0;                                 $vsqlnumvacaciones2 = "";                       $numvacaciones2 = 0;
            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;                                 $celda51="";
            $celda52="";

            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;


            while($rowsololiq = mysql_fetch_array($resultsololiq))
            {
                // id del empleado
                $terid = $rowsololiq['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal = 'CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);
                
                if($numnomext<2)
                {
                    // Documento del empleado
                    $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                    // Primer apellido
                    $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                    // Segundo apellido
                    $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                    // Primer nombre
                    $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                    // Segundo nombre
                    $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                    // Sueldo básico
                    $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                    // Código del trabajador
                    $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                    // Correo electrónico
                    $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                    // Teléfono
                    $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                    // Número de cuenta
                    $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
    
                    // Tipo de documento
                    $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                    // Banco
                    $vsqlbanco = "SELECT b.descripcion AS banco
                                    FROM periodoterceros p
                                         INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                   WHERE p.terid = ".$terid;
                    $banco = $clase->SeleccionarUno($vsqlbanco);
                    $banco = trim(str_replace("BANCO ","",$banco));
    
                    // cargo del empleado
                    $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
    
                    $sueldoper = 0;                     $auxtransp = 0;                 $embargo = 0;
                    $salud = 0;                         $pension = 0;                   $devengados = 0;
                    $descuentos = 0;
    
                    // Obtengo la fecha de ingreso del empleado
                    $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
    
                    $numincap = 0;                      $numlicencias = 0;                      $numlibranzas = 0;
                    $numlibranzasliq = 0;               $numsanciones = 0;                      $numotrasded = 0;
                    $numotrasdedliq = 0;                $diasrecnoc = 0;                        $montorecargonoc = 0;
                    $cantidaddehed = 0;                 $montodehorasextrasdiura = 0;           $cantidaddehen = 0;
                    $montohorextnoc = 0;                $cantidaddehedd = 0;                    $montohoraextdiudom = 0;
                    $cantidaddehendf = 0;               $montodehendf = 0;                      $cantidaddedomfes = 0;
                    $montodedomfes = 0;                 $cantidadderecnocdonfes = 0;            $montoderecnocdonfes = 0;                    

                    // Incapacidades del periodo
                    $vsqlincapacidad = "SELECT COUNT(*) AS numincap
                                          FROM detalleliquidacion 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND conceptoid IN (10,43,40)";
                    $numincap = $clase->SeleccionarUno($vsqlincapacidad);                    

                    // Embargo
                    $vsqlembliq = "SELECT IFNULL(SUM(descuentos),0)  AS embliq
                                     FROM detalleliquidacion
                                    WHERE terid = ".$terid."
                                          AND conceptoid = 30
                                          AND pernominaid IN ($listaperiodos)";
                    $embargo = $clase->SeleccionarUno($vsqlembliq);
    
                    // Vacaciones
                    $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                  AND periodonomina = '".$codperiodo."' 
                                                  AND tipo = 'vacaciones'";
                    $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                    // Vacaciones pagadas en quincenas
                    $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2
                                             FROM hisdetallenomina 
                                            WHERE terid = ".$terid."
                                                  AND conceptoid = 38 
                                                  AND pernominaid IN ($listaperiodos)";
                    $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                    $numvacacionest = $numvacaciones1 + $numvacaciones2;
    
                    // Primas
                    $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                        FROM liquidacion
                                       WHERE terid=".$terid."
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'primas'";
                    $numprimas = $clase->SeleccionarUno($vsqlnumprimas);
    
                    // Cesantías
                    $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                           FROM liquidacion
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'cesantias'";
                    $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);
    
                    // Indemnización
                    $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                            FROM liquidacion
                                           WHERE terid = ".$terid." 
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'indemnizacion'";
                    $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                    $numotrosdevenliq = 0;
                    $numotrosdeven = 0;
    
                    // Dotaciones 
                    $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                         FROM dotaciones
                                        WHERE periodonomina = '".$codperiodo."'
                                              AND terid = ".$terid."";
                    $montodotacion = $clase->SeleccionarUno($vsqldotaciones);
    
                    $celda1="A".strval($l);         $celda2="B".strval($l);         $celda3="C".strval($l);         $celda4="D".strval($l);         $celda5="E".strval($l);
                    $celda6="F".strval($l);         $celda7="G".strval($l);         $celda8="H".strval($l);         $celda9="I".strval($l);         $celda10="J".strval($l);
                    $celda11="K".strval($l);        $celda12="L".strval($l);        $celda13="M".strval($l);        $celda14="N".strval($l);        $celda15="O".strval($l);
                    $celda16="P".strval($l);        $celda17="Q".strval($l);        $celda18="R".strval($l);        $celda19="S".strval($l);        $celda20="T".strval($l);
                    $celda21="U".strval($l);        $celda22="V".strval($l);        $celda23="W".strval($l);        $celda24="X".strval($l);        $celda25="Y".strval($l);
                    $celda26="Z".strval($l);        $celda27="AA".strval($l);       $celda28="AB".strval($l);       $celda29="AC".strval($l);       $celda30="AD".strval($l);
                    $celda31="AE".strval($l);       $celda32="AF".strval($l);       $celda33="AG".strval($l);       $celda34="AH".strval($l);       $celda35="AI".strval($l);
                    $celda36="AJ".strval($l);       $celda37="AK".strval($l);       $celda38="AL".strval($l);       $celda39="AM".strval($l);       $celda40="AN".strval($l);
                    $celda41="AO".strval($l);       $celda42="AP".strval($l);       $celda43="AQ".strval($l);       $celda44="AR".strval($l);       $celda45="AS".strval($l);
                    $celda46="AT".strval($l);       $celda47="AU".strval($l);       $celda48="AV".strval($l);       $celda49="AW".strval($l);       $celda50="AX".strval($l);
                    $celda51="AY".strval($l);       $celda52="AZ".strval($l);       $celda53="BA".strval($l);       $celda54="BB".strval($l);       $celda55="BC".strval($l);
                    $celda56="BD".strval($l);       $celda57="BE".strval($l);       $celda58="BF".strval($l);       $celda59="BG".strval($l);       $celda60="BH".strval($l);
                    $celda61="BI".strval($l);       $celda62="BJ".strval($l);       $celda63="BK".strval($l);       $celda64="BL".strval($l);
    
                    // Escribo en la hoja de Excel
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda1, $fecingreso)
                                ->setCellValue($celda2, '01')
                                ->setCellValue($celda3, '00')
                                ->setCellValue($celda4, 'true')
                                ->setCellValue($celda5,'13')
                                ->setCellValue($celda6, $dni)
                                ->setCellValue($celda7, $primerapellido)
                                ->setCellValue($celda8, $segundoapellido)
                                ->setCellValue($celda9, $primernombre)
                                ->setCellValue($celda10, $segundonombre)
                                ->setCellValue($celda11, number_format($basico))
                                ->setCellValue($celda12, $codvende)
                                ->setCellValue($celda13, '1');
    
                    // Identifico la forma de pago
                    if($numcuenta!="")
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda14, '45')
                                    ->setCellValue($celda15, $banco)
                                    ->setCellValue($celda16, 'AHORROS')
                                    ->setCellValue($celda17, $numcuenta);
                    }
                    else
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda14, '10')
                                    ->setCellValue($celda15, 'NINGUNO')
                                    ->setCellValue($celda16, 'NINGUNO')
                                    ->setCellValue($celda17, 'NINGUNA');
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda18, $diastrab)
                                ->setCellValue($celda19, number_format(intval($sueldoper)))
                                ->setCellValue($celda20, number_format(intval($auxtransp)));

                    // Incluyo los recargos nocturnos
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda21, $diasrecnoc)
                                ->setCellValue($celda22, number_format($montorecargonoc));

                    // hora extra diurna
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda23, $cantidaddehed)
                                ->setCellValue($celda24, number_format($montodehorasextrasdiura));

                    // hora extra nocturna
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda25, $cantidaddehen)
                                ->setCellValue($celda26, number_format($montohorextnoc));

                    // hora extra diurna dominical
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda27, $cantidaddehedd)
                                ->setCellValue($celda28, number_format($montohoraextdiudom));

                    // hora extra nocturna dominical y festivo
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda29, $cantidaddehendf)
                                ->setCellValue($celda30, number_format($montodehendf));

                    // domingos y festivos
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda31, $cantidaddedomfes)
                                ->setCellValue($celda32, number_format($montodedomfes));

                    // recargo nocturno dominical y festivo
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda33, $cantidadderecnocdonfes)
                                ->setCellValue($celda34, number_format($montoderecnocdonfes));
    
                    // Incluyo las incapacidades
                    if($numincap>0)
                    {
                        // Días de la(s) incapacidad(es)
                        $vsql5 = "SELECT IFNULL(SUM(valor),0) AS valor
                                    FROM hisdetallenomina 
                                   WHERE pernominaid IN ($listaperiodos) 
                                         AND conceptoid IN (10,43,40)
                                         AND terid = ".$terid."
                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                   FROM periodoterceros
                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                        AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                        AND periodoterceros.extralegal = 'CHECKED')";
                        $valorinc = $clase->SeleccionarUno($vsql5);
    
                        // Monto de la(s) incapacidad(es)
                        $vsql6 = "SELECT devengados
                                    FROM hisdetallenomina 
                                   WHERE pernominaid IN ($listaperiodos) 
                                         AND conceptoid IN (10,40)
                                         AND terid = ".$terid."
                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                   FROM periodoterceros
                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                        AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                        AND periodoterceros.extralegal = 'CHECKED')";

                        // --------------------------------------------------------------------------------------- //
                        $vsql105 = "SELECT c.nomconcepto AS nombreincapacidad
                                      FROM hisdetallenomina h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid IN ($listaperiodos) 
                                           AND c.conceptoid IN (10,43,40)
                                           AND h.terid = ".$terid."
                                           AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal = 'CHECKED')
                                     UNION ALL
                                    SELECT c.nomconcepto AS nombreincapacidad
                                      FROM detalleliquidacion h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid IN ($listaperiodos) 
                                           AND c.conceptoid IN (10,43,40)
                                           AND h.terid = ".$terid."";
                        $conex  = $clase->Conectar();
                        $result105 = mysql_query($vsql105,$conex);

                        $nombreincapacidad = "";
                        while($row105 = mysql_fetch_array($result105))
                        {                            
                            $nombreincapacidad.= $row105['nombreincapacidad'].", ";
                        }
                        $nombreincapacidad = substr($nombreincapacidad, 0, -2);
                        // --------------------------------------------------------------------------------------- //
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda35, $valorinc)
                                    ->setCellValue($celda36, $nombreincapacidad)
                                    ->setCellValue($celda37, number_format($devengadosinc));
                    }
                    else
                    {
                        $valorinc = 0;
                        $devengadosinc = 0;
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda35, $valorinc)
                                    ->setCellValue($celda36, 'NINGUNA')
                                    ->setCellValue($celda37, number_format($devengadosinc));
                    }
    
                    // Incluyo las licencias
                    if($numlicencias>0)
                    {
                        // Días de la(s) licencia(s)
                        $vsql3 = "SELECT IFNULL(SUM(h.valor),0) AS valorlic
                                    FROM hisdetallenomina h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND c.eslicencia = 'CHECKED' 
                                         AND c.tipodc = 'C' 
                                         AND h.conceptoid NOT IN (10,9,43,40,58) 
                                         AND h.terid = ".$terid."
                                         AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                          AND periodoterceros.extralegal = 'CHECKED')";
                        $valorlic = $clase->SeleccionarUno($vsql3);

                        // -------------------------------------------------------------------------------------------------- //
                        $vsqllicnoremuneradas = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem
                                                   FROM hisdetallenomina 
                                                  WHERE pernominaid IN ($listaperiodos)
                                                        AND conceptoid = 6
                                                        AND terid = ".$terid."
                                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                       AND periodoterceros.extralegal = 'CHECKED')";
                        $valorlicnorem = $clase->SeleccionarUno($vsqllicnoremuneradas);

                        $valorlic += $valorlicnorem;

                        // -------------------------------------------------------------------------------------------------- //
                        $vsql32 = "SELECT IFNULL(SUM(h.valor),0) AS valorlic
                                     FROM detalleliquidacion h 
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND c.eslicencia = 'CHECKED' 
                                          AND c.tipodc = 'C' 
                                          AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                          AND h.terid = ".$terid."
                                          AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                        $valorlic2 = $clase->SeleccionarUno($vsql32);

                        // -------------------------------------------------------------------------------------------------- //
                        $vsqllicnoremuneradas2 = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem2
                                                    FROM detalleliquidacion 
                                                   WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid."
                                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                                   FROM periodoterceros
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND pernominaid IN ($listaperiodos)
                                                                                        AND extralegal = 'CHECKED')";
                        $valorlicnorem2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                        $valorlic2 += $valorlicnorem2;
                        // -------------------------------------------------------------------------------------------------- //

                        $valorlic += $valorlic2;
    
                        // Monto de la(s) licencia(s)
                        $vsql4 = "SELECT SUM(h.devengados) AS devengadoslic 
                                    FROM detalleliquidacion h 
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid) 
                                   WHERE h.pernominaid IN ($listaperiodos) 
                                         AND c.eslicencia = 'CHECKED' 
                                         AND c.tipodc = 'C' 
                                         AND h.conceptoid NOT IN (10,9,43,40,58) 
                                         AND h.terid = ".$terid;
                        $devengadoslic = $clase->SeleccionarUno($vsql4);
    
                        // Construyo la descripción de todas las licencias en el periodo
                        $vsql10 = "SELECT c.nomconcepto AS nombrelicencia 
                                     FROM detalleliquidacion h 
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid) 
                                    WHERE h.pernominaid IN ($listaperiodos) 
                                          AND c.eslicencia = 'CHECKED'  
                                          AND c.tipodc = 'C' 
                                          AND h.conceptoid NOT IN (10,9,43,40,58) 
                                          AND h.terid = ".$terid."
                                    UNION ALL
                                   SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia
                                     FROM detalleliquidacion h 
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid = 6
                                          AND h.terid = ".$terid."";
                                            
                        $conex  = $clase->Conectar();
                        $result10 = mysql_query($vsql10,$conex);
    
                        $nombrelicencia = "";
                        while($row10 = mysql_fetch_array($result10))
                        {
                            $nombrelicencia.= $row10['nombrelicencia'].", ";
                        }
                        $nombrelicencia = substr($nombrelicencia, 0, -2);
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda38, $nombrelicencia)
                                    ->setCellValue($celda39, $valorlic)
                                    ->setCellValue($celda40, number_format($devengadoslic));
                    }
                    else
                    {
                        $valorlic = 0;
                        $devengadoslic = 0;
                        $nombrelicencia = "NINGUNA";
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda38, $nombrelicencia)
                                    ->setCellValue($celda39, $valorlic)
                                    ->setCellValue($celda40, number_format($devengadoslic));
                    }
    
                    // Embargo
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda41, number_format($embargo));
    
                    // otras deducciones
                    if(($numotrasded>0)&&($numotrasdedliq>0))
                    {
                        // Monto de las otras deducciones
                        $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                               AND h.terid = ".$terid;
                        $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                        $vsqlmontood2 = "SELECT SUM(h.descuentos) as montootrasdeduc2
                                           FROM hisdetallenomina h
                                                INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                          WHERE h.pernominaid IN ($listaperiodos)
                                            AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                            AND h.terid = ".$terid."
                                            AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                             AND periodoterceros.extralegal = 'CHECKED')";
                        $montootrasdeduc2 = $clase->SeleccionarUno($vsqlmontood);
                        $montootrasdeduc += $montootrasdeduc2;
    
                        // Consulta con los datos que se incluirán en el json
                        $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                    FROM hisdetallenomina h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                         AND h.terid = ".$terid." 
                                         AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                          AND periodoterceros.extralegal = 'CHECKED')";
    
                        $conex  = $clase->Conectar();
                        $result7 = mysql_query($vsql7,$conex);
    
                        $nombreoc = "";
                        while($row7 = mysql_fetch_array($result7))
                        {
                            $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                        }
                        $nombreoc = substr($nombreoc, 0, -2);
    
                        $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                     FROM detalleliquidacion h
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                          AND h.terid = ".$terid."";
    
                        $conex  = $clase->Conectar();
                        $result77 = mysql_query($vsql77,$conex);
    
                        $nombreoc = "";
                        while($row77 = mysql_fetch_array($result77))
                        {
                            $nombreoc.= $row77['nomconcepto']." (".number_format($row77['descuentos'])."), ";
                        }
                        $nombreoc = substr($nombreoc, 0, -2);
                    }
    
                    if(($numotrasded==0)&&($numotrasdedliq>0))
                    {
                        $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                               AND h.terid = ".$terid;
                        $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                        // Consulta con los datos que se incluirán en el json
                        $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                         AND h.terid = ".$terid;
    
                        $conex  = $clase->Conectar();
                        $result7 = mysql_query($vsql7,$conex);
                        $nombreoc = "";
                        while($row7 = mysql_fetch_array($result7))
                        {
                            $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                        }
                        $nombreoc = substr($nombreoc, 0, -2);
                    }
    
                    if(($numotrasded==0)&&($numotrasdedliq==0))
                    {
                        $nombreoc = "NINGUNO";
                        $montootrasdeduc = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda42, $nombreoc)
                                ->setCellValue($celda43, number_format($montootrasdeduc));
    
                    // Continuamos con salud y pensión
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda44, $por_sal_tra)
                                ->setCellValue($celda45, number_format(intval($salud)))
                                ->setCellValue($celda46, $por_pen_tra)
                                ->setCellValue($celda47, number_format(intval($pension)));
    
                    // sanciones
                    if($numsanciones>0)
                    {
                        $vsql66a = "SELECT h.descuentos AS montosancion 
                                      FROM hisdetallenomina h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid IN ($listaperiodos)
                                           AND h.conceptoid = 9
                                           AND h.terid = ".$terid." 
                                           AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                        $montosancion = $clase->SeleccionarUno($vsql66a);
                        $conceptosancion = "SUSPENCION";
                    }
                    else
                    {
                        $montosancion = 0;
                        $conceptosancion = "NINGUNA";
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda48, number_format($montosancion))
                                ->setCellValue($celda49, $conceptosancion);
    
                    if(($numlibranzas==0)&&($numlibranzasliq==0))
                    {
                        $nombrelibranza = "NINGUNA";
                        $montolibranza = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda50, $nombrelibranza)
                                ->setCellValue($celda51, number_format($montolibranza));
    
                    // primas
                    if($numprimas>0)
                    {
                        // Días de la prima
                        $vsqlcanprimas = "SELECT cantidad AS canprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                        // Pago de la prima
                        $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                             FROM liquidacion
                                            WHERE terid = ".$terid."
                                                  AND periodonomina = '".$codperiodo."' 
                                                  AND tipo = 'primas'";
                        $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);
    
                        $devengados += $pagoprimas;
                    }                
                    else
                    {
                        $canprimas = 0;
                        $pagoprimas = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda52, number_format($canprimas))
                                ->setCellValue($celda53, number_format($pagoprimas));
    
                    // Cesantías
                    if($numcesantias>0)
                    {
                        // Pago de la cesantía
                        $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                               FROM liquidacion
                                              WHERE terid = ".$terid." 
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);
    
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid." 
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        if($numpagocesan>0)
                        {
                            $vsqlnumpagocesan = "";
                            $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid." 
                                                        AND periodonomina = '".$codperiodo."'";
                            $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                            $pagocesantia += $montopagocesan;
                        }
    
                        // Porcentaje cesantía
                        $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);
    
                        // Pago de intereses de cesantías
                        $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'cesantias'";
                        $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);
    
                        $devengados += $pagocesantia;
                        $devengados += $pagointereses;
                    }
                    else
                    {
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        if($numpagocesan>0)
                        {
                            $vsqlnumpagocesan = "";
                            $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                            $pagocesantia = $montopagocesan;
                            $devengados += $pagocesantia;
                        }
                        else
                            $pagocesantia = 0;
                        
                        $porccesantia = 0;
                        $pagointereses = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda54, number_format($pagocesantia))
                                ->setCellValue($celda55, number_format($porccesantia))
                                ->setCellValue($celda56, number_format($pagointereses));
    
                    // vacaciones
                    if($numvacacionest>0)
                    {
                        if($numvacaciones1 > 0)
                        {
                            // Días de vacaciones
                            $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'vacaciones'";
                            $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                            // Pago de vacaciones
                            $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'vacaciones'";
                            $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                        }
                        else
                        {
                            $canvacaciones = 0;
                            $pagovaca1 = 0;
                        }

                        if($numvacaciones2>0)
                        {
                            $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                FROM hisdetallenomina  
                                               WHERE terid = ".$terid."
                                                     AND conceptoid = 38 
                                                     AND pernominaid IN ($listaperiodos)";
                            $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                        }
                        else
                            $pagovaca2 = 0;
                        
                        if($canvacaciones == 0)               $canvacaciones = 1;
                        $pagovaca = $pagovaca1 + $pagovaca2;    
                        $devengados += $pagovaca1;
                    }
                    else
                    {
                        $canvacaciones = 0;
                        $pagovaca = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda57, number_format($canvacaciones,2))
                                ->setCellValue($celda58, number_format($pagovaca));
    
                    // indemnización
                    if($numindemnizacion>0)
                    {
                        $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                        $devengados += $indemnizacion;
                    }
                    else
                        $indemnizacion = 0;
    
                    $objPHPExcel->setActiveSheetIndex(0)                                    
                                ->setCellValue($celda59, number_format($indemnizacion));
    
                    // otros devengados
                    if($numotrosdevenliq>0)
                    {
                        $vsqlotrosdeven = "SELECT SUM(IF(h.conceptoid IN (37,48),h.devengados,0)) AS otrosdeven
                                             FROM detalleliquidacion h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)                                                      
                                                  AND h.terid = ".$terid;
                        $otrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
    
                        $devengados += $otrosdeven;
                    }
                    else                        
                        $otrosdeven = 0;
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda60, number_format($otrosdeven));
    
                    // dotaciones
                    if(strlen($montodotacion)>0)
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda61, number_format($montodotacion));
                        $devengados += $montodotacion;
                    }
                    else
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda61, 0);
    
                    $neto = $devengados - $descuentos;
    
                    // Totales
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda62, number_format($devengados))
                                ->setCellValue($celda63, number_format($descuentos))
                                ->setCellValue($celda64, number_format($neto));
    
                    // Incremento el contador de líneas
                    $l++;
                    $listadereportados.= $terid.",";
                }
            }

            $listadereportados = substr($listadereportados, 0, -1);

            $rangoEncabezado = 'A9:BL9';
            $rangoCeldas     = 'A9:BL'.($l-1);
        }

        // ------------------------------------------------------------------------------------------------------- //
        // ciclo de los empleados con una quincena como extra legal y una liquidación
        $vsqlliquidacionsolo = "SELECT DISTINCT terid 
                                  FROM liquidacion 
                                 WHERE periodonomina = '".$codperiodo."'  
                                       AND terid IN (SELECT terid 
                                                       FROM periodoterceros 
                                                      WHERE pernominaid = ".$primquin." 
                                                            AND extralegal = 'CHECKED')
                                       AND terid IN (SELECT terid 
                                                       FROM detalleliquidacion 
                                                      WHERE pernominaid = ".$segnquin.")";

        if(strlen($listadereportados)>0)
            $vsqlliquidacionsolo.= " AND terid NOT IN ($listadereportados) ";

        if(strlen($nodebensalir) > 0)
            $vsqlliquidacionsolo.= " AND terid NOT IN ($nodebensalir) ";        

        $empleadosliquidacionsolo = 0;
        $m = $l;
        $conex  = $clase->Conectar();
        $resultliquidacionsolo = mysql_query($vsqlliquidacionsolo,$conex);
        $empleadosliquidacionsolo = mysql_num_rows($resultliquidacionsolo);

        if($empleadosliquidacionsolo > 0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";
            $celda1="";                                     $celda2="";                                     $celda3="";
            $celda4="";                                     $celda5="";                                     $celda6="";
            $celda7="";                                     $celda8="";                                     $celda9="";
            $celda10="";                                    $celda11="";                                    $celda12="";
            $celda13="";                                    $celda14="";                                    $celda15="";
            $celda16="";                                    $celda17="";                                    $celda18="";
            $celda19="";                                    $celda20="";                                    $celda21="";
            $celda22="";                                    $celda23="";                                    $celda24="";
            $celda25="";                                    $celda26="";                                    $celda27="";
            $celda28="";                                    $celda29="";                                    $celda30="";
            $celda31="";                                    $celda32="";                                    $celda33="";
            $celda34="";                                    $celda35="";                                    $celda36="";
            $celda37="";                                    $celda38="";                                    $celda39="";
            $celda40="";                                    $celda41="";                                    $celda42="";
            $celda43="";                                    $celda44="";                                    $celda45="";
            $celda46="";                                    $celda47="";                                    $celda48="";
            $celda49="";                                    $celda50="";                                    $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $listadereportados.= ",";                       $vsqlvextralegal = "";
            $numnomext = 0;                                 $vsqlnumvacaciones2 = "";                       $numvacaciones2 = 0;
            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;                                 $celda51="";
            $celda52 = "";

            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;            

            while($rowliqsolo = mysql_fetch_array($resultliquidacionsolo))
            {
                // id del empleado
                $terid = $rowliqsolo['terid'];

                // Documento del empleado
                $dni = $clase->BDLockup($terid,'terceros','terid','dni');

                // Primer apellido
                $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');

                // Segundo apellido
                $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');

                // Primer nombre
                $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');

                // Segundo nombre
                $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');

                // Sueldo básico
                $basico = $clase->BDLockup($terid,'terceros','terid','basico');

                // Código del trabajador
                $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');

                // Correo electrónico
                $email = $clase->BDLockup($terid,'terceros','terid','email');

                // Teléfono
                $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');

                // Número de cuenta
                $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');

                // Tipo de documento
                $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');

                // Banco
                $vsqlbanco = "SELECT b.descripcion AS banco
                                FROM periodoterceros p
                                     INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                               WHERE p.terid = ".$terid;
                $banco = $clase->SeleccionarUno($vsqlbanco);
                $banco = trim(str_replace("BANCO ","",$banco));

                // cargo del empleado
                $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');

                $sueldoper = 0;                     $auxtransp = 0;                 $embargo = 0;
                $salud = 0;                         $pension = 0;                   $devengados = 0;
                $descuentos = 0;

                // Obtengo la fecha de ingreso del empleado
                $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');

                $numincap = 0;                      $numlicencias = 0;                      $numlibranzas = 0;
                $numlibranzasliq = 0;               $numsanciones = 0;                      $numotrasded = 0;
                $numotrasdedliq = 0;                $diasrecnoc = 0;                        $montorecargonoc = 0;
                $horaextradiurnaliq = 0;            $horaextranocturnaliq = 0;              $horaextradiurnadomliq = 0;
                $horaextradnocturnadomfesliq = 0;   $domingosyfestivosliq = 0;              $recargonocdomfesliq = 0;

                // ------------------------------------------------------------------------------------------------------------------------------------------ //
                // Días trabajados en la liquidación
                $vsqldiasliq = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrabliq 
                                  FROM detalleliquidacion 
                                 WHERE pernominaid = ".$segnquin."  
                                       AND terid = ".$terid." 
                                       AND conceptoid = 1";
                $diastrab = $clase->SeleccionarUno($vsqldiasliq);

                // sueldo del periodo
                $vsqlsueldoliq = "SELECT devengados AS sueldoliq
                                    FROM detalleliquidacion
                                   WHERE terid = ".$terid."
                                         AND conceptoid = 1
                                         AND pernominaid = ".$segnquin;
                $sueldoper = $clase->SeleccionarUno($vsqlsueldoliq);

                // Auxilio de transporte     
                $vsqltransliq = "SELECT devengados AS transliq
                                   FROM detalleliquidacion
                                  WHERE terid = ".$terid."
                                        AND conceptoid = 3
                                        AND pernominaid = ".$segnquin;
                $auxtransp = $clase->SeleccionarUno($vsqltransliq);

                // Recargo nocturno
                $vsqlrecargonocliq = "SELECT devengados AS recargonocliq
                                        FROM detalleliquidacion
                                       WHERE terid = ".$terid."
                                             AND conceptoid IN (47,56,59) 
                                             AND pernominaid = ".$segnquin;
                $recargonoc = $clase->SeleccionarUno($vsqlrecargonocliq);

                // hora extra diurna
                $horaextradiurnaliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 49,devengados,0)) AS horaextradiurnaliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // hora extra nocturna
                $horaextranocturnaliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 50,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // hora extra diurna dominical
                $horaextradiurnadomliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 51,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // hora extra nocturna dominical y festivo
                $horaextradnocturnadomfesliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 52,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // domingos y festivos
                $domingosyfestivosliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 53,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");

                // recargo nocturno dominical y festivo
                $recargonocdomfesliq = $clase->SeleccionarUno("SELECT SUM(IF(conceptoid = 54,devengados,0)) AS recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)");                

                // Salud
                $vsqlsaludliq = "SELECT descuentos AS saludliq
                                   FROM detalleliquidacion
                                  WHERE terid = ".$terid."
                                        AND conceptoid = 5
                                        AND pernominaid = ".$segnquin;
                $salud = $clase->SeleccionarUno($vsqlsaludliq);

                // Pensión  
                $vsqlpesionliq = "SELECT descuentos AS pesionliq
                                    FROM detalleliquidacion
                                   WHERE terid = ".$terid."
                                        AND conceptoid = 4
                                        AND pernominaid = ".$segnquin;
                $pension = $clase->SeleccionarUno($vsqlpesionliq);

                // total devengado
                $vsqldevliq = "SELECT SUM(IF(pernominaid = ".$segnquin." ,devengados,0)) AS devengados 
                                 FROM detalleliquidacion 
                                WHERE terid = ".$terid;
                $devengados = $clase->SeleccionarUno($vsqldevliq);

                // total descuentos
                $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                  FROM detalleliquidacion 
                                 WHERE pernominaid = ".$segnquin."  
                                       AND terid = ".$terid."";
                $descuentos = $clase->SeleccionarUno($vsqldescliq);

                // Obtengo la fecha de ingreso del empleado
                $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');

                // // Incapacidades del periodo
                // $vsqlincapacidad2 = "SELECT COUNT(*) AS numincap
                //                        FROM detalleliquidacion 
                //                       WHERE pernominaid = ".$segnquin."  
                //                             AND terid = ".$terid."
                //                             AND conceptoid IN (10,43,40)";
                // $numincap = $clase->SeleccionarUno($vsqlincapacidad2);

                // Incapacidades del periodo
                $vsqlincapacidad = "SELECT COUNT(*) AS numincap
                                      FROM detalleliquidacion 
                                     WHERE pernominaid IN ($listaperiodos) 
                                           AND terid = ".$terid."
                                           AND conceptoid IN (10,43,40)";
                $numincap = $clase->SeleccionarUno($vsqlincapacidad);                

                // Licencias del periodo
                $vsqlincapacidad2 = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                       FROM detalleliquidacion h
                                            INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                      WHERE h.pernominaid = ".$segnquin." 
                                            AND c.eslicencia = 'CHECKED' 
                                            AND c.tipodc = 'C' 
                                            AND h.conceptoid NOT IN (10,9,43,40,58) 
                                            AND h.terid = ".$terid;
                $numlicencias = $clase->SeleccionarUno($vsqlincapacidad2);

                // licencias
                $vsqllicnoremuneradas2 = "SELECT COUNT(conceptoid) AS licnoremuneradas2 
                                            FROM detalleliquidacion 
                                           WHERE pernominaid = ".$segnquin." 
                                                 AND conceptoid = 6
                                                 AND terid = ".$terid;
                $numlicencias = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                // Libranzas del periodo
                $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                       FROM detalleliquidacion h
                                            INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                      WHERE h.pernominaid = ".$segnquin." 
                                            AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                            AND h.terid = ".$terid."
                                            AND c.conceptoid NOT IN (10,30)";
                $numlibranzas = $clase->SeleccionarUno($vsqllibranzasliq);

                // Sanciones del periodo
                $vsqlsanciones = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                    FROM detalleliquidacion h
                                            INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid = ".$segnquin." 
                                            AND h.conceptoid = 9
                                            AND h.terid = ".$terid;
                $numsanciones = $clase->SeleccionarUno($vsqlsanciones);                

                // otras deducciones en liquidación
                $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid = ".$segnquin." 
                                             AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                             AND h.terid = ".$terid;
                $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);

                // Otros conceptos devengados
                $vsqlotrosdevenliq = "SELECT COUNT(h.conceptoid) AS numotrosdevenliq
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid = ".$segnquin." 
                                             AND h.conceptoid IN (37,48) 
                                             AND h.terid = ".$terid;
                $numotrosdevenliq = $clase->SeleccionarUno($vsqlotrosdevenliq);
                // ------------------------------------------------------------------------------------------------------------------------------------------ //

                // Embargo
                $vsqlembliq = "SELECT IFNULL(SUM(descuentos),0)  AS embliq
                                 FROM detalleliquidacion
                                WHERE terid = ".$terid."
                                      AND conceptoid = 30
                                      AND pernominaid = ".$segnquin;
                $embargo = $clase->SeleccionarUno($vsqlembliq);

                // Vacaciones
                $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                        FROM liquidacion
                                       WHERE terid = ".$terid."
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'vacaciones'";
                $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                // Vacaciones pagadas en quincenas
                $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2
                                         FROM hisdetallenomina 
                                        WHERE terid = ".$terid."
                                              AND conceptoid = 38 
                                              AND pernominaid = ".$segnquin;
                $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                $numvacacionest = $numvacaciones1 + $numvacaciones2;

                // Primas
                $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                    FROM liquidacion
                                   WHERE terid = ".$terid."
                                         AND periodonomina = '".$codperiodo."' 
                                         AND tipo = 'primas'";
                $numprimas = $clase->SeleccionarUno($vsqlnumprimas);

                // Cesantías
                $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                       FROM liquidacion
                                      WHERE terid = ".$terid."
                                            AND periodonomina = '".$codperiodo."' 
                                            AND tipo = 'cesantias'";
                $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);

                // Indemnización
                $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                        FROM liquidacion
                                       WHERE terid = ".$terid."
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'indemnizacion'";
                $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);

                // $numotrosdevenliq = 0;
                $numotrosdeven = 0;

                // Dotaciones 
                $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                     FROM dotaciones
                                    WHERE periodonomina = '".$codperiodo."'
                                          AND terid = ".$terid."";
                $montodotacion = $clase->SeleccionarUno($vsqldotaciones);

                $celda1="A".strval($m);         $celda2="B".strval($m);         $celda3="C".strval($m);         $celda4="D".strval($m);         $celda5="E".strval($m);
                $celda6="F".strval($m);         $celda7="G".strval($m);         $celda8="H".strval($m);         $celda9="I".strval($m);         $celda10="J".strval($m);
                $celda11="K".strval($m);        $celda12="L".strval($m);        $celda13="M".strval($m);        $celda14="N".strval($m);        $celda15="O".strval($m);
                $celda16="P".strval($m);        $celda17="Q".strval($m);        $celda18="R".strval($m);        $celda19="S".strval($m);        $celda20="T".strval($m);
                $celda21="U".strval($m);        $celda22="V".strval($m);        $celda23="W".strval($m);        $celda24="X".strval($m);        $celda25="Y".strval($m);
                $celda26="Z".strval($m);        $celda27="AA".strval($m);       $celda28="AB".strval($m);       $celda29="AC".strval($m);       $celda30="AD".strval($m);
                $celda31="AE".strval($m);       $celda32="AF".strval($m);       $celda33="AG".strval($m);       $celda34="AH".strval($m);       $celda35="AI".strval($m);
                $celda36="AJ".strval($m);       $celda37="AK".strval($m);       $celda38="AL".strval($m);       $celda39="AM".strval($m);       $celda40="AN".strval($m);
                $celda41="AO".strval($m);       $celda42="AP".strval($m);       $celda43="AQ".strval($m);       $celda44="AR".strval($m);       $celda45="AS".strval($m);
                $celda46="AT".strval($m);       $celda47="AU".strval($m);       $celda48="AV".strval($m);       $celda49="AW".strval($m);       $celda50="AX".strval($m);
                $celda51="AY".strval($m);       $celda52="AZ".strval($m);       $celda53="BA".strval($m);       $celda54="BB".strval($m);       $celda55="BC".strval($m);
                $celda56="BD".strval($m);       $celda57="BE".strval($m);       $celda58="BF".strval($m);       $celda59="BG".strval($m);       $celda60="BH".strval($m);
                $celda61="BI".strval($m);       $celda62="BJ".strval($m);       $celda63="BK".strval($m);       $celda64="BL".strval($m);

                // Escribo en la hoja de Excel
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda1, $fecingreso)
                            ->setCellValue($celda2, '01')
                            ->setCellValue($celda3, '00')
                            ->setCellValue($celda4, 'true')
                            ->setCellValue($celda5,'13')
                            ->setCellValue($celda6, $dni)
                            ->setCellValue($celda7, $primerapellido)
                            ->setCellValue($celda8, $segundoapellido)
                            ->setCellValue($celda9, $primernombre)
                            ->setCellValue($celda10, $segundonombre)
                            ->setCellValue($celda11, number_format($basico))
                            ->setCellValue($celda12, $codvende)
                            ->setCellValue($celda13, '1');

                // Identifico la forma de pago
                if($numcuenta!="")
                {
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda14, '45')
                                ->setCellValue($celda15, $banco)
                                ->setCellValue($celda16, 'AHORROS')
                                ->setCellValue($celda17, $numcuenta);
                }
                else
                {
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda14, '10')
                                ->setCellValue($celda15, 'NINGUNO')
                                ->setCellValue($celda16, 'NINGUNO')
                                ->setCellValue($celda17, 'NINGUNA');
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda18, $diastrab)
                            ->setCellValue($celda19, number_format(intval($sueldoper)))
                            ->setCellValue($celda20, number_format(intval($auxtransp)));

                // Incluyo los recargos nocturnos
                if($recargonoc > 0)
                {
                    // Días de recargo nocturno
                    $vsql30 = "SELECT IFNULL(SUM(valor),0) AS valor
                                 FROM detalleliquidacion 
                                WHERE pernominaid IN ($listaperiodos) 
                                      AND conceptoid IN (47,56,59) 
                                      AND terid = ".$terid;
                    $diasrecnoc = $clase->SeleccionarUno($vsql30);

                    $vsql33 = "SELECT IFNULL(SUM(devengados),0) AS devengados 
                                 FROM detalleliquidacion 
                                WHERE pernominaid IN ($listaperiodos) 
                                      AND conceptoid IN (47,56,59)  
                                      AND terid = ".$terid;
                    $montorecargonoc = $clase->SeleccionarUno($vsql33);
                }
                else
                {
                    $diasrecnoc = 0;
                    $montorecargonoc = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda21, $diasrecnoc)
                            ->setCellValue($celda22, number_format($montorecargonoc));

                // hora extra diurna
                if($horaextradiurnaliq > 0)
                {
                    $cantidadhedliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 49");
                    $montohoraextdiurnaliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 49");
                }
                else
                {
                    $cantidadhedliq = 0;
                    $montohoraextdiurnaliq = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda23, $cantidadhedliq)
                            ->setCellValue($celda24, number_format($montohoraextdiurnaliq));

                // hora extra nocturna
                if($horaextranocturnaliq > 0)
                {
                    $cantidadhenliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 50");
                    $montohoraextnocturnaliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 50");
                }
                else
                {
                    $cantidadhenliq = 0;
                    $montohoraextnocturnaliq = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda25, $cantidadhenliq)
                            ->setCellValue($celda26, number_format($montohoraextnocturnaliq));

                // hora extra diurna dominical
                if($horaextradiurnadomliq > 0)
                {
                    $cantidadheddliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 51");
                    $montohoraextddomliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 51");
                }
                else
                {
                    $cantidadheddliq = 0;
                    $montohoraextddomliq = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda27, $cantidadheddliq)
                            ->setCellValue($celda28, number_format($montohoraextddomliq));

                // hora extra nocturna dominical y festivo
                if($horaextradnocturnadomfesliq > 0)
                {
                    $cantidadhendfliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 52");
                    $montohendfliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 52");
                }
                else
                {
                    $cantidadhendfliq = 0;
                    $montohendfliq = 0;
                }                    

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda29, $cantidadhendfliq)
                            ->setCellValue($celda30, number_format($montohendfliq));

                // domingos y festivos
                if($domingosyfestivosliq > 0)
                {
                    $cantidaddomfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 53");
                    $montodomfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 53");
                }
                else
                {
                    $cantidaddomfesliq = 0;
                    $montodomfesliq = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda31, $cantidaddomfesliq)
                            ->setCellValue($celda32, number_format($montodomfesliq));

                // recargo nocturno dominical y festivo
                if($recargonocdomfesliq > 0)
                {
                    $cantidadrecnocdonfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(valor),0) AS valor FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 54");
                    $montorecnocdonfesliq = $clase->SeleccionarUno("SELECT IFNULL(SUM(devengados),0) AS devengados FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid." AND conceptoid = 54");
                }
                else
                {
                    $cantidadrecnocdonfesliq = 0;
                    $montorecnocdonfesliq = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda33, $cantidadrecnocdonfesliq)
                            ->setCellValue($celda34, number_format($montorecnocdonfesliq));

                // Incluyo las incapacidades
                if($numincap>0)
                {
                    // Días de la(s) incapacidad(es)
                    $vsql5 = "SELECT IFNULL(SUM(valor),0) AS valor
                                FROM hisdetallenomina 
                               WHERE pernominaid IN ($listaperiodos)  
                                     AND conceptoid IN (10,43,40)
                                     AND terid = ".$terid."
                                     AND pernominaid NOT IN (SELECT pernominaid 
                                                               FROM periodoterceros
                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                    AND periodoterceros.pernominaid IN ($listaperiodos) 
                                                                    AND periodoterceros.extralegal = 'CHECKED')";
                    $valorinc = $clase->SeleccionarUno($vsql5);

                    // Monto de la(s) incapacidad(es)
                    $vsql6 = "SELECT devengados
                                FROM hisdetallenomina 
                               WHERE pernominaid IN ($listaperiodos)  
                                     AND conceptoid IN (10,40)
                                     AND terid = ".$terid."
                                     AND pernominaid NOT IN (SELECT pernominaid 
                                                               FROM periodoterceros
                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                    AND periodoterceros.pernominaid IN ($listaperiodos) 
                                                                    AND periodoterceros.extralegal = 'CHECKED')";

                    // --------------------------------------------------------------------------------------- //
                    $vsql105 = "SELECT c.nomconcepto AS nombreincapacidad
                                  FROM hisdetallenomina h
                                       INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                 WHERE h.pernominaid IN ($listaperiodos)  
                                       AND c.conceptoid IN (10,43,40)
                                       AND h.terid = ".$terid."
                                       AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                   FROM periodoterceros
                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                        AND pernominaid IN ($listaperiodos) 
                                                                        AND extralegal = 'CHECKED')
                                 UNION ALL
                                SELECT c.nomconcepto AS nombreincapacidad
                                  FROM detalleliquidacion h
                                       INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                 WHERE h.pernominaid IN ($listaperiodos)  
                                       AND c.conceptoid IN (10,43,40)
                                       AND h.terid = ".$terid."";
                    $conex  = $clase->Conectar();
                    $result105 = mysql_query($vsql105,$conex);

                    $nombreincapacidad = "";
                    while($row105 = mysql_fetch_array($result105))
                    {                            
                        $nombreincapacidad.= $row105['nombreincapacidad'].", ";
                    }
                    $nombreincapacidad = substr($nombreincapacidad, 0, -2);
                    // --------------------------------------------------------------------------------------- //

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda35, $valorinc)
                                ->setCellValue($celda36, $nombreincapacidad)
                                ->setCellValue($celda37, number_format($devengadosinc));
                }
                else
                {
                    $valorinc = 0;
                    $devengadosinc = 0;
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda35, $valorinc)
                                ->setCellValue($celda36, 'NINGUNA')
                                ->setCellValue($celda37, number_format($devengadosinc));
                }

                // Incluyo las licencias
                if($numlicencias>0)
                {
                    // Días de la(s) licencia(s)
                    $vsql3 = "SELECT IFNULL(SUM(h.valor),0) AS valorlic
                                FROM hisdetallenomina h
                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                               WHERE h.pernominaid = ".$segnquin." 
                                     AND c.eslicencia ='CHECKED' 
                                     AND c.tipodc = 'C' 
                                     AND h.conceptoid NOT IN (10,9,43,40,58) 
                                     AND h.terid = ".$terid."
                                     AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                 FROM periodoterceros
                                                                WHERE periodoterceros.terid = ".$terid." 
                                                                      AND periodoterceros.pernominaid = ".$segnquin." 
                                                                      AND periodoterceros.extralegal = 'CHECKED')";
                    $valorlic = $clase->SeleccionarUno($vsql3);

                    // -------------------------------------------------------------------------------------------------- //
                    $vsqllicnoremuneradas = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem
                                               FROM hisdetallenomina 
                                              WHERE pernominaid = ".$segnquin." 
                                                    AND conceptoid = 6
                                                    AND terid = ".$terid."
                                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid = ".$segnquin." 
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                    $valorlicnorem = $clase->SeleccionarUno($vsqllicnoremuneradas);

                    $valorlic += $valorlicnorem;

                    // -------------------------------------------------------------------------------------------------- //
                    $vsql32 = "SELECT IFNULL(SUM(h.valor),0) AS valorlic
                                 FROM detalleliquidacion h 
                                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                WHERE h.pernominaid = ".$segnquin." 
                                      AND c.eslicencia = 'CHECKED' 
                                      AND c.tipodc = 'C' 
                                      AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                      AND h.terid = ".$terid."
                                      AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                  FROM periodoterceros
                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                       AND periodoterceros.pernominaid = ".$segnquin." 
                                                                       AND periodoterceros.extralegal = 'CHECKED')";
                    $valorlic2 = $clase->SeleccionarUno($vsql32);

                    // -------------------------------------------------------------------------------------------------- //
                    $vsqllicnoremuneradas2 = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem2
                                                FROM detalleliquidacion 
                                               WHERE pernominaid = ".$segnquin." 
                                                     AND conceptoid = 6
                                                     AND terid = ".$terid."
                                                     AND pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND pernominaid = ".$segnquin." 
                                                                                    AND extralegal = 'CHECKED')";
                    $valorlicnorem2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                    $valorlic2 += $valorlicnorem2;
                    // -------------------------------------------------------------------------------------------------- //

                    $valorlic += $valorlic2;

                    // Monto de la(s) licencia(s)
                    $vsql4 = "SELECT SUM(h.devengados) AS devengadoslic 
                                FROM detalleliquidacion h 
                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid) 
                               WHERE h.pernominaid = ".$segnquin."  
                                     AND c.eslicencia = 'CHECKED' 
                                     AND c.tipodc = 'C' 
                                     AND h.conceptoid NOT IN (10,9,43,40,58) 
                                     AND h.terid = ".$terid;
                    $devengadoslic = $clase->SeleccionarUno($vsql4);

                    // Construyo la descripción de todas las licencias en el periodo
                    $vsql10 = "SELECT c.nomconcepto AS nombrelicencia 
                                 FROM detalleliquidacion h 
                                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid) 
                                WHERE h.pernominaid = ".$segnquin."  
                                      AND c.eslicencia = 'CHECKED'  
                                      AND c.tipodc = 'C' 
                                      AND h.conceptoid NOT IN (10,9,43,40,58) 
                                      AND h.terid = ".$terid."
                                UNION ALL
                               SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia
                                 FROM detalleliquidacion h 
                                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                WHERE h.pernominaid = ".$segnquin." 
                                      AND h.conceptoid = 6
                                      AND h.terid = ".$terid."";
                                        
                    $conex  = $clase->Conectar();
                    $result10 = mysql_query($vsql10,$conex);

                    $nombrelicencia = "";
                    while($row10 = mysql_fetch_array($result10))
                    {
                        $nombrelicencia.= $row10['nombrelicencia'].", ";
                    }
                    $nombrelicencia = substr($nombrelicencia, 0, -2);

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda38, $nombrelicencia)
                                ->setCellValue($celda39, $valorlic)
                                ->setCellValue($celda40, number_format($devengadoslic));
                }
                else
                {
                    $valorlic = 0;
                    $devengadoslic = 0;
                    $nombrelicencia = "NINGUNA";

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda38, $nombrelicencia)
                                ->setCellValue($celda39, $valorlic)
                                ->setCellValue($celda40, number_format($devengadoslic));
                }

                // Embargo
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda41, number_format($embargo));

                // otras deducciones
                if(($numotrasded>0)&&($numotrasdedliq>0))
                {
                    // Monto de las otras deducciones
                    $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                      FROM detalleliquidacion h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid = ".$segnquin." 
                                           AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                           AND h.terid = ".$terid;
                    $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);

                    $vsqlmontood2 = "SELECT SUM(h.descuentos) as montootrasdeduc2
                                       FROM hisdetallenomina h
                                            INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                      WHERE h.pernominaid = ".$segnquin." 
                                        AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                        AND h.terid = ".$terid."
                                        AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                    FROM periodoterceros
                                                                   WHERE periodoterceros.terid = ".$terid." 
                                                                         AND periodoterceros.pernominaid = ".$segnquin." 
                                                                         AND periodoterceros.extralegal = 'CHECKED')";
                    $montootrasdeduc2 = $clase->SeleccionarUno($vsqlmontood);
                    $montootrasdeduc += $montootrasdeduc2;

                    // Consulta con los datos que se incluirán en el json
                    $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                FROM hisdetallenomina h
                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                               WHERE h.pernominaid = ".$segnquin." 
                                     AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                     AND h.terid = ".$terid."
                                     AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                 FROM periodoterceros
                                                                WHERE periodoterceros.terid = ".$terid." 
                                                                      AND periodoterceros.pernominaid = ".$segnquin." 
                                                                      AND periodoterceros.extralegal = 'CHECKED')";

                    $conex  = $clase->Conectar();
                    $result7 = mysql_query($vsql7,$conex);

                    $nombreoc = "";
                    while($row7 = mysql_fetch_array($result7))
                    {
                        $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                    }
                    $nombreoc = substr($nombreoc, 0, -2);

                    $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                 FROM detalleliquidacion h
                                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                WHERE h.pernominaid = ".$segnquin." 
                                      AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                      AND h.terid = ".$terid."";

                    $conex  = $clase->Conectar();
                    $result77 = mysql_query($vsql77,$conex);

                    $nombreoc = "";
                    while($row77 = mysql_fetch_array($result77))
                    {
                        $nombreoc.= $row77['nomconcepto']." (".number_format($row77['descuentos'])."), ";
                    }
                    $nombreoc = substr($nombreoc, 0, -2);
                }

                if(($numotrasded==0)&&($numotrasdedliq>0))
                {
                    $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                      FROM detalleliquidacion h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid = ".$segnquin." 
                                           AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                           AND h.terid = ".$terid;
                    $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);

                    // Consulta con los datos que se incluirán en el json
                    $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                FROM detalleliquidacion h
                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                               WHERE h.pernominaid = ".$segnquin." 
                                     AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                     AND h.terid = ".$terid;

                    $conex  = $clase->Conectar();
                    $result7 = mysql_query($vsql7,$conex);
                    $nombreoc = "";
                    while($row7 = mysql_fetch_array($result7))
                    {
                        $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                    }
                    $nombreoc = substr($nombreoc, 0, -2);
                }

                if(($numotrasded==0)&&($numotrasdedliq==0))
                {
                    $nombreoc = "NINGUNO";
                    $montootrasdeduc = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda42, $nombreoc)
                            ->setCellValue($celda43, number_format($montootrasdeduc));

                // Continuamos con salud y pensión
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda44, $por_sal_tra)
                            ->setCellValue($celda45, number_format(intval($salud)))
                            ->setCellValue($celda46, $por_pen_tra)
                            ->setCellValue($celda47, number_format(intval($pension)));

                // sanciones
                if($numsanciones>0)
                {
                    $vsql66a = "SELECT h.descuentos AS montosancion 
                                  FROM hisdetallenomina h
                                       INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                 WHERE h.pernominaid = ".$segnquin." 
                                       AND h.conceptoid = 9
                                       AND h.terid = ".$terid."
                                       AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                   FROM periodoterceros
                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                        AND periodoterceros.pernominaid = ".$segnquin." 
                                                                        AND periodoterceros.extralegal = 'CHECKED')";
                    $montosancion = $clase->SeleccionarUno($vsql66a);
                    $conceptosancion = "SUSPENCION";
                }
                else
                {
                    $montosancion = 0;
                    $conceptosancion = "NINGUNA";
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda48, number_format($montosancion))
                            ->setCellValue($celda49, $conceptosancion);

                if(($numlibranzas==0)&&($numlibranzasliq==0))
                {
                    $nombrelibranza = "NINGUNA";
                    $montolibranza = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda50, $nombrelibranza)
                            ->setCellValue($celda51, number_format($montolibranza));

                // primas
                if($numprimas>0)
                {
                    // Días de la prima
                    $vsqlcanprimas = "SELECT cantidad AS canprimas
                                        FROM liquidacion
                                       WHERE terid = ".$terid."
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'primas'";
                    $canprimas = $clase->SeleccionarUno($vsqlcanprimas);

                    // Pago de la prima
                    $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                         FROM liquidacion
                                        WHERE terid = ".$terid."
                                              AND periodonomina = '".$codperiodo."' 
                                              AND tipo = 'primas'";
                    $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);

                    $devengados += $pagoprimas;
                }                
                else
                {
                    $canprimas = 0;
                    $pagoprimas = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda52, number_format($canprimas))
                            ->setCellValue($celda53, number_format($pagoprimas));

                // Cesantías
                if($numcesantias>0)
                {
                    // Pago de la cesantía
                    $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                           FROM liquidacion
                                          WHERE terid = ".$terid." 
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'cesantias'";
                    $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);

                    // Pagos del fondo de cesantías
                    $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                           FROM pagocesantias
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."'";
                    $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                    if($numpagocesan>0)
                    {
                        $vsqlnumpagocesan = "";
                        $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                        $pagocesantia += $montopagocesan;
                    }

                    // Porcentaje cesantía
                    $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                           FROM liquidacion
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'cesantias'";
                    $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);

                    // Pago de intereses de cesantías
                    $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'cesantias'";
                    $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);

                    $devengados += $pagocesantia;
                    $devengados += $pagointereses;
                }
                else
                {
                    // Pagos del fondo de cesantías
                    $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                           FROM pagocesantias
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."'";
                    $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                    if($numpagocesan>0)
                    {
                        $vsqlnumpagocesan = "";
                        $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                        $pagocesantia = $montopagocesan;
                        $devengados += $pagocesantia;
                    }
                    else
                        $pagocesantia = 0;
                    
                    $porccesantia = 0;
                    $pagointereses = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda54, number_format($pagocesantia))
                            ->setCellValue($celda55, number_format($porccesantia))
                            ->setCellValue($celda56, number_format($pagointereses));

                // vacaciones
                if($numvacacionest>0)
                {
                    if($numvacaciones1 > 0)
                    {
                        // Días de vacaciones
                        $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'vacaciones'";
                        $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                        // Pago de vacaciones
                        $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                           FROM liquidacion
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'vacaciones'";
                        $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                    }
                    else
                    {
                        $canvacaciones = 0;
                        $pagovaca1 = 0;
                    }

                    if($numvacaciones2>0)
                    {
                        $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                            FROM hisdetallenomina  
                                           WHERE terid = ".$terid."
                                                 AND conceptoid = 38 
                                                 AND pernominaid = ".$segnquin." ";
                        $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                    }
                    else
                        $pagovaca2 = 0;
                    
                    if($canvacaciones == 0)               $canvacaciones = 1;
                    $pagovaca = $pagovaca1 + $pagovaca2;    
                    $devengados += $pagovaca1;
                }
                else
                {
                    $canvacaciones = 0;
                    $pagovaca = 0;
                }

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda57, number_format($canvacaciones,2))
                            ->setCellValue($celda58, number_format($pagovaca));

                // indemnización
                if($numindemnizacion>0)
                {
                    $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'indemnizacion'";
                    $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);

                    $devengados += $indemnizacion;
                }
                else
                    $indemnizacion = 0;

                $objPHPExcel->setActiveSheetIndex(0)                                    
                            ->setCellValue($celda59, number_format($indemnizacion));

                // otros devengados
                if($numotrosdevenliq>0)
                {
                    $vsqlotrosdeven = "SELECT SUM(IF(h.conceptoid IN (37,48),h.devengados,0)) AS otrosdeven
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid = ".$segnquin."                                                       
                                              AND h.terid = ".$terid;
                    $otrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);

                    $devengados += $otrosdeven;
                }
                else                        
                    $otrosdeven = 0;

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda60, number_format($otrosdeven));

                // dotaciones
                if(strlen($montodotacion)>0)
                {
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda61, number_format($montodotacion));
                    $devengados += $montodotacion;
                }
                else
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda61, 0);

                $neto = $devengados - $descuentos;

                // Totales
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue($celda62, number_format($devengados))
                            ->setCellValue($celda63, number_format($descuentos))
                            ->setCellValue($celda64, number_format($neto));

                // Incremento el contador de líneas
                $l++;
                $listadereportados.= $terid.",";
            }

            $listadereportados = substr($listadereportados, 0, -1);

            $rangoEncabezado = 'A9:BL9';
            $rangoCeldas     = 'A9:BL'.($m-1);
        }

        // ------------------------------------------------------------------------------------------------------- //
        // // Esta una prueba de los empleados sin días trabajados en el mes pero con pago de cesantías
        // $prueba ="SELECT p.terid 
        //             FROM pagocesantias p 
        //            WHERE p.periodonomina = '".$codperiodo."' 
        //                  AND p.terid IN (SELECT hisdetallenomina.terid 
        //                                    FROM hisdetallenomina 
        //                                   WHERE hisdetallenomina.terid = p.terid 
        //                                         AND hisdetallenomina.pernominaid IN ($listaperiodos) 
        //                                         AND hisdetallenomina.conceptoid NOT IN (1,3,4,5))";

        // if(strlen($listadereportados)>0)            $prueba.= " AND p.terid NOT IN ($listadereportados)";

        // echo $prueba; exit();
        // ------------------------------------------------------------------------------------------------------- //

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('nómina electrónica');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // ------------------------------------------------------------------------------- //        
        $nombrearcexcel = "nómina electrónica del periodo ".strtolower($desperiodo).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // ------------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
        
        if(($empleadosreportar>0)||($empleadosreportarliq>0)||($empleadoscambiados>0))
            $clase->Aviso(1,"La hoja de Excel se generó exitosamente");
        else
            $clase->Aviso(3,"No se generó la hoja de Excel");
        
        header("Location: principal.php?");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: corregirnom
    // Creación: 12/11/2022		última modificación: 12/08/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que presenta la ventana donde están los registros incompletos de 
    //              la transmisión
    // Última modificación: Inclusión del botón para ver el archivo json de empleado.
    //                      (11/01/2024)
    //                      Botón para refrescar la ventana
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "corregirnom")
    {
        // Periodo recientemente transmitido
        $vsql = "SELECT periodonomina FROM periododian WHERE periododiamid = (SELECT MAX(periododiamid) FROM periododian)";
        $periodonomina = $clase->SeleccionarUno($vsql);

        // nombre del periodo
        $desperiodo = $clase->BDLockup($periodonomina,'periodos','codperiodo','desperiodo');

        // Número de registros a corregir
        $vsql = "SELECT COUNT(d.idperiodo) 
                   FROM terceros t
                        INNER JOIN dianterceros d ON (t.terid = d.terid)
                        INNER JOIN periododian p ON (d.periodonomina = p.periododiamid)
                  WHERE p.periodonomina = '".$periodonomina."'
                        AND (d.cune = '' OR d.respuesta = '')";
        $numeroreg = $clase->SeleccionarUno($vsql);

        // Consulta del informe
        $vsql = "SELECT d.idperiodo, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                        d.cune, d.respuesta 
                   FROM terceros t
                        INNER JOIN dianterceros d ON (t.terid = d.terid)
                        INNER JOIN periododian p ON (d.periodonomina = p.periododiamid)
                  WHERE p.periodonomina = '".$periodonomina."'
                        AND (d.cune = '' OR d.respuesta = '')
               ORDER BY nombreemp";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td width="900"> 
                   <b>Corregir registros de la n&oacute;mina electr&oacute;nica del periodo <font color="BLUE">'.$desperiodo.'</font></b> 
                   <br> '.$numeroreg.' registros incompletos
                  </td>                  
                  <td width="30"> 
                  <a href="?opcion=corregirnom" title="refrescar el formulario"> 
                  <img src="images/iconos/refrescar.png" border="0" width="32" height="32">  
                  </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> <a href="nominaelectronica.php?opcion=ventanadatos"> <input type="button" value="<<" class="button blue"> </a> </td> 
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                 <table width="100%" class="sortable">
                  <thead> 
                   <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                    <td width="20">&nbsp;</td>
                    <td width="90" align="left"> Documento </td>				 				 
                    <td width="255" align="left"><p>Nombre</p></td>				 				                  
                    <td width="605" align="left">&nbsp;</td>			
                    <td width="50" align="left">&nbsp;</td>			
                    <td width="60">&nbsp;</td>					
                   </tr>
                  </thead>
                  <tbody style="display:block; width:1050px; height:490px; overflow-Y:scroll">';

        // inicializamos las variables
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
                
            $cont.=' <td width="20">&nbsp;</td>
                     <td width="90" align="left"> '.$row['dni'].' </td>
                     <td width="340" align="left">'.$row['nombreemp'].'</td>
                     <td width="10">&nbsp;</td>					          
                     <td width="520" align="left">&nbsp;</td>
                     <td width="20" align="center">
                      <a href="?opcion=verjson&dni='.$row['dni'].'&periodonomina='.$periodonomina.'" rel="facebox" title="ver json del empleado"> 
                       <img src="images/basicas/existencias.png" border="0">
                      </a>
                     </td>
                     <td width="10">&nbsp;</td>
                     <td width="20" align="center">
                      <a href="?opcion=editarreg&idperiodo='.$row['idperiodo'].'" rel="facebox" title="editar registro"> 
                       <img src="images/basicas/iconobuscar.png" border="0">
                      </a>
                     </td>
                    </tr>';
        }

        $cont.=' </tbody> 
                </table>';

        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="20"> &nbsp; </td>
                  <td width="375" align="left"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="616" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';

        echo $cont.$clase->PiePagina();
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarreg
    // Creación: 15/11/2022		última modificación: 13/01/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana para ingresar la respuesta y el cune que faltaron en la 
    //              transmisión
    // Última modificación: Optimización de espaciado entre campos
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarreg")
    {
        $idperiodo  = $_GET['idperiodo'];

        // Nombre del empleado
        $terid = $clase->BDLockup($idperiodo,'dianterceros','idperiodo','terid');
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                   FROM terceros 
                  WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql);

        // documento
        $dni = $clase->BDLockup($terid,'terceros','terid','dni');
        $respuesta = $clase->BDLockup($idperiodo,'dianterceros','idperiodo','respuesta');
        $cune = $clase->BDLockup($idperiodo,'dianterceros','idperiodo','cune');

        // pinto la ventana
        $cont= '<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b>Editar registro tabla dianterceros</b> </td>                  
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> C&eacute;dula: <br>'.$dni.' </td> 
                 </tr>                 
                 <tr class="CabezoteTabla"> 
                  <td align="center"> Empleado(a): <br>'.$nombreemp.' </td>                   
                 </tr>
                </table>
                <form action="?opcion=guardarcorreccion" method="POST" name="x">                
                <input type="hidden" name="idperiodo" value="'.$idperiodo.'">
                <table width="400">
                 <center>
                 <tr class="TablaDocsImPar">
                  <td width="150" align="right"> Respuesta: &nbsp</td> 			  
                  <td width="250">
                   <br><br>
                   <input type="text" class="Texto11" name="respuesta" size="15" maxlenght="15" value="'.$respuesta.'" style="text-transform:uppercase!Important;width:60px;height:25px" autocomplete="off">
                   <br><br><br>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="150" align="right"> Cune: &nbsp;</td>
                  <td width="250"> <textarea name="cune" cols="40" rows="3" >'.$cune.'</textarea></td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarcorreccion
    // Creación: 15/11/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción donde se almacenan los datos que faltaron en la transmisión de 
    //              la nómina electrónica
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarcorreccion")
    {
        $idperiodo = $_POST['idperiodo'];
        $cune = $_POST['cune'];
        $respuesta = $_POST['respuesta'];

        // Valido los datos
        if((strlen($cune) == 0)||(strlen($respuesta) == 0))
            $clase->Aviso(3,"Debe ingresar el cune y la respuesta");
        else
        {
            // Guardo los datos
            $vsql = "UPDATE dianterceros SET 
                            cune = '".$cune."',
                            respuesta = '".$respuesta."'
                      WHERE idperiodo = ".$idperiodo;
            $clase->EjecutarSQL($vsql);

            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"Registro almacenado satisfactoriamente");
            else
                $clase->Aviso(3,"No se almacenó el registro");
        }

        // Redirecciono el formulario
        header("Location: nominaelectronica.php?opcion=corregirnom");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: verjson
    // Creación: 11/01/2024		última modificación: 15/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para visualizar el archivo json que será corregido
    // Última modificación: Botón de copiar contenido del textarea
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "verjson")
    {
        $dni = $_GET['dni'];
        $periodonomina = $_GET['periodonomina'];

        // inicialización de variables
        $archivojson = "nominaelectronica/".$periodonomina."/".$dni.".json";
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE dni = '".$dni."'";
        $nombreemp = $clase->SeleccionarUno($vsql);
        $json = "";

        $plantilla = fopen($archivojson,"r") or die("error al leer archivo");

        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $json.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        $json = trim(str_replace("<br />","",$json));
        $cont.='<script language="javascript">
                 let texto = document.getElementById("txt").innerHTML;
                 const copiarContenido = async () => {
                 try {
                     await navigator.clipboard.writeText(texto);
                     console.log("Contenido copiado al portapapeles");
                 } catch (err) {
                     console.error("Error al copiar: ", err);
                 }
                 }
                </script>
                <table width="600">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Archivo json de <br> <font color="blue"> '.$nombreemp.' </font> <br> en el periodo <font color="blue"> '.$periodonomina.' </font> </b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" id="txt" cols="80" rows="38" disabled> '.$json.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
                   <a href="nominaelectronica.php?opcion=corregirnom"><input type="button" value="cerrar" class="button blue"></a>
                   &nbsp;&nbsp;
                   <button class="button green" onclick="copiarContenido()"> Copiar </button>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: crudperiodos
    // Creación: 12/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana con la vista de los periodos de nómina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "crudperiodos")
    {
        $codperiodo = $_GET['codperiodo'];
     
        // pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/guardardoc.png" width="32" height="32" border="0"> </td>
                  <td width="790"> <b>Periodos Dian</b> </td>
                  <td width="40"> 
                   <a href="?opcion=nuevo&codperiodo='.$codperiodo.'"> 
                   <img src="images/iconos/nuevodoc.png" width="38" height="38" border="0" title="incluir periodo"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <form action="?opcion=encontrar&codperiodo='.$codperiodo.'" method="POST" name="x">
                  <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                  <td> <input type="text" name="criterio" size="30" placeholder="Criterio a Buscar" tabindex="1" id="default"> </td>
                  <td> <input type="submit" value="Encontrar" class="button"></form> </td>';

        if($_SESSION['SQL_PERIODODIAN'] != "")                    
            $cont.='<td width="10"> <a href="?opcion=nofiltro&codperiodo='.$codperiodo.'"> <img src="images/basicas/nofiltro.png"> </a> </td>';

        $cont.='  <td width="24"> 
                   <a href="nominaelectronica.php?opcion=ventanadatos">
                    <input type="button" value="<<" class="button">
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>	 			   
                </table>';

        if($_SESSION['SQL_PERIODODIAN'] == "")
            $vsql = "SELECT * FROM periododian ORDER BY periododiamid ASC";
        else
            $vsql = $_SESSION['SQL_PERIODODIAN'];
        
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:23px;"> 
                   <td width="15"> &nbsp; </td>
                   <td width="30" align="left"> id </td>				 
                   <td width="80" align="left"> periodo </td>
                   <td width="505" align="left"> token </td>			
                   <td width="100" align="left"> proveedor </td>		                   
                   <td width="70" align="left"> mes </td>
                   <td width="50" align="left"> año </td>				 
                   <td width="70" align="left"> prefijo </td>
                   <td width="60" align="left"> n&uacute;mero </td>
                  </tr>
                  </thead>
                  <tbody style="display:block; width:1050; height:590px; overflow-Y:scroll">';

        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="15">&nbsp;</td>
                     <td width="40" align="left"> '.$row['periododiamid'].' </td>                         
                     <td width="70" align="left"> '.$row['periodonomina'].' </td>
                     <td width="545" align="left"> '.substr($row['token'],0,70).' </td>				  				  
                     <td width="110" align="left"> '.$row['proveedor'].' </td>
                     <td width="80" align="left"> '.$row['mes'].' </td>
                     <td width="100" align="left"> '.$row['ano'].' </td>
                     <td width="100" align="left"> '.$row['prefijo'].' </td>
                     <td width="30" align="left"> '.$row['numero'].' </td>
                     <td width="25"> 
                      <a href="?opcion=confirmacion&periododiamid='.$row['periododiamid'].'&codperiodo='.$codperiodo.'" rel="facebox">
                       <img src="images/basicas/iconoborrar.png" title="eliminar periodo" border="0">
                      </a> 
                     </td>
                     <td width="25"> 
                      <a href="?opcion=detalles&periododiamid='.$row['periododiamid'].'&codperiodo='.$codperiodo.'"> 
                       <img src="images/basicas/iconobuscar.png" title="modificar periodo" border="0"> 
                      </a> 
                     </td>
                    </tr>';
        }

        $cont.=' </tbody> 
                </table><br>';

        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="20"> &nbsp; </td>
                  <td width="375" align="left"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="616" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';                

        echo $cont.$clase->PiePagina();
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: encontrar
    // Creación: 12/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que busca periodos según el criterio
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio = $_POST['criterio'];
        $codperiodo = $_POST['codperiodo'];

        $vsql = "SELECT * FROM periododian WHERE periodonomina like '%".$criterio."%' OR proveedor like '%".$criterio."%'  ORDER BY periododiamid ASC";
        $_SESSION['SQL_PERIODODIAN'] = $vsql;
        header("Location: nominaelectronica.php?opcion=crudperiodos&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 12/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que restablece todos los periodos de nómina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {        
        $codperiodo = $_GET['codperiodo'];

        $vsql = "SELECT * FROM periododian ORDER BY periododiamid ASC ";
        $_SESSION['SQL_PERIODODIAN'] = "";
        header("Location: nominaelectronica.php?opcion=crudperiodos&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nuevo
    // Creación: 12/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la venta donde se captan los datos para incluir un 
    //              periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevo")
    {
        $codperiodo = $_GET['codperiodo'];

        // Inicialización de variables
        $mesplaceholder = substr($codperiodo,0,2);
        if(substr($mesplaceholder,0,1) == "0")              $mesplaceholder = substr($mesplaceholder,1,1);
                
        $yearplaceholder = substr($codperiodo,-4);
        $token = "";

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/guardardoc.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Nuevo periodo Dian </b> </td>
                  <td align="right">
                   <a href="nominaelectronica.php?opcion=crudperiodos&codperiodo='.$codperiodo.'">
                    <input type="button" value="<<" class="button">
                   </a>
                  </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';
        
        $cont.='<br><center>
                <fieldset style="width: 530px; height: 500px;" class="grupos">
                <legend class="titgrupos"> Datos </legend>
                <form action="?opcion=guardarnuevo" method="POST">
                <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                 <table width="200">
                  <tr height="55">
                   <td> <label class="Texto12"> Periodo: </label><br>
                    <input type="text" autocomplete="off" name="periodonomina" class="Texto15" maxlength="10" size="10" placeholder="'.$codperiodo.'"> 
                   </td>
                  </tr>
                  <tr height="55">
                   <td> <label class="Texto12"> Token: </label><br>
                    <textarea name="token" class="Texto11" cols="120" rows="4" tabindex="4" placeholder="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJEaXNwYXBlbGVzIFMuQS5TIiwiaWF0IjoxNjQ0NTEyNzk2LCJleHAiOjE2NDQ1OTkxOTYsInN1YiI6IjE1MzYiLCJjb250ZXh0Ijp7InVzZXIiOnsidXNlcm5hbWUiOiJVU0RST01FRElDQVNPUklFTlRFIiwiZGlzcGxheU5hbWUiOiJEUk9NRURJQ0FTIERFTCBPUklFTlRFIFMuQS5TIn19fQ.xOJVD6rnlBDcxlAdJyKIWhxp6rL_Ubb1iKP48ygAdxU">'.$token.'</textarea>
                   </td>
                  </tr>
                  <tr height="55">
                   <td> <label class="Texto12"> Proveedor: </label><br>
                    <input type="text" autocomplete="off" name="proveedor" class="Texto15" maxlength="30" size="30" placeholder="DISPAPELES"> 
                   </td>
                  </tr>
                  <tr height="55">
                   <td> <label class="Texto12"> Mes: </label><br>
                    <input type="text" autocomplete="off" name="mes" style="width:90px;height:25px" class="Texto15" maxlength="40" size="40" placeholder="'.$mesplaceholder.'"> 
                   </td>
                  </tr>
                  <tr height="55">
                   <td> <label class="Texto12"> Año: </label><br>
                    <input type="text" autocomplete="off" name="ano" style="width:90px;height:25px" class="Texto15" maxlength="40" size="40" placeholder="'.$yearplaceholder.'"> 
                   </td>
                  </tr>
                  <tr height="55">
                   <td> <label class="Texto12"> Prefijo: </label><br>
                    <input type="text" autocomplete="off" name="prefijo" class="Texto15" maxlength="2" size="2" placeholder="NE"> 
                   </td>
                  </tr>
                  <tr height="55">
                   <td> <label class="Texto12"> N&uacute;mero: </label><br>
                    <input type="text" autocomplete="off" name="numero" class="Texto15" maxlength="6" size="6" placeholder="1"> 
                   </td>
                  </tr>
                  <tr height="55">
                   <td align="center"><br><br> 
                    <input type="submit" value="aceptar" class="button blue"> 
                   </td>
                  </tr>
                 </table>
                </form>
                <br><br></fieldset><br><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacion
    // Creación: 12/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que solicita la confirmación de la eliminación de un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacion")
    {
        $periododiamid = $_GET['periododiamid'];
        $codperiodo = $_GET['codperiodo'];
        $periodonomina = $clase->BDLockup($periododiamid,'periododian','periododiamid','periodonomina');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar Periodo Dian</b><br><br></td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"> 
                   <label class="Texto12"> 
                   ¿Confirma que desea eliminar el periodo<br><b> '.$periodonomina.'</b>? <br>
                   </label>
                  </td>       
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=eliminarperiododian" method="POST">
                   <input type="hidden" name="periododiamid" value="'.$periododiamid.'">
                   <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="nominaelectronica.php?opcion=crudperiodos&codperiodo='.$codperiodo.'"><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table>';		
        echo $cont; 
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarperiododian
    // Creación: 12/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un periodo de nómina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarperiododian")
    {		  
        $periododiamid = $_POST['periododiamid'];
        $codperiodo = $_POST['codperiodo'];

   	  	// Valido que el periodo no esté transmitido a la dian
        $vsqlx = "SELECT COUNT(idperiodo) FROM dianterceros WHERE periodonomina = ".$periododiamid;
        $valor = $clase->SeleccionarUno($vsqlx);
   
        if($valor>=1)
        {
            $periodonomina = $clase->BDLockup($periododiamid,'periododian','periododiamid','periodonomina');
            $clase->Aviso(3,"No se puede eliminar el periodo $periodonomina porque ya fue reportado a la Dian");
        }
        else
        {            
            $vsql = "DELETE FROM periododian WHERE periododiamid = ".$periododiamid;
            $clase->EjecutarSQL($vsql);	

            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"periodo eliminado exitosamente");
            else
                $clase->Aviso(3,"No se eliminó el periodo");
        }
        header("Location: nominaelectronica.php?opcion=crudperiodos&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: detalles
    // Creación: 12/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para la edición de un periodo de nómina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "detalles")
    {
        $periododiamid = $_GET['periododiamid'];
        $codperiodo = $_GET['codperiodo'];

        // pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/guardardoc.png" width="32" height="32" border="0"> </td>
                  <td width="940"> <b>Editar Periodo </b></td>
                  <td> 
                   <a href="nominaelectronica.php?opcion=crudperiodos&codperiodo='.$codperiodo.'">
                    <input type="button" value="<<" class="button">
                   </a> 
                  </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';
        
        // Obtengo el valor de los campos
        $vsql = "SELECT * FROM periododian WHERE periododiamid=".$periododiamid;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);

        if($row = mysql_fetch_array($result))
        {
            $cont.='<br><center>
                    <form action="?opcion=guardareditado" method="POST">
                     <input type="hidden" name="periododiamid" value="'.$periododiamid.'">
                     <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                     <fieldset style="width: 530px; height: 500px;" class="grupos">
                     <legend class="titgrupos"> Datos </legend>
                     <table width="400">
                      <tr height="55">
                       <td> <label class="Texto12"> Periodo: </label><br> 
                        <input type="text" autocomplete="off" name="periodonomina" class="Texto15" size="10" maxlength="10" value="'.$row['periodonomina'].'"> 
                       </td>
                      </tr>
                      <tr height="55">
                       <td> <label class="Texto12"> Token: </label><br>
                        <textarea name="token" class="Texto11" cols="120" rows="4" tabindex="4">'.$row['token'].'</textarea> 
                       </td>
                      </tr>
                      <tr height="55">
                       <td> <label class="Texto12"> Proveedor: </label><br>
                        <input type="text" autocomplete="off" name="proveedor" class="Texto15" maxlength="30" size="30" value="'.$row['proveedor'].'"> 
                       </td>
                      </tr>
                      <tr height="55">
                       <td> <label class="Texto12"> Mes: </label><br>
                        <input type="text" autocomplete="off" name="mes" style="width:90px;height:25px" class="Texto15" maxlength="40" size="40" value="'.$row['mes'].'"> 
                       </td>
                      </tr>
                      <tr height="55">
                       <td> <label class="Texto12"> Año: </label><br>
                        <input type="text" autocomplete="off" name="ano" style="width:90px;height:25px" class="Texto15" maxlength="40" size="40" value="'.$row['ano'].'"> 
                       </td>
                      </tr>
                      <tr height="55">
                       <td> <label class="Texto12"> Prefijo: </label><br>
                        <input type="text" autocomplete="off" name="prefijo" class="Texto15" maxlength="2" size="2" value="'.$row['prefijo'].'"> 
                       </td>
                      </tr>
                      <tr height="55">
                       <td> <label class="Texto12"> N&uacute;mero: </label><br>
                        <input type="text" autocomplete="off" name="numero" class="Texto15" maxlength="6" size="6" value="'.$row['numero'].'"> 
                       </td>
                      </tr>
                      <tr height="55">
                       <td align="center"><br><br> 
                        <input type="submit" value="aceptar" class="button blue"> 
                       </td>
                      </tr>
                     </table>
                    </form> 
                    <br><br></fieldset><br><br>';
        }
        mysql_free_result($result); 
        mysql_close($conex);

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardareditado y guardarnuevo
    // Creación: 12/01/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opciones para almacenar los registros 
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if(($opcion == "guardareditado")||($opcion == "guardarnuevo"))
    {
        $codperiodo = $_POST['codperiodo'];
        $periodonomina = $_POST['periodonomina'];
        $token = $_POST['token'];
        $proveedor = strtoupper($_POST['proveedor']);
        $mes = $_POST['mes'];
        $ano = $_POST['ano'];
        $prefijo = strtoupper($_POST['prefijo']);
        $numero = $_POST['numero'];

        // Valido que sean introducidos los datos necesarios
        if((strlen($periodonomina)==0)||(strlen($token)==0)||(strlen($proveedor)==0)||(strlen($mes)==0)||(strlen($ano)==0)||(strlen($prefijo)==0)||(strlen($numero)==0))
        {
            $clase->Aviso(3,"Se deben ingresar todos los datos");
            header("Location: nominaelectronica.php?opcion=crudperiodos&codperiodo=$codperiodo");
        }
        else
        {
            if($opcion == "guardarnuevo")
            {
                // Validación del periodo
                $vsqlx = "SELECT COUNT(periodonomina) FROM periododian WHERE periodonomina = '".trim($periodonomina)."'";
                $valor = $clase->SeleccionarUno($vsqlx);

                if($valor>=1)
                {
                    $clase->Aviso(3,"El periodo ya existe, verifique por favor");
                    header("Location: nominaelectronica.php?opcion=crudperiodos&codperiodo=$codperiodo");
                }
                else
                {
                    // Almaceno la nueva condición
                    $vsql = "INSERT INTO periododian (periodonomina,token,proveedor,mes,ano,prefijo,numero) 
                                               VALUE ('".$periodonomina."','".$token."','".$proveedor."','".$mes."','".$ano."','".$prefijo."','".$numero."')";
                    $clase->EjecutarSQL($vsql);

                    if(mysql_affected_rows() >= 1)
                        $clase->Aviso(1,"periodo creada exitosamente");
                    else
                        $clase->Aviso(1,"no se creó el periodo");
                }
            }

            // guardo la modificación de un registro
            if($opcion == "guardareditado")
            {
                $periododiamid = $_POST['periododiamid'];

                // Validación del periodo
                $vsqlx = "SELECT COUNT(periodonomina) FROM periododian WHERE periodonomina = '".trim($periodonomina)."'";
                $valor = $clase->SeleccionarUno($vsqlx);

                if($valor>=2)
                {
                    $clase->Aviso(3,"El periodo ya existe, verifique por favor");
                    header("Location: nominaelectronica.php?opcion=crudperiodos&codperiodo=$codperiodo");
                }
                else
                {
                    // Almaceno los cambios del condición
                    $vsql = "UPDATE periododian SET 
                                    periodonomina  = '".$periodonomina."', 
                                    token  = '".$token."', 
                                    proveedor  = '".$proveedor."', 
                                    mes  = '".$mes."', 
                                    ano  = '".$ano."', 
                                    prefijo  = '".$prefijo."', 
                                    numero  = '".$numero."' 
                              WHERE periododiamid = ".$periododiamid;
                    $clase->EjecutarSQL($vsql);

                    if(mysql_affected_rows() >= 1)
                        $clase->Aviso(1,"periodo editado exitosamente");
                    else
                        $clase->Aviso(1,"no se editó el periodo");
                }
            }
        }
        header("Location: nominaelectronica.php?opcion=crudperiodos&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: prexls
    // Creación: 08/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opciones para almacenar los registros 
    // Última modificación: Opción que muestra el reloj y el avance del proceso para generar 
    //                      la hoja de Excel con la nómina electrónica 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "prexls")
    {
        $codperiodo  = $_GET['codperiodo'];
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Pinto la vista correspondiente
        $cont = $clase->Header("S","W");
        $cont.='<form name="x" method="POST" action="nominaelectronica.php?opcion=salidaxls&codperiodo='.$codperiodo.'">
                <table width="100%">
                 <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/ventatouch.png" width="32" height="32" border="0"> </td>
                  <td width="950"> <b> Por favor espere ... </b> </td>
                 </tr>
                </table>
                <br>
                <center>
                <h3> Generando la hoja de Excel de la n&oacute;mina electr&oacute;nica de <br> <font color="BLUE"> '.$desperiodo.' </font> </h3>
                <br> Por favor no interrumpa el proceso <br><br><br>
                <img src="images/basicas/cargando.gif" border="0">
                <script language="Javascript">
                 function redireccionar() {
                  setTimeout("location.href=\'nominaelectronica.php?opcion=salidaxls&codperiodo='.$codperiodo.'\'", 1000);
                 }
                 redireccionar();
                </script>
                <br><br><br>
                <!-- Contador de tiempo -->
                <div style="margin: 0px auto; text-align: center; width: 250px;">
                 <img src="images/basicas/1.gif" border="0">
                 <img src="images/basicas/2.gif" border="0">
                 <img src="images/basicas/3.gif" border="0">
                 <img src="images/basicas/4.gif" border="0">
                 <img src="images/basicas/5.gif" border="0">
                </div>';
        echo $cont.$clase->PiePagina();
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventnodebensalir
    // Creación: 10/10/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para incluir y eliminar empleados excluidos del periodo actual 
    //              de nómina electrónica
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventnodebensalir")
    {
        // $clase->Aviso(2,"Esta opción está en construcción");
        // header("Location: nominaelectronica.php?opcion=ventanadatos");

        $codperiodo = $_GET['codperiodo'];        

        // nombre del perido
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/retirados.png" width="32" height="32" border="0"> </td>
                  <td width="800"> <b> Empleados excluidos del periodo <br> <font color="blue">  '.$desperiodo.' </font> </b> </td>
                  <td width="20">
                   <a href="?opcion=nuevoexcluido&codperiodo='.$codperiodo.'" rel="facebox">
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="incluir un nuevo registro"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="nominaelectronica.php?opcion=ventanadatos"> 
                    <input type="button" value="<<" class="button"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>                 
                <table width="100%" class="sortable">
                 <thead>
                  <tr class="TituloTabla" style="display:block; padding-top:5px;height:23px;"> 
                   <th width="10"> &nbsp; </th>
                   <th width="140" align="left">idnoliquida</th>
                   <th width="120" align="left"> terid </th>			
                   <th width="125" align="left"> cedula </th>							 
                   <th width="300" align="left"> nombre </th>
                   <th width="415" align="left"> &nbsp; </th>
                   <th width="45" align="left"> &nbsp; </th>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:520px; overflow-Y:scroll">';

        // consulta de la vista
        $vsql = "SELECT nl.idnoliquida, nl.terid, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp 
                   FROM noliquida nl
                        INNER JOIN terceros t ON (nl.terid = t.terid)
                  WHERE nl.periodonomina = '".$codperiodo."' 
                        AND nl.tipo = 'nominaelec'";

        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="10"> &nbsp; </td>
                     <td width="135" align="left"> '.$row['idnoliquida'].' </td>
                     <td width="110" align="left"> '.$row['terid'].' </td>			
                     <td width="140" align="left"> '.$row['dni'].' </td>
                     <td width="300" align="left"> '.substr($row['nombreemp'],0,50).' </td>
                     <td width="415" align="left"> &nbsp; </td>                     
                     <td width="45" align="center"> 
                      <a href="?opcion=confirmarelinoliquida&idnoliquida='.$row['idnoliquida'].'&codperiodo='.$codperiodo.'" rel="facebox" title="eliminar este registro">
                       <img src="images/basicas/iconoborrar.png" border="0">
                      </a>
                     </td>
                    </tr>';
        }

        $cont.=' </tbody>
                 </table>
                 <table width="100%">
                  <tr class="TituloTabla"> 
                   <td width="261"> &nbsp; </td>
                   <td width="375" align="right"> &nbsp; </td>
                   <td width="375" align="right"> &nbsp; </td>
                   <td width="375" align="right"> &nbsp; </td>
                   <td width="222"> &nbsp; </td>
                  </tr>
                 </table>';

        echo $cont.$clase->PiePagina();
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nuevoexcluido
    // Creación: 12/10/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para seleccionar un nuevo empleado que será 
    //              excluido de la nómina electrónica
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nuevoexcluido")
    {
        $codperiodo = $_GET['codperiodo'];

        // nombre del perido
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // combo de empleados
        $params = ' class="Texto10" ';
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                                AND basico > 0
                       ORDER BY primernombre";

        // Pintamos la ventana
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Incluir empleados excluidos en el periodo <br> <font color="blue">  '.$desperiodo.' </font> </b> <br><br> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardarnewexcluido" name="y" method="POST">
                <table width="500">
                 <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left">
                   <label class="Texto12">Empleado:&nbsp;&nbsp;</label><br>
                   '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombreemp","terid","","N",$params,470).'   
                  </td>
                 </tr>
                </table> 
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnewexcluido
    // Creación: 12/10/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena el nuevo empleado que será excluido de la nómina 
    //              electrónica
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnewexcluido")
    {
        $codperiodo = $_POST['codperiodo'];
        $terid = $_POST['terid'];

        $tipo = "nominaelec";

        // Construyo la instrucción para la inclusión del registro
        $vsql = "INSERT INTO noliquida (periodonomina, terid, tipo) VALUE ('".$codperiodo."',".$terid.",'".$tipo."')";

        // Almaceno la información
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Registro incluido satisfactoriamente");
        else
            $clase->Aviso(3,"No se incluyó el registro");

        // Redirecciono el formulario
        header("Location: nominaelectronica.php?opcion=ventnodebensalir&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarelinoliquida
    // Creación: 12/10/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la venta para la confirmación de la eliminación de un 
    //              empleado excluido del periodo de nómina electrónica
    // Última modificación:     
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "confirmarelinoliquida")
    {
        $idnoliquida = $_GET['idnoliquida'];
        $codperiodo = $_GET['codperiodo'];

        $terid = $clase->BDLockup($idnoliquida,'noliquida','idnoliquida','terid');
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        
        $periodonomina = $clase->BDLockup($idnoliquida,'noliquida','idnoliquida','periodonomina');        
        
        // pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar un empleado excluido</b><br><br></td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><label class="Texto12">¿Confirma que desea eliminar el empleado <br><b>'.$nombreemp.'</b><br> excluido del periodo <b>'.$periodonomina.'</b>?</label></td>
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>
                   <form action="?opcion=elimarnoliquida" method="POST">
                   <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                   <input type="hidden" name="idnoliquida" value="'.$idnoliquida.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   <a href="nominaelectronica.php?opcion=ventnodebensalir&codperiodo='.$codperiodo.'"><input type="button" value="CANCELAR" class="button blue"></a>
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: elimarnoliquida
    // Creación: 12/10/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un registro de la tabla noliquida
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "elimarnoliquida")
    {
        $idnoliquida = $_POST['idnoliquida'];
        $codperiodo = trim($_POST['codperiodo']);

        $vsql = "DELETE FROM noliquida WHERE idnoliquida = ".$idnoliquida;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Registro eliminado satisfactoriamente");
        else
            $clase->Aviso(3,"No se eliminó el registro");

        $cod = $codperiodo;        

        // Redirecciona el formulario
        header("Location: nominaelectronica.php?opcion=ventnodebensalir&codperiodo=$codperiodo");
    }    

    echo $clase->PiePagina();
?>