[].push.apply(
  FullCalendar.globalLocales,
  (function () {
    'use strict';
    return [
      {
        code: 'af',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Vorige', next: 'Volgende', today: 'Vandag', year: 'Jaar', month: 'Maand', week: 'Week', day: 'Dag', list: 'Agenda'},
        allDayText: 'Heeldag',
        moreLinkText: 'Addisionele',
        noEventsText: 'Daar is geen gebeurtenisse nie',
      },
      {
        code: 'ar-dz',
        week: {dow: 0, doy: 4},
        direction: 'rtl',
        buttonText: {prev: 'السابق', next: 'التالي', today: 'اليوم', month: 'شهر', week: 'أسبوع', day: 'يوم', list: 'أجندة'},
        weekText: 'أسبوع',
        allDayText: 'اليوم كله',
        moreLinkText: 'أخرى',
        noEventsText: 'أي أحداث لعرض',
      },
      {
        code: 'ar-kw',
        week: {dow: 0, doy: 12},
        direction: 'rtl',
        buttonText: {prev: 'السابق', next: 'التالي', today: 'اليوم', month: 'شهر', week: 'أسبوع', day: 'يوم', list: 'أجندة'},
        weekText: 'أسبوع',
        allDayText: 'اليوم كله',
        moreLinkText: 'أخرى',
        noEventsText: 'أي أحداث لعرض',
      },
      {
        code: 'ar-ly',
        week: {dow: 6, doy: 12},
        direction: 'rtl',
        buttonText: {prev: 'السابق', next: 'التالي', today: 'اليوم', month: 'شهر', week: 'أسبوع', day: 'يوم', list: 'أجندة'},
        weekText: 'أسبوع',
        allDayText: 'اليوم كله',
        moreLinkText: 'أخرى',
        noEventsText: 'أي أحداث لعرض',
      },
      {
        code: 'ar-ma',
        week: {dow: 6, doy: 12},
        direction: 'rtl',
        buttonText: {prev: 'السابق', next: 'التالي', today: 'اليوم', month: 'شهر', week: 'أسبوع', day: 'يوم', list: 'أجندة'},
        weekText: 'أسبوع',
        allDayText: 'اليوم كله',
        moreLinkText: 'أخرى',
        noEventsText: 'أي أحداث لعرض',
      },
      {
        code: 'ar-sa',
        week: {dow: 0, doy: 6},
        direction: 'rtl',
        buttonText: {prev: 'السابق', next: 'التالي', today: 'اليوم', month: 'شهر', week: 'أسبوع', day: 'يوم', list: 'أجندة'},
        weekText: 'أسبوع',
        allDayText: 'اليوم كله',
        moreLinkText: 'أخرى',
        noEventsText: 'أي أحداث لعرض',
      },
      {
        code: 'ar-tn',
        week: {dow: 1, doy: 4},
        direction: 'rtl',
        buttonText: {prev: 'السابق', next: 'التالي', today: 'اليوم', month: 'شهر', week: 'أسبوع', day: 'يوم', list: 'أجندة'},
        weekText: 'أسبوع',
        allDayText: 'اليوم كله',
        moreLinkText: 'أخرى',
        noEventsText: 'أي أحداث لعرض',
      },
      {
        code: 'ar',
        week: {dow: 6, doy: 12},
        direction: 'rtl',
        buttonText: {prev: 'السابق', next: 'التالي', today: 'اليوم', month: 'شهر', week: 'أسبوع', day: 'يوم', list: 'أجندة'},
        weekText: 'أسبوع',
        allDayText: 'اليوم كله',
        moreLinkText: 'أخرى',
        noEventsText: 'أي أحداث لعرض',
      },
      {
        code: 'az',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Əvvəl', next: 'Sonra', today: 'Bu Gün', month: 'Ay', week: 'Həftə', day: 'Gün', list: 'Gündəm'},
        weekText: 'Həftə',
        allDayText: 'Bütün Gün',
        moreLinkText: (e) => '+ daha çox ' + e,
        noEventsText: 'Göstərmək üçün hadisə yoxdur',
      },
      {
        code: 'bg',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'назад', next: 'напред', today: 'днес', month: 'Месец', week: 'Седмица', day: 'Ден', list: 'График'},
        allDayText: 'Цял ден',
        moreLinkText: (e) => '+още ' + e,
        noEventsText: 'Няма събития за показване',
      },
      {
        code: 'bs',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'Prošli', next: 'Sljedeći', today: 'Danas', month: 'Mjesec', week: 'Sedmica', day: 'Dan', list: 'Raspored'},
        weekText: 'Sed',
        allDayText: 'Cijeli dan',
        moreLinkText: (e) => '+ još ' + e,
        noEventsText: 'Nema događaja za prikazivanje',
      },
      {
        code: 'ca',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Anterior', next: 'Següent', today: 'Avui', month: 'Mes', week: 'Setmana', day: 'Dia', list: 'Agenda'},
        weekText: 'Set',
        allDayText: 'Tot el dia',
        moreLinkText: 'més',
        noEventsText: 'No hi ha esdeveniments per mostrar',
      },
      {
        code: 'cs',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Dříve', next: 'Později', today: 'Nyní', month: 'Měsíc', week: 'Týden', day: 'Den', list: 'Agenda'},
        weekText: 'Týd',
        allDayText: 'Celý den',
        moreLinkText: (e) => '+další: ' + e,
        noEventsText: 'Žádné akce k zobrazení',
      },
      {
        code: 'da',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Forrige', next: 'Næste', today: 'I dag', month: 'Måned', week: 'Uge', day: 'Dag', list: 'Agenda'},
        weekText: 'Uge',
        allDayText: 'Hele dagen',
        moreLinkText: 'flere',
        noEventsText: 'Ingen arrangementer at vise',
      },
      {
        code: 'de',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Zurück', next: 'Vor', today: 'Heute', year: 'Jahr', month: 'Monat', week: 'Woche', day: 'Tag', list: 'Terminübersicht'},
        weekText: 'KW',
        allDayText: 'Ganztägig',
        moreLinkText: (e) => '+ weitere ' + e,
        noEventsText: 'Keine Ereignisse anzuzeigen',
      },
      {
        code: 'el',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Προηγούμενος', next: 'Επόμενος', today: 'Σήμερα', month: 'Μήνας', week: 'Εβδομάδα', day: 'Ημέρα', list: 'Ατζέντα'},
        weekText: 'Εβδ',
        allDayText: 'Ολοήμερο',
        moreLinkText: 'περισσότερα',
        noEventsText: 'Δεν υπάρχουν γεγονότα προς εμφάνιση',
      },
      {code: 'en-au', week: {dow: 1, doy: 4}},
      {code: 'en-gb', week: {dow: 1, doy: 4}},
      {code: 'en-nz', week: {dow: 1, doy: 4}},
      {
        code: 'es',
        week: {dow: 0, doy: 6},
        buttonText: {prev: 'Ant', next: 'Sig', today: 'Hoy', month: 'Mes', week: 'Semana', day: 'Día', list: 'Agenda'},
        weekText: 'Sm',
        allDayText: 'Todo el día',
        moreLinkText: 'más',
        noEventsText: 'No hay eventos para mostrar',
      },
      {
        code: 'es',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Ant', next: 'Sig', today: 'Hoy', month: 'Mes', week: 'Semana', day: 'Día', list: 'Agenda'},
        weekText: 'Sm',
        allDayText: 'Todo el día',
        moreLinkText: 'más',
        noEventsText: 'No hay eventos para mostrar',
      },
      {
        code: 'et',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Eelnev', next: 'Järgnev', today: 'Täna', month: 'Kuu', week: 'Nädal', day: 'Päev', list: 'Päevakord'},
        weekText: 'näd',
        allDayText: 'Kogu päev',
        moreLinkText: (e) => '+ veel ' + e,
        noEventsText: 'Kuvamiseks puuduvad sündmused',
      },
      {
        code: 'eu',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'Aur', next: 'Hur', today: 'Gaur', month: 'Hilabetea', week: 'Astea', day: 'Eguna', list: 'Agenda'},
        weekText: 'As',
        allDayText: 'Egun osoa',
        moreLinkText: 'gehiago',
        noEventsText: 'Ez dago ekitaldirik erakusteko',
      },
      {
        code: 'fa',
        week: {dow: 6, doy: 12},
        direction: 'rtl',
        buttonText: {prev: 'قبلی', next: 'بعدی', today: 'امروز', month: 'ماه', week: 'هفته', day: 'روز', list: 'برنامه'},
        weekText: 'هف',
        allDayText: 'تمام روز',
        moreLinkText: (e) => 'بیش از ' + e,
        noEventsText: 'هیچ رویدادی به نمایش',
      },
      {
        code: 'fi',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Edellinen', next: 'Seuraava', today: 'Tänään', month: 'Kuukausi', week: 'Viikko', day: 'Päivä', list: 'Tapahtumat'},
        weekText: 'Vk',
        allDayText: 'Koko päivä',
        moreLinkText: 'lisää',
        noEventsText: 'Ei näytettäviä tapahtumia',
      },
      {
        code: 'fr',
        buttonText: {
          prev: 'Précédent',
          next: 'Suivant',
          today: "Aujourd'hui",
          year: 'Année',
          month: 'Mois',
          week: 'Semaine',
          day: 'Jour',
          list: 'Mon planning',
        },
        weekText: 'Sem.',
        allDayText: 'Toute la journée',
        moreLinkText: 'en plus',
        noEventsText: 'Aucun événement à afficher',
      },
      {
        code: 'fr-ch',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Précédent', next: 'Suivant', today: 'Courant', year: 'Année', month: 'Mois', week: 'Semaine', day: 'Jour', list: 'Mon planning'},
        weekText: 'Sm',
        allDayText: 'Toute la journée',
        moreLinkText: 'en plus',
        noEventsText: 'Aucun événement à afficher',
      },
      {
        code: 'fr',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Précédent', next: 'Suivant', today: "Aujourd'hui", year: 'Année', month: 'Mois', week: 'Semaine', day: 'Jour', list: 'Planning'},
        weekText: 'Sem.',
        allDayText: 'Toute la journée',
        moreLinkText: 'en plus',
        noEventsText: 'Aucun événement à afficher',
      },
      {
        code: 'gl',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Ant', next: 'Seg', today: 'Hoxe', month: 'Mes', week: 'Semana', day: 'Día', list: 'Axenda'},
        weekText: 'Sm',
        allDayText: 'Todo o día',
        moreLinkText: 'máis',
        noEventsText: 'Non hai eventos para amosar',
      },
      {
        code: 'he',
        direction: 'rtl',
        buttonText: {prev: 'הקודם', next: 'הבא', today: 'היום', month: 'חודש', week: 'שבוע', day: 'יום', list: 'סדר יום'},
        allDayText: 'כל היום',
        moreLinkText: 'אחר',
        noEventsText: 'אין אירועים להצגה',
        weekText: 'שבוע',
      },
      {
        code: 'hi',
        week: {dow: 0, doy: 6},
        buttonText: {prev: 'पिछला', next: 'अगला', today: 'आज', month: 'महीना', week: 'सप्ताह', day: 'दिन', list: 'कार्यसूची'},
        weekText: 'हफ्ता',
        allDayText: 'सभी दिन',
        moreLinkText: (e) => '+अधिक ' + e,
        noEventsText: 'कोई घटनाओं को प्रदर्शित करने के लिए',
      },
      {
        code: 'hr',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'Prijašnji', next: 'Sljedeći', today: 'Danas', month: 'Mjesec', week: 'Tjedan', day: 'Dan', list: 'Raspored'},
        weekText: 'Tje',
        allDayText: 'Cijeli dan',
        moreLinkText: (e) => '+ još ' + e,
        noEventsText: 'Nema događaja za prikaz',
      },
      {
        code: 'hu',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'vissza', next: 'előre', today: 'ma', month: 'Hónap', week: 'Hét', day: 'Nap', list: 'Napló'},
        weekText: 'Hét',
        allDayText: 'Egész nap',
        moreLinkText: 'további',
        noEventsText: 'Nincs megjeleníthető esemény',
      },
      {
        code: 'id',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'mundur', next: 'maju', today: 'hari ini', month: 'Bulan', week: 'Minggu', day: 'Hari', list: 'Agenda'},
        weekText: 'Mg',
        allDayText: 'Sehari penuh',
        moreLinkText: 'lebih',
        noEventsText: 'Tidak ada acara untuk ditampilkan',
      },
      {
        code: 'is',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Fyrri', next: 'Næsti', today: 'Í dag', month: 'Mánuður', week: 'Vika', day: 'Dagur', list: 'Dagskrá'},
        weekText: 'Vika',
        allDayText: 'Allan daginn',
        moreLinkText: 'meira',
        noEventsText: 'Engir viðburðir til að sýna',
      },
      {
        code: 'it',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Prec', next: 'Succ', today: 'Oggi', month: 'Mese', week: 'Settimana', day: 'Giorno', list: 'Agenda'},
        weekText: 'Sm',
        allDayText: 'Tutto il giorno',
        moreLinkText: (e) => '+altri ' + e,
        noEventsText: 'Non ci sono eventi da visualizzare',
      },
      {
        code: 'ja',
        buttonText: {prev: '前', next: '次', today: '今日', month: '月', week: '週', day: '日', list: '予定リスト'},
        weekText: '週',
        allDayText: '終日',
        moreLinkText: (e) => '他 ' + e + ' 件',
        noEventsText: '表示する予定はありません',
      },
      {
        code: 'ka',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'წინა', next: 'შემდეგი', today: 'დღეს', month: 'თვე', week: 'კვირა', day: 'დღე', list: 'დღის წესრიგი'},
        weekText: 'კვ',
        allDayText: 'მთელი დღე',
        moreLinkText: (e) => '+ კიდევ ' + e,
        noEventsText: 'ღონისძიებები არ არის',
      },
      {
        code: 'kk',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'Алдыңғы', next: 'Келесі', today: 'Бүгін', month: 'Ай', week: 'Апта', day: 'Күн', list: 'Күн тәртібі'},
        weekText: 'Не',
        allDayText: 'Күні бойы',
        moreLinkText: (e) => '+ тағы ' + e,
        noEventsText: 'Көрсету үшін оқиғалар жоқ',
      },
      {
        code: 'ko',
        buttonText: {prev: '이전달', next: '다음달', today: '오늘', month: '월', week: '주', day: '일', list: '일정목록'},
        weekText: '주',
        allDayText: '종일',
        moreLinkText: '개',
        noEventsText: '일정이 없습니다',
      },
      {
        code: 'lb',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Zréck', next: 'Weider', today: 'Haut', month: 'Mount', week: 'Woch', day: 'Dag', list: 'Terminiwwersiicht'},
        weekText: 'W',
        allDayText: 'Ganzen Dag',
        moreLinkText: 'méi',
        noEventsText: 'Nee Evenementer ze affichéieren',
      },
      {
        code: 'lt',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Atgal', next: 'Pirmyn', today: 'Šiandien', month: 'Mėnuo', week: 'Savaitė', day: 'Diena', list: 'Darbotvarkė'},
        weekText: 'SAV',
        allDayText: 'Visą dieną',
        moreLinkText: 'daugiau',
        noEventsText: 'Nėra įvykių rodyti',
      },
      {
        code: 'lv',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Iepr.', next: 'Nāk.', today: 'Šodien', month: 'Mēnesis', week: 'Nedēļa', day: 'Diena', list: 'Dienas kārtība'},
        weekText: 'Ned.',
        allDayText: 'Visu dienu',
        moreLinkText: (e) => '+vēl ' + e,
        noEventsText: 'Nav notikumu',
      },
      {
        code: 'mk',
        buttonText: {prev: 'претходно', next: 'следно', today: 'Денес', month: 'Месец', week: 'Недела', day: 'Ден', list: 'График'},
        weekText: 'Сед',
        allDayText: 'Цел ден',
        moreLinkText: (e) => '+повеќе ' + e,
        noEventsText: 'Нема настани за прикажување',
      },
      {
        code: 'ms',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'Sebelum', next: 'Selepas', today: 'hari ini', month: 'Bulan', week: 'Minggu', day: 'Hari', list: 'Agenda'},
        weekText: 'Mg',
        allDayText: 'Sepanjang hari',
        moreLinkText: (e) => 'masih ada ' + e + ' acara',
        noEventsText: 'Tiada peristiwa untuk dipaparkan',
      },
      {
        code: 'nb',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Forrige', next: 'Neste', today: 'I dag', month: 'Måned', week: 'Uke', day: 'Dag', list: 'Agenda'},
        weekText: 'Uke',
        allDayText: 'Hele dagen',
        moreLinkText: 'til',
        noEventsText: 'Ingen hendelser å vise',
      },
      {
        code: 'ne',
        week: {dow: 7, doy: 1},
        buttonText: {prev: 'अघिल्लो', next: 'अर्को', today: 'आज', month: 'महिना', week: 'हप्ता', day: 'दिन', list: 'सूची'},
        weekText: 'हप्ता',
        allDayText: 'दिनभरि',
        moreLinkText: 'थप लिंक',
        noEventsText: 'देखाउनको लागि कुनै घटनाहरू छैनन्',
      },
      {
        code: 'nl',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Voorgaand', next: 'Volgende', today: 'Vandaag', year: 'Jaar', month: 'Maand', week: 'Week', day: 'Dag', list: 'Agenda'},
        allDayText: 'Hele dag',
        moreLinkText: 'extra',
        noEventsText: 'Geen evenementen om te laten zien',
      },
      {
        code: 'nn',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Førre', next: 'Neste', today: 'I dag', month: 'Månad', week: 'Veke', day: 'Dag', list: 'Agenda'},
        weekText: 'Veke',
        allDayText: 'Heile dagen',
        moreLinkText: 'til',
        noEventsText: 'Ingen hendelser å vise',
      },
      {
        code: 'pl',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Poprzedni', next: 'Następny', today: 'Dziś', month: 'Miesiąc', week: 'Tydzień', day: 'Dzień', list: 'Plan dnia'},
        weekText: 'Tydz',
        allDayText: 'Cały dzień',
        moreLinkText: 'więcej',
        noEventsText: 'Brak wydarzeń do wyświetlenia',
      },
      {
        code: 'pt-br',
        buttonText: {prev: 'Anterior', next: 'Próximo', today: 'Hoje', month: 'Mês', week: 'Semana', day: 'Dia', list: 'Lista'},
        weekText: 'Sm',
        allDayText: 'dia inteiro',
        moreLinkText: (e) => 'mais +' + e,
        noEventsText: 'Não há eventos para mostrar',
      },
      {
        code: 'pt',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Anterior', next: 'Seguinte', today: 'Hoje', month: 'Mês', week: 'Semana', day: 'Dia', list: 'Agenda'},
        weekText: 'Sem',
        allDayText: 'Todo o dia',
        moreLinkText: 'mais',
        noEventsText: 'Não há eventos para mostrar',
      },
      {
        code: 'ro',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'precedentă', next: 'următoare', today: 'Azi', month: 'Lună', week: 'Săptămână', day: 'Zi', list: 'Agendă'},
        weekText: 'Săpt',
        allDayText: 'Toată ziua',
        moreLinkText: (e) => '+alte ' + e,
        noEventsText: 'Nu există evenimente de afișat',
      },
      {
        code: 'ru',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Пред', next: 'След', today: 'Сегодня', month: 'Месяц', week: 'Неделя', day: 'День', list: 'Повестка дня'},
        weekText: 'Нед',
        allDayText: 'Весь день',
        moreLinkText: (e) => '+ ещё ' + e,
        noEventsText: 'Нет событий для отображения',
      },
      {
        code: 'sk',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Predchádzajúci', next: 'Nasledujúci', today: 'Dnes', month: 'Mesiac', week: 'Týždeň', day: 'Deň', list: 'Rozvrh'},
        weekText: 'Ty',
        allDayText: 'Celý deň',
        moreLinkText: (e) => '+ďalšie: ' + e,
        noEventsText: 'Žiadne akcie na zobrazenie',
      },
      {
        code: 'sl',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'Prejšnji', next: 'Naslednji', today: 'Trenutni', month: 'Mesec', week: 'Teden', day: 'Dan', list: 'Dnevni red'},
        weekText: 'Teden',
        allDayText: 'Ves dan',
        moreLinkText: 'več',
        noEventsText: 'Ni dogodkov za prikaz',
      },
      {
        code: 'sq',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'mbrapa', next: 'Përpara', today: 'sot', month: 'Muaj', week: 'Javë', day: 'Ditë', list: 'Listë'},
        weekText: 'Ja',
        allDayText: 'Gjithë ditën',
        moreLinkText: (e) => '+më tepër ' + e,
        noEventsText: 'Nuk ka evente për të shfaqur',
      },
      {
        code: 'sr-cyrl',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'Претходна', next: 'следећи', today: 'Данас', month: 'Месец', week: 'Недеља', day: 'Дан', list: 'Планер'},
        weekText: 'Сед',
        allDayText: 'Цео дан',
        moreLinkText: (e) => '+ још ' + e,
        noEventsText: 'Нема догађаја за приказ',
      },
      {
        code: 'sr',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'Prethodna', next: 'Sledeći', today: 'Danas', month: 'Mеsеc', week: 'Nеdеlja', day: 'Dan', list: 'Planеr'},
        weekText: 'Sed',
        allDayText: 'Cеo dan',
        moreLinkText: (e) => '+ još ' + e,
        noEventsText: 'Nеma događaja za prikaz',
      },
      {
        code: 'sv',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Förra', next: 'Nästa', today: 'Idag', month: 'Månad', week: 'Vecka', day: 'Dag', list: 'Program'},
        weekText: 'v.',
        allDayText: 'Heldag',
        moreLinkText: 'till',
        noEventsText: 'Inga händelser att visa',
      },
      {
        code: 'th',
        week: {dow: 1, doy: 4},
        buttonText: {
          prev: 'ก่อนหน้า',
          next: 'ถัดไป',
          prevYear: 'ปีก่อนหน้า',
          nextYear: 'ปีถัดไป',
          year: 'ปี',
          today: 'วันนี้',
          month: 'เดือน',
          week: 'สัปดาห์',
          day: 'วัน',
          list: 'กำหนดการ',
        },
        weekText: 'สัปดาห์',
        allDayText: 'ตลอดวัน',
        moreLinkText: 'เพิ่มเติม',
        noEventsText: 'ไม่มีกิจกรรมที่จะแสดง',
      },
      {
        code: 'tr',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'geri', next: 'ileri', today: 'bugün', month: 'Ay', week: 'Hafta', day: 'Gün', list: 'Ajanda'},
        weekText: 'Hf',
        allDayText: 'Tüm gün',
        moreLinkText: 'daha fazla',
        noEventsText: 'Gösterilecek etkinlik yok',
      },
      {code: 'ug', buttonText: {month: 'ئاي', week: 'ھەپتە', day: 'كۈن', list: 'كۈنتەرتىپ'}, allDayText: 'پۈتۈن كۈن'},
      {
        code: 'uk',
        week: {dow: 1, doy: 7},
        buttonText: {prev: 'Попередній', next: 'далі', today: 'Сьогодні', month: 'Місяць', week: 'Тиждень', day: 'День', list: 'Порядок денний'},
        weekText: 'Тиж',
        allDayText: 'Увесь день',
        moreLinkText: (e) => '+ще ' + e + '...',
        noEventsText: 'Немає подій для відображення',
      },
      {
        code: 'uz',
        buttonText: {month: 'Oy', week: 'Xafta', day: 'Kun', list: 'Kun tartibi'},
        allDayText: "Kun bo'yi",
        moreLinkText: (e) => '+ yana ' + e,
        noEventsText: "Ko'rsatish uchun voqealar yo'q",
      },
      {
        code: 'vi',
        week: {dow: 1, doy: 4},
        buttonText: {prev: 'Trước', next: 'Tiếp', today: 'Hôm nay', month: 'Tháng', week: 'Tuần', day: 'Ngày', list: 'Lịch biểu'},
        weekText: 'Tu',
        allDayText: 'Cả ngày',
        moreLinkText: (e) => '+ thêm ' + e,
        noEventsText: 'Không có sự kiện để hiển thị',
      },
      {
        code: 'zh-cn',
        week: {dow: 1, doy: 4},
        buttonText: {prev: '上月', next: '下月', today: '今天', month: '月', week: '周', day: '日', list: '日程'},
        weekText: '周',
        allDayText: '全天',
        moreLinkText: (e) => '另外 ' + e + ' 个',
        noEventsText: '没有事件显示',
      },
      {
        code: 'zh-tw',
        buttonText: {prev: '上月', next: '下月', today: '今天', month: '月', week: '週', day: '天', list: '活動列表'},
        weekText: '周',
        allDayText: '整天',
        moreLinkText: '顯示更多',
        noEventsText: '没有任何活動',
      },
    ];
  })(),
);
