<?php
  header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
  header("Expires: Sat, 1 Jul 2000 05:00:00 GMT");
  
  ////////////////////////////////////////////////////////////////////////////////////////
  // ReIngenieria - Login DROPOS
  // Clase Index - Metodos para deteccion de Posibles Errores
  // @Autor Ing Said Rodriguez
  ////////////////////////////////////////////////////////////////////////////////////////

  @session_abort();
  @session_unset();
  @session_destroy();

  include("../lib/Sistema.php");
 
  error_reporting(E_ALL);

  ini_set('display_errors', false);
  ini_set('display_startup_errors', false);

  @date_default_timezone_set('America/Bogota');
  @session_abort();
  @session_destroy();

  $version = LeerArchivo("../version.txt");  
  $fecha = GetFechaActual();
  $sucursal = GetSucursal();
  /*
  $conexionremota = EsConexionRemota();
  if($conexionremota)
  {
      $clave2 = '<div class="mb-5 filled form-group tooltip-end-top">
                   <i data-cs-icon="lock-on"></i>
                   <input class="form-control pe-5" name="clave2" type="password" placeholder="Clave Secundaria" autocomplete="off"/>
                 </div>';
  }
  */
  $clave2 = '';

  //////////////////////////////////////////////////////////////////////////////////////
  // LeerArchivo : Lee el contenido de un archivo y lo retorna
  //////////////////////////////////////////////////////////////////////////////////////
  function LeerArchivo($filename)
  {
      if(file_exists($filename))
      {
        $fp = fopen(@$filename, "r");
        $linea="";
        while(!feof($fp))
          $linea.= fgets($fp);
      }
      fclose($fp);
      return($linea); 
  }


  //////////////////////////////////////////////////////////////////////////////////////
  // GetFechaActual() : Detecta la Fecha actual del servidor y la retorna con formato
  //////////////////////////////////////////////////////////////////////////////////////
  function GetFechaActual()
  {
    $semana = array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sabado");
    $mes    = array("","Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
    $fechax = $semana[(date("w"))].", ".date("d")." de ".$mes[(date("n"))]." de ".date("Y");
    return($fechax);  
  }

   //////////////////////////////////////////////////////////////////////////////////////
   // GetSucursal : Obtiene el Codigo y el nombre de la Sucursal Activa
   //////////////////////////////////////////////////////////////////////////////////////
   function GetSucursal()
   {
     $clase = new Sistema();
     $codsucursal = $clase->BDLockup('G_SUCURSALPOS','configuraciones','variab','contenido');
     $sucursalx = $clase->BDLockup($codsucursal,'sucursales','codigo','descripcion');     
     return($sucursalx);
   }      

   //////////////////////////////////////////////////////////////////////////////////////
   // DatosConexion() : Detecta ciertos parámetros de la conexion | Browser | IP | O.S
   //////////////////////////////////////////////////////////////////////////////////////
   function EsConexionRemota()
   {
     $URL = substr($_SERVER["HTTP_HOST"], $f, 15);  

     if((substr($URL,0,8) == "192.168.")||(substr(strtoupper($URL),0,9) == "LOCALHOST"))
        return(false);
     else
        return(true); 
   }

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>DROPOS ERP Login</title>
    <meta name="description" content="DROPOS ERP - Login" />
    <!-- Favicon Tags Start -->
    <link rel="apple-touch-icon-precomposed" sizes="57x57" href="img/favicon/apple-touch-icon-57x57.png" />
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="img/favicon/apple-touch-icon-114x114.png" />
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="img/favicon/apple-touch-icon-72x72.png" />
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="img/favicon/apple-touch-icon-144x144.png" />
    <link rel="apple-touch-icon-precomposed" sizes="60x60" href="img/favicon/apple-touch-icon-60x60.png" />
    <link rel="apple-touch-icon-precomposed" sizes="120x120" href="img/favicon/apple-touch-icon-120x120.png" />
    <link rel="apple-touch-icon-precomposed" sizes="76x76" href="img/favicon/apple-touch-icon-76x76.png" />
    <link rel="apple-touch-icon-precomposed" sizes="152x152" href="img/favicon/apple-touch-icon-152x152.png" />
    <link rel="icon" type="image/png" href="img/favicon/favicon-196x196.png" sizes="196x196" />
    <link rel="icon" type="image/png" href="img/favicon/favicon-96x96.png" sizes="96x96" />
    <link rel="icon" type="image/png" href="img/favicon/favicon-32x32.png" sizes="32x32" />
    <link rel="icon" type="image/png" href="img/favicon/favicon-16x16.png" sizes="16x16" />
    <link rel="icon" type="image/png" href="img/favicon/favicon-128.png" sizes="128x128" />
    <meta name="application-name" content="&nbsp;" />
    <meta name="msapplication-TileColor" content="#FFFFFF" />
    <meta name="msapplication-TileImage" content="img/favicon/mstile-144x144.png" />
    <meta name="msapplication-square70x70logo" content="img/favicon/mstile-70x70.png" />
    <meta name="msapplication-square150x150logo" content="img/favicon/mstile-150x150.png" />
    <meta name="msapplication-wide310x150logo" content="img/favicon/mstile-310x150.png" />
    <meta name="msapplication-square310x310logo" content="img/favicon/mstile-310x310.png" />
    <!-- Favicon Tags End -->
    <!-- Font Tags Start -->
    <link rel="preconnect" href="https://fonts.gstatic.com" />
    <link href="https://fonts.googleapis.com/css2?family=Nunito+Sans:wght@300;400;600&display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;700&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="font/CS-Interface/style.css" />
    <!-- Font Tags End -->
    <!-- Vendor Styles Start -->
    <link rel="stylesheet" href="css/vendor/bootstrap.min.css" />
    <link rel="stylesheet" href="css/vendor/OverlayScrollbars.min.css" />

    <!-- Vendor Styles End -->
    <!-- Template Base Styles Start -->
    <link rel="stylesheet" href="css/styles.css" />
    <!-- Template Base Styles End -->

    <link rel="stylesheet" href="css/main.css" />
    <script src="js/base/loader.js"></script>
  
  </head>

  <body class="h-100">
    <div id="root" class="h-100">
      <!-- Background Start -->
      <div class="fixed-background"></div>
      <!-- Background End -->

      <div class="container-fluid p-0 h-100 position-relative">
        <div class="row g-0 h-100">

          <!-- Left Side Start -->
          <div class="offset-0 col-12 d-none d-lg-flex col-lg h-lg-100">
            <div class="min-h-100 d-flex align-items-center">
              <div class="w-100 w-lg-75 w-xxl-50">
                <div>
                  <div class="mb-5">         
                      <video autoplay="autoplay" muted="muted" preload="auto">
                        <source src="vid/fondo2.webm" type="video/webm" />
                      </video>
                  </div>
                  
                </div>
              </div>
            </div>
          </div>
          <!-- Left Side End -->

          <!-- Right Side Start -->
          <div class="col-12 col-lg-auto h-100 pb-4 px-4 pt-0 p-lg-0">
            <div class="sw-lg-70 min-h-100 bg-foreground d-flex justify-content-center align-items-center shadow-deep py-5 full-page-content-right-border">
              <div class="sw-lg-50 px-5">
                <div class="sh-15">
                  <a href="#">
                    <div class="logo-default logograndelogin"></div>
                  </a>
                </div>
                <div class="mb-5">
                  <h2 class="cta-1 mb-0 text-primary"><big>DROPOS ERP </big></h2>
                  <h2 class="cta-1 text-primary"> &nbsp; v <?PHP echo $version; ?>  </h2>
                </div>
                <div class="mb-5">
                  <p class="h6"> <b> <?PHP echo $sucursal; ?> </b> </p>
                  <p class="h6"> <?PHP echo $fecha; ?>    </p>                  
                </div>
                <div>
                  <form id="loginForm" name="loginForm" class="tooltip-end-bottom" action="../usuarios.php?opcion=login" method="POST" novalidate>
                    <div class="mb-5 filled form-group tooltip-end-top">
                      <i data-cs-icon="email"></i>
                      <input class="form-control" placeholder="Usuario o E-mail" name="usuario" id="usuario" autocomplete="off" style="text-transform:lowercase;" onkeypress="return Pasaraclave(event)" />
                    </div>
                    <div class="mb-5 filled form-group tooltip-end-top">
                      <i data-cs-icon="lock-on"></i>
                      <input class="form-control pe-7" name="clave" id="clave" type="password" placeholder="Clave Principal" autocomplete="off" onkeypress="return Pasaraboton(event)" />
                    </div>
                    <?PHP echo $clave2; ?>
                    <div id="content" class="col-lg-12"> </div>
                    <button type="button" id="botonlogin" class="btn btn-lg btn-primary hover-scale-up" OnClick="ValidarLogin();"> <i data-cs-icon="lock-off"></i> Ingreso al Sistema </button>
                  </form>
                </div>
                
              </div>
            </div>
          </div>
           <!-- Right Side End -->
        </div>
      </div>
    </div>


  <script type="text/javascript">
    <!--
      function Pasaraclave(e)
      {
          if (e.keyCode == 13) 
             document.loginForm.clave.focus();
          return;
      }

      function Pasaraboton(e)
      {
        if (e.keyCode == 13) 
           ValidarLogin();
        return;
      }

    function ValidarLogin()
    {
        var usuario = document.loginForm.usuario.value;
        var clave = document.loginForm.clave.value;

        if(usuario == "")
        {
           $('#content').fadeIn(500).html('<div class="alert alert-primary" role="alert"> Usuario no puede ser vacio </div>');    
           document.loginForm.usuario.focus();
           exit;
        }

        if((clave == "")&&(usuario.toUpperCase() != "VENDEDOR"))
        {
           $('#content').fadeIn(500).html('<div class="alert alert-primary" role="alert"> Clave no puede ser vacio </div>');    
           document.loginForm.clave.focus();
           exit;
        }
        
        var urldestino = "ajax.php?usuario=" + encodeURIComponent(usuario) + "&clave=" + encodeURIComponent(clave);

        //Añadimos la imagen de carga en el contenedor
        $('#content').html('<br><div class="loading"><img src="img/loader.gif"/><br/>Por favor Espere ...</div>');

        $.ajax({
            type: "POST",
            url: urldestino ,
            success: function(data) {
                if(data == "true")
                {
                   $('#content').fadeIn(1500).html('<div class="alert alert-success" role="alert"> Acceso Autorizado, Cargando Datos ...  </div>');
                   loginForm.submit();
                }
                else
                {
                    if(data.substring(0, 3) == "Usu")
                    {
                        $('#content').fadeIn(500).html('<div class="alert alert-danger" role="alert"> ' + data + ' </div>');
                        document.loginForm.usuario.value = "";
                        document.loginForm.clave.value = "";
                        document.loginForm.usuario.focus();
                    }
                    else
                    {
                        $('#content').fadeIn(500).html('<div class="alert alert-danger" role="alert"> ' + data + ' </div>');
                        document.loginForm.clave.value = ""; 
                    }
                }    
            }
        });
        return false;
    }   
    -->           
</script>

    <!-- Vendor Scripts Start -->
    <script src="js/vendor/jquery-3.5.1.min.js"></script>
    <script src="js/vendor/bootstrap.bundle.min.js"></script>
    <script src="js/vendor/OverlayScrollbars.min.js"></script>
    <script src="js/vendor/autoComplete.min.js"></script>
    <script src="js/vendor/clamp.min.js"></script>
    <script src="js/vendor/jquery.validate/additional-methods.min.js"></script>
    <!-- Vendor Scripts End -->

    <!-- Template Base Scripts Start -->
    <script src="font/CS-Line/csicons.min.js"></script>
    <script src="js/base/helpers.js"></script>
    <script src="js/base/globals.js"></script>
    <script src="js/base/nav.js"></script>
    <script src="js/base/search.js"></script>
    <script src="js/base/settings.js"></script>
    <script src="js/base/init.js"></script>
    <!-- Template Base Scripts End -->
    <!-- Page Specific Scripts Start -->
    <script src="js/pages/auth.login.js"></script>
    <script src="js/common.js"></script>
    <script src="js/scripts.js"></script>
    <!-- Page Specific Scripts End -->
  </body>
</html>
