<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 07/04/2021		última modificación: 21/03/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para la captación de datos del informe  
    //              de licencias pendiente
    // Última modificación: Validación de la existencia de licencias pendientes
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "ventanadatos")
    {
        // Valido que existan licencias pendientes
        $vsql = "SELECT COUNT(l.terid) vallicpen 
                   FROM licenciaspendiente l
                        INNER JOIN terceros t ON (l.terid = t.terid)
                  WHERE l.dias > 0
                        AND t.esempleadoactivo = 'CHECKED'";
        $vallicpen = $clase->SeleccionarUno($vsql);        

        if($vallicpen == 0)
        {
            $clase->Aviso(3,"No existen licencias pendientes");
            header("Location: principal.php");
        }
        else
        {
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/grados.png" width="32" height="32" border="0"> </td>
                      <td width="840"> <b> Licencias pendientes </b> </td>
                      <td> &nbsp; </td>
                      <td width="8"> &nbsp; </td>
                     </tr>
                    </table>';
    
            $cont.='<form action="licenciaspendiente.php?opcion=diaspendientes" method="POST" name="x" target="_blank">
                    <center>
                    <table width="100%">
                     <tr class="BarraDocumentos">
                      <td align="center"><br><br><b> Tipo de salida <br><br></td>
                     </tr>
                    </table>  
                    <table width="100%">
                     <tr class="BarraDocumentos"> 
                      <td width="371" height="50" align="center"> &nbsp; </td> 
                      <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"> </td>
                      <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"> </td>
                      <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"> </td>
                      <td width="380" height="50" align="center"> &nbsp; </td>
                     </tr>
                    </table> 
                    </form>';
    
            $cont.='<table width="100%"> 
                     <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
            echo $cont;
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: diaspendientes
    // Creación: 07/04/2021		última modificación: 21/03/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que imprime el informe de licencias pendientes de acuerdo a la 
    //              opción seleccionada en ventanadatos
    // Última modificación: Se incorporó el campo de empleado activo en la nómina
    //                      (11/08/2021)
    //                      Se ajustó la impresión de los días en la salida a pdf con tres 
    //                      cifras (27/09/2021)
    //                      Validación de la existencia de licencias pendientes
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion=="diaspendientes")
    {
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará

        if(strlen($tiposalida) == 0)
            $tiposalida = $_GET["tiposalida"];

        // Valido que existan licencias pendientes
        $vsql2 = "SELECT COUNT(l.terid) vallicpen 
                    FROM licenciaspendiente l
                         INNER JOIN terceros t ON (l.terid = t.terid)
                   WHERE l.dias > 0
                         AND t.esempleadoactivo = 'CHECKED'";        

        $vallicpen = $clase->SeleccionarUno($vsql2);

        if($vallicpen == 0)
            $botoneliminar = '';
        else
            $botoneliminar = '<a href="?opcion=confirmareliminarlic" rel="facebox" title="eliminar todas las licencias" disabled>
                               <img src="images/iconos/eliminardoc.png" border="0">
                              </a>';

        // Consulta de las licencias pendientes
        $vsql = "SELECT t.codvende, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombre,
                        c.nomconcepto, l.dias, l.pendienteid  
                   FROM licenciaspendiente l
                        INNER JOIN terceros t ON (l.terid = t.terid)
                        INNER JOIN conceptosnomina c ON (l.conceptoid = c.conceptoid)
                  WHERE l.dias > 0
                        AND t.esempleadoactivo = 'CHECKED'
               ORDER BY t.codvende";

        // Salida tipo vista del sistema
        if($tiposalida=="vista")
        {
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/grados.png" width="32" height="32" border="0"> </td>
                      <td width="840"> <b> Licencias pendientes </b> </td>
                      <td width="20">
                       '.$botoneliminar.'
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="20"> <a href="licenciaspendiente.php?opcion=ventanadatos"><input type="button" value="<<" class="button"></a> </td>
                      <td width="10"> &nbsp; </td>
                     </tr>           
                    </table>';

            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                       <td width="23"> &nbsp; </td>
                       <td width="125" align="left"> C&oacute;digo </td>
                       <td width="290" align="left"> Nombre </td>
                       <td width="307" align="left"> Concepto </td>
                       <td width="9"> &nbsp; </td>
                       <td width="8"> &nbsp; </td>
                       <td width="9"> &nbsp; </td> 
                       <td width="196" align="right"> D&iacute;as </td>
                       <td width="63"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:580px; overflow-Y:scroll">';

            // Impresión del detalle del informe
            $i = 0;
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';

                $cont.=' <td width="23"> &nbsp; </td>
                         <td width="125" align="left"> '.$row['codvende'].' </td>
                         <td width="290" align="left"> '.$row['nombre'].' </td>                         
                         <td width="307" align="left"> '.$row['nomconcepto'].' </td>
                         <td width="26"> &nbsp; </td>                         
                         <td width="196" align="right">'.number_format($row['dias']).' </td>
                         <td width="23" align="right"> &nbsp; </td>
                         <td width="20" align="center">
                          <a href="?opcion=valborrarlicencia&nombre='.$row['nombre'].'&nomconcepto='.$row['nomconcepto'].'&dias='.$row['dias'].'&pendienteid='.$row['pendienteid'].'" rel="facebox" title="eliminar licencia">
                           <img src="images/basicas/iconoborrar.png" border="0">
                          </a>
                         </td>                        
                         <td width="20" align="center">
                          <a href="?opcion=editarlicencia&nombre='.$row['nombre'].'&nomconcepto='.$row['nomconcepto'].'&dias='.$row['dias'].'&pendienteid='.$row['pendienteid'].'" title="modificar licencia" rel="facebox">
                           <img src="images/basicas/iconobuscar.png" border="0">
                          </a>
                         </td>
                        </tr>';
            }

            $cont.=' </tbody>
                    </table>';

            echo $cont.$clase->PiePagina();
        }

        // Salida en formato PDF
        if($tiposalida=="pdf")
        {
            // Traducción al español del mes que devuelve la función date()
            $mesimp = date('F');
            if($mesimp=="January")       $mesimp = "Enero";
            if($mesimp=="February")      $mesimp = "Febrero";
            if($mesimp=="March")         $mesimp = "Marzo";
            if($mesimp=="April")         $mesimp = "Abril";
            if($mesimp=="May")           $mesimp = "Mayo";
            if($mesimp=="June")          $mesimp = "Junio";
            if($mesimp=="July")          $mesimp = "Julio";
            if($mesimp=="August")        $mesimp = "Agosto";
            if($mesimp=="September")     $mesimp = "Septiembre";
            if($mesimp=="October")       $mesimp = "Octubre";
            if($mesimp=="November")      $mesimp = "Noviembre";
            if($mesimp=="December")      $mesimp = "Diciembre";

            $clase = new Sistema();
            ini_set("memory_limit","200M");
            require('lib/fpdf/fpdf.php');
            $pdf=new FPDF();

            $pdf->AddPage("");

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

            $x = 35;
            $y = 15;
            $pagina = 1;

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x+110,$y,$fechoraimp);

            // Impresión del encabezado
            $pdf->SetFont('Arial','B',10);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
            $pdf->Text($x,$y,$enc);
            $enc= "INFORME DE LICENCIAS PENDIENTES";
            $pdf->Text($x,$y+5,$enc);

            $pdf->SetFillColor(220,220,220);
            $pdf->Rect(5,37,200,8,'F');
            $pdf->SetFont('Arial','B',9);
            $enc= "CODIGO";
            $pdf->Text($x-25,$y+27,$enc);
            $enc= "NOMBRE";
            $pdf->Text($x-5,$y+27,$enc);
            $enc= "CONCEPTO";
            $pdf->Text($x+70,$y+27,$enc);
            $enc= "DIAS";
            $pdf->Text($x+157,$y+27,$enc);

            // Impresión del detalle del informe
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $x = 10;
            $y = 50;
            while($row = mysql_fetch_array($result))
            {
                $pdf->SetFont('Arial','',8);
                $pdf->Text($x,$y,$row['codvende']);
                $pdf->Text($x+20,$y,$row['nombre']);
                $pdf->Text($x+95,$y,$row['nomconcepto']);

                $longitud = strlen($row['dias']);

                if($longitud==1)        $pdf->Text($x+186,$y,$row['dias']);
                if($longitud==2)        $pdf->Text($x+184,$y,$row['dias']);
                if($longitud==3)        $pdf->Text($x+183,$y,$row['dias']);

                $y+=6;
            }
            
            $pdf->Output();
        }
        
        // Salida a Excel
        if($tiposalida=="excel")
        {
            // Obtengo el nombre del periodo a procesar
            $vsql2 = "SELECT periodoid
                        FROM periodosnomina 
                       WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql2);

            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            // Preparo el entorno
            require_once 'lib/PHPExcel.php';
            $clase = new Sistema();
            $clase->Conectar();
            ini_set("memory_limit","100M");

            // Preparación del entorno para la salida a Excel
            $clase = new Sistema();
            $clase->Nombredb = $_SESSION['DBNOMBRE'];
            error_reporting(E_ALL);
            ini_set('display_errors', TRUE);
            ini_set('display_startup_errors', TRUE);
            date_default_timezone_set('Europe/London');
        
            if (PHP_SAPI == 'cli')
                die('This example should only be run from a Web Browser');
        
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
        
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                         ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                         ->setTitle("Licencias pendientes - DROPOS")
                                         ->setSubject("Licencias pendientes - DROPOS")
                                         ->setDescription("Licencias pendientes - DROPOS")
                                         ->setKeywords("Licencias pendientes - DROPOS")
                                         ->setCategory("Categoria General");

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'INFORME DE LICENCIAS PENDIENTES')
                        ->setCellValue('A2', 'PERIODO '.$descripcion)
                        ->setCellValue('A3', 'CODIGO')
                        ->setCellValue('B3', 'NOMBRE')
                        ->setCellValue('C3', 'CONCEPTO')
                        ->setCellValue('D3', 'DIAS');

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            
            $i=4;
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant   = mysql_num_rows($result);
            while($row = mysql_fetch_array($result))
            {
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $row['codvende'])
                            ->setCellValue('B'.$i, $row['nombre'])
                            ->setCellValue('C'.$i, $row['nomconcepto'])
                            ->setCellValue('D'.$i, number_format($row['dias']));
                $i++;
            }

            $rangoEncabezado = 'A3:D3';
            $rangoCeldas     = 'A3:D'.($cant+3);
            
            // Formato de Encabezado y Celdas
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
            
            $EstiloCeldas = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ),
                ),
            );
            $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
            /// Formato de Encabezados 
            $EstiloEncabezado = array(
            'font' => array(
                'bold' => true,
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
            ),
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ),
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'rotation' => 90,
                'startcolor' => array(
                    'argb' => '00FFFFCC',
                ),
                'endcolor' => array(
                    'argb' => 'FFFFFF',
                ),
                ),
            );
            $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('licencias pendientes');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Redirect output to a client’s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            $nombrearcexcel = "licencias pendiente de la ".strtolower($descripcion).".xls";
            header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
            header('Cache-Control: max-age=0');
            /// Genero la Salida
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            exit;
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarlicencia
    // Creación: 28/09/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que edita los días de una licencia pendiente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "editarlicencia")
    {
        $nombre = $_GET['nombre'];
        $nomconcepto = $_GET['nomconcepto'];
        $dias = $_GET['dias'];
        $pendienteid = $_GET['pendienteid'];

        $cont ='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b>Editar licencia pendiente</b> </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> Empleado(a): '.$nombre.' </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> Licencia: '.$nomconcepto.' </td> 
                 </tr>
                </table>
                <form action="licenciaspendiente.php?opcion=almlicedit" method="POST" name="x">
                <input type="hidden" name="pendienteid" value="'.$pendienteid.'">
                <table width="400">
                 <center><br>
                 <tr class="TablaDocsImPar">
                  <td width="150" align="right"> D&iacute;as: &nbsp; </td>
                  <td width="250"> <input type="number" name="dias" class="Texto12New" size="4" min="1" maxlength="4" autocomplete="off" value="'.$dias.'"> </td>
                 </tr>
                </table>
                <br><center>
                <input type="submit" value="aceptar" class="button blue">
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: almlicedit
    // Creación: 28/09/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena la modificación de la licencia pendiente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////            
    if($opcion == "almlicedit")
    {
        $pendienteid = $_POST['pendienteid'];
        $dias = $_POST['dias'];

        // Modifico el monto en la tabla detallenomina
        $vsql = "UPDATE licenciaspendiente SET dias = ".$dias." WHERE pendienteid = ".$pendienteid;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Licencia editada satisfactoriamente");
        else
            $clase->Aviso(3,"No se editó la licencia");

        // Redirecciono el formulario
        header("Location: licenciaspendiente.php?opcion=ventanadatos");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: valborrarlicencia
    // Creación: 28/09/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de una licencia pendiente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "valborrarlicencia")
    {
        $nombre = $_GET['nombre'];
        $nomconcepto = $_GET['nomconcepto'];
        $dias = $_GET['dias'];
        $pendienteid = $_GET['pendienteid'];

        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><b>Eliminar una licencia pendiente</b><br><br><td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">¿Confirma que desea eliminar la licencia <b>'.$nomconcepto.'</b> <br>
                  del empleado(a) <b>'.$nombre.'</b> <br> por <b>'.$dias.'</b> días?</td>
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>                  
                   <form action="?opcion=elimlic&pendienteid='.$pendienteid.'" method="POST">
                   <input type="hidden" name="pendienteid" value="'.$pendienteid.'">
                   <input type="submit" value="ACEPTAR" class="button red">
                   </form>
                   <br>
                  </td>        
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: elimlic
    // Creación: 28/09/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para eliminar la licencia pendiente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "elimlic")
    {
        $pendienteid = $_POST['pendienteid'];
        $dias = 0;

        // Elimino el concepto en la tabla detallenomina
        $vsql = "UPDATE licenciaspendiente SET dias = ".$dias." WHERE pendienteid = ".$pendienteid;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Licencia eliminada satisfactoriamente");
        else
            $clase->Aviso(3,"No se eliminó la licencia");

        // Redirecciono el formulario
        header("Location: licenciaspendiente.php?opcion=ventanadatos");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: confirmareliminarlic
    // Creación: 17/03/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para eliminar todas las licencias pendientes
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confirmareliminarlic")
    {
        $tiposalida = "vista";

        // pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"><br><label class="Texto12"><b>Eliminar todas las licencias pendientes</b></label><br></td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center">
                   <label class="Texto12">
                   ¿Confirma que desea eliminar todas las licencias pendientes?
                   </label>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"><br><br>                  
                   <form action="?opcion=elimartodaslicencias" method="POST">                   
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="licenciaspendiente.php?opcion=diaspendientes&tiposalida='.$tiposalida.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form><br>
                  </td>        
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: elimartodaslicencias
    // Creación: 17/03/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina todas las licencias pendientes
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "elimartodaslicencias")
    {
        // Eliminó las licencias pendientes
        $vsql = "DELETE FROM licenciaspendiente";
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 0)
            $clase->Aviso(1,"Registros eliminados exitosamente");
        else
            $clase->Aviso(3,"No se eliminaron los registros");

        // Redirecciono el formulario
        header("Location: licenciaspendiente.php?opcion=ventanadatos");
    }
?>