<?PHP
  error_reporting(E_ALL);
  ini_set('display_errors', FALSE);
  ini_set('display_startup_errors', FALSE);


  /////////////////////////////////////////////////////////////////////////  
  /// Impresion de la Planilla de Cierre Definitivo de Caja
  /////////////////////////////////////////////////////////////////////////  
  function PlanillaCierreDefinitivo($cierreid,$imprimir="S")
  {
     ini_set("memory_limit","200M");
     set_time_limit(0);

	   $clase = new Sistema();
 	   $diaoperativo = $clase->BDLockup($cierreid,'cierres','cierreid','diaoperativo');	
       $momcierre    = $clase->BDLockup($cierreid,'cierres','cierreid','momento');		 
	   $nomoperador  = $_SESSION['USERNAME'];
	 
	  $sucid  = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	  $nomsuc = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','descripcion');	 	 
	  $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	  $nitempresa = $_SESSION['G_NIT_EMPRESA'];
	  $cont.=  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).'     '.$nomempresa.Chr(13).Chr(10);	
	  $cont.= '           '.$nitempresa.Chr(13).Chr(10);		 
 
     $cont.= ' **** CIERRE DE CAJA DEFINITIVO  ****  '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'COMPROBANTE DE CIERRE No. '.str_pad($cierreid,6,"0",STR_PAD_LEFT).Chr(13).Chr(10);    
	 $cont.= '======================================='.Chr(13).Chr(10);  
	 
	 if($_SESSION['G_SERIALIMPRESORA'] != "")
	 {
		$cont.= 'IMPRESORA FISCAL SERIAL : '.$_SESSION['G_SERIALIMPRESORA'].Chr(13).Chr(10);          
		$cont.= '======================================='.Chr(13).Chr(10);          
	 }

     $cont.= 'MOMENTO DEL CIERRE : '.substr($momcierre,0,16).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= '      DIA OPERATIVO : '.$diaoperativo.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' USUARIO : '.substr($nomoperador,0,28).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	   $cont.= '     SUCURSAL : '.$nomsuc.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10).Chr(13).Chr(10);          

     //// Descripcion del Cuadre de Caja
	   ///// Efectivo
	   $vsqlventas = "SELECT SUM(DV.valorfp1) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	   $ventas     = $clase->SeleccionarUno($vsqlventas);	 
	 
	   ///// Tarjetas Debito y Credito
	   $vsqltar    = "SELECT SUM(DV.valorfp2) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	   $tarjetas   = $clase->SeleccionarUno($vsqltar);
		
	   ///// Transferencia Bancaria
	   $vsqltranfe = "SELECT SUM(DV.valorfp3) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
		              WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
       $transferencias = $clase->SeleccionarUno($vsqltranfe);

	   ///// Creditos a Empleados
	   $vsqlbon    = "SELECT SUM(DV.valorfp4) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                  WHERE D.tipodoc = 'FVE' AND D.nrodocref <> 'VENTA-RAPPI' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	   $bonosdcto  = 0+$clase->SeleccionarUno($vsqlbon);

	   $vsqlrapp   = "SELECT SUM(DV.valorfp6) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                  WHERE D.tipodoc = 'FVE' AND  D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	   $vtasrappi  = 0+$clase->SeleccionarUno($vsqlrapp);
	   
	   $vsqlpuntos = "SELECT SUM(DV.valorfp5) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	   $puntos     = 0+$clase->SeleccionarUno($vsqlpuntos);	 

	   $vsqlrapp   = "SELECT SUM(DV.valorfp7) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                  WHERE D.tipodoc = 'FVE' AND DV.canalventa = 'TVI' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
       $vtasepayco  = 0+$clase->SeleccionarUno($vsqlrapp);

	   ///// Devoluciones
	   $vsqldevoluc  = "SELECT SUM(DV.valor) FROM docudevolucion DV INNER JOIN documentos D ON (D.docuid = DV.docuid) WHERE D.tipodoc = 'DVE' AND D.formapago = 'CO' AND DV.diaoperativo='".$diaoperativo."' AND D.fecasentado <> '0000-00-00'";
	   $devoluciones = 0+$clase->SeleccionarUno($vsqldevoluc);
	 
	   ///// Recogidas
	   $vsqlrecog  = "SELECT SUM(valrecogida) FROM recogidas WHERE diaoperativo = '".$diaoperativo."'";
	   $recogidas  = $clase->SeleccionarUno($vsqlrecog);
		 
	   ///// Arqueos
	   $vsqlcierr  = "SELECT SUM(valentrega) FROM cierres WHERE tipocierre = 'PAR' AND diaoperativo='".$diaoperativo."'";
	   $arqueos    = $clase->SeleccionarUno($vsqlcierr);

		///// Base Caja
		$vsqlcierr  = "SELECT valcaja FROM cierres WHERE tipocierre = 'DEF' AND (diaoperativo='".$diaoperativo."')";
		$basecaja   = $clase->SeleccionarUno($vsqlcierr);
		///// Valor entregado en el Cierre
		$vsqlentreg = "SELECT valentrega FROM cierres WHERE tipocierre = 'DEF' AND (diaoperativo='".$diaoperativo."')";
		$entregado  = $clase->SeleccionarUno($vsqlentreg);
		///// Domicilios
		$vsqldomi   = "SELECT 0 FROM cierres WHERE 1";
		$domicilios = $clase->SeleccionarUno($vsqldomi);
		///// Gastos
		$vsqlbaloto = "SELECT 0 FROM cierres WHERE 1";
		$baloto     = $clase->SeleccionarUno($vsqlbaloto);
		///// ReteFuente
		$vsqlretefte = "SELECT SUM(D.retefuente) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) WHERE D.tipodoc = 'FVE' AND DV.diaoperativo = '".$diaoperativo."'";
		$retefuente  = $clase->SeleccionarUno($vsqlretefte);
		///// ReteFuente
		$vsqlcompras    = "SELECT SUM(valortotal) FROM autorizacionesgastos WHERE codsucursal = '".$_SESSION['G_SUCURSALPOS']."' AND diaoperativo = '".$diaoperativo."'";
		$comprasgastos  = $clase->SeleccionarUno($vsqlcompras);

		///// Billeteras Entradas de Dinero
		$vsqlentradasbilleteras = "SELECT SUM(amount) FROM transaccionesbilleteras WHERE tipomov = 'E' AND diaoperativo = '".$diaoperativo."'";
		$entradasbilleteras = 0+$clase->SeleccionarUno($vsqlentradasbilleteras);
		///// Billeteras Salidas de Dinero
		$vsqlsalidasbilleteras = "SELECT SUM(amount) FROM transaccionesbilleteras WHERE tipomov = 'S' AND diaoperativo = '".$diaoperativo."'";
		$salidasbilleteras = 0+$clase->SeleccionarUno($vsqlsalidasbilleteras);		
		///// Calculo el Saldo de las Billeteras
		$saldobilleteras = (0+($entradasbilleteras-$salidasbilleteras));
		
		//// Separo las Compras - Gastos
		$vsqlcompras    = "SELECT SUM(valortotal) FROM autorizacionesgastos WHERE codsucursal = '".$_SESSION['G_SUCURSALPOS']."' AND diaoperativo = '".$diaoperativo."' AND tipo = 'COMPRA'";
		$comprasx       = $clase->SeleccionarUno($vsqlcompras);
		$vsqlcompras    = "SELECT SUM(valortotal) FROM autorizacionesgastos WHERE codsucursal = '".$_SESSION['G_SUCURSALPOS']."' AND diaoperativo = '".$diaoperativo."' AND tipo = 'GASTO' AND codconcepto <> '999'";
		$gastosx        = $clase->SeleccionarUno($vsqlcompras);
		$vsqlcompras    = "SELECT SUM(valortotal) FROM autorizacionesgastos WHERE codsucursal = '".$_SESSION['G_SUCURSALPOS']."' AND diaoperativo = '".$diaoperativo."' AND tipo = 'TERCER'";
		$tercerosx      = $clase->SeleccionarUno($vsqlcompras);

		$ingresos   = $ventas + $entradasbilleteras + $baloto - $devoluciones;
		$egresos    = $gastos + $salidasbilleteras + $recogidas + $arqueos + $entregado;	  
		$saldo      = $ingresos - $egresos;
		
		 //// Calculo del Dinero Sobrante - Faltante
		 if($saldo>0)   /// Es Faltante   
		 {	   
			 $dinfaltante = abs($saldo);	   
			 $dinsobrante = 0;
			 $restaringresos = $saldo;	            
		 }
		 
		 if($saldo<0)   
		 {	   
			  $dinfaltante = 0;   	       
			  $restaringresos = 0;
			  $dinsobrante = abs($saldo);
			  //	$dinsobrante = abs(($ingresos-$restaringresos)-($egresos-$comprasgastos));	
		 }

		 if($saldo == 0)
		 {	   
			  $dinfaltante = 0;     	  
			  $dinsobrante = 0; 	 
			  $restaringresos = 0;
		 }
		 
		 $subtotal = ($ventas+$dinsobrante-$devoluciones);
		 $montototalconsignar = (0+(($subtotal-$comprasgastos)+$saldobilleteras));
		  
     /// Genero la Impresion
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '    DETALLES DEL ARQUEO DE CAJA        '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONCEPTO           INGRESOS    EGRESOS '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'EFECTIVO        '.str_pad(number_format($ventas,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'DEVOLUCIONES    '.str_pad(number_format((-1)*$devoluciones,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= 'TARJETAS DB CR  '.str_pad(number_format($tarjetas,0),11," ",STR_PAD_LEFT).str_pad(number_format($tarjetas,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 
	 $cont.= 'TRANSFERENCIAS  '.str_pad(number_format($transferencias,0),11," ",STR_PAD_LEFT).str_pad(number_format($transferencias,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
	 $cont.= 'CREDITOS        '.str_pad(number_format($bonosdcto,0),11," ",STR_PAD_LEFT).str_pad(number_format($bonosdcto,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	      
     $cont.= 'PUNTOS FARMANOR '.str_pad(number_format($puntos,0),11," ",STR_PAD_LEFT).str_pad(number_format($puntos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	      
     $cont.= 'VENTAS RAPPI CR '.str_pad(number_format($vtasrappi,0),11," ",STR_PAD_LEFT).str_pad(number_format($vtasrappi,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	           
	 $cont.= 'TIENDAV EPAYCO  '.str_pad(number_format($vtasepayco,0),11," ",STR_PAD_LEFT).str_pad(number_format($vtasepayco,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	           
	 $cont.= 'BILLETERAS (E/S)'.str_pad(number_format($entradasbilleteras,0),11," ",STR_PAD_LEFT).str_pad(number_format($salidasbilleteras,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
	 $cont.= 'BONOS DCTO      '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	           
     $cont.= 'RECOGIDAS       '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($recogidas,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'CIERRES PARC.   '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($arqueos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	
     $cont.= 'EFECT. EN CAJA  '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($entregado,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
	 $cont.= 'DOMICILIOS      '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
	 $cont.= 'RETE FUENTE     '.str_pad(number_format($retefuente,0),11," ",STR_PAD_LEFT).str_pad(number_format($retefuente,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 
     $cont.= ' SUB TOTALES    '.str_pad(number_format($ingresos,0),11," ",STR_PAD_LEFT).str_pad(number_format($egresos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 
	 $cont.= ' COMPRAS  (-)              '.str_pad('-'.number_format($comprasx,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);    
	 $cont.= ' GASTOS   (-)              '.str_pad('-'.number_format($gastosx,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);    
	 $cont.= ' TERCEROS (-)              '.str_pad('-'.number_format($tercerosx,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);    
	 $cont.= '======================================='.Chr(13).Chr(10);          	 
	 $cont.= ' SUB TOTAL 2    '.str_pad(number_format($ingresos-$restaringresos,0),11," ",STR_PAD_LEFT).str_pad(number_format($egresos-$comprasgastos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
	 $cont.= '======================================='.Chr(13).Chr(10);

	 /// Muestro el Sobrante / Faltante  
	 $cont.= ' DINERO FALTANTE            '.str_pad(number_format(abs($dinfaltante),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 
	 $cont.= ' DINERO SOBRANTE            '.str_pad(number_format(abs($dinsobrante),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 
	 $cont.= '======================================='.Chr(13).Chr(10);          	 
	 $cont.= ' TOTAL A CONSIGNAR :        '.str_pad(number_format($montototalconsignar,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 
	 $cont.= '======================================='.Chr(13).Chr(10).Chr(13).Chr(10);        

     /// Calculo el Total a Consignar y lo Actualizo en el Registro del Cierre
	 $totconsig = 0+($ventas+$dinsobrante-$devoluciones-$gastos);
	 $totvendia = 0+($ventas+$tarjetas+$transferencias+$bonosdcto+$puntos+$vtasepayco-$devoluciones);
	 $bonosdcto += 0;

	 /// Actualizo estos Valores calculados en el registro de la Base de datos
	 $totalventadiaXX = 0+($ventas+$tarjetas+$transferencias+$bonosdcto+$vtasrappi+$vtasepayco+$puntos-$devoluciones);			
 	 $clase->EjecutarSQL("UPDATE cierres SET valrappi = '".$vtasrappi."' , valpasarela = '".$vtasepayco."' , valbilleteras = '".$saldobilleteras."' WHERE cierreid = ".$cierreid);		
	 $clase->EjecutarSQL("UPDATE cierres SET totalarqueo = '".$totalventadiaXX."' , devoluciones = '".$devoluciones."' , valdatafono = '".$tarjetas."' , faltante = '".$dinfaltante."' , sobrante = '".$dinsobrante."' WHERE cierreid = ".$cierreid);
	 $clase->EjecutarSQL("UPDATE cierres SET tottarjetas = '".$tarjetas."' , totcreditos = '".($bonosdcto+$vtasrappi)."' , totpuntos = '".$puntos."' , totconsignar = '".$montototalconsignar."' WHERE cierreid = ".$cierreid);
	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10);          	 	 
	 $cont.= ' TOTAL VENTA DEL DIA        '.str_pad(number_format(($ventas+$tarjetas+$transferencias+$bonosdcto+$vtasrappi+$vtasepayco+$puntos-$devoluciones),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10).Chr(13).Chr(10);          	 	 
	 
     /// Resumen de Impuestos
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '        RESUMEN DE IMPUESTOS           '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' T  %IVA  VLR BASE   VLR IVA  VLR VENTA'.Chr(13).Chr(10);          
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
     $vsql ="SELECT DD.porciva , SUM(DD.valbase) base , SUM(DD.valiva) iva , SUM(DD.valtotal) total 
			 FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			 INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
			 WHERE D.tipodoc = 'FVE' AND diaoperativo = '".$diaoperativo."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
			 GROUP BY 1
			 UNION 
			 SELECT DD.porciva , ((-1)*SUM(DD.valbase)) base , ((-1)*SUM(DD.valiva)) iva , ((-1)*SUM(DD.valtotal)) total 
			 FROM documentos D 
			 INNER JOIN docudevolucion DV ON (D.docuid = DV.docuid) 
			 INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
			 WHERE D.tipodoc = 'DVE' AND diaoperativo = '".$diaoperativo."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
			 GROUP BY 1 ORDER BY 1";

     $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 $totbase = 0;     $totiva = 0;     $totventa = 0;	 
	 $base00 = 0;      $iva00 = 0;      $total00 = 0;  
	 $base05 = 0;      $iva05 = 0;      $total05 = 0;
	 $base19 = 0;      $iva19 = 0;      $total19 = 0;

	 $detalles = "";
	 while($row = @mysql_fetch_array($result))
	 { 
	   if($row['porciva'] == 0)
	   {
		  $base00  += 0+$row['base'];
		  $iva00   += 0+$row['iva'];
		  $total00 += 0+$row['total'];
	   }
	   
	   if($row['porciva'] == 5)
	   {
		  $base05  += 0+$row['base'];
		  $iva05   += 0+$row['iva'];
		  $total05 += 0+$row['total'];
	   }

	   if($row['porciva'] == 19)
	   {
		  $base19  += 0+$row['base'];
		  $iva19   += 0+$row['iva'];
		  $total19 += 0+$row['total'];
	   }

	   $totbase += $row['base'];     $totiva+= $row['iva'];     $totventa += $row['total'];	   
	   
	   $totales  = str_pad(number_format($totbase,0),17," ",STR_PAD_LEFT).'  ';
	   $totales .= str_pad(number_format($totiva,0),8," ",STR_PAD_LEFT).'  ';	   
	   $totales .= str_pad(number_format($totventa,0),10," ",STR_PAD_LEFT);	   	   
	}

	$detalles.= "  ".str_pad(0,3," ",STR_PAD_LEFT).'  ';
	$detalles.= str_pad(number_format($base00,0),10," ",STR_PAD_LEFT).'  ';
	$detalles.= str_pad(number_format($iva00),8," ",STR_PAD_LEFT).' ';
	$detalles.= str_pad(number_format($total00),11," ",STR_PAD_LEFT).Chr(13).Chr(10); 	 
	
	$detalles.= "  ".str_pad(5,3," ",STR_PAD_LEFT).'  ';
	$detalles.= str_pad(number_format($base05,0),10," ",STR_PAD_LEFT).'  ';
	$detalles.= str_pad(number_format($iva05),8," ",STR_PAD_LEFT).' ';
	$detalles.= str_pad(number_format($total05),11," ",STR_PAD_LEFT).Chr(13).Chr(10); 	 
	
	$detalles.= "  ".str_pad(19,3," ",STR_PAD_LEFT).'  ';
	$detalles.= str_pad(number_format($base19,0),10," ",STR_PAD_LEFT).'  ';
	$detalles.= str_pad(number_format($iva19),8," ",STR_PAD_LEFT).' ';
    $detalles.= str_pad(number_format($total19),11," ",STR_PAD_LEFT).Chr(13).Chr(10); 	 
 	   
	$cont.= $detalles;
    $cont.= '---------------------------------------'.Chr(13).Chr(10);   
    $cont.= $totales.Chr(13).Chr(10).Chr(13).Chr(10);       

	//// Guardo los Valores en el Cierre 
	$vsqlx = "UPDATE cierres SET ventaexcluida = '".$total00."' , valbase19 = '".$base19."' , valiva19 = '".$iva19."' , valbase05 = '".$base05."' , valiva05 = '".$iva05."' WHERE cierreid = ".$cierreid;
	$clase->EjecutarSQL($vsqlx);

	//////////////////////////////////////
	/// Solo hasta aqui imprimir
	//$IMPRIMIR = $cont;
	/*
	////////////////////////////////////////////////////////////////////////////////////
    //// Discrimino el INC causado por las Bolsas
    $vsql = "SELECT SUM(cantidad) FROM dedocumentos DD INNER JOIN productos P ON (DD.productoid = P.productoid) 
             INNER JOIN docuventa DV ON (DD.docuid = DV.docuid) WHERE P.codigo = 'BOLSAX' AND DV.diaoperativo ='".$diaoperativo."'";
     $canbolsas = $clase->SeleccionarUno($vsql);

     $cont.= '        INC BOLSAS PLASTICAS           '.Chr(13).Chr(10); 
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'BOLSAS ENTREGADAS  '.str_pad(number_format($canbolsas,0),8," ",STR_PAD_LEFT).'    ';
	 $cont.= str_pad(number_format(($canbolsas*20),0),8," ",STR_PAD_LEFT).'  ';	         
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

	 /////////////////////////////////////////////////////////////////
	 ///// Guardo en la Tabla Cierres la información
	 $vsqlx = "UPDATE cierres SET valrecogidas = '".abs($recogidas)."' , totefectivo = '".abs($ventas)."' , 
	           tottarjetas = '".abs($tarjetas)."' , totcreditos = '".abs($creditos)."' , totpuntos = '".abs($puntos)."' , 
			   totconsignar = '".$montototalconsignar."' , valfaltante = '".abs($dinfaltante)."' , valsobrante = '".abs($dinsobrante)."' , 
			   porcenfalta = '0' , base00 = '".$base00."' , base19 = '".$base19."' , iva19 = '".$iva19."' ,  
			   base05 = '".$base05."' , iva05 = '".$iva05."' , diferencia = '".abs(($dinfaltante-$dinsobrante))."' ,
			   cantivaucher = '0' WHERE cierreid = ".$cierreid;    
     $clase->EjecutarSQL($vsqlx);
     	 */
	 //////////////////////////////////////////////////////////
	 ///// Discriminacion de Medios de Pago	 
	 //////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   DISCRIMINACION DE MEDIOS DE PAGO    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' MEDIO PAGO               TOTAL   CANT '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT diaoperativo , 
				(SELECT COUNT(*) FROM docuventa WHERE valorfp1 > 0 AND diaoperativo = DV.diaoperativo) CanEfec , 
				(SELECT COUNT(*) FROM docuventa WHERE valorfp2 > 0 AND diaoperativo = DV.diaoperativo) CanTarj , 
				(SELECT COUNT(*) FROM docuventa WHERE valorfp3 > 0 AND diaoperativo = DV.diaoperativo) CanOtro ,
				(SELECT COUNT(*) FROM docuventa WHERE valorfp4 > 0 AND diaoperativo = DV.diaoperativo) CanCred ,			  
				(SELECT COUNT(*) FROM docuventa WHERE valorfp5 > 0 AND diaoperativo = DV.diaoperativo) CanPuntos ,	
				(SELECT COUNT(*) FROM docuventa WHERE valorfp6 > 0 AND diaoperativo = DV.diaoperativo) CanRappi ,	
				(SELECT COUNT(*) FROM docuventa WHERE valorfp7 > 0 AND diaoperativo = DV.diaoperativo) CanPasarela ,	
				SUM(valorfp1) valorfp1 , SUM(valorfp2) valorfp2 , SUM(valorfp3) valorfp3 , SUM(valorfp4) valorfp4 , SUM(valorfp5) valorfp5  , SUM(valorfp6) valorfp6  , SUM(valorfp7) valorfp7 
				FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo = '".$diaoperativo."' 
				GROUP BY 1 , 2 , 3 , 4 , 5"; 

	 $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $det = "";
	 if($row = @mysql_fetch_array($result))
	 { 
	   $det = 'EFECTIVO ............';
	   $det.= str_pad(number_format($row['valorfp1'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanEfec'],0),7," ",STR_PAD_LEFT);
 	   $det.= Chr(13).Chr(10);
	   $det.= 'TARJ DEB/CRED .......';
	   $det.= str_pad(number_format(($row['valorfp2']+$row['valorfp3']),0),10," ",STR_PAD_LEFT).str_pad(number_format(($row['CanTarj']+$row['CanOtro']),0),7," ",STR_PAD_LEFT);
 	   $det.= Chr(13).Chr(10);
	   $det.= 'CREDITOS ............';
	   $det.= str_pad(number_format($row['valorfp4'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanCred'],0),7," ",STR_PAD_LEFT);
	   $det.= Chr(13).Chr(10);
	   $det.= 'PUNTOS FARMANORTE ...';
	   $det.= str_pad(number_format($row['valorfp5'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanPuntos'],0),7," ",STR_PAD_LEFT);
	   $det.= Chr(13).Chr(10);
	   $det.= 'CREDITOS RAPPI ......';
	   $det.= str_pad(number_format($row['valorfp6'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanRappi'],0),7," ",STR_PAD_LEFT);
	   $det.= Chr(13).Chr(10);
	   $det.= 'PASARELA EPAYCO .....';
	   $det.= str_pad(number_format($row['valorfp7'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanPasarela'],0),7," ",STR_PAD_LEFT);
	   $det.= Chr(13).Chr(10);
	 }
	 $cont.= $det.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 
	 ///////////////////////////////////////////////////////////////////
	 ///// Estadisticas del Proceso de Venta
	 ///////////////////////////////////////////////////////////////////
	 $vsql    = "SELECT COUNT(*) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) WHERE D.tipodoc = 'FVE' AND DV.diaoperativo='".$diaoperativo."'";
	 $cliaten = $clase->SeleccionarUno($vsql);
	 $vsql    = "SELECT CONCAT(prefijo,' ',CAST(numero AS DECIMAL(9,0))) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	             WHERE D.tipodoc = 'FVE' AND DV.diaoperativo='".$diaoperativo."' ORDER BY NUMERO ASC limit 0,1";
	 $finicial = $clase->SeleccionarUno($vsql);
	 $vsql    = "SELECT CONCAT(prefijo,' ',CAST(numero AS DECIMAL(9,0))) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	             WHERE D.tipodoc = 'FVE' AND DV.diaoperativo='".$diaoperativo."' ORDER BY NUMERO DESC limit 0,1";
	 $ffinal  = $clase->SeleccionarUno($vsql);
	 $vsql = "SELECT COUNT(*) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN terceros T ON (T.terid = D.terid1) WHERE D.tipodoc = 'FVE' AND T.codigo <> '99 'AND DV.diaoperativo = '".$diaoperativo."'";
	 $cliregis = $clase->SeleccionarUno($vsql);
	 $clinoreg = $cliaten-$cliregis;

     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   ESTADISTICAS DEL PROCESO DE VENTA   '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'FACTURA INICIAL : .........'.str_pad($finicial,12," ",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= 'FACTURA FINAL : ...........'.str_pad($ffinal,12," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'CLIENTES ATENDIDOS : ......'.str_pad(number_format($cliaten,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= 'CLIENTES REGISTRADOS : ....'.str_pad(number_format($cliregis,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	           
	 $cont.= 'CLIENTES NO REGISTRADOS : .'.str_pad(number_format($clinoreg,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);          	 	 	 
/*
     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Bonos de Descuento Aplicados
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '    RELACION DE BONOS DE DESCUENTO     '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'FACTURA   NUM BONO    VAL DCTO   TOTAL '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.prefijo,' ',D.numero) factura , D.nrodocref , DV.valorfp4 , D.total 
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
	          WHERE D.tipodoc = 'FVE' AND DV.valorfp4 > 0 AND D.fecasentado <> '0000-00-00' AND 
	          D.nrodocref <> '' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $canbonos = 0;    $totbonos = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['factura'],0,10),10," ",STR_PAD_RIGHT).str_pad(substr($row['nrodocref'],0,6),6," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(substr($row['valorfp4'],0,8),8," ",STR_PAD_RIGHT).str_pad(number_format($row['total'],0),7," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totbonos += $row['valorfp4'];  	   $canbonos++;
	 } 

     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT BONOS DCTO : '.str_pad(number_format($canbonos,0),5," ",STR_PAD_LEFT).str_pad(number_format($totbonos,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);


     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Devoluciones
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '      DEVOLUCIONES DE CLIENTES         '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  USUARIO    HORA     VALOR '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , creador , fechadoc , total 
	          FROM documentos D INNER JOIN docudevolucion DV ON (D.docuid = DV.docuid)
	          WHERE D.tipodoc = 'DVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
     	 		  
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['creador'],0,11),11," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(substr($row['fechadoc'],11,5),5," ",STR_PAD_RIGHT).str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 

     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DEVOLUCIONES : '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Domicilios 	 
	 /////////////////////////////////////////////////////////////////
	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '      RELACION DE DOMICILIOS           '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'MENSAJERO         FACTURA        VALOR'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(nombres,' ',apellidos) nommen , CONCAT(prefijo,numero) numfac ,  total 
	          FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid3)
	          INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          WHERE (T.codigo <> '00' AND T.codigo <> '99' AND T.codigo <> '98') AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
			  AND diaoperativo ='".$diaoperativo."' GROUP BY 1,2";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $candomi = 0;    $vendomi = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= substr($row['nommen'],0,16).'  '.substr($row['numfac'],0,10).str_pad(number_format($row['total'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $vendomi += $row['total'];  	   $candomi++;
	 } 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DOMICILIOS : '.str_pad(number_format($candomi,0),5," ",STR_PAD_LEFT).str_pad(number_format($vendomi,0),15," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 
	 /////////////////////////////////////////////////////////////////
	 ///////   Facturas de Venta con Retefuente
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   FACTURAS DE VENTA CON RETEFUENTE    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'DOCUMEN     NOMBRE CLIENTE        VALOR'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(nombres,' ',apellidos) nommen , CONCAT(prefijo,' ',numero) numfac ,  total 
	          FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
	          INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          WHERE D.retefuente>0 AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
			  AND diaoperativo ='".$diaoperativo."' GROUP BY 1,2";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $candomi = 0;    $vendomi = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= substr($row['numfac'],0,10).'  '.substr($row['nommen'],0,16).str_pad(number_format($row['total'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 } 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Creditos por Empleado
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '     DETALLE DE VENTAS A CREDITO       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  USUARIO        VALOR FACT.'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.prefijo,D.numero) consec , CONCAT(nombres,' ',apellidos) usuario , total 
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			  INNER JOIN terceros T ON (T.terid = D.terid1)
			  WHERE D.formapago = 'CR' AND D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
	 //$conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['usuario'],0,16),17," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'TOTAL CREDITOS :    '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     //// Resumen de los Cierres Parciales
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          	 
     $cont.= '  RESUMEN CIERRES PARCIALES Y ARQUEOS  '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' ARQUEO  USUARIO    FECHA / HORA       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT * FROM cierres WHERE tipocierre = 'PAR' AND diaoperativo ='".$diaoperativo."' ORDER BY momento";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = @mysql_fetch_array($result))
	 { 
 	   $detalles.= ' '.str_pad($row['cierreid'],6,"0",STR_PAD_LEFT).'  ';
	   $detalles.= str_pad(substr($row['creador'],0,10),12," ",STR_PAD_RIGHT);
	   $detalles.= $row['momento'];
	 } 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);


     //// Ver cruces del Dia Operativo en la Tira 
     $vsqlcruces = "UPDATE docutranfe SET diaoperativo = '".$diaoperativo."' WHERE diaoperativo = '' AND docuid IN ( SELECT docuid FROM documentos WHERE tipodoc = 'TRB' AND fechadoc >= ( SELECT momento FROM cierres WHERE tipocierre = 'DEF' ORDER BY cierreid DESC LIMIT 1,1))";	 
     $clase->EjecutarSQL($vsqlcruces);

     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   RELACION CRUCES ENTRE SUCURSALES    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'DOCUMENTO   / ORIG / DEST /      VALOR '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          

	 /// Detallo los Cruces
	 $vsql = "SELECT DISTINCT CONCAT(D.prefijo,' ',D.numero) numdoc , D.total , B1.codbodega origen , B2.codbodega destino FROM documentos D INNER JOIN docutranfe DT ON (DT.docuid = D.docuid)
	          INNER JOIN bodegas B1 ON (B1.bodegaid = DT.bodegaidori) INNER JOIN bodegas B2 ON (B2.bodegaid = DT.bodegaiddes)  
			  WHERE D.tipodoc = 'TRB' AND D.prefijo = 'CRU' AND DT.diaoperativo = '".$diaoperativo."' OR date_format(str_to_date( D.fecasentado, '%Y-%m-%d'), '%d/%m/%Y') = '".$diaoperativo."'";
			  
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = @mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad($row['numdoc'],15," ",STR_PAD_RIGHT);
       $detalles.= str_pad($row['origen'],7," ",STR_PAD_RIGHT);
       $detalles.= str_pad($row['destino'],5," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(number_format($row['total'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 } 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

	 //// Resumen de Gastos detallados en Sistema
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '     RELACION GASTOS REGISTRADOS       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'PROVEEDOR / VALOR G   CONCEPTO          '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          

	 /// Detallo las recogidas de Dinero
	 $vsql = "SELECT CONCAT(T.nombres,' ',T.apellidos) prove , DC.valor , CO.descripcion 
	          FROM detallecierre DC INNER JOIN cierres C ON (C.cierreid = DC.cierreid) 
			  INNER JOIN conceptosgastos CO ON (CO.codigo = DC.codconcepto)
			  INNER JOIN terceros T ON (T.terid = DC.proveedor)			  
			  WHERE C.cierreid=".$cierreid;

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = @mysql_fetch_array($result))
	 { 
 	   $detalles.= substr($row['prove'],0,40).Chr(13).Chr(10);
 	   $detalles.= str_pad(substr($row['descripcion'],0,24),24," ",STR_PAD_RIGHT).'   ';
	   $detalles.= str_pad(number_format($row['valor'],0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 } 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

	 //// Resumen de los Cierres Parciales
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '  RELACION DE RECOGIDAS DE DINERO      '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'VALOR REC    USUARIO    FECHA / HORA '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Detallo las recogidas de Dinero
	 $vsql = "SELECT * FROM recogidas WHERE diaoperativo ='".$diaoperativo."' ORDER BY momento";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = @mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad(number_format($row['valrecogida'],0),9," ",STR_PAD_LEFT).'    ';
	   $detalles.= str_pad(substr($row['creador'],0,8),9," ",STR_PAD_RIGHT);
	   $detalles.= substr($row['momento'],0,16).Chr(13).Chr(10);
	 } 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Transferencias de Mercancia
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '    TRANSFERENCIAS A OTRAS BODEGAS     '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  BOD. DESTINO         VALOR'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , B.codbodega , total 
	          FROM documentos d INNER JOIN docutranfe DV ON (D.docuid = DV.docuid)
			  INNER JOIN bodegas B ON (DV.bodegaiddes = B.bodegaid)
	          WHERE D.tipodoc = 'TRB' AND B.codigo = '50' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['nombodega'],0,16),16," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 

     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DEVOLUCIONES : '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

      
	 /// Detallo los documentos de Despachos Convenio
	 $fechaphp = substr($diaoperativo,6,4).'-'.substr($diaoperativo,3,2).'-'.substr($diaoperativo,0,2);
     $vsql = "SELECT D.tipodoc, D.prefijo, D.numero, D.fechadoc , DC.dnibeneficiario
			  FROM documentos D
			  INNER JOIN docuconvenio DC ON ( D.docuid = DC.docuid ) 
			  WHERE D.fechadoc BETWEEN '".$fechaphp." 00:00:00' AND '".$fechaphp." 23:59:59'
			  AND D.fecasentado <> '0000-00-00'
			  ORDER BY numero ASC";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
 	 $numdesde = 0;  $numhasta = 0;  $total = 0;
	 while($row = @mysql_fetch_array($result))
	 { 
 	   if($total == 0)
 	   	 $numdesde = $row['prefijo'].$row['numero'];
 	   else	
         $numhasta = $row['prefijo'].$row['numero'];

 	   $detalles.= str_pad($row['prefijo'].$row['numero'],11);
 	   
 	   $pos = strpos($row['numero'], "-");
 	   if($pos == 0)
 	   	  $detalles .= '   ';
 	   else
 	   	  $detalles .= ' * '; 	
	   
	   $detalles.= substr($row['fechadoc'],0,10).'   '.$row['dnibeneficiario'].Chr(13).Chr(10);
	   $total++;
	 } 	 

     //// Encabezado Despachos Convenio
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= ' DESPACHO DE CONVENIOS CON ENTIDADES   '.Chr(13).Chr(10);          
     $cont.= ' Inicio : '.$numdesde.' - Fin : '.$numhasta.Chr(13).Chr(10);          
     $cont.= ' Total Despachos : '.number_format($total).' Formulas'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'DOCUMENTO      FECHA       PACIENTE    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);


     //// Resumen de los Reportes de Nocturnos
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   REDENCIONES DE PUNTOS FARMANORTE    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'DOCUMENTO       PUNTOS      CLIENTE    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Detallo los documentos
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , DV.valorfp5 , T.nombres , T.apellidos  
	          FROM documentos D INNER JOIN terceros T ON (D.terid1 = T.terid) 
	          INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
	          WHERE DV.diaoperativo ='".$diaoperativo."' AND D.fecasentado <> '0000-00-00' AND DV.valorfp5 > 0
	          ORDER BY D.numero ASC";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = @mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad($row['tipodoc'].$row['prefijo'].$row['numero'],14).'  ';
	   $detalles.= number_format($row['valorfp5']).'   '.substr($row['nombres'].' '.$row['apellidos'],0,13).Chr(13).Chr(10);
	 } 	 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     ////////////////////////////////////////////////////////////////////////
	 ////   Estadisticas de Ventas por Vendedor 	 
     ////////////////////////////////////////////////////////////////////////	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   ESTADISTICA DE VENTAS x VENDEDOR    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT terid , CONCAT( nombres,  ' ', apellidos ) nomven ,  ( SELECT SUM( total ) FROM documentos D3 INNER JOIN docuventa DDD ON ( D3.docuid = DDD.docuid ) 
			  WHERE D3.tipodoc =  'FVE' AND DDD.diaoperativo =  '".$diaoperativo."' AND D3.terid2 = D.terid2 ) total , ( SELECT SUM( total ) FROM documentos D2 
			  INNER JOIN docudevolucion DD ON ( D2.docuid = DD.docuid ) WHERE D2.tipodoc =  'DVE' AND DD.diaoperativo =  '".$diaoperativo."' AND D2.terid2 = D.terid2) devo , 
              ( SELECT SUM( DD3.valparcial ) FROM documentos D3 INNER JOIN docuventa DV3 ON ( D3.docuid = DV3.docuid )  INNER JOIN dedocumentos DD3 ON ( D3.docuid = DD3.docuid ) 
			  INNER JOIN productos P3 ON ( P3.productoid = DD3.productoid ) WHERE DV3.diaoperativo =  '".$diaoperativo."' AND (P3.codigo =  'R1000' OR P3.codigo =  'BOLSAX') AND D3.terid2 = T.terid ) recar
			  FROM documentos D INNER JOIN terceros T ON ( T.terid = D.terid2 ) LEFT JOIN docuventa DV ON (D.docuid = DV.docuid) LEFT JOIN docudevolucion DDV ON (D.docuid = DDV.docuid)
			  WHERE ( D.tipodoc =  'FVE' OR D.tipodoc =  'DVE') AND (DV.diaoperativo =  '".$diaoperativo."' OR DDV.diaoperativo =  '".$diaoperativo."') AND D.fecasentado <>  '0000-00-00'
			  AND D.fecanulado = '0000-00-00' GROUP BY 1 , 2";

	 $conex  = $clase->Conectar();
     $result =  mysql_query($vsql,$conex);
 	 $detalles = "";
 	 while($row = mysql_fetch_array($result))
	 { 
	   $total = $row['total'] - $row['devo'] - $row['recar'];
	   $detalles.= substr($row['nomven'],0,25).Chr(13).Chr(10);
 	   $detalles.= 'VENTAS               :     '.str_pad(number_format($row['total'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
 	   $detalles.= 'DEVOLUCIONES (-)     :     '.str_pad(number_format($row['devo'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
 	   $detalles.= 'RECARGAS|BOLSAS (-)  :     '.str_pad(number_format($row['recar'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
       $detalles.= 'TOTAL                :     '.str_pad(number_format($total,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
       $detalles.= '---------------------------------------'.Chr(13).Chr(10);	   
	 } 
     $cont.= $detalles.Chr(13).Chr(10); 

     //// Resumen de los Reportes de Nocturnos
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '  RELACION DE REPORTES NOCTURNOS       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'VENDEDOR              FECHA / HORA     '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Detallo las recogidas de Dinero
	 $vsql = "SELECT CONVERT( nomvende USING utf8 ) v1 , momento FROM regpervende WHERE diaoperativo ='".$diaoperativo."' ORDER BY momento ASC";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad(substr($row['v1'],0,15)," ",STR_PAD_LEFT).'   ';
	   $detalles.= substr($row['momento'],0,16).Chr(13).Chr(10);
	 } 	 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= "Cumplio : ____ SI    ____ NO   ".Chr(13).Chr(10);

     //// Fin del Cuadre
	 $cont.= "Observaciones : ".Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 $cont.= "NOMBRE/FIRMA ADMINISTRADOR SUCURSAL".Chr(13).Chr(10).Chr(13).Chr(10);	 	 	 	 	   
	 $cont.= "C.C : _____________________________".Chr(13).Chr(10).Chr(13).Chr(10);	 
	 */	 	 	 	   	 
     
	 $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  
	 
     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio el Cierre Definitivo con Exito',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 /// Genero el Archivo del Cierre
	 $archivo= "log/Cierre-".$cierreid.".txt"; // el nombre de tu archivo
	 $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
	 fwrite($fch, $cont); // Grabas
	 fclose($fch); // Cierras el archivo

	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
	 $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
	 fwrite($fch, $cont); // Grabas
	 fclose($fch); // Cierras el archivo	 

	 if($imprimir == "S")
	 {
		//// Imprimo el Cierre
		$tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
		if($tipo == "G")
		{
			/// 1. Le Aplico Permisos a la Carpeta TXT
			chmod($acceso."print/", 0777);
			/// 2. Genero la Impresion  
			$archivo= "print/tiradecierredef.txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			fwrite($fch, $cont); // Grabas
			fclose($fch); // Cierras el archivo

			/// 3. Le Aplico Permisos al archivo
			chmod("print/tiradecierredef.txt", 0777);					
		}
		else
		{
			$archivo= "print/tiradecierredef.txt"; // el nombre de tu archivo 
			$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			fwrite($fch, $cont); // Grabas
			fclose($fch); // Cierras el archivo
		}
	 }
	 
 	 $clase->closeConnection();
  } // Fin de la Funcion  
  
    
  ///////////////////////////////////////////////////////////////////////  
  /// Impresion de la Planilla de Cierre Parcial o Arqueo 
  ///////////////////////////////////////////////////////////////////////  
  function PlanillaCierreParcial($cierreid)
  {
     ini_set("memory_limit","200M");
     set_time_limit(0);

	 $clase = new Sistema();
 	 $diaoperativo = $clase->BDLockup($cierreid,'cierres','cierreid','diaoperativo');	
     $momcierre    = $clase->BDLockup($cierreid,'cierres','cierreid','momento');		 
	 $nomoperador  = $_SESSION['USERNAME'];
	 
	 $sucid  = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 $nomsuc = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','descripcion');	 	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];
	 $cont.=  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).'     '.$nomempresa.Chr(13).Chr(10);	
	 $cont.= '           '.$nitempresa.Chr(13).Chr(10);		 
 
     $cont.= ' **** CIERRE DE CAJA PARCIAL  ****  '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'COMPROBANTE DE CIERRE No. '.str_pad($cierreid,6,"0",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'MOMENTO DEL CIERRE : '.substr($momcierre,0,16).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= '      DIA OPERATIVO : '.$diaoperativo.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' USUARIO : '.substr($nomoperador,0,28).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	 $cont.= '     SUCURSAL : '.$nomsuc.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10).Chr(13).Chr(10);          

     //// Descripcion del Cuadre de Caja
	 ///// Efectivo
	 $vsqlventas = "SELECT SUM(DV.valorfp1) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	 $ventas     = $clase->SeleccionarUno($vsqlventas);	 
	 ///// Tarjetas Debito y Credito
	 $vsqltar    = "SELECT SUM(DV.valorfp2 + DV.valorfp3) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	 $tarjetas   = $clase->SeleccionarUno($vsqltar);
	 ///// Bonos de Descuento
	 $vsqlbon    = "SELECT SUM(DV.valorfp4) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	 $bonosdcto  = $clase->SeleccionarUno($vsqlbon);
	 $vsqlpuntos = "SELECT SUM(DV.valorfp5) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
	 $puntos     = $clase->SeleccionarUno($vsqlpuntos);	 
	 
	 $vsqlrapp   = "SELECT SUM(DV.valorfp6) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.tipodoc = 'FVE' AND D.nrodocref = 'VENTA-RAPPI' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
     $vtasrappi  = 0+$clase->SeleccionarUno($vsqlrapp);     

	 $vsqlrapp   = "SELECT SUM(DV.valorfp7) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	             	WHERE D.tipodoc = 'FVE' AND D.nrodocref <> 'VENTA-RAPPI' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."'";
  	 $vtasepayco  = 0+$clase->SeleccionarUno($vsqlrapp);

	 ///// Devoluciones
	 $vsqldevoluc  = "SELECT SUM(DV.valor) FROM docudevolucion DV INNER JOIN documentos D ON (D.docuid = DV.docuid) WHERE D.tipodoc = 'DVE' AND D.formapago = 'CO' AND DV.diaoperativo='".$diaoperativo."'";
	 $devoluciones = $clase->SeleccionarUno($vsqldevoluc);
	 
	 ///// Recogidas
	 $vsqlrecog  = "SELECT SUM(valrecogida) FROM recogidas WHERE diaoperativo = '".$diaoperativo."'";
	 $recogidas  = $clase->SeleccionarUno($vsqlrecog);
	 ///// Arqueos
	 $vsqlcierr  = "SELECT SUM(valentrega) FROM cierres WHERE tipocierre = 'PAR' AND diaoperativo='".$diaoperativo."'";
	 $arqueos    = $clase->SeleccionarUno($vsqlcierr);
	 ///// Gastos
	 $vsqlgastos = "SELECT SUM(DC.valor) FROM detallecierre DC INNER JOIN cierres C ON (C.cierreid = DC.cierreid) WHERE C.cierreid=".$cierreid;
	 $gastos     = $clase->SeleccionarUno($vsqlgastos);
	 ///// Base Caja
	 $vsqlcierr  = "SELECT valcaja FROM cierres WHERE tipocierre = 'DEF' AND (diaoperativo='".$diaoperativo."')";
	 $basecaja   = $clase->SeleccionarUno($vsqlcierr);
	 ///// Valor entregado en el Cierre
	 $vsqlentreg = "SELECT valentrega FROM cierres WHERE tipocierre = 'DEF' AND (diaoperativo='".$diaoperativo."')";
	 $entregado  = $clase->SeleccionarUno($vsqlentreg);
	 ///// Domicilios
	 $vsqldomi   = "SELECT 0 FROM cierres WHERE 1";
	 $domicilios = $clase->SeleccionarUno($vsqldomi);
	 ///// Gastos
	 $vsqlbaloto = "SELECT 0 FROM cierres WHERE 1";
	 $baloto     = $clase->SeleccionarUno($vsqlbaloto);

	 ///// Billeteras Entradas de Dinero
	 $vsqlentradasbilleteras = "SELECT SUM(amount) FROM transaccionesbilleteras WHERE tipomov = 'E' AND diaoperativo = '".$diaoperativo."'";
	 $entradasbilleteras = 0+$clase->SeleccionarUno($vsqlentradasbilleteras);
	 ///// Billeteras Salidas de Dinero
	 $vsqlsalidasbilleteras = "SELECT SUM(amount) FROM transaccionesbilleteras WHERE tipomov = 'S' AND diaoperativo = '".$diaoperativo."'";
	 $salidasbilleteras = 0+$clase->SeleccionarUno($vsqlsalidasbilleteras);		

	 $ingresos   = $ventas + $entradasbilleteras + $baloto - $devoluciones;
	 $egresos    = $gastos + $salidasbilleteras + $recogidas + $arqueos + $entregado;	  
	 $saldo      = $ingresos - $egresos;
	 	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '    DETALLES DEL ARQUEO DE CAJA        '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONCEPTO           INGRESOS    EGRESOS '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'EFECTIVO        '.str_pad(number_format($ventas,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'DEVOLUCIONES    '.str_pad(number_format((-1)*$devoluciones,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'TARJETA | TRANSF'.str_pad(number_format($tarjetas,0),11," ",STR_PAD_LEFT).str_pad(number_format($tarjetas,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'CREDITOS        '.str_pad(number_format($bonosdcto,0),11," ",STR_PAD_LEFT).str_pad(number_format($bonosdcto,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	      
     $cont.= 'PUNTOS FARMANOR '.str_pad(number_format($puntos,0),11," ",STR_PAD_LEFT).str_pad(number_format($puntos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	      
	 $cont.= 'VENTAS RAPPI CR '.str_pad(number_format($vtasrappi,0),11," ",STR_PAD_LEFT).str_pad(number_format($vtasrappi,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	           
	 $cont.= 'TIENDAV EPAYCO  '.str_pad(number_format($vtasepayco,0),11," ",STR_PAD_LEFT).str_pad(number_format($vtasepayco,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	           
	 $cont.= 'BILLETERAS (E/S)'.str_pad(number_format($entradasbilleteras,0),11," ",STR_PAD_LEFT).str_pad(number_format($salidasbilleteras,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
	 $cont.= 'BONOS DCTO      '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	           
     $cont.= 'RECOGIDAS       '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($recogidas,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'CIERRES PARC.   '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($arqueos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	
     $cont.= 'GASTOS          '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($gastos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);		  	 
     $cont.= 'EFECT. EN CAJA  '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($entregado,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'DOMICILIOS      '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'BALOTO          '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 
     $cont.= ' SUB TOTALES    '.str_pad(number_format($ingresos,0),11," ",STR_PAD_LEFT).str_pad(number_format($egresos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 

	 //// Calculo del Dinero Sobrante - Faltante
	 if($saldo>0)   {	   $dinfaltante = $saldo;	   $dinsobrante = 0;	            }
	 if($saldo<0)   {	   $dinfaltante = 0;   	       $dinsobrante = ((-1)*$saldo);	}
	 if($saldo == 0){	   $dinfaltante = 0;     	   $dinsobrante = 0; 	            }
	 
	 /// Muestro el Sobrante / Faltante  
	 $cont.= ' DINERO FALTANTE            '.str_pad(number_format($dinfaltante,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 
	 $cont.= ' DINERO SOBRANTE            '.str_pad(number_format($dinsobrante,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10);          	 	 
	 $cont.= ' MONTO TOTAL A CONSIGNAR    '.str_pad(number_format(($ventas+$dinsobrante-$devoluciones-$gastos),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10).Chr(13).Chr(10);          	 	 
	 
	 /// Calculo el Total a Consignar y lo Actualizo en el Registro del Cierre
	 $totconsig = 0+($ventas+$dinsobrante-$devoluciones-$gastos);
	 $totvendia = 0+($ventas+$tarjetas+$bonosdcto+$puntos-$devoluciones);
	 $vsql = "UPDATE cierres SET valconsigna = ".$totconsig." , totalventa = ".$totvendia." WHERE cierreid = ".$cierreid;
     $clase->EjecutarSQL($vsql); 

	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10);          	 	 
	 $cont.= ' TOTAL VENTA DEL DIA        '.str_pad(number_format(($ventas+$tarjetas+$bonosdcto+$puntos-$devoluciones),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10).Chr(13).Chr(10);                 	 	 
	 
	 /*
     /// Resumen de Impuestos
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '        RESUMEN DE IMPUESTOS           '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= '  %IVA   VLR BASE   VLR IVA   VLR VENTA'.Chr(13).Chr(10);          
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT DD.porciva , SUM(DD.valbase) base , SUM(DD.valiva) iva , SUM(DD.valtotal) total 
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
	          WHERE D.tipodoc = 'FVE' AND diaoperativo ='".$diaoperativo."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' GROUP BY 1";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $totbase = 0;     $totiva = 0;     $totventa = 0;	 
	 $detalles = "";
	 while($row = @mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad($row['porciva'],5," ",STR_PAD_LEFT).'  ';
	   $detalles.= str_pad(number_format($row['base'],0),10," ",STR_PAD_LEFT).'  ';
	   $detalles.= str_pad(number_format($row['iva']),8," ",STR_PAD_LEFT).' ';
       $detalles.= str_pad(number_format($row['total']),11," ",STR_PAD_LEFT).Chr(13).Chr(10); 	 
 	   
	   $totbase += $row['base'];     $totiva+= $row['iva'];     $totventa += $row['total'];	   
	   $totales  = str_pad(number_format($totbase,0),17," ",STR_PAD_LEFT).'  ';
	   $totales .= str_pad(number_format($totiva,0),8," ",STR_PAD_LEFT).'  ';	   
	   $totales .= str_pad(number_format($totventa,0),10," ",STR_PAD_LEFT);	   	   
	 } 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= $totales.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     	 
	 //////////////////////////////////////////////////////////
	 ///// Discriminacion de Medios de Pago	 
	 //////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   DISCRIMINACION DE MEDIOS DE PAGO    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' MEDIO PAGO               TOTAL   CANT '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          

	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT diaoperativo , 
	          (SELECT COUNT(*) FROM docuventa WHERE valorfp1 > 0 AND diaoperativo = DV.diaoperativo) CanEfec , 
			  (SELECT COUNT(*) FROM docuventa WHERE valorfp2 > 0 AND diaoperativo = DV.diaoperativo) CanTarj , 
			  (SELECT COUNT(*) FROM docuventa WHERE valorfp3 > 0 AND diaoperativo = DV.diaoperativo) CanOtro ,
              (SELECT COUNT(*) FROM docuventa WHERE valorfp4 > 0 AND diaoperativo = DV.diaoperativo) CanCred ,			  
			   SUM(valorfp1) valorfp1 , SUM(valorfp2) valorfp2 , SUM(valorfp3) valorfp3 , SUM(valorfp4) valorfp4 
			   FROM docuventa DV WHERE diaoperativo = '".$diaoperativo."' 
			   GROUP BY 1 , 2 , 3 , 4 , 5";
	 
	 //$conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $det = "";
	 if($row = @mysql_fetch_array($result))
	 { 
 	   $det = 'EFECTIVO ............';
	   $det.= str_pad(number_format($row['valorfp1'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanEfec'],0),7," ",STR_PAD_LEFT);
 	   $det.= Chr(13).Chr(10);
	   $det.= 'TARJ DEB/CRED .......';
	   $det.= str_pad(number_format(($row['valorfp2']+$row['valorfp3']),0),10," ",STR_PAD_LEFT).str_pad(number_format(($row['CanTarj']+$row['CanOtro']),0),7," ",STR_PAD_LEFT);
 	   $det.= Chr(13).Chr(10);
	   $det.= 'BONOS DESCTO ........';
	   $det.= str_pad(number_format($row['valorfp4'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanCred'],0),7," ",STR_PAD_LEFT);
	 } 
	 $cont.= $det.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 
	 ///////////////////////////////////////////////////////////////////
	 ///// Estadisticas del Proceso de Venta
	 ///////////////////////////////////////////////////////////////////
	 $vsql    = "SELECT COUNT(*) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) WHERE D.tipodoc = 'FVE' AND DV.diaoperativo='".$diaoperativo."'";
	 $cliaten = $clase->SeleccionarUno($vsql);
	 $vsql    = "SELECT CONCAT(prefijo,' ',numero) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	             WHERE D.tipodoc = 'FVE' AND DV.diaoperativo='".$diaoperativo."' ORDER BY NUMERO ASC limit 0,1";
	 $finicial = $clase->SeleccionarUno($vsql);
	 $vsql    = "SELECT CONCAT(prefijo,' ',numero) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	             WHERE D.tipodoc = 'FVE' AND DV.diaoperativo='".$diaoperativo."' ORDER BY NUMERO DESC limit 0,1";
	 $ffinal  = $clase->SeleccionarUno($vsql);
	 $vsql = "SELECT COUNT(*) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN terceros T ON (T.terid = D.terid1) WHERE D.tipodoc = 'FVE' AND T.codigo <> '99' AND DV.diaoperativo = '".$diaoperativo."'";
	 $cliregis = $clase->SeleccionarUno($vsql);
	 $clinoreg = $cliaten-$cliregis;
	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   ESTADISTICAS DEL PROCESO DE VENTA   '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'FACTURA INICIAL : .........'.str_pad($finicial,12," ",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= 'FACTURA FINAL : ...........'.str_pad($ffinal,12," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'CLIENTES ATENDIDOS : ......'.str_pad(number_format($cliaten,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= 'CLIENTES REGISTRADOS : ....'.str_pad(number_format($cliregis,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	           
	 $cont.= 'CLIENTES NO REGISTRADOS : .'.str_pad(number_format($clinoreg,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);          	 	 	 

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Devoluciones
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '      DEVOLUCIONES DE CLIENTES         '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  USUARIO    HORA     VALOR '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , creador , fechadoc , total 
	          FROM documentos d INNER JOIN docudevolucion DV ON (D.docuid = DV.docuid)
	          WHERE D.tipodoc = 'DVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
		  
	 //$conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['creador'],0,11),11," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(substr($row['fechadoc'],11,5),5," ",STR_PAD_RIGHT).str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DEVOLUCIONES : '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Domicilios 	 
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '      RELACION DE DOMICILIOS           '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'MENSAJERO         FACTURA        VALOR'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(nombres,' ',apellidos) nommen , CONCAT(prefijo,numero) numfac ,  total 
	          FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid3)
	          INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          WHERE (T.codigo <> '00' AND T.codigo <> '99' AND T.codigo <> '98') AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
			  AND diaoperativo ='".$diaoperativo."' GROUP BY 1,2";
	 //$conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $candomi = 0;    $vendomi = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= substr($row['nommen'],0,16).'  '.substr($row['numfac'],0,10).str_pad(number_format($row['total'],0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $vendomi += $row['total'];  	   $candomi++;
	 } 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DOMICILIOS : '.str_pad(number_format($candomi,0),5," ",STR_PAD_LEFT).str_pad(number_format($vendomi,0),15," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Creditos por Empleado
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '     DETALLE DE VENTAS A CREDITO       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  USUARIO        VALOR FACT.'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , CONCAT(nombres,' ',apellidos) usuario , total 
	          FROM documentos d INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			  INNER JOIN terceros T ON (T.terid = D.terid1)
			  WHERE D.formapago = 'CR' AND D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
		  
	 //$conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['usuario'],0,16),17," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'TOTAL CREDITOS :    '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 	 
	 //// Resumen de los Cierres Parciales
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '  RELACION DE RECOGIDAS DE DINERO      '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'VALOR REC    USUARIO    FECHA / HORA '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Detallo las recogidas de Dinero
	 $vsql = "SELECT * FROM recogidas WHERE diaoperativo ='".$diaoperativo."' ORDER BY momento";
	 //$conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = @mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad(number_format($row['valrecogida'],0),9," ",STR_PAD_LEFT).'    ';
	   $detalles.= str_pad(substr($row['creador'],0,8),9," ",STR_PAD_RIGHT);
	   $detalles.= substr($row['momento'],0,16).Chr(13).Chr(10);
	 } 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);

     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Transferencias de Mercancia
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '    TRANSFERENCIAS A OTRAS BODEGAS     '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  BOD. DESTINO         VALOR'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.tipodoc,D.prefijo,D.numero) consec , B.codbodega , total 
	          FROM documentos d INNER JOIN docutranfe DV ON (D.docuid = DV.docuid)
			  INNER JOIN bodegas B ON (DV.bodegaiddes = B.bodegaid)
	          WHERE D.tipodoc = 'TRB' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."'";
	 //$conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['nombodega'],0,16),16," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CANT DEVOLUCIONES : '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),13," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);


     //// Resumen de los Reportes de Nocturnos
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '  RELACION DE REPORTES NOCTURNOS       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'VENDEDOR              FECHA / HORA     '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Detallo las recogidas de Dinero
	 $vsql = "SELECT * FROM regpervende WHERE diaoperativo ='".$diaoperativo."' ORDER BY momento ASC";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = ""; 	 
	 while($row = @mysql_fetch_array($result))
	 { 
 	   $detalles.= str_pad(substr($row['nomvende'],0,17)," ",STR_PAD_LEFT).'    ';
	   $detalles.= substr($row['momento'],0,16).Chr(13).Chr(10);
	 } 	 
     $cont.= $detalles.Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= "Cumplio : ____ SI    ____ NO   ".Chr(13).Chr(10);
*/
     //// Fin del Cuadre
	 $cont.= "Favor no Enviar con la Papeleria".Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 $cont.= '.';     
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  
/*
	 $cont.= "NOMBRE/FIRMA ADMINISTRADOR SUCURSAL".Chr(13).Chr(10).Chr(13).Chr(10);	 	 	 	 	   
	 $cont.= "C.C : _____________________________".Chr(13).Chr(10).Chr(13).Chr(10);	 	 	 	 	   	 
     
	 $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  
*/
     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio el Cierre Definitivo con Exito',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 //// Imprimo el Cierre
	 $tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
	 if($tipo == "G")
	 {
		 /// 1. Le Aplico Permisos a la Carpeta PDF
		 chmod($acceso."print/", 0777);
		 /// 2. Genero la Impresion  
		 $archivo= "print/tiradecierredef.txt"; // el nombre de tu archivo
		 $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
		 fwrite($fch, $cont); // Grabas
		 fclose($fch); // Cierras el archivo

		 /// 3. Le Aplico Permisos al archivo
		 chmod("print/tiradecierredef.txt", 0777);					
	 }
	 else
	 {
		 $archivo= "print/tiradecierredef.txt"; // el nombre de tu archivo
		 $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
		 fwrite($fch, $cont); // Grabas
		 fclose($fch); // Cierras el archivo
	 }
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "log/Cierre-".$cierreid.".txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("my")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 
 	 $clase->closeConnection();	 
  } // Fin de la Funcion  
  

  ///////////////////////////////////////////////////////////////////////  
  /// Impresion de la Planilla de Cierre Parcial o Arqueo 
  ///////////////////////////////////////////////////////////////////////  
  function PlanillaCierreDeposito($diaoperativo,$cierreid)
  {
     ini_set("memory_limit","200M");
     set_time_limit(0);
    
	 $clase = new Sistema();
     $momcierre    = date("d/m/Y H:i:s");
	 $nomoperador  = $_SESSION['USERNAME'];
	 
	 $sucid  = $clase->BDLockup($cierreid,'cierres','cierreid','sucid');	 
	 if($sucid == "")      $sucid  = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 
	 $nomsuc = $clase->BDLockup($sucid,'sucursales','sucursalid','descripcion');	 	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];
	 $cont.=  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).'     '.$nomempresa.Chr(13).Chr(10);	
	 $cont.= '           '.$nitempresa.Chr(13).Chr(10);		 
 
     $cont.= '    **** CIERRE DE DEPOSITO  ****  '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= '    IMPRESION : '.substr($momcierre,0,16).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= '     DIA OPERATIVO : '.$diaoperativo.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' USUARIO : '.substr($nomoperador,0,28).Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	 $cont.= '   SUCURSAL : '.$nomsuc.Chr(13).Chr(10);		          

     //// Descripcion del Cuadre de Caja
	 ///// Efectivo
	 $vsqlventas = "SELECT SUM(DV.valorfp1) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."' AND D.sucursalid = ".$sucid;
	 $ventas     = $clase->SeleccionarUno($vsqlventas);	 
	 ///// Tarjetas Debito y Credito
	 $vsqltar    = "SELECT SUM(DV.valorfp2 + DV.valorfp3) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."' AND D.sucursalid = ".$sucid;
	 $tarjetas   = $clase->SeleccionarUno($vsqltar);
	 ///// Bonos de Descuento
	 $vsqlbon    = "SELECT SUM(DV.valorfp4) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."' AND D.sucursalid = ".$sucid;
	 $bonosdcto  = $clase->SeleccionarUno($vsqlbon);
	 $vsqlpuntos = "SELECT SUM(DV.valorfp5) FROM docuventa DV INNER JOIN documentos D ON (D.docuid = DV.docuid) 
	                WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo='".$diaoperativo."' AND D.sucursalid = ".$sucid;
	 $puntos     = $clase->SeleccionarUno($vsqlpuntos);	 
	 
	 ///// Devoluciones
	 $vsqldevoluc  = "SELECT SUM(DV.valor) FROM docudevolucion DV INNER JOIN documentos D ON (D.docuid = DV.docuid) WHERE D.tipodoc = 'DVE' AND D.formapago = 'CO' AND DV.diaoperativo='".$diaoperativo."' AND D.sucursalid = ".$sucid;
	 $devoluciones = $clase->SeleccionarUno($vsqldevoluc);
	 
	 ///// Recogidas
	 $vsqlrecog  = "SELECT SUM(valrecogida) FROM recogidas WHERE diaoperativo = '".$diaoperativo."' AND sucursalid = ".$sucid;
	 $recogidas  = $clase->SeleccionarUno($vsqlrecog);
	 ///// Arqueos
	 $vsqlcierr  = "SELECT SUM(valentrega) FROM cierres WHERE tipocierre = 'PAR' AND diaoperativo='".$diaoperativo."' AND sucid = ".$sucid;
	 $arqueos    = $clase->SeleccionarUno($vsqlcierr);
	 ///// Gastos
	 $gastos     = 0;
	 ///// Base Caja
	 $vsqlcierr  = "SELECT valcaja FROM cierres WHERE tipocierre = 'DEF' AND (diaoperativo='".$diaoperativo."') AND sucid = ".$sucid;
	 $basecaja   = $clase->SeleccionarUno($vsqlcierr);
	 ///// Valor entregado en el Cierre
	 $vsqlentreg = "SELECT valentrega FROM cierres WHERE tipocierre = 'DEF' AND (diaoperativo='".$diaoperativo."') AND sucid = ".$sucid;
	 $entregado  = $clase->SeleccionarUno($vsqlentreg);
	 ///// Domicilios
	 $vsqldomi   = "SELECT 0 FROM cierres WHERE 1";
	 $domicilios = $clase->SeleccionarUno($vsqldomi);
	 ///// Gastos
	 $vsqlbaloto = "SELECT 0 FROM cierres WHERE 1";
	 $baloto     = $clase->SeleccionarUno($vsqlbaloto);

	 $ingresos   = $ventas + $baloto - $devoluciones;
	 $egresos    = $gastos + $recogidas + $arqueos + $entregado;	  
	 $saldo      = $ingresos - $egresos;
	 	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '    DETALLES DEL ARQUEO DE CAJA        '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONCEPTO           INGRESOS    EGRESOS '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'EFECTIVO        '.str_pad(number_format($ventas,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'DEVOLUCIONES    '.str_pad(number_format((-1)*$devoluciones,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'TARJETAS DB/CR  '.str_pad(number_format($tarjetas,0),11," ",STR_PAD_LEFT).str_pad(number_format($tarjetas,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'CREDITOS        '.str_pad(number_format($bonosdcto,0),11," ",STR_PAD_LEFT).str_pad(number_format($bonosdcto,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	      
     $cont.= 'PUNTOS FARMANOR '.str_pad(number_format($puntos,0),11," ",STR_PAD_LEFT).str_pad(number_format($puntos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	      
     $cont.= 'BONOS DCTO      '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	           
     $cont.= 'RECOGIDAS       '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($recogidas,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'CIERRES PARC.   '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($arqueos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	
     $cont.= 'GASTOS          '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($gastos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);		  	 
     $cont.= 'EFECT. EN CAJA  '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format($entregado,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'DOMICILIOS      '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= 'BALOTO          '.str_pad(number_format(0,0),11," ",STR_PAD_LEFT).str_pad(number_format(0,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 
     $cont.= ' SUB TOTALES    '.str_pad(number_format($ingresos,0),11," ",STR_PAD_LEFT).str_pad(number_format($egresos,0),11," ",STR_PAD_LEFT).Chr(13).Chr(10);	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 

	 //// Calculo del Dinero Sobrante - Faltante
	 if($saldo>0)   {	   $dinfaltante = $saldo;	   $dinsobrante = 0;	            }
	 if($saldo<0)   {	   $dinfaltante = 0;   	       $dinsobrante = ((-1)*$saldo);	}
	 if($saldo == 0){	   $dinfaltante = 0;     	   $dinsobrante = 0; 	            }
	 
	 /// Muestro el Sobrante / Faltante  
	 $cont.= ' DINERO FALTANTE            '.str_pad(number_format($dinfaltante,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 
	 $cont.= ' DINERO SOBRANTE            '.str_pad(number_format($dinsobrante,0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10);          	 	 
	 $cont.= ' MONTO TOTAL A CONSIGNAR    '.str_pad(number_format(($ventas+$dinsobrante-$devoluciones-$gastos),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10).Chr(13).Chr(10);          	 	 
	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10);          	 	 
	 $cont.= ' TOTAL VENTA DEL DIA        '.str_pad(number_format(($ventas+$tarjetas+$bonosdcto+$puntos-$devoluciones),0),10," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	 	 
	 $cont.= '=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_=_='.Chr(13).Chr(10).Chr(13).Chr(10);                 	 	 
	 	 
	 /// Calculo el Total a Consignar y lo Actualizo en el Registro del Cierre
	 $totconsig = 0+($ventas+$dinsobrante-$devoluciones-$gastos);
	 $totalarqueox = 0+($ventas+$tarjetas+$bonosdcto+$puntos-$devoluciones);
	 $vsql = "UPDATE cierres SET totconsignar = '".$totconsig."' , totalarqueo = '".$totalarqueox."' WHERE cierreid = ".$cierreid;
	 $clase->EjecutarSQL($vsql); 

		/// Resumen de Impuestos
		$cont.= '---------------------------------------'.Chr(13).Chr(10);          
		$cont.= '        RESUMEN DE IMPUESTOS           '.Chr(13).Chr(10);          
		$cont.= '======================================='.Chr(13).Chr(10);          
		$cont.= ' T  %IVA  VLR BASE   VLR IVA  VLR VENTA'.Chr(13).Chr(10);          
		$cont.= '---------------------------------------'.Chr(13).Chr(10);          
		
		/// Hago la Consulta de los datos de la Factura 		
		$vsql ="SELECT DD.porciva , SUM(DD.valbase) base , SUM(DD.valiva) iva , SUM(DD.valtotal) total 
				FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
				INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
				WHERE D.tipodoc = 'FVE' AND diaoperativo = '".$diaoperativo."' AND D.sucursalid = ".$sucid." AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
				GROUP BY 1
				UNION 
				SELECT DD.porciva , ((-1)*SUM(DD.valbase)) base , ((-1)*SUM(DD.valiva)) iva , ((-1)*SUM(DD.valtotal)) total 
				FROM documentos D 
				INNER JOIN docudevolucion DV ON (D.docuid = DV.docuid) 
				INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
				WHERE D.tipodoc = 'DVE' AND diaoperativo = '".$diaoperativo."' AND D.sucursalid = ".$sucid." AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
				GROUP BY 1 ORDER BY 1";

		$conex  = $clase->Conectar();
		$result = @mysql_query($vsql,$conex);
		$totbase = 0;     $totiva = 0;     $totventa = 0;	 
		$base00 = 0;      $iva00 = 0;      $total00 = 0;  
		$base05 = 0;      $iva05 = 0;      $total05 = 0;
		$base19 = 0;      $iva19 = 0;      $total19 = 0;

		$detalles = "";
		while($row = @mysql_fetch_array($result))
		{ 
		if($row['porciva'] == 0)
		{
			$base00  += 0+$row['base'];
			$iva00   += 0+$row['iva'];
			$total00 += 0+$row['total'];
		}
		
		if($row['porciva'] == 5)
		{
			$base05  += 0+$row['base'];
			$iva05   += 0+$row['iva'];
			$total05 += 0+$row['total'];
		}

		if($row['porciva'] == 19)
		{
			$base19  += 0+$row['base'];
			$iva19   += 0+$row['iva'];
			$total19 += 0+$row['total'];
		}

		$totbase += $row['base'];     $totiva+= $row['iva'];     $totventa += $row['total'];	   
		
		$totales  = str_pad(number_format($totbase,0),17," ",STR_PAD_LEFT).'  ';
		$totales .= str_pad(number_format($totiva,0),8," ",STR_PAD_LEFT).'  ';	   
		$totales .= str_pad(number_format($totventa,0),10," ",STR_PAD_LEFT);	   	   
		}

		$detalles.= "  ".str_pad(0,3," ",STR_PAD_LEFT).'  ';
		$detalles.= str_pad(number_format($base00,0),10," ",STR_PAD_LEFT).'  ';
		$detalles.= str_pad(number_format($iva00),8," ",STR_PAD_LEFT).' ';
		$detalles.= str_pad(number_format($total00),11," ",STR_PAD_LEFT).Chr(13).Chr(10); 	 

		$detalles.= "  ".str_pad(5,3," ",STR_PAD_LEFT).'  ';
		$detalles.= str_pad(number_format($base05,0),10," ",STR_PAD_LEFT).'  ';
		$detalles.= str_pad(number_format($iva05),8," ",STR_PAD_LEFT).' ';
		$detalles.= str_pad(number_format($total05),11," ",STR_PAD_LEFT).Chr(13).Chr(10); 	 

		$detalles.= "  ".str_pad(19,3," ",STR_PAD_LEFT).'  ';
		$detalles.= str_pad(number_format($base19,0),10," ",STR_PAD_LEFT).'  ';
		$detalles.= str_pad(number_format($iva19),8," ",STR_PAD_LEFT).' ';
		$detalles.= str_pad(number_format($total19),11," ",STR_PAD_LEFT).Chr(13).Chr(10); 	 
		
		$cont.= $detalles;
		$cont.= '---------------------------------------'.Chr(13).Chr(10);   
		$cont.= $totales.Chr(13).Chr(10).Chr(13).Chr(10);       

		//// Guardo los Valores en el Cierre 
		$vsqlx = "UPDATE cierres SET ventaexcluida = '".$total00."' , valbase19 = '".$base19."' , valiva19 = '".$iva19."' , valbase05 = '".$base05."' , valiva05 = '".$iva05."' WHERE cierreid = ".$cierreid;
		$clase->EjecutarSQL($vsqlx);


	 //////////////////////////////////////////////////////////
	 ///// Discriminacion de Medios de Pago	 
	 //////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   DISCRIMINACION DE MEDIOS DE PAGO    '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= ' MEDIO PAGO               TOTAL   CANT '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          

	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT diaoperativo , 
	          (SELECT COUNT(*) FROM docuventa WHERE valorfp1 > 0 AND diaoperativo = DV.diaoperativo) CanEfec , 
			  (SELECT COUNT(*) FROM docuventa WHERE valorfp2 > 0 AND diaoperativo = DV.diaoperativo) CanTarj , 
			  (SELECT COUNT(*) FROM docuventa WHERE valorfp3 > 0 AND diaoperativo = DV.diaoperativo) CanOtro ,
              (SELECT COUNT(*) FROM docuventa WHERE valorfp4 > 0 AND diaoperativo = DV.diaoperativo) CanCred ,			  
			   SUM(valorfp1) valorfp1 , SUM(valorfp2) valorfp2 , SUM(valorfp3) valorfp3 , SUM(valorfp4) valorfp4 
			   FROM docuventa DV INNER JOIN documentos D ON (DV.docuid = D.docuid) 
			   WHERE D.sucursalid = ".$sucid." AND DV.diaoperativo = '".$diaoperativo."' 
			   GROUP BY 1 , 2 , 3 , 4 , 5";
	 
	 //$conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $det = "";
	 if($row = @mysql_fetch_array($result))
	 { 
 	   $det = 'EFECTIVO ............';
	   $det.= str_pad(number_format($row['valorfp1'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanEfec'],0),7," ",STR_PAD_LEFT);
 	   $det.= Chr(13).Chr(10);
	   $det.= 'TARJ DEB/CRED .......';
	   $det.= str_pad(number_format(($row['valorfp2']+$row['valorfp3']),0),10," ",STR_PAD_LEFT).str_pad(number_format(($row['CanTarj']+$row['CanOtro']),0),7," ",STR_PAD_LEFT);
 	   $det.= Chr(13).Chr(10);
	   $det.= 'BONOS DESCTO ........';
	   $det.= str_pad(number_format($row['valorfp4'],0),10," ",STR_PAD_LEFT).str_pad(number_format($row['CanCred'],0),7," ",STR_PAD_LEFT);
	 } 
	 $cont.= $det.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 
	 ///////////////////////////////////////////////////////////////////
	 ///// Estadisticas del Proceso de Venta
	 ///////////////////////////////////////////////////////////////////
	 $vsql    = "SELECT COUNT(*) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) WHERE D.tipodoc = 'FVE' AND D.sucursalid = ".$sucid." AND DV.diaoperativo='".$diaoperativo."'";
	 $cliaten = $clase->SeleccionarUno($vsql);
	 $vsql    = "SELECT CONCAT(prefijo,' ',numero) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
				 WHERE D.tipodoc = 'FVE' AND DV.diaoperativo='".$diaoperativo."' AND D.fecasentado <> '0000-00-00' AND D.sucursalid = ".$sucid." ORDER BY D.numero ASC limit 0,1";
	 $finicial = $clase->SeleccionarUno($vsql);
	 $vsql    = "SELECT CONCAT(prefijo,' ',numero) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	             WHERE D.tipodoc = 'FVE' AND DV.diaoperativo='".$diaoperativo."' AND D.fecasentado <> '0000-00-00' AND D.sucursalid = ".$sucid." ORDER BY D.numero DESC limit 0,1";
	 $ffinal  = $clase->SeleccionarUno($vsql);
	 $vsql = "SELECT COUNT(*) FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN terceros T ON (T.terid = D.terid1) WHERE D.tipodoc = 'FVE' AND T.codigo <> '99' AND D.sucursalid = ".$sucid."  AND DV.diaoperativo = '".$diaoperativo."' AND D.sucursalid = ".$sucid;
	 $cliregis = $clase->SeleccionarUno($vsql);
	 $clinoreg = $cliaten-$cliregis;
	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '   ESTADISTICAS DEL PROCESO DE VENTA   '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'FACTURA INICIAL : .........'.str_pad($finicial,12," ",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= 'FACTURA FINAL : ...........'.str_pad($ffinal,12," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= 'CLIENTES ATENDIDOS : ......'.str_pad(number_format($cliaten,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10);          
     $cont.= 'CLIENTES REGISTRADOS : ....'.str_pad(number_format($cliregis,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10);          	 	           
	 $cont.= 'CLIENTES NO REGISTRADOS : .'.str_pad(number_format($clinoreg,0),12," ",STR_PAD_LEFT).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);          	 	 	 

	  
     /////////////////////////////////////////////////////////////////
	 ///////   Relacion de Creditos por Empleado
	 /////////////////////////////////////////////////////////////////
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= '     DETALLE DE VENTAS A CREDITO       '.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
     $cont.= 'CONSECUTIVO  USUARIO        VALOR FACT.'.Chr(13).Chr(10);          
     $cont.= '======================================='.Chr(13).Chr(10);          
	  
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT CONCAT(D.prefijo,D.numero) consec , CONCAT(nombres,' ',apellidos) usuario , total 
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			  INNER JOIN terceros T ON (T.terid = D.terid1)
			  WHERE D.formapago = 'CR' AND D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."' AND D.sucursalid = ".$sucid;

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 $detalles = "";     $candevo = 0;    $totdevo = 0;
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $detalles.= str_pad(substr($row['consec'],0,11),13," ",STR_PAD_RIGHT).str_pad(substr($row['usuario'],0,16),17," ",STR_PAD_RIGHT);
	   $detalles.= str_pad(number_format($row['total'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10);
	   $totdevo += $row['total'];  	   $candevo++;
	 } 
	 
     $cont.= $detalles;
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'TOTAL CREDITOS :    '.str_pad(number_format($candevo,0),5," ",STR_PAD_LEFT).str_pad(number_format($totdevo,0),14," ",STR_PAD_LEFT);
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 	 

     //// Fin del Cuadre
	 $cont.= "Observaciones".Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 $cont.= "NOMBRE/FIRMA JEFE DE BODEGA".Chr(13).Chr(10).Chr(13).Chr(10);	 	 	 	 	   
	 $cont.= "C.C : _____________________________".Chr(13).Chr(10).Chr(13).Chr(10);	 	 	 	 	   	 
     
	 $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  

     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio el Cierre Definitivo con Exito',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 //// Genero la Impresion en la Carpeta Correpondiente
	 $codImpre = $clase->BDLockup($_SESSION['USERNAME'],"usuarios","username","codimpresora");
     if(strlen($codImpre)>0) 	
     {	
		 $rutaImpresion = $clase->BDLockup($codImpre,"impresoras","codigo","ruta");
		 $archivo= "../Dropbox/00/".$rutaImpresion."/CierreDef-".rand(11111,99999).".txt"; // el nombre de tu archivo
 	 }
	 else 
		$archivo= "../Dropbox/00/print/CierreDef-".rand(11111,99999).".txt"; // el nombre de tu archivo
	 
	 $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
	 fwrite($fch, $cont); // Grabas
	 fclose($fch); // Cierras el archivo

	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "log/Cierre-".$cierreid.".txt"; // el nombre de tu archivo
	 $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
	 fwrite($fch, $cont); // Grabas
	 fclose($fch); // Cierras el archivo
	
 	 $clase->closeConnection();	 
  } // Fin de la Funcion  



  ///////////////////////////////////////////////////////////////////////  
  /// Impresion de la Tira de Especiales por Dia 
  ///////////////////////////////////////////////////////////////////////  
  function ImpresionTiraCortaBonificado($diaoperativo,$imprimir="S")
  {
     ini_set("memory_limit","200M");
     set_time_limit(0);
/*
     $clase = new Sistema();
	 $sucid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];

	 $cont.=  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).$nomempresa.Chr(13).Chr(10);	
	 $cont.=  $nitempresa.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 
	 /// Hago la Consulta de los datos del cierre
	 $vsql = "SELECT S.descripcion nomsucursal, C. * 
			  FROM cierres C INNER JOIN sucursales S ON ( C.sucid = S.sucursalid ) 
			  WHERE C.tipocierre = 'DEF' AND C.diaoperativo='".$diaoperativo."'";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 if($row = @mysql_fetch_array($result))
	 { 
 	   $nomsucursal  = $row['nomsucursal'];
	   $diaoperativo = $row['diaoperativo'];
 	   $fecha        = substr($row['momento'],0,10);
 	   $hora         = substr($row['momento'],11,2).":".substr($row['momento'],14,2); 	    	   
	   $realiza      = substr($row['nombres'].' '.$row['apellidos'],0,24); 
     } 

     $cont.= 'SUCURSAL : '.$nomsucursal.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'DIA OPERATIVO  : '.$diaoperativo.Chr(13).Chr(10);	 
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 	
	 $cont.= '  ****  RESUMEN DE ESPECIALES  *****   '.Chr(13).Chr(10);    
	 $cont.= '======================================='.Chr(13).Chr(10);     
     	     	 
	 /// Hago la Consulta de los datos del cierre
	 $fechaC=  substr($diaoperativo,6,4)."-".substr($diaoperativo,3,2)."-".substr($diaoperativo,0,2);
	 $vsql2 = "SELECT T.apellidos, T.nombres, P.descripcion, B. fecha , B.porcenboni , SUM(B.cantidad) cantidad , SUM(B.valorventa) valorventa , SUM(B.valorcomi) valorcomi
			   FROM bonificado B INNER JOIN terceros T ON ( T.terid = B.vendedor ) INNER JOIN productos P ON ( P.productoid = B.productoid ) 
			   WHERE B.fecha = '".$fechaC."' AND B.sucursalid =".$sucid." GROUP BY 1,2,3,4,5 ORDER BY T.apellidos ASC , T.nombres ASC , P.descripcion ASC";

	 /// Parametros para la totalizacion 
	 $vendedact = "";   	 $detalles  = "";       $totventa=0;   $totventabon=0;
	 
	 $conex2  = $clase->Conectar();
     $result2 = @mysql_query($vsql2,$conex2);
 	 while($row2 = @mysql_fetch_array($result2))
	 { 
       if($vendedact != substr($row2['nombres']." ".$row2['apellidos'],0,27))
	   {
           if($vendedact != "")
		   {
		     $tv   = str_pad(number_format($totventa),8," ",STR_PAD_LEFT);
		     $tvb  = str_pad(number_format($totventabon),8," ",STR_PAD_LEFT);			 
			 $detalles.= '======================================='.Chr(13).Chr(10);     	 
             $detalles.= 'TOTAL VENTAS ESPECIALES :    '.$tv.Chr(13).Chr(10);     	 		 
             $detalles.= 'TOTAL ESPECIALES :           '.$tvb.Chr(13).Chr(10);     	 		 			   
			 $detalles.= '======================================='.Chr(13).Chr(10);     	 	   
			 $totventa = 0;               $totventabon = 0;
		   }
		   
		   $vendedact = substr($row2['nombres']." ".$row2['apellidos'],0,27);
		   $detalles.= '**************************************'.Chr(13).Chr(10);     	 
           $detalles.= 'VENDEDOR : '.$vendedact.Chr(13).Chr(10);     	 		   
	   }

	   $totventa += $row2['valorventa'];
	   $totventabon += $row2['valorcomi'];	   
     } 
     $tv   = str_pad(number_format($totventa),9," ",STR_PAD_LEFT);
	 $tvb  = str_pad(number_format($totventabon),9," ",STR_PAD_LEFT);			 			
	 $detalles.= '======================================='.Chr(13).Chr(10);     	 
     $detalles.= 'TOTAL VENTAS ESPECIALES :    '.$tv.Chr(13).Chr(10);     	 		 
     $detalles.= 'TOTAL ESPECIALES :           '.$tvb.Chr(13).Chr(10);     	 		 			   
     $detalles.= '======================================='.Chr(13).Chr(10);     	 	   

     //// Genero la Tira 
	 $cont.= $detalles;
     
     $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  

     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio la tira de Especiales con Exito',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 if($imprimir == "S")
	 {
		 $archivo= "print/tirabonificado.txt"; // el nombre de tu archivo

	     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
	     fwrite($fch, $cont); // Grabas
	     fclose($fch); // Cierras el archivo	
	 }	 

     // Genero el Archivo Almacenarlo en el Log
	 $archivo = "log/Espe-".substr($diaoperativo,0,2).substr($diaoperativo,3,2).substr($diaoperativo,6,4).".txt"; // el nombre de tu archivo
	 $fch = fopen($archivo, "w"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 
	 */
  } // Fin de la Funcion
  
  ///////////////////////////////////////////////////////////////////////  
  /// Impresion de la Tira de Especiales por Dia 
  ///////////////////////////////////////////////////////////////////////  
  function ImpresionTiqueteGastos($diaoperativo,$imprimir="S")
  {
     ini_set("memory_limit","200M");
     set_time_limit(0);
   
     $clase = new Sistema();
	 $sucid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];

	 $cont.=  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).$nomempresa.Chr(13).Chr(10);	
	 $cont.=  $nitempresa.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 
	 /// Hago la Consulta de los datos del cierre
	 $vsql = "SELECT S.descripcion nomsucursal, C. * 
			  FROM cierres C INNER JOIN sucursales S ON ( C.sucid = S.sucursalid ) 
			  WHERE C.tipocierre = 'DEF' AND C.diaoperativo='".$diaoperativo."'";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 if($row = @mysql_fetch_array($result))
	 { 
		$cierreid    = $row['cierreid'];
		$nomsucursal = $row['nomsucursal'];
		$diaoperativo = $row['diaoperativo'];
		$fecha        = substr($row['momento'],0,10);
		$hora         = substr($row['momento'],11,2).":".substr($row['momento'],14,2); 	    	   
		$realiza      = substr($row['nombres'].' '.$row['apellidos'],0,24); 
     } 

     $cont.= 'SUCURSAL : '.$nomsucursal.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'DIA OPERATIVO  : '.$diaoperativo.Chr(13).Chr(10);	 
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
     $cont.= '======================================='.Chr(13).Chr(10);          	 	
	 $cont.= '    ***  TICKET DE DESCUENTOS   ***    '.Chr(13).Chr(10);    
	 $cont.= '======================================='.Chr(13).Chr(10);     

	 //// Total a Consignar
	 $totalconsignar = $clase->BDLockup($cierreid,"cierres","cierreid","totconsignar");

	 /// Hago la Consulta de los datos del cierre
	 $vsql2 = "SELECT * FROM autorizacionesgastos WHERE codsucursal = '".$_SESSION['G_SUCURSALPOS']."' AND diaoperativo = '".$diaoperativo."'";
	 $i = 0;
	 $totgastos = 0;
  	 $conex2  = $clase->Conectar();
     $result2 = @mysql_query($vsql2,$conex2);
 	 while($row2 = @mysql_fetch_array($result2))
	 { 		
		if($row2['valortotal']>0)
		{
			$detalles.= str_pad(substr($row2['tipo'],0,20),24," ",STR_PAD_RIGHT).' '.str_pad(number_format($row2['valortotal']),12," ",STR_PAD_LEFT).Chr(13).Chr(10);     	 
			$totgastos += $row2['valortotal'];
		}
		$i++;
	 } 
	 
	 $NVC = str_pad(number_format(($totalconsignar-$totgastos)),12," ",STR_PAD_LEFT);
	 $tg   = str_pad(number_format($totgastos),12," ",STR_PAD_LEFT);

	 //// Actualizo en el Cierre el Total de Gastos
	 $clase->EjecutarSQL("UPDATE cierres SET totgastos = ".$totgastos." WHERE cierreid = ".$cierreid);
	 
	 $detalles.= '======================================='.Chr(13).Chr(10);     	 
     $detalles.= ' TOTAL DESCUENTOS         '.$tg.Chr(13).Chr(10);   
	 $detalles.= '***************************************'.Chr(13).Chr(10);     	 	   
     $detalles.= ' VALOR REAL A CONSIGNAR   '.$NVC.Chr(13).Chr(10);   
	 $detalles.= '***************************************'.Chr(13).Chr(10);
	 $detalles.= 'Observaciones: '.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 $detalles.= '======================'.Chr(13).Chr(10);     	 	   
	 $detalles.= 'FIRMA Y SELLO DE LA SUCURSAL'.Chr(13).Chr(10);     	 	   

	 $cont.= $detalles;
     
     $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  

     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio Tiquete de Gastos con Exito',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 $archivo= "print/tiragastos.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
	 fwrite($fch, $cont); // Grabas
	 fclose($fch); // Cierras el archivo	
	 
	 $archivo= "print/tiragastos2.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
	 fwrite($fch, $cont); // Grabas
	 fclose($fch); // Cierras el archivo	
	 	 
     // Genero el Archivo Almacenarlo en el Log
	 $archivo = "log/Gastos-".substr($diaoperativo,0,2).substr($diaoperativo,3,2).substr($diaoperativo,6,4).".txt"; // el nombre de tu archivo
	 $fch = fopen($archivo, "w"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 

  } // Fin de la Funcion


  ///////////////////////////////////////////////////////////////////////  
  /// Impresion de la Tira de Especiales por Dia 
  ///////////////////////////////////////////////////////////////////////  
  function ImpresionTiraBonificado($diaoperativo,$imprimir="S")
  {
     ini_set("memory_limit","200M");
     set_time_limit(0);
     
     $clase = new Sistema();
	 $sucid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];

	 $cont.=  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).$nomempresa.Chr(13).Chr(10);	
	 $cont.=  $nitempresa.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 
	 /// Hago la Consulta de los datos del cierre
	 $vsql = "SELECT S.descripcion nomsucursal, T.nombres, T.apellidos, C. * 
			  FROM cierres C INNER JOIN sucursales S ON ( C.sucid = S.sucursalid ) 
		  	  INNER JOIN usuarios U ON ( U.username = C.creador ) 
			  INNER JOIN terceros T ON ( T.terid = U.terid ) 
			  WHERE C.diaoperativo='".$diaoperativo."' AND S.sucursalid=".$sucid;

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 if($row = @mysql_fetch_array($result))
	 { 
 	   $nomsucursal  = $row['nomsucursal'];
	   $diaoperativo = $row['diaoperativo'];
 	   $fecha        = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4);
 	   $hora         = substr($row['momento'],11,2).":".substr($row['momento'],14,2); 	    	   
	   $realiza      = substr($row['nombres'].' '.$row['apellidos'],0,24); 
     } 

     $cont.= 'SUCURSAL : '.$nomsucursal.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'DIA OPERATIVO  : '.$diaoperativo.Chr(13).Chr(10);	 
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
	 $cont.= 'REALIZO : '.$realiza.Chr(13).Chr(10);
     $cont.= '======================================='.Chr(13).Chr(10);          	 	
	 $cont.= '  ****  PRODUCTOS ESPECIALES  *****    '.Chr(13).Chr(10);    
	 $cont.= '======================================='.Chr(13).Chr(10);     
     	 
	 /// Hago la Consulta de los datos del cierre
	 $fechaC=  substr($diaoperativo,6,4)."-".substr($diaoperativo,3,2)."-".substr($diaoperativo,0,2);
	 $vsql2 = "SELECT T.apellidos, T.nombres, P.descripcion, B. fecha , B.porcenboni , SUM(B.cantidad) cantidad , SUM(B.valorventa) valorventa , SUM(B.valorcomi) valorcomi
			   FROM bonificado B INNER JOIN terceros T ON ( T.terid = B.vendedor ) INNER JOIN productos P ON ( P.productoid = B.productoid ) 
			   WHERE B.fecha = '".$fechaC."' AND B.sucursalid =".$sucid." GROUP BY 1,2,3,4,5 ORDER BY T.apellidos ASC , T.nombres ASC , P.descripcion ASC";

	 /// Parametros para la totalizacion 
	 $vendedact = "";   	 $detalles  = "";       $totventa=0;   $totventabon=0;
	 
	 $conex2  = $clase->Conectar();
     $result2 = @mysql_query($vsql2,$conex2);
 	 while($row2 = @mysql_fetch_array($result2))
	 { 
       if($vendedact != substr($row2['nombres']." ".$row2['apellidos'],0,27))
	   {
           if($vendedact != "")
		   {
		     $tv   = str_pad(number_format($totventa),8," ",STR_PAD_LEFT);
		     $tvb  = str_pad(number_format($totventabon),8," ",STR_PAD_LEFT);			 
			 $detalles.= '======================================='.Chr(13).Chr(10);     	 
             $detalles.= 'TOTAL VENTAS ESPECIALES :    '.$tv.Chr(13).Chr(10);     	 		 
             $detalles.= 'TOTAL ESPECIALES :           '.$tvb.Chr(13).Chr(10);     	 		 			   
			 $detalles.= '======================================='.Chr(13).Chr(10);     	 	   
			 $totventa = 0;               $totventabon = 0;
		   }
		   
		   $vendedact = substr($row2['nombres']." ".$row2['apellidos'],0,27);
	       $detalles.= '**************************************'.Chr(13).Chr(10);     	 
           $detalles.= 'VENDEDOR : '.$vendedact.Chr(13).Chr(10);     	 		   
           $detalles.= '**************************************'.Chr(13).Chr(10);     	 
		   $detalles.= 'ESPECIAL          %       Base    Desc'.Chr(13).Chr(10);     	 
           $detalles.= '--------------------------------------'.Chr(13).Chr(10);     	 		   
	   }

 	   $detalles.= str_pad(substr($row2['descripcion'],0,12),13," ",STR_PAD_RIGHT).'  ';
	   $detalles.= str_pad($row2['porcenboni'],5," ",STR_PAD_LEFT).'  '.str_pad(number_format($row2['valorventa']),8," ",STR_PAD_LEFT);
	   $detalles.= str_pad(number_format($row2['valorcomi']),8," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
       
	   $totventa += $row2['valorventa'];
	   $totventabon += $row2['valorcomi'];	   
     } 
     $tv   = str_pad(number_format($totventa),9," ",STR_PAD_LEFT);
	 $tvb  = str_pad(number_format($totventabon),9," ",STR_PAD_LEFT);			 			
	 $detalles.= '======================================='.Chr(13).Chr(10);     	 
     $detalles.= 'TOTAL VENTAS ESPECIALES :    '.$tv.Chr(13).Chr(10);     	 		 
     $detalles.= 'TOTAL ESPECIALES :           '.$tvb.Chr(13).Chr(10);     	 		 			   
     $detalles.= '======================================='.Chr(13).Chr(10);     	 	   

     //// Genero la Tira 
	 $cont.= $detalles;
     
    // $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  

     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio la tira de Especiales con Exito',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "print/tirabonificado.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 
	 
  } // Fin de la Funcion



  ////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////  
  function TiraSoporteEmpresaMensajeria($docuid)
  {
	$clase = new Sistema();	 
    $cont = "".Chr(13).Chr(10);	 
	
	/// Hago la Consulta de los datos de la Factura 		
	$vsql ="SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , T.dni codcliente , D.terid3 , 
			CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , T.telmovil , P.codigo codproducto , P.descripcion nomproducto , DD.valunitario , 
			SUM(DD.cantidad) cantidad ,  SUM(DD.valparcial) valparcial 
			FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			INNER JOIN productos P ON (P.productoid = DD.productoid)
			WHERE D.docuid=".$docuid." AND P.codigo = 'DO' GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19";

	$conex  = $clase->Conectar();
	$result = @mysql_query($vsql,$conex);
	$registros = @mysql_num_rows($result);
	if($registros>0)
	{
		while($row = @mysql_fetch_array($result))
		{ 
			/// Nombre del Archivo para la Sincronizacion
			$nombredoc = $row['tipodoc'].$row['prefijo'].$row['numero']; 
			
			$prefijo = $row['prefijo'];
			$numero  = $row['numero'];
			$fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
			$hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
			
			$total    = $clase->BDLockup($docuid,'documentos','docuid','total'); 
			
			$cliente  = substr($row['nomcliente'],0,24); 
			$nitcli   = $row['dni']; 	   
			$dircli   = $row['direccion']; 	   	   
			$telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   
			
			$domi = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid3']);
			$codX = $clase->SeleccionarUno("SELECT dni FROM terceros WHERE terid=".$row['terid3']);
			$domiciliario = substr($domi,0,36); 
			
			$detalles.= ' TOTAL A PAGAR CLIENTE : '.str_pad(number_format($total),13," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
		} 

		$tarifadomicilio =$clase->BDLockup($docuid,"documentos","docuid","observacion2");

		$cont.= '---------------------------------------'.Chr(13).Chr(10);          
		$cont.= '*** TICKET DOMICILIO PARA EMPRESAS *** '.Chr(13).Chr(10);	 
		$cont.= '---------------------------------------'.Chr(13).Chr(10);          
		$cont.= 'FACTURA DE VENTA No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
		$cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
		$cont.= '---------------------------------------'.Chr(13).Chr(10);          
		$cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
		$cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);
		$cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);
		$cont.= 'TELEFON : '.$telcli.Chr(13).Chr(10).Chr(13);
		$cont.= '---------------------------------------'.Chr(13).Chr(10);          	 	
		$cont.= 'DOMICIL : '.$domiciliario.Chr(13).Chr(10);	      
		$cont.= '---------------------------------------'.Chr(13).Chr(10);          
		$cont.= $detalles;	 
		$cont.= '---------------------------------------'.Chr(13).Chr(10); 
		$cont.= ' TARIFA DOMICILIO : '.str_pad(number_format($tarifadomicilio),18," ",STR_PAD_LEFT).Chr(13).Chr(10); 	 
		$cont.= '---------------------------------------'.Chr(13).Chr(10).Chr(13).Chr(10); 
		$cont.= ' NO Entregue este ticket al Cliente!'.Chr(13).Chr(10); 
		$cont.= ' Este es soporte del Domicilio para la Empresa de Mensajeria del Servicio prestado por Usted.'.Chr(13).Chr(10); 
		
		$cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
		$cont.= '.'.Chr(13).Chr(10);
		$cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  

		//// Imprimo el Cierre
		$tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
		if($tipo == "G")
		{
			/// 1. Le Aplico Permisos a la Carpeta PDF
			chmod($acceso."print/", 0777);
			/// 2. Genero la Impresion  
			$archivo= "print/empmensajeria.txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			fwrite($fch, $cont); // Grabas
			fclose($fch); // Cierras el archivo

			/// 3. Le Aplico Permisos al archivo
			chmod("print/imprimircierre.txt", 0777);					
		}		    
		else
		{
		    $archivo= "print/empmensajeria.txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			fwrite($fch, $cont); // Grabas
			fclose($fch); // Cierras el archivo
		}
	
	}
    return;     
  }


  ////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////  
  function ImpresionTiraMensajeria($docuid)
  {
	$clase = new Sistema();	 
	$nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	$cont = $nomempresa.Chr(13).Chr(10);	 
	
	/// Hago la Consulta de los datos de la Factura 		
	$vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , T.dni codcliente , D.terid3 , 
			  CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , T.telmovil , P.codigo codproducto , P.descripcion nomproducto , DD.valunitario , 
			 SUM(DD.cantidad) cantidad ,  SUM(DD.valparcial) valparcial 
			 FROM documentos D LEFT JOIN terceros T ON (T.terid = D.terid1)
			 LEFT JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			 LEFT JOIN productos P ON (P.productoid = DD.productoid)
			 WHERE D.docuid=".$docuid." AND P.codigo = 'DO' AND terid3 <> 999999 GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19";
//echo $vsql;
	$conex  = $clase->Conectar();
	$result = @mysql_query($vsql,$conex);
	$registros = @mysql_num_rows($result);
	if($registros>0)
	{
   	   $direnvio = $clase->BDLockup($docuid,"docuventa","docuid","direnvio");	 
	   while($row = @mysql_fetch_array($result))
	   { 
		   /// Nombre del Archivo para la Sincronizacion
		   $nombredoc = $row['tipodoc'].$row['prefijo'].$row['numero']; 
		   
		   $prefijo = $row['prefijo'];
		   $numero  = $row['numero'];
		   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
		   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
		   
		   $total    = $clase->BDLockup($docuid,'documentos','docuid','total'); 
		   
		   $cliente  = substr($row['nomcliente'],0,24); 
		   $nitcli   = $row['dni']; 	   
		   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   

		   if(strlen($direnvio)>3)
              $dircli   = $direnvio;
		   else
		      $dircli   = $row['direccion']; 	   	   			
		   
		   $domi = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid3']);
		   $codX = $clase->SeleccionarUno("SELECT dni FROM terceros WHERE terid=".$row['terid3']);
		   $domiciliario = substr($domi,0,32); 
		   
		   $detalles.= 'TOTAL A CANCELAR : '.str_pad(number_format($total),18," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
	   } 
       
	   ///// SI Tiene Domiciliario - Genera El Ticket
	   //if($domiciliario != "")
	   //{
		   $cont.= '---------------------------------------'.Chr(13).Chr(10);          
		   $cont.= '    *** RECIBO DE DOMICILIO ***       '.Chr(13).Chr(10);	 
		   $cont.= '---------------------------------------'.Chr(13).Chr(10);          
		   $cont.= 'COMPROBANTE DE VENTA No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
		   $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
		   $cont.= '---------------------------------------'.Chr(13).Chr(10);          
		   $cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
		   $cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);
		   $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);
		   $cont.= 'TELEFON : '.$telcli.Chr(13).Chr(10).Chr(13);
		   $cont.= '---------------------------------------'.Chr(13).Chr(10);          	 	
		   $cont.= 'DOMICIL : '.$domiciliario.Chr(13).Chr(10);	      
		   $cont.= '---------------------------------------'.Chr(13).Chr(10);          
		   $cont.= $detalles;	 
		   $cont.= '---------------------------------------'.Chr(13).Chr(10); 
		   
		   /// Consulto si hubo que dar vueltos 
		   $vueltos = $clase->BDLockup($docuid,'docuventa','docuid','vueltos');
		   if($vueltos > 0){
		   $cont.= 'VUELTOS A ENTREGAR '.str_pad(number_format($vueltos),18," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
		   $cont.= '-------------------------------------'.Chr(13).Chr(10);     	 	 
		   }
	
		   $cont.= Chr(13).Chr(10).str_pad("www.dromedicas.com.co",39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
		   $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
		   $cont.= '.'.Chr(13).Chr(10);
		   $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  
	
		   //// Imprimo el Cierre
		   $tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
		   if($tipo == "G")
		   {
				/// 1. Le Aplico Permisos a la Carpeta PDF
				chmod($acceso."print/", 0777);
				/// 2. Genero la Impresion  
				$archivo= "print/mensajeria.txt"; // el nombre de tu archivo
				$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			    fwrite($fch, $cont); // Grabas
			    fclose($fch); // Cierras el archivo

				/// 3. Le Aplico Permisos al archivo
				chmod("print/imprimircierre.txt", 0777);					
		   }		
		   else
		   {
			   $archivo= "print/mensajeria.txt"; // el nombre de tu archivo 	
			   $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			   fwrite($fch, $cont); // Grabas
			   fclose($fch); // Cierras el archivo
		   }
	   	
			// Lo Adiciono a la tira de Seguridad de la Impresion
			$archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
			fwrite($fch, $cont); // Grabas
			fclose($fch); // Cierras el archivo
			
			$cont = "";
	   //}

	}
	else
	  return;
	  
  } // Fin de la Funcion

  ////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////  
  function ImpresionTiraMensajeria2($docuid)
  {
	$clase = new Sistema();	 
	$nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	$cont = $nomempresa.Chr(13).Chr(10);	 
	
	/// Hago la Consulta de los datos de la Factura 		
	$vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , T.dni codcliente , D.terid3 , 
			  CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , T.telmovil , P.codigo codproducto , P.descripcion nomproducto , DD.valunitario , 
			 SUM(DD.cantidad) cantidad ,  SUM(DD.valparcial) valparcial 
			 FROM documentos D LEFT JOIN terceros T ON (T.terid = D.terid1)
			 LEFT JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			 LEFT JOIN productos P ON (P.productoid = DD.productoid)
			 WHERE D.docuid=".$docuid." AND P.codigo = 'DO' AND terid3 = 999999 GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19";
//echo $vsql;
	$conex  = $clase->Conectar();
	$result = @mysql_query($vsql,$conex);
	$registros = @mysql_num_rows($result);
	if($registros>0)
	{
   	   $direnvio = $clase->BDLockup($docuid,"docuventa","docuid","direnvio");	 
	   while($row = @mysql_fetch_array($result))
	   { 
		   /// Nombre del Archivo para la Sincronizacion
		   $nombredoc = $row['tipodoc'].$row['prefijo'].$row['numero']; 
		   
		   $prefijo = $row['prefijo'];
		   $numero  = $row['numero'];
		   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
		   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
		   
		   $total    = $clase->BDLockup($docuid,'documentos','docuid','total'); 
		   
		   $cliente  = substr($row['nomcliente'],0,24); 
		   $nitcli   = $row['dni']; 	   
		   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   

		   if(strlen($direnvio)>3)
              $dircli   = $direnvio;
		   else
		      $dircli   = $row['direccion']; 	   	   			
		   
		   $domi = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid3']);
		   $codX = $clase->SeleccionarUno("SELECT dni FROM terceros WHERE terid=".$row['terid3']);
		   $domiciliario = substr($domi,0,32); 
		   
		   $detalles.= 'TOTAL A CANCELAR : '.str_pad(number_format($total),18," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
	   } 
       
	   ///// SI Tiene Domiciliario - Genera El Ticket
	   //if($domiciliario != "")
	   //{
		   $cont.= '---------------------------------------'.Chr(13).Chr(10);          
		   $cont.= '    *** RECIBO DE DOMICILIO ***       '.Chr(13).Chr(10);	 
		   $cont.= '---------------------------------------'.Chr(13).Chr(10);          
		   $cont.= 'COMPROBANTE DE VENTA No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
		   $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
		   $cont.= '---------------------------------------'.Chr(13).Chr(10);          
		   $cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
		   $cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);
		   $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);
		   $cont.= 'TELEFON : '.$telcli.Chr(13).Chr(10).Chr(13);
		   $cont.= '---------------------------------------'.Chr(13).Chr(10);          	 	
		   //$cont.= 'DOMICIL : '.$domiciliario.Chr(13).Chr(10);	      
		   //$cont.= '---------------------------------------'.Chr(13).Chr(10);          
		   $cont.= $detalles;	 
		   $cont.= '---------------------------------------'.Chr(13).Chr(10); 
		   
		   /// Consulto si hubo que dar vueltos 
		   $vueltos = $clase->BDLockup($docuid,'docuventa','docuid','vueltos');
		   if($vueltos > 0){
		   $cont.= 'VUELTOS A ENTREGAR '.str_pad(number_format($vueltos),18," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
		   $cont.= '-------------------------------------'.Chr(13).Chr(10);     	 	 
		   }
	
		   $cont.= Chr(13).Chr(10).str_pad("www.dromedicas.com.co",39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
		   $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
		   $cont.= '.'.Chr(13).Chr(10);
		   $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  
	
		   //// Imprimo el Cierre
		   $tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
		   if($tipo == "G")
		   {
				/// 1. Le Aplico Permisos a la Carpeta PDF
				chmod($acceso."print/", 0777);
				/// 2. Genero la Impresion  
				$archivo= "print/mensajeria.txt"; // el nombre de tu archivo
				$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			    fwrite($fch, $cont); // Grabas
			    fclose($fch); // Cierras el archivo

				/// 3. Le Aplico Permisos al archivo
				chmod("print/imprimircierre.txt", 0777);					
		   }		
		   else
		   {
			   $archivo= "print/mensajeria.txt"; // el nombre de tu archivo 	
			   $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			   fwrite($fch, $cont); // Grabas
			   fclose($fch); // Cierras el archivo
		   }
	   	
			// Lo Adiciono a la tira de Seguridad de la Impresion
			$archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
			fwrite($fch, $cont); // Grabas
			fclose($fch); // Cierras el archivo
			
			$cont = "";
	   //}

	}
	else
	  return;
	  
  } // Fin de la Funcion

  //////////////////////////////////////////////////  
  function ImpresionTicketBoleta($docuid)
  {
     $clase = new Sistema();	 
     $cont = Chr(13).Chr(10);	 
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , t.dni codcliente , D.terid3 , 
	 		  CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , T.telmovil , P.codigo codproducto , P.descripcion nomproducto , DD.valunitario , 
			  SUM(DD.cantidad) cantidad ,  SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19 LIMIT 0,1";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 	 
 	 if($row = @mysql_fetch_array($result))
	 { 
 	   /// Nombre del Archivo para la Sincronizacion
	   $nombredoc = $row['tipodoc'].$row['prefijo'].$row['numero']; 
	   
	   $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
 	   
	   $total    = $clase->BDLockup($docuid,'documentos','docuid','total'); 
 	   
   	   $cliente  = substr($row['nomcliente'],0,24); 
   	   $nitcli   = $row['dni']; 	   
   	   $dircli   = $row['direccion']; 	   	   
   	   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   
     } 
 

	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= ' *** BOLETA PARA LA RIFA DE LA MOTO ***       '.Chr(13).Chr(10);	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'FACTURA DE VENTA No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
	 $cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
	 $cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);
	 $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);
	 $cont.= 'TELEFON : '.$telcli.Chr(13).Chr(10).Chr(13);
     $cont.= '---------------------------------------'.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);          	 	
     $cont.= '.'.Chr(13).Chr(10);          	 	
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  
	
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "print/boleta.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
  } // Fin de la Funcion
  
  
  
  //////////////////////////////////////////////////  
  function ImpresionTiraConcurso($docuid)
  {
     $clase = new Sistema();	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
     $cont = $nomempresa.Chr(13).Chr(10);	 
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.prefijo , D.numero , D.fechadoc , D.total , T.* , 
			  CONCAT(T2.nombres,' ',T2.apellidos) vendedor , S.descripcion sucursal 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN terceros T2 ON (T.terid = D.terid2)
			  INNER JOIN suursales S ON (D.sucursalid = S.sucursalid)
			  WHERE D.docuid=".$docuid;

	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 	 
 	 if($row = mysql_fetch_array($result))
	 { 
			$cont.= '---------------------------------------'.Chr(13).Chr(10);          
			$cont.= ' ***  R I F A   D E  L A   M O T O  ***'.Chr(13).Chr(10);	 
			$cont.= '---------------------------------------'.Chr(13).Chr(10);          
			$cont.= 'FACTURA DE VENTA No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
			$cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
			$cont.= 'TOTAL $ : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
			$cont.= 'ATENDIO : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
			$cont.= '---------------------------------------'.Chr(13).Chr(10);          
			$cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
			$cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);
			$cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);
			$cont.= 'TELEFON : '.$telcli.Chr(13).Chr(10).Chr(13);
			$cont.= '---------------------------------------'.Chr(13).Chr(10);          	 	
			$cont.= 'SUCURSAL: '.$domiciliario.Chr(13).Chr(10);	      
			$cont.= '---------------------------------------'.Chr(13).Chr(10);          
			$cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
			$cont.= '.'.Chr(13).Chr(10);
	 }
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "print/rifa.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo = "log/LogImpre".date("mY").".txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en �l
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 
  } // Fin de la Funcion

  
  //////////////////////////////////////////////////////////////////////  
  //// Decide si imprime en formato Matricial o POS Grafica
  //////////////////////////////////////////////////////////////////////  
  function AbrirCajonMonedero($docuid)
  {
	 copy("recursos/ABRIRCAJON.DAT","print/abrir.txt");	
     return;
  }

  //////////////////////////////////////////////////////////////////////  
  //// Decide si imprime en formato Matricial o POS Grafica
  //////////////////////////////////////////////////////////////////////  
  function ImpresionPOSFactura($docuid,$autoprint='N',$reimpresion='N')
  {
	    AbrirCajonMonedero($docuid);

		if(($_SESSION['G_SUCURSALPOS'] == 'CBU')||($_SESSION['G_SUCURSALPOS'] == 'CCU'))   /// Impresion para Cafeterias
			ImpresionPOSFactura5($docuid,$autoprint,$reimpresion);
		else
		{
			if(($_SESSION['G_SUCURSALPOS'] == '00')||($_SESSION['G_SUCURSALPOS'] == 'DB')||($_SESSION['G_SUCURSALPOS'] == 'DBU')||($_SESSION['G_SUCURSALPOS'] == 'DME'))  /// Impresion para Depositos
				ImpresionPOSFactura3($docuid,$autoprint,$reimpresion);
			else
				ImpresionPOSFactura2($docuid,$autoprint,$reimpresion);	 
		}		
	    return;	
  }
  

  ////////////////////////////////////////////////////////////////////// 
  ////  NUEVO FORMATO 2024 - NOTA DE ENTREGA
  ////////////////////////////////////////////////////////////////////// 
  function ImpresionPOSFactura2($docuid,$autoprint='N',$reimpresion='N')
  {
     $clase = new Sistema();	 
	 $detalles = "";       $nombremoneda = "";
  	 $cont = "";

     $nombremoneda = @$_SESSION['G_MONEDALOCAL'];
	 $asentada = $clase->BDLockup($docuid,'documentos','docuid','fecasentado');
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
     $cont.= $nomempresa.Chr(13).Chr(10);	 

	 /// Cargo las configuraciones del Prefijo del Documento
	 $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	 $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");	  

	 /// Datos de la Resolucion
	 $obs2 = $clase->BDLockup($docuid,"documentos","docuid","observacion2");	 
	 $direnvio = $clase->BDLockup($docuid,"docuventa","docuid","direnvio");	 

	 $sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');
	 $fechafactura = $clase->BDLockup($docuid,'documentos','docuid','CAST(fechadoc as DATE)');

	 $vsql = "SELECT * FROM consecutivos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 if($row = @mysql_fetch_array($result))
	 {
		$cadenaid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","cadenaid");
		if($cadenaid == 1)
			$encab1 = "DROGUERIA FARMANORTE";
		if($cadenaid == 2)
			$encab1 = "DROGUERIA GUASIMALES";	
			
		$encab2 = $row['encab2'];	
		$encab3 = $row['encab3'];				    
		$encab4 = $row['encab4'];				    
		$encab5 = $row['encab5'];				    			    
			
		$pie1 = $row['pie1'];	    
		$pie2 = $row['pie2'];	    
		$pie3 = $row['pie3'];	    
		$pie4 = $row['pie4'];	    
		$pie5 = $row['pie5'];	 
		
		$txtres = $txtresol;	    
	}    
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , DD.observalinea , 
	  		  T.dni codcliente , D.terid2 , D.terid3 , CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , P.precio1m , T.email , 
			  T.telmovil , GP.descripcion nomlabo , P.codigo codproducto , P.factor1 , P.porciva , DD.docuref , P.descripcion nomproducto , DD.valunitario , DD.valdescuento , 
			  SUM(DD.unicom) cajas , SUM(DD.unifra) unidades , SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28      
			  ORDER BY DD.dedocumid ASC";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
     
	 if($encab1!= "")
       $cont.= $encab1.Chr(13).Chr(10);
	 if($encab2!= "")
	   $cont.= $encab2.Chr(13).Chr(10);
 	 if($encab3!= "")
	   $cont.= $encab3.Chr(13).Chr(10);
 	 if($encab4!= "")
	   $cont.= $encab4.Chr(13).Chr(10);
 	 if($encab5!= "")
	   $cont.= $encab5.Chr(13).Chr(10);	 	 	 	 
	 
	 $teriddomi = "";  $domix = 0;
	 $condecreto = 0;  $totaldescuento = 0;
	 while($row = @mysql_fetch_array($result))
	 { 
 	   /// Nombre del Archivo para la Sincronizacion
	   $nombredoc = $row['tipodoc'].$row['prefijo'].abs($row['numero']); 
	   $emailcliente = $row['email'];
	   if($emailcliente == "")
	     $emailcliente = "clientessincorreo@dromedicas.com.co";
	   	   
	   $teriddomi = $row['terid3'];
	   $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
 	   
	   $subtotal = $row['base']; 
	   $iva      = $row['iva']; 	   
	   $total    = $row['total']; 

  	   $cliente  = substr($row['nomcliente'],0,24); 

   	   $nitcli   = $row['dni']; 	   
   	   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   
   	   $dircli   = $row['direccion']; 	   	   
   	   
       if($row['docuref'] == "*")
         $condecreto ++;
	   
	   $vend = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid2']);
	   $vendedor = substr($vend,0,27); 

	   if($row['codproducto'] != 'DO')
	   {
 	     $valdcto = ($row['valparcial']*($row['valdescuento']/100));

 	     $detalles.= str_pad(substr($row['nomproducto'],0,27),27," ",STR_PAD_RIGHT).'  ';
		 $detalles.= str_pad($row['cajas'],3," ",STR_PAD_LEFT).' '.str_pad($row['unidades'],3," ",STR_PAD_LEFT).'   ';
		 
         if(strlen($row['observalinea'])>0)
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format((($row['cajas']*$row['factor1'])+$row['unidades'])*$row['valunitario']),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['cajas']*$row['precio1m'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	   
         }	
         else
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format(($row['valparcial'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['valparcial'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   	
         }	
		 
		 
		 if(($_SESSION['USERNAME'] == "VENTASPBX")||($obs2!=""))
		    $detalles.= "Cod. Barra : ".$row['codproducto']."   Lab: ".substr($row['nomlabo'],0,10).Chr(13).Chr(10); 	  

         if($valdcto>0)
          	$totaldescuento += $valdcto;
                  
         //// Adaptacion para las Recargas
         //// Muestra el Operador y el Numero a realizar la transaccion
         if(($row['codproducto'] == "R1000")||($row['codproducto'] == "R1001")) 
         {
           $vsqlx = "SELECT CONCAT('Num : ',T.numrecarga,' Operad : ', O.nomoperador) 
                     FROM transarecargas T INNER JOIN operadorcel O ON (T.codoperador = O.codoperador)
					 WHERE T.idfactura = ".$docuid." ORDER BY transaid DESC LIMIT 0,1";
           $datoRecarga = $clase->SeleccionarUno($vsqlx);
           $detalles   .= $datoRecarga.Chr(13).Chr(10);

		   $vsqlz= "SELECT observacion3 FROM documentos WHERE docuid=".$docuid;
		   $obsrv3 = $clase->SeleccionarUno($vsqlz);

		   if($obsrv3 != "")
		   {
				$jsonResponse2=$_SESSION['TICKEDRECARGAS'];
				$obj = json_decode($jsonResponse2); 
				$transactionId = $obj->data->transactionId;
				$authorizationCode = $obj->data->authorizationCode;
				$header = $obj->data->ticket->header;
				$Fecha = $obj->data->ticket->body->Fecha;
				$Hora = $obj->data->ticket->body->Hora;
				$Aprobacion = $obj->data->ticket->body->Aprobacion;
				$Numero = $obj->data->ticket->body->Numero;
				$Valor = $obj->data->ticket->body->Valor;
				$footer = $obj->data->ticket->footer;
				//$vacoles = (array)['Á',];
				
				$footer2 = str_replace(array('Á', 'É', 'Í', 'Ó', 'Ú', 'á', 'é', 'é', 'ó', 'ú'),array('A', 'E', 'I', 'O', 'U', 'a', 'e', 'i', 'o', 'u'),$footer);
				
				$footer2 = split("\n",$footer2);

				$parrafo = $footer2[8]." ".$footer2[9]
							." ".$footer2[10]." ".$footer2[11]." ".$footer2[12]." ".$footer2[13]." ".
							$footer2[14]." ".$footer2[15]." ".$footer2[16]." ".$footer2[17]." ".$footer2[18];
				
				$title = $obj->data->ticket->title;
				$logo = $obj->data->ticket->logo;
				$pin = $obj->data->pin;

				$detalles.= "".Chr(13).Chr(10);
				$detalles.= $transactionId.Chr(13).Chr(10);
				$detalles.= $authorizationCode.Chr(13).Chr(10);
				if($header != "")
					$detalles.= $header.Chr(13).Chr(10);
				if($Fecha != "")
					$detalles.= "Fecha ".$Fecha.Chr(13).Chr(10);
				if($Hora != "")
					$detalles.= "Hora ".$Hora.Chr(13).Chr(10);
				if($Aprobacion != "")
					$detalles.= "Aprobacion ".$Aprobacion.Chr(13).Chr(10);
				if($Numero != "")
					$detalles.= "Numero ".$Numero.Chr(13).Chr(10);
				if($Valor != "")
					$detalles.= "Valor ".$Valor.Chr(13).Chr(10);
				$detalles.= "".Chr(13).Chr(10);
				if($footer2[0] != "")
					$detalles.= $footer2[0] .Chr(13).Chr(10);
				if($footer2[1] != "")
					$detalles.= $footer2[1] .Chr(13).Chr(10);
				if($footer2[2] != "")
					$detalles.= $footer2[2] .Chr(13).Chr(10);
				if($footer2[3] != "")
					$detalles.= $footer2[3] .Chr(13).Chr(10);
				if($footer2[4] != "")
					$detalles.= $footer2[4] .Chr(13).Chr(10);
				if($footer2[5] != "")
					$detalles.= $footer2[5] .Chr(13).Chr(10);
				if($footer2[6] != "")
					$detalles.= $footer2[6] .Chr(13).Chr(10);
				if($parrafo != "")
					$detalles.= $parrafo .Chr(13).Chr(10);
				if($title != "")
					$detalles.= "Estado ".$title.Chr(13).Chr(10);
				//$detalles.= $logo.Chr(13).Chr(10);
				$detalles.= "Pin ".$pin.Chr(13).Chr(10);

		   }
		   
         }	  
           
		 //// SD : 001 Marzo 2015
		 //// Al usuario DOMICILIOS - Debe mostrar el Codigo de Barras del Producto
		 if($_SESSION['USERNAME'] == "DOMICILIOS")
		    $detalles.=	"Cod Barra: ".$row['codproducto'].Chr(13).Chr(10); 	     
	   }
	   else
	     $domix += $row['valparcial'];
     } 

	 $cont.= 'COMPROBANTE DE ENTREGA No. '.abs($numero).Chr(13).Chr(10);	 
	 $mostrarobs = $direnvio;
	 
	 if(strlen($mostrarobs)>3)
	 {
		   $dircli = "";
		   $observacionfactura .= strtoupper($mostrarobs).Chr(13).Chr(10);
		   $observacionfactura .= '------------------------------------------------';     	 
	 }

     $cont.= '------------------------------------------------'.Chr(13).Chr(10); 
	 $cont.= 'FECHA   : '.$fecha.'              Hora : '.$hora.Chr(13).Chr(10);	 
	 $cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
	 $cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);	 
	 if($dircli != "")   $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);	 
     $cont.= 'TELEFON : '.trim($telcli).Chr(13).Chr(10);
	 $cont.= '------------------------------------------------'.Chr(13).Chr(10); 
	 if($observacionfactura != "")   $cont.= 'DIRECCION : '.$observacionfactura.Chr(13).Chr(10);


	 $medicoid = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($medicoid != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT nommedico FROM medicos WHERE medicoid=".$medicoid);
		if($domi != "")
		{
			$cont.= 'MEDICO  : '.substr(strtoupper($domi),0,27).Chr(13).Chr(10);
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 
		}
	 }     	 
	 
	 if($teriddomi != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$teriddomi);
		if($domi != "")
		{
			$cont.= 'DOMICILIARIO : '.substr($domi,0,24).Chr(13).Chr(10);
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 
		}
	 }         
	 
     $cont.= 'VENDEDOR: '.$vendedor.Chr(13).Chr(10);	      
     $cont.= '------------------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'PRODUCTO Y/O SERVICIO        CAJ UNI       TOTAL'.Chr(13).Chr(10);
     $cont.= '------------------------------------------------'.Chr(13).Chr(10);     
	 $cont.= $detalles;	 
	 $cont.= '                                       ---------'.Chr(13).Chr(10);     
	 $cont.= '  TOTAL ESTE DOCUMENTO :     '.$nombremoneda.'   '.str_pad(number_format($total+$totaldescuento),16," ",STR_PAD_LEFT).Chr(13).Chr(10);     	 
	 $cont.= '                                       ========='.Chr(13).Chr(10);     
	 $cont.= '       SUBTOTAL            :      '.str_pad(number_format($subtotal+$totaldescuento-$domix),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       DESCUENTOS          :      '.str_pad(number_format($totaldescuento),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       DOMICILIO           :      '.str_pad(number_format($domix),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       TOTAL A PAGAR       :      '.str_pad(number_format($total),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '------------------------------------------------'.Chr(13).Chr(10);    
	 

	 /// Especifico el Medio de Pago de la Factura
	 $efectivo = $clase->SeleccionarUno("SELECT valorfp1 FROM docuventa WHERE docuid=".$docuid);	 
	 
	 //// Pongo una linea por Cada medio de Pago
	 if($efectivo > 0)
	    $cont.= 'EFECTIVO  '.str_pad(number_format($efectivo),38," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 	 
	 $tarjetas = $clase->SeleccionarUno("SELECT valorfp2 FROM docuventa WHERE docuid=".$docuid);	 
	 if($tarjetas > 0)
	     $cont.= 'TARJETAS DEB / CRED '.str_pad(number_format($tarjetas),28," ",STR_PAD_LEFT).Chr(13).Chr(10);
    
	 $transferencias = $clase->SeleccionarUno("SELECT valorfp3 FROM docuventa WHERE docuid=".$docuid);	 
	 if($transferencias > 0)
		$cont.= 'TRANSFERENCIA BANCAR '.str_pad(number_format($tarjetas),28," ",STR_PAD_LEFT).Chr(13).Chr(10);
	
	 $creditos = $clase->SeleccionarUno("SELECT valorfp4 FROM docuventa WHERE docuid=".$docuid);	 
	 if(($creditos > 0)&&($_SESSION['G_MODOTRABAJO'] == "SERVIDOR"))
	     $cont.= 'CREDITOS              '.str_pad(number_format($creditos),26," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 
     
	 $puntosRedi = $clase->SeleccionarUno("SELECT valorfp5 FROM docuventa WHERE docuid=".$docuid);	 
	 if($puntosRedi > 0)
	     $cont.= 'PUNTOS FARMANORTE REDIMIDOS '.str_pad(number_format($puntosRedi),20," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	
		
 	 $rappi = $clase->SeleccionarUno("SELECT valorfp6 FROM docuventa WHERE docuid=".$docuid);	 
	 if($rappi > 0)
		$cont.= 'CONVENIO RAPPI              '.str_pad(number_format($rappi),20," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	

	 $tienda = $clase->SeleccionarUno("SELECT valorfp7 FROM docuventa WHERE docuid=".$docuid);	 
	 if($tienda > 0)
		$cont.= 'PAGO VIRTUAL PSE EPAYCO     '.str_pad(number_format($tienda),20," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	
   		
  	 $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
	 
	 /// Consulto si hubo que dar vueltos 
	 $vueltos = $clase->BDLockup($docuid,'docuventa','docuid','vueltos');
	 if(($vueltos > 0)&&($efectivo > 0))
	 {
   	   $cont.= 'VUELTOS A ENTREGAR   '.str_pad(number_format($vueltos),27," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
	   $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
	 }
	  
	 /// Si Corresponde a una reimpresion de Factura lo coloca al Finalizar
	 if($reimpresion == "S")
		$cont.= Chr(13).Chr(10).'              * DUPLICADO *             '.Chr(13).Chr(10);

	  ///////////////////////////////////////////////////////////////////////////////////////////	
	  ////  Muestro la Barra de Participando .. si es Mayor a $ 40.000 Droguerias Farmanorte 
	  $formapago = $clase->BDLockup($docuid,"documentos","docuid","formapago");
	  if($formapago == "CO")
	  {
			if(($_SESSION['G_SUCURSALPOS'] == "127")||($_SESSION['G_SUCURSALPOS'] == "240")||($_SESSION['G_SUCURSALPOS'] == "241")||($_SESSION['G_SUCURSALPOS'] == "244")||($_SESSION['G_SUCURSALPOS'] == "265"))
			{
				/*
				if($total >= 50000)
				{
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
					$cont.= '   POR ESTA COMPRA, ESTAS PARTICIPANDO !!!      '.Chr(13).Chr(10);	   
					$cont.= '      >>   ANIVERSARIO FARMANORTE    <<           '.Chr(13).Chr(10);	   
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);      
				}
				*/
				$w++;
			}
			else
			{
				//////////////////////////////////////////////////////////////////////////////////////////
				//// Muestro la Barra de Participando .. si es Mayor a $ 25.000 Droguerias Farmanorte 
				$vsql5 = "SELECT COUNT(*)
							FROM dedocumentos DD INNER JOIN documentos D ON (DD.docuid = D.docuid) 
							INNER JOIN productos P ON (P.productoid = DD.productoid)
							INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid) 
							WHERE GP.concurso1 = 'CHECKED' AND D.docuid = ".$docuid;
				$tienepatrocinadores = $clase->SeleccionarUno($vsql5);         
				if(($tienepatrocinadores>0)&&($totalfv>=50000))
				{
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
					$cont.= '    POR ESTA COMPRA, ESTAS PARTICIPANDO !!!     '.Chr(13).Chr(10);	   
					$cont.= '      >>   ANIVERSARIO FARMANORTE    <<         '.Chr(13).Chr(10);	   
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);    
				}
			}
	  }

	 /*
     /// Muestro Los Puntos acumulados por el programa de Puntos Farmanorte
     $puntosacu = $clase->BDLockup($docuid,"docuventa","docuid","puntosacumulados");
     if($puntosacu > 0)
     {
        $clasex = new Sistema();
        if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR")
        {
           $clasex->ServidorBD = "192.168.14.244";
           $clasex->UsuarioBD  = "root";
           $clasex->ClaveBD    = "123";
           $clasex->NombreBD   = 'puntosfarmanorte';  
        } 
        else
        {
           $clasex->UsuarioBD  = $_SESSION['G_LOCALDBUSER'];
           $clasex->ClaveBD    = $_SESSION['G_LOCALDBPASS'];
           $clasex->NombreBD   = 'puntosfarmanorte';  
        }

        $totalpuntos = $clasex->SeleccionarUno("SELECT totalpuntos FROM afiliado WHERE documento = '".$nitcli."'");
     
        $cont.= '***   PROGRAMA PUNTOS FARMANORTE   ****'.Chr(13).Chr(10);     	  
        $cont.= ' Ud Acumulo '.number_format($puntosacu).' puntos en esta compra!'.Chr(13).Chr(10);     	 
        $cont.= '>> Visite : www.puntosfarmanorte.com <<'.Chr(13).Chr(10);     	 
        $cont.= '************************************************'.Chr(13).Chr(10);
     }
     if(($_SESSION['G_SUCURSALPOS'] == "14")&&($total>=20000))
     {
        $cont.= Chr(13).Chr(10);
        $cont.= '************************************************'.Chr(13).Chr(10);     	 
        $cont.= '***          DESCUENTO DEL IVA SEGUN        ****'.Chr(13).Chr(10);     	  
        $cont.= '***           DECRETO 1818 DE 2015          ****'.Chr(13).Chr(10);     	 
        $cont.= '************************************************'.Chr(13).Chr(10).Chr(13).Chr(10);
     }
     */
/*	 
	 /// Participacion en el Concurso de Horno Farmanorte 14
	 if(($total>=20000)&&(trim($nitcli) != '99') && ($_SESSION['G_SUCURSALPOS']=='14'))
     {
     	$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
		$cont.= 'POR ESTA COMPRA, PARTICIPAS!! RIFA DE UN HORNO !'.Chr(13).Chr(10);	   
	    $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
	 }	 
*/
     /*
     if(($puntosRedi > 0))
	 {
          $leyenda = "Autorizo descontar de mis puntos Acumulados del Programa Puntos farmanorte como Medio de Pago de esta Venta.".Chr(13).Chr(10).Chr(13).Chr(10);          
          $leyenda.= "El Afiliado,".Chr(13).Chr(10).Chr(13).Chr(10);
          $leyenda.= "__________________________".Chr(13).Chr(10);
          $leyenda.= "C.C. ".Chr(13).Chr(10);                    
         
          $cont.= Chr(13).Chr(10).$leyenda.Chr(13).Chr(10);
	 }*/

     //// Si la Factura es Credito - Le Coloco la Leyenda
	 $empleado    = $clase->BDLockup($nitcli,'terceros','dni','esempleado');
	 $diascredito = $clase->BDLockup($nitcli,'terceros','dni','diascxc');
	 if(($creditos > 0)&&(strlen($empleado)>0))
	 {
		 $leyenda = "Por medio del presente escrito autorizo a la empresa DROMEDICAS DEL ORIENTE SAS, identificada con NIT 900265730-0, voluntariamente y sin coacción alguna descontar de mi salario la suma total de esta factura, esto para cancelación de la deuda generada actualmente con la ejecución del presente crédito y cabe aclarar que en caso de retiro descontar de mi liquidación de Prestaciones Sociales los saldos que se encuentren pendientes por pagar, de acuerdo con lo contemplado en los Art. 150 y 344 del Código Sustantivo del Trabajo".Chr(13).Chr(10).Chr(13).Chr(10);          $leyenda.= "El Empleado,".Chr(13).Chr(10).Chr(13).Chr(10);
		 $leyenda.= "__________________________".Chr(13).Chr(10);
		 $leyenda.= "C.C. ".Chr(13).Chr(10);                    
         
		 $cont.= Chr(13).Chr(10).$leyenda.Chr(13).Chr(10);
	 }
	 else
	 {
		 ////// Si es crédito pero no es para EMPLEADO 
		 if($creditos > 0)
	     {
		     $fecvence = $clase->SeleccionarUno("SELECT DATE_ADD( fechadoc, INTERVAL ".$diascredito." DAY )  FROM documentos D WHERE docuid=".$docuid);		   
			 $leyenda = "FORMA DE PAGO CREDITO CLIENTE AUTORIZADO".Chr(13).Chr(10); 
			 $leyenda.= "PLAZO : ".$diascredito." Dias".Chr(13).Chr(10);
			 $leyenda.= "FECHA VENCIMIENTO : ".substr($fecvence,0,10).Chr(13).Chr(10);
			 $leyenda.= '-----------------------------------------------'.Chr(13).Chr(10);
			 $cont.= $leyenda.Chr(13).Chr(10); 
	 	 } 
		 
		  /// Muestro los Pie de Pagina
	     if($pie1!= "")
	       $cont.= $pie1.Chr(13).Chr(10);
	    /*
		 if($pie2!= "")
	       $cont.= $pie2.Chr(13).Chr(10);
	     if($pie3!= "")
	       $cont.= $pie3.Chr(13).Chr(10);
	     if($pie4!= "")
	       $cont.= $pie4.Chr(13).Chr(10);
	     if($pie5!= "")
	       $cont.= $pie5.Chr(13).Chr(10);	
		 
		 if(($_SESSION['G_SUCURSALPOS'] != "240")&&($_SESSION['G_SUCURSALPOS'] != "241"))  
		 {
			 //// Aviso de Facturacion Electronica
			 $cont.= "Si requiere FACTURA ELECTRONICA de esta compra, ".Chr(13).Chr(10);
			 $cont.= "puede solicitarla escribiendo un correo a  ".Chr(13).Chr(10);
			 $cont.= "facturacionfarmanorte@gmail.com ".Chr(13).Chr(10);
			 $cont.= "adjuntando el RUT y el numero de esta factura ( ".$prefijo.$numero." )".Chr(13).Chr(10);
			 $cont.= "Aplica a partir del 1 de Noviembre de 2021.".Chr(13).Chr(10);
			 $cont.= Chr(13).Chr(10);
		 }

	     /// Aviso Sugerencias
		 $cont.= "  Sugerencias o Recomendaciones a  ".Chr(13).Chr(10);	

		 $cadena = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","cadenaid");
		 if($cadena == 1)
		    $cont.= " servicioalcliente@farmanorte.com.co ".Chr(13).Chr(10);		
		 else
		    $cont.= " servicioalcliente@drogueriasguasimales.com".Chr(13).Chr(10);	
*/
		//// Aviso de NO se Aceptan Devoluciones
		$cont.= "  >>>>  NO SE ACEPTAN DEVOLUCIONES <<<<  ".Chr(13).Chr(10);
		$cont.= "SU FACTURA ELECTRONICA HA SIDO ENVIADA A : ".Chr(13).Chr(10);
		$cont.= "  ".$emailcliente.Chr(13).Chr(10);

        //// Finalmente le coloco el Pie de Pagina y los espacios de Separacion
		$cont.= ' DROPOS ERP - DROPOS SAS - NIT 901191107-6'.Chr(13).Chr(10);   

	 }
/*
		/// Participacion en el Concurso de Aniversario
		$formapago = $clase->BDLockup($docuid,'documentos','docuid','formapago');
		if(($total>=30000)&&(trim($nitcli) != '99')&&($formapago == 'CO'))
		{
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
			$cont.= '   POR ESTA COMPRA, ESTAS PARTICIPANDO !!!      '.Chr(13).Chr(10);	   
			$cont.= '      >>    ANIVERSARIO FARMANORTE     <<       '.Chr(13).Chr(10);	   
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
		} 	 
*/
		$cadenaid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","cadenaid");
		if($cadenaid == 1) /// Si es Farmanorte
		{
			$acumulopuntos = 0+$clase->BDLockup($docuid,"acumulacionespuntos","docuid","puntosacumulados");
			if($acumulopuntos>1)
			{
				$nuevosaldopuntos = 0+$clase->BDLockup($docuid,"acumulacionespuntos","docuid","nuevosaldopuntos");
				$puntosxvencer    = 0+$clase->BDLockup($docuid,"acumulacionespuntos","docuid","puntosxvencer");
				/*
				$idcampa          = $clase->BDLockup($docuid,"acumulacionespuntos","docuid","idcampa");
               
				if($idcampa>0)
				{
					$cont.= ">>> ESTAS PARTICIPANDO CON ESTA FACTURA <<<".Chr(13).Chr(10);
				}
				*/

				$cont.= Chr(13).Chr(10);
				$cont.= "PUNTOS EN ESTA COMPRA : ".$acumulopuntos." PUNTOS".Chr(13).Chr(10);
				$cont.= "TOTAL PUNTOS ACUMULADOS : ".$nuevosaldopuntos." PUNTOS".Chr(13).Chr(10);
				$cont.= "PUNTOS A VENCER : ".$puntosxvencer." PUNTOS".Chr(13).Chr(10);				
			}
		}    
 
     //// Separadores y Corte de Hoja
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.'.Chr(13).Chr(10);   
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D"; 
	 
     // Como mecanismo de Seguridad, guardo en el Dropbox copia de la Tira
     $archivo= "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/Impresora/Imp-".date("mY").".txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a");   // Abres el archivo para escribir en él
     fwrite($fch, $cont);           // Grabas
     fclose($fch);                  // Cierras el archivo

	 ////////////////////////////////////////////////
	 // Genero el Archivo para Enviarlo a Impresora
	 if($autoprint != 'N')
     	 $archivo= "../Dropbox/".$autoprint."/autoprint/autoprint-factura-".rand(11111,99999).".txt"; // el nombre de tu archivo
     else
     {	
       // Genero el Archivo para Enviarlo a Impresora
       if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR") 
       {
          $codImpre = $clase->BDLockup($_SESSION['USERNAME'],"usuarios","username","codimpresora");
          if(strlen($codImpre)>0) 	
          {	
             $rutaImpresion = $clase->BDLockup($codImpre,"impresoras","codigo","ruta");
     	     $archivo= "../../Dropbox/00/".$rutaImpresion."/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
          }
          else 
             $archivo= "../../Dropbox/00/print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
       }	 
       else  /// En Droguerias Imprime ahi
	   {
           $caja = $clase->BDLockup($docuid,"docuventa","docuid","cajaid"); 
		   $caja = 1; 
		   if($caja == 1)
		   {
				//// Imprimo el Cierre
				$tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
				if($tipo == "G")
				{
					/// 1. Le Aplico Permisos a la Carpeta PDF
					chmod($acceso."print/", 0777);
					/// 2. Genero la Impresion  
				    $archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
					$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
					fwrite($fch, $cont); // Grabas
					fclose($fch); // Cierras el archivo					
					/// 3. Le Aplico Permisos al archivo
					chmod("print/imprimircierre.txt", 0777);					
				}
				else
				{
					$archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
					$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
					fwrite($fch, $cont); // Grabas
					fclose($fch); // Cierras el archivo					
				}		       
		   }
		   else
		   {
			   $rutaprint = $clase->BDLockup($caja,"cajasdecobro","cajaid","rutaprint");
			   $archivo   = $rutaprint."/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
			   $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			   fwrite($fch, $cont); // Grabas
			   fclose($fch); // Cierras el archivo
		   }	
	   }
     }

     

    if($autoprint == 'N')
    {	
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("my")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 /// La marco en la Base de datos como Impresa
     $clase->EjecutarSQL("UPDATE documentos SET impreso = 'S' WHERE docuid=".$docuid);
     $clase->EjecutarSQL("UPDATE docuventa SET impreso = CURRENT_TIMESTAMP WHERE docuid=".$docuid);

	 /*
	 //// Si es un Credito a Empleados - Imprime copia
	 $formapago = $clase->SeleccionarUno("SELECT formapago FROM documentos WHERE docuid=".$docuid);
	 if($formapago == 'CR')
	 {   
     	$archivo= "print/facturacopia1.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	*/
	
	 //// Si el Medio de Pago es Tarjetas - Imprimo la Copia de la Factura
	 $estarje = $clase->SeleccionarUno("SELECT valorfp2 + valorfp3 FROM docuventa WHERE docuid=".$docuid);
	 if($estarje > 0)
	 {   
		$caja = $clase->BDLockup($docuid,"docuventa","docuid","cajaid"); 
		if($caja == 1)
		{
			//// Imprimo el Cierre
			$tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
			if($tipo == "G")
			{
				/// 1. Le Aplico Permisos a la Carpeta PDF
				chmod($acceso."print/", 0777);
				/// 2. Genero la Impresion  
				$archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
				$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
				fwrite($fch, $cont); // Grabas
				fclose($fch); // Cierras el archivo					

				/// 3. Le Aplico Permisos al archivo
				chmod("print/imprimircierre.txt", 0777);					
			}
			else
			{
				$archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
				$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
				fwrite($fch, $cont); // Grabas
				fclose($fch); // Cierras el archivo					
			}	
		}			
		else
		{
			$rutaprint = $clase->BDLockup($caja,"cajasdecobro","cajaid","rutaprint");
			$archivo   = $rutaprint."/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
		}
     	
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
        /*
		if(($_SESSION['G_SUCURSALPOS'] == "240")||($_SESSION['G_SUCURSALPOS'] == "241"))
		{
			$archivo= "print/facturacopia2.txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
			fclose($fch); // Cierras el archivo
		}
		*/
	 }

	 //// Si es Empresa de Mensajeria Imprime una Copia
	 $mensajero = $clase->SeleccionarUno("SELECT T.codigo FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid3) WHERE D.docuid = ".$docuid);
	 if($mensajero == "999")
	 {   
		$caja = $clase->BDLockup($docuid,"docuventa","docuid","cajaid");
		if($caja == 1)
		{
			//// Imprimo el Cierre
			$tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
			if($tipo == "G")
			{
				/// 1. Le Aplico Permisos a la Carpeta PDF
				chmod($acceso."print/", 0777);
				/// 2. Genero la Impresion  
				$archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
				$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
				fwrite($fch, $cont); // Grabas
				fclose($fch); // Cierras el archivo					

				/// 3. Le Aplico Permisos al archivo
				chmod("print/imprimircierre.txt", 0777);					
			}
			else
			{
				$archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
				$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
				fwrite($fch, $cont); // Grabas
				fclose($fch); // Cierras el archivo					
			}	
		}			
		else
		{
			$rutaprint = $clase->BDLockup($caja,"cajasdecobro","cajaid","rutaprint");
			$archivo   = $rutaprint."/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
		}

        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo

		/// Si es la Farmanorte 241 - Imprima otra copia
		if($_SESSION['G_SUCURSALPOS'] == "241")
		{
			$archivo= "print/facturacopiaxmensajeria2.txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
			fclose($fch); // Cierras el archivo
		}
	 }
	 
	 /*
	 //// Si es una Formula Medica enviada para CloseUp 
	 $esmedico = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($esmedico!=0)
	 {   
     	$archivo= "print/facturacopia2.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	 */

	 /*
	 //// Si es una Formula Medica enviada para CloseUp 
	 $esmedico = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($esmedico!=0)
	 {   
     	$archivo= "print/facturacopia2.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	 */
	 
	 /*
	 //// Si redimió Puntos en esta Venta - Otra Copia
	 if($puntosRedi != 0)
	 {   
     	$archivo= "print/facturacopia5.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }*/

	 //// Si alguno de los productos que se facturan tiene Beneficio - Debe Imprimir una copia 
	 /*
	 $vsqlaux="SELECT COUNT(*) FROM dedocumentos DD INNER JOIN productos P ON ( P.productoid = DD.productoid ) 
			   WHERE P.recambio = 'CHECKED' AND DD.docuid =".$docuid;
	 $beneficio = $clase->SeleccionarUno($vsqlaux);
	 if($beneficio > 0)
	 {   
     	$archivo= "print/facturacopia3.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	 */
	 
	 //// Marco la Factura como Impresa
	 $clase->EjecutarSQL("UPDATE documentos SET impreso = 'S' WHERE docuid=".$docuid);

	 //// Si la factura es de Domicilio mando a imprimir el Ticket de mensajeria
	 //// Si la Sucursal tiene callcenter se debe Imprimir una copia mas de las Ventas a domicilio
	 $esdomi = $clase->SeleccionarUno("SELECT terid3 FROM documentos WHERE docuid=".$docuid);
	 if($esdomi!=1)
	 {
		 ImpresionTiraMensajeria($docuid);	    
		 /*<
		 $callcenter = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","callcenter");
		 if($callcenter == "CHECKED")
		 {
			 $archivo= "print/facturacopia4.txt"; // el nombre de tu archivo
			 $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			 fwrite($fch,Chr(13).Chr(10).$cont);  // Grabas
			 fclose($fch); // Cierras el archivo
		 }
		 */		   
	 }

	 /////////////////  ANIVERSARIO FARMANORTE  /////////////////////////////////  
	 //// Para las Ventas Superiores a $ 30.000 - Se Genera el Ticket de la Rifa
	
	//  if(($total>=20000)&&(trim($nitcli) != '99') && ($_SESSION['G_SUCURSALPOS']=='102'))
	//  {
	// 	 $sucursal = $clase->SeleccionarUno("SELECT S.descripcion FROM sucursales S INNER JOIN documentos D ON (D.sucursalid = S.sucursalid) WHERE D.docuid = ".$docuid);
	// 	 TiqueteRifa($cliente , $telcli , $dircli , $sucursal);
	//  }


	 
	
	 ///// Rifa Lavadora Entre CLIENTES
	//  if(($total>=20000)&&(trim($nitcli) != '99'))
	//  {
	// 	$sucursal = $clase->SeleccionarUno("SELECT S.descripcion FROM sucursales S INNER JOIN documentos D ON (D.sucursalid = S.sucursalid) WHERE D.docuid = ".$docuid);
	// 	$codsuc   = $clase->SeleccionarUno("SELECT S.codigo FROM sucursales S INNER JOIN documentos D ON (D.sucursalid = S.sucursalid) WHERE D.docuid = ".$docuid);
	// 	$diasrifa = $clase->SeleccionarUno("SELECT DATEDIFF('2019-12-20',CURRENT_DATE)");
	// 	if(($diasrifa<=61)&&($diasrifa>=0)&&(($codsuc == "58")||($codsuc == "59")||($codsuc == "60")||($codsuc == "67")||($codsuc == "07")))
	// 	  TiqueteRifa2($cliente , $telcli , $dircli , $sucursal);
	//  }
	
	 return(true);	
	}	
	
  } // Fin de la Funcion

  
    ////////////////////////////////////////////////////////////////////// 
  ////  NUEVO FORMATO 2018 - IMPRESORAS TERMICAS 
  ////////////////////////////////////////////////////////////////////// 
  function ImpresionPOSFactura6($docuid,$autoprint='N',$reimpresion='N')
  {
     $clase = new Sistema();	 
	 $detalles = "";       $nombremoneda = "";
  	 $cont = "";

     $nombremoneda = @$_SESSION['G_MONEDALOCAL'];
	 $asentada = $clase->BDLockup($docuid,'documentos','docuid','fecasentado');
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
     $cont.= $nomempresa.Chr(13).Chr(10);	 
	 //$cont.= 'SOMOS RESPONSABLES DEL IVA'.Chr(13).Chr(10);
	 //$cont.= 'SOMOS AUTORRETENEDORES DEL ICA'.Chr(13).Chr(10);

	 $cont.= 'SOMOS RESPONSABLES DEL IVA E ICA'.Chr(13).Chr(10);	 

	 /// Cargo las configuraciones del Prefijo del Documento
	 $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	 $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");	  
	 
  	 $txtbolsas = "Ley 1819 de 2016 INC Bolsas Plasticas";

	 /// Datos de la Resolucion
	 $obs2 = $clase->BDLockup($docuid,"documentos","docuid","observacion2");	 
	 $direnvio = $clase->BDLockup($docuid,"docuventa","docuid","direnvio");	 

	 $sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');
	 $fechafactura = $clase->BDLockup($docuid,'documentos','docuid','CAST(fechadoc as DATE)');
	 $vsqlres = "SELECT * FROM resolucionesdian WHERE sucursalid = '".$sucursalid."' AND numini <= '".$numero."' AND numfin >= '".$numero."' 
				 AND fecdesde <= '".$fechafactura."' AND fechasta >= '".$fechafactura."' ORDER BY resid DESC LIMIT 0,1";
	 $conex  = $clase->Conectar();
	 $result = @mysql_query($vsqlres,$conex);
	 $txtresol = "";
	 if($row = @mysql_fetch_array($result)) 
		$txtresol = "AUTOR NUMER DE FACT No ".$row['numeroaut']." FECHA: ".$row['fecdesde']." VIGENCIA ".$row['meses'].
					" MESES Prefijo (".$row['prefijo'].") NUM AUT del ".number_format($row['numini'])." al ".number_format($row['numfin']);      
  
	 if(strlen($txtresol) == 0)
		$txtresol  = $clase->SeleccionarUno("SELECT txtresolucion FROM consecutivos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'");

     $vsql = "SELECT * FROM consecutivos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 if($row = @mysql_fetch_array($result))
	 {
		$cadenaid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","cadenaid");
		if($cadenaid == 1)
			$encab1 = "DROGUERIA FARMANORTE";
		else
			$encab1 = "DROGUERIA GUASIMALES";	
			
		$encab2 = $row['encab2'];	
		$encab3 = $row['encab3'];				    
		$encab4 = $row['encab4'];				    
		$encab5 = $row['encab5'];				    			    
			
		$pie1 = $row['pie1'];	    
		$pie2 = $row['pie2'];	    
		$pie3 = $row['pie3'];	    
		$pie4 = $row['pie4'];	    
		$pie5 = $row['pie5'];	 
		
		$txtres = $txtresol;	    
	}    
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , DD.observalinea , 
	  		  T.dni codcliente , D.terid2 , D.terid3 , CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , P.precio1m , 
			  T.telmovil , GP.descripcion nomlabo , P.codigo codproducto , P.factor1 , P.porciva , DD.docuref , P.descripcion nomproducto , DD.valunitario , DD.valdescuento , 
			  SUM(DD.unicom) cajas , SUM(DD.unifra) unidades , SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27     
			  ORDER BY DD.dedocumid ASC";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
     
	 if($encab1!= "")
       $cont.= $encab1.Chr(13).Chr(10);
	 if($encab2!= "")
	   $cont.= $encab2.Chr(13).Chr(10);
 	 if($encab3!= "")
	   $cont.= $encab3.Chr(13).Chr(10);
 	 if($encab4!= "")
	   $cont.= $encab4.Chr(13).Chr(10);
 	 if($encab5!= "")
	   $cont.= $encab5.Chr(13).Chr(10);	 	 	 	 
	 
	 $teriddomi = "";  $domix = 0;
	 $condecreto = 0;  $totaldescuento = 0;
	 while($row = @mysql_fetch_array($result))
	 { 
 	   /// Nombre del Archivo para la Sincronizacion
	   $nombredoc = $row['tipodoc'].$row['prefijo'].abs($row['numero']); 
	   	   
	   $teriddomi = $row['terid3'];
	   $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
 	   
	   $subtotal = $row['base']; 
	   $iva      = $row['iva']; 	   
	   $total    = $row['total']; 

  	   $cliente  = substr($row['nomcliente'],0,24); 

   	   $nitcli   = $row['dni']; 	   
   	   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   
   	   $dircli   = $row['direccion']; 	   	   
   	   
       if($row['docuref'] == "*")
         $condecreto ++;
	   
	   $vend = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid2']);
	   $vendedor = substr($vend,0,27); 

	   if($row['codproducto'] != 'DO')
	   {
 	     $valdcto = ($row['valparcial']*($row['valdescuento']/100));

 	     $detalles.= str_pad(substr($row['nomproducto'],0,23),23," ",STR_PAD_RIGHT).'  ';
		 $detalles.= str_pad($row['cajas'],3," ",STR_PAD_LEFT).' '.str_pad($row['unidades'],3," ",STR_PAD_LEFT).'  ';
		 $detalles.= str_pad($row['porciva'],3," ",STR_PAD_LEFT).'  ';
		 
         if(strlen($row['observalinea'])>0)
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format((($row['cajas']*$row['factor1'])+$row['unidades'])*$row['valunitario']),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['cajas']*$row['precio1m'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	   
         }	
         else
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format(($row['valparcial'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['valparcial'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   	
         }	
		 
		 
		 if(($_SESSION['USERNAME'] == "VENTASPBX")||($obs2!=""))
		    $detalles.= "Cod. Barra : ".$row['codproducto']."   Lab: ".substr($row['nomlabo'],0,10).Chr(13).Chr(10); 	  

         if($valdcto>0)
          	$totaldescuento += $valdcto;
                  
         //// Adaptacion para las Recargas
         //// Muestra el Operador y el Numero a realizar la transaccion
         if(($row['codproducto'] == "R1000")||($row['codproducto'] == "R1001")) 
         {
           $vsqlx = "SELECT CONCAT('Num : ',T.numrecarga,' Operad : ', O.nomoperador) 
                     FROM transarecargas T INNER JOIN operadorcel O ON (T.codoperador = O.codoperador)
					 WHERE T.idfactura = ".$docuid." ORDER BY transaid DESC LIMIT 0,1";
           $datoRecarga = $clase->SeleccionarUno($vsqlx);
           $detalles   .= $datoRecarga.Chr(13).Chr(10);

		   $vsqlz= "SELECT observacion3 FROM documentos WHERE docuid=".$docuid;
		   $obsrv3 = $clase->SeleccionarUno($vsqlz);

		   if($obsrv3 != "")
		   {
				$jsonResponse2=$_SESSION['TICKEDRECARGAS'];
				$obj = json_decode($jsonResponse2); 
				$transactionId = $obj->data->transactionId;
				$authorizationCode = $obj->data->authorizationCode;
				$header = $obj->data->ticket->header;
				$Fecha = $obj->data->ticket->body->Fecha;
				$Hora = $obj->data->ticket->body->Hora;
				$Aprobacion = $obj->data->ticket->body->Aprobacion;
				$Numero = $obj->data->ticket->body->Numero;
				$Valor = $obj->data->ticket->body->Valor;
				$footer = $obj->data->ticket->footer;
				//$vacoles = (array)['Á',];
				
				$footer2 = str_replace(array('Á', 'É', 'Í', 'Ó', 'Ú', 'á', 'é', 'é', 'ó', 'ú'),array('A', 'E', 'I', 'O', 'U', 'a', 'e', 'i', 'o', 'u'),$footer);
				
				$footer2 = split("\n",$footer2);

				$parrafo = $footer2[8]." ".$footer2[9]
							." ".$footer2[10]." ".$footer2[11]." ".$footer2[12]." ".$footer2[13]." ".
							$footer2[14]." ".$footer2[15]." ".$footer2[16]." ".$footer2[17]." ".$footer2[18];
				
				$title = $obj->data->ticket->title;
				$logo = $obj->data->ticket->logo;
				$pin = $obj->data->pin;

				$detalles.= "".Chr(13).Chr(10);
				$detalles.= $transactionId.Chr(13).Chr(10);
				$detalles.= $authorizationCode.Chr(13).Chr(10);
				if($header != "")
					$detalles.= $header.Chr(13).Chr(10);
				if($Fecha != "")
					$detalles.= "Fecha ".$Fecha.Chr(13).Chr(10);
				if($Hora != "")
					$detalles.= "Hora ".$Hora.Chr(13).Chr(10);
				if($Aprobacion != "")
					$detalles.= "Aprobacion ".$Aprobacion.Chr(13).Chr(10);
				if($Numero != "")
					$detalles.= "Numero ".$Numero.Chr(13).Chr(10);
				if($Valor != "")
					$detalles.= "Valor ".$Valor.Chr(13).Chr(10);
				$detalles.= "".Chr(13).Chr(10);
				if($footer2[0] != "")
					$detalles.= $footer2[0] .Chr(13).Chr(10);
				if($footer2[1] != "")
					$detalles.= $footer2[1] .Chr(13).Chr(10);
				if($footer2[2] != "")
					$detalles.= $footer2[2] .Chr(13).Chr(10);
				if($footer2[3] != "")
					$detalles.= $footer2[3] .Chr(13).Chr(10);
				if($footer2[4] != "")
					$detalles.= $footer2[4] .Chr(13).Chr(10);
				if($footer2[5] != "")
					$detalles.= $footer2[5] .Chr(13).Chr(10);
				if($footer2[6] != "")
					$detalles.= $footer2[6] .Chr(13).Chr(10);
				if($parrafo != "")
					$detalles.= $parrafo .Chr(13).Chr(10);
				if($title != "")
					$detalles.= "Estado ".$title.Chr(13).Chr(10);
				//$detalles.= $logo.Chr(13).Chr(10);
				$detalles.= "Pin ".$pin.Chr(13).Chr(10);

		   }
		   
         }	  
           
		 //// SD : 001 Marzo 2015
		 //// Al usuario DOMICILIOS - Debe mostrar el Codigo de Barras del Producto
		 if($_SESSION['USERNAME'] == "DOMICILIOS")
		    $detalles.=	"Cod Barra: ".$row['codproducto'].Chr(13).Chr(10); 	     
	   }
	   else
	     $domix += $row['valparcial'];
     } 

	 $cont.= 'SISTEMA POS - DOC EQUIVALENTE No. '.$prefijo.' '.abs($numero).Chr(13).Chr(10);
	 $cont.= $txtres.Chr(13).Chr(10);	 	 	
	// $cont.= $txtbolsas.Chr(13).Chr(10);
	// $cont.= "ID Transaccion Auditoria : ".str_pad($docuid,10, "0", STR_PAD_LEFT).Chr(13).Chr(10);
	 
	 //// Se Incluye el Serial de la Impresora 
	 if($_SESSION['G_SERIALIMPRESORA'] != "")
	    $cont.= 'IMPRESORA FISCAL SERIAL : '.$_SESSION['G_SERIALIMPRESORA'].Chr(13).Chr(10);          

	 $mostrarobs = $direnvio;
	 if(strlen($mostrarobs)>3)
	 {
		   $dircli = "";
		   $observacionfactura .= strtoupper($mostrarobs).Chr(13).Chr(10);
		   $observacionfactura .= '------------------------------------------------';     	 
	 }

     $cont.= '------------------------------------------------'.Chr(13).Chr(10); 
	 $cont.= 'FECHA   : '.$fecha.'              Hora : '.$hora.Chr(13).Chr(10);	 
	 $cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
	 $cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);	 
	 if($dircli != "")   $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);	 
     $cont.= 'TELEFON : '.trim($telcli).Chr(13).Chr(10);
     $cont.= '------------------------------------------------'.Chr(13).Chr(10);      
	 if($observacionfactura != "")   $cont.= 'DIRECCION ENTREGA : '.$observacionfactura.Chr(13).Chr(10);

	 $medicoid = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($medicoid != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT nommedico FROM medicos WHERE medicoid=".$medicoid);
		if($domi != "")
		{
			$cont.= 'MEDICO  : '.substr(strtoupper($domi),0,27).Chr(13).Chr(10);
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 
		}
	 }     	 
	 
	 if($teriddomi != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$teriddomi);
		if($domi != "")
		{
			$cont.= 'DOMICILIARIO : '.substr($domi,0,24).Chr(13).Chr(10);
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 
		}
	 }         
	 
     $cont.= 'VENDEDOR: '.$vendedor.Chr(13).Chr(10);	      
     $cont.= '------------------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'PRODUCTO Y/O SERVICIO    CAJ UNI  IVA      TOTAL'.Chr(13).Chr(10);
     $cont.= '------------------------------------------------'.Chr(13).Chr(10);     
	 $cont.= $detalles;	 
	 $cont.= '                                       ---------'.Chr(13).Chr(10);     
	 $cont.= '  TOTAL FACTURA CON IMPUESTOS'.$nombremoneda.'   '.str_pad(number_format($total+$totaldescuento),16," ",STR_PAD_LEFT).Chr(13).Chr(10);     	 
	 $cont.= '                                       ========='.Chr(13).Chr(10);     
	 $cont.= '       SUBTOTAL            :      '.str_pad(number_format($subtotal+$totaldescuento-$domix),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       DESCUENTOS          :      '.str_pad(number_format($totaldescuento),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       I.V.A               :      '.str_pad(number_format($iva),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       DOMICILIO           :      '.str_pad(number_format($domix),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       TOTAL A PAGAR       :      '.str_pad(number_format($total),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '------------------------------------------------'.Chr(13).Chr(10);    
	 

	 /// Especifico el Medio de Pago de la Factura
	 $efectivo = $clase->SeleccionarUno("SELECT valorfp1 FROM docuventa WHERE docuid=".$docuid);	 
	 
	 //// Pongo una linea por Cada medio de Pago
	 if($efectivo > 0)
	    $cont.= 'EFECTIVO  '.str_pad(number_format($efectivo),38," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 	 
	 $tarjetas = $clase->SeleccionarUno("SELECT valorfp2 FROM docuventa WHERE docuid=".$docuid);	 
	 if($tarjetas > 0)
	     $cont.= 'TARJETAS DEB / CRED '.str_pad(number_format($tarjetas),28," ",STR_PAD_LEFT).Chr(13).Chr(10);
    
	 $transferencias = $clase->SeleccionarUno("SELECT valorfp3 FROM docuventa WHERE docuid=".$docuid);	 
	 if($transferencias > 0)
		$cont.= 'TRANSFERENCIA BANCAR '.str_pad(number_format($tarjetas),28," ",STR_PAD_LEFT).Chr(13).Chr(10);
	
	 $creditos = $clase->SeleccionarUno("SELECT valorfp4 FROM docuventa WHERE docuid=".$docuid);	 
	 if(($creditos > 0)&&($_SESSION['G_MODOTRABAJO'] == "SERVIDOR"))
	     $cont.= 'CREDITOS              '.str_pad(number_format($creditos),26," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 
     
	 $puntosRedi = $clase->SeleccionarUno("SELECT valorfp5 FROM docuventa WHERE docuid=".$docuid);	 
	 if($puntosRedi > 0)
	     $cont.= 'PUNTOS FARMANORTE REDIMIDOS '.str_pad(number_format($puntosRedi),20," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 
   		
  	 $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
	 
	 /// Consulto si hubo que dar vueltos 
	 $vueltos = $clase->BDLockup($docuid,'docuventa','docuid','vueltos');
	 if(($vueltos > 0)&&($efectivo > 0))
	 {
   	   $cont.= 'VUELTOS A ENTREGAR   '.str_pad(number_format($vueltos),27," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
	   $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
	 }
	  
	 /// Si Corresponde a una reimpresion de Factura lo coloca al Finalizar
	 if($reimpresion == "S")
		$cont.= Chr(13).Chr(10).Chr(13).Chr(10).'              * DUPLICADO *             '.Chr(13).Chr(10);

	  ///////////////////////////////////////////////////////////////////////////////////////////	
	  ////  Muestro la Barra de Participando .. si es Mayor a $ 40.000 Droguerias Farmanorte 
	  $formapago = $clase->BDLockup($docuid,"documentos","docuid","formapago");
	  if($formapago == "CO")
	  {
			if(($_SESSION['G_SUCURSALPOS'] == "127")||($_SESSION['G_SUCURSALPOS'] == "240")||($_SESSION['G_SUCURSALPOS'] == "241")||($_SESSION['G_SUCURSALPOS'] == "244")||($_SESSION['G_SUCURSALPOS'] == "265"))
			{
				/*
				if($total >= 50000)
				{
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
					$cont.= '   POR ESTA COMPRA, ESTAS PARTICIPANDO !!!      '.Chr(13).Chr(10);	   
					$cont.= '      >>   ANIVERSARIO FARMANORTE    <<           '.Chr(13).Chr(10);	   
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);      
				}
				*/
				$w++;
			}
			else
			{
				//////////////////////////////////////////////////////////////////////////////////////////
				//// Muestro la Barra de Participando .. si es Mayor a $ 25.000 Droguerias Farmanorte 
				$vsql5 = "SELECT COUNT(*)
							FROM dedocumentos DD INNER JOIN documentos D ON (DD.docuid = D.docuid) 
							INNER JOIN productos P ON (P.productoid = DD.productoid)
							INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid) 
							WHERE GP.concurso1 = 'CHECKED' AND D.docuid = ".$docuid;
				$tienepatrocinadores = $clase->SeleccionarUno($vsql5);         
				if(($tienepatrocinadores>0)&&($totalfv>=50000))
				{
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
					$cont.= '    POR ESTA COMPRA, ESTAS PARTICIPANDO !!!     '.Chr(13).Chr(10);	   
					$cont.= '      >>   ANIVERSARIO FARMANORTE    <<         '.Chr(13).Chr(10);	   
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);    
				}
			}
	  }

	 /*
     /// Muestro Los Puntos acumulados por el programa de Puntos Farmanorte
     $puntosacu = $clase->BDLockup($docuid,"docuventa","docuid","puntosacumulados");
     if($puntosacu > 0)
     {
        $clasex = new Sistema();
        if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR")
        {
           $clasex->ServidorBD = "192.168.14.244";
           $clasex->UsuarioBD  = "root";
           $clasex->ClaveBD    = "123";
           $clasex->NombreBD   = 'puntosfarmanorte';  
        } 
        else
        {
           $clasex->UsuarioBD  = $_SESSION['G_LOCALDBUSER'];
           $clasex->ClaveBD    = $_SESSION['G_LOCALDBPASS'];
           $clasex->NombreBD   = 'puntosfarmanorte';  
        }

        $totalpuntos = $clasex->SeleccionarUno("SELECT totalpuntos FROM afiliado WHERE documento = '".$nitcli."'");
     
        $cont.= '***   PROGRAMA PUNTOS FARMANORTE   ****'.Chr(13).Chr(10);     	  
        $cont.= ' Ud Acumulo '.number_format($puntosacu).' puntos en esta compra!'.Chr(13).Chr(10);     	 
        $cont.= '>> Visite : www.puntosfarmanorte.com <<'.Chr(13).Chr(10);     	 
        $cont.= '************************************************'.Chr(13).Chr(10);
     }
     if(($_SESSION['G_SUCURSALPOS'] == "14")&&($total>=20000))
     {
        $cont.= Chr(13).Chr(10);
        $cont.= '************************************************'.Chr(13).Chr(10);     	 
        $cont.= '***          DESCUENTO DEL IVA SEGUN        ****'.Chr(13).Chr(10);     	  
        $cont.= '***           DECRETO 1818 DE 2015          ****'.Chr(13).Chr(10);     	 
        $cont.= '************************************************'.Chr(13).Chr(10).Chr(13).Chr(10);
     }
     */
/*	 
	 /// Participacion en el Concurso de Horno Farmanorte 14
	 if(($total>=20000)&&(trim($nitcli) != '99') && ($_SESSION['G_SUCURSALPOS']=='14'))
     {
     	$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
		$cont.= 'POR ESTA COMPRA, PARTICIPAS!! RIFA DE UN HORNO !'.Chr(13).Chr(10);	   
	    $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
	 }	 
*/
     /*
     if(($puntosRedi > 0))
	 {
          $leyenda = "Autorizo descontar de mis puntos Acumulados del Programa Puntos farmanorte como Medio de Pago de esta Venta.".Chr(13).Chr(10).Chr(13).Chr(10);          
          $leyenda.= "El Afiliado,".Chr(13).Chr(10).Chr(13).Chr(10);
          $leyenda.= "__________________________".Chr(13).Chr(10);
          $leyenda.= "C.C. ".Chr(13).Chr(10);                    
         
          $cont.= Chr(13).Chr(10).$leyenda.Chr(13).Chr(10);
	 }*/

     //// Si la Factura es Credito - Le Coloco la Leyenda
	 $empleado    = $clase->BDLockup($nitcli,'terceros','dni','esempleado');
	 $diascredito = $clase->BDLockup($nitcli,'terceros','dni','diascxc');
	 if(($creditos > 0)&&(strlen($empleado)>0))
	 {
		 $leyenda = "Por medio del presente escrito autorizo a la empresa DROMEDICAS DEL ORIENTE SAS, identificada con NIT 900265730-0, voluntariamente y sin coacción alguna descontar de mi salario la suma total de esta factura, esto para cancelación de la deuda generada actualmente con la ejecución del presente crédito y cabe aclarar que en caso de retiro descontar de mi liquidación de Prestaciones Sociales los saldos que se encuentren pendientes por pagar, de acuerdo con lo contemplado en los Art. 150 y 344 del Código Sustantivo del Trabajo".Chr(13).Chr(10).Chr(13).Chr(10);          $leyenda.= "El Empleado,".Chr(13).Chr(10).Chr(13).Chr(10);
		 $leyenda.= "__________________________".Chr(13).Chr(10);
		 $leyenda.= "C.C. ".Chr(13).Chr(10);                    
         
		 $cont.= Chr(13).Chr(10).$leyenda.Chr(13).Chr(10);
	 }
	 else
	 {
		 ////// Si es crédito pero no es para EMPLEADO 
		 if($creditos > 0)
	     {
		     $fecvence = $clase->SeleccionarUno("SELECT DATE_ADD( fechadoc, INTERVAL ".$diascredito." DAY )  FROM documentos D WHERE docuid=".$docuid);		   
			 $leyenda = "FORMA DE PAGO CREDITO CLIENTE AUTORIZADO".Chr(13).Chr(10); 
			 $leyenda.= "PLAZO : ".$diascredito." Dias".Chr(13).Chr(10);
			 $leyenda.= "FECHA VENCIMIENTO : ".substr($fecvence,0,10).Chr(13).Chr(10);
			 $leyenda.= '-----------------------------------------------'.Chr(13).Chr(10);
			 $cont.= $leyenda.Chr(13).Chr(10); 
	 	 } 
		 
		  /// Muestro los Pie de Pagina
	     if($pie1!= "")
	       $cont.= $pie1.Chr(13).Chr(10);
	     if($pie2!= "")
	       $cont.= $pie2.Chr(13).Chr(10);
	     if($pie3!= "")
	       $cont.= $pie3.Chr(13).Chr(10);
	     if($pie4!= "")
	       $cont.= $pie4.Chr(13).Chr(10);
	     if($pie5!= "")
	       $cont.= $pie5.Chr(13).Chr(10);	
		 /*
		 if(($_SESSION['G_SUCURSALPOS'] != "240")&&($_SESSION['G_SUCURSALPOS'] != "241"))  
		 {
			 //// Aviso de Facturacion Electronica
			 $cont.= "Si requiere FACTURA ELECTRONICA de esta compra, ".Chr(13).Chr(10);
			 $cont.= "puede solicitarla escribiendo un correo a  ".Chr(13).Chr(10);
			 $cont.= "facturacionfarmanorte@gmail.com ".Chr(13).Chr(10);
			 $cont.= "adjuntando el RUT y el numero de esta factura ( ".$prefijo.$numero." )".Chr(13).Chr(10);
			 $cont.= "Aplica a partir del 1 de Noviembre de 2021.".Chr(13).Chr(10);
			 $cont.= Chr(13).Chr(10);
		 }
*/
	     /// Aviso Sugerencias
		 $cont.= "  Sugerencias o Recomendaciones a  ".Chr(13).Chr(10);	

		 $cadena = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","cadenaid");
		 if($cadena == 1)
		    $cont.= " servicioalcliente@farmanorte.com.co ".Chr(13).Chr(10);		
		 else
		    $cont.= " servicioalcliente@drogueriasguasimales.com".Chr(13).Chr(10);	

		//// Aviso de NO se Aceptan Devoluciones
		$cont.= "  >>>>  NO SE ACEPTAN DEVOLUCIONES <<<<  ".Chr(13).Chr(10);
		$cont.= "ART 47 NUMERALES 4,5,6 Y 7 LEY 1480 DE 2011".Chr(13).Chr(10);

        //// Finalmente le coloco el Pie de Pagina y los espacios de Separacion
		$cont.= ' DROPOS ERP - DROPOS SAS - NIT 901191107-6'.Chr(13).Chr(10);   

	 }
/*
		/// Participacion en el Concurso de Aniversario
		$formapago = $clase->BDLockup($docuid,'documentos','docuid','formapago');
		if(($total>=30000)&&(trim($nitcli) != '99')&&($formapago == 'CO'))
		{
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
			$cont.= '   POR ESTA COMPRA, ESTAS PARTICIPANDO !!!      '.Chr(13).Chr(10);	   
			$cont.= '      >>    ANIVERSARIO FARMANORTE     <<       '.Chr(13).Chr(10);	   
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
		} 	 
*/
		$cadenaid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","cadenaid");
		if($cadenaid == 1) /// Si es Farmanorte
		{
			$acumulopuntos = 0+$clase->BDLockup($docuid,"acumulacionespuntos","docuid","puntosacumulados");
			if($acumulopuntos>1)
			{
				$nuevosaldopuntos = 0+$clase->BDLockup($docuid,"acumulacionespuntos","docuid","nuevosaldopuntos");
				$puntosxvencer    = 0+$clase->BDLockup($docuid,"acumulacionespuntos","docuid","puntosxvencer");
				/*
				$idcampa          = $clase->BDLockup($docuid,"acumulacionespuntos","docuid","idcampa");
               
				if($idcampa>0)
				{
					$cont.= ">>> ESTAS PARTICIPANDO CON ESTA FACTURA <<<".Chr(13).Chr(10);
				}
				*/

				$cont.= Chr(13).Chr(10);
				$cont.= "PUNTOS EN ESTA COMPRA : ".$acumulopuntos." PUNTOS".Chr(13).Chr(10);
				$cont.= "TOTAL PUNTOS ACUMULADOS : ".$nuevosaldopuntos." PUNTOS".Chr(13).Chr(10);
				$cont.= "PUNTOS A VENCER : ".$puntosxvencer." PUNTOS".Chr(13).Chr(10);				
			}
		}    
 
     //// Separadores y Corte de Hoja
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.'.Chr(13).Chr(10);   
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D"; 
	 
     // Como mecanismo de Seguridad, guardo en el Dropbox copia de la Tira
     $archivo= "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/Impresora/Imp-".date("mY").".txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a");   // Abres el archivo para escribir en él
     fwrite($fch, $cont);           // Grabas
     fclose($fch);                  // Cierras el archivo

	 ////////////////////////////////////////////////
	 // Genero el Archivo para Enviarlo a Impresora
	 if($autoprint != 'N')
     	 $archivo= "../Dropbox/".$autoprint."/autoprint/autoprint-factura-".rand(11111,99999).".txt"; // el nombre de tu archivo
     else
     {	
       // Genero el Archivo para Enviarlo a Impresora
       if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR") 
       {
          $codImpre = $clase->BDLockup($_SESSION['USERNAME'],"usuarios","username","codimpresora");
          if(strlen($codImpre)>0) 	
          {	
             $rutaImpresion = $clase->BDLockup($codImpre,"impresoras","codigo","ruta");
     	     $archivo= "../../Dropbox/00/".$rutaImpresion."/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
          }
          else 
             $archivo= "../../Dropbox/00/print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
       }	 
       else  /// En Droguerias Imprime ahi
       {
			$caja = $clase->BDLockup($docuid,"docuventa","docuid","cajaid");
			if($caja == 1)
				$archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
			else
			{
				$rutaprint = $clase->BDLockup($caja,"cajasdecobro","cajaid","rutaprint");
				$archivo   = $rutaprint."/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
			}
	   }  	     	
     }

     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo

    if($autoprint == 'N')
    {	
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("my")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 /// La marco en la Base de datos como Impresa
     $clase->EjecutarSQL("UPDATE documentos SET impreso = 'S' WHERE docuid=".$docuid);
     $clase->EjecutarSQL("UPDATE docuventa SET impreso = CURRENT_TIMESTAMP WHERE docuid=".$docuid);

	 /*
	 //// Si es un Credito a Empleados - Imprime copia
	 $formapago = $clase->SeleccionarUno("SELECT formapago FROM documentos WHERE docuid=".$docuid);
	 if($formapago == 'CR')
	 {   
     	$archivo= "print/facturacopia1.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	*/
	
	 //// Si el Medio de Pago es Tarjetas - Imprimo la Copia de la Factura
	 $estarje = $clase->SeleccionarUno("SELECT valorfp2 + valorfp3 FROM docuventa WHERE docuid=".$docuid);
	 if($estarje > 0)
	 {   
     	$archivo= "print/facturacopia1.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
        /*
		if(($_SESSION['G_SUCURSALPOS'] == "240")||($_SESSION['G_SUCURSALPOS'] == "241"))
		{
			$archivo= "print/facturacopia2.txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
			fclose($fch); // Cierras el archivo
		}
		*/
	 }

	 //// Si es Empresa de Mensajeria Imprime una Copia
	 $mensajero = $clase->SeleccionarUno("SELECT T.codigo FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid3) WHERE D.docuid = ".$docuid);
	 if($mensajero == "999")
	 {   
     	$archivo= "print/facturacopiaxmensajeria.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo

		/// Si es la Farmanorte 241 - Imprima otra copia
		if($_SESSION['G_SUCURSALPOS'] == "241")
		{
			$archivo= "print/facturacopiaxmensajeria2.txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
			fclose($fch); // Cierras el archivo
		}
	 }
	 
	 /*
	 //// Si es una Formula Medica enviada para CloseUp 
	 $esmedico = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($esmedico!=0)
	 {   
     	$archivo= "print/facturacopia2.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	 */

	 /*
	 //// Si es una Formula Medica enviada para CloseUp 
	 $esmedico = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($esmedico!=0)
	 {   
     	$archivo= "print/facturacopia2.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	 */
	 
	 /*
	 //// Si redimió Puntos en esta Venta - Otra Copia
	 if($puntosRedi != 0)
	 {   
     	$archivo= "print/facturacopia5.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }*/

	 //// Si alguno de los productos que se facturan tiene Beneficio - Debe Imprimir una copia 
	 /*
	 $vsqlaux="SELECT COUNT(*) FROM dedocumentos DD INNER JOIN productos P ON ( P.productoid = DD.productoid ) 
			   WHERE P.recambio = 'CHECKED' AND DD.docuid =".$docuid;
	 $beneficio = $clase->SeleccionarUno($vsqlaux);
	 if($beneficio > 0)
	 {   
     	$archivo= "print/facturacopia3.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
        fclose($fch); // Cierras el archivo
	 }
	 */
	 
	 //// Marco la Factura como Impresa
	 $clase->EjecutarSQL("UPDATE documentos SET impreso = 'S' WHERE docuid=".$docuid);

	 //// Si la factura es de Domicilio mando a imprimir el Ticket de mensajeria
	 //// Si la Sucursal tiene callcenter se debe Imprimir una copia mas de las Ventas a domicilio
	 $esdomi = $clase->SeleccionarUno("SELECT terid3 FROM documentos WHERE docuid=".$docuid);
	 if($esdomi!=1)
	 {
		 ImpresionTiraMensajeria($docuid);	    
		 /*<
		 $callcenter = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","callcenter");
		 if($callcenter == "CHECKED")
		 {
			 $archivo= "print/facturacopia4.txt"; // el nombre de tu archivo
			 $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			 fwrite($fch,Chr(13).Chr(10).$cont);  // Grabas
			 fclose($fch); // Cierras el archivo
		 }
		 */		   
	 }

	 /////////////////  ANIVERSARIO FARMANORTE  /////////////////////////////////  
	 //// Para las Ventas Superiores a $ 30.000 - Se Genera el Ticket de la Rifa
	
	//  if(($total>=20000)&&(trim($nitcli) != '99') && ($_SESSION['G_SUCURSALPOS']=='102'))
	//  {
	// 	 $sucursal = $clase->SeleccionarUno("SELECT S.descripcion FROM sucursales S INNER JOIN documentos D ON (D.sucursalid = S.sucursalid) WHERE D.docuid = ".$docuid);
	// 	 TiqueteRifa($cliente , $telcli , $dircli , $sucursal);
	//  }


	 
	
	 ///// Rifa Lavadora Entre CLIENTES
	//  if(($total>=20000)&&(trim($nitcli) != '99'))
	//  {
	// 	$sucursal = $clase->SeleccionarUno("SELECT S.descripcion FROM sucursales S INNER JOIN documentos D ON (D.sucursalid = S.sucursalid) WHERE D.docuid = ".$docuid);
	// 	$codsuc   = $clase->SeleccionarUno("SELECT S.codigo FROM sucursales S INNER JOIN documentos D ON (D.sucursalid = S.sucursalid) WHERE D.docuid = ".$docuid);
	// 	$diasrifa = $clase->SeleccionarUno("SELECT DATEDIFF('2019-12-20',CURRENT_DATE)");
	// 	if(($diasrifa<=61)&&($diasrifa>=0)&&(($codsuc == "58")||($codsuc == "59")||($codsuc == "60")||($codsuc == "67")||($codsuc == "07")))
	// 	  TiqueteRifa2($cliente , $telcli , $dircli , $sucursal);
	//  }
	
	 return(true);	
	}	
	
  } // Fin de la Funcion



  ////////////////////////////////////////////////////////////////////// 
  //// FORMATO ANTIGUO 2017 - IMPRESORAS MATRICIALES
  ////////////////////////////////////////////////////////////////////// 
  function ImpresionPOSFactura3($docuid,$autoprint='N',$reimpresion='N')
  {
      $clase = new Sistema();	 
	  $detalles = "";       $nombremoneda = "";
	  $cont = "";

	  if($reimpresion == "S")
	     $cont.= ' ***  REIMPRESION DUPLICADO DE FACTURA *** '.Chr(13).Chr(10);

	  $nombremoneda = @$_SESSION['G_MONEDALOCAL'];
	  $asentada = $clase->BDLockup($docuid,'documentos','docuid','fecasentado');
	  $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	  $cont.= $nomempresa.Chr(13).Chr(10);	 
	  //$cont.= 'SOMOS RESPONSABLES DEL IVA'.Chr(13).Chr(10);
	  //$cont.= 'SOMOS AUTORRETENEDORES DEL ICA'.Chr(13).Chr(10);
	  $cont.= 'SOMOS AUTORRETENEDORES DEL IVA E ICA'.Chr(13).Chr(10);

	  /// Cargo las configuraciones del Prefijo del Documento
	  $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	  $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");	  
	
	  /// Datos de la Resolucion
	  $sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');
	  $fechafactura = $clase->BDLockup($docuid,'documentos','docuid','CAST(fechadoc as DATE)');
	  $vsqlres = "SELECT * FROM resolucionesdian WHERE sucursalid = '".$sucursalid."' AND numini <= '".$numero."' AND numfin >= '".$numero."' 
	   			  AND fecdesde <= '".$fechafactura."' AND fechasta >= '".$fechafactura."' ORDER BY resid DESC LIMIT 0,1";
   	  $conex  = $clase->Conectar();
	  $result = @mysql_query($vsqlres,$conex);
	  $txtresol = "";
	  if($row = @mysql_fetch_array($result)) 
	  	 $txtresol = "AUTOR NUMER DE FACT No ".$row['numeroaut']." FECHA: ".$row['fecdesde']." VIGENCIA ".$row['meses'].
					 " MESES Prefijo (".$row['prefijo'].") NUM AUT del ".number_format($row['numini'])." al ".number_format($row['numfin']);      

   	  if(strlen($txtresol) == 0)
		 $txtresol  = $clase->SeleccionarUno("SELECT txtresolucion FROM consecutivos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'");

      $vsql = "SELECT * FROM consecutivos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'";
	  $conex  = $clase->Conectar();
      $result = @mysql_query($vsql,$conex);
			
	  if($row = @mysql_fetch_array($result))
  	  {
		    $cadenaid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","cadenaid");
			if($cadenaid == 1)
		        $encab1 = "DROGUERIA FARMANORTE";
			else
			    $encab1 = "DROGUERIA GUASIMALES";	
				
			$encab2 = $row['encab2'];	
			$encab3 = $row['encab3'];				    
			$encab4 = $row['encab4'];				    
			$encab5 = $row['encab5'];				    			    
			
			$pie1 = $row['pie1'];	    
			$pie2 = $row['pie2'];	    
			$pie3 = $row['pie3'];	    
			$pie4 = $row['pie4'];	    
			$pie5 = $row['pie5'];	 
			
			$txtres = $txtresol;
	 }     

	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , DD.observalinea , 
	  		  T.dni codcliente , D.terid2 , D.terid3 , CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , P.precio1m , 
			  T.telmovil , P.codigo codproducto , P.factor1 , DD.docuref , P.descripcion nomproducto , DD.valunitario , DD.valdescuento , 
			  SUM(DD.unicom) cajas , SUM(DD.unifra) unidades , SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25 
			  ORDER BY DD.dedocumid ASC";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
     
	 if($encab1!= "")
       $cont.= $encab1.Chr(13).Chr(10);
	 if($encab2!= "")
	   $cont.= $encab2.Chr(13).Chr(10);
 	 if($encab3!= "")
	   $cont.= $encab3.Chr(13).Chr(10);
 	 if($encab4!= "")
	   $cont.= $encab4.Chr(13).Chr(10);
 	 if($encab5!= "")
	   $cont.= $encab5.Chr(13).Chr(10);	 	 	 	 
	 
	 $teriddomi = "";  $domix = 0;
	 $condecreto = 0;  $totaldescuento = 0;
	 while($row = @mysql_fetch_array($result))
	 { 
 	   /// Nombre del Archivo para la Sincronizacion
	   $nombredoc = $row['tipodoc'].$row['prefijo'].abs($row['numero']); 
	   
	   $teriddomi = $row['terid3'];
	   $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
 	   
	   $subtotal = $row['base']; 
	   $iva      = $row['iva']; 	   
	   $total    = $row['total']; 

   	   $cliente  = substr($row['nomcliente'],0,24); 
   	   $nitcli   = $row['dni']; 	   
   	   $dircli   = $row['direccion']; 	   	   
   	   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   
   	   
       if($row['docuref'] == "*")
         $condecreto ++;

	   $vend = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid2']);
	   $vendedor = substr($vend,0,27); 

	   if($row['codproducto'] != 'DO')
	   {
 	     $valdcto = ($row['valparcial']*($row['valdescuento']/100));

 	     $detalles.= str_pad(substr($row['nomproducto'],0,19),19," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad($row['cajas'],3," ",STR_PAD_LEFT).' '.str_pad($row['unidades'],3," ",STR_PAD_LEFT).'  ';
		 
         if(strlen($row['observalinea'])>0)
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format((($row['cajas']*$row['factor1'])+$row['unidades'])*$row['valunitario']),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['cajas']*$row['precio1m'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	   
         }	
         else
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format(($row['valparcial'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['valparcial'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   	
         }	

		 
         if($valdcto>0)
          	$totaldescuento += $valdcto;
                  
         //// Adaptacion para las Recargas
         //// Muestra el Operador y el Numero a realizar la transaccion
         if(($row['codproducto'] == "R1000")||($row['codproducto'] == "R1001")) 
         {
           $vsqlx = "SELECT CONCAT('Num : ',numrecarga,' Operad : ', nomoperador) 
                     FROM transarecargas T INNER JOIN operadorcel O ON (T.codoperador = O.codoperador) WHERE T.idfactura = ".$docuid." ORDER BY transaid DESC LIMIT 0,1";
           $datoRecarga = $clase->SeleccionarUno($vsqlx);
           $detalles   .= $datoRecarga.Chr(13).Chr(10);
         }	  
           
		 //// SD : 001 Marzo 2015
		 //// Al usuario DOMICILIOS - Debe mostrar el Codigo de Barras del Producto
		 if($teriddomi != 1)
		    $detalles.=	"Cod Barra: ".$row['codproducto'].Chr(13).Chr(10); 	     
	   }
	   else
	     $domix += $row['valparcial'];
	 
	 }  /// Fin While

     $cont.= 'SISTEMA POS - DOC EQUIVALENTE No. '.$prefijo.' '.abs($numero).Chr(13).Chr(10);
	 $cont.= $txtres.Chr(13).Chr(10);	 	 	
	 //$cont.= $txtbolsas.Chr(13).Chr(10);
	 //$cont.= "ID Transaccion Auditoria : ".str_pad($docuid,10, "0", STR_PAD_LEFT).Chr(13).Chr(10);

 	 //// Se Incluye el Serial de la Impresora 
	 if($_SESSION['G_SERIALIMPRESORA'] != "")
	   $cont.= 'IMPRESORA FISCAL SERIAL : '.$_SESSION['G_SERIALIMPRESORA'].Chr(13).Chr(10);          

	   $mostrarobs = $clase->BDLockup($docuid,"documentos","docuid","CONCAT(observacion,' ',observacion2");
	   if(strlen($mostrarobs)>3)
	   {
			 $dircli = "";
			 $observacionfactura .= $mostrarobs.Chr(13).Chr(10);
			 $observacionfactura .= '------------------------------------------------'.Chr(13).Chr(10);     	 
	   }
  
	   $cont.= '------------------------------------------------'.Chr(13).Chr(10); 
	   $cont.= 'FECHA   : '.$fecha.'              Hora : '.$hora.Chr(13).Chr(10);	 
	   $cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
	   $cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);	 
	   if($dircli != "")   $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);	 
	   $cont.= 'TELEFON : '.trim($telcli).Chr(13).Chr(10).Chr(13);
	   $cont.= '------------------------------------------------'.Chr(13).Chr(10);    	
	   if($observacionfactura != "")   $cont.= 'DIRECCION : '.$observacionfactura.Chr(13).Chr(10);	   
     
	 $medicoid = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($medicoid != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT nommedico FROM medicos WHERE medicoid=".$medicoid);
		if($domi != "")
		{
			$cont.= 'MEDICO  : '.substr(strtoupper($domi),0,27).Chr(13).Chr(10);
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 
		}
	 }     	 
	 
	 if($teriddomi != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$teriddomi);
		if($domi != "")
		{
			$cont.= 'DOMICILIARIO : '.substr($domi,0,24).Chr(13).Chr(10);
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 
		}
	 }           
	 
     $cont.= 'VENDEDOR: '.$vendedor.Chr(13).Chr(10);	      
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'PRODUCTO             CAJ UNI      TOTAL'.Chr(13).Chr(10);
     $cont.= '---------------------------------------'.Chr(13).Chr(10);     
	 $cont.= $detalles;	 
	 $cont.= '                            -----------'.Chr(13).Chr(10);     
	 $cont.= '              TOTAL '.$nombremoneda.'   '.str_pad(number_format($total+$totaldescuento),16," ",STR_PAD_LEFT).Chr(13).Chr(10);     	 
	 $cont.= '                            ==========='.Chr(13).Chr(10);     
	 
	 $cont.= '    SUBTOTAL           : '.str_pad(number_format($subtotal+$totaldescuento-$domix),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '    DESCUENTOS         : '.str_pad(number_format($totaldescuento),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '    I.V.A              : '.str_pad(number_format($iva),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '    DOMICILIO          : '.str_pad(number_format($domix),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '    TOTAL A PAGAR      : '.str_pad(number_format($total),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= '---------------------------------------'.Chr(13).Chr(10);     	 

	 /// Especifico el Medio de Pago de la Factura
	 $efectivo = $clase->SeleccionarUno("SELECT valorfp1 FROM docuventa WHERE docuid=".$docuid);	 
	      
     //// Pongo una linea por Cada medio de Pago
	 if($efectivo > 0)
	    $cont.= 'EFECTIVO '.str_pad(number_format($efectivo),30," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 	 
	 $tarjetas = $clase->SeleccionarUno("SELECT valorfp2 + valorfp3 FROM docuventa WHERE docuid=".$docuid);	 
	 if($tarjetas > 0)
	     $cont.= 'TARJETAS DEB / CRED '.str_pad(number_format($tarjetas),19," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 
	 $creditos = $clase->SeleccionarUno("SELECT valorfp4 FROM docuventa WHERE docuid=".$docuid);	 
	 if(($creditos > 0)&&($_SESSION['G_MODOTRABAJO'] == "SERVIDOR"))
	     $cont.= 'CREDITOS             '.str_pad(number_format($creditos),17," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 
	 
	 $puntosRedi = $clase->SeleccionarUno("SELECT valorfp5 FROM docuventa WHERE docuid=".$docuid);	 
	 if($puntosRedi > 0)
	     $cont.= 'PUNTOS FARMANORTE REDIMIDOS '.str_pad(number_format($puntosRedi),20," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	 	 
		
	 $cont.= '------------------------------------------------'.Chr(13).Chr(10);     
	
	 /// Consulto si hubo que dar vueltos 
	 $vueltos = $clase->BDLockup($docuid,'docuventa','docuid','vueltos');
	 if(($vueltos > 0)&&($efectivo > 0))
	 {
   	   $cont.= 'VUELTOS A ENTREGAR   '.str_pad(number_format($vueltos),27," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
	   $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
	 }
	
	 /// Si Corresponde a una reimpresion de Factura lo coloca al Finalizar
	 if($reimpresion == "S")
		$cont.= Chr(13).Chr(10).Chr(13).Chr(10).'              * DUPLICADO *             '.Chr(13).Chr(10);

	 //// Si la Factura es Credito - Le Coloco la Leyenda
	 if(($creditos > 0))
	 {
          $leyenda = "Por medio del presente escrito autorizo a la empresa DROMEDICAS DEL ORIENTE SAS, identificada con NIT 900265730-0, voluntariamente y sin coacción alguna descontar de mi salario la suma total de esta factura, esto para cancelación de la deuda generada actualmente con la ejecución del presente crédito y cabe aclarar que en caso de retiro descontar de mi liquidación de Prestaciones Sociales los saldos que se encuentren pendientes por pagar, de acuerdo con lo contemplado en los Art. 150 y 344 del Código Sustantivo del Trabajo".Chr(13).Chr(10).Chr(13).Chr(10);          $leyenda.= "El Empleado,".Chr(13).Chr(10).Chr(13).Chr(10);
          $leyenda.= "__________________________".Chr(13).Chr(10);
          $leyenda.= "C.C. ".Chr(13).Chr(10);                    
         
          $cont.= Chr(13).Chr(10).$leyenda.Chr(13).Chr(10);
	 }
	 else
	 {
         /// Muestro los Pie de Pagina
	     if($pie1!= "")
	       $cont.= $pie1.Chr(13).Chr(10);
	     if($pie2!= "")
	       $cont.= $pie2.Chr(13).Chr(10);
	     if($pie3!= "")
	       $cont.= $pie3.Chr(13).Chr(10);
	     if($pie4!= "")
	       $cont.= $pie4.Chr(13).Chr(10);
	     if($pie5!= "")
	       $cont.= $pie5.Chr(13).Chr(10);	
 		 
		 ///// Sugerencias y Reclamos  
		 $cont.= "  Sugerencias o Recomendaciones a  ".Chr(13).Chr(10);	

		 if(($_SESSION['G_SUCURSALPOS'] == "127")||($_SESSION['G_SUCURSALPOS'] == "240")||($_SESSION['G_SUCURSALPOS'] == "241")||($_SESSION['G_SUCURSALPOS'] == "244")||($_SESSION['G_SUCURSALPOS'] == "265"))
			$cont.= " servicioalcliente@drogueriasguasimales.com".Chr(13).Chr(10);	
		 else
			$cont.= " servicioalcliente@farmanorte.com.co ".Chr(13).Chr(10);		
  
		  //// Aviso de NO se Aceptan Devoluciones
		  $cont.= "  >>>>  NO SE ACEPTAN DEVOLUCIONES <<<<  ".Chr(13).Chr(10);
		  $cont.= "ART 47 NUMERALES 4,5,6 Y 7 LEY 1480 DE 2011".Chr(13).Chr(10);
	
	   
		/* 
		/// Participacion en el Concurso de Aniversario
		if(($total>=30000)&&(trim($nitcli) != '99'))
		{
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
			$cont.= '   POR ESTA COMPRA, ESTAS PARTICIPANDO !!!      '.Chr(13).Chr(10);	   
			$cont.= '      >>    ANIVERSARIO FARMANORTE     <<       '.Chr(13).Chr(10);	   
			$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
		} 	 
		*/ 

	  ///////////////////////////////////////////////////////////////////////////////////////////	
	  ////  Muestro la Barra de Participando .. si es Mayor a $ 40.000 Droguerias Farmanorte 
	
	  $formapago = $clase->BDLockup($docuid,"documentos","docuid","formapago");
	  if($formapago == "CO")
	  {
			if(($_SESSION['G_SUCURSALPOS'] == "127")||($_SESSION['G_SUCURSALPOS'] == "240")||($_SESSION['G_SUCURSALPOS'] == "241")||($_SESSION['G_SUCURSALPOS'] == "244")||($_SESSION['G_SUCURSALPOS'] == "265"))
			{
				$W++;
				/*
				if($total >= 50000)
				{
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
					$cont.= '   POR ESTA COMPRA, ESTAS PARTICIPANDO !!!      '.Chr(13).Chr(10);	   
					$cont.= '    >>    ANIVERSARIO FARMANORTE     <<         '.Chr(13).Chr(10);	   
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);      
					
				}
				*/
			}
			else
			{
				//////////////////////////////////////////////////////////////////////////////////////////
				//// Muestro la Barra de Participando .. si es Mayor a $ 25.000 Droguerias Farmanorte 
				$vsql5 = "SELECT COUNT(*)
							FROM dedocumentos DD INNER JOIN documentos D ON (DD.docuid = D.docuid) 
							INNER JOIN productos P ON (P.productoid = DD.productoid)
							INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid) 
							WHERE GP.concurso1 = 'CHECKED' AND D.docuid = ".$docuid;
				$tienepatrocinadores = $clase->SeleccionarUno($vsql5);         
				if(($tienepatrocinadores>0)&&($totalfv>=50000))
				{
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
					$cont.= '    POR ESTA COMPRA, ESTAS PARTICIPANDO !!!     '.Chr(13).Chr(10);	   
					$cont.= '       >> ANIVERSARIO FARMANORTE  <<            '.Chr(13).Chr(10);	   
					$cont.= '------------------------------------------------'.Chr(13).Chr(10);    
				}
			}
	  }

        //// Finalmente le coloco el Pie de Pagina y los espacios de Separacion
		$cont.= ' DROPOS ERP - DROPOS SAS - NIT 901191107-6'.Chr(13).Chr(10);   
	 }

	 $cadenaid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","cadenaid");
	 if($cadenaid == 1) /// Si es Farmanorte
	 {
			$acumulopuntos = 0+$clase->BDLockup($docuid,"acumulacionespuntos","docuid","puntosacumulados");
			if($acumulopuntos>1)
			{
				$nuevosaldopuntos = 0+$clase->BDLockup($docuid,"acumulacionespuntos","docuid","nuevosaldopuntos");
				$puntosxvencer    = 0+$clase->BDLockup($docuid,"acumulacionespuntos","docuid","puntosxvencer");
				$idcampa          = $clase->BDLockup($docuid,"acumulacionespuntos","docuid","idcampa");

				if($idcampa>0)
				{
					$cont.= ">>> ESTAS PARTICIPANDO CON ESTA FACTURA <<<".Chr(13).Chr(10);
				}
				
				$cont.= Chr(13).Chr(10);
				$cont.= "PUNTOS EN ESTA COMPRA : ".$acumulopuntos." PUNTOS".Chr(13).Chr(10);
				$cont.= "TOTAL PUNTOS ACUMULADOS : ".$nuevosaldopuntos." PUNTOS".Chr(13).Chr(10);
				$cont.= "PUNTOS A VENCER : ".$puntosxvencer." PUNTOS".Chr(13).Chr(10);				
			}
	 }    
 
     //// Separadores y Corte de Hoja
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.'.Chr(13).Chr(10);   
     $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  

     // Como mecanismo de Seguridad, guardo en el Dropbox copia de la Tira
     $archivo= "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/Impresora/Imp-".date("mY").".txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a");   // Abres el archivo para escribir en él
     fwrite($fch, $cont);           // Grabas
     fclose($fch);                  // Cierras el archivo

	 $codImpre = $clase->BDLockup($_SESSION['USERNAME'],"usuarios","username","codimpresora");
     if(strlen($codImpre)>0) 	
     {	
        $rutaImpresion = $clase->BDLockup($codImpre,"impresoras","codigo","ruta");
        $archivo= "../Dropbox/00/".$rutaImpresion."/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
     }
     else 
        $archivo= "../Dropbox/00/print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
     
	 $fch= fopen($archivo, "a");   // Abres el archivo para escribir en él
	 fwrite($fch, $cont);           // Grabas
	 fclose($fch);                  // Cierras el archivo
		 
	 //// Marco la Factura como Impresa
	 $clase->EjecutarSQL("UPDATE documentos SET impreso = 'S' WHERE docuid=".$docuid);
     
	 return(true);	

  }// Fin de la Funcion
  
  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////
  function ImpresionPOSFactura4($docuid)
  {
      $clase = new Sistema();	 
	  $detalles = "";       $nombremoneda = "";
  	  $cont = "";

      $nombremoneda = @$_SESSION['G_MONEDALOCAL'];
	  $asentada = $clase->BDLockup($docuid,'documentos','docuid','fecasentado');
	  $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
      $cont = $nomempresa.Chr(13).Chr(10);	 
	  $cont.= 'SOMOS RESPONSABLES DEL IVA'.Chr(13).Chr(10);
	  $cont.= 'SOMOS AUTORRETENEDORES DEL ICA'.Chr(13).Chr(10);

	  /// Cargo las configuraciones del Prefijo del Documento
	  $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	  $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");	  
	 
  	  $txtbolsas = "Ley 1819 de 2016 INC Bolsas Plasticas";

      $vsql = "SELECT * FROM consecutivos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'";
	  $conex  = $clase->Conectar();
      $result = @mysql_query($vsql,$conex);
	  if($row = @mysql_fetch_array($result))
	  {
				$encab1 = $row['encab1'];	
				$encab2 = $row['encab2'];	
				$encab3 = $row['encab3'];				    
				$encab4 = $row['encab4'];				    
				$encab5 = $row['encab5'];				    			    
				
			$pie1 = $row['pie1'];	    
			$pie2 = $row['pie2'];	    
			$pie3 = $row['pie3'];	    
			$pie4 = $row['pie4'];	    
			$pie5 = $row['pie5'];	 
			
			$txtres = $row['txtresolucion'];	    
	  }    
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , DD.observalinea , 
	  		  T.dni codcliente , D.terid2 , D.terid3 , CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , P.precio1m , 
			  T.telmovil , P.codigo codproducto , P.factor1 , P.porciva , DD.docuref , P.descripcion nomproducto , DD.valunitario , DD.valdescuento , 
			  SUM(DD.unicom) cajas , SUM(DD.unifra) unidades , SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26    
			  ORDER BY DD.dedocumid ASC";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
     
	 if($encab1!= "")
       $cont.= $encab1.Chr(13).Chr(10);
	 if($encab2!= "")
	   $cont.= $encab2.Chr(13).Chr(10);
 	 if($encab3!= "")
	   $cont.= $encab3.Chr(13).Chr(10);
 	 if($encab4!= "")
	   $cont.= $encab4.Chr(13).Chr(10);
 	 if($encab5!= "")
	   $cont.= $encab5.Chr(13).Chr(10);	 	 	 	 
	 
	 $teriddomi = "";  $domix = 0;
	 $condecreto = 0;  $totaldescuento = 0;
	 while($row = @mysql_fetch_array($result))
	 { 
 	   /// Nombre del Archivo para la Sincronizacion
	   $nombredoc = $row['tipodoc'].$row['prefijo'].abs($row['numero']); 
	   	   
	   $teriddomi = $row['terid3'];
	   $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
 	   
	   $subtotal = $row['base']; 
	   $iva      = $row['iva']; 	   
	   $total    = $row['total']; 

  	   $cliente  = substr($row['nomcliente'],0,24); 

   	   $nitcli   = $row['dni']; 	   
   	   $dircli   = $row['direccion']; 	   	   
   	   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   
   	   
       if($row['docuref'] == "*")
         $condecreto ++;

	   $vend = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid2']);
	   $vendedor = substr($vend,0,27); 

	   if($row['codproducto'] != 'DO')
	   {
 	     $valdcto = ($row['valparcial']*($row['valdescuento']/100));

 	     $detalles.= str_pad(substr($row['nomproducto'],0,23),23," ",STR_PAD_RIGHT).'  ';
		 $detalles.= str_pad($row['cajas'],3," ",STR_PAD_LEFT).' '.str_pad($row['unidades'],3," ",STR_PAD_LEFT).'  ';
		 $detalles.= str_pad($row['porciva'],3," ",STR_PAD_LEFT).'  ';
		 
         if(strlen($row['observalinea'])>0)
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format((($row['cajas']*$row['factor1'])+$row['unidades'])*$row['valunitario']),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['cajas']*$row['precio1m'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	   
         }	
         else
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format(($row['valparcial'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['valparcial'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   	
         }	
		 
		 if($_SESSION['USERNAME'] == "VENTASPBX")
		   $detalles.= "Cod. Barra : ".$row['codproducto'].Chr(13).Chr(10); 	   	
		 
         if($valdcto>0)
          	$totaldescuento += $valdcto;
                  
         //// Adaptacion para las Recargas
         //// Muestra el Operador y el Numero a realizar la transaccion
         if(($row['codproducto'] == "R1000")||($row['codproducto'] == "R1001")) 
         {
           $vsqlx = "SELECT CONCAT('Num : ',numrecarga,' Operad : ', nomoperador) 
                     FROM transarecargas T INNER JOIN operadorcel O ON (T.codoperador = O.codoperador) WHERE T.idfactura = ".$docuid." ORDER BY transaid DESC LIMIT 0,1";
           $datoRecarga = $clase->SeleccionarUno($vsqlx);
           $detalles   .= $datoRecarga.Chr(13).Chr(10);
         }	  
           
		 //// SD : 001 Marzo 2015
		 //// Al usuario DOMICILIOS - Debe mostrar el Codigo de Barras del Producto
		 if($_SESSION['USERNAME'] == "DOMICILIOS")
		    $detalles.=	"Cod Barra: ".$row['codproducto'].Chr(13).Chr(10); 	     
	   }
	   else
	     $domix += $row['valparcial'];
     } 

	 $cont.= 'DOC. EQUIVALENTE No.'.$prefijo.' '.abs($numero).Chr(13).Chr(10);
	 $cont.= $txtres.Chr(13).Chr(10);	 	 	
	 $cont.= $txtbolsas.Chr(13).Chr(10);
	 $cont.= "ID Transaccion Auditoria : ".str_pad($docuid,10, "0", STR_PAD_LEFT).Chr(13).Chr(10);
	 
	 //// Se Incluye el Serial de la Impresora 
	 if($_SESSION['G_SERIALIMPRESORA'] != "")
	    $cont.= 'IMPRESORA FISCAL SERIAL : '.$_SESSION['G_SERIALIMPRESORA'].Chr(13).Chr(10);          

		$mostrarobs = $clase->BDLockup($docuid,"documentos","docuid","CONCAT(observacion,' ',observacion2");
		if(strlen($mostrarobs)>3)
		{
			  $dircli = "";
			  $observacionfactura .= $mostrarobs.Chr(13).Chr(10);
			  $observacionfactura .= '------------------------------------------------'.Chr(13).Chr(10);     	 
		}
   
		$cont.= '------------------------------------------------'.Chr(13).Chr(10); 
		$cont.= 'FECHA   : '.$fecha.'              Hora : '.$hora.Chr(13).Chr(10);	 
		$cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
		$cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);	 
		if($dircli != "")   $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);	 
	    $cont.= 'TELEFON : '.trim($telcli).Chr(13).Chr(10).Chr(13);
        $cont.= '------------------------------------------------'.Chr(13).Chr(10);          	 	
     
	 $medicoid = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($medicoid != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT nommedico FROM medicos WHERE medicoid=".$medicoid);
		$cont.= 'MEDICO  : '.substr(strtoupper($domi),0,27).Chr(13).Chr(10);
        $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 
	 }     	 
	 
	 if($teriddomi != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$teriddomi);
		$cont.= 'DOMICILIARIO : '.substr($domi,0,24).Chr(13).Chr(10);
        $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 
	 }         
	 
     $cont.= 'VENDEDOR: '.$vendedor.Chr(13).Chr(10);	      
     $cont.= '------------------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'PRODUCTO Y/O SERVICIO    CAJ UNI  IVA      TOTAL'.Chr(13).Chr(10);
     $cont.= '------------------------------------------------'.Chr(13).Chr(10);     
	 $cont.= $detalles;	 
	 $cont.= '                                       ---------'.Chr(13).Chr(10);     
	 $cont.= '  TOTAL FACTURA CON IMPUESTOS'.$nombremoneda.'   '.str_pad(number_format($total+$totaldescuento),16," ",STR_PAD_LEFT).Chr(13).Chr(10);     	 
	 $cont.= '                                       ========='.Chr(13).Chr(10);     
	 $cont.= '       SUBTOTAL            :      '.str_pad(number_format($subtotal+$totaldescuento-$domix),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       DESCUENTOS          :      '.str_pad(number_format($totaldescuento),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       I.V.A               :      '.str_pad(number_format($iva),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       DOMICILIO           :      '.str_pad(number_format($domix),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '       TOTAL A PAGAR       :      '.str_pad(number_format($total),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '------------------------------------------------'.Chr(13).Chr(10);    
	 

	 /// Especifico el Medio de Pago de la Factura
	 $efectivo = $clase->SeleccionarUno("SELECT valorfp1 FROM docuventa WHERE docuid=".$docuid);	 
	 	 
	 //// Pongo una linea por Cada medio de Pago
	 if($efectivo > 0)
	    $cont.= 'EFECTIVO  '.str_pad(number_format($efectivo),38," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 	 
	 $tarjetas = $clase->SeleccionarUno("SELECT valorfp2 + valorfp3 FROM docuventa WHERE docuid=".$docuid);	 
	 if($tarjetas > 0)
	     $cont.= 'TARJETAS DEB / CRED '.str_pad(number_format($tarjetas),28," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 
	 $creditos = $clase->SeleccionarUno("SELECT valorfp4 FROM docuventa WHERE docuid=".$docuid);	 
	 if(($creditos > 0)&&($_SESSION['G_MODOTRABAJO'] == "SERVIDOR"))
	     $cont.= 'CREDITOS              '.str_pad(number_format($creditos),26," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 
	 
	 $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
	 
	 /// Consulto si hubo que dar vueltos 
	 $vueltos = $clase->BDLockup($docuid,'docuventa','docuid','vueltos');
	 if(($vueltos > 0)&&($efectivo > 0))
	 {
   	   $cont.= 'VUELTOS A ENTREGAR   '.str_pad(number_format($vueltos),27," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
	   $cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
	 }
	
     if($condecreto > 0)
     {
        $cont.= Chr(13).Chr(10);
        $cont.= '************************************************'.Chr(13).Chr(10);     	 
        $cont.= '***          DESCUENTO DEL IVA SEGUN        ****'.Chr(13).Chr(10);     	  
        $cont.= '***           DECRETO 1818 DE 2015          ****'.Chr(13).Chr(10);     	 
        $cont.= '************************************************'.Chr(13).Chr(10).Chr(13).Chr(10);
     }

     //// Si la Factura es Credito - Le Coloco la Leyenda
	 $empleado    = $clase->BDLockup($nitcli,'terceros','dni','esempleado');
	 $diascredito = $clase->BDLockup($nitcli,'terceros','dni','diascxc');
	 if(($creditos > 0)&&(strlen($empleado)>0))
	 {
		 $leyenda = "Por medio del presente escrito autorizo a la empresa DROMEDICAS DEL ORIENTE SAS, identificada con NIT 900265730-0, voluntariamente y sin coacción alguna descontar de mi salario la suma total de esta factura, esto para cancelación de la deuda generada actualmente con la ejecución del presente crédito y cabe aclarar que en caso de retiro descontar de mi liquidación de Prestaciones Sociales los saldos que se encuentren pendientes por pagar, de acuerdo con lo contemplado en los Art. 150 y 344 del Código Sustantivo del Trabajo".Chr(13).Chr(10).Chr(13).Chr(10);          $leyenda.= "El Empleado,".Chr(13).Chr(10).Chr(13).Chr(10);
		 $leyenda.= "__________________________".Chr(13).Chr(10);
		 $leyenda.= "C.C. ".Chr(13).Chr(10);                    
         
		 $cont.= Chr(13).Chr(10).$leyenda.Chr(13).Chr(10);
	 }
	 else
	 {
		 ////// Si es crédito pero no es para EMPLEADO 
		 if($creditos > 0)
	     {
		     $fecvence = $clase->SeleccionarUno("SELECT DATE_ADD( fechadoc, INTERVAL ".$diascredito." DAY )  FROM documentos D WHERE docuid=".$docuid);		   
			 $leyenda = "FORMA DE PAGO CREDITO CLIENTE AUTORIZADO".Chr(13).Chr(10); 
			 $leyenda.= "PLAZO : ".$diascredito." Dias".Chr(13).Chr(10);
			 $leyenda.= "FECHA VENCIMIENTO : ".substr($fecvence,0,10).Chr(13).Chr(10);
			 $leyenda.= '-----------------------------------------------'.Chr(13).Chr(10);
			 $cont.= $leyenda.Chr(13).Chr(10); 
	 	 } 
		 
		  /// Muestro los Pie de Pagina
	     if($pie1!= "")
	       $cont.= $pie1.Chr(13).Chr(10);
	     if($pie2!= "")
	       $cont.= $pie2.Chr(13).Chr(10);
	     if($pie3!= "")
	       $cont.= $pie3.Chr(13).Chr(10);
	     if($pie4!= "")
	       $cont.= $pie4.Chr(13).Chr(10);
	     if($pie5!= "")
	       $cont.= $pie5.Chr(13).Chr(10);	
		 
		 //// Aviso de NO se Aceptan Devoluciones
		 $cont.= "  >>  No se Aceptan Devoluciones <<  ".Chr(13).Chr(10);	
		 if(($_SESSION['G_SUCURSALPOS'] == "127")||($_SESSION['G_SUCURSALPOS'] == "240")||($_SESSION['G_SUCURSALPOS'] == "241")||($_SESSION['G_SUCURSALPOS'] == "244"))
		    $cont.= " servicioalcliente@drogueriasguasimales.com".Chr(13).Chr(10);	
	     else
		    $cont.= " servicioalcliente@farmanorte.com.co ".Chr(13).Chr(10);	

		///////////////////////////////////////////////////////////////////////////////////////////	
		////  Muestro la Barra de Participando .. si es Mayor a $ 40.000 Droguerias Farmanorte 
		if(($_SESSION['G_SUCURSALPOS'] == "127")||($_SESSION['G_SUCURSALPOS'] == "240")||($_SESSION['G_SUCURSALPOS'] == "241")||($_SESSION['G_SUCURSALPOS'] == "244"))
		{
			if($total >= 40000)
			{
				$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
				$cont.= '   POR ESTA COMPRA, ESTAS PARTICIPANDO !!!      '.Chr(13).Chr(10);	   
				$cont.= '   >>    SORTEO TV - MES DE LA MADRE    <<      '.Chr(13).Chr(10);	   
				$cont.= '------------------------------------------------'.Chr(13).Chr(10);      
			}
		}
		else
		{
			//////////////////////////////////////////////////////////////////////////////////////////
			//// Muestro la Barra de Participando .. si es Mayor a $ 25.000 Droguerias Farmanorte 
			$vsql5 = "SELECT COUNT(*)
						FROM dedocumentos DD INNER JOIN documentos D ON (DD.docuid = D.docuid) 
						INNER JOIN productos P ON (P.productoid = DD.productoid)
						INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid) 
						WHERE GP.concurso1 = 'CHECKED' AND D.docuid = ".$docuid;
			$tienepatrocinadores = $clase->SeleccionarUno($vsql5);         
			if(($tienepatrocinadores>0)&&($totalfv>=25000))
			{
				$cont.= '------------------------------------------------'.Chr(13).Chr(10);     	 	 
				$cont.= '    POR ESTA COMPRA, ESTAS PARTICIPANDO !!!     '.Chr(13).Chr(10);	   
				$cont.= '    >> SPA Y SERENATA - MES DE LA MADRE  <<     '.Chr(13).Chr(10);	   
				$cont.= '------------------------------------------------'.Chr(13).Chr(10);    
			}
		}
       	
        //// Finalmente le coloco el Pie de Pagina y los espacios de Separacion
        //   $cont.= str_pad("www.dromedicas.com.co",39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
	 }

     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.'.Chr(13).Chr(10);   
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D"; 
	 
     // Como mecanismo de Seguridad, guardo en el Dropbox copia de la Tira
     $archivo= "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/Impresora/Imp-".date("mY").".txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a");   // Abres el archivo para escribir en él
     fwrite($fch, $cont);           // Grabas
     fclose($fch);                  // Cierras el archivo

	 ////////////////////////////////////////////////
	 // Genero el Archivo para Enviarlo a Impresora
	 if($autoprint != 'N')
     	 $archivo= "../Dropbox/".$autoprint."/autoprint/autoprint-factura-".rand(11111,99999).".txt"; // el nombre de tu archivo
     else
     {	
       // Genero el Archivo para Enviarlo a Impresora
       if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR") 
       {
          $codImpre = $clase->BDLockup($_SESSION['USERNAME'],"usuarios","username","codimpresora");
          if(strlen($codImpre)>0) 	
          {	
             $rutaImpresion = $clase->BDLockup($codImpre,"impresoras","codigo","ruta");
     	     $archivo= "../../Dropbox/00/".$rutaImpresion."/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
          }
          else 
             $archivo= "../../Dropbox/00/print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
       }	 
       else  /// En Droguerias Imprime ahi
	   {
		   //// Imprimo el Cierre
		   $tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
		   if($tipo == "G")
		   {
				/// 1. Le Aplico Permisos a la Carpeta PDF
				chmod($acceso."print/", 0777);
				/// 2. Genero la Impresion  
				$archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo 
				/// 3. Le Aplico Permisos al archivo
				chmod("print/imprimircierre.txt", 0777);					
		   }				          	
		   else
		      $archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     		
	   }
     }

     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo

	 //// Si el Medio de Pago es Tarjetas - Imprimo la Copia de la Factura
	 $estarje = $clase->SeleccionarUno("SELECT valorfp2 + valorfp3 FROM docuventa WHERE docuid=".$docuid);
	 if($estarje > 0)
	 {   
     	$archivo= "print/facturacopia1.txt"; // el nombre de tu archivo
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch,Chr(13).Chr(10).$cont); // 
        fclose($fch); // Cierras el archivo
	 }

	 //// Marco la Factura como Impresa
	 $clase->EjecutarSQL("UPDATE documentos SET impreso = 'S' WHERE docuid=".$docuid);
     
	 return(true);	
  } // Fin de la Funcion


  //////////////////////////////////////////////////////////////////////////////
  //// Impresion Factura Cafeterias
  //////////////////////////////////////////////////////////////////////////////
  function ImpresionPOSFactura5($docuid,$autoprint='N',$reimpresion='N')
  {
      $clase = new Sistema();	 
	  $detalles = "";       $nombremoneda = "";
  	  $cont = "";

      $nombremoneda = @$_SESSION['G_MONEDALOCAL'];
	  $asentada = $clase->BDLockup($docuid,'documentos','docuid','fecasentado');
	  $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
      $cont = $nomempresa.Chr(13).Chr(10);	 

	  /// Cargo las configuraciones del Prefijo del Documento
	  $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	  $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");	  
	 
      $vsql = "SELECT * FROM consecutivos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'";
	  $conex  = $clase->Conectar();
      $result = @mysql_query($vsql,$conex);
	  if($row = @mysql_fetch_array($result))
	  {
				$encab1 = $row['encab1'];	
				$encab2 = $row['encab2'];	
				$encab3 = $row['encab3'];				    
				$encab4 = $row['encab4'];				    
				$encab5 = $row['encab5'];				    			    
				
			$pie1 = $row['pie1'];	    
			$pie2 = $row['pie2'];	    
			$pie3 = $row['pie3'];	    
			$pie4 = $row['pie4'];	    
			$pie5 = $row['pie5'];	 
			
			$txtres = $row['txtresolucion'];	    
	  }    
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , DD.observalinea , 
	  		  T.dni codcliente , D.terid2 , D.terid3 , CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , P.precio1m , 
			  T.telmovil , P.codigo codproducto , P.factor1 , P.porciva , DD.docuref , P.descripcion nomproducto , DD.valunitario , DD.valdescuento , 
			  SUM(DD.unicom) cajas , SUM(DD.unifra) unidades , SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26    
			  ORDER BY DD.dedocumid ASC";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
     
	 if($encab1!= "")
       $cont.= $encab1.Chr(13).Chr(10);
	 if($encab2!= "")
	   $cont.= $encab2.Chr(13).Chr(10);
 	 if($encab3!= "")
	   $cont.= $encab3.Chr(13).Chr(10);
 	 if($encab4!= "")
	   $cont.= $encab4.Chr(13).Chr(10);
 	 if($encab5!= "")
	   $cont.= $encab5.Chr(13).Chr(10);	 	 	 	 
	 
	 $teriddomi = "";  $domix = 0;
	 $condecreto = 0;  $totaldescuento = 0;
	 while($row = @mysql_fetch_array($result))
	 { 
 	   /// Nombre del Archivo para la Sincronizacion
	   $nombredoc = $row['tipodoc'].$row['prefijo'].abs($row['numero']); 
	   	   
	   $teriddomi = $row['terid3'];
	   $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
 	   
	   $subtotal = $row['base']; 
	   $iva      = $row['iva']; 	   
	   $total    = $row['total']; 

  	   $cliente  = substr($row['nomcliente'],0,24); 

   	   $nitcli   = $row['dni']; 	   
   	   $dircli   = $row['direccion']; 	   	   
   	   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   
   	   
       if($row['docuref'] == "*")
         $condecreto ++;

	   $vend = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid2']);
	   $vendedor = substr($vend,0,29); 

	   if($row['codproducto'] != 'DO')
	   {
 	     $valdcto = ($row['valparcial']*($row['valdescuento']/100));

 	     $detalles.= str_pad(substr($row['nomproducto'],0,27),27," ",STR_PAD_RIGHT).'  ';
		 $detalles.= str_pad($row['cajas'],3," ",STR_PAD_LEFT).' ';
		 
         if(strlen($row['observalinea'])>0)
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format((($row['cajas']*$row['factor1'])+$row['unidades'])*$row['valunitario']),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['cajas']*$row['precio1m'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	   
         }	
         else
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format(($row['valparcial'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['valparcial'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   	
         }	
		 
		 if($_SESSION['USERNAME'] == "VENTASPBX")
		   $detalles.= "Cod. Barra : ".$row['codproducto'].Chr(13).Chr(10); 	   	
		 
         if($valdcto>0)
          	$totaldescuento += $valdcto;
                  
         //// Adaptacion para las Recargas
         //// Muestra el Operador y el Numero a realizar la transaccion
         if(($row['codproducto'] == "R1000")||($row['codproducto'] == "R1001")) 
         {
           $vsqlx = "SELECT CONCAT('Num : ',numrecarga,' Operad : ', nomoperador) 
                     FROM transarecargas T INNER JOIN operadorcel O ON (T.codoperador = O.codoperador) WHERE T.idfactura = ".$docuid." ORDER BY transaid DESC LIMIT 0,1";
           $datoRecarga = $clase->SeleccionarUno($vsqlx);
           $detalles   .= $datoRecarga.Chr(13).Chr(10);
         }	  
           
		 //// SD : 001 Marzo 2015
		 //// Al usuario DOMICILIOS - Debe mostrar el Codigo de Barras del Producto
		 if($_SESSION['USERNAME'] == "DOMICILIOS")
		    $detalles.=	"Cod Barra: ".$row['codproducto'].Chr(13).Chr(10); 	     
	   }
	   else
	     $domix += $row['valparcial'];
     } 

	 $cont.= 'DOC. EQUIVALENTE No.'.$prefijo.' '.abs($numero).Chr(13).Chr(10);
	 $cont.= $txtres.Chr(13).Chr(10);	 	 	
	 $cont.= "ID Transaccion Auditoria : ".str_pad($docuid,10, "0", STR_PAD_LEFT).Chr(13).Chr(10);
	 
	 $mostrarobs = $clase->BDLockup($docuid,"documentos","docuid","CONCAT(observacion,' ',observacion2");
	 if(strlen($mostrarobs)>3)
	 {
		   $dircli = "";
		   $observacionfactura .= $mostrarobs.Chr(13).Chr(10);
		   $observacionfactura .= '------------------------------------------------'.Chr(13).Chr(10);     	 
	 }

	 $cont.= '------------------------------------------------'.Chr(13).Chr(10); 
	 $cont.= 'FECHA   : '.$fecha.'              Hora : '.$hora.Chr(13).Chr(10);	 
	 $cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
	 $cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);	 
	 if($dircli != "")   $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);	 
	 $cont.= 'TELEFON : '.trim($telcli).Chr(13).Chr(10).Chr(13);
	 $cont.= '------------------------------------------------'.Chr(13).Chr(10);             	 	              	 
     $cont.= 'VENDEDOR: '.$vendedor.Chr(13).Chr(10);	      
     $cont.= '------------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'PRODUCTO Y/O SERVICIO    CAJ UNI     TOTAL'.Chr(13).Chr(10);
     $cont.= '------------------------------------------'.Chr(13).Chr(10);     
	 $cont.= $detalles;	 
	 $cont.= '                            =============='.Chr(13).Chr(10);     
	 $cont.= ' SUBTOTAL            :      '.str_pad(number_format($subtotal+$totaldescuento-$domix),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= ' DESCUENTOS          :      '.str_pad(number_format($totaldescuento),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= ' I.V.A               :      '.str_pad(number_format($iva),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= ' TOTAL A PAGAR       :      '.str_pad(number_format($total),14," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 $cont.= '------------------------------------------'.Chr(13).Chr(10);    
	 

	 /// Especifico el Medio de Pago de la Factura
	 $efectivo = $clase->SeleccionarUno("SELECT valorfp1 FROM docuventa WHERE docuid=".$docuid);	 
	 	 
	 //// Pongo una linea por Cada medio de Pago
	 if($efectivo > 0)
	    $cont.= 'EFECTIVO  '.str_pad(number_format($efectivo),32," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 	 
	 $tarjetas = $clase->SeleccionarUno("SELECT valorfp2 + valorfp3 FROM docuventa WHERE docuid=".$docuid);	 
	 if($tarjetas > 0)
	     $cont.= 'TARJETAS DEB / CRED '.str_pad(number_format($tarjetas),21," ",STR_PAD_LEFT).Chr(13).Chr(10);
	 
	 $creditos = $clase->SeleccionarUno("SELECT valorfp4 FROM docuventa WHERE docuid=".$docuid);	 
	 if(($creditos > 0)&&($_SESSION['G_MODOTRABAJO'] == "SERVIDOR"))
	     $cont.= 'CREDITOS              '.str_pad(number_format($creditos),19," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 
	 
	 $cont.= '------------------------------------------'.Chr(13).Chr(10);     	 	 
	 
	 /// Consulto si hubo que dar vueltos 
	 $vueltos = $clase->BDLockup($docuid,'docuventa','docuid','vueltos');
	 if(($vueltos > 0)&&($efectivo > 0))
	 {
   	   $cont.= 'VUELTOS A ENTREGAR   '.str_pad(number_format($vueltos),20," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
	   $cont.= '------------------------------------------'.Chr(13).Chr(10);     	 	 
	 }
	
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.'.Chr(13).Chr(10);   
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D"; 
	 /*
     // Como mecanismo de Seguridad, guardo en el Dropbox copia de la Tira
     $archivo= "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/Impresora/Imp-".date("mY").".txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a");   // Abres el archivo para escribir en él
     fwrite($fch, $cont);           // Grabas
     fclose($fch);                  // Cierras el archivo

	 ////////////////////////////////////////////////
	 // Genero el Archivo para Enviarlo a Impresora
	 if($autoprint != 'N')
     	 $archivo= "../Dropbox/".$autoprint."/autoprint/autoprint-factura-".rand(11111,99999).".txt"; // el nombre de tu archivo
     else
     {	
       // Genero el Archivo para Enviarlo a Impresora
       if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR") 
       {
          $codImpre = $clase->BDLockup($_SESSION['USERNAME'],"usuarios","username","codimpresora");
          if(strlen($codImpre)>0) 	
          {	
             $rutaImpresion = $clase->BDLockup($codImpre,"impresoras","codigo","ruta");
     	     $archivo= "../../Dropbox/00/".$rutaImpresion."/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
          }
          else 
             $archivo= "../../Dropbox/00/print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
       }	 
       else  /// En Droguerias Imprime ahi
         $archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
     }
*/
 	//// Imprimo el Cierre
	 $tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
	 if($tipo == "G")
	 {
		  /// 1. Le Aplico Permisos a la Carpeta PDF
		  chmod($acceso."print/", 0777);
		  /// 2. Genero la Impresion  
		  $archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo 
		  /// 3. Le Aplico Permisos al archivo
		  chmod("print/imprimircierre.txt", 0777);					
	 }	         
	 else
	     $archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo 	

     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo

	 //// Marco la Factura como Impresa
	 $clase->EjecutarSQL("UPDATE documentos SET impreso = 'S' WHERE docuid=".$docuid);
     
	 return(true);	
  } // Fin de la Funcion


  //////////////////////////////////////////////////////////////////////
  ////////////////Impresion POS Cotizacion ////////////////////////////
  /////  Autoprint == N o Autoprint = CodSucursal
  function ImpresionPOSCotizacion($docuid,$autoprint='N')
  {
     $clase = new Sistema();	 
	 $detalles = "";       $nombremoneda = "";
	 $cont = "";

     $nombremoneda = @$_SESSION['G_MONEDALOCAL'];
	 $asentada = $clase->BDLockup($docuid,'documentos','docuid','fecasentado');
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
     $cont = $nomempresa.Chr(13).Chr(10);	 
	 
	 /// Cargo las configuraciones del Prefijo del Documento
	 $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	 $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");	  
	 
	 $txtbolsas = "Ley 1819 de 2016 INC Bolsas Plasticas";

     $vsql = "SELECT * FROM consecutivos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."'";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 if($row = @mysql_fetch_array($result))
	 {
	    $encab1 = $row['encab1'];	
	    $encab2 = $row['encab2'];	
	    $encab3 = $row['encab3'];				    
	    $encab4 = $row['encab4'];				    
	    $encab5 = $row['encab5'];				    			    
	    
		$pie1 = $row['pie1'];	    
		$pie2 = $row['pie2'];	    
		$pie3 = $row['pie3'];	    
		$pie4 = $row['pie4'];	    
		$pie5 = $row['pie5'];	 
		
		$txtres = $row['txtresolucion'];	    
	 }    
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.fecasentado , D.fecanulado , D.base , D.iva ,  D.total , DD.observalinea , 
	  		  T.dni codcliente , D.terid2 , D.terid3 , CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , P.precio1m , 
			  T.telmovil , P.codigo codproducto , P.factor1 , DD.docuref , P.descripcion nomproducto , DD.valunitario , DD.valdescuento , 
			  SUM(DD.unicom) cajas , SUM(DD.unifra) unidades , SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25    
			  ORDER BY DD.dedocumid ASC";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
     
	 if($encab1!= "")
       $cont.= $encab1.Chr(13).Chr(10);
	 if($encab2!= "")
	   $cont.= $encab2.Chr(13).Chr(10);
 	 if($encab3!= "")
	   $cont.= $encab3.Chr(13).Chr(10);
 	 if($encab4!= "")
	   $cont.= $encab4.Chr(13).Chr(10);
 	 if($encab5!= "")
	   $cont.= $encab5.Chr(13).Chr(10);	 	 	 	 
	 
	 $teriddomi = "";  $domix = 0;
	 $condecreto = 0;  $totaldescuento = 0;
	 while($row = @mysql_fetch_array($result))
	 { 
 	   /// Nombre del Archivo para la Sincronizacion
	   $nombredoc = $row['tipodoc'].$row['prefijo'].$row['numero']; 
	   
	   $teriddomi = $row['terid3'];
	   $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['fechadoc'],11,2).":".substr($row['fechadoc'],14,2); 	   
 	   
	   $subtotal = $row['base']; 
	   $iva      = $row['iva']; 	   
	   $total    = $row['total']; 

  	   $cliente  = substr($row['nomcliente'],0,24); 

   	   $nitcli   = $row['dni']; 	   
   	   $dircli   = $row['direccion']; 	   	   
   	   $telcli   = $row['telmovil']." ".$row['telfijo']; 	   	   	   
   	   
       if($row['docuref'] == "*")
         $condecreto ++;

	   $vend = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$row['terid2']);
	   $vendedor = substr($vend,0,27); 

	   if($row['codproducto'] != 'DO')
	   {
 	     $valdcto = ($row['valparcial']*($row['valdescuento']/100));

 	     $detalles.= str_pad(substr($row['nomproducto'],0,19),19," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad($row['cajas'],3," ",STR_PAD_LEFT).' '.str_pad($row['unidades'],3," ",STR_PAD_LEFT).'  ';
		 
         if(strlen($row['observalinea'])>0)
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format((($row['cajas']*$row['factor1'])+$row['unidades'])*$row['valunitario']),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['cajas']*$row['valunitario'])),9," ",STR_PAD_LEFT).Chr(13).Chr(10).$row['observalinea'].Chr(13).Chr(10); 	   
         }	
         else
         {
	          if($row['unidades'] > 0)
			     $detalles.= str_pad(number_format((($row['cajas']*$row['factor1'])+$row['unidades'])*$row['valunitario']),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	    
			  else 
			     $detalles.= str_pad(number_format(($row['valparcial']-$valdcto)),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   	
         }	

		 
         if($valdcto>0)
          	$totaldescuento += $valdcto;
			
		
		 //// SD : 001 Marzo 2015
		 //// Al usuario DOMICILIOS - Debe mostrar el Codigo de Barras del Producto
		 if($_SESSION['USERNAME'] == "DOMICILIOS")
		    $detalles.=	"Cod Barra: ".$row['codproducto'].Chr(13).Chr(10); 	     
	   }
	   else
	     $domix += $row['valparcial'];
     } 

	 $cont.= 'COTIZACION No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
	 $cont.= "ID Transaccion Auditoria : ".str_pad($docuid,10, "0", STR_PAD_LEFT).Chr(13).Chr(10);
     $cont.= '---------------------------------------'.Chr(13).Chr(10); 
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
	 $cont.= 'CLIENTE : '.$cliente.Chr(13).Chr(10);
	 $cont.= 'IDENTIF : '.$nitcli.Chr(13).Chr(10);
	 $cont.= 'DIRECC  : '.$dircli.Chr(13).Chr(10);
	 $cont.= 'TELEFON : '.trim($telcli).Chr(13).Chr(10).Chr(13);
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          	 	
     
	 $medicoid = $clase->SeleccionarUno("SELECT medicoid FROM docuventa WHERE docuid=".$docuid);
	 if($medicoid != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT nommedico FROM medicos WHERE medicoid=".$medicoid);
		$cont.= 'MEDICO  : '.substr(strtoupper($domi),0,27).Chr(13).Chr(10);
        $cont.= '---------------------------------------'.Chr(13).Chr(10);     	 
	 }     	 
	 
	 if($teriddomi != 1)
	 {
        $domi = $clase->SeleccionarUno("SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE terid=".$teriddomi);
		$cont.= 'MENSAJE : '.substr($domi,0,27).Chr(13).Chr(10);
        $cont.= '---------------------------------------'.Chr(13).Chr(10);     	 
	 }         
	 
     $cont.= 'VENDEDOR: '.$vendedor.Chr(13).Chr(10);	      
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'PRODUCTO             CAJ UNI      TOTAL'.Chr(13).Chr(10);
     $cont.= '---------------------------------------'.Chr(13).Chr(10);     
	 $cont.= $detalles;	 
	 $cont.= '                            -----------'.Chr(13).Chr(10);     
	 $cont.= '   TOTAL COTIZACION '.$nombremoneda.'   '.str_pad(number_format($total),16," ",STR_PAD_LEFT).Chr(13).Chr(10);     	 
	 $cont.= '                            ==========='.Chr(13).Chr(10);     
	 
	  $cont.= '---------------------------------------'.Chr(13).Chr(10);     	 
	 $cont.= '****************************************'.Chr(13).Chr(10);     	 
	 $cont.= '*** NO VALIDO COMO FACTURA DE VENTA  ***'.Chr(13).Chr(10);     	
	   
	 
     if($condecreto > 0)
     {
        $cont.= Chr(13).Chr(10);
        $cont.= '***************************************'.Chr(13).Chr(10);     	 
        $cont.= '***     DESCUENTO DEL IVA SEGUN    ****'.Chr(13).Chr(10);     	  
        $cont.= '***      DECRETO 1818 DE 2015      ****'.Chr(13).Chr(10);     	 
		$cont.= '***************************************'.Chr(13).Chr(10).Chr(13).Chr(10);
	
     }
	 
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.'.Chr(13).Chr(10);   
     $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";  

     // Como mecanismo de Seguridad, guardo en el Dropbox copia de la Tira
     $archivo= "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/Impresora/Imp-".date("mY").".txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a");   // Abres el archivo para escribir en él
     fwrite($fch, $cont);           // Grabas
     fclose($fch);                  // Cierras el archivo

	 ////////////////////////////////////////////////
	 // Genero el Archivo para Enviarlo a Impresora
	 if($autoprint != 'N')
     	 $archivo= "../Dropbox/".$autoprint."/autoprint/autoprint-factura-".rand(11111,99999).".txt"; // el nombre de tu archivo
     else
     {	
       // Genero el Archivo para Enviarlo a Impresora
       if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR") 
       {
          $codImpre = $clase->BDLockup($_SESSION['USERNAME'],"usuarios","username","codimpresora");
          if(strlen($codImpre)>0) 	
          {	
             $rutaImpresion = $clase->BDLockup($codImpre,"impresoras","codigo","ruta");
     	     $archivo= "../../Dropbox/00/".$rutaImpresion."/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
          }
          else 
             $archivo= "../../Dropbox/00/print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo
       }	 
       else  /// En Droguerias Imprime ahi
	   {
			$tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
			if($tipo == "G")
			{
				/// 1. Le Aplico Permisos a la Carpeta PDF
				chmod($acceso."print/", 0777);
				/// 2. Genero la Impresion  
				$archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo 
				/// 3. Le Aplico Permisos al archivo
				chmod("print/imprimircierre.txt", 0777);					
			}	        		          	
            else
		      $archivo= "print/imp-venta-".rand(11111,99999).".txt"; // el nombre de tu archivo     	
	   }
     }

     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo

    if($autoprint == 'N')
    {	
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("my")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 /// La marco en la Base de datos como Impresa
     $clase->EjecutarSQL("UPDATE documentos SET impreso = 'S' WHERE docuid=".$docuid);
	 $clase->EjecutarSQL("UPDATE docuventa SET impreso = CURRENT_TIMESTAMP WHERE docuid=".$docuid);
	 
	 //// Marco la Factura como Impresa
	 $clase->EjecutarSQL("UPDATE documentos SET impreso = 'S' WHERE docuid=".$docuid);
     
	 return(true);	
    }	 
  } // Fin de la Funcion
  

  /////////////////////////////////////////////////////////////////////////////////////
  ///// MODULO : VENTAS   -   Envia al Servidor Web la Venta al Instante
  /////////////////////////////////////////////////////////////////////////////////////  
  function EnviarVentasInstanteServidor()
  {
	  $clase = new Sistema();
	  ini_set("memory_limit","200M");
 	  set_time_limit(0);
    
       $vsql = "SELECT T2.codvende , T2.nombres , T2.apellidos , S.codigo codsucursal , S.zona codzona , Z.codregion codregion , DV.diaoperativo , SUM(DD.valtotal) ventagen , 
				SUM(IF(P.porcenboni>0,DD.valtotal,0)) ventaespe , SUM(IF(P.descripcion like 'SUREZINC%',DD.unicom,0)) surezinc , SUM(IF((P.gruposprodid = 596 OR P.gruposprodid = 578),DD.valtotal,0)) ventalicores
				FROM terceros T2 INNER JOIN documentos D ON (D.terid2 = T2.terid) INNER JOIN docuventa DV ON (DV.docuid = D.docuid) INNER JOIN sucursales S ON (S.sucursalid = D.sucursalid) INNER JOIN zonas Z ON (Z.codzona = S.zona) INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) INNER JOIN productos P ON (P.productoid = DD.productoid) 
				WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo = '".$_SESSION['G_DIAOPERATIVO']."' GROUP BY 1,2,3,4,5,6,7";

	   $conex  = $clase->Conectar();
	   $result = mysql_query($vsql,$conex);  
	   $i = 0;
	   while($row = mysql_fetch_array($result))
	   {
			$tipodoc    = $row['tipodoc'];  
			$prefijo    = $row['prefijo'];  
			$numero     = $row['numero']; 			  
	   }
	   
	   return;			 
  }


  /////////////////////////////////////////////////////////////////////////////////////
  ///// MODULO : Transferencias   -    Permite Cargar una Transferencia desde Archivo 
  /////////////////////////////////////////////////////////////////////////////////////  
  function CargarRemision($numerorem)  // TRBCRU201456
  {
     $clase = new Sistema();
     ini_set("memory_limit","200M");
     set_time_limit(0);
	
	 
	 $ruta      = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/transferencias/".$numerorem.".txt";
	 if(file_exists($ruta))
	 {	 
       $docuid = "";
	   $numlinea = 1;
	   $continuar = "S";
	  
	   if(substr($numerorem,0,6) == "TRBCOD") 
	      $clase->EjecutarSQL("DELETE FROM documentos WHERE CONCAT(tipodoc,prefijo,numero) = '".$numerorem."'");  
	   
	   $fp = fopen($ruta,"r");	   
	   while ($linea= fgets($fp,2048))
       {
		  sleep(2);
		  if($numlinea == 1)
		  {
		    $clase->EjecutarSQL($linea);			
		  }		  
		  else
		  {	
		     
			 if($numlinea == 2)  
			 {
		        $inserto = $clase->EjecutarSQL(substr($linea,1,2048));
				if($inserto > 0){
				  $continuar = "S";   				  
				}
				else
				  $continuar = "N";				  
			 }	
			 else
			 {
			    
			   if($continuar == "S")	
			   {
				if($numlinea == 3)
				{
				  if(substr($linea,0,11)=='|SELECTUNO|')  
		            $docuid = $clase->SeleccionarUno(substr($linea,11,2048));
					
				  $clase->EjecutarSQL("UPDATE documentos SET base = 0 , iva = 0 , total = 0 WHERE docuid=".$docuid);		
				  
				} 
				else
				{
				   if($docuid != "")
				   {
				      $linea2 = str_replace("|||||",$docuid,$linea);
					 
					  if((substr($linea2,0,3) == "**I")||(substr($linea2,0,3) == "**D"))
					     $clase->EjecutarSQL(substr($linea2,2,2048));							 
					  
					  if(substr($linea2,0,3) == "***")
						 $clase->EjecutarSQL(substr($linea2,3,2048)); 	
					  			 				   
			      }
                } 
			  }	
			}			  
		  }	 
 
		 $numlinea++;	
		 	     		  
       } /// Fin del While
	   
     } /// Fin de If File Exist
	/// Cierro el Archivo
    fclose($fp);
	
	/// Elimino el Archivo  luego de Cargar la remision para prevenir almacenamiento en Disco
	if(file_exists($ruta))
	 unlink($ruta);

	/// Elimino los Productos que esten con Cantidad Cero
    $clase->EjecutarSQL("DELETE FROM dedocumentos WHERE cantidad = 0 AND docuid=".$docuid);

	/// Cambio la de Asentar
	if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR")
	{
        //// Controlo que la Bodega de Destino sea la Misma que la Bodega Actual que tengo en Sesion
		$clase->EjecutarSQL("UPDATE docutranfe SET cargadodestino = 'CHECKED' WHERE cargadodestino IS NULL AND docuid = ".$docuid);

		/// Genero la remision a las tablas de Auditoria
		$numremision = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,prefijo,numero) FROM documentos WHERE docuid=".$docuid);
		$clase->EjecutarSQL("CALL PA_GenerarAuditoria('".$numremision."')"); 
	}
	  
	return($docuid);	 	 
  } // Fin de la Funcion


/////////////////////////////////////////////////////////////////////////////////////////////
  /// Cargar Pedido de Sucursales
  ///////////////////////////////////////////////////////////////
  function CargarPedido($numerorem)
  {
	 $clase = new Sistema();
     $esurgente = "N";                     $docuid="";
	 $ruta      = "../Dropbox/00/pedidos/".$numerorem.".txt";
	 
	 if(!file_exists($ruta))
	 {  
	    $ruta    = "../Dropbox/00/pedidosu/".$numerorem.".txt";
		$esurgente = "S";
	 }	

	 if(!file_exists($ruta))
	 {  
	    $ruta    = "../Dropbox/00/pedidosc/".$numerorem.".txt";
		$esurgente = "S";
	 }	
  
	 if(!file_exists($ruta))
	 {  
	    $ruta    = "../Dropbox/DB/pedidosu/".$numerorem.".txt";
		$esurgente = "S";
	 }	

	 if(!file_exists($ruta))
	 {  
	    $ruta    = "../Dropbox/DB/pedidosc/".$numerorem.".txt";
		$esurgente = "S";
	 }

	 if(!file_exists($ruta))
	 {  
	    $ruta    = "../Dropbox/DB/pedidos/".$numerorem.".txt";
		$esurgente = "S";
	 }

     if(file_exists($ruta))
	 { 	 
	   $docuid = "";
	   $numlinea = 1;
	   $cantotal = 0;         $valtotal = 0; 
	   $fp = fopen($ruta,"r");	   
	   while ($linea= fgets($fp,2048))
       {
	      if($numlinea == 1)
		  {
		    $clase->EjecutarSQL($linea);			
		  }		  
		  else
		  {	
		     
			 if($numlinea == 2)  
			 {
		        $clase->EjecutarSQL(substr($linea,1,2048));
			 }	
			 else
			 {
			    if($numlinea == 3)
				{
				  if(substr($linea,0,11)=='|SELECTUNO|')  
		            $docuid = $clase->SeleccionarUno(substr($linea,11,2048));

			      $clase->EjecutarSQL("UPDATE documentos SET base = 0 , iva = 0 , total = 0 WHERE docuid=".$docuid);		
				} 
				else
				{
				   if($docuid != "")
				   {
				      $linea2 = str_replace("|||||",$docuid,$linea);
                   
					  if(substr($linea2,0,3) == "**I")
					     $clase->EjecutarSQL(substr($linea2,2,2048));							 
					  
					  if(substr($linea2,0,3) == "***")
					     $clase->EjecutarSQL(substr($linea2,3,2048));
					 
				   }
                } 
			 }
		  }	 
 
		 $numlinea++;	
       } /// Fin del While
	   
     } /// Fin de If File Exist

	/// Le Asigno el Consecutivo Unioco de Pedidos de Sucursales PVE - DEP - 0000X
	$numante = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,prefijo,numero) FROM documentos WHERE docuid=".$docuid);		 
    $numero = $clase->SeleccionarUno("SELECT numero FROM consecutivos WHERE tipodoc='PVE' AND prefijo='".$_SESSION['G_PREF_PVE']."'");		 
	$numerox = str_pad(($numero+1),6,0,STR_PAD_LEFT);
	$clase->EjecutarSQL("UPDATE consecutivos SET numero = ".$numerox." WHERE tipodoc='PVE' AND prefijo='".$_SESSION['G_PREF_PVE']."'");	 
		
	/// Si es Urgente Lo reverso
	$clase->EjecutarSQL("UPDATE documentos SET observacion = '".$numante."' , prefijo = '".$_SESSION['G_PREF_PVE']."' , fecasentado = '0000-00-00' , numero = '".$numerox."', impreso='N' WHERE docuid=".$docuid);		 

	/// Cierro el Archivo
    fclose($fp);
	
	/// Elimino el Archivo  luego de Cargar la remision para prevenir almacenamiento en Disco
	if(file_exists($ruta))
	 unlink($ruta);
    
 	return($docuid);	 	 
  } // Fin de la Funcion

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////  
  function CargarRemisionAutomatica($numerorem)
  {
     ini_set("memory_limit","200M");
     set_time_limit(0);

     $clase = new Sistema();
	 $ruta      = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/automatico/".$numerorem;
	 $rutahecho = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/transferencias/".$numerorem;
	 
	 if(file_exists($ruta))
	 {	 
       $docuid = "";
	   $numlinea = 1;
	   
	   $fp = fopen($ruta,"r");	   
	   while ($linea= fgets($fp,1024))
       {
	      if($numlinea == 1)
		  {
		    $clase->EjecutarSQL($linea);			
		  }		  
		  else
		  {	
			 if($numlinea == 2)  
			 {
		        $clase->EjecutarSQL(substr($linea,1,2048));
			 }	
			 else
			 {
			    if($numlinea == 3)
				{
				  if(substr($linea,0,11)=='|SELECTUNO|')  
		            $docuid = $clase->SeleccionarUno(substr($linea,11,2048));
					
			      $clase->EjecutarSQL("UPDATE documentos SET base = 0 , iva = 0 , total = 0 WHERE docuid=".$docuid);		
				} 
				else
				{
				   if($docuid != "")
				   {
				      $linea2 = str_replace("|||||",$docuid,$linea);
					 
					  if(substr($linea2,0,3) == "**I")
						 $clase->EjecutarSQL(substr($linea2,2,2048));							 
					  
					  if(substr($linea2,0,3) == "**D")
					     $clase->EjecutarSQL(substr($linea2,2,2048));		 
					  
					  if(substr($linea2,0,3) == "***")
					     $clase->EjecutarSQL(substr($linea2,3,2048)); 					 				   
				   }
                } 
			 }
			  
		  }	 
		 
		 $numlinea++;	
		   		  
       } /// Fin del While
	   
	    /// Asiento la Tranferencia para que Descuente el Inventario
		$fechadoc  = date("Y-m-d");
        $vsql = "UPDATE documentos SET fecasentado ='".$fechadoc."' WHERE docuid=".$docuid;
		$clase->EjecutarSQL($vsql);
		
     } /// Fin de If File Exist
	
	/// Cierro el Archivo Ocupado
	@fclose($fp);
	
	/// Genero la Impresion del Documento
	ImpresionPOSGeneral($docuid);

	$tipoprefnumero = $clase->BDLockup($docuid,"documentos","docuid","CONCAT(tipodoc,prefijo,numero)");
	$tiene = $clase->SeleccionarUno("SELECT COUNT(*) FROM kardex WHERE CONCAT(tipodoc,prefijo,numero) = '".$tipoprefnumero."'");
	if($tiene == 0)
	{
		$vsql = "CALL PA_AsentarTransferencia(".$docuid.")";
		$clase->EjecutarSQL($vsql);
	}
	
	/// Finalizado el Proceso, Muevo el Archivo a hecho
	@copy($ruta,$rutahecho);
	//@unlink($ruta);	 	 
  } 
  

  /////////////////////////////////////////////////////////////////////////////////////////// 
  /////////////////////////////////////////////////////////////////////////////////////////// 
  function GenerarKardexOrigenx($docuid)
  {
     ini_set("memory_limit","200M");                            set_time_limit(0);
     $clase = new Sistema();
     $clase->Nombredb = $_SESSION['DBNOMBRE']; 
     $bodid = $clase->BDLockup($docuid,'docutranfe','docuid','bodegaidori');
     $sucid = $clase->BDLockup($bodid,'bodegas','bodegaid','sucursalid');
     $vsql  = "SELECT * FROM dedocumentos DD INNER JOIN documentos D ON (D.docuid = DD.docuid) INNER JOIN productos P ON (P.productoid = DD.productoid) WHERE D.docuid=".$docuid;
     
     $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);  
     $i = 0;
     while($row = mysql_fetch_array($result))
     {
        $tipodoc    = $row['tipodoc'];  
        $prefijo    = $row['prefijo'];  
        $numero     = $row['numero']; 
        $fechadoc   = $row['fechadoc'];     
        $periodo    = $row['periodo'];          
     
        $productoid = $row['productoid']; 
        $cantidad   = ((-1)*($row['unidades']));

        $creador    = $row['creador'];  
        $momento    = $row['momento'];

        if($i == 0)
        {
           //// Limpio los movimientos anteriores si los hay
           $clase->EjecutarSQL("DELETE FROM kardex WHERE tipodoc = '".$tipodoc."' AND prefijo = '".$prefijo."' AND numero = '".$numero."' AND bodegaid=".$bodid);
        }

     $vsqlx = "INSERT INTO kardex(tipodoc,prefijo,numero,fechadoc,periodo,productoid,bodegaid,sucursalid,cantidad,creador,momento) 
              VALUES('".$tipodoc."','".$prefijo."','".$numero."','".$fechadoc."','".$periodo."',".$productoid.",".$bodid.",".$sucid.",".$cantidad.",'".$creador."','".$momento."')";
     $clase->EjecutarSQL($vsqlx);      
     $i++;
     }  
    return; 
  }

  //////////////////////////////////////////////////////////////////////
  ////           Impresion de Ajuste de Inventario
  //////////////////////////////////////////////////////////////////////  
  function ImpresionPOSGeneral($docuid,$carpeta="print",$copias=1)
  {
     $clase = new Sistema();	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
     $cont = $nomempresa.Chr(13).Chr(10);	 
	 
	 /// Cargo las configuraciones del Prefijo del Documento
	 $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	 $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");	  
	 $nomdocumento = $clase->BDLockup($tipodoc,"tipodoc","codigo","descripcion");	  
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.creador , D.fecanulado , D.observacion , D.iva ,  D.total , D.momento , T.dni codcliente , D.terid2 , D.terid3 , 
	 		  CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , DD.bodegaid , P.codigo codproducto , P.descripcion nomproducto , DD.valunitario , 
			  SUM(DD.cantidad) cantidad , SUM(DD.unidades) unidades ,  SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21";

    if($tipodoc == "AJU")
	   $vsql.= ' ORDER BY cantidad DESC , P.descripcion';

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
     
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $teriddomi = $row['terid3'];
	   $tipodoc = $row['tipodoc'];                       $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['momento'],11,2).":".substr($row['momento'],14,2); 	   

   	   $observacion = $row['observacion'];  	   
   	   $cantidad = $row['cantidad']; 
	   $creador  = $row['creador']; 	   
   	   $total    = $row['total']; 
	     
	   if($tipodoc == "AJU")
	   {    
    	 if($cantidad < 0)  $mov = "SAL - "; else $mov = "ENT - ";
		 $bodega = $clase->BDLockup($row['bodegaid'],'bodegas','bodegaid','codbodega');
		 $encabezado1 = ''; 
	     $detalles.= $mov.str_pad(substr($row['nomproducto'],0,20),20," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad(number_format($row['unidades'],1),3," ",STR_PAD_LEFT).'  '.str_pad(number_format($row['valparcial'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
		 $titulodet = 'MOV   PRODUCTO             CANT      TOTAL';
	   }
	   
	   if(($tipodoc == "REN")||($tipodoc == "INF"))
	   {    
	     $bodega = $clase->BDLockup($row['bodegaid'],'bodegas','bodegaid',"nombodega");
		 $encabezado1 = 'BODEGA   : '.$bodega; 
		 $detalles.= str_pad(substr($row['nomproducto'],0,26),26," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad($row['cantidad'],3," ",STR_PAD_LEFT).'  '.str_pad(number_format($row['valparcial']),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
		 $titulodet = 'PRODUCTO                 CANT      TOTAL';
	   }
	   
	   if(($tipodoc == "TRB")||($tipodoc == "TXC"))
	   {    
	     $bodegaori = $clase->BDLockup($row['bodegaid'],'bodegas','bodegaid',"nombodega");
		 $vsql1 = "SELECT nombodega FROM bodegas B INNER JOIN docutranfe DT ON (DT.bodegaidori = B.bodegaid) WHERE docuid=".$docuid;
		 $vsql2 = "SELECT nombodega FROM bodegas B INNER JOIN docutranfe DT ON (DT.bodegaiddes = B.bodegaid) WHERE docuid=".$docuid;		 
		 $bodori = $clase->SeleccionarUno($vsql1);
		 $boddes = $clase->SeleccionarUno($vsql2);		 
		 $encabezado1 = 'BOD. ORIGEN : '.$bodori.Chr(13).Chr(10);
		 $encabezado1.= 'BOD. DESTIN : '.$boddes;
		 $detalles.= str_pad(substr($row['nomproducto'],0,24),24," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad($row['unidades'],3," ",STR_PAD_LEFT).'  '.str_pad(number_format($row['valparcial']),9," ",STR_PAD_LEFT).Chr(13).Chr(10);;
		 $detalles.= "Cod Barras : ".$row['codproducto'].Chr(13).Chr(10); 	   
		 
		 $titulodet = 'PRODUCTO                 CANT      TOTAL';
	   } 
	   	 
     } 

     $cont.= $nomdocumento.Chr(13).Chr(10);
	 $cont.= 'No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
     $cont.= '----------------------------------------'.Chr(13).Chr(10); 
	 $cont.= 'OBS : '.$observacion.Chr(13).Chr(10);	 	 
     $cont.= '----------------------------------------'.Chr(13).Chr(10); 	 
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
	 $cont.= 'CREADOR : '.$creador.Chr(13).Chr(10);	 
     if($encabezado1 != "")
	 {
	    $cont.= '----------------------------------------'.Chr(13).Chr(10);          	 	
	    $cont.= $encabezado1.Chr(13).Chr(10);
	 }
	 $cont.= '----------------------------------------'.Chr(13).Chr(10);          	 	
     $cont.= $titulodet.Chr(13).Chr(10);
     $cont.= '========================================'.Chr(13).Chr(10);     
	 $cont.= $detalles;	 
	 $cont.= '                          --------------'.Chr(13).Chr(10);     
	 $cont.= '         TOTAL DOC : '.$_SESSION['G_MONEDALOCAL'].'   '.str_pad(number_format($total),16," ",STR_PAD_LEFT).Chr(13).Chr(10);     	 
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).'.'.Chr(13).Chr(10);     
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";

	 for($c=0;$c<$copias;$c++)
	 {
	    // Genero el Archivo para Enviarlo a Impresora
	    if($carpeta == "autoprint")
	       $archivo= "../Dropbox/00/autoprint/".$prefijo.$numero."-".$c.".txt"; // el nombre de tu archivo
	    else
		{
			$tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
			if($tipo == "G")
			{
				/// 1. Le Aplico Permisos a la Carpeta PDF
				chmod($acceso."print/", 0777);
				/// 2. Genero la Impresion  
				$archivo= "print/".$prefijo.$numero.".txt"; // el nombre de tu archivo
				/// 3. Le Aplico Permisos al archivo
				chmod("print/imprimircierre.txt", 0777);					
			}			    
			else
			    $archivo= "print/".$prefijo.$numero.".txt"; // el nombre de tu archivo
		}
		   
        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch, $cont); // Grabas
        fclose($fch); // Cierras el archivo

        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch, $cont); // Grabas
        fclose($fch); // Cierras el archivo
     }
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 	 
  } // Fin de la Funcion


  /////////////////////////////////////////////////////////////////////////  
  function ImpresionPOSKardex($vsql)
  {
	 $clase = new Sistema();
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];
     $sucursal   = $_SESSION['G_SUCURSALPOS'];
	 $nomsucursal = $clase->BDLockup($sucursal,'sucursales','codigo','descripcion');
	 $momento    = date("D, d M Y H:i:s T");
	 
	 $cont.=  Chr(13).Chr(10).$nomempresa.Chr(13).Chr(10);	
	 $cont.=  $nitempresa.Chr(13).Chr(10);		 
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          
     $cont.= 'SUCURSAL : '.$nomsucursal.Chr(13).Chr(10);               
     $cont.= '---------------------------------------'.Chr(13).Chr(10);          

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
     $grupo = "";
	 while($row = @mysql_fetch_array($result))  	
	 {
       $grupo = $row['grupo'];
	   $encab = 'BODEGA : '.$row['nombodega'].Chr(13).Chr(10);		 
       $encab.= '---------------------------------------'.Chr(13).Chr(10);          	   
       $encab.= 'LABORAT: '.$row['grupo'].Chr(13).Chr(10);		 	   
       $encab.= '======================================='.Chr(13).Chr(10); 
       $encab.= 'ARTICULO/CODIGO    UNIDAD   CAJ    UNID'.Chr(13).Chr(10);		 	   	            	   	   
       $encab.= '======================================='.Chr(13).Chr(10);          	   	   	   
       
	   $empaque  = $row['factor1'];
	   $detallar = $row['detallar'];
       $existencia = $row['cantidad'];
	   
	   if(abs($existencia) == 0){
	        $cajas = 0;     $unidades = 0;
   	   }
       else
       {
		 $partescanti = explode(".",$existencia);
       	 $cajas       = $partescanti[0];		  
         $decimal     = (round($existencia,10)-$cajas);
         $unidades    =  number_format(round(($decimal*$empaque),0),0);	
         if(($unidades == $empaque)&&($unidades!=0)){ 
	           $cajas++;
	           $unidades=0;
          }     
       } 
	   	
       $det  .= substr($row['descripcion'],0,40).Chr(13).Chr(10);
       $det  .= str_pad(substr($row['codigo'],0,15),15," ",STR_PAD_RIGHT).'     '.str_pad(substr($row['unidet'],0,4),4," ",STR_PAD_RIGHT).'  ';
	   $det  .= str_pad(substr(number_format($cajas,0),0,5),5," ",STR_PAD_LEFT);

	   if($_SESSION['G_MODOTRABAJO'] == "PUNTODEVENTA")
  	       $det  .= str_pad(substr(number_format($unidades,0),0,5),5," ",STR_PAD_LEFT).Chr(13).Chr(10);	   
	   else
           $det  .= str_pad(substr(number_format($unidades,0),0,5),5," ",STR_PAD_LEFT)."    _______  _______".Chr(13).Chr(10);	   	   	   
	 }  

     //// Genero la Tira 
	 $cont.= $encab.$det.Chr(13).Chr(10).$momento.Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
	 $cont.= "REALIZO : ___________________".Chr(13).Chr(10).Chr(13).Chr(10);
	 
     /// Web
     $cont.= str_pad($_SESSION['G_SITIOWEB_PRO'],39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';
     if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR") 
        $cont.= Chr(12).Chr(13);     
	 
     ///// Corte de Hoja
     //$cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";

     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se genero informe de Kardex por Laboratorio',strtoupper($_SESSION["USERNAME"]),$vsql);    
	 
	 // Genero el Archivo para Enviarlo a Impresora
     if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR") 
     {
        $codImpre = $clase->BDLockup($_SESSION['USERNAME'],"usuarios","username","codimpresora");
        if(strlen($codImpre)>0) 	
        {	
           $rutaImpresion = $clase->BDLockup($codImpre,"impresoras","codigo","ruta");
     	   $archivo= "../Dropbox/00/".$rutaImpresion."/imp-tranfe-".rand(11111,99999).".txt"; // el nombre de tu archivo
        }
        else 
           $archivo= "../Dropbox/00/print6/imp-tranfe-".rand(11111,99999).".txt"; // el nombre de tu archivo
     }	 
     else
     {
		$tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
		if($tipo == "G")
		{
			/// 1. Le Aplico Permisos a la Carpeta PDF
			chmod($acceso."print/", 0777);
			/// 2. Genero la Impresion  
			$archivo= "print/Kardex_".$grupo.".txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			fwrite($fch, $cont); // Grabas
			fclose($fch); // Cierras el archivo

			/// 3. Le Aplico Permisos al archivo
			chmod("print/Kardex_".$grupo.".txt", 0777);					
		}	            
		else
		{
		    $archivo= "print/Kardex_".$grupo.".txt"; // el nombre de tu archivo
			$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
			fwrite($fch, $cont); // Grabas
			fclose($fch); // Cierras el archivo
		}

     }	
	 sleep(2);
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 
	 
  } // Fin de la Funcion
  

  //////////////////////////////////////////////////////////////////////////////////////////////
  //// Retorna 1 Si la Factura Supera los 25.000 en Marcas Patrocinadoras - SINO Devuelve 0
  //////////////////////////////////////////////////////////////////////////////////////////////
  function FacturaCumpleMinimoMarcasPatrocinadoras($docuid)
  {
		$clase = new Sistema();
		
		$vsql = "SELECT COALESCE(SUM(IF(GP.concurso1 = 'CHECKED' OR P.porcenboni>0,DD.valparcial,0)),0) valorsi  
		FROM documentos D
		INNER JOIN terceros T ON (T.terid = D.terid2)
		INNER JOIN terceros CLI ON (CLI.terid = D.terid1)
		INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
		INNER JOIN productos P ON (P.productoid = DD.productoid)
		INNER JOIN gruposprod GP ON (GP.gruposprodid = P.gruposprodid) 
		WHERE D.docuid = ".$docuid; 			 
		
		$valorsi = 0+$clase->SeleccionarUno($vsql);
		if($valorsi>=25000)
		   return(1);
		else
		   return(0);
  }

  /////////////////////////////////////////////////////////////////////////////////////
  //// Retorna en Formato Array la Respuesta del JSON de Puntos Farmanorte
  /////////////////////////////////////////////////////////////////////////////////////
  function AcumularPuntosFarmanorteVenta($docuid)
  {
	$clase = new Sistema();

    $errores = 0;
	$responsepuntos = "";

    /// REGLAS LOCALES : 
    /// Facturas de 20 Lineas o mas -> NO ACUMULAN
    $lineasfactura = $clase->SeleccionarUno("SELECT COUNT(*) FROM dedocumentos WHERE docuid = ".$docuid);
    if($lineasfactura >= 20)  $errores = 1;
    /// Base de Acumulacion es VRBASE de los Productos no Exceptuados o Bloqueados por Cantidad
    /// Facturas Credito -> NO ACUMULAN 
    /// Productos Bloqueados -> NO FORMAN PARTE DE LA BASE -> Si Acumulan
    $vsql = "SELECT D.formapago , D.base , D.total , P.productoid , P.codigo , DD.cantidad , DD.valunitario , T.codvende , T.nombres , T.apellidos , CLI.dni cedulacliente , 
             SUM(IF(DD.cantidad<20,DD.valbase,0)) baseacum , COALESCE(SUM(IF(GP.concurso1 = 'CHECKED' OR P.porcenboni>0,DD.valparcial,0)),0) valorsi ,       
             (SELECT COUNT(*) FROM productosnoredimir WHERE bloqacumula = 1 AND productoid = P.productoid) bloqueado 
             FROM documentos D
			 INNER JOIN terceros T ON (T.terid = D.terid2)
			 INNER JOIN terceros CLI ON (CLI.terid = D.terid1)
             INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
             INNER JOIN productos P ON (P.productoid = DD.productoid)
			 INNER JOIN gruposprod GP ON (GP.gruposprodid = P.gruposprodid) 
             WHERE D.docuid = ".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11 HAVING bloqueado = 0"; 

//echo $vsql;
    $conex  = $clase->Conectar();
    $result = mysql_query($vsql,$conex);
    $totalbase = 0;  $jsonproductos = 0;  $totalfv = 0;   $basefv = 0; $nomvende = ""; $cliente = "";  $valor_marcas_patrocinadoras = 0;
    $i = 0;
    while($row = mysql_fetch_array($result)) 
    {
        $cliente = $row['cedulacliente'];
		$basefv = $row['base'];
        $totalfv = $row['total'];
		$valor_marcas_patrocinadoras += $row['valorsi'];
		$nomvende = $row['codvende']." ".trim($row['nombres'])." ".trim($row['apellidos']);


        if($row['formapago'] == "CR")  $errores++;

        if($i>0)
          $jsonproductos.= ",";

        $jsonproductos.= '{"codigo":"'.$row['codigo'].'",
                           "cantidad":"'.$row['cantidad'].'",
                           "valunitario":"'.$row['valunitario'].'"
                          }';          

        /// Acumulo la Base de la Factura de los Productos que Aplican
        $totalbase += $row['baseacum'];

        $i++;
    } 
    	
    ///////////////////////////////////////////////////////////////////////////////
    ///// Si se cumplen todas las condiciones -> Procedo a Acumular los puntos
    if(($errores == 0)&&($totalbase>0))
    {
        $tokenFV = md5(date("dmY"));
		$sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");
		$numfactura = $clase->SeleccionarUno("SELECT CONCAT(prefijo,numero) FROM documentos WHERE docuid = ".$docuid);
        $campaid    = 0+$clase->SeleccionarUno("SELECT convenioid FROM docuventa WHERE docuid = ".$docuid);

		/// Acumulo Localmente los Puntos Farmanorte para efectos de la Campaña
		$vsql2 = "UPDATE docuventa SET puntosacumulados = 1 WHERE docuid = ".$docuid;
		$clase->EjecutarSQL($vsql2);
	
		//// Participa en Raspa Y Gana
		$participacion_raspa_gana = 0;
		//if(($totalfv>=30000)&&($valor_marcas_patrocinadoras>=25000)) 
		if($totalfv>=30000)
		   $participacion_raspa_gana = 1;
		  
		//// Consumo la API para generar la Acumulacion en la Web
		$URL2 = "cliente=".$cliente."&docuid=".$docuid."&descripcion=".urlencode("Acumulacion de puntos Compra")."&valor=".round($totalbase)."&sucursal=".$sucursalid."&numerofactura=".$numfactura."&campaid=".$campaid."&vendedor=".urlencode($nomvende)."&participacion_raspa_gana=".urlencode($participacion_raspa_gana)."&token=".$tokenFV;
		$URL = "https://www.puntosfarmanorte.com/api/registraPuntosCompras?".$URL2;
		
		//echo "<br>".$URL;

		///// Array Options
		$arrContextOptions=array(
			"ssl"=>array(
				"verify_peer"=>false,
				"verify_peer_name"=>false,
			),
		); 
		
		//// Traigo los Puntos a Redimir
        $respuesta = file_get_contents($URL, false, stream_context_create($arrContextOptions));
		$responsepuntos = json_decode($respuesta,true);
		$codigo = $responsepuntos['Code'];
        
		//// Registro el Detalle del Proceso de Envio a Puntos
		$procesoid = $clase->SeleccionarUno("SELECT id FROM procesosenviofacturas WHERE tipoenvio = 'PFA' AND docuid = ".$docuid);
		if($procesoid != "")
		{
			$exitoso = 0;
			if($codigo != "") $exitoso = 1;
			 
			$vsqlx = "INSERT INTO detalleenviosfacturas(procesoid,jsonentrada,jsonretorno,procesoexitoso) VALUES(".$procesoid.",'".$URL."','".$respuesta."','".$exitoso."')";
			$clase->EjecutarSQL($vsqlx);

			if($exitoso == "1")
			   $clase->EjecutarSQL("UPDATE procesosenviofacturas SET fingeneral = CURRENT_TIMESTAMP WHERE id = ".$procesoid);
		}

		/// Si CODE = 200 
		$puntosacumulados = 1;
		if($codigo == "200") 
        {
			$puntosacumulados = $responsepuntos['puntos_acumulados'];
            $puntosxvencer    = $responsepuntos['puntos_vencer'];
            $nuevosaldopuntos = 0+(intval($responsepuntos['puntos_acumulados'])+intval($responsepuntos['saldo_actual']));

			$existe = $clase->SeleccionarUno("SELECT COUNT(*) FROM acumulacionespuntos WHERE docuid = ".$docuid);
            if($existe == "0")
			{
				$vsql = "INSERT INTO acumulacionespuntos(docuid, dnicliente, token, jsonproductos, valorbasefactura, valortotalfactura, 
				         valorbaseacumulacion, respuestaws, puntosacumulados, puntosxvencer, nuevosaldopuntos, idcampa) 
				         VALUES ('".$docuid."','".$cliente."','".$tokenFV."','','0','0','0','','0','0','0','0')";
	            $clase->EjecutarSQL($vsql);
			}
			
			if($puntosacumulados>0)
			{
				$vsql = "UPDATE acumulacionespuntos SET jsonproductos = '".$jsonproductos."' , valorbasefactura = '".$basefv."' ,  valortotalfactura = '".$totalfv."' , valorbaseacumulacion = '".$totalbase."' , 
							respuestaws = '".$jsonpuntos."' , puntosacumulados = '".$puntosacumulados."' , puntosxvencer = '".$puntosxvencer."' ,  nuevosaldopuntos = '".$nuevosaldopuntos."' , idcampa = 0   
							WHERE docuid = ".$docuid;
				$clase->EjecutarSQL($vsql);
			}

			$vsql2 = "UPDATE docuventa SET puntosacumulados = '".$puntosacumulados."' WHERE docuid = ".$docuid;
			$clase->EjecutarSQL($vsql2);
        }  
    }
    
    //echo "<br><br>".$URL; 
	return($responsepuntos);
  }


  ///////////////////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////////
  function RecordatoriosLlamadas($fecha)
  {
     $clase = new Sistema();
	 $sucid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 
	 $nomempresa = $_SESSION['G_NOMBRE_EMPRESA'];
	 $nitempresa = $_SESSION['G_NIT_EMPRESA'];

	 $enca =  Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).$nomempresa.Chr(13).Chr(10);	
	 $enca.=  $nitempresa.Chr(13).Chr(10);		 
     $enca.= '---------------------------------------'.Chr(13).Chr(10);          
	 $deta = "";
	 
	 /// Hago la Consulta de los datos del cierre
	 $vsql = "SELECT D.fechadoc, DATE_ADD( D.fechadoc, INTERVAL DD.diasrecor DAY ) as fecharec, P.descripcion nomproducto , T.* 
	          FROM documentos D INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid ) INNER JOIN productos P ON (P.productoid = DD.productoid) 
			  INNER JOIN terceros T ON (T.terid = D.terid1) 
			  WHERE DD.diasrecor >0 AND EXTRACT( DAY FROM DATE_ADD( D.fechadoc, INTERVAL DD.diasrecor DAY )) = '".substr($fecha,8,2)."'";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
 	 while($row = @mysql_fetch_array($result))
	 { 
 	   $fecha        = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4);
 	   $hora         = substr($row['momento'],11,2).":".substr($row['momento'],14,2); 	    	   
	   $cliente      = substr($row['nombres'].' '.$row['apellidos'],0,24); 
	   $telcliente   = substr($row['telfijo'].' '.$row['telmovil'],0,24); 	   
	   $dircliente   = substr($row['direccion'],0,24); 	   	   
	   $producto     = substr($row['nomproducto'],0,24); 
	   
	   $deta .= "CLIENTE : ".$cliente.Chr(13).Chr(10);
	   $deta .= "MEDICAM : ".$producto.Chr(13).Chr(10);
	   $deta .= "TELEFON : ".$telcliente.Chr(13).Chr(10);
	   $deta .= "DIRECCI : ".$dircliente.Chr(13).Chr(10);	   	   	     
       $deta .= '---------------------------------------'.Chr(13).Chr(10);          
     } 

	 $enca.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
     $enca.= '======================================='.Chr(13).Chr(10);          	 	
	 $enca.= '****  RECORDATORIO DE LLAMADAS  *****    '.Chr(13).Chr(10);    
	 $enca.= '======================================='.Chr(13).Chr(10);     
     
     $cont = $enca.$deta;
	 
     $cont.= str_pad("www.dromedicas.com.co",39," ",STR_PAD_LEFT).Chr(13).Chr(10);	 	 	 	   
     $cont.= Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10).Chr(13).Chr(10);
     $cont.= '.';     
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";
	 
     ////// Adiciono al Log la informacion
	 $clase->CrearLOG('018','Se imprimio el informe de recordatorios',strtoupper($_SESSION["USERNAME"]),'');    
	 
	 // Genero el Archivo para Enviarlo a Impresora
	 $archivo= "print/fichero.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo	 	 
  }

  /////////////////////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////////////////////
  function ActualizarDiaOperativoServidor()  
  {
	 $clase  = new Sistema();
	 $diahoy = $_SESSION['G_DIAOPERATIVO'];
	 $diasig = SiguienteDia($diahoy,1);
	 $_SESSION['G_DIAOPERATIVO'] = $diasig;
	 $clase->EjecutarSQL("UPDATE configuraciones SET contenido ='".$diasig."' WHERE variab='G_DIAOPERATIVO'");		  
	 return;	  
  }  

  /////////////////////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////////////////////
  function Actualizarsihayceros($docuid) 
  {
     $clase = new Sistema();
	 $vsql="SELECT DISTINCT productoid , bodegaid FROM dedocumentos WHERE docuid=".$docuid;
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 while($row = @mysql_fetch_array($result)) 
	 { 
         $pid = $row['productoid'];
		 $bid = $row['bodegaid'];
		 
		 $vsql2 = "SELECT SUM(if(cantidad>0,cantidad,'')) entradas , SUM(if(cantidad<0,cantidad,'')) salidas 
                   FROM kardex WHERE productoid=".$pid." AND bodegaid=".$bid;
  		 
         $result2 = @mysql_query($vsql2,$conex);
	     while($row2 = @mysql_fetch_array($result2)) 
	     { 
	         $entradas = round($row2['entradas'],2);
			 $salidasx = round($row2['salidas'],2);
			 $salidas  = (-1)*$salidasx;
			 if(strcmp($entradas,$salidas) == 0)
			   $clase->EjecutarSQL("UPDATE existencias SET cantidad = 0 WHERE bodegaid=".$bid." AND productoid=".$pid);
		 }
     }
	 $clase->closeConnection();
	 return;
  }  

  /////////////////////////////////////////////////////////////////////////////////////////////////
  /// Consumo Productos Combos - TAbla ConsumoProductos
  /////////////////////////////////////////////////////////////////////////////////////////////////
  function AfectarKardexSiTieneCombos($docuid)
  {
		$clase = new Sistema();
		$vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.periodo , DD.bodegaid , D.sucursalid , 
		         DD.productoid , DD.cantidad vendido , DC.*
				 FROM consumoproductos C 
				 INNER JOIN dedocumentos DD ON (DD.productoid = C.productobaseid) 
				 INNER JOIN deconsumoproductos DC ON (DC.consumoid = C.consumoid) 
				 INNER JOIN documentos D ON (D.docuid = DD.docuid) 
				 WHERE DD.docuid = ".$docuid;
		//echo $vsql."<br>";		 
		$conex  = $clase->Conectar();
		$result = @mysql_query($vsql,$conex);
		while($row = @mysql_fetch_array($result)) 
		{ 
            $tipodoc = $row['tipodoc'];         $prefijo = $row['prefijo'];
			$numero  = $row['numero'];          $fechadoc = $row['fechadoc'];
			$periodo = $row['periodo'];         $productoid = $row['productoid'];
			$bodid   = $row['bodegaid'];        $sucid = $row['sucursalid'];
						 
			$pid = $row['productoid'];		
			$mat = $row['productolistaid'];		
			$ven = $row['vendido'];	
			$dctouni = $row['cantidad'];	
			$cantidad = abs(0+($dctouni*$ven));
			$cantidad = $cantidad*(-1);

		    $vsqlx = "INSERT INTO kardex(tipodoc,prefijo,numero,fechadoc,periodo,docuid,productoid,bodegaid,sucursalid,cantidad,creador,momento) 
                      VALUES('".$tipodoc."','".$prefijo."','".$numero."','".$fechadoc."','".$periodo."','".$docuid."',".$mat.",".$bodid.",".$sucid.",".$cantidad.",'SYSTEM',CURRENT_TIMESTAMP)";
			$clase->EjecutarSQL($vsqlx); 	
            //echo $vsqlx."<br>";
		}
  }

  /////////////////////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////////////////////
  function ActualizarEstadisticaVentasLocal($periodo)
  {
     ini_set("memory_limit","300M");
	 error_reporting(E_ALL);
	 set_time_limit(0);
     $clase = new Sistema();
   
	 //// Ajuste para el mes de Marzo
	 if($periodo == "032025")
        $clase->EjecutarSQL("UPDATE enviofacturasdian SET codrespuestavps = '200' , enviows = '1' WHERE cufe IS NOT NULL");

	 //// Limpio la Data 
     $clase->EjecutarSQL("DELETE FROM estaventasuc WHERE periodo = '".$periodo."'");

	 //// Variables iniciales
	 $codsuc = $_SESSION['G_SUCURSALPOS'];
	 $nomsuc = $clase->BDLockup($codsuc,"sucursales","codigo","descripcion");
	 $criterio = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);

	 ////////////////////////////////////////////////////////
	 //// 1. Data de Venta General
     $vsql = "SELECT T.codvende, DV.diaoperativo , SUM( D.total ) venta , SUM(IF((EXTRACT(HOUR FROM D.fechadoc)>21 OR EXTRACT(HOUR FROM D.fechadoc)<7),1,0)) noche2 , COUNT(*) cliatendidos , 
	          SUM(IF(D.terid3>1,D.total,0)) domicilios2 , COUNT(*) totalfacturas , SUM(IF(DV.esfel=1,1,0)) canenviadas  , SUM(IF(DV.canalventa='CCE',D.total,0)) ventacall , 
			  SUM(IF(DV.canalventa='TVI',D.total,0)) ventatienda , SUM(IF(DV.canalventa='RAP',D.total,0)) ventarappi , SUM(IF((CLI.clientepuntos = 'CHECKED' AND CLI.dni <> '99' AND CLI.dni <> '222222222222'),1,0)) clientespuntosfn 
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          INNER JOIN terceros CLI ON ( CLI.terid = D.terid1 ) 
			  LEFT JOIN terceros T ON ( T.terid = D.terid2 ) 
			  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' 
			  AND DV.diaoperativo LIKE '".$criterio."' GROUP BY 1,2 ORDER BY 2 ASC";

     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
        $porcenenvio = 0+((intval($row['canenviadas'])*100)/intval($row['totalfacturas']));

	    $vsql = "INSERT INTO estaventasuc(codven,codsuc,periodo,diaoperativo,ventagen,ventanoc2,domicilios2,cliatendidos,clientespuntos,cantotalfacturas,canenviadas,porcenenvio,ventacall,ventatienda,ventarappi) 
		         VALUES('".$row['codvende']."','".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$row['venta']."','".$row['noche2']."','".$row['domicilios2']."','".$row['cliatendidos']."',
				 '".$row['clientespuntosfn']."','".$row['totalfacturas']."','".$row['canenviadas']."','".$porcenenvio."','".$row['ventacall']."','".$row['ventatienda']."','".$row['ventarappi']."')";
		$clase->EjecutarSQL($vsql);
	 } // Fin While
    

	 ////////////////////////////////////////////////////////
	 //// 1.1 Data de Despacho de Tienda - Call - Rappi
     $vsql = "SELECT T.codvende , DV.diaoperativo , DV.canalventa , COUNT(*) clidespa , SUM( D.total ) despachado  
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          INNER JOIN terceros T ON ( T.terid = D.terid4 ) 
			  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' 
			  AND DV.diaoperativo LIKE '".$criterio."' GROUP BY 1,2,3 ORDER BY 2,1 ASC";

     //// Limpio la Data 
     $clase->EjecutarSQL("DELETE FROM estadespasuc WHERE periodo = '".$periodo."'");

     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
	    $vsql = "INSERT INTO estadespasuc(coddespa,codsuc,periodo,diaoperativo,tipodespa,cantidespachos,valordespachado) 
		         VALUES('".$row['codvende']."','".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$row['canalventa']."','".$row['clidespa']."','".$row['despachado']."')";
		$clase->EjecutarSQL($vsql);
		//echo $vsql."<br>";
	 } // Fin While


	//////////////////////////////////////////////////////// 
	//// 2. Data de Venta Especial
	$vsql = "SELECT T.codvende , B.fecha , ROUND(SUM( B.valorventa )) ventaespe, ROUND(SUM( B.valorcomi )) comision FROM bonificado B INNER JOIN terceros T ON ( T.terid = B.vendedor )
	         WHERE EXTRACT( MONTH FROM fecha ) = ".intval(substr($periodo,0,2))." AND EXTRACT(YEAR FROM fecha ) = ".intval(substr($periodo,2,4))." GROUP BY 1,2 ORDER BY 2 ASC";
    $conex  = $clase->Conectar();
	$result = @mysql_query($vsql,$conex);
	while($row = @mysql_fetch_array($result))
	{ 
		$diaoperativo = substr($row['fecha'],8,2)."/".substr($row['fecha'],5,2)."/".substr($row['fecha'],0,4);
		
		/// Valido si Existe y sino - lo creo
		$existeregistro = $clase->SeleccionarUno("SELECT COUNT(*) FROM estaventasuc WHERE codven = '".$row['codvende']."' AND codsuc = '".$codsuc."' AND periodo = '".$periodo."' AND diaoperativo = '".$diaoperativo."'");
        if($existeregistro == 0)
		{
			$vsql = "INSERT INTO estaventasuc(codven,codsuc,periodo,diaoperativo,ventaesp,comiespe) 
		             VALUES('".$row['codvende']."','".$codsuc."','".$periodo."','".$diaoperativo."','".$row['ventaespe']."','".$row['comision']."')";
					 echo $vsql."<br>";
		}
		else
		{
			$vsql = "UPDATE estaventasuc SET ventaesp = '".$row['ventaespe']."' , comiespe = '".$row['comision']."' 
					 WHERE codven = '".$row['codvende']."' AND codsuc = '".$codsuc."' AND periodo = '".$periodo."' AND diaoperativo = '".$diaoperativo."'";
		}
		$clase->EjecutarSQL($vsql);
	} // Fin While

    ///////////////////////////////////////////////////////
    //// 3. Data de Venta por Productos
	$vsql = "SELECT T.codvende, DV.diaoperativo , SUM(IF((P.codigo = 'R1000' OR P.codigo = 'R1001'),DD.valtotal,0)) recargas , SUM(IF((GP.codigo = '827' OR GP.codigo = '808' OR GP.codigo = '809'),DD.valtotal,0)) licores , 
	         SUM(IF((P.descripcion LIKE 'SUREZINC%' AND P.codigo <> 'D1849' AND P.codigo <> 'D1850'),(DD.unicom+(DD.unifra/P.factor1)),0)) surezinc , SUM(IF((EXTRACT(HOUR FROM fechadoc)>21 OR EXTRACT(HOUR FROM fechadoc)<7),DD.valtotal,0)) noche , 
			 SUM(IF((P.codigo = 'DO'),DD.cantidad,0)) domicilios 
			 FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
		 	 LEFT JOIN terceros T ON ( T.terid = D.terid2 ) 
	 		 INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			 INNER JOIN productos P ON (DD.productoid = P.productoid) 
             INNER JOIN gruposprod GP ON (GP.gruposprodid = P.gruposprodid)			 
			 WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."' GROUP BY 1,2";
    $conex  = $clase->Conectar();
	$result = @mysql_query($vsql,$conex);
	while($row = @mysql_fetch_array($result))
	{ 
		$vsql = "UPDATE estaventasuc SET ventarec = '".$row['recargas']."' , ventalic = '".$row['licores']."' , ventanoc = '".$row['noche']."' , ventasure = '".$row['surezinc']."' , 
		         domicilios = '".$row['domicilios']."' 
				 WHERE codven = '".$row['codvende']."' AND codsuc = '".$codsuc."' AND periodo = '".$periodo."' AND diaoperativo = '".$row['diaoperativo']."'";
		$clase->EjecutarSQL($vsql);
	} // Fin While

	 ////////////////////////////////////////////////////////
	 //// 4. Devoluciones
     $vsql = "SELECT T.codvende, DV.diaoperativo , SUM( D.total ) devoluciones FROM documentos D INNER JOIN docudevolucion DV ON (D.docuid = DV.docuid) 
	          INNER JOIN terceros T ON ( T.terid = D.terid2 ) WHERE D.tipodoc = 'DVE' AND D.fecasentado <> '0000-00-00' 
			  AND DV.diaoperativo LIKE '".$criterio."' GROUP BY 1,2 ORDER BY 2 ASC";
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
		$existeregistro = $clase->SeleccionarUno("SELECT COUNT(*) FROM estaventasuc WHERE codven = '".$row['codvende']."' AND codsuc = '".$codsuc."' AND periodo = '".$periodo."' AND diaoperativo = '".$row['diaoperativo']."'");
	    if($existeregistro == 0)
			$vsql = "INSERT INTO estaventasuc(codven,codsuc,periodo,diaoperativo,devoluciones) 
		             VALUES('".$row['codvende']."','".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$row['devoluciones']."')";
		else
			$vsql = "UPDATE estaventasuc SET devoluciones = '".$row['devoluciones']."' 
					 WHERE codven = '".$row['codvende']."' AND codsuc = '".$codsuc."' AND periodo = '".$periodo."' AND diaoperativo = '".$row['diaoperativo']."'";

		$clase->EjecutarSQL($vsql);
	 } // Fin While	 

	 ////////////////////////////////////////////////////////
	 //// 5. Domicilios prestados por los mensajeros
	 /*
     $vsql = "SELECT T.codvende , T.coddomi , DV.diaoperativo , COUNT(*) cantidomicilios , SUM( D.total ) valdomicilios 
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          INNER JOIN terceros T ON ( T.terid = D.terid3 ) 
			  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."' 
			  GROUP BY 1,2,3 HAVING T.codvende <> '' OR T.coddomi <> '' ORDER BY 3 ASC" ;
	*/
	$vsql = "SELECT R.coddomi , DV.diaoperativo , COUNT(*) cantidomicilios , SUM( D.total ) valdomicilios 
 			 FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid)             
			 INNER JOIN registrodomicilios R ON (R.docuid = D.docuid)
			 WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."' 
			 GROUP BY 1,2 ORDER BY 2 ASC"; 
			  
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i==0)
		   $clase->EjecutarSQL("DELETE FROM estadomisuc WHERE periodo = '".$periodo."'");

		if($row['coddomi']!="")   $coddomi = $row['coddomi'];
		if($row['codvende']!="")  $coddomi = $row['codvende'];
		if($coddomi == "")  $coddomi = "000";

	    $vsql = "INSERT INTO estadomisuc(coddomi,codsuc,periodo,diaoperativo,cantidomicilios,valdomicilios) 
		         VALUES('".$coddomi."','".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$row['cantidomicilios']."','".$row['valdomicilios']."')";
		$clase->EjecutarSQL($vsql);

		$i++;		
	 } // Fin While

	 ////////////////////////////////////////////////////////
	 /* 6. Impuestos en Ventas y Devoluciones por Dia
	       Genero la Consulta asi : 
	       1. Ventas Enviadas Y NO ENVIADAS ( Tambien SIN Devol )
		   2. Devoluciones    
     //////////////////////////////////////////////////////*/

	 //// Correccion a los Errores de la FEL - Modificadas
	 $vsqlarreglo = "UPDATE dedocumentos SET porciva = 0 WHERE porciva > 0 AND valiva = 0 AND docuid IN (SELECT D.docuid FROM documentos D WHERE D.periodo = '062025' AND D.tipodoc = 'FVE')";
     $clase->EjecutarSQL($vsqlarreglo);

	 //// Extraigo la Informacion de Impuestos
	 $vsql ="SELECT '1'orden, IF(EFD.docuid IS NULL OR EFD.enviows IS NULL OR EFD.enviows = 0,0,1)  enviows, D.tipodoc, DV.diaoperativo, SUM( IF( DD.porciva =0, DD.valbase, 0 ) ) base00, 
			 SUM( IF( DD.porciva =5, DD.valbase, 0 ) ) base05, SUM( IF( DD.porciva =5, DD.valiva, 0 ) ) iva05, SUM( IF( DD.porciva =5, DD.valtotal, 0 ) ) total05, 
			 SUM( IF( DD.porciva =19, DD.valbase, 0 ) ) base19, SUM( IF( DD.porciva =19, DD.valiva, 0 ) ) iva19, SUM( IF( DD.porciva =19, DD.valtotal, 0 ) ) total19, 
			 SUM( DD.valtotal ) ventatotal, 0 AS dbase00, 0 AS dbase05, 0 AS diva05, 0 AS dtotal05, 0 AS dbase19, 0 AS diva19, 0 as dtotal19, 0 as devolucionestotal 
			 FROM documentos D
			 INNER JOIN docuventa DV ON ( D.docuid = DV.docuid )
			 INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid )
			 LEFT JOIN enviofacturasdian EFD ON ( EFD.docuid = D.docuid )
			 WHERE D.tipodoc = 'FVE' AND diaoperativo LIKE '".$criterio."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'
             GROUP BY 1,2,3,4			 
			 UNION 
			 SELECT '2' orden , '1' enviows, D.tipodoc , DV.diaoperativo, 0 base00, 0 base05, 0 iva05, 0 total05, 0 base19, 0 iva19, 0 total19, 0 ventatotal ,SUM(IF(P.porciva =0, DD.valbase,0)) dbase00, 
			 SUM( IF( P.porciva =5, (DD.valtotal / 1.05), 0 ) ) dbase05, SUM( IF( P.porciva =5, (DD.valtotal - ( DD.valtotal / 1.05 ) ) , 0 )) diva05, 
			 SUM( IF( P.porciva =5, DD.valtotal, 0 ) ) dtotal05, SUM( IF( P.porciva =19, (DD.valtotal / 1.19), 0 ) ) dbase19 ,  SUM( IF( P.porciva =19, DD.valtotal-(DD.valtotal / 1.19), 0 ) ) diva19 , SUM( IF( P.porciva =19, DD.valtotal, 0 ) ) dtotal19, 
             SUM( DD.valtotal ) devolucionestotal
			 FROM documentos D
			 INNER JOIN docudevolucion DV ON ( D.docuid = DV.docuid )
			 INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid )
			 INNER JOIN productos P ON ( P.productoid = DD.productoid )
			 WHERE D.tipodoc = 'DVE' AND diaoperativo LIKE  '".$criterio."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
			 GROUP BY 1,2,3,4 ORDER BY 4 ASC , 1 ASC , 2 ASC , 3 ASC";
     //echo $vsql;
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i==0)
		   $clase->EjecutarSQL("DELETE FROM estaimpuestosuc WHERE periodo = '".$periodo."'");

		$vsql = "INSERT INTO estaimpuestosuc(codsuc,periodo,diaoperativo,base00,base05,iva05,total05,base19,iva19,total19,ventatotal,dbase00,dbase05,diva05,dtotal05,dbase19,diva19,dtotal19,enviado) 
				 VALUES('".$codsuc."','".$periodo."','".$row['diaoperativo']."','".round($row['base00'],4)."','".round($row['base05'],4)."','".
				 round($row['iva05'],4)."','".round($row['total05'],4)."','".round($row['base19'],4)."','".round($row['iva19'],4)."','".round($row['total19'],4)."','".round($row['ventatotal'],4)."',
				 '".round($row['dbase00'],4)."','".round($row['base05'],4)."','".round($row['diva05'],4)."','".round($row['dtotal05'],4)."','".round($row['base19'],4)."','".round($row['diva19'],4)."',
				 '".round($row['dtotal19'],4)."','".$row['enviows']."')";

        $clase->EjecutarSQL($vsql);
				
		$i++;
	 } // Fin While

	 ////////////////////////////////////////////////////////
	 //// 7. Data de Campañas
     $vsql = "SELECT DV.diaoperativo , T.codvende , T.nombres , T.apellidos , COUNT(*) cliatendidos , SUM(IF(DV.puntosacumulados>1,1,0)) clipuntos , 
			  SUM(IF(DV.puntosacumulados>1 AND DV.convenioid IS NOT NULL,1,0)) clicampa , 
			  SUM(IF(DV.puntosacumulados<=1 AND DV.convenioid IS NOT NULL,1,0)) facturaserror  
		  	  FROM documentos D 
			  INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			  INNER JOIN terceros T ON (T.terid = D.terid2)
			  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fechadoc BETWEEN '2023-06-15' AND '2023-07-31' AND periodo = '".$periodo."'  
			  GROUP BY 1,2,3,4
			  ORDER BY DV.diaoperativo DESC , 5 DESC";
			  
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;  $codsuc = $_SESSION['G_SUCURSALPOS'];
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i==0)
		   $clase->EjecutarSQL("DELETE FROM estacampasuc WHERE codsuc = '".$codsuc."' AND periodo = '".$periodo."'");

	    $vsql = "INSERT INTO estacampasuc(codsuc,diaoperativo,periodo,codvende,cliatendidos,clicampa,clipuntos,facturaserror) 
		         VALUES('".$codsuc."','".$row['diaoperativo']."','".$periodo."','".$row['codvende']."','".$row['cliatendidos']."','".$row['clicampa']."','".$row['clipuntos']."','".$row['facturaserror']."')";
		$clase->EjecutarSQL($vsql);

		$i++;
	 } // Fin While

	 ////////////////////////////////////////////////////////
	 //// 8. Data de Categorizacion
     $vsql = "SELECT CP.categoriaid , DV.diaoperativo , ROUND(SUM(DD.unidades)) cantivendida , ROUND(SUM(DD.valtotal)) valorvendido
 	 		  FROM documentos D 
		  	  INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			  INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
			  INNER JOIN categoriasportafolioxproductos CPP ON (DD.productoid = CPP.productoid)
			  INNER JOIN categoriasportafolio CP ON (CP.categoriaid = CPP.categoriaid)
			  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."' 
			  GROUP BY 1,2 ORDER BY DV.diaoperativo ASC , CP.codcategoria ASC";
			  
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i==0)
		   $clase->EjecutarSQL("DELETE FROM estacategoriasuc WHERE periodo = '".$periodo."'");

	    $vsql = "INSERT INTO estacategoriasuc(categoriaid,codsuc,periodo,diaoperativo,cantivendida,valorvendido) 
		         VALUES('".$row['categoriaid']."','".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$row['cantivendida']."','".$row['valorvendido']."')";
		$clase->EjecutarSQL($vsql);

		$i++;		
	 } // Fin While

    
	 ////////////////////////////////////////////////////////
	 //// 9. Data de Creditos
     $vsql = "SELECT T.codvende , T.dni , T.nombres , T.apellidos , DV.diaoperativo , D.* , 
  			 (SELECT SUM(valtotal) FROM dedocumentos WHERE docuid = D.docuid AND valiva = 0) total00 , 
		 	 (SELECT SUM(valtotal) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 5) total05 ,
	 		 (SELECT SUM(valtotal) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 19) total19 
			 FROM documentos D 
			 INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			 INNER JOIN terceros T ON (T.terid = D.terid1) 
			 WHERE D.tipodoc = 'FVE' AND D.formapago = 'CR' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."' 
			 ORDER BY DV.diaoperativo ASC , D.fechadoc ASC";
			  
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i==0)
		   $clase->EjecutarSQL("DELETE FROM estacreditos WHERE periodo = '".$periodo."'");
		
		$b0 = $t0 = $row['total00'];   
		$t5 = $row['total05'];
		$i5 = $t5/1.05;
		$b5 = $t5-$i5;

		$t19 = $row['total19'];
		$i19 = $t19/1.19;
		$b19 = $t19-$i19;

		$numfactura = "FVE ".$row['prefijo']." ".$row['numero'];

	    $vsql = "INSERT INTO estacreditos(codsuc,periodo,diaoperativo,numfactura,codempleado,dnicliente,nomcliente,base00,base05,base19,iva05,iva19,total,codautorizo) 
		         VALUES('".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$numfactura."','".$row['codvende']."','".$row['dni']."','".$row['nombres']." ".$row['apellidos']."','".$b0."','".$b5."','".$b19."'
				 ,'".$i5."','".$i19."','".$row['total']."','".$row['observacion2']."')";
		$clase->EjecutarSQL($vsql);

		$i++;		
	 } // Fin While

	 ////////////////////////////////////////////////////////
	 //// 10. Data de RAPPI
     $vsql = "SELECT D.docuid idfactura , D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.total , SUC.codigo codsucursal, S.* 
  			  FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN sucursales SUC ON (SUC.sucursalid = D.sucursalid) 
			  LEFT JOIN seguimientorappi S ON (D.docuid = S.docuid) WHERE DV.canalventa = 'RAP' AND D.periodo = '".$periodo."'
		   	  ORDER BY D.docuid DESC";		
     $clase->EjecutarSQL("ALTER TABLE estarappisuc ADD total DOUBLE NOT NULL DEFAULT '0' AFTER codsucursal");
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);	 
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i==0)
		   $clase->EjecutarSQL("DELETE FROM estarappisuc WHERE periodo = '".$periodo."'");

	    $vsql3 = "INSERT INTO estarappisuc(docuid,periodo,numfactura,fechadoc,orderid,codbarra,codsucursal,total) 
		          VALUES('".$row['idfactura']."','".$periodo."','".$row['tipodoc'].' '.$row['prefijo'].' '.$row['numero']."','".substr($row['fechadoc'],0,10)."','".$row['orderid']."','".$row['codigopayless']."','".$row['codsucursal']."','".$row['total']."')";
		$clase->EjecutarSQL($vsql3);

		$i++;		
	 } // Fin While

  } /// fin ActualizarEstadisticaVentasLocal


  /////////////////////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////////////////////
  function ActualizarEstadisticaVentasLocalServidor($periodo)
  {
     ini_set("memory_limit","300M");
	 error_reporting(E_ALL);
	 set_time_limit(0);
     $clase = new Sistema();

	 //// Limpio la Data 
     $clase->EjecutarSQL("DELETE FROM estaventasuc WHERE periodo = '".$periodo."' AND codsuc IN ('00','DB','DBU','DME')");

	 //// Variables iniciales
	 $criterio = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);

	 ////////////////////////////////////////////////////////
	 //// 1. Data de Venta General
     $vsql = "SELECT S.codigo codsuc , T.codvende, DV.diaoperativo , SUM( D.total ) venta , SUM(IF((EXTRACT(HOUR FROM D.fechadoc)>21 OR EXTRACT(HOUR FROM D.fechadoc)<7),1,0)) noche2 , COUNT(*) cliatendidos , 
	          SUM(IF(D.terid3>1,D.total,0)) domicilios2 , COUNT(*) totalfacturas , SUM(IF(DV.esfel=1,1,0)) canenviadas  , SUM(IF(DV.canalventa='CCE',D.total,0)) ventacall , 
			  SUM(IF(DV.canalventa='TVI',D.total,0)) ventatienda , SUM(IF(DV.canalventa='RAP',D.total,0)) ventarappi 
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN sucursales S ON (S.sucursalid = D.sucursalid)
	          LEFT JOIN terceros T ON ( T.terid = D.terid2 ) WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' 
			  AND DV.diaoperativo LIKE '".$criterio."' GROUP BY 1,2,3 ORDER BY 3 ASC";

     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
        $porcenenvio = 0+((intval($row['canenviadas'])*100)/intval($row['totalfacturas']));
        $codsuc = $row['codsuc'];

	    $vsql = "INSERT INTO estaventasuc(codven,codsuc,periodo,diaoperativo,ventagen,ventanoc2,domicilios2,cliatendidos,cantotalfacturas,canenviadas,porcenenvio,ventacall,ventatienda,ventarappi) 
		         VALUES('".$row['codvende']."','".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$row['venta']."','".$row['noche2']."','".$row['domicilios2']."','".$row['cliatendidos']."',
				 '".$row['totalfacturas']."','".$row['canenviadas']."','".$porcenenvio."','".$row['ventacall']."','".$row['ventatienda']."','".$row['ventarappi']."')";
		$clase->EjecutarSQL($vsql);
	 } // Fin While
    

	 ////////////////////////////////////////////////////////
	 //// 1.1 Data de Despacho de Tienda - Call - Rappi
     $vsql = "SELECT S.codigo codsuc , T.codvende , DV.diaoperativo , DV.canalventa , COUNT(*) clidespa , SUM( D.total ) despachado  
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			  INNER JOIN sucursales S ON (S.sucursalid = D.sucursalid)
	          INNER JOIN terceros T ON ( T.terid = D.terid4 ) 
			  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' 
			  AND DV.diaoperativo LIKE '".$criterio."' GROUP BY 1,2,3,4 ORDER BY 3,2 ASC";

     //// Limpio la Data 
     $clase->EjecutarSQL("DELETE FROM estadespasuc WHERE periodo = '".$periodo."' AND codsuc IN ('00','DB','DBU','DME')");

     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
	    $vsql = "INSERT INTO estadespasuc(coddespa,codsuc,periodo,diaoperativo,tipodespa,cantidespachos,valordespachado) 
		         VALUES('".$row['codvende']."','".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$row['canalventa']."','".$row['clidespa']."','".$row['despachado']."')";
		$clase->EjecutarSQL($vsql);
	 } // Fin While

/*
	//////////////////////////////////////////////////////// 
	//// 2. Data de Venta Especial
	$vsql = "SELECT T.codvende , B.fecha , ROUND(SUM( B.valorventa )) ventaespe, ROUND(SUM( B.valorcomi )) comision 
	         FROM bonificado B INNER JOIN terceros T ON ( T.terid = B.vendedor )
	         WHERE EXTRACT( MONTH FROM fecha ) = ".intval(substr($periodo,0,2))." AND EXTRACT(YEAR FROM fecha ) = ".intval(substr($periodo,2,4))." GROUP BY 1,2 ORDER BY 2 ASC";
    $conex  = $clase->Conectar();
	$result = @mysql_query($vsql,$conex);
	while($row = @mysql_fetch_array($result))
	{ 
		$diaoperativo = substr($row['fecha'],8,2)."/".substr($row['fecha'],5,2)."/".substr($row['fecha'],0,4);
		
		/// Valido si Existe y sino - lo creo
		$existeregistro = $clase->SeleccionarUno("SELECT COUNT(*) FROM estaventasuc WHERE codven = '".$row['codvende']."' AND codsuc = '".$codsuc."' AND periodo = '".$periodo."' AND diaoperativo = '".$diaoperativo."'");
        if($existeregistro == 0)
		{
			$vsql = "INSERT INTO estaventasuc(codven,codsuc,periodo,diaoperativo,ventaesp,comiespe) 
		             VALUES('".$row['codvende']."','".$codsuc."','".$periodo."','".$diaoperativo."','".$row['ventaespe']."','".$row['comision']."')";
					 echo $vsql."<br>";
		}
		else
		{
			$vsql = "UPDATE estaventasuc SET ventaesp = '".$row['ventaespe']."' , comiespe = '".$row['comision']."' 
					 WHERE codven = '".$row['codvende']."' AND codsuc = '".$codsuc."' AND periodo = '".$periodo."' AND diaoperativo = '".$diaoperativo."'";
		}
		$clase->EjecutarSQL($vsql);
	} // Fin While

    ///////////////////////////////////////////////////////
    //// 3. Data de Venta por Productos
	$vsql = "SELECT T.codvende, DV.diaoperativo , SUM(IF((P.codigo = 'R1000' OR P.codigo = 'R1001'),DD.valtotal,0)) recargas , SUM(IF((GP.codigo = '827' OR GP.codigo = '808' OR GP.codigo = '809'),DD.valtotal,0)) licores , 
	         SUM(IF((P.descripcion LIKE 'SUREZINC%' AND P.codigo <> 'D1849' AND P.codigo <> 'D1850'),(DD.unicom+(DD.unifra/P.factor1)),0)) surezinc , SUM(IF((EXTRACT(HOUR FROM fechadoc)>21 OR EXTRACT(HOUR FROM fechadoc)<7),DD.valtotal,0)) noche , 
			 SUM(IF((P.codigo = 'DO'),DD.cantidad,0)) domicilios 
			 FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
		 	 INNER JOIN terceros T ON ( T.terid = D.terid2 ) 
	 		 INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			 INNER JOIN productos P ON (DD.productoid = P.productoid) 
             INNER JOIN gruposprod GP ON (GP.gruposprodid = P.gruposprodid)			 
			 WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."' GROUP BY 1,2";
    $conex  = $clase->Conectar();
	$result = @mysql_query($vsql,$conex);
	while($row = @mysql_fetch_array($result))
	{ 
		$vsql = "UPDATE estaventasuc SET ventarec = '".$row['recargas']."' , ventalic = '".$row['licores']."' , ventanoc = '".$row['noche']."' , ventasure = '".$row['surezinc']."' , 
		         domicilios = '".$row['domicilios']."' 
				 WHERE codven = '".$row['codvende']."' AND codsuc = '".$codsuc."' AND periodo = '".$periodo."' AND diaoperativo = '".$row['diaoperativo']."'";
		$clase->EjecutarSQL($vsql);
	} // Fin While

	 ////////////////////////////////////////////////////////
	 //// 4. Devoluciones
     $vsql = "SELECT T.codvende, DV.diaoperativo , SUM( D.total ) devoluciones FROM documentos D INNER JOIN docudevolucion DV ON (D.docuid = DV.docuid) 
	          INNER JOIN terceros T ON ( T.terid = D.terid2 ) WHERE D.tipodoc = 'DVE' AND D.fecasentado <> '0000-00-00' 
			  AND DV.diaoperativo LIKE '".$criterio."' GROUP BY 1,2 ORDER BY 2 ASC";
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
		$existeregistro = $clase->SeleccionarUno("SELECT COUNT(*) FROM estaventasuc WHERE codven = '".$row['codvende']."' AND codsuc = '".$codsuc."' AND periodo = '".$periodo."' AND diaoperativo = '".$row['diaoperativo']."'");
	    if($existeregistro == 0)
			$vsql = "INSERT INTO estaventasuc(codven,codsuc,periodo,diaoperativo,devoluciones) 
		             VALUES('".$row['codvende']."','".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$row['devoluciones']."')";
		else
			$vsql = "UPDATE estaventasuc SET devoluciones = '".$row['devoluciones']."' 
					 WHERE codven = '".$row['codvende']."' AND codsuc = '".$codsuc."' AND periodo = '".$periodo."' AND diaoperativo = '".$row['diaoperativo']."'";

		$clase->EjecutarSQL($vsql);
	 } // Fin While	 

	 ////////////////////////////////////////////////////////
	 //// 5. Domicilios prestados por los mensajeros
     $vsql = "SELECT T.codvende , T.coddomi , DV.diaoperativo , COUNT(*) cantidomicilios , SUM( D.total ) valdomicilios 
	          FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	          INNER JOIN terceros T ON ( T.terid = D.terid3 ) 
			  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."' 
			  GROUP BY 1,2,3 HAVING T.codvende <> '' OR T.coddomi <> '' ORDER BY 3 ASC" ;
			  
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i==0)
		   $clase->EjecutarSQL("DELETE FROM estadomisuc WHERE periodo = '".$periodo."' AND codsuc IN ('00','DB','DBU','DME')");

		if($row['coddomi']!="")   $coddomi = $row['coddomi'];
		if($row['codvende']!="")  $coddomi = $row['codvende'];
		if($coddomi == "")  $coddomi = "000";

	    $vsql = "INSERT INTO estadomisuc(coddomi,codsuc,periodo,diaoperativo,cantidomicilios,valdomicilios) 
		         VALUES('".$coddomi."','".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$row['cantidomicilios']."','".$row['valdomicilios']."')";
		$clase->EjecutarSQL($vsql);

		$i++;		
	 } // Fin While

	 ////////////////////////////////////////////////////////
	 /* 6. Impuestos en Ventas y Devoluciones por Dia
	       Genero la Consulta asi : 
	       1. Ventas Enviadas Y NO ENVIADAS ( Tambien SIN Devol )
		   2. Devoluciones    
     /////////////////////////////////////////////////////*/

	 $vsql ="SELECT S.codigo codsuc , '1'orden, IF( EFD.docuid IS NULL OR EFD.enviows IS NULL OR EFD.enviows = 0, 0, 1 ) enviows , D.tipodoc, DV.diaoperativo , 
	         SUM( IF( DD.porciva =0, DD.valbase, 0 ) ) base00, 
			 SUM( IF( DD.porciva =5, DD.valbase, 0 ) ) base05, SUM( IF( DD.porciva =5, DD.valiva, 0 ) ) iva05, SUM( IF( DD.porciva =5, DD.valtotal, 0 ) ) total05, 
			 SUM( IF( DD.porciva =19, DD.valbase, 0 ) ) base19, SUM( IF( DD.porciva =19, DD.valiva, 0 ) ) iva19, SUM( IF( DD.porciva =19, DD.valtotal, 0 ) ) total19, 
			 SUM( DD.valtotal ) ventatotal, 0 AS dbase00, 0 AS dbase05, 0 AS diva05, 0 AS dtotal05, 0 AS dbase19, 0 AS diva19, 0 as dtotal19, 0 as devolucionestotal 
			 FROM documentos D
			 INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid)
			 INNER JOIN docuventa DV ON ( D.docuid = DV.docuid )
			 INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid )
			 LEFT JOIN enviofacturasdian EFD ON ( EFD.docuid = D.docuid )
			 WHERE D.tipodoc = 'FVE' AND DV.diaoperativo LIKE '".$criterio."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'
             GROUP BY 1,2,3,4,5			 
			 UNION 
			 SELECT S.codigo codsuc , '2' orden , '1' enviows, D.tipodoc , DV.diaoperativo, 0 base00, 0 base05, 0 iva05, 0 total05, 0 base19, 0 iva19, 0 total19, 0 ventatotal ,SUM(IF(P.porciva =0, DD.valbase,0)) dbase00, 
			 SUM( IF( P.porciva =5, (DD.valtotal / 1.05), 0 ) ) dbase05, SUM( IF( P.porciva =5, (DD.valtotal - ( DD.valtotal / 1.05 ) ) , 0 )) diva05, 
			 SUM( IF( P.porciva =5, DD.valtotal, 0 ) ) dtotal05, SUM( IF( P.porciva =19, (DD.valtotal / 1.19), 0 ) ) dbase19 ,  SUM( IF( P.porciva =19, DD.valtotal-(DD.valtotal / 1.19), 0 ) ) diva19 , SUM( IF( P.porciva =19, DD.valtotal, 0 ) ) dtotal19, 
             SUM( DD.valtotal ) devolucionestotal
			 FROM documentos D
			 INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid)
			 INNER JOIN docudevolucion DV ON ( D.docuid = DV.docuid )
			 INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid )
			 INNER JOIN productos P ON ( P.productoid = DD.productoid )
			 WHERE D.tipodoc = 'DVE' AND DV.diaoperativo LIKE  '".$criterio."' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00' 
			 GROUP BY 1,2,3,4,5 ORDER BY 1 ASC , 5 ASC , 2 ASC , 3 ASC";
     
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i==0)
		   $clase->EjecutarSQL("DELETE FROM estaimpuestosuc WHERE periodo = '".$periodo."' AND codsuc IN ('00','DB','DBU','DME')");

		$codsuc = $row['codsuc']; 
		$vsql = "INSERT INTO estaimpuestosuc(codsuc,periodo,diaoperativo,base00,base05,iva05,total05,base19,iva19,total19,ventatotal,dbase00,dbase05,diva05,dtotal05,dbase19,diva19,dtotal19,enviado) 
				 VALUES('".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".round($row['base00'],4)."','".round($row['base05'],4)."','".
				 round($row['iva05'],4)."','".round($row['total05'],4)."','".round($row['base19'],4)."','".round($row['iva19'],4)."','".round($row['total19'],4)."','".round($row['ventatotal'],4)."',
				 '".round($row['dbase00'],4)."','".round($row['base05'],4)."','".round($row['diva05'],4)."','".round($row['dtotal05'],4)."','".round($row['base19'],4)."','".round($row['diva19'],4)."',
				 '".round($row['dtotal19'],4)."','".$row['enviows']."')";
        //echo $vsql."<br>";
        $clase->EjecutarSQL($vsql);
				
		$i++;
	 } // Fin While

	 ////////////////////////////////////////////////////////
	 //// 9. Data de Creditos
     $vsql = "SELECT S.codigo codsuc , T2.codvende , T.dni , T.nombres , T.apellidos , DV.diaoperativo , D.* , 
  			 (SELECT SUM(valtotal) FROM dedocumentos WHERE docuid = D.docuid AND valiva = 0) total00 , 
		 	 (SELECT SUM(valtotal) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 5) total05 ,
	 		 (SELECT SUM(valtotal) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 19) total19 
			 FROM documentos D 
			 INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
			 INNER JOIN sucursales S ON (S.sucursalid = D.sucursalid) 
			 INNER JOIN terceros T ON (T.terid = D.terid1)
  			 INNER JOIN terceros T2 ON (T2.terid = D.terid2)
			 WHERE D.tipodoc = 'FVE' AND D.formapago = 'CR' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."' 
			 ORDER BY DV.diaoperativo ASC , D.fechadoc ASC";
			  
     $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i==0)
		   $clase->EjecutarSQL("DELETE FROM estacreditos WHERE periodo = '".$periodo."' AND (codsuc = '00' OR codsuc = 'DB' OR codsuc = 'DBU' OR codsuc = 'DME')");
		
		$b0 = $t0 = $row['total00'];   
		$t5 = $row['total05'];
		$i5 = $t5/1.05;
		$b5 = $t5-$i5;

		$t19 = $row['total19'];
		$i19 = $t19/1.19;
		$b19 = $t19-$i19;
		
		$codsuc = $row['codsuc'];
		$numfactura = "FVE ".$row['prefijo']." ".$row['numero'];

	    $vsql = "INSERT INTO estacreditos(codsuc,periodo,diaoperativo,numfactura,codempleado,dnicliente,nomcliente,base00,base05,base19,iva05,iva19,total,codautorizo) 
		         VALUES('".$codsuc."','".$periodo."','".$row['diaoperativo']."','".$numfactura."','".$row['codvende']."','".$row['dni']."','".$row['nombres']." ".$row['apellidos']."','".$b0."','".$b5."','".$b19."'
				 ,'".$i5."','".$i19."','".$row['total']."','".$row['observacion2']."')";
		$clase->EjecutarSQL($vsql);

		$i++;		
	 } // Fin While


  } /// fin ActualizarEstadisticaVentasLocalServidor

  /////////////////////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////////////////////////
  function GenerarExistenciasAServidor()
 {
     ini_set("memory_limit","300M");
	 error_reporting(E_ALL);
	 set_time_limit(0);
     $clase = new Sistema();
	 $bodegaid = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],'bodegas','codbodega','bodegaid');
	 
	 /// Elimino el Archivo 
	 //$archivo1 = "../Dropbox/Todos/ULT-Existencias-".$_SESSION['G_SUCURSALPOS'].".sql";
 	 $archivo1 = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/Todos/ULT-Existencias-".$_SESSION['G_SUCURSALPOS'].".sql";
	 
	 if(file_exists($archivo1))
       unlink($archivo1);

	 $clase = new Sistema();
	 $vsql = "SELECT * FROM existencias WHERE bodegaid =".$bodegaid." AND cantidad <> 0";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo1,"w");
	 $cont="";
	 $i=0;
	 while($row = @mysql_fetch_array($result))
	 { 
	   if($i==0){
	       $cont.="SET NAMES LATIN1;".Chr(13).Chr(10);	
	       $cont.="UPDATE IGNORE existencias SET cantidad = 0 WHERE bodegaid=".$row['bodegaid'].";".Chr(13).Chr(10);	   
	    }
	  	  
	   $cont.="UPDATE IGNORE existencias SET cantidad =".$row['cantidad']." WHERE bodegaid=".$row['bodegaid']." AND productoid=".$row['productoid'].";".Chr(13).Chr(10);	   
	   $i++;
	 } 
     
	 /// Ingreso otros Parametros de Actualizacion	 
	 $version = $clase->BDLockup('G_VERSIONAPP','configuraciones','variab','contenido');
	 $cont.="UPDATE IGNORE sucursales SET diaoperativo='".$_SESSION['G_DIAOPERATIVO']."' , ultcierre='".date("dMY His")."' WHERE codigo='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	   
	 
	 fwrite($fp,$cont);
     fclose($fp);	 

	 ///////////////////////////////////////////////////////////
	 /// Genero el Archivo de KARDEX
     GenerarArchivoKardex(date("mY"));	

     $clase->closeConnection();	 
 } 
  
    ////////////////////////////////////////////////////
    function GenerarArchivoKardex($periodo)
    {
	ini_set("memory_limit","300M");
	error_reporting(E_ALL);

    $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/KARDEXPERIODO-".$_SESSION['G_SUCURSALPOS'].".sql";
	 
	if(file_exists($archivo))
	   unlink($archivo);
	 
	 ///// Me conecto a la Base de Datos
	 $clase = new Sistema();
     $bodegaid = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],'bodegas','codbodega','bodegaid');
     $bodegaid2 = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS']."B",'bodegas','codbodega','bodegaid');
     $wherebodegas = $bodegaid;
     if($bodegaid2 != "")  $wherebodegas.= ",".$bodegaid2;

	 /// 1. Envio SOLO los siguientes Documentos : FVE - DVE - AJU - REN - RSA
	 $vsql   = "SELECT DISTINCT * FROM kardex WHERE periodo ='".$periodo."' AND bodegaid IN (".$wherebodegas.")";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);

	 $fp = fopen($archivo,"w");
	 $cont="";	 
	 $i=0;      $j=0;
	 while($row = @mysql_fetch_array($result))
	 { 
	    if($i==0){
	       $cont.="SET NAMES LATIN1;".Chr(13).Chr(10);	
	       $cont.="DELETE FROM KARDEX WHERE periodo ='".$periodo."' AND bodegaid IN (".$wherebodegas.");".Chr(13).Chr(10);	
	    }

	    if($j == 0)
	    { 
	       if($i == 0)
	         $cont.="INSERT IGNORE INTO kardex(tipodoc,prefijo,fechadoc,numero,productoid,periodo,bodegaid,sucursalid,cantidad,creador,momento,kardexidsuc) values('".$row['tipodoc']."','".$row['prefijo']."','".$row['fechadoc']."','".$row['numero']."',".$row['productoid'].",'".$row['periodo']."',".$bodegaid.",".$row['sucursalid'].",".$row['cantidad'].",'VENDEDOR','".$row['momento']."','".$row['kardexid']."')";
           else
           {
           	 $cont.=";".Chr(13).Chr(10);	
           	 $cont.="INSERT IGNORE INTO kardex(tipodoc,prefijo,fechadoc,numero,productoid,periodo,bodegaid,sucursalid,cantidad,creador,momento,kardexidsuc) values('".$row['tipodoc']."','".$row['prefijo']."','".$row['fechadoc']."','".$row['numero']."',".$row['productoid'].",'".$row['periodo']."',".$bodegaid.",".$row['sucursalid'].",".$row['cantidad'].",'VENDEDOR','".$row['momento']."','".$row['kardexid']."')";          
           }
	    }
	    else
        {
           $cont.=",('".$row['tipodoc']."','".$row['prefijo']."','".$row['fechadoc']."','".$row['numero']."',".$row['productoid'].",'".$row['periodo']."',".$row['bodegaid'].",".$row['sucursalid'].",".$row['cantidad'].",'VENDEDOR','".$row['momento']."','".$row['kardexid']."')";
        }

        /// Solo 40 Registros mete por Linea
        if($j==40)
           $j = 0;           
        else
       	   $j++;
	   
	    $i++;		  
	 } 
     $cont.=";".Chr(13).Chr(10);

     $sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");
     $cont.="UPDATE sucursales SET ultrecekardex = CURRENT_TIMESTAMP WHERE sucursalid = ".$sucursalid.";";

	 fwrite($fp,$cont);
     fclose($fp);
     $clase->closeConnection();	
 }  

 ///////////////////////////////////////////////////////////////////////
 /// Se debe actualizar en el Servicio WSJSON/WEBCOMANDOS
 ///////////////////////////////////////////////////////////////////////
 function GenerarArchivoKardexTotal($periodo)
 {
	 ini_set("memory_limit","300M");
	 error_reporting(E_ALL);

     $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/KARDEXTOTAL-".$_SESSION['G_SUCURSALPOS'].".sql";
	 
	 if(file_exists($archivo))
	   unlink($archivo);
	 
	 ///// Me conecto a la Base de Datos
	 $clase = new Sistema();
     $bodegaid = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],'bodegas','codbodega','bodegaid');
     $bodegaid2 = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS']."B",'bodegas','codbodega','bodegaid');
     $wherebodegas = $bodegaid;
     if($bodegaid2 != "")  $wherebodegas.= ",".$bodegaid2;

	 if($periodo == "") 
		$anio = date("Y");   //$anio--;
	 else
	    $anio = substr($periodo,2,4);		
		
	 $vsql   = "SELECT DISTINCT * FROM kardex WHERE periodo LIKE '%".$anio."' AND bodegaid IN (".$wherebodegas.") ORDER BY kardexid DESC";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);

	 $fp = fopen($archivo,"w");
	 $cont="";	 
	 $i=0;      $j=0;
	 while($row = @mysql_fetch_array($result))
	 { 
	    if($i==0){
	       $cont.="SET NAMES LATIN1;".Chr(13).Chr(10);	
	       $cont.="DELETE FROM kardex WHERE periodo LIKE '%".$anio."' AND bodegaid IN (".$wherebodegas.");".Chr(13).Chr(10);	
	    }
	   
	    if($j == 0)
	    { 
	       if($i == 0)
	         $cont.="INSERT IGNORE INTO kardex(tipodoc,prefijo,fechadoc,numero,productoid,periodo,bodegaid,sucursalid,cantidad,creador,momento,kardexidsuc) values('".$row['tipodoc']."','".$row['prefijo']."','".$row['fechadoc']."','".$row['numero']."',".$row['productoid'].",'".$row['periodo']."',".$bodegaid.",".$row['sucursalid'].",".$row['cantidad'].",'VENDEDOR','".$row['momento']."','".$row['kardexid']."')";
           else
           {
           	 $cont.=";".Chr(13).Chr(10);	
           	 $cont.="INSERT IGNORE INTO kardex(tipodoc,prefijo,fechadoc,numero,productoid,periodo,bodegaid,sucursalid,cantidad,creador,momento,kardexidsuc) values('".$row['tipodoc']."','".$row['prefijo']."','".$row['fechadoc']."','".$row['numero']."',".$row['productoid'].",'".$row['periodo']."',".$bodegaid.",".$row['sucursalid'].",".$row['cantidad'].",'VENDEDOR','".$row['momento']."','".$row['kardexid']."')";          
           }
	    }
	    else
        {
           $cont.=",('".$row['tipodoc']."','".$row['prefijo']."','".$row['fechadoc']."','".$row['numero']."',".$row['productoid'].",'".$row['periodo']."',".$row['bodegaid'].",".$row['sucursalid'].",".$row['cantidad'].",'VENDEDOR','".$row['momento']."','".$row['kardexid']."')";
        }

        /// Solo 40 Registros mete por Linea
        if($j==40)
           $j = 0;           
        else
       	   $j++;
	   
	    $i++;		  
	 } 
     
	 fwrite($fp,$cont);
     fclose($fp);
     $clase->closeConnection();	 
  }  


 ///////////////////////////////////////////////////////////////////
 ///  SD : Busca las ventas y Devoluciones de los 2 ultimos dias
 ///////////////////////////////////////////////////////////////////
 function GenerarConsolidadoDias()
 {
	///// Me conecto a la Base de Datos
	$clase = new Sistema();
	
    /// Fecha Ultimo Cierre
	$fechacierreultimo = $clase->SeleccionarUno('SELECT STR_TO_DATE(diaoperativo, "%d/%m/%Y") dia FROM cierres WHERE tipocierre = "DEF" ORDER BY cierreid DESC LIMIT 0,1');

	// Inicializo las variables
	$enc = ""; $cont= "";  $periodo = "";

	// Busco los dias operativos - Dia 1 es Dia Actual
    $vsql = "SELECT DATE_SUB('".$fechacierreultimo."' , INTERVAL 2 DAY) dia1 , DATE_SUB('".$fechacierreultimo."' , INTERVAL 1 DAY) dia2 , '".$fechacierreultimo."' as dia3 , DATE_SUB('".$fechacierreultimo."' , INTERVAL -1 DAY) dia4 , DATE_SUB('".$fechacierreultimo."' , INTERVAL -2 DAY) dia5 ";
    $conex  = $clase->Conectar();
    $result = mysql_query($vsql,$conex);
    if($row = mysql_fetch_array($result)) 
    { 
        $dia1 = substr($row['dia1'],8,2)."/".substr($row['dia1'],5,2)."/".substr($row['dia1'],0,4);      
		$dia2 = substr($row['dia2'],8,2)."/".substr($row['dia2'],5,2)."/".substr($row['dia2'],0,4);      
		$dia3 = substr($row['dia3'],8,2)."/".substr($row['dia3'],5,2)."/".substr($row['dia3'],0,4);
		$dia4 = substr($row['dia4'],8,2)."/".substr($row['dia4'],5,2)."/".substr($row['dia4'],0,4);
		$dia5 = substr($row['dia5'],8,2)."/".substr($row['dia5'],5,2)."/".substr($row['dia5'],0,4);
    }

	if(($dia1 != "")&&($dia2 != "")&&($dia3 != ""))
	{
	  ini_set("memory_limit","300M");
	  error_reporting(E_ALL);      
	  
      $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/CONSOLIDA-DIA-".$_SESSION['G_SUCURSALPOS'].".sql";
	  if(file_exists($archivo))	      unlink($archivo);
	  
	  ///// Encabezado del Archivo
      if($_SESSION['G_SUCURSALPOS'] == "00")  $bodega = 50;
      else                                    $bodega = $_SESSION['G_SUCURSALPOS'];	 

	  $enc = "SET NAMES LATIN1;".Chr(13).Chr(10);	
	  if(($_SESSION['G_SUCURSALPOS'] == "00")||($_SESSION['G_SUCURSALPOS'] == "DB")||($_SESSION['G_SUCURSALPOS'] == "DBU")||($_SESSION['G_SUCURSALPOS'] == "MDE"))
	     $enc.= "DELETE FROM consolida1 WHERE (CODSUCURSAL = '00' OR CODSUCURSAL = 'DB' OR CODSUCURSAL = 'DBU' OR CODSUCURSAL = 'MDE') AND (DVDIAOPE LIKE '".$periodo2."' OR DDDIAOPE LIKE '".$periodo2."');".Chr(13).Chr(10);	
	  else
	     $enc.= "DELETE FROM consolida1 WHERE CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."' AND (DVDIAOPE IN('".$dia1."','".$dia2."','".$dia3."','".$dia4."','".$dia5."') OR DDDIAOPE IN('".$dia1."','".$dia2."','".$dia3."','".$dia4."','".$dia5."'));".Chr(13).Chr(10);	  

	  $clase = new Sistema();

	 //// Le pongo el dia Operativo a las Cotizaciones
	 $vsql = "";
	 
     /// Saco el Infoe
	 $vsql  = "select distinct doc.tipodoc as tipodoc,doc.prefijo as prefijodoc,doc.numero as numerodoc ,doc.fechadoc as fechadoc,doc.periodo as periododoc,doc.formapago as formapagodoc,
			   cli.dni as dniclidoc,cli.nombres as nombresclidoc,cli.apellidos as apeclidoc ,cli.direccion as dirclidoc,concat(cli.telfijo,_utf8' ',cli.telmovil) as telclidoc,
			   ven.codvende as codvendoc,ven.nombres as nomvendoc,ven.apellidos as apevendoc ,men.codvende as codmendoc , men.coddomi as codmendoc2,men.nombres as nommendoc,
			   men.apellidos as apemendoc,med.codmedico as codmeddoc,med.dni as dnimeddoc,med.nommedico as nommeddoc ,doc.observacion as observadoc,doc.totalitems as itemsdoc,
			   doc.base as vrbasedoc,doc.iva as vrivadoc,suc.codigo as codsucursal,suc.descripcion as nomsucdoc ,doc.creador as credordoc,doc.momento as momentodoc, dvt.procedencia as procedencia , 
			   doc.total as totaldoc,bod.codbodega as decodbod,bod.nombodega as denombod,dvt.diaoperativo as dvdiaope,ddv.diaoperativo as dddiaope,dvt.valorfp1 as fpefectivo,
			   (dvt.valorfp2+dvt.valorfp3) as fptarjetas,dvt.valorfp4 as fpotros,dd.diasrecor , pro.codigo as codproducto,pro.descripcion as nomproducto,lab.codigo as codlabo,
			   lab.descripcion as nomlabo, dd.valunitario as devaluni , dvt.puntosacumulados depuntos , dd.porciva , doc.observacion2 , sum(dd.cantidad) as decantidad , 
			   sum(dd.valparcial) as devalpar , sum(dd.valbase) as devalbase , sum(dd.valiva) as devaliva , sum(dd.valtotal) as devaltotal , sum(dd.unicom) as deunicom , 
			   sum(dd.unifra) as deunifra , pro.ultcosto as costoprod , pro.productoid , bod.bodegaid , bod.sucursalid 
		       from (((((((((((documentos doc join sucursales suc on((doc.sucursalid = suc.sucursalid))) join terceros cli on((cli.terid = doc.terid1))) 
		       join terceros ven on((ven.terid = doc.terid2))) join terceros men on((men.terid = doc.terid3))) 
               join dedocumentos dd on((doc.docuid = dd.docuid))) join bodegas bod on((bod.bodegaid = dd.bodegaid))) 
               join productos pro on((pro.productoid = dd.productoid))) join gruposprod lab on((lab.gruposprodid = pro.gruposprodid))) 
               left join docuventa dvt on((doc.docuid = dvt.docuid))) left join medicos med on((med.medicoid = dvt.medicoid))) 
			   left join docudevolucion ddv on((doc.docuid = ddv.docuid))) 
			   where (((dvt.diaoperativo IN('".$dia1."','".$dia2."','".$dia3."','".$dia4."','".$dia5."'))Or(ddv.diaoperativo IN('".$dia1."','".$dia2."','".$dia3."','".$dia4."','".$dia5."')))  
			   and (doc.fecasentado <> _utf8'0000-00-00') and ((doc.tipodoc = _utf8'fve') or (doc.tipodoc = _utf8'dve') or (doc.tipodoc = _utf8'cot') or (doc.tipodoc = _utf8'fec')))
               group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43 order by fechadoc asc";

     $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 
	 $cont = "";   $lineas = "";	  
	 $i=0;  $agendo = "";
	 while($row = @mysql_fetch_array($result))
	 {  	
	   $periodo = $row['periododoc'];

	   if($row['codmendoc'] == "")  
	      $mensajero = $row['codmendoc2'];
	   else
	      $mensajero = $row['codmendoc'];
	   
	   if($row['tipodoc'] == "DVE")
	      $diaoperativo = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);    
	   else
	      $diaoperativo = $row['dvdiaope'];

       $puntosx = 0;                  $puntosx = 0+$row['depuntos'];
	   if($row['diasrecor'] > 0) 	  $agendo = substr($row['diasrecor'],0,3);        else     	  $agendo = "";

	   $observacionx = $row['observadoc'];
	   if(strlen($row['procedencia'])>0)
	      $observacionx = $row['procedencia'];

	   if($i == 0)
	   {
          $lineas ="INSERT INTO consolida1(TIPODOC, PREFIJODOC, NUMERODOC, FECHADOC, PERIODODOC, FORMAPAGODOC, DNICLIDOC, NOMBRESCLIDOC, APECLIDOC, DIRCLIDOC, TELCLIDOC, CODVENDOC, NOMVENDOC, APEVENDOC, CODMENDOC, NOMMENDOC, APEMENDOC, CODMEDDOC, DNIMEDDOC, NOMMEDDOC, OBSERVADOC, OBSERVACION2, ITEMSDOC, VRBASEDOC, VRIVADOC, CODSUCURSAL, NOMSUCDOC, CREDORDOC, MOMENTODOC, TOTALDOC, DEPORCIVA, NRODOCREF, DECODBOD, DENOMBOD, DECANTIDAD, DEVALUNI, DEVALPAR, DEVALBASE, DEVALIVA, DEVALTOTAL, DEUNICOM, DEUNIFRA, DEPUNTOS , AGENDO , DVDIAOPE, DDDIAOPE, FPEFECTIVO , FPTARJETAS , FPOTROS , CODPRODUCTO, NOMPRODUCTO, CODLABO, NOMLABO, MOMINSERTADO , COSTOPROD, PRODUCTOID, BODEGAID, SUCURSALID) VALUES ('".$row['tipodoc']."','".$row['prefijodoc']."','".$row['numerodoc']."','".$row['fechadoc']."','".$row['periododoc']."','".$row['formapagodoc']."','".limpiarCaracteresEspeciales($row['dniclidoc'])."','".substr(limpiarCaracteresEspeciales($row['nombresclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['apeclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['dirclidoc']),0,30)."','".limpiarCaracteresEspeciales($row['telclidoc'])."','".$row['codvendoc']."','".$row['nomvendoc']."','".$row['apevendoc']."','".$mensajero."','".$row['nommendoc']."','".$row['apemendoc']."','".$row['codmeddoc']."','".$row['dnimeddoc']."','".$row['nommeddoc']."','".$observacionx."','".$row['observacion2']."','".$row['itemsdoc']."','".$row['vrbasedoc']."','".$row['vrivadoc']."','".$row['codsucursal']."','".$row['nomsucdoc']."','".$row['credordoc']."','".$row['momentodoc']."','".$row['totaldoc']."','".$row['porciva']."','".$row['observacion2']."','".$row['decodbod']."','".$row['denombod']."','".$row['decantidad']."','".$row['devaluni']."','".$row['devalpar']."','".(0+$row['devalbase'])."','".(0+$row['devaliva'])."','".(0+$row['devaltotal'])."','".$row['deunicom']."','".$row['deunifra']."','".$puntosx."','".$agendo."','".$diaoperativo."','".$row['dddiaope']."',".(0+$row['fpefectivo']).",".(0+$row['fptarjetas']).",".(0+$row['fpotros']).",'".$row['codproducto']."','".substr($row['nomproducto'],0,70)."','".$row['codlabo']."','".substr($row['nomlabo'],0,50)."','".$row['fechadoc']."',  ".$row['costoprod'].", ".$row['productoid'].", ".$row['bodegaid'].", ".$row['sucursalid'].")";	   
	   }
	   else
	   {
          if($i == 40)
		  {
              $lineas.=",('".$row['tipodoc']."','".$row['prefijodoc']."','".$row['numerodoc']."','".$row['fechadoc']."','".$row['periododoc']."','".$row['formapagodoc']."','".limpiarCaracteresEspeciales($row['dniclidoc'])."','".substr(limpiarCaracteresEspeciales($row['nombresclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['apeclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['dirclidoc']),0,30)."','".limpiarCaracteresEspeciales($row['telclidoc'])."','".$row['codvendoc']."','".$row['nomvendoc']."','".$row['apevendoc']."','".$mensajero."','".$row['nommendoc']."','".$row['apemendoc']."','".$row['codmeddoc']."','".$row['dnimeddoc']."','".$row['nommeddoc']."','".$observacionx."','".$row['observacion2']."','".$row['itemsdoc']."','".$row['vrbasedoc']."','".$row['vrivadoc']."','".$row['codsucursal']."','".$row['nomsucdoc']."','".$row['credordoc']."','".$row['momentodoc']."','".$row['totaldoc']."','".$row['porciva']."','".$row['observacion2']."','".$row['decodbod']."','".$row['denombod']."','".$row['decantidad']."','".$row['devaluni']."','".$row['devalpar']."','".(0+$row['devalbase'])."','".(0+$row['devaliva'])."','".(0+$row['devaltotal'])."','".$row['deunicom']."','".$row['deunifra']."','".$puntosx."','".$agendo."','".$diaoperativo."','".$row['dddiaope']."','".(0+$row['fpefectivo'])."','".(0+$row['fptarjetas'])."','".(0+$row['fpotros'])."','".$row['codproducto']."','".substr($row['nomproducto'],0,70)."','".$row['codlabo']."','".substr($row['nomlabo'],0,50)."','".$row['fechadoc']."',  ".$row['costoprod'].", ".$row['productoid'].", ".$row['bodegaid'].", ".$row['sucursalid'].");".Chr(13).Chr(10);	   
		  } 
		  else
		  {
              $lineas.=",('".$row['tipodoc']."','".$row['prefijodoc']."','".$row['numerodoc']."','".$row['fechadoc']."','".$row['periododoc']."','".$row['formapagodoc']."','".limpiarCaracteresEspeciales($row['dniclidoc'])."','".substr(limpiarCaracteresEspeciales($row['nombresclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['apeclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['dirclidoc']),0,30)."','".limpiarCaracteresEspeciales($row['telclidoc'])."','".$row['codvendoc']."','".$row['nomvendoc']."','".$row['apevendoc']."','".$mensajero."','".$row['nommendoc']."','".$row['apemendoc']."','".$row['codmeddoc']."','".$row['dnimeddoc']."','".$row['nommeddoc']."','".$observacionx."','".$row['observacion2']."','".$row['itemsdoc']."','".$row['vrbasedoc']."','".$row['vrivadoc']."','".$row['codsucursal']."','".$row['nomsucdoc']."','".$row['credordoc']."','".$row['momentodoc']."','".$row['totaldoc']."','".$row['porciva']."','".$row['observacion2']."','".$row['decodbod']."','".$row['denombod']."','".$row['decantidad']."','".$row['devaluni']."','".$row['devalpar']."','".(0+$row['devalbase'])."','".(0+$row['devaliva'])."','".(0+$row['devaltotal'])."','".$row['deunicom']."','".$row['deunifra']."','".$puntosx."','".$agendo."','".$diaoperativo."','".$row['dddiaope']."','".(0+$row['fpefectivo'])."','".(0+$row['fptarjetas'])."','".(0+$row['fpotros'])."','".$row['codproducto']."','".substr($row['nomproducto'],0,70)."','".$row['codlabo']."','".substr($row['nomlabo'],0,50)."','".$row['fechadoc']."',  ".$row['costoprod'].", ".$row['productoid'].", ".$row['bodegaid'].", ".$row['sucursalid'].")";	   
		  }     
	   } 	  
	   
	   $i++;		  
	 }  

	 /// Arreglo para consolidar con toda la informacion
	 $cont.= "UPDATE consolida1 SET DEVALPAR  = DEVALUNI*DECANTIDAD WHERE DEVALPAR = 0 AND PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);
	 $cont.= "UPDATE consolida1 SET DEVALBASE = DEVALTOTAL*DEVALIVA WHERE DEVALBASE = 0 AND PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);
	 $cont.= "UPDATE consolida1 SET DEVALIVA  = DEVALTOTAL-DEVALBASE WHERE PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	 
     $cont.= "UPDATE consolida1 SET VRBASEDOC = TOTALDOC-VRIVADOC WHERE VRBASEDOC = 0 AND VRIVADOC = 0 AND PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	 	 
	 
	 /*
     /////////////////////////////////////////////////////
     ///// Le borro lo del Transporte
     $vsql = "SELECT tipodoc , prefijo , numero FROM documentos WHERE tipodoc = 'TRB' ORDER BY fechadoc DESC LIMIT 0,300";
     $result = @mysql_query($vsql,$conex);
	 $cont2 = "";	  
	 
	 while($row = @mysql_fetch_array($result))
	 { 
         $cont2.="DELETE FROM kardextransito WHERE tipodoc = 'TRB' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."';".Chr(13).Chr(10);	   
         $cont2.="DELETE FROM kardex WHERE tipodoc = 'TRB' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."' AND bodegaid = 87;".Chr(13).Chr(10);
	     $i++;		  
	 }  
     */

	 /////////////////////////////////////////////////////
     ///// Los Especiales los incluyo en el Archivo
     $enc3 = "DELETE FROM consolida2 WHERE PERIODOESPE = '".$periodo."' AND CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	

	 $month   = substr($periodo,0,2);
	 $year    = substr($periodo,2,4);
	 $ultimodia = date('t', mktime(0, 0, 0, $month, 1, $year));

	 $vsql = "SELECT B.* , S.codigo codsuc , S.descripcion nomsuc , P.codigo codpro , P.descripcion nompro , T.codvende , CONCAT(T.nombres,' ',T.apellidos) nomvende 
	           FROM bonificado B INNER JOIN productos P ON (P.productoid = B.productoid) 
	           INNER JOIN sucursales S ON (S.sucursalid = B.sucursalid) 
	           INNER JOIN terceros T ON (T.terid = B.vendedor) 
	           WHERE B.fecha >= '".substr($periodo,2,4)."-".substr($periodo,0,2)."-01' AND B.fecha <= '".substr($periodo,2,4)."-".substr($periodo,0,2)."-".$ultimodia."'";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 $cont3 = "";	  
	 $i=0;  $agendo = "";
	 $SUCURSALIDX = "";
	 while($row = @mysql_fetch_array($result))
	 { 
		 $SUCURSALIDX = $row['sucursalid'];

	     $cont3.="INSERT INTO consolida2(PERIODOESPE, FECHAESPE , CODVENDE , NOMVENDE , CODPRODUCTO , NOMPRODUCTO , CANTIVENTA , VALORVENTA , PORCENBONI , VALORCOMI , CODSUCURSAL ,  NOMSUCURSAL , PAGADO ) VALUES ('".$periodo."','".$row['fecha']."','".$row['codvende']."','".$row['nomvende']."','".$row['codpro']."','".$row['nompro']."','".$row['cantidad']."','".$row['valorventa']."','".$row['porcenboni']."','".$row['valorcomi']."','".$row['codsuc']."','".$row['nomsuc']."','".$row['pagado']."');".Chr(13).Chr(10);	   
	     $i++;		  
	 }
	 
	 $enc5 = "SET NAMES LATIN1;".Chr(13).Chr(10);	
	 $enc5.= "DELETE FROM consolida3 WHERE CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."' AND DIAOPERATIVO LIKE '%/".$month."/".$year."';".Chr(13).Chr(10);	

	 $vsql  = "SELECT S.codigo codsucursal , S.descripcion nomsucursal , D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.total , DV.diaoperativo , TR.codoperador , 
			   TR.numrecarga, TR.valor, TR.codvende, TR.pinrecargas 
			   FROM documentos D INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid) 
			   INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
			   INNER JOIN productos P ON (P.productoid = DD.productoid)
			   INNER JOIN docuventa DV ON ( D.docuid = DV.docuid ) 
			   INNER JOIN transarecargas TR ON ( D.docuid = TR.idfactura )
			   WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '%/".$month."/".$year."' AND D.numero NOT LIKE '-%' 
			   AND (P.codigo = 'R1000' OR P.codigo = 'R1001')";

	 $conex  = $clase->Conectar();
	 $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo,"w");
	 $cont5 = "";	  
	 $i=0;  $agendo = "";
	 while($row = @mysql_fetch_array($result))
	 { 
		 $cont5.="INSERT INTO consolida3(CODSUCURSAL,NOMSUCURSAL,TIPODOC,PREFIJODOC,NUMERODOC,FECHADOC,DIAOPERATIVO,CODOPERADOR,NUMRECARGA,VALOR,CODVENDE,PINRECARGAS,TOTALDOC) VALUES ('".$row['codsucursal']."','".$row['nomsucursal']."','".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['fechadoc']."','".$row['diaoperativo']."','".$row['codoperador']."','".$row['numrecarga']."','".$row['valor']."','".$row['codvende']."','".$row['pinrecargas']."','".$row['total']."');".Chr(13).Chr(10);	   
		 $i++;		  
	 }  

    }	 

     /////// Ingreso las Existencias Actuales
	 $vsql = "SELECT * FROM existencias E INNER JOIN bodegas B ON (E.bodegaid = B.bodegaid) WHERE B.codbodega = '".$_SESSION['G_BODEGAPREDETPOS']."' ORDER BY E.ultcambio DESC LIMIT 0,1000";
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 $cont4 = "";	  
	 $i=0;  $agendo = "";
	 while($row = @mysql_fetch_array($result))
	 { 
	     $cont4.= "UPDATE existencias SET cantidad = '".$row['cantidad']."' WHERE bodegaid = ".$row['bodegaid']." AND productoid = ".$row['productoid'].";".Chr(13).Chr(10);	   
	     $i++;		  
	 }   

	 //// Finalizando, Inserto en el Log de Carga de Archivos
	 $cont4.= "INSERT INTO cargaarchivossucursal(sucursalid,diaoperativo) VALUES(".$SUCURSALIDX.",'".$_SESSION['G_DIAOPERATIVO']."');".Chr(13).Chr(10);	   

     //// Junto Todas las Variables y Genero el archivo
	 $fp = fopen($archivo,"w");
	 $contenido = $enc.$cont.$cont2.$enc3.$cont3.$cont4.$enc5.$cont5;
	 fwrite($fp,$contenido);
	 fclose($fp);

    $clase->closeConnection();	     	 

	$periodo = date("mY");
	GenerarDATARotacion($periodo);
    GenerarConsolidadoEspeciales($periodo);
    GenerarConsolidadoRecargas($periodo);
	
    return;
  }  

 ////////////////////////////////////////////////////
 function GenerarConsolidadoUnico($periodo)
 {
	$enc = ""; $cont= "";

	if($periodo != "")
	{
	 ini_set("memory_limit","300M");
	 error_reporting(E_ALL);
     
	 $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/CONSOLIDA-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";
	 if(file_exists($archivo))	     unlink($archivo);

	 ///// Encabezado del Archivo
     if($_SESSION['G_SUCURSALPOS'] == "00")  $bodega = 50;
     else                                    $bodega = $_SESSION['G_SUCURSALPOS'];
	 
     //// Armo la variable Periodo2 que hace lo siguiente -> Si Periodo = 012020 Entonces Periodo2 = /01/2020
	 $periodo2 = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);
	 
	 $enc = "SET NAMES LATIN1;".Chr(13).Chr(10);	
	 if(($_SESSION['G_SUCURSALPOS'] == "00")||($_SESSION['G_SUCURSALPOS'] == "DB")||($_SESSION['G_SUCURSALPOS'] == "DBU"))
	    $enc.= "DELETE FROM consolida1 WHERE (CODSUCURSAL = '00' OR CODSUCURSAL = 'DB' OR CODSUCURSAL = 'DBU') AND (DVDIAOPE LIKE '".$periodo2."' OR DDDIAOPE LIKE '".$periodo2."');".Chr(13).Chr(10);	
	 else
	    $enc.= "DELETE FROM consolida1 WHERE CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."' AND (DVDIAOPE LIKE '".$periodo2."' OR DDDIAOPE LIKE '".$periodo2."');".Chr(13).Chr(10);	  

	 $clase = new Sistema();
	 $vsql  = "SELECT DISTINCT doc.docuid , doc.tipodoc as tipodoc,doc.prefijo as prefijodoc,doc.numero as numerodoc ,doc.fechadoc as fechadoc,doc.periodo as periododoc,doc.formapago as formapagodoc,
			   cli.dni as dniclidoc,cli.nombres as nombresclidoc,cli.apellidos as apeclidoc ,cli.direccion as dirclidoc,concat(cli.telfijo,_utf8' ',cli.telmovil) as telclidoc,
			   ven.codvende as codvendoc,ven.nombres as nomvendoc,ven.apellidos as apevendoc ,men.codvende as codmendoc , men.coddomi as codmendoc2,men.nombres as nommendoc,
			   men.apellidos as apemendoc,med.codmedico as codmeddoc,med.dni as dnimeddoc,med.nommedico as nommeddoc ,doc.observacion as observadoc,doc.totalitems as itemsdoc,
			   doc.base as vrbasedoc,doc.iva as vrivadoc,suc.codigo as codsucursal,suc.descripcion as nomsucdoc ,doc.creador as credordoc,doc.momento as momentodoc, dvt.procedencia as procedencia , 
			   doc.total as totaldoc,bod.codbodega as decodbod,bod.nombodega as denombod,dvt.diaoperativo as dvdiaope,ddv.diaoperativo as dddiaope,dvt.valorfp1 as fpefectivo,
			   (dvt.valorfp2+dvt.valorfp3) as fptarjetas,dvt.valorfp4 as fpotros,dd.diasrecor , pro.codigo as codproducto,pro.descripcion as nomproducto,lab.codigo as codlabo,
			   lab.descripcion as nomlabo, dd.valunitario as devaluni , dvt.puntosacumulados depuntos, sum(dd.cantidad) as decantidad , sum(dd.valparcial) as devalpar , sum(dd.valbase) as devalbase , 
			   sum(dd.valiva) as devaliva , sum(dd.valtotal) as devaltotal , sum(dd.unicom) as deunicom , sum(dd.unifra) as deunifra , dd.costoprod as costoprod , pro.productoid , bod.bodegaid , bod.sucursalid 
		       FROM documentos doc join sucursales suc on((doc.sucursalid = suc.sucursalid))  
		       join terceros ven on((ven.terid = doc.terid2)) 
               join dedocumentos dd on((doc.docuid = dd.docuid)) join bodegas bod on((bod.bodegaid = dd.bodegaid)) 
               join productos pro on((pro.productoid = dd.productoid)) join gruposprod lab on((lab.gruposprodid = pro.gruposprodid))
			   left join terceros cli on((cli.terid = doc.terid1)) 
               left join docuventa dvt on((doc.docuid = dvt.docuid)) left join medicos med on((med.medicoid = dvt.medicoid)) 
			   left join docudevolucion ddv on((doc.docuid = ddv.docuid))
			   LEFT join terceros men on((men.terid = doc.terid3)) 
			   where (((dvt.diaoperativo LIKE _utf8'".$periodo2."')Or(ddv.diaoperativo LIKE _utf8'".$periodo2."'))  
			   and (doc.fecasentado <> _utf8'0000-00-00') and ((doc.tipodoc = _utf8'FVE') or (doc.tipodoc = _utf8'fve') or (doc.tipodoc = _utf8'dve') or (doc.tipodoc = _utf8'cot') or (doc.tipodoc = _utf8'fec')))
               group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44 order by fechadoc asc";

     $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 //echo $vsql."<br><br>";
	 $cont = "";	  
	 $i=0;  $agendo = "";
	 while($row = @mysql_fetch_array($result))
	 {  	
	   if($row['codmendoc'] == "")  
	      $mensajero = $row['codmendoc2'];
	   else
	      $mensajero = $row['codmendoc'];
	   
	   if($row['dvdiaope'] == "")
	      $diaoperativo = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);    
	   else
	      $diaoperativo = $row['dvdiaope'];

       $puntosx = 0;                  $puntosx = 0+$row['depuntos'];
	   if($row['diasrecor'] > 0) 	  $agendo = substr($row['diasrecor'],0,3);        else     	  $agendo = "";
	
	   $observacionx = $row['observadoc'];
	   if(strlen($row['procedencia'])>0)
	      $observacionx = $row['procedencia'];

	   //echo $i;
	   
	   if($i == 0)
	   {
		  $enc2  = "INSERT INTO consolida1(TIPODOC, PREFIJODOC, NUMERODOC, FECHADOC, PERIODODOC, FORMAPAGODOC, DNICLIDOC, NOMBRESCLIDOC, APECLIDOC, DIRCLIDOC, TELCLIDOC, CODVENDOC, NOMVENDOC, APEVENDOC, CODMENDOC, NOMMENDOC, APEMENDOC, CODMEDDOC, DNIMEDDOC, NOMMEDDOC, OBSERVADOC, OBSERVACION2, ITEMSDOC, VRBASEDOC, VRIVADOC, CODSUCURSAL, NOMSUCDOC, CREDORDOC, MOMENTODOC, TOTALDOC, DECODBOD, DENOMBOD, DECANTIDAD, DEVALUNI, DEVALPAR, DEVALBASE, DEVALIVA, DEVALTOTAL, DEUNICOM, DEUNIFRA, DEPUNTOS , AGENDO , DVDIAOPE, DDDIAOPE, FPEFECTIVO , FPTARJETAS , FPOTROS , CODPRODUCTO, NOMPRODUCTO, CODLABO, NOMLABO, MOMINSERTADO , COSTOPROD, PRODUCTOID, BODEGAID, SUCURSALID , DOCUID) VALUES ";
		  $det .= "('".$row['tipodoc']."','".$row['prefijodoc']."','".$row['numerodoc']."','".$row['fechadoc']."','".$row['periododoc']."','".$row['formapagodoc']."','".limpiarCaracteresEspeciales($row['dniclidoc'])."','".substr(limpiarCaracteresEspeciales($row['nombresclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['apeclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['dirclidoc']),0,30)."','".limpiarCaracteresEspeciales($row['telclidoc'])."','".$row['codvendoc']."','".$row['nomvendoc']."','".$row['apevendoc']."','".$mensajero."','".$row['nommendoc']."','".$row['apemendoc']."','".$row['codmeddoc']."','".$row['dnimeddoc']."','".$row['nommeddoc']."','".$observacionx."','".$row['observacion2']."','".$row['itemsdoc']."','".$row['vrbasedoc']."','".$row['vrivadoc']."','".$row['codsucursal']."','".$row['nomsucdoc']."','".$row['credordoc']."','".$row['momentodoc']."','".$row['totaldoc']."','".$row['decodbod']."','".$row['denombod']."','".$row['decantidad']."','".$row['devaluni']."','".$row['devalpar']."','".(0+$row['devalbase'])."','".(0+$row['devaliva'])."','".(0+$row['devaltotal'])."','".$row['deunicom']."','".$row['deunifra']."','".$puntosx."','".$agendo."','".$diaoperativo."','".$row['dddiaope']."','".(0+$row['fpefectivo'])."','".(0+$row['fptarjetas'])."','".(0+$row['fpotros'])."','".$row['codproducto']."','".substr($row['nomproducto'],0,70)."','".$row['codlabo']."','".substr($row['nomlabo'],0,50)."','".$row['fechadoc']."',  ".$row['costoprod'].", ".$row['productoid'].", ".$row['bodegaid'].", ".$row['sucursalid'].", ".$row['docuid'].")";	   
		  
		 // echo"Entro 0 .. ".$i." -  ".$row['numerodoc']."<br>";
		  $i++;
	   }
	   else
	   {
		   
		   if($i<40)
		   {
			   $det .= "
			   ,('".$row['tipodoc']."','".$row['prefijodoc']."','".$row['numerodoc']."','".$row['fechadoc']."','".$row['periododoc']."','".$row['formapagodoc']."','".limpiarCaracteresEspeciales($row['dniclidoc'])."','".substr(limpiarCaracteresEspeciales($row['nombresclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['apeclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['dirclidoc']),0,30)."','".limpiarCaracteresEspeciales($row['telclidoc'])."','".$row['codvendoc']."','".$row['nomvendoc']."','".$row['apevendoc']."','".$mensajero."','".$row['nommendoc']."','".$row['apemendoc']."','".$row['codmeddoc']."','".$row['dnimeddoc']."','".$row['nommeddoc']."','".$observacionx."','".$row['observacion2']."','".$row['itemsdoc']."','".$row['vrbasedoc']."','".$row['vrivadoc']."','".$row['codsucursal']."','".$row['nomsucdoc']."','".$row['credordoc']."','".$row['momentodoc']."','".$row['totaldoc']."','".$row['decodbod']."','".$row['denombod']."','".$row['decantidad']."','".$row['devaluni']."','".$row['devalpar']."','".(0+$row['devalbase'])."','".(0+$row['devaliva'])."','".(0+$row['devaltotal'])."','".$row['deunicom']."','".$row['deunifra']."','".$puntosx."','".$agendo."','".$diaoperativo."','".$row['dddiaope']."','".(0+$row['fpefectivo'])."','".(0+$row['fptarjetas'])."','".(0+$row['fpotros'])."','".$row['codproducto']."','".substr($row['nomproducto'],0,70)."','".$row['codlabo']."','".substr($row['nomlabo'],0,50)."','".$row['fechadoc']."',  ".$row['costoprod'].", ".$row['productoid'].", ".$row['bodegaid'].", ".$row['sucursalid'].", ".$row['docuid'].")";	   
			   
			  //echo"Entro 1-39 .. ".$i." -  ".$row['numerodoc']."<br>";
			   $i++;
		   }
		   else
		   {
			  if($i == 40)
			  {
				  
				  $det .= "
				  ,('".$row['tipodoc']."','".$row['prefijodoc']."','".$row['numerodoc']."','".$row['fechadoc']."','".$row['periododoc']."','".$row['formapagodoc']."','".limpiarCaracteresEspeciales($row['dniclidoc'])."','".substr(limpiarCaracteresEspeciales($row['nombresclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['apeclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['dirclidoc']),0,30)."','".limpiarCaracteresEspeciales($row['telclidoc'])."','".$row['codvendoc']."','".$row['nomvendoc']."','".$row['apevendoc']."','".$mensajero."','".$row['nommendoc']."','".$row['apemendoc']."','".$row['codmeddoc']."','".$row['dnimeddoc']."','".$row['nommeddoc']."','".$observacionx."','".$row['observacion2']."','".$row['itemsdoc']."','".$row['vrbasedoc']."','".$row['vrivadoc']."','".$row['codsucursal']."','".$row['nomsucdoc']."','".$row['credordoc']."','".$row['momentodoc']."','".$row['totaldoc']."','".$row['decodbod']."','".$row['denombod']."','".$row['decantidad']."','".$row['devaluni']."','".$row['devalpar']."','".(0+$row['devalbase'])."','".(0+$row['devaliva'])."','".(0+$row['devaltotal'])."','".$row['deunicom']."','".$row['deunifra']."','".$puntosx."','".$agendo."','".$diaoperativo."','".$row['dddiaope']."','".(0+$row['fpefectivo'])."','".(0+$row['fptarjetas'])."','".(0+$row['fpotros'])."','".$row['codproducto']."','".substr($row['nomproducto'],0,70)."','".$row['codlabo']."','".substr($row['nomlabo'],0,50)."','".$row['fechadoc']."',  ".$row['costoprod'].", ".$row['productoid'].", ".$row['bodegaid'].", ".$row['sucursalid'].", ".$row['docuid'].")";	   
				
				  $cont.= $enc2.$det.";".Chr(13).Chr(10);	 
				  
				  $enc2  = ""; 
				  $det = "";

				 // echo"Entro 40  ..  ".$i." -  ".$row['numerodoc']."<br><br>";
				  $i = 0;
			  } 
			  else
			  {
				  $enc2  = "";
				  $det = "";
				  $i = 0;

				 // echo"Entro Mas de 40   ..  ".$i." -  ".$row['numerodoc']."<br><br>";
			  }
           }
	   }	  

	 }  

	 /// Si en la Ultima vuelta dio menos de 40 registros, los incluyo
	 if($i<=40)
	 {
		$cont.= $enc2.$det.";".Chr(13).Chr(10);
		//echo"Entro por ultimo  ..  ".$i." -  ".$row['numerodoc']."<br><br>";
	 }

	 /// Arreglo para consolidar con toda la informacion
	 $cont.= "UPDATE consolida1 SET DEVALPAR  = DEVALUNI*DECANTIDAD WHERE DEVALPAR = 0 AND PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);
	 $cont.= "UPDATE consolida1 SET DEVALBASE = DEVALTOTAL*DEVALIVA WHERE DEVALBASE = 0 AND PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);
	 $cont.= "UPDATE consolida1 SET DEVALIVA  = DEVALTOTAL-DEVALBASE WHERE PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	 
     $cont.= "UPDATE consolida1 SET VRBASEDOC = TOTALDOC-VRIVADOC WHERE VRBASEDOC = 0 AND VRIVADOC = 0 AND PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	 	 
	 
	 /*
     /////////////////////////////////////////////////////
     ///// Le borro lo del Transporte
     $vsql = "SELECT tipodoc , prefijo , numero FROM documentos WHERE tipodoc = 'TRB' ORDER BY fechadoc DESC LIMIT 0,300";
     $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo,"w");
	 $cont2 = "";	  
	 
	 while($row = @mysql_fetch_array($result))
	 { 
         $cont2.="DELETE FROM kardextransito WHERE tipodoc = 'TRB' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."';".Chr(13).Chr(10);	   
         $cont2.="DELETE FROM kardex WHERE tipodoc = 'TRB' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."' AND bodegaid = 87;".Chr(13).Chr(10);
	     $i++;		  
	 }  
     */

     /////////////////////////////////////////////////////
     ///// Los Especiales los incluyo en el Archivo
     $enc3 = "DELETE FROM consolida2 WHERE PERIODOESPE = '".$periodo."' AND CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	

	 $month   = substr($periodo,0,2);
	 $year    = substr($periodo,3,4);
	 $ultimodia = date('t', mktime(0, 0, 0, $month, 1, $year));

	 $vsql = "SELECT B.* , S.codigo codsuc , S.descripcion nomsuc , P.codigo codpro , P.descripcion nompro , T.codvende , CONCAT(T.nombres,' ',T.apellidos) nomvende 
	           FROM bonificado B INNER JOIN productos P ON (P.productoid = B.productoid) 
	           INNER JOIN sucursales S ON (S.sucursalid = B.sucursalid) 
	           INNER JOIN terceros T ON (T.terid = B.vendedor) 
	           WHERE B.fecha >= '".substr($periodo,2,4)."-".substr($periodo,0,2)."-01' AND B.fecha <= '".substr($periodo,2,4)."-".substr($periodo,0,2)."-".$ultimodia."'";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 $cont3 = "";	  
	 $i=0;  $agendo = "";
	 while($row = @mysql_fetch_array($result))
	 { 
	     $cont3.="INSERT INTO consolida2(PERIODOESPE, FECHAESPE , CODVENDE , NOMVENDE , CODPRODUCTO , NOMPRODUCTO , CANTIVENTA , VALORVENTA , PORCENBONI , VALORCOMI , CODSUCURSAL ,  NOMSUCURSAL , PAGADO ) VALUES ('".$periodo."','".$row['fecha']."','".$row['codvende']."','".$row['nomvende']."','".$row['codpro']."','".$row['nompro']."','".$row['cantidad']."','".$row['valorventa']."','".$row['porcenboni']."','".$row['valorcomi']."','".$row['codsuc']."','".$row['nomsuc']."','".$row['pagado']."');".Chr(13).Chr(10);	   
	     $i++;		  
	 }   

     //// Junto Todas las Variables y Genero el archivo
	 $fp = fopen($archivo,"w");
	 $contenido = $enc.$cont.$cont2.$enc3.$cont3;
	 fwrite($fp,$contenido);
	 fclose($fp);

     $clase->closeConnection();	 
    }	 
	
	//// Genero el Archivo de Especiales Aparte Tambien
	GenerarDATARotacion($periodo);
	GenerarConsolidadoEspeciales($periodo);
	
	if($_SESSION['G_MODOTRABAJO'] == "PUNTODEVENTA")
	  GenerarDATAVentas($periodo);
    
	return;
  }  

  
 ///////////////////////////////////////////////////////////////////////////////////////////////
 ///////////////////////////////////////////////////////////////////////////////////////////////
 function GenerarDATARotacion($periodo)
 {
	ini_set("memory_limit","300M");
	error_reporting(E_ALL);

	$clase = new Sistema();

	/// Busco la Bodegaid
	$bodegaid = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],"bodegas","codbodega","bodegaid");
    $wherex = "";
	if($bodegaid!='') 
	   $wherex = " AND bodegaid = ".$bodegaid;
	 
	/// Ejecuto la Consulta
	$conex  = $clase->Conectar();
	if($bodegaid == "")
	{
		$vsql = "SELECT K.productoid , K.bodegaid , P.precio1m , SUM(K.cantidad*(-1)) canti , 0 existencia FROM kardex K INNER JOIN productos P ON (K.productoid = P.productoid) 
				 WHERE K.periodo = '".$periodo."' AND (K.tipodoc = 'FVE' OR K.tipodoc = 'DVE') GROUP BY 1,2 HAVING K.canti > 0 ORDER BY 3 DESC";
	}
	else
	{
		$vsql = "SELECT K.productoid , K.bodegaid , P.precio1m , SUM(K.cantidad*(-1)) canti ,  
		        (SELECT SUM(cantidad) FROM existencias WHERE productoid = P.productoid AND bodegaid = ".$bodegaid." ) existencia  
		         FROM kardex K INNER JOIN productos P ON (K.productoid = P.productoid) 
				 WHERE K.periodo = '".$periodo."' ".$wherex." AND (K.tipodoc = 'FVE' OR K.tipodoc = 'DVE')  GROUP BY 1,2 HAVING canti > 0  ORDER BY 3 DESC";
	}
	$result = @mysql_query($vsql,$conex);
	//echo $vsql."<br><br>";
	$cont = "";	  $cont2 = "";
	$i=0; $lt = 1;
	while($row = @mysql_fetch_array($result))
	{  	
		//echo $lt."----".$row['productoid']."<br>";
	    if($i == 0)
		{
			$borrar = "DELETE FROM rotacionproducto WHERE bodegaid = ".$row['bodegaid']." AND codperiodo = '".$periodo."';".Chr(13).Chr(10);
			$enc2   = "INSERT IGNORE INTO rotacionproducto(productoid, bodegaid, codperiodo, salidas , existencia , precio) VALUES ";

			$det .= "('".$row['productoid']."','".$row['bodegaid']."','".$periodo."','".$row['canti']."','".$row['existencia']."','".$row['precio1m']."')";	   
			
			//echo"Entro 0 .. ".$i." -  ".$row['productoid']."<br>";
			$i++;
		}
		else
		{
			
			if($i<50)
			{
				$det .= "
				,('".$row['productoid']."','".$row['bodegaid']."','".$periodo."','".$row['canti']."','".$row['existencia']."','".$row['precio1m']."')";	   
		
				
				//echo"Entro 1-39 .. ".$i." -  ".$row['productoid']."<br>";
				$i++;
			}
			else
			{
				if($i == 50)
				{
					
					$det .= "
					,('".$row['productoid']."','".$row['bodegaid']."','".$periodo."','".$row['canti']."','".$row['existencia']."','".$row['precio1m']."')";	   
					
					$cont.= $enc2.$det.";".Chr(13).Chr(10).Chr(13).Chr(10);		 
					
					$enc2  = ""; 
					$det = "";

					//echo"Entro 50  ..  ".$i." -  ".$row['productoid']."<br><br>";
					$i = 0;
				} 
				else
				{
					$enc2  = "";
					$det = "";
					$i = 0;

					//echo"Entro Mas de 50   ..  ".$i." -  ".$row['numerodoc']."<br><br>";
				}
			}
		}	
		
		//$i++;
		$lt++;
    }  

	/// Si en la Ultima vuelta dio menos de 40 registros, los incluyo
	if($i<50)
	{
		$cont.= $enc2.$det.";".Chr(13).Chr(10);
		$cont.= "/* TOTAL LINEAS : ".($lt-1)." */";
		//echo"Entro por ultimo  ..  ".$i." -  ".$det."<br><br>";
	}


	 //// Junto Todas las Variables y Genero el archivo
	 $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/ROTACION-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";
	 if(file_exists($archivo))	     unlink($archivo);
	 $fp = fopen($archivo,"w");
	 $contenido = $borrar.$cont;
	 fwrite($fp,$contenido);
	 fclose($fp);

     $clase->closeConnection();	 
	return;
 }


 
 ///////////////////////////////////////////////////////////////////////////////////////////////
 ///////////////////////////////////////////////////////////////////////////////////////////////
 function GenerarDATAVentasServidor($periodo)
 {
	ini_set("memory_limit","300M");
	error_reporting(E_ALL);

	$clase = new Sistema();

	///////////////////////////////////////////////////
	/// 1. Sincronizo la Tabla estaventasuc
	$diaoperativohoy = date("d/m/Y");
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estaventasuc WHERE periodo = '".$periodo."' AND codsuc IN ('00','DB','DBU','DME') ";
	$result = @mysql_query($vsql,$conex);
	//echo $vsql."<br><br>";
	$cont2 = "";	$codsuc = "";
	$i=0; $lt = 1;
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
		{
			$codsuc = $row['codsuc'];
			$cont2 = "DELETE FROM estaventasuc WHERE codsuc = '".$row['codsuc']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		}
		
		$cont2.= "INSERT INTO estaventasuc(codven,codsuc,periodo,diaoperativo,ventagen,ventaesp,comiespe,ventalic,ventarec,ventacall,ventatienda,ventarappi,
		          ventanoc,ventanoc2,ventasure,devoluciones,domicilios,domicilios2,cliatendidos,clientespuntos,adicional1,adicional2,adicional3,cantotalfacturas,canenviadas,porcenenvio) VALUES";
		$cont2.= "('".$row['codven']."','".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".round($row['ventagen'])."','".round($row['ventaesp'])."','".$row['comiespe']."','".$row['ventalic']."','".$row['ventarec']."',";
		$cont2.= "'".$row['ventacall']."','".$row['ventatienda']."','".$row['ventarappi']."',";
		$cont2.= "'".$row['ventanoc']."','".$row['ventanoc2']."','".$row['ventasure']."','".$row['devoluciones']."','".$row['domicilios']."','".$row['domicilios2']."','".$row['cliatendidos']."','".$row['clientespuntos']."','".$row['adicional1']."','".$row['adicional2']."','".$row['adicional3']."','".$row['cantotalfacturas']."','".$row['canenviadas']."','".$row['porcenenvio']."');".Chr(13).Chr(10);
		$i++;		  
    }  
	
	 //// Ejecuto la Ultima Linea 
	 /// Adaptacion para que no tome la venta con Licores - Rige a Partir de Abril2024 
	 $ordenperiodoactual = $clase->BDLockup($periodo,"periodos","codperiodo","orden");
	 if($ordenperiodoactual<=124)
	    $cont2.= "UPDATE estaventasuc SET ventaneta = (ventagen-(ventarec+devoluciones)) WHERE codsuc = '".$codsuc."' AND periodo = '".$periodo."';".Chr(13).Chr(10); 
     else
	    $cont2.= "UPDATE estaventasuc SET ventaneta = (ventagen-(ventarec+devoluciones+ventalic+ventacall+ventatienda+ventarappi)) WHERE codsuc = '".$codsuc."' AND periodo = '".$periodo."';".Chr(13).Chr(10); 	


	///////////////////////////////////////////////////
	/// 1.1 Sincronizo la Tabla EstaDespaSuc
	$diaoperativohoy = date("d/m/Y");
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estadespasuc WHERE periodo = '".$periodo."' AND codsuc IN ('00','DB','DBU','DME') ";
	$result = @mysql_query($vsql,$conex);
	//echo $vsql."<br><br>";
	$cont2.= "".Chr(13).Chr(10);	$codsuc = "";
	$i=0; $lt = 1;
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
			$cont2.= "DELETE FROM estadespasuc WHERE codsuc = '".$row['codsuc']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		
		$cont2.= "INSERT INTO estadespasuc(coddespa,codsuc,periodo,diaoperativo,tipodespa,cantidespachos,valordespachado) VALUES";
		$cont2.= "('".$row['coddespa']."','".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".$row['tipodespa']."','".round($row['cantidespachos'])."','".round($row['valordespachado'])."');".Chr(13).Chr(10);
		$i++;		  
    }  
	
    ///////////////////////////////////////////////////
	/// 2. Sincronizo la Tabla estadomisuc
	$cont2.= "".Chr(13).Chr(10);
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estadomisuc WHERE periodo = '".$periodo."' AND codsuc IN ('00','DB','DBU','DME')";
	$result = @mysql_query($vsql,$conex);
	$i=0; $lt = 1;
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
		{
			$codsuc = $row['codsuc'];
			$cont2.= "DELETE FROM estadomisuc WHERE codsuc = '".$row['codsuc']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		}
		
		$cont2.= "INSERT INTO estadomisuc(coddomi,codsuc,periodo,diaoperativo,cantidomicilios,valdomicilios) VALUES";
		$cont2.= "('".$row['coddomi']."','".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".round($row['cantidomicilios'])."','".round($row['valdomicilios'])."');".Chr(13).Chr(10);
		$i++;		  
    }  
	$cont2.= "".Chr(13).Chr(10);    

	///////////////////////////////////////////////////
	/// 3. Sincronizo la Tabla estaimpuestosuc
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estaimpuestosuc WHERE periodo = '".$periodo."' AND codsuc IN ('00','DB','DBU','DME')";
	$result = @mysql_query($vsql,$conex);
	$i=0;  
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
		{
			$codsuc = $row['codsuc'];
			$cont2.= "DELETE FROM estaimpuestosuc WHERE codsuc = '".$row['codsuc']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		}
		
		$cont2.= "INSERT INTO estaimpuestosuc(codsuc,periodo,diaoperativo,base00,base05,iva05,total05,base19,iva19,total19,ventatotal,dbase00,dbase05,diva05,dtotal05,dbase19,diva19,dtotal19,devolucionestotal,enviado) VALUES";
		$cont2.= "('".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".$row['base00']."','".$row['base05']."','".$row['iva05']."','".$row['total05']."','".$row['base19']."','";
		$cont2.= $row['iva19']."','".$row['total19']."','".$row['ventatotal']."','".$row['dbase00']."','".$row['dbase05']."','".$row['diva05']."','".$row['dtotal05']."','".$row['dbase19']."','".$row['diva19']."','";
		$cont2.= $row['dtotal19']."','".$row['devolucionestotal']."','".$row['enviado']."');".Chr(13).Chr(10);

		$i++;		  
    }  
	$cont2.= "".Chr(13).Chr(10);

	/////////////////////////////////////////////////////////////////////////////
	//// Selecciono el Numero de Factura Actual en el que va la resolucion
	$version = LeerArchivo("version.txt");  
	$sucursalid   = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");
	$diaoperativo = $clase->BDLockup("G_DIAOPERATIVO","configuraciones","variab","contenido");
	$numactualfve = 0+$clase->SeleccionarUno("SELECT MAX(numero) FROM consecutivos WHERE tipodoc = 'FVE' AND sucursalid = ".$sucursalid);
	$resolucionid = 0+$clase->SeleccionarUno("SELECT resid FROM resolucionesdian WHERE sucursalid = ".$sucursalid." AND numini <= '".$numactualfve."' AND numfin >= '".$numactualfve."' ORDER BY resid DESC limit 0,1");
	$ultcierre = $clase->Seleccionaruno("SELECT momento FROM cierres WHERE tipocierre = 'DEF' ORDER BY cierreid DESC LIMIT 0,1");
	$vsqlActualiza = "UPDATE sucursales SET diaoperativo = '".$diaoperativo."' , ultcierre = '".$ultcierre."' , version = '".$version."' , consecactualfve = '".$numactualfve."' , resolactualfve = '".$resolucionid."' WHERE sucursalid = ".$sucursalid.";";
    $cont2.= $vsqlActualiza.Chr(13).Chr(10);
	$vsqlActualiza = "UPDATE resolucionesdian SET consecactualsuc = '".$numactualfve."' , resolactualsuc = '".$resolucionid."' WHERE sucursalid = ".$sucursalid.";";
    $cont2.= $vsqlActualiza.Chr(13).Chr(10);
	$cont2.= "".Chr(13).Chr(10);
    //// Fin Archivo VENTAS

    ////////////////////////////////////////////////////////////////
	 //// Junto Todas las Variables y Genero el archivo
	 $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/VENTAS-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";
	 if(file_exists($archivo))	     unlink($archivo);
	 $fp = fopen($archivo,"w");
	 $contenido = $cont2;
	 fwrite($fp,$contenido);
	 fclose($fp);
 }


 ///////////////////////////////////////////////////////////////////////////////////////////////
 ///////////////////////////////////////////////////////////////////////////////////////////////
 function GenerarDATAVentas($periodo)
 {
	ini_set("memory_limit","300M");
	error_reporting(E_ALL);

	$clase = new Sistema();

	///////////////////////////////////////////////////
	/// 1. Sincronizo la Tabla estaventasuc
	$diaoperativohoy = date("d/m/Y");
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estaventasuc WHERE periodo = '".$periodo."'";
	$result = @mysql_query($vsql,$conex);
	//echo $vsql."<br><br>";
	$cont2 = "";	$codsuc = "";
	$i=0; $lt = 1;
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
		{
			$codsuc = $row['codsuc'];
			$cont2 = "DELETE FROM estaventasuc WHERE codsuc = '".$row['codsuc']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		}
		
		$cont2.= "INSERT INTO estaventasuc(codven,codsuc,periodo,diaoperativo,ventagen,ventaesp,comiespe,ventalic,ventarec,ventacall,ventatienda,ventarappi,
		          ventanoc,ventanoc2,ventasure,devoluciones,domicilios,domicilios2,cliatendidos,clientespuntos,adicional1,adicional2,adicional3,cantotalfacturas,canenviadas,porcenenvio) VALUES";
		$cont2.= "('".$row['codven']."','".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".round($row['ventagen'])."','".round($row['ventaesp'])."','".$row['comiespe']."','".$row['ventalic']."','".$row['ventarec']."',";
		$cont2.= "'".$row['ventacall']."','".$row['ventatienda']."','".$row['ventarappi']."',";
		$cont2.= "'".$row['ventanoc']."','".$row['ventanoc2']."','".$row['ventasure']."','".$row['devoluciones']."','".$row['domicilios']."','".$row['domicilios2']."','".$row['cliatendidos']."','".$row['clientespuntos']."','".$row['adicional1']."','".$row['adicional2']."','".$row['adicional3']."','".$row['cantotalfacturas']."','".$row['canenviadas']."','".$row['porcenenvio']."');".Chr(13).Chr(10);
		$i++;		  
    }  
	
	 //// Ejecuto la Ultima Linea 
	 /// Adaptacion para que no tome la venta con Licores - Rige a Partir de Abril2024 
	 $ordenperiodoactual = $clase->BDLockup($periodo,"periodos","codperiodo","orden");
	 if($ordenperiodoactual<=124)
	    $cont2.= "UPDATE estaventasuc SET ventaneta = (ventagen-(ventarec+devoluciones)) WHERE codsuc = '".$codsuc."' AND periodo = '".$periodo."';".Chr(13).Chr(10); 
     else
	    $cont2.= "UPDATE estaventasuc SET ventaneta = (ventagen-(ventarec+devoluciones+ventalic+ventacall+ventatienda+ventarappi)) WHERE codsuc = '".$codsuc."' AND periodo = '".$periodo."';".Chr(13).Chr(10); 	


	///////////////////////////////////////////////////
	/// 1.1 Sincronizo la Tabla EstaDespaSuc
	$diaoperativohoy = date("d/m/Y");
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estadespasuc WHERE periodo = '".$periodo."'";
	$result = @mysql_query($vsql,$conex);
	//echo $vsql."<br><br>";
	$cont2.= "".Chr(13).Chr(10);	$codsuc = "";
	$i=0; $lt = 1;
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
			$cont2.= "DELETE FROM estadespasuc WHERE codsuc = '".$row['codsuc']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		
		$cont2.= "INSERT INTO estadespasuc(coddespa,codsuc,periodo,diaoperativo,tipodespa,cantidespachos,valordespachado) VALUES";
		$cont2.= "('".$row['coddespa']."','".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".$row['tipodespa']."','".round($row['cantidespachos'])."','".round($row['valordespachado'])."');".Chr(13).Chr(10);
		$i++;		  
    }  
	
    ///////////////////////////////////////////////////
	/// 2. Sincronizo la Tabla estadomisuc
	$cont2.= "".Chr(13).Chr(10);
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estadomisuc WHERE periodo = '".$periodo."'";
	$result = @mysql_query($vsql,$conex);
	$i=0; $lt = 1;
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
		{
			$codsuc = $row['codsuc'];
			$cont2.= "DELETE FROM estadomisuc WHERE codsuc = '".$row['codsuc']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		}
		
		$cont2.= "INSERT INTO estadomisuc(coddomi,codsuc,periodo,diaoperativo,cantidomicilios,valdomicilios) VALUES";
		$cont2.= "('".$row['coddomi']."','".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".round($row['cantidomicilios'])."','".round($row['valdomicilios'])."');".Chr(13).Chr(10);
		$i++;		  
    }  
	$cont2.= "".Chr(13).Chr(10);    

	///////////////////////////////////////////////////
	/// 3. Sincronizo la Tabla estarappisuc    
	$cont2.= "".Chr(13).Chr(10);
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estarappisuc WHERE periodo = '".$periodo."'";
	$result = @mysql_query($vsql,$conex);
	$i=0; $lt = 1;
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
		{
			$codsuc = $row['codsuc'];
			$cont2.= "DELETE FROM estarappisuc WHERE codsucursal = '".$row['codsucursal']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		}
		
		$cont2.= "INSERT INTO estarappisuc(periodo,docuid,numfactura,fechadoc,orderid,codbarra,codsucursal,total) VALUES";
		$cont2.= "('".$row['periodo']."','".$row['docuid']."','".$row['numfactura']."','".$row['fechadoc']."','".$row['orderid']."','".$row['codbarra']."','".$row['codsucursal']."','".$row['total']."');".Chr(13).Chr(10);
		$i++;		  
    }  
	$cont2.= "".Chr(13).Chr(10);    

	///////////////////////////////////////////////////
	/// 3. Sincronizo la Tabla estaimpuestosuc
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estaimpuestosuc WHERE periodo = '".$periodo."'";
	$result = @mysql_query($vsql,$conex);
	$i=0;  
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
		{
			$codsuc = $row['codsuc'];
			$cont2.= "DELETE FROM estaimpuestosuc WHERE codsuc = '".$row['codsuc']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		}
		
		$cont2.= "INSERT INTO estaimpuestosuc(codsuc,periodo,diaoperativo,base00,base05,iva05,total05,base19,iva19,total19,ventatotal,dbase00,dbase05,diva05,dtotal05,dbase19,diva19,dtotal19,devolucionestotal,enviado) VALUES";
		$cont2.= "('".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".$row['base00']."','".$row['base05']."','".$row['iva05']."','".$row['total05']."','".$row['base19']."','";
		$cont2.= $row['iva19']."','".$row['total19']."','".$row['ventatotal']."','".$row['dbase00']."','".$row['dbase05']."','".$row['diva05']."','".$row['dtotal05']."','".$row['dbase19']."','".$row['diva19']."','";
		$cont2.= $row['dtotal19']."','".$row['devolucionestotal']."','".$row['enviado']."');".Chr(13).Chr(10);

		$i++;		  
    }  
	$cont2.= "".Chr(13).Chr(10);

	///////////////////////////////////////////////////
	/// 4. Sincronizo la Tabla estacreditos
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estacreditos WHERE periodo = '".$periodo."'";
	$result = @mysql_query($vsql,$conex);
	$i=0;  
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
		{
			$codsuc = $row['codsuc'];
			$cont2.= "DELETE FROM estacreditos WHERE codsuc = '".$row['codsuc']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		}
		
		$cont2.= "INSERT INTO estacreditos(codsuc,periodo,diaoperativo,numfactura,codempleado,dnicliente,nomcliente,base00,base05,base19,iva05,iva19,total,codautorizo) VALUES";
		$cont2.= "('".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".$row['numfactura']."','".$row['codempleado']."','".$row['dnicliente']."','".$row['nomcliente']."','".$row['base00']."','".$row['base05']."','";
		$cont2.= $row['base19']."','".$row['iva05']."','".$row['iva19']."','".$row['total']."','".$row['codautorizo']."');".Chr(13).Chr(10);

		$i++;		  
    }  
	$cont2.= "".Chr(13).Chr(10);


	/////////////////////////////////////////////////////////////////////////////
	//// Selecciono el Numero de Factura Actual en el que va la resolucion
	$version = LeerArchivo("version.txt");  
	$sucursalid   = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");
	$diaoperativo = $clase->BDLockup("G_DIAOPERATIVO","configuraciones","variab","contenido");
	$numactualfve = 0+$clase->SeleccionarUno("SELECT MAX(numero) FROM consecutivos WHERE tipodoc = 'FVE' AND sucursalid = ".$sucursalid);
	$resolucionid = 0+$clase->SeleccionarUno("SELECT resid FROM resolucionesdian WHERE sucursalid = ".$sucursalid." AND numini <= '".$numactualfve."' AND numfin >= '".$numactualfve."' ORDER BY resid DESC limit 0,1");
	$ultcierre = $clase->Seleccionaruno("SELECT momento FROM cierres WHERE tipocierre = 'DEF' ORDER BY cierreid DESC LIMIT 0,1");
	$vsqlActualiza = "UPDATE sucursales SET diaoperativo = '".$diaoperativo."' , ultcierre = '".$ultcierre."' , version = '".$version."' , consecactualfve = '".$numactualfve."' , resolactualfve = '".$resolucionid."' WHERE sucursalid = ".$sucursalid.";";
    $cont2.= $vsqlActualiza.Chr(13).Chr(10);
	$vsqlActualiza = "UPDATE resolucionesdian SET consecactualsuc = '".$numactualfve."' , resolactualsuc = '".$resolucionid."' WHERE sucursalid = ".$sucursalid.";";
    $cont2.= $vsqlActualiza.Chr(13).Chr(10);
	$cont2.= "".Chr(13).Chr(10);
    //// Fin Archivo VENTAS

	////////////////////////////////////////////////////////
	//// INICIA VENTAS2 
	//// 4. Campañas	
    $conex  = $clase->Conectar();
	$criterio = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);
	$cont = "";

	$vsql = "SELECT DV.diaoperativo , T.codvende , T.nombres , T.apellidos , COUNT(*) cliatendidos , SUM(IF(DV.puntosacumulados>0,1,0)) clipuntos , 
	         SUM(IF(DV.puntosacumulados>1 AND DV.convenioid IS NOT NULL,1,0)) clicampa , 
	         SUM(IF(DV.puntosacumulados<=0 AND DV.convenioid IS NOT NULL,1,0)) facturaserror  
	         FROM documentos D 
			 INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			 INNER JOIN terceros T ON (T.terid = D.terid2)
			 WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fechadoc BETWEEN '2023-06-15' AND '2023-07-31' 
			 GROUP BY 1,2,3,4
			 ORDER BY DV.diaoperativo DESC , 5 DESC";

	 $result = @mysql_query($vsql,$conex);
	 $i=0;    $codsuc = $_SESSION['G_SUCURSALPOS'];
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i == 0)
		   $cont.= "DELETE FROM estacampasuc WHERE codsuc = '".$codsuc."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		
	    $cont.="INSERT INTO estacampasuc(codsuc,diaoperativo,periodo,codvende,cliatendidos,clicampa,clipuntos,facturaserror) ";
		$cont.="VALUES('".$_SESSION['G_SUCURSALPOS']."','".$row['diaoperativo']."','".$periodo."','".$row['codvende']."','".$row['cliatendidos']."','".$row['clicampa']."','".$row['clipuntos']."','".$row['facturaserror']."');".Chr(13).Chr(10);

		$i++;				
	 } // Fin While

	///////////////////////////////////////////////////
	/// 5. Sincronizo la Tabla estadomisuc
	$cont.= "".Chr(13).Chr(10);
	$conex  = $clase->Conectar();
	$vsql = "SELECT * FROM estacategoriasuc WHERE periodo = '".$periodo."'";
	$result = @mysql_query($vsql,$conex);
	$i=0; $lt = 1;
	while($row = @mysql_fetch_array($result))
	{  	
	    if($i == 0)
		{
			$codsuc = $row['codsuc'];
			$cont.= "DELETE FROM estacategoriasuc WHERE codsuc = '".$row['codsuc']."' AND periodo = '".$periodo."';".Chr(13).Chr(10);
		}

		$cont.= "INSERT INTO estacategoriasuc(categoriaid,codsuc,periodo,diaoperativo,cantivendida,valorvendido) VALUES";
		$cont.= "('".$row['categoriaid']."','".$row['codsuc']."','".$periodo."','".$row['diaoperativo']."','".round($row['cantivendida'])."','".round($row['valorvendido'])."');".Chr(13).Chr(10);
		$i++;		  
    }  

	////////////////////////////////////////////////////////
	//// 6. Recargas del Periodo hacia consolida3
	$cont.= "".Chr(13).Chr(10);
    $conex  = $clase->Conectar();
	$criterio = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);

    $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , DV.diaoperativo , T.codoperador , T.numrecarga , T.valor , T.codvende , T.pinrecargas 
	         FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	         INNER JOIN transarecargas T ON (T.idfactura = D.docuid)
			 WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."' GROUP BY 1,2";  

	 $result = @mysql_query($vsql,$conex);
	 $i=0; $nomsuc  = "FARMANORTE ".$codsuc;
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i == 0)
		   $cont.= "DELETE FROM consolida3 WHERE CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."' AND DIAOPERATIVO LIKE '%/".substr($periodo,0,2)."/".substr($periodo,2,4)."';".Chr(13).Chr(10);
		
	    $cont.="INSERT INTO consolida3(CODSUCURSAL,NOMSUCURSAL,TIPODOC,PREFIJODOC,NUMERODOC,FECHADOC,DIAOPERATIVO,CODOPERADOR,NUMRECARGA,VALOR,CODVENDE,PINRECARGAS,TOTALDOC) ";
		$cont.="VALUES('".$codsuc."','".$nomsuc."','".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['fechadoc']."','".$row['diaoperativo']."','".$row['codoperador']."',";
    	$cont.="'".$row['numrecarga']."','".$row['valor']."','".$row['codvende']."','".$row['pinrecargas']."','".$row['valor']."');".Chr(13).Chr(10);

		$i++;				
	 } // Fin While


	////////////////////////////////////////////////////////
	//// 7. Agua Farmanorte
	$cont.= "".Chr(13).Chr(10);
    $conex  = $clase->Conectar();
	$criterio = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);

    $vsql = "SELECT T.codvende , S.codigo codsuc , D.periodo , DV.diaoperativo , DD.productoid , SUM(DD.cantidad) cantiventa , SUM(DD.valtotal) valorventa 
	         FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
	         INNER JOIN terceros T ON (T.terid = D.terid2) 
			 INNER JOIN sucursales S ON (S.sucursalid = D.sucursalid) 
			 INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			 WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND T.codvende <> '' AND (DD.productoid = 48019 OR DD.productoid = 60214) 
			 AND T.codvende IS NOT NULL AND DV.diaoperativo LIKE '".$criterio."' 
			 GROUP BY 1,2,3,4,5 ORDER BY 2 ASC , 4 ASC , 1 ASC";  

	 $result = @mysql_query($vsql,$conex);
	 $i=0; $nomsuc  = "FARMANORTE ".$codsuc;
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i == 0)
		   $cont.= "DELETE FROM seguiprodsuc WHERE codsuc = '".$_SESSION['G_SUCURSALPOS']."' AND diaoperativo LIKE '%/".substr($periodo,0,2)."/".substr($periodo,2,4)."';".Chr(13).Chr(10);
		
	    $cont.="INSERT INTO seguiprodsuc(codven,codsuc,periodo,diaoperativo,cantiventa,valorventa,productoid) ";
		$cont.="VALUES('".$row['codvende']."','".$row['codsuc']."','".$row['periodo']."','".$row['diaoperativo']."','".$row['cantiventa']."','".$row['valorventa']."','".$row['productoid']."');".Chr(13).Chr(10);

		$i++;				
	 } // Fin While

    ////////////////////////////////////////////////////////
	//// 8. Formulas Medicas y Venta Empleados
	$cont.= "".Chr(13).Chr(10);
    $conex  = $clase->Conectar();
	$criterio = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);

    $vsql = "SELECT DV.diaoperativo , SUM(IF(DV.medicoid>0,1,0)) canventamedicos , SUM(IF(DV.medicoid>0,D.total,0)) totalventamedicos , SU	M(IF(T.codvende <> '',1,0)) canventaempleados , SUM(IF(T.codvende <> '',D.total,0)) totalventaempleados , COUNT(*) cantiventatotal , SUM(total) valorventatotal 
	         FROM documentos D INNER JOIN docuventa DV ON (D.docuid  = DV.docuid) INNER JOIN terceros T ON (D.terid1 = T.terid) 
			 WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo LIKE '".$criterio."'
			 GROUP BY 1 ORDER BY 1 ASC";  
	 $result = @mysql_query($vsql,$conex);
	 $i=0; 
	 while($row = @mysql_fetch_array($result))
	 { 
		if($i == 0)
		   $cont.= "DELETE FROM seguiprodsuc2 WHERE codsuc = '".$_SESSION['G_SUCURSALPOS']."' AND diaoperativo LIKE '%/".substr($periodo,0,2)."/".substr($periodo,2,4)."';".Chr(13).Chr(10);
		
	    $cont.="INSERT INTO seguiprodsuc2(codsuc,periodo,diaoperativo,canventamedicos,totalventamedicos,canventaempleados,totalventaempleados,cantiventatotal,valorventatotal) ";
		$cont.="VALUES('".$_SESSION['G_SUCURSALPOS']."','".$periodo."','".$row['diaoperativo']."','".$row['canventamedicos']."','".$row['totalventamedicos']."','".$row['canventaempleados']."','".$row['totalventaempleados']."','".$row['cantiventatotal']."','".$row['valorventatotal']."');".Chr(13).Chr(10);

		$i++;				
	 } // Fin While
		 
	 
    ////////////////////////////////////////////////////////
	//// 8. Data de ABBOTT
	$cont.= "".Chr(13).Chr(10);
    $conex  = $clase->Conectar();
	$criterio = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);

    //// Traigo el Consolidado de ABBOTT
	$cont.= "DELETE FROM consolida5 WHERE PERIODO = '".$periodo."' AND CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	

	$clase = new Sistema();
	$vsql= "SELECT DD. * , T.dni, T.nombres, T.apellidos, P.descripcion nomproducto , P.codigo , D.tipodoc, D.prefijo, D.numero, D.fechadoc, 
			S.descripcion nomsucursal, S.codigo codsucursal , D.creador , D.momento , DV.diaoperativo , D.observacion , D.observacion2 , T2.codvende
			FROM documentos D 
			INNER JOIN docuventa DV ON (DV.docuid = D.docuid)
			INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid ) 
			INNER JOIN terceros T ON ( T.terid = D.terid1 ) 
			INNER JOIN terceros T2 ON ( T2.terid = D.terid2 ) 
			INNER JOIN sucursales S ON ( S.sucursalid = D.sucursalid ) 
			INNER JOIN productos P ON ( DD.productoid = P.productoid ) 
			WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND periodo = '".$periodo."' AND D.observacion LIKE '%|%'";
	$conex  = $clase->Conectar();
	$result = @mysql_query($vsql,$conex);
	$fp = fopen($archivo,"w");
	$i=0;  $agendo = "";
	while($row = @mysql_fetch_array($result))
	{ 
		 $cont.= "INSERT INTO consolida5(CODSUCURSAL,NOMSUCURSAL,DIAOPERATIVO,TOKEN,DNIPACIENTE,NOMPACIENTE,APEPACIENTE,NOMPRODUCTO,CODPRODUCTO,NUMFACTURA,CANTIDAD,VALOR,PERIODO,
		          OBSERVACION1,OBSERVACION2,CREADOR,MOMENTO,CODVENDE) ". 
				 "VALUES ('".$row['codsucursal']."','".$row['nomsucursal']."','".$row['diaoperativo']."','".$row['observalinea']."','".$row['dni'].
				 "','".$row['nombres']."','".$row['apellidos']."','".$row['nomproducto']."','".$row['codigo']."','".$row['tipodoc'].$row['prefijo'].$row['numero'].
				 "','".$row['cantidad']."','".$row['valunitario']."','".$periodo."','".$row['observacion']."','".$row['observacion2']."','".$row['creador']."','".$row['momento']."','".$row['codvende']."');".Chr(13).Chr(10);	   
		 $i++;		  
	}  

	////////////////////////////////////////////////////////
	//// 9. Data de Toques Nocturnos
	$cont.= "".Chr(13).Chr(10);
    $conex  = $clase->Conectar();
	$criterio = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);

    //// Primero Elimino
	$cont.= "DELETE FROM consolida4 WHERE CODSUCURSAL = '".$codsuc."' AND DIAOPERATIVO LIKE '".$criterio."';".Chr(13).Chr(10);	

	$clase = new Sistema();
	$vsql= "SELECT * FROM regpervende WHERE diaoperativo LIKE '".$criterio."'";
	$conex  = $clase->Conectar();
	$result = @mysql_query($vsql,$conex);
	$fp = fopen($archivo,"w");
	$i=0;  $agendo = "";
	while($row = @mysql_fetch_array($result))
	{ 
		 $cont.= "INSERT INTO consolida4(CODSUCURSAL,DIAOPERATIVO,CODVENDE,NOMVENDE,MOMENTO) VALUES('".$row['codsucursal']."','".$row['diaoperativo']."','".$row['codvende']."','".$row['nomvende']."','".$row['momento']."');".Chr(13).Chr(10);	   
		 $i++;		  
	}  

	////////////////////////////////////////////////////////
	//// 10. Data de Campañas
	$cont.= "".Chr(13).Chr(10);
    $conex  = $clase->Conectar();
	$criterio = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);

    //// Elimino
	$cont.= "DELETE FROM consolida6 WHERE CODSUCURSAL = '".$codsuc."' AND DIAOPERATIVO LIKE '".$criterio."';".Chr(13).Chr(10);	

	$clase = new Sistema();
	$vsql= "SELECT DV.diaoperativo , T.codvende , T.nombres , T.apellidos , COUNT(*) totalclientesaten , SUM(IF(D.total<50000,1,0)) clientesbajo50 , 
			SUM(IF(D.total>=50000,1,0)) clientessobre50 , SUM(IF(DV.puntosacumulados>0,1,0)) ClientePuntos , 
			SUM(IF(DV.puntosacumulados>0 AND D.total>=50000,1,0)) facturasparticipan , 
            SUM(IF(DV.puntosacumulados<=0 AND D.total>=50000,1,0)) facturaserror , 
			SUM(IF(D.total>=45000 AND D.total<=49999,1,0)) clientes4550 
		    FROM documentos D 
			INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			INNER JOIN terceros T ON (T.terid = D.terid2)
			WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fechadoc BETWEEN '2024-05-01' AND '2024-05-31' 
			GROUP BY 1,2,3,4
			ORDER BY SUBSTRING(DV.DIAOPERATIVO,4,2) DESC , SUBSTRING(DV.DIAOPERATIVO,1,2) DESC , 5 DESC";
	$conex  = $clase->Conectar();
	$result = @mysql_query($vsql,$conex);
	$fp = fopen($archivo,"w");
	$i=0;  $agendo = "";
	while($row = @mysql_fetch_array($result))
	{ 
		 $nomvendex = substr($row['nombres']." ".$row['apellidos'],0,30);

		 $cont.= "INSERT INTO consolida6(CODSUCURSAL,DIAOPERATIVO,CODVENDE,NOMVENDE,CLIATENDIDOS,CLIBAJOTOPE,CLISOBRETOPE,CLIPUNTOS,FACTPARTICIPAN,FACTERROR,CLILIMITE) ". 
				 "VALUES ('".$codsuc."','".$row['diaoperativo']."','".$row['codvende']."','".$nomvendex."','".$row['totalclientesaten']."','".$row['clientesbajo50'].
				 "','".$row['clientessobre50']."','".$row['ClientePuntos']."','".$row['facturasparticipan']."','".$row['facturaserror']."','".$row['clientes4550']."');".Chr(13).Chr(10);	   
		 $i++;		  
	}  
	
    	
     ////////////////////////////////////////////////////////////////
     //// Datos de Actualizacion 
	 $version = LeerArchivo("version.txt");  
     $diaactual = $clase->BDLockup("G_DIAOPERATIVO","configuraciones","variab","contenido");
	 $ultcierre = $clase->SeleccionarUno("SELECT momento FROM cierres WHERE tipocierre = 'DEF' ORDER BY cierreid DESC LIMIT 0,1");
	 $ciudad = $clase->SeleccionarUno("SELECT C.nombre FROM ciudades C INNER JOIN sucursales S ON (C.ciudadid = S.ciudadid) WHERE S.codigo = '".$_SESSION['G_SUCURSALPOS']."'");

	 $vsqlActualiza = "UPDATE sucursales SET version = '".$version."' , diaoperativo = '".$diaactual."' , ultcierre = '".$ultcierre."' , 
	                   nomciudad = '".$ciudad."' , activa = 'CHECKED' , utlrecepauto = CURRENT_TIMESTAMP 
					   WHERE codigo = '".$_SESSION['G_SUCURSALPOS']."';";
     $cont.= $vsqlActualiza.Chr(13).Chr(10);	
	 
	 /////////////////////////////////////////////////////////////////////////////
	 //// Selecciono el Numero de Factura Actual en el que va la resolucion
	 $sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");
	 $numactualfve = 0+$clase->SeleccionarUno("SELECT MAX(numero) FROM consecutivos WHERE tipodoc = 'FVE' AND sucursalid = ".$sucursalid);
	 $resolucionid = 0+$clase->SeleccionarUno("SELECT resid FROM resolucionesdian WHERE sucursalid = ".$sucursalid." AND numini <= '".$numactualfve."' AND numfin >= '".$numactualfve."' ORDER BY resid DESC limit 0,1");
	 $vsqlActualiza = "UPDATE sucursales SET consecactualfve = '".$numactualfve."' , resolactualfve = '".$resolucionid."' WHERE sucursalid = ".$sucursalid.";";
     $cont.= $vsqlActualiza.Chr(13).Chr(10);
	 $vsqlActualiza = "UPDATE resolucionesdian SET consecactualsuc = '".$numactualfve."' , resolactualsuc = '".$resolucionid."' WHERE sucursalid = ".$sucursalid.";";
     $cont.= $vsqlActualiza.Chr(13).Chr(10);

     ////////////////////////////////////////////////////////////////
	 //// Junto Todas las Variables y Genero el archivo
	 $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/VENTAS-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";
	 if(file_exists($archivo))	     unlink($archivo);
	 $fp = fopen($archivo,"w");
	 $contenido = $cont2;
	 fwrite($fp,$contenido);
	 fclose($fp);

     ////////////////////////////////////////////////////////////////
	 //// Junto Todas las Variables y Genero el archivo
	 $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/VENTAS2-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";
	 if(file_exists($archivo))	     unlink($archivo);
	 $fp = fopen($archivo,"w");
	 $contenido = $cont;
	 fwrite($fp,$contenido);
	 fclose($fp);

     $clase->closeConnection();	 
	 return;
 }


 /////////////////////////////////////////////////////////////////////////////////////////////////
 /////////////////////////////////////////////////////////////////////////////////////////////////
 function GenerarConsolidado($periodo)
 {
	$enc = ""; $cont= "";

	if($periodo != "")
	{
	 ini_set("memory_limit","300M");
	 error_reporting(E_ALL);
     
	 $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/CONSOLIDA-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";
	 if(file_exists($archivo))	     unlink($archivo);

	 ///// Encabezado del Archivo
     if($_SESSION['G_SUCURSALPOS'] == "00")  $bodega = 50;
     else                                    $bodega = $_SESSION['G_SUCURSALPOS'];
	 
     //// Armo la variable Periodo2 que hace lo siguiente -> Si Periodo = 012020 Entonces Periodo2 = /01/2020
	 $periodo2 = "%/".substr($periodo,0,2)."/".substr($periodo,2,4);
	 
	 $enc = "SET NAMES LATIN1;".Chr(13).Chr(10);	
	 if(($_SESSION['G_SUCURSALPOS'] == "00")||($_SESSION['G_SUCURSALPOS'] == "DB")||($_SESSION['G_SUCURSALPOS'] == "DBU"))
	    $enc.= "DELETE FROM consolida1 WHERE (CODSUCURSAL = '00' OR CODSUCURSAL = 'DB' OR CODSUCURSAL = 'DBU') AND (DVDIAOPE LIKE '".$periodo2."' OR DDDIAOPE LIKE '".$periodo2."');".Chr(13).Chr(10);	
	 else
	    $enc.= "DELETE FROM consolida1 WHERE CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."' AND (DVDIAOPE LIKE '".$periodo2."' OR DDDIAOPE LIKE '".$periodo2."');".Chr(13).Chr(10);	  

	 $clase = new Sistema();

	 //// Le pongo el dia Operativo a las Cotizaciones
	 $vsql = "";
	 
     /// Saco el Infoe
	 $vsql  = "select distinct doc.tipodoc as tipodoc,doc.prefijo as prefijodoc,doc.numero as numerodoc ,doc.fechadoc as fechadoc,doc.periodo as periododoc,doc.formapago as formapagodoc,
			   cli.dni as dniclidoc,cli.nombres as nombresclidoc,cli.apellidos as apeclidoc ,cli.direccion as dirclidoc,concat(cli.telfijo,_utf8' ',cli.telmovil) as telclidoc,
			   ven.codvende as codvendoc,ven.nombres as nomvendoc,ven.apellidos as apevendoc ,men.codvende as codmendoc , men.coddomi as codmendoc2,men.nombres as nommendoc,
			   men.apellidos as apemendoc,med.codmedico as codmeddoc,med.dni as dnimeddoc,med.nommedico as nommeddoc ,doc.observacion as observadoc,doc.totalitems as itemsdoc,
			   doc.base as vrbasedoc,doc.iva as vrivadoc,suc.codigo as codsucursal,suc.descripcion as nomsucdoc ,doc.creador as credordoc,doc.momento as momentodoc, dvt.procedencia as procedencia , 
			   doc.total as totaldoc,bod.codbodega as decodbod,bod.nombodega as denombod,dvt.diaoperativo as dvdiaope,ddv.diaoperativo as dddiaope,dvt.valorfp1 as fpefectivo,
			   (dvt.valorfp2+dvt.valorfp3) as fptarjetas,dvt.valorfp4 as fpotros,dd.diasrecor , pro.codigo as codproducto,pro.descripcion as nomproducto,lab.codigo as codlabo,
			   lab.descripcion as nomlabo, dd.valunitario as devaluni , dvt.puntosacumulados depuntos, dd.porciva , doc.observacion2 , 
			   sum(dd.cantidad) as decantidad , sum(dd.valparcial) as devalpar , sum(dd.valbase) as devalbase , 
			   sum(dd.valiva) as devaliva , sum(dd.valtotal) as devaltotal , sum(dd.unicom) as deunicom , sum(dd.unifra) as deunifra , pro.ultcosto as costoprod , pro.productoid , bod.bodegaid , bod.sucursalid 
		       from (((((((((((documentos doc join sucursales suc on((doc.sucursalid = suc.sucursalid))) join terceros cli on((cli.terid = doc.terid1))) 
		       left join terceros ven on((ven.terid = doc.terid2))) join terceros men on((men.terid = doc.terid3))) 
               left join dedocumentos dd on((doc.docuid = dd.docuid))) join bodegas bod on((bod.bodegaid = dd.bodegaid))) 
               left join productos pro on((pro.productoid = dd.productoid))) join gruposprod lab on((lab.gruposprodid = pro.gruposprodid))) 
               left join docuventa dvt on((doc.docuid = dvt.docuid))) left join medicos med on((med.medicoid = dvt.medicoid))) 
			   left join docudevolucion ddv on((doc.docuid = ddv.docuid))) 
			   where (doc.tipodoc = 'FVE' OR doc.tipodoc = 'DVE') AND (((dvt.diaoperativo LIKE _utf8'".$periodo2."')Or(ddv.diaoperativo LIKE _utf8'".$periodo2."'))  
			   and (doc.fecasentado <> _utf8'0000-00-00') and ((doc.tipodoc = _utf8'fve') or (doc.tipodoc = _utf8'dve') or (doc.tipodoc = _utf8'cot') or (doc.tipodoc = _utf8'fec')))
               group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45 order by fechadoc asc";

     $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 
	 $cont = "";	  
	 $i=0;  $agendo = "";
	 while($row = @mysql_fetch_array($result))
	 {  
		$SUCURSALIDX = $row['sucursalid'];

	   if($row['codmendoc'] == "")  
	      $mensajero = $row['codmendoc2'];
	   else
	      $mensajero = $row['codmendoc'];
	   
	   if($row['dvdiaope'] == "")
	      $diaoperativo = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);    
	   else
	      $diaoperativo = $row['dvdiaope'];

       $puntosx = 0;                  $puntosx = 0+$row['depuntos'];
	   if($row['diasrecor'] > 0) 	  $agendo = substr($row['diasrecor'],0,3);        else     	  $agendo = "";
	
	   $observacionx = $row['observadoc'];
	   if(strlen($row['procedencia'])>0)
	      $observacionx = $row['procedencia'];

		  
	   	 
	   if($i == 0)
	   {
		  $enc2  = "INSERT INTO consolida1(TIPODOC, PREFIJODOC, NUMERODOC, FECHADOC, PERIODODOC, FORMAPAGODOC, DNICLIDOC, NOMBRESCLIDOC, APECLIDOC, DIRCLIDOC, TELCLIDOC, CODVENDOC, NOMVENDOC, APEVENDOC, CODMENDOC, NOMMENDOC, APEMENDOC, CODMEDDOC, DNIMEDDOC, NOMMEDDOC, OBSERVADOC, OBSERVACION2, ITEMSDOC, VRBASEDOC, VRIVADOC, CODSUCURSAL, NOMSUCDOC, CREDORDOC, MOMENTODOC, TOTALDOC, DECODBOD, DENOMBOD, DECANTIDAD, DEVALUNI, DEVALPAR, DEVALBASE, DEVALIVA, DEVALTOTAL, DEUNICOM, DEUNIFRA, DEPUNTOS , AGENDO , DVDIAOPE, DDDIAOPE, FPEFECTIVO , FPTARJETAS , FPOTROS , CODPRODUCTO, NOMPRODUCTO, CODLABO, NOMLABO, MOMINSERTADO , COSTOPROD, PRODUCTOID, BODEGAID, SUCURSALID) VALUES ";
		  $det .= "('".$row['tipodoc']."','".$row['prefijodoc']."','".$row['numerodoc']."','".$row['fechadoc']."','".$row['periododoc']."','".$row['formapagodoc']."','".limpiarCaracteresEspeciales($row['dniclidoc'])."','".substr(limpiarCaracteresEspeciales($row['nombresclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['apeclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['dirclidoc']),0,30)."','".limpiarCaracteresEspeciales($row['telclidoc'])."','".$row['codvendoc']."','".$row['nomvendoc']."','".$row['apevendoc']."','".$mensajero."','".$row['nommendoc']."','".$row['apemendoc']."','".$row['codmeddoc']."','".$row['dnimeddoc']."','".$row['nommeddoc']."','".$observacionx."','".$row['observacion2']."','".$row['itemsdoc']."','".$row['vrbasedoc']."','".$row['vrivadoc']."','".$row['codsucursal']."','".$row['nomsucdoc']."','".$row['credordoc']."','".$row['momentodoc']."','".$row['totaldoc']."','".$row['decodbod']."','".$row['denombod']."','".$row['decantidad']."','".$row['devaluni']."','".$row['devalpar']."','".(0+$row['devalbase'])."','".(0+$row['devaliva'])."','".(0+$row['devaltotal'])."','".$row['deunicom']."','".$row['deunifra']."','".$puntosx."','".$agendo."','".$diaoperativo."','".$row['dddiaope']."',".(0+$row['fpefectivo']).",".(0+$row['fptarjetas']).",".(0+$row['fpotros']).",'".$row['codproducto']."','".substr($row['nomproducto'],0,70)."','".$row['codlabo']."','".substr($row['nomlabo'],0,50)."','".$row['fechadoc']."',  ".$row['costoprod'].", ".$row['productoid'].", ".$row['bodegaid'].", ".$row['sucursalid'].")";	   
		  $i++;
	   }
	   else
	   {
		   echo $i."----".$row['numerodoc'];
		   if($i<40)
		   {
			   $det .= ",('".$row['tipodoc']."','".$row['prefijodoc']."','".$row['numerodoc']."','".$row['fechadoc']."','".$row['periododoc']."','".$row['formapagodoc']."','".limpiarCaracteresEspeciales($row['dniclidoc'])."','".substr(limpiarCaracteresEspeciales($row['nombresclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['apeclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($row['dirclidoc']),0,30)."','".limpiarCaracteresEspeciales($row['telclidoc'])."','".$row['codvendoc']."','".$row['nomvendoc']."','".$row['apevendoc']."','".$mensajero."','".$row['nommendoc']."','".$row['apemendoc']."','".$row['codmeddoc']."','".$row['dnimeddoc']."','".$row['nommeddoc']."','".$observacionx."','".$row['observacion2']."','".$row['itemsdoc']."','".$row['vrbasedoc']."','".$row['vrivadoc']."','".$row['codsucursal']."','".$row['nomsucdoc']."','".$row['credordoc']."','".$row['momentodoc']."','".$row['totaldoc']."','".$row['decodbod']."','".$row['denombod']."','".$row['decantidad']."','".$row['devaluni']."','".$row['devalpar']."','".(0+$row['devalbase'])."','".(0+$row['devaliva'])."','".(0+$row['devaltotal'])."','".$row['deunicom']."','".$row['deunifra']."','".$puntosx."','".$agendo."','".$diaoperativo."','".$row['dddiaope']."',".(0+$row['fpefectivo']).",".(0+$row['fptarjetas']).",".(0+$row['fpotros']).",'".$row['codproducto']."','".substr($row['nomproducto'],0,70)."','".$row['codlabo']."','".substr($row['nomlabo'],0,50)."','".$row['fechadoc']."',  ".$row['costoprod'].", ".$row['productoid'].", ".$row['bodegaid'].", ".$row['sucursalid'].")";	   
			   $i++;
		   }
		   else
		   {
			  if($i == 40)
			  {
                  $cont.= $enc2.$det.";".Chr(13).Chr(10);	 
				  $det = "";
				  $i = 0;
				  //echo"Fin<br>";
				  //echo $cont;
			  } 
			  else
			  {
				  $det = "";
				  $i = 0;
			  }
           }
	   }	  
	   		  
	 } //// Fin While


	 /// Arreglo para consolidar con toda la informacion
	 $cont.= "UPDATE consolida1 SET DEVALPAR  = DEVALUNI*DECANTIDAD WHERE DEVALPAR = 0 AND PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);
	 $cont.= "UPDATE consolida1 SET DEVALBASE = DEVALTOTAL*DEVALIVA WHERE DEVALBASE = 0 AND PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);
	 $cont.= "UPDATE consolida1 SET DEVALIVA  = DEVALTOTAL-DEVALBASE WHERE PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	 
     $cont.= "UPDATE consolida1 SET VRBASEDOC = TOTALDOC-VRIVADOC WHERE VRBASEDOC = 0 AND VRIVADOC = 0 AND PERIODODOC = '".$periodo."' AND DECODBOD='".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	 	 

     //// Junto Todas las Variables y Genero el archivo
	 $fp = fopen($archivo,"w");
	 $contenido = $enc.$cont.$cont2;
	 fwrite($fp,$contenido);
	 fclose($fp);
     $clase->closeConnection();	 
    }	 
    
	GenerarDATARotacion($periodo);
    GenerarConsolidadoEspeciales($periodo);
    GenerarConsolidadoRecargas($periodo);
    return;
  }  

/*
  ////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////////////
  function CrearObtenerPedidoidx($docuid,$bodega)
  {
    $clase   = new Sistema();
    $prefijo = $clase->BDLockup($docuid,'documentos','docuid','prefijo'); 
    $numero  = $clase->BDLockup($docuid,'documentos','docuid','numero'); 
    $numero2 = $numero."-".$bodega; 
	
	 $existe = $clase->SeleccionarUno("SELECT COUNT(*) FROM documentos WHERE tipodoc = 'PVE' AND prefijo = '".$prefijo."' AND numero = '".$numero2."'");

	 if($existe == 1)
	    $docuidPed = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'PVE' AND prefijo = '".$prefijo."' AND numero = '".$numero2."'");
	 else
	 {
		 $fechadoc   = $clase->BDLockup($docuid,'documentos','docuid','fechadoc');
		 $formapago  = $clase->BDLockup($docuid,'documentos','docuid','formapago');
		 $nrodocref  = $clase->BDLockup($docuid,'documentos','docuid','nrodocref');
		 $sucursalid = $clase->BDLockup($docuid,'documentos','docuid','sucursalid');
         $region = $clase->SeleccionarUno("SELECT Z.codregion FROM zonas Z INNER JOIN sucursales S ON (S.zona = Z.codzona) WHERE S.sucursalid =".$sucursalid);
		 $ano = intval(date("Y"))-2000;

		 $vsqlx = "INSERT INTO documentos(tipodoc,prefijo,numero,fechadoc,periodo,fecvence,fecasentado,fecanulado,observacion,
		    	   formapago,nrodocref,terid1,terid2,terid3,totalitems,sucursalid,creador,momento,auditado,ano,numdocuoriginal) 
				   VALUES('PVE','".$prefijo."','".$numero2."','".$fechadoc."','".date("mY").
			       "','0000-00-00','".$fechadoc."','0000-00-00','Pedido Dividido al Generarse','".$formapago."','".$nrodocref."',1,1,1,0,".$sucursalid.",'".$_SESSION['USERNAME']."',
				   CURRENT_TIMESTAMP,'".$region."','".$ano."','PVE".$prefijo.$numero."')";
	     
			
		 $clase->EjecutarSQL($vsqlx);
		
	     $docuidPed = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'PVE' AND prefijo = '".$prefijo."' AND numero = '".$numero2."'");
	 }  	
	 
	 echo $vsqlx."<br>".$docuidPed."<br><br>";
	  
	 return($docuidPed); 
  }
*/

  ////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////////////
  function getJsonFromMysqlQuery($vsql)
  {
		$clase = new Sistema();
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $registros = @mysql_num_rows($result);        
        while($row = mysql_fetch_object($result)) 
          $data[] = $row;		

		// Return the data array as a JSON string
		return json_encode(['code' => '200','status' => 'success', 'data' => $data]);
  }

  ////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////////////
  function GenerarJSONMenu()
  {
	 $clase = new Sistema();
   
	 //// Nombre de Usuario
	 $usuario = $_SESSION['USERNAME'];

	 $vsql1 = "SELECT * FROM usuariosxgrupos WHERE nomusuario = '".$usuario."'";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql1,$conex);
	 $grupos = "";  $i=0;
     while($row = mysql_fetch_array($result)) 
	 {
		if($i==0)
		   $grupos.= "'".$row['nomgrupo']."'";
		else
		   $grupos.= ",'".$row['nomgrupo']."'";	

		$i++;
	 }
          
	 $vsqlfinal  = "SELECT DISTINCT M.id , M.orden , M.descripcion , M.link , M.tipolink , M.esfijo  
	                FROM menu M INNER JOIN menuxusuario MU ON (M.id = MU.menuid) 
					INNER JOIN usuarios U ON (U.usuid = MU.usuarioid) 
					WHERE MU.permitido = 'S' AND (U.username = '".$usuario."' OR U.username IN (".$grupos.") ) 
	                ORDER BY M.orden ASC LIMIT 0,3";


     //// Recibo el Menu en Formato 
	 $jsonresultado = getJsonFromMysqlQuery($vsqlfinal);	

	 //// Guardo el Archivo
	 $archivo= "media/json/".$_SESSION['USERNAME'].".json"; // el nombre de tu archivo 
	 $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
	 fwrite($fch, $jsonresultado); // Grabas
	 fclose($fch); // Cierras el archivo
     
	 return;
  }

  /////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////  
  function EnviarDataVentaDiariaStellar($diaoperativo)
  {
	$clase       = new Sistema();
    $codsucursal = $clase->BDLockup('G_SUCURSALPOS','configuraciones','variab','contenido');
	$fecha = substr($diaoperativo,6,4)."-".substr($diaoperativo,3,2)."-".substr($diaoperativo,0,2);

	$vsql= "SELECT DV.diaoperativo , SUM(IF(D.tipodoc = 'FVE',D.total,0)) total , SUM(IF(DV.canalventa = 'CCE' , D.total , 0)) callcenter , SUM(IF(DV.canalventa = 'TVI' , D.total , 0)) tienda , 
			SUM(IF(DV.canalventa = 'RAP' , D.total , 0)) rappi , COUNT(D.docuid) clientesatendidos , COUNT(DISTINCT D.terid1) clientesdiferentes ,
			(SELECT SUM(total) FROM documentos DX INNER JOIN docudevolucion DVX ON (DX.docuid = DVX.docuid) WHERE DX.tipodoc = 'DVE' AND DVX.diaoperativo = DV.diaoperativo
			) devoluciones ,
			(SELECT SUM(valorventa) FROM bonificado WHERE fecha = '".$fecha."') ventaespecial , 
			(SELECT SUM(valtotal) 
			FROM documentos DX INNER JOIN dedocumentos DDX ON (DX.docuid = DDX.docuid) 
			INNER JOIN docuventa DVX ON (DVX.docuid = DX.docuid)
			WHERE DX.tipodoc = 'FVE' AND (DDX.productoid = 45308 OR DDX.productoid = 59924) AND DX.tipodoc = 'FVE' AND DX.fecasentado <> '0000-00-00' 
			AND DVX.diaoperativo = DV.diaoperativo 
			) recargas , 
			(SELECT SUM(valtotal) 
			FROM documentos DX INNER JOIN dedocumentos DDX ON (DX.docuid = DDX.docuid) 
			INNER JOIN docuventa DVX ON (DVX.docuid = DX.docuid)
			INNER JOIN productos PX ON (PX.productoid = DDX.productoid)
			WHERE DX.tipodoc = 'FVE' AND (PX.gruposprodid = 596 OR PX.gruposprodid = 577 OR PX.gruposprodid = 578) AND DX.tipodoc = 'FVE' AND DX.fecasentado <> '0000-00-00' 
			AND DVX.diaoperativo = DV.diaoperativo 
			) licores , 
			(SELECT COALESCE(COUNT(DX.docuid),0) FROM documentos DX INNER JOIN docuventa DVX ON (DX.docuid = DVX.docuid) WHERE DX.tipodoc = 'FVE' AND DVX.diaoperativo = DV.diaoperativo
			AND DX.terid3 <> 1) cantidomi  , 
			(SELECT COALESCE(SUM(DX.total),0) FROM documentos DX INNER JOIN docuventa DVX ON (DX.docuid = DVX.docuid) WHERE DX.tipodoc = 'FVE' AND DVX.diaoperativo = DV.diaoperativo
			AND DX.terid3 <> 1) valordomi  , 
			(SELECT COALESCE(COUNT(DX.numero),0) FROM documentos DX INNER JOIN docuventa DVX ON (DX.docuid = DVX.docuid) 
			WHERE DX.tipodoc = 'FVE' AND DVX.diaoperativo = DV.diaoperativo AND (EXTRACT(HOUR FROM DX.fechadoc) >= 22 or EXTRACT(HOUR FROM DX.fechadoc) <= 6)) clientesnoche ,
			(SELECT COALESCE(SUM(DX.total),0) FROM documentos DX INNER JOIN docuventa DVX ON (DX.docuid = DVX.docuid) 
			WHERE DX.tipodoc = 'FVE' AND DVX.diaoperativo = DV.diaoperativo AND (EXTRACT(HOUR FROM DX.fechadoc) >= 22 or EXTRACT(HOUR FROM DX.fechadoc) <= 6)) ventanoche 
			FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			LEFT JOIN terceros T ON (T.terid = D.terid2) 
			WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo = '".$diaoperativo."'";

			$conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $registros = @mysql_num_rows($result);        
            if($row = mysql_fetch_array($result)) 
            { 
               $vtagen   = round($row['total']);
			   $vtaesp   = round($row['ventaespecial']);
			   $noc      = $row['ventanoche'];
			   $lic      = $row['licores'];
			   $dom      = $row['cantidomi'];
			   $dom2     = $row['valordomi'];
			   $cli      = $row['clientesdiferentes'];
			   $cli2     = $row['clientesatendidos'];
			   $rec      = $row['recargas'];
			   $can      = 0+($row['rappi']+$row['tienda']+$row['callcenter']);
			   

		    }			

	  $URL = "https://plataforma.farmanorteonline.com/registro_ventas_sucursal?codigoSucursal=".$codsucursal."&diaOperativo=".$fecha."&ventaGeneral=".$vtagen."&ventaEspecial=".$vtaesp."&ventaNocturna=".$noc."&licores=".$lic."&cantDomicilios=".$dom."&valorDomicilios=".$dom2."&cantClientes=".$cli."&cantFacturas=".$cli2."&surezinc=0&recargas=".$rec."&canalesTotalizados=".$can;
	  
	  echo $URL;
	  ini_set("memory_limit","200M");
	  ini_set('display_errors', TRUE);
	  ini_set('display_startup_errors', TRUE);
	
	  set_time_limit(0);

	  $ch = curl_init($URL);
	  curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
      $tmp = curl_exec($ch);
  	  $k = json_decode($tmp);
	  curl_close($ch);    

	  echo $ch."<br>".$tmp."<br>".$k."<br>";
	  return;
  }


  /////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////
  function DividirenBodegasEspeciales($docuid)
  {
      if($_SESSION["USU-REGIONPRED"] != "")
      {
          $clase = new Sistema();
          
          $numpedori =  $clase->BDLockup($docuid,'documentos','docuid','numero');
          $sucursal  =  $clase->BDLockup($docuid,'documentos','docuid','sucursalid');
          $zona      =  $clase->BDLockup($sucursal,'sucursales','sucursalid','zona');

          if(strpos($numpedori,'-') == 0)
          {
            if($_SESSION["USU-REGIONPRED"] == "03")
            {
              /// Ingreso a Cada Pedido la mercancia	
              $vsql = "SELECT DISTINCT P.productoid , P.descripcion , P.precio1m , B.codbodega , E.cantidad FROM productos P  INNER JOIN dedocumentos DD ON (P.productoid = DD.productoid)
              LEFT JOIN existencias E ON (E.productoid = P.productoid) INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid) 
              WHERE DD.docuid = ".$docuid." AND B.codbodega IN ('VB5','VB6','VB7','VB8','VB9','VB10','RS') AND E.cantidad > 0 ORDER BY 3 ASC";
            }
            if($_SESSION["USU-REGIONPRED"] == "02")
            {
              /// Ingreso a Cada Pedido la mercancia	
              $vsql = "SELECT DISTINCT P.productoid , P.descripcion , P.precio1m , B.codbodega , E.cantidad FROM productos P  INNER JOIN dedocumentos DD ON (P.productoid = DD.productoid)
              LEFT JOIN existencias E ON (E.productoid = P.productoid) INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid) 
              WHERE DD.docuid = ".$docuid." AND B.codbodega IN ('AV5','AV6','AV7','AV8','AV9','AV10','RA') AND E.cantidad > 0 ORDER BY 3 ASC";
            }
            if($_SESSION["USU-REGIONPRED"] == "01")
            {
              /// Ingreso a Cada Pedido la mercancia	
              $vsql = "SELECT DISTINCT P.productoid , P.descripcion , P.precio1m , B.codbodega , E.cantidad FROM productos P  INNER JOIN dedocumentos DD ON (P.productoid = DD.productoid)
              LEFT JOIN existencias E ON (E.productoid = P.productoid) INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid) 
              WHERE DD.docuid = ".$docuid." AND B.codbodega IN ('VC5','VC6','VC7','VC8','VC9','VC10','RN') AND E.cantidad > 0 ORDER BY 3 ASC";
            }

            //echo $vsql;  exit;

            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $registros = @mysql_num_rows($result);
        
            while($row = mysql_fetch_array($result)) 
            { 
              $Did = CrearObtenerPedidoidx($docuid,$row['codbodega']);

              ////   Busco cuanto hay en la Bodega
              $bodegaid = $clase->BDLockup($row['codbodega'],'bodegas','codbodega','bodegaid');
              $precio   = $row['precio1m'];
              $cantBod  = $row['cantidad'];
            
              ////   Busco cuanto pidieron en el "Pedido"
              $cantPed = $clase->SeleccionarUno("SELECT cantidad FROM dedocumentos WHERE docuid=".$docuid." AND productoid=".$row['productoid']);	   
                
              if($cantBod >= $cantPed)
                  $Cantix = $cantPed;
              else
                  $Cantix = $cantBod;	 
            
              if($cantPed > 0)
              {
                //// Copio la Cantidad al Pedido Nuevo
                $vsql = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,tipund,valunitario,".
                        "valdescuento,valparcial,valbase,valiva,valtotal) VALUES(".$Did.",".$row['productoid'].",".$bodegaid.
                        ",".$Cantix.",".$Cantix.",'D',".$precio.",0,".($Cantix*$precio).",0,0,".($Cantix*$precio).")";
                $clase->EjecutarSQL($vsql);	   
            
                ///// Descuento del Pedido Original la cantidad pasada
                $vsql = "UPDATE dedocumentos SET cantidad = (cantidad - ".$Cantix.") WHERE docuid = ".$docuid." AND productoid = ".$row['productoid']; 
                $clase->EjecutarSQL($vsql);	   
              }

              CrearTransitoPedidoServidor($Did);
            }

            //// Actualizo el Campo Productos del Documento Maestro 
            $nproductos = $clase->SeleccionarUno("SELECT SUM(totalitems) FROM documentos WHERE tipodoc = 'PVE' AND numero like '".$numpedori."-%'");
            $vsql = "UPDATE documentos SET totalitems = ".$nproductos." WHERE docuid = ".$docuid; 
            $clase->EjecutarSQL($vsql);	   

          }  /// Fin del IIF

          //// Genero el Transito del Pedido original como quedó
          CrearTransitoPedidoServidor($docuid);
      }
      else
        return;
  }


  
  ///////////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////////
  function ReconstruirTransitoSucursales()
  {
		ini_set("memory_limit","300M");
		set_time_limit(0);

		error_reporting(E_ALL);
		$clase = new Sistema();
		
		//// Defino la fecha inciio
		$hoymenos4dias = $clase->SeleccionarUno("SELECT DATE_SUB(CURDATE(), INTERVAL 4 DAY)");

		///// Cargo los Pedidos
		$vsql = "SELECT D.docuid , D.tipodoc , D.prefijo , D.numero , DD.productoid , DD.cantidad , D.fechadoc 
		         FROM documentos D 
			 	 INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) WHERE D.tipodoc = 'PVE' AND D.prefijo <> 'MEK' AND D.fechadoc >= '".$hoymenos4dias."'";
		$i = 0;
		$conex  = $clase->Conectar();
		$result = @mysql_query($vsql,$conex);
		$registros = mysql_num_rows($result);
		if($registros>0) 
			$clase->EjecutarSQL("TRUNCATE transitosucursales");

		while($row = @mysql_fetch_array($result))
		{ 
			$vsql = "INSERT INTO transitosucursales(productoid,cantidad,numpedido,fecinicio,creador,momento) 
					VALUES('".$row['productoid']."','".$row['cantidad']."','".$row['tipdooc'].$row['prefijo'].$row['numero']."','".substr($row['fechadoc'],0,10)."','SYSTEM',CURRENT_TIMESTAMP)";     
			$clase->EjecutarSQL($vsql);
			//echo $vsql."<br>";		  
			$i++;
		}

		//echo"stop"; exit;
		///////////////////////////////////////////////////////////////////////
		///// Recorro las Remisiones y Elimino lo que tenga que Borrar	 
		$vsql = "SELECT D.docuid , D.tipodoc , D.prefijo , D.numero , DD.productoid , D.nrodocref FROM documentos D
				INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
				WHERE D.tipodoc = 'TRB' AND D.prefijo = 'REM' AND D.fechadoc >= '".$hoymenos4dias."'";
		$i = 0;
		$conex  = $clase->Conectar();
		$result = @mysql_query($vsql,$conex);
		while($row = @mysql_fetch_array($result))
		{ 
			if(strlen($row['nrodocref'])>0)
			{
				$vsqldel = "DELETE FROM transitosucursales WHERE productoid = '".$row['productoid']."' AND numpedido = '".$row['nrodocref']."'";     
				$clase->EjecutarSQL($vsqldel);
				//echo $vsqldel.";<br>";		  
			}
			$i++;
		}

     return;
  }


  ///////////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////////
  function DividirPedidoenVarios($docuid)
  {
     ini_set("memory_limit","300M");
	 set_time_limit(0);

	 error_reporting(E_ALL);
	 $clase = new Sistema();
	 
	 $numeroactual = $clase->BDLockup($docuid,"documentos","docuid","numero");
	 $pos = strpos($numeroactual, '-', 1);
	 echo $pos;
	 if($pos>0)
	 {
	   echo"ERROR Pedido YA Modulado - Tiene Numero con -";
	   return;
	 }

	 ///// 1. Lo Divido en las Bodegas Especiales
     /// DividirenBodegasEspeciales($docuid);
   
	 //// 2. Busco la Sucursal del Pedido
	 $sucursalid = $clase->BDLockup($docuid,"documentos","docuid","sucursalid");	
	 
     //// 3. Con La Sucursal - Busco los modulos que tiene con Productos
     $cantimodulos = 0;
     $arrayidmodulos = array();
     $arrayaliasmodulos = array();

     //// 4. DEPOSITO DESDE DONDE SE VA A DESPACHAR
	 $origen = $clase->BDLockup($docuid,"documentos","docuid","observacion2");
	 if($origen != "")
	 {
	     if($origen == "CUC") $sucidz = 19;
		 if($origen == "BAR") $sucidz = 53;
		 if($origen == "BUC") $sucidz = 249;
		 if($origen == "MED") $sucidz = 19;
     }  
	 else
	 {
         $zona = $clase->BDLockup($sucursalid,"sucursales","sucursalid","zona");
		 $region = $clase->BDLockup($zona,"zonas","codzona","codregion");
		 if($region == "01") $sucidz = 19;
		 if($region == "02") $sucidz = 53;
		 if($region == "03") $sucidz = 249;
		 if($region == "04") $sucidz = 19;
	 }
	   

	 /// Aplico la modulacion por cada uno 
     $vsql = 'SELECT DISTINCT PS.sectorid , SD.alias  FROM dedocumentos DD 
              INNER JOIN productos P ON (DD.productoid = P.productoid)
              INNER JOIN productosxsector PS ON (PS.productoid = P.productoid AND PS.sucursalid = '.$sucidz.')
              INNER JOIN sectordeposito SD ON (SD.sectorid = PS.sectorid) 
              WHERE DD.docuid = '.$docuid;

     $i = 0;
     $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
     while($row = @mysql_fetch_array($result))
     { 
        $cantimodulos++;   
        $arrayidmodulos[$i] = $row['sectorid'];
        $arrayaliasmodulos[$i] = $row['alias'];  
        
        $i++;
     }

     //// Si 
     if($cantimodulos>0)
     {
         print_r($arrayidmodulos);
         echo"<br>";
         print_r($arrayaliasmodulos);
         echo"<br>";

		 ///// Busco los Datos del Encabezado del Pedido
		 $vsql  = "SELECT * FROM documentos WHERE docuid = ".$docuid;
		 $conex  = $clase->Conectar();
		 $result = @mysql_query($vsql,$conex);
		 $row = @mysql_fetch_array($result);
	        
         $i = 0;
         while($arrayidmodulos[$i] != "")
         {
              if($arrayaliasmodulos[$i] == "")
                  $numpedidox = $row['numero']."-".($i+1);
              else
                  $numpedidox = $row['numero']."-".$arrayaliasmodulos[$i];
              
			  ///// Numero Pedido Original 
			  $numoriginal = $row['tipodoc'].$row['prefijo'].$row['numero'];	  

              ///// A. Inserto el Encabezado del Pedido    
              $vsqlins = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecvence,fecasentado,
                          fecanulado,formapago,nrodocref,importado,terid1,observacion,observacion2,
                          base,iva,total,impreso,totalitems,sucursalid,creador,momento,auditado,numdocuoriginal) 
                          VALUES('PVE','".$row['prefijo']."','".$numpedidox."','".$row['periodo']."','".$row['fechadoc']."','".$row['fecvence']."','".$row['fecasentado']."',
                          '".$row['fecanulado']."','CO','".$row['nrodocref']."','".$row['importado']."','".$row['terid1']."','".$row['observacion']."',
						  '".$row['observacion2']."','".$row['base']."','".$row['iva']."','".$row['total']."','".$row['impreso']."','".$row['totalitems']."',
						  '".$row['sucursalid']."','".$row['creador']."','".$row['momento']."','".$row['auditado']."','".$numoriginal."')";
              
		      //echo $vsqlins."<BR><br>";
              $clase->EjecutarSQL($vsqlins);		  			  

              //// B. Busco el DOCUID Nuevo
              $NDocuid = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'PVE' AND prefijo = '".$row['prefijo']."' AND numero = '".$numpedidox."'");
              $DOCUIDX = $NDocuid;

              //// C. Le hago UPDATE a los Detalles 
              $vsql2 = "SELECT DD.dedocumid FROM dedocumentos DD INNER JOIN productosxsector PXS ON (PXS.productoid = DD.productoid) WHERE DD.docuid = ".$docuid." AND PXS.sectorid = ".$arrayidmodulos[$i];
              $conex2  = $clase->Conectar();
              $result2 = @mysql_query($vsql2,$conex2);
              while($row2 = @mysql_fetch_array($result2))
              {
                  $vsqlx2 = "UPDATE dedocumentos SET docuid = ".$DOCUIDX." WHERE dedocumid = ".$row2['dedocumid'];
                  echo $vsqlx2."<br>";
                  $clase->EjecutarSQL($vsqlx2);
              }

              //// EStando Listo el Pedido, Se Modula
			  PedidoDistribuirenModulos($DOCUIDX);

              $i++;

         }  //// While 

	  } /// Si CantiModulos > 0 
	  
	  return;
  }

  ///////////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////////
  function PedidoDistribuirenModulos($docuid)
  {
      ini_set("memory_limit","300M");
	  error_reporting(E_ALL);
	  $clase = new Sistema();
	  $region = "";
	 
	  //// Busco la Sucursal del Pedido
	  $sucursalid = $clase->BDLockup($docuid,"documentos","docuid","sucursalid");		  

  	  //// Primero Limpio el Pedidos_Despacho    
  	  $clase->EjecutarSQL("DELETE FROM depedidos_despacho WHERE docuid = ".$docuid);        
	  $clase->EjecutarSQL("DELETE FROM pedidos_despacho WHERE docuid = ".$docuid); 
	  $clase->EjecutarSQL("DELETE FROM pedidos_despacho_self WHERE docuid = ".$docuid); 
	  $clase->EjecutarSQL("DELETE FROM statuspedidos WHERE docuid = ".$docuid);
	  $clase->EjecutarSQL("DELETE FROM salidas_productos_despacho WHERE docuid = ".$docuid);

	  ///// Encabezado
	  $vsql  = "SELECT * FROM documentos WHERE docuid = ".$docuid." AND (tipodoc = 'PVE' OR tipodoc = 'PXC')";

	  $conex  = $clase->Conectar();
	  $result = @mysql_query($vsql,$conex);
	  if($row = @mysql_fetch_array($result))
	  { 
		  $urgente = 0;
		  if($row['nrodocref'] == "URGENTE")       $urgente = 1;
		  $periodo = date("mY");
		  $sucursalid = $row['sucursalid'];

		  //// En caso de Ser Pedido entre Depositos se ajusta
		  if(($sucursalid == 19)||($sucursalid == 53)||($sucursalid == 249)||($sucursalid == 400))
		  {
  			  $origen = $row['observacion2'];
			  if($origen != "")
			  {
		 		  if($origen == "CUC") $region = '01';
 			      if($origen == "BAR") $region = '02';
				  if($origen == "BUC") $region = '03';
				  if($origen == "MED") $region = '04';
		   	  }  
			  else
				$region = $clase->SeleccionarUno("SELECT Z.codregion FROM zonas Z INNER JOIN sucursales S ON (S.zona = Z.codzona) WHERE S.sucursalid =".$sucursalid);
		  }
		  else
		  {
			  $sucursalid = $row['sucursalid'];
			  $region = $clase->SeleccionarUno("SELECT Z.codregion FROM zonas Z INNER JOIN sucursales S ON (S.zona = Z.codzona) WHERE S.sucursalid =".$sucursalid);
		  }

          ////////////////////////////////////////////////////////////
		  ///  SEGUN LA REGION - PROCESO DE MODULACION
		  ////////////////////////////////////////////////////////////
		  if($region == '01')
		  {
			$sucursalid_deposito = 19;
			$bodegaid = 2;
			$nombodega = "CEDI CUCUTA";
		  }

		  if($region == '02')
		  {
			$sucursalid_deposito = 53;
			$bodegaid = 119;
			$nombodega = "CEDI BARRANQUILLA";
		  }
		  	 
		  if($region == '03')
		  {
			$sucursalid_deposito = 249;
			$bodegaid = 426;
			$nombodega = "CEDI BUCARAMANGA";
		  }
		  	 
		  $ciudadid  = $clase->BDLockup($sucursalid,"sucursales","sucursalid","ciudadid");
		  $nomciudad = $clase->BDLockup($ciudadid,"ciudades","ciudadid","nombre");

		  //// "Cargo" los pedidos si son de Cualquier CEDI
		  $clase->EjecutarSQL("UPDATE documentos SET tipodoc = 'PVE' WHERE docuid = ".$docuid); 

		  //// Inserto en Pedidos Despacho
          $vsqlins = "INSERT INTO pedidos_despacho(docuid,fechadoc,tipodoc,numero,numcomprobante,fechapedidogenerado,urgente,estado_pedido,orden_pedido,sucursalid_pedido,region_pedido,
		              tipocargaped,periodo,ciudadid,nomciudad) 
					  VALUES('".$docuid."','".substr($row['fechadoc'],0,10)."','PVE','".$row['numero']."','".$row['nrodocref']."',CURRENT_TIMESTAMP,'".$urgente."','','".$docuid."','".$sucursalid."','".$region."',
					  'M','".$periodo."','".$ciudadid."','".$nomciudad."')";
		  echo $vsqlins."<BR>";
		  $clase->EjecutarSQL($vsqlins);

		  //// Busco el Sectorid
		  $partesnumero = explode("-",$row['numero']);
		  $numoriginal  = $partesnumero[0];
		  $aliassector  = $partesnumero[1];
		  echo $numoriginal."****".$aliassector;
		  if($aliassector == "")
	     	 $sectorid = '';
	  	  else
		     $sectorid = $clase->BDLockup($aliassector,"sectordeposito","alias","sectorid");
		
		  //// Inserto el Sectorid  
	  	  $vsqlins = "INSERT INTO pedidos_despacho_self(docuid,sectorid) VALUES('".$docuid."','".$sectorid."')";
		  echo $vsqlins."<br>"; 
		  $clase->EjecutarSQL($vsqlins);
	  }

	  /////// Ahora inserto los detalles
	  $vsql  = "SELECT P.codigo , P.codbarra , P.descripcion , E.cantidad exiactual ,  GP.descripcion laboratorio , 
				GP.orden orden_laboratorio , PS.orden orden_producto ,  PS.* , FD.cantidad factorproducto , SUM(DD.cantidad) solicitado
				FROM dedocumentos DD 
				INNER JOIN productosxsector PS ON (PS.productoid = DD.productoid AND PS.sucursalid = ".$sucursalid_deposito.") 
				INNER JOIN productos P ON (DD.productoid = P.productoid)
				INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid) 				
				INNER JOIN existencias E ON (E.productoid = P.productoid AND E.bodegaid = ".$bodegaid.")			
				LEFT JOIN factordespacho FD ON (FD.productoid = P.productoid) 	  
				WHERE DD.cantidad >= 1  AND DD.docuid = ".$docuid." 	
				GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14";

  	  $conex  = $clase->Conectar();
	  $result = @mysql_query($vsql,$conex);
	  while($row = @mysql_fetch_array($result))
	  { 
		 echo $row['codigo']."<br>";
		 if($row['factorproducto'] == "")
		    $solicitado = 0+($row['solicitado']);
		 else
		 {
			if($row['solicitado']<=$row['factorproducto'])
			   $solicitado = 0+($row['factorproducto']);
			else
			{
				$multiplo = 0+floor(($row['solicitado']/$row['factorproducto']));
				$solicitado = 0+($multiplo*$row['factorproducto']);
			}
		 }

		 ///// Restrinjo el Zona Cero en los Casos que Existencia == 0 y el Producto esta en la Zona Cero
		 if(($row['exiactual'] <= 0)&&($row['sectorid'] == 1))
		    $solicitado = 0;

         if($solicitado>0)
		 {
			$ordenlab = 0+$row['orden_laboratorio']; 
            $ordenpro = 0+$row['orden_producto'];

			$existe = $clase->SeleccionarUno("SELECT COUNT(*) FROM depedidos_despacho WHERE docuid = ".$docuid." AND productoid = ".$row['productoid']);
			echo $existe."<br>";
            if($existe == 0)
            {
				$vsqlins2 = "INSERT INTO depedidos_despacho(docuid,regionid,sucursalid,sectorid,productoid,producto_nombre,
							codbarraprincipal,codbarrasegundario,existencias,solicitado,despachado,fecharegistro,alistado,laboratorio,bodegaid,bodega_nombre,orden_laboratorio,orden_producto) 
							VALUES('".$docuid."','".$region."','".$sucursalid_deposito."','".$row['sectorid']."','".$row['productoid']."','".$row['descripcion']."',
							'".$row['codigo']."','".$row['codbarra']."','".$row['exiactual']."','".$solicitado."',0,CURRENT_TIMESTAMP,0,'".$row['laboratorio']."','".$bodegaid."',
							'".$nombodega."','".$ordenlab."','".$ordenpro."')";
				echo $vsqlins2."<br>";			 
				$clase->EjecutarSQL($vsqlins2);	
			}
		 }
	  }

	  $vsql = "SELECT DPD.sectorid , PD.docuid , PD.ciudadid , PD.nomciudad , S.nomsector , PD.region_pedido , COUNT(*) lineas 
	           FROM pedidos_despacho PD INNER JOIN depedidos_despacho DPD ON (PD.docuid = DPD.docuid) 
			   INNER JOIN sectordeposito S ON (S.sectorid = DPD.sectorid)
			   WHERE PD.docuid = ".$docuid." GROUP BY 1,2,3,4,5,6";
	  //echo $vsql."<BR>";
	  
	  $conex  = $clase->Conectar();
	  $result = @mysql_query($vsql,$conex);
	  while($row = @mysql_fetch_array($result))
	  { 
		 $lineas = 0+$row['lineas'];
		 $vsqlins3 = "INSERT INTO statuspedidos(docuid,codregion,ciudadid,nomciudad,lineastotales,lineasprocesadas,sectorid,nomsector) 
					  VALUES('".$docuid."','".$row['region_pedido']."','".$row['ciudadid']."','".$row['nomciudad']."','".$lineas."',0,'".$row['sectorid']."','".$row['nomsector']."')";

   	     $clase->EjecutarSQL($vsqlins3);	
	     //echo $vsqlins3."<BR>";
	  }

	  /// Ejecuto este SQL de Control 
	  $clase->EjecutarSQL("UPDATE pedidos_despacho SET urgente = 1 WHERE numcomprobante = 'URGENTE' AND urgente = 0");

	  return;
 }
 
  ///////////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////////
  function MarcarRemisionesCargaAutomaticaViaje($viajeid,$sucursalid="")
  {
      ini_set("memory_limit","300M");
	  error_reporting(E_ALL);
	  $clase = new Sistema();
	  	  
	  $vsql = "SELECT docuidremision FROM transporteremision WHERE viajeid = ".$viajeid;
	  if($sucursalid != "")
	     $vsql.= " AND sucursalid = ".$sucursalid;

	  $conex  = $clase->Conectar();
	  $result = @mysql_query($vsql,$conex);
	  while($row = @mysql_fetch_array($result))
	  { 
		 $docuid = 0+$row['docuidremision'];
		 $vsqlx = "UPDATE docutranfe SET cargaautomatica = 1 WHERE docuid = ".$docuid;		 
		 $clase->EjecutarSQL($vsqlx);
	  }
      return;
  }

  ///////////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////////
  function PedidoReordenarInternamenteDespacho($docuid)
  {
      ini_set("memory_limit","300M");
	  error_reporting(E_ALL);
	  $clase = new Sistema();
	 
	  /////// Ahora inserto los detalles
      $vsql  = "SELECT P.codigo , P.codbarra , P.descripcion , E.cantidad exiactual , DD.cantidad solicitado ,  GP.descripcion laboratorio , 
               GP.orden orden_laboratorio , PS.orden orden_producto ,  PS.* , FD.cantidad factorproducto , FD.cantidad factorproducto 
               FROM dedocumentos DD 
               INNER JOIN productosxsector PS ON (PS.productoid = DD.productoid AND PS.sucursalid = 19) 
               INNER JOIN productos P ON (DD.productoid = P.productoid)
               INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid) 				
               INNER JOIN existencias E ON (E.productoid = P.productoid AND E.bodegaid = 2)			
               LEFT JOIN factordespacho FD ON (FD.productoid = P.productoid) 	  
               WHERE DD.cantidad >= 1  AND DD.docuid = ".$docuid;

	  $conex  = $clase->Conectar();
	  $result = @mysql_query($vsql,$conex);
	  while($row = @mysql_fetch_array($result))
	  { 
		 $solicitado = 0+$row['solicitado'];

         if($solicitado>0)
		 {
            $ordenlab = 0+$row['orden_laboratorio']; 
            $ordenpro = 0+$row['orden_producto'];
			$pid = 0+$row['productoid'];

			$vsqlins2 = "UPDATE depedidos_despacho SET orden_laboratorio = '".$ordenlab."' , orden_producto = '".$ordenpro."' 
                         WHERE productoid = '".$pid."' AND docuid = ".$docuid;						 
			$clase->EjecutarSQL($vsqlins2);	
		 }
	  }

	  return;
  }

 ///////////////////////////////////////////////////////////////////////////////////////////////
 ///////////////////////////////////////////////////////////////////////////////////////////////
 function GenerarConsolidadoEspeciales($periodo)
 {
	$enc = ""; $cont= "";

	if($periodo != "")
	{
	 ini_set("memory_limit","300M");
	 error_reporting(E_ALL);

     if($_SESSION['G_SUCURSALPOS'] == '00')
        $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/ESPECIALES-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";
     else 
        $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/ESPECIALES-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";

	 if(file_exists($archivo))
	    unlink($archivo);
     
     $month   = substr($periodo,0,2);
	 $year    = substr($periodo,3,4);
	 $ultimodia = date('t', mktime(0, 0, 0, $month, 1, $year));

	 ///// Encabezado del Archivo
     if($_SESSION['G_SUCURSALPOS'] == "00")  $bodega = 50;
     else                                    $bodega = $_SESSION['G_SUCURSALPOS'];
	 
	 $enc = "SET NAMES LATIN1;".Chr(13).Chr(10);	
	 $enc.= "DELETE FROM consolida2 WHERE PERIODOESPE = '".$periodo."' AND CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	

	 $clase = new Sistema();
	 $vsql  = "SELECT B.* , S.codigo codsuc , S.descripcion nomsuc , P.codigo codpro , P.descripcion nompro , T.codvende , CONCAT(T.nombres,' ',T.apellidos) nomvende 
	           FROM bonificado B INNER JOIN productos P ON (P.productoid = B.productoid) 
	           INNER JOIN sucursales S ON (S.sucursalid = B.sucursalid) 
	           INNER JOIN terceros T ON (T.terid = B.vendedor) 
	           WHERE B.fecha >= '".substr($periodo,2,4)."-".substr($periodo,0,2)."-01' AND B.fecha <= '".substr($periodo,2,4)."-".substr($periodo,0,2)."-".$ultimodia."'";

	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 $fp = fopen($archivo,"w");
	 $cont = "";	  
	 $i=0;  $agendo = "";
	 while($row = @mysql_fetch_array($result))
	 { 
	     $cont.="INSERT INTO consolida2(PERIODOESPE, FECHAESPE , CODVENDE , NOMVENDE , CODPRODUCTO , NOMPRODUCTO , CANTIVENTA , VALORVENTA , PORCENBONI , VALORCOMI , CODSUCURSAL ,  NOMSUCURSAL , PAGADO ) VALUES ('".$periodo."','".$row['fecha']."','".$row['codvende']."','".$row['nomvende']."','".$row['codpro']."','".$row['nompro']."','".$row['cantidad']."','".$row['valorventa']."','".$row['porcenboni']."','".$row['valorcomi']."','".$row['codsuc']."','".$row['nomsuc']."','".$row['pagado']."');".Chr(13).Chr(10);	   
	     $i++;		  
	 }  
	 
	 $contenido = $enc.$cont;
	 fwrite($fp,$contenido);
	 
	 fclose($fp);
     $clase->closeConnection();	 
    }	 
  }  
  
  ///////////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////////
  function GenerarConsolidadoRecargas($periodo)
  {
		 $enc = ""; $cont= "";
	     ini_set("memory_limit","300M");
		 error_reporting(E_ALL);
	     
	     $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/RECARGAS-".$_SESSION['G_SUCURSALPOS'].".sql";
	     
		 if(file_exists($archivo))
		    unlink($archivo);
	     
	     $month   = substr($periodo,0,2);
		 $year    = substr($periodo,2,4);
		 $ultimodia = date('t', mktime(0, 0, 0, $month, 1, $year));

		 ///// Encabezado del Archivo
	     if($_SESSION['G_SUCURSALPOS'] == "00")  $bodega = 50;
	     else                                    $bodega = $_SESSION['G_SUCURSALPOS'];
		 
		 $enc = "SET NAMES LATIN1;".Chr(13).Chr(10);	
		 $enc.= "DELETE FROM consolida3 WHERE CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	

		 $clase = new Sistema();
		 $vsql  = "SELECT S.codigo codsucursal , S.descripcion nomsucursal , D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.total , DV.diaoperativo , TR.codoperador , 
		           TR.numrecarga, TR.valor, TR.codvende, TR.pinrecargas 
	               FROM documentos D INNER JOIN sucursales S ON (D.sucursalid = S.sucursalid) 
				   INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
				   INNER JOIN productos P ON (P.productoid = DD.productoid)
	               INNER JOIN docuventa DV ON ( D.docuid = DV.docuid ) 
	               INNER JOIN transarecargas TR ON ( D.docuid = TR.idfactura )
				   WHERE D.fecasentado <> '0000-00-00' AND D.numero NOT LIKE '-%' AND (P.codigo = 'R1000' OR P.codigo = 'R1001')";

		 $conex  = $clase->Conectar();
	     $result = @mysql_query($vsql,$conex);
		 $fp = fopen($archivo,"w");
		 $cont = "";	  
		 $i=0;  $agendo = "";
		 while($row = @mysql_fetch_array($result))
		 { 
		     $cont.="INSERT INTO consolida3(CODSUCURSAL,NOMSUCURSAL,TIPODOC,PREFIJODOC,NUMERODOC,FECHADOC,DIAOPERATIVO,CODOPERADOR,NUMRECARGA,VALOR,CODVENDE,PINRECARGAS,TOTALDOC) VALUES ('".$row['codsucursal']."','".$row['nomsucursal']."','".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['fechadoc']."','".   $row['diaoperativo']."','".$row['codoperador']."','".$row['numrecarga']."','".$row['valor']."','".$row['codvende']."','".$row['pinrecargas']."','".$row['total']."');".Chr(13).Chr(10);	   
		     $i++;		  
		 }  
		 
		 $contenido = $enc.$cont;
		 fwrite($fp,$contenido);
		 
		 fclose($fp);
	     $clase->closeConnection();	 
  }  

  ///////////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////////
  function GenerarConsolidadoNocturnos($periodo)
  {
		 $enc = ""; $cont= "";
	     ini_set("memory_limit","300M");
		 error_reporting(E_ALL);
	     
	     $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/NOCTURNOS-".$_SESSION['G_SUCURSALPOS'].".sql";
	     
		 if(file_exists($archivo))
		    unlink($archivo);
	     
	     $month   = substr($periodo,0,2);
		 $year    = substr($periodo,2,4);
		 $ultimodia = date('t', mktime(0, 0, 0, $month, 1, $year));

		 ///// Encabezado del Archivo
	     if($_SESSION['G_SUCURSALPOS'] == "00")  $bodega = 50;
	     else                                    $bodega = $_SESSION['G_SUCURSALPOS'];
		 
		 $enc = "SET NAMES LATIN1;".Chr(13).Chr(10);	
		 $enc.= "DELETE FROM consolida4 WHERE CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."' AND DIAOPERATIVO LIKE '%/".$month."/".$year."';".Chr(13).Chr(10);	

		 $clase = new Sistema();
		 $vsql  = "SELECT * FROM regpervende WHERE diaoperativo LIKE '%/".$month."/".$year."'";

		 $conex  = $clase->Conectar();
	     $result = @mysql_query($vsql,$conex);
		 $fp = fopen($archivo,"w");
		 $cont = "";	  
		 $i=0;  $agendo = "";
		 while($row = @mysql_fetch_array($result))
		 { 
		     $cont.="INSERT INTO consolida4(CODSUCURSAL,DIAOPERATIVO,CODVENDE,NOMVENDE,MOMENTO) VALUES ('".$row['codsucursal']."','".$row['diaoperativo']."','".$row['codvende']."','".$row['nomvende']."','".$row['momento']."');".Chr(13).Chr(10);	   
		     $i++;		  
		 }  
		 
		 $contenido = $enc.$cont;
		 fwrite($fp,$contenido);
		 
		 fclose($fp);
	     $clase->closeConnection();	 
  }  

  ///////////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////////
  function GenerarConsolidadoMasxti($periodo)
  {
		 $enc = ""; $cont= "";
	     ini_set("memory_limit","300M");
		 error_reporting(E_ALL);
	     
	     $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/MASXTI-".$_SESSION['G_SUCURSALPOS'].".sql";
	     
		 if(file_exists($archivo))
		    unlink($archivo);
	     
	     $month   = substr($periodo,0,2);
		 $year    = substr($periodo,2,4);
		 $ultimodia = date('t', mktime(0, 0, 0, $month, 1, $year));

		 ///// Encabezado del Archivo
	     if($_SESSION['G_SUCURSALPOS'] == "00")  $bodega = 50;
	     else                                    $bodega = $_SESSION['G_SUCURSALPOS'];
		 
		 $enc = "SET NAMES LATIN1;".Chr(13).Chr(10);	
		 $enc.= "DELETE FROM consolida5 WHERE CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	

		 $clase = new Sistema();
		 $vsql  = "SELECT DD. * , T.dni, T.nombres, T.apellidos, P.descripcion nomproducto , P.codigo , D.tipodoc, D.prefijo, D.numero, D.fechadoc, 
				   S.descripcion nomsucursal, S.codigo codsucursal , D.creador , D.momento , DV.diaoperativo , D.observacion , D.observacion2 
				   FROM documentos D 
				   INNER JOIN docuventa DV ON (DV.docuid = D.docuid)
				   INNER JOIN dedocumentos DD ON ( D.docuid = DD.docuid ) 
			   	   INNER JOIN terceros T ON ( T.terid = D.terid1 ) 
				   INNER JOIN sucursales S ON ( S.sucursalid = D.sucursalid ) 
				   INNER JOIN productos P ON ( DD.productoid = P.productoid ) 
				   WHERE D.fecasentado <> '0000-00-00' 
				   AND D.tipodoc =  'FVE' 
				   AND DD.observalinea NOT LIKE '%*%'
			       AND DD.observalinea <> ''";

		 $conex  = $clase->Conectar();
	     $result = @mysql_query($vsql,$conex);
		 $fp = fopen($archivo,"w");
		 $cont = "";	  
		 $i=0;  $agendo = "";
		 while($row = @mysql_fetch_array($result))
		 { 
			 $periodo = substr($row['fechadoc'],5,2).substr($row['fechadoc'],0,4);
			 $cont.= "INSERT INTO consolida5(CODSUCURSAL,NOMSUCURSAL,DIAOPERATIVO,TOKEN,DNIPACIENTE,NOMPACIENTE,APEPACIENTE,NOMPRODUCTO,CODPRODUCTO,NUMFACTURA,CANTIDAD,VALOR,PERIODO,OBSERVACION1,OBSERVACION2,CREADOR,MOMENTO) ". 
		             "VALUES ('".$row['codsucursal']."','".$row['nomsucursal']."','".$row['diaoperativo']."','".$row['observalinea']."','".$row['dni'].
		             "','".$row['nombres']."','".$row['apellidos']."','".$row['nomproducto']."','".$row['codigo']."','".$row['tipodoc'].$row['prefijo'].$row['numero'].
		             "','".$row['cantidad']."','".$row['valunitario']."','".$periodo."','".$row['observacion']."','".$row['observacion2']."','".$row['creador']."','".$row['momento']."');".Chr(13).Chr(10);	   
		     $i++;		  
		 }  
		 
		 $contenido = $enc.$cont;
		 fwrite($fp,$contenido);
		 
		 fclose($fp);
	     $clase->closeConnection();	 
  }  
 
 ////////////////////////////////////////////////////
 ////////////////////////////////////////////////////
 function GenerarConsolidadoConvenio($periodo)
 {
	$enc = ""; $cont= "";

	if($periodo != "")
	{
	 ini_set("memory_limit","300M");
	 error_reporting(E_ALL); 

     if($_SESSION['G_SUCURSALPOS'] == '00')
        $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/CONVENIO-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";
     else 
        $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/CONVENIO-".$periodo."-".$_SESSION['G_SUCURSALPOS'].".sql";

	 if(file_exists($archivo))
	    unlink($archivo);
	 
	 ///// Encabezado del Archivo
     if($_SESSION['G_SUCURSALPOS'] == "00")  $bodega = 50;
     else                                    $bodega = $_SESSION['G_SUCURSALPOS'];
	 
	 $enc = "SET NAMES LATIN1;".Chr(13).Chr(10);	
	 $enc.= "DELETE FROM consolidaconvenio WHERE PERIODODOC = '".$periodo."' AND CODSUC = '".$_SESSION['G_SUCURSALPOS']."';".Chr(13).Chr(10);	

	 $clase = new Sistema();
	 $vsql  =  "SELECT DISTINCT D.tipodoc , D.prefijo , D.numero , D.fechadoc , DCC.diaoperativo , D.periodo , DCC.* , T.codvende , 
				CONCAT(T.nombres,' ',T.apellidos) nomvende , P.codigo codproducto , P.descripcion nomproducto , 
				B.codbodega , B.nombodega , C.codconvenio , C.nomconvenio , E.codentidad , E.nomentidad , S.codigo codsucursal , 
				S.descripcion nomsucursal , GP.codigo codlabo , GP.descripcion nomlabo , DDC.* , 0 as cantix , 
				(SELECT CONCAT(nombres,' ',priapellido) FROM beneficiariosconvenio WHERE dni = DCC.dnibeneficiario) nombeneficiario , P.factor1    
				FROM documentos D 
				INNER JOIN sucursales S ON (S.sucursalid = D.sucursalid)
				INNER JOIN docuconvenio DCC ON (DCC.docuid = D.docuid)
				INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
				INNER JOIN productos P ON (P.productoid = DD.productoid)
				INNER JOIN bodegas B ON (B.bodegaid = DD.bodegaid) 
				INNER JOIN dedocuconvenio DDC ON (DDC.dedocumid = DD.dedocumid)
				INNER JOIN gruposprod GP ON (GP.gruposprodid = P.gruposprodid)
				LEFT JOIN terceros T ON (T.terid = D.terid2)
				LEFT JOIN convenios C ON (C.convenioid = DCC.convenioid)
				LEFT JOIN entidades E ON (E.entidadid = C.entidadid)
				WHERE D.tipodoc = 'FEN' AND D.fecasentado <> '0000-00-00' AND D.periodo = '".$periodo."'";
				
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 $cont = "";	  
	 $i=0;  $agendo = "";
	 while($row = @mysql_fetch_array($result))
	 {  	
		   $diaoperativox = $row['fechadoc'];
		   $diaoperativo = substr($diaoperativox,8,2).'/'.substr($diaoperativox,5,2).'/'.substr($diaoperativox,0,4);
		   	       
	       ///// Cajas y Unidades Entregadas
	       if(abs($row['cantix']) == 0)
	       {
	           $cajentre = $row['cajentrega'];
		       $unientre = $row['unientrega'];
	       }
	       else
	       {
		       $cajentre = variant_int(abs($row['cantix']));
		       $unientre = abs($row['cantix']) - $cajentre;
		       $unientre = ($unientre*$row['factor1']);
	       }

		   $cont.="INSERT INTO consolidaconvenio(TIPODOC,PREFIJODOC,NUMERODOC,FECHADOC,DIAOPEDOC,PERIODODOC,DNIBENEDOC,NOMBENEDOC,CODVENDOC,NOMVENDOC,CODMEDDOC,NOMMEDDOC,CODCONVENIO,NOMCONVENIO,NUMFORMULA,FECFORMULA,CODENTI,NOMENTI,ITEMSDOC,OBSERVADOC,CODSUC,NOMSUC,DECODBOD,DENOMBOD,DECODPRO,DENOMPRO,DECODLABO,DENOMLABO,CAJFOR,UNIFOR,CAJENT,UNIENT,CAJFAL,UNIFAL,CREADOR,MOMENTO) VALUES ('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['fechadoc']."','".$diaoperativo."','".$row['periodo']."','".$row['dnibeneficiario']."','".$row['nombeneficiario']."','".$row['codvende']."','".$row['nomvende']."','".$row['medicoid']."','".$row['medicoid']."','".$row['codconvenio']."','".$row['nomconvenio']."','".$row['numformula']."','".$row['fechaformula']."','".$row['codentidad']."','".$row['nomentidad']."',0,'".$row['observacion']."','".$row['codsucursal']."','".$row['nomsucursal']."','".$row['codbodega']."','".$row['nombodega']."','".$row['codproducto']."','".$row['nomproducto']."','".$row['codlabo']."','".$row['nomlabo']."','".$row['cajformula']."','".$row['uniformula']."','".$cajentre."','".$unientre."','".$row['cajfaltan']."','".$row['unifaltan']."','SYSTEM',CURRENT_TIMESTAMP);".Chr(10);
		   $i++;		  
	 }  
	 
     //// Junto Todas las Variables y Genero el archivo
     $fp = fopen($archivo,"w");
	 $contenido = $enc.$cont.$cont2;
	 fwrite($fp,$contenido);
	 fclose($fp);
     $clase->closeConnection();	 
    }	 

    return;
  }  


  ///////////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////////
	function GenerarCierreCostos($diaoperativo)
	{
		  if($periodo != "")
			{
				ini_set("memory_limit","300M");
	      error_reporting(E_ALL); 
				$clase = new Sistema();
				$vsql  =  "SELECT C.CODSUCURSAL , C.TIPODOC , C.PREFIJODOC , C.NUMERODOC , C.FECHADOC , C.CODPRODUCTO , C.NOMPRODUCTO , C.DEUNICOM , C.DEUNIFRA , C.DEVALTOTAL , C.DEVALBASE , 
				 					 COALESCE(ROUND(FU_CostoProducto(C.CODPRODUCTO , C.FECHADOC),2),0) COSTOHIS , ROUND(((C.DEVALTOTAL / C.DEVALBASE)-1)*100) PORCIVA , 
									 P.factor1 , P.precio1m , ROUND(P.ultcosto,2) ultcosto , ROUND(P.costoinf,2) costoinf , ROUND(P.costoprom,2) costoprom 
									 FROM consolida1 C 
									 LEFT JOIN productos P ON (C.CODPRODUCTO = P.codigo)
									 WHERE PERIODODOC = '".$diaoperativo."' AND C.DVDIAOPE = '01/03/2019'
									 ORDER BY C.CODSUCURSAL , C.PREFIJODOC , C.NUMERODOC";
				
				$periodo = substr($diaoperativo,3,2).substr($diaoperativo,6,4);

				$conex  = $clase->Conectar();
				$result = @mysql_query($vsql,$conex);
				$registros = mysql_num_rows($result);
				echo $vsql." -> ".$registros."<br>"; 

				/// Si hay Registros ejecuto el Proceso
				if($registros>0)
				{
						$clase->EjecutarSQL("DELETE FROM cierrecostosmes WHERE periodo = '".$periodo."'");

					  $i=0;  $agendo = "";
						while($row = @mysql_fetch_array($result))
						{  	
								$vsql2 = "INSERT INTO cierrecostosmes(periodo,tipodoc,prefijo,numero,fechadoc,codproducto,unicom,unifra,total,base,costohis,costoprom,costoinf,ultcosto,precio1m,factor1,porciva,momento) 
													VALUES('".$periodo."','".$row['TIPODOC']."','".$row['PREFIJODOC']."','".$row['NUMERODOC']."','".$row['FECHADOC']."','".$row['CODPRODUCTO']."','".$row['DEUNICOM']."','".$row['DEUNIFRA']."',
													'".$row['DEVALTOTAL']."','".$row['DEVALBASE']."','".$row['COSTOHIS']."','".$row['costoprom']."','".$row['costoinf']."','".$row['ultcosto']."','".$row['precio1m']."','".$row['factor1']."',
													'".$row['PORCIVA']."',CURRENT_TIMESTAMP)";
								//$clase->EjecutarSQL($vsql2);
								echo $vsql2."<br>";		  
						}  
				}
			  $clase->closeConnection();	 
			}
		return;
	}

  ///////////////////////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////////////////////
  function GenerarConsolidadoCierres($periodo)
  {
		 $enc = ""; $cont= "";
	     ini_set("memory_limit","200M");
		 error_reporting(E_ALL);
	     
	     $archivo = "../Dropbox/".$_SESSION['G_SUCURSALPOS']."/todos/CIERRES-".$_SESSION['G_SUCURSALPOS'].".sql";
	     
		 if(file_exists($archivo))
		    unlink($archivo);
	     
	     $month   = substr($periodo,0,2);
		 $year    = substr($periodo,2,4);
		 $ultimodia = date('t', mktime(0, 0, 0, $month, 1, $year));

		 ///// Encabezado del Archivo
	     if($_SESSION['G_SUCURSALPOS'] == "00")  $bodega = 50;
	     else                                    $bodega = $_SESSION['G_SUCURSALPOS'];
		 
		 $enc = "SET NAMES LATIN1;".Chr(13).Chr(10);	
		 $enc.= "DELETE FROM consolidacierres WHERE CODSUCURSAL = '".$_SESSION['G_SUCURSALPOS']."' AND DIAOPERATIVO LIKE '%/".$month."/".$year."';".Chr(13).Chr(10);	

		 $clase = new Sistema();
		 $vsql  = "SELECT S.codigo codsuc , C.* FROM cierres C INNER JOIN sucursales S ON (C.sucid = S.sucursalid) WHERE C.tipocierre = 'DEF' AND C.diaoperativo LIKE '%/".$month."/".$year."'";

		 $conex  = $clase->Conectar();
	     $result = @mysql_query($vsql,$conex);
		 $fp = fopen($archivo,"w");
		 $cont = "";	  
		 $i=0;  $agendo = "";
		 while($row = @mysql_fetch_array($result))
		 { 
		     $cont.="INSERT INTO consolidacierres(CODSUCURSAL,DIAOPERATIVO,TIPOCIERRE,ENCAJA,ENTREGADO,RECOGIDAS,DIFERENCIA,INGRESOEFE,EFECTIVO,TARJETAS,CREDITOS,PUNTOS,ACONSIGNAR,GASTOS,OTROSMP,CREADOR,MOMENTO) VALUES('".$row['codsuc']."','".$row['diaoperativo']."','".$row['tipocierre']."','".$row['valcaja']."','".$row['valentrega']."','".$row['valrecogidas']."','".$row['valdiferencia']."','".$row['ingresoefe']."','".$row['totefectivo']."','".$row['tottarjetas']."','".$row['totcreditos']."','".$row['totpuntos']."','".$row['totconsignar']."','".$row['totgastos']."','".$row['tototrosmp']."','".$row['creador']."','".$row['momento']."');".Chr(13).Chr(10);	   
		     $i++;		  
		 }  
		 
		 $contenido = $enc.$cont;
		 fwrite($fp,$contenido);
		 
		 fclose($fp);
	     $clase->closeConnection();	 
  } 

  /////////////////////////////////////////////////////////////////////////////////
  function PermisoAcceso($usuario,$menu)  
  {
	 $clase = new Sistema();
	 $permitido = true;
	 /// Busco los grupos a los que pertenece el Usuario
	 $vsqlg = "SELECT U2.username FROM usuarios U INNER JOIN usuariosxgrupos UG ON (U.username = UG.nomusuario) INNER JOIN usuarios U2 ON (UG.nomgrupo = U2.username) WHERE U.username = '".$usuario."'";
	 
	 $conex  = $clase->Conectar();   
	 $result  = @mysql_query($vsqlg,$conex);  
	 $listausuarios = "";
	 
	 while($row = @mysql_fetch_array($result)) 
		$listausuarios .= " U.username = '".$row['username']."' OR ";

	  /// Le Adiciono el nombre del Usuario
	  $listausuarios .= " U.username = '".$usuario."' ";
	 
	  $vsql = "SELECT MAX(MU.permitido)
	           FROM menu M 
			   INNER JOIN menuxusuario MU ON ( M.id = MU.menuid ) 
			   INNER JOIN usuarios U ON ( U.usuid = MU.usuarioid ) 
			   WHERE M.orden = '".$menu."' AND (".$listausuarios.") ";  		   

      $permitido = $clase->SeleccionarUno($vsql);		   
	  return($permitido);
  } 
  
  ///////////////////////////////////////////////////////////////////////////////// 
  ////   FUNCIONES DE FECHAS
  /////////////////////////////////////////////////////////////////////////////////  
  function DiaSemanaNumero($fechax) {
	$dia = @date('N', strtotime($fechax));
	return($dia);
  }
  
  function DiaSemana($fechax) {
	  $dias = @array('','Lunes','Martes','Miercoles','Jueves','Viernes','Sabado','Domingo');
	  $fecha = @$dias[date('N', strtotime($fechax))];
	  return($fecha);
  }
  
  function DiaSemanaCorto($fechax) {
	$dias = @array('','Lun','Mar','Mie','Jue','Vie','Sab','Dom');
	$fecha = @$dias[date('N', strtotime($fechax))];
	return($fecha);
  }

  /////////////////////////////////////////////////////////////////////////
  function SiguienteDia($fecha,$dias) 
  {	  
	  $errores = 0;
	  //// Se corrige los dias de Cierres
	  list ($dia,$mes,$ano)=explode("/",$fecha);  
	  if (!checkdate($mes,$dia,$ano))
	    $errores = 1;
	  
      if($errores == 0)
	  {
		  $dia=$dia+$dias;  
		  $fecha=date("d/m/Y", mktime(0,0,0,$mes,$dia,$ano) );  
		  if(strlen($fecha) == 10)
		    return $fecha;  
 		  else  
			return("ERROR");		  
	  }		
	  else
	  {
		 $clase = new Sistema();

		 //// Busco Primero en la Tabla Configuraciones
		 $ultimodiaope = $clase->BDLockup("G_DIAOPERATIVO","configuraciones","variab","contenido");
         if(($ultimodiaope != "")&&(strlen($ultimodiaope) == 10))
		 {
			 list ($dia,$mes,$ano)=explode("/",$fecha);  
			 $dia=$dia+$dias;  
			 $fecha=date("d/m/Y", mktime(0,0,0,$mes,$dia,$ano) ); 
			 if(strlen($fecha) == 10)
			   return($fecha);
		 } 		
		 else
		 {
			 //// Busco como segunda opcion el Dia Operativo del Ultimo Cierre
			 $cierreid = $clase->SeleccionarUno("SELECT MAX(cierreid) FROM cierres WHERE tipocierre = 'DEF' AND diaoperativo <> '' AND diaoperativo IS NOT NULL");
			 $ultimodiaope = $clase->BDLockup($cierreid,"cierres","cierreid","diaoperativo");
	
			 list ($dia,$mes,$ano)=explode("/",$fecha);  
			 $dia=$dia+$dias;  
			 $fecha=date("d/m/Y", mktime(0,0,0,$mes,$dia,$ano) ); 
			 if(strlen($fecha) == 10)
			   return($fecha);
			 else  
			   return("ERROR");		  
		 } 
		 
	  }
  }  

  ///////////////////////////////////////////////////////////////////////////////// 
  ////   INTERFAZ DROPOS - VISUAL TNS
  /////////////////////////////////////////////////////////////////////////////////  
  ////   1. COMPRAS
  ////   Al asentar una Compra - Genera el registro en TNS /  
  /////////////////////////////////////////////////////////////////////////////////
  function QUITARCompraTNS($docuid)
  {
	 $clase = new Sistema();
	 $claseTNS = new Datos();
 
     $vsql = "SELECT * FROM documentos D INNER JOIN terceros T ON (D.terid1 = T.terid) WHERE docuid=".$docuid;
	 $con  = $clase->Conectar();
     $result = @mysql_query($vsql,$con);

	 if($row = @mysql_fetch_array($result))
	 {
        $codcomp    = "FC";
        $codprefijo = "XX";
        $numero     = $row['numero'];
        
        // 1. ME CONECTO
		// Lo Busco - Si Existe Lo Elimino y lo SobreEscribo
		$conex = $claseTNS->Conectar();
        
		// 2. ELIMINO LA COMPRA - SI LA HAY
        // Busco el KARDEXID de la Compra Existente
        $kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP='FC' AND CODPREFIJO='00' AND NUMERO='".$numero."'");
		if($kardexid!="")
		{
		  // Elimino lo que hay de Prueba
		  $vsqlTNS0 = "DELETE FROM DEKARDEX WHERE KARDEXID=".$kardexid;
		  $claseTNS->Consulta($conex,$vsqlTNS0);   
		  
		  $vsqlTNS0 = "DELETE FROM KARDEX WHERE KARDEXID=".$kardexid;
		  $claseTNS->Consulta($conex,$vsqlTNS0);   
        }
 	 }
	 $clase->closeConnection();
  }


  ////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////    
  function ExisteCompraTNS($NUMERO)
  {
	 $clase     = new Sistema();    /// Clase de Conexion a Mysql
	 $claseTNS  = new Datos();      /// Clase de Conexion a Firebird
	 $conex     = $claseTNS->Conectar();
	 $kardexid  = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP = 'FC' AND CODPREFIJO = '00' AND NUMERO = '".$NUMERO."'","KARDEXID");
     if($kardexid == "")
	    return(0);
	 else 
	    return(1);  
  }

  ////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////    
  function EnviarCompraTNS($docuid)
  {
	 $clase = new Sistema();       /// Clase de Conexion a Mysql
	 $claseTNS = new Datos();      /// Clase de Conexion a Firebird
     
     $errores = 0;

     $vsql= "SELECT DC.diascartera , DC.dcto1 , DC.dcto2 , T.dni , T.porreteftecom , 
			(SELECT IFNULL(SUM(valtotal),0) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 0) iva0 ,
			(SELECT IFNULL(SUM(valtotal),0) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 5) iva5 ,
			(SELECT IFNULL(SUM(valtotal),0) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 19) iva19 , 
			D.*  
			FROM documentos D INNER JOIN docucompra DC ON (D.docuid = DC.docuid) 
			INNER JOIN terceros T ON (D.terid1 = T.terid) 
			WHERE D.docuid = ".$docuid;

	 $con  = $clase->Conectar();
     $result = mysql_query($vsql,$con);

	 if($row = mysql_fetch_array($result))
	 {
        $codcomp    = "FC";
        $codprefijo = "00";
        $numero     = substr($row['nrodocref'],0,7);		
        $nrodocref  = $row['numero'];
		$obs        = 'Factura de Compra No. FCO '.$row['prefijo'].' '.$row['numero'].' generado por DROPos v. '.$_SESSION['G_VERSIONAPP'];        
        $fecha      = substr($row['fechadoc'],5,2).'/'.substr($row['fechadoc'],8,2).'/'.substr($row['fechadoc'],0,4);
        $periodo    = substr($row['fechadoc'],5,2);
        $formapago  = $row['formapago'];		
		$base       = round($row['base'],4);
		$iva        = round($row['iva'],4);
		$total      = round($row['total'],4);
        $periodo    = substr($fecha,0,2);
        $dias       = 0+$row['diascartera'];
        $dcto1      = 0+$row['dcto1'];
		$dcto2      = 0+$row['dcto2'];

		if($row['fecvence'] == "0000-00-00") 
		  $fecvence   = 'NULL';
		else  
		  $fecvence   = "'".substr($row['fecvence'],5,2)."/".substr($row['fecvence'],8,2)."/".substr($row['fecvence'],0,4)."'";
        
        $prods00    = 0+$row['iva0'];                  $base00 = $prods00;                $iva00   = 0;
        $prods05    = 0+$row['iva5'];                  $base05 = round(($prods05/1.05),4);           $iva05   = round(($prods05-$base05),4);
        $prods19    = 0+$row['iva19'];                 $base19 = round(($prods19/1.19),4);           $iva19   = round(($prods19-$base19),4);        

        if($row['retefuente'] > 0)
           $porrete    = round(0+(($row['retefuente']/$row['base'])*100),4);
        else 
           $porrete    = 0;

        // 1. ME CONECTO
		// Lo Busco - Si Existe Lo Elimino y lo SobreEscribo
		$conex = $claseTNS->Conectar();
				
        // 2. CREO EL TERCERO SI NO ESTA EN TNS
		// Busco la Informacion del Tercero
		$terid    = $claseTNS->SelectOne($conex,"SELECT TERID FROM TERCEROS WHERE NIT='".$row['dni']."' OR NITTRI='".$row['dni']."'","TERID");				
		if($terid == "")
		{
			$errores = 1;
			  return(false);
			exit;     
				}
				else
				{
			// 4. INSERTO o ACTUALIZO EL ENCABEZADO DEL DOCUMENTO
			// Inserto el Encabezado del Comprobante
			$kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP = 'FC' AND CODPREFIJO = '".$codprefijo."' AND NUMERO = '".$numero."'","KARDEXID");
			if($kardexid == "")
			{
							$vsqlTNS1 = "INSERT INTO KARDEX( CODCOMP , CODPREFIJO , NUMERO , FECHA , OBSERV , PERIODO , CENID , AREADID , SUCID , RETIVA , RETICA , RETFTE , 
												AJUSTEBASE , AJUSTEIVA , AJUSTEIVAEXC , AJUSTENETO , CLIENTE , VENDEDOR , FORMAPAGO , PLAZODIAS , TIPODOC , DOCUMENTO , FECVENCE , FECEMI , 
												NROFACPROV , VRBASE , VRIVA , VRICONSUMO , VRRFTE , 
												VRRICA , VRRIVA , TOTAL , FPCONTADO , FPCREDITO , FACTORCONV , IMPORTADO , USUARIO , RETCREE , VRRCREE) 
											VALUES('FC','".$codprefijo."','".$numero."','".$fecha."','Generada de Dropos ERP - Dia ".
								date("d/m/Y")."','".$periodo."',1,1,1,0,0,".$porrete.",0,0,0,0,".$terid.",1,'".$formapago."',".$dias.",'','',".$fecvence.",'".$fecha."',
								'".$nrodocref."',".$total.",0,0,0,0,0,".$total.",0,".$total.",1,'S','ADMIN',0,0)";

								$claseTNS->Consulta($conex,$vsqlTNS1);
			}
			else
			{
				$fecasentado = $claseTNS->SelectOne($conex,"SELECT FECASENTAD FROM KARDEX WHERE CODCOMP = 'FC' AND CODPREFIJO = '".$codprefijo."' AND NUMERO = '".$numero."'","FECASENTAD");
				if($fecasentado != "")
				{
					$errores = 1;
					  return(false);
					exit; 
								}
								else
								{
							$vsqlTNS1 = "UPDATE KARDEX SET FECHA = '".$fecha."' , PERIODO  = '".$periodo."' , CLIENTE = ".$terid." , RETFTE = ".$porrete." , 
												NROFACPROV = '".$nrodocref."' , VRBASE = ".$base." ,  VRIVA = ".$iva." ,  
												TOTAL = ".$total." , FPCREDITO = ".$total." WHERE KARDEXID = ".$kardexid;	
								$claseTNS->Consulta($conex,$vsqlTNS1);
								}				
			}	        
	

            if($errores == 0)
            {
					// 5. BUSCO EL KARDEXID 
			        $kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP = 'FC' AND CODPREFIJO = '".$codprefijo."' AND NUMERO = '".$numero."'","KARDEXID");

				    // 6. Aplico los descuentos de la Compra
				    $vsqlTNS1 = "UPDATE KARDEX SET PORC1 = ".$dcto1." , PORC2 = ".$dcto2." WHERE KARDEXID = ".$kardexid;	
		            $claseTNS->Consulta($conex,$vsqlTNS1);            

		            // 7. Elimino los Productos que tengan 
		            $claseTNS->Consulta($conex,"DELETE FROM DEKARDEX WHERE KARDEXID = ".$kardexid);

		            // 8. Inserto los Nuevos Productos
			        if($row['iva0'] > 0)
			        {
						$matid = 33;
						$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
			        		         PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
					                 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
					                 PRECIOTASA , PARCTASA) 
		                             VALUES(".$kardexid.",".$matid.",1,2,0,'D',0,0,1,1,".$prods00.",".$prods00.",".$prods00.",0".
		                             ",0,0,".$prods00.",".$prods00.",".$prods00.",0,0,0,'',0,".$prods00.",".$prods00.")";
					    $claseTNS->Consulta($conex,$vsqlTNS2);
			        }


			        if($row['iva5'] > 0)
			        {
						$matid = 34;
						$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
			        		         PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
					                 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
					                 PRECIOTASA , PARCTASA) 
		                             VALUES(".$kardexid.",".$matid.",1,2,0,'D',5,0,1,1,".$base05.",".$base05.",".$base05.",".$iva05.
		                             ",0,0,".$prods05.",".$prods05.",".$base05.",0,0,0,'',0,".$base05.",".$base05.")";
					    $claseTNS->Consulta($conex,$vsqlTNS2);
			        }


			        if($row['iva19'] > 0)
			        {
						$matid = 35;
						$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
			        		         PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
					                 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
					                 PRECIOTASA , PARCTASA) 
		                             VALUES(".$kardexid.",".$matid.",1,2,0,'D',19,0,1,1,".$base19.",".$base19.",".$base19.",".$iva19.
		                             ",0,0,".$prods19.",".$prods19.",".$base19.",0,0,0,'',0,".$base19.",".$base19.")";
					    $claseTNS->Consulta($conex,$vsqlTNS2);
			        }
            }
       }

	   /// Finalizo Actualizando el Campo de TNS al Documento de DROPOS
	   $vsqlM = "UPDATE documentos SET contabilizado = 'CHECKED' , numcomprobante = 'FC".$codprefijo.$numero."' WHERE docuid = ".$docuid;  
	   echo $vsqlM;
	   $clase->EjecutarSQL($vsqlM);
	    
       /// Cierro todas las Conexiones al ODBC
       $claseTNS->DesconectarTodo();
     }
  }  

  ////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////    
  function EnviarVentaCXPTNS($nrodocref)
  {
	 $clase = new Sistema();       /// Clase de Conexion a Mysql
	 $claseTNS = new Datos();      /// Clase de Conexion a Firebird
     
     $errores = 0;
     $prods00 = 0;   $prods05 = 0;     $prods10 = 0;       $prods16 = 0;    $prods19 = 0;
     $vsql= "SELECT * FROM consolida1 WHERE CONCAT(TIPODOC,PREFIJODOC,NUMERODOC) = '".$nrodocref."'";
	 $con  = $clase->Conectar();
	 $result = mysql_query($vsql,$con);
	 $registros = mysql_num_rows($result);
          	
     if($registros > 0)
     {

		 while($row = mysql_fetch_array($result))
		 {
	        $codcomp    = "FV";
	        $codprefijo = "DP";
	        $numero     = $row['NUMERODOC'];		
	        $nrodocref  = $nrodocref;
		    	$obs        = 'Factura de Venta No. FVE '.$row['PREFIJODOC'].' '.$row['NUMERODOC'].' generado por DROPos v. '.$_SESSION['G_VERSIONAPP'];        
	        $fecha      = substr($row['FECHADOC'],5,2).'/'.substr($row['FECHADOC'],8,2).'/'.substr($row['FECHADOC'],0,4);
	        $periodo    = substr($row['FECHADOC'],5,2);
	        $formapago  = 'CR';		
					$base       = $row['VRBASEDOC'];
					$iva        = $row['VRIVADOC'];
					$total      = $row['TOTALDOC'];
	        $periodo    = substr($fecha,0,2);
	        $dias       = 30;
	        $dnitercero = $row['DNICLIDOC'];

	        $porcentaje = round((($row['DEVALTOTAL']/$row['DEVALBASE'])*100)-100);

	        if($porcentaje == 0){     $prods00   += 0+$row['DEVALTOTAL'];          $base00 += 0+$row['DEVALBASE'];        $iva00   += 0;                  }
	        if($porcentaje == 5){     $prods05   += 0+$row['DEVALTOTAL'];          $base05 += 0+$row['DEVALBASE'];        $iva05   += $prods05-$base05;   }
	        if($porcentaje == 10){    $prods10   += 0+$row['DEVALTOTAL'];          $base10 += 0+$row['DEVALBASE'];        $iva10   += $prods10-$base10;   }
	        if($porcentaje == 16){    $prods16   += 0+$row['DEVALTOTAL'];          $base16 += 0+$row['DEVALBASE'];        $iva16   += $prods16-$base16;   }
	        if($porcentaje == 19){    $prods19   += 0+$row['DEVALTOTAL'];          $base19 += 0+$row['DEVALBASE'];        $iva19   += $prods19-$base19;   }     
         }	        
	       
	        // 1. ME CONECTO
			// Lo Busco - Si Existe Lo Elimino y lo SobreEscribo
			$conex = $claseTNS->Conectar();

	        // 2. CREO EL TERCERO SI NO ESTA EN TNS
			// Busco la Informacion del Tercero
			$terid    = $claseTNS->SelectOne($conex,"SELECT TERID FROM TERCEROS WHERE NIT='".$dnitercero."' OR NITTRI='".$dnitercero."'","TERID");				
			if($terid == "")
			{
			   $errores = 1;
			   echo'<h1> Tercero No Existe </h1>
			        <h3> Debe crearlo en TNS </h3>
			        <a href = "cuentasporcobrar.php"> Volver a Cuentas por Cobrar </a>';
			   exit;     
	        }
	        else
	        {
				// 4. INSERTO o ACTUALIZO EL ENCABEZADO DEL DOCUMENTO
				// Inserto el Encabezado del Comprobante
		        $kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP = 'FV' AND CODPREFIJO = '".$codprefijo."' AND NUMERO = '".$numero."'","KARDEXID");
				
				if($kardexid == "")
				{
		            $vsqlTNS1 = "INSERT INTO KARDEX( CODCOMP , CODPREFIJO , NUMERO , FECHA , OBSERV , PERIODO , CENID , AREADID , SUCID , RETIVA , RETICA , RETFTE , 
		            	         AJUSTEBASE , AJUSTEIVA , AJUSTEIVAEXC , AJUSTENETO , CLIENTE , VENDEDOR , FORMAPAGO , PLAZODIAS , TIPODOC , DOCUMENTO , FECVENCE , FECEMI , 
		            	         NROFACPROV , VRBASE , VRIVA , VRICONSUMO , VRRFTE , 
		            	         VRRICA , VRRIVA , TOTAL , FPCONTADO , FPCREDITO , FACTORCONV , IMPORTADO , USUARIO , RETCREE , VRRCREE) 
				                 VALUES('FV','".$codprefijo."','".$numero."','".$fecha."','Generada de Dropos ERP - Dia ".
					     		 date("d/m/Y")."','".$periodo."',1,1,1,0,0,0,0,0,0,0,".$terid.",1,'".$formapago."',".$dias.",'','','".$fecha."','".$fecha."',
					     		 '".$nrodocref."',".$total.",0,0,0,0,0,".$total.",0,".$total.",1,'S','ADMIN',0,0)";

	              $claseTNS->Consulta($conex,$vsqlTNS1);
				}
				else
				{
					$fecasentado = $claseTNS->SelectOne($conex,"SELECT FECASENTAD FROM KARDEX WHERE CODCOMP = 'FV' AND CODPREFIJO = '".$codprefijo."' AND NUMERO = '".$numero."'","FECASENTAD");
					if($fecasentado != "")
					{
						$errores = 1;
						echo'<h1> Factura Asentada en TNS </h1>
	 				         <h3> No se Puede modificar ningun valor </h3>
	 				         <a href = "cuentasporcobrar.php"> Volver a Cuentas por Cobra>';
						exit; 
	                }
	                else
	                {
				        $vsqlTNS1 = "UPDATE KARDEX SET FECHA = '".$fecha."' , PERIODO  = '".$periodo."' , CLIENTE = ".$terid." , 
							             NROFACPROV = '".$nrodocref."' , VRBASE = ".$base." ,  VRIVA = ".$iva." ,  
							             TOTAL = ".$total." , FPCREDITO = ".$total." WHERE KARDEXID = ".$kardexid;	
			            $claseTNS->Consulta($conex,$vsqlTNS1);
	                }				
				}	        
	            

	            if($errores == 0)
	            {
						// 5. BUSCO EL KARDEXID 
				        $kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP = 'FV' AND CODPREFIJO = '".$codprefijo."' AND NUMERO = '".$numero."'","KARDEXID");

			            // 6. Inserto los Nuevos Productos
				        if($prods00 > 0)
				        {
				        	$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
															 PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
															 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
															 PRECIOTASA , PARCTASA) 
			                         VALUES(".$kardexid.",3,1,2,0,'D',0,0,1,1,".$prods00.",".$prods00.",".$prods00.",0".
			                         ",0,0,".$prods00.",".$prods00.",".$prods00.",0,0,0,'',0,".$prods00.",".$prods00.")";
						      $claseTNS->Consulta($conex,$vsqlTNS2);
				        }


				        if($prods05 > 0)
				        {
				        	$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
				        		         PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
						                 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
						                 PRECIOTASA , PARCTASA) 
			                             VALUES(".$kardexid.",10,1,2,0,'D',5,0,1,1,".$base05.",".$base05.",".$base05.",".$iva05.
			                             ",0,0,".$prods05.",".$prods05.",".$base05.",0,0,0,'',0,".$base05.",".$base05.")";
						    $claseTNS->Consulta($conex,$vsqlTNS2);
				        }

                        if($prods10 > 0)
				        {
				        	$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
				        		         PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
						                 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
						                 PRECIOTASA , PARCTASA) 
			                             VALUES(".$kardexid.",10,1,2,0,'D',10,0,1,1,".$base10.",".$base10.",".$base10.",".$iva10.
			                             ",0,0,".$prods10.",".$prods10.",".$base10.",0,0,0,'',0,".$base10.",".$base10.")";
						    $claseTNS->Consulta($conex,$vsqlTNS2);
				        }

				        if($prods16 > 0)
				        {
				        	$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
				        		         PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
						                 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
						                 PRECIOTASA , PARCTASA) 
			                             VALUES(".$kardexid.",10,1,2,0,'D',16,0,1,1,".$base16.",".$base16.",".$base16.",".$iva16.
			                             ",0,0,".$prods16.",".$prods16.",".$base16.",0,0,0,'',0,".$base16.",".$base16.")";
						    $claseTNS->Consulta($conex,$vsqlTNS2);
				        }

				        if($prods19 > 0)
				        {
				        	$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
				        		         PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
						                 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
						                 PRECIOTASA , PARCTASA) 
			                             VALUES(".$kardexid.",4,1,2,0,'D',19,0,1,1,".$base19.",".$base19.",".$base19.",".$iva19.
			                             ",0,0,".$prods19.",".$prods19.",".$base19.",0,0,0,'',0,".$base19.",".$base19.")";
						    $claseTNS->Consulta($conex,$vsqlTNS2);
				        }
	               }
            }	
      }
    
    /// Cierro todas las Conexiones al ODBC
    $claseTNS->DesconectarTodo();
  }

  ////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////    
  function EnviarVentaConvenioTNS($docuid)
  {
	 $clase = new Sistema();       /// Clase de Conexion a Mysql
	 $claseTNS = new Datos();      /// Clase de Conexion a Firebird
     
     $errores = 0;

     $vsql= "SELECT T.dni , T.porreteftecom , 
			(SELECT IFNULL(SUM(valtotal),0) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 0) iva0 ,
			(SELECT IFNULL(SUM(valtotal),0) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 5) iva5 ,
			(SELECT IFNULL(SUM(valtotal),0) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 19) iva19 , 
			D.*  
			FROM documentos D 
			INNER JOIN terceros T ON (D.terid1 = T.terid) 
			WHERE D.docuid = ".$docuid;

	 $con  = $clase->Conectar();
     $result = mysql_query($vsql,$con);

	 if($row = mysql_fetch_array($result))
	 {
        $codcomp    = "FV";
        $codprefijo = "IN";
        $numero     = $row['numero'];		
        $nrodocref  = $row['nnrodocref'];
		    $obs        = 'Factura de Venta No. '.$row['prefijo'].' '.$row['numero'].' generado por DROPos v. '.$_SESSION['G_VERSIONAPP'];        
        $fecha      = substr($row['fechadoc'],5,2).'/'.substr($row['fechadoc'],8,2).'/'.substr($row['fechadoc'],0,4);
        $periodo    = substr($row['fechadoc'],5,2);
        $formapago  = 'CR';		
				$base       = $row['base'];
				$iva        = $row['iva'];
				$total      = $row['total'];
        $periodo    = substr($fecha,0,2);
        $dias       = 30;
        
        $prods00    = 0+$row['iva0'];                  $base00 = $prods00;                $iva00   = 0;
        $prods05    = 0+$row['iva5'];                  $base05 = $prods05/1.05;           $iva05   = $prods05-$base05;
        $prods19    = 0+$row['iva19'];                 $base19 = $prods19/1.19;           $iva19   = $prods19-$base19;        

        // 1. ME CONECTO
		    // Lo Busco - Si Existe Lo Elimino y lo SobreEscribo
		    $conex = $claseTNS->Conectar();
		
        // 2. CREO EL TERCERO SI NO ESTA EN TNS
				// Busco la Informacion del Tercero
				$terid    = $claseTNS->SelectOne($conex,"SELECT TERID FROM TERCEROS WHERE NIT='".$row['dni']."' OR NITTRI='".$row['dni']."'","TERID");				

				if($terid == "")
				{
					$errores = 1;
					echo'<h1> Tercero No Existe </h1>
								<h3> Debe crearlo en TNS </h3>
								<a href = "facturaespe.php"> Volver a Ventas Institucionales </a>';
					exit;     
        }
        else
        {
					// 4. INSERTO o ACTUALIZO EL ENCABEZADO DEL DOCUMENTO
					// Inserto el Encabezado del Comprobante
							$kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP = 'FV' AND CODPREFIJO = '".$codprefijo."' AND NUMERO = '".$numero."'","KARDEXID");
						if($kardexid == "")
						{
										$vsqlTNS1 = "INSERT INTO KARDEX( CODCOMP , CODPREFIJO , NUMERO , FECHA , OBSERV , PERIODO , CENID , AREADID , SUCID , RETIVA , RETICA , RETFTE , 
															AJUSTEBASE , AJUSTEIVA , AJUSTEIVAEXC , AJUSTENETO , CLIENTE , VENDEDOR , FORMAPAGO , PLAZODIAS , TIPODOC , DOCUMENTO , FECVENCE , FECEMI , 
															NROFACPROV , VRBASE , VRIVA , VRICONSUMO , VRRFTE , 
															VRRICA , VRRIVA , TOTAL , FPCONTADO , FPCREDITO , FACTORCONV , IMPORTADO , USUARIO , RETCREE , VRRCREE) 
														VALUES('FV','".$codprefijo."','".$numero."','".$fecha."','Generada de Dropos ERP - Dia ".
											date("d/m/Y")."','".$periodo."',1,1,1,0,0,0,0,0,0,0,".$terid.",1,'".$formapago."',".$dias.",'','','".$fecha."','".$fecha."',
											'".$nrodocref."',".$total.",0,0,0,0,0,".$total.",0,".$total.",1,'S','ADMIN',0,0)";

											$claseTNS->Consulta($conex,$vsqlTNS1);
						}
						else
						{
							$fecasentado = $claseTNS->SelectOne($conex,"SELECT FECASENTAD FROM KARDEX WHERE CODCOMP = 'FV' AND CODPREFIJO = '".$codprefijo."' AND NUMERO = '".$numero."'","FECASENTAD");
							if($fecasentado != "")
							{
									$errores = 1;
									echo'<h1> Factura Asentada en TNS </h1>
												<h3> No se Puede modificar ningun valor </h3>
												<a href = "facturaespe.php"> Volver a Ventas Institucionales </a>';
									exit; 
												}
												else
												{
											$vsqlTNS1 = "UPDATE KARDEX SET FECHA = '".$fecha."' , PERIODO  = '".$periodo."' , CLIENTE = ".$terid." , RETFTE = ".$porrete." , 
																NROFACPROV = '".$nrodocref."' , VRBASE = ".$base." ,  VRIVA = ".$iva." ,  
																TOTAL = ".$total." , FPCREDITO = ".$total." WHERE KARDEXID = ".$kardexid;	
												$claseTNS->Consulta($conex,$vsqlTNS1);
												}				
							}	        
            
	
            if($errores == 0)
            {
					      // 5. BUSCO EL KARDEXID 
			          $kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP = 'FV' AND CODPREFIJO = '".$codprefijo."' AND NUMERO = '".$numero."'","KARDEXID");

		            // 7. Elimino los Productos que tengan 
		            $claseTNS->Consulta($conex,"DELETE FROM DEKARDEX WHERE KARDEXID = ".$kardexid);

		            // 8. Inserto los Nuevos Productos
			        if($row['iva0'] > 0)
			        {
			        	$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
			        		         PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
					                 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
					                 PRECIOTASA , PARCTASA) 
		                             VALUES(".$kardexid.",3,1,2,0,'D',0,0,1,1,".$prods00.",".$prods00.",".$prods00.",0".
		                             ",0,0,".$prods00.",".$prods00.",".$prods00.",0,0,0,'',0,".$prods00.",".$prods00.")";
					    $claseTNS->Consulta($conex,$vsqlTNS2);
			        }


			        if($row['iva5'] > 0)
			        {
			        	$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
			        		         PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
					                 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
					                 PRECIOTASA , PARCTASA) 
		                             VALUES(".$kardexid.",10,1,2,0,'D',5,0,1,1,".$base05.",".$base05.",".$base05.",".$iva05.
		                             ",0,0,".$prods05.",".$prods05.",".$base05.",0,0,0,'',0,".$base05.",".$base05.")";
					    $claseTNS->Consulta($conex,$vsqlTNS2);
			        }


			        if($row['iva19'] > 0)
			        {
			        	$vsqlTNS2 = "INSERT INTO DEKARDEX( KARDEXID , MATID , BODID , PRIORIDAD , REMTOTFAC , TIPUND , PORCIVA , DESCUENTO , CANLISTA , CANMAT , 
			        		         PRECIOLISTA , PRECIOVTA , PRECIOBASE , PRECIOIVA , 
					                 PRECIOEXCENTO , PRECIOICONSUMO , PRECIONETO , PARCVTA , PARCOSTO , DCTOADIC , DESCUENTO3 , DESCUENTO4 , TALLACOLOR , DAJUSTEBASE , 
					                 PRECIOTASA , PARCTASA) 
		                             VALUES(".$kardexid.",4,1,2,0,'D',19,0,1,1,".$base19.",".$base19.",".$base19.",".$iva19.
		                             ",0,0,".$prods19.",".$prods19.",".$base19.",0,0,0,'',0,".$base19.",".$base19.")";
					    $claseTNS->Consulta($conex,$vsqlTNS2);
			        }
            }
       }

       /// Cierro todas las Conexiones al ODBC
       $claseTNS->DesconectarTodo();
     }
  }  

  ////////////////////////////////////////////////////////////////////////////  
  //// 2. INTERFAZ DE VENTAS                                              ////  
  ////////////////////////////////////////////////////////////////////////////  
  function QUITARVentaTNS($docuid)
  {
	 $clase = new Sistema();
	 $claseTNS = new Datos();
 
     $vsql = "SELECT * FROM documentos D INNER JOIN terceros T ON (D.terid1 = T.terid) WHERE docuid=".$docuid;
	 $con  = $clase->Conectar();
     $result = @mysql_query($vsql,$con);

	 if($row = @mysql_fetch_array($result))
	 {
        $codcomp    = "FC";
        $codprefijo = "XX";
        $numero     = $row['numero'];
        
        // 1. ME CONECTO
		// Lo Busco - Si Existe Lo Elimino y lo SobreEscribo
		$conex = $claseTNS->Conectar();
        
		// 2. ELIMINO LA COMPRA - SI LA HAY
        // Busco el KARDEXID de la Compra Existente
        $kardexid    = $claseTNS->SelectOne($conex,"SELECT KARDEXID FROM KARDEX WHERE CODCOMP='FC' AND CODPREFIJO='00' AND NUMERO='".$numero."'");
		if($kardexid!="")
		{
		  // Elimino lo que hay de Prueba
		  $vsqlTNS0 = "DELETE FROM DEKARDEX WHERE KARDEXID=".$kardexid;
		  $claseTNS->Consulta($conex,$vsqlTNS0);   
		  
		  $vsqlTNS0 = "DELETE FROM KARDEX WHERE KARDEXID=".$kardexid;
		  $claseTNS->Consulta($conex,$vsqlTNS0);   
        }
 	 }
	$clase->closeConnection(); 
  }
        
  //////////////////////////////////////////////////  
  //////////////////////////////////////////////////  
  function EnviarVentasaContabilidadTNS($docuid)
  {
	$clase = new Sistema();       /// Clase de Conexion a Mysql
	$claseTNS = new Datos();      /// Clase de Conexion a Firebird
	
	$errores = 0;

	$vsql= "SELECT DC.*, T.dni , T.porreteftecom , 
		   (SELECT IFNULL(SUM(valtotal),0) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 0) iva0 ,
		   (SELECT IFNULL(SUM(valtotal),0) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 5) iva5 ,
		   (SELECT IFNULL(SUM(valtotal),0) FROM dedocumentos WHERE docuid = D.docuid AND porciva = 19) iva19 , 
		   D.*  
		   FROM documentos D INNER JOIN docuventa DC ON (D.docuid = DC.docuid) 
		   INNER JOIN terceros T ON (D.terid1 = T.terid) 
		   WHERE D.docuid = ".$docuid;

	$con  = $clase->Conectar();
	$result = mysql_query($vsql,$con);
	if($row = mysql_fetch_array($result))
	{
	   $pref = substr($row['fechadoc'],5,2);
	   $num  = $row['numero'];	
	
	   $obs  = "Factura Contabilizada desde Dropos ERP";
	   $fec  = substr($row['fechadoc'],5,2).'/'.substr($row['fechadoc'],8,2).'/'.substr($row['fechadoc'],0,4);
	   $per  = substr($row['fechadoc'],5,2);
	   $tot  = $row['total'];
	   $fpf  = $row['formapago'];

	   $prods00    = 0+$row['iva0'];   
	   $prods05    = 0+$row['iva5'];   
	   $prods19    = 0+$row['iva19'];  
	   	 	   				   
	   // 1. ME CONECTO
	   // Lo Busco - Si Existe Lo Elimino y lo SobreEscribo
	   $conex = $claseTNS->Conectar();
			   
	   // 2. CREO EL TERCERO SI NO ESTA EN TNS
       // Busco la Informacion del Tercero
	   $terid    = $claseTNS->SelectOne($conex,"SELECT TERID FROM TERCEROS WHERE NIT='".$row['dni']."' OR NITTRI='".$row['dni']."'","TERID");				
	   if($terid == "")
	   {
				   $errores = 1;
				   echo'<h1> Tercero No Existe </h1>
							   <h3> Debe crearlo en TNS </h3>
							   <a href = "compras.php"> Volver a Compras </a>';
				   exit;     
	   }
	   else
	   {
		        $vsqlTNS1 = "INSERT INTO MOVI(CODCOMP,CODPREFIJO,NUMERO,OBS,FECHA,TOTDB,TOTCR,FECASENT,PERIODO,
			  	 			 AREADID,SUCID,IMPORTADO,USUARIO,TOTDBNIIF,TOTCRNIIF,DIFERENCIA,DIFERENCIANIIF,PREIMP)
							 VALUES('FV','".$pref."','".$num."','".$obs."','".$fec."',".$tot.",".$tot.",NULL,'".$per."',
							 1,1,'N','ADMIN',".$tot.",".$tot.",0,0,'00')";
 		        $claseTNS->Consulta($conex,$vsqlTNS1);

				// Inserto Los Detalles
				$movid = $claseTNS->SelectOne($conex,"SELECT MOVID FROM MOVI WHERE CODCOMP = 'FV' AND CODPREFIJO = '".$pref."' AND NUMERO = '".$num."'","MOVID");
				

				// Inserto el Detalle por el Total
				/// Si es a Credito 136595.06    -     Si es contado 110505.01
                if($fpf == "CR")
				   $pucid = $claseTNS->SelectOne($conex,"SELECT PUCID FROM PLANCUENTAS WHERE CODIGO = '136595.06'","PUCID");   
				else
				   $pucid = $claseTNS->SelectOne($conex,"SELECT PUCID FROM PLANCUENTAS WHERE CODIGO = '110505.01'","PUCID");      

				$vsqlTNS2 = "INSERT INTO DEMOVI(MOVID,PUCID,VALORTRA,VALORTRANIIF,TIPOCD,TERID,OBSTRA,TIPDOCUM,NRODOCUM,BASERET,CENID,FUENTERECID,SIGNO,AREADID)
					    	 VALUES(".$movid.",".$pucid.",".$tot.",".$tot.",'D',".$terid.",'Factura de Venta No. FV".$pref.$num."','FV','".$num."',0,1,1,1,1)";
				$claseTNS->Consulta($conex,$vsqlTNS2);
				echo $vsqlTNS2."<br>";
				
				// Inserto los Detalles
				if($row['iva0'] > 0)
				{
					   $pucid = $claseTNS->SelectOne($conex,"SELECT PUCID FROM PLANCUENTAS WHERE CODIGO = '413538.01'","PUCID");   
					   $vsqlTNS2 = "INSERT INTO DEMOVI(MOVID,PUCID,VALORTRA,VALORTRANIIF,TIPOCD,TERID,OBSTRA,TIPDOCUM,NRODOCUM,BASERET,CENID,FUENTERECID,SIGNO,AREADID)
									VALUES(".$movid.",".$pucid.",".$row['iva0'].",".$row['iva0'].",'C',".$terid.",'Venta IVA 0%','FV','".$num."',0,1,1,-1,1)";
					   $claseTNS->Consulta($conex,$vsqlTNS2);
					   echo $vsqlTNS2."<br>";
				}

                if($row['iva5'] > 0)
				{
					$total = $row['iva5'];
					$base  = $total/1.05;
					$iva   = $total-$base; 
					$pucid = $claseTNS->SelectOne($conex,"SELECT PUCID FROM PLANCUENTAS WHERE CODIGO = '413538.02'","PUCID");   
					$vsqlTNS2 = "INSERT INTO DEMOVI(MOVID,PUCID,VALORTRA,VALORTRANIIF,TIPOCD,TERID,OBSTRA,TIPDOCUM,NRODOCUM,BASERET,CENID,FUENTERECID,SIGNO,AREADID)
								 VALUES(".$movid.",".$pucid.",".$base.",".$base.",'C',".$terid.",'Venta IVA 5%','FV','".$num."',0,1,1,-1,1)";
					$claseTNS->Consulta($conex,$vsqlTNS2);
					$pucid = $claseTNS->SelectOne($conex,"SELECT PUCID FROM PLANCUENTAS WHERE CODIGO = '240802.03'","PUCID");   
					$vsqlTNS2 = "INSERT INTO DEMOVI(MOVID,PUCID,VALORTRA,VALORTRANIIF,TIPOCD,TERID,OBSTRA,TIPDOCUM,NRODOCUM,BASERET,CENID,FUENTERECID,SIGNO,AREADID)
								 VALUES(".$movid.",".$pucid.",".$iva.",".$iva.",'C',".$terid.",'IVA 5%','FV','".$num."',0,1,1,-1,1)";
			    }
				   
				if($row['iva19'] > 0)
				{
					$total = $row['iva19'];
					$base  = $total/1.19;
					$iva   = $total-$base; 
					$pucid = $claseTNS->SelectOne($conex,"SELECT PUCID FROM PLANCUENTAS WHERE CODIGO = '413538.02'","PUCID");   
					$vsqlTNS2 = "INSERT INTO DEMOVI(MOVID,PUCID,VALORTRA,VALORTRANIIF,TIPOCD,TERID,OBSTRA,TIPDOCUM,NRODOCUM,BASERET,CENID,FUENTERECID,SIGNO,AREADID)
								 VALUES(".$movid.",".$pucid.",".$base.",".$base.",'C',".$terid.",'Venta IVA 19%','FV','".$num."',0,1,1,-1,1)";
					$claseTNS->Consulta($conex,$vsqlTNS2);
			        $pucid = $claseTNS->SelectOne($conex,"SELECT PUCID FROM PLANCUENTAS WHERE CODIGO = '240802.01'","PUCID");   
					$vsqlTNS2 = "INSERT INTO DEMOVI(MOVID,PUCID,VALORTRA,VALORTRANIIF,TIPOCD,TERID,OBSTRA,TIPDOCUM,NRODOCUM,BASERET,CENID,FUENTERECID,SIGNO,AREADID)
								 VALUES(".$movid.",".$pucid.",".$iva.",".$iva.",'C',".$terid.",'IVA 19%','FV','".$num."',0,1,1,-1,1)";
					$claseTNS->Consulta($conex,$vsqlTNS2);

				}
		   }

	  /// Cierro todas las Conexiones al ODBC
	  $claseTNS->DesconectarTodo();
	}
  }  

  

//////////////////////////////////////////////////////////////////////////
/// CLASE MONTO EN LETRAS
//////////////////////////////////////////////////////////////////////////
class EnLetras
{
  var $Void = "";
  var $SP = " ";
  var $Dot = ".";
  var $Zero = "0";
  var $Neg = "Menos";
  
function ValorEnLetras($x, $Moneda ) 
{
    $s="";
    $Ent="";
    $Frc="";
    $Signo="";
        
    if(floatVal($x) < 0)
     $Signo = $this->Neg . " ";
    else
     $Signo = "";
    
    if(intval(number_format($x,2,'.','') )!=$x) //<- averiguar si tiene decimales
      $s = number_format($x,2,'.','');
    else
      $s = number_format($x,0,'.','');
       
    $Pto = strpos($s, $this->Dot);
        
    if ($Pto === false)
    {
      $Ent = $s;
      $Frc = $this->Void;
    }
    else
    {
      $Ent = substr($s, 0, $Pto );
      $Frc =  substr($s, $Pto+1);
    }

    if($Ent == $this->Zero || $Ent == $this->Void)
       $s = "Cero ";
    elseif( strlen($Ent) > 7)
    {
       $s = $this->SubValLetra(intval( substr($Ent, 0,  strlen($Ent) - 6))) . 
             "Millones " . $this->SubValLetra(intval(substr($Ent,-6, 6)));
    }
    else
    {
      $s = $this->SubValLetra(intval($Ent));
    }

    if (substr($s,-9, 9) == "Millones " || substr($s,-7, 7) == "Millón ")
       $s = $s . "de ";

    $s = $s . $Moneda;

    if($Frc != $this->Void)
    {
       $s = $s . " Con " . $this->SubValLetra(intval($Frc)) . "Centavos";
       //$s = $s . " " . $Frc . "/100";
    }
    return ($Signo . $s . " MCTE");
   
}


function SubValLetra($numero) 
{
    $Ptr="";
    $n=0;
    $i=0;
    $x ="";
    $Rtn ="";
    $Tem ="";

    $x = trim("$numero");
    $n = strlen($x);

    $Tem = $this->Void;
    $i = $n;
    
    while( $i > 0)
    {
       $Tem = $this->Parte(intval(substr($x, $n - $i, 1). 
                           str_repeat($this->Zero, $i - 1 )));
       If( $Tem != "Cero" )
          $Rtn .= $Tem . $this->SP;
       $i = $i - 1;
    }

    
    //--------------------- GoSub FiltroMil ------------------------------
    $Rtn=str_replace(" Mil Mil", " Un Mil", $Rtn );
    while(1)
    {
       $Ptr = strpos($Rtn, "Mil ");       
       If(!($Ptr===false))
       {
          If(! (strpos($Rtn, "Mil ",$Ptr + 1) === false ))
            $this->ReplaceStringFrom($Rtn, "Mil ", "", $Ptr);
          Else
           break;
       }
       else break;
    }

    //--------------------- GoSub FiltroCiento ------------------------------
    $Ptr = -1;
    do{
       $Ptr = strpos($Rtn, "Cien ", $Ptr+1);
       if(!($Ptr===false))
       {
          $Tem = substr($Rtn, $Ptr + 5 ,1);
          if( $Tem == "M" || $Tem == $this->Void)
             ;
          else          
             $this->ReplaceStringFrom($Rtn, "Cien", "Ciento", $Ptr);
       }
    }while(!($Ptr === false));

    //--------------------- FiltroEspeciales ------------------------------
    $Rtn=str_replace("Diez Un", "Once", $Rtn );
    $Rtn=str_replace("Diez Dos", "Doce", $Rtn );
    $Rtn=str_replace("Diez Tres", "Trece", $Rtn );
    $Rtn=str_replace("Diez Cuatro", "Catorce", $Rtn );
    $Rtn=str_replace("Diez Cinco", "Quince", $Rtn );
    $Rtn=str_replace("Diez Seis", "Dieciseis", $Rtn );
    $Rtn=str_replace("Diez Siete", "Diecisiete", $Rtn );
    $Rtn=str_replace("Diez Ocho", "Dieciocho", $Rtn );
    $Rtn=str_replace("Diez Nueve", "Diecinueve", $Rtn );
    $Rtn=str_replace("Veinte Un", "Veintiun", $Rtn );
    $Rtn=str_replace("Veinte Dos", "Veintidos", $Rtn );
    $Rtn=str_replace("Veinte Tres", "Veintitres", $Rtn );
    $Rtn=str_replace("Veinte Cuatro", "Veinticuatro", $Rtn );
    $Rtn=str_replace("Veinte Cinco", "Veinticinco", $Rtn );
    $Rtn=str_replace("Veinte Seis", "Veintiseís", $Rtn );
    $Rtn=str_replace("Veinte Siete", "Veintisiete", $Rtn );
    $Rtn=str_replace("Veinte Ocho", "Veintiocho", $Rtn );
    $Rtn=str_replace("Veinte Nueve", "Veintinueve", $Rtn );

    //--------------------- FiltroUn ------------------------------
    If(substr($Rtn,0,1) == "M") $Rtn = "Un " . $Rtn;
    //--------------------- Adicionar Y ------------------------------
    for($i=65; $i<=88; $i++)
    {
      If($i != 77)
         $Rtn=str_replace("a " . Chr($i), "* y " . Chr($i), $Rtn);
    }
    $Rtn=str_replace("*", "a" , $Rtn);
    return($Rtn);
}


function ReplaceStringFrom(&$x, $OldWrd, $NewWrd, $Ptr)
{
  $x = substr($x, 0, $Ptr)  . $NewWrd . substr($x, strlen($OldWrd) + $Ptr);
}


function Parte($x)
{
    $Rtn='';
    $t='';
    $i='';
    Do
    {
      switch($x)
      {
         Case 0:  $t = "Cero";break;
         Case 1:  $t = "Un";break;
         Case 2:  $t = "Dos";break;
         Case 3:  $t = "Tres";break;
         Case 4:  $t = "Cuatro";break;
         Case 5:  $t = "Cinco";break;
         Case 6:  $t = "Seis";break;
         Case 7:  $t = "Siete";break;
         Case 8:  $t = "Ocho";break;
         Case 9:  $t = "Nueve";break;
         Case 10: $t = "Diez";break;
         Case 20: $t = "Veinte";break;
         Case 30: $t = "Treinta";break;
         Case 40: $t = "Cuarenta";break;
         Case 50: $t = "Cincuenta";break;
         Case 60: $t = "Sesenta";break;
         Case 70: $t = "Setenta";break;
         Case 80: $t = "Ochenta";break;
         Case 90: $t = "Noventa";break;
         Case 100: $t = "Cien";break;
         Case 200: $t = "Doscientos";break;
         Case 300: $t = "Trescientos";break;
         Case 400: $t = "Cuatrocientos";break;
         Case 500: $t = "Quinientos";break;
         Case 600: $t = "Seiscientos";break;
         Case 700: $t = "Setecientos";break;
         Case 800: $t = "Ochocientos";break;
         Case 900: $t = "Novecientos";break;
         Case 1000: $t = "Mil";break;
         Case 1000000: $t = "Millón";break;
      }

      If($t == $this->Void)
      {
        $i = $i + 1;
        $x = $x / 1000;
        If($x== 0) $i = 0;
      }
      else
         break;
           
    }while($i != 0);
   
    $Rtn = $t;
    Switch($i)
    {
       Case 0: $t = $this->Void;break;
       Case 1: $t = " Mil";break;
       Case 2: $t = " Millones";break;
       Case 3: $t = " Billones";break;
    }
    return($Rtn . $t);
}

}

///////////////////////////////////////////////////////////////////////////
function limpiarCaracteresEspeciales($string)
{
  $especiales = array("/", "\\", "&", "(", ")", "'", ";", "*", "[", "]");
  $string = htmlentities($string);
  $string2 = str_replace($especiales , " " , $string);
  return $string2;
}

  ////////////////////////////////////////////////////////////////////////////////////////  
  ////////////////////////////////////////////////////////////////////////////////////////  
  function DuplicarBorrarDocumento($docuid)
  {
     $id=0;
     $clase = new Sistema();
     $clase->Nombredb = $_SESSION['DBNOMBRE']; 
     
     //// Encabezado de la Factura
     $vsql = "SELECT * FROM documentos WHERE docuid =".$docuid;   
     $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex); 
     if($row = mysql_fetch_array($result)) 
     {
        $conse = $van+1;
        $numero = $row['numero']."-".rand(11,99);
        $referencia = "";

        $vsqlx = "INSERT INTO documentos2(tipodoc,prefijo,numero,periodo,fechadoc,terid1,terid2,terid3,nrodocref,observacion,sucursalid,creador,momento) VALUES('".$row['tipodoc']."','".
                  $row['prefijo']."','".$numero."','".$row['periodo']."','".$row['fechadoc']."','".$row['terid1']."','".$row['terid2']."','".$row['terid3']."','".
                  $referencia."','".$row['observacion']."','".$row['sucursalid']."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";

        $id = $clase->EjecutarSQL($vsqlx);
        $NDocuid = $clase->SeleccionarUno("SELECT docuid FROM documentos2 WHERE tipodoc='".$row['tipodoc']."' AND prefijo='".$row['prefijo']."' AND numero='".substr($numero,0,8)."' ORDER BY momento DESC limit 0,1");

        //// Totalizo los valores de la Compra
        $clase->EjecutarSQL("PA_CalValoresFVE(".$NDocuid.")");
     }   

     /// Busco los detalles de Documentos para copiarlos
     $vsql = "SELECT * FROM dedocumentos WHERE docuid =".$docuid;
     $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex); 
     while($row = mysql_fetch_array($result)) 
     {
          $vsqly = "INSERT INTO dedocumentos2(docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal,diasrecor,numlinea,unicom,unifra) values(".
                    $NDocuid.",'".$row['productoid']."','".$row['bodegaid']."','".$row['cantidad']."','".$row['unidades']."','".$row['tipund']."','".$row['costoprod']."','".$row['valunitario']."','".
                    $row['valdescuento']."','".$row['valparcial']."','".$row['porciva']."','".$row['valbase']."','".$row['valiva']."','".$row['valtotal']."','".$row['diasrecor']."',0,'".
                    $row['unicom']."','".$row['unifra']."')";   
          $clase->EjecutarSQL($vsqly);  
     }
     return($NDocuid);
  }

  /////////////////////////////////////////////////////////////////////////////////
  //// Compras Tesoreria - Genera la Trazabilidad del Proceso de Pagos con 
  /////////////////////////////////////////////////////////////////////////////////   
  function CrearTrazabilidadPagos($docuid)
  {
      $clase  = new Sistema();
	  $conex  = $clase->Conectar();
	  $vsql   = "SELECT * FROM documentos WHERE docuid=".$docuid; 
      $result = @mysql_query($vsql,$conex);
  	  if($row = @mysql_fetch_array($result)) 
  	  {
  	     $tipodoc      = $row['tipodoc'];
  	     $prefijo      = $row['prefijo'];
		 $numero       = $row['numero'];	
		 $total        = $row['total'];	  
 	  }
      
	  $vsqlx = "INSERT IGNORE INTO trazabilidadpagos(docuidcompra,numcompra,valorcompra,saldocompra) VALUES('".$docuid."','".$tipodoc.$prefijo.$numero."','".$total."','".$total."')"; 
	  $clase->EjecutarSQL($vsqlx); 
	  return;
  }

  /////////////////////////////////////////////////////////////////////////////////
  //// Tesoreria - Generar Compra a Cuentas por Pagar
  /////////////////////////////////////////////////////////////////////////////////   
  function GenerarTesoreria($docuid)
  {
      $clase  = new Sistema();
      $conex  = $clase->Conectar();
	  $vsql   = "SELECT DCC.dcto1 , DATE_ADD(DCC.fechallegada,INTERVAL DCC.diascartera day) fecvencex , S.codigo codsucursal , D.* 
	  		     FROM documentos D INNER JOIN docucompra DCC ON (D.docuid = DCC.docuid) 
			     INNER JOIN sucursales S ON (S.sucursalid = D.sucursalid)
			 	 WHERE D.tipodoc = 'FCO' AND D.formapago = 'CR' AND D.fecasentado <> '0000-00-00' AND D.docuid=".$docuid; 
      $result = @mysql_query($vsql,$conex);
  	  if($row = @mysql_fetch_array($result)) 
  	  {
  	     $descuento    = $row['dcto1'];
         $tipodoc      = $row['tipodoc'];
  	     $prefijo      = $row['prefijo'];
		 $numero       = $row['numero'];	
		 $observ2      = $row['observacion2'];	  
  	     $fechadoc     = $row['fechallegada'];	
  	     if($fechadoc == "")
  	        $fechadoc  = $row['fechadoc'];		 

  	     $fecvence     = $row['fecvencex'];	
  	     $fecasentado  = $row['fecasentado'];
  	     $terid1       = $row['terid1'];
         
  	     $periodo      = $row['periodo'];
  	     $nrodocref    = $row['tipodoc'].$row['prefijo'].$row['numero'];

  	     $retefuente   = 0+$row['retefuente'];
  	     $impoconsumo  = 0+$row['impoconsumo'];
 	     $ibua         = 0+$row['ibua'];
		 $icui         = 0+$row['icui'];
		 $reteica      = 0+$row['reteica'];
		 $reteiva      = 0+$row['reteiva'];
  	     
		 $base         = $row['base']+$row['ajustebase'];
  	     $iva          = $row['iva']+$row['ajusteiva'];
  	     $total        = ($base+$iva-$retefuente+$ibua+$icui+$impoconsumo);

  	     $sucursalid   = $row['sucursalid'];			     
  	     $creador      = $row['creador'];	
         $nrodocrefFCO = $row['nrodocref'];		     
   
  	     $observ      = "Factura de Compra No. ".$tipodoc." ".$prefijo." ".$numero." - Num Prov. ".$row['nrodocref']." ";


		 //// SD 30 12 2021  -  La Fecha de Vencimiento del CXC está mal calculada y queda igual a la Fecha de Emision   
		 //// Valido si la Fecha de Vencimiento que tiene (Erronea) es igual a la Fecha del Documento entonces tome el otro campo FECVENCE
		 if($fechadoc == $fecvence)
		   $fecvence = $row['fecvence'];
      }

      /// Borro el Registro Anterior
      /// 1. Elimino los registros Existentes 
      /// Borro el Registro Anterior
      $vsql2 = "SELECT docuid FROM documentos WHERE tipodoc = 'CXP' AND prefijo = '".$prefijo."' AND numero = '".$numero."'";
      $DOCUIDXDEL = $clase->SeleccionarUno($vsql2);
      $vsql2 = "DELETE FROM dedocucuenta WHERE docuid=".$DOCUIDXDEL;
      $clase->EjecutarSQL($vsql2);      
      $vsql2 = "DELETE FROM documentos WHERE docuid=".$DOCUIDXDEL;
      $clase->EjecutarSQL($vsql2);      

      /// Inserto el Documento de Tesoreria
      $vsql3 = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,fecvence,formapago,importado,retefuente,observacion,observacion2,nrodocref,descuentogen,
	            terid1,reteica,reteiva,impoconsumo,ibua,icui,base,iva,total,saldo,sucursalid,documentojson,creador,momento) 
                VALUES('CXP','".$prefijo."','".$numero."','".$periodo."','".$fechadoc."','".$fecasentado."','".$fecvence."','CR','S',".$retefuente.",'".$observ."','".$nrodocrefFCO."','".$nrodocref."',".$descuento.",
				".$terid1.",".$reteica.",".$reteiva.",'".$impoconsumo."','".$ibua."','".$icui."','".$base."','".$iva."','".$total."','".$total."',".$sucursalid.",'".$observ2."','".$creador."',CURRENT_TIMESTAMP)"; 
      $clase->EjecutarSQL($vsql3);      

      /// Busco el Docuid Insertado
      $NDOCUIDX = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'CXP' AND prefijo = '".$prefijo."' AND numero = '".$numero."'");      
      
      /// Inserto el Detalle del Concepto
      $vsql3 = "INSERT INTO dedocucuenta(docuid,concid,item,valor,interes,capital,valorini,saldo,doculpago,feculpago,teridpago,detalle,fecvence,nrodocref) 
                VALUES(".$NDOCUIDX.",1,'001',".$total.",0,".$total.",".$total.",".$total.",'','0000-00-00',1,'".$nrodocref."','".$fecvence."','".$nrodocref."')"; 
     
      $clase->EjecutarSQL($vsql3);   

      /// Actualizo la Trazabilidad
	  $vsql4 = "UPDATE trazabilidadpagos SET docuidcxp = ".$NDOCUIDX." , numcxp = 'CXP".$prefijo.$numero."' , valorcxp = ".$total." , saldocxp  = ".$total." WHERE docuidcompra = ".$docuid;
      $clase->EjecutarSQL($vsql4);      
      
	  return;
   }
  
  /////////////////////////////////////////////////////////////////////////////////
  //// Cartera - Generar Venta a Cuentas por Cobrar
  /////////////////////////////////////////////////////////////////////////////////   
  function GenerarCartera($docuid)
  {
      $clase  = new Sistema();
      $conex  = $clase->Conectar();
	  $vsql   = "SELECT * 
	             FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
                 WHERE D.tipodoc = 'FVE' AND D.formapago = 'CR' AND D.fecasentado <> '0000-00-00' AND D.docuid=".$docuid; 
      $result = @mysql_query($vsql,$conex);
  	  if($row = @mysql_fetch_array($result)) 
  	  {
  	     $descuento    = $row['dcto1'];
         $tipodoc      = $row['tipodoc'];
  	     $prefijo      = $row['prefijo'];
  	     $numero       = $row['numero'];	
  	     $fechadoc     = $row['fechadoc'];		 
  	     $terid1       = $row['terid1'];
		 $dias         = $clase->BDLockup($terid1,"terceros","terid","diascxc");	 

		 $fecvence     = $clase->SeleccionarUno("SELECT SUBSTRING(DATE_ADD('".$fechadoc."',INTERVAL ".$dias." DAY),1,10)");	
		 $fecvence     = substr($fecvence,0,10);
		   
		 $fecasentado  = $row['fecasentado'];
         
  	     $periodo      = $row['periodo'];
  	     $nrodocref    = $row['tipodoc'].$row['prefijo'].$row['numero'];
  	     $base         = round($row['base']+$row['ajustebase']);
       
  	     $iva          = round($row['iva']+$row['ajusteiva']);
  	     $retefuente   = round($valrf);
  	     $total        = round($base+$iva-$retefuente);
  	     $sucursalid   = $row['sucursalid'];			     
  	     $creador      = $row['creador'];	
         $nrodocrefFCO = $row['tipodoc'].$row['prefijo'].$row['numero'];		     
         $nrodocref    = $row['tipodoc'].$row['prefijo'].$row['numero'];		     
         $descuento    = 0;         
         $retefuente   = 0;         
   
  	     $observ   = "Factura de Venta No. ".$tipodoc." ".$prefijo." ".$numero." ";
      }

      /// Borro el Registro Anterior
      /// 1. Elimino los registros Existentes 
      /// Borro el Registro Anterior
      $vsql2 = "SELECT docuid FROM documentos WHERE tipodoc = 'CXC' AND prefijo = '".$prefijo."' AND numero = '".$numero."'";
      $DOCUIDXDEL = $clase->SeleccionarUno($vsql2);
      $vsql2 = "DELETE FROM dedocucuenta WHERE docuid=".$DOCUIDXDEL;
      $clase->EjecutarSQL($vsql2);      
      $vsql2 = "DELETE FROM documentos WHERE docuid=".$DOCUIDXDEL;
      $clase->EjecutarSQL($vsql2);      

      /// Inserto el Documento de Tesoreria
      $vsql3 = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,fecvence,formapago,importado,retefuente,observacion,observacion2,nrodocref,descuentogen,terid1,base,iva,total,saldo,sucursalid,creador,momento) 
                VALUES('CXC','".$prefijo."','".$numero."','".$periodo."','".$fechadoc."','".$fecasentado."','".$fecvence."','CR','S',".$retefuente.",'".$observ."','".$nrodocrefFCO."','".$nrodocref."',".$descuento.",".$terid1.",".$base.",".$iva.",".$total.",".$total.",".$sucursalid.",'".$creador."',
                CURRENT_TIMESTAMP)"; 
      $clase->EjecutarSQL($vsql3);      

	  //echo $vsql3."<br>";

      /// Busco el Docuid Insertado
      $NDOCUIDX = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'CXC' AND prefijo = '".$prefijo."' AND numero = '".$numero."'");      
      
      /// Inserto el Detalle del Concepto
      $vsql3 = "INSERT INTO dedocucuenta(docuid,concid,item,valor,interes,capital,valorini,saldo,doculpago,feculpago,teridpago,detalle,fecvence,nrodocref) 
                VALUES(".$NDOCUIDX.",1,'001',".$total.",0,".$total.",".$total.",".$total.",'','0000-00-00',1,'".$nrodocref."','".$fecvence."','".$nrodocref."')"; 
	  $clase->EjecutarSQL($vsql3);   
	  
	  /// Le arreglo los dias de Vencimiento al Documento Factura de Venta 
	  $clase->EjecutarSQL("UPDATE documentos SET fecvence = '".$fecvence."' WHERE docuid = ".$docuid);
   }

  /////////////////////////////////////////////////////////////////////////////////
  //// Cartera - Generar Venta a Cuentas por Cobrar
  /////////////////////////////////////////////////////////////////////////////////   
  function GenerarCarteraDIPIN($docuid)
  {
      $clase  = new Sistema();
      $conex  = $clase->Conectar();
	  $vsql   = "SELECT * 
	             FROM documentos D INNER JOIN docuventa DV ON (D.docuid = Dv.docuid) 
                 WHERE D.tipodoc = 'FEC' AND D.prefijo = 'DPIN' AND D.formapago = 'CR' AND D.fecasentado <> '0000-00-00' AND D.docuid=".$docuid; 
      $result = @mysql_query($vsql,$conex);
  	  if($row = @mysql_fetch_array($result)) 
  	  {
  	     $descuento    = $row['dcto1'];
         $tipodoc      = $row['tipodoc'];
  	     $prefijo      = $row['prefijo'];
  	     $numero       = $row['numero'];	
  	     $fechadoc     = $row['fechadoc'];		 
  	     $terid1       = $row['terid1'];
		 $dias         = $clase->BDLockup($terid1,"terceros","terid","diascxc");	 

		 $fecvence     = $clase->SeleccionarUno("SELECT SUBSTRING(DATE_ADD('".$fechadoc."',INTERVAL ".$dias." DAY),1,10)");	
		 $fecvence     = substr($fecvence,0,10);
		   
		 $fecasentado  = $row['fecasentado'];
         
  	     $periodo      = $row['periodo'];
  	     $nrodocref    = $row['tipodoc'].$row['prefijo'].$row['numero'];
  	     $base         = $row['base']+$row['ajustebase'];
       
  	     $iva          = $row['iva']+$row['ajusteiva'];
  	     $retefuente   = $valrf;
  	     $total        = ($base+$iva-$retefuente);
  	     $sucursalid   = $row['sucursalid'];			     
  	     $creador      = $row['creador'];	
         $nrodocrefFCO = $row['tipodoc'].$row['prefijo'].$row['numero'];		     
         $nrodocref    = $row['tipodoc'].$row['prefijo'].$row['numero'];		     
         $descuento    = 0;         
         $retefuente   = 0;         
   
  	     $observ   = "Factura de Venta No. ".$tipodoc." ".$prefijo." ".$numero." ";
      }

      /// Borro el Registro Anterior
      /// 1. Elimino los registros Existentes 
      /// Borro el Registro Anterior
      $vsql2 = "SELECT docuid FROM documentos WHERE tipodoc = 'CXC' AND prefijo = '".$prefijo."' AND numero = '".$numero."'";
      $DOCUIDXDEL = $clase->SeleccionarUno($vsql2);
      $vsql2 = "DELETE FROM dedocucuenta WHERE docuid=".$DOCUIDXDEL;
      $clase->EjecutarSQL($vsql2);      
      $vsql2 = "DELETE FROM documentos WHERE docuid=".$DOCUIDXDEL;
      $clase->EjecutarSQL($vsql2);      

      /// Inserto el Documento de Tesoreria
      $vsql3 = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,fecvence,formapago,importado,retefuente,observacion,observacion2,nrodocref,descuentogen,terid1,base,iva,total,saldo,sucursalid,creador,momento) 
                VALUES('CXC','".$prefijo."','".$numero."','".$periodo."','".$fechadoc."','".$fecasentado."','".$fecvence."','CR','S',".$retefuente.",'".$observ."','".$nrodocrefFCO."','".$nrodocref."',".$descuento.",".$terid1.",".$base.",".$iva.",".$total.",".$total.",".$sucursalid.",'".$creador."',
                CURRENT_TIMESTAMP)"; 
      $clase->EjecutarSQL($vsql3);      

      /// Busco el Docuid Insertado
      $NDOCUIDX = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'CXC' AND prefijo = '".$prefijo."' AND numero = '".$numero."'");      
      
      /// Inserto el Detalle del Concepto
      $vsql3 = "INSERT INTO dedocucuenta(docuid,concid,item,valor,interes,capital,valorini,saldo,doculpago,feculpago,teridpago,detalle,fecvence,nrodocref) 
                VALUES(".$NDOCUIDX.",1,'001',".$total.",0,".$total.",".$total.",".$total.",'','0000-00-00',1,'".$nrodocref."','".$fecvence."','".$nrodocref."')"; 
	  $clase->EjecutarSQL($vsql3);   
	  
	  /// Le arreglo los dias de Vencimiento al Documento Factura de Venta 
	  $clase->EjecutarSQL("UPDATE documentos SET fecvence = '".$fecvence."' WHERE docuid = ".$docuid);
   }

   /////////////////////////////////////////////////////////////////////////////////
   //// Cartera - Generar Venta a Cuentas por Cobrar
   /////////////////////////////////////////////////////////////////////////////////   
   function GenerarNotificaciones($notificacionid)
   {
      $clase    = new Sistema();
	  $tiponoti = $clase->BDLockup($notificacionid,'notificaciones','notificacionid','tiponotificacion');
	  $vsql     = "SELECT usuario FROM destinostiponoti WHERE codtiponoti = '".$tiponoti."'";
	  
      $conex  = $clase->Conectar();
      $result = @mysql_query($vsql,$conex);
  	  while($row = @mysql_fetch_array($result)) 
  	  {
	     echo $row['usuario']."<br>";
	  }
   }			 
	 
  ////////////////////////////////////////////////////////////////////////////////////////////////////////
  //   Actualiza los campos en Producto Self con los datos de la consulta Febrero 18 2020
  ////////////////////////////////////////////////////////////////////////////////////////////////////////  
  function ActualizaDatosEspeciales($productoid = 0,$docuid = 0,$solotransito=0)     /// Rediseñada 18 Feb 2020
  {
	 /*	
	    $clase = new Sistema();
		
		//// Si es Solo un producto
		if(($productoid != 0)&&($docuid == 0))
		{
			$codigo = $clase->BDLockup($productoid,"productos","productoid","codigo");
			
			/// Ejecuto los 2 Procedures que calculan el Transito - Rotacion por Region
			/// y las Existencias por Region
			$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones2(".$productoid.",'".$codigo."')");           /// Esto hace Division de Rotaciones
			$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones3(".$productoid.",'".$codigo."')");           /// Esto hace Division de Existencias 
			$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones4(".$productoid.")");                         /// Esto hace Division de Transito 
		}	

		//// Si es un Documento Completo
		if(($productoid == 0)&&($docuid != 0))
		{
			///// Enero 4 2019
			$vsqles = "SELECT DISTINCT P.productoid , P.codigo FROM dedocumentos DD INNER JOIN productos P ON (DD.productoid = P.productoid) WHERE DD.docuid = ".$docuid;
			$conex  = $clase->Conectar();
			$result = @mysql_query($vsqles,$conex);
			while($row = @mysql_fetch_array($result))
			{
				/// Ejecuto los 2 Procedures que calculan el Transito - Rotacion por Region
				/// y las Existencias por Region
			
				if($solotransito == 1)
				    $clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones4(".$row['productoid'].")");                                /// Esto hace Division de Transito 	
				else
				{
					$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones2(".$row['productoid'].",'".$row['codigo']."')");           /// Esto hace Division de Rotaciones
					$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones3(".$row['productoid'].",'".$row['codigo']."')");           /// Esto hace Division de Existencias 
					$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones4(".$row['productoid'].")");                                /// Esto hace Division de Transito 
				}
				
			}	
			$clase->EjecutarSQL("CALL PA_CalValoresGen(".$docuid.")");	   
		}    
	*/
	return;
  }

  ////////////////////////////////////////////////////////////////////////////////////////////////////////
  //   Actualiza los campos en Producto Self con los datos de la consulta Febrero 18 2020
  ////////////////////////////////////////////////////////////////////////////////////////////////////////  
  function ActualizaDatosEspecialesDocumento($productoid = 0,$docuid = 0,$solotransito=0)     /// Rediseñada 18 Feb 2020
  {
		$clase = new Sistema();
		
		//// Si es un Documento Completo
		if(($productoid == 0)&&($docuid != 0))
		{
			///// Enero 4 2019
			$vsqles = "SELECT DISTINCT P.productoid , P.codigo FROM dedocumentos DD INNER JOIN productos P ON (DD.productoid = P.productoid) WHERE DD.docuid = ".$docuid;
			$conex  = $clase->Conectar();
			$result = @mysql_query($vsqles,$conex);
			while($row = @mysql_fetch_array($result))
			{
				/// Ejecuto los 2 Procedures que calculan el Transito - Rotacion por Region
				/// y las Existencias por Region
			
				if($solotransito == 1)
				    $clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones4(".$row['productoid'].")");                                /// Esto hace Division de Transito 	
				else
				{
					/*
					$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones2(".$row['productoid'].",'".$row['codigo']."')");           /// Esto hace Division de Rotaciones
					$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones3(".$row['productoid'].",'".$row['codigo']."')");           /// Esto hace Division de Existencias 
					$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones4(".$row['productoid'].")");                                /// Esto hace Division de Transito 
					*/
				}
				
			}	
			$clase->EjecutarSQL("CALL PA_CalValoresGen(".$docuid.")");	   
		}    
	
	return;
  }


   ////////////////////////////////////////////////////////////////////////////////////////////////////////
  //   Actualiza los campos en Producto Self con los datos de la consulta - Depreciada 18 Feb 2020
  ////////////////////////////////////////////////////////////////////////////////////////////////////////  
  function ActualizaDatosEspecialesAntigua($productoid = 0,$docuid = 0)
  {
    $clase = new Sistema();
    if(($productoid != 0)&&($docuid == 0))
    {
       $vsqles = "SELECT P.productoid , P.codigo , P.rota30dias , P.rota60dias , P.rota90dias , P.rota100dias , SUM(E.cantidad) existencia , SUM(IF(B.tipobodega = 'PVE',E.cantidad,0)) exisuc , SUM(IF(B.tipobodega = 'DEP',E.cantidad,0)) exidepo , 
                  FU_TransitoCompras(P.productoid) transito , FU_Rotacion30dias(P.productoid) rotacion , FU_Rotacion30diasregion(P.productoid,'01') rotacion 
                  FROM productos P INNER JOIN existencias E ON (P.productoid = E.productoid)
                  INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid)
                  WHERE P.productoid = ".$productoid." AND E.bodegaid <> 27";
    }
    
    if(($productoid == 0)&&($docuid != 0))
    {
		  ///// Enero 4 2019
		  $vsqles = "SELECT DISTINCT P.productoid , P.codigo , P.rota30dias , P.rota60dias , P.rota90dias , P.rota100dias , SUM(E.cantidad) existencia , SUM(IF(B.tipobodega = 'PVE',E.cantidad,0)) exisuc , SUM(IF(B.tipobodega = 'DEP',E.cantidad,0)) exidepo , 
			    		   FU_TransitoCompras(P.productoid) transito , ROUND(FU_Rotacion30dias(P.productoid)) rotacion 
								 FROM productos P INNER JOIN existencias E ON (P.productoid = E.productoid)
								 INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid)
								 INNER JOIN dedocumentos DD ON (DD.productoid = P.productoid)
								 WHERE DD.docuid = ".$docuid." AND E.bodegaid <> 27 GROUP BY 1,2,3,4,5,6";
	}
	
    $conex  = $clase->Conectar();
    $result = @mysql_query($vsqles,$conex);
    while($row = @mysql_fetch_array($result))
    {
   	   //// Calculo la rotacion
       $rota   = 0 + $row['rota30dias'];
       if($row['rota60dias']>$rota)     $rota = $row['rota60dias'];
       if($row['rota90dias']>$rota)     $rota = $row['rota90dias'];
       if($row['rota100dias']>$rota)    $rota = $row['rota100dias'];

       $tran   = 0+$row['transito'];
       $exis   = 0+$row['existencia'];
       $exidep = 0+$row['exidepo'];
       $exisuc = 0+$row['exisuc'];
	   
			///// Aqui decido si Elimino - Inserto o si sólo Actualizo
			///// ELiminar Insertar - Es más lento pero necesario si el producto hace 1 dia no se ha actualizado
			///// Actualizar sólo actualiza el Transito

			/// Elimino el registro
			$clase->EjecutarSQL("DELETE FROM productoself WHERE productoid = ".$row['productoid']);           

			/// Lo Actualizo con la nueva informacion
			$vsqlx = "INSERT INTO productoself(productoid,rotacion30,transito,transitonorte,existotal,exidepo,exisuc) VALUES(".$row['productoid'].",".$rota.",".$tran.",".$tran.",".$exis.",".$exidep.",".$exisuc.")";
			$clase->EjecutarSQL($vsqlx);           

			/// Ejecuto los 2 Procedures que calculan el Transito - Rotacion por Region
			/// y las Existencias por Region
			/*
			$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones1(".$row['productoid'].")");                                 /// Esto hace Division de Rotaciones
			$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones2(".$row['productoid'].",'".$row['codigo']."')");           /// Esto hace Division de Rotaciones
			$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones3(".$row['productoid'].",'".$row['codigo']."')");           /// Esto hace Division de Existencias 
			$clase->EjecutarSQL("CALL PA_SectorizarRotacionRegiones4(".$row['productoid'].")");                                /// Esto hace Division de Transito 
			*/

    }     

    if($docuid != 0)
        $clase->EjecutarSQL("CALL PA_CalValoresGen(".$docuid.")");
  
	return;
  }

  /////////////////////////////////////////////////////////////////
  //// Envia un Mensaje SMS a un Numero Celular de 10 Digitos
  /////////////////////////////////////////////////////////////////
  function EnviarSMS($numero,$mensaje)
  {
			if(strlen($numero) == 10)
			{
				$numero  = '57'.$numero;
					$mensaje = str_replace(" ","%20",$mensaje);
				$json = file_get_contents('https://api.hablame.co/sms/envio/?api=mZG8Sorrrm5hXuQrYCPliyzUdrt808&cliente=10011843&numero='.$numero.'&sms='.$mensaje."&referencia=pruebas");   
				$data = json_decode($json,true);
				return(1);
			}
			else 
				return(0);		
  }


	/////////////////////////////////////////////////////////////////
	////  Generar Codigo QR DIAN - Si el Cufe
	/////////////////////////////////////////////////////////////////
	function GenerarCodigoQRDianCufe($docuid,$cufe)
	{
		 $clase = new Sistema();
		 $datoscompletos = 0;
		 if($cufe == "")
		 {
				//// 1. Intento
				$cufe = $clase->SeleccionarUno("SELECT cufe FROM docuventa WHERE docuid = ".$docuid);
				if(strlen($cufe) > 0)  
			 	  $datoscompletos++; 
				else
				  sleep(3);

				//// 2. Intento   
				if($datoscompletos == 0)
				{
					$cufe = $clase->SeleccionarUno("SELECT cufe FROM docuventa WHERE docuid = ".$docuid);
					if(strlen($cufe) > 0)  
					  $datoscompletos++; 
					else
					  sleep(3);
				}

				//// 3. Intento   
				if($datoscompletos == 0)
				{
					$cufe = $clase->SeleccionarUno("SELECT cufe FROM docuventa WHERE docuid = ".$docuid);
					if(strlen($cufe) > 0)  
				  	  $datoscompletos++; 
					else
					  sleep(3);
				}
		 } 

		 if(($docuid != "")&&($cufe != ""))
		 {
			 // Incluir la librería phpqrcode
			 include 'lib/phpqrcode/qrlib.php';
 			 
			 // Datos para el código QR (puedes cambiar esto)
			 $data = 'https://catalogo-vpfe.dian.gov.co/User/SearchDocument?DocumentKey='.$cufe;
 
			 // Nombre del archivo de imagen PNG
			 $filename = 'temp/codigoqrdianfactura_'.$docuid.'.png';
 
			 /// Borro el QR existente por si existe
             @unlink($filename);

			 // Ruta completa donde se guardará la imagen
			 $filepath = __DIR__ . '/' . $filename;
 
			 // Nivel de corrección de errores (L, M, Q, H)
			 $level = 'L';
 
			 // Tamaño del módulo (píxeles por cuadro)
			 $size = 10;
 
			 // Margen (cuadros en blanco alrededor del código)
			 $margin = 2;
 
			 // Generar el código QR y guardarlo en disco
			 QRcode::png($data, $filepath, $level, $size, $margin);

			 echo"Generado";
		 }  
	} 
  
    ////////////////////////////////////////////////////////////////////////////////////
	//// Descargar Configuracion de Sucursal
	///////////////////////////////////////////////////////////////////////////////////  
	function DescargarConfiguracionSucursal()
	{
		$clase = new Sistema();

		//$URLSERVIDOR = "http://192.168.14.244:9999";
		$URLSERVIDOR = "http://dromedicas.sytes.net:9999";
		$json = file_get_contents($URLSERVIDOR.'/dropos/wsjson/consolida/datasucursal.php?codsucursal='.$_SESSION['G_SUCURSALPOS']); 
		$data = json_decode($json);

		$detalles = ""; $i = 0; $totalacum = 0;
		$pedidoactual = "";
		if(@$data[$i]->sucursalid != "")
		{
			$vsql = "UPDATE sucursales SET statuscierredef = '".$data[$i]->statuscierredef."' , statuspedsug = '".$data[$i]->statuspedsug."' , statuspedurg = '".$data[$i]->statuspedurg."' ,
			         statuspedlic = '".$data[$i]->statuspedlic."' , statuspedref = '".$data[$i]->statuspedref."' , statuspedcon = '".$data[$i]->statuspedcon."' ,
			         statuspedsin = '".$data[$i]->statuspedsin."' WHERE sucursalid = ".$data[$i]->sucursalid;
			//echo $vsql;		 
		    $clase->EjecutarSQL($vsql);
		}
	    	
        return;
	}

   
  /////////////////////////////////////////////////////////////////
  //// Envia un Mensaje SMS a un Numero Celular de 10 Digitos
  /////////////////////////////////////////////////////////////////  
  function TiqueteRifa($nombre, $telefono , $direccion, $sucursal)
  {
	$cont = Chr(13).Chr(10);   
	$cont = '----------------------------------------------'.Chr(13).Chr(10);  
	$cont.= '--  G R A N   R I F A   D E  L A  BICICLETA --'.Chr(13).Chr(10);   
	$cont.= '----------------------------------------------'.Chr(13).Chr(10);   
	$cont.= ' NOMBRE    : '.$nombre.Chr(13).Chr(10);	      
	$cont.= ' TELEFONO  : '.$telefono.Chr(13).Chr(10);	      
	$cont.= ' DIRECCION : '.$direccion.Chr(13).Chr(10);	      
	$cont.= ' SUCURSAL  : '.$sucursal.Chr(13).Chr(10);	      
	$cont.= '----------------------------------------------'.Chr(13).Chr(10).Chr(13).Chr(10);   
	$cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D".Chr(13).Chr(10);  

	$archivo= "print/tirarifa.txt"; // el nombre de tu archivo
	$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
	fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
	fclose($fch); // Cierras el archivo
  }


  /////////////////////////////////////////////////////////////////
  //// Envia un Mensaje SMS a un Numero Celular de 10 Digitos
  /////////////////////////////////////////////////////////////////  
  function TiqueteRifaAux($nombre, $telefono , $direccion, $sucursal)
  {
	$cont = Chr(13).Chr(10);   
	$cont = '----------------------------------------------'.Chr(13).Chr(10);  
	$cont.= '--  G R A N   R I F A   D E  L A  LICUADORA --'.Chr(13).Chr(10);   
	$cont.= '----------------------------------------------'.Chr(13).Chr(10);   
	$cont.= ' NOMBRE    : '.$nombre.Chr(13).Chr(10);	      
	$cont.= ' TELEFONO  : '.$telefono.Chr(13).Chr(10);	      
	$cont.= ' DIRECCION : '.$direccion.Chr(13).Chr(10);	      
	$cont.= ' SUCURSAL  : '.$sucursal.Chr(13).Chr(10);	      
	$cont.= '----------------------------------------------'.Chr(13).Chr(10).Chr(13).Chr(10);   
	$cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D".Chr(13).Chr(10);  

	$archivo= "print/tirarifa.txt"; // el nombre de tu archivo
	$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
	fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
	fclose($fch); // Cierras el archivo
  }

  ////////////////////////////////////////////////////////////////
  //// Envia un Mensaje SMS a un Numero Celular de 10 Digitos
  /////////////////////////////////////////////////////////////////  
  function TiqueteRifa2($nombre = "" , $telefono = "" , $direccion = "" , $sucursal = "")
  {
	$cont = Chr(13).Chr(10);   
	$cont = '----------------------------------------------'.Chr(13).Chr(10);   
	$cont.= '-- G R A N   R I F A   F A R M A N O R T E  --'.Chr(13).Chr(10);   
	$cont.= '----------------------------------------------'.Chr(13).Chr(10);   
	$cont.= ' NOMBRE    : '.$nombre.Chr(13).Chr(10);	      
	$cont.= ' TELEFONO  : '.$telefono.Chr(13).Chr(10);	      
	$cont.= ' DIRECCION : '.$direccion.Chr(13).Chr(10);	      
	$cont.= ' SUCURSAL  : '.$sucursal.Chr(13).Chr(10);	      
	$cont.= ' CUMPLEANOS :  ______ / ________ / ________  '.Chr(13).Chr(10);	      
	$cont.= ' E-MAIL :  _________________________________  '.Chr(13).Chr(10);	      
	$cont.= '----------------------------------------------'.Chr(13).Chr(10).Chr(13).Chr(10);   
	$cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D".Chr(13).Chr(10);  

	$archivo= "print/tirarifa.txt"; // el nombre de tu archivo
	$fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
	fwrite($fch,Chr(13).Chr(10).$cont); // Grabas
	fclose($fch); // Cierras el archivo
  }
    //////////////////////////////////////////////////////////////////////////////////////
	//// Calcula los productos mas vendidos en el Ultimo mes calendario - Ranking Local
	//////////////////////////////////////////////////////////////////////////////////////
	function RankingProductos()
	{
		$clase = new Sistema();

		/// Primero Limpio la tabla
		$clase->EjecutarSQL("TRUNCATE rankingsucursal");

		/// Calculo el Ranking
		$vsql = "SELECT productoid , SUM(abs(cantidad)) venta , 
		         (SELECT cantidad FROM existencias E INNER JOIN bodegas B ON (E.bodegaid = B.bodegaid) WHERE E.productoid = K.productoid AND B.codbodega = '".$_SESSION['G_SUCURSALPOS']."') existencia 
		         FROM kardex K WHERE tipodoc = 'FVE' AND fechadoc BETWEEN DATE_SUB(NOW(), INTERVAL 30 DAY) AND NOW() GROUP BY 1 ORDER BY 2 DESC LIMIT 0,1500";
		$conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 1; 
        while($row = mysql_fetch_array($result)) 
	    {
		   /// Calculo los dias
		   $dias = 0+(($row['existencia']*30)/$row['venta']);

		   /// Registro el Valor
		   $vsqlx = "INSERT INTO rankingsucursal(productoid,sucursal,posranking,exilocal,diasinventario,r30local) VALUES(".$row['productoid'].",'".$_SESSION['G_SUCURSALPOS']."',".$i.",".$row['existencia'].",".$dias.",".$row['venta'].")";
           $clase->EjecutarSQL($vsqlx); 

		   $i++;
		}  
		return;
	}

	//////////////////////////////////////////////////////////////////////////////////////
	//// Pasa a Cero las Existencias de Productos que tienen un sobrante mayor a cero
	//// @saidrodriguezc 26/11/2019 
	//////////////////////////////////////////////////////////////////////////////////////
	function AproximarExistenciasCero()
	{
		$clase = new Sistema();
		$bodegaid = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],'bodegas','codbodega','bodegaid');

		/// Busco los productos con problema
		$vsql = "SELECT P.productoid, ROUND( ( 1 / factor1 ) , 4 ) unaunidad, ROUND( ABS( E.cantidad ) , 4 ) exiactual
		         FROM existencias E INNER JOIN productos P ON ( E.productoid = P.productoid	AND E.bodegaid = ".$bodegaid." ) 
		         WHERE P.factor1 >1 AND ABS( E.cantidad ) >0 AND ABS( E.cantidad ) < ( 1 / factor1 ) HAVING exiactual < unaunidad";
		$conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $i = 1; 
        while($row = mysql_fetch_array($result)) 
	    {
		   /// Lo llevo a cero
		   $vsqlx = "UPDATE existencias SET cantidad  = 0 WHERE productoid = ".$row['productoid']." AND bodegaid = ".$bodegaid;
           $clase->EjecutarSQL($vsqlx); 
		}  
		return;
	}

   ///////////////////////////////////////////////////////////////////////  
   ///////////////////////////////////////////////////////////////////////  
   function DiasDelMes($mes)
   {
      $numero = intval($mes);
      if(($numero == 1)||($numero == 3)||($numero == 5)||($numero == 7)||($numero == 8)||($numero == 10)||($numero == 12))
        return(31);
      if(($numero == 4)||($numero == 6)||($numero == 9)||($numero == 11))
        return(30);

	  $anohoy = date("Y");
      if($numero == 2)
	  {
		  if(($anohoy == 2024)||($anohoy == 2028))
		     return(29);
	      else
		     return(28);		
	  }	     
	}

   ///////////////////////////////////////////////////////////////////////  
   //////////////////////////////////////////////////////////////////////  
   function DiasDelaSemana($dia)
   {
      if($dia == 1) return("Lunes");
	  if($dia == 2) return("Martes");
	  if($dia == 3) return("Miercoles");
	  if($dia == 4) return("Jueves");
	  if($dia == 5) return("Viernes");
	  if($dia == 6) return("Sabado");
	  if($dia == 7) return("Domingo");
	}

	/////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////
	function ImprimirTiquetsPendientes()
	{
		if($_SESSION['G_MODOTRABAJO'] == "PUNTODEVENTA")
		{
				$clase = new Sistema();
				$vsql = "SELECT docuid FROM documentos WHERE tipodoc = 'TRB' AND prefijo = 'COD' AND autoimpreso IS NULL LIMIT 0,1";
				$docuid = $clase->SeleccionarUno($vsql);
				if($docuid!="")
				{
						$vsql2 = "CALL PA_AsentarTransferencia(".$docuid.")";
						$clase->EjecutarSQL($vsql2);

						ImpresionPOSGeneral($docuid);
						$clase->EjecutarSQL("UPDATE documentos SET autoimpreso = 'CHECKED' WHERE docuid =".$docuid);
				}		
		}			
		return;	
	}

	//////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////
	function RegenerarFCOaTesoreria()
	{
		  $clase = new Sistema();
		  if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR")
			{
					$vsql = "SELECT docuid , tipodoc , prefijo , numero , formapago , D.fechadoc , 
									(SELECT docuid FROM documentos WHERE tipodoc = 'CXP' AND numero = D.numero) docuidx   
									FROM documentos D
									WHERE tipodoc = 'FCO' AND formapago = 'CR' AND D.fecasentado <> '0000-00-00' AND D.periodo = '".date("mY")."'
									HAVING docuidx IS NULL
									ORDER BY docuidx ASC , numero ASC";

					$conex  = $clase->Conectar();
					$result = mysql_query($vsql,$conex);
					while($row = mysql_fetch_array($result))
					{
							$docuid = $row['docuid'];
							GenerarTesoreria($docuid);
					}
			}			
			return;	
	}

   /////////////////////////////////////////////////////////////////////////////////
   /////////////////////////////////////////////////////////////////////////////////
   function CostoAsentarCompraNuevo($productoid)
   {
         $clase = new Sistema();

  	     $linealog = "";

          /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
          //// Costo Promedio - Ultimas 6 compras del Producto
          $vsql2 = "SELECT DISTINCT D.docuid , D.tipodoc , D.observacion2 , D.prefijo , D.numero , D.fechadoc , DD.productoid , D.nrodocref , D.terid1 ,  DD.valunitario , 
		            DCC.dcto1 , DCC.dcto2 , DCC.dcto3 , DCC.aplicar2 , 
					COALESCE(DDCX.dctol1,0) dctol1 , COALESCE(DDCX.dctol2,0) dctol2 , COALESCE(DDCX.dctol3,0) dctol3 , COALESCE(DDCX.dctol4,0) dctol4 , DD.valico , D.sucursalid , 
                    COALESCE(DD.valdescuento,0) valdescuento , DD.valunitario , COALESCE(DDCX.obsequio,0) obsequio , DD.valiva , SUM(DD.cantidad) canti , 
                    (SELECT SUM(cantidad) FROM existencias EXX WHERE EXX.productoid = DD.productoid) exitotal                 
                    FROM documentos D INNER JOIN docucompra DCC ON (D.docuid = DCC.docuid) 
                    INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
                    LEFT JOIN dedocuorden DDCX ON (DDCX.dedocumid = DD.dedocumid)
                    WHERE D.tipodoc = 'FCO' AND DD.productoid = ".$productoid." AND D.ano > 21 AND DD.valunitario > 0 AND D.fecasentado <> '0000-00-00' 
                    GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24 ORDER BY D.fechadoc DESC LIMIT 0,100"; 
                   
          $conex2  = $clase->Conectar();
          $result2 = @mysql_query($vsql2,$conex2);
          $sumacanti = 0;     $sumaval = 0;    $j = 0;  
          $linealog = '<font face="verdana" size="2"><br>
                        <table width="900"> <tr> 
                          <td align="right" width="200"> <b> Documento </td>
                          <td align="right" width="130"> <b> Fecha </td>
                          <td align="right" width="120"> <b> Cant </td> 
                          <td align="right" width="150"> <b> VUnit </td> 
                          <td align="right" width="150"> <b> VTotal </td> 
                          <td align="right" width="150"> <b> Exit </td>
                          <td align="right" width="50"> &nbsp; </td>
                        </tr>';
          $cx = 1;  $totalizado = 0;
          while($row2 = @mysql_fetch_array($result2)) 
          {
              $exitotal = $row2['exitotal'];

              if(substr($row2['observacion2'],0,7) == "TRBCODB")
              {
                  $c++;
              }
              else
              {
                      $dcto1 = $row2['dcto1'];  
                      $dcto2 = $row2['dcto2'];
                      $dcto3 = $row2['dcto3'];
                      $dcto4 = $row2['dcto4'];
                      $aplicar2 = $row2['aplicar2'];
                      //$dcto5 = $row2['dctol1'];
                      //$dcto6 = $row2['dctol2'];
                      $dcto7 = $row2['dctol3'];
                      $dcto8 = $row2['dctol4'];
                      $valdescuento = $row2['valdescuento'];
                      
                      $basenotas  = 0;

					  ///// Calculo el Costo Informativo con Base en los Nuevos Impuestos
                      $costoinf   = 0+(((($row2['valico']/$row2['canti'])+($row2['valibua']/$row2['canti'])+($row2['valicui']/$row2['canti'])+$row2['valunitario'])*$row2['canti'])/($row2['canti']+$row2['obsequio']));

                      if($dcto1 > 0)  $costoinf = $costoinf - ($costoinf*($dcto1/100));
                      //if(($dcto2 > 0)&&($aplicar2 == "CHECKED"))  $costoinf = $costoinf - ($costoinf*($dcto2/100));
                      $basenotas  = $costoinf;
                        
                      if($dcto3 > 0)  $costoinf = $costoinf - ($costoinf*($dcto3/100));
                      if($dcto4 > 0)  $costoinf = $costoinf - ($costoinf*($dcto4/100));
                        //if($dcto5 > 0)  $costoinf = $costoinf - ($costoinf*($dcto5/100));
                        //if($dcto6 > 0)  $costoinf = $costoinf - ($costoinf*($dcto6/100));
                      if($dcto7 > 0)  $costoinf = $costoinf - ($costoinf*($dcto7/100));
                      if($dcto8 > 0)  $costoinf = $costoinf - ($costoinf*($dcto8/100));
                        
                      $basenotas  =  $basenotas - ($basenotas*($dcto5/100));
                      $basenotas  =  $basenotas - ($basenotas*($dcto6/100));	      
                      $basenotas  =  ($basenotas * ($row2['canti']+$row2['obsequio']));

                      if(($dcto7 > 0)&&($basenotas>1000))           GenerarNotaDescuento($docuid,$dcto7,$basenotas,4);  
                      if(($dcto8 > 0)&&($basenotas>1000))           GenerarNotaDescuento($docuid,$dcto8,$basenotas,5); 
                      //if(($valdescuento > 0)&&($basenotas>1000))    GenerarNotaDescuento($docuid,$valdescuento,$basenotas,6,"V"); 

                      if($j==0)
                      {
						if(intval($row2['valico'])>0)
                           $UltCostoProd  = ($row2['valunitario']+($row2['valico']/$row2['canti']));
						else
						   $UltCostoProd  = $row2['valunitario'];

                        $CostoInfxProd = $costoinf;
                      }

                      $sumacanti += (round($row2['canti'])+round($row2['obsequio']));
                      $sumaval   += (round($costoinf)*round(($row2['canti']+$row2['obsequio'])));
                      $j++;
                      
                      //// Agrego la Linea a los Costos de la Señora
                      if($row2['prefijo'] != "")
                      {
                        if(substr($row2['prefijo'],0,3) == "COD")  
                          $cod = $prefijo;
                        else
                          $cod = "";
                        AgregarLineaCostosSeñora($row2['sucursalid'],$row2['tipodoc'].$row2['prefijo'].$row2['numero'],$row2['nrodocref'],substr($row2['fechadoc'],0,10),$row2['terid1'],$row2['canti'],$row2['obsequio'],$costoinf,$row2['precio1m'],0,$iva,$cod,$productoid,$row2['docuid']); 
                      }

                      /// Linea LOG 
                      $linealog.='<tr>
                                    <td align="right"> '.$cx." * <b>".$row2['tipodoc'].$row2['prefijo'].$row2['numero'].'</b> </td>
                                    <td align="right"> '.substr($row2['fechadoc'],8,2).'/'.substr($row2['fechadoc'],5,2).'/'.substr($row2['fechadoc'],0,4).'</td>
                                    <td align="right"> '.number_format(($row2['canti']+$row2['obsequio']),1).'</td>
                                    <td align="right"> '.number_format(($costoinf),1).'</td>
                                    <td align="right"> '.number_format(((round($costoinf)*round(($row2['canti']+$row2['obsequio'])))),1).'</td>
                                    <td align="right"> '.number_format(($exitotal),1).'</td>
                                  </tr>';                             

                      //if($sumacanti >= $row2['exitotal']) 
                      if(($sumacanti >= $exitotal)||($cx>399))
                      {
                        $totalizado = 1;
                        $linealog.='<tr>
                                      <td align="right"> &nbsp; </td>
                                      <td align="right"> &nbsp; </td>
                                      <td align="right"> <b>'.number_format($sumacanti,1).'</td>
                                      <td align="right"> &nbsp; </td>
                                      <td align="right"> <b>'.number_format(($sumaval),1).'</td>
                                      <td align="right"> <b>'.number_format(($exitotal),1).'</td>
                                      <td align="right"> &nbsp; </td>
                                    </tr></table><br>';
                        break;          	
                      }	 
                $cx++;
				
             } /// ELSE

         } // While Interno    	
         
          if($totalizado == 0)
          {
            $linealog.='<tr>
                          <td align="right"> &nbsp; </td>
                          <td align="right"> &nbsp; </td>
                          <td align="right"> <b>'.number_format($sumacanti,1).'</td>
                          <td align="right"> &nbsp; </td>
                          <td align="right"> <b>'.number_format(($sumaval),1).'</td>
                          <td align="right"> <b>'.number_format(($exitotal),1).'</td>
                          <td align="right"> &nbsp; </td>
                        </tr></table><br>';
          }
         
          //echo $productoid.$linealog."<br>";

          //// Guardo el Log al Producto 
          $clase->EjecutarSQL("UPDATE productos SET tablacostoprom = '".$linealog."' WHERE productoid =".$productoid);

          echo "<br>".$linealog."<br><br>";

          $costoProm = round($sumaval/$sumacanti);
          $clase->EjecutarSQL("UPDATE productos SET costoprom = '".$costoProm."' , ultcosto = '".$UltCostoProd."' , costoinf = '".$CostoInfxProd."' , tablacostoprom = '".$linealog."' WHERE productoid =".$productoid);
        
    //  }  /// While de Productos
     
   } // Fin de la Funcion

	
  ///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  function GenerarDevolucionAServidor($docuid)
  {
     ini_set("memory_limit","200M");
     set_time_limit(0);
     
     $linea = "";      $cont="";
	   $clase = new Sistema();
	   
  	 //// Datos del Tercero
  	 $vsql="SELECT T.* FROM terceros T INNER JOIN documentos D ON (T.terid = D.terid1) WHERE D.docuid=".$docuid;
  	 $conex  = $clase->Conectar();
       $result = mysql_query($vsql,$conex);
  	 if($row = mysql_fetch_array($result))
  	 {
  	    $linea = "INSERT IGNORE INTO terceros(codigo,dni,tipodoc,apellidos,nombres,telfijo,telmovil,ciudadid,zonaterid,gruposperid,escliente,creador,momento) VALUES('".$row['codigo']."','".$row['dni']."','".$row['tipodoc']."','".$row['apellidos']."','".$row['nombres']."','".$row['telfijo']."','".$row['telmovil']."',1,1,1,'S','".$row['creador']."','".$row['momento']."');";
  		$cont.= $linea.Chr(13).Chr(10);  		 
  	 }   
	 
	 //// Datos del Documento
	 $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 if($row = mysql_fetch_array($result))
	 {
	    $linea = "*INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['formapago']."',".$row['terid1'].",".$row['terid2'].",".$row['terid3'].",'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".$row['base'].",".$row['iva'].",".$row['total'].",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."');";
		$cont.= $linea.Chr(13).Chr(10); 
		$nombresincro = $row['tipodoc'].$row['prefijo'].$row['numero'];
	 }  

	 //// Comando *SEL-DOCUID
	 $linea = "|SELECTUNO|SELECT docuid FROM documentos WHERE CONCAT(tipodoc,prefijo,numero)='".$nombresincro."'";
	 $cont .= $linea.Chr(13).Chr(10); 
	 
	 /// Genero 2 Tipos de Documento - 1 de Salida de la Bodega de Origen y otro de Entrada Normal
	 
	 //// Detalles del Documento
	 $vsql="SELECT docuid , productoid , bodegaid , valunitario , porciva , SUM(cantidad) cantidad , SUM(unidades) unidades , SUM(costoprod) costoprod , SUM(valdescuento) valdescuento , 
            SUM(valparcial) valparcial , SUM(valbase) valbase , SUM(valiva) valiva , SUM(valtotal) valtotal , SUM(unicom) unicom , SUM(unifra) unifra 
            FROM dedocumentos WHERE docuid=".$docuid." GROUP BY 1,2,3,4,5";
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 
	 $cont1 = $cont;   /// Bodega Origen
	 $cont2 = $cont;   /// Bodega Destino
	 
	 while($row = @mysql_fetch_array($result))
	 {
		$linea = "**DELETE  FROM dedocumentos WHERE docuid = ||||| AND productoid = ".$row['productoid']." AND cantidad = ".$row['cantidad'].";";     
		$cont1.= $linea.Chr(13).Chr(10);       
		$linea = "**INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal) VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".$row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].",".$row['valiva'].",".$row['valtotal'].");";     
		$cont1.= $linea.Chr(13).Chr(10);       
   
		$linea = "**DELETE  FROM dedocumentos WHERE docuid = ||||| AND productoid = ".$row['productoid']." AND cantidad = ".$row['cantidad'].";";     
		$cont2.= $linea.Chr(13).Chr(10);       
		$linea = "**INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal) VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".$row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].",".$row['valiva'].",".$row['valtotal'].");";   
		$cont2.= $linea.Chr(13).Chr(10);  
	 }  

	 //// Docutranfe
	 $vsql="SELECT * FROM docutranfe WHERE docuid=".$docuid;
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 while($row = mysql_fetch_array($result))
	 {
	    $bodegades  = $row['bodegaiddes'];
		$bodegaori  = $row['bodegaidori'];		
		$codbodegaori = $clase->BDLockup($bodegaori,"bodegas","bodegaid","codbodega"); 
		$codbodegades = $clase->BDLockup($bodegades,"bodegas","bodegaid","codbodega");
		$carpetaori = $clase->SeleccionarUno("SELECT codigo FROM sucursales S INNER JOIN bodegas B ON (B.sucursalid = S.sucursalid) WHERE B.bodegaid = ".$bodegaori);
		$carpetades = $clase->SeleccionarUno("SELECT codigo FROM sucursales S INNER JOIN bodegas B ON (B.sucursalid = S.sucursalid) WHERE B.bodegaid = ".$bodegades);

		$linea = "***INSERT INTO docutranfe(docuid,bodegaidori,bodegaiddes,kardexori,kardexdes,codbarra,enviado,planogen) VALUES(|||||,".$row['bodegaidori'].",".$row['bodegaiddes'].",'".$row['kardexori']."','".$row['kardexdes']."','".$row['codbarra']."','".$row['enviado']."','S');";
		$cont1.= $linea.Chr(13).Chr(10);  		 
		$cont2.= $linea.Chr(13).Chr(10);  		 
	 }    
	 
	 ///////////////////////////////////////////////////////////////////////////
	 ///// Si ORIGEN es diferente a la bodega Actual la envio
	 ///////////////////////////////////////////////////////////////////////////
	 if(substr($codbodegaori,0,2) != substr($_SESSION['G_BODEGAPREDETPOS'],0,2))
	 {	   
  	   $directorio = "../Dropbox/Todos/".$carpetaori."/automatico/"; 
  	   $archivo    = "../Dropbox/Todos/".$carpetaori."/automatico/".$nombresincro.".txt"; 
  	   $archivoz   = "../Dropbox/Todos/".$carpetaori."/automatico/DES".$nombresincro.".zip"; 
  	   $archivod   = "../Dropbox/Todos/".$carpetaori."/transferencias/".$nombresincro.".txt"; 

       if(file_exists($archivo))
	      unlink($archivo);
		  
       //// Creo nuevamente el Archivo con el nuevo contenido
	     $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
       if($fch)
  	   {
  	    fwrite($fch, $cont1); // Grabas
          fclose($fch); // Cierras el archivo	 
  	   }

       //// Creo nuevamente el Archivo con el nuevo contenido
	     $fch= fopen($archivod, "w"); // Abres el archivo para escribir en él
       if($fch)
  	   {
  	      fwrite($fch, $cont1); // Grabas
          fclose($fch); // Cierras el archivo	 
  	   }

  	   //// Lo comprimo en ZIP
  	   include('lib/pclzip/pclzip.lib.php');
  	   $archive = new PclZip($archivoz);
       $archive->add($archivo, PCLZIP_OPT_REMOVE_PATH, $directorio);
       //// Despues de Comprimirlo - Lo Elimino
       unlink($archivo); 
     }    
     
	   ///////////////////////////////////////////////////////////////////////////
 	   /////  DESTINO es diferente a la bodega Actual la envio
	   ///////////////////////////////////////////////////////////////////////////
	   if($codbodegades == "50")
	     $archivo= "../Dropbox/00/transferencias/".$nombresincro.".txt"; 
	   else
	   {
	     	if($codbodegades == "DB")
			  $archivo= "../Dropbox/DB/transferencias/".$nombresincro.".txt"; 
			else
			  $archivo= "../Dropbox/Todos/".$carpetades."/transferencias/".$nombresincro.".txt"; 	
	   }
	     

      //// Elimino el Archivo
      if(file_exists($archivo))
	    unlink($archivo);
     
	   //// Creo nuevamente el Archivo con el nuevo contenido	 
	   $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
       if($fch)
	   {
	      fwrite($fch, $cont2); // Gr
          fclose($fch); // Cierras el archivo	 
	   }
	   return;	  
    }  //// Fin de la Funcion


    //////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////
	function GenerarDevoluciondeExcesosAServidor($docuid)
	{
		$clase = new Sistema();	
		$vsql="SELECT DT.bodegaidori , DT.bodegaiddes , D.* , DD.productoid , DD.bodegaid , DD.cantidad , DD.valunitario , DD.valparcial 
		       FROM documentos D INNER JOIN docutranfe DT ON (D.docuid = DT.docuid) 
			   INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
			   WHERE D.docuid = ".$docuid;

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		while($row = mysql_fetch_array($result))
		{
			$arrayFinal[$i] = $row;         
			$i++;
		}

	    ///$url = "http://192.168.14.244:9999/dropos/wsjson/devolucionesexcesos/recibirdevolucion.php";
        $url = "http://dromedicas.sytes.net:9999/dropos/wsjson/devolucionesexcesos/recibirdevolucion.php";

		$ch = curl_init($url);

		//// creo el JSON 
		$mandar =  json_encode(array("data" => $arrayFinal));

		// Attach encoded JSON string to the POST fields
		curl_setopt($ch, CURLOPT_POSTFIELDS, $mandar);

		// Set the content type to application/json
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

		// Return response instead of outputting
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute the POST request
		$json = curl_exec($ch);

		//// SOLO PARA VALIDACION : IMPRIMO lo que hace la API
        print_r($json); 
		
		// Close cURL resource
		curl_close($ch);

		$dataRespuesta = json_decode($json);
		return($dataRespuesta);
	}


    //////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////
	function MarcarEnServidorAutorizacionesWS()
	{
		$clase = new Sistema();	
		$vsql  =  "SELECT autorizaid , diaoperativo FROM autorizacionesgastos WHERE (diaoperativo <> '' OR diaoperativo IS NOT NULL) ORDER BY autorizaid DESC LIMIT 0,100";
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		while($row = mysql_fetch_array($result))
		{
			$arrayFinal[$i] = $row;         
			$i++;
		}

        $url = "http://dromedicas.sytes.net:9999/dropos/wsjson/recibirdatoscierre/diasoperativosautorizaciones.php";
	    ///$url = "http://192.168.14.244:9999/dropos/wsjson/recibirdatoscierre/diasoperativosautorizaciones.php";

		$ch = curl_init($url);

		//// creo el JSON 
		$mandar =  json_encode(array("data" => $arrayFinal));

		// Attach encoded JSON string to the POST fields
		curl_setopt($ch, CURLOPT_POSTFIELDS, $mandar);

		// Set the content type to application/json
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

		// Return response instead of outputting
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute the POST request
		$json = curl_exec($ch);

		//// SOLO PARA VALIDACION : IMPRIMO lo que hace la API
        print_r($json); 
		
		// Close cURL resource
		curl_close($ch);

		$dataRespuesta = json_decode($json);
		return($dataRespuesta);
	}



	//////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////
	function GenerarDevolucionExcesos()
	{
		$clase = new Sistema();	

		ini_set("memory_limit","100M");                            
		set_time_limit(0);

		$periodoactual = date("mY");
		$yalahizo = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc = 'TRB' AND periodo = '".$periodoactual."' AND observacion2 = 'DEVOLUCIONEXCESOS'");
		if($yalahizo != "")
		 {
			$clase->Aviso(2,'Devolucion de Excesos de este periodo, ya fué Generada'); 
			header("Location: principal.php");
			exit;
		}
		
		/// Crear Encabezado
		$tipodoc   = "TRB";
		$prefijo   = "EXC";
		$numero    = $_SESSION['G_SUCURSALPOS'].date("m").substr(date("Y"),2,2);
		$periodo   = $periodoactual;
		$fechadoc  = date("Y-n-d");
		$fechanull = "0000-00-00";
		$sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid'); 		
		$existe = $clase->SeleccionarUno("SELECT COUNT(*) FROM documentos WHERE tipodoc='".$tipodoc."' AND prefijo='".$prefijo."' AND numero='".$numero."'");

		if($existe == 0)
		{
			if($_SESSION['G_MODOTRABAJO'] == "PUNTODEVENTA")
			{
					$sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid'); 
					$codzona  = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','zona'); 
					$codregion  = $clase->BDLockup($codzona,'zonas','codzona','codregion'); 
					$bodegades = $clase->BDLockup($codregion,'regiones','codregion','boddeposito'); 
					$bodegadespre = $clase->BDLockup($bodegades,'bodegas','codbodega','bodegaid');	
			}
				
			//// Inserto el encabezado del Documento
			$observacion = "DEVOLUCION DE EXCESOS CALCULADA AUTOMATICAMENTE POR EL SISTEMA. PERIODO : ".$periodoactual;
			$vsql = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,fecanulado,terid1,total,impreso,totalitems,sucursalid,creador,momento,formapago,observacion,observacion2,nrodocref) 
					VALUES('".$tipodoc."','".$prefijo."','".$numero."','".$periodo."',CURRENT_TIMESTAMP,CURRENT_DATE,'".$fechanull."',1,0,'N',0,".$sucursalid.",'".
					$_SESSION['USERNAME']."',CURRENT_TIMESTAMP,'CO','".$observacion."','DEVEXCESOS','DEVEXCESOS')";
			
			$clase->EjecutarSQL($vsql);

			/// Busco el Maximo Docuid - El recien insertado
			$Ndocuid = $clase->SeleccionarUno("SELECT MAX(docuid) FROM documentos WHERE tipodoc='".$tipodoc."' AND prefijo = '".$prefijo."' AND numero = '".$numero."'");

			/// Asigno la bodega predeterminada como origen de la transferencia
			$bodegapred = $_SESSION['G_BODEGAPREDETPOS'];
			$bodegaid = $clase->BDLockup($bodegapred,'bodegas','codbodega','bodegaid');
			
			/// Inserto el Docutrasla para este documento	
			$vsql = "INSERT INTO docutranfe(docuid,diaoperativo,bodegaidori,bodegaiddes,kardexori,kardexdes) VALUES(".$Ndocuid.",'".$_SESSION['G_DIAOPERATIVO']."',".$bodegaid.",".$bodegadespre.",'N','N')";
			$clase->EjecutarSQL($vsql);

			/// Recorro el Módulo e inserto los detalles de documento
			$vsql =  "SELECT DISTINCT D.id , P.precio1m , P.porciva , P.porcenboni , E.cantidad exireal , D.productoid , D.codigo , D.descripcion , D.laboratorio , D.r150 , D.devolver ,
    					(SELECT DATEDIFF(CURRENT_DATE,MAX(fechadoc)) FROM kardex WHERE tipodoc = 'TRB' AND productoid = P.productoid AND bodegaid = ".$bodegaid." AND cantidad > 0 HAVING MAX(fechadoc) ORDER BY fechadoc DESC) ultimoingreso , 
						(SELECT ABS( ROUND( SUM( cantidad ) ) ) FROM kardex WHERE tipodoc = 'TRB' AND productoid = P.productoid AND bodegaid = ".$bodegaid." AND cantidad > 0 AND DATE_SUB( NOW( ) , INTERVAL 90 DAY ) <= fechadoc) entradaultimos90dias , 
						(SELECT minimo FROM minimospersonalizados WHERE tipo = 'todas' AND productoid = P.productoid AND fechahasta > CURRENT_DATE LIMIT 0,1) tieneminimo1 ,  							
		                (SELECT minimo FROM minimospersonalizados WHERE (tipo = 'por drogueria' OR tipo = 'exhibicion') AND sucursalid = ".$sucursalid." AND productoid = P.productoid AND fechahasta > CURRENT_DATE LIMIT 0,1) tieneminimo2 
                         FROM devolucionexcesos D 
						INNER JOIN productos P ON (D.productoid = P.productoid)
						INNER JOIN gruposprod GP ON (GP.gruposprodid = P.gruposprodid)			
						INNER JOIN existencias E ON (E.productoid = P.productoid) 
						INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid AND B.bodegaid = ".$bodegaid.")
						WHERE D.periodo = '".date("mY")."' AND devolver > 0 AND COALESCE(GP.nodevolverexceso,'') = '' AND P.productoid NOT IN (SELECT productoid FROM excluirexcesos) 
						AND GP.gruposprodid NOT IN (SELECT gruposprodid FROM excluirexcesos) 
						ORDER BY D.laboratorio , D.descripcion";
			
			
			$conex  = $clase->Conectar();
			$result = mysql_query($vsql,$conex);
			$cantid = mysql_num_rows($result);
			$i=1;
			while($row = mysql_fetch_array($result)) 
			{
				if(intval($row['tieneminimo2'])>0)
					$MIN = $row['tieneminimo2'];
				else
					$MIN = $row['tieneminimo1'];

				if($MIN == 0)  $MIN = "";	
				if(($row['devolver']>0)&&($row['exireal']>0))
				{
						// Pendiente el Guardado
						$cantiventa = 0+$row['devolver'];  
						$productoid = $row['productoid'];
						$costoprod  = $row['precio1m'];
						$porciva    = $row['porciva'];
							
						$valparcial = $cantiventa*$costoprod;
						$valbase    = $valparcial;
						$valiva     = 0;
						$valtotal   = $valparcial;
						
						$vsql2 = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,valunitario,valparcial,porciva,valbase,
								valiva,valtotal,numlinea,unicom,unifra) VALUES(".$Ndocuid.",".$productoid.",".$bodegapred.",".$cantiventa.",".$cantiventa.",'D',".
								$costoprod.",".$costoprod.",".$valparcial.",".$porciva.",".$valbase.",".$valiva.",".$valtotal.",".$cantiventa.",".$i.",0)";
						$clase->EjecutarSQL($vsql2); 
                        $i++; 					                        				
			   }
			}
		}

		/// Dejo sólo decimales
		$clase->EjecutarSQL("UPDATE dedocumentos SET cantidad = FLOOR(cantidad) , unidades = FLOOR(unidades) WHERE docuid = ".$Ndocuid);		
		/// Imprimo el Ticket 
		ImpresionPOSGeneral($Ndocuid);
		/// y Copia del Ticket
		ImpresionPOSGeneral($Ndocuid);
		/// Envio el Archivo
		/// GenerarDevolucionAServidor($Ndocuid);
		//GenerarDevoluciondeExcesosAServidor($Ndocuid);
		/// Retorno
		return($Ndocuid);
	} /// Fin de la Funcion


  ////////////////////////////////////////////////////////////////////////////////////////
  /// Guardar en Tabla de Busqueda Rapida - Ordenes de Compra
  /// Almacena en la Tabla el Producto y Docuid para busquedas mas agiles
  //////////////////////////////////////////////////////////////////////////////////////// 	
  function GuardarenTablaBusquedaRapida($docuid)
  {
     	$clase = new Sistema();
		$vsql = "SELECT DISTINCT productoid , docuid FROM dedocumentos WHERE docuid = ".$docuid;
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		while($row = @mysql_fetch_array($result))
		   $clase->EjecutarSQL("INSERT INTO productosxordencompra(productoid,docuid) VALUES('".$row['productoid']."','".$row['docuid']."')");     
	    
		return;	
  }
  
  ////////////////////////////////////////////////////////////////////////////////////////
  /* FUNCIONES PARA SINCRONIZACION DE SERVIDORES BARRANQUILLA - PRINCIPAL  */
  ////////////////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////////////
  function ActExistenciasAServidorPrincipal($sucursalid)
  {
		ini_set("memory_limit","200M");
		set_time_limit(0);

		$clase = new Sistema();
		$vsql = "SELECT DISTINCT E.*
				FROM existencias E 
				INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid)
				INNER JOIN kardex K ON (K.bodegaid = E.bodegaid AND K.productoid = E.productoid)
				WHERE B.sucursalid = ".$sucursalid;
		$cont = "";
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$vsql3 = array();
		$i=0;
		while($row = @mysql_fetch_array($result))
		{
			$vsql3[$i]= "UPDATE IGNORE existencias SET cantidad = ".$row['cantidad']." WHERE productoid = ".$row['productoid']." AND bodegaid = ".$row['bodegaid'];     
			$i++;				  
		}  

        //////////////////////////////////////////////////////////////////////////
	    //////////////////////////////////////////////////////////////////////////
	    /// Me conecto al Servidor para Ingresar el Documento allá
	    //////////////////////////////////////////////////////////////////////////
	    //////////////////////////////////////////////////////////////////////////
	    try {

		$ServidorBD = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBSERVER'");
		$NombreBD   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBNAME'");
		$UsuarioBD  = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBUSER'");
		$ClaveBD    = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBPASS'");
		
		/// Valor a Retornar
		$retorno = false;

		//// Me conecto a la Base de Datos
		$conn = new PDO("mysql:host=$ServidorBD;dbname=$NombreBD", $UsuarioBD, $ClaveBD);
		$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

		/// Recorro los detalles y Voy insertando Linea a Linea   
		foreach($vsql3 as $consulta)
		{
			if($consulta!="")
			   echo $consulta."<br>";
			   //$conn->exec($consulta);
		}

		/// Si Finaliza el proceso la marco LOCALMENTE como en Servidor
		/*
        $clase->EjecutarSQL("UPDATE documentos SET sincronizado = CURRENT_DATE WHERE docuid = ".$docuid);
		$retorno = true;
		*/
		/// Cierro la Conexion y Garbage Collector
		$conn = null;
	  }
	  catch(PDOException $err) {
		echo "<b>ERROR <br> Detalle del Error : </b>" .$err->getMessage(). "<br> <b> Error No. </b> ".$err->getCode(). "<br> <b> Linea </b> ".$err->getLine();
		exit;
	  }

	 return($retorno); 
   } 
   
  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  function CopiarTransferenciaAServidor($docuid)
  {
	  ini_set("memory_limit","200M");
	  set_time_limit(0);
	
	  $linea = "";      $cont="";
	  $clase = new Sistema();
	  	  
	  //// Datos del Documento
	  $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	  {
		 $vsql1 = "INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento,sincronizado) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['fechadoc']."','".$row['formapago']."',".$row['terid1'].",".$row['terid2'].",".$row['terid3'].",'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".(0+$row['base']).",".(0+$row['iva']).",".(0+$row['total']).",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."',CURRENT_DATE)";  
		 $vsqlb = "SELECT docuid FROM documentos WHERE tipodoc = '".$row['tipodoc']."' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."'";  
		 $vsqlr = "CALL PA_CalValoresGen(|||||)";   
		 $vsqla = "CALL PA_AsentarTransferencia(|||||)";   
	  } 
	  		 
	  //// Datos Docutranfe
	  $vsql="SELECT * FROM docutranfe WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	     $vsql2 = "INSERT INTO docutranfe(docuid,bodegaidori,bodegaiddes,kardexori,kardexdes,codbarra,enviado,planogen,cargadodestino) VALUES(|||||,".$row['bodegaidori'].",".$row['bodegaiddes'].",'".$row['kardexori']."','".$row['kardexdes']."','".$row['codbarra']."','".$row['enviado']."','S','CHECKED')";   
	  
	  //// Detalles del Documento
	  $vsql="SELECT * FROM dedocumentos WHERE docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql3 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql3[$i]= "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,
	                  porciva,valbase,valiva,valtotal) 
			  	      VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".
				      $row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].
					  ",".$row['valiva'].",".$row['valtotal'].")";     
	     $i++;				  
	  }  
	 
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  /// Me conecto al Servidor para Ingresar el Documento allá
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  try {

		$ServidorBD = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBSERVER'");
		$NombreBD   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBNAME'");
		$UsuarioBD  = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBUSER'");
		$ClaveBD    = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBPASS'");
		
		/// Valor a Retornar
		$retorno = false;

		//// Me conecto a la Base de Datos
		$conn = new PDO("mysql:host=$ServidorBD;dbname=$NombreBD", $UsuarioBD, $ClaveBD);
		$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	
        //// Primero Busco la Toma Fisica, Si está borro todo
		foreach ($conn->query($vsqlb) as $row) 
		   $ADocuid = $row[0];
	    	
	    if($ADocuid != "")
		{
			$vsqlexec = "DELETE IGNORE FROM dedocumentos WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
			$vsqlexec = "DELETE IGNORE FROM documentos WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
		}
		
		/// Si llego hasta aqui - Es por que aún estoy conectado
		/// Inserto el Encabezado - Documento
		$conn->exec($vsql1);

		foreach ($conn->query($vsqlb) as $row) 
		   $NDocuid = $row[0];

		/// ReemPlazo el Docuid y luego Inserto Dedocumentos
		$vsqlexec = str_replace("|||||", $NDocuid , $vsql2);
		$filas2 = $conn->exec($vsqlexec);

		/// Recorro los detalles y Voy insertando Linea a Linea   
		foreach($vsql3 as $consulta)
		{
			if($consulta!="")
			{
		     	$vsqlexec = str_replace("|||||", $NDocuid , $consulta);
				$conn->exec($vsqlexec);
			}	
		}

		/// Recalculo los Valores Totales
		$vsqlexec = str_replace("|||||", $NDocuid , $vsqlr);
		$conn->exec($vsqlexec);

		/// Si Finaliza el proceso la marco LOCALMENTE como en Servidor
        $clase->EjecutarSQL("UPDATE documentos SET sincronizado = CURRENT_DATE WHERE docuid = ".$docuid);
		$retorno = true;
		
		/// Cierro la Conexion y Garbage Collector
		$conn = null;
	  }
	  catch(PDOException $err) {
		echo "<b>ERROR <br> Detalle del Error : </b>" .$err->getMessage(). "<br> <b> Error No. </b> ".$err->getCode(). "<br> <b> Linea </b> ".$err->getLine();
		exit;
	  }

	 return($retorno); 
  } 

  /////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  function CopiarTomaFisicaAServidor($docuid)
  {
	  ini_set("memory_limit","200M");
	  set_time_limit(0);
	
	  $linea = "";      $cont="";
	  $clase = new Sistema();
	  	  
	  //// Datos del Documento
	  $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	  {
		 $vsql1 = "INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento,sincronizado) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['fechadoc']."','".$row['formapago']."',".$row['terid1'].",".$row['terid2'].",".$row['terid3'].",'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".$row['base'].",".$row['iva'].",".$row['total'].",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."',CURRENT_DATE)";  
		 $vsqlb = "SELECT docuid FROM documentos WHERE tipodoc = '".$row['tipodoc']."' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."'";  
		 $vsqlr = "CALL PA_CalValoresGen(|||||)";   
		 $vsqla = "CALL PA_AsentarTransferencia(|||||)";   
	  } 
	  		 	  
	  //// Detalles del Documento
	  $vsql="SELECT * FROM dedocumentos WHERE docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql3 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql3[$i]= "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,
	                  porciva,valbase,valiva,valtotal) 
			  	      VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".
				      $row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].
					  ",".$row['valiva'].",".$row['valtotal'].")";     
	     $i++;				  
	  }  
	 
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  /// Me conecto al Servidor para Ingresar el Documento allá
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  try {

		$ServidorBD = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBSERVER'");
		$NombreBD   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBNAME'");
		$UsuarioBD  = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBUSER'");
		$ClaveBD    = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBPASS'");
		
		/// Valor a Retornar
		$retorno = false;

		//// Me conecto a la Base de Datos
		$conn = new PDO("mysql:host=$ServidorBD;dbname=$NombreBD", $UsuarioBD, $ClaveBD);
		$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	
        //// Primero Busco la Toma Fisica, Si está borro todo
		foreach ($conn->query($vsqlb) as $row) 
		   $ADocuid = $row[0];
	    	
	    if($ADocuid != "")
		{
			$vsqlexec = "DELETE IGNORE FROM dedocumentos WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
			$vsqlexec = "DELETE IGNORE FROM documentos WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
	    }

		/// Si llego hasta aqui - Es por que aún estoy conectado
		/// Inserto el Encabezado - Documento
		$conn->exec($vsql1);

		foreach ($conn->query($vsqlb) as $row) 
		   $NDocuid = $row[0];

		/// Recorro los detalles y Voy insertando Linea a Linea   
		foreach($vsql3 as $consulta)
		{
			if($consulta!="")
			{
		     	$vsqlexec = str_replace("|||||", $NDocuid , $consulta);
				$conn->exec($vsqlexec);
			}	
		}

		/// Recalculo los Valores Totales
		$vsqlexec = str_replace("|||||", $NDocuid , $vsqlr);
		$conn->exec($vsqlexec);

		/// Si Finaliza el proceso la marco LOCALMENTE como en Servidor
        $clase->EjecutarSQL("UPDATE documentos SET sincronizado = CURRENT_DATE WHERE docuid = ".$docuid);
		$retorno = true;
		
		/// Cierro la Conexion y Garbage Collector
		$conn = null;
	  }
	  catch(PDOException $err) {
		echo "<b>ERROR <br> Detalle del Error : </b>" .$err->getMessage(). "<br> <b> Error No. </b> ".$err->getCode(). "<br> <b> Linea </b> ".$err->getLine();
		exit;
	  }

	 return($retorno); 
  } 

  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  function CopiarFacturaCompraAServidor($docuid)
  {
	  ini_set("memory_limit","200M");
	  set_time_limit(0);
	
	  $linea = "";      $cont="";
	  $clase = new Sistema();
	  	  
	  //// Datos del Documento
	  $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	  {
		 $vsql1 = "INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento,sincronizado) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['fecasentado']."','".$row['formapago']."',".$row['terid1'].",".$row['terid2'].",".$row['terid3'].",'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".$row['base'].",".$row['iva'].",".$row['total'].",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."',CURRENT_DATE)";  
		 $vsqlb = "SELECT docuid FROM documentos WHERE tipodoc = '".$row['tipodoc']."' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."'";  
		 $vsqlr = "CALL PA_CalValoresFCO(|||||)";   
		 $vsqlreve = "CALL PA_ReversarDocumento(|||||)"; 
		 if($row['fecasentado']!="0000-00-00")
		   $vsqlasen = "CALL PA_AsentarDocumento(|||||,'FCO')"; 
		 else
		   $vsqlasen = ""; 
	  } 
	  		 
	  //// Datos Docutranfe
	  $vsql="SELECT * FROM docucompra WHERE docuid=".$docuid;
	  //$conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	     $vsql2 = "INSERT INTO docucompra(docuid,dcto1,dcto2,dcto3,dcto4,fechallegada,aplicarcondipro,diasplazo,paradias,aplicar2,convenioid,diascartera) VALUES(|||||,'".$row['dcto1']."','".$row['dcto2']."','".$row['dcto3']."','".$row['dcto4']."','".$row['fechallegada']."','".$row['aplicarcondipro']."','".(0+$row['diasplazo'])."','".(0+$row['paradias'])."','".$row['aplicar2']."','".(0+$row['convenioid'])."','".(0+$row['diascartera'])."')";   

	  //// Detalles del Documento
	  $vsql="SELECT * FROM dedocumentos WHERE docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql3 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql3[$i]= "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,
	                  porciva,valbase,valiva,valtotal) 
			  	      VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".
				      $row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].
					  ",".$row['valiva'].",".$row['valtotal'].")";     
	     $i++;				  
	  }  

	  //// Detalles de la Orden de Compra
	  $vsql="SELECT DDO.* FROM dedocuorden DDO INNER JOIN dedocumentos DD ON (DD.dedocumid = DDo.dedocumid) WHERE DD.docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql4 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql4[$i]= "INSERT INTO dedocuorden(dedocumid,precioant,dctol1,dctol2,dctol3,dctol4,obsequio) 
			  	      VALUES('".$row['dedocumid']."','".(0+$row['precioant'])."','".(0+$row['dctol1'])."','".(0+$row['dctol2'])."','".
				      (0+$row['dctol3'])."','".(0+$row['dctol4'])."','".(0+$row['obsequio'])."')";     
	     $i++;				  
	  }  

	  //// Docuself Asociar Ordenes y Facturas
	  $vsql="SELECT DO.tipodoc , DO.prefijo , DO.numero , DS.docuid2 
	         FROM docuself DS INNER JOIN documentos D ON (DS.docuid = D.docuid) 
	         INNER JOIN documentos DO ON (DO.docuid = DS.docuid2) WHERE D.docuid = ".$docuid." LIMIT 0,1";
	  //$conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	  {
		 $vsqlboc = "SELECT docuid FROM documentos WHERE CONCAT(tipodoc,prefijo,numero) = '".$row['tipodoc'].$row['prefijo'].$row['numero']."'";   		  
	     $vsql5   = "INSERT INTO docuself(docuid,docuid2) VALUES(|||||,?????)";   
	  }

	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  /// Me conecto al Servidor para Ingresar el Documento allá
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  try {

		$ServidorBD = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBSERVER'");
		$NombreBD   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBNAME'");
		$UsuarioBD  = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBUSER'");
		$ClaveBD    = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBPASS'");
		
		/// Valor a Retornar
		$retorno = false;

		//// Me conecto a la Base de Datos
		$conn = new PDO("mysql:host=$ServidorBD;dbname=$NombreBD", $UsuarioBD, $ClaveBD);
		$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	
		//// Primero Busco la Toma Fisica, Si está borro todo
		foreach ($conn->query($vsqlb) as $row) 
		   $ADocuid = $row[0];
	    	
	    if($ADocuid != "")
		{
			$vsqlexec = "DELETE IGNORE FROM dedocumentos WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
			$vsqlexec = "DELETE IGNORE FROM docucompra WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
			$vsqlexec = "DELETE IGNORE FROM documentos WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
	    }

		/// Si llego hasta aqui - Es por que aún estoy conectado
		/// Inserto el Encabezado - Documento
		$conn->exec($vsql1);
		foreach ($conn->query($vsqlb) as $row) 
		   $NDocuid = $row[0];

		/// ReemPlazo el Docuid y luego Inserto Dedocumentos
		$vsqlexec = str_replace("|||||", $NDocuid , $vsql2);
		$filas2 = $conn->exec($vsqlexec);

		/// Recorro los detalles y Voy insertando Linea a Linea   
		foreach($vsql3 as $consulta)
		{
			if($consulta!="")
			{
		     	$vsqlexec = str_replace("|||||", $NDocuid , $consulta);
				$conn->exec($vsqlexec);
			}	
		}

		// Recorro los detalles y Voy insertando Linea a Linea   
		foreach($vsql4 as $consulta2)
		{
			if($consulta2!="")
			{
		     	$vsqlexec = str_replace("|||||", $NDocuid , $consulta2);
				$conn->exec($vsqlexec);
			}	
		}

		/// Asocio la Factura a las Ordenes de Compra
		if($vsqlboc != "")
		{
			foreach ($conn->query($vsqlboc) as $row) 
				$OCDocuid = $row[0];
	
			if(($NDocuid != "")&&($OCDocuid != ""))	 
			{
				/// Reemplazo el ID Factura y el ID Orden para Insertar el Docuself  
				$vsqltemp = str_replace("|||||", $NDocuid , $vsql5);  
				$vsqlexec = str_replace("?????", $OCDocuid , $vsqltemp);  
				$conn->exec($vsqlexec);
			}
		}
		
		/// Recalculo los Valores Totales
		$vsqlexec = str_replace("|||||", $NDocuid , $vsqlr);
		$conn->exec($vsqlexec);

		/// La Asiento
		if($vsqlasen != "")
		{
			$vsqlexec = str_replace("|||||", $NDocuid , $vsqlreve);
			$conn->exec($vsqlexec);
			$vsqlexec = str_replace("|||||", $NDocuid , $vsqlasen);
			$conn->exec($vsqlexec);
		}
		
		/// Si Finaliza el proceso la marco LOCALMENTE como en Servidor
        $clase->EjecutarSQL("UPDATE documentos SET sincronizado = CURRENT_DATE WHERE docuid = ".$docuid);
		$retorno = true;
		
		/// Cierro la Conexion y Garbage Collector
		$conn = null;
	  }
	   catch(PDOException $err) {
		echo "<b>ERROR <br> Detalle del Error : </b>" .$err->getMessage(). "<br> <b> Error No. </b> ".$err->getCode(). "<br> <b> Linea </b> ".$err->getLine();
		exit;
	  }

	 return($retorno); 
  }

  //////////////////////////////////////////////////////////////////////
  /// COPIA SI NO EXISTE - UNA FCO al Servidor
  //////////////////////////////////////////////////////////////////////
  function CopiarFacturaCompraAServidor2($docuid)
  {
	  ini_set("memory_limit","200M");
	  set_time_limit(0);
	
	  $linea = "";      $cont="";
	  $clase = new Sistema();
	  	  
	  //// Datos del Documento
	  $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	  {
		 $vsql1 = "INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento,sincronizado) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['fecasentado']."','".$row['formapago']."',".$row['terid1'].",".$row['terid2'].",".$row['terid3'].",'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".$row['base'].",".$row['iva'].",".$row['total'].",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."',CURRENT_DATE)";  
		 $vsqlb = "SELECT docuid FROM documentos WHERE tipodoc = '".$row['tipodoc']."' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."'";  
		 $vsqlb = "SELECT docuid FROM documentos WHERE tipodoc = '".$row['tipodoc']."' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."'";  
		 $vsqlr = "CALL PA_CalValoresFCO(|||||)";   
		 $vsqlreve = "CALL PA_ReversarDocumento(|||||)"; 
		 if($row['fecasentado']!="0000-00-00")
		   $vsqlasen = "CALL PA_AsentarDocumento(|||||,'FCO')"; 
		 else
		   $vsqlasen = ""; 
	  } 
	  		 
	  //// Datos Docutranfe
	  $vsql="SELECT * FROM docucompra WHERE docuid=".$docuid;
	  //$conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	     $vsql2 = "INSERT INTO docucompra(docuid,dcto1,dcto2,dcto3,dcto4,fechallegada,aplicarcondipro,diasplazo,paradias,aplicar2,convenioid,diascartera) VALUES(|||||,'".$row['dcto1']."','".$row['dcto2']."','".$row['dcto3']."','".$row['dcto4']."','".$row['fechallegada']."','".$row['aplicarcondipro']."','".(0+$row['diasplazo'])."','".(0+$row['paradias'])."','".$row['aplicar2']."','".(0+$row['convenioid'])."','".(0+$row['diascartera'])."')";   

	  //// Detalles del Documento
	  $vsql="SELECT * FROM dedocumentos WHERE docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql3 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql3[$i]= "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,
	                  porciva,valbase,valiva,valtotal) 
			  	      VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".
				      $row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].
					  ",".$row['valiva'].",".$row['valtotal'].")";     
	     $i++;				  
	  }  

	  //// Detalles de la Orden de Compra
	  $vsql="SELECT DDO.* FROM dedocuorden DDO INNER JOIN dedocumentos DD ON (DD.dedocumid = DDo.dedocumid) WHERE DD.docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql4 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql4[$i]= "INSERT INTO dedocuorden(dedocumid,precioant,dctol1,dctol2,dctol3,dctol4,obsequio) 
			  	      VALUES('".$row['dedocumid']."','".(0+$row['precioant'])."','".(0+$row['dctol1'])."','".(0+$row['dctol2'])."','".
				      (0+$row['dctol3'])."','".(0+$row['dctol4'])."','".(0+$row['obsequio'])."')";     
	     $i++;				  
	  }  

	  //// Docuself Asociar Ordenes y Facturas
	  $vsql="SELECT DO.tipodoc , DO.prefijo , DO.numero , DS.docuid2 
	         FROM docuself DS INNER JOIN documentos D ON (DS.docuid = D.docuid) 
	         INNER JOIN documentos DO ON (DO.docuid = DS.docuid2) WHERE D.docuid = ".$docuid." LIMIT 0,1";
	  //$conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	  {
		 $vsqlboc = "SELECT docuid FROM documentos WHERE CONCAT(tipodoc,prefijo,numero) = '".$row['tipodoc'].$row['prefijo'].$row['numero']."'";   		  
	     $vsql5   = "INSERT INTO docuself(docuid,docuid2) VALUES(|||||,?????)";   
	  }

	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  /// Me conecto al Servidor para Ingresar el Documento allá
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  try {

		$ServidorBD = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBSERVER'");
		$NombreBD   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBNAME'");
		$UsuarioBD  = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBUSER'");
		$ClaveBD    = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBPASS'");
		
		/// Valor a Retornar
		$retorno = false;

		//// Me conecto a la Base de Datos
		$conn = new PDO("mysql:host=$ServidorBD;dbname=$NombreBD", $UsuarioBD, $ClaveBD);
		$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	
		//// Primero Busco la Toma Fisica, Si está borro todo
		foreach ($conn->query($vsqlb) as $row) 
		   $ADocuid = $row[0];
	    	
	    if($ADocuid == "")
		{
			/// Si llego hasta aqui - Es por que aún estoy conectado
			/// Inserto el Encabezado - Documento
			$conn->exec($vsql1);
			foreach ($conn->query($vsqlb) as $row) 
			$NDocuid = $row[0];

			/// ReemPlazo el Docuid y luego Inserto Dedocumentos
			$vsqlexec = str_replace("|||||", $NDocuid , $vsql2);
			$filas2 = $conn->exec($vsqlexec);

			/// Recorro los detalles y Voy insertando Linea a Linea   
			foreach($vsql3 as $consulta)
			{
				if($consulta!="")
				{
					$vsqlexec = str_replace("|||||", $NDocuid , $consulta);
					$conn->exec($vsqlexec);
				}	
			}

			// Recorro los detalles y Voy insertando Linea a Linea   
			foreach($vsql4 as $consulta2)
			{
				if($consulta2!="")
				{
					$vsqlexec = str_replace("|||||", $NDocuid , $consulta2);
					$conn->exec($vsqlexec);
				}	
			}

			/// Asocio la Factura a las Ordenes de Compra
			if($vsqlboc != "")
			{
				foreach ($conn->query($vsqlboc) as $row) 
					$OCDocuid = $row[0];
		
				if(($NDocuid != "")&&($OCDocuid != ""))	 
				{
					/// Reemplazo el ID Factura y el ID Orden para Insertar el Docuself  
					$vsqltemp = str_replace("|||||", $NDocuid , $vsql5);  
					$vsqlexec = str_replace("?????", $OCDocuid , $vsqltemp);  
					$conn->exec($vsqlexec);
				}
			}
			
			/// Recalculo los Valores Totales
			$vsqlexec = str_replace("|||||", $NDocuid , $vsqlr);
			$conn->exec($vsqlexec);

			/// La Asiento
			if($vsqlasen != "")
			{
				$vsqlexec = str_replace("|||||", $NDocuid , $vsqlreve);
				$conn->exec($vsqlexec);
				$vsqlexec = str_replace("|||||", $NDocuid , $vsqlasen);
				$conn->exec($vsqlexec);
			}
		}
		
		/// Si Finaliza el proceso la marco LOCALMENTE como en Servidor
        $clase->EjecutarSQL("UPDATE documentos SET sincronizado = CURRENT_DATE WHERE docuid = ".$docuid);
		$retorno = true;
		
		/// Cierro la Conexion y Garbage Collector
		$conn = null;
	  }
	  catch(PDOException $err) {
		echo "<b>ERROR <br> Detalle del Error : </b>" .$err->getMessage(). "<br> <b> Error No. </b> ".$err->getCode(). "<br> <b> Linea </b> ".$err->getLine();
		exit;
	  }

	 return($retorno); 
  }

   //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  function CopiarOrdenCompraAServidor($docuid)
  {
	  ini_set("memory_limit","200M");
	  set_time_limit(0);
	
	  $linea = "";      $cont="";
	  $clase = new Sistema();
	  	  
	  //// Datos del Documento
	  $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	  {
		 $vsql1 = "INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento,sincronizado) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['fecasentado']."','".$row['formapago']."',".$row['terid1'].",".$row['terid2'].",".$row['terid3'].",'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".$row['base'].",".$row['iva'].",".$row['total'].",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."',CURRENT_DATE)";  
		 $vsqlb = "SELECT docuid FROM documentos WHERE tipodoc = '".$row['tipodoc']."' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."'";  
		 $vsqlr = "CALL PA_CalValoresFCO(|||||)";   
	  } 
	  		 
	  //// Datos Docutranfe
	  $vsql="SELECT * FROM docucompra WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	     $vsql2 = "INSERT INTO docucompra(docuid,dcto1,dcto2,dcto3,dcto4,fechallegada,aplicarcondipro,diasplazo,paradias,aplicar2,convenioid,diascartera) VALUES(|||||,'".$row['dcto1']."','".$row['dcto2']."','".$row['dcto3']."','".$row['dcto4']."','".$row['fechallegada']."','".$row['aplicarcondipro']."','".(0+$row['diasplazo'])."','".(0+$row['paradias'])."','".$row['aplicar2']."','".(0+$row['convenioid'])."','".(0+$row['diascartera'])."')";   

	  //// Detalles del Documento
	  $vsql="SELECT * FROM dedocumentos WHERE docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql3 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql3[$i]= "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,
	                  porciva,valbase,valiva,valtotal) 
			  	      VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".
				      $row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].
					  ",".$row['valiva'].",".$row['valtotal'].")";     
	     $i++;				  
	  }  

	  //// Detalles de la Orden de Compra
	  $vsql="SELECT DDO.* FROM dedocuorden DDO INNER JOIN dedocumentos DD ON (DD.dedocumid = DDo.dedocumid) WHERE DD.docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql4 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql4[$i]= "INSERT INTO dedocuorden(dedocumid,precioant,dctol1,dctol2,dctol3,dctol4,obsequio) 
			  	      VALUES('".$row['dedocumid']."','".(0+$row['precioant'])."','".(0+$row['dctol1'])."','".(0+$row['dctol2'])."','".
				      (0+$row['dctol3'])."','".(0+$row['dctol4'])."','".(0+$row['obsequio'])."')";     
	     $i++;				  
	  }  
	 
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  /// Me conecto al Servidor para Ingresar el Documento allá
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  try {

		$ServidorBD = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBSERVER'");
		$NombreBD   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBNAME'");
		$UsuarioBD  = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBUSER'");
		$ClaveBD    = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBPASS'");
		
		/// Valor a Retornar
		$retorno = false;

		//// Me conecto a la Base de Datos
		$conn = new PDO("mysql:host=$ServidorBD;dbname=$NombreBD", $UsuarioBD, $ClaveBD);
		$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	
		//// Primero Busco la Toma Fisica, Si está borro todo
		foreach ($conn->query($vsqlb) as $row) 
		   $ADocuid = $row[0];
 	
	    if($ADocuid == "")
		{
				/// Si llego hasta aqui - Es por que aún estoy conectado
				/// Inserto el Encabezado - Documento
				$conn->exec($vsql1);
				foreach ($conn->query($vsqlb) as $row) 
				$NDocuid = $row[0];

				/// ReemPlazo el Docuid y luego Inserto Dedocumentos
				$vsqlexec = str_replace("|||||", $NDocuid , $vsql2);
				$filas2 = $conn->exec($vsqlexec);

				/// Recorro los detalles y Voy insertando Linea a Linea   
				foreach($vsql3 as $consulta)
				{
					if($consulta!="")
					{
						$vsqlexec = str_replace("|||||", $NDocuid , $consulta);
						$conn->exec($vsqlexec);
					}	
				}

				// Recorro los detalles y Voy insertando Linea a Linea   
				foreach($vsql4 as $consulta2)
				{
					if($consulta2!="")
					{
						$vsqlexec = str_replace("|||||", $NDocuid , $consulta2);
						$conn->exec($vsqlexec);
					}	
				}

				/// Recalculo los Valores Totales
				$vsqlexec = str_replace("|||||", $NDocuid , $vsqlr);
				$conn->exec($vsqlexec);

				/// Si Finaliza el proceso la marco LOCALMENTE como en Servidor
				$clase->EjecutarSQL("UPDATE documentos SET sincronizado = CURRENT_DATE WHERE docuid = ".$docuid);
				$retorno = true;
		}
		else
		{
			/// Si Finaliza el proceso la marco LOCALMENTE como en Servidor
			$clase->EjecutarSQL("UPDATE documentos SET sincronizado = CURRENT_DATE WHERE docuid = ".$docuid);
			$retorno = true;
		}
		
		/// Cierro la Conexion y Garbage Collector
		$conn = null;
	  }
	  catch(PDOException $err) {
		echo "<b>ERROR <br> Detalle del Error : </b>" .$err->getMessage(). "<br> <b> Error No. </b> ".$err->getCode(). "<br> <b> Linea </b> ".$err->getLine();
		exit;
	  }

	 return($retorno); 
  }


  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  function DBPedidoAServidor($docuid)
  {
	  ini_set("memory_limit","200M");
	  set_time_limit(0);
	
	  $linea = "";      $cont="";
	  $clase = new Sistema();
	  	  
	  //// Datos del Documento
	  $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	  {
		 $vsql1 = "INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento,sincronizado) VALUES('PXC','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['fechadoc']."','".$row['formapago']."',".$row['terid1'].",".$row['terid2'].",".$row['terid3'].",'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".$row['base'].",".$row['iva'].",".$row['total'].",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."',CURRENT_DATE)";  
		 $vsqlb = "SELECT docuid FROM documentos WHERE tipodoc = 'PXC' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."'";  
		 $vsqlr = "CALL PA_CalValoresGen(|||||)";   
	  } 
	  		 	  
	  //// Detalles del Documento
	  $vsql="SELECT * FROM dedocumentos WHERE docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql3 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql3[$i]= "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,
	                  porciva,valbase,valiva,valtotal) 
			  	      VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".
				      $row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].
					  ",".$row['valiva'].",".$row['valtotal'].")";     
	     $i++;				  
	  }  
	
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  /// Me conecto al Servidor para Ingresar el Documento allá
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  try {

		$ServidorBD = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBSERVER'");
		$NombreBD   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBNAME'");
		$UsuarioBD  = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBUSER'");
		$ClaveBD    = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBPASS'");
		
		/// Valor a Retornar
		$retorno = false;

		//// Me conecto a la Base de Datos
		$mysqli = new mysqli($ServidorBD,$UsuarioBD,$ClaveBD,$NombreBD);
		if ($mysqli->connect_errno) {
			return(false);
		}
		
		/// Primero Busco la Toma Fisica, Si está borro todo
		$resultado = $mysqli->query($vsqlb);
        $row = $resultado->fetch_assoc();
		   $ADocuid = $row['docuid'];
		
		if($ADocuid != "")
		{
			$vsqlexec = "DELETE IGNORE FROM dedocumentos WHERE docuid = ".$ADocuid;
			$mysqli->query($vsqlexec);
			$vsqlexec = "DELETE IGNORE FROM documentos WHERE docuid = ".$ADocuid;
			$mysqli->query($vsqlexec);
	    }

		/// Si llego hasta aqui - Es por que aún estoy conectado
		/// Inserto el Encabezado - Documento
		$mysqli->query($vsql1);

		$resultado2 = $mysqli->query($vsqlb);
		$row2 = $resultado2->fetch_assoc();
		   $NDocuid    = $row2['docuid'];
		
		/// Recorro los detalles y Voy insertando Linea a Linea   
		foreach($vsql3 as $consulta)
		{
			if($consulta!="")
			{
		     	$vsqlexec = str_replace("|||||", $NDocuid , $consulta);
				$mysqli->query($vsqlexec);
			}	
		}

		/// Recalculo los Valores Totales
		$vsqlexec = str_replace("|||||", $NDocuid , $vsqlr);
		$mysqli->query($vsqlexec);

		/// Si Finaliza el proceso la marco LOCALMENTE como en Servidor
        $clase->EjecutarSQL("UPDATE documentos SET sincronizado = CURRENT_DATE WHERE docuid = ".$docuid);
		$retorno = true;
		
		/// Cierro la Conexion y Garbage Collector
		$resultado->free();
		$mysqli->close();
	  }
	  catch(Exception $e) 
	  {
	      echo "<b>ERROR <br> Detalle del Error : </b>" .$err->getMessage(). "<br> <b> Error No. </b> ".$err->getCode(). "<br> <b> Linea </b> ".$err->getLine();
	      return(false);
	  }

	 return($retorno); 
  } 
  
  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  function ActualizarPrecioAServidor($productoid)
  {
	  ini_set("memory_limit","200M");
	  ini_set('display_errors', TRUE);
	  ini_set('display_startup_errors', TRUE);
	
	  set_time_limit(0);
	
	  $linea = "";      $cont="";
	  $clase = new Sistema();
	  	  
	  //// Datos del Documento
	  $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	  {
		 $vsql1 = "INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento,sincronizado) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['fechadoc']."','".$row['formapago']."',".$row['terid1'].",".$row['terid2'].",".$row['terid3'].",'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".$row['base'].",".$row['iva'].",".$row['total'].",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."',CURRENT_DATE)";  
		 $vsqlb = "SELECT docuid FROM documentos WHERE tipodoc = '".$row['tipodoc']."' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."'";  
		 $vsqlr = "CALL PA_CalValoresFCO(|||||)";   
	  } 
	  		 
	  //// Datos Docutranfe ->  
	  $vsql="SELECT * FROM docucompra WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	     $vsql2 = "INSERT INTO docucompra(docuid,dcto1,dcto2,dcto3,dcto4,fechallegada,aplicarcondipro,diasplazo,paradias,aplicar2,convenioid,diascartera) VALUES(|||||,'".$row['dcto1']."','".$row['dcto2']."','".$row['dcto3']."','".$row['dcto4']."','".$row['fechallegada']."','".$row['aplicarcondipro']."','".(0+$row['diasplazo'])."','".(0+$row['paradias'])."','".$row['aplicar2']."','".(0+$row['convenioid'])."','".(0+$row['diascartera'])."')";   

	  //// Detalles del Documento
	  $vsql="SELECT * FROM dedocumentos WHERE docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql3 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql3[$i]= "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,
	                  porciva,valbase,valiva,valtotal) 
			  	      VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".
				      $row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].
					  ",".$row['valiva'].",".$row['valtotal'].")";     
	     $i++;				  
	  }  

	  //// Detalles de la Orden de Compra
	  $vsql="SELECT DDO.* FROM dedocuorden DDO INNER JOIN dedocumentos DD ON (DD.dedocumid = DDo.dedocumid) WHERE DD.docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql4 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql4[$i]= "INSERT INTO dedocuorden(dedocumid,precioant,dctol1,dctol2,dctol3,dctol4,obsequio) 
			  	      VALUES('".$row['dedocumid']."','".(0+$row['precioant'])."','".(0+$row['dctol1'])."','".(0+$row['dctol2'])."','".
				      (0+$row['dctol3'])."','".(0+$row['dctol4'])."','".(0+$row['obsequio'])."')";     
	     $i++;				  
	  }  
	 
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  /// Me conecto al Servidor para Ingresar el Documento allá
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  try {

		$ServidorBD = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBSERVER'");
		$NombreBD   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBNAME'");
		$UsuarioBD  = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBUSER'");
		$ClaveBD    = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBPASS'");
		
		/// Valor a Retornar
		$retorno = false;

		//// Me conecto a la Base de Datos
		$conn = new PDO("mysql:host=$ServidorBD;dbname=$NombreBD", $UsuarioBD, $ClaveBD);
		$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	
		//// Primero Busco la Toma Fisica, Si está borro todo
		foreach ($conn->query($vsqlb) as $row) 
		   $ADocuid = $row[0];
	    	
	    if($ADocuid != "")
		{
			$vsqlexec = "DELETE IGNORE FROM dedocumentos WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
			$vsqlexec = "DELETE IGNORE FROM docucompra WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
			$vsqlexec = "DELETE IGNORE FROM documentos WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
	    }

		/// Si llego hasta aqui - Es por que aún estoy conectado
		/// Inserto el Encabezado - Documento
		$conn->exec($vsql1);
		foreach ($conn->query($vsqlb) as $row) 
		   $NDocuid = $row[0];

		/// ReemPlazo el Docuid y luego Inserto Dedocumentos
		$vsqlexec = str_replace("|||||", $NDocuid , $vsql2);
		$filas2 = $conn->exec($vsqlexec);

		/// Recorro los detalles y Voy insertando Linea a Linea   
		foreach($vsql3 as $consulta)
		{
			if($consulta!="")
			{
		     	$vsqlexec = str_replace("|||||", $NDocuid , $consulta);
				$conn->exec($vsqlexec);
			}	
		}

		// Recorro los detalles y Voy insertando Linea a Linea   
		foreach($vsql4 as $consulta2)
		{
			if($consulta2!="")
			{
		     	$vsqlexec = str_replace("|||||", $NDocuid , $consulta2);
				$conn->exec($vsqlexec);
			}	
		}

		/// Recalculo los Valores Totales
		$vsqlexec = str_replace("|||||", $NDocuid , $vsqlr);
		$conn->exec($vsqlexec);

		/// Si Finaliza el proceso la marco LOCALMENTE como en Servidor
        $clase->EjecutarSQL("UPDATE documentos SET sincronizado = CURRENT_DATE WHERE docuid = ".$docuid);
		$retorno = true;
		
		/// Cierro la Conexion y Garbage Collector
		$conn = null;
	  }
	  catch(PDOException $err) {
		echo "<b>ERROR <br> Detalle del Error : </b>" .$err->getMessage(). "<br> <b> Error No. </b> ".$err->getCode(). "<br> <b> Linea </b> ".$err->getLine();
		exit;
	  }

	 return($retorno); 
  }

  
  //////////////////////////////////////////////////////////////////////
  //// COPIA UN DOCUMENTO GENERAL AL SERVIDOR
  //// PUEDE SER PVE - REN - RSA - AJU - FIS  
  //////////////////////////////////////////////////////////////////////
  function CopiarDocumentoGeneralAServidor($docuid)
  {
	  ini_set("memory_limit","200M");
	  set_time_limit(0);
	
	  $linea = "";      $cont="";
	  $clase = new Sistema();
	  	  
	  //// Datos del Documento
	  $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  if($row = mysql_fetch_array($result))
	  {
		 $vsql1 = "INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento,sincronizado) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['fecasentado']."','".$row['formapago']."',".$row['terid1'].",".$row['terid2'].",".$row['terid3'].",'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".$row['base'].",".$row['iva'].",".$row['total'].",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."',CURRENT_DATE)";  
		 $vsqlb = "SELECT docuid FROM documentos WHERE tipodoc = '".$row['tipodoc']."' AND prefijo = '".$row['prefijo']."' AND numero = '".$row['numero']."'";  
		 $vsqlr = "CALL PA_CalValoresFCO(|||||)";   
		 $TIPODOC = $row['tipodoc'];
		 $vsqlreve = "CALL PA_ReversarDocumento(|||||)"; 
  	     $vsqlasen = "CALL PA_AsentarDocumento(|||||,'".$row['tipodoc']."')"; 
	  } 
	  		 
	  //// Detalles del Documento
	  $vsql="SELECT * FROM dedocumentos WHERE docuid = ".$docuid;
	  $conex  = $clase->Conectar();
	  $result = mysql_query($vsql,$conex);
	  $vsql3 = array();
	  $i=0;
	  while($row = @mysql_fetch_array($result))
	  {
	     $vsql3[$i]= "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,
	                  porciva,valbase,valiva,valtotal) 
			  	      VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".
				      $row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].
					  ",".$row['valiva'].",".$row['valtotal'].")";     
	     $i++;				  
	  }  

	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  /// Me conecto al Servidor para Ingresar el Documento allá
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  try {

		$ServidorBD = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBSERVER'");
		$NombreBD   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBNAME'");
		$UsuarioBD  = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBUSER'");
		$ClaveBD    = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='G_REMOTODBPASS'");
		
		/// Valor a Retornar
		$retorno = false;

		//// Me conecto a la Base de Datos
		$conn = new PDO("mysql:host=$ServidorBD;dbname=$NombreBD", $UsuarioBD, $ClaveBD);
		$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	
		//// Primero Busco la Toma Fisica, Si está borro todo
		foreach ($conn->query($vsqlb) as $row) 
		   $ADocuid = $row[0];
	    	
	    if($ADocuid != "")
		{
			$vsqlexec = "DELETE IGNORE FROM dedocumentos WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
			$vsqlexec = "DELETE IGNORE FROM documentos WHERE docuid = ".$ADocuid;
			$conn->exec($vsqlexec);
	    }

		/// Si llego hasta aqui - Es por que aún estoy conectado
		/// Inserto el Encabezado - Documento
		$conn->exec($vsql1);
		foreach ($conn->query($vsqlb) as $row) 
		   $NDocuid = $row[0];

		/// Recorro los detalles y Voy insertando Linea a Linea   
		foreach($vsql3 as $consulta)
		{
			if($consulta!="")
			{
		     	$vsqlexec = str_replace("|||||", $NDocuid , $consulta);
				$conn->exec($vsqlexec);
			}	
		}
		
		/// Recalculo los Valores Totales
		$vsqlexec = str_replace("|||||", $NDocuid , $vsqlr);
		$conn->exec($vsqlexec);
		
        ///// Asiento los Documentos que son de AFECTACION DE INVENTARIO
		if(($TIPODOC == "AJU")||($TIPODOC == "REN")||($TIPODOC == "RSA")||($TIPODOC == "DCO")||($TIPODOC == "DVE"))
        {
				$vsqlexec = str_replace("|||||", $NDocuid , $vsqlreve);
				$conn->exec($vsqlexec);

			    $vsqlexec = str_replace("|||||", $NDocuid , $vsqlasen);
				$conn->exec($vsqlexec);
		}
		
		/// Si Finaliza el proceso la marco LOCALMENTE como en Servidor
        $clase->EjecutarSQL("UPDATE documentos SET sincronizado = CURRENT_DATE WHERE docuid = ".$docuid);
		$retorno = true;
		
		/// Cierro la Conexion y Garbage Collector
		$conn = null;
	    }
	    catch(PDOException $err) {
		  echo "<b>ERROR <br> Detalle del Error : </b>" .$err->getMessage(). "<br> <b> Error No. </b> ".$err->getCode(). "<br> <b> Linea </b> ".$err->getLine();
		  exit;
	  }

	 return($retorno); 
  }



  //////////////////////////////////////////////////////////////////////
  //// NOTIFICA EL VALOR VENDIDO EN EL MOMENTO AL SERVIDOR
  //////////////////////////////////////////////////////////////////////
  function NotificarVentaMySQL($diaoperativo)
  {
	  ini_set("memory_limit","200M");
	  set_time_limit(0);

	  $linea = "";      $cont="";
	  $clase = new Sistema();

	  //// Datos del Documento
	  $vsql2 = "SELECT T2.codvende , CONCAT(T2.nombres,' ',T2.apellidos) vendedor , SUM( total ) vtageneral ,
				(
				SELECT SUM(DD2.valtotal) FROM documentos D2 INNER JOIN docuventa DV2 ON (D2.docuid = DV2.docuid) INNER JOIN dedocumentos DD2 ON (D2.docuid = DD2.docuid)                
				INNER JOIN productos P2 ON (P2.productoid = DD2.productoid) 
				WHERE D2.tipodoc = 'FVE' AND D2.fecanulado = '0000-00-00' AND D2.terid2 = T2.terid AND P2.porcenboni > 0 AND DV2.diaoperativo = '".$diaoperativo."'
				) vtaespecial ,
				(
				SELECT SUM(DD2.cantidad*DD2.valunitario*(P2.porcenboni/100)) FROM documentos D2 INNER JOIN docuventa DV2 ON (D2.docuid = DV2.docuid) INNER JOIN dedocumentos DD2 ON (D2.docuid = DD2.docuid)                
				INNER JOIN productos P2 ON (P2.productoid = DD2.productoid) 
				WHERE D2.tipodoc = 'FVE' AND D2.fecanulado = '0000-00-00' AND D2.terid2 = T2.terid AND P2.porcenboni > 0 AND DV2.diaoperativo = '".$diaoperativo."'
				) especialganado ,
				(
					SELECT SUM(DD3.cantidad) FROM dedocumentos DD3 INNER JOIN productos P3 ON (P3.productoid = DD3.productoid)
					INNER JOIN docuventa DV3 ON (DD3.docuid = DV3.docuid)
					INNER JOIN documentos D3 ON (DD3.docuid = D3.docuid)
					WHERE D3.tipodoc = 'FVE' AND P3.descripcion LIKE 'SURE%ZINC%' AND T2.terid = D3.terid2 AND DV3.diaoperativo = '".$diaoperativo."'
				) surezinc             
				FROM documentos D INNER JOIN docuventa DV ON ( D.docuid = DV.docuid ) INNER JOIN terceros T2 ON (T2.terid = D.terid2) 
				WHERE D.tipodoc =  'FVE' AND D.fecasentado <>  '0000-00-00' AND D.fecanulado =  '0000-00-00' AND DV.diaoperativo = '".$diaoperativo."' GROUP BY 1 ORDER BY 2 DESC";


		$conex  = $clase->Conectar();
		$result = mysql_query($vsql2,$conex);
		$vsql3 = array();
		$i=0;
		while($row = @mysql_fetch_array($result))
		{
			$vtagen = 0+$row['vtageneral'];
			$vtaesp = 0+$row['vtaespecial'];
			$surezinc = 0+$row['surezinc'];

			$sucursal = $_SESSION['G_SUCURSALPOS'];
			$vsqlborrar = "DELETE FROM ventasinstante WHERE codsucursal = '".$sucursal."' AND diaoperativo = '".$diaoperativo."'";
			
			$vsql3[$i]= "INSERT INTO ventasinstante(codvende,nomvende,codsucursal,diaoperativo,ventageneral,ventaespecial,surezinc) 
						 VALUES('".$row['codvende']."','".$row['vendedor']."','".$sucursal."','".$diaoperativo."','".$vtagen."','".$vtaesp."','".$surezinc."')";     
			$i++;				  
		}  

	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  /// Me conecto al Servidor para Ingresar el Documento allá
	  //////////////////////////////////////////////////////////////////////////
	  //////////////////////////////////////////////////////////////////////////
	  try {

		$ServidorBD = "dromedicas.com.co";
		$NombreBD   = "dromedic_existencias";
		$UsuarioBD  = "dromedic_exis";
		$ClaveBD    = "Barcelona2013.";
		
		/// Valor a Retornar
		$retorno = false;

		//// Me conecto a la Base de Datos
		$mysqli = new mysqli($ServidorBD,$UsuarioBD,$ClaveBD,$NombreBD);
		if ($mysqli->connect_errno) {
			return(false);
		}

		/// Elimino los registros actuales
		$mysqli->query($vsqlborrar);

		/// Recorro los detalles y Voy insertando Linea a Linea   
		foreach($vsql3 as $consulta)
		{
			if($consulta!="")
			   $mysqli->query($consulta);
		}
		
		$retorno = true;
		
		/// Cierro la Conexion y Garbage Collector
		$mysqli->close();
	  }
	  catch(Exception $e) {
	 	echo "<b>ERROR <br> Detalle del Error : </b>" .$err->getMessage(). "<br> <b> Error No. </b> ".$err->getCode(). "<br> <b> Linea </b> ".$err->getLine();
	    return(false);
	  }

	 return($retorno); 
  }

  
  //////////////////////////////////////////////////////////////////////////////
  ///// FUNCIONES FTP - Para envío de Archivos planos  
  //////////////////////////////////////////////////////////////////////////////
  
  /// Prueba si hay conexion al servidor FTP
  function ProbarConexionFTP()
  {
	include "lib/SFTP.php";

	// set SFTP object, use host, username and password
	$ftp = new SFTP("dromedicas.sytes.net", "farmanorte1", "d2218aa");
 
	// Prueba de Conexion to FTP server
	if($ftp->connect())
	   return(true);
	else
	   return(false);  
	
	$ftp->disconnect();
  }

  //////////////////////////////////////////////////////
  //// Envia Archivos al Servidor FTP
  function EnviarArchivosCierreFTP($sucursal,$periodo)
  {
	 $valor = true;
	 include "lib/SFTP.php";

	 // set SFTP object, use host, username and password
	 $ftp = new SFTP("dromedicas.sytes.net", "farmanorte1", "d2218aa");
  
     // connect to FTP server
	 if($ftp->connect()) 
	 {
		print "Conectado .. <br>";

		if($ftp->put("../Dropbox/".$sucursal."/todos/CONSOLIDA-DIA-".$sucursal.".sql", "CARGAR/CONSOLIDA-DIA-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		} else {
			$valor = false; 
			print "<br />Error al Cargar Consolidado: " . $ftp->error;
		}
  		
		if($ftp->put("../Dropbox/".$sucursal."/todos/CONSOLIDA-".$periodo."-".$sucursal.".sql", "CARGAR/CONSOLIDA-".$periodo."-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar los especiales: " . $ftp->error;
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/ESPECIALES-".$periodo."-".$sucursal.".sql", "CARGAR/ESPECIALES-".$periodo."-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar los especiales: " . $ftp->error;
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/RECARGAS-".$sucursal.".sql", "CARGAR/RECARGAS-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar las Recargas : " . $ftp->error;
		}
/*		
		if($ftp->put("../Dropbox/".$sucursal."/todos/NOCTURNOS-".$sucursal.".sql", "CARGAR/NOCTURNOS-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar los consolidados Nocturnos: " . $ftp->error;
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/CONVENIO-".$periodo."-".$sucursal.".sql", "CARGAR/CONVENIO-".$periodo."-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar los convenios: " . $ftp->error;
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/KARDEXPERIODO-".$sucursal.".sql", "CARGAR/KARDEXPERIODO-".$sucursal.".sql")) {
		   print "Archivo cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar el Kardex : " . $ftp->error;
		}
*/
		if($ftp->put("../Dropbox/".$sucursal."/todos/KARDEXTOTAL-".$sucursal.".sql", "CARGAR/KARDEXTOTAL-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		 } else {
			 $valor = false;
			 print "<br />Error al Cargar el Kardex : " . $ftp->error;
		 }
/*
		if($ftp->put("../Dropbox/".$sucursal."/todos/MASXTI-".$sucursal.".sql", "CARGAR/MASXTI-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		 } else {
			 $valor = false;
			 print "<br />Error al Cargar el detalle de Mas por Ti : " . $ftp->error;
		 }
		 if($ftp->put("../Dropbox/".$sucursal."/todos/CIERRES-".$sucursal.".sql", "CARGAR/CIERRES-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		 } else {
			 $valor = false;
			 print "<br />Error al Cargar el detalle de Cierres: " . $ftp->error;
		 }
*/
	  } else {
				// connection failed, display last error
			print "Error de Conexion: " . $ftp->error;
			$valor = false;
	  }
		
	 return($valor);
  }


  //////////////////////////////////////////////////////
  //// Envia Archivos al Servidor FTP del DIA
  //////////////////////////////////////////////////////
  function EnviarArchivosCierreFTPDia($sucursal,$periodo)
  {
	 $valor = true;
	 include "lib/SFTP.php";

	 // set SFTP object, use host, username and password
	 $ftp = new SFTP("dromedicas.sytes.net", "farmanorte1", "d2218aa");
  
     // connect to FTP server
	 if($ftp->connect()) 
	 {
		print "Conectado .. <br>";

		if($ftp->put("../Dropbox/".$sucursal."/todos/CONSOLIDA-DIA-".$sucursal.".sql", "CARGAR/CONSOLIDA-DIA-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		} else {
			$valor = false; 
			print "<br />Error al Cargar Consolidado: " . $ftp->error;
		}
  		
		if($ftp->put("../Dropbox/".$sucursal."/todos/ESPECIALES-".$periodo."-".$sucursal.".sql", "CARGAR/ESPECIALES-".$periodo."-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar los especiales: " . $ftp->error;
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/RECARGAS-".$sucursal.".sql", "CARGAR/RECARGAS-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar las Recargas : " . $ftp->error;
		}
		
		if($ftp->put("../Dropbox/".$sucursal."/todos/NOCTURNOS-".$sucursal.".sql", "CARGAR/NOCTURNOS-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar los consolidados Nocturnos: " . $ftp->error;
		}
/*
		if($ftp->put("../Dropbox/".$sucursal."/todos/CONVENIO-".$periodo."-".$sucursal.".sql", "CARGAR/CONVENIO-".$periodo."-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar los convenios: " . $ftp->error;
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/CIERRES-".$sucursal.".sql", "CARGAR/CIERRES-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		 } else {
			 $valor = false;
			 print "<br />Error al Cargar el detalle de Cierres: " . $ftp->error;
		 }
*/
	  } else {
				// connection failed, display last error
			print "Error de Conexion: " . $ftp->error;
			$valor = false;
	  }
		
	 return($valor);
  }

  //////////////////////////////////////////////////////
  //// Envia Archivos al Servidor FTP
  function EnviarArchivosVentasFTP($sucursal,$periodo)
  {
	 $valor = true;
	 include "lib/SFTP.php";

	 // set SFTP object, use host, username and password
	 $ftp = new SFTP("dromedicas.sytes.net", "farmanorte1", "d2218aa");
  
     // connect to FTP server
	 if($ftp->connect()) 
	 {
		print "Conectado .. <br>";

		if($ftp->put("../Dropbox/".$sucursal."/todos/CONSOLIDA-DIA-".$sucursal.".sql", "CARGAR/CONSOLIDA-DIA-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		} else {
			$valor = false; 
			print "<br />Error al Cargar Consolidado: " . $ftp->error;
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/CONSOLIDA-".$periodo."-".$sucursal.".sql", "CARGAR/CONSOLIDA-".$periodo."-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		} else {
			$valor = false; 
			print "<br />Error al Cargar Consolidado: " . $ftp->error;
		}

  		
		if($ftp->put("../Dropbox/".$sucursal."/todos/ESPECIALES-".$periodo."-".$sucursal.".sql", "CARGAR/ESPECIALES-".$periodo."-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar los especiales: " . $ftp->error;
		}

	  } else {
				// connection failed, display last error
			print "Error de Conexion: " . $ftp->error;
			$valor = false;
	  }
		
	 return($valor);
  }

  //////////////////////////////////////////////////////
  //// Envia Archivos al Servidor FTP
  function EnviarArchivosVentasPeriodoFTP($sucursal,$periodo)
  {
	 $valor = true;
	 include "lib/SFTP.php";

	 if($periodo == date("mY"))
	   $carpetadestino = "MESACTU";
	 else
	   $carpetadestino = "MESANTE";

	 // set SFTP object, use host, username and password
	 $ftp = new SFTP("dromedicas.sytes.net", "farmanorte1", "d2218aa");
  
     // connect to FTP server
	 if($ftp->connect()) 
	 {
		print "Conectado .. <br>";

		if($ftp->put("../Dropbox/".$sucursal."/todos/ROTACION-".$periodo."-".$sucursal.".sql", $carpetadestino."/ROTACION-".$periodo."-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		} else {
			$valor = false; 
			print "<br />Error al Cargar Consolidado:  <b>" . $ftp->error." </b> <br>";
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/VENTAS-".$periodo."-".$sucursal.".sql", $carpetadestino."/VENTAS-".$periodo."-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		} else {
			$valor = false; 
			print "<br />Error al Cargar Consolidado:  <b>" . $ftp->error." </b> <br>";
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/VENTAS2-".$periodo."-".$sucursal.".sql", $carpetadestino."/VENTAS2-".$periodo."-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		} else {
			$valor = false; 
			print "<br />Error al Cargar Consolidado:  <b>" . $ftp->error." </b> <br>";
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/CONSOLIDA-".$periodo."-".$sucursal.".sql", $carpetadestino."/CONSOLIDA-".$periodo."-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		} else {
			$valor = false; 
			print "<br />Error al Cargar Consolidado:  <b>" . $ftp->error." </b> <br>";
		}

		if($ftp->put("../Dropbox/".$sucursal."/todos/ESPECIALES-".$periodo."-".$sucursal.".sql", $carpetadestino."/ESPECIALES-".$periodo."-".$sucursal.".sql")) {
			print "Archivo Cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar los especiales: <b>" . $ftp->error." </b> <br>";
		}

	  } else {
			/// connection failed, display last error
			print "Error de Conexion:  <b>" . $ftp->error;
			$valor = false;
	  }
		
	 return($valor);
  }

  //////////////////////////////////////////////////////
  //// Envia Archivos al Servidor FTP
  function EnviarArchivosKardexFTP($sucursal,$periodo)
  {
	 $valor = true;
	 include "lib/SFTP.php";

	 // set SFTP object, use host, username and password
	 $ftp = new SFTP("dromedicas.sytes.net", "farmanorte1", "d2218aa");
  
     // connect to FTP server
	 if($ftp->connect()) 
	 {
		print "Conectado .. <br>";

		if($ftp->put("../Dropbox/".$sucursal."/todos/KARDEXTOTAL-".$sucursal.".sql", "CARGAR/KARDEXTOTAL-".$sucursal.".sql")) {
			print "Archivo cargado con Exito";
		} else {
			$valor = false; 
			print "<br />Error al Cargar Kardex Total: " . $ftp->error;
		}  		
	 }	
	 return($valor);
  }

  //////////////////////////////////////////////////////
  //// Envia Archivos al Servidor FTP
  function EnviarBackupFTP($sucursal)
  {
	 $valor = true;
	 include "lib/SFTP.php";

	 // set SFTP object, use host, username and password
	 $ftp = new SFTP("dromedicas.sytes.net", "farmanorte1", "d2218aa");
  
     // connect to FTP server
	 if($ftp->connect()) 
	 {
		print "Conectado .. <br>";

		if($ftp->put("db/copias/ULT-BAK-Completa-".$sucursal.".zip", "CARGAR/ULT-BAK-Completa-".$sucursal.".zip")) {
		   print "Archivo cargado con Exito";
		} else {
			$valor = false;
			print "<br />Error al Cargar la Copia : " . $ftp->error;
		}

	  } else {
				// connection failed, display last error
			print "Error de Conexion: " . $ftp->error;
			$valor = false;
	  }
		
	 return($valor);
  }


  //////////////////////////////////////////////////////
  //// Descargar el Archivo de Globales
  function DescargarGlobalesFTP()
  {
	$valor = true;
	include "lib/SFTP.php";
/*
	// set SFTP object, use host, username and password
	$ftp = new SFTP("dromedicas.sytes.net", "farmanorte1", "d2218aa");
 
	// connect to FTP server
	if($ftp->connect()) 
	{
	   print "Conectado .. <br>";

	   if($ftp->get("GLOBALES.sql","GLOBALES.sql")) {
		   print "Archivo ZIP Descargado con Exito";
		   $valor = true;
	   } else {
		   print "<br />Error al descargar : " . $ftp->error;
		   $valor = false;
	   }
	   
	 } else {
			   // connection failed, display last error
		   print "Error de Conexion: " . $ftp->error;
		   $valor = false;
	 }
	   */
	return($valor);
  }

  //////////////////////////////////////////////////////
  //// Descargar el Archivo de Globales
  function DescargarGlobalesFTPZIP()
  {
     $valor = true; 
	 include "lib/SFTP.php";
/*
	 // set SFTP object, use host, username and password
	 $ftp = new SFTP("dromedicas.sytes.net", "farmanorte1", "d2218aa");
  
     // connect to FTP server
	 if($ftp->connect())
	 {
      print "Conectado .. <br>";
      
      /// Elimino el archivo
      unlink("GLOBALES.zip");

      if($ftp->get("GLOBALES.zip","GLOBALES.zip")) 
      {

         print "Archivo Descargado con Exito";
         $fileupdate = "GLOBALES.zip";
         $salida = exec("unzip -o -d  ".$fileupdate." "); 
         echo $salida."<br>";
			$valor = true;
      } else {
			print "<br />Error al descargar : " . $ftp->error."<br><br>";
			$valor = false;
        }

      
	  } else {
				// connection failed, display last error
			print "Error de Conexion: " . $ftp->error."<br><br>";
			$valor = false;
	 }
	 */
  }

  //////////////////////////////////////////////////////
  //// Descargar el Archivo de Globales
  function DescargarVersionFTP()
  {
	 $valor = true;
	 include "lib/SFTP.php";

	 // set SFTP object, use host, username and password
	 $ftp = new SFTP("dromedicas.sytes.net", "farmanorte1", "d2218aa");
  
     // connect to FTP server
	 if($ftp->connect()) 
	 {
		print "Conectado .. <br>";

		if($ftp->get("version.zip","version.zip")) {
			print "Archivo ZIP Descargado con Exito";
			$valor = true;
        } else {
			print "<br />Error al descargar : " . $ftp->error;
			$valor = false;
        }
		
	  } else {
				// connection failed, display last error
			print "Error de Conexion: " . $ftp->error;
			$valor = false;
	  }
		
	 return($valor);
  }

  ///////////////////////////////////////////////////////////////////////////////////////
  //  Actualiza la tabla consolida1 desde la venta de una sucursal en un dia Operativo
  ///////////////////////////////////////////////////////////////////////////////////////
  function ActualizarVentaSucursalDiaWS($codsucursal,$diaoperativo)
  {
	 ini_set("memory_limit","200M");
	 set_time_limit(0);
	 $clase = new Sistema();

	 $rutaweb = $clase->BDlockup($codsucursal,"sucursales","codigo","rutaweb");
	 $url = $rutaweb.'wsjson/consolida/ventageneral.php?diaoperativo='.$diaoperativo;
	 echo $url."<br><br><font size=1>";
	 
	 $json = file_get_contents($url);   
	 $data = json_decode($json,true);
	 //print_r($data); exit;
	 
     $enc = "";    $det = "";  $i = 0; $NDocuid = "";
  
     while($data[$i]['tipodoc']!="") 
     { 
			if($i == 0)
            {
				//// Borro para sobreescribirlo
				$vsql = "DELETE FROM consolida1 WHERE CODSUCURSAL = '".$codsucursal."' AND (DVDIAOPE = '".$diaoperativo."' OR DDDIAOPE = '".$diaoperativo."')";
				$ret = $clase->EjecutarSQL($vsql);
				echo $vsql.";<br><br>";
				
			}
			
			if($data[$i]['codmendoc'] == "")  
				$mensajero = $data[$i]['codmendoc2'];
			else
				$mensajero = $data[$i]['codmendoc'];
			
			$puntosx = 0;                     $puntosx = 0+$data[$i]['depuntos'];
			if($data[$i]['diasrecor'] > 0) 	  
			   $agendo = substr($data[$i]['diasrecor'],0,3);        
			else     	  
			   $agendo = "";
			
			//// Luego Inserto el Encabezado
			$vsql = "INSERT INTO consolida1(TIPODOC, PREFIJODOC, NUMERODOC, FECHADOC, PERIODODOC, FORMAPAGODOC, DNICLIDOC, NOMBRESCLIDOC, APECLIDOC, DIRCLIDOC, TELCLIDOC, CODVENDOC, NOMVENDOC, APEVENDOC, 
			         CODMENDOC, NOMMENDOC, APEMENDOC, CODMEDDOC, DNIMEDDOC, NOMMEDDOC, OBSERVADOC, ITEMSDOC, VRBASEDOC, VRIVADOC, CODSUCURSAL, NOMSUCDOC, CREDORDOC, MOMENTODOC, TOTALDOC, DECODBOD, DENOMBOD, 
					 DECANTIDAD, DEVALUNI, DEVALPAR, DEVALBASE, DEVALIVA, DEVALTOTAL, DEUNICOM, DEUNIFRA, DEPUNTOS , AGENDO , DVDIAOPE, DDDIAOPE, FPEFECTIVO , FPTARJETAS , FPOTROS , CODPRODUCTO, NOMPRODUCTO, 
					 CODLABO, NOMLABO, MOMINSERTADO, COSTOPROD, PRODUCTOID, BODEGAID, SUCURSALID) 
					 VALUES ('".$data[$i]['tipodoc']."','".$data[$i]['prefijodoc']."','".$data[$i]['numerodoc']."','".$data[$i]['fechadoc']."','".$data[$i]['periododoc']."','".$data[$i]['formapagodoc']."','".
					 limpiarCaracteresEspeciales($data[$i]['dniclidoc'])."','".substr(limpiarCaracteresEspeciales($data[$i]['nombresclidoc']),0,34)."','".substr(limpiarCaracteresEspeciales($data[$i]['apeclidoc']),0,34).
					 "','".substr(limpiarCaracteresEspeciales($data[$i]['dirclidoc']),0,30)."','".limpiarCaracteresEspeciales($data[$i]['telclidoc'])."','".$data[$i]['codvendoc']."','".$data[$i]['nomvendoc']."','".
					 $data[$i]['apevendoc']."','".$mensajero."','".$data[$i]['nommendoc']."','".$data[$i]['apemendoc']."','".$data[$i]['codmeddoc']."','".$data[$i]['dnimeddoc']."','".$data[$i]['nommeddoc']."','".$data[$i]['procedencia'].
					 "','".$data[$i]['itemsdoc']."','".$data[$i]['vrbasedoc']."','".$data[$i]['vrivadoc']."','".$data[$i]['codsucursal']."','".$data[$i]['nomsucdoc']."','".$data[$i]['credordoc']."','".$data[$i]['momentodoc']."','".
					 $data[$i]['totaldoc']."','".$data[$i]['decodbod']."','".$data[$i]['denombod']."','".$data[$i]['decantidad']."','".$data[$i]['devaluni']."','".$data[$i]['devalpar']."','".(0+$data[$i]['devalbase'])."','".
					 (0+$data[$i]['devaliva'])."','".(0+$data[$i]['devaltotal'])."','".$data[$i]['deunicom']."','".$data[$i]['deunifra']."','".$puntosx."','".$agendo."','".$data[$i]['dvdiaope']."','".$data[$i]['dddiaope'].
					 "',".(0+$data[$i]['fpefectivo']).",".(0+$data[$i]['fptarjetas']).",".(0+$data[$i]['fpotros']).",'".$data[$i]['codproducto']."','".substr($data[$i]['nomproducto'],0,70)."','".$data[$i]['codlabo'].
					 "','".substr($data[$i]['nomlabo'],0,50)."',CURRENT_TIMESTAMP,'".$data[$i]['costoprod']."','".$data[$i]['productoid']."','".$data[$i]['bodegaid']."','".$data[$i]['sucursalid']."');";	   
			$ret = $clase->EjecutarSQL($vsql);
			echo $vsql."<br><br>";   
			
			$i++;
		}  
		
		$clase->EjecutarSQL("UPDATE consolida1 SET DEVALPAR  = DEVALUNI*DECANTIDAD WHERE DEVALPAR = 0 AND DVDIAOPE = '".$diaoperativo."' AND DECODBOD = '".$codsucursal."'");
		$clase->EjecutarSQL("UPDATE consolida1 SET DEVALBASE = DEVALTOTAL*DEVALIVA WHERE DEVALBASE = 0 AND DVDIAOPE = '".$diaoperativo."' AND DECODBOD = '".$codsucursal."'");
		$clase->EjecutarSQL("UPDATE consolida1 SET DEVALIVA  = DEVALTOTAL-DEVALBASE WHERE DEVALBASE = 0 AND DVDIAOPE = '".$diaoperativo."' AND DECODBOD = '".$codsucursal."'");
		$clase->EjecutarSQL("UPDATE consolida1 SET VRBASEDOC = TOTALDOC-VRIVADOC WHERE VRBASEDOC = 0 AND VRIVADOC = 0 AND DEVALPAR = 0 AND DVDIAOPE = '".$diaoperativo."' AND DECODBOD = '".$codsucursal."'");
	} 
	
  ///////////////////////////////////////////////////////////////////////////////////////
  //  Actualiza la tabla consolida1 desde la venta de una sucursal en un dia Operativo
  ///////////////////////////////////////////////////////////////////////////////////////
  function ActualizarEspecialesSucursalDiaWS($codsucursal,$diaoperativo)
  {
	 ini_set("memory_limit","200M");
	 set_time_limit(0);
	 $clase = new Sistema();

	 $rutaweb = $clase->BDlockup($codsucursal,"sucursales","codigo","rutaweb");
	 $url = $rutaweb.'wsjson/consolida/ventaespecial.php?diaoperativo='.$diaoperativo;
	 echo $url."<br><br><font size=1>";
	 
	 $json = file_get_contents($url);   
     $data = json_decode($json,true);

     $enc = "";    $det = "";  $i = 0; $NDocuid = "";
  
     while($data[$i]['fecha']!="") 
     { 
			if($i == 0)
            {
				//// Borro para sobreescribirlo
				$diax = substr($diaoperativo,6,4)."-".substr($diaoperativo,3,2)."-".substr($diaoperativo,0,2);
				$vsql = "DELETE FROM consolida2 WHERE CODSUCURSAL = '".$codsucursal."' AND FECHAESPE = '".$diax."'";
				$ret = $clase->EjecutarSQL($vsql);
				echo $vsql."<br><br>";
			}
			
			if($data[$i]['codmendoc'] == "")  
				$mensajero = $data[$i]['codmendoc2'];
			else
				$mensajero = $data[$i]['codmendoc'];
			
			$puntosx = 0;                     $puntosx = 0+$data[$i]['depuntos'];
			if($data[$i]['diasrecor'] > 0) 	  
			   $agendo = substr($data[$i]['diasrecor'],0,3);        
			else     	  
			   $agendo = "";
			
			//// Luego Inserto el Encabezado
			$vsql = "INSERT IGNORE INTO consolida2(PERIODOESPE, FECHAESPE , CODVENDE , NOMVENDE , CODPRODUCTO , NOMPRODUCTO , CANTIVENTA , VALORVENTA , 
			         PORCENBONI , VALORCOMI , CODSUCURSAL ,  NOMSUCURSAL , PAGADO) VALUES ('".
					 $data[$i]['periodo']."','".$data[$i]['fecha']."','".$data[$i]['codvende']."','".$data[$i]['nomvende']."','".$data[$i]['codpro']."','".$data[$i]['nompro']."','".
					 $data[$i]['cantidad']."','".$data[$i]['valorventa']."','".$data[$i]['porcenboni']."','".$data[$i]['valorcomi']."','".$data[$i]['codsuc']."','".
					 $data[$i]['nomsuc']."','".$data[$i]['pagado']."')";	   
			$ret = $clase->EjecutarSQL($vsql);
			echo $vsql."<br><br>";   

			$i++;
		}  
	} 

	//////////////////////////////////////////////////////////////
	/// Envia a la Sucursal - Via WebService una Transferencia
	//////////////////////////////////////////////////////////////
	function TransferenciaWebServiceSucursal($documento,$sucursal)
	{
		$clase = new Sistema();
		$url   = $clase->BDLockup($sucursal,"sucursales","codigo","rutaweb"); 
		$cadena = 'C:/Appserv/www/dropos/lib/consolebrowser/consolewebopen.exe "'.$url.'demonio/suc/transferencias/push.php?documento='.$documento.'"';
		shell_exec($cadena);
		return;
	}

	/////////////////////////////////////////////////////////////
	/// Envia a la Sucursal - Via WebService una Transferencia
	/////////////////////////////////////////////////////////////
	function TransferenciaWebServiceSucursalReemplazar($documento,$sucursal)
	{
		$clase = new Sistema();
		$url   = $clase->BDLockup($sucursal,"sucursales","codigo","rutaweb"); 
		$cadena = 'C:/Appserv/www/dropos/lib/consolebrowser/consolewebopen.exe "'.$url.'demonio/suc/transferencias/pushload.php?documento='.$documento.'"';
		shell_exec($cadena);
		return;
	}

  //////////////////////////////////////////////////////////////////////
  ////           Impresion de Ajuste de Inventario
  //////////////////////////////////////////////////////////////////////  
  function ImpresionPOSGeneralWS($docuid,$carpeta="print",$copias=1)
  {
     $clase = new Sistema();	 
	 $nomempresa = $clase->BDLockup('G_NOMBRE_EMPRESA','configuraciones','variab','contenido');
     $cont = $nomempresa.Chr(13).Chr(10);	 
	 
	 /// Cargo las configuraciones del Prefijo del Documento
	 $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	 $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");	  
	 $nomdocumento = $clase->BDLockup($tipodoc,"tipodoc","codigo","descripcion");	  
	 
	 /// Hago la Consulta de los datos de la Factura 		
	 $vsql = "SELECT D.tipodoc , D.prefijo , D.numero , D.fechadoc , D.creador , D.fecanulado , D.observacion , D.iva ,  D.total , D.momento , T.dni codcliente , D.terid2 , D.terid3 , 
	 		  CONCAT(T.nombres,' ',T.apellidos) nomcliente , T.dni , T.direccion , T.telfijo , DD.bodegaid , P.codigo codproducto , P.descripcion nomproducto , DD.valunitario , 
			  SUM(DD.cantidad) cantidad , SUM(DD.unidades) unidades ,  SUM(DD.valparcial) valparcial 
			  FROM documentos D INNER JOIN terceros T ON (T.terid = D.terid1)
			  INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
			  INNER JOIN productos P ON (P.productoid = DD.productoid)
			  WHERE D.docuid=".$docuid." GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21 ";

     if($tipodoc == "AJU")
	   $vsql.= 'ORDER BY cantidad DESC , P.descripcion';
	   
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
     
 	 while($row = @mysql_fetch_array($result))
	 { 
	   $teriddomi = $row['terid3'];
	   $tipodoc = $row['tipodoc'];                       $prefijo = $row['prefijo'];
 	   $numero  = $row['numero'];
 	   $fecha   = substr($row['fechadoc'],8,2)."/".substr($row['fechadoc'],5,2)."/".substr($row['fechadoc'],0,4);
 	   $hora    = substr($row['momento'],11,2).":".substr($row['momento'],14,2); 	   

   	   $observacion = $row['observacion'];  	   
   	   $cantidad = $row['cantidad']; 
	   $creador  = $row['creador']; 	   
   	   $total    = $row['total']; 
	     
	   if($tipodoc == "AJU")
	   {    
    	 if($cantidad < 0)  $mov = "SAL - "; else $mov = "ENT - ";
		 $bodega = $clase->BDLockup($row['bodegaid'],'bodegas','bodegaid','codbodega');
		 $encabezado1 = ''; 
	     $detalles.= $mov.str_pad(substr($row['nomproducto'],0,20),20," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad(number_format($row['unidades'],1),3," ",STR_PAD_LEFT).'  '.str_pad(number_format($row['valparcial'],0),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
		 $titulodet = 'MOV   PRODUCTO             CANT      TOTAL';
	   }
	   
	   if(($tipodoc == "REN")||($tipodoc == "INF"))
	   {    
	     $bodega = $clase->BDLockup($row['bodegaid'],'bodegas','bodegaid',"nombodega");
		 $encabezado1 = 'BODEGA   : '.$bodega; 
		 $detalles.= str_pad(substr($row['nomproducto'],0,26),26," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad($row['cantidad'],3," ",STR_PAD_LEFT).'  '.str_pad(number_format($row['valparcial']),9," ",STR_PAD_LEFT).Chr(13).Chr(10); 	   
		 $titulodet = 'PRODUCTO                 CANT      TOTAL';
	   }
	   
	   if($tipodoc == "TRB")
	   {    
	     $bodegaori = $clase->BDLockup($row['bodegaid'],'bodegas','bodegaid',"nombodega");
		 $vsql1 = "SELECT nombodega FROM bodegas B INNER JOIN docutranfe DT ON (DT.bodegaidori = B.bodegaid) WHERE docuid=".$docuid;
		 $vsql2 = "SELECT nombodega FROM bodegas B INNER JOIN docutranfe DT ON (DT.bodegaiddes = B.bodegaid) WHERE docuid=".$docuid;		 
		 $bodori = $clase->SeleccionarUno($vsql1);
		 $boddes = $clase->SeleccionarUno($vsql2);		 
		 $encabezado1 = 'BOD. ORIGEN : '.$bodori.Chr(13).Chr(10);
		 $encabezado1.= 'BOD. DESTIN : '.$boddes;
		 $detalles.= str_pad(substr($row['nomproducto'],0,24),24," ",STR_PAD_RIGHT).'  ';
	     $detalles.= str_pad($row['unidades'],3," ",STR_PAD_LEFT).'  '.str_pad(number_format($row['valparcial']),9," ",STR_PAD_LEFT).Chr(13).Chr(10);;
		 $detalles.= "Cod Barras : ".$row['codproducto'].Chr(13).Chr(10); 	   
		 
		 $titulodet = 'PRODUCTO                 CANT      TOTAL';
	   } 
	   	 
     } 
     $cont.= $nomdocumento.Chr(13).Chr(10);
	 $cont.= 'No.'.$prefijo.' '.$numero.Chr(13).Chr(10);
     $cont.= '----------------------------------------'.Chr(13).Chr(10); 
	 $cont.= 'OBS : '.$observacion.Chr(13).Chr(10);	 	 
     $cont.= '----------------------------------------'.Chr(13).Chr(10); 	 
	 $cont.= 'FECHA   : '.$fecha.'      Hora : '.$hora.Chr(13).Chr(10);	 
	 $cont.= 'CREADOR : '.$creador.Chr(13).Chr(10);	 
     if($encabezado1 != "")
	 {
	    $cont.= '----------------------------------------'.Chr(13).Chr(10);          	 	
	    $cont.= $encabezado1.Chr(13).Chr(10);
	 }
	 $cont.= '----------------------------------------'.Chr(13).Chr(10);          	 	
     $cont.= $titulodet.Chr(13).Chr(10);
     $cont.= '========================================'.Chr(13).Chr(10);     
	 $cont.= $detalles;	 
	 $cont.= '                          --------------'.Chr(13).Chr(10);     
	 $cont.= '         TOTAL DOC : '.$_SESSION['G_MONEDALOCAL'].'   '.str_pad(number_format($total),16," ",STR_PAD_LEFT).Chr(13).Chr(10);     	 
	 $cont.= Chr(13).Chr(10).Chr(13).Chr(10).'.'.Chr(13).Chr(10);     
	 $cont.= "\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X0A\X0D\X1B@\X0A\X0D\X1Bi\X0A\X0D";

	 for($c=0;$c<$copias;$c++)
	 {
	    // Genero el Archivo para Enviarlo a Impresora
	    if($carpeta == "autoprint")
	       $archivo= "../Dropbox/00/autoprint/".$prefijo.$numero."-".$c.".txt"; // el nombre de tu archivo
	    else
		{
			$tipo = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","tipoimpresion");
			if($tipo == "G")
			{
				/// 1. Le Aplico Permisos a la Carpeta PDF
				chmod($acceso."print/", 0777);
				/// 2. Genero la Impresion  
				$archivo= "print/".$prefijo.$numero."-".$c.".txt"; // el nombre de tu archivo
				/// 3. Le Aplico Permisos al archivo
				chmod("print/imprimircierre.txt", 0777);					
			}			    
			else
			    $archivo= "print/".$prefijo.$numero."-".$c.".txt"; // el nombre de tu archivo
		}


        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch, $cont); // Grabas
        fclose($fch); // Cierras el archivo

        $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
        fwrite($fch, $cont); // Grabas
        fclose($fch); // Cierras el archivo
     }
	 
	 // Lo Adiciono a la tira de Seguridad de la Impresion
	 $archivo= "log/".date("dmy")."impresora.txt"; // el nombre de tu archivo
     $fch= fopen($archivo, "a"); // Abres el archivo para escribir en él
     fwrite($fch, $cont); // Grabas
     fclose($fch); // Cierras el archivo
	 	 
  } // Fin de la Funcion

  ///////////////////////////////////////////////////////////////////
  /// Almacena en una Tabla las Cargas de las Remisiones
  ///////////////////////////////////////////////////////////////////
  function GuardarLogCargaRemision($docuid)
  {
	 $clase = new Sistema();
	 
	 $tipodoc = $clase->BDLockup($docuid,"documentos","docuid","tipodoc");
	 $prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");
	 $numero  = $clase->BDLockup($docuid,"documentos","docuid","numero");

	 $vsql  = "INSERT INTO logcargaremisiones(docuid,tipodoc,prefijo,numero,usuario,momento) VALUES(".$docuid.",'".$tipodoc."','".$prefijo."','".$numero."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
	 $clase->EjecutarSQL($vsql);
	 return;
  }

  ///////////////////////////////////////////////////////////////////
  /// Valida Si Hay Internet o no
  ///////////////////////////////////////////////////////////////////
  function HayInternet()
  {
    $json = file_get_contents('http://dromedicas.sytes.net:9999/dropos/wsjson/consolida/internet.php');   
	$data = json_decode($json,true);
	if(strlen($data)>5)
	   return(true);
    else
       return(false);
  }  

    /////////////////////////////////////////////////////////////////////////////
	//// Generar JSON Transferencia
	/////////////////////////////////////////////////////////////////////////////  
	function GuardarJSONTransferencia($docuid)
	{
	    $clase = new Sistema();
		
		$message = Array();		
		$jsontotal = "";
		$encab = ""; 
		$detalle = Array();

		$prefijo = $clase->BDLockup($docuid,"documentos","docuid","prefijo");
		$numero  = $clase->BDLockup($docuid,"documentos","docuid","numero");
		$bodegaidori = $clase->BDLockup($docuid,"docutranfe","docuid","bodegaidori");
		$bodegaiddes = $clase->BDLockup($docuid,"docutranfe","docuid","bodegaiddes");
		$codbodegaori = $clase->BDLockup($bodegaidori,"bodegas","bodegaid","codbodega");
		$codbodegades = $clase->BDLockup($bodegaiddes,"bodegas","bodegaid","codbodega");
	
		//// Consulta SQL para el Encabezado del Documento
		if($prefijo == "CRU")
		{
			$vsql2 = "SELECT D.docuid , D.tipodoc,D.prefijo,D.numero, D.periodo, D.fechadoc, D.fecvence, D.fecasentado, D.fecanulado, D.formapago, D.nrodocref , D.importado, D.terid1,D.terid2, D.terid3, 
					D.codigo1, D.codigo2, D.codigo3, '' as observacion , D.observacion2, D.retefuente, D.reteiva, D.reteica, D.descuentogen,  D.ajustebase, D.ajusteiva, D.ajusteneto, D.base, D.iva, 
					D.impoconsumo, D.total, D.saldo, D.anticipo, D.impreso, D.totalitems, D.sucursalid, D.creador, D. momento,  D.contabilizado,  D.numcomprobante,  
					D.estadosincro,  D.sincronizado,  D.autoimpreso,  D.regenerado,  D.auditado , DT.*
					FROM documentos D INNER JOIN docutranfe DT ON (D.docuid = DT.docuid) WHERE D.docuid = ".$docuid;
		}
		else
		{
			$vsql2 = "SELECT D.docuid , D.tipodoc,D.prefijo,D.numero, D.periodo, D.fechadoc, D.fecvence, D.fecasentado, D.fecanulado, D.formapago, D.nrodocref , D.importado, D.terid1,D.terid2, D.terid3, 
					D.codigo1, D.codigo2, D.codigo3,  D.observacion , D.observacion2, D.retefuente, D.reteiva, D.reteica, D.descuentogen,  D.ajustebase, D.ajusteiva, D.ajusteneto, D.base, D.iva, 
					D.impoconsumo, D.total, D.saldo, D.anticipo, D.impreso, D.totalitems, D.sucursalid, D.creador, D. momento,  D.contabilizado,  D.numcomprobante,  
					D.estadosincro,  D.sincronizado,  D.autoimpreso,  D.regenerado,  D.auditado , D.numdocuoriginal , DT.*
					FROM documentos D INNER JOIN docutranfe DT ON (D.docuid = DT.docuid) WHERE D.docuid = ".$docuid;
		}

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql2,$conex);
		while($row = mysql_fetch_array($result)) 
		{
			$encab = $row;
		}
		
		//// Ahora el Detalle
		$vsql2 = "SELECT docuid,  productoid,  bodegaid, tipund,  costoprod,  valunitario, porciva,  valbase, diasrecor,  obsrecor,  numlinea, docuref,  observalinea,  
		          SUM(valiva) valiva , SUM(valico) valico , SUM(valtotal) valtotal ,  SUM(unicom) unicom ,  SUM(unifra) unifra , SUM(cantidad) cantidad ,  
				  SUM(unidades) unidades , SUM(valparcial) valparcial   
		          FROM dedocumentos  
		          WHERE docuid = ".$docuid." 
		          GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13";
		$result = mysql_query($vsql2,$conex);
		while($row2 = mysql_fetch_array($result)) 
		{
		   $detalle[] = $row2;
		}
	 		
		/// Ahora saco los detalles
		$message["code"] = "20";
		$message["encabezado"] = $encab;
		$message["detalle"] = $detalle;
		$jsontotal = json_encode($message);
		
		/// Lo guardo en el Documento
		$confirmacion = $clase->EjecutarSQL("UPDATE documentos SET documentojson = '".$jsontotal."' WHERE docuid = ".$docuid);
		$confirmacion = $clase->EjecutarSQL("DELETE FROM jsondocumentos WHERE docuid = ".$docuid);
		$confirmacion = $clase->EjecutarSQL("INSERT INTO jsondocumentos(docuid,documentojson) VALUES(".$docuid.",'".$jsontotal."')");

		//// Lo guardo en la nueva Tabla
		$clase->EjecutarSQL("DELETE FROM documentosxdescargar WHERE docuid = ".$docuid);
		$vsqlnew = "INSERT INTO documentosxdescargar(docuid,numerodoc,bodegaidori,codbodegaori,bodegaiddes,codbodegades,documentojson) 
		            VALUES(".$docuid.",'TRB".$prefijo.$numero."',".$bodegaidori.",'".$codbodegaori."',".$bodegaiddes.",'".$codbodegades."','".$jsontotal."')";
		$clase->EjecutarSQL($vsqlnew);

 		/// Retorno
		return(1); 
		
	} // Fin de GuardarJSONTransferencia  


	////////////////////////////////////////////////
	//// Notificacion de Envio de Transferencia
	////////////////////////////////////////////////
    function EnviarMailTransferencia($numerodoc,$asunto,$destino1,$destino2)
    {
        require 'lib/PHPMailer/PHPMailerAutoload.php';
        $mail = new PHPMailer;
        $mail->isSMTP();
        $mail->SMTPDebug = 2;
        $mail->Debugoutput = 'html';
        $mail->Port = 587;
        $mail->SMTPSecure = 'tls';
        $mail->SMTPAuth = true;
        $mail->Timeout=20;
        $mail->CharSet = 'UTF-8';
        $mail->Host = $_SESSION['G_HOSTCORREO'];
        $mail->Username = $_SESSION['G_USERCORREO'];
        $mail->Password = $_SESSION['G_CLAVECORREO'];
        $mail->setFrom('sistemas@dromedicas.com.co', 'DROPOS ERP Notificaciones');
        $mail->addReplyTo('sistemas@dromedicas.com.co', 'DROPOS ERP Notificaciones');
		$mail->addAddress($destino1, "Drogueria Farmanorte");
		if($destino2 != "")
		   $mail->addAddress($destino2, "Drogueria Farmanorte");

        $mail->Subject = $asunto;
                
        $mail->isHTML(true);       
		$mail->Body = "Se ha generado una Transferencia a su Sistema. <br>
		               El numero es el <b>".$numerodoc."</b> <br> 
					   Para Visualizarla <a href='http://dromedicas.sytes.net:9999/dropos/public/imptranfe.php?numerodoc=".$numerodoc."' target='_Blank> VER AQUI </a> <br>
					   Este Email fue generado automaticamente por nuestro Sistema. ";
        $errores = 0;
        if (!$mail->send())
          $errores++;
	}

    /////////////////////////////////////////////////////////////////////////////
	//// Borra un Pedido del Transito Local cuando se carga la Transferencia
	/////////////////////////////////////////////////////////////////////////////  
	function BorrarTransitoLocalSucursal($numpedido,$numpedido2="",$docuidtrb="")
	{
		$clase = new Sistema();
		
		//// Borro Los transitos temporales
		EliminarTransitosVencidos();

		//// Borro los transitos metodologia Nueva 
		//// Aplicada 8 May 2025 
		if(strlen($numpedido)>4)
		{
			$vsqldel = "DELETE FROM transitosucursales WHERE numpedido LIKE '%".$numpedido."'";
			$clase->EjecutarSQL($vsqldel);			
		} 

		if(strlen($numpedido2)>4)
		{
			$vsqldel = "DELETE FROM transitosucursales WHERE numpedido LIKE '%".$numpedido2."'";
			$clase->EjecutarSQL($vsqldel);			
		} 
		
		//// Borro los del Pedido indicado
		if(($docuidtrb != "")&&($numpedido2 != ""))
		{
            $vsql = "DELETE FROM transitosucursales 
			         WHERE (numpedido = '".$numpedido."' OR numpedido = '".$numpedido2."' OR numpedido = 'PVE".$numpedido."' OR numpedido = 'PVE".$numpedido2."') AND
			         productoid IN (SELECT productoid FROM dedocumentos WHERE docuid = ".$docuidtrb.")";   
		}
		else
		{
			if($numpedido2 != "")
			   $vsql = "DELETE FROM transitosucursales WHERE (numpedido = '".$numpedido2."' OR numpedido = 'PVE".$numpedido2."')";   	
			else
			   $vsql = "DELETE FROM transitosucursales WHERE (numpedido = '".$numpedido."'OR numpedido = 'PVE".$numpedido."')";   				
		}
		$clase->EjecutarSQL($vsql);		
		return;
	}	
	
	/////////////////////////////////////////////////////////////////////////////
	//// Crea el Transito Local cuando se Asienta el pedido 
	/////////////////////////////////////////////////////////////////////////////  
	function CrearTransitoLocalSucursal($docuid)
	{
		$clase = new Sistema();
        
		//// Borro Los transitos temporales y con Error
		EliminarTransitosVencidos();

		//// Busco el Numero del Pedido
		$numpedido = $clase->SeleccionarUno("SELECT CONCAT(tipodoc,prefijo,numero) FROM documentos WHERE docuid = ".$docuid);

        //// Elimino el transito Asociado a ese Numero  
		$clase->EjecutarSQL("DELETE FROM transitosucursales WHERE numpedido = '".$numpedido."'");

		$vsql = "SELECT * FROM dedocumentos WHERE docuid = ".$docuid;
		$conex  = $clase->Conectar();
		$result = @mysql_query($vsql,$conex);
		while($row = @mysql_fetch_array($result))
		{ 
		  $pid   = $row['productoid'];
		  $canti = $row['cantidad'];
		  
		  $vsqlx = "INSERT INTO transitosucursales(productoid,cantidad,numpedido,fecinicio,fecfin,momento) VALUES('".$pid."','".$canti."','".$numpedido."',CURRENT_DATE,DATE_ADD(NOW(), INTERVAL 6 DAY),CURRENT_TIMESTAMP)";
		  $clase->EjecutarSQL($vsqlx);
		}
		return;
	}

	/////////////////////////////////////////////////////////////////////////////////////////
	//// Crea el Transito Local EN SERVIDOR de los Pedidos Separados de otro Pedido
	//// DEPRECIATED .  Este proceso queda inmerso en el Despacho del Pedido desde Stellar
	/////////////////////////////////////////////////////////////////////////////////////////  
	function CrearTransitoPedidoServidor($docuid)
	{
	    /*
	 	$clase = new Sistema();

		$fechadoc    = substr($clase->BDLockup($docuid,"documentos","docuid","fechadoc"),0,10);
		$numremision = $clase->SeleccionarUno("SELECT CONCAT(prefijo,numero) FROM documentos WHERE docuid = ".$docuid);
		$numpedido   = $clase->BDLockup($docuid,"documentos","docuid","nrodocref");
        $codsucursal = $clase->SeleccionarUno("SELECT S.codigo FROM sucursales S INNER JOIN documentos D ON (D.sucursalid = S.sucursalid) WHERE D.docuid = ".$docuid);
		
        if(($numpedido == 'SUGERIDO')||($numpedido == 'URGENTE')||($numpedido == 'ESPECIAL')||($numpedido == 'INTEGRAL'))
		{
		    $numpedidox = $numremision;
			$numremisionx = $numpedido;
			
			$numpedido = $numpedidox;
			$numremision = "";
		}

		$vsql = "SELECT DISTINCT productoid , sum(cantidad) cantidad FROM dedocumentos WHERE docuid = ".$docuid." GROUP BY 1";
		$conex  = $clase->Conectar();
		$result = @mysql_query($vsql,$conex);
		$i=0;
		while($row = @mysql_fetch_array($result))
		{ 
			$pid   = $row['productoid'];
			$canti = $row['cantidad'];

			//// Primero hago Delete
			$clase->EjecutarSQL("DELETE FROM transitosucursales WHERE numpedido = '".$numpedido."' AND productoid = ".$pid);

			//// Luego Insert
			if($canti>0)
			{
				$vsqlx = "INSERT INTO transitosucursales(productoid,cantidad,numpedido,numremision,fecinicio,fecfin,codsucursal,momento) 
						  VALUES('".$pid."','".$canti."','".$numpedido."','".$numremision."',CURRENT_DATE,DATE_ADD(NOW(), INTERVAL 6 DAY),'".$codsucursal."',CURRENT_TIMESTAMP)";
				$clase->EjecutarSQL($vsqlx);
			}	

			$i++;
		}  // Fin While
        */		
		return; 
	}

	////////////////////////////////////////////////////////////////////////////////////
	//// Reemplaza el Transito de un Pedido 
	///////////////////////////////////////////////////////////////////////////////////  
	function ReemplazarTransitoPedidoxRemision($docuid,$numpedido)
	{
		$clase = new Sistema();
        
		$codsucursal = $clase->SeleccionarUno("SELECT S.codigo FROM sucursales S INNER JOIN documentos D ON (D.sucursalid = S.sucursalid) WHERE D.docuid = ".$docuid);
		$numpedido   = $clase->BDLockup($docuid,"documentos","docuid","nrodocref");
		$fechadoc    = substr($clase->BDLockup($docuid,"documentos","docuid","fechadoc"),0,10);
		$numremision = $clase->SeleccionarUno("SELECT CONCAT(prefijo,numero) FROM documentos WHERE docuid = ".$docuid);

		if(($numpedido == 'SUGERIDO')||($numpedido == 'URGENTE')||($numpedido == 'ESPECIAL'))
		{
		    $numpedidox = $numremision;
			$numremisionx = $numpedido;
			
			$numpedido = $numpedidox;
			$numremision = "";
		}

		$vsql = "SELECT productoid , SUM(cantidad) cantidad FROM dedocumentos WHERE docuid = ".$docuid." group by 1";
		$conex  = $clase->Conectar();
		$result = @mysql_query($vsql,$conex);
		$i=0;
		while($row = @mysql_fetch_array($result))
		{ 
		  $pid   = $row['productoid'];
		  $canti = $row['cantidad'];
		  		  
		  if($i==0)
		     $clase->EjecutarSQL("DELETE FROM transitosucursales WHERE numpedido = '".$numpedido."'");

		  $vsqlx = "INSERT INTO transitosucursales(productoid,cantidad,numpedido,numremision,fecinicio,fecfin,codsucursal,momento) 
		            VALUES('".$pid."','".$canti."','".$numpedido."','".$numremision."',CURRENT_DATE,DATE_ADD(NOW(), INTERVAL 6 DAY),'".$codsucursal."',CURRENT_TIMESTAMP)";
		  $clase->EjecutarSQL($vsqlx);

		  $i++;
		}
		return;
	}


    ////////////////////////////////////////////////////////////////////////////////////
	//// Elimina los Transitos que ya dejaron de estar Activos
	///////////////////////////////////////////////////////////////////////////////////  
	/*
	function EliminarTransitosVencidos()
	{
		$clase = new Sistema();
		
		$vsql = "DELETE FROM transitosucursales WHERE (fecfin < CURRENT_DATE) OR (cantidad < 1) OR (numpedido LIKE 'F%*%' OR numpedido LIKE 'PVEF%*%')";
		$clase->EjecutarSQL($vsql);

		//// Borro los transitos Duplicados que son Errores
		$vsql = "SELECT DISTINCT productoid , numpedido , COUNT(*) repetidos , (SELECT transitoid FROM transitosucursales 
				 WHERE TS.productoid = productoid AND TS.numpedido = numpedido limit 0,1) noborrar FROM transitosucursales TS 
				 GROUP BY 1,2 HAVING repetidos>1";
        $conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		while($row = mysql_fetch_array($result))
		{
			$pid = $row['productoid'];
			$num = $row['numpedido'];
			$nob = $row['noborrar'];

			$vsqlx = "DELETE FROM transitosucursales WHERE productoid = ".$pid." AND numpedido = '".$num."' AND transitoid <> ".$nob;
			$clase->EjecutarSQL($vsqlx);
		}	 

		$vsql = "SELECT nrodocref FROM documentos WHERE tipodoc = 'TRB' AND prefijo = 'REM' AND LENGTH(nrodocref)>3 IS NOT NULL ORDER BY fechadoc DESC , docuid DESC LIMIT 0,100";
        $conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		while($row = mysql_fetch_array($result))
		{
			$numeropedido = trim($row['nrodocref']);
			$vsqlx = "DELETE FROM transitosucursales WHERE (numpedido = '".$numeropedido."' OR numpedido = 'PVE".$numeropedido."')";
			$clase->EjecutarSQL($vsqlx);
		}	 

	    return;
	}
*/

    ////////////////////////////////////////////////////////////////////////////////////
	//// Elimina los Transitos que ya dejaron de estar Activos
	///////////////////////////////////////////////////////////////////////////////////  
	function EliminarTransitosVencidos()
	{
		$clase = new Sistema();
		
		$vsql = "DELETE FROM transitosucursales WHERE DATEDIFF( CURRENT_DATE , fecinicio ) >= 5";
		$clase->EjecutarSQL($vsql);
        
		return;
	}

	////////////////////////////////////////////////////////////////////////////////////
	//// Descarga los Productos Excluidos para Devoluciones de Excesos
	///////////////////////////////////////////////////////////////////////////////////  
	function SincronizarProductosExcluidosDevoluexcesos()
	{
		$clase = new Sistema();
	
		$URLSERVIDOR = "http://192.168.14.244:9999";
		$URLSERVIDOR = "http://dromedicas.sytes.net:9999";
		$json = file_get_contents($URLSERVIDOR.'/dropos/wsjson/consolida/excluirexcesos.php'); 
		$data = json_decode($json);
		
		$ultimoid = $clase->SeleccionarUno("SELECT MAX(id) as id FROM excluirexcesos");
		$i = 0; 

		while(@$data[$i]->id != "")
		{
			$id   = $data[$i]->id;
		    $prid = $data[$i]->productoid;
			$grid = $data[$i]->gruposprodid;
			$crea = $data[$i]->creador;
			$mome = $data[$i]->momento;

			if($id > $ultimoid)
			{
                $vsqlins = "INSERT INTO excluirexcesos(id,productoid,gruposprodid,creador,momento) VALUES('".$id."', '".$prid."','".$grid."','".$crea."','".$mome."')";
				$clase->EjecutarSQL($vsqlins);
			}
			
			$i++;
		}

	    return;
	}
	
    ////////////////////////////////////////////////////////////////////////////////////
	//// Aplicar transito desde TXC
	///////////////////////////////////////////////////////////////////////////////////  
	function AplicarNuevoTransitoPedidos5dias()
	{
		$clase = new Sistema();

		//// Cargo el Transito desde TXC
		$vsql = "SELECT docuid FROM documentos WHERE tipodoc = 'PVE' AND nrodocref = 'INTEGRAL' AND DATEDIFF(CURRENT_DATE,fechadoc)<=4";
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$registros = mysql_num_rows($result);
		
		while($row = mysql_fetch_array($result))
		{
			$docuid     = $row['docuid'];
			CrearTransitoLocalSucursal($docuid);
		}
		return;    
	}

	////////////////////////////////////////////////////////////////////////////////////
	//// Aplicar transito desde TXC
	///////////////////////////////////////////////////////////////////////////////////  
	function GenerarTransitoPedidoenServidoralCargar($docuid)
	{
		$clase = new Sistema();

		//// Cargo el Transito desde TXC
		$vsql = "SELECT D.tipodoc , D.prefijo , D.numero , DD.productoid , DD.cantidad , S.codigo codsuc , D.fechadoc   
		         FROM documentos D INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
				 INNER JOIN sucursales S ON (S.sucursalid = D.sucursalid) 
				 WHERE D.docuid = ".$docuid;
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$registros = mysql_num_rows($result);		
		$i = 0;
		while($row = mysql_fetch_array($result))
		{
			$docuid      = $row['docuid'];
			$fecha       = substr($row['fechadoc'],0,10);
			$pedido      = $row['tipodoc'].$row['prefijo'].$row['numero'];
			$productoid  = $row['productoid'];
			$cantidad    = $row['cantidad'];
			$codsuc      = $row['codsuc'];
			$numremision = "";
           
			if($i == 0)
			{
				$vsql = "DELETE FROM transitosucursales WHERE numpedido = '".$pedido."'";            
				echo $vsql."<br>"; 
                $clase->EjecutarSQL($vsql); 
			}			

			$vsql = "INSERT INTO transitosucursales(productoid,cantidad,numpedido,fecinicio,codsucursal) 
			         VALUES('".$productoid."','".$cantidad."','".$pedido."','".$fecha."','".$codsuc."')";              	

			echo $vsql."<br>"; 
			$clase->EjecutarSQL($vsql);
			
			$i++;
		}
		return;    
	}


	
    ////////////////////////////////////////////////////////////////////////////////////
	//// Aplicar transito desde TXC
	///////////////////////////////////////////////////////////////////////////////////  
	function AplicarNuevoTransitoWebservice()
	{
		$clase = new Sistema();

		$URLSERVIDOR = "http://192.168.14.244:9999";
		$URLSERVIDOR = "http://dromedicas.sytes.net:9999";
		$json = file_get_contents($URLSERVIDOR.'/dropos/wsjson/nuevomodtransito/dataparaeliminartransito.php?sucursal='.$_SESSION['G_SUCURSALPOS']); 
		$data = json_decode($json);
        $i = 0;

		while($data[$i]->productoid != "")
		{
			$pedido      = $data[$i]->numpedidooriginal;
			$productoid  = $data[$i]->productoid;
			$cantidad    = $data[$i]->cantidad;
			$numremision = $data[$i]->numremision;
           
            if($cantidad<=0) 
			   $vsql = "DELETE FROM transitosucursales WHERE productoid = '".$productoid."' AND numpedido LIKE '%".trim(substr($pedido,3,20))."%'";            
			else
			   $vsql = "UPDATE transitosucursales SET cantidad = '".$cantidad."' , numremision = '".$numremision."' 
			            WHERE productoid = '".$productoid."' AND (numpedido LIKE '%".trim(substr($pedido,3,20))."%' OR numpedido = 'PVE".trim($pedido)."')";              	

			//echo $vsql."<br>"; 
			$clase->EjecutarSQL($vsql);
			
			$i++;
		}

		return;    
	}

	////////////////////////////////////////////////////////////////////////////////////
	//// Elimina los Transitos Duplicados en la Misma Remision
	///////////////////////////////////////////////////////////////////////////////////  
	function EliminarTransitosDuplicadosSucursal()
	{
		$clase = new Sistema();

		//// Cargo el Transito desde TXC
		$vsql = "SELECT productoid , numremision , COUNT(*) repeticiones 
 				 FROM transitosucursales 
				 WHERE numremision IS NOT NULL 
				 GROUP BY 1,2
				 HAVING repeticiones > 1";
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$registros = mysql_num_rows($result);

		while($row = mysql_fetch_array($result))
		{
			$productoid  = $row['productoid'];    
			$numremision = $row['numremision'];
            
			$transitoid = $clase->SeleccionarUno("SELECT transitoid FROM transitosucursales WHERE productoid = ".$productoid." AND numremision = '".$numremision."' LIMIT 0,1");

			$vsql = "DELETE FROM transitosucursales WHERE productoid = ".$productoid." AND numremision = '".$numremision."' AND transitoid <> ".$transitoid;
			$clase->EjecutarSQL($vsql);
		}

		//// Cargo el Transito desde TXC
		$vsql = "SELECT productoid , IF(SUBSTRING(numpedido,1,3)='PVE',numpedido,CONCAT('PVE',numpedido)) pedido , COUNT(*) repeticiones 
 				 FROM transitosucursales 
				 WHERE 1 
				 GROUP BY 1,2 
				 HAVING repeticiones > 1";
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$registros = mysql_num_rows($result);

		while($row = mysql_fetch_array($result))
		{
			$productoid  = $row['productoid'];    
			$numremision = $row['pedido'];
            
			$transitoid = $clase->SeleccionarUno("SELECT transitoid FROM transitosucursales WHERE productoid = ".$productoid." AND numpedido = '".$numremision."' LIMIT 0,1");

			$vsql = "DELETE FROM transitosucursales WHERE productoid = ".$productoid." AND numpedido = '".$numremision."' AND transitoid <> ".$transitoid;
			$clase->EjecutarSQL($vsql);
		}

		return;
	}


	/////////////////////////////////////////////////////////////////////////////
	//// Crea el Transito Local cuando se Asienta el pedido 
	/////////////////////////////////////////////////////////////////////////////  
	function CrearTransitoLocalSucursaldesdeWS($docuid)
	{
		$clase = new Sistema();
        		
		$URLSERVIDOR = "http://192.168.14.244:9999";
		$URLSERVIDOR = "http://dromedicas.sytes.net:9999";
		$json = file_get_contents($URLSERVIDOR.'/dropos/wsjson/nuevomodtransito/detallespedidoparatransito.php?docuid='.$docuid); 
		$data = json_decode($json);
        $i = 0;
		
		while($data[$i]->productoid != "")
		{
			$pid  = $data[$i]->productoid;
			$sol  = $data[$i]->solicitado;
			$exi  = $data[$i]->existencias;
			$num  = $data[$i]->numero;
			$nrem = $data[$i]->numero_rem;
			$fec  = $data[$i]->fechadoc;

			if($sol>=$exi)
			   $cantidad = $exi;
			else
			{
				if($exi == 0)
				   $cantidad = 0;
				else
				   $cantidad = $sol;
			}

			if($cantidad>0)
			{
					$vsql = "INSERT INTO transitosucursales(productoid,cantidad,numpedido,fecinicio,fecfin,momento) 
							 VALUES('".$pid."','".$cantidad."','PVE".$num."','".$fec."',CURRENT_DATE,CURRENT_TIMESTAMP)";	
					$clase->EjecutarSQL($vsql);
			}

			$i++;
		}		
		
		//// Borro Los transitos temporales y con Error
		EliminarTransitosVencidos();

		return;
	}




	////////////////////////////////////////////////////////////////////////////////////
	//// Aplicar transito desde TXC
	///////////////////////////////////////////////////////////////////////////////////  
	function AplicarNuevoTransitoTXC()
	{
		$clase = new Sistema();

		//// Cargo el Transito desde TXC
		$vsql = "SELECT D.numero ,  DD.productoid , SUM(DD.cantidad) canti FROM  documentos D INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) WHERE D.tipodoc = 'TXC' GROUP BY 1,2";
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$registros = mysql_num_rows($result);
		
		if($registros>0)
		   $clase->EjecutarSQL("TRUNCATE transitosucursales");

		while($row = mysql_fetch_array($result))
		{
			$productoid = $row['productoid'];    
			$cantidad   = $row['canti'];
			$numero     = $row['numero'];

			$vsql = "INSERT INTO transitosucursales(productoid,cantidad,numpedido,fecinicio,fecfin,momento) 
			         VALUES('".$productoid."','".$cantidad."','TRB REM ".$numero."',CURRENT_DATE,CURRENT_DATE,CURRENT_TIMESTAMP)";	
			$clase->EjecutarSQL($vsql);
    	}
	   return;
	}


    ////////////////////////////////////////////////////////////////////////////////////
	//// Descarga el Transito que está en el Servidor
	///////////////////////////////////////////////////////////////////////////////////  
	function DescargarTransitoServidor()
	{
		$clase = new Sistema();

		//// Borro Los transitos temporales
		//EliminarTransitosVencidos();
		
		$URLSERVIDOR = "http://192.168.14.244:9999";
		$URLSERVIDOR = "http://dromedicas.sytes.net:9999";
		$json = file_get_contents($URLSERVIDOR.'/dropos/wsjson/transitopedidos/transitoservidor.php?codsucursal='.$_SESSION['G_SUCURSALPOS']); 
		$data = json_decode($json);

		$detalles = ""; $i = 0; $totalacum = 0;
		$pedidoactual = "";
		while(@$data[$i]->transitoid != "")
		{
		    /// Extraigo el Numero Original
			$numerooriginal = explode("-",$data[$i]->numpedido);

			///////////////////////////////////////////////////////////////////////////////////
            //// Pueden Pasar 2 Cosas : a) Pedidos sin Raya   b)  
            if($numerooriginal[1] == "")   // Sin Raya
			{
				/// Si es un pedido Nuevo - Borre lo anterior que hay
				if($pedidoactual != $numerooriginal)
				{
					/// Borro el Transito de ese Numero de Pedido
					if(strlen($data[$i]->numpedido)>4)
					{
						$vsql = "DELETE FROM transitosucursales WHERE (numpedido = '".$data[$i]->numpedido."' OR numpedido = 'PVE".$data[$i]->numpedido."')";
						//echo $vsql."*<br>";		
						$clase->EjecutarSQL($vsql);
					}
	                
					/// Lo almaceno como pedido Actual 
					$pedidoactual = $numerooriginal;
				}	
				
				/// Inserto el Transito del Peido con Raya 
				$vsql = "INSERT INTO transitosucursales(productoid,cantidad,numpedido,fecinicio,fecfin,momento) 
							VALUES('".$data[$i]->productoid."','".$data[$i]->cantidad."','".$data[$i]->numpedido."','".$data[$i]->fecinicio."','"
						.$data[$i]->fecfin."','".$data[$i]->momento."')";	
				//echo $vsql."*<br>";		
				$clase->EjecutarSQL($vsql);
			} 

            ////////////////////////////////////////////////////////////////////////////////
			if($numerooriginal[1] != "")   // Pedidos con Raya
			{
				/// Borro el Transito de ese Numero de Pedido
				if((strlen($data[$i]->productoid)>3)&&(strlen($data[$i]->numpedido>4)))
				{
				   $vsql = "DELETE FROM transitosucursales WHERE productoid = ".$data[$i]->productoid." AND (numpedido = '".$data[$i]->numpedido."' OR numpedido = 'PVE".$data[$i]->numpedido."')";
				   //echo $vsql."*<br>";		
			   	   $clase->EjecutarSQL($vsql);
				}
	            
				/// Inserto el Transito del Pedido con Raya 
				$vsql = "INSERT INTO transitosucursales(productoid,cantidad,numpedido,fecinicio,fecfin,momento) 
					 	 VALUES('".$data[$i]->productoid."','".$data[$i]->cantidad."','".$data[$i]->numpedido."','".$data[$i]->fecinicio."','"
						 .$data[$i]->fecfin."','".$data[$i]->momento."')";	
				$clase->EjecutarSQL($vsql);
                //echo $vsql."**<br>";
			} 

			$i++;	
		}


        //// Si Recorrió - Confirme que si estan cargados
		if($i>0)
		{
			$json = file_get_contents($URLSERVIDOR.'/dropos/wsjson/transitopedidos/confirmarcarga.php?codsucursal='.$_SESSION['G_SUCURSALPOS']); 
		    $data = json_decode($json);
		}
	
        return;
	}


	////////////////////////////////////////////////////////////////////////////////////
	//// Descarga el Transito que está en el Servidor
	///////////////////////////////////////////////////////////////////////////////////  
	function DescargarProveedoresServidor()
	{
		$clase = new Sistema();

		//$URLSERVIDOR = "http://192.168.14.244:9999";
		$URLSERVIDOR = "http://dromedicas.sytes.net:9999";
		$json = file_get_contents($URLSERVIDOR.'/dropos/wsjson/consolida/proveedores.php'); 
		$data = json_decode($json);

		$detalles = ""; $i = 0; $totalacum = 0;
		$pedidoactual = "";
		while(@$data[$i]->dni != "")
		{		
			/// Inserto el Transito del Peido con Raya 
			$vsql= "INSERT IGNORE INTO terceros(codigo,dni,cedulade,tipodoc,nombres,apellidos,nomtributario,fecnaci,genero,direccion,telfijo,telmovil,
					ciudadid,zonaterid,gruposperid,creador,momento) 
					VALUES ('".$data[$i]->dni."','".$data[$i]->dni."','','CEC','".$data[$i]->nombres."','".$data[$i]->apellidos."','".$data[$i]->nombres.
					"','0000-00-00','F','','','',1,1,1,'SYSTEM',CURRENT_TIMESTAMP)";

			//echo $vsql."*<br>";		
			$clase->EjecutarSQL($vsql);
		
			$i++;	
		}
	
        return;
	}

	////////////////////////////////////////////////////////////////////////////////////
	//// Actualiza los precios 
	///////////////////////////////////////////////////////////////////////////////////  
	function ActualizarPreciosDesdeServidor()
	{
		$clase = new Sistema();
		$URLSERVIDOR = "http://192.168.14.244:9999";
		$URLSERVIDOR = "http://dromedicas.sytes.net:9999";
		$json = file_get_contents($URLSERVIDOR.'/dropos/wsjson/consolida/productosprecios.php'); 
		$data = json_decode($json);

		$detalles = ""; $i = 0; 
		while(@$data[$i]->productoid != "")
		{
		    /// Actualizo el Registro
			$vsql = "UPDATE productos SET codigo = '".$data[$i]->codigo."' , codbarra = '".$data[$i]->codbarra."' , descripcion = '".$data[$i]->descripcion."' , 
			         gruposprodid = '".$data[$i]->gruposprodid."' , factor1 = '".$data[$i]->factor1."' , factor2 = '".$data[$i]->factor2."' , 
					 precio1g = '".$data[$i]->precio1g."' , precio1m = '".$data[$i]->precio1m."' , precio1d = '".$data[$i]->precio1d."' , 
					 precio2g = '".$data[$i]->precio2g."' , precio2m = '".$data[$i]->precio2m."' , precio2d = '".$data[$i]->precio2d."' , 
					 porcenboni = '".$data[$i]->porcenboni."' , bloqueado = '".$data[$i]->bloqueado."'
                     WHERE productoid = ".$data[$i]->productoid;	
			//		 echo $vsql."<br>";
			$clase->EjecutarSQL($vsql);
		
			$i++;	
		}
	    return;
	}
	
   /////////////////////////////////////////////////////////////////////////////////////
   //////////////////////////////////////////////////////////////////////////////////////
   function EnviarCierreWebsevice($diaoperativo,$sucid="")
   {
		ini_set("memory_limit","200M");                            set_time_limit(0);
		$clase = new Sistema();
		if($sucid == "")  $sucid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");

		//// Primero Paso los Valores de Control
		$vsql = "SELECT DV.diaoperativo , SUM(D.total) ventageneral , (SELECT ROUND(SUM(valorventa)) FROM bonificado WHERE fecha = STR_TO_DATE(DV.diaoperativo,'%d/%m/%Y')) ventaespecial 
		         FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo = '".$diaoperativo."'"; 
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$vgc = 0;    $vec = 0;
		if($row = mysql_fetch_array($result))
		{
			$vgc = 0+$row['ventageneral'];        
			$vec = 0+$row['ventaespecial'];
		}

		//// Luego paso los Valores del Cierre
		if($sucid == "")
		   $vsql = "SELECT * FROM cierres WHERE tipocierre = 'DEF' AND diaoperativo = '".$diaoperativo."'";
		else
		   $vsql = "SELECT * FROM cierres WHERE tipocierre = 'DEF' AND diaoperativo = '".$diaoperativo."' AND sucid = ".$sucid;
 
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		if($row = mysql_fetch_array($result))
		{
			$codsuc  = $clase->BDLockup($sucid,"sucursales","sucursalid","codigo");
			$diaope  = $diaoperativo; 
			$totarq  = 0+$row['totalarqueo'];        
			$devolu  = 0+$row['devoluciones'];        
			$faltan  = 0+$row['faltante'];        
			$sobran  = 0+$row['sobrante'];         
			$valdat  = 0+$row['valdatafono'];       
			$credit  = 0+$row['totcreditos'];     
			$venexc  = round(0+$row['ventaexcluida']);       
			$base19  = round(0+$row['valbase19']);       
			$iva19   = round(0+$row['valiva19']);       
			$base05  = round(0+$row['valbase05']);       
 			$iva05   = round(0+$row['valiva05']); 
			
			$pun     = 0+$row['totpuntos'];       
			$vga     = 0+$row['valgastos'];       
			$vco     = 0+$row['valcompras'];       
			$vte      = 0+$row['valterceros'];  
			$idcierre = 0+$row['cierreid'];     
			
			$vrap   = 0+$row['valrappi'];  
			$vpas   = 0+$row['valpasarela'];  
			$vbil   = 0+$row['valbilleteras'];  
				
			/// Consumo el Webservice para Enviar los Datos del Cierre
			if($_SESSION["G_MODOTRABAJO"] == "SERVIDOR")
			{
				$json = file_get_contents('http://192.168.14.244:9999/dropos/wsjson/recibirdatoscierre/datoscierres.php?codsucursal='.urlencode($codsuc).'&diaoperativo='.urlencode($diaope).'&totalarqueo='.urlencode($totarq).'&devoluciones='.urlencode($devolu).'&faltante='.urlencode($faltan).'&sobrante='.urlencode($sobran).'&valdatafono='.urlencode($valdat).'&totcreditos='.urlencode($credit).'&ventaexcluida='.urlencode($venexc).'&valbase19='.urlencode($base19).'&valiva19='.urlencode($iva19).'&valbase05='.urlencode($base05).'&valiva05='.urlencode($iva05).'&valgastos='.urlencode($vga).'&valcompras='.urlencode($vco).'&valterceros='.urlencode($vte).'&valpuntos='.urlencode($pun).'&vegecon='.urlencode($vgc).'&veescon='.urlencode($vec).'&cierreidlocal='.urlencode($idcierre).'&valrappi='.urlencode($vrap).'&valbilleteras='.urlencode($vbil).'&vpasarela='.urlencode($vpas));
				echo 'http://192.168.14.244:9999/dropos/wsjson/recibirdatoscierre/datoscierres.php?codsucursal='.urlencode($codsuc).'&diaoperativo='.urlencode($diaope).'&totalarqueo='.urlencode($totarq).'&devoluciones='.urlencode($devolu).'&faltante='.urlencode($faltan).'&sobrante='.urlencode($sobran).'&valdatafono='.urlencode($valdat).'&totcreditos='.urlencode($credit).'&ventaexcluida='.urlencode($venexc).'&valbase19='.urlencode($base19).'&valiva19='.urlencode($iva19).'&valbase05='.urlencode($base05).'&valiva05='.urlencode($iva05).'&valgastos='.urlencode($vga).'&valcompras='.urlencode($vco).'&valterceros='.urlencode($vte).'&valpuntos='.urlencode($pun).'&vegecon='.urlencode($vgc).'&veescon='.urlencode($vec).'&cierreidlocal='.urlencode($idcierre).'&valrappi='.urlencode($vrap).'&valbilleteras='.urlencode($vbil).'&vpasarela='.urlencode($vpas);
			}
			else
			{
				$json = file_get_contents('http://dromedicas.sytes.net:9999/dropos/wsjson/recibirdatoscierre/datoscierres.php?codsucursal='.urlencode($codsuc).'&diaoperativo='.urlencode($diaope).'&totalarqueo='.urlencode($totarq).'&devoluciones='.urlencode($devolu).'&faltante='.urlencode($faltan).'&sobrante='.urlencode($sobran).'&valdatafono='.urlencode($valdat).'&totcreditos='.urlencode($credit).'&ventaexcluida='.urlencode($venexc).'&valbase19='.urlencode($base19).'&valiva19='.urlencode($iva19).'&valbase05='.urlencode($base05).'&valiva05='.urlencode($iva05).'&valgastos='.urlencode($vga).'&valcompras='.urlencode($vco).'&valterceros='.urlencode($vte).'&valpuntos='.urlencode($pun).'&vegecon='.urlencode($vgc).'&veescon='.urlencode($vec).'&cierreidlocal='.urlencode($idcierre).'&valrappi='.urlencode($vrap).'&valbilleteras='.urlencode($vbil).'&valpasarela='.urlencode($vpas));	
				echo 'http://192.168.14.244:9999/dropos/wsjson/recibirdatoscierre/datoscierres.php?codsucursal='.urlencode($codsuc).'&diaoperativo='.urlencode($diaope).'&totalarqueo='.urlencode($totarq).'&devoluciones='.urlencode($devolu).'&faltante='.urlencode($faltan).'&sobrante='.urlencode($sobran).'&valdatafono='.urlencode($valdat).'&totcreditos='.urlencode($credit).'&ventaexcluida='.urlencode($venexc).'&valbase19='.urlencode($base19).'&valiva19='.urlencode($iva19).'&valbase05='.urlencode($base05).'&valiva05='.urlencode($iva05).'&valgastos='.urlencode($vga).'&valcompras='.urlencode($vco).'&valterceros='.urlencode($vte).'&valpuntos='.urlencode($pun).'&vegecon='.urlencode($vgc).'&veescon='.urlencode($vec).'&cierreidlocal='.urlencode($idcierre).'&valrappi='.urlencode($vrap).'&valbilleteras='.urlencode($vbil).'&vpasarela='.urlencode($vpas);
			}

			$resultado = json_decode($json);   
		}    
		return;
    }	

   /////////////////////////////////////////////////////////////////////////////////////
   //////////////////////////////////////////////////////////////////////////////////////
   function EnviarDatosControlCierreWebsevice($diaoperativo,$sucid="")
   {
		ini_set("memory_limit","200M");                            set_time_limit(0);
		$clase = new Sistema();
		if($sucid == "")  $sucid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");

		//// Primero Paso los Valores de Control
		$vsql = "SELECT DV.diaoperativo , SUM(D.total) ventageneral , (SELECT ROUND(SUM(valorventa)) FROM bonificado WHERE fecha = STR_TO_DATE(DV.diaoperativo,'%d/%m/%Y')) ventaespecial 
		         FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo = '".$diaoperativo."'"; 
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$vgc = 0;    $vec = 0;
		if($row = mysql_fetch_array($result))
		{
			$vgc = 0+$row['ventageneral'];        
			$vec = 0+$row['ventaespecial'];
		}
		
		/// Consumo el Webservice para Enviar los Datos del Cierre
		if($_SESSION["G_MODOTRABAJO"] == "SERVIDOR")
		{
			$json = file_get_contents('http://192.168.14.244:9999/dropos/wsjson/recibirdatoscierre/solodatoscontrol.php?codsucursal='.urlencode($_SESSION['G_SUCURSALPOS']).'&diaoperativo='.urlencode($diaoperativo).'&vegecon='.urlencode($vgc).'&veescon='.urlencode($vec));
			//echo 'http://192.168.14.253:9999/dropos/wsjson/recibirdatoscierre/solodatoscontrol.php?codsucursal='.urlencode($_SESSION['G_SUCURSALPOS']).'&diaoperativo='.urlencode($diaoperativo).'&vegecon='.urlencode($vgc).'&veescon='.urlencode($vec);
		}
		else
		{
			$json = file_get_contents('http://dromedicas.sytes.net:9999/dropos/wsjson/recibirdatoscierre/solodatoscontrol.php?codsucursal='.urlencode($_SESSION['G_SUCURSALPOS']).'&diaoperativo='.urlencode($diaoperativo).'&vegecon='.urlencode($vgc).'&veescon='.urlencode($vec));	
			//echo 'http://dromedicas.sytes.net:9999/dropos/wsjson/recibirdatoscierre/solodatoscontrol.php?codsucursal='.urlencode($_SESSION['G_SUCURSALPOS']).'&diaoperativo='.urlencode($diaoperativo).'&vegecon='.urlencode($vgc).'&veescon='.urlencode($vec);
		}

		$resultado = json_decode($json);   
		    
		return;
    }	


  	//////////////////////////////////////////////////////////////////////////////////////////// 
	/// Marca en el Servidor lo Autorizado en el DIA XX
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function MarcarEnServidorAutorizaciones($diaoperativo)
	{
		ini_set("memory_limit","200M");                            set_time_limit(0);
		$clase = new Sistema();

		$vsql = "SELECT * FROM autorizacionesgastos WHERE diaoperativo = '".$diaoperativo."'";
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$lista = "";
		while($row = mysql_fetch_array($result))
		{
			$autid = $row['autorizaid'];
			$lista.= $autid."|";
		}

		if($_SESSION["G_MODOTRABAJO"] == "SERVIDOR")
		   $json = file_get_contents('http://192.168.14.253:9999/dropos/wsjson/recibirdatoscierre/marcarautorizacionesdia.php?sucursal='.urlencode($_SESSION['G_SUCURSALPOS']).'&diaoperativo='.urlencode($diaoperativo).'&numeros='.urlencode($lista));   	
		else
		   $json = file_get_contents('http://dromedicas.sytes.net:9999/dropos/wsjson/recibirdatoscierre/marcarautorizacionesdia.php?sucursal='.urlencode($_SESSION['G_SUCURSALPOS']).'&diaoperativo='.urlencode($diaoperativo).'&numeros='.urlencode($lista));   	   

		$data = json_decode($json,true);
		return;
	}

	//////////////////////////////////////////////////////////////////////////////////////////// 
	/// Marca en el Servidor lo Autorizado en el DIA XX
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function EnviarAServidorVentasCR($diaoperativo,$codsucursal)
	{   
		$clase = new Sistema();
		$sucid = $clase->BDLockup($codsucursal,"sucursales","codigo","sucursalid");
	    $vsql = "SELECT CONCAT( D.tipodoc , D.prefijo , D.numero ) numfactura, ROUND(total) total , D.formapago, (valorfp2) tarjetas , DV.aprofp2 , DV.aprofp3 , 
		         T.nombres , T.apellidos , DV.valorfp7 , DV.aprofp7 , TR.codigoDeAprobacion 				 
				 FROM documentos D INNER JOIN docuventa DV ON ( D.docuid = DV.docuid ) 
				 LEFT JOIN terceros T ON (T.terid = D.terid1)
				 LEFT JOIN transaccionescredibanco TR ON (TR.docuid = D.docuid) 
				 WHERE DV.diaoperativo = '".$diaoperativo."' AND D.sucursalid = ".$sucid." AND ( D.formapago = 'CR' OR ( DV.valorfp2 >0) OR ( DV.valorfp7 >0) )";
        
        $conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		while($row = mysql_fetch_array($result))
		{
			$total       = $row['total'];
			$tarjetas    = $row['tarjetas'];
			$numfactura  = $row['numfactura'];
			$nomtercero  = $row['nombres'].' '.$row['apellidos'];
			if($nomtercero == "")
			   $nomtercero = "TERCERO NO DISPONIBLE";
			
			$descripcion = trim($row['aprofp2'].' '.$row['aprofp3']);
			if(($row['valorfp7'] > 0)&&($row['aprofp7'] != ""))
			    $tarjetas = $row['valorfp7'];

			if($row['formapago'] == "CR")
			   $tipo    = 'CREDITO';
			else
			{
				if(($row['valorfp7'] > 0)&&($row['aprofp7'] != ""))
				{
					$tipo        = 'PASARELA';   
					$descripcion = $total;
				}
				else
			       $tipo    = 'TARJETA';   
			}
			
            ////////////////////////////////////////////////////
			///// Ajuste para el envio de la Data TEF CLOUD
			if($descripcion == "TEF-CLOUD")
			{
				$tipotef      = "TEF-CLOUD"; 
				$autorizacion = $row['autorizaciontef'];  
			}	
			else
			{
                $tipotef      = ""; 
				$autorizacion = $descripcion; 
			}
               

            ////// Creo el JSON
			$array = [
				'tipo' => $tipo,
				'diaoperativo' => $diaoperativo,
				'codsucursal' => $codsucursal,
				'numfactura' => $numfactura,
				'numfactura2' => $tipotef,
				'nomtercero' => $nomtercero, 
				'descripcion' => $autorizacion,
				'total' => $total,
				'tarjetas' => $tarjetas,
				'autorizaid' => ''
			];

			$arrayFinal[$i] = $array;         
			$i++;
		}

        ///// Consumo el Servicio
		if($_SESSION["G_MODOTRABAJO"] == "SERVIDOR")
			$url = "http://192.168.14.253:9999/dropos/wsjson/recibirdatoscierre/recibirtarjetasycreditos.php";
		else
		    $url = "http://dromedicas.sytes.net:9999/dropos/wsjson/recibirdatoscierre/recibirtarjetasycreditos.php";
					
		$ch = curl_init($url);

		//// creo el JSON 
		$mandar =  json_encode(array("data" => $arrayFinal));

		// Attach encoded JSON string to the POST fields
		curl_setopt($ch, CURLOPT_POSTFIELDS, $mandar);

		// Set the content type to application/json
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

		// Return response instead of outputting
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute the POST request
		$json = curl_exec($ch);

		//echo $mandar." ---- ".$json;

		// Close cURL resource
		curl_close($ch);

		return;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////// 
	/// Notifica la Existencia a Droposv2 en la Tienda 
	//////////////////////////////////////////////////////////////////////////////////////////// 
    function NotificarVentaATienda($docuid)
	{
		$clase = new Sistema();
		$sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");
		$bodegaid   = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],"bodegas","codbodega","bodegaid");
		
		$vsql = "SELECT DV.diaoperativo , D.tipodoc , D.prefijo , D.numero , CLI.dni , T.coddomi , DD.productoid , E.cantidad canti , DD.valunitario , SUM(DD.cantidad) vendi 
				 FROM documentos D 
				 INNER JOIN docuventa DV ON (DV.docuid = D.docuid)
				 INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
				 INNER JOIN terceros CLI ON (CLI.terid = D.terid1) 
				 INNER JOIN terceros T ON (T.terid = D.terid3) 
				 INNER JOIN existencias E ON (DD.productoid = E.productoid AND E.bodegaid = ".$bodegaid.")
				 WHERE D.docuid = ".$docuid."
				 GROUP BY 1,2,3,4,5,6,7,8,9";

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		while($row = mysql_fetch_array($result))
		{
			$diaoperativo= $row['diaoperativo'];
			$tipodoc     = $row['tipodoc'];
			$prefijo     = $row['prefijo'];
			$numero      = $row['numero'];
			$coddomi     = $row['coddomi'];
			$dnicliente  = $row['dni'];
			$valunitario = $row['valunitario'];

			$productoid    = $row['productoid'];
			$cantidad      = $row['canti'];
			$cantidadVenta = $row['vendi'];
			
			$array = [
				'tipo' => '1',
				'diaoperativo' => $diaoperativo,
				'tipodoc' => $tipodoc,
				'prefijo' => $prefijo, 
				'numero' => $numero, 
				'codmensajero' => $coddomi,
				'dnicliente' => $dnicliente, 
				'preciounitario' => $valunitario,
				'sucursalid' => $sucursalid,
				'productoid' => $productoid,
				'cantidad' => $cantidad,
				'cantidad_venta' => $cantidadVenta,
				'key' => md5($sucursalid.'~'.$productoid.'~'.$cantidad)
			];

			$arrayFinal[$i] = $array;
			$i++;
		}
        $mandar = json_encode($arrayFinal);
    	$url = "http://plataforma.farmanorteonline.com/existencias-actualizar?id=".$mandar;

		// Consumo el Webservice con CURL
		$json = file_get_contents($url);   	
		return;
	}

	/////////////////////////////////////////////////////////////////////////////////////////// 
	/// Notifica la Existencia a Droposv2 en la Tienda 
	//////////////////////////////////////////////////////////////////////////////////////////// 
    function NotificarDevolucionATienda($docuid)
	{
		$clase = new Sistema();
		$sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");
		$bodegaid   = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],"bodegas","codbodega","bodegaid");
		
		$vsql = "SELECT DV.diaoperativo , D.tipodoc , D.prefijo , D.numero , CLI.dni , DD.productoid , E.cantidad canti , DD.valunitario , SUM(DD.cantidad) vendi 
				 FROM documentos D 
				 INNER JOIN docudevolucion DV ON (DV.docuid = D.docuid)
				 INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
				 INNER JOIN terceros CLI ON (CLI.terid = D.terid1) 
				 INNER JOIN existencias E ON (DD.productoid = E.productoid AND E.bodegaid = ".$bodegaid.")
				 WHERE D.docuid = ".$docuid."
				 GROUP BY 1,2,3,4,5,6,7,8";

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		while($row = mysql_fetch_array($result))
		{
			$diaoperativo= $row['diaoperativo'];
			$tipodoc     = $row['tipodoc'];
			$prefijo     = $row['prefijo'];
			$numero      = $row['numero'];
			$coddomi     = $row['coddomi'];
			$dnicliente  = $row['dni'];
			$valunitario = $row['valunitario'];

			$productoid    = $row['productoid'];
			$cantidad      = $row['canti'];
			$cantidadVenta = $row['vendi'];
			
			$array = [
				'tipo' => '2',
				'diaoperativo' => $diaoperativo,
				'tipodoc' => $tipodoc,
				'prefijo' => $prefijo, 
				'numero' => $numero, 
				'dnicliente' => $dnicliente, 
				'preciounitario' => $valunitario,
				'sucursalid' => $sucursalid,
				'productoid' => $productoid,
				'cantidad' => $cantidad,
				'cantidad_devuelta' => $cantidadVenta,
				'key' => md5($sucursalid.'~'.$productoid.'~'.$cantidad)
			];

			$arrayFinal[$i] = $array;
			$i++;
		}
        $mandar = json_encode($arrayFinal);
    	$url = "http://plataforma.farmanorteonline.com/existencias-actualizar?id=".$mandar;

		// Consumo el Webservice con CURL
		$json = file_get_contents($url);   	
		return;
	}

	
	///////////////////////////////////////////////////////// 
	////       Proceso de Calculo de Bonificados 
	/////////////////////////////////////////////////////////
	function CalcularBonificadoDia($diaoperativo)
	{
		$clase = new Sistema();
		ini_set("memory_limit","200M");
		set_time_limit(0);

		$cierreid     = $_GET['cierreid'];
		if($diaoperativo == "")
			$diaoperativo = $clase->BDLockup($cierreid,'cierres','cierreid','diaoperativo');
		$sucid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','sucursalid');	 

	 /// Elimino todos los posibles bonificados existentes
	 $vsqlx = "DELETE FROM bonificado WHERE fecha='".substr($diaoperativo,6,4)."-".substr($diaoperativo,3,2)."-".substr($diaoperativo,0,2)."' AND sucursalid=".$sucid;
	 $clase->EjecutarSQL($vsqlx);

	 ///// BONIFICADO EN VENTAS (SUMAN) 
	 /// Busco las ventas bonificadas del Dia XX en la Sucursal YY
	 $vsql = "SELECT D.terid2, DD.productoid, DD.cantidad , DD.valparcial, DD.valtotal , DD.valiva , P.porcenboni , P.pagodiario , P.precio1m , P.porciva 
	          FROM documentos D
			  INNER JOIN docuventa DV ON ( D.docuid = DV.docuid ) INNER JOIN dedocumentos DD ON ( DD.docuid = D.docuid ) 
			  INNER JOIN productos P ON ( DD.productoid = P.productoid ) WHERE D.tipodoc = 'FVE' AND D.fecasentado <>  '0000-00-00'
			  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."' AND P.porcenboni >0 ";
	 
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 while($row = mysql_fetch_array($result))
	 {
        $fecha = substr($diaoperativo,6,4)."-".substr($diaoperativo,3,2)."-".substr($diaoperativo,0,2);
		$periodo = substr($diaoperativo,3,2).substr($diaoperativo,6,4);

		if($row['pagodiario'] == "CHECKED")
		   $diario = "CHECKED";
		else
		   $diario = ""; 

		//// Calculo el Valor Vendido 
		$cantidad = abs($row['cantidad']);
		if($row['valparcial'] == $row['valtotal'])
            $vendido = abs($row['valparcial']-$row['valiva']);
		else
		{
			if($row['valtotal']>=$row['valparcial'])
			    $vendido = abs($row['valtotal']-$row['valiva']);
			else
			    $vendido = abs($row['valparcial']-$row['valiva']);
		}
		
		if($vendido<1)
		   $vendido = abs($row['precio1m']*$cantidad-($row['precio1m']*$cantidad*($row['porciva']/100)));

		$vsql2 = "INSERT INTO bonificado(fecha,vendedor,productoid,cantidad,valorventa,porcenboni,sucursalid,periodo,pagado,valorcomi) 
		          VALUES('".$fecha."',".$row['terid2'].",".$row['productoid'].",".$row['cantidad'].",".$vendido.",".
		          $row['porcenboni'].",".$sucid.",'".$periodo."','".$diario."',0)";
		//echo $vsql2."<br>";
		$clase->EjecutarSQL($vsql2);		       
     }

     /////  BONIFICADO EN DEVOLUCIONES (RESTAN)
	 /// Busco las Devoluciones Bonificadas del Dia XX en la Sucursal YY
	 $vsql = "SELECT D.terid2, DD.productoid, DD.cantidad , DD.valparcial, DD.valiva ,P.porcenboni , P.pagodiario FROM documentos D
			  INNER JOIN docudevolucion DV ON ( D.docuid = DV.docuid ) INNER JOIN dedocumentos DD ON ( DD.docuid = D.docuid ) 
			  INNER JOIN productos P ON ( DD.productoid = P.productoid ) WHERE D.tipodoc = 'DVE' AND D.fecasentado <>  '0000-00-00'
			  AND D.fecanulado = '0000-00-00' AND DV.diaoperativo ='".$diaoperativo."' AND P.porcenboni >0 ";
	 
	 $conex  = $clase->Conectar();
     $result = @mysql_query($vsql,$conex);
	 while($row = @mysql_fetch_array($result))
	 {
        $fecha   = substr($diaoperativo,6,4)."-".substr($diaoperativo,3,2)."-".substr($diaoperativo,0,2);
		$periodo = substr($diaoperativo,3,2).substr($diaoperativo,6,4);

		if($row['pagodiario'] == "CHECKED")
		   $diario = "CHECKED";
		else
		   $diario = ""; 
		
		$vsql2 = "INSERT INTO bonificado(fecha,vendedor,productoid,cantidad,valorventa,porcenboni,sucursalid,periodo,pagado,valorcomi) 
		          VALUES('".$fecha."',".$row['terid2'].",".$row['productoid'].",-".$row['cantidad'].",-".($row['valparcial']-$row['valiva']).",".
		          $row['porcenboni'].",".$sucid.",'".$periodo."','".$diario."',0)";
		$clase->EjecutarSQL($vsql2);
     }

     /// Totalizo la comision
	 $clase->EjecutarSQL("UPDATE bonificado SET valorcomi = (valorventa)*(porcenboni/100) WHERE valorcomi<=0");			            

     /// Pongo el codigo de la Sucursal a todos los registros de la tabla
	 $clase->EjecutarSQL("UPDATE bonificado SET codsuc = '".$_SESSION['G_SUCURSALPOS']."' WHERE 1");		            
	 
	 /// Registro en el Log de Auditoria
     $clase->CrearLOG('019','Se calculo el bonificado del dia exitosamente',strtoupper($_SESSION["USERNAME"]),'');   
    }	


	////////////////////////////////////////////////////////////////////////////////////////////
	////// Se corrigen los Medios de Pago en la Facturas
	function CorregirFormasdePagoenFacturas($diaoperativo)
	{
		$clase = new Sistema();

		/// Soluciono el problema de las Formas de Pago
		$vsql = "SELECT D.docuid , D.total , ((DV.valorfp1 + DV.valorfp2 + DV.valorfp3 + DV.valorfp4 + DV.valorfp5 + DV.valorfp6 + DV.valorfp7)-D.total) diferencia
				FROM documentos D INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
				WHERE DV.diaoperativo = '".$diaoperativo."' HAVING abs(round(diferencia)) > 99";
		$conex  = $clase->Conectar();
		$result = @mysql_query($vsql,$conex);
		while($row = @mysql_fetch_array($result))
		{
			$pasarela  = 0+$clase->BDLockup($row['docuid'],'docuventa','docuid','valorfp7');		
			if($pasarela <= 0)
			{
				$totalfv   = $row['total'];
				$efectivo  = $clase->BDLockup($row['docuid'],'docuventa','docuid','valorfp1');
				$tarjetas  = $clase->BDLockup($row['docuid'],'docuventa','docuid','valorfp2');        
				$tarjetas2 = $clase->BDLockup($row['docuid'],'docuventa','docuid','valorfp3');        
				$tarjetas3 = $clase->BDLockup($row['docuid'],'docuventa','docuid','valorfp4'); 
				$puntos    = $clase->BDLockup($row['docuid'],'docuventa','docuid','valorfp5'); 
				$rappi     = $clase->BDLockup($row['docuid'],'docuventa','docuid','valorfp6');
				
				$totalerror = $totalfv - ($tarjetas+$tarjetas2+$tarjetas3+$puntos+$rappi+$pasarela);
	
				$vsql2 = "UPDATE docuventa SET valorfp1 =".$totalerror." WHERE docuid=".$row['docuid'];		         
				$clase->EjecutarSQL($vsql2);		   
			}
		}

		return;
	}

	
    ////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////
	function BeneficiosProducto($docuid,$productoid)
	{
		$clase = new Sistema();
        
		$vsql   = "SELECT beneficioid FROM beneficios WHERE idproductocompra = ".$productoid." AND fecdesde <= CURRENT_DATE AND fechasta >= CURRENT_DATE";
        $beneid = $clase->SeleccionarUno($vsql);
		
		if($beneid != "") 
		{
            //// Bodega
		    $bodegaid = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],'bodegas','codbodega','bodegaid');
		
			//// Consulta
		    $vsql2  = "SELECT B.* , PB1.factor1 factor1, PB1.precio1m precio1, PB1.porciva porciva1 ,
			           PB2.factor1 factor2, PB2.precio1m precio2 , PB2.porciva porciva2 
			           FROM beneficios B 
					   INNER JOIN productos P ON (B.idproductocompra = P.productoid) 
					   LEFT JOIN productos PB1 ON (B.idproductobene1 = PB1.productoid) 
					   LEFT JOIN productos PB2 ON (B.idproductobene2 = PB2.productoid) 
					   WHERE B.beneficioid = ".$beneid;
            
			/// Me conecto 
		 	$conex  = $clase->Conectar();
		    $result = @mysql_query($vsql2,$conex);
			if($row = @mysql_fetch_array($result))
			{
				/// Beneficio1
				$nombeneficio = $row['nomcorto'];
				$productoidB1 = $row['idproductobene1'];
				$ejecucion    = $row['ejecucion']; 

				$obsrecor = "";
				if($ejecucion == "OB")   $obsrecor = "LOCK";

				if($productoidB1 != "")
				{
				   $factor1  = $row['factor1'];
				   $precio1  = $row['precio1'];
				   $canti1   = $row['cantibene1'];
				   $porciva1 = $row['porciva1'];
				   $precio1  = ($precio1 - ($precio1*($row['porcendcto1']/100)));				   

				   /// Elimino cualquier otro beneficio del mismo producto
                   $clase->EjecutarSQL("DELETE FROM dedocumentos WHERE docuid = ".$docuid." and productoid = ".$productoidB1." and valunitario = 0");      
				 
				   /// Inserto el detalle del Documento
				   $vsqlb = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,
				             valunitario,valparcial,porciva,valbase,valiva,valtotal,valdescuento,diasrecor,
							 docuref,unicom,unifra,observalinea,obsrecor) VALUES(".
							 $docuid.",".$productoidB1.",".$bodegaid.",".$canti1.",".$canti1.",'D',0,".
							 $precio1.",".$precio1.",".$porciva1.",".$precio1.",0,".$precio1.",0,0,
							 'BEN-".$beneid."',".$canti1.",0,'BENEFICIO ".$nombeneficio."','".$obsrecor."')";
				   $clase->EjecutarSQL($vsqlb);     

                   /// Grabo la Promocion en Docuref
				   $vsqlc = "UPDATE dedocumentos SET docuref = 'BEN-".$beneid."' WHERE docuid = ".$docuid." AND productoid = ".$productoid;
				   $clase->EjecutarSQL($vsqlc);     
				}
				
				/// Beneficio2
				$productoidB2 = $row['idproductobene2'];
				if($productoidB2 != "")
				{
				   $factor2 = $row['factor2'];
				   $precio2 = $row['precio2'];
				   $canti2  = $row['cantibene2'];
				   $porciva2 = $row['porciva2'];
				   $precio2 = ($precio2 - ($precio2*($row['porcendcto2']/100)));

                   /// Elimino cualquier otro beneficio del mismo producto
                   //$clase->EjecutarSQL("DELETE FROM dedocumentos WHERE docuid = ".$docuid." and productoid = ".$productoidB1." and valunitario = 0");      
				 
				   /// Inserto el detalle del Documento
				   $vsqlb = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,
				             valunitario,valparcial,porciva,valbase,valiva,valtotal,valdescuento,diasrecor,
							 docuref,unicom,unifra,observalinea,obsrecor) VALUES(".
							 $docuid.",".$productoidB2.",".$bodegaid.",".$canti2.",".$canti2.",'D',0,".
							 $precio2.",".$precio2.",".$porciva2.",".$precio2.",0,".$precio2.",0,0,
							 'BEN-".$beneid."',".$canti2.",0,'BENEFICIO ".$nombeneficio."','".$obsrecor."')";
				   $clase->EjecutarSQL($vsqlb);     

                   /// Grabo la Promocion en Docuref
				   $vsqlc = "UPDATE dedocumentos SET docuref = 'BEN-".$beneid."' WHERE docuid = ".$docuid." AND productoid = ".$productoid;
				   $clase->EjecutarSQL($vsqlc);    
				}				
			}			
		}
        
		return;	
	}
 
    ////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////
	function EnviarDomicilio($dir,$lat,$lng,$docuid)
	{
		$clase = new Sistema();
		// $sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");
		// $bodegaid   = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],"bodegas","codbodega","bodegaid");

		$vsql = "SELECT DV.diaoperativo , D.tipodoc , D.prefijo , D.numero , CLI.dni , T.coddomi , DD.productoid ,P.codigo, P.descripcion,  DD.valunitario , DD.valbase, DD.valiva, DD.valtotal, DD.cantidad,DD.unicom, DD.unifra,
				CLI.nombres, CLI.apellidos, D.base, D.iva, D.total, B.codbodega
				FROM documentos D 
				INNER JOIN docuventa DV ON (DV.docuid = D.docuid)
				INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
				LEFT JOIN terceros CLI ON (CLI.terid = D.terid1) 
				INNER JOIN terceros T ON (T.terid = D.terid3)
				INNER JOIN bodegas B ON  (DD.bodegaid = B.bodegaid)
				LEFT JOIN productos P ON (DD.productoid=P.productoid)
				 WHERE D.docuid = ".$docuid." and DD.productoid <> 44348
				 GROUP BY 1,2,3,4,5,6,7";

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		$detalle_prod = array();
		while($row = @mysql_fetch_array($result))
		{
			$numero          = $row['prefijo'].$row['numero'];
			$nombre_cliente  = $row['nombres'].'  '.$row['apellidos'];
			$dni             = $row['dni'];
			$base      		= $row['base'];
			$iva  			= $row['iva'];
			$total		 	= $row['total'];
			$bodega_suc     = $row['codbodega'];
			$prefijo    	= $row['prefijo'];
			$aux   = [ 
				'cantidad' => $row['cantidad'],
				'codproducto' => $row['codigo'],
				'nomproducto' => $row['descripcion'],
				'precio' =>  $row['valunitario'],
				'valor_base' =>  round($row['valbase']),
				'valor_iva' =>   round($row['valiva']),
				'valor_total' =>   round($row['valtotal'])
			]
			;
			array_push($detalle_prod, $aux);
			$array = [
				'numero_factura' => $numero,
				'nombrecompleto_cliente' => $nombre_cliente,
				'identificacion_cliente' => $dni,
				'telefono_cliente' => $dni, 
				'direccion_cliente' => $dir, 
				'punto_referencia' => $dir,
				'latitud_cliente' => $lat, 
				'longitud_cliente' => $lng,
				'valor_base' =>  round($base),
				'valor_iva' =>  round($iva),
				'valor_total' =>  round($total),
				'valor_domicilio' => $total,
				'codsucursal' => $bodega_suc,
				'prefijo' => $prefijo,
				'json'=> $detalle_prod

			];
			//array_push($arrayFinal, $array);
			$arrayFinal = $array;
			$i++;
		}


		//echo $
    	$mandar = json_encode($arrayFinal);
		//echo var_dump($mandar);
		//exit;
    	$url = "http://www.dromedicas.com.co/api/Eventos/Delivery/NewEvent.php";
		$ch = curl_init();
		curl_setopt($ch,CURLOPT_URL,$url);
		curl_setopt($ch,CURLOPT_POSTFIELDS, $mandar);

		curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
		$tmp = curl_exec($ch);
		$k = json_decode($tmp);
		curl_close($ch);
		//print_r($k);


		// // Consumo el Webservice con CURL
		// $json = file_get_contents($url);   	
		return;
	}
	


	/////////////////////////////////////////////////////////////////////////////////////////// 
	/// Notifica la Existencia a Droposv2 en la Tienda 
	//////////////////////////////////////////////////////////////////////////////////////////// 
    function NotificarTransferenciaATienda($docuid)
	{
		$clase = new Sistema();
		$sucursalid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");
		$bodegaid   = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],"bodegas","codbodega","bodegaid");
		
		$vsql = "SELECT D.tipodoc , D.prefijo , D.numero , DD.productoid , E.cantidad canti , DD.valunitario , SUM(DD.cantidad) vendi 
				 FROM documentos D 
				 INNER JOIN docutranfe DT ON (DT.docuid = D.docuid)
				 INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
				 INNER JOIN existencias E ON (DD.productoid = E.productoid AND E.bodegaid = ".$bodegaid.")
				 WHERE D.docuid = ".$docuid."
				 GROUP BY 1,2,3,4,5,6";

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		while($row = mysql_fetch_array($result))
		{
			$tipodoc     = $row['tipodoc'];
			$prefijo     = $row['prefijo'];
			$numero      = $row['numero'];
			$coddomi     = $row['coddomi'];
			$valunitario = $row['valunitario'];

			$productoid    = $row['productoid'];
			$cantidad      = $row['canti'];
			$cantidadVenta = $row['vendi'];
			
			$array = [
				'tipo' => '3',
				'tipodoc' => $tipodoc,
				'prefijo' => $prefijo, 
				'numero' => $numero, 
				'preciounitario' => $valunitario,
				'sucursalid' => $sucursalid,
				'productoid' => $productoid,
				'cantidad' => $cantidad,
				'cantidad_transfe' => $cantidadVenta,
				'key' => md5($sucursalid.'~'.$productoid.'~'.$cantidad)
			];

			$arrayFinal[$i] = $array;
			$i++;
		}
        $mandar = json_encode($arrayFinal);
    	$url = "http://plataforma.farmanorteonline.com/existencias-actualizar?id=".$mandar;

		// Consumo el Webservice con CURL
		$json = file_get_contents($url);   	
		return;
	}



    //////////////////////////////////////////////////////////////////////////////////////////// 
	/// Envia La Rotacion y Existencia Actualizadas al Servidor
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function EnviarAServidorExoistenciayRotacion($periodo)
	{   
		$clase = new Sistema();
		$codbodega   = $_SESSION['G_BODEGAPREDETPOS'];
		$codsucursal = $_SESSION['G_SUCURSALPOS'];
		if($periodo == "")  $periodo = date("mY");

        $vsql = "SELECT P.productoid , B.bodegaid , S.sucursalid , C.codigo codciudad , Z.codzona , Z.codregion , E.cantidad , '".$periodo."' periodo , 
				 (SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad > 0 AND productoid = P.productoid AND periodo = '".$periodo."') entradas , 
				 (SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad < 0 AND productoid = P.productoid AND periodo = '".$periodo."' AND tipodoc = 'FVE') salidas 
				 FROM productos P 
				 INNER JOIN existencias E ON (P.productoid = E.productoid)
				 INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid AND B.codbodega = '".$codbodega."')
				 INNER JOIN sucursales S ON (S.sucursalid = B.sucursalid)
				 INNER JOIN ciudades C ON (C.codigo = S.ciudadcodigo)
				 INNER JOIN zonas Z ON (Z.codzona = S.zona)
				 WHERE E.cantidad <> 0 OR P.productoid IN (SELECT DISTINCT productoid FROM kardex WHERE periodo = '".$periodo."')";

        $conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		while($row = mysql_fetch_array($result))
		{
			$productoid  = $row['productoid'];
			$bodegaid    = $row['bodegaid'];
			$sucursalid  = $row['sucursalid'];
			$codciudad   = $row['codciudad'];
			$codzona     = $row['codzona'];
			$codregion   = $row['codregion'];
			$cantidad    = $row['cantidad'];
			$entradas    = $row['entradas'];
			$salidas     = $row['salidas'];
					
			$array = [
				'productoid' => $productoid,
				'bodegaid' => $bodegaid,
				'sucursalid' => $sucursalid,
				'codciudad' => $codciudad,
				'codzona' => $codzona, 
				'codregion' => $codregion,
				'cantidad' => $cantidad,
				'periodo' => $periodo,
				'entradas' => $entradas,
				'salidas' => $salidas
			];

			$arrayFinal[$i] = $array;         
			$i++;
		}

		//if($_SESSION["G_MODOTRABAJO"] == "PUNTODEVENTA")
		if($_SESSION["G_MODOTRABAJO"] == "SERVIDOR")
			$url = "http://192.168.14.253:9999/dropos/wsjson/sincronizarotacion/recibirdataxperiodo2.php";
		else
		    $url = "http://dromedicas.sytes.net:9999/dropos/wsjson/sincronizarotacion/recibirdataxperiodo.php";
			
		$ch = curl_init($url);

		//// creo el JSON 
		$mandar =  json_encode(array("data" => $arrayFinal));

		// Attach encoded JSON string to the POST fields
		curl_setopt($ch, CURLOPT_POSTFIELDS, $mandar);

		// Set the content type to application/json
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

		// Return response instead of outputting
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute the POST request
		$json = curl_exec($ch);

		// Close cURL resource
		curl_close($ch);

		/// Marco en la Sucursal que ya se envió
		$clase->EjecutarSQL("UPDATE sucursales SET momentoupdaterotacion = CURRENT_TIMESTAMP WHERE codigo = '".$codsucursal."'");
		$_SESSION['ULTIMOENVIODATASERV'] = date("H");

		return;
	}
	

	//////////////////////////////////////////////////////////////////////////////////////////// 
	/// Envia La Rotacion y Existencia Actualizadas al Servidor
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function EnviarAServidorExoistenciayRotacionFull($periodo)
	{   
		$clase = new Sistema();
		$periodo      = $_GET['periodo'];   
		$codbodega    = $_GET['codbodega'];
		$codsucursal  = $_GET['codsucursal'];
		
		if($periodo == "")      $periodo = date("mY");
		if($codbodega == "")    $codbodega   = $_SESSION['G_BODEGAPREDETPOS'];
		if($codsucursal == "")  $codsucursal = $_SESSION['G_SUCURSALPOS'];

		//// Diferente para Servidores
		if(($codbodega == "50")||($codbodega == "DB"))
		{
			$bodegaid = $clase->BDLockup($codbodega,"bodegas","codbodega","bodegaid");
			$vsql = "SELECT P.productoid , B.bodegaid , S.sucursalid , C.codigo codciudad , Z.codzona , Z.codregion , E.cantidad , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE bodegaid = ".$bodegaid." AND tipodoc = 'FVE' AND periodo = '042021' AND cantidad < 0 AND productoid = P.productoid ) salidas1 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE bodegaid = ".$bodegaid." AND tipodoc = 'FVE' AND periodo = '032021' AND cantidad < 0 AND productoid = P.productoid ) salidas2 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE bodegaid = ".$bodegaid." AND tipodoc = 'FVE' AND periodo = '022021' AND cantidad < 0 AND productoid = P.productoid ) salidas3 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE bodegaid = ".$bodegaid." AND tipodoc = 'FVE' AND periodo = '012021' AND cantidad < 0 AND productoid = P.productoid ) salidas4 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE bodegaid = ".$bodegaid." AND tipodoc = 'FVE' AND periodo = '122020' AND cantidad < 0 AND productoid = P.productoid ) salidas5 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE bodegaid = ".$bodegaid." AND tipodoc = 'FVE' AND periodo = '112020' AND cantidad < 0 AND productoid = P.productoid ) salidas6  
					FROM productos P 
					INNER JOIN existencias E ON (P.productoid = E.productoid)
					INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid AND B.codbodega = '".$codbodega."')
					INNER JOIN sucursales S ON (S.sucursalid = B.sucursalid)
					INNER JOIN ciudades C ON (C.codigo = S.ciudadcodigo)
					INNER JOIN zonas Z ON (Z.codzona = S.zona)
					WHERE E.cantidad <> 0 OR P.productoid IN (SELECT DISTINCT productoid FROM kardex WHERE tipodoc = 'FVE' AND bodegaid = 2 AND DATE_SUB(CURRENT_DATE, INTERVAL 180 DAY))";
		}
		else
		{
			$vsql = "SELECT P.productoid , B.bodegaid , S.sucursalid , C.codigo codciudad , Z.codzona , Z.codregion , E.cantidad , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad > 0 AND productoid = P.productoid AND periodo = '042021') entradas1 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad < 0 AND productoid = P.productoid AND periodo = '042021' AND tipodoc = 'FVE') salidas1 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad > 0 AND productoid = P.productoid AND periodo = '032021') entradas2 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad < 0 AND productoid = P.productoid AND periodo = '032021' AND tipodoc = 'FVE') salidas2 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad > 0 AND productoid = P.productoid AND periodo = '022021') entradas3 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad < 0 AND productoid = P.productoid AND periodo = '022021' AND tipodoc = 'FVE') salidas3 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad > 0 AND productoid = P.productoid AND periodo = '012021') entradas4 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad < 0 AND productoid = P.productoid AND periodo = '012021' AND tipodoc = 'FVE') salidas4 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad > 0 AND productoid = P.productoid AND periodo = '122020') entradas5 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad < 0 AND productoid = P.productoid AND periodo = '122020' AND tipodoc = 'FVE') salidas5 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad > 0 AND productoid = P.productoid AND periodo = '112020') entradas6 , 
					(SELECT COALESCE(SUM(cantidad),0) FROM kardex WHERE cantidad < 0 AND productoid = P.productoid AND periodo = '112020' AND tipodoc = 'FVE') salidas6  
					FROM productos P 
					INNER JOIN existencias E ON (P.productoid = E.productoid)
					INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid AND B.codbodega = '".$codbodega."')
					INNER JOIN sucursales S ON (S.sucursalid = B.sucursalid)
					INNER JOIN ciudades C ON (C.codigo = S.ciudadcodigo)
					INNER JOIN zonas Z ON (Z.codzona = S.zona)
					WHERE E.cantidad <> 0 OR P.productoid IN (SELECT DISTINCT productoid FROM kardex WHERE productoid <> '' AND ".$wherex." DATE_SUB(CURRENT_DATE, INTERVAL 180 DAY))";
		}

		//echo $vsql; exit;
    
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		while($row = mysql_fetch_array($result))
		{
			$productoid  = $row['productoid'];
			$bodegaid    = $row['bodegaid'];
			$sucursalid  = $row['sucursalid'];
			$codciudad   = $row['codciudad'];
			$codzona     = $row['codzona'];
			$codregion   = $row['codregion'];
			$cantidad    = $row['cantidad'];
			$entradas1   = $row['entradas1'];
			$salidas1    = $row['salidas1'];
			$entradas2   = $row['entradas2'];
			$salidas2    = $row['salidas2'];
			$entradas3   = $row['entradas3'];
			$salidas3    = $row['salidas3'];
			$entradas4   = $row['entradas4'];
			$salidas4    = $row['salidas4'];
			$entradas5   = $row['entradas5'];
			$salidas5    = $row['salidas5'];
			$entradas6   = $row['entradas6'];
			$salidas6    = $row['salidas6'];
			
			if($i<=0)
			{
				$vsql0 = "DELETE FROM rotacionproducto WHERE bodegaid = '".$bodegaid."' AND codperiodo = '".$periodo."';";
				echo $vsql0."<br>";
			}
			
			if(abs($salidas1)>0)
            {
                $vsql1 = "INSERT INTO rotacionproducto(productoid,bodegaid,sucursalid,codciudad,codzona,codregion,codperiodo,entradas,salidas) 
                              VALUES ('".$productoid."','".$bodegaid."','".$sucursalid."','".$codciudad."','".$codzona."','".$codregion."','042021','".$entradas1."','".$salidas1."');";
                echo $vsql1."<br>";
            }
			if(abs($salidas2)>0)
            {
                $vsql1 = "INSERT INTO rotacionproducto(productoid,bodegaid,sucursalid,codciudad,codzona,codregion,codperiodo,entradas,salidas) 
                              VALUES ('".$productoid."','".$bodegaid."','".$sucursalid."','".$codciudad."','".$codzona."','".$codregion."','032021','".$entradas2."','".$salidas2."');";
                echo $vsql1."<br>";
            }
			if(abs($salidas3)>0)
            {
                $vsql1 = "INSERT INTO rotacionproducto(productoid,bodegaid,sucursalid,codciudad,codzona,codregion,codperiodo,entradas,salidas) 
                              VALUES ('".$productoid."','".$bodegaid."','".$sucursalid."','".$codciudad."','".$codzona."','".$codregion."','022021','".$entradas3."','".$salidas3."');";
                echo $vsql1."<br>";
            }
			if(abs($salidas4)>0)
            {
                $vsql1 = "INSERT INTO rotacionproducto(productoid,bodegaid,sucursalid,codciudad,codzona,codregion,codperiodo,entradas,salidas) 
                              VALUES ('".$productoid."','".$bodegaid."','".$sucursalid."','".$codciudad."','".$codzona."','".$codregion."','012021','".$entradas4."','".$salidas4."');";
                echo $vsql1."<br>";
            }
			if(abs($salidas5)>0)
            {
                $vsql1 = "INSERT INTO rotacionproducto(productoid,bodegaid,sucursalid,codciudad,codzona,codregion,codperiodo,entradas,salidas) 
                              VALUES ('".$productoid."','".$bodegaid."','".$sucursalid."','".$codciudad."','".$codzona."','".$codregion."','122020','".$entradas5."','".$salidas5."');";
                echo $vsql1."<br>";
            }
			if(abs($salidas6)>0)
            {
                $vsql1 = "INSERT INTO rotacionproducto(productoid,bodegaid,sucursalid,codciudad,codzona,codregion,codperiodo,entradas,salidas) 
                              VALUES ('".$productoid."','".$bodegaid."','".$sucursalid."','".$codciudad."','".$codzona."','".$codregion."','112020','".$entradas6."','".$salidas6."');";
                echo $vsql1."<br>";
            }

			$i++;
		}

		echo "<br><br>Registros <b>".$i."</b>";

		return;
	}


	/////////////////////////////////////////////////////////////////////////////////////////// 
	/// Extrae localmente el contenido de la Factura electronica
	//////////////////////////////////////////////////////////////////////////////////////////// 
    function ContenidoFacturaElectronica($docuid)
	{
		$clase = new Sistema();
		$vsql = "SELECT '".$_SESSION['USERNAME']."' usuenvia , P.codigo , P.descripcion , P.precio1m , P.porciva , T.tipodoc tipodocumento , T.dni , T.nombres , T.apellidos , T.email , T.direccion , CONCAT(T.telfijo,' ',T.telmovil) telefono , 
		         C.codigo codciudad , C.nombre nomciudad , C.departamento depciudad , DV.* , DD.* , D.* 
		         FROM documentos D
				 INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
				 INNER JOIN terceros T ON (T.terid = D.terid1)
				 INNER JOIN ciudades C ON (T.ciudadid = C.ciudadid)
				 INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
				 INNER JOIN productos P ON (DD.productoid = P.productoid)
				 WHERE D.docuid = ".$docuid;

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		while($row = mysql_fetch_array($result))
		{
			$arrayFinal[$i] = $row;         
			$i++;
		}

		$mandar =  json_encode(array("data" => $arrayFinal));
		return($mandar);
	}
	

	/////////////////////////////////////////////////////////////////////////////////////////// 
	/// Genera en el Servidor la Factura Electrónica en Condiciones Normales
	//////////////////////////////////////////////////////////////////////////////////////////// 
    function GenerarFacturaElectronica($docuid)
	{
		/*
		$clase = new Sistema();
		$vsql = "SELECT '".$_SESSION['USERNAME']."' usuenvia , P.codigo , P.descripcion , P.precio1m , P.porciva , T.tipodoc tipodocumento , T.dni , T.nombres , T.apellidos , T.email , T.direccion , CONCAT(T.telfijo,' ',T.telmovil) telefono , 
		         C.codigo codciudad , C.nombre nomciudad , C.departamento depciudad , DV.* , DD.* , D.* 
		         FROM documentos D
				 INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
				 INNER JOIN terceros T ON (T.terid = D.terid1)
				 INNER JOIN ciudades C ON (T.ciudadid = C.ciudadid)
				 INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
				 INNER JOIN productos P ON (DD.productoid = P.productoid)
				 WHERE D.docuid = ".$docuid;

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		while($row = mysql_fetch_array($result))
		{
			$arrayFinal[$i] = $row;         
			$i++;
		}

		/* Anteriormente se enviaban a Dromedicas.Sytes - Ahora se envian a Dromedicas.com.co
		if($_SESSION['G_MODOTRABAJO'] == "PUNTODEVENTA")
		    $url = "http://dromedicas.sytes.net:9999/dropos/wsjson/facturaelectronica/recibirfactura.php";
		else
			$url = "http://192.168.14.244:9999/dropos/wsjson/facturaelectronica/recibirfactura.php";
        

		/// Nuevo End Point 
		$url = "http://www.dromedicas.com.co/api/facturacionelectronica/recibirfactura.php";	
		$ch = curl_init($url);

		//// creo el JSON 
		$mandar =  json_encode(array("data" => $arrayFinal));

		// Attach encoded JSON string to the POST fields
		curl_setopt($ch, CURLOPT_POSTFIELDS, $mandar);

		// Set the content type to application/json
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

		// Return response instead of outputting
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute the POST request
		$json = curl_exec($ch);

		// Close cURL resource
		curl_close($ch);

		$dataRespuesta = json_decode($json);
		$codigo = $dataRespuesta->code;

		//// Guardo la Respuesta en la Nueva Tabla
        $vsqlx = "INSERT INTO enviofacturasdian(docuid,codrespuestavps,momento) VALUES('".$docuid."','".$codigo."',CURRENT_TIMESTAMP)";
		$clase->EjecutarSQL($vsqlx);

		//// Retorno el Codigo
		return($codigo);
		*/
	}


	/////////////////////////////////////////////////////////////////////////////////////////// 
	/// Genera en el Servidor la Factura Electrónica - En Condiciones Especiales
	//////////////////////////////////////////////////////////////////////////////////////////// 
    function GenerarFacturaElectronica24($docuid)
	{
		$clase = new Sistema();

		//// Consulto la Informacion
		$vsql = "SELECT '".$_SESSION['USERNAME']."' usuenvia , P.codigo , P.descripcion , P.precio1m , P.porciva , T.tipodoc tipodocumento , T.dni , T.nombres , T.apellidos , T.email , T.direccion , CONCAT(T.telfijo,' ',T.telmovil) telefono , 
		         C.codigo codciudad , C.nombre nomciudad , C.departamento depciudad , DV.* , DD.* , D.* 
		         FROM documentos D
				 INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
				 INNER JOIN terceros T ON (T.terid = D.terid1)
				 INNER JOIN ciudades C ON (T.ciudadid = C.ciudadid)
				 INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
				 INNER JOIN productos P ON (DD.productoid = P.productoid)
				 WHERE D.docuid = ".$docuid;

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;  $dni = "";   $fpg = "";
		while($row = mysql_fetch_array($result))
		{
			$dni = $row['dni'];         
			$tot = 0+round($row['total']);   
			$efe = 0+round($row['valorfp1']);          /// Si es = 0 SIRVE
			$iva = 0+round($row['iva']);               /// Si es Mayor que 0 SIRVE

			$arrayFinal[$i] = $row;         
			$i++;
		}

		///// Controlo el Envio o NO ENVIO de las Facturas Electronicas
		if($_SESSION['G_CONTROLNOENVIARFEL1'] == "")    /// Control 1
		   $controlnoenviar1 = 1;  /// Control Activado

        if($_SESSION['G_CONTROLNOENVIARFEL2'] == "")    /// Control 2
		   $controlnoenviar2 = 1;  /// Control Activado

        $ENVIARFEL = 1;   //// POR DEFECTO SIEMPRE SE ENVIAN    
		
		//// Facturas Inferiores a $10.000  en Efectivo no se Envian
		if(($tot<10001)&&($efe == $tot))
		   $ENVIARFEL = 0;

		//// Regla Predominante : Si Es NIT si la debe Enviar Siempre
		$pos = strpos($dni,"-");
		if($pos != "")
		   $ENVIARFEL = 1;   

		if($ENVIARFEL == 1)
		{
			//// Guardo la Respuesta en la Nueva Tabla
			$vsqlx = "INSERT INTO enviofacturasdian(docuid,enviows,momento) VALUES('".$docuid."',0,CURRENT_TIMESTAMP)";
			$clase->EjecutarSQL($vsqlx);

			/// Nuevo End Point 
			$url = "http://www.dromedicas.com.co/api/facturacionelectronica/recibirfactura.php";	
			$ch = curl_init($url);
	
			//// creo el JSON 
			$mandar =  json_encode(array("data" => $arrayFinal));
	
			// Attach encoded JSON string to the POST fields
			curl_setopt($ch, CURLOPT_POSTFIELDS, $mandar);
	
			// Set the content type to application/json
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
	
			// Return response instead of outputting
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	
			// Execute the POST request
			$json = curl_exec($ch);
	
			// Close cURL resource
			curl_close($ch);
	
			$dataRespuesta = json_decode($json);

			$codigo = $dataRespuesta->code;
	        $controlnoenviar1 = $dataRespuesta->control1;
			$controlnoenviar2 = $dataRespuesta->control2;

			$_SESSION['G_CONTROLNOENVIARFEL1'] = $controlnoenviar1;   /// Control 1
			$_SESSION['G_CONTROLNOENVIARFEL2'] = $controlnoenviar2;   /// Control 2

            if($codigo != "")
			{
				//// Guardo la Respuesta en la Nueva Tabla
				$vsqlx = "UPDATE enviofacturasdian SET enviows = 1 , codrespuestavps = '".$codigo."' WHERE docuid = '".$docuid."'";
				$clase->EjecutarSQL($vsqlx);
			}
		}	

		//// Retorno el Codigo
		return($codigo);
	}


	/////////////////////////////////////////////////////////////////////////////////////////// 
	/// Genera en el Servidor la Factura Electrónica - En Condiciones Especiales
	//////////////////////////////////////////////////////////////////////////////////////////// 
    function GenerarFacturaElectronica22($docuid,$libremente="N")
	{
        $clase = new Sistema();
     	$proveedortecno = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","proveedorfel"); 
		$idfel = "";
		if($proveedortecno == "DIS")
		   $idfel = EnviarFacturaElectronicaDispapeles2025($docuid,$libremente);
	    if($proveedortecno == "APG")
	       $idfel = EnviarFacturaElectronicaAPG($docuid,$libremente);
		
		return($idfel);
	}

	////////////////////////////////////////////////////////////////////////////////////////// 
	/// Genera en el Servidor la Factura Electrónica APG - En Condiciones Especiales
	//////////////////////////////////////////////////////////////////////////////////////////// 
    function EnviarFacturaElectronicaAPG($docuid,$libremente="N")
	{
		return;
    }

	////////////////////////////////////////////////////////////////////////////////////////// 
	/// Genera en el Servidor la Factura Electrónica DIS - En Condiciones Especiales
	//////////////////////////////////////////////////////////////////////////////////////////// 
    function EnviarFacturaElectronicaDispapeles2025($docuid,$libremente="N")
	{
		$clase = new Sistema();

		///   Con manejo de Session para no estar consultando cada Vez 
		//$controlnoenviar1 = $_SESSION['G_CONTROLNOENVIARFEL1'];    /// Control 1
		//$controlnoenviar2 = $_SESSION['G_CONTROLNOENVIARFEL2'];    /// Control 2

		//// Sin Session es decir .. Siempre pregunta a www.dromedicas.com.co como estan las llaves
	 	$controlnoenviar1 = "";    /// Control 1
		$controlnoenviar2 = "";    /// Control 2

		if(($controlnoenviar1 == "")&&($controlnoenviar1 == ""))
		{
			$json = file_get_contents('https://www.dromedicas.com.co/api/facturacionelectronica/estadocontroles.php');     
            $datallaves = json_decode($json); 
			
			$_SESSION['G_CONTROLNOENVIARFEL1'] = $datallaves->control1;
			$_SESSION['G_CONTROLNOENVIARFEL2'] = $datallaves->control2;
		}
		
		//// Consulto la Informacion
		$vsql = "SELECT '".$_SESSION['USERNAME']."' usuenvia , P.codigo , P.descripcion , P.precio1m , P.porciva , T.tipodoc tipodocumento , T.dni , T.nombres , T.apellidos , T.email , T.direccion , CONCAT(T.telfijo,' ',T.telmovil) telefono , 
		         C.codigo codciudad , C.nombre nomciudad , C.departamento depciudad , DV.* , DD.* , D.* 
		         FROM documentos D
				 INNER JOIN docuventa DV ON (D.docuid = DV.docuid) 
				 INNER JOIN terceros T ON (T.terid = D.terid1)
				 INNER JOIN ciudades C ON (T.ciudadid = C.ciudadid)
				 INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) 
				 INNER JOIN productos P ON (DD.productoid = P.productoid)
				 WHERE D.docuid = ".$docuid;

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;  $dni = "";   $fpg = "";
		while($row = mysql_fetch_array($result))
		{
			$dni = $row['dni'];         
			$tot = 0+round($row['total']);   
			$efe = 0+round($row['valorfp1']);          /// Si es = 0 SIRVE
			$iva = 0+round($row['iva']);               /// Si es Mayor que 0 SIRVE

			$arrayFinal[$i] = $row;         
			$i++;
		}
        
		///// ANALIZO SI SE ENVIA O NO   |    ANALIZO SI SE MODIFICA O NO
		$CUMPLECRITERIOS = 0;
		
    	//if(($tot<=30000)&&($efe==$tot))
	    if(($tot<=20000)&&($efe==$tot))
           $CUMPLECRITERIOS = 1;
        
		if(($CUMPLECRITERIOS == 1)&&($iva>0))   
           $CUMPLECRITERIOS = 2;

		//// POR DEFECTO SIEMPRE SE ENVIAN    
		$ENVIARFEL = 1;   
		
		///////////////////////////////////////////////////////////////////
		//// AQUI ES DONDE ESTA LA MAGIA
		//// Si el FILTRO está Activo - Filtra a ver si la OMITE o NO 
		//// Facturas Inferiores a $10.000  en Efectivo no se Envian
		$campoareportardian = 1;
        if($CUMPLECRITERIOS == 0)
		   $ENVIARFEL = 1;
		else
		{
			$ENVIARFEL = 1;
			///// CASO 1 - Evaluo la Llave - Si la Factura cumple los Criterios y la llave esta Abierta se envia - Si esta Cerrada No se envia
			/*
			if($CUMPLECRITERIOS == 1)
			{
				if($_SESSION['G_CONTROLNOENVIARFEL1'] == 0)   /// Si Cumple Criterios y Llave Abierta -> Enviela
				   $ENVIARFEL = 1;
				if($_SESSION['G_CONTROLNOENVIARFEL1'] == 1)   /// Si Cumple Criterios y Llave Cerrada -> No la Envie
				   $ENVIARFEL = 0;
			}
            */
			///// CASO 2 - Evaluo la Llave - Si la Factura cumple los Criterios y la llave esta Abierta se envia como está - Si esta Cerrada Se Altera y se Envia
			if($CUMPLECRITERIOS == 2)
			{
				if($_SESSION['G_CONTROLNOENVIARFEL2'] == 0)   /// Si Cumple Criterios y Llave Abierta -> Enviela NORMAL
				   $ENVIARFEL = 1;
				if($_SESSION['G_CONTROLNOENVIARFEL2'] == 1)   /// Si Cumple Criterios y Llave Cerrada -> MOdifiquela y Enviela
				{
                    //// Ajusto los IVAS en el Detalle y Encabezado
					$clase->EjecutarSQL("UPDATE dedocumentos SET valbase = valtotal , valiva = 0 WHERE docuid = ".$docuid);
					$clase->EjecutarSQL("UPDATE documentos SET porciva = 0 , base = total , iva = 0 WHERE docuid = ".$docuid);
					$ENVIARFEL = 1;
					$campoareportardian = 2;
				}
			}			
		}				

		///////////////////////////////////////////////////////////////////
		//// Regla PredominanteS : 
		//// Si Es NIT si la debe Enviar Siempre
		$pos = strpos($dni,"-");
		if($pos != "")
		   $ENVIARFEL = 1;   
        
		//// La Opcion de Libremente debe Mandarla Siempre
		if($libremente == "S")   
		    $ENVIARFEL = 1; 
    
		////echo $_SESSION['G_CONTROLNOENVIARFEL1']." ----- ".$_SESSION['G_CONTROLNOENVIARFEL2']." ----- ".$CUMPLECRITERIOS." ----- ".$ENVIARFEL;   exit;	
		        
		////////////////////////////////////////////////////////	
		//// Si el COntrol de Envio está en 1 -> Enviela 	
		if($ENVIARFEL == 1)
		{
			//// Guardo la Respuesta en la Nueva Tabla
			$vsqlx = "INSERT INTO enviofacturasdian(docuid,enviows,momento) VALUES('".$docuid."',0,CURRENT_TIMESTAMP)";
			$clase->EjecutarSQL($vsqlx);

			/// Nuevo End Point 
			$url = "http://www.dromedicas.com.co/api/facturacionelectronica/recibirfactura.php";	
			$ch = curl_init($url);
	
			//// creo el JSON 
			$mandar =  json_encode(array("data" => $arrayFinal));
	
			// Attach encoded JSON string to the POST fields
			curl_setopt($ch, CURLOPT_POSTFIELDS, $mandar);
	
			// Set the content type to application/json
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

			// Establece un tiempo de espera de 10 segundos para la conexión 10 Seg
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 6);

			/// Establece un tiempo de espera total de 25 segundos para toda la operación
			curl_setopt($ch, CURLOPT_TIMEOUT, 25);
	
			// Return response instead of outputting
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	
			// Execute the POST request
			$json = curl_exec($ch);
	
			// Close cURL resource
			curl_close($ch);
	
			$dataRespuesta = json_decode($json);
			$codigo = $dataRespuesta->code;
			$idfel  = $dataRespuesta->idfel;
			/*
	        $controlnoenviar1 = $dataRespuesta->control1;
			$controlnoenviar2 = $dataRespuesta->control2;

			$_SESSION['G_CONTROLNOENVIARFEL1'] = $controlnoenviar1;   /// Control 1
			$_SESSION['G_CONTROLNOENVIARFEL2'] = $controlnoenviar2;   /// Control 2
            */ 
            if($codigo != "")
			{
				//// Guardo la Respuesta en la Nueva Tabla
				$vsqlx = "UPDATE enviofacturasdian SET enviows = ".$campoareportardian." , codrespuestavps = '".$codigo."' , respuestaproveeedortecno = '".$idfel."' WHERE docuid = '".$docuid."'";
				$clase->EjecutarSQL($vsqlx);
			}
		}	
         
		//// Retorno el Codigo
		return($idfel);
	}

	////////////////////////////////////////////////////////////////////
	//// RECALCULAR / CREAR - Dia en Papeleria 26/08/2022
	////////////////////////////////////////////////////////////////////
	function RecalcularCrearDiaPapeleria($diaoperativo,$sucursal)
	{
 	    $clase = new Sistema();
 
		//// Si No existe el Dia se crea
		$existecierre = $clase->SeleccionarUno("SELECT COUNT(*) FROM cierresucursales WHERE codsucursal = '".$sucursal."' AND diaoperativo = '".$diaoperativo."'");
		if($existecierre == 0)
		{
			$campocontrol = $sucursal."|".$diaoperativo;
			$vsqlc = "INSERT INTO cierresucursales(codsucursal,diaoperativo,creador,momento,campocontrol) VALUES('".$sucursal."','".$diaoperativo."','SYSTEM',CURRENT_TIMESTAMP,'".$campocontrol."')";
			$clase->EjecutarSQL($vsqlc);
		}

		//// Selecciono los Valores para Recalculo
		$vsql = "SELECT SUM(valor) FROM consignacionespapeleria WHERE tipo = 'CON' AND codsucursal = '".$sucursal."' AND diaoperativo = '".$diaoperativo."'";
		$NuevoTotal = 0+$clase->SeleccionarUno($vsql);
		$vsql = "SELECT SUM(valor) FROM consignacionespapeleria WHERE tipo = 'TRA' AND codsucursal = '".$sucursal."' AND diaoperativo = '".$diaoperativo."'";
		$Transferencias = 0+$clase->SeleccionarUno($vsql);
		
		$vsql = "SELECT SUM(valortotal) FROM autorizacionesgastos WHERE tipo = 'COMPRA' AND usuautoriza IS NOT NULL AND codsucursal = '".$sucursal."' AND (diaoperativo = '".$diaoperativo."')";
		$ComprasAut = 0+$clase->SeleccionarUno($vsql);
        $vsql = "SELECT SUM(valortotal) FROM autorizacionesgastos WHERE tipo = 'GASTO' AND usuautoriza IS NOT NULL AND  codsucursal = '".$sucursal."' AND codconcepto <> '999' AND (diaoperativo = '".$diaoperativo."')";
		$Gastos = 0+$clase->SeleccionarUno($vsql);
        $vsql = "SELECT SUM(valortotal) FROM autorizacionesgastos WHERE tipo = 'GASTO' AND usuautoriza IS NOT NULL AND  codsucursal = '".$sucursal."' AND codconcepto = '999' AND (diaoperativo = '".$diaoperativo."')";
		$Terceros = 0+$clase->SeleccionarUno($vsql);
        $vsql = "SELECT SUM(valortotal) FROM autorizacionesgastos WHERE tipo = 'CREDITO' AND usuautoriza IS NOT NULL AND codsucursal = '".$sucursal."' AND (diaoperativo = '".$diaoperativo."')";
		$Creditos = 0+$clase->SeleccionarUno($vsql);

		/// Actualizo los totales de Consignaciones y Transferencias
		$vsql2 = "UPDATE cierresucursales SET consignado = '".$NuevoTotal."' , valtransferencias = '".$Transferencias."'  
		          WHERE codsucursal = '".$sucursal."' AND diaoperativo = '".$diaoperativo."'";
		$clase->EjecutarSQL($vsql2);                 

		return;
	}

	////////////////////////////////////////////////////////////////////
	/// Crea nuevo Transito entre Depositos 
    ////////////////////////////////////////////////////////////////////
	function GenerarTransitoenDepositos($docuid)
	{
		$clase = new Sistema();
        
		$bodegaidori = $clase->BDLockup($docuid,"docutranfe","docuid","bodegaidori");
		$bodegaiddes = $clase->BDLockup($docuid,"docutranfe","docuid","bodegaiddes");
		
		//// Limpio los transitos de este documento
        BorrarTransitoenDepositos($docuid);

		//// Preparo la Consulta 
		$vsqlinsert = "INSERT INTO transitoentredepositos(docuid,bodegaidorigen,bodegaiddestino,productoid,cantidad) VALUES";

		//// Consulto el Contenido de la Remision
		$vsql = "SELECT productoid ,  SUM(cantidad) canti FROM dedocumentos WHERE docuid = ".$docuid." GROUP BY 1";
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);	
		$cantilineas = mysql_num_rows($result);
		$i=0;
		while($row = mysql_fetch_array($result)) 
		{
		   $pid = 0+$row['productoid'];
		   $can = 0+$row['canti'];
 		   
		   if($i>0)
		      $vsqlinsert .= ",";
		   $vsqlinsert .= "('".$docuid."','".$bodegaidori."','".$bodegaiddes."','".$pid."','".$can."')";

		   $i++;
		}

		//// Inserto en la Tabla transitodepositos
        $clase->EjecutarSQL($vsqlinsert);

		return;
	}

	////////////////////////////////////////////////////////////////////
	/// Crea nuevo Transito entre Depositos 
    ////////////////////////////////////////////////////////////////////
	function BorrarTransitoenDepositos($docuid)
	{
		$clase = new Sistema();
        
		//// Borro de la Tabla transitodepositos
        $clase->EjecutarSQL("DELETE FROM transitodepositos WHERE docuid = ".$docuid);

		return;
	}

	////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////
	//// DELETE controlremisionped WHERE docuid = $docuidtranfe
	function GenerarValoresControlRemision($docuidpedido,$docuidtranfe)
	{
	   $clase = new Sistema();

       /// 1. Elimino los valores de control Antiguos
       $vsql = "DELETE FROM controlremisionped WHERE DATEDIFF(CURRENT_DATE,momento)>3";
	   $clase->EjecutarSQL($vsql);

	   /// 2.1 Busco la Bodega Origen de la Transferencia
	   $bodidexistencia = $clase->SeleccionarUno("SELECT bodegaidori FROM docutranfe WHERE docuid = ".$docuidtranfe);

	   /// 2.2 Ingreso los valores de Control segun el Pedido
       $vsql = "SELECT DD.productoid , P.codigo , P.descripcion , E.cantidad existencia , SUM(DD.cantidad) canti FROM dedocumentos DD 
	            INNER JOIN existencias E ON (E.productoid = DD.productoid AND E.bodegaid = ".$bodidexistencia.") 
				INNER JOIN productos P ON (P.productoid = DD.productoid) 
				WHERE docuid = ".$docuidpedido."  GROUP BY 1,2,3,4";
	   $conex  = $clase->Conectar();
	   $result = mysql_query($vsql,$conex);	
	   $cantilineas = mysql_num_rows($result);
	   if($cantilineas>0)
	      $clase->EjecutarSQL("DELETE FROM controlremisionped WHERE docuid = ".$docuidtranfe);

	   while($row = mysql_fetch_array($result)) 
	   {
		  $pid   = 0+$row['productoid'];
		  $cod   = trim($row['codigo']);
		  $des   = trim($row['descripcion']);
		  $exi   = 0+$row['existencia'];
		  $can   = 0+$row['canti'];
		  
		  $vsql2 = "INSERT INTO controlremisionped(docuid,productoid,codigo,descripcion,exibodori,cantiped,cantirem,creador) VALUES(".$docuidtranfe.",".$pid.",'".$cod."','".$des."',".$exi.",".$can.",0,'SYSTEM')"; 
		  $clase->EjecutarSQL($vsql2);
	   }
	   return;
	}

	//////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////
	//// Guarda las Existencias que habian al Cerrar el Pedido
	//// Al Inicial el Pedido se guardan en ControlRemisionPed
	function GuardarExistenciasalFinalizarREM($docuidtranfe)
	{
	   $clase = new Sistema();

	   /// 2.1 Busco la Bodega Origen de la Transferencia
	   $bodidexistencia = $clase->SeleccionarUno("SELECT bodegaidori FROM docutranfe WHERE docuid = ".$docuidtranfe);

	   /// 2.2 Ingreso los valores de Control segun el Pedido
       $vsql = "SELECT DISTINCT DD.productoid , E.cantidad existencia
	            FROM dedocumentos DD 
				INNER JOIN productos P ON (P.productoid = DD.productoid) 
	            INNER JOIN existencias E ON (E.productoid = DD.productoid AND E.bodegaid = ".$bodidexistencia.") 
				WHERE docuid = ".$docuidtranfe;
	   $conex  = $clase->Conectar();
	   $result = mysql_query($vsql,$conex);	
	   $cantilineas = mysql_num_rows($result);
	   
	   while($row = mysql_fetch_array($result)) 
	   {
		  $pid   = 0+$row['productoid'];
		  $exi   = 0+$row['existencia'];
		  
		  $vsql2 = "UPDATE dedocumentos SET exibodega = ".$exi." WHERE docuid = ".$docuidtranfe." AND productoid = ".$pid;
		  $clase->EjecutarSQL($vsql2);
	   }
	   return;
	}


	////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////
	function CompletarValoresControlRemision($docuidpedido,$docuidtranfe)
	{
	   $clase = new Sistema();
       
	   /// 2.1 Busco la Bodega Origen de la Transferencia
	   $bodidexistencia = $clase->SeleccionarUno("SELECT bodegaidori FROM docutranfe WHERE docuid = ".$docuidtranfe);

	   /// 2.2 Ingreso los valores de Control segun el Pedido
       $vsql = "SELECT DD.productoid , E.cantidad existencia , SUM(DD.cantidad) canti FROM dedocumentos DD 
	            INNER JOIN existencias E ON (E.productoid = DD.productoid AND E.bodegaid = ".$bodidexistencia.") 
				WHERE docuid = ".$docuidpedido." AND DD.productoid NOT IN (SELECT productoid FROM controlremisionped WHERE docuid = ".$docuidtranfe.")  GROUP BY 1,2";
	   $conex  = $clase->Conectar();
	   $result = mysql_query($vsql,$conex);	
	   while($row = mysql_fetch_array($result)) 
	   {
		  $pid   = 0+$row['productoid'];
		  $exi   = 0+$row['existencia'];
		  $can   = 0+$row['canti'];
		  
		  $vsql2 = "INSERT INTO controlremisionped(docuid,productoid,exibodori,cantiped,cantirem,creador) VALUES(".$docuidtranfe.",".$pid.",".$exi.",".$can.",0,'SYSTEM')"; 
		  $clase->EjecutarSQL($vsql2);
	   }
	   return;
	}

	/////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////
    function GenerarCompraxPeriodoxLabo($docuid)
	{
        $clase = new Sistema();
        $vsql = "SELECT D.periodo , P.gruposprodid , SUM(DD.cantidad) cantidad , SUM(DD.valtotal) valor , SUM(DD.cantidad*P.costoinf) valorcostoinf  
				 FROM documentos D INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
		         INNER JOIN productos P ON (DD.productoid = P.productoid)
				 WHERE D.docuid = ".$docuid." GROUP BY 1,2";
	    $conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);	
		$i=0;
		while($row = mysql_fetch_array($result)) 
		{
		   $per   = $row['periodo'];
		   $gid   = $row['gruposprodid'];
		   $can   = 0+$row['cantidad'];
		   $val   = 0+$row['valor'];
		   $val2  = 0+$row['valorcostoinf'];
		   		   
		   if($i==0)
		   {
			   $vsql2 = "DELETE FROM comprasxperxlabo WHERE docuid = ".$docuid; 
			   $clase->EjecutarSQL($vsql2);
		   }

		   $vsql2 = "INSERT INTO comprasxperxlabo(docuid,gruposprodid,periodo,cantidad,valor,costoinf) VALUES(".$docuid.",".$gid.",'".$per."',".$can.",'".$val."','".$val2."')"; 
		   $clase->EjecutarSQL($vsql2);

		   $i++;
		}
		return;
	}

	///////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////
    function AgregarLineaCostosSeñora($sucid,$nomdocu,$numprov,$feccom,$terid,$can,$obs,$inf,$pre,$uti,$iva,$cod,$pid,$docuid)
	{
        $clase = new Sistema();

		//// Borro la Linea de la Factura antes de Agregarla
		$clase->EjecutarSQL("DELETE FROM costoscompras WHERE productoid = ".$pid." AND docuid = ".$docuid);

		if((strlen($pid)>1)&&(strlen($docuid)>1)&&(strlen($sucid)>1))
		{
			//// Inserto la Linea    
			$vsql = "INSERT INTO costoscompras(productoid,docuid,sucursalid,numcompra,numproveedor,fecha,teridproveedor,cantidad,obsequio,costoinf,precioventa,utilidad,porciva,escod) 
					 VALUES('".$pid."','".$docuid."','".$sucid."','".$nomdocu."','".$numprov."','".$feccom."','".$terid."','".$can."','".$obs."','".$inf."','".$pre."','".$uti."','".$iva."','".$cod."')";
			//echo $vsql."<br>";
			$clase->EjecutarSQL($vsql);  
		}
		
		return;		
	}

	////////////////////////////////////////////////////
	function GuardarAgotadosDia()
	{
		$clase = new Sistema();

		//// 1. Borro lo que hay
		$clase->EjecutarSQL("DELETE FROM ventaperdida WHERE fecha = CURRENT_DATE");

		//// 1. Calculo los Agotados
		$vsql = "SELECT E.productoid FROM existencias E WHERE E.productoid IN ( SELECT DISTINCT productoid FROM kardex 
		         WHERE ( periodo = '112025' OR periodo = '102025' OR periodo = '092025' ) )";
        $conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);	
		$i = 1;		
		while($row = mysql_fetch_array($result)) 
		{
		   $pid   = $row['productoid'];
		   $vsql1 = "INSERT INTO ventaperdida(productoid,fecha) VALUES('".$pid."',CURRENT_DATE)";
		   mysql_query($vsql1,$conex);	
		   $i++;
		}

		//// 2. Cuantifico los Agotados		
		$vsql = "SELECT VP.productoid , PT.r30 , P.precio1m 
		         FROM ventaperdida VP 
				 INNER JOIN productos P ON (VP.productoid = P.productoid)
				 LEFT JOIN pedidotemporal PT ON (P.productoid = PT.productoid) 
				 WHERE VP.fecha = CURRENT_DATE";
        $conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);	
		$i = 1;		
		while($row = mysql_fetch_array($result)) 
		{
		   $pid   = $row['productoid'];
		   $r30   = $row['r30'];
		   $pre   = $row['precio1m'];

		   /// hago los calculos
		   $r1 = ($r30/30);
		   if($r1>0.1)
		   {
			   $valperdida = (0+($r1*$pre));
			   $vsql2 = "UPDATE ventaperdida SET rotacion = '".$r30."' , valorperdido = '".$pre."'
			             WHERE productoid = '".$pid."' AND fecha = CURRENT_DATE";
			   mysql_query($vsql2,$conex);	
		   }
		   else
		   {
			   $vsql2 = "DELETE FROM ventaperdida WHERE productoid = '".$pid."' AND fecha = CURRENT_DATE";
			   mysql_query($vsql2,$conex);	
		   }

		   $i++;
		}

		return;       
	}

	///////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////
	function PonerProductosdelaCompraenColaCostos($docuid)
	{
		$clase = new Sistema();
       
		$vsql = "SELECT DISTINCT productoid FROM dedocumentos WHERE docuid = ".$docuid;
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);	
		$i = 1;
		while($row = mysql_fetch_array($result)) 
		{
		   $pid   = $row['productoid'];
		   $clase->EjecutarSQL("INSERT IGNORE INTO ordenproductos(productoid,orden) VALUES(".$pid.",".$i.")");
		   $i++;
		}
		return;
	}

	///////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////
    function RegistrarProductoenZonaCero($productoid)
	{
		$clase = new Sistema();
       
		$vsql = "SELECT * FROM sectordeposito WHERE pordefecto = 1";
		$conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);	
		while($row = mysql_fetch_array($result)) 
		{
		   $sid   = $row['sectorid'];
		   $clase->EjecutarSQL("INSERT INTO productosxsector(sectorid,productoid,orden) VALUES(".$sid.",".$productoid.",0)");
		}
		return;
	}

	////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////
	function GenerarPedidoSugeridoDia($diaoperativo)
	{
	   $clase = new Sistema();
       $numero  = 'RE'.substr($diaoperativo,0,2).substr($diaoperativo,3,2).substr($diaoperativo,8,2);
       $existe  = $clase->SeleccionarUno("SELECT COUNT(*) FROM documentos WHERE tipodoc = 'PVE' AND numero = '".$numero."'"); 

		if($existe == 0)
		{ 

		  $pre = $_SESSION['G_PREF_PVE'];	 
		  $per = date("mY");
		  $sid = $clase->BDLockup($_SESSION['G_SUCURSALPOS'],"sucursales","codigo","sucursalid");
		  $bid = $clase->BDLockup($_SESSION['G_BODEGAPREDETPOS'],"bodegas","codbodega","bodegaid");

		  //// Encabezado de la Orden de Compra  	 
   		  $vsqlx = "INSERT INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,fecasentado,terid1,terid2,terid3,nrodocref,observacion,sucursalid,creador,momento) VALUES('PVE','".
		    		$pre."','".$numero."','".$per."',CURRENT_DATE,CURRENT_DATE,1,1,1,'ESPECIAL','PEDIDO AUTOMATICO DE REPOSICION AL CIERRE ".$diaoperativo."','".$sid."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
		  $clase->EjecutarSQL($vsqlx);
 	      $NDocuid = $clase->SeleccionarUno("SELECT docuid FROM documentos WHERE tipodoc='PVE' AND prefijo='".$pre."' AND numero='".$numero."'");
		  
		  // Agrego los productos
			$vsql = "SELECT P.productoid , P.precio1m , P.porciva , E.cantidad existencia , SUM(DD.unidades) vendido 
			FROM dedocumentos DD 
			INNER JOIN productos P ON (P.productoid = DD.productoid) 
			INNER JOIN documentos D ON (DD.docuid = D.docuid)
			INNER JOIN docuventa DV ON (D.docuid = DV.docuid)
			INNER JOIN existencias E ON (E.productoid = P.productoid AND E.bodegaid = ".$bid.") 
			WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.fecanulado = '0000-00-00'
			AND DV.diaoperativo = '".$diaoperativo."'
			GROUP BY 1,2,3,4   
			ORDER BY 2 DESC";

			$conex  = $clase->Conectar();
			$result = mysql_query($vsql,$conex);	
			while($row = mysql_fetch_array($result)) 
			{
				$pid      = $row['productoid'];
				$cantidad = floor($row['vendido']);	
				if($row['existencia']<$cantidad) 
				   $cantidad = floor($row['existencia']);	
				
				$precio   = $row['precio1m'];
				$porciva  = $row['porciva'];
				
				if($cantidad > 0)
				{
					$vsqly = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal,diasrecor,numlinea,unicom,unifra) 
								values('".$NDocuid."','".$pid."','".$bid."','".$cantidad."','".$cantidad."','D','0','".$precio."','0','".($precio*$cantidad)."','".$porciva."','".($precio*$cantidad)."','0','".
								($precio*$cantidad)."','0',0,'".$cantidad."','0')";	 
					$clase->EjecutarSQL($vsqly);  
					echo $vsqly."<br>";
				}
			}

     		// Pedido Generado con Exito - Se Procede a enviar a la Web
		    $RUTARECEPCION = "http://www.dromedicas.com.co/wsjson/pedidos/webservice.php";
    	    //// Extraigo la Data    

	     	$jsondata = DataPedidoJSON($NDocuid);
			/// Si hay Datos
		    if($jsondata!="")
			   $resultado = ConsumumirWebservicePedidoJSON($RUTARECEPCION,$jsondata);
            
		} // Fin de SI Existe	
		else
		  echo"Pedido ya existe";
		
	}  /// Fin de la Funcion

    //////////////////////////////////////////////////////////////////////////////////////////// 
	/// Recibe la Existencia Total de los Productos
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function RecibirExistenciaTotalProductos()
	{   
		$clase = new Sistema();

		$json = file_get_contents('https://dromedicas.com.co/wsjson/exitotalproducto/todosconexistencia.php');     
        $existencias = json_decode($json); 

        //// Primero, vacío la tabla
		$clase->EjecutarSQL("TRUNCATE exitotalprod");
		
        $detalles = ""; $i = 0; $totalacum = 0;
        while(@$existencias[$i]->productoid != "")
        {
			$cantidad = 0+$existencias[$i]->exitotal;
			if($cantidad <= 0)
			  break; 
			  
            $vsqlx = "INSERT INTO exitotalprod(productoid,exitotal) VALUES(".$existencias[$i]->productoid.",".$cantidad.")";
			$clase->EjecutarSQL($vsqlx);
			$i++;
		}	
		return(number_format($i)." Prods Actualizados");
	}


	//////////////////////////////////////////////////////////////////////////////////////////// 
	/// Envia a Rappi los datos del Comercio Actualizados
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function EnviarARappiFULL()
	{   
		$clase = new Sistema();
		$codbodega   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab = 'G_BODEGAPREDETPOS'");
		$codsucursal = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab = 'G_SUCURSALPOS'");

        $vsql = "SELECT B.codbodega store_id , P.productoid id , TRIM(P.codigo) gtin , TRIM(UCASE(P.descripcion)) productname , TRIM(UCASE(GP.descripcion)) brand , 
		         ROUND(P.precio1m) price ,  FLOOR(E.cantidad) stock ,  
		         IF(P.bloqueado = 'CHECKED','false','true') is_available , 'U' sale_type , 
				 (
			       SELECT IFNULL(IF(DP.valor > 0,(P2.precio1m-DP.valor),(P2.precio1m-(P2.precio1m*(DP.porcentaje/100)))),0) 
				   FROM promociones PR
				   INNER JOIN depromociones DP ON (PR.promoid = DP.promoid)
				   INNER JOIN productos P2 ON (DP.productoid = P2.productoid)
				   INNER JOIN promoxsucursal PXS ON (PXS.promoid = PR.promoid)
				   INNER JOIN sucursales SX ON (SX.sucursalid = PXS.sucursalid)
				   WHERE PR.desde <= CURRENT_DATE AND PR.hasta >= CURRENT_DATE AND P2.productoid = P.productoid AND SX.codigo = '".$codsucursal."' 
				   ORDER BY PR.promoid DESC LIMIT 0,1
				 ) discount_price               
				 FROM productos P INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid)
				 INNER JOIN existencias E ON (P.productoid = E.productoid)
				 INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid)
				 INNER JOIN productosxatributo PA ON (PA.productoid = P.productoid AND PA.valor = 'CHECKED') 
				 WHERE B.codbodega = '".$codbodega."' AND E.cantidad > 1 AND P.precio1m > 999 
				 ORDER BY brand ASC , productname ASC";
echo $vsql;
        $conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
		$discount_price=0;

        $jsonfinal = '{ "type": "full" , "records": [ ';
        $i=0;
		while($row = mysql_fetch_array($result))
		{
			if($i>0)
			   $jsonfinal.= ',';

			if(($row['discount_price'] == 0)||($row['discount_price'] == ""))
			{
				$discount = 0;
				$discount_price = $row['price'];
			}
			else
			{
				$discount = (intval($row['price'])-intval($row['discount_price']));
				$discount_price = intval(0+$row['discount_price']);
			}
			
			$jsonfinal.= '{
				"id" : "'.$row['id'].'",
				"store_id" : "'.$row['store_id'].'", 
				"gtin" : "'.preg_replace('([^A-Za-z0-9])','', $row['gtin']).'",
				"name" : "'.preg_replace('([^A-Za-z0-9])','', $row['productname']).'",
				"brand" : "'.preg_replace('([^A-Za-z0-9])','', $row['brand']).'",
				"trademark" : null,
				"price" : '.$row['price'].' ,
				"discount" : '.$discount.' ,
				"discount_price" : '.$discount_price.' ,
				"stock" : '.(0+$row['stock']).',
				"is_available" : '.$row['is_available'].',
				"sale_type" : "'.$row['sale_type'].'"
    		    }';

			$i++;
		}

		/// Finalizo el JSON
		$jsonfinal.= ' ] }';
        //echo $jsonfinal;

        ///// Procedo a Enviar JSON Final				  		
		$url = "https://services.grability.rappi.com/api/cpgs-integration/datasets";
		$ch = curl_init($url);

		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonfinal);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'api_key: bb048622-a115-489c-a45c-43bf9bb00d4a',
			'Content-Length: ' . strlen($jsonfinal))
		);

		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
		
		// Execute the POST request
		$jsonretorno = curl_exec($ch);

		// Close cURL resource
		curl_close($ch);

		return($jsonretorno);
	}

	//////////////////////////////////////////////////////////////////////////////////////////// 
	/// Envia a Rappi los datos del Comercio Actualizados
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function EnviarARappiDELTA()
	{   
		$clase = new Sistema();
		$codbodega   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab = 'G_BODEGAPREDETPOS'");
		$codsucursal = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab = 'G_SUCURSALPOS'");

        $hora = intval(date("H"));
		$hora--;
		$horax = $hora;
		if($hora<10) $horax = "0".$hora;

		$momentocambios = date("Y-m-d")." ".$horax.date(":i:")."00";
		
        $vsql = "SELECT B.codbodega store_id , P.productoid id , TRIM(P.codigo) gtin , TRIM(UCASE(P.descripcion)) productname , TRIM(UCASE(GP.descripcion)) brand , 
		         ROUND(P.precio1m) price ,  FLOOR(E.cantidad) stock ,  
		         IF(P.bloqueado = 'CHECKED','false','true') is_available , 'U' sale_type , 
				 (
			       SELECT IFNULL(IF(DP.valor > 0,(P2.precio1m-DP.valor),(P2.precio1m-(P2.precio1m*(DP.porcentaje/100)))),0) 
				   FROM promociones PR
				   INNER JOIN depromociones DP ON (PR.promoid = DP.promoid)
				   INNER JOIN productos P2 ON (DP.productoid = P2.productoid)
				   INNER JOIN promoxsucursal PXS ON (PXS.promoid = PR.promoid)
				   INNER JOIN sucursales SX ON (SX.sucursalid = PXS.sucursalid)
				   WHERE PR.desde <= CURRENT_DATE AND PR.hasta >= CURRENT_DATE AND P2.productoid = P.productoid AND SX.codigo = '".$codsucursal."' 
				   ORDER BY PR.promoid DESC LIMIT 0,1
				 ) discount_price               
				 FROM productos P INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid)
				 INNER JOIN existencias E ON (P.productoid = E.productoid)
				 INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid)
				 INNER JOIN productosxatributo PA ON (PA.productoid = P.productoid AND PA.valor = 'CHECKED') 
				 WHERE B.codbodega = '".$codbodega."'  AND E.cantidad > 1 AND P.precio1m > 999  AND (E.ultcambio > '".$momentocambios."' OR P.ultcambio > '".$momentocambios."') 
				 ORDER BY brand ASC , productname ASC";

        $conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$arrayFinal = [];
		$i=0;
        $discount_price = 0;

        $jsonfinal = '{ "type": "delta" , "records": [ ';
        $i=0;
		while($row = mysql_fetch_array($result))
		{
			if($i>0)
			   $jsonfinal.= ',';

			if(($row['discount_price'] == 0)||($row['discount_price'] == ""))
			{
				$discount = 0;
				$discount_price = $row['price'];
			}
			else
			{
				$discount = (intval($row['price'])-intval($row['discount_price']));
				$discount_price = intval(0+$row['discount_price']);
			}
			
			$jsonfinal.= '{
				"id" : "'.$row['id'].'",
				"store_id" : "'.$row['store_id'].'", 
				"gtin" : "'.preg_replace('([^A-Za-z0-9])','', $row['gtin']).'",
				"name" : "'.preg_replace('([^A-Za-z0-9])','', $row['productname']).'",
				"brand" : "'.preg_replace('([^A-Za-z0-9])','', $row['brand']).'",
				"trademark" : null,
				"price" : '.$row['price'].' ,
				"discount" : '.$discount.' ,
				"discount_price" : '.$discount_price.' ,
				"stock" : '.(0+$row['stock']).',
				"is_available" : '.$row['is_available'].',
				"sale_type" : "'.$row['sale_type'].'"
    		    }';

			$i++;
		}

		/// Finalizo el JSON
		$jsonfinal.= ' ] }';

        ///// Procedo a Enviar JSON Final				  		
		$url = "https://services.grability.rappi.com/api/cpgs-integration/datasets";
		$ch = curl_init($url);

		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonfinal);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'api_key: bb048622-a115-489c-a45c-43bf9bb00d4a',
			'Content-Length: ' . strlen($jsonfinal))
		);

		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
		
		// Execute the POST request
		$jsonretorno = curl_exec($ch);

		// Close cURL resource
		curl_close($ch);

		return($jsonretorno);
	}

    //////////////////////////////////////////////////////////////////////////////////////////// 
	/// Envia al Servidor las Existencias Actualizadas
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function EnviarExistenciasAServidor()
	{   
		
		$clase = new Sistema();
		$codbodega   = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab = 'G_BODEGAPREDETPOS'");

        $vsql = "SELECT E.bodegaid, E.productoid, E.cantidad
                 FROM existencias E INNER JOIN bodegas B ON (E.bodegaid = B.bodegaid) 
                 WHERE B.codbodega = '".$codbodega."' AND DATEDIFF( CURRENT_DATE, E.ultcambio ) <=3
                 ORDER BY E.ultcambio DESC";

        $conex  = $clase->Conectar();
		$result = mysql_query($vsql,$conex);
		$i=0;
        $list = array();
		while($row = mysql_fetch_array($result)) 
			$list[] = $row;
			
		$param = json_encode($list);		
        
        ///// Procedo a Enviar JSON Final				  		
		$url = "http://dromedicas.sytes.net:9999/dropos/wsjson/socketutils/recibirexistencias.php";
		//$url = "http://localhost:9999/dropos/wsjson/socketutils/recibirexistencias.php";
		$ch = curl_init($url);

		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Content-Length: ' . strlen(json_encode($param)))
		);

		curl_setopt($ch, CURLOPT_TIMEOUT, 40);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 40);
		
		// Execute the POST request
		$jsonretorno = curl_exec($ch);

		// Close cURL resource
		curl_close($ch);

		return($jsonretorno);
	}


	////////////////////////////////////////////////////////////////////////////
	//// Datos de Venta - en Sucursal
	/////////////////////////////////////////////////////////////////////////////  
	function DataPedidoJSON($docuid)
	{
		$clase = new Sistema();
		$vsql2 = "SELECT * FROM documentos D INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) WHERE D.docuid = ".$docuid;

		$conex  = $clase->Conectar();
		$result = mysql_query($vsql2,$conex);
		$list = array();
		while($row = mysql_fetch_array($result)) 
			$list[] = $row;
			
		$param = json_encode($list);			  
		return($param); 
		
	} // Fin de DataVentaMySQL  

	
	/////////////////////////////////////////////////////////////////////////////
	//// Consumir WebService
	/////////////////////////////////////////////////////////////////////////////  
	function ConsumumirWebservicePedidoJSON($ruta,$datajson)
	{
		$dirWS = $ruta.'?m=POST';
		$ch = curl_init($dirWS);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch, CURLOPT_POSTFIELDS, $datajson);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'Content-Length: ' . strlen($datajson))
		);
		curl_setopt($ch, CURLOPT_TIMEOUT, 120);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 120);

		//execute post
		$result2 = curl_exec($ch);

		//close connection
		curl_close($ch);

		/// Retorno el JSON con el resultado
		$obj = json_decode($result2);   
		$objArr = (array)$obj;
		return($objArr);    
  	}


    /////////////////////////////////////////////////////////////////////////////////////////// 
	/// Consumo de API  - Externa
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function Consumir_API_GET($URL)
	{   
		//// http://192.168.14.244:9999/dropos/api20/inventario/bodegas/index.php
		$ch = curl_init($URL);
		$jsonfinal = "";

		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json')
		);

		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
		
		// Execute the POST request
		$datajson = curl_exec($ch);       
        echo $datajson;

		// Close cURL resource
		curl_close($ch);

		$jsonretorno = json_decode($datajson);		
		
		return($datajson);
	}


	//////////////////////////////////////////////////////////////////////////////////////////// 
	/// Consumo de APIs DROPOS - Interno
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function Consumir_APIDROPOS_GET($URL)
	{   
		//// http://192.168.14.244:9999/dropos/api20/inventario/bodegas/index.php
		$ch = curl_init($URL);
		$jsonfinal = "";
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, 'droposerp:d2218aa');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'api_key: bb048622-a115-489c-a45c-43bf9bb00d4a',
			'Content-Length: ' . strlen($jsonfinal))
		);

		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
		
		// Execute the POST request
		$datajson = curl_exec($ch);       

		// Close cURL resource
		curl_close($ch);

		$jsonretorno = json_decode($datajson);		
		return($jsonretorno);
	}

	//////////////////////////////////////////////////////////////////////////////////////////// 
	/// Consumo de APIs DROPOS -   METODO GET   - Interno
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function Consumir_APIDROPOS_POST($URL,$jsonentrada)
	{   
		//// http://192.168.14.244:9999/dropos/api20/nomina/conceptoexpediente/index.php
		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonentrada);		
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, 'droposerp:d2218aa');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'api_key: bb048622-a115-489c-a45c-43bf9bb00d4a',
			'Content-Length: ' . strlen($jsonentrada))
		);

		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
		
		// Execute the POST request
		$datajson = curl_exec($ch);       

		// Close cURL resource
		curl_close($ch);

		$jsonretorno = json_decode($datajson);		
		return($jsonretorno);
	}

	//////////////////////////////////////////////////////////////////////////////////////////// 
	/// Consumo de APIs DROPOS -   METODO GET   - Interno
	//////////////////////////////////////////////////////////////////////////////////////////// 
	function Consumir_APIDROPOS_PUT($URL,$jsonentrada)
	{   
		//// http://192.168.14.244:9999/dropos/api20/nomina/conceptoexpediente/index.php
		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonentrada);
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, 'droposerp:d2218aa');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'api_key: bb048622-a115-489c-a45c-43bf9bb00d4a',
			'Content-Length: ' . strlen($jsonentrada))
		);

		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
		
		// Execute the POST request
		$datajson = curl_exec($ch);       

		// Close cURL resource
		curl_close($ch);

		$jsonretorno = json_decode($datajson);		
		return($jsonretorno);
	}



	////////////////////////////////////////////////////////////////
	//// METODO - DELETE
	////////////////////////////////////////////////////////////////	
	function Consumir_APIDROPOS_DELETE($URL)
	{   
		//// http://192.168.14.244:9999/dropos/api20/inventario/bodegas/index.php
		$ch = curl_init($URL);
		$jsonfinal = "";
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, 'droposerp:d2218aa');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-Type: application/json',
			'api_key: bb048622-a115-489c-a45c-43bf9bb00d4a',
			'Content-Length: ' . strlen($jsonfinal))
		);

		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
		
		// Execute the POST request
		$datajson = curl_exec($ch);       

		// Close cURL resource
		curl_close($ch);

		$jsonretorno = json_decode($datajson);		
		return($jsonretorno);
	}


	  ////////////////////////////////////////////////////////////////////////////
	  /////  Programacion Rappi Cierre
	  ////////////////////////////////////////////////////////////////////////////
	  function programacionrappidiasiguiente()
	  {
		  $clase = new Sistema();
		  $vsql2 = "UPDATE programacionrappi SET fecha = DATE_ADD(CURDATE(),INTERVAL 1 DAY) , realizado = 0 WHERE 1";
		  $clase->EjecutarSQL($vsql2); 
		  return;
	  }

	  ////////////////////////////////////////////////////////////////////////////
	  ////////////////////////////////////////////////////////////////////////////
	  /**
	   * Funciones MODULO CONTABLE
	   * Listado de Funciones que Gestionan todo el modulo contable
	   * @version 10.0.29, 11/02/21
	   * @author saidrodriguezc
	   */
      ////////////////////////////////////////////////////////////////////////////
	  ////////////////////////////////////////////////////////////////////////////
	 
	  ////////////////////////////////////////////////////////////////////////////
	  /** 
	    * Funcion SALDOCUENTA
        * Devuelve el Saldo de la Cuenta Global
        * @param Pucid cuenta
        * @return Valor del saldo de la Cuenta. Cero en caso de no tener valor
        */ 

	  function SaldoCuenta($pucid)
	  {
         return;
 	  } 

      ////////////////////////////////////////////////////////////////////////////
	  /** 
	    * Funcion SALDOCUENTA
        * Devuelve el Saldo de la Cuenta Global
        * @param Pucid cuenta
        * @return Valor del saldo de la Cuenta. Cero en caso de no tener valor
        */ 

		function SaldoCuentaCentroCosto($pucid)
		{
		   return;
		} 
  


?>