<?PHP
    /*
     * Clase que gestiona los métodos y llama a las funciones segun el caso
     * @author Ing. Said Rodriguez
     * @version: 31/08/2016
     */
 require_once "WebserviceDB.php";

 class WebserviceAPI 
 {    
    public function API()
    {
        header('Content-Type: application/JSON');                
        $method = $_SERVER['REQUEST_METHOD'];
        
        switch ($method) {
        
        case 'GET':               // Consulta de Registros - SELECT
            $this->getUsuarios();
            break;     
        
        case 'POST':              // Adicion de Registros - INSERT
            $this->saveUsuario();
            break;                
        
        case 'PUT':               // Actualizacion de Registros - UPDATE
            $this->updateUsuario();
            break;      
        
        case 'DELETE':            // Eliminacion de Registros - DELETE
            $this->borrarUsuario();
            break;
        
        default:                  // POR DEFECTO OTROS NO SOPORTADOS
            echo 'METODO NO SOPORTADO';
            break;
        }
    }
    
    /*
    *  Genera las respuestas con los codigos predeterminados segun el protocolo
    */
    function response($code=200, $status="", $message="") 
    {
      http_response_code($code);
      
      if( !empty($status) && !empty($message) ){
        $response = array("status" => $status ,"message"=>$message);  
        echo json_encode($response,JSON_PRETTY_PRINT);    
      }            
    }  

    /*
     *  Selecciona 1 o Todos los Usuarios de la Base de Datos
     *  Parametro : Vacio o el usuid del Usuario
     *  Retorno   : Los datos del Usuario solicitado o de Todos los usuarios
     */
    function getUsuarios()
    {
      if($_GET['action']=='usuarios'){         
         $db = new WebserviceDB();
         if(isset($_GET['id'])){//muestra 1 solo registro si es que existiera ID                 
             $response = $db->getUsuario($_GET['id']);                
             echo json_encode($response,JSON_PRETTY_PRINT);
         }else{ //muestra todos los registros                   
             $response = $db->getUsuarios();              
             echo json_encode($response,JSON_PRETTY_PRINT);
       }
     }else{
           $this->response(400);
     }       
    }

    /*
     *  Modifica los datos de un Usuario
     *  Parametros : Username - Clave del Usuario
     *  Retorno    : Estado del response segun lo ejecutado
     */
    function saveUsuario()
    {
       if($_GET['action']=='usuarios')
       {   
         //Decodifica un string de JSON
         $obj = json_decode( file_get_contents('php://input') );   
         $objArr = (array)$obj;
          if (empty($objArr)){
             $this->response(422,"error","Imposible Adicionar Registro - Datos incorrectos o Invalidos");                           
         }else if(isset($obj->name)){
            $WsDB = new WebserviceDB();     
            $WsDB->insert( $obj->name , $obj->pass);
            $this->response(200,"ejecutado","Registro creado con Exito");                             
         }else{
              $this->response(422,"error","The property is not defined");
         }
       }else{               
         $this->response(400);
      }  
    } 
 
    /*
     *  Elimina un Usuario
     *  Parametros : Usuid del Usuario
     *  Retorno    : Respuesta HTTP
     */
    function updateUsuario() 
    {
      if( isset($_GET['action']) && isset($_GET['id']) )
      {
          if($_GET['action']=='usuarios'){
              $obj = json_decode( file_get_contents('php://input') );   
              $objArr = (array)$obj;
              if (empty($objArr)){                        
                  $this->response(422,"error","Nothing to add. Check json");                        
              }else if(isset($obj->name)){
                  $db = new WebserviceDB();
                  $db->update($_GET['id'], $obj->name , $obj->pass);
                  $this->response(200,"success","Record updated");                             
              }else{
                  $this->response(422,"error","The property is not defined");                        
              }     
              exit;
           }
      }
     $this->response(400);
    }   

    /*
     *  Elimina un Usuario
     *  Parametros : Usuid del Usuario
     *  Retorno    : Respuesta HTTP
     */
    function borrarUsuario(){
        if( isset($_GET['action']) && isset($_GET['id']) ){
            if($_GET['action']=='usuarios'){                   
                $db = new WebserviceDB();
                $db->delete($_GET['id']);
                $this->response(204);                   
                exit;
            }
        }
        $this->response(400);
    }

 }//end class
 
 
?>