<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Productos
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-28
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene un Listado de Productos (Los Primeros 100)
	 *
	 * @param Vacio	 
	 * @return Lista de Productos en Formato JSON
	 */
	function getSucursales()
	{
		$this->db->query("SET @counter = 0");
		
		$query = 'SELECT sub.* FROM (SELECT upper( s.descripcion ) sucursal , s.latitud, s.longitud, s.direccion2, s.telefono, s.celular, 
			      c.nombre , s.es24horas, IF( s.horaperturagen = "00:00" , "" , s.horaperturagen) an , 
			      IF( s.horacierregen = "00:00" , "", s.horacierregen) cn , IF( s.horaperturaes = "00:00", "" , s.horaperturaes) ae,
                  IF( s.horacierrees = "00:00", "" , s.horacierrees) ce ,  (@counter := @counter +1) as contador
  				  FROM sucursales s INNER JOIN ciudades c ON ( s.ciudadcodigo = c.codigo) 
  				  WHERE s.longitud <> null OR s.longitud != ""  ORDER BY 1 ASC) sub';
		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		{
			$list[] = $row;
		}
		return $list;
	}


} /// Fin de la Clase API
