<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Transferencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-30
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}


    /**
	 * Crea una nueva Transferencia por Cargar
	 *
	 * @param Array con los datos de la Transferencia	 
	 * @return 1 Exitoso - 0 Error 
	 */
    function setNuevaRecarga($params)
	{
		require_once('../../lib/nusoap/lib/nusoap.php');
        set_time_limit(25);
  
        /// Produccion - Privado A traves de VPN
        $servicio = "http://10.125.15.4:8980/WebServicePuntoRedHTTPAutentication/services/PuntoRedWSService?wsdl"; 
        $usuario  = "cxrdromedicas";
        $puerto   = 8980; 
        $clave    = "f20855c15c65859df6145b9821029f72";  
  
        $client = new nusoap_client($servicio, true);
        $client->setCredentials($usuario,$clave,"basic");
  
        $client->soap_defencoding = 'UTF-8';
        $client->decode_utf8 = true;

        $err = $client->getError();
        if ($err) 
        {
           $XRETORNO = "99|No se puede conectar";
           return($XRETORNO);
           exit();
        }
        else
        {
			//// Datos del Comercio - Pto de Venta - Terminal
			$comercio = "283142";
			$ptoventa = "138164";
			$terminal = "188101";
			$clave    = "13102015";

	        /// Leo los parametros del WebService
	        $data = array();
	        $obj = (array)$params;
	 
	        /// Capturo los Datos de la Recarga
	        $codoperador = $params['codoperador'];                   $numrecarga  = $params['numrecarga'];
	        $codvende    = $params['codvende'];                      $pinrecargas = $params['pinrecargas'];       
	        $codsucursal = $params['codsucursal'];                   $creador     = $params['creador']; 
	        $idfactura   = $params['idfactura'];                     $valor       = $params['valor'];
	        $servidor    = $params['servidor'];                      $numfactura  = $params['numfactura']; 


			/// Paso los parametros al Webservice
			$param = array('comercioId' => $comercio , 'puntodeventaId' => $ptoventa , 'terminalId' => $terminal , 'clave' => $clave , 'codigoOperador'=>$codoperador , 'numero'=>$numrecarga , 'valor'=>$valor , 'trace'=>$numfactura);
			$result = $client->call("recarga" , $param);
			   
			return($result);
        }	
 
	}

} /// Fin de la Clase API
