<?php
header('Access-Control-Allow-Origin: *');
header('Content-type: application/json; charset=utf-8');
/**
 * Ejemplo simple de Uso de un Webservice
 * @author Said Rodriguez
 * @version v1.0
 * @return  Datos de la Venta Actualizada en Formato JSON
 **/

// Vinculo el Archivo de la API
require_once 'api.php';

// Crea una nueva Instancia de la API del Producto
$api = new api();

// message to return
$message = array();

// Capturo el Metodo -> GET -> POST -> PUT -> DELETE
$method = $_SERVER['REQUEST_METHOD'];

$m = $_GET['m'];
if($m == "POST")     $method = $m;

//// Parametros que se le pasan a los métodos del WebService
$params = array();

switch($method)
{
	///////////////////////////////////////////////////////////////////////////////////////
	///// GET -> Obtiene la Lista de Productos o los datos de un producto con id = ID
	case 'GET':
	
		$data = $api->getTransaccionesPendientes();
		$message["code"] = "1";
		$message["data"] = $data;	
		
        response(200,"sucess",$message);	
	
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// POST -> Crear Nuevo Producto
    case 'POST':
		    $data = "ERROR : No está Admitida la Actualizacion de Transferencias Via WebService";
	        $message["code"] = "1";
		    $message["data"] = $data;		  
		    response(400,"error","No se admite la actualizacion de Transferencias Via WebService");	
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// PUT -> Actualizar Datos del Producto
    case 'PUT':
		    $data = "ERROR : No está Admitida la Actualizacion de Transferencias Via WebService";
		    $message["code"] = "1";
		 	$message["data"] = $data;		  
		 	response(400,"error","No se admite la actualizacion de Transferencias Via WebService");	
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// POST -> Crear Nuevo Producto
    case 'DELETE':
		    $data = "ERROR : No está Admitida la creacion de Transferencias Via WebService";
		    $message["code"] = "1";
		 	$message["data"] = $data;	
		 	response(400,"error","No se admite el borrado de Transferencias Via WebService");	  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// En caso de no ser ninguno de los Metodos permitidos muestro el error
	default://metodo NO soportado
       response(400,"error","Metodo NO Soporta");
    break;
}

//////////////////////////////////////////////////////////////
//// Genera la Respuesta en Formato JSON
//////////////////////////////////////////////////////////////
function response($code=200, $status="", $message="") 
{
    $status = strtolower($status);
    if( !empty($status) && !empty($message) )
    {
        $response = array("status" => $status ,"message" => $message);
        echo json_encode($response);
    }            
 }   

?>
