<?php
header('Access-Control-Allow-Origin: *');
/**
 * Ejemplo simple de Uso de un Webservice
 * @author Said Rodriguez
 * @version v1.0
 * @return  Datos del Producto en Formato JSON
 **/

// Vinculo el Archivo de la API
require_once 'api.php';

// Crea una nueva Instancia de la API del Producto
$api = new api();

// message to return
$message = array();

// Capturo el Metodo -> GET -> POST -> PUT -> DELETE
$method = $_SERVER['REQUEST_METHOD'];

//// Parametros que se le pasan a los métodos del WebService
$params = array();

switch($method)
{
	///////////////////////////////////////////////////////////////////////////////////////
	///// GET -> Obtiene la Lista de Productos o los datos de un producto con id = ID
	case 'GET':

		$params['documento']    = $_GET["documento"];     				$params['tipodocumento']   = $_GET["tipodocumento"];
		$params['nombres']      = $_GET["nombres"];             		$params['apellidos']       = $_GET["apellidos"];
		$params['sexo']         = $_GET["sexo"];		        		$params['fechanacimiento'] = $_GET["fechanacimiento"];		
		$params['telefonofijo'] = $_GET["telefonofijo"];				$params['celular']         = $_GET["celular"];		
		$params['ciudad']       = $_GET["ciudad"];			         	$params['email']           = $_GET["email"];	
		$params['direccion']    = $_GET["direccion"];                   $params['barrio']          = $_GET["barrio"];	

		if((strlen($_GET["documento"])>0)&&(strlen($_GET["nombres"])>0)&&(strlen($_GET["apellidos"])>0))
        {
	          $data = $api->AfiliarPersona($params);
	          if(strlen($data)>0)
			  {
					if($data == 1)
					{
						if(strlen($_GET["email"])>0)
						  EnviarCorreoNotificacion($_GET["documento"],$_GET["nombres"],$_GET["apellidos"],$_GET["email"]);

						$message["code"] = $data;
					 	$message["data"] = $data;
				 	    response(200,"sucess","Persona Afiliada con Exito",$data);
					}
					else
					{
						if($data == 99)
							$msgError = "Persona ya registrada";
						if($data == 51)
							$msgError = "Debe suministrar al menos un telefono o celular";
                        if($data == 52)
							$msgError = "Fecha de Nacimiento es Obligatorio";	

						$message["code"] = $data;
					 	$message["data"] = $data;
				 	    response(400,"error",$msgError,$data);				
					}
			  } 
			  else 
			  {
				$message["code"] = "0";
				$message["message"] = "Parametros Incorrectos al Webservice";
			    response(400,"error","Error al Procesar la Transaccion",$data);
			  }	
        }
		else
		{
            $message["code"] = "0";
			$message["message"] = "Faltan Datos minimos para la afiliacion de la Persona";
			response(400,"error",$message["message"],$data);		  
		}

	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// POST -> Crear Nuevo Producto
    case 'POST':
		    $data = "ERROR : No está Admitida la creacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["data"] = $data;		  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// PUT -> Actualizar Datos del Producto
    case 'PUT':
		    $data = "ERROR : No está Admitida la Actualizacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["data"] = $data;		  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// POST -> Crear Nuevo Producto
    case 'DELETE':
		    $data = "ERROR : No está Admitida la creacion de Productos Via WebService";
		    $message["code"] = "0";
		 	$message["data"] = $data;		  
	break;

	///////////////////////////////////////////////////////////////////////////////////////
    //// En caso de no ser ninguno de los Metodos permitidos muestro el error
	default://metodo NO soportado
       echo 'METODO NO SOPORTADO';
    break;
}

 //////////////////////////////////////////////////////////////
 //// Genera la Respuesta en Formato JSON
 //////////////////////////////////////////////////////////////
 function response($code=200, $status="", $message="" , $data="") 
 {
    $status = strtolower($status);
    $response = array("code" => $code , "status" => $status ,"message" => $message , "data" => $data);
    echo json_encode($response);
 }   

 
  //////////////////////////////////////////////////////////////
  //// Genera la Respuesta en Formato JSON
  //////////////////////////////////////////////////////////////
  function EnviarCorreoNotificacion($documento,$nombres,$apellidos,$correo) 
  {
  	 /// Cargo la Plantilla y posteriormente le reemplazo las variables
     $plantilla = "";
     $ruta = "../../recursos/html/registropuntosf.html";
     $fp = fopen($ruta,"r");     
     while ($linea= fgets($fp,2048))
       $plantilla.= $linea;
     
     /// Reemplazo los campos  
     $plantilla = str_replace("#{DOCUMENTO}", $documento , $plantilla);                
     $plantilla = str_replace("#{NOMBRES}", $nombres , $plantilla);                
     $plantilla = str_replace("#{APELLIDOS}" , $apellidos , $plantilla); 

     require '../../lib/PHPMailer/PHPMailerAutoload.php';
     $mail = new PHPMailer;
     $mail->isSMTP();
     $mail->SMTPDebug = 0;
     $mail->Debugoutput = 'html';
     $mail->Host = 'smtp.gmail.com';
     $mail->Port = 587;
     $mail->SMTPSecure = 'tls';
     $mail->SMTPAuth = true;
     $mail->Timeout=20;
     $mail->CharSet = 'UTF-8';
     $mail->Username = "contacto.sms.service@gmail.com";
     $mail->Password = "Barcelona2013.";
     $mail->setFrom('info@puntosfarmanorte.com.co', 'Puntos Farmanorte App');
     $mail->addReplyTo('info@puntosfarmanorte.com.co', 'Puntos Farmanorte App');
     
     $mail->addAddress("info@puntosfarmanorte.com.co", "Dpto Sistemas");
     $mail->addAddress($correo , "Afiliado Puntos Farmanorte");
     $mail->Subject = 'Afiliacion al programa Puntos Farmanorte';
     
     $mail->isHTML(true);       
     $mail->Body = $plantilla;
     $mail->send();
  }

?>
