<?php
  header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
  header("Expires: Sat, 1 Jul 2000 05:00:00 GMT");
  
  ini_set('display_errors', FALSE);
  ini_set('display_startup_errors', FALSE);
  ////////////////////////////////////////////////////////////////////////////////////////
  // ReIngenieria - Login DROPOS
  // Clase Index - Metodos para deteccion de Posibles Errores
  // @Autor Ing Said Rodriguez
  ////////////////////////////////////////////////////////////////////////////////////////

  include("lib/Sistema.php");
  $opcion = $_GET['opcion'];

  class Index
  {
  	  public $Bloqueado;         /// Define si el Acceso esta restringido
     public $NombreApp;         /// Nombre del Aplicativo
     public $FechaActual;       /// Fecha Actual del Sistema
     public $VersionSoft;       /// Version del Kernel del Software
     public $CodigoSucursal;    /// Codigo de la Sucursal Activa
     public $NombreSucursal;    /// Nombre de la Sucursal Activa
     public $NavegadorUsado;    /// Codigo de la Sucursal Activa
     public $SistemaOperatSer;  /// Nombre de la Sucursal Activa
   

     //////////////////////////////////////////////////////////////////////////////////////
     // Constructor : Inicializa las Propiedades
     //////////////////////////////////////////////////////////////////////////////////////
  	 function __construct()
	   {
         $this->GetNombreApp();
         $this->GetSistemaBloqueado();
         $this->GetFechaActual();
         $this->GetSucursal();
         $this->GetVersion();
     }
     
     //////////////////////////////////////////////////////////////////////////////////////
     // GetDataConexion : Obtiene la conexion a Datos a la que esta conectado
     //////////////////////////////////////////////////////////////////////////////////////
     function GetURLData()
     {
        $clase = new Sistema();
        $conex = $clase->Conectar();
        return($clase->ServidorBD.":".$clase->UsuarioBD."@".$clase->NombreBD);
     } 

     //////////////////////////////////////////////////////////////////////////////////////
     // GetNombreApp : Obtiene el Nombre del Sistema
     //////////////////////////////////////////////////////////////////////////////////////
     function GetNombreApp()
     {
        $this->NombreApp = $this->LeerArchivo("config/nombreapp.txt");
        return($this->NombreApp);
     } 

     //////////////////////////////////////////////////////////////////////////////////////
     // GetConexionServidor() : Obtiene la conexion al servidor y retorna si hay o NO
     //////////////////////////////////////////////////////////////////////////////////////
     function GetConexionServidor()
     {
         $valor = $this->ConexionServidor();
         print_r($valor);
         return($valor);
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // GetConexionDB : Determina si hay conexion con MySQL o NO
     //////////////////////////////////////////////////////////////////////////////////////
     function GetConexionDB()
     {
     	  $clase = new Sistema();
     	  $conex = $clase->Conectar();
        if($conex)
          return(true);
        else
          return(false); 
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // GetSucursal : Obtiene el Codigo y el nombre de la Sucursal Activa
     //////////////////////////////////////////////////////////////////////////////////////
     function GetSucursal()
     {
        $clase = new Sistema();
        $this->CodigoSucursal = $clase->BDLockup('G_SUCURSALPOS','configuraciones','variab','contenido');     
        $this->NombreSucursal = $clase->BDLockup($this->CodigoSucursal,'sucursales','codigo','descripcion');     
        if(strlen($this->NombreSucursal)==0)
        {
            $this->CodigoSucursal = "";     
            $this->NombreSucursal = "";
        }
        return;
     }     
     
     //////////////////////////////////////////////////////////////////////////////////////
     // GetVersion : Obtiene la Version del Sistema - Kernel
     //////////////////////////////////////////////////////////////////////////////////////
     function GetVersion()
     {
        $this->VersionSoft = $this->LeerArchivo("version.txt");
        return($this->VersionSoft);
     }     

     //////////////////////////////////////////////////////////////////////////////////////
     // LeerArchivo : Lee el contenido de un archivo y lo retorna
     //////////////////////////////////////////////////////////////////////////////////////
     function LeerArchivo($filename)
     {
         if(file_exists($filename))
         {
           $fp = fopen(@$filename, "r");
           $linea="";
           while(!feof($fp))
              $linea.= fgets($fp);
         }
         fclose($fp);
         return($linea); 
     }
        
     //////////////////////////////////////////////////////////////////////////////////////
     // GetBloqueoCierre() : Determina si el sistema está bloqueado por el cierre Definit
     //////////////////////////////////////////////////////////////////////////////////////
     function GetBloqueoCierre()
     {
        if(file_exists("tmpcierre.txt"))
           $this->Bloqueado = true;
        else
           $this->Bloqueado = false;          
           
        return($this->Bloqueado);	
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // GetBloqueoCierre() : Determina si el Browser es el correcto para ingresar a la App
     //////////////////////////////////////////////////////////////////////////////////////
     function GetNavegadorOk()
     {
        $navegador = $this->NavegadorName();
        if(($navegador == "SAFARI")||($navegador == "OPERA")||($navegador == "CHROME"))
          return(true);
        else
          return(false);	
     }
     
     //////////////////////////////////////////////////////////////////////////////////////
     // GetBloqueoCierre() : Determina si el sistema está bloqueado por el Administrador
     //////////////////////////////////////////////////////////////////////////////////////
     function GetSistemaBloqueado()
     {
        $this->Bloqueado = false;
        return($this->Bloqueado);  
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // GetFechaActual() : Detecta la Fecha actual del servidor y la retorna con formato
     //////////////////////////////////////////////////////////////////////////////////////
     function GetFechaActual()
     {
        $semana = array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sabado");
        $mes    = array("","Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
        $this->FechaActual = $semana[(date("w"))].", ".date("d")." de ".$mes[(date("n"))]." de ".date("Y");
        return($this->FechaActual);  
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // NavegadorName() : Detecta el nombre del navegador usado
     //////////////////////////////////////////////////////////////////////////////////////
     function NavegadorName()
     {
        $info      = $this->DatosConexion();
        $navegador = $info["browser"]; 
        return($navegador);
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // ConexionServidor() : Establece una conexion al servidor remoto y retorna si conectó o NO
     //////////////////////////////////////////////////////////////////////////////////////
     function ConexionServidor()
     {
         $url   = 'http://dromedicas.ddns.net:9999/dropos/wsjson/probarconexion/';
         $json  = @file_get_contents($url);
         $array = json_decode($json,true);
         if(sizeof($array) == 0)
           return(false);
         else
           return(true);  	
     }
     
     /////////////////////////////////////////////////////////////////////////////////////
     //  AlertaError() : Muestra un mensaje de Alerta segun los parametros 
     //  Tipo : OK  |  ERROR  |  INFO 
     /////////////////////////////////////////////////////////////////////////////////////
     function AlertaError($titulo,$mensaje,$tipo,$txtboton,$opciones="")
     {
        if($tipo == "OK")      {   $tipoboton = "btn-sucess";    $icono = "success";   }
        if($tipo == "AVISO")   {   $tipoboton = "btn-warning";   $icono = "warning";   }
        if($tipo == "ERROR")   {   $tipoboton = "btn-danger";    $icono = "error";   }
        if($tipo == "INFO")    {   $tipoboton = "btn-info";      $icono = "info";      }

        $cont = '<script language="javascript">
                 <!--
                   swal({title: "'.$titulo.'", text: "'.$mensaje.'", type: "'.$icono.'", confirmButtonClass: "'.$tipoboton.'", confirmButtonText: "'.$txtboton.'", closeOnConfirm: true});
                 -->
                </script>';
        return($cont);         
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // DatosConexion() : Detecta ciertos parámetros de la conexion | Browser | IP | O.S
     //////////////////////////////////////////////////////////////////////////////////////
     function DatosConexion()
     {
   	    $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
	      $os=array("WIN","MAC","LINUX");
 
	      # definimos unos valores por defecto para el navegador y el sistema operativo
	      $info['browser'] = "OTHER";
   	    $info['os'] = "OTHER";
 
	    # buscamos el navegador con su sistema operativo
	    foreach($browser as $parent)
	    {
		    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
		    $f = $s + strlen($parent);
	 	    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
	 	    $version = preg_replace('/[^0-9,.]/','',$version);
		    if ($s)
	  	  {
		     	 $info['browser'] = $parent;
		     	 $info['version'] = $version;
		    }
	    }
 
	    # obtenemos el sistema operativo
	    foreach($os as $val)
	    {
		     if (strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
			    $info['os'] = $val;
	    }
      
      $this->NavegadorUsado   = $info['browser'];
      $this->SistemaOperatSer = $info['os'];      
	    # devolvemos el array de valores
	    return $info;
      }

     //////////////////////////////////////////////////////////////////////////////////////
     // DatosConexion() : Detecta ciertos parámetros de la conexion | Browser | IP | O.S
     //////////////////////////////////////////////////////////////////////////////////////
     function EsConexionRemota()
     {
        $URL = substr($_SERVER["HTTP_HOST"], $f, 15);

        if((substr($URL,0,8) == "192.168.")||(substr(strtoupper($URL),0,9) == "LOCALHOST"))
           return(false);
        else
           return(true); 
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // CrearCookie() : Detecta ciertos parámetros de la conexion | Browser | IP | O.S
     //////////////////////////////////////////////////////////////////////////////////////
     function CrearCookie($nombrecookie,$contenido,$diasexpira)
     {
         echo'<script language="javascript">
               <!--
                  function setCookie(cname, cvalue, exdays) {
                      var d = new Date();
                      d.setTime(d.getTime() + (exdays*24*60*60*1000));
                      var expires = "expires="+ d.toUTCString();
                      document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
                  }

                  setCookie("DROPOS", "SAIDRODRIGUEZ", 5);
               -->
             </script>';
         return(true);    
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // ExisteCookie($nombre) : Determina si la Cookie Existe o NO
     //////////////////////////////////////////////////////////////////////////////////////
     function ExisteCookie($nombrecookie)
     {
        /*
        if( isset( $_COOKIE[$nombrecookie]) )
           return(true);
        else
           return(false);
        */
        return(true);   
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // ValorCookie($nombre) : Retorna el contenido de una Cookie
     //////////////////////////////////////////////////////////////////////////////////////
     function ValorCookie($nombrecookie)
     {
        /*
        if( isset( $_COOKIE[$nombrecookie]) )
           return($_COOKIE[$nombrecookie]);
        else
           return("");
         */
        return(""); 
     }     

  } // Fin de la Clase Index 

  
  ////////////////////////////////////////////////////////////////////////////////////////
  //// Bloques de Opcion
  ////////////////////////////////////////////////////////////////////////////////////////
  $obj = new Index();
  if($opcion == "registrar")
  {
     $token = $_GET['token'];
     if(strlen($token)>0)
     {
        $vsql  = "SELECT COALESCE(DATEDIFF(fecexpira,CURRENT_TIMESTAMP),0) FROM equiposautorizados WHERE EXTRACT(YEAR FROM fecactivado) = '0000' AND claveregistro = '".$token."'";
        $clase = new Sistema();
        $dias  = $clase->SeleccionarUno($vsql);  
        $dias += 0;

        if($dias>0)
        {
           $id = $clase->BDLockup($token,"equiposautorizados","claveregistro","id");
           RegistrarEquipo($id);
           echo'<script language="javascript">
                  <!--
                     alert("Registro Exitoso!");
                     document.location.href = "index.php";
                  -->
                 </script>';    
        } 
        else
        {
            echo'<script language="javascript">
                  <!--
                     alert("Equipo ya ha sido activado o ha superado el tiempo de la Activacion");
                     document.location.href = "http://www.farmanorte.com.co";
                  -->
                 </script>';
        }    
     }
     else
     {
        echo'<script language="javascript">
              <!--
                 alert("Debe Tener un Token Asignado");
                 document.location.href = "http://www.farmnanorte.com.co";
              -->
             </script>';
     } 
     exit;
  }  
 
  /////////////////////////////////////////////////////////////////////////////
  ///// Horario No permitido 
  if($opcion == "errorhorario") 
  {
     $error = $obj->AlertaError("Horario NO Autorizado","En este momento no es posible ingresar al sistema","ERROR","Aceptar");
  }

  /////////////////////////////////////////////////////////////////////////////
  ///// Muestro el Contenido de la Cookie .. si existe 
  if($opcion == "vercookie") 
  {
     echo "**".$_COOKIE['DROPOS']."**";
     exit;
  }
  
  ////////////////////////////////////////////////////////////////////////////////////////
  /// Parametrizo el Login en caso de acceder de forma remota
  ////////////////////////////////////////////////////////////////////////////////////////
  $clase = new Sistema();
  $obj = new Index();
  
  //// Registro el paso x aqui
  //$clase->RegistrarAccesoLog();
   
  /// Aqui controla los equipos registrados
  $usuariopredet = strtoupper($obj->ValorCookie("DROPOS")); 
  $esloginremoto = $obj->EsConexionRemota();
  
  /*/// Cierro las Conexiones Activas Pegadas
  if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR")
     $clase->EjecutarSQL("CALL PA_CerrarConexiones()");  
  */
  /////////////////////////////////////////////////////////
  /// Controlo q no me deje entrar remotamente
  /// Desde aqui
  /////////////////////////////////////////////////////////
  if($esloginremoto)
  {
      if($obj->ExisteCookie("DROPOS"))
      {  
          $usuariopredet = strtoupper($_COOKIE['DROPOS']); 
          $estado = "readonly";
          
          /// Busco SI el usuario tiene activado el Acceso Remoto
          $activoAccesoRemoto = $clase->BDLockup($usuariopredet,"usuarios","username","accesoexterno");
          if($activoAccesoRemoto == "")
          {
             echo'<script language="javascript">
                <!--
                   alert("Equipo / Dispositivo NO Registrado");
                   alert("Denegado Acceso Remoto","El Usuario '.$usuariopredet.' No tiene permitido acceder de forma remota");
                   document.location.href = "http://www.farmanorte.com.co/";
                -->
               </script>';
          } 
          else
             $msgremoto = "Se ha concedido el Acceso al Usuario ".$usuariopredet." exclusivamente en este dispositivo";
      }
      else
      {
          echo'<script language="javascript">
                <!--
                   alert("Acceso Remoto No permitido a este equipo");
                   document.location.href = "http://www.farmanorte.com.co/";
                -->
               </script>';
          exit;     
      }
  }  
  else
  {
      $usuariopredet = $_COOKIE["DROPOS"];
      $estado = "";
  }  
  
  /// Arreglo temporal
  $usuariopredet = ""; 
  $estado = "";
  
  /// Hasta aqui
  $encabezado = '<!DOCTYPE html>
   <html lang="es">
    <head>
      <meta charset="UTF-8">
        <title>'.$obj->CodigoSucursal.' '.$obj->NombreApp.' v '.$obj->VersionSoft.'</title>
        <link rel="stylesheet" href="css/layout.css"> 
        <link rel="stylesheet" href="lib/sweetalert.css"> 
        <META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE">
        <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
        <!--Forzar la Actualizacion sin Cache - Control+F5 -->
        <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="Expires" content="0" />
        <link rel="shortcut icon" type="image/x-icon" href="images/favicon.ico">  
        <script src="lib/jquery-2.1.3.min.js"></script>
        <script src="lib/sweetalert.js"></script>
        <script src="js/test.js"></script>

    </head>
    <body class="body" id="body">';

 //////////////////////////////////////////////////////////////////////////
 // Aqui se harán las respectivas validaciones para mostrar al usuario 
 // si hay problemas para iniciar sesion. Estos errores estan priorizados
 // desde el mas Critico al menos critico para que No salgan varios
 // errores sino uno a la vez
 //////////////////////////////////////////////////////////////////////////
 $errorx = 0; $opcionlogin = ""; 
 /*
 if($obj->CodigoSucursal == '00') 
 {
     if(($obj->GetConexionServidor() != 1)&&($errorx==0)){
       $error = $obj->AlertaError("No hay Conexión al Servidor","No hay conexión al Servidor Principal del Aplicativo","AVISO","Aceptar"); $errorx++;
     }  
 } 
*/ 
 if(($obj->GetBloqueoCierre())&&($errorx==0)){
   $error = $obj->AlertaError("Error","Se está realizando el Cierre Definitivo. Por favor intente dentro de 1 minuto","ERROR","Aceptar"); $errorx++;
   $opcionlogin = "disabled";
 }

 if((!$obj->GetNavegadorOk())&&($errorx==0)){
   $error = $obj->AlertaError("Navegador Incorrecto","Esta utilizando un Navegador NO Autorizado","ERROR","Aceptar"); $errorx++;
   $opcionlogin = "disabled";
 }

$cuerpo = '<ul class="cb-slideshow" id="cb-slideshow">
            <li><span>Image 01</span><div></div></li>
            <li><span>Image 02</span><div></div></li>
            <li><span>Image 03</span><div></div></li>
            <li><span>Image 04</span><div></div></li>
            <li><span>Image 05</span><div></div></li>
            <li><span>Image 06</span><div></div></li>
    </ul>
    <section class="header">
      <div class="colorazul">
       <div class="hora"> '.$obj->FechaActual.' </div>
       <div class="sucursal"> Sucursal : '.$obj->NombreSucursal.' </div>
      </div>
    <div class="colorazul2"></div> 
  </section>
  <section class="main">
    <div class="container">
      <div class="logoheader">
        <h1>'.$obj->NombreApp.'</h1>
        <h5>Versi&oacute;n '.$obj->VersionSoft.' </h5>
      </div>    
      <div class="containerform">
        <form action="usuarios.php?opcion=login" method="POST" class="formulario" name="x">
        <input type="hidden" name="browser" value="'.$obj->NavegadorUsado.'">         
        <input type="hidden" name="os" value="'.$obj->SistemaOperatSer.'">         
        <input type="hidden" name="browser" value="'.$obj->NavegadorUsado.'">';       
   
   if(($usuariopredet!="")&&($esloginremoto))     
      $cuerpo.= '<label style="color:red">Acceso remoto exclusivo a usuario</label>';

   $cuerpo.= '<label for="usuario">Nombre de usuario</label>
          <div class="inputicon">
            <span class="fa fa-user"></span>
            <input type="text" name="usuario" id="usuario" class="entrada usuario" value="" placeholder="Ingrese su usuario" '.$opcionlogin.' autocomplete="off">
          </div>
          <div class="inputicon">
            <label for="contrasenia">Contraseña</label>
            <span class="fa fa-keyboard-o "></span>
            <input type="password" name="clave" id="contrasenia" class="entrada" placeholder="Ingrese su contraseña" '.$opcionlogin.' autocomplete="off">          
          </div>';
   
   if($esloginremoto)
   { 
     $cuerpo.='<div class="inputicon">
                <label for="contrasenia">Contraseña Remota</label>
                <span class="fa fa-keyboard-o "></span>
                <input type="password" name="clave2" id="contrasenia2" class="entrada" placeholder="Ingrese su contraseña" '.$opcionlogin.' autocomplete="off">
               </div>';
   }

   $cuerpo.='
          <input type="submit" class="button ingresar" value="Ingresar" '.$opcionlogin.'>
          <a href="#" class="olvidocontrasena">¿Olvido su contraseña?</a>
        </form>
      </div>    
    </div>  
    </section>';

$pie = '<div class="footerWhite">
      <footer class="footer">
        <ul class="entradasfooter">
          <li><a href="" class="footertext">Politicas de Privacidad</a></li>
          <li><a href="" class="footertext">Condiciones de servicio</a></li>
          <li><a href="" class="footertext">Copyright &copy; <script type="text/javascript">
                document.write(new Date().getFullYear());
                </script>, Dromedicas del Oriente SAS.</a></li>
        </ul><br><br>
        Conectado a : <b>'.$obj->GetURLData().'</b>
      </footer>     
    </div> <!-- fin de footerWhite -->  
  </body>
  </html>';

 echo $encabezado.$error.$cuerpo.$pie;

 ///////////////////////////////////////////////////////////////////////////////////
 /// Funcion que crea la Cookie para hacer el registro del Usuario en el PC
 ///////////////////////////////////////////////////////////////////////////////////
 function RegistrarEquipo($id)
 {
     $clase    = new Sistema();
     $username = $clase->SeleccionarUno("SELECT U.username FROM equiposautorizados E INNER JOIN usuarios U ON (E.usuarioasociado = U.usuid) WHERE E.id = ".$id);
     
     echo'<script language="javascript">
               <!--
                  function setCookie(cname, cvalue, exdays) {
                      var d = new Date();
                      d.setTime(d.getTime() + (exdays*24*60*60*1000));
                      var expires = "expires="+ d.toUTCString();
                      document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
                  }

                  setCookie("DROPOS", "'.strtoupper($username).'" , 90);
               -->
             </script>';

     $clase->EjecutarSQL("UPDATE equiposautorizados SET fecactivado = CURRENT_TIMESTAMP WHERE id = ".$id);        
     return;
 }
?>