<?PHP
    /*
     * Clase que gestiona los métodos y llama a las funciones segun el caso
     * @author Ing. Said Rodriguez
     * @version: 31/08/2016
     */
 require_once "WSremisionesDB.php";

 class WebserviceAPI 
 {    
    public function API()
    {
        header('Content-Type: application/JSON');                
        $method = $_SERVER['REQUEST_METHOD'];
        
        switch ($method) {
        
        case 'GET':               // Consulta de Registros - SELECT
            $this->getRemision();
            break;     
        
        case 'POST':              // Adicion de Registros - INSERT
            $this->crearRemision();
            break;                
        
        case 'PUT':               // Actualizacion de Registros - UPDATE
            $this->updateUsuario();
            break;      
        
        case 'DELETE':            // Eliminacion de Registros - DELETE
            $this->borrarUsuario();
            break;
        
        default:                  // POR DEFECTO OTROS NO SOPORTADOS
            echo 'METODO NO SOPORTADO';
            break;
        }
    }
    
    /*
    *  Genera las respuestas con los codigos predeterminados segun el protocolo
    */
    function response($code=200, $status="", $message="") 
    {
      http_response_code($code);
      
      if( !empty($status) && !empty($message) ){
        $response = array("code" => $code , "status" => $status ,"message"=>$message);  
        echo json_encode($response,JSON_PRETTY_PRINT);    
      }            
    }  

    /*
     *  Selecciona 1 o Todos los Usuarios de la Base de Datos
     *  Parametro : Vacio o el usuid del Usuario
     *  Retorno   : Los datos del Usuario solicitado o de Todos los usuarios
     */
    function getRemision()
    {
      if($_GET['action']=='remision')
      {         
         $db = new WebserviceDB();
         if(isset($_GET['id']))
         {
             $response = $db->getDatosRemision($_GET['id']);                
             echo json_encode($response,JSON_PRETTY_PRINT);
             exit();
         }
         else
           $this->response(400);
      }
      return;
    }

    /*
     *  Modifica los datos de un Usuario
     *  Parametros : Username - Clave del Usuario
     *  Retorno    : Estado del response segun lo ejecutado
     */
    function crearRemision()
    {
      $DOCUID = "";
      if($_GET['action']=='remisiones')
      {   
           //Decodifica un string de JSON
           $obj = json_decode( file_get_contents('php://input') );   
           $ob  = (array)$obj;
 
           if(empty($ob))
              $this->response(422,"error","Imposible Adicionar Registro - Datos incorrectos o Invalidos");                           
           else 
           {
              $i=0;
              $WsDB = new WebserviceDB();                     
              
              for($i=0; $i<count($ob); $i++)
              {
                 if($i == 0)
                 { // $ob[$i]->docuid -- Imprime el Docuid - Fila 0
                   // $ob lleva todo el array
                   $DOCUID = $WsDB->crearDocumentoRemision($ob[$i]);                  
                   //$DOCUID = 117920;
                   $WsDB->limpiarDocumentoRemision($DOCUID);                  
                 } 
                 
                 $WsDB->crearDetalleRemision($DOCUID,$ob[$i]);     
              }     

              $this->response(200,"Realizado","Registro creado con Exito");                                  
           }
       
       }
       else               
         $this->response(400);          
      
    } 
 
 }//end class

 /// Expongo el Webservice desde este mismo archivo 
 $WsAPI = new WebserviceAPI();
 $WsAPI->API();

?>