<?PHP
    @session_start(); 
    include("lib/Sistema.php");
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: "infempleadosperiodos"
    // Creación: 01/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana principal de informe donde se solicita el 
    //              periodo a consultar
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "infempleadosperiodos")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT periodoid, descripcion FROM periodosnomina WHERE cerrado = 'CHECKED' ORDER BY periodoid ASC";
    
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/infcomisiones.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Informe datos de empleados por periodos </b> </td>
                  <td width="50" align="center"> <input type="button" class="button" value="<<" OnClick="document.location=\'principal.php\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<form action="?opcion=datemphtml" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Periodo: </td>
                  <td width="120"> '.$clase->CrearComboBuscar("periodoid",$vsqlcomboperiodo,"descripcion","periodoid","","N",$params,400).' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>
                <table width="100%">
                 <tr class="CabezoteTabla">
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: datemphtml
    // Creación: 01/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida a html del informe de datos de empleados 
    //              en un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "datemphtml")
    {
        $periodoid = $_POST['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Pinto la ventana
        $cont = $clase->HeaderBlanco("datos de empleados");
        $cont.='<table width="1300">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> </td>
                  <td width="37"> <img src="images/iconos/infcomisiones.png" width="32" height="32" border="0"> </td>
                  <td width="1000"> <b> Informe de datos de empleados <br> <font color="BLUE">'.$descripcion.'</font> </b> </td>
                  <td width="10" align="center"> 
                   <a href="?opcion=datosempxls&periodoid='.$periodoid.'" title="salida a excel del informe" target="_blank"> 
                    <img src="images/iconos/exportarexcel2.png" border="0"> 
                   </a> 
                  </td>
                  <td width="10" align="center"> &nbsp; </td>
                  <td width="10" align="center">
                   <a href="?opcion=infempleadosperiodos"> <input type="button" value="<<" class="button" title="ventana anterior"> </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        // Títulos
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="1250" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <th width="12"> &nbsp; </th>
                   <th width="80" align="left"> C&oacute;digo </th>
                   <th width="200" align="left"> C&eacute;dula </th>
                   <th width="525" align="left"> Nombre </th>
                   <th width="110" align="left"> Ingreso </th>
                   <th width="64" align="left"> &Aacute;rea </th>
                   <th width="222" align="left"> Secci&oacute;n </th>
                   <th width="252" align="left"> Cargo </th>
                   <th width="192" align="left"> EPS </th>
                   <th width="205" align="left"> AFP </th>
                   <th width="145" align="left"> Banco </th>
                   <th width="185" align="left"> Cuenta </th>
                   <th width="20"> &nbsp; </th>	
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1300px; height:770px; overflow-Y:scroll">';

        // Consulta del informe
        $vsql = "SELECT pt.codvende, pt.nombre, pt.dni, a.descripcionarea, s.descripcionsec, c.descripcioncargo, b.descripcion AS banco,
                        e.descripcioneps, p.descripcionafp, pt.numcuenta, pt.fecingreso, pt.basico, pt.extralegal  
                   FROM periodoterceros pt
                        INNER JOIN areanomina a ON (pt.areaid = a.areaid)
                        INNER JOIN seccion s ON (pt.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (pt.cargoid = c.cargoid)
                        INNER JOIN bancos b ON (pt.bancoid = b.bancoid)
                        INNER JOIN eps e ON (pt.epsid = e.epsid)
                        INNER JOIN pensiones p ON (pt.pensionesid = p.pensionesid)
                  WHERE pt.pernominaid = ".$periodoid." 
               ORDER BY 1";

        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $fecingreso = substr($row['fecingreso'],8,2)."/".substr($row['fecingreso'],5,2)."/".substr($row['fecingreso'],0,4);
            $banco = $row['banco'];
            $banco = str_replace('BANCO ','',$banco);
            $descripcionarea = $row['descripcionarea'];

            if($descripcionarea == "VENTAS")
                $area = "VTS";

            if($descripcionarea == "ADMINISTRACION")
                $area = "ADM";

            if($row['extralegal'] == "CHECKED")
                $area = "EXTL";
                
            $cont.=' <td width="12"> &nbsp; </td>
                     <td width="160" align="left"> '.$row['codvende'].' </td>
                     <td width="150" align="left"> '.$row['dni'].' </td>
                     <td width="680" align="left"> '.$row['nombre'].' </td>
                     <td width="117" align="left"> '.$fecingreso.' </td>
                     <td width="82" align="left"> '.$area.' </td>
                     <td width="212" align="left"> '.$row['descripcionsec'].' </td>
                     <td width="212" align="left"> '.$row['descripcioncargo'].' </td>
                     <td width="142" align="left"> '.$row['descripcioneps'].' </td>
                     <td width="155" align="left"> '.$row['descripcionafp'].' </td>
                     <td width="135" align="left"> '.$banco.' </td>
                     <td width="135" align="left"> '.$row['numcuenta'].' </td>
                     <td width="20"> &nbsp; </td>
                    </tr>';
        }

        $cont.=' </tbody> 
                </table>';

        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="20"> &nbsp; </td>
                  <td width="375" align="left"> <font color="WHITE"> <b> Empleados: </b> '.number_format($i).' </font> </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="616" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: datosempxls
    // Creación: 02/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida a Excel del informe de datos de empleados 
    //              en un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "datosempxls")
    {
        $periodoid = $_GET['periodoid'];
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        
        // Consulta del informe
        $vsql = "SELECT pt.codvende, pt.nombre, pt.dni, a.descripcionarea, s.descripcionsec, c.descripcioncargo, b.descripcion AS banco,
                        e.descripcioneps, p.descripcionafp, pt.numcuenta, pt.fecingreso, pt.basico, pt.extralegal  
                   FROM periodoterceros pt
                        INNER JOIN areanomina a ON (pt.areaid = a.areaid)
                        INNER JOIN seccion s ON (pt.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (pt.cargoid = c.cargoid)
                        INNER JOIN bancos b ON (pt.bancoid = b.bancoid)
                        INNER JOIN eps e ON (pt.epsid = e.epsid)
                        INNER JOIN pensiones p ON (pt.pensionesid = p.pensionesid)
                  WHERE pt.pernominaid = ".$periodoid." 
               ORDER BY 1";

        // Preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");
        
        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("datos empleados - DROPOS")
                                     ->setSubject("datos empleados - DROPOS")
                                     ->setDescription("datos empleados - DROPOS")
                                     ->setKeywords("datos empleados - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'INFORME DE DATOS DE EMPLEADOS')
                    ->setCellValue('A2', $descripcion)
                    ->setCellValue('A3', 'CODIGO')
                    ->setCellValue('B3', 'CEDULA')
                    ->setCellValue('C3', 'NOMBRE')
                    ->setCellValue('D3', 'INGRESO')
                    ->setCellValue('E3', 'AREA')
                    ->setCellValue('F3', 'SECCION')
                    ->setCellValue('G3', 'CARGO')
                    ->setCellValue('H3', 'EPS')
                    ->setCellValue('I3', 'AFP')
                    ->setCellValue('J3', 'BANCO')
                    ->setCellValue('K3', 'CUENTA');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);
        
        $i = 4;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $cant   = @mysql_num_rows($result);
        while($row = @mysql_fetch_array($result))
        {
            $codvende = $row['codvende'];
            if(substr($codvende,0,1) == "0")            $codvende="'".$codvende;
            
            $fecingreso = substr($row['fecingreso'],8,2)."/".substr($row['fecingreso'],5,2)."/".substr($row['fecingreso'],0,4);
            $banco = $row['banco'];
            $banco = str_replace('BANCO ','',$banco);
            $descripcionarea = $row['descripcionarea'];

            if($descripcionarea == "VENTAS")
                $area = "VTS";

            if($descripcionarea == "ADMINISTRACION")
                $area = "ADM";

            if($row['extralegal'] == "CHECKED")
                $area = "EXTL";
                
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $codvende)
                        ->setCellValue('B'.$i, $row['dni'])
                        ->setCellValue('C'.$i, $row['nombre'])
                        ->setCellValue('D'.$i, $fecingreso)
                        ->setCellValue('E'.$i, $area)
                        ->setCellValue('F'.$i, $row['descripcionsec'])
                        ->setCellValue('G'.$i, $row['descripcioncargo'])
                        ->setCellValue('H'.$i, $row['descripcioneps'])
                        ->setCellValue('I'.$i, $row['descripcionafp'])
                        ->setCellValue('J'.$i, $banco)
                        ->setCellValue('K'.$i, $row['numcuenta']);
            $i++;
        }

        $rangoEncabezado = 'A3:K3';
        $rangoCeldas     = 'A3:K'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('datos de empleados');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        $nombrearcexcel = "datos de empleados ".strtolower($descripcion).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaselperne
    // Creación: 02/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana principal de informe donde se solicita el 
    //              periodo de nómina electrónica que se va a consultar
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaselperne")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo 
                                FROM periodos 
                               WHERE codperiodo IN (SELECT periodonomina FROM periododian) 
                            ORDER BY orden";
        $comboperiodos = $clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,300);

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/ventatouch.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> N&oacute;mina electr&oacute;nica por periodos </b> </td>
                  <td width="50" align="center"> <input type="button" class="button" value="<<" OnClick="document.location=\'principal.php\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<form action="?opcion=prereportar&codperiodo='.$codperiodo.'" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Periodo: </td>
                  <td width="120"> '.$comboperiodos.' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>
                <table width="100%">
                 <tr class="CabezoteTabla">
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';        

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: prereportar
    // Creación: 02/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana que indica que se está generando la hoja de 
    //              Excel con la nómina electrónica
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "prereportar")
    {
        $codperiodo  = $_POST['codperiodo'];
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Pinto la vista correspondiente
        $cont = $clase->Header("S","W");
        $cont.='<form name="x" method="POST" action="informesnomina.php?opcion=nomelectxls&codperiodo='.$codperiodo.'">
                <table width="100%">
                 <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/ventatouch.png" width="32" height="32" border="0"> </td>
                  <td width="950"> <b> Por favor espere ... </b> </td>
                 </tr>
                </table>
                <br>
                <center>
                <h3> Generando la hoja de Excel de la n&oacute;mina electr&oacute;nica de <br> <font color="BLUE"> '.$desperiodo.' </font> </h3>
                <br> Por favor no interrumpa el proceso <br><br><br>
                <img src="images/basicas/cargando.gif" border="0">
                <script language="Javascript">
                 function redireccionar() {
                  setTimeout("location.href=\'informesnomina.php?opcion=nomelectxls&codperiodo='.$codperiodo.'\'", 1000);
                 }
                 redireccionar();
                </script>
                <br><br><br>
                <!-- Contador de tiempo -->
                <div style="margin: 0px auto; text-align: center; width: 250px;">
                 <img src="images/basicas/1.gif" border="0">
                 <img src="images/basicas/2.gif" border="0">
                 <img src="images/basicas/3.gif" border="0">
                 <img src="images/basicas/4.gif" border="0">
                 <img src="images/basicas/5.gif" border="0">
                </div>';
        echo $cont.$clase->PiePagina();
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nomelectxls
    // Creación: 02/08/2023		última modificación: 25/10/2023
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la hoja de Excel con la nómina electrónica del  
    //              periodo seleccionado
    // Última modificación: Inclusión de campo cune y lista de los empleados excluidos en  
    //                      el periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nomelectxls")
    {
        // Código del periodo
        $codperiodo  = $_GET['codperiodo'];
        
        $listadereportados = "";
        $nodebensalir = "";

        // Mes y año del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $mesperiodo = substr($desperiodo,0,-5);
        $yeartoday = date("Y");
        
        // validación para el caso del año anterior
        if(intval(substr($codperiodo,-4)) != $yeartoday)
            $yeartoday--;

        // fechas del periodo
        $fecinicio = substr($desperiodo,-4)."-".substr($codperiodo,0,2)."-01";
        $fecfinal = date("Y-m-t", strtotime($fecinicio));

        // Consulta de los periodos de nómina que se van a consultar
        $vsql = "SELECT periodoid 
                   FROM periodosnomina 
                  WHERE descripcion LIKE '%".$mesperiodo."%' AND descripcion LIKE '%".$yeartoday."%'";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $periodosreportar = mysql_num_rows($result);

        // Periodos a procesar
        if($periodosreportar>0)
        {
            while($row = mysql_fetch_array($result))
            {
                $listaperiodos.= $row['periodoid'].",";
                $segundaquinper = $row['periodoid'];
            }
            $listaperiodos = substr($listaperiodos, 0, -1);
        }

        // Determino si existen empleados excluidos en el periodo
        $vsql250 = "SELECT terid 
                      FROM noliquida 
                     WHERE periodonomina = '".$codperiodo."' 
                       AND tipo = 'nominaelec'";

        $conex  = $clase->Conectar();
        $result250 = mysql_query($vsql250,$conex);
        $hayexcluidos = mysql_num_rows($result250);

        if($hayexcluidos > 0)
        {
            while($row250 = mysql_fetch_array($result250))
            {
                $nodebensalir.= $row250['terid'].",";
            }
            $nodebensalir = substr($nodebensalir, 0, -1);
        }        

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Consulta para determinar los empleados procesados en el periodo seleccionado
        $vsql2 = "SELECT DISTINCT terid 
                    FROM hisdetallenomina 
                   WHERE pernominaid IN ($listaperiodos)";

        if(strlen($nodebensalir) > 0)
            $vsql2.= " AND terid NOT IN ($nodebensalir) ";

        $conex  = $clase->Conectar();
        $result2 = mysql_query($vsql2,$conex);
        $empleadosreportar = mysql_num_rows($result2);

        if($empleadosreportar>0)
        {
            require_once 'lib/PHPExcel.php';
            $clase = new Sistema();
            $clase->Conectar();
            ini_set("memory_limit","100M");

            // Inicialización de variables
            $consecutivo = 0;                           $dni = "";                              $primerapellido = "";                           $segundoapellido = "";
            $primernombre = "";                         $segundonombre = "";                    $basico = 0;                                    $codvende = "";
            $email = "";                                $telmovil = "";                         $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                            $banco = "";                            $vsqldias = "";                                 $diastrab = 0;
            $vsqltrasp = "";                            $auxtransp = 0;                         $vsqldev = "";                                  $devengados = 0;
            $vsqldesc = "";                             $descuentos = 0;                        $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                            $salud = 0;                             $por_sal_tra = 0;                               $vsqlpension = "";
            $pension = 0;                               $por_pen_tra = 0;                       $neto = 0;                                      $fecingreso = "";
            $vsqlincapacidad = "";                      $numincap = 0;                          $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                          $fecfinincap = "";                      $vsqlpagoincap = "";                            $pagoincap = 0;
            $fechaAct = date("Y-m-d");                  $horaAct = date("H:i:s");               $newconsecutivo = "";                           $vsqlsanciones = "";
            $numsanciones = 0;                          $prefijo = "";                          $vsqlnumcuenta = "";
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;          $vsqldotaciones = "";                   $montodotacion = 0;                             $vsqlnumpagocesan = "";
            $numpagocesan = 0;                          $montopagocesan = 0;                    $vsqlnumvacaciones2 = "";                       $numvacaciones2 = 0;
            $vsqlpagovaca2 = "";                        $pagovaca2 = 0;                         $cune = "";                                     $vsqlcune = "";

            // Preparación del entorno para la salida a Excel
            $clase = new Sistema();
            $clase->Nombredb = $_SESSION['DBNOMBRE'];
            error_reporting(E_ALL);
            ini_set('display_errors', TRUE);
            ini_set('display_startup_errors', TRUE);
            date_default_timezone_set('Europe/London');
        
            if (PHP_SAPI == 'cli')
                die('This example should only be run from a Web Browser');
        
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
        
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                         ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                         ->setTitle("Planilla de nomina - DROPOS")
                                         ->setSubject("Planilla de nomina - DROPOS")
                                         ->setDescription("Planilla de nomina - DROPOS")
                                         ->setKeywords("Planilla de nomina - DROPOS")
                                         ->setCategory("Categoria General");

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'NOMINA ELECTRÓNICA DEL PERIODO '.$desperiodo)                        
                        ->setCellValue('A3', 'idEmpresa: 1536')
                        ->setCellValue('A4', 'tipoDocumento: 1')
                        ->setCellValue('A5', 'almacenamiento: 1')
                        ->setCellValue('A6', 'Fecha de inicio: '.$fecinicio)
                        ->setCellValue('A7', 'Fecha final: '.$fecfinal)                        
                        ->setCellValue('A9', 'fechaIngreso')
                        ->setCellValue('B9', 'tipoTrabajador')
                        ->setCellValue('C9', 'subTipoTrabajador')
                        ->setCellValue('D9', 'altoRiesgoPension')
                        ->setCellValue('E9', 'tipoDocumento')
                        ->setCellValue('F9', 'numeroDocumento')
                        ->setCellValue('G9', 'primerApellido')
                        ->setCellValue('H9', 'segundoApellido')
                        ->setCellValue('I9', 'primerNombre')
                        ->setCellValue('J9', 'otrosNombres')
                        ->setCellValue('K9', 'sueldo')
                        ->setCellValue('L9', 'codigoTrabajador')
                        ->setCellValue('M9', 'formapago')
                        ->setCellValue('N9', 'metodopago')
                        ->setCellValue('O9', 'banco')
                        ->setCellValue('P9', 'tipoCuenta')
                        ->setCellValue('Q9', 'numeroCuenta')
                        ->setCellValue('R9', 'diasTrabajados')
                        ->setCellValue('S9', 'sueldoTrabajado')
                        ->setCellValue('T9', 'transporte')
                        ->setCellValue('U9', 'incapacidadcantidad')
                        ->setCellValue('V9', 'incapacidadtipo')
                        ->setCellValue('W9', 'incapacidadpago')
                        ->setCellValue('X9', 'licenciadescripcion')
                        ->setCellValue('Y9', 'licenciacantidad')
                        ->setCellValue('Z9', 'licenciapago')
                        ->setCellValue('AA9', 'embargo')
                        ->setCellValue('AB9', 'OtrasDeducciones')
                        ->setCellValue('AC9', 'MontoOtrasDeducciones')
                        ->setCellValue('AD9', 'porcentajesalud')
                        ->setCellValue('AE9', 'deduccionsalud')
                        ->setCellValue('AF9', 'porcentajepension')
                        ->setCellValue('AG9', 'deduccionpension')
                        ->setCellValue('AH9', 'valorSancion')
                        ->setCellValue('AI9', 'tipoSancion')
                        ->setCellValue('AJ9', 'libranzadescripcion')
                        ->setCellValue('AK9', 'libranzadeduccion')
                        ->setCellValue('AL9', 'díasdeprima')
                        ->setCellValue('AM9', 'montoprima')
                        ->setCellValue('AN9', 'pagocesantias')
                        ->setCellValue('AO9', 'porcentajecesantias')
                        ->setCellValue('AP9', 'pagointereses')
                        ->setCellValue('AQ9', 'díasvacaciones')
                        ->setCellValue('AR9', 'montovacaciones') 
                        ->setCellValue('AS9', 'indemnizacion')
                        ->setCellValue('AT9', 'otrosdevengados')
                        ->setCellValue('AU9', 'dotaciones')
                        ->setCellValue('AV9', 'devengadosTotal')
                        ->setCellValue('AW9', 'deduccionesTotal')
                        ->setCellValue('AX9', 'comprobanteTotal')
                        ->setCellValue('AY9', 'cune');

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AF')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AG')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AH')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AI')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AJ')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AK')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AL')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AM')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AN')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AO')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AP')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AQ')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AR')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AS')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AT')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AU')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AV')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AW')->setAutoSize(true);            $objPHPExcel->getActiveSheet()->getColumnDimension('AX')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('AY')->setAutoSize(true);

            // Inmovilizar paneles
            $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,10);

            $i = 10;
            while($row2 = mysql_fetch_array($result2))
            {
                // id del empleado
                $terid = $row2['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal ='CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);
                
                if($numnomext<2)
                {
                    // Días trabajados
                    $vsqldias = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrab 
                                   FROM hisdetallenomina 
                                  WHERE pernominaid IN ($listaperiodos) 
                                        AND terid = ".$terid."
                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                  FROM periodoterceros
                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                       AND pernominaid IN ($listaperiodos)
                                                                       AND extralegal ='CHECKED')";
                    $diastrab = $clase->SeleccionarUno($vsqldias);

                    if(($numnomext==1)&&($diastrab==0))
                    {
                        $laboro = false;

                        $vsqlnuminc = "SELECT COUNT(*) AS numinc
                                         FROM periodoterceros pt 
                                              INNER JOIN hisdetallenomina h ON (pt.terid = h.terid AND pt.pernominaid = h.pernominaid) 
                                        WHERE pt.terid = ".$terid." 
                                              AND pt.extralegal <> 'CHECKED' 
                                              AND (h.conceptoid = 10 AND h.valor = 15)";
                        $numincsolo = $clase->SeleccionarUno($vsqlnuminc);

                        if($numincsolo == 1)
                            $laboro = true;
                    }
                    else
                        $laboro = true;

                    if($laboro)
                    {
                        // ----------------------------------------------------------------------------------------------- //                        
                        $sumar = 0;
                        $numlibranzasliq = 0;
                        $vsqlrep = "SELECT COUNT(*) AS sumar
                                      FROM detalleliquidacion
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos)";
                        $sumar = $clase->SeleccionarUno($vsqlrep);
                        // ----------------------------------------------------------------------------------------------- //

                        // Actualizo los días trabajados
                        if($sumar>0)
                        {
                            $vsqldiasliq = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrabliq 
                                              FROM detalleliquidacion 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND terid = ".$terid."
                                                   AND conceptoid = 1";
                            $diastrabliq = $clase->SeleccionarUno($vsqldiasliq);

                            $diastrab += $diastrabliq;
                        }

                        // Documento del empleado
                        $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                        // Primer apellido
                        $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                        // Segundo apellido
                        $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                        // Primer nombre
                        $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                        // Segundo nombre
                        $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                        // Sueldo básico
                        $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                        // Código del trabajador
                        $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                        // Correo electrónico
                        $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                        // Teléfono
                        $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                        // Número de cuenta
                        $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
                        
                        // Tipo de documento
                        $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                        // Banco
                        $vsqlbanco = "SELECT b.descripcion AS banco
                                        FROM periodoterceros p
                                             INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                       WHERE p.terid = ".$terid;
                        $banco = $clase->SeleccionarUno($vsqlbanco);
                        $banco = trim(str_replace("BANCO ","",$banco));
    
                        // cargo del empleado
                        $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');

                        // sueldo del periodo
                        $vsqlsueldo = "SELECT SUM(IF(conceptoid=1,devengados,0)) AS sueldoper 
                                         FROM hisdetallenomina 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid=".$terid."
                                              AND pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND pernominaid IN ($listaperiodos)
                                                                             AND extralegal ='CHECKED')";
                        $sueldoper = $clase->SeleccionarUno($vsqlsueldo);

                        if($sumar>0)
                        {
                            $vsqlsueldoliq = "SELECT devengados AS sueldoliq
                                                FROM detalleliquidacion
                                               WHERE terid=".$terid."
                                                     AND conceptoid = 1
                                                     AND pernominaid IN ($listaperiodos)";
                            $sueldoliq = $clase->SeleccionarUno($vsqlsueldoliq);

                            $sueldoper += $sueldoliq;
                        }

                        // Auxilio de transporte
                        $vsqltrasp = "SELECT SUM(IF(conceptoid=3,devengados,0)) AS auxtransp 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros 
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal ='CHECKED')";
                        $auxtransp = $clase->SeleccionarUno($vsqltrasp);

                        if($sumar>0)
                        {
                            $vsqltransliq = "SELECT devengados AS transliq
                                               FROM detalleliquidacion
                                              WHERE terid = ".$terid."
                                                    AND conceptoid = 3
                                                    AND pernominaid IN ($listaperiodos)";
                            $transliq = $clase->SeleccionarUno($vsqltransliq);

                            $auxtransp += $transliq;
                        }

                        // Embargo
                        $vsqlembg = "SELECT SUM(IF(conceptoid=30,descuentos,0)) AS embargo 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND pernominaid IN ($listaperiodos)
                                                                           AND extralegal ='CHECKED')";
                        $embargo = $clase->SeleccionarUno($vsqlembg);

                        if($sumar>0)
                        {
                            $vsqlembliq = "SELECT descuentos AS embliq
                                             FROM detalleliquidacion
                                            WHERE terid = ".$terid."
                                                  AND conceptoid = 30
                                                  AND pernominaid IN ($listaperiodos)";
                            $embliq = $clase->SeleccionarUno($vsqlembliq);

                            $embargo += $embliq;
                        }

                        // Salud
                        $vsqlsalud = "SELECT SUM(IF(conceptoid=5,descuentos,0)) AS salud 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal ='CHECKED')";
                        $salud = $clase->SeleccionarUno($vsqlsalud);

                        if($sumar>0)
                        {
                            $vsqlsaludliq = "SELECT descuentos AS saludliq
                                               FROM detalleliquidacion
                                              WHERE terid = ".$terid."
                                                    AND conceptoid = 5
                                                    AND pernominaid IN ($listaperiodos)";
                            $saludliq = $clase->SeleccionarUno($vsqlsaludliq);

                            $salud += $saludliq;
                        }

                        // Pensión
                        $vsqlpension = "SELECT SUM(IF(conceptoid=4,descuentos,0)) AS pension 
                                          FROM hisdetallenomina 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal ='CHECKED')";
                        $pension = $clase->SeleccionarUno($vsqlpension);

                        if($sumar>0)
                        {
                            $vsqlpesionliq = "SELECT descuentos AS pesionliq
                                                FROM detalleliquidacion
                                               WHERE terid = ".$terid."
                                                     AND conceptoid = 4
                                                     AND pernominaid IN ($listaperiodos)";
                            $pesionliq = $clase->SeleccionarUno($vsqlpesionliq);

                            $pension += $pesionliq;
                        }

                        // total devengado
                        $vsqldev = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                      FROM hisdetallenomina 
                                     WHERE terid = ".$terid."
                                           AND pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND pernominaid IN ($listaperiodos)
                                                                          AND extralegal ='CHECKED')";
                        $devengados = $clase->SeleccionarUno($vsqldev);

                        if($sumar>0)
                        {
                            $vsqldevliq = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                             FROM detalleliquidacion 
                                            WHERE terid = ".$terid."";
                            $devengadosliq = $clase->SeleccionarUno($vsqldevliq);

                            $devengados += $devengadosliq;
                        }
                        
                        // total descuentos
                        $vsqldesc = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid = ".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND pernominaid IN ($listaperiodos)
                                                                           AND extralegal ='CHECKED')";
                        $descuentos = $clase->SeleccionarUno($vsqldesc);

                        if($sumar>0)
                        {
                            $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                              FROM detalleliquidacion 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND terid = ".$terid."";
                            $descuentosliq = $clase->SeleccionarUno($vsqldescliq);

                            $descuentos += $descuentosliq;
                        }

                        $neto = $devengados - $descuentos;

                        // Obtengo la fecha de ingreso del empleado
                        $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');

                        // Incapacidades del periodo
                        $vsqlincapacidad = "SELECT COUNT(*) AS numincap 
                                              FROM hisdetallenomina 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND conceptoid IN (10,40,43)
                                                   AND terid = ".$terid."
                                                   AND pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal ='CHECKED')";
                        $numincap = $clase->SeleccionarUno($vsqlincapacidad);

                        if($numincap>0)
                        {
                            // Cantidad de la incapacidad                            
                            $vsqlcantincap = "SELECT SUM(valor) AS diasincap 
                                                FROM hisdetallenomina 
                                               WHERE pernominaid IN ($listaperiodos) 
                                                     AND conceptoid IN (10,40,43)
                                                     AND terid = ".$terid."
                                                     AND pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND pernominaid IN ($listaperiodos)
                                                                                    AND extralegal ='CHECKED')";
                            $diasincap = $clase->SeleccionarUno($vsqlcantincap);

                            $vsqlcantincap2 = "SELECT IFNULL(SUM(valor),0) AS diasincap 
                                                 FROM detalleliquidacion 
                                                WHERE pernominaid IN ($listaperiodos) 
                                                      AND terid = ".$terid."
                                                      AND conceptoid IN (10,40,43)";
                            $diasincap2 = $clase->SeleccionarUno($vsqlcantincap2);

                            $diasincap += $diasincap2;                            
    
                            // Fecha de inicio
                            $feciniincap = $fecinicio;
    
                            // Fecha final
                            $fecfinincap = date("Y-m-d",strtotime($feciniincap."+ $diasincap days"));
                        }

                        // Licencias del periodo
                        $vsqlincapacidad = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                              FROM hisdetallenomina h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND c.eslicencia = 'CHECKED' 
                                                   AND c.tipodc = 'C' 
                                                   AND h.conceptoid NOT IN (10,9,43,58)                                          
                                                   AND h.terid = ".$terid."
                                                   AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND pernominaid IN ($listaperiodos)
                                                                                    AND extralegal ='CHECKED')";
                        $numlicencias = $clase->SeleccionarUno($vsqlincapacidad);

                        // --------------------------------------------------------------------------------------------------- //
                        // inclusión de las licencas no remuneradas en este renglón solo para la salida a excel
                        $vsqllicnoremuneradas = "SELECT COUNT(conceptoid) AS licnoremuneradas 
                                                   FROM hisdetallenomina 
                                                  WHERE pernominaid IN ($listaperiodos)
                                                        AND conceptoid = 6
                                                        AND terid = ".$terid."
                                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND pernominaid IN ($listaperiodos)
                                                                                       AND extralegal ='CHECKED')";
                        $licnoremuneradas = $clase->SeleccionarUno($vsqllicnoremuneradas);
                        $numlicencias += $licnoremuneradas;
                        // --------------------------------------------------------------------------------------------------- //

                        $vsqlincapacidad2 = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                               FROM detalleliquidacion h
                                                    INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                              WHERE h.pernominaid IN ($listaperiodos)
                                                    AND c.eslicencia = 'CHECKED' 
                                                    AND c.tipodc = 'C' 
                                                    AND h.conceptoid NOT IN (10,9,43,58) 
                                                    AND h.terid = ".$terid;
                        $numlicencias2 = $clase->SeleccionarUno($vsqlincapacidad2);

                        // --------------------------------------------------------------------------------------------------- //
                        // inclusión de las licencas no remuneradas en este renglón solo para la salida a excel
                        $vsqllicnoremuneradas2 = "SELECT COUNT(conceptoid) AS licnoremuneradas2 
                                                    FROM detalleliquidacion 
                                                   WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid."
                                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                                   FROM periodoterceros
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND pernominaid IN ($listaperiodos)
                                                                                        AND extralegal ='CHECKED')";
                        $licnoremuneradas2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);
                        $numlicencias2 += $licnoremuneradas2;
                        // --------------------------------------------------------------------------------------------------- //

                        $numlicencias += $numlicencias2;                        

                        // Libranzas del periodo
                        $vsqllibranzas = "SELECT COUNT(h.conceptoid) AS numlibranzas 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                                                 AND h.terid = ".$terid."
                                                 AND c.conceptoid NOT IN (10,30)
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal ='CHECKED')";
                        $numlibranzas = $clase->SeleccionarUno($vsqllibranzas);

                        if($sumar>0)
                        {
                            $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                                   FROM detalleliquidacion h
                                                        INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                                  WHERE h.pernominaid IN ($listaperiodos)
                                                        AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                                                        AND h.terid = ".$terid."
                                                        AND c.conceptoid NOT IN (10,30)";
                            $numlibranzasliq = $clase->SeleccionarUno($vsqllibranzasliq);
                        }

                        // Sanciones del periodo
                        $vsqlsanciones = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid = 9
                                                 AND h.terid = ".$terid."
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND pernominaid IN ($listaperiodos)
                                                                                  AND extralegal ='CHECKED')";
                        $numsanciones = $clase->SeleccionarUno($vsqlsanciones);

                        // Otras deducciones
                        // Estas incluyen: CAMISETAS, PLAN TELEFONIA MOVIL, PRESTAMOS PERSONALES, AJUSTE SALARIO SENA, 
                        // CREDITOS OTROS NEGOCIOS, DESCUENTO SP, MANGAS, CAFETERIA, COMPRAS A CREDITO, OTROS
                        $vsqlotrasdeduc = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                  AND h.terid = ".$terid."
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND pernominaid IN ($listaperiodos)
                                                                                   AND extralegal = 'CHECKED')";
                        $numotrasded = $clase->SeleccionarUno($vsqlotrasdeduc);

                        if($sumar>0)
                        {
                            $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                                    FROM detalleliquidacion h
                                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                                   WHERE h.pernominaid IN ($listaperiodos)
                                                         AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                         AND h.terid = ".$terid."";
                            $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);
                        }

                        // Vacaciones
                        $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'vacaciones'";
                        $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                        // Vacaciones pagadas en quincenas
                        $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2 
                                                 FROM hisdetallenomina 
                                                WHERE terid = ".$terid."
                                                      AND conceptoid = 38 
                                                      AND pernominaid IN ($listaperiodos)";
                        $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                        $numvacacionest = $numvacaciones1 + $numvacaciones2;

                        // Primas
                        $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $numprimas = $clase->SeleccionarUno($vsqlnumprimas);

                        // Cesantías
                        $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);

                        // Indemnización
                        $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Otros conceptos devengados
                        $vsqlotrosdeven = "SELECT COUNT(h.conceptoid) AS numotrosdeven
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid = 37
                                                  AND h.terid = ".$terid."
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND pernominaid IN ($listaperiodos)
                                                                                   AND extralegal = 'CHECKED')";
                        $numotrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);

                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Dotaciones 
                        $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                             FROM dotaciones
                                            WHERE periodonomina = '".$codperiodo."'
                                                  AND terid = ".$terid."";
                        $montodotacion = $clase->SeleccionarUno($vsqldotaciones);
                        
                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Escribo en la hoja de Excel
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$i, $fecingreso)
                                    ->setCellValue('B'.$i, '01')
                                    ->setCellValue('C'.$i, '00')
                                    ->setCellValue('D'.$i, 'true')
                                    ->setCellValue('E'.$i,'13')
                                    ->setCellValue('F'.$i, $dni)
                                    ->setCellValue('G'.$i, $primerapellido)
                                    ->setCellValue('H'.$i, $segundoapellido)
                                    ->setCellValue('I'.$i, $primernombre)
                                    ->setCellValue('J'.$i, $segundonombre)
                                    ->setCellValue('K'.$i, number_format($basico))
                                    ->setCellValue('L'.$i, $codvende)
                                    ->setCellValue('M'.$i, '1');

                        // Identifico la forma de pago
                        if($numcuenta!="")
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('N'.$i, '45')
                                        ->setCellValue('O'.$i, $banco)
                                        ->setCellValue('P'.$i, 'AHORROS')
                                        ->setCellValue('Q'.$i, $numcuenta);
                        }
                        else
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('N'.$i, '10')
                                        ->setCellValue('O'.$i, 'NINGUNO')
                                        ->setCellValue('P'.$i, 'NINGUNO')
                                        ->setCellValue('Q'.$i, 'NINGUNA');
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('R'.$i, $diastrab)
                                    ->setCellValue('S'.$i, number_format($sueldoper))
                                    ->setCellValue('T'.$i, number_format($auxtransp));

                        // Incluyo las incapacidades
                        if($numincap>0)
                        {
                            // Días de la(s) incapacidad(es)
                            $vsql5 = "SELECT SUM(valor) AS valor
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND conceptoid IN (10,40,43)
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal = 'CHECKED')";
                            $valorinc = $clase->SeleccionarUno($vsql5);

                            $vsql52 = "SELECT IFNULL(SUM(valor),0) AS valor
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid = ".$terid."
                                              AND conceptoid IN (10,40,43)";
                            $valorinc2 = $clase->SeleccionarUno($vsql52);

                            $valorinc += $valorinc2;                            

                            // Monto de la(s) incapacidad(es)
                            $vsql6 = "SELECT SUM(devengados) AS devengados 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND conceptoid IN (10,40) 
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal = 'CHECKED')";
                            $devengadosinc = $clase->SeleccionarUno($vsql6);

                            $vsql62 = "SELECT IFNULL(SUM(devengados),0) AS devengados 
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid = ".$terid."
                                              AND conceptoid IN (10,40)";
                            $devengadosinc2 = $clase->SeleccionarUno($vsql62);

                            $devengadosinc += $devengadosinc2;

                            // --------------------------------------------------------------------------------------- //
                            $vsql105 = "SELECT c.nomconcepto AS nombreincapacidad
                                          FROM hisdetallenomina h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos) 
                                               AND c.conceptoid IN (10,40,43)
                                               AND h.terid = ".$terid."
                                               AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                           FROM periodoterceros
                                                                          WHERE periodoterceros.terid = ".$terid." 
                                                                                AND pernominaid IN ($listaperiodos)
                                                                                AND extralegal ='CHECKED')
                                        UNION 
                                        SELECT c.nomconcepto AS nombreincapacidad
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos) 
                                               AND c.conceptoid IN (10,40,43)
                                               AND h.terid = ".$terid."";
                            $conex  = $clase->Conectar();
                            $result105 = mysql_query($vsql105,$conex);

                            $nombreincapacidad = "";
                            while($row105 = mysql_fetch_array($result105))
                            {
                                $nombreincapacidad.= $row105['nombreincapacidad'].", ";
                            }
                            $nombreincapacidad = substr($nombreincapacidad, 0, -2);
                            // --------------------------------------------------------------------------------------- //

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('U'.$i, $valorinc)
                                        ->setCellValue('V'.$i, '3')
                                        ->setCellValue('W'.$i, number_format($devengadosinc));
                        }
                        else
                        {
                            $valorinc = 0;
                            $devengadosinc = 0;
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('U'.$i, $valorinc)
                                        ->setCellValue('V'.$i, 'NINGUNA')
                                        ->setCellValue('W'.$i, number_format($devengadosinc));
                        }

                        // Incluyo las licencias
                        if($numlicencias>0)
                        {
                            // Días de la(s) licencia(s)
                            $vsql3 = "SELECT SUM(h.valor) AS valorlic
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND c.eslicencia ='CHECKED' 
                                             AND c.tipodc = 'C' 
                                             AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $valorlic = $clase->SeleccionarUno($vsql3);

                            // -------------------------------------------------------------------------------------------------- //
                            $vsqllicnoremuneradas = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem
                                                       FROM hisdetallenomina 
                                                      WHERE pernominaid IN ($listaperiodos)
                                                        AND conceptoid = 6
                                                        AND terid = ".$terid."
                                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND pernominaid IN ($listaperiodos)
                                                                                       AND extralegal ='CHECKED')";
                            $valorlicnorem = $clase->SeleccionarUno($vsqllicnoremuneradas);

                            $valorlic += $valorlicnorem;
                            // -------------------------------------------------------------------------------------------------- //

                            $vsql32 = "SELECT SUM(h.valor) AS valorlic
                                        FROM detalleliquidacion h 
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                            AND c.eslicencia = 'CHECKED' 
                                            AND c.tipodc = 'C' 
                                            AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                            AND h.terid = ".$terid;
                            $valorlic2 = $clase->SeleccionarUno($vsql32);

                            if($valorlic2==NULL)
                                $valorlic2 = 0;

                            // -------------------------------------------------------------------------------------------------- //
                            $vsqllicnoremuneradas2 = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem2
                                                        FROM detalleliquidacion 
                                                       WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid."
                                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                                   FROM periodoterceros
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND pernominaid IN ($listaperiodos)
                                                                                        AND extralegal ='CHECKED')";
                            $valorlicnorem2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                            $valorlic2 += $valorlicnorem2;
                            // -------------------------------------------------------------------------------------------------- //

                            $valorlic += $valorlic2;                            

                            // Monto de la(s) licencia(s)
                            $vsql4 = "SELECT SUM(h.devengados) AS devengadoslic
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND c.eslicencia ='CHECKED' 
                                             AND c.tipodc = 'C' 
                                             AND h.conceptoid NOT IN (10,9,43,40,58)                                        
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $devengadoslic = $clase->SeleccionarUno($vsql4);

                            $vsql42 = "SELECT IFNULL(SUM(h.devengados),0) AS devengadoslic
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia ='CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,58)                                          
                                              AND h.terid = ".$terid;
                            $devengadoslic2 = $clase->SeleccionarUno($vsql42);

                            $devengadoslic += $devengadoslic2;                            

                            // Construyo la descripción de todas las licencias en el periodo
                            $vsql10 = "SELECT c.nomconcepto AS nombrelicencia
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia = 'CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58) 
                                              AND h.terid = ".$terid."
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal ='CHECKED')
                                       UNION 
                                       SELECT c.nomconcepto AS nombrelicencia
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia = 'CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58) 
                                              AND h.terid = ".$terid."
                                       UNION
                                       SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia
                                         FROM hisdetallenomina h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid = 6
                                              AND h.terid = ".$terid."
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal ='CHECKED')
                                        UNION
                                        SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia
                                          FROM detalleliquidacion h 
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND h.conceptoid = 6
                                               AND h.terid = ".$terid."
                                               AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                           FROM periodoterceros
                                                                          WHERE periodoterceros.terid = ".$terid." 
                                                                                AND pernominaid IN ($listaperiodos)
                                                                                AND extralegal ='CHECKED')";
                            $conex  = $clase->Conectar();
                            $result10 = mysql_query($vsql10,$conex);

                            $nombrelicencia = "";
                            while($row10 = mysql_fetch_array($result10))
                            {
                                if($row10['nombrelicencia'] != "")
                                {
                                    if($row10['nombrelicencia'] != NULL)
                                        $nombrelicencia.= $row10['nombrelicencia'].", ";
                                }
                            }
                            $nombrelicencia = substr($nombrelicencia, 0, -2);

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('X'.$i, $nombrelicencia)
                                        ->setCellValue('Y'.$i, $valorlic)
                                        ->setCellValue('Z'.$i, number_format($devengadoslic));
                        }
                        else
                        {
                            $valorlic = 0;
                            $devengadoslic = 0;
                            $nombrelicencia = "NINGUNA";

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('X'.$i, $nombrelicencia)
                                        ->setCellValue('Y'.$i, $valorlic)
                                        ->setCellValue('Z'.$i, number_format($devengadoslic));
                        }

                        // Embargo
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AA'.$i, number_format($embargo));

                        // Otras deducciones
                        if($numotrasded>0)
                        {
                            // Monto de las otras deducciones
                            $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                              FROM hisdetallenomina h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                   AND h.terid = ".$terid."
                                                   AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND pernominaid IN ($listaperiodos)
                                                                                    AND extralegal = 'CHECKED')";
                            $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);

                            // Descripción de las deducciones
                            $vsql11 = "SELECT c.nomconcepto, h.descuentos
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                              AND h.terid = ".$terid."
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE periodoterceros.terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result11 = mysql_query($vsql11,$conex);

                            $nombreoc = "";
                            while($row11 = mysql_fetch_array($result11))
                            {
                                $nombreoc.= $row11['nomconcepto']." (".number_format($row11['descuentos'])."), ";
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
                        }
                        else
                        {
                            $nombreoc = "NINGUNO";
                            $montootrasdeduc = 0;
                        }

                        // ------------------------------------------------------------------------------------------------------------------------ //
                        // Otras deducciones en la tabla de liquidaciones
                        $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                     FROM detalleliquidacion h
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                          AND h.terid = ".$terid."";
                        $conex  = $clase->Conectar();
                        $result77 = mysql_query($vsql77,$conex);
                        $tienedesliq = mysql_num_rows($result77);

                        if($tienedesliq>0)
                        {
                            if($nombreoc=="NINGUNO")
                                $nombreoc = "";
                            else
                                $nombreoc.=", ";

                            while($row77 = mysql_fetch_array($result77))
                            {
                                $nombreoc.= $row77['nomconcepto']." (".number_format($row77['descuentos'])."), ";
                                $montootrasdeduc += $row77['descuentos'];
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AB'.$i, $nombreoc)
                                    ->setCellValue('AC'.$i, number_format($montootrasdeduc));
                        // ------------------------------------------------------------------------------------------------------------------------ //

                        // Continuamos con salud y pensión
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AD'.$i, $por_sal_tra)
                                    ->setCellValue('AE'.$i, number_format($salud))
                                    ->setCellValue('AF'.$i, $por_pen_tra)
                                    ->setCellValue('AG'.$i, number_format($pension));

                        // Incluyo las sanciones
                        if($numsanciones>0)
                        {
                            // Valor de la sanción
                            $vsql6 = "SELECT SUM(h.descuentos) AS montosancion
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid = 9
                                             AND h.terid = ".$terid;
                            $montosancion = $clase->SeleccionarUno($vsql6);

                            // Monto de la sanción
                            $vsql7 = "SELECT c.nomconcepto
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid = 9
                                             AND h.terid = ".$terid;
                            $conceptosancion = $clase->SeleccionarUno($vsql7);

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AH'.$i, number_format($montosancion))
                                        ->setCellValue('AI'.$i, $conceptosancion);
                        }
                        else
                        {
                            $montosancion = 0;
                            $conceptosancion = "NINGUNA";

                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AH'.$i, number_format($montosancion))
                                        ->setCellValue('AI'.$i, $conceptosancion);
                        }

                        // Incluyo las libranzas
                        if($numlibranzas>0)
                        {
                            $vsql8 = "SELECT SUM(h.descuentos) AS montolibranza
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza ='CHECKED' OR c.montopermanente = 'CHECKED') 
                                             AND h.terid = ".$terid."
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $montolibranza = $clase->SeleccionarUno($vsql8);

                            $vsql9 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED') 
                                             AND h.terid = ".$terid."
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal ='CHECKED')";
                            $conex  = $clase->Conectar();
                            $result9 = mysql_query($vsql9,$conex);
                            $nombrelibranza = "";
                            while($row9 = mysql_fetch_array($result9))
                            {
                                $nombrelibranza.= $row9['nomconcepto']." (".number_format($row9['descuentos'])."), ";
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
                        }
                        else
                        {
                            $montolibranza = 0;
                            $nombrelibranza = "NINGUNA";
                        }

                        // libranzas en liquidación
                        $vsql888 = "SELECT c.nomconcepto, h.descuentos  
                                      FROM detalleliquidacion h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid IN ($listaperiodos)
                                           AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                                           AND h.terid = ".$terid."
                                           AND c.conceptoid NOT IN (10,30)";
                        $conex  = $clase->Conectar();
                        $result88 = mysql_query($vsql888,$conex);
                        $tienelibliq = mysql_num_rows($result88);

                        if($tienelibliq>0)
                        {
                            if($nombrelibranza=="NINGUNA")
                                $nombrelibranza = "";
                            else
                                $nombrelibranza.=", ";

                            while($row88 = mysql_fetch_array($result88))
                            {
                                $nombrelibranza.= $row88['nomconcepto']." (".number_format($row88['descuentos'])."), ";
                                $montolibranza += $row88['descuentos'];
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AJ'.$i, $nombrelibranza)
                                    ->setCellValue('AK'.$i, number_format($montolibranza));

                        // Aquí obtengo los valores de la liquidación

                        // Primas
                        $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $numprimas = $clase->SeleccionarUno($vsqlnumprimas);

                        if($numprimas>0)
                        {
                            // Días de la prima
                            $vsqlcanprimas = "SELECT cantidad AS canprimas
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'primas'";
                            $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                            // Pago de la prima
                            $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                                 FROM liquidacion
                                                WHERE terid = ".$terid."
                                                      AND periodonomina = '".$codperiodo."' 
                                                      AND tipo = 'primas'";
                            $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);

                            $devengados += $pagoprimas;
                        }
                        else
                        {
                            $canprimas = 0;
                            $pagoprimas = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AL'.$i, number_format($canprimas))
                                    ->setCellValue('AM'.$i, number_format($pagoprimas));

                        // Cesantías
                        $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);

                        if($numcesantias>0)
                        {
                            // Pago de la cesantía
                            $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);

                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia += $montopagocesan;
                            }

                            // Porcentaje cesantía
                            $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);

                            // Pago de intereses de cesantías
                            $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'cesantias'";
                            $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);

                            $devengados += $pagocesantia;
                            $devengados += $pagointereses;
                        }
                        else
                        {
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);

                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia = $montopagocesan;
                                $devengados += $pagocesantia;
                            }
                            else
                                $pagocesantia = 0;
                            
                            $porccesantia = 0;
                            $pagointereses = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AN'.$i, number_format($pagocesantia))
                                    ->setCellValue('AO'.$i, number_format($porccesantia))
                                    ->setCellValue('AP'.$i, number_format($pagointereses));
                            
                        if($numvacacionest>0)
                        {
                            if($numvacaciones1 > 0)
                            {
                                // Días de vacaciones
                                $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                        FROM liquidacion
                                                       WHERE terid = ".$terid."
                                                             AND periodonomina = '".$codperiodo."' 
                                                             AND tipo = 'vacaciones'";
                                $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                                // Pago de vacaciones
                                $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'vacaciones'";
                                $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                            }
                            else
                            {
                                $canvacaciones = 0;
                                $pagovaca1 = 0;
                            }

                            if($numvacaciones2>0)
                            {
                                $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                    FROM hisdetallenomina  
                                                   WHERE terid = ".$terid."
                                                         AND conceptoid = 38 
                                                         AND pernominaid IN ($listaperiodos)";
                                $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                            }
                            else
                                $pagovaca2 = 0;
                            
                            if($canvacaciones == 0)               $canvacaciones = 1;
                            $pagovaca = $pagovaca1 + $pagovaca2;

                            $devengados += $pagovaca1;
                        }
                        else
                        {
                            $canvacaciones = 0;
                            $pagovaca = 0;
                        }

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AQ'.$i, number_format($canvacaciones,2))
                                    ->setCellValue('AR'.$i, number_format($pagovaca));

                        // indemnización
                        if($numindemnizacion>0)
                        {
                            $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                                    FROM liquidacion
                                                   WHERE terid=".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'indemnizacion'";
                            $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);

                            $devengados += $indemnizacion;
                        }
                        else
                            $indemnizacion = 0;

                        $objPHPExcel->setActiveSheetIndex(0)                                    
                                    ->setCellValue('AS'.$i, number_format($indemnizacion));

                        // otros devengados
                        if($numotrosdeven>0)
                        {
                            $vsqlotrosdeven = "SELECT SUM(IF(h.conceptoid = 37,h.devengados,0)) AS otrosdeven
                                                 FROM hisdetallenomina h
                                                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                                WHERE h.pernominaid IN ($listaperiodos)                                                      
                                                      AND h.terid = ".$terid."
                                                      AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND pernominaid IN ($listaperiodos)
                                                                                       AND extralegal = 'CHECKED')";
                            $otrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
                        }
                        else
                            $otrosdeven = 0;

                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AT'.$i, number_format($otrosdeven));

                        // dotaciones
                        if(strlen($montodotacion)>0)
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AU'.$i, number_format($montodotacion));
                            $devengados += $montodotacion;
                        }
                        else
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AU'.$i, 0);

                        $neto = $devengados - $descuentos;

                        // cune del empleado
                        $vsqlcune = "SELECT d.cune AS cune
                                       FROM dianterceros d 
                                            INNER JOIN periododian p ON (d.periodonomina = p.periododiamid)
                                      WHERE p.periodonomina = '".$codperiodo."'
                                            AND d.terid = ".$terid;
                        $cune = $clase->SeleccionarUno($vsqlcune);

                        // Totales
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AV'.$i, number_format($devengados))
                                    ->setCellValue('AW'.$i, number_format($descuentos))
                                    ->setCellValue('AX'.$i, number_format($neto))
                                    ->setCellValue('AY'.$i, $cune);

                        // Incremento el contador de líneas
                        $i++;
                        $listadereportados.= $terid.",";
                    }
                }
            }
            $listadereportados = substr($listadereportados, 0, -1);

            $rangoEncabezado = 'A9:AK9';
            $rangoCeldas     = 'A9:AK'.($i-1);
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Ciclo para procesar a los empleados liquidados que trabajaron una quincena

        $primquin = substr($listaperiodos,0,2);
        $segnquin = substr($listaperiodos,-2);

        $vsqlliq ="SELECT DISTINCT terid 
                     FROM detalleliquidacion 
                    WHERE pernominaid IN ($listaperiodos)
                          AND terid NOT IN (SELECT terid
                                              FROM hisdetallenomina
                                             WHERE pernominaid IN ($listaperiodos))";
        if(strlen($listadereportados)>0)
            $vsqlliq.= " AND terid NOT IN ($listadereportados)";

        if(strlen($nodebensalir) > 0)
            $vsqlliq.= " AND terid NOT IN ($nodebensalir) ";

        $vsqlliq.= "UNION
                    SELECT p.terid
                      FROM periodoterceros p
                     WHERE p.extralegal = 'CHECKED'
                           AND p.pernominaid IN ($listaperiodos)
                           AND p.terid IN (SELECT terid
                                             FROM detalleliquidacion
                                            WHERE terid = p.terid
                                                  AND pernominaid IN ($listaperiodos))";
        // ---------------------------------------------------------------------------------- //

        if(strlen($listadereportados)>0)
            $vsqlliq.= " AND p.terid NOT IN ($listadereportados)";

        if(strlen($nodebensalir) > 0)
            $vsqlliq.= " AND p.terid NOT IN ($nodebensalir) ";            

        $conex  = $clase->Conectar();
        $resultliq = mysql_query($vsqlliq,$conex);
        $empleadosreportarliq = mysql_num_rows($resultliq);

        // $empleadosreportarliq = 0;      $j = 2;
        $j = $i;

        if($empleadosreportarliq>0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";                            $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $numlicencias = 0;                              $listadereportados.= ",";
            $vsqlvextralegal = "";                          $numnomext = 0;                                 $vsqlnumvacaciones2 = "";
            $numvacaciones2 = 0;                            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;
            $cune = "";                                     $vsqlcune = "";                                 $celda51="";

            while($rowliq = mysql_fetch_array($resultliq))
            {
                // id del empleado
                $terid = $rowliq['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal ='CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);
                
                if($numnomext<2)
                {
                    // días trabajados
                    $vsqldiasliq = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrabliq 
                                      FROM detalleliquidacion 
                                     WHERE pernominaid IN ($listaperiodos) 
                                           AND terid = ".$terid."";
                    $diastrabliq = $clase->SeleccionarUno($vsqldiasliq);
    
                    // Documento del empleado
                    $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                    // Primer apellido
                    $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                    // Segundo apellido
                    $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                    // Primer nombre
                    $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                    // Segundo nombre
                    $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                    // Sueldo básico
                    $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                    // Código del trabajador
                    $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                    // Correo electrónico
                    $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                    // Teléfono
                    $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                    // Número de cuenta
                    $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
    
                    // Tipo de documento
                    $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                    // Banco
                    $vsqlbanco = "SELECT b.descripcion AS banco
                                    FROM periodoterceros p
                                         INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                   WHERE p.terid = ".$terid;
                    $banco = $clase->SeleccionarUno($vsqlbanco);
                    $banco = trim(str_replace("BANCO ","",$banco));
    
                    // cargo del empleado
                    $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
    
                    $vsqlsueldoliq = "SELECT IFNULL(devengados,0) AS sueldoliq
                                        FROM detalleliquidacion
                                       WHERE terid = ".$terid."
                                             AND conceptoid = 1
                                             AND pernominaid IN ($listaperiodos)";
                    $sueldoliq = $clase->SeleccionarUno($vsqlsueldoliq);
                    if($sueldoliq=="")          $sueldoliq = 0;
    
                    // auxilio de transporte
                    $vsqltransliq = "SELECT IFNULL(devengados,0) AS transliq
                                       FROM detalleliquidacion
                                      WHERE terid = ".$terid."
                                            AND conceptoid = 3
                                            AND pernominaid IN ($listaperiodos)";
                    $transliq = $clase->SeleccionarUno($vsqltransliq);
                    if($transliq=="")  $transliq = 0;
    
                    // embargo
                    $vsqlembliq = "SELECT descuentos AS embliq
                                     FROM detalleliquidacion
                                    WHERE terid = ".$terid."
                                          AND conceptoid = 30
                                          AND pernominaid IN ($listaperiodos)";
                    $embliq = $clase->SeleccionarUno($vsqlembliq);
    
                    // salud
                    $vsqlsaludliq = "SELECT IFNULL(descuentos,0) AS saludliq
                                       FROM detalleliquidacion
                                      WHERE terid = ".$terid."
                                            AND conceptoid = 5
                                            AND pernominaid IN ($listaperiodos)";
                    $saludliq = $clase->SeleccionarUno($vsqlsaludliq);
                    if($saludliq=="")  $saludliq = 0;
    
                    // pensión
                    $vsqlpesionliq = "SELECT IFNULL(descuentos,0) AS pesionliq
                                        FROM detalleliquidacion
                                       WHERE terid = ".$terid."
                                             AND conceptoid = 4
                                             AND pernominaid IN ($listaperiodos)";
                    $pesionliq = $clase->SeleccionarUno($vsqlpesionliq);
                    if($pesionliq=="")  $pesionliq = 0;
    
                    // total devengado
                    $vsqldevliq = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                     FROM detalleliquidacion 
                                    WHERE terid = ".$terid."
                                          AND pernominaid IN ($listaperiodos) ";
                    $devengados = $clase->SeleccionarUno($vsqldevliq);
    
                    // total descuentos
                    $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                      FROM detalleliquidacion 
                                     WHERE pernominaid IN ($listaperiodos) 
                                           AND terid = ".$terid."";
                    $descuentos = $clase->SeleccionarUno($vsqldescliq);
    
                    // neto a pagar
                    $neto = $devengados - $descuentos;
    
                    // Obtengo la fecha de ingreso del empleado
                    $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
    
                    // libranzas
                    $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                           FROM detalleliquidacion h
                                                INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                          WHERE h.pernominaid IN ($listaperiodos)
                                                AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                                                AND h.terid = ".$terid."
                                                AND c.conceptoid NOT IN (10,30)";
                    $numlibranzasliq = $clase->SeleccionarUno($vsqllibranzasliq);
    
                    // otras deducciones
                    $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41,43,58) 
                                                 AND h.terid = ".$terid."";
                    $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);
    
                    // Vacaciones
                    $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'vacaciones'";
                    $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                    // Vacaciones pagadas en quincenas
                    $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2
                                             FROM hisdetallenomina 
                                            WHERE terid = ".$terid."
                                                  AND conceptoid = 38 
                                                  AND pernominaid IN ($listaperiodos)";
                    $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                    $numvacacionest = $numvacaciones1 + $numvacaciones2;
    
                    // Primas
                    $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                        FROM liquidacion
                                       WHERE terid = ".$terid."
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'primas'";
                    $numprimas = $clase->SeleccionarUno($vsqlnumprimas);
    
                    // Cesantías
                    $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                           FROM liquidacion
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'cesantias'";
                    $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);
    
                    // indemnización
                    $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'indemnizacion'";
                    $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                    // Otros conceptos devengados
                    $vsqlotrosdevenliq = "SELECT COUNT(h.conceptoid) AS numotrosdevenliq
                                            FROM detalleliquidacion h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid = 37
                                                 AND h.terid = ".$terid."";
                    $numotrosdevenliq = $clase->SeleccionarUno($vsqlotrosdevenliq);
    
                    // ------------------------------------------------------------------------------------------------------------------------------------ //
                    // Dotaciones 
                    $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                         FROM dotaciones
                                        WHERE periodonomina = '".$codperiodo."'
                                              AND terid = ".$terid."";
                    $montodotacion = $clase->SeleccionarUno($vsqldotaciones);
    
                    // Licencias
                    $vsqlincapacidad = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND c.eslicencia = 'CHECKED' 
                                               AND c.tipodc = 'C' 
                                               AND h.conceptoid NOT IN (10,9,43,58)                                          
                                               AND h.terid = ".$terid."";
                    $numlicencias = $clase->SeleccionarUno($vsqlincapacidad);

                    $vsqllicnoremuneradas2 = "SELECT COUNT(conceptoid) AS licnoremuneradas2 
                                                FROM detalleliquidacion 
                                               WHERE pernominaid IN ($listaperiodos)
                                                     AND conceptoid = 6
                                                     AND terid = ".$terid;
                    $licnoremuneradas2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                    $numlicencias += $licnoremuneradas2;

                    // Incapacidades del periodo
                    $vsqlincapacidad = "SELECT COUNT(*) AS numincap
                                          FROM detalleliquidacion 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND conceptoid IN (10,43)";
                    $numincap = $clase->SeleccionarUno($vsqlincapacidad);                    
    
                    $celda1="A".strval($j);             $celda2="B".strval($j);             $celda3="C".strval($j);             $celda4="D".strval($j);
                    $celda5="E".strval($j);             $celda6="F".strval($j);             $celda7="G".strval($j);             $celda8="H".strval($j);
                    $celda9="I".strval($j);             $celda10="J".strval($j);            $celda11="K".strval($j);            $celda12="L".strval($j);
                    $celda13="M".strval($j);            $celda14="N".strval($j);            $celda15="O".strval($j);            $celda16="P".strval($j);
                    $celda17="Q".strval($j);            $celda18="R".strval($j);            $celda19="S".strval($j);            $celda20="T".strval($j);
                    $celda21="U".strval($j);            $celda22="V".strval($j);            $celda23="W".strval($j);            $celda24="X".strval($j);
                    $celda25="Y".strval($j);            $celda26="Z".strval($j);            $celda27="AA".strval($j);           $celda28="AB".strval($j);
                    $celda29="AC".strval($j);           $celda30="AD".strval($j);           $celda31="AE".strval($j);           $celda32="AF".strval($j);
                    $celda33="AG".strval($j);           $celda34="AH".strval($j);           $celda35="AI".strval($j);           $celda36="AJ".strval($j);
                    $celda37="AK".strval($j);           $celda38="AL".strval($j);           $celda39="AM".strval($j);           $celda40="AN".strval($j);
                    $celda41="AO".strval($j);           $celda42="AP".strval($j);           $celda43="AQ".strval($j);           $celda44="AR".strval($j);
                    $celda45="AS".strval($j);           $celda46="AT".strval($j);           $celda47="AU".strval($j);           $celda48="AV".strval($j);
                    $celda49="AW".strval($j);           $celda50="AX".strval($j);           $celda51="AY".strval($j);
    
                    // Escribo en la hoja de Excel
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda1, $fecingreso)
                                ->setCellValue($celda2, '01')
                                ->setCellValue($celda3, '00')
                                ->setCellValue($celda4, 'true')
                                ->setCellValue($celda5,'13')
                                ->setCellValue($celda6, $dni)
                                ->setCellValue($celda7, $primerapellido)
                                ->setCellValue($celda8, $segundoapellido)
                                ->setCellValue($celda9, $primernombre)
                                ->setCellValue($celda10, $segundonombre)
                                ->setCellValue($celda11, number_format($basico))
                                ->setCellValue($celda12, $codvende)
                                ->setCellValue($celda13, '1');
    
                    // Identifico la forma de pago
                    if($numcuenta!="")
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda14, '45')
                                    ->setCellValue($celda15, $banco)
                                    ->setCellValue($celda16, 'AHORROS')
                                    ->setCellValue($celda17, $numcuenta);
                    }
                    else
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda14, '10')
                                    ->setCellValue($celda15, 'NINGUNO')
                                    ->setCellValue($celda16, 'NINGUNO')
                                    ->setCellValue($celda17, 'NINGUNA');
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda18, $diastrabliq)
                                ->setCellValue($celda19, number_format($sueldoliq))
                                ->setCellValue($celda20, number_format($transliq));
    
                    // Incluyo las incapacidades
                    if($numincap>0)
                    {
                        // Días de la(s) incapacidad(es)
                        $vsql5 = "SELECT IFNULL(SUM(valor),0) AS valor
                                    FROM detalleliquidacion 
                                   WHERE pernominaid IN ($listaperiodos) 
                                         AND conceptoid IN (10,43,40) 
                                         AND terid = ".$terid;
                        $valorinc = $clase->SeleccionarUno($vsql5);
    
                        // Monto de la(s) incapacidad(es)
                        $vsql6 = "SELECT IFNULL(SUM(devengados),0) AS devengados 
                                    FROM detalleliquidacion 
                                   WHERE pernominaid IN ($listaperiodos) 
                                         AND conceptoid = 10 
                                         AND terid = ".$terid;
                        $devengadosinc = $clase->SeleccionarUno($vsql6);

                        // --------------------------------------------------------------------------------------- //
                        $vsql105 = "SELECT c.nomconcepto AS nombreincapacidad
                                      FROM detalleliquidacion h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid IN ($listaperiodos) 
                                           AND c.conceptoid IN (10,43,40)
                                           AND h.terid = ".$terid."";
                        $conex  = $clase->Conectar();
                        $result105 = mysql_query($vsql105,$conex);

                        $nombreincapacidad = "";
                        while($row105 = mysql_fetch_array($result105))
                        {
                            $nombreincapacidad.= $row105['nombreincapacidad'].", ";
                        }
                        $nombreincapacidad = substr($nombreincapacidad, 0, -2);
                        // --------------------------------------------------------------------------------------- //                        
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda21, $valorinc)
                                    ->setCellValue($celda22, $nombreincapacidad)
                                    ->setCellValue($celda23, number_format($devengadosinc));
                    }
                    else
                    {
                        $valorinc = 0;
                        $devengadosinc = 0;
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda21, $valorinc)
                                    ->setCellValue($celda22, 'NINGUNA')
                                    ->setCellValue($celda23, number_format($devengadosinc));
                    }
    
                    // Incluyo las licencias
                    if($numlicencias>0)
                    {
                        // Días de la(s) licencia(s)
                        $vsql3 = "SELECT SUM(h.valor) AS valorlic
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND c.eslicencia ='CHECKED' 
                                         AND c.tipodc = 'C' 
                                         AND h.conceptoid NOT IN (10,9,43,40,58)                                        
                                         AND h.terid = ".$terid;
                        $valorlic = $clase->SeleccionarUno($vsql3);

                        $vsqllicnoremuneradas2 = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem2
                                                    FROM detalleliquidacion 
                                                   WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid;
                        $valorlicnorem2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                        $valorlic += $valorlicnorem2;                        
    
                        // Monto de la(s) licencia(s)
                        $vsql4 = "SELECT SUM(h.devengados) AS devengadoslic
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND c.eslicencia = 'CHECKED' 
                                         AND c.tipodc = 'C' 
                                         AND h.conceptoid NOT IN (10,9)                                          
                                         AND h.terid = ".$terid;
                        $devengadoslic = $clase->SeleccionarUno($vsql4);
    
                        // Construyo la descripción de todas las licencias en el periodo
                        $vsql10 = "SELECT c.nomconcepto AS nombrelicencia
                                     FROM detalleliquidacion h
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND c.eslicencia ='CHECKED' 
                                          AND c.tipodc = 'C' 
                                          AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                          AND h.terid = ".$terid."
                                   UNION
                                   SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia
                                     FROM detalleliquidacion h 
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid = 6
                                          AND h.terid = ".$terid;
                                            
                        $conex  = $clase->Conectar();
                        $result10 = mysql_query($vsql10,$conex);
    
                        $nombrelicencia = "";
                        while($row10 = mysql_fetch_array($result10))
                        {
                            $nombrelicencia.= $row10['nombrelicencia'].", ";
                        }
                        $nombrelicencia = substr($nombrelicencia, 0, -2);
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda24, $nombrelicencia)
                                    ->setCellValue($celda25, $valorlic)
                                    ->setCellValue($celda26, number_format($devengadoslic));
                    }
                    else
                    {
                        $valorlic = 0;
                        $devengadoslic = 0;
                        $nombrelicencia = "NINGUNA";
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda24, $nombrelicencia)
                                    ->setCellValue($celda25, $valorlic)
                                    ->setCellValue($celda26, number_format($devengadoslic));
                    }
    
                    // Embargo
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda27, number_format($embargo));
    
                    // Otras deducciones
                    if($numotrasdedliq>0)
                    {
                        // Monto de las otras deducciones
                        $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                               AND h.terid = ".$terid;
                        $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                        // Descripción de las deducciones
                        $vsql11 = "SELECT c.nomconcepto, h.descuentos
                                     FROM detalleliquidacion h
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                          AND h.terid = ".$terid;
                        $conex  = $clase->Conectar();
                        $result11 = mysql_query($vsql11,$conex);
    
                        $nombreoc = "";
                        while($row11 = mysql_fetch_array($result11))
                        {
                            $nombreoc.= $row11['nomconcepto']." (".number_format($row11['descuentos'])."), ";
                        }
                        $nombreoc = substr($nombreoc, 0, -2);
                    }
                    else
                    {
                        $nombreoc = "NINGUNO";
                        $montootrasdeduc = 0;
                    }
                    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda28, $nombreoc)
                                ->setCellValue($celda29, number_format($montootrasdeduc));
    
                    // Continuamos con salud y pensión
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda30, $por_sal_tra)
                                ->setCellValue($celda31, number_format($saludliq))
                                ->setCellValue($celda32, $por_pen_tra)
                                ->setCellValue($celda33, number_format($pesionliq));
    
                    // sanciones
                    $montosancion = 0;
                    $conceptosancion = "NINGUNA";
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda34, number_format($montosancion))
                                ->setCellValue($celda35, $conceptosancion);
    
                    if($numlibranzasliq>0)
                    {
                        $vsql8 = "SELECT SUM(h.descuentos) AS montolibranza
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                         AND h.terid = ".$terid."
                                         AND c.conceptoid NOT IN (10,30)";
                        $montolibranza = $clase->SeleccionarUno($vsql8);
    
                        $vsql9 = "SELECT c.nomconcepto, h.descuentos  
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                         AND h.terid = ".$terid."
                                         AND c.conceptoid NOT IN (10,30)";    
                        $conex  = $clase->Conectar();
                        $result9 = mysql_query($vsql9,$conex);
    
                        $nombrelibranza = "";
                        while($row9 = mysql_fetch_array($result9))
                        {
                            $nombrelibranza.= $row9['nomconcepto']." (".number_format($row9['descuentos'])."), ";
                        }
                        $nombrelibranza = substr($nombrelibranza, 0, -2);
                    }
                    else
                    {
                        $nombrelibranza = "NINGUNA";
                        $montolibranza = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda36, $nombrelibranza)
                                ->setCellValue($celda37, number_format($montolibranza));
    
                    // primas
                    if($numprimas>0)
                    {
                        // Días de la prima
                        $vsqlcanprimas = "SELECT cantidad AS canprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                        // Pago de la prima
                        $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                             FROM liquidacion
                                            WHERE terid = ".$terid."
                                                  AND periodonomina = '".$codperiodo."' 
                                                  AND tipo = 'primas'";
                        $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);
    
                        $devengados += $pagoprimas;
                    }
                    else
                    {
                        $canprimas = 0;
                        $pagoprimas = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda38, number_format($canprimas))
                                ->setCellValue($celda39, number_format($pagoprimas));
    
                    // Cesantías
                    if($numcesantias>0)
                    {
                        // Pago de la cesantía
                        $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);
    
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        if($numpagocesan>0)
                        {
                            $vsqlnumpagocesan = "";
                            $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                            $pagocesantia += $montopagocesan;
                        }
    
                        // Porcentaje cesantía
                        $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);
    
                        // Pago de intereses de cesantías
                        $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'cesantias'";
                        $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);
    
                        $devengados += $pagocesantia;
                        $devengados += $pagointereses;
                    }
                    else
                    {
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        if($numpagocesan>0)
                        {
                            $vsqlnumpagocesan = "";
                            $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                            $pagocesantia = $montopagocesan;
                            $devengados += $pagocesantia;
                        }
                        else
                            $pagocesantia = 0;
    
                        $porccesantia = 0;
                        $pagointereses = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda40, number_format($pagocesantia))
                                ->setCellValue($celda41, number_format($porccesantia))
                                ->setCellValue($celda42, number_format($pagointereses));
    
                    // vacaciones
                    if($numvacacionest>0)
                    {
                        if($numvacaciones1 > 0)
                        {
                            // Días de vacaciones
                            $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'vacaciones'";
                            $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                            // Pago de vacaciones
                            $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'vacaciones'";
                            $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                        }
                        else
                        {
                            $canvacaciones = 0;
                            $pagovaca1 = 0;
                        }

                        if($numvacaciones2>0)
                        {
                            $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                FROM hisdetallenomina  
                                               WHERE terid = ".$terid."
                                                     AND conceptoid = 38 
                                                     AND pernominaid IN ($listaperiodos)";
                            $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                        }
                        else
                            $pagovaca2 = 0;
                        
                        if($canvacaciones == 0)               $canvacaciones = 1;
                        $pagovaca = $pagovaca1 + $pagovaca2;
                        $devengados += $pagovaca1;
                    }
                    else
                    {
                        $canvacaciones = 0;
                        $pagovaca = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda43, number_format($canvacaciones,2))
                                ->setCellValue($celda44, number_format($pagovaca));
    
                    // indemnización
                    if($numindemnizacion>0)
                    {
                        $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                        $devengados += $indemnizacion;
                    }
                    else
                        $indemnizacion = 0;
    
                    $objPHPExcel->setActiveSheetIndex(0)                                    
                                ->setCellValue($celda45, number_format($indemnizacion));
    
                    // otros devengados
                    if($numotrosdevenliq>0)
                    {
                        $vsqlotrosdeven = "SELECT SUM(IF(h.conceptoid = 37,h.devengados,0)) AS otrosdeven
                                             FROM detalleliquidacion h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)                                                      
                                                  AND h.terid=".$terid;
                        $otrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
                    }
                    else
                        $otrosdeven = 0;
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda46, number_format($otrosdeven));
    
                    $neto = $devengados - $descuentos;
    
                    // dotaciones
                    if(strlen($montodotacion)>0)
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AU'.$i, number_format($montodotacion));
                        $devengados += $montodotacion;
                    }
                    else
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AU'.$i, 0);
    
                        // cune del empleado
                        $vsqlcune = "SELECT d.cune AS cune
                                       FROM dianterceros d 
                                            INNER JOIN periododian p ON (d.periodonomina = p.periododiamid)
                                      WHERE p.periodonomina = '".$codperiodo."'
                                            AND d.terid = ".$terid;
                        $cune = $clase->SeleccionarUno($vsqlcune);

                    // Totales
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda48, number_format($devengados))
                                ->setCellValue($celda49, number_format($descuentos))
                                ->setCellValue($celda50, number_format($neto))
                                ->setCellValue($celda51, $cune);
    
                    // Incremento el contador de líneas
                    $j++;
                    $listadereportados.= $terid.",";
                }
            }

            $listadereportados = substr($listadereportados, 0, -1);

            $rangoEncabezado = 'A9:AK9';
            $rangoCeldas     = 'A9:AK'.($j-1);
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Ciclo para los empleados que trabajaron ambas quincenas y también tienen liquidación y son empleados activos, esto es para el caso que uno o varios 
        // empleados hayan tenido cambio de cargo
        
        $primquin = substr($listaperiodos,0,2);
        $segnquin = substr($listaperiodos,-2);

        $vsqlcambiocargo = "SELECT DISTINCT d.terid,  
                                   CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                   t.esempleadoactivo, t.extralegal
                              FROM detallenomina d
                                   INNER JOIN terceros t ON (d.terid = t.terid)
                             WHERE d.pernominaid = ".$primquin."
                                   AND d.terid IN (SELECT terid
                                                     FROM hisdetallenomina 
                                                    WHERE pernominaid = ".$segnquin.") 
                                   AND d.terid IN (SELECT terid
                                                     FROM detalleliquidacion 
                                                    WHERE pernominaid IN ($listaperiodos))                      
                                   AND d.terid IN (SELECT terid
                                                     FROM liquidacion 
                                                    WHERE periodonomina = '".$codperiodo."')  
                                   AND t.esempleadoactivo = 'CHECKED'
                                   AND t.extralegal <> 'CHECKED'";

        if(strlen($listadereportados)>0)            $vsqlcambiocargo.= " AND d.terid NOT IN ($listadereportados)";

        if(strlen($nodebensalir) > 0)
            $vsqlcambiocargo.= " AND d.terid NOT IN ($nodebensalir) ";        

        $k = $j;

        $conex  = $clase->Conectar();
        $resultcam = mysql_query($vsqlcambiocargo,$conex);
        $empleadoscambiados = mysql_num_rows($resultcam);

        if($empleadoscambiados > 0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";
            $celda1="";                                     $celda2="";                                     $celda3="";
            $celda4="";                                     $celda5="";                                     $celda6="";
            $celda7="";                                     $celda8="";                                     $celda9="";
            $celda10="";                                    $celda11="";                                    $celda12="";
            $celda13="";                                    $celda14="";                                    $celda15="";
            $celda16="";                                    $celda17="";                                    $celda18="";
            $celda19="";                                    $celda20="";                                    $celda21="";
            $celda22="";                                    $celda23="";                                    $celda24="";
            $celda25="";                                    $celda26="";                                    $celda27="";
            $celda28="";                                    $celda29="";                                    $celda30="";
            $celda31="";                                    $celda32="";                                    $celda33="";
            $celda34="";                                    $celda35="";                                    $celda36="";
            $celda37="";                                    $celda38="";                                    $celda39="";
            $celda40="";                                    $celda41="";                                    $celda42="";
            $celda43="";                                    $celda44="";                                    $celda45="";
            $celda46="";                                    $celda47="";                                    $celda48="";
            $celda49="";                                    $celda50="";                                    $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $listadereportados.= ",";                       $vsqlvextralegal = "";
            $numnomext = 0;                                 $vsqlnumvacaciones2 = "";                       $numvacaciones2 = 0;
            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;                                 $celda51="";
            $cune = "";                                     $vsqlcune = "";

            while($rowcambio = mysql_fetch_array($resultcam))
            {
                // id del empleado
                $terid = $rowcambio['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal ='CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);
                
                if($numnomext<2)
                {
                    // Documento del empleado
                    $dni = $clase->BDLockup($terid,'terceros','terid','dni');
                    $cambiorepetido = 0;
    
                    // Genero el registro en la hoja de Excel
                    if($cambiorepetido==0)
                    {
                        // Días trabajados                    
                        $vsqldias = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrab 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid=".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                        $diastrab = $clase->SeleccionarUno($vsqldias);
    
                        // Días trabajados en la liquidación
                        $vsqldiasliq = "SELECT SUM(IF(conceptoid=1,valor,0)) AS diastrabliq 
                                          FROM detalleliquidacion 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND conceptoid = 1";
                        $diastrabliq = $clase->SeleccionarUno($vsqldiasliq);
    
                        $diastrab += $diastrabliq;
    
                        // Documento del empleado
                        $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                        // Primer apellido
                        $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                        // Segundo apellido
                        $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                        // Primer nombre
                        $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                        // Segundo nombre
                        $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                        // Sueldo básico
                        $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                        // Código del trabajador
                        $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                        // Correo electrónico
                        $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                        // Teléfono
                        $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                        // Número de cuenta
                        $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
    
                        // Tipo de documento
                        $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                        // Banco
                        $vsqlbanco = "SELECT b.descripcion AS banco
                                        FROM periodoterceros p
                                             INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                       WHERE p.terid = ".$terid;
                        $banco = $clase->SeleccionarUno($vsqlbanco);
                        $banco = trim(str_replace("BANCO ","",$banco));
    
                        // cargo del empleado
                        $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
    
                        // sueldo del periodo
                        $vsqlsueldo = "SELECT SUM(IF(conceptoid=1,devengados,0)) AS sueldoper 
                                         FROM hisdetallenomina 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND terid=".$terid."
                                              AND pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                             AND periodoterceros.extralegal = 'CHECKED')";
                        $sueldoper = $clase->SeleccionarUno($vsqlsueldo);
    
                        $vsqlsueldoliq = "SELECT devengados AS sueldoliq
                                            FROM detalleliquidacion
                                           WHERE terid=".$terid."
                                                 AND conceptoid = 1
                                                 AND pernominaid IN ($listaperiodos)";
                        $sueldoliq = $clase->SeleccionarUno($vsqlsueldoliq);
    
                        $sueldoper += $sueldoliq;
    
                        // Auxilio de transporte                        
                        $vsqltrasp = "SELECT SUM(IF(conceptoid=3,devengados,0)) AS auxtransp 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid=".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                        $auxtransp = $clase->SeleccionarUno($vsqltrasp);
    
                        $vsqltransliq = "SELECT devengados AS transliq
                                           FROM detalleliquidacion
                                          WHERE terid = ".$terid."
                                                AND conceptoid = 3
                                                AND pernominaid IN ($listaperiodos)";
                        $transliq = $clase->SeleccionarUno($vsqltransliq);
    
                        $auxtransp += $transliq;
    
                        // Embargo
                        $vsqlembg = "SELECT SUM(IF(conceptoid=30,descuentos,0)) AS embargo 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid=".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                        $embargo = $clase->SeleccionarUno($vsqlembg);
    
                        $vsqlembliq = "SELECT descuentos AS embliq
                                         FROM detalleliquidacion
                                        WHERE terid=".$terid."
                                              AND conceptoid = 30
                                              AND pernominaid IN ($listaperiodos)";
                        $embliq = $clase->SeleccionarUno($vsqlembliq);
    
                        $embargo += $embliq;
    
                        // Salud
                        $vsqlsalud = "SELECT SUM(IF(conceptoid=5,descuentos,0)) AS salud 
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND terid=".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                        $salud = $clase->SeleccionarUno($vsqlsalud);
    
                        $vsqlsaludliq = "SELECT descuentos AS saludliq
                                           FROM detalleliquidacion
                                          WHERE terid=".$terid."
                                                AND conceptoid = 5
                                                AND pernominaid IN ($listaperiodos)";
                        $saludliq = $clase->SeleccionarUno($vsqlsaludliq);
    
                        $salud += $saludliq;
    
                        // Pensión                        
                        $vsqlpension = "SELECT SUM(IF(conceptoid=4,descuentos,0)) AS pension 
                                          FROM hisdetallenomina 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid = ".$terid."
                                               AND pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
                        $pension = $clase->SeleccionarUno($vsqlpension);
    
                        $vsqlpesionliq = "SELECT descuentos AS pesionliq
                                            FROM detalleliquidacion
                                           WHERE terid=".$terid."
                                                 AND conceptoid = 4
                                                 AND pernominaid IN ($listaperiodos)";
                        $pesionliq = $clase->SeleccionarUno($vsqlpesionliq);
    
                        $pension += $pesionliq;
    
                        // total devengado
                        $vsqldev = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                      FROM hisdetallenomina 
                                     WHERE terid=".$terid."
                                           AND pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                          AND periodoterceros.extralegal = 'CHECKED')";
                        $devengados = $clase->SeleccionarUno($vsqldev);
    
                        $vsqldevliq = "SELECT SUM(IF(pernominaid IN ($listaperiodos),devengados,0)) AS devengados 
                                         FROM detalleliquidacion 
                                        WHERE terid=".$terid."";
                        $devengadosliq = $clase->SeleccionarUno($vsqldevliq);
    
                        $devengados += $devengadosliq;
    
                        // total descuentos
                        $vsqldesc = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                       FROM hisdetallenomina 
                                      WHERE pernominaid IN ($listaperiodos) 
                                            AND terid=".$terid."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                        $descuentos = $clase->SeleccionarUno($vsqldesc);
    
                        $vsqldescliq = "SELECT SUM(IF(conceptoid NOT IN (6, 9, 43, 58),descuentos,0)) AS descuentos 
                                          FROM detalleliquidacion 
                                         WHERE pernominaid IN ($listaperiodos) 
                                               AND terid=".$terid."";
                        $descuentosliq = $clase->SeleccionarUno($vsqldescliq);
    
                        $descuentos += $descuentosliq;
        
                        // Obtengo la fecha de ingreso del empleado
                        $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
    
                        // Incapacidades del periodo                        
                        $vsqlincapacidad = "SELECT COUNT(*) AS numincap 
                                              FROM hisdetallenomina 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND conceptoid IN (10,43,40) 
                                                   AND terid=".$terid."
                                                   AND pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                  AND periodoterceros.extralegal = 'CHECKED')";
                        $numincap = $clase->SeleccionarUno($vsqlincapacidad);

                        $vsqlincapacidad2 = "SELECT COUNT(*) AS numincap
                                              FROM detalleliquidacion 
                                             WHERE pernominaid IN ($listaperiodos) 
                                                   AND terid = ".$terid."
                                                   AND conceptoid IN (10,43,40)";
                        $numincap2 = $clase->SeleccionarUno($vsqlincapacidad2);

                        $numincap += $numincap2;                        
    
                        // Licencias del periodo
                        $vsqlincapacidad = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                              FROM hisdetallenomina h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND c.eslicencia = 'CHECKED' 
                                                   AND c.tipodc = 'C' 
                                                   AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                                   AND h.terid = ".$terid."
                                                   AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                               FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                    AND periodoterceros.extralegal = 'CHECKED')";
                        $numlicencias = $clase->SeleccionarUno($vsqlincapacidad);

                        $vsqlincapacidad2 = "SELECT COUNT(h.conceptoid) AS numlicencias 
                                              FROM detalleliquidacion h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND c.eslicencia = 'CHECKED' 
                                                   AND c.tipodc = 'C' 
                                                   AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                                   AND h.terid = ".$terid;
                        $numlicencias2 = $clase->SeleccionarUno($vsqlincapacidad2);

                        $numlicencias += $numlicencias2;

                        // ---------------------------------------------------------------------------------------------------------- //
                        $vsqllicnoremuneradas2 = "SELECT COUNT(conceptoid) AS licnoremuneradas2 
                                                    FROM detalleliquidacion 
                                                   WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid."
                                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                                   FROM periodoterceros
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND pernominaid IN ($listaperiodos)
                                                                                        AND extralegal ='CHECKED')";
                        $licnoremuneradas2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);
                        $numlicencias += $licnoremuneradas2;
                        // ---------------------------------------------------------------------------------------------------------- //                        
    
                        // Libranzas del periodo
                        $vsqllibranzas = "SELECT COUNT(h.conceptoid) AS numlibranzas 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                                                 AND h.terid = ".$terid."
                                                 AND c.conceptoid NOT IN (10,30)
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                  AND periodoterceros.extralegal = 'CHECKED')";
                        $numlibranzas = $clase->SeleccionarUno($vsqllibranzas);
    
                        // Libranzas en liquidación
                        $vsqllibranzasliq = "SELECT COUNT(h.conceptoid) AS numlibranzasliq 
                                               FROM detalleliquidacion h
                                                    INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                              WHERE h.pernominaid IN ($listaperiodos)
                                                    AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                                                    AND h.terid=".$terid."
                                                    AND c.conceptoid NOT IN (10,30)";
                        $numlibranzasliq = $clase->SeleccionarUno($vsqllibranzasliq);
    
                        // Sanciones del periodo
                        $vsqlsanciones = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                            FROM hisdetallenomina h
                                                 INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                           WHERE h.pernominaid IN ($listaperiodos)
                                                 AND h.conceptoid = 9
                                                 AND h.terid=".$terid."
                                                 AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                             FROM periodoterceros
                                                                            WHERE periodoterceros.terid = ".$terid." 
                                                                                  AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                  AND periodoterceros.extralegal = 'CHECKED')";
                        $numsanciones = $clase->SeleccionarUno($vsqlsanciones);
    
                        // Otras deducciones
                        // Estas incluyen: CAMISETAS, PLAN TELEFONIA MOVIL, PRESTAMOS PERSONALES, AJUSTE SALARIO SENA, 
                        // CREDITOS OTROS NEGOCIOS, DESCUENTO SP, MANGAS, CAFETERIA, COMPRAS A CREDITO, OTROS E INCAPACIDAD SUPERIOR A 180 DÍAS
                        $vsqlotrasdeduc = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                                  AND h.terid=".$terid."
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                        $numotrasded = $clase->SeleccionarUno($vsqlotrasdeduc);
    
                        // otras deducciones en liquidación
                        $vsqlotrasdeducliq = "SELECT COUNT(h.conceptoid) AS numsanciones 
                                                FROM detalleliquidacion h
                                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                               WHERE h.pernominaid IN ($listaperiodos)
                                                     AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                                     AND h.terid=".$terid."";
                        $numotrasdedliq = $clase->SeleccionarUno($vsqlotrasdeducliq);
    
                        // Vacaciones
                        $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'vacaciones'";
                        $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                        // Vacaciones pagadas en quincenas
                        $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2
                                                 FROM hisdetallenomina 
                                                WHERE terid = ".$terid."
                                                      AND conceptoid = 38 
                                                      AND pernominaid IN ($listaperiodos)";
                        $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                        $numvacacionest = $numvacaciones1 + $numvacaciones2;

                        // Primas
                        $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                            FROM liquidacion
                                           WHERE terid=".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $numprimas = $clase->SeleccionarUno($vsqlnumprimas);
    
                        // Cesantías
                        $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                               FROM liquidacion
                                              WHERE terid=".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);
    
                        // Indemnización
                        $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                                FROM liquidacion
                                               WHERE terid=".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                        // Otros conceptos devengados
                        $vsqlotrosdevenliq = "SELECT COUNT(h.conceptoid) AS numotrosdevenliq
                                                FROM detalleliquidacion h
                                                     INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                               WHERE h.pernominaid IN ($listaperiodos)
                                                     AND h.conceptoid = 37
                                                     AND h.terid = ".$terid."";
                        $numotrosdevenliq = $clase->SeleccionarUno($vsqlotrosdevenliq);
    
                        // Otros conceptos devengados
                        $vsqlotrosdeven = "SELECT COUNT(h.conceptoid) AS numotrosdeven
                                             FROM hisdetallenomina h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos)
                                                  AND h.conceptoid = 37
                                                  AND h.terid=".$terid."
                                                  AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                        $numotrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
    
                        // ------------------------------------------------------------------------------------------------------------------------------------ //
                        // Dotaciones 
                        $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                             FROM dotaciones
                                            WHERE periodonomina = '".$codperiodo."'
                                                  AND terid = ".$terid."";
                        $montodotacion = $clase->SeleccionarUno($vsqldotaciones);
    
                        $celda1="A".strval($k);         $celda2="B".strval($k);         $celda3="C".strval($k);         $celda4="D".strval($k);         $celda5="E".strval($k);
                        $celda6="F".strval($k);         $celda7="G".strval($k);         $celda8="H".strval($k);         $celda9="I".strval($k);         $celda10="J".strval($k);
                        $celda11="K".strval($k);        $celda12="L".strval($k);        $celda13="M".strval($k);        $celda14="N".strval($k);        $celda15="O".strval($k);
                        $celda16="P".strval($k);        $celda17="Q".strval($k);        $celda18="R".strval($k);        $celda19="S".strval($k);        $celda20="T".strval($k);
                        $celda21="U".strval($k);        $celda22="V".strval($k);        $celda23="W".strval($k);        $celda24="X".strval($k);        $celda25="Y".strval($k);
                        $celda26="Z".strval($k);        $celda27="AA".strval($k);       $celda28="AB".strval($k);       $celda29="AC".strval($k);       $celda30="AD".strval($k);
                        $celda31="AE".strval($k);       $celda32="AF".strval($k);       $celda33="AG".strval($k);       $celda34="AH".strval($k);       $celda35="AI".strval($k);
                        $celda36="AJ".strval($k);       $celda37="AK".strval($k);       $celda38="AL".strval($k);       $celda39="AM".strval($k);       $celda40="AN".strval($k);
                        $celda41="AO".strval($k);       $celda42="AP".strval($k);       $celda43="AQ".strval($k);       $celda44="AR".strval($k);       $celda45="AS".strval($k);
                        $celda46="AT".strval($k);       $celda47="AU".strval($k);       $celda48="AV".strval($k);       $celda49="AW".strval($k);       $celda50="AX".strval($k);
                        $celda51="AY".strval($k);
    
                        // Escribo en la hoja de Excel
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda1, $fecingreso)
                                    ->setCellValue($celda2, '01')
                                    ->setCellValue($celda3, '00')
                                    ->setCellValue($celda4, 'true')
                                    ->setCellValue($celda5,'13')
                                    ->setCellValue($celda6, $dni)
                                    ->setCellValue($celda7, $primerapellido)
                                    ->setCellValue($celda8, $segundoapellido)
                                    ->setCellValue($celda9, $primernombre)
                                    ->setCellValue($celda10, $segundonombre)
                                    ->setCellValue($celda11, number_format($basico))
                                    ->setCellValue($celda12, $codvende)
                                    ->setCellValue($celda13, '1');
    
                        // Identifico la forma de pago
                        if($numcuenta!="")
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda14, '45')
                                        ->setCellValue($celda15, $banco)
                                        ->setCellValue($celda16, 'AHORROS')
                                        ->setCellValue($celda17, $numcuenta);
                        }
                        else
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda14, '10')
                                        ->setCellValue($celda15, 'NINGUNO')
                                        ->setCellValue($celda16, 'NINGUNO')
                                        ->setCellValue($celda17, 'NINGUNA');
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda18, $diastrab)
                                    ->setCellValue($celda19, number_format(intval($sueldoper)))
                                    ->setCellValue($celda20, number_format(intval($auxtransp)));
    
                        // Incluyo las incapacidades
                        if($numincap>0)
                        {
                            // Días de la(s) incapacidad(es)
                            $vsql5 = "SELECT valor
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND conceptoid IN (10,43,40)  
                                             AND terid=".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                            $valorinc = $clase->SeleccionarUno($vsql5);

                            $vsql52 = "SELECT IFNULL(SUM(valor),0) AS valor
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND conceptoid IN (10,43,40)
                                              AND terid = ".$terid;
                            $valorinc2 = $clase->SeleccionarUno($vsql52);

                            $valorinc += $valorinc2;                            
    
                            // Monto de la(s) incapacidad(es)
                            $vsql6 = "SELECT devengados
                                        FROM hisdetallenomina 
                                       WHERE pernominaid IN ($listaperiodos) 
                                             AND conceptoid = 10 
                                             AND terid = ".$terid."
                                             AND pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                            $devengadosinc = $clase->SeleccionarUno($vsql6);

                            $vsql62 = "SELECT devengados
                                         FROM detalleliquidacion 
                                        WHERE pernominaid IN ($listaperiodos) 
                                              AND conceptoid = 10  
                                              AND terid = ".$terid;
                            $devengadosinc2 = $clase->SeleccionarUno($vsql62);

                            $devengadosinc += $devengadosinc2;

                            // --------------------------------------------------------------------------------------- //
                            $vsql105 = "SELECT c.nomconcepto AS nombreincapacidad
                                          FROM hisdetallenomina h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos) 
                                               AND c.conceptoid IN (10,43,40)
                                               AND h.terid = ".$terid."
                                               AND pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal ='CHECKED')
                                        UNION 
                                        SELECT c.nomconcepto AS nombreincapacidad
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos) 
                                               AND c.conceptoid IN (10,43,40)
                                               AND h.terid = ".$terid."";
                            $conex  = $clase->Conectar();
                            $result105 = mysql_query($vsql105,$conex);

                            $nombreincapacidad = "";
                            while($row105 = mysql_fetch_array($result105))
                            {
                                $nombreincapacidad.= $row105['nombreincapacidad'].", ";                                
                            }
                            $nombreincapacidad = substr($nombreincapacidad, 0, -2);
                            // --------------------------------------------------------------------------------------- //                        
    
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda21, $valorinc)
                                        ->setCellValue($celda22, $nombreincapacidad)
                                        ->setCellValue($celda23, number_format($devengadosinc));
                        }
                        else
                        {
                            $valorinc = 0;
                            $devengadosinc = 0;
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda21, $valorinc)
                                        ->setCellValue($celda22, 'NINGUNA')
                                        ->setCellValue($celda23, number_format($devengadosinc));
                        }
    
                        // Incluyo las licencias
                        if($numlicencias>0)
                        {
                            // Días de la(s) licencia(s)
                            $vsql3 = "SELECT SUM(h.valor) AS valorlic
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND c.eslicencia = 'CHECKED' 
                                             AND c.tipodc = 'C' 
                                             AND h.conceptoid NOT IN (10,9,43,40,58)  
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
                            $valorlic = $clase->SeleccionarUno($vsql3);

                            if($valorlic==NULL)
                                $valorlic = 0;

                            // -------------------------------------------------------------------------------------------------- //
                            $vsqllicnoremuneradas = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem
                                                       FROM hisdetallenomina 
                                                      WHERE pernominaid IN ($listaperiodos)
                                                        AND conceptoid = 6
                                                        AND terid = ".$terid."
                                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND pernominaid IN ($listaperiodos)
                                                                                       AND extralegal ='CHECKED')";
                            $valorlicnorem = $clase->SeleccionarUno($vsqllicnoremuneradas);

                            $valorlic += $valorlicnorem;
                            // -------------------------------------------------------------------------------------------------- //                                

                            $vsql32 = "SELECT IFNULL(SUM(h.valor),0) AS valorlic
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia = 'CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                              AND h.terid = ".$terid;
                            $valorlic2 = $clase->SeleccionarUno($vsql32);

                            // -------------------------------------------------------------------------------------------------- //
                            $vsqllicnoremuneradas2 = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem2
                                                        FROM detalleliquidacion 
                                                       WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid."
                                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                                   FROM periodoterceros
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND pernominaid IN ($listaperiodos)
                                                                                        AND extralegal ='CHECKED')";
                            $valorlicnorem2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                            $valorlic2 += $valorlicnorem2;
                            // -------------------------------------------------------------------------------------------------- //

                            $valorlic += $valorlic2;
    
                            // Monto de la(s) licencia(s)
                            $vsql4 = "SELECT SUM(h.devengados) AS devengadoslic
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND c.eslicencia ='CHECKED' 
                                             AND c.tipodc = 'C' 
                                             AND h.conceptoid NOT IN (9,43,58) 
                                             AND h.terid = ".$terid;
                            $devengadoslic = $clase->SeleccionarUno($vsql4);
    
                            $vsql42 = "SELECT IFNULL(SUM(h.devengados),0) AS devengadoslic
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia ='CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (9,43,58)                                          
                                              AND h.terid = ".$terid;
                            $devengadoslic2 = $clase->SeleccionarUno($vsql42);

                            $devengadoslic += $devengadoslic2;

                            // Construyo la descripción de todas las licencias en el periodo
                            $vsql10 = "SELECT c.nomconcepto AS nombrelicencia
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND c.eslicencia ='CHECKED' 
                                              AND c.tipodc = 'C' 
                                              AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                              AND h.terid=".$terid."
                                       UNION                                       
                                       SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia 
                                         FROM detalleliquidacion h 
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid = 6
                                              AND h.terid = ".$terid."";
                            $conex  = $clase->Conectar();
                            $result10 = mysql_query($vsql10,$conex);
    
                            $nombrelicencia = "";
                            while($row10 = mysql_fetch_array($result10))
                            {
                                if($row10['nombrelicencia'] != "")
                                {
                                    if($row10['nombrelicencia'] != NULL)
                                        $nombrelicencia.= $row10['nombrelicencia'].", ";
                                }
                            }
                            $nombrelicencia = substr($nombrelicencia, 0, -2);
    
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda24, $nombrelicencia)
                                        ->setCellValue($celda25, $valorlic)
                                        ->setCellValue($celda26, number_format($devengadoslic));
                        }
                        else
                        {
                            $valorlic = 0;
                            $devengadoslic = 0;
                            $nombrelicencia = "NINGUNA";
        
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue($celda24, $nombrelicencia)
                                        ->setCellValue($celda25, $valorlic)
                                        ->setCellValue($celda26, number_format($devengadoslic));
                        }
    
                        // Embargo
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda27, number_format($embargo));
    
                        // otras deducciones
                        if(($numotrasded>0)&&($numotrasdedliq>0))
                        {
                            // Monto de las otras deducciones
                            $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                              FROM detalleliquidacion h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                                   AND h.terid=".$terid;
                            $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                            $vsqlmontood2 = "SELECT SUM(h.descuentos) as montootrasdeduc2
                                               FROM hisdetallenomina h
                                                    INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                              WHERE h.pernominaid IN ($listaperiodos)
                                                AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                                AND h.terid = ".$terid."
                                                AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                            FROM periodoterceros
                                                                           WHERE periodoterceros.terid = ".$terid." 
                                                                                 AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                 AND periodoterceros.extralegal = 'CHECKED')";
                            $montootrasdeduc2 = $clase->SeleccionarUno($vsqlmontood);
                            $montootrasdeduc += $montootrasdeduc2;
    
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
    
                            $nombreoc = "";
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
    
                            $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                              AND h.terid = ".$terid."";
    
                            $conex  = $clase->Conectar();
                            $result77 = mysql_query($vsql77,$conex);
    
                            $nombreoc = "";
                            while($row77 = mysql_fetch_array($result77))
                            {
                                $nombreoc.= $row77['nomconcepto']." (".number_format($row77['descuentos'])."), ";
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
                        }
    
                        if(($numotrasded==0)&&($numotrasdedliq>0))
                        {
                            $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                              FROM detalleliquidacion h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                                   AND h.terid = ".$terid;
                            $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM detalleliquidacion h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                             AND h.terid = ".$terid;    
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
                            $nombreoc = "";
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
                        }
    
                        if(($numotrasded>0)&&($numotrasdedliq==0))
                        {
                            // Monto de las otras deducciones
                            $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                              FROM detalleliquidacion h
                                                   INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                             WHERE h.pernominaid IN ($listaperiodos)
                                                   AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                                   AND h.terid = ".$terid;
                            $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                            // Consulta con los datos que se incluirán en el json
                            $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                             AND h.terid = ".$terid."
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE periodoterceros.terid = ".$terid." 
                                                                              AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                              AND periodoterceros.extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result7 = mysql_query($vsql7,$conex);
                            $nombreoc = "";
                            while($row7 = mysql_fetch_array($result7))
                            {
                                $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                            }
                            $nombreoc = substr($nombreoc, 0, -2);
                        }
    
                        if(($numotrasded==0)&&($numotrasdedliq==0))
                        {
                            $nombreoc = "NINGUNO";
                            $montootrasdeduc = 0;
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda28, $nombreoc)
                                    ->setCellValue($celda29, number_format($montootrasdeduc));
    
                        // Continuamos con salud y pensión
                        $objPHPExcel->setActiveSheetIndex(0)                                    
                                    ->setCellValue($celda30, $por_sal_tra)
                                    ->setCellValue($celda31, number_format(intval($salud)))
                                    ->setCellValue($celda32, $por_pen_tra)
                                    ->setCellValue($celda33, number_format(intval($pension)));
    
                        // sanciones
                        if($numsanciones>0)
                        {
                            $vsql66a = "SELECT h.descuentos AS montosancion 
                                          FROM hisdetallenomina h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND h.conceptoid = 9
                                               AND h.terid = ".$terid."
                                               AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                           FROM periodoterceros
                                                                          WHERE periodoterceros.terid = ".$terid." 
                                                                                AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                AND periodoterceros.extralegal = 'CHECKED')";
                            $montosancion = $clase->SeleccionarUno($vsql66a);
                            $conceptosancion = "SUSPENCION";
                        }
                        else
                        {
                            $montosancion = 0;
                            $conceptosancion = "NINGUNA";
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda34, number_format($montosancion))
                                    ->setCellValue($celda35, $conceptosancion);
    
                        // libranzas
                        if(($numlibranzas>0)&&($numlibranzasliq>0))
                        {
                            $vsql82 = "SELECT SUM(h.descuentos) AS montolibranza
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')                                            
                                              AND h.terid = ".$terid."
                                              AND c.conceptoid NOT IN (10,30)
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')";
                            $montolibranza = $clase->SeleccionarUno($vsql82);
    
                            $vsql83 = "SELECT SUM(h.descuentos) AS montolibranza2
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED') 
                                              AND h.terid = ".$terid;
                            $montolibranza2 = $clase->SeleccionarUno($vsql83);
    
                            $montolibranza += $montolibranza2;
    
                            $vsql9 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza ='CHECKED' OR c.montopermanente='CHECKED')
                                             AND h.terid = ".$terid."
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result9 = mysql_query($vsql9,$conex);
        
                            $nombrelibranza = "";
                            while($row9 = mysql_fetch_array($result9))
                            {
                                $nombrelibranza.= $row9['nomconcepto']." (".number_format($row9['descuentos'])."), ";
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
    
                            $vsql99 = "SELECT c.nomconcepto, h.descuentos  
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')
                                              AND h.terid = ".$terid."
                                              AND c.conceptoid NOT IN (10,30)";
                            $conex  = $clase->Conectar();
                            $result99 = mysql_query($vsql99,$conex);
        
                            $nombrelibranza = "";
                            while($row99 = mysql_fetch_array($result99))
                            {
                                $nombrelibranza.= $row99['nomconcepto']." (".number_format($row99['descuentos'])."), ";
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
                        }
    
                        if(($numlibranzas==0)&&($numlibranzasliq>0))
                        {
                            $vsql83 = "SELECT SUM(h.descuentos) AS montolibranza
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')
                                              AND h.terid = ".$terid;
                            $montolibranza = $clase->SeleccionarUno($vsql83);
    
                            $vsql99 = "SELECT c.nomconcepto, h.descuentos  
                                         FROM detalleliquidacion h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                              AND h.terid = ".$terid."
                                              AND c.conceptoid NOT IN (10,30)";
                            $conex  = $clase->Conectar();
                            $result99 = mysql_query($vsql99,$conex);
        
                            $nombrelibranza = "";
                            while($row99 = mysql_fetch_array($result99))
                            {
                                $nombrelibranza.= $row99['nomconcepto']." (".number_format($row99['descuentos'])."), ";
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
                        }
    
                        if(($numlibranzas>0)&&($numlibranzasliq==0))
                        {
                            $vsql82 = "SELECT SUM(h.descuentos) AS montolibranza
                                         FROM hisdetallenomina h
                                              INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                        WHERE h.pernominaid IN ($listaperiodos)
                                              AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                              AND h.terid = ".$terid."
                                              AND c.conceptoid NOT IN (10,30)
                                              AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros
                                                                         WHERE terid = ".$terid." 
                                                                               AND pernominaid IN ($listaperiodos)
                                                                               AND extralegal = 'CHECKED')";
                            $montolibranza = $clase->SeleccionarUno($vsql82);
    
                            $vsql9 = "SELECT c.nomconcepto, h.descuentos  
                                        FROM hisdetallenomina h
                                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                       WHERE h.pernominaid IN ($listaperiodos)
                                             AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')                                            
                                             AND h.terid = ".$terid."
                                             AND c.conceptoid NOT IN (10,30)
                                             AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                         FROM periodoterceros
                                                                        WHERE terid = ".$terid." 
                                                                              AND pernominaid IN ($listaperiodos)
                                                                              AND extralegal = 'CHECKED')";
                            $conex  = $clase->Conectar();
                            $result9 = mysql_query($vsql9,$conex);
        
                            $nombrelibranza = "";
                            while($row9 = mysql_fetch_array($result9))
                            {
                                $nombrelibranza.= $row9['nomconcepto']." (".number_format($row9['descuentos'])."), ";
                            }
                            $nombrelibranza = substr($nombrelibranza, 0, -2);
                        }
    
                        if(($numlibranzas==0)&&($numlibranzasliq==0))
                        {
                            $nombrelibranza = "NINGUNA";
                            $montolibranza = 0;
                        }
        
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda36, $nombrelibranza)
                                    ->setCellValue($celda37, number_format($montolibranza));
    
                        // primas
                        if($numprimas>0)
                        {
                            // Días de la prima
                            $vsqlcanprimas = "SELECT cantidad AS canprimas
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'primas'";
                            $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                            // Pago de la prima
                            $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                                 FROM liquidacion
                                                WHERE terid = ".$terid."
                                                      AND periodonomina = '".$codperiodo."' 
                                                      AND tipo = 'primas'";
                            $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);
    
                            $devengados += $pagoprimas;
                        }
                        else
                        {
                            $canprimas = 0;
                            $pagoprimas = 0;
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda38, number_format($canprimas))
                                    ->setCellValue($celda39, number_format($pagoprimas));
    
                        // Cesantías
                        if($numcesantias>0)
                        {
                            // Pago de la cesantía
                            $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);
    
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia += $montopagocesan;
                            }
    
                            // Porcentaje cesantía
                            $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'cesantias'";
                            $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);
    
                            // Pago de intereses de cesantías
                            $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'cesantias'";
                            $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);
    
                            $devengados += $pagocesantia;
                            $devengados += $pagointereses;
                        }
                        else
                        {
                            // Pagos del fondo de cesantías
                            $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                            if($numpagocesan>0)
                            {
                                $vsqlnumpagocesan = "";
                                $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                       FROM pagocesantias
                                                      WHERE terid = ".$terid."
                                                            AND periodonomina = '".$codperiodo."'";
                                $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                                $pagocesantia = $montopagocesan;
                                $devengados += $pagocesantia;
                            }
                            else
                                $pagocesantia = 0;
                            
                            $porccesantia = 0;
                            $pagointereses = 0;
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda40, number_format($pagocesantia))
                                    ->setCellValue($celda41, number_format($porccesantia))
                                    ->setCellValue($celda42, number_format($pagointereses));
    
                        // vacaciones
                        if($numvacacionest>0)
                        {
                            if($numvacaciones1 > 0)
                            {
                                // Días de vacaciones
                                $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                        FROM liquidacion
                                                       WHERE terid = ".$terid."
                                                             AND periodonomina = '".$codperiodo."' 
                                                             AND tipo = 'vacaciones'";
                                $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                                // Pago de vacaciones
                                $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                                   FROM liquidacion
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'vacaciones'";
                                $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                            }
                            else
                            {
                                $canvacaciones = 0;
                                $pagovaca1 = 0;
                            }

                            if($numvacaciones2>0)
                            {
                                $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                    FROM hisdetallenomina  
                                                   WHERE terid = ".$terid."
                                                         AND conceptoid = 38 
                                                         AND pernominaid IN ($listaperiodos)";
                                $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                            }
                            else
                                $pagovaca2 = 0;
                            
                            if($canvacaciones == 0)               $canvacaciones = 1;
                            $pagovaca = $pagovaca1 + $pagovaca2;
                            $devengados += $pagovaca1;
                        }
                        else
                        {
                            $canvacaciones = 0;
                            $pagovaca = 0;
                        }
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda43, number_format($canvacaciones,2))
                                    ->setCellValue($celda44, number_format($pagovaca));
    
                        // indemnización
                        if($numindemnizacion>0)
                        {
                            $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'indemnizacion'";
                            $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                            $devengados += $indemnizacion;
                        }
                        else
                            $indemnizacion = 0;
    
                        $objPHPExcel->setActiveSheetIndex(0)                                    
                                    ->setCellValue($celda45, number_format($indemnizacion));
    
                        // otros devengados
                        if($numotrosdevenliq>0)
                        {
                            $vsqlotrosdeven = "SELECT SUM(IF(h.conceptoid = 37,h.devengados,0)) AS otrosdeven
                                                 FROM detalleliquidacion h
                                                      INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                                WHERE h.pernominaid IN ($listaperiodos)
                                                      AND h.terid = ".$terid;
                            $otrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
    
                            $devengados += $otrosdeven;
                        }
                        else
                            $otrosdeven = 0;
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda46, number_format($otrosdeven));
    
                        // dotaciones
                        if(strlen($montodotacion)>0)
                        {
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AU'.$i, number_format($montodotacion));
                            $devengados += $montodotacion;
                        }
                        else
                            $objPHPExcel->setActiveSheetIndex(0)
                                        ->setCellValue('AU'.$i, 0);
    
                        $neto = $devengados - $descuentos;
    
                        // cune del empleado
                        $vsqlcune = "SELECT d.cune AS cune
                                       FROM dianterceros d 
                                            INNER JOIN periododian p ON (d.periodonomina = p.periododiamid)
                                      WHERE p.periodonomina = '".$codperiodo."'
                                            AND d.terid = ".$terid;
                        $cune = $clase->SeleccionarUno($vsqlcune);

                        // Totales
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda48, number_format($devengados))
                                    ->setCellValue($celda49, number_format($descuentos))
                                    ->setCellValue($celda50, number_format($neto))
                                    ->setCellValue($celda51, $cune);
    
                        // Incremento el contador de líneas
                        $k++;
                        $listadereportados.= $terid.",";
                    }
                }
            }

            $listadereportados = substr($listadereportados, 0, -1);

            $rangoEncabezado = 'A9:AK9';
            $rangoCeldas     = 'A9:AK'.($k-1);
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Ciclo para los empleados que no trabajaron ninguna quincena y tienen una liquidación

        $vsqlsololiquidacion = "SELECT DISTINCT terid
                                  FROM liquidacion 
                                 WHERE periodonomina = '".$codperiodo."'
                                       AND terid NOT IN (SELECT terid
                                                           FROM detalleliquidacion 
                                                          WHERE pernominaid IN ($listaperiodos))";

        if(strlen($listadereportados)>0)            $vsqlsololiquidacion.= " AND terid NOT IN ($listadereportados)";

        if(strlen($nodebensalir) > 0)
            $vsqlsololiquidacion.= " AND terid NOT IN ($nodebensalir) ";        

        $l = $k;
        $conex  = $clase->Conectar();
        $resultsololiq = mysql_query($vsqlsololiquidacion,$conex);
        $empleadossololiq = mysql_num_rows($resultsololiq);

        if($empleadossololiq > 0)
        {
            // Inicialización de variables
            $consecutivo = 0;                               $dni = "";                                      $primerapellido = "";
            $segundoapellido = "";                          $primernombre = "";                             $segundonombre = "";
            $basico = 0;                                    $codvende = "";                                 $email = "";
            $telmovil = "";                                 $numcuenta = "";                                $tipodoc = "";
            $vsqlbanco = "";                                $banco = "";                                    $vsqldias = "";
            $diastrab = 0;                                  $vsqltrasp = "";                                $auxtransp = 0;
            $vsqldev = "";                                  $devengados = 0;                                $vsqldesc = "";
            $descuentos = 0;                                $vsqlembg = "";                                 $embargo = 0;
            $vsqlsalud = "";                                $salud = 0;                                     $por_sal_tra = 0;
            $vsqlpension = "";                              $pension = 0;                                   $por_pen_tra = 0;
            $neto = 0;                                      $fecingreso = "";                               $vsqlincapacidad = "";
            $numincap = 0;                                  $vsqlcantincap = "";                            $diasincap = 0;
            $feciniincap = "";                              $fecfinincap = "";                              $vsqlpagoincap = "";
            $pagoincap = 0;                                 $fechaAct = date("Y-m-d");                      $horaAct = date("H:i:s");
            $por_sal_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_SAL_TRA'");
            $por_sal_tra = $por_sal_tra * 100;
            $por_pen_tra = $clase->SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab='N_POR_PEN_TRA'");
            $por_pen_tra = $por_pen_tra * 100;
            $newconsecutivo = "";                           $vsqlsanciones = "";                            $numsanciones = 0;
            $prefijo = "";                                  $vsqlnumcuenta = "";
            $celda1="";                                     $celda2="";                                     $celda3="";
            $celda4="";                                     $celda5="";                                     $celda6="";
            $celda7="";                                     $celda8="";                                     $celda9="";
            $celda10="";                                    $celda11="";                                    $celda12="";
            $celda13="";                                    $celda14="";                                    $celda15="";
            $celda16="";                                    $celda17="";                                    $celda18="";
            $celda19="";                                    $celda20="";                                    $celda21="";
            $celda22="";                                    $celda23="";                                    $celda24="";
            $celda25="";                                    $celda26="";                                    $celda27="";
            $celda28="";                                    $celda29="";                                    $celda30="";
            $celda31="";                                    $celda32="";                                    $celda33="";
            $celda34="";                                    $celda35="";                                    $celda36="";
            $celda37="";                                    $celda38="";                                    $celda39="";
            $celda40="";                                    $celda41="";                                    $celda42="";
            $celda43="";                                    $celda44="";                                    $celda45="";
            $celda46="";                                    $celda47="";                                    $celda48="";
            $celda49="";                                    $celda50="";                                    $vsqldotaciones = "";
            $montodotacion = 0;                             $vsqlnumpagocesan = "";                         $numpagocesan = 0;
            $montopagocesan = 0;                            $listadereportados.= ",";                       $vsqlvextralegal = "";
            $numnomext = 0;                                 $vsqlnumvacaciones2 = "";                       $numvacaciones2 = 0;
            $vsqlpagovaca2 = "";                            $pagovaca2 = 0;                                 $celda51="";
            $cune = "";                                     $vsqlcune = "";

            while($rowsololiq = mysql_fetch_array($resultsololiq))
            {
                // id del empleado
                $terid = $rowsololiq['terid'];

                // Validación de que el empleado no estuvo en condición de extralegal en ambas quincenas
                $vsqlvextralegal = "SELECT COUNT(*) AS numnomext
                                      FROM periodoterceros 
                                     WHERE terid = ".$terid." 
                                           AND pernominaid IN ($listaperiodos) 
                                           AND extralegal = 'CHECKED'";
                $numnomext = $clase->SeleccionarUno($vsqlvextralegal);
                
                if($numnomext<2)
                {
                    // Documento del empleado
                    $dni = $clase->BDLockup($terid,'terceros','terid','dni');
    
                    // Primer apellido
                    $primerapellido = $clase->BDLockup($terid,'terceros','terid','primerapellido');
    
                    // Segundo apellido
                    $segundoapellido = $clase->BDLockup($terid,'terceros','terid','segundoapellido');
    
                    // Primer nombre
                    $primernombre = $clase->BDLockup($terid,'terceros','terid','primernombre');
    
                    // Segundo nombre
                    $segundonombre = $clase->BDLockup($terid,'terceros','terid','segundonombre');
    
                    // Sueldo básico
                    $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                    // Código del trabajador
                    $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');
    
                    // Correo electrónico
                    $email = $clase->BDLockup($terid,'terceros','terid','email');
    
                    // Teléfono
                    $telmovil = $clase->BDLockup($terid,'terceros','terid','telmovil');
    
                    // Número de cuenta
                    $numcuenta = $clase->BDLockup($terid,'terceros','terid','numcuenta');
    
                    // Tipo de documento
                    $tipodoc = $clase->BDLockup($terid,'terceros','terid','tipodoc');
    
                    // Banco
                    $vsqlbanco = "SELECT b.descripcion AS banco
                                    FROM periodoterceros p
                                         INNER JOIN bancos b ON (p.bancoid = b.bancoid) 
                                   WHERE p.terid = ".$terid;
                    $banco = $clase->SeleccionarUno($vsqlbanco);
                    $banco = trim(str_replace("BANCO ","",$banco));
    
                    // cargo del empleado
                    $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
    
                    $sueldoper = 0;                     $auxtransp = 0;                 $embargo = 0;
                    $salud = 0;                         $pension = 0;                   $devengados = 0;
                    $descuentos = 0;
    
                    // Obtengo la fecha de ingreso del empleado
                    $fecingreso =  $clase->BDLockup($terid,'terceros','terid','fecingreso');
    
                    $numincap = 0;                      $numlicencias = 0;                      $numlibranzas = 0;
                    $numlibranzasliq = 0;               $numsanciones = 0;                      $numotrasded = 0;
                    $numotrasdedliq = 0;
    
                    // Vacaciones
                    $vsqlnumvacaciones = "SELECT COUNT(idliquidacion) AS numvacaciones1
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'vacaciones'";
                    $numvacaciones1 = $clase->SeleccionarUno($vsqlnumvacaciones);

                    // Vacaciones pagadas en quincenas
                    $vsqlnumvacaciones2 = "SELECT COUNT(detalleid) AS numvacaciones2
                                             FROM hisdetallenomina 
                                            WHERE terid = ".$terid."
                                                  AND conceptoid = 38 
                                                  AND pernominaid IN ($listaperiodos)";
                    $numvacaciones2 = $clase->SeleccionarUno($vsqlnumvacaciones2);

                    $numvacacionest = $numvacaciones1 + $numvacaciones2;
    
                    // Primas
                    $vsqlnumprimas = "SELECT COUNT(idliquidacion) AS numprimas
                                        FROM liquidacion
                                       WHERE terid = ".$terid."
                                             AND periodonomina = '".$codperiodo."' 
                                             AND tipo = 'primas'";
                    $numprimas = $clase->SeleccionarUno($vsqlnumprimas);
    
                    // Cesantías
                    $vsqlnumcesantias = "SELECT COUNT(idliquidacion) AS numcesantias
                                           FROM liquidacion
                                          WHERE terid = ".$terid."
                                                AND periodonomina = '".$codperiodo."' 
                                                AND tipo = 'cesantias'";
                    $numcesantias = $clase->SeleccionarUno($vsqlnumcesantias);
    
                    // Indemnización
                    $vsqlindemnizacion = "SELECT COUNT(idliquidacion) AS numindemnizacion
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'indemnizacion'";
                    $numindemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                    $numotrosdevenliq = 0;
                    $numotrosdeven = 0;
    
                    // Dotaciones 
                    $vsqldotaciones = "SELECT IFNULL(monto,0) AS montodotacion
                                         FROM dotaciones
                                        WHERE periodonomina = '".$codperiodo."'
                                              AND terid = ".$terid."";
                    $montodotacion = $clase->SeleccionarUno($vsqldotaciones);
    
                    $celda1="A".strval($l);         $celda2="B".strval($l);         $celda3="C".strval($l);         $celda4="D".strval($l);         $celda5="E".strval($l);
                    $celda6="F".strval($l);         $celda7="G".strval($l);         $celda8="H".strval($l);         $celda9="I".strval($l);         $celda10="J".strval($l);
                    $celda11="K".strval($l);        $celda12="L".strval($l);        $celda13="M".strval($l);        $celda14="N".strval($l);        $celda15="O".strval($l);
                    $celda16="P".strval($l);        $celda17="Q".strval($l);        $celda18="R".strval($l);        $celda19="S".strval($l);        $celda20="T".strval($l);
                    $celda21="U".strval($l);        $celda22="V".strval($l);        $celda23="W".strval($l);        $celda24="X".strval($l);        $celda25="Y".strval($l);
                    $celda26="Z".strval($l);        $celda27="AA".strval($l);       $celda28="AB".strval($l);       $celda29="AC".strval($l);       $celda30="AD".strval($l);
                    $celda31="AE".strval($l);       $celda32="AF".strval($l);       $celda33="AG".strval($l);       $celda34="AH".strval($l);       $celda35="AI".strval($l);
                    $celda36="AJ".strval($l);       $celda37="AK".strval($l);       $celda38="AL".strval($l);       $celda39="AM".strval($l);       $celda40="AN".strval($l);
                    $celda41="AO".strval($l);       $celda42="AP".strval($l);       $celda43="AQ".strval($l);       $celda44="AR".strval($l);       $celda45="AS".strval($l);
                    $celda46="AT".strval($l);       $celda47="AU".strval($l);       $celda48="AV".strval($l);       $celda49="AW".strval($l);       $celda50="AX".strval($l);
                    $celda51="AY".strval($l);
    
                    // Escribo en la hoja de Excel
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda1, $fecingreso)
                                ->setCellValue($celda2, '01')
                                ->setCellValue($celda3, '00')
                                ->setCellValue($celda4, 'true')
                                ->setCellValue($celda5,'13')
                                ->setCellValue($celda6, $dni)
                                ->setCellValue($celda7, $primerapellido)
                                ->setCellValue($celda8, $segundoapellido)
                                ->setCellValue($celda9, $primernombre)
                                ->setCellValue($celda10, $segundonombre)
                                ->setCellValue($celda11, number_format($basico))
                                ->setCellValue($celda12, $codvende)
                                ->setCellValue($celda13, '1');
    
                    // Identifico la forma de pago
                    if($numcuenta!="")
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda14, '45')
                                    ->setCellValue($celda15, $banco)
                                    ->setCellValue($celda16, 'AHORROS')
                                    ->setCellValue($celda17, $numcuenta);
                    }
                    else
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda14, '10')
                                    ->setCellValue($celda15, 'NINGUNO')
                                    ->setCellValue($celda16, 'NINGUNO')
                                    ->setCellValue($celda17, 'NINGUNA');
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda18, $diastrab)
                                ->setCellValue($celda19, number_format(intval($sueldoper)))
                                ->setCellValue($celda20, number_format(intval($auxtransp)));
    
                    // Incluyo las incapacidades
                    if($numincap>0)
                    {
                        // Días de la(s) incapacidad(es)
                        $vsql5 = "SELECT valor
                                    FROM hisdetallenomina 
                                   WHERE pernominaid IN ($listaperiodos) 
                                         AND conceptoid IN (10,43,40)
                                         AND terid = ".$terid."
                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                   FROM periodoterceros
                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                        AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                        AND periodoterceros.extralegal = 'CHECKED')";
                        $valorinc = $clase->SeleccionarUno($vsql5);
    
                        // Monto de la(s) incapacidad(es)
                        $vsql6 = "SELECT devengados
                                    FROM hisdetallenomina 
                                   WHERE pernominaid IN ($listaperiodos) 
                                         AND conceptoid IN (10,40) 
                                         AND terid = ".$terid."
                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                   FROM periodoterceros
                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                        AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                        AND periodoterceros.extralegal = 'CHECKED')";
    
                        // --------------------------------------------------------------------------------------- //
                        $vsql105 = "SELECT c.nomconcepto AS nombreincapacidad
                                      FROM hisdetallenomina h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid IN ($listaperiodos) 
                                           AND c.conceptoid IN (10,43,40)
                                           AND h.terid = ".$terid."
                                           AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND pernominaid IN ($listaperiodos)
                                                                            AND extralegal ='CHECKED')
                                    UNION 
                                    SELECT c.nomconcepto AS nombreincapacidad
                                      FROM detalleliquidacion h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid IN ($listaperiodos) 
                                           AND c.conceptoid IN (10,43,40)
                                           AND h.terid = ".$terid."";
                        $conex  = $clase->Conectar();
                        $result105 = mysql_query($vsql105,$conex);

                        $nombreincapacidad = "";
                        while($row105 = mysql_fetch_array($result105))
                        {                            
                            $nombreincapacidad.= $row105['nombreincapacidad'].", ";
                        }
                        $nombreincapacidad = substr($nombreincapacidad, 0, -2);
                        // --------------------------------------------------------------------------------------- //
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda21, $valorinc)
                                    ->setCellValue($celda22, $nombreincapacidad)
                                    ->setCellValue($celda23, number_format($devengadosinc));
                    }
                    else
                    {
                        $valorinc = 0;
                        $devengadosinc = 0;
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda21, $valorinc)
                                    ->setCellValue($celda22, 'NINGUNA')
                                    ->setCellValue($celda23, number_format($devengadosinc));
                    }
    
                    // Incluyo las licencias
                    if($numlicencias>0)
                    {
                        // Días de la(s) licencia(s)
                        $vsql3 = "SELECT SUM(h.valor) AS valorlic
                                    FROM hisdetallenomina h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND c.eslicencia = 'CHECKED' 
                                         AND c.tipodc = 'C' 
                                         AND h.conceptoid NOT IN (10,9,43,40,58) 
                                         AND h.terid = ".$terid."
                                         AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                          AND periodoterceros.extralegal = 'CHECKED')";
                        $valorlic = $clase->SeleccionarUno($vsql3);

                        // -------------------------------------------------------------------------------------------------- //
                        $vsqllicnoremuneradas = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem
                                                   FROM hisdetallenomina 
                                                  WHERE pernominaid IN ($listaperiodos)
                                                        AND conceptoid = 6
                                                        AND terid = ".$terid."
                                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                                       AND periodoterceros.extralegal ='CHECKED')";
                        $valorlicnorem = $clase->SeleccionarUno($vsqllicnoremuneradas);

                        $valorlic += $valorlicnorem;

                        // -------------------------------------------------------------------------------------------------- //
                        $vsql32 = "SELECT IFNULL(SUM(h.valor),0) AS valorlic
                                     FROM detalleliquidacion h 
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND c.eslicencia = 'CHECKED' 
                                          AND c.tipodc = 'C' 
                                          AND h.conceptoid NOT IN (10,9,43,40,58)                                          
                                          AND h.terid = ".$terid."
                                         AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                          AND periodoterceros.extralegal ='CHECKED')";
                        $valorlic2 = $clase->SeleccionarUno($vsql32);

                        // -------------------------------------------------------------------------------------------------- //
                        $vsqllicnoremuneradas2 = "SELECT IFNULL(SUM(valor),0) AS valorlicnorem2
                                                    FROM detalleliquidacion 
                                                   WHERE pernominaid IN ($listaperiodos)
                                                         AND conceptoid = 6
                                                         AND terid = ".$terid."
                                                         AND pernominaid NOT IN (SELECT pernominaid 
                                                                                   FROM periodoterceros
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND pernominaid IN ($listaperiodos)
                                                                                        AND extralegal ='CHECKED')";
                        $valorlicnorem2 = $clase->SeleccionarUno($vsqllicnoremuneradas2);

                        $valorlic2 += $valorlicnorem2;
                        // -------------------------------------------------------------------------------------------------- //

                        $valorlic += $valorlic2;                        
    
                        // Monto de la(s) licencia(s)
                        $vsql4 = "SELECT SUM(h.devengados) AS devengadoslic 
                                    FROM detalleliquidacion h 
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid) 
                                   WHERE h.pernominaid IN ($listaperiodos) 
                                         AND c.eslicencia = 'CHECKED' 
                                         AND c.tipodc = 'C' 
                                         AND h.conceptoid NOT IN (10,9,43,40,58) 
                                         AND h.terid = ".$terid;
                        $devengadoslic = $clase->SeleccionarUno($vsql4);
    
                        // Construyo la descripción de todas las licencias en el periodo
                        $vsql10 = "SELECT c.nomconcepto AS nombrelicencia 
                                     FROM detalleliquidacion h 
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid) 
                                    WHERE h.pernominaid IN ($listaperiodos) 
                                          AND c.eslicencia ='CHECKED'  
                                          AND c.tipodc = 'C' 
                                          AND h.conceptoid NOT IN (10,9,43,40,58) 
                                          AND h.terid=".$terid."
                                   UNION
                                   SELECT IFNULL(c.nomconcepto,'') AS nombrelicencia
                                     FROM detalleliquidacion h 
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid = 6
                                          AND h.terid = ".$terid."";
                                            
                        $conex  = $clase->Conectar();
                        $result10 = mysql_query($vsql10,$conex);
    
                        $nombrelicencia = "";
                        while($row10 = mysql_fetch_array($result10))
                        {
                            $nombrelicencia.= $row10['nombrelicencia'].", ";
                        }
                        $nombrelicencia = substr($nombrelicencia, 0, -2);
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda24, $nombrelicencia)
                                    ->setCellValue($celda25, $valorlic)
                                    ->setCellValue($celda26, number_format($devengadoslic));
                    }
                    else
                    {
                        $valorlic = 0;
                        $devengadoslic = 0;
                        $nombrelicencia = "NINGUNA";
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue($celda24, $nombrelicencia)
                                    ->setCellValue($celda25, $valorlic)
                                    ->setCellValue($celda26, number_format($devengadoslic));
                    }
    
                    // Embargo
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda27, number_format($embargo));
    
                    // otras deducciones
                    if(($numotrasded>0)&&($numotrasdedliq>0))
                    {
                        // Monto de las otras deducciones
                        $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41)
                                               AND h.terid = ".$terid;
                        $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                        $vsqlmontood2 = "SELECT SUM(h.descuentos) as montootrasdeduc2
                                           FROM hisdetallenomina h
                                                INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                          WHERE h.pernominaid IN ($listaperiodos)
                                            AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                            AND h.terid = ".$terid."
                                            AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                        FROM periodoterceros
                                                                       WHERE periodoterceros.terid = ".$terid." 
                                                                             AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                             AND periodoterceros.extralegal = 'CHECKED')";
                        $montootrasdeduc2 = $clase->SeleccionarUno($vsqlmontood);
                        $montootrasdeduc += $montootrasdeduc2;
    
                        // Consulta con los datos que se incluirán en el json
                        $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                    FROM hisdetallenomina h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                         AND h.terid = ".$terid."
                                         AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                     FROM periodoterceros
                                                                    WHERE periodoterceros.terid = ".$terid." 
                                                                          AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                          AND periodoterceros.extralegal = 'CHECKED')";
                        $conex  = $clase->Conectar();
                        $result7 = mysql_query($vsql7,$conex);
    
                        $nombreoc = "";
                        while($row7 = mysql_fetch_array($result7))
                        {
                            $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                        }
                        $nombreoc = substr($nombreoc, 0, -2);
    
                        $vsql77 = "SELECT c.nomconcepto, h.descuentos 
                                     FROM detalleliquidacion h
                                          INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                    WHERE h.pernominaid IN ($listaperiodos)
                                          AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                          AND h.terid = ".$terid."";    
                        $conex  = $clase->Conectar();
                        $result77 = mysql_query($vsql77,$conex);
    
                        $nombreoc = "";
                        while($row77 = mysql_fetch_array($result77))
                        {
                            $nombreoc.= $row77['nomconcepto']." (".number_format($row77['descuentos'])."), ";
                        }
                        $nombreoc = substr($nombreoc, 0, -2);
                    }
    
                    if(($numotrasded==0)&&($numotrasdedliq>0))
                    {
                        $vsqlmontood = "SELECT SUM(h.descuentos) as montootrasdeduc
                                          FROM detalleliquidacion h
                                               INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                         WHERE h.pernominaid IN ($listaperiodos)
                                               AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                               AND h.terid = ".$terid;
                        $montootrasdeduc = $clase->SeleccionarUno($vsqlmontood);
    
                        // Consulta con los datos que se incluirán en el json
                        $vsql7 = "SELECT c.nomconcepto, h.descuentos 
                                    FROM detalleliquidacion h
                                         INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                   WHERE h.pernominaid IN ($listaperiodos)
                                         AND h.conceptoid IN (8,24,25,26,28,32,33,34,35,41) 
                                         AND h.terid = ".$terid;    
                        $conex  = $clase->Conectar();
                        $result7 = mysql_query($vsql7,$conex);
                        $nombreoc = "";
                        while($row7 = mysql_fetch_array($result7))
                        {
                            $nombreoc.= $row7['nomconcepto']." (".number_format($row7['descuentos'])."), ";
                        }
                        $nombreoc = substr($nombreoc, 0, -2);
                    }
    
                    if(($numotrasded==0)&&($numotrasdedliq==0))
                    {
                        $nombreoc = "NINGUNO";
                        $montootrasdeduc = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda28, $nombreoc)
                                ->setCellValue($celda29, number_format($montootrasdeduc));
    
                    // Continuamos con salud y pensión
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda30, $por_sal_tra)
                                ->setCellValue($celda31, number_format(intval($salud)))
                                ->setCellValue($celda32, $por_pen_tra)
                                ->setCellValue($celda33, number_format(intval($pension)));
    
                    // sanciones
                    if($numsanciones>0)
                    {
                        $vsql66a = "SELECT h.descuentos AS montosancion 
                                      FROM hisdetallenomina h
                                           INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                     WHERE h.pernominaid IN ($listaperiodos)
                                           AND h.conceptoid = 9
                                           AND h.terid = ".$terid."
                                           AND h.pernominaid NOT IN (SELECT pernominaid 
                                                                       FROM periodoterceros
                                                                      WHERE periodoterceros.terid = ".$terid." 
                                                                            AND periodoterceros.pernominaid IN ($listaperiodos)
                                                                            AND periodoterceros.extralegal = 'CHECKED')";
                        $montosancion = $clase->SeleccionarUno($vsql66a);
                        $conceptosancion = "SUSPENCION";
                    }
                    else
                    {
                        $montosancion = 0;
                        $conceptosancion = "NINGUNA";
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda34, number_format($montosancion))
                                ->setCellValue($celda35, $conceptosancion);
    
                    if(($numlibranzas==0)&&($numlibranzasliq==0))
                    {
                        $nombrelibranza = "NINGUNA";
                        $montolibranza = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda36, $nombrelibranza)
                                ->setCellValue($celda37, number_format($montolibranza));
    
                    // primas
                    if($numprimas>0)
                    {
                        // Días de la prima
                        $vsqlcanprimas = "SELECT cantidad AS canprimas
                                            FROM liquidacion
                                           WHERE terid = ".$terid."
                                                 AND periodonomina = '".$codperiodo."' 
                                                 AND tipo = 'primas'";
                        $canprimas = $clase->SeleccionarUno($vsqlcanprimas);
    
                        // Pago de la prima
                        $vsqlpagoprimas = "SELECT SUM(pago) AS pagoprimas
                                             FROM liquidacion
                                            WHERE terid = ".$terid."
                                                  AND periodonomina = '".$codperiodo."' 
                                                  AND tipo = 'primas'";
                        $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);
    
                        $devengados += $pagoprimas;
                    }
                    else
                    {
                        $canprimas = 0;
                        $pagoprimas = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda38, number_format($canprimas))
                                ->setCellValue($celda39, number_format($pagoprimas));
    
                    // Cesantías
                    if($numcesantias>0)
                    {
                        // Pago de la cesantía
                        $vsqlpagocesantia = "SELECT pago AS pagocesantia
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);
    
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        if($numpagocesan>0)
                        {
                            $vsqlnumpagocesan = "";
                            $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                            $pagocesantia += $montopagocesan;
                        }
    
                        // Porcentaje cesantía
                        $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'cesantias'";
                        $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);
    
                        // Pago de intereses de cesantías
                        $vsqlpagointereses = "SELECT IFNULL(SUM(pagointereses),0) AS pagointereses
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'cesantias'";
                        $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);
    
                        $devengados += $pagocesantia;
                        $devengados += $pagointereses;
                    }
                    else
                    {
                        // Pagos del fondo de cesantías
                        $vsqlnumpagocesan = "SELECT COUNT(idpagocesantia) AS numpagocesan
                                               FROM pagocesantias
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."'";
                        $numpagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
    
                        if($numpagocesan>0)
                        {
                            $vsqlnumpagocesan = "";
                            $vsqlnumpagocesan = "SELECT monto AS montopagocesan
                                                   FROM pagocesantias
                                                  WHERE terid = ".$terid."
                                                        AND periodonomina = '".$codperiodo."'";
                            $montopagocesan = $clase->SeleccionarUno($vsqlnumpagocesan);
                            $pagocesantia = $montopagocesan;
                            $devengados += $pagocesantia;
                        }
                        else
                            $pagocesantia = 0;
                        
                        $porccesantia = 0;
                        $pagointereses = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda40, number_format($pagocesantia))
                                ->setCellValue($celda41, number_format($porccesantia))
                                ->setCellValue($celda42, number_format($pagointereses));
    
                    // vacaciones
                    if($numvacacionest>0)
                    {
                        if($numvacaciones1 > 0)
                        {
                            // Días de vacaciones
                            $vsqlcanvacaciones = "SELECT IFNULL(cantidad,0) AS canvacaciones
                                                    FROM liquidacion
                                                   WHERE terid = ".$terid."
                                                         AND periodonomina = '".$codperiodo."' 
                                                         AND tipo = 'vacaciones'";
                            $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

                            // Pago de vacaciones
                            $vsqlpagovaca = "SELECT IFNULL(pago,0) AS pagovaca
                                               FROM liquidacion
                                              WHERE terid = ".$terid."
                                                    AND periodonomina = '".$codperiodo."' 
                                                    AND tipo = 'vacaciones'";
                            $pagovaca1 = $clase->SeleccionarUno($vsqlpagovaca);
                        }
                        else
                        {
                            $canvacaciones = 0;
                            $pagovaca1 = 0;
                        }

                        if($numvacaciones2>0)
                        {
                            $vsqlpagovaca2 = "SELECT IFNULL(SUM(devengados),0) AS pagovaca2
                                                FROM hisdetallenomina  
                                               WHERE terid = ".$terid."
                                                     AND conceptoid = 38 
                                                     AND pernominaid IN ($listaperiodos)";
                            $pagovaca2 = $clase->SeleccionarUno($vsqlpagovaca2);
                        }
                        else
                            $pagovaca2 = 0;
                        
                        if($canvacaciones == 0)               $canvacaciones = 1;
                        $pagovaca = $pagovaca1 + $pagovaca2;
                        $devengados += $pagovaca1;
                    }
                    else
                    {
                        $canvacaciones = 0;
                        $pagovaca = 0;
                    }
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda43, number_format($canvacaciones,2))
                                ->setCellValue($celda44, number_format($pagovaca));
    
                    // indemnización
                    if($numindemnizacion>0)
                    {
                        $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                                FROM liquidacion
                                               WHERE terid = ".$terid."
                                                     AND periodonomina = '".$codperiodo."' 
                                                     AND tipo = 'indemnizacion'";
                        $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);
    
                        $devengados += $indemnizacion;
                    }
                    else
                        $indemnizacion = 0;
    
                    $objPHPExcel->setActiveSheetIndex(0)                                    
                                ->setCellValue($celda45, number_format($indemnizacion));
    
                    // otros devengados
                    if($numotrosdevenliq>0)
                    {
                        $vsqlotrosdeven = "SELECT SUM(IF(h.conceptoid = 37,h.devengados,0)) AS otrosdeven
                                             FROM detalleliquidacion h
                                                  INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                                            WHERE h.pernominaid IN ($listaperiodos) 
                                                  AND h.terid = ".$terid;
                        $otrosdeven = $clase->SeleccionarUno($vsqlotrosdeven);
    
                        $devengados += $otrosdeven;
                    }
                    else
                        $otrosdeven = 0;
    
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda46, number_format($otrosdeven));
    
                    // dotaciones
                    if(strlen($montodotacion)>0)
                    {
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AU'.$i, number_format($montodotacion));
                        $devengados += $montodotacion;
                    }
                    else
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('AU'.$i, 0);
    
                    $neto = $devengados - $descuentos;

                    // cune del empleado
                    $vsqlcune = "SELECT d.cune AS cune
                                   FROM dianterceros d 
                                        INNER JOIN periododian p ON (d.periodonomina = p.periododiamid)
                                  WHERE p.periodonomina = '".$codperiodo."'
                                        AND d.terid = ".$terid;
                    $cune = $clase->SeleccionarUno($vsqlcune);
    
                    // Totales
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue($celda48, number_format($devengados))
                                ->setCellValue($celda49, number_format($descuentos))
                                ->setCellValue($celda50, number_format($neto))
                                ->setCellValue($celda51, $cune);
    
                    // Incremento el contador de líneas
                    $l++;
                    $listadereportados.= $terid.",";
                }
            }

            $listadereportados = substr($listadereportados, 0, -1);

            $rangoEncabezado = 'A9:AK9';
            $rangoCeldas     = 'A9:AK'.($l-1);
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('nómina electrónica');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // ----------------------------------------------------------------------- //
        $nombrearcexcel = "nómina electrónica ".strtolower($desperiodo).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // ----------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
        
        if(($empleadosreportar>0)||($empleadosreportarliq>0)||($empleadoscambiados>0))
            $clase->Aviso(1,"La hoja de Excel se generó exitosamente");
        else
            $clase->Aviso(3,"No se generó la hoja de Excel");
        
        header("Location: principal.php?");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanarecibosxempleado
    // Creación: 22/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para los filtros del informe
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanarecibosxempleado")
    {
        // configuración de combos
        $params = ' class="Texto11" ';

        // consulta para los combos de los periodos
        $vsqlcomboperiodo  = "SELECT periodoid, descripcion 
                                FROM periodosnomina 
                               WHERE cerrado = 'CHECKED' AND calculado = 'CHECKED' 
                            ORDER BY periodoid ASC";

        // consulta para el combo de empleados
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                                AND basico > 0 
                       ORDER BY primernombre";

        // variables para los combos
        $vsqlcomboempleados = $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,500);
        $vsqlcomboperiodoincial = $clase->CrearComboBuscar("perinicial",$vsqlcomboperiodo,"descripcion","periodoid","","N",$params,330);
        $vsqlcomboperiodofinal = $clase->CrearComboBuscar("perfinal",$vsqlcomboperiodo,"descripcion","periodoid","","N",$params,330);

        // pinto la ventana
        $cont = $clase->Header("S","W");

        // encabezado
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/pdf.png" width="32" height="32" border="0"> </td> 
                  <td width="840"> <b> Recibos de pago por empleado entre periodos </b> </td>
                  <td width="50" align="center"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td> 
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // filtros para generar los recibos
        $cont.='<form action="?opcion=generarrecibosxempleados" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="220"> &nbsp; </td>
                  <td width="100"> Empleado: </td>
                  <td width="120"> '.$vsqlcomboempleados.' </td> 
                  <td width="140"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp; </td>
                  <td width="100"> Periodo incial: </td>
                  <td width="120"> '.$vsqlcomboperiodoincial.' </td> 
                  <td width="140"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp; </td>
                  <td width="100"> Periodo final: </td>
                  <td width="120"> '.$vsqlcomboperiodofinal.' </td> 
                  <td width="140"> &nbsp; </td>
                 </tr>
                </table>';

        // botón de aceptar
        $cont.='<table width="100%">
                 <tr class="BarraDocumentos"> 
                  <td width="260"> &nbsp; </td> 
                  <td width="100" alling="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';

        // pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: generarrecibosxempleados
    // Creación: 22/01/2024		última modificación: 04/12/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera los recibos de pago de un empleado en un rango de 
    //              periodos
    // Última modificación: Recepción de parámetros por GET en caso de no llegar por POST y 
    //                      optimización de la impresión excluyendo la sección y subiendo 
    //                      el resto de los datos (28/06/2024)
    //                      Sustitución de la consulta del detalle del recibo con la 
    //                      agrupación por concepto 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "generarrecibosxempleados")
    {
        $terid = $_POST['terid'];
        $perinicial = $_POST['perinicial'];
        $perfinal = $_POST['perfinal'];

        if(strlen($terid) == 0)
            $terid = $_GET['terid'];

        if(strlen($perinicial) == 0)
            $perinicial = $_GET['perinicial'];

        if(strlen($perfinal) == 0)
            $perfinal = $_GET['perfinal'];

        // validación de los periodos
        if($perinicial >= $perfinal)
        {
            $clase->Aviso(3,"El periodo inicial debe ser menor al periodo final");
            header("Location: informesnomina.php?opcion=ventanarecibosxempleado");
        }
        else
        {
            $clase = new Sistema();
            ini_set("memory_limit","200M");
            require('lib/fpdf/fpdf.php');
            $pdf=new FPDF();
    
            // Consulta para periodos del empleado seleccionado
            $vsql = "SELECT t.pernominaid, t.terid, t.codvende, t.dni, nombre, 
                            t.basico, t.fecingreso, c.descripcioncargo, s.descripcionsec, t.extralegal, b.descripcion, t.numcuenta, e.descripcioneps, 
                            p.descripcionafp, a.descripcionarea
                       FROM periodoterceros t
                            INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                            INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                            INNER JOIN bancos b ON (t.bancoid = b.bancoid)
                            INNER JOIN eps e ON (t.epsid = e.epsid) 
                            INNER JOIN pensiones p ON (t.pensionesid = p.pensionesid)  
                            INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                      WHERE t.terid = ".$terid ." AND t.extralegal <> 'CHECKED' 
                            AND t.pernominaid BETWEEN ".$perinicial." AND ".$perfinal." 
                   ORDER BY t.pernominaid";
            
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant   = @mysql_num_rows($result);

            // Valido que exista información en el rango de periodos
            if($cant == 0)
            {
                $vsql61 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
                $nombreempneg = $clase->SeleccionarUno($vsql61);

                $clase->Aviso(3,"$nombreempneg no laboró en el rango de los periodos seleccionados");
                header("Location: informesnomina.php?opcion=ventanarecibosxempleado");
            }
            else
            {
                // Traducción al español del mes que devuelve la función date()
                $mesimp = date('F');
                if($mesimp=="January")       $mesimp = "Enero";
                if($mesimp=="February")      $mesimp = "Febrero";
                if($mesimp=="March")         $mesimp = "Marzo";
                if($mesimp=="April")         $mesimp = "Abril";
                if($mesimp=="May")           $mesimp = "Mayo";
                if($mesimp=="June")          $mesimp = "Junio";
                if($mesimp=="July")          $mesimp = "Julio";
                if($mesimp=="August")        $mesimp = "Agosto";
                if($mesimp=="September")     $mesimp = "Septiembre";
                if($mesimp=="October")       $mesimp = "Octubre";
                if($mesimp=="November")      $mesimp = "Noviembre";
                if($mesimp=="December")      $mesimp = "Diciembre";

                // Inicializo las variables
                $vsqldatos = "";                    $codvende = "";             $nombreemp = "";                $documento = "";                    $pagina = 0;
                $cargo = "";                        $basico = 0;                $seccion = "";                  $fecingreso = "";                   $area = "";
                $banco = "";                        $lineatotales = 0;          $epsid = 0;                     $eps = "";                          $nomconcepto = "";
                $pensiones = "";                    $longitud = 0;              $fechoraimp = "";               $mesimp = "";                       $extralegal = "";
                $cant = 0;                          $nombreempneg = "";         $descripcionper = "";           $periodoid = 0;                     $numreg = 0;
                $i = 0;

                while($row = mysql_fetch_array($result))
                {
                    $periodoid = $row['pernominaid'];

                    // Validación que tenga registros en el periodo actual
                    $vsql5 = "SELECT COUNT(*) AS numreg 
                                FROM hisdetallenomina 
                               WHERE pernominaid = ".$periodoid." 
                                     AND terid = ".$terid;
                    $numreg = $clase->SeleccionarUno($vsql5);

                    if($numreg>0)
                    {
                        // nombre del periodos
                        $descripcionper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
                        $codvende = $row['codvende'];                               // El código del empleado
                        $nombreemp = $row['nombre'];                                // El nombre del empleado
                        $documento = $row['dni'];                                   // Documento
                        $cargo = $row['descripcioncargo'];                          // El cargo
                        $basico = $row['basico'];                                   // sueldo básico
                        $seccion = $row['descripcionsec'];                          // La sección
        
                        $fecingreso = $row['fecingreso'];                           // Fecha de ingreso
                        $fecingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
            
                        // Determino si el empleado es de condición extralegal
                        $extralegal = $row['extralegal'];
            
                        if($extralegal=="CHECKED")
                            $area = "EXTRALEGALES";
                        else
                            $area = $row['descripcionarea'];
            
                        $banco = $row['descripcion'];                   // El banco
                        $numcuenta = $row['numcuenta'];                 // Número de cuenta bancaria
                        $eps = $row['descripcioneps'];                  // EPS a la cual pertenece el empleado
                        $pensiones = $row['descripcionafp'];            // Fondo de pensiones al cual pertenece el empleado
        
                        // Procedo a construir el encabezado del recibo
                    
                        // Página nueva
                        $i++;
                        $lbpar = false;
                        $lbimpar = false;
            
                        if($i%2 == 0)
                            $lbpar = true;
                        else
                        {
                            $pdf->AddPage("");
                            $lbimpar = true;
                            $pagina++;
                        }
            
                        // Encabezado del recibo
                        $x = 35;
                        if($lbpar)
                            $y = 153;
                        else
                            $y = 15;

                        // Logo Dromedicas
                        if($lbpar)
                            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,150,20,25,'PNG','');
                        else
                            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
            
                        $pdf->SetFont('Arial','B',10);
                        $enc= "COMPROBANTE DE PAGO";                                                $pdf->Text($x,$y,$enc);
            
                        // Fecha y hora de impresión
                        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
            
                        $pdf->SetFont('Arial','',8);
                        $pdf->Text($x+112,$y,$fechoraimp);
            
                        $pdf->SetFont('Arial','B',10);
                        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";                      $pdf->Text($x,$y+7,$enc);
                        $enc= "NOMINA: ";                                                           $pdf->Text(35,$y+14,$enc);
            
                        $pdf->SetFont('Arial','',10);
                        $enc=strtoupper($descripcionper);                                           $pdf->Text($x+18,$y+14,$enc);
            
                        $x = 10;
                        if($lbpar)
                            $y = 180;
                        else
                            $y = 40;

                        // Datos del empleado
                        $pdf->SetFont('Arial','B',10);
                        $enc= "CODIGO: ";                                                           $pdf->Text($x,$y,$enc);
                        $pdf->SetFont('Arial','',10);
                        $enc=$codvende;                                                             $pdf->Text($x+28,$y,$enc);
                        $pdf->SetFont('Arial','B',10);
                        $enc= "NOMBRE: ";                                                           $pdf->Text($x+60,$y,$enc);
                        $pdf->SetFont('Arial','',10);
                        $enc=strtoupper($nombreemp);                                                $pdf->Text($x+80,$y,$enc);
                        $pdf->SetFont('Arial','B',10);
                        $enc= "DOCUMENTO: ";                                                        $pdf->Text($x,$y+7,$enc);
                        $pdf->SetFont('Arial','',10);
                        $enc=$documento;                                                            $pdf->Text($x+28,$y+7,$enc);
                        $pdf->SetFont('Arial','B',10);
                        $enc= "CARGO: ";                                                            $pdf->Text($x+60,$y+7,$enc);
                        $pdf->SetFont('Arial','',10);
                        $enc=strtoupper($cargo);                                                    $pdf->Text($x+80,$y+7,$enc);
                        $pdf->SetFont('Arial','B',10);
                        $enc= "BASICO: ";                                                           $pdf->Text($x,$y+14,$enc);
                        $pdf->SetFont('Arial','',10);
                        $enc=number_format($basico,2);                                              $pdf->Text($x+28,$y+14,$enc);
                        $pdf->SetFont('Arial','B',10);
                        $enc= "AREA: ";                                                             $pdf->Text($x+60,$y+14,$enc);
                        $pdf->SetFont('Arial','',10);
                        $enc=strtoupper($area);                                                     $pdf->Text($x+80,$y+14,$enc);
            
                        // Títulos del detalle
                        $x = 10;            
                        if($lbpar)
                            $y = 204;
                        else
                            $y = 62;

                        $pdf->SetFillColor(220,220,220);
                        $pdf->Rect($x-3,$y-5,195,8,'F');
            
                        $pdf->SetFont('Arial','B',9);
                        $pdf->Text($x,$y,"CODIGO");                     $pdf->Text($x+20,$y,"CONCEPTO");                    $pdf->Text($x+75,$y,"CANTIDAD");
                        $pdf->Text($x+105,$y,"DEVENGADOS");             $pdf->Text($x+135,$y,"DESCUENTOS");                 $pdf->Text($x+170,$y,"SALDO/BASE");
                        
                        // Impresión del detalle del recibo
                        $vsql2 = "SELECT c.codconcepto, c.nomconcepto, IF(d.conceptoid NOT IN (53,54),SUM(d.valor),COUNT(*)) valor, SUM(d.devengados) devengados, SUM(d.descuentos) descuentos, d.saldo, d.conceptoid 
                                    FROM detallenomina d 
                                         INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                                   WHERE d.pernominaid = ".$periodoid." 
                                         AND d.terid = ".$terid." 
                                GROUP BY d.conceptoid 
                                ORDER BY c.tipodc, c.codconcepto";

                        $conex  = $clase->Conectar();
                        $result2 = mysql_query($vsql2,$conex);
                        
                        $x = 10;
                        if($lbpar)
                            $y = 212;
                        else
                            $y = 70;

                        $totdevengado = 0;
                        $totdescuento = 0;
                        $totpagar = 0;
                        while($row2 = mysql_fetch_array($result2))
                        {
                            // Imprimo los conceptos con sus respectivos montos
                            $pdf->SetFont('Arial','',8);
                            $pdf->Text($x,$y,$row2['codconcepto']);
            
                            if(($row2['conceptoid']==4)||($row2['conceptoid']==5))
                            {
                                if($row2['conceptoid']==4)          $nomconcepto = $pensiones;
                                if($row2['conceptoid']==5)          $nomconcepto = $eps;
                                if($nomconcepto=="")                $nomconcepto = "NO ESPECIFICA";
                                $pdf->Text($x+20,$y,$nomconcepto);
                            }
                            else
                            {
                                $nomconcepto = $row2['nomconcepto'];
                                $pdf->Text($x+20,$y,$nomconcepto);
                            }
            
                            // Impresión de los días
                            if($row2['valor']>0)
                            {
                                // Alineación de los montos correspondientes
                                $longitud = strlen($row2['valor']);
                                if($longitud==1)                    $pdf->Text($x+81,$y,number_format($row2['valor'],2));
                                if($longitud==2)                    $pdf->Text($x+80,$y,number_format($row2['valor'],2));
                            }
            
                            // Impresión de los devengados
                            if($row2['devengados']>0)
                            {
                                // Alineación de los montos correspondientes
                                $longitud = strlen($row2['devengados']);
                                if($longitud==5)                    $pdf->Text($x+118,$y,number_format($row2['devengados'],0));
                                if($longitud==6)                    $pdf->Text($x+117,$y,number_format($row2['devengados'],0));
                                if($longitud==7)                    $pdf->Text($x+115,$y,number_format($row2['devengados'],0));
                            }
                            
                            // Impresión de los descuentos
                            if(($row2['descuentos']>0)&&(($row2['conceptoid']!=6)&&($row2['conceptoid']!=9)&&($row2['conceptoid']!=43)&&($row2['conceptoid']!=58)))
                            {
                                // Alineación de los montos correspondientes
                                $longitud = strlen($row2['descuentos']);
                                if($longitud==4)                    $pdf->Text($x+149,$y,number_format($row2['descuentos'],0));
                                if($longitud==5)                    $pdf->Text($x+148,$y,number_format($row2['descuentos'],0));
                                if($longitud==6)                    $pdf->Text($x+146,$y,number_format($row2['descuentos'],0));
                            }
            
                            // Impresión del saldo/base
                            if($row2['saldo']>0)
                            {
                                // Alineación de los montos correspondientes
                                $longitud = strlen($row2['saldo']);
                                if($longitud==7)                    $pdf->Text($x+178,$y,number_format($row2['saldo'],0));
                                if($longitud==6)                    $pdf->Text($x+180,$y,number_format($row2['saldo'],0));
                            }
            
                            // Incremento los totales
                            $totdevengado += $row2['devengados'];
            
                            if(($row2['conceptoid']!=6)&&($row2['conceptoid']!=9)&&($row2['conceptoid']!=43)&&($row2['conceptoid']!=58))
                                $totdescuento += $row2['descuentos'];
                            
                            $y+=6;
                        }
            
                        // Imprimo los totales
                        $lineatotales = $y;
                        $pdf->SetFillColor(220,220,220);
                        $pdf->Rect($x-3,$y-3,195,8,'F');
            
                        $pdf->SetFont('Arial','B',10);
                        $pie= "TOTALES: ";                          $pdf->Text($x+70,$y+2,$pie);
            
                        $pdf->SetFont('Arial','',8);
            
                        // Alineación de los montos correspondientes
                        $longitud = strlen($totdevengado);
                        if($longitud==5)                        $pdf->Text($x+113,$y+2,number_format($totdevengado));
                        if($longitud==6)                        $pdf->Text($x+117,$y+2,number_format($totdevengado));
                        if($longitud==7)                        $pdf->Text($x+114,$y+2,number_format($totdevengado));
            
                        // Alineación de los montos correspondientes
                        $longitud = strlen($totdescuento);
                        if($longitud==5)                        $pdf->Text($x+148,$y+2,number_format($totdescuento));
                        if($longitud==6)                        $pdf->Text($x+146,$y+2,number_format($totdescuento));
            
                        $totpagar = $totdevengado - $totdescuento;
            
                        $pdf->SetFillColor(180,180,180);
                        $pdf->Rect($x-3,$y+5,195,8,'F');
            
                        $pdf->SetFont('Arial','B',10);
                        $pie= "NETO A PAGAR: ";
                        $pdf->Text($x+70,$y+10,$pie);
            
                        $longitud = strlen($totpagar);
                        if($longitud==6)                        $pdf->Text($x+144,$y+10,number_format($totpagar));
                        if($longitud==7)                        $pdf->Text($x+141,$y+10,number_format($totpagar));
            
                        // Impresión del banco y cuenta a la cual se le consigna
                        $pdf->SetFont('Arial','',8);
                        $pie= "                                                                                                                                                                     __________________________";
                        $pdf->Text($x,$y+26,$pie);
                        $pie= "                                                                                                                                                                     RECIBI CONFORME";
                        $pdf->Text($x,$y+31,$pie);
            
                        if($extralegal=="CHECKED")
                            $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
                        else
                        {
                            if(($numcuenta=="")||($numcuenta==NULL))
                                $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
                            else
                                $pie= "CONSIGNADO EN: ".strtoupper($banco)."                      CUENTA NO. ".$numcuenta."                            C.C.";
                        }
                        $pdf->Text($x,$y+36,$pie);
                    }
                }
                $pdf->Output();
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanainftiposdepago
    // Creación: 28/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar los filtros del informe de 
    //              tipos de pago
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanainftiposdepago")
    {
        $params = ' class="Texto11" ';

        // consulta para los combos de los periodos
        $vsqlcomboperiodo  = "SELECT periodoid, descripcion 
                                FROM periodosnomina 
                               WHERE cerrado = 'CHECKED' OR 
                                     periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado = '' AND calculado = 'CHECKED') 
                            ORDER BY periodoid ASC";

        // combo para los periodos
        $vsqlcomboperiodo = $clase->CrearComboBuscar("periodoid",$vsqlcomboperiodo,"descripcion","periodoid","","N",$params,330);

        // pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Informe de tipos de pago por periodo </b> </td>
                  <td width="50" align="center"> <input type="button" class="button blue" value="<<" OnClick="document.location=\'principal.php\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // filtros
        $cont.='<form action="?opcion=inftiposdepagohtml" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Tipo: </td>
                  <td width="120"> ';

        // consulta para los bancos
        $vsql2 = "SELECT b.bancoid, b.descripcion FROM bancos b WHERE b.bancoid IN (SELECT DISTINCT bancoid FROM periodoterceros)";
                  
		$conex  = $clase->Conectar();
		$result2 = mysql_query($vsql2,$conex);
                
        // combo para los tipos de pago
        $cont.='<select name="tipopago" id="tipopago" style="width:200px;height:28px;" class="Texto11">';

		while($row2 = mysql_fetch_array($result2))
		{
			$cont.='<option value="'.$row2['bancoid'].'">'.substr($row2['descripcion'],0,50).'</option>';
		}

        $cont.='<option value="0"> PAGO EN EFECTIVO </option>';
                  
        $cont.='   </select>
                  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:30px;Important!">
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Periodo: </td>
                  <td width="120"> '.$vsqlcomboperiodo.' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: inftiposdepagohtml
    // Creación: 28/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite el informe de tipos de pago en salida html
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "inftiposdepagohtml")
    {
        $tipopago = $_POST['tipopago'];
        $periodoid = $_POST['periodoid'];

        // nombre del periodo
        $descripcionper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Determino si el periodo está cerrado
        $cerrado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');                

        // tipo del pago
        if($tipopago == 0)
        {
            $pago = "PAGO EN EFECTIVO";

            if($cerrado == "CHECKED")
                $cwhere = " AND (pt.numcuenta = '0' OR pt.numcuenta = '') ";
            else
                $cwhere = " AND (ta.numcuenta = '0' OR ta.numcuenta = '') ";

            $titulocuenta = '';
        }
        else
        {
            $pago = $clase->BDLockup($tipopago,'bancos','bancoid','descripcion');
            
            if($cerrado == "CHECKED")
                $cwhere = " AND (pt.bancoid = ".$tipopago." AND (pt.numcuenta <> '' AND pt.numcuenta <> '0')) ";
            else
                $cwhere = " AND (ta.bancoid = ".$tipopago." AND (ta.numcuenta <> '' AND ta.numcuenta <> '0')) ";

            $titulocuenta = 'N&uacute;mero Cuenta';
        }

        // Filtro de la salida a Excel
        $filtroxls = $descripcionper." ".$pago;

        // consulta del informe
        if($cerrado == "CHECKED")
            $vsql = "SELECT pt.terid, pt.dni, pt.codvende, pt.nombre, pt.numcuenta, 
                            (SELECT (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) neto 
                               FROM hisdetallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = pt.terid 
                                    AND d.pernominaid = pt.pernominaid) neto
                       FROM periodoterceros pt     
                      WHERE pt.pernominaid = ".$periodoid."
                            ".$cwhere."
                   ORDER BY 3";
        else
            $vsql = "SELECT ta.terid, ta.dni, ta.codvende, CONCAT(ta.primernombre,' ',ta.segundonombre,' ',ta.primerapellido,' ',ta.segundoapellido) AS nombre,
                            ta.numcuenta, 
                            (SELECT (SUM(IF(c.tipodc = 'C',d.devengados,0)) - SUM(IF(c.tipodc = 'D' AND d.conceptoid NOT IN (6,9,43,58),d.descuentos,0))) neto 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ta.terid 
                                    AND d.pernominaid = ta.pernominaid) neto 
                       FROM tercerosactual ta 
                      WHERE ta.pernominaid = ".$periodoid." 
                            ".$cwhere."
                   ORDER BY 3";

        // Variable para la salida a Excel
        $_SESSION['SQL_TIPOSPAGOXLS'] = $vsql;

        // pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                  <td width="800"> <b> Informe de tipos de pago por periodo <br> <font color="blue"> '.$descripcionper.' <br> '.$pago.' </b> </font> </td>
                  <td width="30"> 
                   <a href="?opcion=inftiposdepagoxls&filtroxls='.$filtroxls.'&tipopago='.$tipopago.'" title="salida en una hoja de Excel" target="_blank"> 
                    <img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="50" align="center"> <input type="button" class="button blue" value="<<" OnClick="document.location=\'informesnomina.php?opcion=ventanainftiposdepago\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';        

        // Títulos
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <th width="12"> &nbsp; </th>
                   <th width="120" align="left"> Documento </th>
                   <th width="90" align="left"> C&oacute;digo </th>
                   <th width="400" align="left"> Nombre </th>
                   <th width="327" align="left"> '.$titulocuenta.' </th>
                   <th width="200" align="right"> Neto </th>
                   <th width="30"> &nbsp; </th>	
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:580px; overflow-Y:scroll">';

        // impresión de detalle
        $i = 0;
        $totalneto = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            if($tipopago == 0)
                $numcuenta = '';
            else
                $numcuenta = $row['numcuenta'];            

            $cont.=' <td width="12"> &nbsp; </td>
                     <td width="125" align="left"> '.$row['dni'].' </td>
                     <td width="95" align="left"> '.$row['codvende'].' </td>
                     <td width="405" align="left"> '.$row['nombre'].' </td>
                     <td width="312" align="left"> '.$numcuenta.' </td>
                     <td width="220" align="right"> '.number_format($row['neto']).' </td>
                     <td width="10"> &nbsp; </td>
                    </tr>';

            $totalneto += $row['neto'];
        }

        $cont.=' </tbody> 
                </table>';

        // totales
        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="20"> &nbsp; </td>
                  <td width="375" align="left"> <font color="WHITE"> <b> Empleados: </b> '.number_format($i).' </font> </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="182"> &nbsp; </td>
                  <td width="616" align="right"> <font color="WHITE"> <b> Total: </b> '.number_format($totalneto).' </td>
                  <td width="40"> &nbsp; </td>                  
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: inftiposdepagoxls
    // Creación: 28/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite el informe de tipos de pago en salida a Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "inftiposdepagoxls")
    {
        $filtroxls = $_GET['filtroxls'];
        $tipopago = $_GET['tipopago'];
        $vsql = $_SESSION['SQL_TIPOSPAGOXLS'];

        // Preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");
        
        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("tipos de pago - DROPOS")
                                     ->setSubject("tipos de pago - DROPOS")
                                     ->setDescription("tipos de pago - DROPOS")
                                     ->setKeywords("tipos de pago - DROPOS")
                                     ->setCategory("Categoria General");        

        if($tipopago <> 0)
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'INFORME DE TIPOS DE PAGO POR PERIODO')
                        ->setCellValue('A2', $filtroxls)
                        ->setCellValue('A3', 'DOCUMENTO')
                        ->setCellValue('B3', 'CODIGO')
                        ->setCellValue('C3', 'NOMBRE')
                        ->setCellValue('D3', 'CUENTA')
                        ->setCellValue('E3', 'NETO');
                     
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        }
        else
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'INFORME DE TIPOS DE PAGO POR PERIODO')
                        ->setCellValue('A2', $filtroxls)
                        ->setCellValue('A3', 'DOCUMENTO')
                        ->setCellValue('B3', 'CODIGO')
                        ->setCellValue('C3', 'NOMBRE')
                        ->setCellValue('D3', 'NETO');
                     
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);            
        }

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);
        
        $i = 4;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $cant   = @mysql_num_rows($result);
        while($row = @mysql_fetch_array($result))
        {
            $codvende = $row['codvende'];
            if(substr($codvende,0,1) == "0")
                $codvende="'".$codvende;
            
            if($tipopago <> 0)
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $row['dni'])
                            ->setCellValue('B'.$i, $codvende)
                            ->setCellValue('C'.$i, $row['nombre'])
                            ->setCellValue('D'.$i, $row['numcuenta'])
                            ->setCellValue('E'.$i, number_format($row['neto']));
            else
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $row['dni'])
                            ->setCellValue('B'.$i, $codvende)
                            ->setCellValue('C'.$i, $row['nombre'])
                            ->setCellValue('D'.$i, number_format($row['neto']));

            $i++;
        }

        if($tipopago <> 0)
        {
            $rangoEncabezado = 'A3:E3';
            $rangoCeldas     = 'A3:E'.($i-1);
        }
        else
        {
            $rangoEncabezado = 'A3:D3';
            $rangoCeldas     = 'A3:D'.($i-1);            
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('tipos de pago');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        $nombrearcexcel = "tipos de pago ".strtolower($filtroxls).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cuposencero
    // Creación: 26/09/2025		última modificación: 01/10/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana con los empleados activos con cupo en cero
    // Última modificación: Inclusión del botón para refrescar la ventana y el botón para 
    //                      acceder a la ficha terceros de cada empleado
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "cuposencero")
    {
        // consulta de la ventana
        $vsql = "SELECT terid, dni, codvende, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp, cupocredito 
                   FROM terceros 
                  WHERE basico > 0 
                        AND esempleadoactivo = 'CHECKED' 
                        AND cupocredito = 0";

        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        $det = '';
        // $cant   = 0;

        // Validación de la existencia de registros 
        if($cant == 0)
            $det.= '<table width="100%">
                     <tr class="BarraDocumentos" style="height:50px;Important!">
                      <td width="20"> &nbsp; </td>
                      <td width="750" align="center"> <h2> No existen empleados activos con cupo en cero </h2> </td>
                     </tr>
                    </table>
                    <table width="100%"> 
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
        else
        {
            $det .='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <form action="?opcion=actualizarcupo" method="POST" name="f2">
                    <table id="fixTableV" class="sortable">
                     <tr class="TituloTabla">
                      <th width="40"> # </th>
                      <th width="120"> C&eacute;dula </th>
                      <th width="30"> C&oacute;digo </th>
                      <th width="600"> Nombre </th>
                      <th width="100"> Cupo Cr&eacute;dito </th>
                      <th width="30"> &nbsp; </th>
                     </tr>';
 
            // impresión del detalle
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $det.='<tr class="TablaDocsPar">';
                else
                    $det.='<tr class="TablaDocsImPar">';

                $det.=' <td align="center"> '.$i.' </td>
                        <td align="center"> '.$row['dni'].' </td>
                        <td align="center"> '.$row['codvende'].' </td>
                        <td align="center"> '.$row['nombreemp'].' </td>
                        <td align="center"> 
                         <input type="number" name="pedir-'.$row['dni'].'" min="0" class="Texto12New" size="12" style="width:100px;height:25px;" title="monto del cr&eacute;dito" value="'.number_format($row['cupocredito']).'">
                        </td>
                        <td align="center"> 
                         <a href="terceros.php?opcion=detalles2&id='.$row['terid'].'" title="ver ficha terceros de '.$row['nombreemp'].'" target="_blank"> 
                          <img src="images/basicas/validar.png" border="0" width="20" height="20"> 
                         </a>
                        </td>
                       </tr>';
            }

            // totales y botones
            $det .='<table width="100%"> 
                     <tr class="TituloTabla"> 
                      <td width="20"> &nbsp; </td> 
                      <td width="1588"> <font color="white"> <b> Total empleados sin cupo: '.number_format($i).' </b> </font> </td> 
                     </tr>
                    </table>
                    <br>
                    <center>
                    <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="aceptar"></a>
                    </form>';
        }

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td>
                  <td width="1240"> <b>Empleados activos con cupos cr&eacute;dito en cero</b> </td>
                  <td width="30"> 
                   <a href="informesnomina.php?opcion=cuposencero" title="actualizar la ventana"> 
				    <img src="images/iconos/refrescar.png" border="0" width="34" height="34">  
				   </a>                  
                  </td>
		          <td width="10"> &nbsp; </td>
                  <td width="30" align="center"> <input type="button" class="button blue" value="<<"> </td>
                  <td width="10" align="center"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.= $det;

        mysql_free_result($result);
        mysql_close($conex);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: actualizarcupo
    // Creación: 26/09/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que actualiza los cupos en cero de los empleados activos que 
    //              fueron seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actualizarcupo")
    {
        // consulta de la ventana
        $vsql = "SELECT terid, dni, codvende, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp, cupocredito 
                   FROM terceros 
                  WHERE basico > 0 
                        AND esempleadoactivo = 'CHECKED' 
                        AND cupocredito = 0";

		$conex    = $clase->Conectar();
        $result   = mysql_query($vsql,$conex);
		while($row = mysql_fetch_array($result)) 
        {
            $dni = $row['dni'];
		    $montocupocredito = $_POST['pedir-'.$row['dni']];

            if($montocupocredito > 0)
                $clase->EjecutarSQL("UPDATE terceros SET cupocredito = ".$montocupocredito." WHERE dni = '".$dni."'");
        }

        // Redirecciono el formulario
        header("Location: informesnomina.php?opcion=cuposencero");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: prepersonalasignado
    // Creación: 04/11/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar los filtros del informe de 
    //              emplados asignados a un líder de área
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "prepersonalasignado")
    {
        // pinto la ventana
        $cont = $clase->Header("S","W");

        // encabezado
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/clientes.png" width="32" height="32" border="0"> </td> 
                  <td width="840"> <b> Empleados asignados </b> </td>
                  <td width="50" align="center"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td> 
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // filtros para generar el informe
        $cont.='<form action="?opcion=infpersonalasignado" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="180"> &nbsp; </td>
                  <td width="70"> C&oacute;digo del l&iacute;der: </td>
                  <td width="150" alling="left"> <input type="text" class="Texto12" style="width:80px;height:25px;" name="codvende" size="5" maxlenght="5"> </td> 
                  <td width="180"> &nbsp; </td>
                 </tr>                 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="180"> &nbsp; </td>
                  <td width="70"> &Aacute;rea: </td>
                  <td width="150"> 
                    <input type="radio" style="width:15px;height:15px;" name="areaid" value="1" checked> Administraci&oacute;n 
                    &nbsp;
                    <input type="radio" style="width:15px;height:15px;" name="areaid" value="2"> Ventas                  
                  </td> 
                  <td width="180"> &nbsp; </td>
                 </tr>
                </table>';

        // botón de aceptar
        $cont.='<table width="100%">
                 <tr class="BarraDocumentos"> 
                  <td width="260"> &nbsp; </td> 
                  <td width="100" alling="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';                

        // pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infpersonalasignado
    // Creación: 04/11/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite el informe de empleados asignados a un líder de área
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "infpersonalasignado")
    {
        $codvende = $_POST['codvende'];
        $areaid = $_POST['areaid'];

        // validación del código del líder
        if(strlen($codvende) == 0)
        {
            $clase->Aviso(3,"Introduzca el código del líder");
            header("Location: informesnomina.php?opcion=prepersonalasignado");
        }
        else
        {
            // valido que código sea de un líder del área
            $iddellider = $clase->SeleccionarUno("SELECT terid FROM terceros WHERE codvende = '".$codvende."' AND basico > 0");
            $nomreemp = "CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)";
            $nombreempleado = $clase->BDLockup($iddellider,'terceros','terid',$nomreemp);
            $numlider = $clase->SeleccionarUno("SELECT COUNT(*) numlider FROM seccion WHERE idlider = ".$iddellider."");

            // valido que sea líder de área en administración
            if(($numlider == 0) && ($areaid == 1))
            {
                $clase->Aviso(3,"<b>$nombreempleado</b> no es líder de área de administración");
                header("Location: informesnomina.php?opcion=prepersonalasignado");
            }
            else
            {
                // pinto la ventana
                $cont = $clase->Header("S","W");

                // encabezado
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> <img src="images/iconos/clientes.png" width="32" height="32" border="0"> </td> 
                          <td width="840"> <b> Empleados asignados <br> <font color="blue"> '.$nombreempleado.' </font> </b> </td>
                          <td width="50" align="center"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td> 
                          <td width="8"> &nbsp; </td>
                         </tr>
                        </table>';

                // área de administración
                if($areaid == 1)
                {
                    // títulos
                    $cont.='<table width="100%" class="sortable">
                             <thead> 
                              <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                               <td width="1260"> &nbsp; </td>
                              </tr>
                             </thead>
                             <tbody style="display:block; width:1050px; height:600px; overflow-Y:scroll">';
    
                    $vsql = "SELECT T.dni, T.`codvende`, CONCAT(T.primernombre,' ',T.segundonombre,' ',T.primerapellido,' ',T.segundoapellido) AS nombreempleado, S.descripcionsec, C.descripcioncargo, ST.seccionid,
                                    S.idlider, T.terid 
                               FROM seccionterceros ST
                                    INNER JOIN seccion S ON (ST.seccionid = S.seccionid)
                                    INNER JOIN terceros T ON (ST.terid = T.terid)
                                    INNER JOIN cargos C ON (T.cargoid = C.cargoid)
                              WHERE S.idlider = ".$iddellider."                         
                                    AND T.esempleadoactivo = 'CHECKED'  
                           ORDER BY ST.seccionid, T.primernombre";
    
                    $i = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        if(($_SESSION['SUPERUSUARIO'] == "CHECKED") || ($_SESSION['USERNAME'] == "KAREN.PADUA") || ($_SESSION['USERNAME'] == "LIDER-TALENTOHUMANO") || ($_SESSION['USERNAME'] == "LIDERNOMINA") || ($_SESSION['USERNAME'] == "Y.MARIN") || ($_SESSION['USERNAME'] == "LFLOREZ"))
                            $botonterceros = '<a href="terceros.php?opcion=detalles2&id='.$row['terid'].'" target="_blank"> <img src="images/basicas/iconobuscar.png" border="0" width="18" height="18"> </a>';
                        else
                            $botonterceros = '';

                        $i++;
                        if($i==1)
                        {
                            // Nombre de la sección
                            $cont.='<tr class="CabezoteTabla">
                                     <td width="30"> &nbsp;  </td>
                                     <td width="600"> <font color="blue"> <b>'.$row['descripcionsec'].' </b> </font> </td>
                                     <td width="600"> &nbsp; </td>
                                     <td width="30"> &nbsp; </td>    
                                    </tr>
                                    <tr class="TituloTabla">
                                     <td width="30">&nbsp;  </td>
                                     <td width="600" align="left"> Empleado </td>
                                     <td width="600" align="left"> Cargo </td>
                                     <td width="30"> &nbsp; </td>
                                    </tr>';                            

                            if($row['terid'] != $row['idlider'])
                                $cont.='<tr class="TablaDocsImPar">
                                         <td width="30">&nbsp; </td>
                                         <td width="600" align="left"> '.$row['nombreempleado'].' </td>
                                         <td width="600" align="left"> '.$row['descripcioncargo'].' </td>
                                         <td width="30" align="left"> '.$botonterceros.' </td>
                                        </tr>';
                        }
                        else
                        {
                            if($row['seccionid']!=$seccionant)                            
                                $cont.='<tr class="CabezoteTabla">
                                         <td width="30">&nbsp; </td>
                                         <td width="600"> <font color="blue"> <b>'.$row['descripcionsec'].' </b> </font> </td>
                                         <td width="600"> &nbsp; </td>
                                         <td width="30"> &nbsp; </td>
                                        </tr>
                                        <tr class="TituloTabla">
                                         <td width="30"> &nbsp; </td>
                                         <td width="600" align="left"> Empleado </td>
                                         <td width="600" align="left"> Cargo </td>
                                         <td width="30"> &nbsp; </td>
                                        </tr>';

                            if($row['terid'] != $row['idlider'])
                            {
                                if($i%2 == 0)
                                    $cont.='<tr class="TablaDocsPar">';
                                else
                                    $cont.='<tr class="TablaDocsImPar">';
                
                                $cont.=' <td width="30"> &nbsp; </td>
                                         <td width="600" align="left"> '.$row['nombreempleado'].' </td>
                                         <td width="600" align="left"> '.$row['descripcioncargo'].' </td>
                                         <td width="30" align="left"> '.$botonterceros.' </td>
                                        </tr>';
                            }
                        }
                        $seccionant = $row['seccionid'];
                    }
                }

                // área de ventas
                if($areaid == 2)
                {
                    // cosulta para el área de ventas
                    $vsql = "SELECT R.nomcorto , Z.* , S.codigo , S.descripcion , C.sucursalid, CONCAT(T.primernombre,' ',T.segundonombre,' ',T.primerapellido,' ',T.segundoapellido) AS nombreempleado, 
                                    CA.descripcioncargo
                               FROM regiones R 
                                    INNER JOIN zonas Z ON (Z.codregion = R.codregion) 
                                    INNER JOIN sucursales S ON (S.zona = Z.codzona)
                                    INNER JOIN cuadropersonal C ON (C.sucursalid = S.sucursalid)
                                    INNER JOIN terceros T ON (T.terid = C.terid)
                                    INNER JOIN cargos CA ON (T.cargoid = CA.cargoid)
                              WHERE C.sucursalid IS NOT NULL 
                                    AND (Z.codcooregional  = '".$codvende."' OR Z.codcoordinador = '".$codvende."') 
                           ORDER BY Z.codzona ASC , S.orden ASC , T.nombres ASC";

                    $i = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    $cant   = mysql_num_rows($result);

                    if($cant == 0)                    
                        $cont.='<table width="100%">
                                 <tr class="BarraDocumentos" style="height:50px;Important!">
                                  <td width="20"> &nbsp; </td>
                                  <td width="750" align="center"> 
                                   <h2> El empleado seleccionado no es l&iacute;der de &aacute;rea de ventas </h2>
                                 </tr>
                                </table>
                                <table width="100%"> 
                                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                                </table>';                    
                    else
                    {
                        // títulos
                        $cont.='<table width="100%" class="sortable">
                                 <thead> 
                                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                                   <td width="1260"> &nbsp; </td>
                                  </tr>
                                 </thead>
                                 <tbody style="display:block; width:1050px; height:600px; overflow-Y:scroll">';

                        while($row = mysql_fetch_array($result))
                        {
                            if(($_SESSION['SUPERUSUARIO'] == "CHECKED") || ($_SESSION['USERNAME'] == "KAREN.PADUA") || ($_SESSION['USERNAME'] == "LIDER-TALENTOHUMANO") || ($_SESSION['USERNAME'] == "LIDERNOMINA") || ($_SESSION['USERNAME'] == "Y.MARIN") || ($_SESSION['USERNAME'] == "LFLOREZ"))
                                $botonterceros = '<a href="terceros.php?opcion=detalles2&id='.$row['terid'].'" target="_blank"> <img src="images/basicas/iconobuscar.png" border="0" width="18" height="18"> </a>';
                            else
                                $botonterceros = '';
    
                            $i++;
                            if($i==1)                                
                                $cont.='<tr class="CabezoteTabla">
                                         <td width="30"> &nbsp;  </td>
                                         <td width="600"> <font color="blue"> <b>'.$row['descripcion'].' </b> </font> </td>
                                         <td width="600"> &nbsp; </td>
                                         <td width="30"> &nbsp; </td>    
                                        </tr>
                                        <tr class="TituloTabla">
                                         <td width="30">&nbsp;  </td>
                                         <td width="600" align="left"> Empleado </td>
                                         <td width="600" align="left"> Cargo </td>
                                         <td width="30"> &nbsp; </td>
                                        </tr>
                                        <tr class="TablaDocsImPar">
                                         <td width="30">&nbsp; </td>
                                         <td width="600" align="left"> '.$row['nombreempleado'].' </td>
                                         <td width="600" align="left"> '.$row['descripcioncargo'].' </td>
                                         <td width="30" align="left"> '.$botonterceros.' </td>
                                        </tr>';
                            else
                            {
                                if($row['sucursalid']!=$sucursalidant)                                
                                    $cont.='<tr class="CabezoteTabla">
                                             <td width="30">&nbsp; </td>
                                             <td width="600"> <font color="blue"> <b>'.$row['descripcion'].' </b> </font> </td>
                                             <td width="600"> &nbsp; </td>
                                             <td width="30"> &nbsp; </td>
                                            </tr>
                                            <tr class="TituloTabla">
                                             <td width="30"> &nbsp; </td>
                                             <td width="600" align="left"> Empleado </td>
                                             <td width="600" align="left"> Cargo </td>
                                             <td width="30"> &nbsp; </td>
                                            </tr>';

                                if($i%2 == 0)
                                    $cont.='<tr class="TablaDocsPar">';
                                else
                                    $cont.='<tr class="TablaDocsImPar">';
                
                                $cont.=' <td width="30"> &nbsp; </td>
                                         <td width="600" align="left"> '.$row['nombreempleado'].' </td>
                                         <td width="600" align="left"> '.$row['descripcioncargo'].' </td>
                                         <td width="30" align="left"> '.$botonterceros.' </td>
                                        </tr>';
                            }
                            $sucursalidant = $row['sucursalid'];
                        }

                        $cont.=' </tbody>
                                </table>
                                <table width="100%"> <tr class="TituloTabla"> <td width="917"> &nbsp; </td> </tr> </table>';                        
                    }
                }                
            }
        }
    }

    echo $cont.$clase->PiePagina();
?>