<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: preventasdetalladaxiva
    // Creación: 16/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la venta para captar el periodo del informe
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "preventasdetalladaxiva")
    {
        /// Combo de Periodos
        $params = ' class="Texto11" ';			  
        $vsqlcombo  = "SELECT codperiodo, desperiodo FROM periodos ORDER BY orden ASC";
        $fecdesde = date("Y-m-d");
        $periodo = substr($fecdesde,5,2).substr($fecdesde,0,4);
        $comboperiodos = $clase->CrearComboBuscar("codperiodo",$vsqlcombo,"codperiodo","desperiodo", $periodo,"S",$params,250);

        // pinto la ventana
        $cont = $clase->Header("S","W");

        // encabezado
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/analicostos.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Ventas detalladas por iva </b> </td>
                  <td width="100" align="center"> &nbsp; </td>
                  <td width="50" align="center"> <input type="button" class="button blue" value="<<" OnClick="document.location=\'principal.php\'"> </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        // títulos
        $cont.='<form action="?opcion=ventasdetalladaxiva" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="220"> &nbsp; </td>
                  <td width="20"> <label class="Texto12"> Periodo: </label> </td>
                  <td width="120"> '.$comboperiodos.' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';

        // bóton de aceptar
        $cont.='<table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                </table>';

        echo $cont.$clase->PiePagina();
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventasdetalladaxiva
    // Creación: 16/09/2024		última modificación: 08/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que emite la salida en html del informe de ventas detalladas 
    //              por iva
    // Última modificación: Inclusión de los totales
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventasdetalladaxiva")
    {
        $codperiodo = $_POST['codperiodo'];

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // filtro de la consulta
        $filtroper = "'"."%/".substr($codperiodo,0,2)."/".substr($codperiodo,-4)."'";
        
        //// Dia Actual
        $hoy = date("d/m/Y");

        // consulta del informe
        $vsql = "SELECT DV.diaoperativo , ROUND(SUM(DD.valtotal),2) TOTAL , ROUND(SUM(IF(DD.porciva = 0,DD.valbase,0)),2) base00 , 0 iva00 , ROUND(SUM(IF(DD.porciva=5,DD.valbase,0)),2) base05 , 
	                    ROUND(SUM(IF(DD.porciva=5,DD.valiva,0)),2) iva05 , ROUND(SUM(IF(DD.porciva=19,DD.valbase,0)),2) base19 , ROUND(SUM(IF(DD.porciva=19,DD.valiva,0)),2) iva19 , 
			 	        (SELECT SUM(DX.total) 
			 	           FROM docudevolucion DDV 
				                INNER JOIN documentos DX ON (DDV.docuid = DX.docuid) 
					      WHERE DX.tipodoc = 'DVE' AND DX.fecasentado <> '0000-00-00' AND DDV.diaoperativo = DV.diaoperativo) devoluciones 
                   FROM docuventa DV                         
                        INNER JOIN documentos D ON (DV.docuid = D.docuid) 
                        INNER JOIN dedocumentos DD ON (DD.docuid = D.docuid) 
                  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND DV.diaoperativo <> '".$hoy."' AND DV.diaoperativo LIKE ".$filtroper."
               GROUP BY 1";
//echo $vsql;
        // variable de sesión para la salida a Excel
        $_SESSION['SQL_VTADETXIVAXLS'] = $vsql;

        // construyo el detalle
        $i = 0;                 $det = '';
        $totbase00 = 0;         $totiva00 = 0;      $totbase05 = 0;
        $totiva05 = 0;          $totbase19 = 0;     $totiva19 = 0;
        $totdevoluciones = 0;   $totalvtadet = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $det.='<tr class="TablaDocsPar">';
            else
                $det.='<tr class="TablaDocsImPar">';

            // imprimo el detalle
            $det.=' <td width="20"> &nbsp; </td>
                    <td width="100" align="left"> '.$row['diaoperativo'].' </td>                    
                    <td width="120" align="right"> '.number_format($row['base00']).' </td>
                    <td width="120" align="right"> '.number_format($row['iva00']).' </td>
                    <td width="120" align="right"> '.number_format($row['base05']).' </td>
                    <td width="120" align="right"> '.number_format($row['iva05']).' </td>
                    <td width="120" align="right"> '.number_format($row['base19']).' </td>
                    <td width="120" align="right"> '.number_format($row['iva19']).' </td>
                    <td width="120" align="right"> '.number_format($row['devoluciones']).' </td>
                    <td width="120" align="right"> <b>'.number_format($row['TOTAL']).'</b> </td>
                    <td width="30" align="center"> &nbsp; </td> 
                   </tr>';

            // incremento de los totales
            $totbase00 += $row['base00'];                   $totiva00 += $row['iva00'];                 $totbase05 += $row['base05'];                   $totiva05 += $row['iva05'];
            $totbase19 += $row['base19'];                   $totiva19 += $row['iva19'];                 $totdevoluciones += $row['devoluciones'];       $totalvtadet += $row['TOTAL'];
        }
        
        $det.=' </tbody>
               </table>';        

        // Impresión de los totales
        $pie = '<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="30"> &nbsp; </td>
                  <td width="171" align="left"> <font color="white"> <b> Totales: </b> </td>
                  <td width="141" align="right"> <font color="white"> <b> '.number_format($totbase00).' </b> </font> </td>
                  <td width="241" align="right"> <font color="white"> <b> '.number_format($totiva00).' </b> </font> </td>
                  <td width="161" align="right"> <font color="white"> <b> '.number_format($totbase05).' </b> </font> </td>                  
                  <td width="201" align="right"> <font color="white"> <b> '.number_format($totiva05).' </b> </font> </td>
                  <td width="201" align="right"> <font color="white"> <b> '.number_format($totbase19).' </b> </font> </td>
                  <td width="201" align="right"> <font color="white"> <b> '.number_format($totiva19).' </b> </font> </td>
                  <td width="201" align="right"> <font color="white"> <b> '.number_format($totdevoluciones).' </b> </font> </td>
                  <td width="201" align="right"> <font color="white"> <b> '.number_format($totalvtadet).' </b> </font> </td>
                  <td width="60"> &nbsp; </td>
                 </tr>
                </table>';

        // validación del botón para la salida a Excel
        if($i > 0)
            $htmlsalidaxls = '<a href="?opcion=ventasdetalladaxivaxls&desperiodo='.$desperiodo.'" target="_blank"> 
                               <img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32" title="exportar a una hoja de Excel"> 
                              </a>';        
        else
            $htmlsalidaxls = '&nbsp;';

        // pinto la ventana
        $enc = $clase->Header("S","W");

        // encabezado
        $enc.= '<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/analicostos.png" width="32" height="32" border="0"> </td>
                  <td width="750"> <b> Ventas detalladas por iva </b> <br> <font color="blue"> '.$desperiodo.' </font> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> &nbsp; </td>
                  <td width="20"> &nbsp; </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> '.$htmlsalidaxls.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="50" align="center"> <input type="button" class="button blue" value="<<" OnClick="document.location=\'informeslocales.php?opcion=preventasdetalladaxiva\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // títulos
        $enc.= '<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:35px;">
                   <th width="20"> &nbsp; </th>
                   <th width="100" align="left"> D&iacute;a<br>operativo </th>                   
                   <th width="120" align="right"> Base 0 </th>
                   <th width="120" align="right"> Iva 0 </th>
                   <th width="120" align="right"> Base 5 </th>
                   <th width="120" align="right"> Iva 5 </th>
                   <th width="120" align="right"> Base 19 </th>
                   <th width="120" align="right"> Iva 19 </th>
                   <th width="120" align="right"> Devoluciones </th>
                   <th width="120" align="right"> Total </th>
                   <th width="30" align="center"> &nbsp; </th>               
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';

        // Construyo el contenido del formulario
        $cont = $enc.$det.$pie;
        echo $cont.$clase->PiePagina(); 
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventasdetalladaxiva
    // Creación: 16/09/2024		última modificación: 08/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que emite la salida en html del informe de ventas detalladas 
    //              por iva
    // Última modificación: Inclusión de los totales
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "clientesregistropuntos")
    {
        $codperiodo = $_POST['codperiodo'];

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // filtro de la consulta
        $filtroper = "'"."%/".substr($codperiodo,0,2)."/".substr($codperiodo,-4)."'";
        
        //// Dia Actual
        $hoy = date("d/m/Y");

        // consulta del informe
        $vsql = "SELECT DV.diaoperativo , ROUND(SUM(D.total),2) total , 0 registrados , COUNT(*) totalclientes          
                 FROM docuventa DV INNER JOIN documentos D ON (DV.docuid = D.docuid) 
                 WHERE D.tipodoc = 'FVE'  
                 GROUP BY 1
                 limit 0,31";

        // variable de sesión para la salida a Excel
        $_SESSION['SQL_VTADETXIVAXLS'] = $vsql;

        // construyo el detalle
        $i = 0;                 $det = '';
        $totbase00 = 0;         $totiva00 = 0;      $totbase05 = 0;
        $totiva05 = 0;          $totbase19 = 0;     $totiva19 = 0;
        $totdevoluciones = 0;   $totalvtadet = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $det.='<tr class="TablaDocsPar">';
            else
                $det.='<tr class="TablaDocsImPar">';

            // imprimo el detalle
            $det.=' <td width="20"> &nbsp; </td>
                    <td width="100" align="left"> '.$row['diaoperativo'].' </td>                    
                    <td width="120" align="right"> '.number_format($row['base00']).' </td>
                    <td width="120" align="right"> '.number_format($row['iva00']).' </td>
                    <td width="120" align="right"> '.number_format($row['base05']).' </td>
                    <td width="120" align="right"> '.number_format($row['iva05']).' </td>
                    <td width="120" align="right"> '.number_format($row['base19']).' </td>
                    <td width="120" align="right"> '.number_format($row['iva19']).' </td>

                    <td width="30" align="center"> &nbsp; </td> 
                   </tr>';

            // incremento de los totales
            $totbase00 += $row['base00'];                   $totiva00 += $row['iva00'];                 $totbase05 += $row['base05'];                   $totiva05 += $row['iva05'];
            $totbase19 += $row['base19'];                   $totiva19 += $row['iva19'];                 $totdevoluciones += $row['devoluciones'];       $totalvtadet += $row['TOTAL'];
        }
        
        $det.=' </tbody>
               </table>';        

        // Impresión de los totales
        $pie = '<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="30"> &nbsp; </td>
                  <td width="171" align="left"> <font color="white"> <b> Totales: </b> </td>
                  <td width="141" align="right"> <font color="white"> <b> '.number_format($totbase00).' </b> </font> </td>
                  <td width="241" align="right"> <font color="white"> <b> '.number_format($totiva00).' </b> </font> </td>
                  <td width="161" align="right"> <font color="white"> <b> '.number_format($totbase05).' </b> </font> </td>                  
                  <td width="201" align="right"> <font color="white"> <b> '.number_format($totiva05).' </b> </font> </td>
                  <td width="201" align="right"> <font color="white"> <b> '.number_format($totbase19).' </b> </font> </td>
                  <td width="201" align="right"> <font color="white"> <b> '.number_format($totiva19).' </b> </font> </td>

                  <td width="60"> &nbsp; </td>
                 </tr>
                </table>';

        // validación del botón para la salida a Excel
        if($i > 0)
            $htmlsalidaxls = '<a href="?opcion=ventasdetalladaxivaxls&desperiodo='.$desperiodo.'" target="_blank"> 
                               <img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32" title="exportar a una hoja de Excel"> 
                              </a>';        
        else
            $htmlsalidaxls = '&nbsp;';

        // pinto la ventana
        $enc = $clase->Header("S","W");

        // encabezado
        $enc.= '<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/analicostos.png" width="32" height="32" border="0"> </td>
                  <td width="750"> <b> Clientes Fidelizados </b> <br> <font color="blue"> Diferencia entre Fidelizados y NO </font> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> &nbsp; </td>
                  <td width="20"> &nbsp; </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> '.$htmlsalidaxls.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="50" align="center"> <input type="button" class="button blue" value="<<" OnClick="document.location=\'informeslocales.php?opcion=preventasdetalladaxiva\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // títulos
        $enc.= '<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:35px;">
                   <th width="20"> &nbsp; </th>
                   <th width="100" align="left"> D&iacute;a<br>operativo </th>                   
                   <th width="120" align="right"> Total Clientes </th>
                   <th width="120" align="right"> Ya Fidelizados </th>
                   <th width="120" align="right"> Pre-Registrados </th>
                   <th width="120" align="right"> NO Fidelizados </th>
                   <th width="120" align="right"> Indicador </th>
                   <th width="120" align="right"> Indicador PreRe </th>

                   <th width="30" align="center"> &nbsp; </th>               
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';

        // Construyo el contenido del formulario
        $cont = $enc.$det.$pie;
        echo $cont.$clase->PiePagina(); 
    }
    
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventasdetalladaxivaxls
    // Creación: 17/09/2024		última modificación: 08/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que emite la salida en una hoja de Excel del informe de ventas 
    //              detalladas por iva
    // Última modificación: Inclusión de los totales
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventasdetalladaxivaxls")
    {
        $desperiodo = $_GET['desperiodo'];

        $vsql = $_SESSION['SQL_VTADETXIVAXLS'];
        
        // preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');

        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');

        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("ventas detalladas por iva - DROPOS")
                                     ->setSubject("ventas detalladas por iva - DROPOS")
                                     ->setDescription("ventas detalladas por iva - DROPOS")
                                     ->setKeywords("ventas detalladas por iva - DROPOS")
                                     ->setCategory("ventas detalladas por iva");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'VENTAS DETALLADAS POR IVA')
                    ->setCellValue('A2', $desperiodo)
                    ->setCellValue('A3', 'DIA OPERATIVO')
                    ->setCellValue('B3', 'TOTAL')
                    ->setCellValue('C3', 'BASE')
                    ->setCellValue('D3', 'IVA')                    
                    ->setCellValue('E3', 'BASE 5')
                    ->setCellValue('F3', 'IVA 5')
                    ->setCellValue('G3', 'BASE 19')
                    ->setCellValue('H3', 'IVA 19')
                    ->setCellValue('I3', 'DEVOLUCIONES');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        // Detalle del informe
        $i = 4;
        $totbase00 = 0;         $totiva00 = 0;      $totbase05 = 0;
        $totiva05 = 0;          $totbase19 = 0;     $totiva19 = 0;
        $totdevoluciones = 0;   $totalvtadet = 0;        
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['diaoperativo'])
                        ->setCellValue('B'.$i, number_format($row['base00']))
                        ->setCellValue('C'.$i, number_format($row['iva00']))
                        ->setCellValue('D'.$i, number_format($row['base05']))
                        ->setCellValue('E'.$i, number_format($row['iva05']))
                        ->setCellValue('F'.$i, number_format($row['base19']))
                        ->setCellValue('G'.$i, number_format($row['iva19']))
                        ->setCellValue('H'.$i, number_format($row['devoluciones']))
                        ->setCellValue('I'.$i, number_format($row['TOTAL']));

            // incremento de los totales
            $totbase00 += $row['base00'];                   $totiva00 += $row['iva00'];                 $totbase05 += $row['base05'];                   $totiva05 += $row['iva05'];
            $totbase19 += $row['base19'];                   $totiva19 += $row['iva19'];                 $totdevoluciones += $row['devoluciones'];       $totalvtadet += $row['TOTAL'];

            $i++;
        }

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A'.$i, 'TOTALES:')
                    ->setCellValue('B'.$i, number_format($totbase00))
                    ->setCellValue('C'.$i, number_format($totiva00))
                    ->setCellValue('D'.$i, number_format($totbase05))
                    ->setCellValue('E'.$i, number_format($totiva05))
                    ->setCellValue('F'.$i, number_format($totbase19))
                    ->setCellValue('G'.$i, number_format($totiva19))
                    ->setCellValue('H'.$i, number_format($totdevoluciones))
                    ->setCellValue('I'.$i, number_format($totalvtadet));

        $rangoEncabezado = 'A3:I3';
        $rangoCeldas     = 'A3:I'.($i);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('ventas detalladas por iva');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // -------------------------------------------------------------------------------------------- //
        $nombrearcexcel = "ventas detalladas por iva ".strtolower($desperiodo).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // -------------------------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: prefacturasencampana
    // Creación: 17/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la venta para captar el periodo del informe
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "prefacturasencampana")
    {
        /// Combo de Periodos
        $params = ' class="Texto11" ';			  
        $vsqlcombo  = "SELECT codperiodo, desperiodo FROM periodos ORDER BY orden ASC";
        $fecdesde = date("Y-m-d");
        $periodo = substr($fecdesde,5,2).substr($fecdesde,0,4);
        $comboperiodos = $clase->CrearComboBuscar("codperiodo",$vsqlcombo,"codperiodo","desperiodo", $periodo,"S",$params,250);

        // pinto la ventana
        $cont = $clase->Header("S","W");

        // encabezado
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cotizacion.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Facturas que participan en campa&ntilde;a </b> </td>
                  <td width="100" align="center"> &nbsp; </td>
                  <td width="50" align="center"> <input type="button" class="button blue" value="<<" OnClick="document.location=\'principal.php\'"> </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        // títulos
        $cont.='<form action="?opcion=facturasencampana" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="220"> &nbsp; </td>
                  <td width="20"> <label class="Texto12"> Periodo: </label> </td>
                  <td width="120"> '.$comboperiodos.' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';

        // bóton de aceptar
        $cont.='<table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                </table>';

        echo $cont.$clase->PiePagina();
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: facturasencampana
    // Creación: 17/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite la salida en html del informe de facturas que 
    //              participan en campaña
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "facturasencampana")
    {
        $codperiodo = $_POST['codperiodo'];

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // filtro de la consulta
        $filtroper = "'"."%/".substr($codperiodo,0,2)."/".substr($codperiodo,-4)."'";

        // consulta del informe
        $vsql = "SELECT T.dni , T.nombres , T.apellidos , DV.diaoperativo , D.tipodoc , D.prefijo , D.numero , D.total , D.docuid , 
                        (SELECT SUM(DD.valparcial) 
                           FROM dedocumentos DD 
                                INNER JOIN productos P ON (P.productoid = DD.productoid)
                                INNER JOIN gruposprod GP ON (P.gruposprodid = GP.gruposprodid) 
                          WHERE DD.docuid = D.docuid AND (GP.concurso1 = 'CHECKED' OR P.porcenboni>0)) valormarcas , 
                        (SELECT COUNT(*) FROM clientespuntosfarmanorte WHERE ndocumento = T.dni) enpuntos  
                   FROM docuventa DV 
                        INNER JOIN documentos D ON (DV.docuid = D.docuid) 
                        INNER JOIN terceros T ON (T.terid = D.terid1) 
                  WHERE D.tipodoc = 'FVE' AND D.fecasentado <> '0000-00-00' AND D.total >= 50000 AND DV.diaoperativo LIKE ".$filtroper." 
               ORDER BY 1 ASC";

        // variable de sesión para la salida a Excel
        $_SESSION['SQL_FACTCAMPANAXLS'] = $vsql;

        // construyo el detalle
        $i = 0;         $det = '';
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $det.='<tr class="TablaDocsPar">';
            else
                $det.='<tr class="TablaDocsImPar">';

            $nombre = $row['nombres']." ".$row['apellidos'];
            
            $enpuntos = "NO";
            if($row['enpuntos'] == 1)  
              $enpuntos = "SI";
            
            // imprimo el detalle
            $det.=' <td width="20"> &nbsp; </td>
                    <td width="120" align="left"> '.$row['dni'].' </td>
                    <td width="220" align="left"> '.substr($nombre,0,31).' </td>
                    <td width="100" align="left"> '.$row['diaoperativo'].' </td>
                    <td width="150" align="left"> <a href="reportes/impventas3.php?docuid='.$row['docuid'].'" target="_blank"> '.$row['tipodoc'].' '.$row['prefijo'].' '.$row['numero'].' </a> </td>
                    <td width="120" align="right"> <b>'.number_format($row['total']).' </b> </td>
                    <td width="120" align="right"> '.number_format($row['valormarcas']).' </td>
                    <td width="120" align="right"> '.$enpuntos.' </td>
                    <td width="30" align="center"> &nbsp; </td> 
                   </tr>';
        }
        
        $det.=' </tbody>
               </table>';

        // pie de página
        $pie = '<table width="100%"> <tr class="TituloTabla"> <td width="1608"> &nbsp; </td> </tr> </table>';

        // validación del botón para la salida a Excel
        if($i > 0)
            $htmlsalidaxls = '<a href="?opcion=facturasencampanaxls&desperiodo='.$desperiodo.'" target="_blank"> 
                               <img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32" title="exportar a una hoja de Excel"> 
                              </a>';        
        else
            $htmlsalidaxls = '&nbsp;';

        // pinto la ventana
        $enc = $clase->Header("S","W");

        // encabezado
        $enc.= '<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cotizacion.png" width="32" height="32" border="0"> </td>
                  <td width="750"> <b> Facturas que participan en campa&ntilde;a </b> <br> <font color="blue"> '.$desperiodo.' </font> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> &nbsp; </td>
                  <td width="20"> &nbsp; </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> '.$htmlsalidaxls.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="50" align="center"> <input type="button" class="button blue" value="<<" OnClick="document.location=\'informeslocales.php?opcion=prefacturasencampana\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // títulos
        $enc.= '<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:35px;">
                   <th width="20"> &nbsp; </th>
                   <th width="120" align="left"> Documento </th>
                   <th width="220" align="left"> Nombres </th>
                   <th width="100" align="left"> D&iacute;a<br>operativo </th>
                   <th width="150" align="left"> N&uacute;mero </th>
                   <th width="120" align="right"> Total </th>
                   <th width="120" align="right"> Valor<br>Marcas </th>
                   <th width="120" align="right"> En puntos </th>
                   <th width="30" align="center"> &nbsp; </th>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';

        // Construyo el contenido del formulario
        $cont = $enc.$det.$pie;
        echo $cont.$clase->PiePagina(); 
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: facturasencampanaxls
    // Creación: 17/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite la salida en una hoja de Excel del informe de facturas 
    //              que participan en campaña
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "facturasencampanaxls")
    {
        $desperiodo = $_GET['desperiodo'];

        $vsql = $_SESSION['SQL_FACTCAMPANAXLS'];
        
        // preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');

        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');

        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("facturas en campaña - DROPOS")
                                     ->setSubject("facturas en campaña - DROPOS")
                                     ->setDescription("facturas en campaña - DROPOS")
                                     ->setKeywords("facturas en campaña - DROPOS")
                                     ->setCategory("facturas en campaña");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'FACTURAS QUE PARTICIPAN EN CAMPAÑA')
                    ->setCellValue('A2', $desperiodo)
                    ->setCellValue('A3', 'DOCUMENTO')
                    ->setCellValue('B3', 'NOMBRES')
                    ->setCellValue('C3', 'DIA OPERATIVO	')
                    ->setCellValue('D3', 'TIPO DOC.')                    
                    ->setCellValue('E3', 'PREFIJO')
                    ->setCellValue('F3', 'NUMERO')
                    ->setCellValue('G3', 'TOTAL')
                    ->setCellValue('H3', 'VALOR MARCAS')
                    ->setCellValue('I3', 'EN PUNTOS');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        // Detalle del informe
        $i = 4;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $nombre = $row['nombres']." ".$row['apellidos'];

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['dni'])
                        ->setCellValue('B'.$i, $nombre)
                        ->setCellValue('C'.$i, $row['diaoperativo'])
                        ->setCellValue('D'.$i, $row['tipodoc'])
                        ->setCellValue('E'.$i, $row['prefijo'])
                        ->setCellValue('F'.$i, $row['numero'])
                        ->setCellValue('G'.$i, number_format($row['total']))
                        ->setCellValue('H'.$i, number_format($row['valormarcas']))
                        ->setCellValue('I'.$i, number_format($row['enpuntos']));
            $i++;
        }

        $rangoEncabezado = 'A3:I3';
        $rangoCeldas     = 'A3:I'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('en campaña');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // -------------------------------------------------------------------------------------------- //
        $nombrearcexcel = "facturas en campaña ".strtolower($desperiodo).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // -------------------------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }
?>