<?PHP
    @session_start(); 
    include("lib/Sistema.php");    
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 26/12/2020		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para la captación de datos del informe  
    //              de histórico de contratos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) FROM terceros WHERE basico > 0 ORDER BY primernombre";
    
        $cont = $clase->Header("S","W");    
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/infcomisiones.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Hist&oacute;rico de contratos </b> </td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr> 
                </table>';
        
        $cont.='<form action="infhistcont.php?opcion=listadocontratos" method="POST" name="x" target="_blank">
                 <center>
                 <table width="100%">
                  <tr class="BarraDocumentos">
                   <td align="center"><br><br><b> Datos del informe <br><br> </td>
                  </tr>
                 </table>  
                 <table width="100%">
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Empleado: &nbsp; </td>
                   <td width="120"> '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,500).' </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                 </table>                   
                 <table width="100%">                     
                  <tr class="BarraDocumentos"> 
                   <td width="371" height="50" align="center"> &nbsp; </td>      
                   <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"> </td>
                   <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"> </td>
                   <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"> </td>
                   <td width="380" height="50" align="center"> &nbsp; </td>
                  </tr>
                 </table> 
                </form>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                </table>';
        echo $cont.$clase->PiePagina();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: listadocontratos
    // Creación: 26/12/2020		última modificación: 08/10/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que imprime el informe de histórico de contratos de acuerdo al 
    //              tipo de salida que se seleccione en la opción “ventanadatos” 
    //              (vista, PDF o Excel)
    // Última modificación: Inclusión de los botones para eliminar y editar un contrato
    //                      en la vista html. (17/12/2021)
    //                      Inclusión de la columna para la condición del empleado
    //                      (29/09/2022)
    //                      Validación de los botones de eliminar y editar y optimización 
    //                      del código (26/09/2024)
    //                      Se le dio permiso al usuario DROPOS.NOMINA para editar y 
    //                      eliminar histórico de contratos
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion=="listadocontratos")
    {
        $terid = $_POST['terid'];
        $tiposalida = $_POST['tiposalida'];

        if($terid=="")      $terid = $_GET['terid'];
        if($tiposalida=="") $tiposalida = $_GET['tiposalida'];

        // Nombre de empleado
        $nomreemp = "CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)";
        $nombre = $clase->BDLockup($terid,'terceros','terid',$nomreemp);

        // Consulta para el informe
        $vsql = "SELECT fecingreso, fecretiro, ultsueldo, id, idcondicion  
                   FROM histcontrato 
                  WHERE terid = ".$terid."
               GROUP BY id";
        
        // ------------------------------------------------------------------------------------------------------------------------------------------ //
        // Muestra el informe en una vista del sistema
        if($tiposalida=="vista")
        {
            // Impresión del detalle del informe
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);            
            $i = 0;         $det = '';
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $det.='<tr class="TablaDocsPar">';
                else
                    $det.='<tr class="TablaDocsImPar">';

                $fecdesde  = substr($row['fecingreso'],8,2)."/".substr($row['fecingreso'],5,2)."/".substr($row['fecingreso'],0,4);
                $fechasta  = substr($row['fecretiro'],8,2)."/".substr($row['fecretiro'],5,2)."/".substr($row['fecretiro'],0,4);
                $id = $row['id'];

                $idcondicion = $row['idcondicion'];

                if($idcondicion == 0)
                    $nombrecondicion = "NO ESPECIFICA";
                else
                    $nombrecondicion = $clase->BDLockup($idcondicion,'condicionempleado','idcondicion','nombrecondicion');

                $det.=' <td width="27"> &nbsp; </td>
                        <td width="315" align="left"> '.$fecdesde.' </td>
                        <td width="316" align="left"> '.$fechasta.' </td>                         
                        <td width="227" align="right"> &nbsp; </td>
                        <td width="10"> &nbsp; </td>                         
                        <td width="11" align="center"> &nbsp; </td>                         
                        <td width="75" align="right"> &nbsp; </td> 
                        <td width="333" align="left"> '.$nombrecondicion.' </td>
                        <td width="242" align="right">'.number_format($row['ultsueldo']).' </td>
                        <td width="23" align="right">&nbsp;</td>';

                if(($_SESSION['USERNAME'] == "LFLOREZ") || ($_SESSION["SUPERUSUARIO"] == "CHECKED") || ($_SESSION['USERNAME'] == "DROPOS.NOMINA"))
                    $det.='<td width="20" align="center"> 
                            <a href="?opcion=valborrarcontrato&id='.$id.'" rel="facebox" title="eliminar contrato">
                             <img src="images/basicas/iconoborrar.png" border="0" width="20" height="20">
                            </a>
                           </td>
                           <td width="20" align="center">
                            <a href="?opcion=editarcontrato&id='.$id.'" title="editar contrato" rel="facebox">
                             <img src="images/basicas/iconobuscar.png" border="0" width="20" height="20">
                            </a>                           
                           </td>';
                else
                    $det.='<td width="30" align="center"> &nbsp; </td>
                           <td width="30" align="center"> &nbsp; </td>';
                        
                $det.='</tr>';
            }

            // pinto la ventana
            $enc = $clase->Header("S","W");
            $enc.= '<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/infcomisiones.png" width="32" height="32" border="0"> </td>
                      <td width="840"> <b> Hist&oacute;rico de contratos </b> </td>
                      <td> &nbsp; </td>
                      <td width="50" align="center"> <a href="infhistcont.php?opcion=ventanadatos"> <input type="button" value="<<" class="button blue"> </a> </td> 
                      <td width="8"> &nbsp; </td>
                     </tr>           
                    </table>';

            $enc.= '<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> &nbsp; </td>
                      <td width="840"> <b> Empleado: </b>'.$nombre.'</td>
                      <td> &nbsp; </td>
                      <td width="8"> &nbsp; </td>
                     </tr>           
                    </table>';

            $enc.= '<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="27"> &nbsp; </td>
                       <td width="310" align="left"> Ingreso </td>
                       <td width="296" align="left"> Retiro </td>			                        
                       <td width="233" align="right"> &nbsp; </td>                        
                       <td width="11"> &nbsp; </td>
                       <td width="80"> &nbsp; </td> 
                       <td width="319" align="left"> Condici&oacute;n </td>                        
                       <td width="242" align="right"> &Uacute;ltimo salario </td>                      
                       <td width="110"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:400px; overflow-Y:scroll">';

            $pie.=' </tbody>
                   </table>
                   <table width="100%"> <tr class="TituloTabla"> <td width="1608"> &nbsp; </td> </tr> </table>';

            $cont = $enc.$det.$pie;
            echo $cont.$clase->PiePagina();
        }

        // ------------------------------------------------------------------------------------------------------------------------------------------ //
        // Muestra el informe en formato PDF
        if($tiposalida=="pdf")
        {
            // Inicializo las variables
            $longitud = 0;
            $lineatotales = 0;
            $mesimp = "";
            $fechoraimp = "";
            $enc = "";
            $pie = "";

            // Procedo a construir el encabezado del recibo
            ini_set("memory_limit","200M");
            require('lib/fpdf/fpdf.php');
            $pdf=new FPDF();
        
            // Página nueva
            $pdf->AddPage("");
            $pagina = 1;

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

            // Imprimo el encabezado del informe
            $x = 25;
            $y = 13;
            $pdf->SetFont('Arial','B',10);

            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";      $pdf->Text($x,$y,$enc);

            $enc= "HISTORICO DE CONTRATOS";                             $pdf->Text($x,$y+5,$enc);
            $enc= $nombre;                                              $pdf->Text($x,$y+10,$enc);

            $pdf->SetFillColor(220,220,220);
            $pdf->Rect(5,33,200,8,'F');
            $pdf->SetFont('Arial','B',9);

            $enc= "INGRESO";                                            $pdf->Text($x-17,$y+25,$enc);
            $enc= "RETIRO";                                             $pdf->Text($x+15,$y+25,$enc);
            $enc= "CONDICION";                                          $pdf->Text($x+55,$y+25,$enc);
            $enc= "ULTIMO SALARIO";                                     $pdf->Text($x+150,$y+25,$enc);

            // Impresión del detalle del informe
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $total = 0;
            $x = 8;
            $y = 46;
            while($row = mysql_fetch_array($result))
            {
                $fecdesde  = substr($row['fecingreso'],8,2)."/".substr($row['fecingreso'],5,2)."/".substr($row['fecingreso'],0,4);
                $fechasta  = substr($row['fecretiro'],8,2)."/".substr($row['fecretiro'],5,2)."/".substr($row['fecretiro'],0,4);

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x,$y,$fecdesde);
                $pdf->Text($x+30,$y,$fechasta);

                // Condición del empleado
                $idcondicion = $row['idcondicion'];

                if($idcondicion == 0)
                    $nombrecondicion = "No especifica";
                else
                    $nombrecondicion = $clase->BDLockup($idcondicion,'condicionempleado','idcondicion','nombrecondicion');
                    
                $pdf->Text($x+72,$y,$nombrecondicion);    

                // Alineación de los montos correspondientes
                $longitud = strlen($row['ultsueldo']);
                if($longitud==6)            $pdf->Text($x+183,$y,number_format($row['ultsueldo']));
                if($longitud==7)            $pdf->Text($x+181,$y,number_format($row['ultsueldo']));

                $y+=6;
            }

            // Traducción al español del mes que devuelve la función date()
            $mesimp = date('F');
            if($mesimp=="January")       $mesimp = "Enero";
            if($mesimp=="February")      $mesimp = "Febrero";
            if($mesimp=="March")         $mesimp = "Marzo";
            if($mesimp=="April")         $mesimp = "Abril";
            if($mesimp=="May")           $mesimp = "Mayo";
            if($mesimp=="June")          $mesimp = "Junio";
            if($mesimp=="July")          $mesimp = "Julio";
            if($mesimp=="August")        $mesimp = "Agosto";
            if($mesimp=="September")     $mesimp = "Septiembre";
            if($mesimp=="October")       $mesimp = "Octubre";
            if($mesimp=="November")      $mesimp = "Noviembre";
            if($mesimp=="December")      $mesimp = "Diciembre";

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
            $pdf->SetFont('Arial','',8);
            $pdf->Text(146,$y+13,$fechoraimp);
            
            $pdf->Output();
        }

        // ------------------------------------------------------------------------------------------------------------------------------------------ //
        // El informe es mostrado en una salida a Excel
        if($tiposalida=="excel")
        {
            require_once 'lib/PHPExcel.php';
            $clase = new Sistema();
            $clase->Conectar();
            ini_set("memory_limit","100M");
            
            // Preparación del entorno para la salida a Excel
            $clase = new Sistema();
            $clase->Nombredb = $_SESSION['DBNOMBRE'];
            error_reporting(E_ALL);
            ini_set('display_errors', TRUE);
            ini_set('display_startup_errors', TRUE);
            date_default_timezone_set('Europe/London');
        
            if (PHP_SAPI == 'cli')
                die('This example should only be run from a Web Browser');
        
            // Create new PHPExcel object
            $objPHPExcel = new PHPExcel();
        
            // Set document properties
            $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                         ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                         ->setTitle("historico de contratos - DROPOS")
                                         ->setSubject("historico de contratos - DROPOS")
                                         ->setDescription("historico de contratos - DROPOS")
                                         ->setKeywords("historico de contratos - DROPOS")
                                         ->setCategory("historico de contratos");

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A1', 'HISTORICO DE CONTRATOS')
                        ->setCellValue('A2', 'EMPLEADO: '.$nombre)
                        ->setCellValue('A4', 'INGRESO')
                        ->setCellValue('B4', 'RETIRO')
                        ->setCellValue('C4', 'CONDICION')
                        ->setCellValue('D4', 'ULTIMO SALARIO');
            
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
            
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant   = mysql_num_rows($result);
            $i = 5;
            $totalconcepto = 0;
            while($row = mysql_fetch_array($result))
            {
                $fecdesde  = substr($row['fecingreso'],8,2)."/".substr($row['fecingreso'],5,2)."/".substr($row['fecingreso'],0,4);
                $fechasta  = substr($row['fecretiro'],8,2)."/".substr($row['fecretiro'],5,2)."/".substr($row['fecretiro'],0,4);

                $idcondicion = $row['idcondicion'];

                if($idcondicion == 0)
                    $nombrecondicion = "No especifica";
                else
                    $nombrecondicion = $clase->BDLockup($idcondicion,'condicionempleado','idcondicion','nombrecondicion');

                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, $fecdesde)
                            ->setCellValue('B'.$i, $fechasta)
                            ->setCellValue('C'.$i, $nombrecondicion)
                            ->setCellValue('D'.$i, number_format($row['ultsueldo']));
                $i++;
            }
            
            $i--;
            $rangoEncabezado = 'A4:D4';
            $rangoCeldas     = 'A4:D'.($i);
            
            // Formato de Encabezado y Celdas
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
            
            $EstiloCeldas = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ),
                ),
            );
            $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
            /// Formato de Encabezados 
            $EstiloEncabezado = array(
            'font' => array(
                'bold' => true,
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
            ),
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ),
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'rotation' => 90,
                'startcolor' => array(
                    'argb' => '00FFFFCC',
                ),
                'endcolor' => array(
                    'argb' => 'FFFFFF',
                ),
                ),
            );
            $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('histórico de contratos');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Redirect output to a client’s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            $nombrearcexcel = "historico de contrato de ".strtolower($nombre).".xls";
            header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
            header('Cache-Control: max-age=0');
            /// Genero la Salida
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
            exit;
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: valborrarcontrato
    // Creación: 17/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de un contrato
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "valborrarcontrato")
    {
        $id = $_GET['id'];

        // nombre del empleado
        $terid = $clase->BDLockup($id,'histcontrato','id','terid');
        $vsql4 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql4);

        // fecha de inicio del contrato
        $fecingreso = $clase->BDLockup($id,'histcontrato','id','fecingreso');
        $fecdesde  = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);

        // fecha fin del contrato
        $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');
        $fechasta  = substr($fecretiro,8,2)."/".substr($fecretiro,5,2)."/".substr($fecretiro,0,4);

        $tiposalida = "vista";

        // pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <br> <label class="Texto12"> <b>Eliminar contrato </b> </label> <br><br> </td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"> 
                   <label class="Texto12">
                   ¿Confirma que desea eliminar el contrato del empleado(a) <br><b>'.$nombreemp.'</b> <br>
                   con fecha de ingreso: <b>'.$fecdesde.'</b> <br> y fecha de retiro: <b>'.$fechasta.'</b>?
                   </label>
                  </td>
                 </tr>                 
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">
                   <br>                  
                   <center>
                   <form action="?opcion=elimcont" method="POST">
                   <input type="hidden" name="id" value="'.$id.'">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="infhistcont.php?opcion=listadocontratos&terid='.$terid.'&tiposalida='.$tiposalida.'"> <input type="button" value="CANCELAR" class="button red"> </a>                   
                   </form>
                  </td>        
                 </tr>
                </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: elimcont
    // Creación: 17/12/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para eliminar un contrato del histórico
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "elimcont")
    {
        $id = $_POST['id'];

        // Id del empleado
        $terid = $clase->BDLockup($id,'histcontrato','id','terid');

        // Defino el tipo de salida
        $tiposalida = "vista";

        // Elimino el contrato del histórico
        $vsql = "DELETE FROM histcontrato WHERE id = ".$id;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Contrato eliminado satisfactoriamente");
        else
            $clase->Aviso(3,"No se eliminó el contrato");

        // Redirecciono el formulario
        header("Location: infhistcont.php?opcion=listadocontratos&terid=$terid&tiposalida=$tiposalida");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarcontrato
    // Creación: 17/12/2021		última modificación: 26/09/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para editar los datos del contrato
    // Última modificación: Inclusión del combo de condición
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarcontrato")
    {
        $id = $_GET['id'];

        // nombre del empleado
        $terid = $clase->BDLockup($id,'histcontrato','id','terid');
        $vsql4 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql4);
        
        // fecha de inicio del contrato
        $fecingreso = $clase->BDLockup($id,'histcontrato','id','fecingreso');

        // fecha fin del contrato
        $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');

        // Último sueldo
        $ultsueldo = $clase->BDLockup($id,'histcontrato','id','ultsueldo');

        $tiposalida = "vista";

        // combo condición
        $idcondicion = $clase->BDLockup($id,'histcontrato','id','idcondicion');

        $vsqlcombocondicion = "SELECT DISTINCT 0 idcondicion, 'NO ESPECIFICA' nombrecondicion FROM condicionempleado
                                UNION ALL
                               SELECT idcondicion, nombrecondicion FROM condicionempleado ORDER BY idcondicion";

        $params = ' class="Texto12" style="width:200px;height:25px;" ';        
        $combocondicion = $clase->CrearComboEsp("idcondicion",$vsqlcombocondicion,"descripcion","idcondicion",$idcondicion,"N",$params);        

        // pinto la ventana
        $cont='<table width="400">
                <tr class="CabezoteTabla"> 
                 <td align="center"> <b>Editar contrato</b> </td>                  
                </tr>
                <tr class="CabezoteTabla"> 
                 <td align="center"> Empleado(a): <br><b>'.$nombreemp.'</b> </td>                  
                </tr>
               </table>
               <form action="infhistcont.php?opcion=almcontrato" method="POST" name="x">                
               <input type="hidden" name="id" value="'.$id.'">                
               <table width="400">
                <center>
                <tr class="TablaDocsImPar">				
                 <td width="150" align="right"> Fecha ingreso: &nbsp;</td> 			  
                 <td width="250"> <input type="date" name="fecingreso" class="Texto11" style="width:120px;height:25px;" size="4" min="12" maxlength="40" value="'.$fecingreso.'"></td>
                </tr>
                <tr class="TablaDocsImPar">				
                 <td width="150" align="right"> Fecha retiro: &nbsp;</td> 			  
                 <td width="250"> <input type="date" name="fecretiro" class="Texto11" style="width:120px;height:25px;" size="4" min="12" maxlength="40" value="'.$fecretiro.'"></td>
                </tr>
                <tr class="TablaDocsImPar">				
                 <td width="150" align="right"> &Uacute;ltimo sueldo: &nbsp;</td>
                 <td width="250"> <input type="number" name="ultsueldo" class="Texto12New" style="width:120px;height:25px;" size="4" min="1" maxlength="4" autocomplete="off" value="'.$ultsueldo.'"></td>
                </tr>
                <tr class="TablaDocsImPar">				
                 <td width="150" align="right"> Condici&oacute;n: &nbsp;</td>
                 <td width="250"> '.$combocondicion.' </td>
                </tr>
               </table><br>
               <center>
               <input type="submit" value="aceptar" class="button blue">
               <a href="infhistcont.php?opcion=listadocontratos&terid='.$terid.'&tiposalida='.$tiposalida.'"> <input type="button" value="CANCELAR" class="button red"> </a>
               </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: almcontrato
    // Creación: 17/12/2021		última modificación: 26/09/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para almacenar los cambios realizados en el histórico de contrato
    // Última modificación: Inclusión de la modificación del campo idcondicion
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "almcontrato")
    {
        $id = $_POST['id'];
        $fecingreso = $_POST['fecingreso'];
        $fecretiro = $_POST['fecretiro'];
        $ultsueldo = $_POST['ultsueldo'];
        $idcondicion = $_POST['idcondicion'];

        // Id del empleado
        $terid = $clase->BDLockup($id,'histcontrato','id','terid');

        // Defino el tipo de salida
        $tiposalida = "vista";        

        // Modifico el monto en la tabla detallenomina
        $vsql = "UPDATE histcontrato SET 
                        fecingreso = '".$fecingreso."', 
                        fecretiro = '".$fecretiro."', 
                        ultsueldo = ".$ultsueldo.", 
                        idcondicion = ".$idcondicion." 
                  WHERE id = ".$id;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        $clase->Aviso(1,"Contrato editado satisfactoriamente");

        // Redirecciono el formulario
        header("Location: infhistcont.php?opcion=listadocontratos&terid=$terid&tiposalida=$tiposalida");
    }    
?>