<?php
  header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
  header("Expires: Sat, 1 Jul 2000 05:00:00 GMT");
  header("Location: login/");
  
  ////////////////////////////////////////////////////////////////////////////////////////
  // ReIngenieria - Login DROPOS
  // Clase Index - Metodos para deteccion de Posibles Errores
  // @Autor Ing Said Rodriguez
  ////////////////////////////////////////////////////////////////////////////////////////

  include("lib/Sistema.php");

  class Index
  {
  	 public $Bloqueado;         /// Define si el Acceso esta restringido
     public $FechaActual;       /// Fecha Actual del Sistema
     public $VersionSoft;       /// Version del Kernel del Software
     public $CodigoSucursal;    /// Codigo de la Sucursal Activa
     public $NombreSucursal;    /// Nombre de la Sucursal Activa
     public $NavegadorUsado;    /// Codigo de la Sucursal Activa
     public $SistemaOperatSer;  /// Nombre de la Sucursal Activa

     //////////////////////////////////////////////////////////////////////////////////////
     // Constructor : Inicializa las Propiedades
     //////////////////////////////////////////////////////////////////////////////////////
  	 function __construct()
	   {
       $this->GetSistemaBloqueado();
       $this->GetFechaActual();
       $this->GetSucursal();
       $this->GetVersion();
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // GetConexionServidor() : Obtiene la conexion al servidor y retorna si hay o NO
     //////////////////////////////////////////////////////////////////////////////////////
     function GetConexionServidor()
     {
         $valor = $this->ConexionServidor();
         return($valor);
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // GetConexionDB : Determina si hay conexion con MySQL o NO
     //////////////////////////////////////////////////////////////////////////////////////
     function GetConexionDB()
     {
     	  $clase = new Sistema();
     	  $conex = $clase->Conectar();
        if($conex)
          return(true);
        else
          return(false); 
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // GetSucursal : Obtiene el Codigo y el nombre de la Sucursal Activa
     //////////////////////////////////////////////////////////////////////////////////////
     function GetSucursal()
     {
        $clase = new Sistema();
        $this->CodigoSucursal = $clase->BDLockup('G_SUCURSALPOS','configuraciones','variab','contenido');     
        $this->NombreSucursal = $clase->BDLockup($this->CodigoSucursal,'sucursales','codigo','descripcion');     
        if(strlen($this->NombreSucursal)==0)
        {
            $this->CodigoSucursal = "";     
            $this->NombreSucursal = "";
        }
        return;
     }     
     
     //////////////////////////////////////////////////////////////////////////////////////
     // GetVersion : Obtiene la Version del Sistema - Kernel
     //////////////////////////////////////////////////////////////////////////////////////
     function GetVersion()
     {
        $clase   = new Sistema();
        $this->VersionSoft = $this->LeerArchivo("version.txt");
        return($this->VersionSoft);
     }     

     //////////////////////////////////////////////////////////////////////////////////////
     // LeerArchivo : Lee el contenido de un archivo y lo retorna
     //////////////////////////////////////////////////////////////////////////////////////
     function LeerArchivo($filename)
     {
         if(file_exists($filename))
         {
           $fp = fopen(@$filename, "r");
           $linea="";
           while(!feof($fp))
              $linea.= fgets($fp);
         }
         fclose($fp);
         return($linea); 
     }
        
     //////////////////////////////////////////////////////////////////////////////////////
     // GetBloqueoCierre() : Determina si el sistema está bloqueado por el cierre Definit
     //////////////////////////////////////////////////////////////////////////////////////
     function GetBloqueoCierre()
     {
        if(file_exists("tmpcierre.txt"))
           $this->Bloqueado = true;
        else
           $this->Bloqueado = false;          
        return($this->Bloqueado);	
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // GetBloqueoCierre() : Determina si el Browser es el correcto para ingresar a la App
     //////////////////////////////////////////////////////////////////////////////////////
     function GetNavegadorOk()
     {
        $navegador = $this->NavegadorName();
        if(($navegador == "SAFARI")||($navegador == "OPERA")||($navegador == "CHROME"))
          return(true);
        else
          return(false);	
     }
     
     //////////////////////////////////////////////////////////////////////////////////////
     // GetBloqueoCierre() : Determina si el sistema está bloqueado por el Administrador
     //////////////////////////////////////////////////////////////////////////////////////
     function GetSistemaBloqueado()
     {
        $this->Bloqueado = false;
        return($this->Bloqueado);  
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // GetFechaActual() : Detecta la Fecha actual del servidor y la retorna con formato
     //////////////////////////////////////////////////////////////////////////////////////
     function GetFechaActual()
     {
        $semana = array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sabado");
        $mes    = array("","Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
        $this->FechaActual = $semana[(date("w"))].", ".date("d")." de ".$mes[(date("n"))]." de ".date("Y");
        return($this->FechaActual);  
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // NavegadorName() : Detecta el nombre del navegador usado
     //////////////////////////////////////////////////////////////////////////////////////
     function NavegadorName()
     {
        $info      = $this->DatosConexion();
        $navegador = $info["browser"]; 
        return($navegador);
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // ConexionServidor() : Establece una conexion al servidor remoto y retorna si conectó o NO
     //////////////////////////////////////////////////////////////////////////////////////
     function ConexionServidor()
     {
         $url   = 'http://181.143.221.66:9998/produccion/webservicebasico/usuarios';
         $json  = @file_get_contents($url);
         $array = json_decode($json,true);
         if(sizeof($array) == 0)
           return(false);
         else
           return(true);  	
     }
     
     /////////////////////////////////////////////////////////////////////////////////////
     //  AlertaError() : Muestra un mensaje de Alerta segun los parametros 
     //  Tipo : OK  |  ERROR  |  INFO 
     /////////////////////////////////////////////////////////////////////////////////////
     function AlertaError($titulo,$mensaje,$tipo,$txtboton,$opciones="")
     {
        if($tipo == "OK")      {   $tipoboton = "btn-sucess";    $icono = "success";   }
        if($tipo == "AVISO")   {   $tipoboton = "btn-warning";   $icono = "warning";   }
        if($tipo == "ERROR")   {   $tipoboton = "btn-danger";    $icono = "error";   }
        if($tipo == "INFO")    {   $tipoboton = "btn-info";      $icono = "info";      }

        $cont = '<script language="javascript">
                 <!--
                   swal({title: "'.$titulo.'", text: "'.$mensaje.'", type: "'.$icono.'", confirmButtonClass: "'.$tipoboton.'", confirmButtonText: "'.$txtboton.'", closeOnConfirm: true});
                 -->
                </script>';
        return($cont);         
     }

     //////////////////////////////////////////////////////////////////////////////////////
     // DatosConexion() : Detecta ciertos parámetros de la conexion | Browser | IP | O.S
     //////////////////////////////////////////////////////////////////////////////////////
     function DatosConexion()
     {
   	    $browser=array("IE","OPERA","MOZILLA","NETSCAPE","FIREFOX","SAFARI","CHROME");
	    $os=array("WIN","MAC","LINUX");
 
	    # definimos unos valores por defecto para el navegador y el sistema operativo
	    $info['browser'] = "OTHER";
   	    $info['os'] = "OTHER";
 
	    # buscamos el navegador con su sistema operativo
	    foreach($browser as $parent)
	    {
		    $s = strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $parent);
		    $f = $s + strlen($parent);
	 	    $version = substr($_SERVER['HTTP_USER_AGENT'], $f, 15);
	 	    $version = preg_replace('/[^0-9,.]/','',$version);
		    if ($s)
	  	  {
		     	 $info['browser'] = $parent;
		     	 $info['version'] = $version;
		    }
	    }
 
	    # obtenemos el sistema operativo
	    foreach($os as $val)
	    {
		     if (strpos(strtoupper($_SERVER['HTTP_USER_AGENT']),$val)!==false)
			    $info['os'] = $val;
	    }
      
      $this->NavegadorUsado   = $info['browser'];
      $this->SistemaOperatSer = $info['os'];      
	    # devolvemos el array de valores
	    return $info;
      }

  } // Fin de la Clase Index 

  ////////////////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////////////////////////
  $obj = new Index();
  
  $encabezado = '<!DOCTYPE html>
   <html lang="es">
    <head>
      <meta charset="UTF-8">
        <title>'.$obj->CodigoSucursal.' DROPOS v '.$obj->VersionSoft.'</title>
        <link rel="stylesheet" href="css/layout.css"> 
        <link rel="stylesheet" href="lib/sweetalert.css"> 
        <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">  
        <script src="lib/jquery-2.1.3.min.js"></script>
        <script src="lib/sweetalert.js"></script>
    </head>
    <body class="body" id="body">';

 //////////////////////////////////////////////////////////////////////////
 // Aqui se harán las respectivas validaciones para mostrar al usuario 
 // si hay problemas para iniciar sesion. Estos errores estan priorizados
 // desde el mas Critico al menos critico para que No salgan varios
 // errores sino uno a la vez
 //////////////////////////////////////////////////////////////////////////
 $errorx = 0; $opcionlogin = "";

 if((!$obj->GetConexionDB())&&($errorx==0)){
   $error = $obj->AlertaError("No hay Conexion Base de Datos","Por favor reinicie su equipo e intente nuevamente","ERROR","Aceptar");
   $errorx++;     $opcionlogin = "disabled";
 }

 if((!$obj->GetConexionServidor())&&($errorx==0)){
   $error = $obj->AlertaError("No hay Conexión al Servidor","No hay conexión al Servidor Principal del Aplicativo","AVISO","Aceptar"); $errorx++;
 }

 if(($obj->GetBloqueoCierre())&&($errorx==0)){
   $error = $obj->AlertaError("Error","Se está realizando el Cierre Definitivo. Por favor intente dentro de 1 minuto","ERROR","Aceptar"); $errorx++;
   $opcionlogin = "disabled";
 }

 if((!$obj->GetNavegadorOk())&&($errorx==0)){
   $error = $obj->AlertaError("Navegador Incorrecto","Esta utilizando un Navegador NO Autorizado","ERROR","Aceptar"); $errorx++;
   $opcionlogin = "disabled";
 }

$cuerpo = '<ul class="cb-slideshow" id="cb-slideshow">
            <li><span>Image 01</span><div></div></li>
            <li><span>Image 02</span><div></div></li>
            <li><span>Image 03</span><div></div></li>
            <li><span>Image 04</span><div></div></li>
            <li><span>Image 05</span><div></div></li>
            <li><span>Image 06</span><div></div></li>
    </ul>
    <section class="header">
      <div class="colorazul">
       <div class="hora"> '.$obj->FechaActual.' </div>
       <div class="sucursal"> Sucursal : '.$obj->NombreSucursal.' </div>
      </div>
    <div class="colorrojo"></div> 
  </section>
  <section class="main">
    <div class="container">
      <div class="logoheader">
        <h1>DROPOS</h1>
        <h5>Versi&oacute;n '.$obj->VersionSoft.' </h5>
      </div>    
      <div class="containerform">
        <form action="usuarios.php?opcion=login" method="POST" class="formulario" name="x">
        <input type="hidden" name="browser" value="'.$obj->NavegadorUsado.'">         
        <input type="hidden" name="os" value="'.$obj->SistemaOperatSer.'">         
        <input type="hidden" name="browser" value="'.$obj->NavegadorUsado.'">       
          <label for="usuario">Nombre de usuario</label>
          <div class="inputicon">
            <span class="fa fa-user"></span>
            <input type="text" name="usuario" id="usuario" class="entrada usuario" value="'.$_COOKIE["ult_username_administrativo"].'" placeholder="Ingrese su usuario"'.$opcionlogin.'>
          </div>
          <div class="inputicon">
            <label for="contrasenia">Contraseña</label>
            <span class="fa fa-keyboard-o "></span>
            <input type="password" name="clave" id="contrasenia" class="entrada" placeholder="Ingrese su contraseña"'.$opcionlogin.'>          
          </div>
          <div class="mantenersesion">
            <input type="checkbox" id="recordarme" class="checkrecordar">
            <label for="recordarme">Recordarme.</label>         
          </div>
          <input type="submit" class="button ingresar" value="Ingresar" '.$opcionlogin.'>
          <a href="#" class="olvidocontrasena">¿Olvido su contraseña?</a>
        </form>
      </div>    
    </div>  
    </section>';

$pie = '<div class="footerWhite">
      <footer class="footer">
        <ul class="entradasfooter">
          <li><a href="" class="footertext">Politicas de Privacidad</a></li>
          <li><a href="" class="footertext">Condiciones de servicio</a></li>
          <li><a href="" class="footertext">Copyright 2006 Dromedicas del Oriente</a></li>
        </ul>
      </footer>     
    </div> <!-- fin de footerWhite -->
</body>
</html>';

echo $encabezado.$error.$cuerpo.$pie;
?>