<?PHP
    @session_start(); 

    require_once("classes/class_validaciones.php");
    $io_fecha=new class_validaciones();

    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarnovedades
    // Creación: 22/11/2024		última modificación: 08/04/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción donde se administra las operaciones de las novedades de un 
    //              periodo
    // Última modificación: Total de licencias (23/11/2024)
    //                      Inclusión del botón para descargar en una hoja de Excel las 
    //                      novedades del periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarnovedades")
    {
        $periodoid = $_GET["periodoidanterior"];

        // nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // valido que el archivo de mostrar errores exista
        $archivoerror = "reportes/errores.txt";
        if (file_exists ($archivoerror))
            $htmlarchivoerror = '<a href="?opcion=vererroresnovedades&periodoid='.$periodoid.'" rel="facebox">
                                  <img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&eacute;dulas de empleados no guardados en el &uacute;ltimo proceso de importaci&oacute;n">
                                 </a>';
        else
            $htmlarchivoerror = '<img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&eacute;dulas de empleados no guardados en el &uacute;ltimo proceso de importaci&oacute;n">';

        // consulta de la vista
        $vsql = "SELECT t.codvende, t.`dni`, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        c.`nomconcepto`, d.`valor` , IF(c.tipodc = 'C',d.devengados,d.`descuentos`) monto, c.tipodc, d.devengados, d.descuentos, d.detalleid  
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                        INNER JOIN terceros t ON (d.terid = t.terid)
                  WHERE d.pernominaid = ".$periodoid." 
                        AND c.eslicencia = 'CHECKED'  
               ORDER BY 1";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                  <td width="800"> <b> Novedades <br> <font color="blue"> '.$descripcion.' </font> </b> </td>
                  <td width="30"> 
                   <a href="?opcion=descargarnovedades&periodoid='.$periodoid.'" target="_blank"> 
                    <img src="images/iconos/descargar.png" width="32" height="32" border="0" title="bajar informaci&oacute;n de libranzas"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=ventataimportarnov&periodoid='.$periodoid.'" rel="facebox">
                    <img src="images/iconos/cargar.png" title="Subir novedades" border="0" width="32" height="32"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30" align="center"> '.$htmlarchivoerror.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=ventanaincnovedad&periodoid='.$periodoid.'" rel="facebox"> 
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="nuevo recargo nocturno"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="40" align="center"> 
                   <a href="importacionexcelnom.php?opcion=ventanaimportacion"> 
                    <input type="button" value="<<" class="button blue" title="ventana principal"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>                  
                 </tr> 
                </table>';

        // títulos        
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="11"> &nbsp; </td>
                   <td width="120" align="left"> Documento </td>
                   <td width="360" align="left"> Empleado </td>                   
                   <td width="320" align="left"> Concepto </td>
                   <td width="60" align="right"> D&iacute;as </td>
                   <td width="150" align="right"> Monto </td>
                   <td width="60"> &nbsp; </td>
                   <td width="60"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';

        // detalle de la ventana
        $i = 0;         $totaldevengados = 0;           $totaldeducciones = 0;          $totaldias = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="11"> &nbsp; </td>
                     <td width="120" align="left"> '.$row['dni'].' </td>
                     <td width="340" align="left"> '.$row['nombreemp'].' </td>
                     <td width="240" align="left"> '.$row['nomconcepto'].' </td>
                     <td width="125" align="right"> '.number_format($row['valor']).' </td>
                     <td width="145" align="right"> '.number_format($row['monto']).' </td>                     
                     <td width="14" align="right"> &nbsp; </td>
                     <td width="26" align="center">
                      <a href="?opcion=confirmareliminarnovedad&detalleid='.$row['detalleid'].'&periodoid='.$periodoid.'" rel="facebox">
                       <img src="images/basicas/borrados.png" title="eliminar liquidaci&oacute;n" border="0" width="20" height="20">
                      </a>
                     </td>
                     <td width="26" align="center">
                      <a href="?opcion=ventanaeditnov&detalleid='.$row['detalleid'].'" rel="facebox">
                       <img src="images/basicas/iconobuscar.png" border="0" width="20" height="20" title="editar liquidaci&oacute;n" border="0">
                      </a>                         
                     </td>
                     <td width="26" align="center">
                      <a href="recibodepago.php?opcion=negativo&periodoid='.$periodoid.'&dni='.$row['dni'].'" target="_blank">
                       <img src="images/basicas/pdf.png" title="ver recibo de pago" border="0" width="20" height="20">
                      </a>                     
                     </td>
                    </tr>';

            // incremento de los totales
            if($row['tipodc'] == "C")
                $totaldevengados += $row['devengados'];
            else
                $totaldeducciones += $row['descuentos'];

            $totaldias += $row['valor'];
        }

        $cont.=' </tbody>
                </table>';

        // Impresión de los totales
        $cont.='<table width="100%">
                 <tr class="TituloTabla">
                  <td width="140"> &nbsp; </td>
                  <td width="320" align="left"> <b> <font color="white"> Total d&iacute;as: '.number_format($totaldias).' </font> </b> </td>
                  <td width="80"> &nbsp; </td>
                  <td width="475" align="left"> <b> <font color="white"> Total en devengados: '.number_format($totaldevengados).' </font> </b> </td>
                  <td width="100"> &nbsp; </td>
                  <td width="475" align="left"> <b> <font color="white"> Total en deducciones: '.number_format($totaldeducciones).' </font> </b> </td>
                  <td width="182"> &nbsp; </td>
                 </tr>
                </table>';

        echo $cont.$clase->PiePagina();
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaincnovedad
    // Creación: 22/11/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para incluir una novedad a un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaincnovedad")
    {
        $periodoid = $_GET["periodoid"];

        // nombre del periodo
        $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado=="CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        $params = ' class="Texto11" ';

        // combo de empleados
        $vsqlcomboemp = "SELECT terid,  CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                           FROM $tabla 
                          WHERE esempleadoactivo = 'CHECKED' 
                                AND basico > 0
                       ORDER BY primernombre";
        $comboempledos = $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,520);

        // combo de licencias
        $vsqlcombolic = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE eslicencia='CHECKED' ORDER BY conceptoid";
        $combonovedades = $clase->CrearComboBuscar("conceptoid",$vsqlcombolic,"nombres","conceptoid","","N",$params,420);

        $dias = 1;

        // pinto la ventana
        $cont ='<table width="700">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
                  <td width="650" align="center"> <b> Incluir Novedad <br> <font color="BLUE"> '.$descripcion.'</font> </b> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardarnovedad" method="POST" name="x">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="700">
                 <center>
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <td width="100" align="right"> <label class="Texto12"> Empleado: </label> </td>
                  <td width="600"> &nbsp; '.$comboempledos.' </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <td width="100" align="right"> <label class="Texto12"> Licencia: </label> </td>
                  <td width="600"> &nbsp; '.$combonovedades.' </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <td width="100" align="right"> <label class="Texto12"> D&iacute;as: </label> </td>
                  <td width="600">
                   &nbsp;
                   <input type="number" name="dias" min="1" max="180" class="Texto12New" size="12" style="width:80px;height:25px;" autocomplete="off" title="días de la licencia" value="'.$dias.'">
                  </td>
                 </tr>
                </table>
                <table width="700">
                <tr class="BarraDocumentos" style="height:40px;Important!">
                 <td width="700" align="center">
                  <input type="submit" value="aceptar" class="button blue">
                  <a href="?opcion=importarnovedades&periodoidanterior='.$periodoid.'"><input type="button" value="CANCELAR" class="button red"></a>
                  </form>
                 </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnovedad
    // Creación: 22/11/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena una novedad a un empleado en el periodo actual
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnovedad")
    {
        $periodoid = $_POST["periodoid"];
        $terid = $_POST["terid"];
        $conceptoid = $_POST["conceptoid"];
        $dias = $_POST["dias"];

        // Inicialización de variables
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $valorperiodo = 0;
        $valorconcepto = 0;
        $diff = 0;
        $difendias = 0;
        $diaspendiente = 0;

        // Valido que el periodo esté procesado en la tabla detalle de nómina
        $vsql = "SELECT count(*) 
                   FROM detallenomina
                  WHERE pernominaid = ".$periodoid;
        $valorperiodo = $clase->SeleccionarUno($vsql);

        if($valorperiodo==0)        
            $clase->Aviso(3,"No se puede procesar este concepto porque el periodo $descripcion no ha sido procesado");        
        else
        {
            // Inicializo las variables
            $basico = 0;                            $formulabasico = "";                            $diastrab = 0;
            $detalleid = 0;                         $sueldo = 0;                                    $numid = 0;
            $licencianorem = 0;                     $formulatransporte = "";                        $subsidiotransporte = 0;
            $lbpaso = false;                        $formulasuspencion = "";                        $suspension = 0;
            $formulaincapacidad = "";               $incapacidad = 0;                               $formulapaternidad = "";
            $paternidad = 0;                        $totnovedades = 0;                              $sueldostr = "";
            $centenas = "";                         $centenasnum = 0;                               $sueldodeducciones = 0;
            $formulapension = "";                   $pension = 0;                                   $detalleid = 0;
            $formulasalud = "";                     $salud = 0;                

            // Obtengo el salario básico del empleado
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado == "CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            $basico = $clase->BDLockup($terid,$tabla,'terid','basico');

            // Obtengo la formula del sueldo
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
            $formulabasico = $clase->SeleccionarUno($vsql);

            // Obtengo los días trabajados en el periodo
            $vsql = "SELECT valor
                       FROM detallenomina 
                      WHERE conceptoid = 1  
                            AND pernominaid = ".$periodoid."
                            AND terid = ".$terid."";
            $diastrab = $clase->SeleccionarUno($vsql);            

            // Obtengo el ID del registro que se modificará
            $vsql = "SELECT detalleid
                       FROM detallenomina 
                      WHERE conceptoid = 1  
                            AND pernominaid = ".$periodoid."
                            AND terid = ".$terid."";
            $detalleid = $clase->SeleccionarUno($vsql);

            // ------------------------------------------------------------------------ //
            $diastrab -= $dias;

            eval("\$sueldo = $formulabasico;");
            $sueldo = round($sueldo,0);

            // Almaceno en nuevo sueldo
            $vsql = "UPDATE detallenomina SET 
                            devengados = ".$sueldo.", 
                            valor = ".$diastrab."
                      WHERE detalleid = ".$detalleid."";
            $clase->EjecutarSQL($vsql);

            $vsql32 = "SELECT devengados AS sueldodev FROM detallenomina WHERE detalleid = ".$detalleid;
            $sueldodev = $clase->SeleccionarUno($vsql32);

            if($sueldodev >= 0)
            {
                // Calculo el nuevo ID
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numid = $clase->SeleccionarUno($vsql);
                $numid++;                    

                // Inserto la nueva licencia

                // Obtengo la formula de la licencia
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                $formulalice = $clase->SeleccionarUno($vsql);

                // Calculo la licencia
                if($conceptoid!=10)
                {
                    eval("\$montolicencia = $formulalice;");
                    $montolicencia = round($montolicencia,0);
                }
                else
                {
                    // Calculo la incapacidad                        

                    // Obtengo el salario mínimo legal vigente
                    $smlv = $_SESSION['N_SALMIN2020'];

                    // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                    if($basico<=$smlv)
                    {                            
                        $montolicencia = ($smlv*$dias)/30;
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        $porcbasico = ($basico*66.67)/100;
                        $porcbasico = round($porcbasico,0);

                        // Calculo la incapacidad si el básico sea mayor al mínimo 
                        if($porcbasico>$smlv)
                        {
                            $montolicencia = ($porcbasico*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                            if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                            $montolicencia = round($montolicencia,0);
                        }
                    }
                }

                // ------------------------------------------------------------------------------------------------------------------- //                    
                // Obtengo el tipo de licencia
                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                // ------------------------------------------------------------------------------------------------------------------- //
                // Determino si el registro existe para modificarlo o incluirlo
                $vsql = "SELECT COUNT(*) AS repetida 
                           FROM detallenomina
                          WHERE pernominaid = ".$periodoid."
                                AND conceptoid = ".$conceptoid."
                                AND terid = ".$terid."";
                $repetida = $clase->SeleccionarUno($vsql);

                // ------------------------------------------------------------------------------------------------------------------- //
                if($repetida==0)
                {
                    if($tipodc=="C")
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                    else
                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
                }
                else 
                {
                    // Determino el id del registro
                    $vsql = "SELECT detalleid AS detalleid 
                               FROM detallenomina
                              WHERE pernominaid = ".$periodoid."
                                    AND conceptoid = ".$conceptoid."
                                    AND terid = ".$terid."";
                    $detalleid = $clase->SeleccionarUno($vsql);

                    $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
                    $valor += $dias;

                    // Actualizo la licencia
                    if($tipodc=="C")
                    {
                        $devengados = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
                        $devengados += $montolicencia;
                        
                        $vsql = "UPDATE detallenomina SET 
                                        devengados = ".$devengados.", 
                                        valor = ".$valor."
                                  WHERE detalleid = ".$detalleid."";
                    }
                    else
                    {
                        $descuentos = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
                        $descuentos += $montolicencia;

                        $vsql = "UPDATE detallenomina SET 
                                        descuentos = ".$descuentos.", 
                                        valor = ".$valor."
                                  WHERE detalleid = ".$detalleid."";
                    }
                }
            }
            $clase->EjecutarSQL($vsql);

            // ---------------------------------------------------------------------------------------------------------- //
            // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos

            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];

            $cargoid = $clase->BDLockup($terid,'tercerosactual','terid','cargoid');                       // Obtengo el cargo del empleado
            $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte            

            if($diastrab > 0)
            {
                // Variable para la validación del auxilio de transporte
                $valsubtrasp = $smlv * 2;                
    
                if(($basico <= $valsubtrasp) && ($aplicatransporte == "CHECKED"))
                {    
                    // Obtengo la formula del subsidio de transporte
                    $auxtrans = $_SESSION['N_AUXTRANS2020'];
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                    $formulatransporte = $clase->SeleccionarUno($vsql);
    
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);                    
                }
                else
                    $subsidiotransporte = 0;
            }
            else
                $subsidiotransporte = 0;
            
            // ID transporte
            $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
            $idtransporte = $clase->SeleccionarUno($vsql);
    
            if($idtransporte!="")        
                // Grabo el subsidio de transporte
                $vsql = "UPDATE detallenomina SET 
                                devengados = ".$subsidiotransporte.",
                                valor = ".$diastrab."
                          WHERE detalleid = ".$idtransporte."";        
            else
            {
                // Obtengo el valor del subsidio de transporte
                $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
    
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";            
            }    
            $clase->EjecutarSQL($vsql);

            // ----------------------------------------------------------------------------------------------------------- //
            // Obtengo el total devengado por novedades
            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";                
            $totnovedades = $clase->SeleccionarUno($vsql);

            $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
            $totrecargos = $clase->SeleccionarUno($vsql);

            // Actualizo el sueldo
            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

            $extralegal = $clase->BDLockup($terid,'tercerosactual','terid','extralegal');
            $epsid = $clase->BDLockup($terid,'tercerosactual','terid','epsid');
            $pensionesid = $clase->BDLockup($terid,'tercerosactual','terid','pensionesid');
            
            if($epsid==NULL)                $epsid=0;
            if($pensionesid==NULL)          $pensionesid=0;

            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');   // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');   // Obtengo el control del cálculo de salud

            if($extralegal == "CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5) || ($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);

                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }

                if(($epsid==37) || ($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }                    
            }                

            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);

            if($idpension!="")            
                // Grabo la pensión
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);

            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);

            if($idsalud!="")
                // Grabo la salud
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);

            // ----------------------------------------------------------------------------------------------------------- //            
            // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
            $vsql = "DELETE FROM detallenomina WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid;
            $clase->EjecutarSQL($vsql);            

            // emito el mensaje correspondiente
            $clase->Aviso(1,"Novedad procesada satisfactoriamente");
        }

        // Redirecciono el formulario
        header("Location: importarexcelnom.php?opcion=importarnovedades&periodoidanterior=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmareliminarnovedad
    // Creación: 22/11/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la venta para confirmar la eliminación de una novedad
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmareliminarnovedad")
    {
        $detalleid = $_GET["detalleid"];
        $periodoid = $_GET["periodoid"];

        // datos de la novedad
        $terid = $clase->BDLockup($detalleid,'detallenomina','detalleid','terid');
        $nomreemp = "CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)";
        $nombreempleado = $clase->BDLockup($terid,'terceros','terid',$nomreemp);        
        $conceptoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','conceptoid');
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');

        // Pinto la ventana
        $cont= '<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="350" align="center"><br><label class="Texto12"><b>Eliminar novedad </b> </label> <br><br> </td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="400" align="center">
                   <br>
                   <label class="Texto12">
                   ¿Confirma que desea eliminar <br> <b> '.$nomconcepto.' </b> de <br> <b> '.$nombreempleado.' </b> <br> de <b> '.number_format($valor).' </b> d&iacute;as? 
                   </label> 
                  </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminanovedad" method="POST">
                   <input type="hidden" name="detalleid" value="'.$detalleid.'"> 
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">                   
                   <input type="submit" value="ACEPTAR" class="button blue">                   
                   <a href="importarexcelnom.php?opcion=importarnovedades&periodoidanterior='.$periodoid.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminanovedad
    // Creación: 22/11/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina una novedad de un empleado en un periodo y recalcula 
    //              el resto de los conceptos involucrados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminanovedad")
    {
        $detalleid = $_POST["detalleid"];
        $periodoid = $_POST["periodoid"];

        $conceptoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','conceptoid');
        $terid = $clase->BDLockup($detalleid,'detallenomina','detalleid','terid');

        // Inicializo las variables
        $diasconcepto = 0;                          $diastrab = 0;                      $detalleid = 0;
        $formulabasico = "";                        $sueldo = 0;                        $basico = 0;
        $smlv = 0;                                  $valsubtrasp = 0;                   $auxtrans = 0;
        $formulatransporte = "";                    $subsidiotransporte = 0;            $lb_grabosueldo = false;
        $numlicpendientes = 0;

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado=="CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        // Nombre del empleado
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                   FROM ".$tabla." 
                  WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql);

        // Nombre del concepto
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');

        // Obtengo los días del concepto que se eliminará
        $vsql = "SELECT SUM(valor) AS diasconcepto FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $diasconcepto = $clase->SeleccionarUno($vsql);

        $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $clase->EjecutarSQL($vsql);

        if(mysql_affected_rows() < 1)
            $clase->Aviso(3,"No se eliminó el concepto $nomconcepto al empleado $nombreemp");
        else
        {
            // Determino el ámbito del concepto
            $eslibranza = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','eslibranza');
            $eslicencia = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','eslicencia');
            $montoocasional = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','montoocasional');
            $montopermanente = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','montopermanente');

            // Valido si es una libranza o licencia para recalcular lo correspondiente a ese caso
            if($eslicencia == "CHECKED")
            {
                // Obtengo el salario básico del empleado
                $basico = $clase->BDLockup($terid,'tercerosactual','terid','basico');
    
                // Obtengo los días trabajados en el periodo
                $vsql = "SELECT valor
                           FROM detallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $diastrab = $clase->SeleccionarUno($vsql);

                if(strlen($diastrab) == 0)
                    $diastrab = 0;
    
                // Obtengo el ID del registro que se modificará
                $vsql = "SELECT detalleid
                           FROM detallenomina 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $detalleid = $clase->SeleccionarUno($vsql);
    
                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
    
                // Recalculo el sueldo del periodo
                $diastrab += $diasconcepto;
                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
    
                // Almaceno en nuevo sueldo
                if(strlen($detalleid) > 0)
                    $vsql = "UPDATE detallenomina SET devengados = ".$sueldo.", valor = ".$diastrab." WHERE detalleid = ".$detalleid."";
                else
                {
                    $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detallenomina");
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico)";
                }
                $clase->EjecutarSQL($vsql);

                // Ahora voy a recalcular el subsidio de transporte si es necesario

                // Obtengo el salario mínimo legal vigente
                $smlv = $_SESSION['N_SALMIN2020'];
    
                // Variable para la validación del auxilio de transporte
                $valsubtrasp = $smlv * 2;

                $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');                               // Obtengo el cargo del empleado
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');       // Obtengo el control del cálculo de subsidio de transporte

                if($diastrab > 0)
                {
                    if(($basico <= $valsubtrasp) && ($aplicatransporte == "CHECKED"))
                    {    
                        // Obtengo la formula del subsidio de transporte
                        $auxtrans = $_SESSION['N_AUXTRANS2020'];
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                        $formulatransporte = $clase->SeleccionarUno($vsql);
        
                        eval("\$subsidiotransporte = $formulatransporte;");
                        $subsidiotransporte = round($subsidiotransporte,0);
                    }
                    else
                        $subsidiotransporte = 0;
                }
                else
                    $subsidiotransporte = 0;

                // ID transporte
                $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                $idtransporte = $clase->SeleccionarUno($vsql);
        
                // Grabo el subsidio de transporte
                if($idtransporte!="")
                    $vsql = "UPDATE detallenomina SET 
                                    devengados = ".$subsidiotransporte.",
                                    valor = ".$diastrab."
                                WHERE detalleid = ".$idtransporte."";
                else
                {
                    // Obtengo el valor del subsidio de transporte
                    $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
        
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                }
                $clase->EjecutarSQL($vsql);                    

                // ----------------------------- //
                // Recalculo la pensión
                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.eslicencia = 'CHECKED' AND c.tipodc = 'C') ";
                $totnovedades = $clase->SeleccionarUno($vsql);

                $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.recargo = 'CHECKED' AND c.tipodc = 'C')";
                $totrecargos = $clase->SeleccionarUno($vsql);

                // Actualizo el sueldo                
                $sueldo  = $sueldo + $totnovedades + $totrecargos;
                $sueldodeducciones = $sueldo;

                // ------------------------------------------------------------------------------------------------------------- //
                // Obtengo la formula para el descuento por pensión
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                $formulapension = $clase->SeleccionarUno($vsql);

                // Obtengo la formula para el descuento de salud
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                $formulasalud = $clase->SeleccionarUno($vsql);

                // Determino si el empleado es de condición extralegal
                $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
                $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
                
                if($epsid==NULL)
                    $epsid=0;
                if($pensionesid==NULL)
                    $pensionesid=0;

                // ----------------------------------------------------------------------------------------------------------- //
                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
                if($extralegal=="CHECKED")
                {
                    $pension = 0;
                    $salud = 0;
                }
                else
                {
                    // Recalculo pensión y salud
                    if(($pensionesid==5)||($aplicapension!="CHECKED"))
                        $pension = 0;
                    else
                    {
                        // Obtengo la formula para el descuento por pensión
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                        $formulapension = $clase->SeleccionarUno($vsql);
    
                        // Calculo la pensión
                        eval("\$pension = $formulapension;");
                        $pension = round($pension,0);
                    }
    
                    if(($epsid==37)||($aplicasalud!="CHECKED"))
                        $salud = 0;
                    else
                    {
                        // Obtengo la formula para el descuento de salud
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                        $formulasalud = $clase->SeleccionarUno($vsql);
                        
                        // Calculo la salud
                        eval("\$salud = $formulasalud;");
                        $salud = round($salud,0);
                    }
                }
    
                //  ID pensión
                $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                $idpension = $clase->SeleccionarUno($vsql);
    
                if($idpension!="")
                    // Grabo la pensión
                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$pension.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idpension."";
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
    
                // ID salud
                $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                $idsalud = $clase->SeleccionarUno($vsql);
    
                if($idsalud!="")
                    // Grabo la salud
                    $vsql = "UPDATE detallenomina SET 
                                    descuentos = ".$salud.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idsalud."";
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                }    
                $clase->EjecutarSQL($vsql);

                // ------------------------------------------------------------------------------------------------------------- //
                // Obtengo el id del pendiente
                $vsql3 = "SELECT MAX(pendienteid) AS pendienteid 
                            FROM licenciaspendiente 
                           WHERE terid = ".$terid."
                                 AND conceptoid = ".$conceptoid."";
                $pendienteid = $clase->SeleccionarUno($vsql3);

                $vsql = "DELETE FROM licenciaspendiente WHERE pendienteid = ".$pendienteid."";
                $clase->EjecutarSQL($vsql);

            }
            else
            {
                $vsql = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoid." AND terid = ".$terid." AND conceptoid = ".$conceptoid."";
                $clase->EjecutarSQL($vsql);                
            }
        }

        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
        $vsql = "DELETE FROM detallenomina WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid." AND terid = ".$terid."";
        $clase->EjecutarSQL($vsql);

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Se eliminó exitosamente el concepto $nomconcepto al empleado $nombreemp");

        // Redirecciono el formulario
        header("Location: importarexcelnom.php?opcion=importarnovedades&periodoidanterior=$periodoid");
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventataimportarnov
    // Creación: 22/11/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con las 
    //              novedades que serán incluidas en un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventataimportarnov")
    {
        $periodoid = $_GET["periodoid"];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor dir&iacute;jase al servidor </font> <br>
                       <a href="http://192.168.14.248:9999/dropos/login/" target="_blank"> 
                        <font color=blue> 192.168.14.248:9999 </font> <br>                        
                       </a>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importarexcelnom.php?opcion=importarnovedades&periodoidanterior='.$periodoid.'" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            $descripcionant = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');            

            // Combo de conceptos
            $params = ' class="Texto12" ';
            $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto FROM conceptosnomina WHERE eslicencia = 'CHECKED' ORDER BY conceptoid ASC";

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar novedades<br> <font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importarexcelnom.php?opcion=procesarnovedades" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">        
                       <input type="file" name="excel" /><br><br>                            
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';

            // Valido que existan licencias pendientes para emitir el mensaje correspondiente
            $vsql = "SELECT COUNT(d.conceptoid) AS numlicenciaspro
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.pernominaid = ".$periodoid."
                            AND c.eslicencia = 'CHECKED'";
            $numlicenciaspro = $clase->SeleccionarUno($vsql);

            if($numlicenciaspro > 0)
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> 
                          <td width="10" align="right">                           
                           <img src="images/iconos/alerta.png" width="30" height="30" border="0">
                          </td>
                          <td width="390" align="center">
                           <font color="red"> <b> Advertencia: Ya existen novedades procesadas <br> en el periodo </b> </font>
                          </td>
                         </tr>
                        </table>';            

            $variab = 'G_NOFECHALIC';
            $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

            if($nofechalic == "CHECKED")
            {
                $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                $fecdesde2  = substr($fecdesde,8,2)."/".substr($fecdesde,5,2)."/".substr($fecdesde,0,4);
                $mensajefecha = 'Fecha <b>'.$fecdesde2.'</b> para todas';
            }
            else
                $mensajefecha = 'Fecha <b>(formato texto)</b>';

            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: '.$mensajefecha.' </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: D&iacute;as </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: Tipo de licencia: </td> </tr> 
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b>6</b> </font> LICENCIA NO REMUNERADA <font color="blue"> <b>9</b> </font> SUSPENCION <font color="blue"> <b>10</b> </font> INCAPACIDAD
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b>11</b> </font> LICENCIA POR MATERNIDAD <font color="blue"> <b>12</b> </font> LICENCIA POR PATERNIDAD
                      </td>
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b>13</b> </font> LICENCIA REMUNERADA <font color="blue"> <b>23</b> </font> LICENCIA POR CUMPLEAñOS 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b>31</b> </font> MATRIMONIO <font color="blue"> <b>40</b> </font> INCAPACIDAD ARL 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b>43</b> </font> INC SUPERIOR A 180 D&Iacute;AS <font color="blue"> <b>46</b> </font> DIA DE LA FAMILIA 
                      </td> 
                     </tr>
                    </table>';

            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplolicencias2.png" width="300" height="200" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx </font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: procesarnovedades
    // Creación: 22/11/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que importa desde una hoja de Excel las novedades en un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "procesarnovedades")
    {
		set_time_limit(0);
		extract($_POST);
        $periodoid = $_POST["periodoid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);        

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importarexcelnom.php?opcion=importarnovedades&periodoidanterior=$periodoid");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['fecdesde'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i);
                    $_DATOS_EXCEL[$i]['dias'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['conceptoid'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)||(strlen($_DATOS_EXCEL[$i]['fecdesde']) == 0)||(strlen($_DATOS_EXCEL[$i]['dias']) == 0)||(strlen($_DATOS_EXCEL[$i]['conceptoid']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";                

            // ------------------------------------------------------------------------------------------ //
            // Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            $variab = 'G_NOFECHALIC';
            $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'NOVEDADES'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($descripcion,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $motivo = "";
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];

                $valreg = 0;
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],$tabla,"dni","terid");
                
                if($terid != "")
                {
                    // Valido que el empleado esté activo
                    $esempleadoactivo = $clase->BDLockup($terid,$tabla,'terid','esempleadoactivo');                    

                    if($esempleadoactivo=="CHECKED")
                    {
                        $lb_valido = false;
                        $lb_valido2 = false;
                        $lb_valida3 = false;
    
                        $fecdesde = $_DATOS_EXCEL[$j]['fecdesde'];
                        $dias = $_DATOS_EXCEL[$j]['dias'];
                        $conceptoid = $_DATOS_EXCEL[$j]['conceptoid'];                        
                        
                        // Valido la entrada de los datos de la hoja de Excel
                        $lb_valido = $io_fecha->uf_solo_numeros($dias);         // Valido la columna de los días
                        $lb_valido2 = validar_fecha_espanol($fecdesde);         // Valido la columna de la fecha                        

                        // Valido que el concepto sea una licencia
                        $vsql = "SELECT eslicencia
                                   FROM conceptosnomina 
                                  WHERE conceptoid = ".$conceptoid;
                        $eslicencia = $clase->SeleccionarUno($vsql);
                        
                        if(($lb_valido)&&($lb_valido2)&&($eslicencia == "CHECKED"))
                        {
                            // Valido que la fecha esté dentro del periodo
                            $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                            $fecdesde2 = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                            $fecdesde3 = substr($fecdesde,6,4)."-".substr($fecdesde,3,2)."-".substr($fecdesde,0,2);

                            if($nofechalic == "CHECKED")
                                $fecdesde3 =  $fecdesde2;
    
                            $lb_valida3 = verifica_rango($fecdesde2,$fechasta,$fecdesde3);                            
    
                            if($lb_valida3)
                            {
                                $vsql = "SELECT count(*) AS numreg 
                                           FROM detallenomina 
                                          WHERE terid = ".$terid." 
                                                AND pernominaid = ".$periodoid." 
                                                AND conceptoid IN (1,3,4,5)";
                                $numreg = $clase->SeleccionarUno($vsql);

                                if($numreg==0)
                                {
                                    // Calculo el nuevo ID
                                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                                    $numid = $clase->SeleccionarUno($vsql);
                                    $numid++;
    
                                    // Inserto la nueva licencia
    
                                    // Obtengo la formula de la licencia
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                    $formulalice = $clase->SeleccionarUno($vsql);

                                    $basico = $clase->BDLockup($terid,$tabla,'terid','basico');             // salario básico
    
                                    // Calculo la licencia
                                    if($conceptoid!=10)
                                    {
                                        eval("\$montolicencia = $formulalice;");
                                        $montolicencia = round($montolicencia,0);
                                    }
                                    else
                                    {
                                        // Calculo la incapacidad
    
                                        // Obtengo el salario mínimo legal vigente
                                        $smlv = $_SESSION['N_SALMIN2020'];                                        
    
                                        // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                                        if($basico<=$smlv)
                                        {
                                            $montolicencia = ($smlv*$dias)/30;
                                            $montolicencia = round($montolicencia,0);
                                        }
                                        else
                                        {
                                            $porcbasico = ($basico*66.67)/100;
                                            $porcbasico = round($porcbasico,0);
    
                                            // Calculo la incapacidad si el básico sea mayor al mínimo
                                            if($porcbasico>$smlv)
                                            {
                                                $montolicencia = ($porcbasico*$dias)/30;
                                                $montolicencia = round($montolicencia,0);
                                            }
                                            else
                                            {
                                                if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                                if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;
    
                                                $montolicencia = round($montolicencia,0);
                                            }
                                        }
                                    }

                                    // Obtengo el tipo de licencia
                                    $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                    if($tipodc=="C")
                                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                                    else
                                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";

                                    $clase->EjecutarSQL($vsql);

                                    if(mysql_affected_rows() >= 1)
                                    {
                                        $grabados++;
                                        $lbgrabo = true;
                                    }
                                }
                                else
                                {
                                    // inicialización de variables
                                    $difendias = 0;                         $basico = 0;                        $diastrab = 0;
                                    $detalleid = 0;                         $numid = 0;                         $formulabasico = "";
                                    $formulalice = "";                      $montolicencia = 0;                 $porcbasico = 0;
                                    $tipodc = "";                           $repetida = 0;                      $valor = 0;
                                    $descuentos = 0;                        $smlv = 0;                          $cargoid = 0;
                                    $aplicatransporte = "";                 $auxtrans = 0;                      $formulatransporte = "";
                                    $subsidiotransporte = 0;                $numreg = 0;                        $totnovedades = 0;
                                    $sueldodeducciones = 0;                 $sueldo = 0;                        $epsid = 0;
                                    $pensionesid = 0;                       $aplicapension = "";                $aplicasalud = "";
                                    $pension = 0;                           $salud = 0;                         $formulapension = "";
                                    $formulasalud = "";                     $idpension = 0;                     $idsalud = 0;
                                    $diaspendiente = 0;
    
                                    // días de la licencia
                                    $fecha1= new DateTime($fecdesde3);
                                    $fecha2= new DateTime($fechasta);
                                    $diff = $fecha1->diff($fecha2);
                                    
                                    $difendias = $diff->days;
                                    $difendias += 1;
    
                                    // ----------------------------------------------------------------------------------------------------------------------------- //                                        
                                    $suma = "+".strval($dias-1)." day";
                                    $date_fin = strtotime(".$suma.", strtotime($fecdesde3));
                                    $date_fin = date('Y-m-d', $date_fin);
    
                                    if($date_fin > $fechasta)
                                    {
                                        // Aquí guardo en la tabla correspondiente el exceso en días 
                                        // para ser calculado en próximos periodos
                    
                                        $diaspendiente = $dias - $difendias;
                    
                                        // --------------------------------------------------------------------------------------------------------- //
                                        $feciniper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                                        $diadesde = substr($feciniper, -2);
                    
                                        if($diadesde=="16")
                                        {
                                            $fecfinper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                                            $fechaEntera = strtotime($fecfinper);
                                            $valdias = date("d", $fechaEntera);
                    
                                            if($valdias=="28")              $diaspendiente -= 2;
                                            if($valdias=="29")              $diaspendiente -= 1;
                                            if($valdias=="31")              $diaspendiente += 1;
                                        }
                                        // --------------------------------------------------------------------------------------------------------- //                
                                        $dias -= $diaspendiente;
                    
                                        $procesado = "";
                                        $vsql = "SELECT periodoid 
                                                   FROM periodosnomina 
                                                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE periodoid > $periodoid)";
                                        $periodoapagar = $clase->SeleccionarUno($vsql);
                    
                                        $vsql = "INSERT INTO licenciaspendiente (terid,conceptoid,dias,periodoapagar,procesado) 
                                                                         VALUES (".$terid.",".$conceptoid.",".$diaspendiente.",".$periodoapagar.",'".$procesado."')";
                                        $clase->EjecutarSQL($vsql);
                                    }                                
                                    // ----------------------------------------------------------------------------------------------------------------------------- //
    
                                    // Obtengo el salario básico del empleado
                                    $basico = $clase->BDLockup($terid,$tabla,'terid','basico');
                        
                                    // Obtengo la formula del sueldo
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                                    $formulabasico = $clase->SeleccionarUno($vsql);
                        
                                    // Obtengo los días trabajados en el periodo
                                    $vsql = "SELECT valor
                                               FROM detallenomina 
                                              WHERE conceptoid = 1  
                                                    AND pernominaid = ".$periodoid."
                                                    AND terid = ".$terid."";
                                    $diastrab = $clase->SeleccionarUno($vsql);
                        
                                    // Obtengo el ID del registro que se modificará
                                    $vsql = "SELECT detalleid
                                               FROM detallenomina 
                                              WHERE conceptoid = 1  
                                                    AND pernominaid = ".$periodoid."
                                                    AND terid = ".$terid."";
                                    $detalleid = $clase->SeleccionarUno($vsql);
    
                                    $diastrab -= $dias;
    
                                    eval("\$sueldo = $formulabasico;");
                                    $sueldo = round($sueldo,0);
                        
                                    // Almaceno en nuevo sueldo
                                    $vsql = "UPDATE detallenomina SET 
                                                    devengados = ".$sueldo.", 
                                                    valor = ".$diastrab."
                                              WHERE detalleid = ".$detalleid."";
                                    $clase->EjecutarSQL($vsql);
    
                                    // Calculo el nuevo ID
                                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                                    $numid = $clase->SeleccionarUno($vsql);
                                    $numid++;
    
                                    // Inserto la nueva licencia
    
                                    // Obtengo la formula de la licencia
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                    $formulalice = $clase->SeleccionarUno($vsql);
    
                                    // Calculo la licencia
                                    if($conceptoid!=10)
                                    {
                                        eval("\$montolicencia = $formulalice;");
                                        $montolicencia = round($montolicencia,0);
                                    }
                                    else
                                    {
                                        // Calculo la incapacidad
    
                                        // Obtengo el salario mínimo legal vigente
                                        $smlv = $_SESSION['N_SALMIN2020'];
    
                                        // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                                        if($basico<=$smlv)
                                        {
                                            $montolicencia = ($smlv*$dias)/30;
                                            $montolicencia = round($montolicencia,0);
                                        }
                                        else
                                        {
                                            $porcbasico = ($basico*66.67)/100;
                                            $porcbasico = round($porcbasico,0);
    
                                            // Calculo la incapacidad si el básico sea mayor al mínimo
                                            if($porcbasico>$smlv)
                                            {
                                                $montolicencia = ($porcbasico*$dias)/30;
                                                $montolicencia = round($montolicencia,0);
                                            }
                                            else
                                            {
                                                if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                                if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;
    
                                                $montolicencia = round($montolicencia,0);
                                            }
                                        }
                                    }
    
                                    // Obtengo el tipo de licencia
                                    $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                                    // ------------------------------------------------------------------------------------------------------------------- //
                                    // Determino si el registro existe para modificarlo o incluirlo
                                    $vsql = "SELECT COUNT(*) AS repetida 
                                               FROM detallenomina
                                              WHERE pernominaid = ".$periodoid."
                                                    AND conceptoid = ".$conceptoid."
                                                    AND terid = ".$terid."";
                                    $repetida = $clase->SeleccionarUno($vsql);
    
                                    if($repetida==0)
                                    {
                                        if($tipodc=="C")
                                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                                        else
                                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
                                    }
                                    else
                                    {
                                        // Determino el id del registro
                                        $vsql = "SELECT detalleid AS detalleid 
                                                   FROM detallenomina
                                                  WHERE pernominaid = ".$periodoid."
                                                        AND conceptoid = ".$conceptoid."
                                                        AND terid = ".$terid."";
                                        $detalleid = $clase->SeleccionarUno($vsql);
                
                                        $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
                                        $valor += $dias;
                
                                        // Actualizo la licencia
                                        if($tipodc=="C")
                                        {
                                            $devengados = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
                                            $devengados += $montolicencia;
                                            
                                            $vsql = "UPDATE detallenomina SET 
                                                            devengados = ".$devengados.", 
                                                            valor = ".$valor."
                                                      WHERE detalleid = ".$detalleid."";
                                        }
                                        else
                                        {
                                            $descuentos = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
                                            $descuentos += $montolicencia;
                
                                            $vsql = "UPDATE detallenomina SET 
                                                            descuentos = ".$descuentos.", 
                                                            valor = ".$valor."
                                                      WHERE detalleid = ".$detalleid."";
                                        }
                                    }
                                    $clase->EjecutarSQL($vsql);
    
                                    if(mysql_affected_rows() < 1)
                                        $lbpaso = false;
                                    else
                                    {
                                        $lbpaso = true;
                                        $grabados++;
                                        $lbgrabo = true;
                                    }
    
                                    if($lbpaso)
                                    {
                                        $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');                           // Obtengo el cargo del empleado

                                        if($diastrab > 0)
                                        {
                                            // ---------------------------------------------------------------------------------------------------------- //
                                            // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos            
                                            $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte
                                
                                            // Variable para la validación del auxilio de transporte
                                            $valsubtrasp = $smlv * 2;
                                
                                            if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                                            {
                                                // Obtengo el ID del registro que se modificará
                                                $vsql = "SELECT detalleid
                                                           FROM detallenomina 
                                                          WHERE conceptoid = 3  
                                                                AND pernominaid = ".$periodoid."
                                                                AND terid = ".$terid."";
                                                $detalleid = $clase->SeleccionarUno($vsql);
                                
                                                // Obtengo la formula del subsidio de transporte
                                                $auxtrans = $_SESSION['N_AUXTRANS2020'];
                                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                                                $formulatransporte = $clase->SeleccionarUno($vsql);
                                
                                                eval("\$subsidiotransporte = $formulatransporte;");
                                                $subsidiotransporte = round($subsidiotransporte,0);
                                            }
                                            else
                                                $subsidiotransporte = 0;
            
                                            // ID transporte
                                            $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                                            $idtransporte = $clase->SeleccionarUno($vsql);
                                    
                                            // Grabo el subsidio de transporte
                                            if($idtransporte!="")        
                                                $vsql = "UPDATE detallenomina SET 
                                                                devengados = ".$subsidiotransporte.",
                                                                valor = ".$diastrab."
                                                          WHERE detalleid = ".$idtransporte."";
                                            else
                                            {
                                                // Obtengo el valor del subsidio de transporte
                                                $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
                                    
                                                $vsql = "SELECT max(detalleid) FROM detallenomina";
                                                $numreg = $clase->SeleccionarUno($vsql);
                                    
                                                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                                            }                            
                                            $clase->EjecutarSQL($vsql);
                                        }
                                        else
                                        {
                                            $subsidiotransporte = 0;

                                            // ID transporte
                                            $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                                            $idtransporte = $clase->SeleccionarUno($vsql);

                                            // Grabo el subsidio de transporte
                                            if($idtransporte!="")        
                                            {
                                                $vsql = "UPDATE detallenomina SET 
                                                                devengados = ".$subsidiotransporte.",
                                                                valor = ".$diastrab."
                                                          WHERE detalleid = ".$idtransporte;
                                                $clase->EjecutarSQL($vsql);
                                            }

                                            // elimino el subsidio de transporte
                                            $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                                            $clase->EjecutarSQL($vsql);

                                            $sueldo = 0;
                                        }
        
                                        // ----------------------------------------------------------------------------------------------------------- //
                                        // Ahora recalculo la pensión y la salud
        
                                        // ----------------------------------------------------------------------------------------------------------- //
                                        // Obtengo el total devengado por novedades
                                        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                                   FROM detallenomina d
                                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                                  WHERE d.terid = ".$terid."
                                                        AND d.pernominaid = ".$periodoid." 
                                                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                                        $totnovedades = $clase->SeleccionarUno($vsql);

                                        // Actualizo el sueldo
                                        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                                   FROM detallenomina d
                                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                                  WHERE d.terid = ".$terid."
                                                        AND d.pernominaid = ".$periodoid." 
                                                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                                        $totrecargos = $clase->SeleccionarUno($vsql);
                                
                                        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                                        if($sueldodeducciones == 0)
                                        {
                                            $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid IN (4,5)";
                                            $clase->EjecutarSQL($vsql);
                                        }
                                        else
                                        {            
                                            $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                                            $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
                                            $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
                                            
                                            if($epsid==NULL)                $epsid=0;
                                            if($pensionesid==NULL)          $pensionesid=0;
            
                                            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                                            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
            
                                            if($extralegal=="CHECKED")
                                            {
                                                $pension = 0;
                                                $salud = 0;
                                            }
                                            else
                                            {
                                                // Recalculo pensión y salud
                                                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                                    $pension = 0;
                                                else
                                                {
                                                    // Obtengo la formula para el descuento por pensión
                                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                                    $formulapension = $clase->SeleccionarUno($vsql);
                                
                                                    // Calculo la pensión
                                                    eval("\$pension = $formulapension;");
                                                    $pension = round($pension,0);
                                                }
                                
                                                if(($epsid==37)||($aplicasalud!="CHECKED"))
                                                    $salud = 0;
                                                else
                                                {
                                                    // Obtengo la formula para el descuento de salud
                                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                                    $formulasalud = $clase->SeleccionarUno($vsql);
                                                    
                                                    // Calculo la salud
                                                    eval("\$salud = $formulasalud;");
                                                    $salud = round($salud,0);
                                                }
                                            }
            
                                            //  ID pensión
                                            $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                                            $idpension = $clase->SeleccionarUno($vsql);
                                
                                            // Grabo la pensión
                                            if($idpension!="")
                                                $vsql = "UPDATE detallenomina SET 
                                                                descuentos = ".$pension.",
                                                                saldo = ".$sueldodeducciones."
                                                          WHERE detalleid = ".$idpension."";
                                            else
                                            {
                                                $vsql = "SELECT max(detalleid) FROM detallenomina";
                                                $numreg = $clase->SeleccionarUno($vsql);
                                
                                                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                                            }
                                            $clase->EjecutarSQL($vsql);
            
                                            // ID salud
                                            $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                                            $idsalud = $clase->SeleccionarUno($vsql);
                                
                                            // Grabo la salud
                                            if($idsalud!="")
                                                $vsql = "UPDATE detallenomina SET 
                                                                descuentos = ".$salud.",
                                                                saldo = ".$sueldodeducciones."
                                                          WHERE detalleid = ".$idsalud."";
                                            else
                                            {
                                                $vsql = "SELECT max(detalleid) FROM detallenomina";
                                                $numreg = $clase->SeleccionarUno($vsql);
                                
                                                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                                            }
                                            $clase->EjecutarSQL($vsql);
                                        }
        
                                        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                                        $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid = ".$terid."";
                                        $clase->EjecutarSQL($vsql);
                                    }
                                }
                            }
                            else
                                $motivo = "Fecha en rango incorrecto";
                        }
                        else
                            $motivo = "Formato de fechas incorrecto o el concepto no es licencia";
                    }
                    else
                        $motivo = "Empleado no está activo en nómina";
                }
                else
                    $motivo = "Documento no encontrado";                

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").' -- '.str_pad($motivo,1,"").Chr(13).Chr(10);               // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                                             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                                                    // Grabas
                    fclose($fd);                                                                                // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errores.txt";                                                   // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                    // Grabas
            fclose($fd);                                                                // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // emito el mensaje correspondiente
            $clase->Aviso(1,"Se cargaron las licencias para el periodo $descripcion");
    
            // Redirecciona el formulario
            header("Location: importarexcelnom.php?opcion=importarnovedades&periodoidanterior=$periodoid");
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererroresnovedades
    // Creación: 23/11/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para ver las cédulas no grabadas en el
    //              último proceso de importación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererroresnovedades")
    {
        $periodoid = $_GET['periodoid'];

        // Inicialización de variables
        $archivoerror = "reportes/errores.txt";
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        $txt = trim(str_replace("<br />","",$txt));
        $txt = trim(str_replace(" -- Documento no encontrado","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> C&oacute;digos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
				  <a href="?opcion=importarnovedades&periodoidanterior='.$periodoid.'"> <input type="button" value="aceptar" class="button blue"> </a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();    
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaeditnov
    // Creación: 21/01/2025		última modificación: 23/01/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para editar una novedad
    // Última modificación: Impresión del nombre del empleado y del periodo fuera del 
    //                      encabezado
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaeditnov")
    {
        $detalleid = $_GET['detalleid'];

        // obtengo los datos de la novedad
        $terid = $clase->BDLockup($detalleid,'detallenomina','detalleid','terid');
        $nomreemp = "CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)";
        $nombreempleado = $clase->BDLockup($terid,'tercerosactual','terid',$nomreemp);
        $conceptoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','conceptoid');
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        $dias = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
        $pernominaid = $clase->BDLockup($detalleid,'detallenomina','detalleid','pernominaid');
        $descripcion = $clase->BDLockup($pernominaid,'periodosnomina','periodoid','descripcion');

        // pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"> <b> Editar Novedad <br> <font color="BLUE"> '.$nomconcepto.'</font> </b> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardareditarnovedad" method="POST" name="x">
                <input type="hidden" name="detalleid" value="'.$detalleid.'">
                <table width="500">
                 <tr class="BarraDocumentos" style="height:30px;Important!">
                  <td width="40" align="left"> &nbsp; </td>
                  <td width="460" align="left"> <label class="Texto12"> Periodo: '.$descripcion.' </label> </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:30px;Important!">
                  <td width="40" align="left"> &nbsp; </td>
                  <td width="460" align="left"> <label class="Texto12"> Empleado: '.$nombreempleado.' </label> </td>
                 </tr>
                </table>
                <table width="500">
                 <center>
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <td width="100" align="right"> <label class="Texto12"> D&iacute;as: </label> </td>
                  <td width="400">
                   &nbsp; <input type="number" name="dias" min="1" max="15" class="Texto12New" size="12" style="width:80px;height:25px;" autocomplete="off" title="días de la licencia" value="'.$dias.'">
                  </td>
                 </tr>';

        if(($_SESSION["SUPERUSUARIO"] == "CHECKED") || ($_SESSION['USERNAME'] == "LFLOREZ"))
        {
            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

            if($tipodc == "C")
                $monto = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
            else
                $monto = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');

            $cont.='<tr class="BarraDocumentos" style="height:40px;Important!">
                     <td width="100" align="right"> <label class="Texto12"> Monto: </label> </td>
                     <td width="400">
                      &nbsp; <input type="number" name="monto" min="1" class="Texto12New" size="12" style="width:130px;height:25px;" autocomplete="off" title="monto de la licencia" value="'.$monto.'">
                     </td>
                    </tr>';
        }

        $cont.='</table>
                <table width="500">
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="importarexcelnom.php?opcion=importarnovedades&periodoidanterior='.$pernominaid.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                  </td>
                 </tr>
                </table>';

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardareditarnovedad
    // Creación: 21/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que modifica una novedad
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardareditarnovedad")
    {
        $detalleid = $_POST['detalleid'];
        $dias = $_POST['dias'];
        $monto = $_POST['monto'];

        //datos de registro
        $conceptoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','conceptoid');
        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
        $pernominaid = $clase->BDLockup($detalleid,'detallenomina','detalleid','pernominaid');

        if($tipodc == "C")
            $montoactual = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
        else
            $montoactual = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');

        // determino si modifico el monto sin recalcular
        if((strlen($monto) > 0 ) && ($monto != $montoactual))
        {
            if($tipodc == "C")
                $clase->EjecutarSQL("UPDATE detallenomina SET devengados = ".$monto." WHERE detalleid = ".$detalleid."");                 
            else
                $clase->EjecutarSQL("UPDATE detallenomina SET descuentos = ".$monto." WHERE detalleid = ".$detalleid."");

            $clase->Aviso(1,"Monto de la novedad editada satisfactoriamente");
        }
        else
        {
            // recalculo de la novedad
            $diasactual = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');

            if($dias == $diasactual)
                $clase->Aviso(3,"No se modificó la novedad");
            else
            {
                // Obtengo el salario básico del empleado
                $periodoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','pernominaid');
                $terid = $clase->BDLockup($detalleid,'detallenomina','detalleid','terid');

                $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

                if($calculado == "CHECKED")
                    $tabla = "tercerosactual";
                else
                    $tabla = "terceros";

                $basico = $clase->BDLockup($terid,$tabla,'terid','basico');

                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);

                // Obtengo los días trabajados en el periodo
                $diastrab = $clase->SeleccionarUno("SELECT valor FROM detallenomina WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid."");

                if(strlen($diastrab) == 0)
                    $diastrab = 0;

                // Obtengo el ID del registro que se modificará
                $detalleid = $clase->SeleccionarUno("SELECT detalleid FROM detallenomina WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid."");

                $diastrab = ($diastrab + $diasactual) - $dias;

                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);

                // Almaceno en nuevo sueldo
                if(strlen($detalleid) > 0)
                    $clase->EjecutarSQL("UPDATE detallenomina SET devengados = ".$sueldo.", valor = ".$diastrab." WHERE detalleid = ".$detalleid."");
                else
                {                    
                    $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detallenomina");
                    $clase->EjecutarSQL("INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico)");
                }

                $sueldodev = $clase->SeleccionarUno("SELECT devengados AS sueldodev FROM detallenomina WHERE detalleid = ".$detalleid."");

                if($sueldodev >= 0)
                {
                    // Calculo el nuevo ID
                    $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detallenomina");
                    $numid++;

                    // Obtengo la formula de la licencia
                    $formulalice = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                    // Calculo la licencia
                    if($conceptoid!=10)
                    {
                        eval("\$montolicencia = $formulalice;");
                        $montolicencia = round($montolicencia,0);
                    }
                    else
                    {
                        // Obtengo el salario mínimo legal vigente
                        $smlv = $_SESSION['N_SALMIN2020'];

                        // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                        if($basico<=$smlv)
                        {
                            $montolicencia = ($smlv*$dias)/30;
                            $montolicencia = round($montolicencia,0);
                        }
                        else
                        {
                            $porcbasico = ($basico*66.67)/100;
                            $porcbasico = round($porcbasico,0);

                            // Calculo la incapacidad si el básico sea mayor al mínimo 
                            if($porcbasico>$smlv)
                            {
                                $montolicencia = ($porcbasico*$dias)/30;
                                $montolicencia = round($montolicencia,0);
                            }
                            else
                            {
                                if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                                $montolicencia = round($montolicencia,0);
                            }
                        }
                    }
                    
                    // Determino si el registro existe para modificarlo o incluirlo
                    $repetida = $clase->SeleccionarUno("SELECT COUNT(*) AS repetida FROM detallenomina WHERE pernominaid = ".$periodoid." AND conceptoid = ".$conceptoid." AND terid = ".$terid."");
                    
                    if($repetida==0)
                    {
                        if($tipodc=="C")
                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
                        else
                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
                    }
                    else 
                    {
                        // Determino el id del registro
                        $detalleid = $clase->SeleccionarUno("SELECT detalleid AS detalleid FROM detallenomina WHERE pernominaid = ".$periodoid." AND conceptoid = ".$conceptoid." AND terid = ".$terid."");
                        $valor = $dias;

                        // Actualizo la licencia
                        if($tipodc=="C")
                        {
                            $devengados = $montolicencia;
                            $vsql = "UPDATE detallenomina SET devengados = ".$devengados.", valor = ".$valor." WHERE detalleid = ".$detalleid."";
                        }
                        else
                        {
                            $descuentos = $montolicencia;
                            $vsql = "UPDATE detallenomina SET descuentos = ".$descuentos.", valor = ".$valor." WHERE detalleid = ".$detalleid."";
                        }
                    }
                    $clase->EjecutarSQL($vsql);
                }

                // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos                
                $smlv = $_SESSION['N_SALMIN2020'];

                $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');                           // Obtengo el cargo del empleado
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte

                if($diastrab > 0)
                {
                    // Variable para la validación del auxilio de transporte
                    $valsubtrasp = $smlv * 2;
        
                    if(($basico <= $valsubtrasp) && ($aplicatransporte=="CHECKED"))
                    {
                        // Obtengo el ID del registro que se modificará
                        $detalleid = $clase->SeleccionarUno("SELECT detalleid FROM detallenomina WHERE conceptoid = 3 AND pernominaid = ".$periodoid." AND terid = ".$terid."");
        
                        // Obtengo la formula del subsidio de transporte
                        $auxtrans = $_SESSION['N_AUXTRANS2020'];
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                        $formulatransporte = $clase->SeleccionarUno($vsql);
        
                        eval("\$subsidiotransporte = $formulatransporte;");
                        $subsidiotransporte = round($subsidiotransporte,0);
                    }
                    else
                        $subsidiotransporte = 0;
                }
                else
                    $subsidiotransporte = 0;

                // ID transporte
                $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                $idtransporte = $clase->SeleccionarUno($vsql);
        
                // Grabo el subsidio de transporte
                if($idtransporte != "")
                    $vsql = "UPDATE detallenomina SET devengados = ".$subsidiotransporte.", valor = ".$diastrab." WHERE detalleid = ".$idtransporte."";
                else
                {
                    // Obtengo el valor del subsidio de transporte
                    $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
                    $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detallenomina");
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                }
                $clase->EjecutarSQL($vsql);

                // ----------------------------------------------------------------------------------------------------------- //
                // Obtengo el total devengado por novedades
                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                $totnovedades = $clase->SeleccionarUno($vsql);

                $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                           FROM detallenomina d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                $totrecargos = $clase->SeleccionarUno($vsql);

                // Actualizo el sueldo
                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
                $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
                
                if($epsid==NULL)                $epsid=0;
                if($pensionesid==NULL)          $pensionesid=0;

                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');         // Obtengo el control del cálculo de pensión
                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');             // Obtengo el control del cálculo de salud

                if($extralegal == "CHECKED")
                {
                    $pension = 0;
                    $salud = 0;
                }
                else
                {
                    // Recalculo pensión y salud
                    if(($pensionesid==5) || ($aplicapension!="CHECKED"))
                        $pension = 0;
                    else
                    {
                        // Obtengo la formula para el descuento por pensión
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                        $formulapension = $clase->SeleccionarUno($vsql);

                        // Calculo la pensión
                        eval("\$pension = $formulapension;");
                        $pension = round($pension,0);
                    }

                    if(($epsid == 37) || ($aplicasalud != "CHECKED"))
                        $salud = 0;
                    else
                    {
                        // Obtengo la formula para el descuento de salud
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                        $formulasalud = $clase->SeleccionarUno($vsql);
                        
                        // Calculo la salud
                        eval("\$salud = $formulasalud;");
                        $salud = round($salud,0);
                    }
                }

                //  ID pensión
                $idpension = $clase->SeleccionarUno("SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4");

                // Grabo la pensión
                if($idpension != "")
                    $vsql = "UPDATE detallenomina SET descuentos = ".$pension.", saldo = ".$sueldodeducciones." WHERE detalleid = ".$idpension."";
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                    $numreg = $clase->SeleccionarUno($vsql);
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);

                // ID salud
                $idsalud = $clase->SeleccionarUno("SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5");

                // Grabo la salud
                if($idsalud != "")
                    $vsql = "UPDATE detallenomina SET descuentos = ".$salud.", saldo = ".$sueldodeducciones." WHERE detalleid = ".$idsalud."";
                else
                {
                    $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detallenomina");
                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
                
                // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                $clase->EjecutarSQL("DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoid."");
                
                $clase->Aviso(1,"Novedad modificada satisfactoriamente");
            }
        }

        // Redirecciono el formulario
        header("Location: importarexcelnom.php?opcion=importarnovedades&periodoidanterior=$pernominaid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarlibranzasall
    // Creación: 22/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para gestionar las libranzas de un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarlibranzasall")
    {
        $periodoid = $_GET["periodoidanterior"];

        // nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // valido que el archivo de mostrar errores exista
        $archivoerror = "reportes/erroreslibranzas.txt";
        if (file_exists ($archivoerror))
            $htmlarchivoerror = '<a href="?opcion=vererroreslibranzas&periodoid='.$periodoid.'" rel="facebox">
                                  <img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&eacute;dulas de empleados no guardados en el &uacute;ltimo proceso de importaci&oacute;n">
                                 </a>';
        else
            $htmlarchivoerror = '<img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&eacute;dulas de empleados no guardados en el &uacute;ltimo proceso de importaci&oacute;n">';        

        // consulta de la vista
        $vsql = "SELECT t.codvende, t.`dni`, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        c.`nomconcepto`, IF(c.tipodc = 'C',d.devengados,d.`descuentos`) monto, d.detalleid, c.tipodc, d.devengados, d.descuentos   
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                        INNER JOIN terceros t ON (d.terid = t.terid)
                  WHERE d.pernominaid = ".$periodoid."           
                        AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED' OR c.`montoocasional` = 'CHECKED')
               ORDER BY 1";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                  <td width="800"> <b> Libranzas <br> <font color="blue"> '.$descripcion.' </font> </b> </td>
                  <td width="30"> 
                   <a href="?opcion=ventataimportarlib&periodoid='.$periodoid.'" rel="facebox">
                    <img src="images/iconos/cargar.png" title="subir libranzas" border="0" width="32" height="32"> 
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30" align="center"> '.$htmlarchivoerror.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=ventanainclibranza&periodoid='.$periodoid.'" rel="facebox"> 
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="nueva libranza"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=descargarlibranzas&periodoid='.$periodoid.'" target="_blank"> 
                    <img src="images/iconos/descargar.png" width="32" height="32" border="0" title="bajar informaci&oacute;n de libranzas"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="40" align="center"> 
                   <a href="importacionexcelnom.php?opcion=ventanaimportacion"> 
                    <input type="button" value="<<" class="button blue" title="ventana principal"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>                  
                 </tr> 
                </table>';

        // títulos        
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="11"> &nbsp; </td>
                   <td width="120" align="left"> Documento </td>
                   <td width="360" align="left"> Empleado </td>                   
                   <td width="320" align="left"> Concepto </td>
                   <td width="60" align="right"> &nbsp; </td>
                   <td width="150" align="right"> Monto </td>
                   <td width="60"> &nbsp; </td>
                   <td width="60"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';

        // detalle de la ventana
        $i = 0;         $totaldevengados = 0;           $totaldeducciones = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="11"> &nbsp; </td>
                     <td width="120" align="left"> '.$row['dni'].' </td>
                     <td width="340" align="left"> '.$row['nombreemp'].' </td>
                     <td width="240" align="left"> '.$row['nomconcepto'].' </td>
                     <td width="125" align="right"> &nbsp; </td>
                     <td width="145" align="right"> '.number_format($row['monto']).' </td>                     
                     <td width="14" align="right"> &nbsp; </td>
                     <td width="26" align="center">
                      <a href="?opcion=confirmareliminarlibranzas&detalleid='.$row['detalleid'].'&periodoid='.$periodoid.'" rel="facebox">
                       <img src="images/basicas/borrados.png" title="eliminar liquidaci&oacute;n" border="0" width="20" height="20">
                      </a>
                     </td>
                     <td width="26" align="center">
                      <a href="?opcion=ventanaeditarlib&detalleid='.$row['detalleid'].'" rel="facebox">
                       <img src="images/basicas/iconobuscar.png" border="0" border="0" width="20" height="20" title="editar liquidaci&oacute;n">
                      </a>                         
                     </td>
                     <td width="26" align="center">
                      <a href="recibodepago.php?opcion=negativo&periodoid='.$periodoid.'&dni='.$row['dni'].'" target="_blank">
                       <img src="images/basicas/pdf.png" title="ver recibo de pago" border="0" width="20" height="20">
                      </a>                     
                     </td>
                    </tr>';

            if($row['tipodc'] == "C")
                $totaldevengados += $row['devengados'];
            else
                $totaldeducciones += $row['descuentos'];
        }

        $cont.=' </tbody>
                </table>';

        // Impresión de los totales
        $cont.='<table width="100%">
                 <tr class="TituloTabla">
                  <td width="140"> &nbsp; </td>
                  <td width="320" align="left"> <b> <font color="white"> Total licencias: '.number_format($i).' </font> </b> </td>
                  <td width="80"> &nbsp; </td>
                  <td width="475" align="left"> <b> <font color="white"> Total en devengados: '.number_format($totaldevengados).' </font> </b> </td>
                  <td width="100"> &nbsp; </td>
                  <td width="475" align="left"> <b> <font color="white"> Total en deducciones: '.number_format($totaldeducciones).' </font> </b> </td>
                  <td width="182"> &nbsp; </td>
                 </tr>
                </table>';

        echo $cont.$clase->PiePagina();
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmareliminarlibranzas
    // Creación: 22/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de una 
    //              libranza
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmareliminarlibranzas")
    {
        $detalleid = $_GET["detalleid"];
        $periodoid = $_GET["periodoid"];

        // datos de la novedad
        $terid = $clase->BDLockup($detalleid,'detallenomina','detalleid','terid');
        $nomreemp = "CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)";
        $nombreempleado = $clase->BDLockup($terid,'terceros','terid',$nomreemp);        
        $conceptoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','conceptoid');
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        
        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

        if($tipodc == "C")
            $monto = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
        else
            $monto = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');

        // Pinto la ventana
        $cont= '<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="350" align="center"> <br> <label class="Texto12"> <b>Eliminar libranzas</b> </label> <br><br> </td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <br>
                   <label class="Texto12">
                   ¿Confirma que desea eliminar <br> <b> '.$nomconcepto.' </b> <br> por un monto de <b> '.number_format($monto).' </b> <br> para <b> '.$nombreempleado.'</b>? 
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarlibranza" method="POST">
                   <input type="hidden" name="detalleid" value="'.$detalleid.'"> 
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">                   
                   <input type="submit" value="ACEPTAR" class="button blue">                   
                   <a href="importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior='.$periodoid.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarlibranza
    // Creación: 22/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina una libranza
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarlibranza")
    {
        $detalleid = $_POST["detalleid"];
        $periodoid = $_POST["periodoid"];

        // elimino el registro
        $clase->EjecutarSQL("DELETE FROM detallenomina WHERE detalleid = ".$detalleid."");

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Libranza eliminada satisfactoriamente");

        // redirecciono el formulario
        header("Location: importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaeditarlib
    // Creación: 22/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para editar el monto de una libranza
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaeditarlib")
    {
        $detalleid = $_GET['detalleid'];

        // obtengo los datos de la novedad
        $terid = $clase->BDLockup($detalleid,'detallenomina','detalleid','terid');
        $nomreemp = "CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)";
        $nombreempleado = $clase->BDLockup($terid,'tercerosactual','terid',$nomreemp);
        $conceptoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','conceptoid');
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        $pernominaid = $clase->BDLockup($detalleid,'detallenomina','detalleid','pernominaid');
        $descripcion = $clase->BDLockup($pernominaid,'periodosnomina','periodoid','descripcion');
        $periodoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','pernominaid');
        
        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
        
        if($tipodc == "C")
            $monto = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
        else
            $monto = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');

        // pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"> 
                   <b> Editar Libranza <br> <font color="BLUE"> '.$descripcion.'</font> </b>
                  </td>
                 </tr> 
                </table>
                <form action="?opcion=guardareditarlibranza" method="POST" name="x">
                <input type="hidden" name="detalleid" value="'.$detalleid.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="500">
                 <tr class="BarraDocumentos" style="height:30px;Important!">
                  <td width="20" align="left"> &nbsp; </td>
                  <td width="480" align="left"> <label class="Texto12"> Empleado: '.$nombreempleado.' </label> </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:30px;Important!">
                  <td width="20" align="left"> &nbsp; </td>
                  <td width="480" align="left"> <label class="Texto12"> Concepto: '.$nomconcepto.' </label> </td>
                 </tr>
                </table>
                <table width="500">
                 <center>
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <td width="20" align="left"> &nbsp; </td>
                  <td width="55" align="left"> <label class="Texto12"> Monto: </label> </td>
                  <td width="425">
                   &nbsp; <input type="number" name="monto" min="1" class="Texto12New" size="12" style="width:130px;height:25px;" autocomplete="off" title="monto de la licencia" value="'.$monto.'">
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior='.$periodoid.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                  </td>
                 </tr>
                </table>';

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardareditarlibranza
    // Creación: 22/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena la modificación del monto de una libranza
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardareditarlibranza")
    {
        $detalleid = $_POST['detalleid'];
        $periodoid = $_POST['periodoid'];
        $monto = $_POST['monto'];

        //datos de registro
        $conceptoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','conceptoid');
        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');        

        if($tipodc == "C")
            $montoactual = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
        else
            $montoactual = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');

        // valido la entrada del monto
        if(strlen($monto) == 0)
            $clase->Aviso(3,"Debe introducir el monto");
        else
        {
            // valido que el monto sea igual al anterior
            if($monto == $montoactual)
                $clase->Aviso(3,"No se modificó el monto");
            else
            {
                // almaceno la modificación
                if($tipodc == "C")
                    $clase->EjecutarSQL("UPDATE detallenomina SET devengados = ".$monto." WHERE detalleid = ".$detalleid."");
                else
                    $clase->EjecutarSQL("UPDATE detallenomina SET descuentos = ".$monto." WHERE detalleid = ".$detalleid."");

                $clase->Aviso(1,"Monto de la libranza editada satisfactoriamente");
            }
        }

        // redirecciono el formulario
        header("Location: importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanainclibranza
    // Creación: 22/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar los datos de la libranza
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanainclibranza")
    {
        $periodoid = $_GET['periodoid'];

        $descripcionant = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado=="CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        // combo de empleados
        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM ".$tabla." 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";       

        $params = ' class="Texto12" ';
        $comboempeado = $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,500);

        // combo de conceptos        
        $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto FROM conceptosnomina WHERE eslibranza = 'CHECKED' OR montopermanente = 'CHECKED' OR `montoocasional` = 'CHECKED' ORDER BY 1 ASC";
        $comboconcepto = $clase->CrearComboBuscar("conceptoid",$vsqlcomboconcepto,"nombres","conceptoid","","N",$params,350);

        // inicializo
        $monto = 1;

        // pinto la ventana
        $cont ='<table width="600">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Inclusi&oacute;n de libranzas <br> <font color="blue"> '.$descripcionant.' </font> </b> <br><br> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardarlibranza" name="y" method="POST">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">                  
                <table width="600">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="580" align="left"> <label class="Texto12"> Empleado: </label> '.$comboempeado.' </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="580" align="left"> <label class="Texto12"> Concepto: </label> '.$comboconcepto.' </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="20"> &nbsp; </td>
                  <td width="580" align="left"> 
                   Monto: &nbsp;&nbsp;
                   <input type="number" name="monto" min="1" class="Texto12" style="width:120px;height:25px;" size="2" autocomplete="off" title="monto de la libranza" value="'.$monto.'">
                  </td>
                 </tr>
                </table>                
                <table width="600">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior='.$periodoid.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarlibranza
    // Creación: 22/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena la nueva libranza
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarlibranza")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $conceptoid = $_POST['conceptoid'];
        $monto = $_POST['monto'];

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado == "CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";        

        // Valido que el concepto asignado a un empleado no esté repetido
        $valreg = $clase->SeleccionarUno("SELECT COUNT(*) valreg FROM detallenomina WHERE pernominaid = ".$periodoid." AND terid = ".$terid." AND conceptoid = ".$conceptoid."");

        if($valreg>0)
        {
            $nombreemp = $clase->SeleccionarUno("SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) nombreemp FROM ".$tabla." WHERE terid = ".$terid."");
            $nomconcepto = $clase->SeleccionarUno("SELECT nomconcepto FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");
            $clase->Aviso(3,"$nombreemp ya tiene $nomconcepto en este periodo");
        }
        else
        {
            // Obtengo el número de registros de la tabla detallenomina
            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detallenomina");
    
            // Incremento el ID
            $numeroid++;
    
            // Determino el tipo de concepto
            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
            // Construyo la instrucción
            if($tipodc=="C")
                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                            VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
            else
                $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                            VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
    
            // Almaceno en la tabla
            $clase->EjecutarSQL($vsql);
    
            // Emito el mensaje correspondiente
            $clase->Aviso(1,"Datos almacenados satisfactoriamente");
        }

        // redirecciono el formulario
        header("Location: importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventataimportarlib
    // Creación: 22/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con las 
    //              libranzas para un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventataimportarlib")
    {
        $periodoid = $_GET['periodoid'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if($servidor!="192.168.14.248:9999")
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor dir&iacute;jase al servidor </font> <br>
                       <a href="http://192.168.14.248:9999/dropos/login/" target="_blank"> 
                        <font color=blue> 192.168.14.248:9999 </font> <br>                        
                       </a>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior='.$periodoid.'" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            $descripcionant = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="950">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar libranzas<br><font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td>                    
                     </tr> 
                    </table>
                    <table width="950">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importarexcelnom.php?opcion=importarlibranzasexcel" id="theform" enctype="multipart/form-data">
                        <input type="hidden" name="periodoid" value="'.$periodoid.'"> 
                        <input type="file" name="excel" /><br><br>                        
                        <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                        <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';

            // datos de la hoja
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp;&nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp;&nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp;&nbsp; Columna <b>B</b>: Monto (solo n&uacute;meros) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp;&nbsp; Columna <b>C</b>: ID </td> </tr> 
                    </table>';

            // impresión de todos los Ids
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp;&nbsp;&nbsp; </td> 
                      <td align="left"> <font color="blue"> <b>8</b> </font> COMPRAS A CREDITO </td> 
                      <td align="left"> <font color="blue"> <b>14</b> </font> OPTICA DE TODOS </td> 
                      <td align="left"> <font color="blue"> <b>15</b> </font> OPTICA PRACSO </td> 
                      <td align="left"> <font color="blue"> <b>16</b> </font> PROGRESSA </td> 
                      <td align="left"> <font color="blue"> <b>17</b> </font> COOPTELECUC </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp;&nbsp;&nbsp; </td> 
                      <td align="left"> <font color="blue"> <b>18</b> </font> DAVIVIENDA </td> 
                      <td align="left"> <font color="blue"> <b>19</b> </font> RECORDAR </td> 
                      <td align="left"> <font color="blue"> <b>20</b> </font> LOS OLIVOS </td> 
                      <td align="left"> <font color="blue"> <b>21</b> </font> LA ESPERANZA </td> 
                      <td align="left"> <font color="blue"> <b>24</b> </font> CAMISETAS </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp;&nbsp;&nbsp; </td> 
                      <td align="left"> <font color="blue"> <b>25</b> </font> PLAN TELEFONIA MOVIL </td> 
                      <td align="left"> <font color="blue"> <b>26</b> </font> PRESTAMOS PERSONALES </td> 
                      <td align="left"> <font color="blue"> <b>27</b> </font> SEGURO DE VIDA SURAMERICANA </td> 
                      <td align="left"> <font color="blue"> <b>28</b> </font> AJUSTE SALARIO SENA </td> 
                      <td align="left"> <font color="blue"> <b>29</b> </font> BANCOLOMBIA </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp;&nbsp;&nbsp; </td> 
                      <td align="left"> <font color="blue"> <b>30</b> </font> EMBARGO </td> 
                      <td align="left"> <font color="blue"> <b>32</b> </font> CREDITOS OTROS NEGOCIOS </td> 
                      <td align="left"> <font color="blue"> <b>33</b> </font> ANTICIPO DE NOMINA </td> 
                      <td align="left"> <font color="blue"> <b>34</b> </font> MANGAS </td> 
                      <td align="left"> <font color="blue"> <b>35</b> </font> COOMUNIDAD </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp;&nbsp;&nbsp; </td> 
                      <td align="left"> <font color="blue"> <b>36</b> </font> MACROPAPELES </td> 
                      <td align="left"> <font color="blue"> <b>37</b> </font> SUELDO LECTIVA </td> 
                      <td align="left"> <font color="blue"> <b>38</b> </font> VACACIONES </td> 
                      <td align="left"> <font color="blue"> <b>39</b> </font> SOLCARIBE </td> 
                      <td align="left"> <font color="blue"> <b>41</b> </font> OTROS </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp;&nbsp;&nbsp; </td> 
                      <td align="left"> <font color="blue"> <b>42</b> </font> OPTICA MM </td> 
                      <td align="left"> <font color="blue"> <b>44</b> </font> SEGUROS BOLIVAR </td> 
                      <td align="left"> <font color="blue"> <b>45</b> </font> AUX TRASPORTE </td> 
                      <td align="left"> <font color="blue"> <b>48</b> </font> ADICIONAL </td> 
                      <td align="left"> <font color="blue"> <b>55</b> </font> OPTICA PROVISION </td> 
                     </tr>
                    </table>';

            // Advertencia de la extensión de la hoja de Excel 
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocompras2.png" width="600" height="220" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';

        }
        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarlibranzasexcel
    // Creación: 23/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena libranzas para un periodo venidas desde una hoja de 
    //              Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarlibranzasexcel")
    {
		set_time_limit(0);
		extract($_POST);
		$periodoid = $_POST["periodoid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior=$periodoid");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['conceptoid'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['monto']) == 0) || (strlen($_DATOS_EXCEL[$i]['conceptoid']) == 0) ) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado == "CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";            

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                // inicialización de variables
                $lbgrabo = false;
                $valreg = 0;
                $motivo = "";
                $eslibranza = "";
                $montoocasional = "";
                $montopermanente = "";

                // valido la existencia de empleado
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $terid = $clase->BDLockup($dni,$tabla,"dni","terid");

                if($terid == "")
                    $motivo = "Empleado no existe";
                else
                {
                    // valido la entrada del monto
                    $monto = $_DATOS_EXCEL[$j]['monto'];
    
                    // llamado al procedimiento para validar el monto
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($monto);

                    if(!$lb_valido)                    
                        $motivo = "Formato del monto es invalido";
                    else
                    {
                        // valido la entrada del concepto
                        $conceptoid = $_DATOS_EXCEL[$j]['conceptoid'];

                        $eslibranza = $clase->SeleccionarUno("SELECT eslibranza FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");
                        $montoocasional = $clase->SeleccionarUno("SELECT montoocasional FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");
                        $montopermanente = $clase->SeleccionarUno("SELECT montopermanente FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                        if(($eslibranza == "") && ($montoocasional == "") && ($montopermanente == ""))
                            $motivo = "El ID del concepto no es una libranza";
                        else
                        {
                            // Valido que el concepto asignado a un empleado no esté repetido
                            $valreg = $clase->SeleccionarUno("SELECT count(*) AS valreg FROM detallenomina WHERE pernominaid = ".$periodoid." AND terid = ".$terid." AND conceptoid = ".$conceptoid."");
    
                            if($valreg > 0)
                                $motivo = "Concepto ya incluido en el periodo";
                            else
                            {
                                // Obtengo el número de registros de la tabla detallenomina
                                $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detallenomina");
                        
                                // Incremento el ID
                                $numeroid++;
        
                                // Determino el tipo de concepto
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
        
                                // Construyo la instrucción
                                if($tipodc == "C")
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                  VALUES (".$numeroid.",".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
                                else
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                  VALUES (".$numeroid.",".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";                                
        
                                // Almaceno en la tabla
                                $clase->EjecutarSQL($vsql);

                                // Incremento el contador de registros almacenados
                                if(mysql_affected_rows() == 1)
                                {
                                    $grabados++;
                                    $lbgrabo = true;
                                }
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if((!$lbgrabo) && ($dni != ""))
                {
                    $nocedulas.= str_pad($dni,1,"").' -- '.str_pad($motivo,1,"").Chr(13).Chr(10);                       // Actualizo la variable con el documento no almacenado
                    $archivo = "erroreslibranzas.txt";                                                                  // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                                                     // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                                                            // Grabas
                    fclose($fd);                                                                                        // Cierras el archivo
                }                
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);         // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroreslibranzas.txt";                                              // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                                 // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                        // Grabas
            fclose($fd);                                                                    // Cierras el archivo
        
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados == 0)
                $clase->Aviso(3,"No se cargaron las libranzas");
            else
                $clase->Aviso(1,"Se cargaron $grabados libranzas");
    
            // Redirecciona el formulario
            header("Location: importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior=$periodoid");
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererroreslibranzas
    // Creación: 23/01/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana que muestra los errores encontrados en el 
    //              último proceso de importación desde una hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererroreslibranzas")
    {
        $periodoid = $_GET['periodoid'];

        // botón de aceptar
        $htmlaceptar = '<a href="importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior='.$periodoid.'">';

        // Inicialización de variables
        $archivoerror = "reportes/erroreslibranzas.txt";
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        // $txt = trim(str_replace(" -- Empleado no existe","",$txt));
        $txt = trim(str_replace("<br />","",$txt));

        // pinto la ventana
        $cont ='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Documentos no grabados <br>en el &uacute;ltimo proceso de importaci&oacute;n </b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled>'.$txt.'</textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
				   '.$htmlaceptar.' <input type="button" value="aceptar" class="button blue"> </a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: descargarlibranzas
    // Creación: 05/02/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite la salida a Excel del informe de libranzas en un 
    //              periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "descargarlibranzas")
    {
        $periodoid = $_GET['periodoid'];
        
        // nombre del periodo
        $descripcionperiodo = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // nombre de la hoja de excel
        $nombrearchivo = "libranzas del periodo ".strtolower($descripcionperiodo).".xls";
        
        // consulta del informe
        $vsql = "SELECT t.codvende, t.`dni`, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        c.`nomconcepto`, IF(c.tipodc = 'C',d.devengados,d.`descuentos`) monto, d.detalleid, c.tipodc, d.devengados, d.descuentos   
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                        INNER JOIN terceros t ON (d.terid = t.terid)
                  WHERE d.pernominaid = ".$periodoid."           
                        AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED' OR c.`montoocasional` = 'CHECKED')
               ORDER BY 1";        

        // Preparación del entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("libranzas de un periodo - DROPOS")
                                     ->setSubject("libranzas de un periodo - DROPOS")
                                     ->setDescription("libranzas de un periodo - DROPOS")
                                     ->setKeywords("libranzas de un periodo - DROPOS")
                                     ->setCategory("Categoria General");        

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'LIBRANZAS')
                    ->setCellValue('A2', $descripcionperiodo)
                    ->setCellValue('A4', 'DOCUMENTO')
                    ->setCellValue('B4', 'EMPLEADO')
                    ->setCellValue('C4', 'CONCEPTO')
                    ->setCellValue('D4', 'MONTO');
                 
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,5);
        
        $i = 5;
        $totaldevengados = 0;
        $totaldeducciones = 0;        
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);        
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['dni'])
                        ->setCellValue('B'.$i, $row['nombreemp'])
                        ->setCellValue('C'.$i, $row['nomconcepto'])
                        ->setCellValue('D'.$i, number_format($row['monto']));
            
            if($row['tipodc'] == "C")
                $totaldevengados += $row['devengados'];
            else
                $totaldeducciones += $row['descuentos'];

            $i++;
        }
        
        // Impresión de los totales
        $p = $i + 1;
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('C'.$i, "DEVENGADOS:")
                    ->setCellValue('D'.$i, number_format($totaldevengados))                    
                    ->setCellValue('C'.$p, "DEDUCCIONES:")
                    ->setCellValue('D'.$p, number_format($totaldeducciones));

        $rangoEncabezado = 'A4:D4';
        $rangoCeldas     = 'A4:D'.($cant+1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(20);

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('libranzas');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$nombrearchivo.'"');
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: descargarnovedades
    // Creación: 08/04/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite la salida a Excel del informe de novedades en un 
    //              periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "descargarnovedades")
    {
        $periodoid = $_GET['periodoid'];
        
        // nombre del periodo
        $descripcionperiodo = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // nombre de la hoja de excel
        $nombrearchivo = "novedades del periodo ".strtolower($descripcionperiodo).".xls";
        
        // consulta del informe
        $vsql = "SELECT t.codvende, t.`dni`, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        c.`nomconcepto`, d.`valor` , IF(c.tipodc = 'C',d.devengados,d.`descuentos`) monto, c.tipodc, d.devengados, d.descuentos, d.detalleid  
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                        INNER JOIN terceros t ON (d.terid = t.terid)
                  WHERE d.pernominaid = ".$periodoid." 
                        AND c.eslicencia = 'CHECKED'  
               ORDER BY 1";

        // Preparación del entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("libranzas de un periodo - DROPOS")
                                     ->setSubject("libranzas de un periodo - DROPOS")
                                     ->setDescription("libranzas de un periodo - DROPOS")
                                     ->setKeywords("libranzas de un periodo - DROPOS")
                                     ->setCategory("Categoria General");        

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'NOVEDADES')
                    ->setCellValue('A2', $descripcionperiodo)
                    ->setCellValue('A4', 'DOCUMENTO')
                    ->setCellValue('B4', 'EMPLEADO')
                    ->setCellValue('C4', 'CONCEPTO')
                    ->setCellValue('D4', 'DIAS')
                    ->setCellValue('E4', 'MONTO');
                 
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,5);
        
        $i = 5;
        $totaldevengados = 0;           $totaldeducciones = 0;          $totaldias = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);        
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['dni'])
                        ->setCellValue('B'.$i, $row['nombreemp'])
                        ->setCellValue('C'.$i, $row['nomconcepto'])
                        ->setCellValue('D'.$i, number_format($row['valor']))
                        ->setCellValue('E'.$i, number_format($row['monto']));
            
            // incremento de los totales
            if($row['tipodc'] == "C")
                $totaldevengados += $row['devengados'];
            else
                $totaldeducciones += $row['descuentos'];

            $totaldias += $row['valor'];

            $i++;
        }
        
        // Impresión de los totales
        $p = $i + 1;
        $q = $i + 2;
        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('C'.$i, "DIAS:")
                    ->setCellValue('D'.$i, number_format($totaldias))
                    ->setCellValue('C'.$p, "DEVENGADOS:")
                    ->setCellValue('D'.$p, number_format($totaldevengados))                    
                    ->setCellValue('C'.$q, "DEDUCCIONES:")
                    ->setCellValue('D'.$q, number_format($totaldeducciones));

        $rangoEncabezado = 'A4:E4';
        $rangoCeldas     = 'A4:E'.($cant+1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(20);

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('novedades');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$nombrearchivo.'"');
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función fechayhoraejecucion
    // Parámetro de entrada:    Ninguno
    // Valor de retorno:        $fechoraimp --> día, fecha y hora
    // Descripción: Función que devuelve la fecha con día, fecha y hora de ejecución del 
    //              último proceso
    ////////////////////////////////////////////////////////////////////////////////////////
    function fechayhoraejecucion()
    {
        $mesimp = date('F');
        if($mesimp == "January")       $mesimp = "enero";
        if($mesimp == "February")      $mesimp = "febrero";
        if($mesimp == "March")         $mesimp = "marzo";
        if($mesimp == "April")         $mesimp = "abril";
        if($mesimp == "May")           $mesimp = "mayo";
        if($mesimp == "June")          $mesimp = "junio";
        if($mesimp == "July")          $mesimp = "julio";
        if($mesimp == "August")        $mesimp = "agosto";
        if($mesimp == "September")     $mesimp = "septiembre";
        if($mesimp == "October")       $mesimp = "octubre";
        if($mesimp == "November")      $mesimp = "noviembre";
        if($mesimp == "December")      $mesimp = "diciembre";

        $dayweek = date("l");
        if($dayweek == "Monday")       $dayweek = "lunes";
        if($dayweek == "Tuesday")      $dayweek = "martes";
        if($dayweek == "Wednesday")    $dayweek = "miércoles";
        if($dayweek == "Thursday")     $dayweek = "jueves";
        if($dayweek == "Friday")       $dayweek = "viernes";
        if($dayweek == "Saturday")     $dayweek = "sábado";
        if($dayweek == "Sunday")       $dayweek = "domingo";

        $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');
        return($fechoraimp);
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función validar_fecha_espanol
    // Parámetro de entrada:    $fecha --> Fecha que se va a evaluar
    // Valor de retorno:        true o false
    // Descripción: Función que valida el formato de fecha dd/mm/aaaa
    ////////////////////////////////////////////////////////////////////////////////////////
    function validar_fecha_espanol($fecha)
    {
        $valores = explode('/', $fecha);
        if(count($valores) == 3 && checkdate($valores[1], $valores[0], $valores[2]))
        {
            return true;
        }
        return false;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función verifica_rango
    // Parámetro de entrada:    $date_inicio --> Fecha de inicio del periodo
    //                          $date_fin    --> Fecha fin del periodo
    //                          $date_nueva  --> Fecha que se va a evaluar
    // Valor de retorno:        true o false
    // Descripción: Función que valida si una fecha está en un rango especifico
    ////////////////////////////////////////////////////////////////////////////////////////    
    function verifica_rango($date_inicio, $date_fin, $date_nueva) 
    {
        $date_inicio = strtotime($date_inicio);
        $date_fin = strtotime($date_fin);
        $date_nueva = strtotime($date_nueva);

        if (($date_nueva >= $date_inicio) && ($date_nueva <= $date_fin))
            return true;
        else
            return false;
    }    
?>