<?PHP
    @session_start(); 

    require_once("classes/class_validaciones.php");
    $io_fecha=new class_validaciones();

    include("lib/Sistema.php");      
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanaimportacion
    // Creación: 31/08/2022		última modificación: 04/03/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana con los accesos para los procesos de importación desde una hoja 
    //              de Excel
    // Última modificación: Mensaje de advertencia del servidor equivocado (09/11/2022)
    //                      Acceso a la opción retirados en el periodo
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "ventanaimportacion")
    {
        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/importarexcel.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b>Procesos de importaci&oacute;n desde Excel </b> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="terceros.php" title="acceder a la ficha terceros" target="_blank">
                    <img src="images/iconos/terceros.png" border="0" width="38" height="38">
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        // Advertencia del servidor equivocado 
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td>
                      <td width="930" align="center"> 
                       Para ejecutar los procesos de importación desde una hoja de Excel debe dirigirse al servidor <br> 192.168.14.248:9999 o al servidor dromedicas.sytes.net:9996 
                      </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';

        $cont.='<center>	
                <table width="900" border="0">
                 <tr height="120">
                  <td width="25%" align="center">
                   <a href="?opcion=importarexcel9" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br> Importar pago <br>de cesantías
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=importarexcel7" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br>Importar dotaciones
                   </a> 
                  </td>
                  <td width="25%" align="center"> 
                   <a href="?opcion=importarexcel5" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br>Importar descuentos <br>ocasionales
                   </a>
                  </td>
                  <td width="25%" align="center"> 
                   <a href="?opcion=importarexcel3" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br>Importar intereses <br> de cesantías
                   </a> 
                  </td>
                 </tr>
                 <tr height="120">
                  <td width="25%" align="center">
                   <a href="?opcion=importarexcel" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br>Importar primas
                   </a> 
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=editarpagocesantia" rel="facebox"> 
                    <img src="images/iconos/cajas.png" border="0">
                    <br>Procesar pagos de <br>cesantías manualmente
                   </a>  
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=editardotacion" rel="facebox"> 
                    <img src="images/iconos/bodegas.png" border="0">
                    <br>Procesar dotaciones<br> manualmente
                   </a>                   
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=editarprimamanual" rel="facebox"> 
                    <img src="images/iconos/guardar.png" border="0">
                    <br>Procesar primas<br> manualmente
                   </a>                    
                  </td>
                 </tr>
                 <tr height="120">
                  <td width="25%" align="center">
                   <a href="?opcion=cesantiasmanual" rel="facebox"> 
                    <img src="images/iconos/guardardoc.png" border="0">
                    <br>Procesar intereses de <br>cesant&iacute;as manualmente
                   </a> 
                  </td>';

        // Periodo anterior
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoidanterior = $clase->SeleccionarUno($vsql);
        
        $descripcionant = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');

        // variables para controlar la importación hacía Excel de las libranzas y los descuentos permanentes
        $cal_libranza = $_SESSION['G_CAL_LIBRANZA'];
        $cal_permanente = $_SESSION['G_CAL_PERMANENTE'];

        // activo estos botines si están configurados para eso
        if(($cal_libranza!="CHECKED")||($cal_permanente!="CHECKED"))
        {
            if(($cal_libranza!="CHECKED")&&($cal_permanente!="CHECKED"))
            {                
                $tipodesc = "ambas";
                $cont.=' <td width="25%" align="center">
                          <!-- <a href="?opcion=importarexcel11&periodoidanterior='.$periodoidanterior.'&tipodesc='.$tipodesc.'" rel="facebox"> -->
                          <a href="importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior='.$periodoidanterior.'" target="_blank">
                           <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                           <br> Importar libranzas y <br>descuentos permanentes<br>'.strtolower($descripcionant).'
                          </a>
                         </td>
                         <td width="25%" align="center">
                          <a href="?opcion=editarlibyperm&periodoidanterior='.$periodoidanterior.'&tipodesc='.$tipodesc.'" rel="facebox">
                           <img src="images/iconos/aspectos.png" border="0">
                           <br>Procesar libranzas y <br>descuentos permanentes<br> manualmente
                          </a> 
                         </td>';
                
                $cont.=' <td width="25%" align="center">                          
                          <a href="importarexcelnom.php?opcion=importarnovedades&periodoidanterior='.$periodoidanterior.'" target="_blank">
                           <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                           <br> Importar novedades<br>'.strtolower($descripcionant).'
                          </a>
                         </td>';

                $cont.='</tr>';
            }

            if(($cal_libranza=="CHECKED")&&($cal_permanente!="CHECKED"))
            {
                $tipodesc = "descperm";
                $cont.=' <td width="25%" align="center">
                          <!-- <a href="?opcion=importarexcel11&periodoidanterior='.$periodoidanterior.'&tipodesc='.$tipodesc.'" rel="facebox"> -->
                           <a href="importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior='.$periodoidanterior.'" target="_blank">
                           <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                           <br> Importar descuentos<br> permanentes<br> '.strtolower($descripcionant).'
                          </a>
                         </td>
                         <td width="25%" align="center">
                          <a href="?opcion=editarlibyperm&periodoidanterior='.$periodoidanterior.'&tipodesc='.$tipodesc.'" rel="facebox">
                           <img src="images/iconos/aspectos.png" border="0">
                           <br>Procesar descuentos<br>permanentes manualmente
                          </a> 
                         </td>';
                
                $cont.=' <td width="25%" align="center">
                          <!-- <a href="?opcion=importarexcel12&periodoidanterior='.$periodoidanterior.'&tipodesc='.$tipodesc.'" rel="facebox"> -->
                          <a href="importarexcelnom.php?opcion=importarnovedades&periodoidanterior='.$periodoidanterior.'" target="_blank">
                           <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                           <br> Importar novedades<br>'.strtolower($descripcionant).'
                          </a>
                         </td>';

                $cont.='</tr>';
            }

            if(($cal_libranza!="CHECKED")&&($cal_permanente=="CHECKED"))
            {
                $tipodesc = "libranza";
                $cont.=' <td width="25%" align="center">
                          <!-- <a href="?opcion=importarexcel11&periodoidanterior='.$periodoidanterior.'&tipodesc='.$tipodesc.'" rel="facebox"> -->
                           <a href="importarexcelnom.php?opcion=importarlibranzasall&periodoidanterior='.$periodoidanterior.'" target="_blank">
                           <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                           <br> Importar libranzas<br>'.strtolower($descripcionant).'
                          </a>
                         </td>
                         <td width="25%" align="center">
                          <a href="?opcion=editarlibyperm&periodoidanterior='.$periodoidanterior.'&tipodesc='.$tipodesc.'" rel="facebox">
                           <img src="images/iconos/aspectos.png" border="0">
                           <br>Procesar libranzas<br> manualmente
                          </a> 
                         </td>';
                
                $cont.=' <td width="25%" align="center">
                          <!-- <a href="?opcion=importarexcel12&periodoidanterior='.$periodoidanterior.'&tipodesc='.$tipodesc.'" rel="facebox"> -->
                          <a href="importarexcelnom.php?opcion=importarnovedades&periodoidanterior='.$periodoidanterior.'" target="_blank">
                           <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                           <br> Importar novedades<br>'.strtolower($descripcionant).'
                          </a>
                         </td>';
            
                $cont.='</tr>';
            }

            if(($cal_libranza=="CHECKED")&&($cal_permanente=="CHECKED"))
            {
                $cont.=' <td width="25%" align="center">
                          <!-- <a href="?opcion=importarexcel12&periodoidanterior='.$periodoidanterior.'&tipodesc='.$tipodesc.'" rel="facebox"> -->
                          <a href="importarexcelnom.php?opcion=importarnovedades&periodoidanterior='.$periodoidanterior.'" target="_blank">
                           <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                           <br> Importar novedades<br>'.strtolower($descripcionant).'
                          </a>
                         </td>
                        </tr>';
            }
        }
        else
            $cont.=' <td width="25%" align="center">
                      <!--<a href="?opcion=importarexcel12&periodoidanterior='.$periodoidanterior.'&tipodesc='.$tipodesc.'" rel="facebox"> -->
                      <a href="importarexcelnom.php?opcion=importarnovedades&periodoidanterior='.$periodoidanterior.'" target="_blank">
                       <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                       <br> Importar novedades<br>'.strtolower($descripcionant).'
                      </a>
                     </td>';

        $cont.=' </tr>                 
                 <tr height="120">
                  <td width="25%" align="center">
                   <a href="?opcion=importarexcel15" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br> Corregir <br> incapacidades   
                   </a>
                  </td>
                  <td width="25%" align="center">                   
                   <a href="?opcion=selperiodo" title="pre c&aacute;lculo de primas" rel="facebox"> 
                    <img src="images/iconos/exportarexcel2.png" border="0"> 
                    <br> Pre cálculo de primas <br> de servicio
                   </a>
                  </td>
                  <td width="25%" align="center"> 
                   <a href="?opcion=confirmeretrans&periodoidanterior='.$periodoidanterior.'"  rel="facebox">
                    <img src="images/iconos/calculando.png" border="0" width="38" height="38">
                    <br> Recalcular subsidio <br> de transporte
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=vererrores" rel="facebox">
                    <img src="images/iconos/notas.png" border="0" width="38" height="38">
                    <br> Documentos no grabados <br> en el &uacute;ltimo proceso 
                   </a>
                  </td>
                 </tr>
                 <tr height="120">
                  <td width="25%" align="center">
                   <a href="?opcion=importarexcel19&periodoidanterior='.$periodoidanterior.'" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br> Cambiar cargo, <br> básico y recalcular <br>'.strtolower($descripcionant).'
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=recargonocturno&periodoidanterior='.$periodoidanterior.'" target="_blank">
                    <img src="images/iconos/cajas.png" border="0" width="38" height="38">
                    <br> Recargos <br>'.strtolower($descripcionant).'
                   </a>
                  </td>
                  <td width="25%" align="center"> &nbsp; </td>
                  <td width="25%" align="center"> &nbsp; </td>
                 </tr>
                 <!-- -----------------------------------------------------------------------------------
                 <tr height="120">
                  <td width="25%" align="center">
                   <a href="?opcion=importarexcel17" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br> Retirados en el periodo <br>'.strtolower($descripcionant).'
                   </a>
                  </td>
                  <td width="25%" align="center"> &nbsp; </td>
                  <td width="25%" align="center"> &nbsp; </td>
                  <td width="25%" align="center"> &nbsp; </td>
                 </tr>
                 ----------------------------------------------------------------------------------- --> 
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarlibyperm
    // Creación: 05/08/2022		última modificación: 12/08/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana para la captación de datos del proceso manual de las libranzas  
    //              y los descuentos permanentes
    // Última modificación: Validación del cálculo del periodo
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "editarlibyperm")
    {
        $periodoidanterior = $_GET["periodoidanterior"];
        $tipodesc = $_GET["tipodesc"];
        $descripcionant = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');
        
        $cont = '';
        $params = ' class="Texto12" ';

        // combo de empleados
        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";
        $monto = 1;

        // Combo de conceptos
        $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto FROM conceptosnomina ";

        if($tipodesc=="ambas")      $vsqlcomboconcepto.= "WHERE eslibranza = 'CHECKED' OR montopermanente = 'CHECKED' ";
        if($tipodesc=="descperm")   $vsqlcomboconcepto.= "WHERE montopermanente = 'CHECKED' ";
        if($tipodesc=="libranza")   $vsqlcomboconcepto.= "WHERE eslibranza = 'CHECKED' ";

        $vsqlcomboconcepto.= " ORDER BY conceptoid ASC";

        // Pintamos la ventana        
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>';

        if($tipodesc=="ambas")      $cont.='<td align="center"> <b>Edici&oacute;n de libranzas y descuentos permanentes <br><font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td>';
        if($tipodesc=="descperm")   $cont.='<td align="center"> <b>Edici&oacute;n de descuentos permanentes <br><font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td>';
        if($tipodesc=="libranza")   $cont.='<td align="center"> <b>Edici&oacute;n de libranzas<br> <font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td>';
    
        $cont.=' </tr> 
                </table>                
                <form action="?opcion=guardarlibyperm" name="y" method="POST">
                <input type="hidden" name="periodoidanterior" value="'.$periodoidanterior.'">
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                   <td align="left"><label class="Texto12">Empleado:</label>';
    
        $cont.= $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,400);
                       
        $cont.='  </td>
                 </tr>                 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">concepto:</label>
                   '.$clase->CrearComboEsp("conceptoid",$vsqlcomboconcepto,"conceptoid","nomperiodo",$conceptoid,"N",$params).'
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Monto:</label>&nbsp;&nbsp;&nbsp;&nbsp;
                   <input type="number" name="monto" min="1" class="Texto12" size="2" autocomplete="off" title="monto de la dotaci&oacute;n" value="'.$monto.'">
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="importacionexcelnom.php?opcion=ventanaimportacion"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                  </td>
                 </tr>
                </table>';
        
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarlibyperm
    // Creación: 05/08/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para almacenar las libranzas y los descuentos permanentes 
    //              procesados manualmente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarlibyperm")
    {
        $terid = $_POST['terid'];
        $conceptoid = $_POST['conceptoid'];
        $monto = $_POST['monto'];
        $periodoidanterior = $_POST['periodoidanterior'];

        // Validación de los datos
        if((strlen($terid)==0) || (strlen($conceptoid)==0) || (strlen($monto)==0) || (strlen($periodoidanterior)==0))
            $clase->Aviso(3,"Debe ingresar todos los datos");
        else
        {
            // Valido que el concepto asignado a un empleado no esté repetido
            $vsql3 = "SELECT count(*) AS valreg
                        FROM detallenomina
                       WHERE pernominaid = ".$periodoidanterior."
                             AND terid = ".$terid."
                             AND conceptoid = ".$conceptoid;
            $valreg = $clase->SeleccionarUno($vsql3);

            if($valreg>0)
            {
                $vsql4 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid=".$terid;
                $nombreemp = $clase->SeleccionarUno($vsql4);
    
                $vsql5 = "SELECT nomconcepto FROM conceptosnomina WHERE conceptoid=".$conceptoid;
                $nomconcepto = $clase->SeleccionarUno($vsql5);
    
                $clase->Aviso(3,"$nombreemp ya tiene $nomconcepto en este periodo");
            }
            else
            {
                // Obtengo el número de registros de la tabla detallenomina
                $vsql = "SELECT MAX(detalleid) FROM detallenomina";
                $numeroid = $clase->SeleccionarUno($vsql);
        
                // Incremento el ID
                $numeroid++;
        
                // Determino el tipo de concepto
                $tipodc = $clase->BDLockup($periodoidanterior,'conceptosnomina','conceptoid','tipodc');
        
                // Construyo la instrucción
                if($tipodc=="C")
                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidanterior.",".$monto.",0,0,0)";
                else
                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidanterior.",0,".$monto.",0,0)";
        
                // Almaceno en la tabla
                $clase->EjecutarSQL($vsql);
        
                // Emito el mensaje correspondiente
                if(mysql_affected_rows() >= 1)
                    $clase->Aviso(1,"Datos almacenados satisfactoriamente");
                else
                    $clase->Aviso(3,"No se almacenaron los datos");
            }
        }

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel
    // Creación: 14/12/2021		última modificación: 29/06/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para seleccionar la hoja de Excel
    // Última modificación: Se añadió la advertencia que se debe utilizar un archivo .xlsx
    //                      (03/01/2021)
    //                      Inclusión de la estructura de la hoja de Excel que se importará
    //                      (08/02/2022)
    //                      Validación del servidor 248 y .net para realizar el proceso
    ////////////////////////////////////////////////////////////////////////////////////////
	if($opcion == "importarexcel")
	{
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar primas </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el código del periodo
            $yeartoday = date("Y");
    
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";
    
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar primas <br> <font color="blue">'.strtolower($desperiodo).'</font></b> </td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcel2" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>
                       <!-- <input type="checkbox" name="elimnaprimas" value="CHECKED"> Eliminar primas del periodo '.strtolower($desperiodo).'</a><br><br> -->
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: D&iacute;as </td> </tr> 
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Pago </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: Tipo (<b><font color="blue">2</font></b> n&oacute;mina <b><font color="blue">E</font></b> extralegal) </td> </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemploprimas2.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel2
    // Creación: 14/12/2021		última modificación: 27/12/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para grabar los datos importados de la hoja de Excel
    // Última modificación: Inclusión de registro en la tabla de enlace primas con terceros 
    //                      para los datos del recibo de pago (31/12/2021)
    //                      Validación de la extensión del archivo que se importará
    //                      (04/01/2022)
    //                      Se incluyó el campo tipo de la tabla primasterceros para 
    //                      diferenciar las primas de las cesantías (20/01/2022)
    //                      Almacenamiento en un archivo de texto de las cédulas que no 
    //                      fueron grabadas en el proceso (08/11/2022)
    //                      Inclusión de la columna para el tipo de empleado y exclusión de 
    //                      la validación de empleado activo
    //                      Inclusión de la impresión de la fecha de ejecución del proceso
    //                      (01/03/2023)
    //                      Optimización del proceso para grabar en la tabla primasterceros
    ////////////////////////////////////////////////////////////////////////////////////////
	if($opcion == "importarexcel2")
	{
		set_time_limit(0);
		extract($_POST);
		$docuid = $_POST["docuid"];
        $elimnaprimas = $_POST["elimnaprimas"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();  
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cantidad'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pago'] = round( $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue());
                    $_DATOS_EXCEL[$i]['tipoempleado'] = round( $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue());
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)&&(strlen($_DATOS_EXCEL[$i]['cantidad']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el código del periodo
            $yeartoday = date("Y");

            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                            FROM periodosnomina 
                           WHERE consecutivone <> ''
                                 AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";

            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);            

            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);                
            }

            // ------------------------------------------------------------------------------------------ //
            // Eliminación de las compras a crédito en el periodo si se marca el checkbox correspondiente
            if($elimnaprimas == "CHECKED")
            {
                $vsql = "DELETE FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'primas'";
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------ //
            // Obtengo el nombre del periodo a procesar
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);

            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'PRIMAS DE SERVICIO'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($desperiodo,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $tipoempleado = $_DATOS_EXCEL[$j]['tipoempleado'];
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],$tabla,"dni","terid");
                
                if($terid != "")
                {
                    // // Valido que el empleado esté activo
                    // $esempleadoactivo = $clase->BDLockup($terid,$tabla,'terid','esempleadoactivo');

                    // if($esempleadoactivo=="CHECKED")
                    // {
                        $cantidad = $_DATOS_EXCEL[$j]['cantidad'];
                        $pago = $_DATOS_EXCEL[$j]['pago'];
        
                        // Almaceno en la tabla
                        $vsql = "INSERT INTO liquidacion (periodonomina,terid,tipo,pago,cantidad,porcentaje,pagointereses) 
                                                  VALUES ('".$codperiodo."',".$terid.",'primas',".$pago.",".$cantidad.",0,0)";
                        $clase->EjecutarSQL($vsql);
        
                        if(mysql_affected_rows() >= 1)
                        {
                            $grabados++;
                            $lbgrabo = true;
        
                            // Guardo en la tabla de enlace
                            $vsql2 = "SELECT COUNT(*) AS valreg
                                       FROM primasterceros
                                      WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
                            $valreg = $clase->SeleccionarUno($vsql2);

                            if($valreg == 0)
                            {
                                // if(strlen($tipoempleado) == 0)
                                //     $vsql = "INSERT INTO primasterceros (tipo, periodonomina, terid, esempleado, esempleadoactivo, extralegal,
                                //                                          areaid, seccionid, cargoid, bancoid, numcuenta, fecingreso,
                                //                                          basico, codvende, dni, nombre, epsid, pensionesid) 
                                //                   SELECT 'primas', '".$codperiodo."', terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                //                          cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, 
                                //                          CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre,
                                //                          epsid, pensionesid
                                //                     FROM terceros
                                //                    WHERE terid = ".$terid;
                                // else
                                // {
                                //     if($tipoempleado=="2")
                                //         $vsql = "INSERT INTO primasterceros (tipo, periodonomina, terid, esempleado, esempleadoactivo, extralegal,
                                //                                              areaid, seccionid, cargoid, bancoid, numcuenta, fecingreso,
                                //                                              basico, codvende, dni, nombre, epsid, pensionesid) 
                                //                       SELECT 'primas', '".$codperiodo."', terid, esempleado, esempleadoactivo, '', areaid, seccionid,
                                //                              cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, 
                                //                              CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre,
                                //                              epsid, pensionesid
                                //                         FROM terceros
                                //                        WHERE terid = ".$terid;
    
                                //     if($tipoempleado=="E")
                                //         $vsql = "INSERT INTO primasterceros (tipo, periodonomina, terid, esempleado, esempleadoactivo, extralegal,
                                //                                              areaid, seccionid, cargoid, bancoid, numcuenta, fecingreso,
                                //                                              basico, codvende, dni, nombre, epsid, pensionesid) 
                                //                       SELECT 'primas', '".$codperiodo."', terid, esempleado, esempleadoactivo, 'CHECKED', areaid, seccionid,
                                //                              cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, 
                                //                              CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre,
                                //                              epsid, pensionesid
                                //                         FROM terceros
                                //                        WHERE terid = ".$terid;
                                // }

                                $vsql = "INSERT INTO primasterceros (tipo, periodonomina, terid, esempleado, esempleadoactivo, extralegal,
                                                     areaid, seccionid, cargoid, bancoid, numcuenta, fecingreso,
                                                     basico, codvende, dni, nombre, epsid, pensionesid) 
                                              SELECT 'primas', '".$codperiodo."', terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                                     cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, 
                                                     CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre,
                                                     epsid, pensionesid
                                                FROM terceros
                                               WHERE terid = ".$terid;
                                $clase->EjecutarSQL($vsql);
                            }
                        }
                    // }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }                
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errores.txt";                                                   // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                    // Grabas
            fclose($fd);                                                                // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las primas");
            else
                $clase->Aviso(1,"Se cargaron $grabados primas para el periodo $desperiodo");
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel3
    // Creación: 18/01/2022		última modificación: 29/06/2022
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para grabar los datos importados de la hoja de Excel
    // Última modificación: Inclusión de la estructura de la hoja de Excel que se importará
    //                      (08/02/2022)
    //                      Validación del servidor 248 y .net para realizar el proceso
    ////////////////////////////////////////////////////////////////////////////////////////          
    if($opcion == "importarexcel3")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar intereses de cesant&iacute;as </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el código del periodo
            $yeartoday = date("Y");
    
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";
    
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                        $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar intereses de <br> cesant&iacute;as <font color="blue">'.strtolower($desperiodo).'</font> </b></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcel4" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Pago de cesant&iacute;as (0) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: D&iacute;as </td> </tr> 
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: Porcentaje de cesant&iacute;as </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>E</b>: Pago de intereses </td> </tr>                 
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocesantias.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont; 
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel4
    // Creación: 18/01/2022	    última modificación: 01/03/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para grabar los datos de las cesantías importados de la hoja de 
    //              Excel
    // Última modificación: Se incluyó el campo tipo de la tabla primasterceros para 
    //                      diferenciar las primas de las cesantías (20/01/2022)
    //                      Almacenamiento en un archivo de texto de las cédulas que no 
    //                      fueron grabadas en el proceso (08/11/2022)
    //                      Inclusión de la impresión de la fecha de ejecución del proceso
    ////////////////////////////////////////////////////////////////////////////////////////    
	if($opcion == "importarexcel4")
	{
		set_time_limit(0);
		extract($_POST);
		$docuid = $_POST["docuid"];
        $elimnacesantias = $_POST["elimnacesantias"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagocesantias'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cantidad'] = round( $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue());
                    $_DATOS_EXCEL[$i]['porcesantias'] = round( $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue());
                    $_DATOS_EXCEL[$i]['pagointereses'] = round( $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue());
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el código del periodo
            $yeartoday = date("Y");

            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday." ";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;

            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";

            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);

            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }

            // ------------------------------------------------------------------------------------------ //
            // Eliminación de las compras a crédito en el periodo si se marca el checkbox correspondiente
            if($elimnacesantias == "CHECKED")
            {
                $vsql = "DELETE FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------ //
            // Obtengo el nombre del periodo a procesar
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);

            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos                
            $errores = 0;
            $grabados = 0;

            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'INTERESES DE CESANTIAS'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($desperiodo,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);            

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $pagocesantias = 0;
                $cantidad = 0;
                $porcesantias = 0;
                $pagointereses = 0;
                $dni = $_DATOS_EXCEL[$j]['dni'];

                $valreg = 0;
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],$tabla,"dni","terid");
                
                if($terid != "")
                {
                    // Valido que el empleado esté activo
                    $esempleadoactivo = $clase->BDLockup($terid,$tabla,'terid','esempleadoactivo');

                    // if($esempleadoactivo=="CHECKED")
                    // {
                        $pagocesantias = $_DATOS_EXCEL[$j]['pagocesantias'];
                        $cantidad = $_DATOS_EXCEL[$j]['cantidad'];
                        $porcesantias = $_DATOS_EXCEL[$j]['porcesantias'];
                        $pagointereses = $_DATOS_EXCEL[$j]['pagointereses'];
    
                        // Valido que todos los datos sean numéricos
                        $lb_valido1 = false;
                        $lb_valido2 = false;
                        $lb_valido3 = false;
                        $lb_valido4 = false;
    
                        $lb_valido1 = $io_fecha->uf_solo_numeros($pagocesantias);
                        $lb_valido2 = $io_fecha->uf_solo_numeros($cantidad);
                        $lb_valido3 = $io_fecha->uf_solo_numeros($porcesantias);
                        $lb_valido4 = $io_fecha->uf_solo_numeros($pagointereses);
    
                        if(($lb_valido1)&&($lb_valido2)&&($lb_valido3)&&($lb_valido4))
                        {
                            // Almaceno en la tabla
                            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                                      VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcesantias.",".$pagointereses.")";
                            $clase->EjecutarSQL($vsql);
            
                            if(mysql_affected_rows() >= 1)
                            {
                                $grabados++;
                                $lbgrabo = true;
            
                                // Guardo en la tabla de enlace
                                $vsql = "INSERT INTO primasterceros (tipo, periodonomina, terid, esempleado, esempleadoactivo, extralegal,
                                                                     areaid, seccionid, cargoid, bancoid, numcuenta, fecingreso,
                                                                     basico, codvende, dni, nombre, epsid, pensionesid)                             
                                              SELECT 'cesantias', '".$codperiodo."', terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                                     cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, 
                                                     CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre,
                                                     epsid, pensionesid
                                                FROM terceros
                                               WHERE terid = ".$terid;
                                $clase->EjecutarSQL($vsql);
                            }                        
                        }
                    // }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }                
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errores.txt";                                                   // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                    // Grabas
            fclose($fd);                                                                // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las cesantías");
            else
                $clase->Aviso(1,"Se cargaron $grabados cesantías para el periodo $desperiodo");            
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel5
    // Creación: 31/01/2022		última modificación: 04/08/2022
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción para grabar los datos importados de la hoja de Excel
    // Última modificación: Inclusión de la estructura de la hoja de Excel que se importará
    //                      (08/02/2022)
    //                      checkbox para eliminar las compras a crédito en el periodo
    //                      (22/02/2022)
    //                      Validación del servidor 248 y .net para realizar el proceso
    //                      (29/06/2022)
    //                      Inclusión del combo para los descuentos ocasionales
    ////////////////////////////////////////////////////////////////////////////////////////          
    if($opcion == "importarexcel5")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b></td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor diríjase al servidor </font><br> 
        //                <font color=blue> 192.168.14.248:9999 </font> <br>
        //                <font color=red>o al servidor </font> <br> 
        //                <font color=blue> dromedicas.sytes.net:9996 </font> <br>
        //                <font color=red> para poder importar estos datos </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">        
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
        //                 <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
        //                </form> 
        //               </td>    
        //              </tr>
        //             </table>';
        // else
        // {
            // Obtengo el código del periodo
            $yeartoday = date("Y");
    
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";
    
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

            // Combo de Periodos
            $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto
                                    FROM conceptosnomina 
                                   WHERE montoocasional = 'CHECKED'
                                ORDER BY conceptoid ASC";
            $params = ' class="Texto12" ';
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar descuentos ocasionales <br><font color="blue">'.strtolower($desperiodo).'</font></b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcel6" id="theform" enctype="multipart/form-data">
                       concepto: '.$clase->CrearComboEsp("conceptoid",$vsqlcomboconcepto,"conceptoid","nomperiodo",$conceptoid,"N",$params).'
                       <br> <br>
                       <input type="file" name="excel" /><br><br>
                       <input type="checkbox" name="elimnacompras" value="CHECKED"> Eliminar todos los registros de este concepto <br> en el periodo '.strtolower($desperiodo).'</a><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Monto (solo n&uacute;meros) </td> </tr>                 
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocompras.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        // }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel6
    // Creación: 31/01/2022	    última modificación: 01/03/2023
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción para grabar los datos de las compras a crédito de la hoja de 
    //              Excel
    // Última modificación: Eliminación de las compras a crédito en el periodo si se marca 
    //                      el checkbox elimnacompras (22/02/2022)
    //                      Procesamiento de los descuentos permanentes, ocasionales y 
    //                      libranzas, validación del monto y verificación del tipo de
    //                      concepto (23/07/2022)
    //                      Almacenamiento en un archivo de texto de los documentos que no 
    //                      se grabaron en el proceso (04/11/2022)
    //                      Inclusión de la impresión de la fecha de ejecución del proceso
    ////////////////////////////////////////////////////////////////////////////////////////    
	if($opcion == "importarexcel6")
	{
		set_time_limit(0);
		extract($_POST);
		$conceptoid = $_POST["conceptoid"];        
        $elimnacompras = $_POST["elimnacompras"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)&&(strlen($_DATOS_EXCEL[$i]['monto']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el periodo actual
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);

            // ------------------------------------------------------------------------------------------ //
            // Eliminación de las compras a crédito en el periodo si se marca el checkbox correspondiente
            if($elimnacompras == "CHECKED")
            {
                $vsql = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoid." AND conceptoid = ".$conceptoid;
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------ //
            // Obtengo el nombre del periodo a procesar
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);

            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";            

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            // Nombres del concepto y del periodo
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = ''.str_pad($nomconcepto,1,"").''.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($descripcion,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $valreg = 0;
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],$tabla,"dni","terid");

                if($terid != "")
                {
                    // Valido que el empleado esté activo
                    $esempleadoactivo = $clase->BDLockup($terid,$tabla,'terid','esempleadoactivo');                    

                    if($esempleadoactivo=="CHECKED")
                    {
                        $monto = $_DATOS_EXCEL[$j]['monto'];
    
                        // llamado al procedimiento para validar el monto
                        $lb_valido = false;
                        $lb_valido = $io_fecha->uf_solo_numeros($monto);
                        if($lb_valido)
                        {
                            // Valido que el concepto asignado a un empleado no esté repetido
                            $vsql3 = "SELECT count(*) AS valreg
                                        FROM detallenomina
                                       WHERE pernominaid = ".$periodoid."
                                             AND terid = ".$terid."
                                             AND conceptoid = ".$conceptoid;
                            $valreg = $clase->SeleccionarUno($vsql3);
    
                            if($valreg==0)
                            {
                                // Obtengo el número de registros de la tabla detallenomina
                                $vsql = "SELECT MAX(detalleid) FROM detallenomina";
                                $numeroid = $clase->SeleccionarUno($vsql);
                        
                                // Incremento el ID
                                $numeroid++;
        
                                // Determino el tipo de concepto
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
        
                                // Construyo la instrucción
                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                  VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
                                else
                                    $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                  VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";                                
        
                                // Almaceno en la tabla
                                $clase->EjecutarSQL($vsql);

                                // Incremento el contados de registros almacenados
                                if(mysql_affected_rows() == 1)
                                {
                                    $grabados++;
                                    $lbgrabo = true;
                                }
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);         // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errores.txt";                                                       // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                                 // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                        // Grabas
            fclose($fd);                                                                    // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los registros de $nomconcepto para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados registros de $nomconcepto para el periodo $descripcion");
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel7
    // Creación: 04/03/2022		última modificación: 29/06/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para grabar los datos importados de la hoja de Excel de las 
    //              dotaciones de uniformes
    // Última modificación: Validación del servidor 248 y .net para realizar el proceso
    ////////////////////////////////////////////////////////////////////////////////////////          
    if($opcion == "importarexcel7")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar dotaciones </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el código del periodo
            $yeartoday = date("Y");
    
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";
    
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar dotaciones <br> <font color="blue">'.strtolower($desperiodo).'</font></b></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcel8" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>
                       <input type="checkbox" name="elimnadotaciones" value="CHECKED"> Eliminar dotaciones del periodo '.strtolower($desperiodo).'</a><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Monto </td> </tr>                 
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplodotaciones.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel8
    // Creación: 04/03/2022	    última modificación: 01/03/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para grabar los datos de las dotaciones importados de la hoja de 
    //              Excel
    // Última modificación: Almacenamiento en un archivo de texto de las cédulas que no 
    //                      fueron grabadas en el proceso (08/11/2022)
    //                      Validación del monto mayor a cero e inclusión de la impresión de 
    //                      la fecha de ejecución del proceso
    ////////////////////////////////////////////////////////////////////////////////////////    
	if($opcion == "importarexcel8")
	{
		set_time_limit(0);
		extract($_POST);		
        $elimnadotaciones = $_POST["elimnadotaciones"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['monto']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el código del periodo
            $yeartoday = date("Y");

            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;

            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep  = "SELECT codperiodo 
                                 FROM periodos 
                                WHERE anoperiodo = ".$yeartoday." 
                                      AND mesperiodo = ".$nummesval." 
                             ORDER BY orden";

            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);

            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep  = "SELECT codperiodo 
                                     FROM periodos 
                                    WHERE anoperiodo = ".$yeartoday." 
                                          AND mesperiodo = ".$nummesval." 
                                 ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }

            // ------------------------------------------------------------------------------------------ //
            // Eliminación de las compras a crédito en el periodo si se marca el checkbox correspondiente
            if($elimnadotaciones == "CHECKED")
            {
                $vsql = "DELETE FROM dotaciones WHERE periodonomina = '".$codperiodo."'";
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------ //
            // Obtengo el nombre del periodo a procesar
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);

            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;

            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'DOTACIONES'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($desperiodo,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];

                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],$tabla,"dni","terid");
                
                if($terid != "")
                {
                    // Valido que el empleado esté activo
                    $esempleadoactivo = $clase->BDLockup($terid,$tabla,'terid','esempleadoactivo');

                    if($esempleadoactivo=="CHECKED")
                    {
                        $monto = $_DATOS_EXCEL[$j]['monto'];                        
    
                        // llamado al procedimiento para validar el monto
                        $lb_valido = false;
                        $lb_valido = $io_fecha->uf_solo_numeros($monto);
                        if($lb_valido)
                        {
                            // Valido que el monto sea mayor a cero
                            if($monto > 0)
                            {
                                // Valido que el concepto asignado a un empleado no esté repetido
                                $vsql3 = "SELECT count(*) AS valreg
                                            FROM dotaciones
                                           WHERE periodonomina = '".$codperiodo."'
                                                 AND terid = ".$terid;
                                $valreg = $clase->SeleccionarUno($vsql3);
        
                                if($valreg==0)
                                {
                                    // Almaceno en la tabla
                                    $vsql = "INSERT INTO dotaciones (periodonomina, terid, monto) 
                                                             VALUES ('".$codperiodo."',".$terid.",".$monto.")";
                                    $clase->EjecutarSQL($vsql);
                    
                                    if(mysql_affected_rows() >= 1)
                                    {
                                        $grabados++;
                                        $lbgrabo = true;
                                    }
                                }
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errores.txt";                                                   // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                    // Grabas
            fclose($fd);                                                                // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las dotaciones");
            else
                $clase->Aviso(1,"Se cargaron satisfactoriamente $grabados dotaciones para el periodo $desperiodo");            
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel9
    // Creación: 07/03/2022		última modificación: 29/06/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para grabar los datos importados de la hoja de Excel del 
    //              pago de cesantías
    // Última modificación: Validación del servidor 248 y .net para realizar el proceso
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel9")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar pago de cesant&iacute;as </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el código del periodo
            $yeartoday = date("Y");
    
            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;
    
            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";
    
            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
    
            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }
    
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar pago de cesant&iacute;as <br> <font color="blue">'.strtolower($desperiodo).'</font></b></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcel10" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>
                       <input type="checkbox" name="elimnapagocesan" value="CHECKED"> Eliminar pago de cesant&iacute;as del periodo '.strtolower($desperiodo).'</a><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Monto </td> </tr>                 
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: D&iacute;as </td> </tr>                 
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplopagocesantias.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel10
    // Creación: 04/03/2022	    última modificación: 01/03/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para grabar los datos del pago de cesantías importados de la 
    //              hoja de Excel
    // Última modificación: Exclusión de la validación del empleado activo (26/12/2022)
    //                      Inclusión de la impresión de la fecha de ejecución del proceso
    ////////////////////////////////////////////////////////////////////////////////////////    
	if($opcion == "importarexcel10")
	{
		set_time_limit(0);
		extract($_POST);		
        $elimnapagocesan = $_POST["elimnapagocesan"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['dias'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['monto']) == 0) || (strlen($_DATOS_EXCEL[$i]['dias']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el código del periodo
            $yeartoday = date("Y");

            // Determino el código y el nombre del periodo que se reportará
            $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                             FROM periodosnomina 
                            WHERE consecutivone <> ''
                                  AND YEAR(fechasta) = ".$yeartoday."";
            $nummesval = $clase->SeleccionarUno($vsqlmesval);
            $nummesval++;

            if($nummesval==13)      $nummesval = 1;
            
            $vsqlcodmesrep = "SELECT codperiodo 
                                FROM periodos 
                               WHERE anoperiodo = ".$yeartoday." 
                                     AND mesperiodo = ".$nummesval." 
                            ORDER BY orden";

            $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);

            // Validación para el caso que sea del año anterior
            if(($codperiodo=="")||($codperiodo==NULL))
            {
                $yeartoday--;
                $nummesval--;
                $vsqlcodmesrep = "SELECT codperiodo 
                                    FROM periodos 
                                   WHERE anoperiodo = ".$yeartoday." 
                                         AND mesperiodo = ".$nummesval." 
                                ORDER BY orden";
                $codperiodo = $clase->SeleccionarUno($vsqlcodmesrep);
            }

            // ------------------------------------------------------------------------------------------ //
            // Eliminación de las compras a crédito en el periodo si se marca el checkbox correspondiente
            if($elimnapagocesan == "CHECKED")
            {
                $vsql = "DELETE FROM pagocesantias WHERE periodonomina = '".$codperiodo."'";
                $clase->EjecutarSQL($vsql);
            }

            // ------------------------------------------------------------------------------------------ //
            // Obtengo el nombre del periodo a procesar
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);

            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;

            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'PAGOS DE CESANTIAS'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($desperiodo,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],$tabla,"dni","terid");
                
                if($terid != "")
                {
                    $valreg = 0;
                    $monto = $_DATOS_EXCEL[$j]['monto'];
                    $dias = $_DATOS_EXCEL[$j]['dias'];
    
                    // Validación del monto y de los días
                    $lb_valido = false;
                    $lb_valido2 = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($monto);
                    $lb_valido2 = $io_fecha->uf_solo_numeros($dias);

                    if(($lb_valido)&&($lb_valido2))
                    {
                        // Valido que el concepto asignado a un empleado no esté repetido
                        $vsql3 = "SELECT count(*) AS valreg
                                    FROM pagocesantias
                                   WHERE periodonomina = '".$codperiodo."'
                                         AND terid = ".$terid;
                        $valreg = $clase->SeleccionarUno($vsql3);                        

                        if($valreg==0)
                        {
                            // Almaceno en la tabla
                            $vsql = "INSERT INTO pagocesantias (periodonomina, terid, dias, monto) 
                                                        VALUES ('".$codperiodo."',".$terid.",".$dias.",".$monto.")";
                            $clase->EjecutarSQL($vsql);
            
                            if(mysql_affected_rows() >= 1)
                            {
                                $grabados++;
                                $lbgrabo = true;
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }                
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);         // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errores.txt";                                                       // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                                 // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                        // Grabas
            fclose($fd);                                                                    // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)            
                $clase->Aviso(3,"No se cargaron los pagos de cesantías");
            else
                $clase->Aviso(1,"Se cargaron satisfactoriamente $grabados pagos de cesantías para el periodo $desperiodo");

            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel11
    // Creación: 25/07/2022		última modificación: 22/03/2023
    // Creador: Luis Flórez		modificado por:  Flórez
    // Descripción: Opción para grabar los datos importados de la hoja de Excel de las 
    //              libranzas y los descuentos permanentes
    // Última modificación: Advertencia que ya existen licencias y descuentos permanentes 
    //                      procesadas en el periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel11")
    {
        $periodoidanterior = $_GET["periodoidanterior"];
        $tipodesc = $_GET["tipodesc"];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            $descripcionant = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');
            
            // Combo de conceptos
            $params = ' class="Texto12" ';
            $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto FROM conceptosnomina ";

            if($tipodesc=="ambas")      $vsqlcomboconcepto.= "WHERE eslibranza = 'CHECKED' OR montopermanente = 'CHECKED' ";
            if($tipodesc=="descperm")   $vsqlcomboconcepto.= "WHERE montopermanente = 'CHECKED' ";
            if($tipodesc=="libranza")   $vsqlcomboconcepto.= "WHERE eslibranza = 'CHECKED' ";

            $vsqlcomboconcepto.= " ORDER BY conceptoid ASC";

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> ';

            if($tipodesc=="ambas")      $cont.='<td align="center"> <b>Importar libranzas<br> y descuentos permanentes <br><font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td>';
            if($tipodesc=="descperm")   $cont.='<td align="center"> <b>Importar descuentos permanentes <br><font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td>';
            if($tipodesc=="libranza")   $cont.='<td align="center"> <b>Importar libranzas<br><font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td>';

            $cont.=' </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcel14" id="theform" enctype="multipart/form-data">
                        <input type="file" name="excel" /><br><br>                        
                        <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                        <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';

            // Valido que existan libranzas y/o descuentos permanentes en el periodo
            $vsql = "SELECT COUNT(d.conceptoid) AS numlibydppro 
                       FROM detallenomina d 
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid) 
                      WHERE d.pernominaid = ".$periodoidanterior." 
                            AND (c.eslibranza = 'CHECKED' OR c.montopermanente = 'CHECKED')";
            $numlibydppro = $clase->SeleccionarUno($vsql);

            if($numlibydppro > 0)
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> 
                          <td width="10" align="right">                           
                           <img src="images/iconos/alerta.png" width="30" height="30" border="0">
                          </td>
                          <td width="390" align="center">
                           <font color="red"> <b>Advertencia: Ya existen licencias y/o descuentos <br>permanentes procesados en el periodo </b></font>
                          </td>
                         </tr>
                        </table>';

            // Descripción de la estructura de la hoja de Excel
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Monto (solo n&uacute;meros) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Tipo: </td> </tr> 
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>14</b></font> OPTICA DE TODOS <font color="blue"><b>15</b></font> OPTICA PRACSO <font color="blue"><b>16</b></font> PROGRESSA
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>17</b></font> COOPTELECUC <font color="blue"><b>18</b></font> DAVIVIENDA <font color="blue"><b>19</b></font> RECORDAR
                      </td>
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp;  <font color="blue"><b>20</b></font> LOS OLIVOS <font color="blue"><b>21</b></font> LA ESPERANZA 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>27</b></font> SEGURO DE VIDA SURAMERICANA <font color="blue"><b>29</b></font> BANCOLOMBIA
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>30</b></font> EMBARGO <font color="blue"><b>42</b></font> OPTICA MM
                      </td> 
                     </tr>
                    </table>';
        
            // Advertencia de la extensión de la hoja de Excel 
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocompras2.png" width="280" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel12
    // Creación: 17/08/2022		última modificación: 22/02/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para captar los datos para la importación desde una hoja de  
    //              Excel de las novedades
    // Última modificación: Adaptación para importar todas las licencias en una hoja de 
    //                      Excel (21/09/2022)
    //                      Advertencia que ya existen novedades procesadas en el periodo
    //                      22/03/2023
    //                      Inclusión de los conceptos Macropapeles y seguros Bolívar en la 
    //                      descripción de la estructura de la hoja de Excel
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel12")
    {
        $periodoidanterior = $_GET["periodoidanterior"];
        $tipodesc = $_GET["tipodesc"];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            $descripcionant = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');            

            // Combo de conceptos
            $params = ' class="Texto12" ';
            $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto
                                    FROM conceptosnomina 
                                   WHERE eslicencia = 'CHECKED' 
                                ORDER BY conceptoid ASC";

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar novedades<br> <font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcel13" id="theform" enctype="multipart/form-data">
                        <input type="hidden" name="periodoidanterior" value="'.$periodoidanterior.'">        
                        <input type="file" name="excel" /><br><br>                            
                        <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                        <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';

            // Valido que existan licencias pendientes para emitir el mensaje correspondiente
            $vsql = "SELECT COUNT(d.conceptoid) AS numlicenciaspro
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.pernominaid = ".$periodoidanterior."
                            AND c.eslicencia = 'CHECKED'";
            $numlicenciaspro = $clase->SeleccionarUno($vsql);

            if($numlicenciaspro > 0)
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> 
                          <td width="10" align="right">                           
                           <img src="images/iconos/alerta.png" width="30" height="30" border="0">
                          </td>
                          <td width="390" align="center">
                           <font color="red"> <b>Advertencia: Ya existen novedades procesadas <br>en el periodo </b></font>
                          </td>
                         </tr>
                        </table>';            

            $variab = 'G_NOFECHALIC';
            $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

            if($nofechalic == "CHECKED")
            {
                $fecdesde = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','fecdesde');
                $fecdesde2  = substr($fecdesde,8,2)."/".substr($fecdesde,5,2)."/".substr($fecdesde,0,4);
                $mensajefecha = 'Fecha <b>'.$fecdesde2.'</b> para todas';
            }
            else
                $mensajefecha = 'Fecha <b>(formato texto)</b>';

            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: '.$mensajefecha.' </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: D&iacute;as </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: Tipo de licencia: </td> </tr> 
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>6</b></font> LICENCIA NO REMUNERADA <font color="blue"><b>9</b></font> SUSPENCION <font color="blue"><b>10</b></font> INCAPACIDAD
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>11</b></font> LICENCIA POR MATERNIDAD <font color="blue"><b>12</b></font> LICENCIA POR PATERNIDAD
                      </td>
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>13</b></font> LICENCIA REMUNERADA <font color="blue"><b>23</b></font> LICENCIA POR CUMPLEAñOS 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>31</b></font> MATRIMONIO <font color="blue"><b>40</b></font> INCAPACIDAD ARL 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>43</b></font> INC SUPERIOR A 180 D&Iacute;AS <font color="blue"><b>36</b></font> MACROPAPELES 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>44</b></font> SEGUROS BOLIVAR
                      </td> 
                     </tr>
                    </table>';

            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplolicencias2.png" width="300" height="200" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx </font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel13
    // Creación: 22/08/2022		última modificación: 21/03/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para calcular las novedades de acuerdo a los datos aportados 
    //              desde una hoja de Excel
    // Última modificación: Adaptación para importar todas las licencias en una hoja de 
    //                      Excel (21/09/2022)
    //                      Almacenamiento en un archivo de texto de las cédulas que no 
    //                      fueron grabadas en el proceso (08/11/2022)
    //                      Inclusión de la impresión de la fecha de ejecución del proceso
    //                      (01/03/2023)
    //                      Cálculo del subsidio de transporte para quienes no lo tengan y 
    //                      deban tenerlo
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "importarexcel13")
    {
		set_time_limit(0);
		extract($_POST);
        $periodoidanterior = $_POST["periodoidanterior"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['fecdesde'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i);
                    $_DATOS_EXCEL[$i]['dias'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['conceptoid'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)||(strlen($_DATOS_EXCEL[$i]['fecdesde']) == 0)||(strlen($_DATOS_EXCEL[$i]['dias']) == 0)||(strlen($_DATOS_EXCEL[$i]['conceptoid']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            $calculado = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            // ------------------------------------------------------------------------------------------ //
            // Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            $variab = 'G_NOFECHALIC';
            $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

            $descripcion = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'NOVEDADES'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($descripcion,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];

                $valreg = 0;
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],$tabla,"dni","terid");
                
                if($terid != "")
                {
                    // Valido que el empleado esté activo
                    $esempleadoactivo = $clase->BDLockup($terid,$tabla,'terid','esempleadoactivo');

                    if($esempleadoactivo=="CHECKED")
                    {
                        $lb_valido = false;
                        $lb_valido2 = false;
                        $lb_valida3 = false;
    
                        $fecdesde = $_DATOS_EXCEL[$j]['fecdesde'];
                        $dias = $_DATOS_EXCEL[$j]['dias'];
                        $conceptoid = $_DATOS_EXCEL[$j]['conceptoid'];
                        
                        // Valido la entrada de los datos de la hoja de Excel
                        $lb_valido = $io_fecha->uf_solo_numeros($dias);         // Valido la columna de los días
                        $lb_valido2 = validar_fecha_espanol($fecdesde);         // Valido la columna de la fecha

                        // Valido que el concepto sea una licencia
                        $vsql = "SELECT eslicencia
                                   FROM conceptosnomina 
                                  WHERE conceptoid = ".$conceptoid;
                        $eslicencia = $clase->SeleccionarUno($vsql);
                        
                        if(($lb_valido)&&($lb_valido2)&&($eslicencia == "CHECKED"))
                        {
                            // Valido que la fecha esté dentro del periodo
                            $fechasta = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','fechasta');
                            $fecdesde2 = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','fecdesde');
                            $fecdesde3 = substr($fecdesde,6,4)."-".substr($fecdesde,3,2)."-".substr($fecdesde,0,2);

                            if($nofechalic == "CHECKED")
                                $fecdesde3 =  $fecdesde2;
    
                            $lb_valida3 = verifica_rango($fecdesde2,$fechasta,$fecdesde3);
    
                            if($lb_valida3)
                            {
                                $vsql = "SELECT count(*) AS numreg 
                                           FROM detallenomina 
                                          WHERE terid = ".$terid." 
                                                AND pernominaid = ".$periodoidanterior." 
                                                AND conceptoid IN (1,3,4,5)";
                                $numreg = $clase->SeleccionarUno($vsql);

                                if($numreg==0)
                                {
                                    // Calculo el nuevo ID
                                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                                    $numid = $clase->SeleccionarUno($vsql);
                                    $numid++;
    
                                    // Inserto la nueva licencia
    
                                    // Obtengo la formula de la licencia
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                    $formulalice = $clase->SeleccionarUno($vsql);

                                    $basico = $clase->BDLockup($terid,$tabla,'terid','basico');             // salario básico
    
                                    // Calculo la licencia
                                    if($conceptoid!=10)
                                    {
                                        eval("\$montolicencia = $formulalice;");
                                        $montolicencia = round($montolicencia,0);
                                    }
                                    else
                                    {
                                        // Calculo la incapacidad
    
                                        // Obtengo el salario mínimo legal vigente
                                        $smlv = $_SESSION['N_SALMIN2020'];                                        
    
                                        // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                                        if($basico<=$smlv)
                                        {
                                            $montolicencia = ($smlv*$dias)/30;
                                            $montolicencia = round($montolicencia,0);
                                        }
                                        else
                                        {
                                            $porcbasico = ($basico*66.67)/100;
                                            $porcbasico = round($porcbasico,0);
    
                                            // Calculo la incapacidad si el básico sea mayor al mínimo
                                            if($porcbasico>$smlv)
                                            {
                                                $montolicencia = ($porcbasico*$dias)/30;
                                                $montolicencia = round($montolicencia,0);
                                            }
                                            else
                                            {
                                                if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                                if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;
    
                                                $montolicencia = round($montolicencia,0);
                                            }
                                        }
                                    }

                                    // Obtengo el tipo de licencia
                                    $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                    if($tipodc=="C")
                                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidanterior.",".$montolicencia.",0,".$dias.",".$basico.")";
                                    else
                                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                    VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidanterior.",0,".$montolicencia.",".$dias.",".$basico.")";

                                    $clase->EjecutarSQL($vsql);

                                    if(mysql_affected_rows() >= 1)
                                    {
                                        $grabados++;
                                        $lbgrabo = true;
                                    }
                                }
                                else
                                {
                                    // inicialización de variables
                                    $difendias = 0;                         $basico = 0;                        $diastrab = 0;
                                    $detalleid = 0;                         $numid = 0;                         $formulabasico = "";
                                    $formulalice = "";                      $montolicencia = 0;                 $porcbasico = 0;
                                    $tipodc = "";                           $repetida = 0;                      $valor = 0;
                                    $descuentos = 0;                        $smlv = 0;                          $cargoid = 0;
                                    $aplicatransporte = "";                 $auxtrans = 0;                      $formulatransporte = "";
                                    $subsidiotransporte = 0;                $numreg = 0;                        $totnovedades = 0;
                                    $sueldodeducciones = 0;                 $sueldo = 0;                        $epsid = 0;
                                    $pensionesid = 0;                       $aplicapension = "";                $aplicasalud = "";
                                    $pension = 0;                           $salud = 0;                         $formulapension = "";
                                    $formulasalud = "";                     $idpension = 0;                     $idsalud = 0;
                                    $diaspendiente = 0;
    
                                    // días de la licencia
                                    $fecha1= new DateTime($fecdesde3);
                                    $fecha2= new DateTime($fechasta);
                                    $diff = $fecha1->diff($fecha2);
                                    
                                    $difendias = $diff->days;
                                    $difendias += 1;
    
                                    // ----------------------------------------------------------------------------------------------------------------------------- //                                        
                                    $suma = "+".strval($dias-1)." day";
                                    $date_fin = strtotime(".$suma.", strtotime($fecdesde3));
                                    $date_fin = date('Y-m-d', $date_fin);
    
                                    if($date_fin > $fechasta)
                                    {
                                        // Aquí guardo en la tabla correspondiente el exceso en días 
                                        // para ser calculado en próximos periodos
                    
                                        $diaspendiente = $dias - $difendias;
                    
                                        // --------------------------------------------------------------------------------------------------------- //
                                        $feciniper = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','fecdesde');
                                        $diadesde = substr($feciniper, -2);
                    
                                        if($diadesde=="16")
                                        {
                                            $fecfinper = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','fechasta');
                                            $fechaEntera = strtotime($fecfinper);
                                            $valdias = date("d", $fechaEntera);
                    
                                            if($valdias=="28")              $diaspendiente -= 2;
                                            if($valdias=="29")              $diaspendiente -= 1;
                                            if($valdias=="31")              $diaspendiente += 1;
                                        }
                                        // --------------------------------------------------------------------------------------------------------- //                
                                        $dias -= $diaspendiente;
                    
                                        $procesado = "";
                                        $vsql = "SELECT periodoid 
                                                   FROM periodosnomina 
                                                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE periodoid > $periodoidanterior)";
                                        $periodoapagar = $clase->SeleccionarUno($vsql);
                    
                                        $vsql = "INSERT INTO licenciaspendiente (terid,conceptoid,dias,periodoapagar,procesado) 
                                                                         VALUES (".$terid.",".$conceptoid.",".$diaspendiente.",".$periodoapagar.",'".$procesado."')";
                                        $clase->EjecutarSQL($vsql);
                                    }                                
                                    // ----------------------------------------------------------------------------------------------------------------------------- //
    
                                    // Obtengo el salario básico del empleado
                                    $basico = $clase->BDLockup($terid,$tabla,'terid','basico');
                        
                                    // Obtengo la formula del sueldo
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                                    $formulabasico = $clase->SeleccionarUno($vsql);
                        
                                    // Obtengo los días trabajados en el periodo
                                    $vsql = "SELECT valor
                                               FROM detallenomina 
                                              WHERE conceptoid = 1  
                                                    AND pernominaid = ".$periodoidanterior."
                                                    AND terid = ".$terid."";
                                    $diastrab = $clase->SeleccionarUno($vsql);
                        
                                    // Obtengo el ID del registro que se modificará
                                    $vsql = "SELECT detalleid
                                               FROM detallenomina 
                                              WHERE conceptoid = 1  
                                                    AND pernominaid = ".$periodoidanterior."
                                                    AND terid = ".$terid."";
                                    $detalleid = $clase->SeleccionarUno($vsql);
    
                                    $diastrab -= $dias;
    
                                    eval("\$sueldo = $formulabasico;");
                                    $sueldo = round($sueldo,0);
                        
                                    // Almaceno en nuevo sueldo
                                    $vsql = "UPDATE detallenomina SET 
                                                    devengados = ".$sueldo.", 
                                                    valor = ".$diastrab."
                                              WHERE detalleid = ".$detalleid."";
                                    $clase->EjecutarSQL($vsql);
    
                                    // Calculo el nuevo ID
                                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                                    $numid = $clase->SeleccionarUno($vsql);
                                    $numid++;
    
                                    // Inserto la nueva licencia
    
                                    // Obtengo la formula de la licencia
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                                    $formulalice = $clase->SeleccionarUno($vsql);
    
                                    // Calculo la licencia
                                    if($conceptoid!=10)
                                    {
                                        eval("\$montolicencia = $formulalice;");
                                        $montolicencia = round($montolicencia,0);
                                    }
                                    else
                                    {
                                        // Calculo la incapacidad
    
                                        // Obtengo el salario mínimo legal vigente
                                        $smlv = $_SESSION['N_SALMIN2020'];
    
                                        // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                                        if($basico<=$smlv)
                                        {
                                            $montolicencia = ($smlv*$dias)/30;
                                            $montolicencia = round($montolicencia,0);
                                        }
                                        else
                                        {
                                            $porcbasico = ($basico*66.67)/100;
                                            $porcbasico = round($porcbasico,0);
    
                                            // Calculo la incapacidad si el básico sea mayor al mínimo
                                            if($porcbasico>$smlv)
                                            {
                                                $montolicencia = ($porcbasico*$dias)/30;
                                                $montolicencia = round($montolicencia,0);
                                            }
                                            else
                                            {
                                                if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                                if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;
    
                                                $montolicencia = round($montolicencia,0);
                                            }
                                        }
                                    }
    
                                    // Obtengo el tipo de licencia
                                    $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                                    // ------------------------------------------------------------------------------------------------------------------- //
                                    // Determino si el registro existe para modificarlo o incluirlo
                                    $vsql = "SELECT COUNT(*) AS repetida 
                                               FROM detallenomina
                                              WHERE pernominaid = ".$periodoidanterior."
                                                    AND conceptoid = ".$conceptoid."
                                                    AND terid = ".$terid."";
                                    $repetida = $clase->SeleccionarUno($vsql);
    
                                    if($repetida==0)
                                    {
                                        if($tipodc=="C")
                                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidanterior.",".$montolicencia.",0,".$dias.",".$basico.")";
                                        else
                                            $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                        VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidanterior.",0,".$montolicencia.",".$dias.",".$basico.")";
                                    }
                                    else
                                    {
                                        // Determino el id del registro
                                        $vsql = "SELECT detalleid AS detalleid 
                                                   FROM detallenomina
                                                  WHERE pernominaid = ".$periodoidanterior."
                                                        AND conceptoid = ".$conceptoid."
                                                        AND terid = ".$terid."";
                                        $detalleid = $clase->SeleccionarUno($vsql);
                
                                        $valor = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
                                        $valor += $dias;
                
                                        // Actualizo la licencia
                                        if($tipodc=="C")
                                        {
                                            $devengados = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');
                                            $devengados += $montolicencia;
                                            
                                            $vsql = "UPDATE detallenomina SET 
                                                            devengados = ".$devengados.", 
                                                            valor = ".$valor."
                                                      WHERE detalleid = ".$detalleid."";
                                        }
                                        else
                                        {
                                            $descuentos = $clase->BDLockup($detalleid,'detallenomina','detalleid','descuentos');
                                            $descuentos += $montolicencia;
                
                                            $vsql = "UPDATE detallenomina SET 
                                                            descuentos = ".$descuentos.", 
                                                            valor = ".$valor."
                                                      WHERE detalleid = ".$detalleid."";
                                        }
                                    }
                                    $clase->EjecutarSQL($vsql);
    
                                    if(mysql_affected_rows() < 1)
                                        $lbpaso = false;
                                    else
                                    {
                                        $lbpaso = true;
                                        $grabados++;
                                        $lbgrabo = true;
                                    }
    
                                    if($lbpaso)
                                    {
                                        $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');                           // Obtengo el cargo del empleado

                                        if($diastrab > 0)
                                        {
                                            // ---------------------------------------------------------------------------------------------------------- //
                                            // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos            
                                            $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte
                                
                                            // Variable para la validación del auxilio de transporte
                                            $valsubtrasp = $smlv * 2;
                                
                                            if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                                            {
                                                // Obtengo el ID del registro que se modificará
                                                $vsql = "SELECT detalleid
                                                           FROM detallenomina 
                                                          WHERE conceptoid = 3  
                                                                AND pernominaid = ".$periodoidanterior."
                                                                AND terid = ".$terid."";
                                                $detalleid = $clase->SeleccionarUno($vsql);
                                
                                                // Obtengo la formula del subsidio de transporte
                                                $auxtrans = $_SESSION['N_AUXTRANS2020'];
                                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                                                $formulatransporte = $clase->SeleccionarUno($vsql);
                                
                                                eval("\$subsidiotransporte = $formulatransporte;");
                                                $subsidiotransporte = round($subsidiotransporte,0);
                                            }
                                            else
                                                $subsidiotransporte = 0;
            
                                            // ID transporte
                                            $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 3";
                                            $idtransporte = $clase->SeleccionarUno($vsql);
                                    
                                            // Grabo el subsidio de transporte
                                            if($idtransporte!="")        
                                                $vsql = "UPDATE detallenomina SET 
                                                                devengados = ".$subsidiotransporte.",
                                                                valor = ".$diastrab."
                                                          WHERE detalleid = ".$idtransporte."";
                                            else
                                            {
                                                // Obtengo el valor del subsidio de transporte
                                                $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
                                    
                                                $vsql = "SELECT max(detalleid) FROM detallenomina";
                                                $numreg = $clase->SeleccionarUno($vsql);
                                    
                                                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoidanterior.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                                            }                            
                                            $clase->EjecutarSQL($vsql);
                                        }
                                        else
                                        {
                                            $subsidiotransporte = 0;

                                            // ID transporte
                                            $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 3";
                                            $idtransporte = $clase->SeleccionarUno($vsql);

                                            // Grabo el subsidio de transporte
                                            if($idtransporte!="")        
                                            {
                                                $vsql = "UPDATE detallenomina SET 
                                                                devengados = ".$subsidiotransporte.",
                                                                valor = ".$diastrab."
                                                          WHERE detalleid = ".$idtransporte;
                                                $clase->EjecutarSQL($vsql);
                                            }

                                            // elimino el subsidio de transporte
                                            $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 3";
                                            $clase->EjecutarSQL($vsql);

                                            $sueldo = 0;
                                        }
        
                                        // ----------------------------------------------------------------------------------------------------------- //
                                        // Ahora recalculo la pensión y la salud
        
                                        // ----------------------------------------------------------------------------------------------------------- //
                                        // Obtengo el total devengado por novedades
                                        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                                   FROM detallenomina d
                                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                                  WHERE d.terid = ".$terid."
                                                        AND d.pernominaid = ".$periodoidanterior." 
                                                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                                        $totnovedades = $clase->SeleccionarUno($vsql);

                                        // Actualizo el sueldo
                                        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                                   FROM detallenomina d
                                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                                  WHERE d.terid = ".$terid."
                                                        AND d.pernominaid = ".$periodoidanterior." 
                                                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                                        $totrecargos = $clase->SeleccionarUno($vsql);
                                
                                        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                                        if($sueldodeducciones == 0)
                                        {
                                            $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid IN (4,5)";
                                            $clase->EjecutarSQL($vsql);
                                        }
                                        else
                                        {            
                                            $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                                            $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
                                            $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
                                            
                                            if($epsid==NULL)                $epsid=0;
                                            if($pensionesid==NULL)          $pensionesid=0;
            
                                            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                                            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
            
                                            if($extralegal=="CHECKED")
                                            {
                                                $pension = 0;
                                                $salud = 0;
                                            }
                                            else
                                            {
                                                // Recalculo pensión y salud
                                                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                                    $pension = 0;
                                                else
                                                {
                                                    // Obtengo la formula para el descuento por pensión
                                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                                    $formulapension = $clase->SeleccionarUno($vsql);
                                
                                                    // Calculo la pensión
                                                    eval("\$pension = $formulapension;");
                                                    $pension = round($pension,0);
                                                }
                                
                                                if(($epsid==37)||($aplicasalud!="CHECKED"))
                                                    $salud = 0;
                                                else
                                                {
                                                    // Obtengo la formula para el descuento de salud
                                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                                    $formulasalud = $clase->SeleccionarUno($vsql);
                                                    
                                                    // Calculo la salud
                                                    eval("\$salud = $formulasalud;");
                                                    $salud = round($salud,0);
                                                }
                                            }
            
                                            //  ID pensión
                                            $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 4";
                                            $idpension = $clase->SeleccionarUno($vsql);
                                
                                            // Grabo la pensión
                                            if($idpension!="")
                                                $vsql = "UPDATE detallenomina SET 
                                                                descuentos = ".$pension.",
                                                                saldo = ".$sueldodeducciones."
                                                          WHERE detalleid = ".$idpension."";
                                            else
                                            {
                                                $vsql = "SELECT max(detalleid) FROM detallenomina";
                                                $numreg = $clase->SeleccionarUno($vsql);
                                
                                                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoidanterior.",0,".$pension.",0,$sueldodeducciones)";
                                            }
                                            $clase->EjecutarSQL($vsql);
            
                                            // ID salud
                                            $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 5";
                                            $idsalud = $clase->SeleccionarUno($vsql);
                                
                                            // Grabo la salud
                                            if($idsalud!="")
                                                $vsql = "UPDATE detallenomina SET 
                                                                descuentos = ".$salud.",
                                                                saldo = ".$sueldodeducciones."
                                                          WHERE detalleid = ".$idsalud."";
                                            else
                                            {
                                                $vsql = "SELECT max(detalleid) FROM detallenomina";
                                                $numreg = $clase->SeleccionarUno($vsql);
                                
                                                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoidanterior.",0,".$salud.",0,$sueldodeducciones)";
                                            }
                                            $clase->EjecutarSQL($vsql);
                                        }
        
                                        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                                        $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoidanterior." AND terid = ".$terid."";
                                        $clase->EjecutarSQL($vsql);
                                    }
                                }
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errores.txt";                                                   // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                    // Grabas
            fclose($fd);                                                                // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las licencias para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados licencias para el periodo $descripcion");
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarprimamanual
    // Creación: 18/01/2022		última modificación: 02/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para editar las primas que se procesarán manualmente en caso de 
    //              fallar el importar Excel
    // Última modificación: Validación del combo de periodos excluyendo los periodos 
    //                      transmitidos a la dian
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarprimamanual")
    {
        $params = ' class="Texto11" ';

        // consulta para el combo de periodos
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo 
                                FROM periodos 
                               WHERE mesperiodo IN (6,12) 
                                     AND anoperiodo >= 2021 
                                     AND orden > 91 
                                     AND codperiodo NOT IN (SELECT periodonomina FROM periododian)
                            ORDER BY orden";

        // consulta para el combo de empleados
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";

        $monto = 1;

        // Pintamos la ventana
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n de primas </b> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardarprimasmanual" name="y" method="POST">
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">&nbsp;&nbsp;Empleado:</label>
                   '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,400).'
                  </td> 
                 </tr> 
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">&nbsp;&nbsp;Periodo:</label>
                   '.$clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400).'
                  </td> 
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">&nbsp;&nbsp;D&iacute;as:</label>
                   <input type="number" name="cantidad" min="1" class="Texto12" size="2" autocomplete="off" title="días" value="'.$cantidad.'"> 
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">&nbsp;&nbsp;Pago:</label>
                   <input type="number" name="pagoprimas" min="1" class="Texto12" size="2" autocomplete="off" title="pago" value="'.$pagoprimas.'"> 
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="importacionexcelnom.php?opcion=ventanaimportacion"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                  </td>
                 </tr>
                </table>';

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarprimasmanual
    // Creación: 18/01/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los datos de las primas que se procesaron 
    //              manualmente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarprimasmanual")
    {
        $terid = $_POST['terid'];
        $cantidad = $_POST['cantidad'];
        $pagoprimas = $_POST['pagoprimas'];
        $codperiodo = $_POST['codperiodo'];

        // Guardo en la tabla
        $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimas.",".$cantidad.",0,0)";
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Datos almacenados satisfactoriamente");
        else
            $clase->Aviso(3,"No se almacenaron los datos");

        $vsql = "INSERT INTO primasterceros (tipo, periodonomina, terid, esempleado, esempleadoactivo, extralegal,
                             areaid, seccionid, cargoid, bancoid, numcuenta, fecingreso,
                             basico, codvende, dni, nombre, epsid, pensionesid)
                      SELECT 'primas', '".$codperiodo."', t.terid, t.esempleado, t.esempleadoactivo, t.extralegal, t.areaid, t.seccionid,
                             t.cargoid, t.bancoid, t.numcuenta, t.fecingreso, t.basico, t.codvende, t.dni, 
                             CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombre,
                             t.epsid, t.pensionesid
                        FROM liquidacion d
                             INNER JOIN terceros t ON (d.terid = t.terid)
                       WHERE d.periodonomina = '".$codperiodo."'
                             AND t.basico > 0 
                             AND t.terid = ".$terid."
                    GROUP BY t.terid, t.esempleado, t.esempleadoactivo, t.extralegal, t.areaid, t.seccionid,
                             t.cargoid, t.bancoid, t.numcuenta, t.fecingreso, t.basico, t.codvende, t.dni, 
                             nombre, t.epsid, t.pensionesid";
        $clase->EjecutarSQL($vsql);

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cesantiasmanual
    // Creación: 19/01/2022		última modificación: 02/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que capta los datos de las cesantías que se procesarán 
    //              manualmente
    // Última modificación: Inclusión del campo cantidad para los días de cesantías
    //                      (21/01/2022)
    //                      Se desactivó el pago para garantizar que el registro incluido 
    //                      sea intereses de cesantías (06/02/2023)
    //                      Validación del combo de periodos excluyendo los periodos 
    //                      transmitidos a la dian
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "cesantiasmanual")
    {
        // Combos
        $params = ' class="Texto11" ';

        // consulta para el combo de periodos
        $vsqlcomboperiodo = "SELECT codperiodo, desperiodo 
                               FROM periodos 
                              WHERE mesperiodo = 1 
                                    AND anoperiodo >= 2022
                                    AND codperiodo NOT IN (SELECT periodonomina FROM periododian)
                           ORDER BY orden";

        // consulta para el combo de empleados                   
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";

        // Inicialización de variables
        $pagocesantias = 0;
        $porcentaje = 0;
        $pagointereses = 0;
        $cantidad = 0;

        // Pintamos la ventana        
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n de cesant&iacute;as </b> </td>
                 </tr> 
                </table>                
                <form action="?opcion=almcesantiasmanual" name="y" method="POST">
                <input type="hidden" name="pagocesantias" value="'.$pagocesantias.'">
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto13">&nbsp;&nbsp;Empleado:</label>'.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,400).' </td>                  
                 </tr>                 
                 <tr class="CabezoteTabla">
                  <td align="left">
                   <label class="Texto13">&nbsp;&nbsp;Periodo:</label>'.$clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400).' 
                  </td>                  
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto13">&nbsp;&nbsp;Pago:</label>
                   <input type="number" name="pagocesantias" min="0" class="Texto12" size="2" autocomplete="off" title="Pago de cesantías" value="'.$pagocesantias.'" disabled>
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto13">&nbsp;&nbsp;D&iacute;as:</label>
                   <input type="number" name="cantidad" min="0" class="Texto12" size="2" autocomplete="off" title="días" value="'.$cantidad.'">
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">&nbsp;&nbsp;Porcentaje:</label>
                   <input type="number" name="porcentaje" min="0" class="Texto12" size="2" autocomplete="off" title="porcentaje" value="'.$porcentaje.'">  %
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td align="left"><label class="Texto12">&nbsp;&nbsp;Intereses:</label>
                   <input type="number" name="pagointereses" min="0" class="Texto12" size="2" autocomplete="off" title="pago de intereses" value="'.$pagointereses.'">                
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="importacionexcelnom.php?opcion=ventanaimportacion"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: almcesantiasmanual
    // Creación: 19/01/2022		última modificación: 21/01/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda las cesantías que se procesaran manualmente por no ser 
    //              importadas desde Excel
    // Última modificación: Inclusión de la tabla primasterceros para la impresión de recibo 
    //                      de pago
    ////////////////////////////////////////////////////////////////////////////////////////            
    if($opcion == "almcesantiasmanual")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $pagocesantias = $_POST['pagocesantias'];
        $porcentaje = $_POST['porcentaje'];
        $pagointereses = $_POST['pagointereses'];
        $cantidad = $_POST['cantidad'];

        // Guardo en la tabla
        $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                  VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcentaje.",".$pagointereses.")";
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
        {
            $vsql = "INSERT INTO primasterceros (tipo, periodonomina, terid, esempleado, esempleadoactivo, extralegal,
                                                 areaid, seccionid, cargoid, bancoid, numcuenta, fecingreso,
                                                 basico, codvende, dni, nombre, epsid, pensionesid)                             
                          SELECT 'cesantias', '".$codperiodo."', terid, esempleado, esempleadoactivo, extralegal, areaid, seccionid,
                                 cargoid, bancoid, numcuenta, fecingreso, basico, codvende, dni, 
                                 CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombre,
                                 epsid, pensionesid
                            FROM terceros
                           WHERE terid = ".$terid."";
            $clase->EjecutarSQL($vsql);

            $clase->Aviso(1,"Datos almacenados satisfactoriamente");
        }
        else
            $clase->Aviso(3,"No se almacenaron los datos");

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editardotacion
    // Creación: 04/03/2022		última modificación: 02/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para editar las dotaciones que se procesarán manualmente en caso  
    //              de fallar el importar desde Excel
    // Última modificación: Validación del combo de periodos excluyendo los periodos 
    //                      transmitidos a la dian
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editardotacion")
    {
        $params = ' class="Texto11" ';

        // consulta para el combo de periodos
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo 
                                FROM periodos 
                               WHERE anoperiodo >= 2022 
                                     AND mesperiodo >=2 
                                     AND codperiodo NOT IN (SELECT periodonomina FROM periododian)
                            ORDER BY orden";

        // consulta para el combo de empleados
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";
        $monto = 1;

        // Pintamos la ventana        
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n de dotaciones </b> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardardotaciones" name="y" method="POST">
                <table width="500">                 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Empleado:</label>
                   '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,400).'
                  </td>                  
                 </tr>                 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Periodo:</label>
                   '.$clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400).'
                  </td>                  
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Monto:</label>
                   <input type="number" name="monto" min="1" class="Texto12" size="2" autocomplete="off" title="monto de la dotaci&oacute;n" value="'.$monto.'">                  
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="importacionexcelnom.php?opcion=ventanaimportacion"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardardotaciones
    // Creación: 04/03/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los datos de las dotaciones que se procesaron 
    //              manualmente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardardotaciones")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $monto = $_POST['monto'];

        $numregistro = 0;

        if((strlen($terid)==0) || (strlen($codperiodo)==0) || (strlen($monto)==0))
            $clase->Aviso(3,"Debe ingresar todos los datos");
        else
        {
            $vsql2 = "SELECT COUNT(*) AS numregistro
                        FROM dotaciones
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."'";
            $numregistro = $clase->SeleccionarUno($vsql2);

            if($numregistro>0)
            {
                $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid=".$terid."";
                $nombreemp = $clase->SeleccionarUno($vsql);

                $vsql = "SELECT monto FROM dotaciones WHERE terid=".$terid." AND periodonomina = '".$codperiodo."'";
                $monto = $clase->SeleccionarUno($vsql);
                
                $clase->Aviso(3,"$nombreemp ya tiene una dotación en el periodo $codperiodo por un monto de $monto pesos");
            }
            else
            {
                // Guardo en la tabla
                $vsql = "INSERT INTO dotaciones (periodonomina, terid, monto) 
                                         VALUES ('".$codperiodo."',".$terid.",".$monto.")";
                $clase->EjecutarSQL($vsql);
        
                // Emito el mensaje correspondiente
                if(mysql_affected_rows() >= 1)
                    $clase->Aviso(1,"Datos almacenados satisfactoriamente");
                else
                    $clase->Aviso(3,"No se almacenaron los datos");
            }
        }

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarpagocesantia
    // Creación: 07/03/2022		última modificación: 02/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para editar los pagos de cesantias que se procesarán manualmente 
    //              en caso de fallar el importar desde Excel
    // Última modificación: Validación del combo de periodos excluyendo los periodos 
    //                      transmitidos a la dian
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarpagocesantia")
    {
        $params = ' class="Texto11" ';

        // consulta para el combo de periodos
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo 
                                FROM periodos 
                               WHERE anoperiodo >= 2022 
                                     AND mesperiodo >=2 
                                     AND codperiodo NOT IN (SELECT periodonomina FROM periododian)
                            ORDER BY orden";

        // consulta para el combo de empleados
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                       ORDER BY primernombre";

        $monto = 1;
        $dias = 1;

        // Pintamos la ventana        
        $cont.='<table width="500">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Edici&oacute;n de pagos de cesant&iacute;as </b> </td>
                 </tr> 
                </table>                
                <form action="?opcion=guardarpagoscesan" name="y" method="POST">
                <table width="500">                 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Empleado:</label>
                   '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,400).'
                  </td>                  
                 </tr>                 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Periodo:</label>
                   '.$clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400).'
                  </td>                  
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">D&iacute;as:</label>
                   <input type="number" name="dias" min="1" class="Texto12" size="2" autocomplete="off" title="d&iacute;as de  cesant&iacute;as" value="'.$dias.'"> 
                  </td>
                 </tr>
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left"><label class="Texto12">Monto:</label>
                   <input type="number" name="monto" min="1" class="Texto12" size="2" autocomplete="off" title="monto de la dotaci&oacute;n" value="'.$monto.'">                  
                  </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarpagoscesan
    // Creación: 07/03/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los datos de los pagos de cesantias que se  
    //              procesaron manualmente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarpagoscesan")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $dias = $_POST['dias'];
        $monto = $_POST['monto'];

        $numregistro = 0;

        // Valido que los datos estén llenos
        if((strlen($terid)==0) || (strlen($codperiodo)==0) || (strlen($monto)==0) || (strlen($dias)==0))
            $clase->Aviso(3,"Debe ingresar todos los datos");
        else
        {
            // Valido que el pago a un empleado no esté duplicado
            $vsql2 = "SELECT COUNT(*) AS numregistro
                        FROM pagocesantias
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."'";
            $numregistro = $clase->SeleccionarUno($vsql2);

            if($numregistro>0)
            {
                $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid=".$terid."";
                $nombreemp = $clase->SeleccionarUno($vsql);

                $vsql = "SELECT monto FROM pagocesantias WHERE terid=".$terid." AND periodonomina = '".$codperiodo."'";
                $monto = $clase->SeleccionarUno($vsql);
                
                $clase->Aviso(3,"$nombreemp ya tiene una dotación en el periodo $codperiodo por un monto de $monto pesos");
            }
            else
            {
                // Guardo en la tabla
                $vsql = "INSERT INTO pagocesantias (periodonomina, terid, dias, monto) 
                                         VALUES ('".$codperiodo."',".$terid.",".$dias.",".$monto.")";
                $clase->EjecutarSQL($vsql);
        
                // Emito el mensaje correspondiente
                if(mysql_affected_rows() >= 1)
                    $clase->Aviso(1,"Datos almacenados satisfactoriamente");
                else
                    $clase->Aviso(3,"No se almacenaron los datos");
            }
        }

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel14
    // Creación: 18/10/2022		última modificación: 01/03/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que almacena las libranzas y los descuentos permanentes 
    //              importados desde una hoja de Excel
    // Última modificación: Almacenamiento en un archivo de texto de las cédulas que no 
    //                      fueron grabadas en el proceso (04/11/2022)
    //                      Inclusión de la impresión de la fecha de ejecución del proceso
    ////////////////////////////////////////////////////////////////////////////////////////    
	if($opcion == "importarexcel14")
	{
		set_time_limit(0);
		extract($_POST);
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['conceptoid'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)||(strlen($_DATOS_EXCEL[$i]['monto']) == 0)||(strlen($_DATOS_EXCEL[$i]['conceptoid']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
      
            // ------------------------------------------------------------------------------------------ //
            // Obtengo el periodo actual
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);

            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";            

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            // Nombre del periodo            
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            // carpeta
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados            
            $nocedulas = 'LIBRANZAS Y DESCUENTOS PERMANENTES'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($descripcion,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];                
                $valreg = 0;
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],$tabla,"dni","terid");

                if($terid != "")
                {                    
                    // Valido que el empleado esté activo
                    $esempleadoactivo = $clase->BDLockup($terid,$tabla,'terid','esempleadoactivo');                    

                    if($esempleadoactivo=="CHECKED")
                    {
                        $monto = $_DATOS_EXCEL[$j]['monto'];

                        // // Le quito los decimales que pueda tener la variable monto                        
                        // $monto = round($monto,0);
    
                        // llamado al procedimiento para validar el monto
                        $lb_valido = false;
                        $lb_valido = $io_fecha->uf_solo_numeros($monto);
                        if($lb_valido)
                        {
                            $conceptoid = $_DATOS_EXCEL[$j]['conceptoid'];

                            // Validación del concepto libranza o descuento permanente
                            $lb_valido2 = false;
                            $lb_valido2 = valida_concepto($conceptoid);

                            if($lb_valido2)
                            {
                                // Valido que el concepto asignado a un empleado no esté repetido
                                $vsql3 = "SELECT count(*) AS valreg
                                            FROM detallenomina
                                           WHERE pernominaid = ".$periodoid."
                                                 AND terid = ".$terid."
                                                 AND conceptoid = ".$conceptoid;
                                $valreg = $clase->SeleccionarUno($vsql3);
        
                                if($valreg==0)
                                {
                                    // Obtengo el número de registros de la tabla detallenomina
                                    $vsql = "SELECT MAX(detalleid) FROM detallenomina";
                                    $numeroid = $clase->SeleccionarUno($vsql);
                            
                                    // Incremento el ID
                                    $numeroid++;
            
                                    // Determino el tipo de concepto
                                    $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
            
                                    // Construyo la instrucción
                                    if($tipodc=="C")
                                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                      VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
                                    else
                                        $vsql = "INSERT INTO detallenomina (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                      VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
            
                                    // Almaceno en la tabla
                                    $clase->EjecutarSQL($vsql);
                    
                                    // Incremento el contados de registros almacenados
                                    if(mysql_affected_rows() >= 1)
                                    {
                                        $grabados++;
                                        $lbgrabo = true;
                                    }
                                }
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }                
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errores.txt";                                                   // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                    // Grabas
            fclose($fd);                                                                // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);

            // $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los registros para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados registros para el periodo $descripcion");            
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel15
    // Creación: 21/10/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para seleccionar la hoja de Excel con las cédulas de las 
    //              incapacidades que se corregirán
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel15")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b> </td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" /> 
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el periodo actual
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);
    
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Corregir incapacidades <br> masivamente en el periodo <br> <font color="blue">'.strtolower($descripcion).'</font></b> <br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importarexcel16" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="file" name="excel" /><br><br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocedulas.png" width="240" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel16
    // Creación: 21/10/2022		última modificación: 01/03/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción donde se modifican las incapacidades    
    // Última modificación: Almacenamiento en un archivo de texto de las cédulas que no 
    //                      fueron grabadas en el proceso (09/11/2022)
    //                      Inclusión de la impresión de la fecha de ejecución del proceso
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel16")
    {
		set_time_limit(0);
		extract($_POST);
        $periodoid = $_POST["periodoid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            // Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;

            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];

            // Obtengo la formula del subsidio de transporte
            $auxtrans = $_SESSION['N_AUXTRANS2020'];

            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            $grabados = 0;

            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'INCAPACIDADES'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($descripcion,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);            

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];

                $numced = 0;
                $cedula = $_DATOS_EXCEL[$j]['dni'];

                // Valido que la cédula exista
                $vsql = "SELECT COUNT(*) AS numced FROM ".$tabla." WHERE dni = '".$cedula."'";
                $numced = $clase->SeleccionarUno($vsql);

                if($numced > 0)
                {
                    // Obtengo el terid asociado a la cédula
                    $terid = $clase->BDLockup($cedula,$tabla,"dni","terid");

                    if($terid != "")
                    {
                        // Determino si el empleado tiene incapacidades en el periodo
                        $vsql = "SELECT detalleid
                                   FROM detallenomina 
                                  WHERE conceptoid = 10  
                                        AND pernominaid = ".$periodoid."
                                        AND terid = ".$terid;
                        $detalleid = $clase->SeleccionarUno($vsql);
     
                        if(strlen($detalleid) > 0)
                        {
                            // Obtengo los días de incapacidad
                            $vsql2 = "SELECT valor AS dias
                                        FROM detallenomina 
                                       WHERE detalleid = ".$detalleid;
                            $dias = $clase->SeleccionarUno($vsql2);

                            $vsql3 = "SELECT valor AS montoant
                                        FROM detallenomina 
                                       WHERE detalleid = ".$detalleid;
                            $montoant = $clase->SeleccionarUno($vsql3);

                            $montoant = round($montoant,0);
                    
                            // Obtengo el salario básico del empleado
                            $basico = $clase->BDLockup($terid,$tabla,'terid','basico');
                    
                            if($basico>=$smlv)
                            {
                                $montolicencia = ($basico*$dias)/30;
                                $montolicencia = round($montolicencia,0);

                                if($montolicencia!=$montoant)
                                {
                                    // Almaceno la modificación
                                    $vsql = "UPDATE detallenomina SET 
                                                    devengados = ".$montolicencia."
                                              WHERE detalleid = ".$detalleid;
                                    $clase->EjecutarSQL($vsql);
        
                                    if(mysql_affected_rows() > 0)
                                    {
                                        // Incremento el contador de procesados
                                        $grabados++;

                                        // Variable para el control de los no grabados
                                        $lbgrabo = true;
        
                                        // Recalculo el sueldo del empleado
        
                                        // Obtengo los días trabajados en el periodo
                                        $vsql = "SELECT valor
                                                   FROM detallenomina 
                                                  WHERE conceptoid = 1  
                                                        AND pernominaid = ".$periodoid."
                                                        AND terid = ".$terid."";
                                        $diastrab = $clase->SeleccionarUno($vsql);
        
                                        // Obtengo el ID del registro que se modificará
                                        $vsql = "SELECT detalleid
                                                   FROM detallenomina 
                                                  WHERE conceptoid = 1  
                                                        AND pernominaid = ".$periodoid."
                                                        AND terid = ".$terid."";
                                        $detalleidsueldo = $clase->SeleccionarUno($vsql);
        
                                        // Obtengo la formula del sueldo
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                                        $formulabasico = $clase->SeleccionarUno($vsql);
                                
                                        // Calculo el sueldo básico
                                        eval("\$sueldo = $formulabasico;");
                                        $sueldo = round($sueldo,0);
        
                                        // Almaceno en nuevo sueldo
                                        $vsql = "UPDATE detallenomina SET 
                                                        devengados = ".$sueldo.", 
                                                        valor = ".$diastrab."
                                                  WHERE detalleid = ".$detalleidsueldo;
                                        $clase->EjecutarSQL($vsql);
                                        
                                        // Recalculo el subsidio de transporte
        
                                        $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');                                   // Obtengo el cargo del empleado
                                        $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');           // Obtengo el control del cálculo de subsidio de transporte
        
                                        // Variable para la validación del auxilio de transporte
                                        $valsubtrasp = $smlv * 2;
        
                                        if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                                        {
                                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                                            $formulatransporte = $clase->SeleccionarUno($vsql);
        
                                            eval("\$subsidiotransporte = $formulatransporte;");
                                            $subsidiotransporte = round($subsidiotransporte,0);
                                        }
                                        else
                                            $subsidiotransporte = 0;
        
                                        // ID transporte
                                        $vsql = "SELECT detalleid AS idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                                        $idtransporte = $clase->SeleccionarUno($vsql);
                                
                                        // Grabo el subsidio de transporte
                                        if($idtransporte!="")
                                            $vsql = "UPDATE detallenomina SET 
                                                            devengados = ".$subsidiotransporte.",
                                                            valor = ".$diastrab."
                                                      WHERE detalleid = ".$idtransporte."";
                                        else
                                        {
                                            $vsql = "SELECT max(detalleid) FROM detallenomina";
                                            $numreg = $clase->SeleccionarUno($vsql);
                                
                                            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$auxtrans)";
                                        }
                                        $clase->EjecutarSQL($vsql);
        
                                        // Procedo a recalcular pensión y salud
                                
                                        // Determino si el empleado es de condición extralegal
                                        $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                                        $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
                                        $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
                                        $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');                       // Obtengo el cargo del empleado
                                        
                                        if($epsid==NULL)                $epsid=0;
                                        if($pensionesid==NULL)          $pensionesid=0;
                                
                                        // Consulta para el total de devengados
                                        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                                   FROM detallenomina d
                                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                                  WHERE d.terid = ".$terid."
                                                        AND d.pernominaid = ".$periodoid." 
                                                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                                        $totnovedades = $clase->SeleccionarUno($vsql);

                                        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                                   FROM detallenomina d
                                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                                  WHERE d.terid = ".$terid."
                                                        AND d.pernominaid = ".$periodoid." 
                                                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                                        $totrecargos = $clase->SeleccionarUno($vsql);
                                
                                        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;                                       
                                
                                        $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');             // Obtengo el control del cálculo de pensión
                                        $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');                 // Obtengo el control del cálculo de salud
                                        
                                        if($extralegal=="CHECKED")
                                        {
                                            $pension = 0;
                                            $salud = 0;
                                        }
                                        else
                                        {
                                            // Recalculo pensión y salud
                                            if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                                $pension = 0;
                                            else
                                            {
                                                // Obtengo la formula para el descuento por pensión
                                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                                $formulapension = $clase->SeleccionarUno($vsql);
                                
                                                // Calculo la pensión
                                                eval("\$pension = $formulapension;");
                                                $pension = round($pension,0);
                                            }
                                
                                            if(($epsid==37)||($aplicasalud!="CHECKED"))
                                                $salud = 0;
                                            else
                                            {
                                                // Obtengo la formula para el descuento de salud
                                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                                $formulasalud = $clase->SeleccionarUno($vsql);
                                                
                                                // Calculo la salud
                                                eval("\$salud = $formulasalud;");
                                                $salud = round($salud,0);
                                            }
                                        }
                                        // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
                                        //  ID pensión
                                        $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                                        $idpension = $clase->SeleccionarUno($vsql);
                                
                                        // Grabo la pensión
                                        if($idpension!="")
                                            $vsql = "UPDATE detallenomina SET 
                                                            descuentos = ".$pension.",
                                                            saldo = ".$sueldodeducciones."
                                                      WHERE detalleid = ".$idpension."";
                                        else
                                        {
                                            $vsql = "SELECT max(detalleid) FROM detallenomina";
                                            $numreg = $clase->SeleccionarUno($vsql);
                                
                                            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                                        }
                                        $clase->EjecutarSQL($vsql);
                                
                                        // ID salud
                                        $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                                        $idsalud = $clase->SeleccionarUno($vsql);
                                
                                        // Grabo la salud
                                        if($idsalud!="")
                                            $vsql = "UPDATE detallenomina SET 
                                                            descuentos = ".$salud.",
                                                            saldo = ".$sueldodeducciones."
                                                      WHERE detalleid = ".$idsalud."";
                                        else
                                        {
                                            $vsql = "SELECT max(detalleid) FROM detallenomina";
                                            $numreg = $clase->SeleccionarUno($vsql);
                                
                                            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                                        }
                                        $clase->EjecutarSQL($vsql);
                                
                                        // Aquí depuro los conceptos que estén en cero
                                        $vsql = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoid." AND terid =".$terid."";
                                        $clase->EjecutarSQL($vsql);
                                    }
                                }
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errores.txt";                                                   // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                    // Grabas
            fclose($fd);                                                                // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se corrigieron las licencias para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se corrigieron $grabados licencias para el periodo $descripcion");
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: selperiodo
    // Creación: 06/12/2022		última modificación: 
    // Creador: Luis Flórez		modificado 
    // Descripción: Opción que pinta la ventana donde se selecciona el periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "selperiodo")
    {
        // año actual
        $yeartoday = date("Y");

        // Pinto la ventana
        $cont='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
               <script>
               $(function()
               {
               $("#enviarr").on("click",function()
               {
                   $(this).val("Espere por favor ...")
                   .attr("disabled","disabled");
                   $("#theform").submit();
               });
               });
               </script>                
               <table width="400">
                <tr class="CabezoteTabla"> 
                 <td align="center"> <b>Primas de servicio <br> año '.$yeartoday.' </b></td>                  
                </tr>
               </table>
               <!--  <form action="?opcion=precalprimasxls" method="POST" name="x" id="theform"> -->
               <form action="?opcion=precalprimasxls" method="POST" name="x">
               <table width="400">
                <center>
                <br>
                <tr class="TablaDocsImPar">				
                 <td width="150" align="right"> Semestre: &nbsp;</td> 			  
                 <td width="250"> 
                  <select name="semestre" id="semestre" style="width:140px;height:20px">
                   <option value="primero" SELECTED> primero </option> 
                   <option value="segundo"> segundo </option>
                  </select>
                 </td>
                </tr>
                <tr class="TablaDocsImPar">				
                 <td width="150" align="right"> Empleados: &nbsp;</td> 			  
                 <td width="250"> 
                  <select name="empleados" id="empleados" style="width:140px;height:20px">
                   <option value="todos" SELECTED> todos </option> 
                   <option value="nomina"> n&oacute;mina </option>
                   <option value="extralegal"> extralegal </option>
                  </select>
                 </td>
                </tr>
               </table>
               <br>
               <center>
               <input type="submit" value="aceptar" class="button blue"> 
               <a href="importacionexcelnom.php?opcion=ventanaimportacion"><input type="button" value="CANCELAR" class="button red"></a>
               </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: precalprimasxls
    // Creación: 06/12/2022		última modificación: 16/05/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que realiza el cálculo de las primas de los empleados activos
    // Última modificación: Cálculo de los días que faltan para completar el semestre
    //                      (14/12/2022)
    //                      Inmovilización de los paneles superiores para hacer siempre 
    //                      visible el encabezado de la hoja
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "precalprimasxls")
    {
        $semestre = $_POST["semestre"];
        $empleados = $_POST["empleados"];

        // configuración del título
        $yeartoday = date("Y");

        if($semestre == "primero")
        {
            $titulo = "PRIMER SEMESTRE ".$yeartoday;
            $conjuntoperiodos = "1,2,3,4,5,6";
        }
        
        if($semestre == "segundo")
        {
            $titulo = "SEGUNDO SEMESTRE ".$yeartoday;
            $conjuntoperiodos = "7,8,9,10,11,12";
        }

        // Título de la segunda línea
        switch($empleados)
        {
            case 'todos':
                $titulo2="TODOS LOS EMPLEADOS";
                break;
            case 'nomina':
                $titulo2="EMPLEADOS DE NOMINA";
                break;
            case 'extralegal':
                $titulo2="EXTRALEGALES";
                break;
            default:
                break;
        }        

        // obtengo los periodos los cuales voy a calcular
        $vsql2 = "SELECT periodoid
                    FROM periodosnomina
                   WHERE MONTH(fecdesde) IN ($conjuntoperiodos) 
                         AND YEAR(fecdesde) = ".$yeartoday."";

        $conex  = $clase->Conectar();
        $result2 = mysql_query($vsql2,$conex);
        $periodosreportar = mysql_num_rows($result2);

        // Periodos a procesar
        if($periodosreportar>0)
        {
            while($row2 = mysql_fetch_array($result2))
            {
                $listaperiodos.= $row2['periodoid'].",";
            }
            $listaperiodos = substr($listaperiodos, 0, -1);
        }

        // Valor del subsidio de transporte
        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

        // Obtengo el salario mínimo legal vigente
        $smlv = $_SESSION['N_SALMIN2020'];

        // Variable para la validación del auxilio de transporte
        $valsubtrasp = $smlv * 2;

        // Cálculo de los días que faltan para completar el semestre
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoactual = $clase->SeleccionarUno($vsql);

        $k = 0;
        $diasrestantes = 0;
        while($k<strlen($listaperiodos))
        {
            $numcad = substr($listaperiodos,$k,2);
            $nument = intval($numcad);

            if($nument >= $periodoactual)
                $diasrestantes += 15;

            $k += 3;
        }

        // fecha de hoy
        $fechadehoy = date("d/m/Y");

        // Preparo el entorno de la hoja de Excel
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("pre calculo de primas - DROPOS")
                                     ->setSubject("pre calculo de primas - DROPOS")
                                     ->setDescription("pre calculo de primas - DROPOS")
                                     ->setKeywords("pre calculo de primas - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'PRE CALCULO DE PRIMAS DE SERVICIO '.$titulo)
                    ->setCellValue('A2', $titulo2.' AL '.$fechadehoy)
                    ->setCellValue('A3', 'CODIGO')
                    ->setCellValue('B3', 'DOCUMENTO')
                    ->setCellValue('C3', 'NOMBRE')
                    ->setCellValue('D3', 'DIAS TRAB')
                    ->setCellValue('E3', 'LICENCIAS')
                    ->setCellValue('F3', 'MONTO')
                    ->setCellValue('G3', 'PROMEDIO');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        // consulta para procesar los empleados activos
        $vsql = "SELECT terid, codvende, dni, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp,
                        basico, fecingreso
                   FROM terceros
                  WHERE esempleadoactivo = 'CHECKED' AND basico > 0 ";

        if($empleados=="nomina")            $vsql.="  AND (extralegal = '' OR extralegal IS NULL) ";
        if($empleados=="extralegal")        $vsql.="  AND extralegal = 'CHECKED' ";

        $vsql.= "ORDER BY terid";

        $totdiastrab = 0;                           $totlicencias = 0;                          $totmonto = 0;                          $totempleados = 0;
        $i = 4;                                     $totpromedio = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            // Inicializo las variables
            $codvende = "";                         $primerdia = "";                        $ultimodia = "";                        $monto = 0;
            $periodoinicial = 0;                    $diastrab = 0;                          $diaslicencia = 0;                      $sueldointegral = 0;
            $vsql3 = "";                            $vsql4 = "";                            $vsql5 = "";                            $vsql6 = "";

            // formateo el código
            $codvende = $row['codvende'];
            if(substr($codvende,0,1) == "0")            $codvende="'".$codvende;

            // fecha de ingreso del empleado
            $fecingreso = $row['fecingreso'];

            // Valido que el empleado haya trabajado el semestre completo
            if($semestre == "primero")
            {
                $primerdia = $yeartoday."-01-01";
                $ultimodia = $yeartoday."-06-30";

                if(($fecingreso >= $primerdia) && ($fecingreso<=$ultimodia))
                    $todoslosperiodos = true;
                else
                    $todoslosperiodos = false;
            }

            if($semestre == "segundo")
            {
                $primerdia = $yeartoday."-07-01";
                $ultimodia = $yeartoday."-12-30";

                if(($fecingreso >= $primerdia) && ($fecingreso <= $ultimodia))
                    $todoslosperiodos = false;
                else
                    $todoslosperiodos = true;
            }

            // Construyo la nueva lista de periodos trabajados a partir de su fecha de ingreso
            if(!$todoslosperiodos)
            {
                $vsql3 = "SELECT periodoid
                            FROM periodosnomina
                           WHERE '".$fecingreso."' BETWEEN fecdesde AND fechasta";
                $periodoinicial = $clase->SeleccionarUno($vsql3);

                $j = 0;
                $nuevalista = "";
                while($j<strlen($listaperiodos))
                {
                    $numcad = substr($listaperiodos,$j,2);
                    $nument = intval($numcad);

                    if($periodoinicial <= $nument)
                        $nuevalista.= $numcad.",";
                        
                    $j = $j + 3;
                }
                $nuevalista = substr($nuevalista, 0, -1);
            }

            // id del empleado
            $terid = $row['terid'];

            // días trabajados
            $vsql4 = "SELECT IFNULL(SUM(valor),0) AS diastrab
                        FROM hisdetallenomina
                       WHERE terid = ".$terid."";

            if(!$todoslosperiodos)
                $vsql4.= "       AND pernominaid IN ($nuevalista)";
            else
                $vsql4.= "       AND pernominaid IN ($listaperiodos)";

            $vsql4.= "       AND conceptoid IN (1,10,11,12,13,23,31,40)";

            $diastrab = $clase->SeleccionarUno($vsql4);

            // Se añaden los días restantes del semestre
            $diastrab += $diasrestantes;

            // días de licencia
            $vsql5 = "SELECT IFNULL(SUM(valor),0) AS diaslicencia
                        FROM detallenomina h
                             INNER JOIN conceptosnomina c ON (h.conceptoid = c.conceptoid)
                       WHERE h.terid = ".$terid."";

            if(!$todoslosperiodos)
                $vsql5.= "       AND h.pernominaid IN ($nuevalista)";
            else
                $vsql5.= "       AND h.pernominaid IN ($listaperiodos)";

            $vsql5.= "       AND c.eslicencia = 'CHECKED'
                             AND c.tipodc = 'D'";

            $diaslicencia = $clase->SeleccionarUno($vsql5);

            // cálculo el sueldo integral            
            $basico = $row['basico'];

            if($basico <= $valsubtrasp)
                $sueldointegral = $basico + $valsubtransporte;
            else
                $sueldointegral = $basico;

            // Cálculo el monto de la prima
            $monto = $sueldointegral * $diastrab / 360;

            // Cálculo del monto de prima con el sueldo promedio
            if(!$todoslosperiodos)
            {
                $l = 0;
                $acumsueldo = 0;
                $numquincena = 0;
                $sueldoperpri = 0;
                $montopromedio = 0;
                $sueldopromedio = 0;
                while($l<strlen($nuevalista))
                {
                    $numcad = substr($nuevalista,$l,2);
                    $nument = intval($numcad);

                    // Fecha de comienzo del periodo
                    $fecdesde = $clase->BDLockup($nument,'periodosnomina','periodoid','fecdesde');
                    $diadesde = substr($fecdesde, -2);

                    if($diadesde=="01")
                    {
                        $numquincena++;
                        $vsql6 = "SELECT IFNULL(basico,0) AS sueldoperpri FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$nument."";
                        $sueldoperpri = $clase->SeleccionarUno($vsql6);

                        if($sueldoperpri <= $valsubtrasp)
                            $sueldoperpri += $valsubtransporte;

                        $acumsueldo += $sueldoperpri;
                    }
                        
                    $l = $l + 3;
                }

                if($numquincena > 0)
                {
                    $sueldopromedio = $acumsueldo / $numquincena;
                    $montopromedio = $sueldopromedio * $diastrab / 360;
                }
            }
            else
            {
                $m = 0;
                $acumsueldo = 0;
                $numquincena = 0;
                $sueldoperpri = 0;
                $montopromedio = 0;
                $sueldopromedio = 0;
                while($m<strlen($listaperiodos))
                {
                    $numcad = substr($listaperiodos,$m,2);
                    $nument = intval($numcad);

                    // Fecha de comienzo del periodo
                    $fecdesde = $clase->BDLockup($nument,'periodosnomina','periodoid','fecdesde');
                    $diadesde = substr($fecdesde, -2);

                    if($diadesde=="01")
                    {
                        $numquincena++;
                        $vsql6 = "SELECT IFNULL(basico,0) AS sueldoperpri FROM periodoterceros WHERE terid = ".$terid." AND pernominaid = ".$nument."";
                        $sueldoperpri = $clase->SeleccionarUno($vsql6);

                        if($sueldoperpri <= $valsubtrasp)
                            $sueldoperpri += $valsubtransporte;

                        $acumsueldo += $sueldoperpri;
                    }
                        
                    $m = $m + 3;
                }

                if($numquincena > 0)
                {
                    $sueldopromedio = $acumsueldo / $numquincena;
                    $montopromedio = $sueldopromedio * $diastrab / 360;
                }
            }

            if($montopromedio == 0)        $montopromedio = $monto;

            // Monto los datos en la hoja de Excel
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $codvende)
                        ->setCellValue('B'.$i, $row['dni'])
                        ->setCellValue('C'.$i, $row['nombreemp'])
                        ->setCellValue('D'.$i, $diastrab)
                        ->setCellValue('E'.$i, $diaslicencia)
                        ->setCellValue('F'.$i, number_format($monto,2))
                        ->setCellValue('G'.$i, number_format($montopromedio,2));

            // Incremento los totales
            $i++;
            $totempleados++;
            $totdiastrab += $diastrab;
            $totlicencias += $diaslicencia;
            $totmonto += $monto;
            $totpromedio += $montopromedio;
        }

        $rangoEncabezado = 'A3:G3';
        $rangoCeldas     = 'A3:G'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Impresión de totales
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A'.$i, 'TOTALES')
                    ->setCellValue('C'.$i, 'EMPLEADOS: '.$totempleados)
                    ->setCellValue('F'.$i, number_format($totmonto,2))
                    ->setCellValue('G'.$i, number_format($totpromedio,2));

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('primas');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // ---------------------------------------------------------------------------------------------- //
        $nombrearcexcel = "pre calculo de primas de servicio ".strtolower($titulo)." ".$empleados.".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // ---------------------------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmeretrans
    // Creación: 11/04/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar el recalculo de subsidios de 
    //              transporte
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmeretrans")
    {
        $periodoidanterior = $_GET['periodoidanterior'];
        $descripcion  = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');

        // inicialización de variables
        $smlvverifi = $_SESSION['N_SALMIN2020'];
        $valsubtraspverifi = $smlvverifi * 2;
        $vsql9 = "";
        $vsql8 = "";
        $numreg1 = 0;
        $numreg2 = 0;
        $numregt = 0;
        
        // Consulta de los empleados sin subsidio de transporte que deberían tenerlo
        $vsql9 = "SELECT COUNT(t.terid) numreg
                    FROM terceros t 
                         INNER JOIN cargos c ON (t.cargoid =  c.cargoid) 
                   WHERE t.esempleadoactivo = 'CHECKED' 
                         AND c.aplicatransporte = 'CHECKED'  
                         AND t.basico > 0 
                         AND t.basico <=  ".$valsubtraspverifi."   
                         AND t.terid IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 1) 
                         AND t.terid NOT IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 3)";
        $numreg1 = $clase->SeleccionarUno($vsql9);

        // Consulta de los empleados sin subsidio de transporte que deberían tenerlo
        $vsql8 = "SELECT COUNT(t.terid) numreg
                    FROM terceros t 
                         INNER JOIN cargos c ON (t.cargoid =  c.cargoid) 
                   WHERE t.esempleadoactivo = 'CHECKED' 
                         AND c.aplicatransporte = 'CHECKED'  
                         AND t.basico > 0 
                         AND t.basico <=  ".$valsubtraspverifi."   
                         AND t.terid NOT IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 1) 
                         AND t.terid IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 3)";
        $numreg2 = $clase->SeleccionarUno($vsql8);

        if(($numreg1 == 0) && ($numreg2 == 0))
            $cont ='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>No existen registros</b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> No existen empleados a los cuales <br>se les deba recalcular el subsidio de transporte <br> 
                       </font><br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
                       <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
        else
        {
            $numregt = $numreg1 + $numreg2;
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br><b>Recalcular subsidio de transporte</b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center">
                       <label class="Texto12"> 
                       ¿Confirma que desea recalcular el subsidio de transporte a <b> '.$numregt.'</b> empleados <br>en el periodo <b> '.$descripcion.'</b>? 
                       </label>
                      </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"><br><br>
                       <form action="?opcion=recaltransporte" method="POST">
                       <input type="hidden" name="periodoidanterior" value="'.$periodoidanterior.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="importacionexcelnom.php?opcion=ventanaimportacion" ><input type="button" value="CANCELAR" class="button blue"></a>
                       <br><br>
                       <a href="?opcion=infsinsubtransporte&periodoidanterior='.$periodoidanterior.'" target="_blank"> 
                        <img src="images/iconos/cotizacion.png" border="0" title="no lo tienen y deben tenerlo" width="38" height="38">
                       </a>
                       <a href="?opcion=infsinsubtransporteno&periodoidanterior='.$periodoidanterior.'" target="_blank"> 
                        <img src="images/iconos/egresos.png" border="0" title="lo tienen y no deben tenerlo" width="38" height="38">
                       </a>
                       </form>
                       <br>
                      </td>
                     </tr>
                    </table>';
        }
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: recaltransporte
    // Creación: 11/04/2023		última modificación: 20/04/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que recalcula el subsidio de transporte para quienes no lo tengan 
    //              y deban tenerlo
    // Última modificación: Eliminación del subsidio de transporte a los empleados que lo 
    //                      tienen y no deban tenerlo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "recaltransporte")
    {
        $periodoidanterior = $_POST['periodoidanterior'];
        
        // Actualizo el subsidio de transporte a quienes no lo tengan y deban tenerlo
        $smlvverifi = $_SESSION['N_SALMIN2020'];
        $valsubtraspverifi = $smlvverifi * 2;
        $grabados = 0;

        // Consulta de los empleados sin subsidio de transporte que deberían tenerlo
        $vsql9 = "SELECT t.terid, t.basico 
                    FROM terceros t 
                         INNER JOIN cargos c ON (t.cargoid =  c.cargoid) 
                   WHERE t.esempleadoactivo = 'CHECKED' 
                         AND c.aplicatransporte = 'CHECKED'  
                         AND t.basico > 0 
                         AND t.basico <=  ".$valsubtraspverifi."   
                         AND t.terid IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 1) 
                         AND t.terid NOT IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 3)";
    
        $conex = $clase->Conectar();
        $result9 = mysql_query($vsql9,$conex);
        $cant = mysql_num_rows($result9);
        if($cant > 0)
        {
            $vsql10 = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
            $formulatransporte = $clase->SeleccionarUno($vsql10);

            $auxtrans = $_SESSION['N_AUXTRANS2020'];
            $subsidiotransporte = 0;
            $diastrab = 0;
            $numregdn = 0;            
            while($row9 = mysql_fetch_array($result9))
            {
                $terid = $row9['terid'];

                $vsql11 = "SELECT valor FROM detallenomina WHERE conceptoid = 1 AND pernominaid = ".$periodoidanterior." AND terid = ".$terid;
                $diastrab = $clase->SeleccionarUno($vsql11);

                if($diastrab > 0)
                {
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);

                    if($subsidiotransporte > 0)
                    {
                        $vsql12 = "SELECT MAX(detalleid) FROM detallenomina";
                        $numregdn = $clase->SeleccionarUno($vsql12);
                        $numregdn++;
        
                        $vsql13 = "INSERT INTO detallenomina VALUES (".$numregdn.",".$terid.",3,".$periodoidanterior.",".$subsidiotransporte.",0,".$diastrab.",$auxtrans)";
                        $clase->EjecutarSQL($vsql13);

                        if(mysql_affected_rows() >= 1)
                            $grabados++;
                    }
                }
            }

            // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
            $vsql3 = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoidanterior;
            $clase->EjecutarSQL($vsql3);
        }

        // ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
        $vsql8 = "SELECT t.terid
                    FROM terceros t 
                         INNER JOIN cargos c ON (t.cargoid =  c.cargoid) 
                   WHERE t.esempleadoactivo = 'CHECKED' 
                         AND c.aplicatransporte = 'CHECKED'  
                         AND t.basico > 0 
                         AND t.basico <=  ".$valsubtraspverifi."   
                         AND t.terid NOT IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 1) 
                         AND t.terid IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 3)";
    
        $conex = $clase->Conectar();
        $result8 = mysql_query($vsql8,$conex);
        $cant2 = mysql_num_rows($result8);
        if($cant2 > 0)
        {
            while($row8 = mysql_fetch_array($result8))
            {
                $terid = $row8['terid'];

                $vsql = "DELETE FROM detallenomina WHERE terid = ".$terid." AND conceptoid = 3 AND pernominaid =".$periodoidanterior;
                $clase->EjecutarSQL($vsql);

                if(mysql_affected_rows() >= 1)
                    $grabados++;
            }
        }
        // ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- //

        $descripcion  = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');

        // Emito el mensaje correspondiente
        if($grabados==0)
            $clase->Aviso(3,"No se recalcularon subsidios de transporte para el periodo $descripcion");
        else
            $clase->Aviso(1,"Se recalcularon $grabados empleados sin subsidio de transporte en el periodo $descripcion");

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infsinsubtransporte
    // Creación: 14/04/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite el informe de los empleados sin subsidio de transporte 
    //              y que deben tenerlo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "infsinsubtransporte")
    {
        $periodoidanterior = $_GET['periodoidanterior'];
        $descripcion = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/remisionesen.png" width="32" height="32" border="0"> </td>
                  <td width="535"> <b>Empleados sin subsidio de transporte del periodo <font color="blue">'.$descripcion.'</font></b> </td>
                  <td width="20"> &nbsp; </td>
                  <td width="24"> <a href="importacionexcelnom.php?opcion=ventanaimportacion"><input type="button" value="<<" class="button"></a> </td>
                 </tr>
                </table>';

        // encabezado
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                   <td width="10"> &nbsp; </td>
                   <td width="40" alling="center"> Nro </td>
                   <td width="110"> C&eacute;dula </td>
                   <td width="320"> Nombre </td>
                   <td width="75"> &nbsp; </td>
                   <td width="75"> &nbsp; </td>
                   <td width="45"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="60"> &nbsp; </td>
                   <td width="150"> &nbsp; </td>
                   <td width="60"> Recibo </td>
                   <td width="10"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:690px; overflow-Y:scroll">';

        // Consulta de los empleados sin subsidio de transporte que deberían tenerlo
        $smlvverifi = $_SESSION['N_SALMIN2020'];
        $valsubtraspverifi = $smlvverifi * 2;

        $vsql = "SELECT t.terid, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp   
                   FROM terceros t 
                        INNER JOIN cargos c ON (t.cargoid =  c.cargoid) 
                  WHERE t.esempleadoactivo = 'CHECKED' 
                        AND c.aplicatransporte = 'CHECKED'  
                        AND t.basico > 0 
                        AND t.basico <=  ".$valsubtraspverifi."   
                        AND t.terid IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 1) 
                        AND t.terid NOT IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 3)";

        $i = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            // impresión del detalle
            $cont.=' <td width="20"> &nbsp; </td>
                     <td width="30" alling="center"> '.$i.' </td>
                     <td width="110"> '.$row['dni'].' </td>
                     <td width="320"> '.$row['nombreemp'].' </td>
                     <td width="80"> &nbsp; </td>
                     <td width="85"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="40"> &nbsp; </td>
                     <td width="20"> &nbsp; </td>
                     <td width="30"> &nbsp; </td>
                     <td width="40">  
                      <a href="recibodepago.php?opcion=negativo&periodoid='.$periodoidanterior.'&dni='.$row['dni'].'" target="_blank">
                       <img src="images/basicas/pdf.png" title="Recibo" border="0">
                      </a>                             
                     </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infsinsubtransporteno
    // Creación: 20/04/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite el informe de los empleados con subsidio de transporte 
    //              y que no deben tenerlo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "infsinsubtransporteno")
    {
        $periodoidanterior = $_GET['periodoidanterior'];
        $descripcion = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/remisionesen.png" width="32" height="32" border="0"> </td>
                  <td width="535"> <b>Empleados con subsidio de transporte del periodo <font color="blue">'.$descripcion.'</font></b> </td>
                  <td width="20"> &nbsp; </td>
                  <td width="24"> <a href="importacionexcelnom.php?opcion=ventanaimportacion"><input type="button" value="<<" class="button"></a> </td>
                 </tr>
                </table>';

        // encabezado
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                   <td width="10"> &nbsp; </td>
                   <td width="40" alling="center"> Nro </td>
                   <td width="110"> C&eacute;dula </td>
                   <td width="320"> Nombre </td>
                   <td width="75"> &nbsp; </td>
                   <td width="75"> &nbsp; </td>
                   <td width="45"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="50"> &nbsp; </td>
                   <td width="60"> &nbsp; </td>
                   <td width="150"> &nbsp; </td>
                   <td width="60"> Recibo </td>
                   <td width="10"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:690px; overflow-Y:scroll">';

        // Consulta de los empleados sin subsidio de transporte que deberían tenerlo
        $smlvverifi = $_SESSION['N_SALMIN2020'];
        $valsubtraspverifi = $smlvverifi * 2;

        $vsql = "SELECT t.terid, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp   
                   FROM terceros t 
                        INNER JOIN cargos c ON (t.cargoid =  c.cargoid) 
                  WHERE t.esempleadoactivo = 'CHECKED' 
                        AND c.aplicatransporte = 'CHECKED'  
                        AND t.basico > 0 
                        AND t.basico <=  ".$valsubtraspverifi."   
                        AND t.terid NOT IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 1) 
                        AND t.terid IN (SELECT terid FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND conceptoid = 3)";

        $i = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            // impresión del detalle
            $cont.=' <td width="20"> &nbsp; </td>
                     <td width="30" alling="center"> '.$i.' </td>
                     <td width="110"> '.$row['dni'].' </td>
                     <td width="320"> '.$row['nombreemp'].' </td>
                     <td width="80"> &nbsp; </td>
                     <td width="85"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="50"> &nbsp; </td>
                     <td width="40"> &nbsp; </td>
                     <td width="20"> &nbsp; </td>
                     <td width="30"> &nbsp; </td>
                     <td width="40">  
                      <a href="recibodepago.php?opcion=negativo&periodoid='.$periodoidanterior.'&dni='.$row['dni'].'" target="_blank">
                       <img src="images/basicas/pdf.png" title="Recibo" border="0">
                      </a>                             
                     </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererrores
    // Creación: 18/05/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para emitir la información del archivo de 
    //              texto errores.txt
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererrores")
    {
        // Inicialización de variables
        $archivoerror = "reportes/errores.txt";
        $btnaceptar = '<a href="?opcion=ventanaimportacion">';
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        // echo $txt; exit();
        $txt = trim(str_replace("<br />","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Documentos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
                   '.$btnaceptar.'<input type="button" value="aceptar" class="button blue"></a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventliquidacionesxls
    // Creación: 05/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para seleccionar el proceso de importación 
    //              desde Excel para liquidados
    // Última modificación: Validación de la existencia del archivo de errores (10/02/2024)
    //                      Acceso al nuevo formulario de liquidaciones
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventliquidacionesxls")
    {
        $codperiodo = $_GET['codperiodo'];
        $periodoid = $_GET['periodoid'];

        if((strlen($periodoid) == "") || ($periodoid == "") || ($periodoid == 0))
        {
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MAX(periodoid) FROM periodosnomina WHERE cerrado = 'CHECKED')";
            $periodoid = $clase->SeleccionarUno($vsql);            
        }

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $periodonom = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // valido que el archivo de mostrar errores exista
        $archivoerror = "reportes/erroresliquidacion.txt";
        if (file_exists ($archivoerror))
            $htmlarchivoerror = '<a href="?opcion=vererroresliquidaciones&codperiodo='.$codperiodo.'" rel="facebox">
                                  <img src="images/iconos/notas.png" border="0" width="38" height="38">
                                  <br> Documentos no grabados <br> en el &uacute;ltimo proceso 
                                 </a>';
        else
            $htmlarchivoerror = '<img src="images/iconos/notas.png" border="0" width="38" height="38">
                                 <br> Documentos no grabados <br> en el &uacute;ltimo proceso';

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/retirados.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b> Empleados liquidados para el periodo <font color="blue">'.$desperiodo.'</font> </b> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> <a href="calculoliquidados.php?opcion=ventanaliquidados"> <input type="button" value="<<" class="button blue"> </a> </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        // Advertencia del servidor equivocado 
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td>
                      <td width="930" align="center"> 
                       Para ejecutar los procesos de importación desde una hoja de Excel debe dirigirse al servidor <br> 192.168.14.248:9999 o al servidor dromedicas.sytes.net:9996 
                      </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';

        // // variable para la corrección de liquidaciones
        // if(($_SESSION['USERNAME'] == "LFLOREZ"))
        //     $htmlcorreccion = '<a href="?opcion=correcionliquidaciones&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'" rel="facebox">
        //                         <img src="images/iconos/aspectos.png" border="0" width="38" height="38">
        //                         <br>Correcci&oacute;n de liquidaciones <br>'.strtolower($periodonom).'
        //                        </a>';
        // else
        //     $htmlcorreccion = '';

        // variable para la corrección de liquidaciones
        // if(($_SESSION['USERNAME'] == "LFLOREZ"))
        //     $newliquidados = '<a href="liquidados.php" target="_blank">
        //                         <img src="images/iconos/cotizar.png" border="0" width="38" height="38">
        //                         <br>Liquidaciones <br>'.strtolower($desperiodo).'
        //                        </a>';
        // else
        //     $newliquidados = '';

        $newliquidados = '<a href="liquidados.php" target="_blank">
                           <img src="images/iconos/cotizar.png" border="0" width="38" height="38">
                           <br>Liquidaciones <br>'.strtolower($desperiodo).'
                          </a>';

        // Procesos inherentes a la importación desde Excel de los empleados liquidados
        $cont.='<center>
                <table width="900" border="0">
                 <tr height="120">
                  <td width="25%" align="center">
                   <a href="?opcion=importarexcelempliq1&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br>Importar empleados <br> liquidados
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=importarnovedadesliq&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br>Importar novedades
                   </a> 
                  </td>
                  <td width="25%" align="center"> 
                   <a href="?opcion=recargonocturnoliq&periodoid='.$periodoid.'&codperiodo='.$codperiodo.'" target="_blank">
                    <img src="images/iconos/cajas.png" border="0" width="38" height="38">
                    <br> Recargos <br>'.strtolower($periodonom).'
                   </a>
                  </td>
                  <td width="25%" align="center"> 
                   <a href="?opcion=importarocasionalesliq&codperiodo='.$codperiodo.'" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br>Importar descuentos <br>ocasionales
                   </a>
                  </td>
                 </tr>
                 <tr height="120">
                  <td width="25%" align="center"> 
                   <a href="?opcion=importarlibranzasliq&codperiodo='.$codperiodo.'" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br>Importar libranzas <br> y descuentos permanentes
                   </a> 
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=confirmarlimpiarliq&codperiodo='.$codperiodo.'" rel="facebox">
                    <img src="images/iconos/alertas.png" border="0" width="38" height="38">
                    <br> Eliminar liquidaciones <br> de '.strtolower($desperiodo).'
                   </a>                    
                  </td>
                  <td width="25%" align="center">
                   '.$htmlarchivoerror.'
                  </td>                  
                  <td width="25%" align="center">                   
                   <a href="liquidadosxperiodo.php?opcion=ventanadatos" target="_blank">
                    <img src="images/iconos/asignacursos.png" border="0" width="38" height="38">
                    <br>Reporte liquidados <br> por periodo
                   </a>
                  </td>
                 </tr>
                 <tr height="120">
                  <td width="25%" align="center"> 
                   <a href="?opcion=confirmarrecalculo&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'" rel="facebox">
                    <img src="images/iconos/calculando.png" border="0" width="38" height="38">
                    <br>Recalcular liquidaciones
                   </a>
                  </td>
                  <td width="25%" align="center"> 
                   <a href="?opcion=ventanalimpiarconpliq&codperiodo='.$codperiodo.'" target="_blank">
                    <img src="images/iconos/anulardoc.png" border="0" width="38" height="38">
                    <br> Eliminar concepto <br> de '.strtolower($desperiodo).'
                   </a> 
                  </td>
                  <td width="25%" align="center"> '.$newliquidados.' </td>                  
                  <td width="25%" align="center"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarlimpiarliq
    // Creación: 05/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de todas las 
    //              liquidaciones del periodo actual
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiarliq")
    {
        $codperiodo = $_GET['codperiodo'];
        
        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        
        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar liquidaciones </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">¿Confirma que desea eliminar todas las liquidaciones del periodo <br> <b>'.trim($desperiodo).'</b>? <br><br> Esta operaci&oacute;n no podrá ser revertida </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarallliquidaciones" method="POST">
                   <input type="hidden" name="codperiodo" value="'.$codperiodo.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'" > <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarallliquidaciones
    // Creación: 05/02/2024		última modificación: 19/02/2024 
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que elimina todas las liquidaciones del periodo actual
    // Última modificación: Validación de la no eliminación de liquidaciones que estén 
    //                      marcadas como no recalcular en la tabla parametrosliquidacion
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarallliquidaciones")
    {
        $codperiodo = $_POST['codperiodo'];

        $listaperiodos = generarlistaper($codperiodo);

		// Elimino las liquidaciones
		$vsql = "DELETE FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND terid NOT IN (SELECT terid 
                                                                                                     FROM parametrosliquidacion 
                                                                                                    WHERE codperiodo = '".$codperiodo."'
                                                                                                          AND norecalcular = 'CHECKED')";
		$clase->EjecutarSQL($vsql);

		// Elimino las quincenas procesadas en las liquidaciones
		$vsql2 = "DELETE FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid NOT IN (SELECT terid 
                                                                                                           FROM parametrosliquidacion 
                                                                                                          WHERE codperiodo = '".$codperiodo."'
                                                                                                            AND norecalcular = 'CHECKED')";
		$clase->EjecutarSQL($vsql2);

		// Elimino los parámetros de liquidación
		$vsql3 = "DELETE FROM parametrosliquidacion WHERE codperiodo = '".$codperiodo."' AND norecalcular <> 'CHECKED'";
		$clase->EjecutarSQL($vsql3);
        
        // emito el mensaje correspondiente
        $clase->Aviso(1,"Liquidaciones eliminadas exitosamente");

        // Redirecciono el formulario
        header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcelempliq1
    // Creación: 06/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para solicitar la hoja de Excel para subir 
    //              los empleados liquidados con sus cálculos básicos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcelempliq1")
    {
        $codperiodo = $_GET['codperiodo'];
        $periodoid = $_GET['periodoid'];
        
        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b> </td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor diríjase al servidor </font> <br> 
        //                <font color=blue> 192.168.14.248:9999 </font> <br>
        //                <font color=red>o al servidor </font> <br> 
        //                <font color=blue> dromedicas.sytes.net:9996 </font> <br>
        //                <font color=red> para poder ejecutar este proceso </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'" id="theform" enctype="multipart/form-data">
        //                 <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
        //                 <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />
        //                </form> 
        //               </td>
        //              </tr>
        //             </table>';
        // else
        // {
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                        $("#enviarr").on("click",function()
                      {
                         $(this).val("Espere por favor ...")
                         .attr("disabled","disabled");
                         $("#theform").submit();
                      });    
                     });
                    </script>';

            // encabezado
            $cont.='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Importar empleados liquidados <br> <font color="blue">'.strtolower($desperiodo).'</font> </b> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcelempliq2" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">                       
                       <input type="file" name="excel" /><br><br> 
                       <input type="submit" name="enviar" id="enviarr" value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>
                     </tr>
                    </table>';

            // Descripción de la hoja
            $cont.='<table width="500">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: c&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: cesant&iacute;as a&ntilde;o anterior (SI/NO) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: intereses cesant&iacute;as a&ntilde;o anterior (SI/NO) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: cesant&iacute;as a&ntilde;o actual (SI/NO) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>E</b>: intereses cesant&iacute;as a&ntilde;o actual (SI/NO) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>F</b>: vacaciones (SI/NO) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>G</b>: primas primer semestre (SI/NO) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>H</b>: primas segundo semestre (SI/NO) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>I</b>: calcular quincena (SI/NO) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>J</b>: primera o segunda quincena (1/2) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>K</b>: fecha de ingreso (formato aaaa-mm-dd) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>L</b>: fecha de retiro (formato aaaa-mm-dd) </td> </tr>
                    </table>';

            // imagen de ejemplo de la hoja de excel
            $cont.='<table width="500">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplolicenciassubirliq.png" width="450" height="200" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        // }
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcelempliq2
    // Creación: 06/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que calcula la liquidación de los empleados incluidos en la hoja 
    //              de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcelempliq2")
    {
		set_time_limit(0);
		extract($_POST);		
        $codperiodo = $_POST["codperiodo"];
        $periodoidvaca = $_POST["periodoid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;        

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');                               
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;                

                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cesantiasyearanterior'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['intcesantiasyearanterior'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cesantiasyearactual'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['intcesantiasyearactual'] = $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['vacaciones'] = $objPHPExcel->getActiveSheet()->getCell('F'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['primasprimersemestre'] = $objPHPExcel->getActiveSheet()->getCell('G'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['primassegundosemestre'] = $objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['calcularquin'] = $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['nroquincena'] = $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['fecingreso'] = $objPHPExcel->getActiveSheet()->getCell('K'.$i);
                    $_DATOS_EXCEL[$i]['fecretiro'] = $objPHPExcel->getActiveSheet()->getCell('L'.$i);
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['cesantiasyearanterior']) == 0) || (strlen($_DATOS_EXCEL[$i]['cesantiasyearactual']) == 0) 
                       || (strlen($_DATOS_EXCEL[$i]['intcesantiasyearanterior']) == 0) || (strlen($_DATOS_EXCEL[$i]['intcesantiasyearactual']) == 0) || (strlen($_DATOS_EXCEL[$i]['vacaciones']) == 0) 
                       || (strlen($_DATOS_EXCEL[$i]['primasprimersemestre']) == 0) || (strlen($_DATOS_EXCEL[$i]['primassegundosemestre']) == 0) || (strlen($_DATOS_EXCEL[$i]['calcularquin']) == 0)                       
                       || (strlen($_DATOS_EXCEL[$i]['fecingreso']) == 0) || (strlen($_DATOS_EXCEL[$i]['fecretiro']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;            

            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'EMPLEADOS LIQUIDADOS'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($desperiodo,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                
                if($terid != "")
                {
                    // Parámetros establecidos en la hoja de Excel
                    $cesantiasyearanterior = strtoupper($_DATOS_EXCEL[$j]['cesantiasyearanterior']);
                    $cesantiasyearactual = strtoupper($_DATOS_EXCEL[$j]['cesantiasyearactual']);
                    $intcesantiasyearanterior = strtoupper($_DATOS_EXCEL[$j]['intcesantiasyearanterior']);
                    $intcesantiasyearactual = strtoupper($_DATOS_EXCEL[$j]['intcesantiasyearactual']);
                    $vacaciones = strtoupper($_DATOS_EXCEL[$j]['vacaciones']);
                    $primasprimersemestre = strtoupper($_DATOS_EXCEL[$j]['primasprimersemestre']);
                    $primassegundosemestre = strtoupper($_DATOS_EXCEL[$j]['primassegundosemestre']);
                    $calcularquin = strtoupper($_DATOS_EXCEL[$j]['calcularquin']);
                    $nroquincena = strtoupper($_DATOS_EXCEL[$j]['nroquincena']);
                    $norecalcular = "";

                    // Almaceno en la tabla de parámetros de cálculo masivo de las liquidaciones
                    $vsql69 = "INSERT INTO parametrosliquidacion (terid,codperiodo,cesantiasyearanterior,cesantiasyearactual,intcesantiasyearanterior,intcesantiasyearactual,vacaciones,primasprimersemestre,
                                                                  primassegundosemestre,calcularquin,nroquincena,norecalcular) 
                                     VALUE (".$terid.",'".$codperiodo."','".$cesantiasyearanterior."','".$cesantiasyearactual."','".$intcesantiasyearanterior."','".$intcesantiasyearactual."',
                                            '".$vacaciones."','".$primasprimersemestre."','".$primassegundosemestre."','".$calcularquin."',".$nroquincena.",'".$norecalcular."')";
                    $clase->EjecutarSQL($vsql69);

                    // sueldo básico
                    $vsql17 = "SELECT IFNULL(hc.ultsueldo,0) basico 
                                 FROM histcontrato hc
                                WHERE hc.terid = ".$terid." 
                                      AND hc.id = (SELECT MAX(id)
                                                     FROM histcontrato
                                                    WHERE terid = ".$terid.")";
                    $basico = $clase->SeleccionarUno($vsql17);

                    $auxtrans = $_SESSION['N_AUXTRANS2020'];                                            // auxilio de transporte

                    // --------------------------------------------------------------------------------------------------------------- //
                    // actualizo las fechas de ingreso y retiro
                    $fecingreso = $_DATOS_EXCEL[$j]['fecingreso'];
                    $fecretiro = $_DATOS_EXCEL[$j]['fecretiro'];

                    // actualización en el histórico de contrato
                    $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                    $idhistorico = $clase->SeleccionarUno($vsql18);

                    // depuro la fecha de ingreso en caso de ser necesario
                    if(substr($fecingreso,0,1) == "'")
	                    $fecingreso = substr($fecingreso,1,strlen($fecingreso));

                    $vsql42 = "UPDATE histcontrato SET fecingreso = '".$fecingreso."' WHERE id = ".$idhistorico;
                    $clase->EjecutarSQL($vsql42);

                    // depuro la fecha de ingreso en caso de ser necesario
                    if(substr($fecretiro,0,1) == "'")
	                    $fecretiro = substr($fecretiro,1,strlen($fecretiro));

                    $vsql42 = "UPDATE histcontrato SET fecretiro = '".$fecretiro."' WHERE id = ".$idhistorico;
                    $clase->EjecutarSQL($vsql42);                    
            
                    // actualizo en terceros
                    $vsql41 = "UPDATE terceros SET fecharetiro = '".$fecretiro."' WHERE terid = ".$idhistorico;
                    $clase->EjecutarSQL($vsql41);

                    // Calculo los días de quincena
                    if($calcularquin == "SI")
                    {
                        // Valido la columna de la quincena
                        $lb_valido = $io_fecha->uf_solo_numeros($nroquincena);

                        if($lb_valido)
                        {
                            // valido si es primera o segunda quincena
                            if(($nroquincena == 1) || ($nroquincena == 2))
                            {
                                $listaperiodos = generarlistaper($codperiodo);

                                // Determino la quincena (primera o segunda) que se procesará
                                if($nroquincena == 1)
                                    $periodoid = intval(substr($listaperiodos,0,2));
        
                                if($nroquincena == 2)
                                    $periodoid = intval(substr($listaperiodos,3,2));

                                // días trabajados
                                $diastrab = 15;
                                $diastrab2 = 15;

                                // --------------------------------------------------------------------------------------------------------------------- //
                                $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                                $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

                                // $fecingreso = $clase->BDLockup($terid,'terceros','terid','fecingreso');

                                // // Obtengo el id del último contrato
                                // $vsql = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
                                // $id = $clase->SeleccionarUno($vsql);                                
                                // $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');

                                // if(($fecretiro == NULL) || ($fecretiro == '0000-00-00') || ($fecretiro == ''))
                                //     $fecretiro = $clase->BDLockup($terid,'terceros','terid','fecharetiro');                                

                                // Cálculo los días trabajados en caso de que el empleado haya ingresado durante este periodo
                                if(($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta))
                                {
                                    $diastrab = 0;

                                    // Procedo a calcular los días que trabajó durante el periodo
                                    $fecha1= new DateTime($fecingreso);
                                    $fecha2= new DateTime($fechasta);
                                    $diff = $fecha1->diff($fecha2);
                                    
                                    $difendias = $diff->days;
                                    $diastrab = $difendias + 1;
                
                                    $diadesde = substr($fecdesde, -2);
                                    if($diadesde=="16")
                                    {
                                        $fechaEntera = strtotime($fechasta);
                                        $valdias = date("d", $fechaEntera);
                                        if($valdias=="28")          $diastrab += 2;
                                        if($valdias=="29")          $diastrab += 1;
                                        if($valdias=="31")          $diastrab -= 1;
                                    }

                                    $diastrab2 = $diastrab;
                                }

                                // Valido si la fecha de retiro está dentro del rango de periodo
                                if(($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta))
                                {
                                    $diastrab = 0;

                                    // Procedo a calcular los días que trabajó durante el periodo
                                    $fecha1= new DateTime($fecdesde);
                                    $fecha2= new DateTime($fecretiro);
                                    $diff = $fecha1->diff($fecha2);
                                    
                                    $difendias = $diff->days;
                                    $diastrab = $difendias + 1;

                                    $diastrab2 = $diastrab;
                                }                                

                                // valido si el empleado tiene fecha de ingreso y retiro dentro del periodo
                                if((($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta)) && (($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta)))
                                {
                                    $diastrab = 0;

                                    // Procedo a calcular los días que trabajó durante el periodo
                                    $fecha1= new DateTime($fecingreso);
                                    $fecha2= new DateTime($fecretiro);
                                    $diff = $fecha1->diff($fecha2);
                                    
                                    $difendias = $diff->days;
                                    $diastrab = $difendias + 1;

                                    $diastrab2 = $diastrab;
                                }

                                if($diastrab >= 16)
                                    $diastrab = 15;

                                if($diastrab2 >= 16)
                                    $diastrab2 = 15;

                                // --------------------------------------------------------------------------------------------------------------------- //
        
                                // Obtengo la formula del sueldo
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                                $formulabasico = $clase->SeleccionarUno($vsql);
        
                                // Calculo el sueldo básico
                                eval("\$sueldo = $formulabasico;");
                                $sueldo = round($sueldo,0);
        
                                // --------------------------------------------------------------------------------------------------- //
                                // Determino si el empleado posee pagos de quincena en liquidación para eliminárselo
                                $vsqldatos = "";
                                $vsqldatos = "SELECT COUNT(*) AS numregliq 
                                                FROM detalleliquidacion 
                                               WHERE pernominaid IN ($listaperiodos) 
                                                     AND terid = ".$terid;
                                $numregliq = $clase->SeleccionarUno($vsqldatos);
        
                                if($numregliq>0)
                                {
                                    $vsql = "DELETE FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid;
                                    $clase->EjecutarSQL($vsql);
                                }
        
                                // --------------------------------------------------------------------------------------------------- //
                                // sueldo
                                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                $numreg = $clase->SeleccionarUno($vsql);
                                $numreg++;
        
                                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico)";
                                $clase->EjecutarSQL($vsql);
        
                                // Recalculo el subsidio de transporte

                                // Obtengo el salario mínimo legal vigente
                                $smlv = $_SESSION['N_SALMIN2020'];
                                $valsubtrasp = $smlv * 2;                       // Variable para la validación del auxilio de transporte
        
                                // Obtengo la formula para el subsidio de transporte
                                $auxtrans = $_SESSION['N_AUXTRANS2020'];
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                                $formulatransporte = $clase->SeleccionarUno($vsql);
        
                                $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
                                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte
        
                                if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                                {
                                    // Calculo el subsidio de transporte
                                    $aux_trans = $diastrab;
                                    // $diastrab = $diastrab2;
        
                                    eval("\$subsidiotransporte = $formulatransporte;");
                                    $subsidiotransporte = round($subsidiotransporte,0);
        
                                    // $diastrab = $aux_trans;
                                }
                                else
                                    $subsidiotransporte = 0;
        
                                // Obtengo el valor del subsidio de transporte
                                $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
        
                                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                $numreg = $clase->SeleccionarUno($vsql);
                                $numreg++;
        
                                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                                $clase->EjecutarSQL($vsql);
        
                                // Determino si el empleado es de condición extralegal
                                $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                                $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                                $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                                
                                if($epsid==NULL)                $epsid=0;
                                if($pensionesid==NULL)          $pensionesid=0;
        
                                $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totnovedades 
                                           FROM detalleliquidacion d
                                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                          WHERE d.terid = ".$terid."
                                                AND d.pernominaid = ".$periodoid." 
                                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                                $totnovedades = $clase->SeleccionarUno($vsql);

                                $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                           FROM detallenomina d
                                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                          WHERE d.terid = ".$terid."
                                                AND d.pernominaid = ".$periodoid." 
                                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                                $totrecargos = $clase->SeleccionarUno($vsql);
                        
                                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
        
                                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');             // Obtengo el control del cálculo de pensión
                                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');                 // Obtengo el control del cálculo de salud
        
                                if($extralegal=="CHECKED")
                                {
                                    $pension = 0;
                                    $salud = 0;
                                }
                                else
                                {
                                    // Recalculo pensión y salud
                                    if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                        $pension = 0;
                                    else
                                    {
                                        // Obtengo la formula para el descuento por pensión
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                        $formulapension = $clase->SeleccionarUno($vsql);
        
                                        // Calculo la pensión
                                        eval("\$pension = $formulapension;");
                                        $pension = round($pension,0);
                                    }
        
                                    if(($epsid==37)||($aplicasalud!="CHECKED"))
                                        $salud = 0;
                                    else
                                    {
                                        // Obtengo la formula para el descuento de salud
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                        $formulasalud = $clase->SeleccionarUno($vsql);
                                        
                                        // Calculo la salud
                                        eval("\$salud = $formulasalud;");
                                        $salud = round($salud,0);
                                    }
                                }
        
                                // ------------------------------------------------------------------------------------------------------------------------------------ //
                                // pensión
                                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                $numreg = $clase->SeleccionarUno($vsql);
                                $numreg++;
        
                                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                                $clase->EjecutarSQL($vsql);
        
                                // salud
                                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                $numreg = $clase->SeleccionarUno($vsql);
                                $numreg++;
        
                                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                                $clase->EjecutarSQL($vsql);
        
                                // Aquí depuro los conceptos que estén en cero
                                $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoid." AND terid = ".$terid."";
                                $clase->EjecutarSQL($vsql);
                            }
                        }
                    }

                    // Inicialización de variables
                    $diasps = 0;
                    $diasss = 0;

                    // $fecingreso = $clase->BDLockup($terid,'terceros','terid','fecingreso');             // fecha de ingreso                    
                    $yearingreso = intval(substr($fecingreso,0,4));                                     // año de la fecha de ingreso

                    // // Obtengo el id del último contrato
                    // $vsql = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
                    // $id = $clase->SeleccionarUno($vsql);
                    // $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');
                    
                    // $sueldointegralact = $basico + $auxtrans;                                           // sueldo integral año actual

                    // if(($fecretiro == NULL) || ($fecretiro == '0000-00-00') || ($fecretiro == ''))
                    //     $fecretiro = $clase->BDLockup($terid,'terceros','terid','fecharetiro');
            
                    // // validación del subsidio de transporte
                    // $smlv = $_SESSION['N_SALMIN2020'];
                    // $valtransporte = $smlv * 2;
            
                    // if($basico > $valtransporte)
                    //     $auxtrans = 0;
                    // else
                    //     $auxtrans = $_SESSION['N_AUXTRANS2020'];

                    // ------------------------------------------------------------------------------------------- //
                    // Determino si hubo un cambio de salario en los últimos tres meses
                    $tienecambio = tienecambiosalario($terid,$fecretiro);

                    if($tienecambio)
                    {
                        $promsueldoact = calsueldopromedio($terid,$fecingreso);
                        $basico = $promsueldoact;
                    }
                    
                    // año anterior
                    $yearprev = date("Y") - 1;

                    if($yearingreso>$yearprev)
                    {
                        $basicoant = 0;
                        $auxtransant = 0;
                        $diasyearant = 0;
                        $sueldointegralant = 0;
                    }
                    else
                    {
                        // máximo periodo del año anterior
                        $vsql = " SELECT MAX(periodoid) AS periodoidant FROM periodosnomina WHERE YEAR(fechasta) = ".$yearprev." ";
                        $periodoidant = $clase->SeleccionarUno($vsql);
                
                        // básico de año anterior            
                        $vsql = "SELECT saldo 
                                   FROM hisdetallenomina 
                                  WHERE terid = ".$terid." 
                                        AND pernominaid = ".$periodoidant." 
                                        AND conceptoid IN (1,10,11,12,13,31,38,43)";
                        $basicoant = $clase->SeleccionarUno($vsql);

                        $vsql25 = "SELECT MIN(periodoid) permin2
                                     FROM periodosnomina 
                                    WHERE fecdesde >= '".$fecingreso."' 
                                          AND YEAR(fecdesde) = ".$yearprev." 
                                          AND cerrado = 'CHECKED' ";
                        $permin2 = $clase->SeleccionarUno($vsql25);

                        if(strlen($permin2) == 0)
                        {
                            $vsql25 = "SELECT MIN(periodoid) permin2
                                         FROM periodosnomina 
                                        WHERE fecdesde >= '".$fecingreso."'
                                              AND cerrado = 'CHECKED' ";
                            $permin2 = $clase->SeleccionarUno($vsql25);
                            $permin2--;
                        }
                    
                        $vsql26 = "SELECT MAX(periodoid) permax2
                                     FROM periodosnomina 
                                    WHERE fecdesde >= '".$fecingreso."' 
                                          AND YEAR(fecdesde) = ".$yearprev." 
                                          AND cerrado = 'CHECKED' ";
                        $permax2 = $clase->SeleccionarUno($vsql26);

                        if(strlen($permax2) == 0)
                            $permax2 = $permin2;
                
                        if(($basicoant==0)||($basicoant==NULL))
                        {
                            $basicoant = 0;
                            $auxtransant = 0;
                            $diasyearant = 0;
                            $sueldointegralant = 0;
                        }
                        else
                        {
                            // auxilio de transporte del año anterior
                            $vsql = "SELECT saldo FROM hisdetallenomina WHERE conceptoid = 3 AND pernominaid = ".$periodoidant." AND terid = ".$terid;
                            $auxtransant = $clase->SeleccionarUno($vsql);
                
                            // Sueldo integral del año anterior
                            $sueldointegralant = $basicoant + $auxtransant;
                
                            // días laborados el año anterior
                            $vsql = "SELECT periodoid
                                       FROM periodosnomina
                                      WHERE fecdesde <= '".$fecingreso."'
                                            AND fechasta >= '".$fecingreso."'";
                            $eneroant = $clase->SeleccionarUno($vsql);
                    
                            $vsql = "SELECT SUM(valor) AS diasyearant 
                                       FROM hisdetallenomina 
                                      WHERE terid = ".$terid." 
                                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                            AND pernominaid BETWEEN ".$eneroant." AND ".$periodoidant."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid BETWEEN ".$permin2." AND ".$permax2."
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                            $diasyearant = $clase->SeleccionarUno($vsql);
                        }
                    }

                    // ----------------------------------------------------------------------------------------------- //
                    // Días laborados en el primer trimestre del año actual
                    $yeartoday = date("Y");

                    $comienzoprimersemestre = $yeartoday."-01-01";
                    $finprimersemestre = $yeartoday."-06-30";

                    // si el empleado ingresó en este periodo
                    if($fecingreso>=$comienzoprimersemestre)
                    {            
                        $vsql = " SELECT MAX(periodoid) AS primeroenero FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
                        $primeroenero = $clase->SeleccionarUno($vsql);
                
                        $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
                        $treintajunio = $clase->SeleccionarUno($vsql);
                
                        // Días en el histórico
                        $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                                   FROM hisdetallenomina 
                                  WHERE terid = ".$terid." 
                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40)
                                        AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                  FROM periodoterceros
                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                       AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                       AND periodoterceros.extralegal = 'CHECKED')";
                        $diasps = $clase->SeleccionarUno($vsql);
                
                        // Días en la liquidación        
                        $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                   FROM detalleliquidacion 
                                  WHERE terid = ".$terid." 
                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                        AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
                        $diasliq = $clase->SeleccionarUno($vsql);
                
                        $diasps += $diasliq;
                    }

                    if(($fecingreso<$comienzoprimersemestre)&&($diasyearant>0))
                    {
                        $diasliq = 0;
                        $vsql = " SELECT periodoid AS primeroenero FROM periodosnomina WHERE fecdesde = '".$comienzoprimersemestre."' ";
                        $primeroenero = $clase->SeleccionarUno($vsql);

                        $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
                        $treintajunio = $clase->SeleccionarUno($vsql);
                
                        // Días en el histórico
                        $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                                   FROM hisdetallenomina 
                                  WHERE terid = ".$terid." 
                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                        AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                  FROM periodoterceros
                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                       AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                       AND periodoterceros.extralegal = 'CHECKED')";
                        $diasps = $clase->SeleccionarUno($vsql);
                
                        // Días en la liquidación        
                        $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                   FROM detalleliquidacion 
                                  WHERE terid = ".$terid." 
                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40)
                                        AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
                        $diasliq = $clase->SeleccionarUno($vsql);
                
                        $diasps += $diasliq;
                    }

                    // Días laborados en el segundo semestre del año
                    $inisegsemestre = $yeartoday."-07-01";
                    $finsegsemestre = $yeartoday."-12-31";

                    // si el empleado ingresó en este periodo
                    if($fecingreso>=$inisegsemestre)
                    {
                        $vsql = " SELECT MAX(periodoid) AS primerojulio FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
                        $primerojulio = $clase->SeleccionarUno($vsql);

                        $vsql = " SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."' ";
                        $treintayuno = $clase->SeleccionarUno($vsql);
                
                        $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                                   FROM hisdetallenomina 
                                  WHERE terid = ".$terid." 
                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                        AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                  FROM periodoterceros
                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                       AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                       AND periodoterceros.extralegal = 'CHECKED')";
                        $diasss = $clase->SeleccionarUno($vsql);
                
                        // Días en la liquidación        
                        $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                   FROM detalleliquidacion 
                                  WHERE terid = ".$terid." 
                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                        AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
                        $diasliq = $clase->SeleccionarUno($vsql);
                
                        $diasss += $diasliq;
                    }

                    if(($fecingreso<$inisegsemestre)&&($diasps>0))
                    {
                        $vsql = " SELECT periodoid AS primerojulio FROM periodosnomina WHERE fecdesde = '".$inisegsemestre."' ";
                        $primerojulio = $clase->SeleccionarUno($vsql);

                        $vsql = " SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."' ";
                        $treintayuno = $clase->SeleccionarUno($vsql);
                
                        $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                                   FROM hisdetallenomina 
                                  WHERE terid = ".$terid." 
                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                        AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                  FROM periodoterceros
                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                       AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                       AND periodoterceros.extralegal = 'CHECKED')";
                        $diasss = $clase->SeleccionarUno($vsql);
                
                        // Días en la liquidación
                        $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                   FROM detalleliquidacion 
                                  WHERE terid = ".$terid." 
                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                        AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
                        $diasliq = $clase->SeleccionarUno($vsql);
                
                        $diasss += $diasliq;
                    }

                    // Inicialización de variables
                    $pagocenact = 0;                            $cantidad = 0;                          $porcentaje = 0;                        $pagointereses = 0;
                    $pagovaca = 0;                              $diasvaca = 0;                          $diasprima = 0;                         $pagoprimasps = 0;
                    $lbprocesado = false;                       $pagocesant = 0;                        $cantidadact = 0;                       $cantidadant = 0;
                    $pagocesantias = 0;                         $interesesact = 0;                      $interesesant = 0;                      $pagoprimasss = 0;
                    $pagoprimas = 0;                            $recarnonocturno = 0;                   $ultimobasico = 0;                      $auxtrans = $_SESSION['N_AUXTRANS2020'];

                    // ---------------------------------------------------------- //
                    // Cálculo de cesantías
                    if(($cesantiasyearactual == "SI") || ($cesantiasyearanterior == "SI") || ($intcesantiasyearactual == "SI") || ($intcesantiasyearanterior == "SI"))
                    {
                        // Cálculo de cesantías del año actual
                        if($cesantiasyearactual == "SI")
                        {
                            $cantidadact = $diasps + $diasss;
                            // $pagocenact = $sueldointegralact * $cantidadact / 360;
                            $pagocenact = ($basico + $auxtrans) * $cantidadact / 360;
                        }
                        else
                        {
                            $pagocenact = 0;
                            $cantidadact = 0;
                        }
                        
                        // Cálculo de cesantías del año anterior
                        if($cesantiasyearanterior == "SI")
                        {
                            $pagocesant = ($sueldointegralant + $auxtrans) * $diasyearant / 360;
                            $cantidadant = $diasyearant;
                        }
                        else
                        {
                            $pagocesant = 0;
                            $cantidadant = 0;
                        }
                        
                        // sub totales
                        $pagocesantias = $pagocenact + $pagocesant;
                        $pagocesantias = round($pagocesantias,2);
                        $cantidad = $cantidadact + $cantidadant;
                        $porcentaje = 12;

                        // Intereses año actual
                        if($intcesantiasyearactual == "SI")
                            $interesesact = (($pagocenact * ($diasps + $diasss)) * 0.12 / 360);
                        else
                            $interesesact = 0;

                        // intereses del año anterior
                        if($intcesantiasyearanterior == "SI")
                            $interesesant = (($pagocesant * $diasyearant) * 0.12 / 360);
                        else
                            $interesesant = 0;

                        $pagointereses = $interesesact + $interesesant;
                        $pagointereses = round($pagointereses,2);

                        // Guardo en la tabla
                        $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                                  VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcentaje.",".$pagointereses.")";
                        $clase->EjecutarSQL($vsql);

                        if(mysql_affected_rows() >= 1)
                            $lbgrabo = true;
                    }

                    // ---------------------------------------------------------- //
                    // Cálculo de vacaciones
                    if($vacaciones == "SI")
                    {
                        // Determino si hay vacaciones canceladas previamente
                        $vsql22 = "SELECT MIN(periodoid) permin
                                     FROM periodosnomina 
                                    WHERE fecdesde >= '".$fecingreso."' 
                                          AND cerrado = 'CHECKED' ";
                        $permin = $clase->SeleccionarUno($vsql22);

                        // Determino si hay vacaciones canceladas previamente
                        $vsql23 = "SELECT MAX(periodoid) permax
                                     FROM periodosnomina 
                                    WHERE fecdesde >= '".$fecingreso."' 
                                          AND cerrado = 'CHECKED' ";
                        $permax = $clase->SeleccionarUno($vsql23);

                        $vsql24 = "SELECT pernominaid pervacaciones
                                     FROM hisdetallenomina 
                                    WHERE terid = ".$terid."         
                                          AND conceptoid = 38 
                                          AND pernominaid >= ".$permin." AND pernominaid <= ".$permax."";
                        $pervacaciones = $clase->SeleccionarUno($vsql24);

                        if(strlen($pervacaciones) > 0)
                        {
                            $pervacaciones++;

                            $vsql31 = "SELECT IFNULL(SUM(valor),0) AS diasvaca  
                                         FROM hisdetallenomina 
                                        WHERE terid = ".$terid."         
                                              AND (pernominaid >= ".$pervacaciones." AND pernominaid <= ".$permax.")  
                                              AND conceptoid IN (1,10,11,12,13,23,31,38,40)";
                            $diasvaca = $clase->SeleccionarUno($vsql31);
                        }
                        else
                            $diasvaca = $diasyearant + $diasps + $diasss;
                        
                        // ---------------------------------------------------------- //
                        // sueldo básico
                        // $basico = $clase->BDLockup($terid,'terceros','terid','basico');
                        // $pagovaca = $basico * ($diasyearant + $diasps + $diasss) / 720;
                        // $pagovaca = $basico * $diasvaca / 720;

                        $vsql19 = "SELECT saldo FROM detalleliquidacion WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                        $ultimobasico = $clase->SeleccionarUno($vsql19);
                        
                        if($ultimobasico == 0)
                        {
                            $vsql20 = "SELECT MAX(pernominaid) FROM detallenomina WHERE conceptoid = 1 AND terid = ".$terid;
                            $ultimoperbasico = $clase->SeleccionarUno($vsql20);
            
                            $vsql19 = "SELECT saldo FROM detallenomina WHERE conceptoid = 1 AND pernominaid = ".$ultimoperbasico." AND terid = ".$terid;
                            $ultimobasico = $clase->SeleccionarUno($vsql19);
                        }                        

                        // busco recargo nocturno
                        $recarnonocturno = buscarrecargonoc($terid,$periodoidvaca);

                        $pagovaca = ($ultimobasico + $recarnonocturno) * $diasvaca / 720;

                        $pagovaca = round($pagovaca,2);
                        // $diasvaca = $diasyearant + $diasps + $diasss;

                        // Almaceno en la tabla
                        $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovaca.",".$diasvaca.",0,0)";
                        $clase->EjecutarSQL($vsql);

                        if(mysql_affected_rows() >= 1)
                            $lbgrabo = true;
                    }

                    // ---------------------------------------------------------- //
                    // Cálculo de primas
                    if(($primasprimersemestre == "SI") || ($primassegundosemestre == "SI"))
                    {
                        // Primas primer semestre
                        if($primasprimersemestre == "SI")
                        {
                            $diasprima += $diasps;
                            $pagoprimasps = ($basico + $auxtrans) * $diasps / 360;
                        }

                        // Primas segundo semestre
                        if($primassegundosemestre == "SI")
                        {
                            $diasprima += $diasss;
                            $pagoprimasss = ($basico + $auxtrans) * $diasss / 360;
                        }

                        $pagoprimas = $pagoprimasps + $pagoprimasss;
                        $pagoprimas = round($pagoprimas,2);

                        // Almaceno en la tabla
                        $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimas.",".$diasprima.",0,0)";
                        $clase->EjecutarSQL($vsql);

                        if(mysql_affected_rows() >= 1)
                            $lbgrabo = true;
                    }

                    if($lbgrabo)
                        $grabados++;
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresliquidacion.txt";                        // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);         // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresliquidacion.txt";                                            // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                                 // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                        // Grabas
            fclose($fd);                                                                    // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las liquidaciones");
            else
                $clase->Aviso(1,"Se cargaron satisfactoriamente $grabados liquidaciones del periodo $desperiodo");

            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo&periodoid=$periodoidvaca");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarnovedadesliq
    // Creación: 07/02/2024		última modificación: 22/02/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para seleccionar la hoja de Excel para 
    //              importar las novedades de liquidación
    // Última modificación: Inclusión de los conceptos Macropapeles y seguros Bolívar en la 
    //                      descripción de la estructura de la hoja de Excel
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarnovedadesliq")
    {
        $codperiodo = $_GET['codperiodo'];
        $periodoid = $_GET['periodoid'];

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');        

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b></td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor diríjase al servidor </font><br> 
        //                <font color=blue> 192.168.14.248:9999 </font> <br>
        //                <font color=red>o al servidor </font> <br> 
        //                <font color=blue> dromedicas.sytes.net:9996 </font> <br>
        //                <font color=red> para poder importar estos datos </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">        
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'" id="theform" enctype="multipart/form-data">
        //                 <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
        //                 <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
        //                </form> 
        //               </td>    
        //              </tr>
        //             </table>';
        // else
        // {
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Importar novedades de liquidaciones <br> <font color="blue">'.strtolower($desperiodo).'</font> </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarnovedadesliq2" id="theform" enctype="multipart/form-data">
                        <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                        <input type="hidden" name="periodoid" value="'.$periodoid.'">
                        <input type="file" name="excel" /><br><br>                            
                        <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                        <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';

            // descripción de la hoja de Excel
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: D&iacute;as </td> </tr>                 
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Tipo de licencia: </td> </tr>                     
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>6</b></font> LICENCIA NO REMUNERADA <font color="blue"><b>9</b></font> SUSPENCION <font color="blue"><b>10</b></font> INCAPACIDAD
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>11</b></font> LICENCIA POR MATERNIDAD <font color="blue"><b>12</b></font> LICENCIA POR PATERNIDAD
                      </td>
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>13</b></font> LICENCIA REMUNERADA <font color="blue"><b>23</b></font> LICENCIA POR CUMPLEAñOS 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>31</b></font> MATRIMONIO <font color="blue"><b>40</b></font> INCAPACIDAD ARL 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>43</b></font> INC SUPERIOR A 180 D&Iacute;AS <font color="blue"><b>36</b></font> MACROPAPELES 
                      </td>                      
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>44</b></font> SEGUROS BOLIVAR
                      </td> 
                     </tr>
                    </table>';

            // imagen de ejemplo
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplonovliqmasiva.png" width="300" height="200" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx </font>
                      </td> 
                     </tr>
                    </table>';
        // }
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarnovedadesliq2
    // Creación: 08/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para calcular masivamente las novedades de liquidaciones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarnovedadesliq2")
    {
		set_time_limit(0);
		extract($_POST);
        $codperiodo = $_POST["codperiodo"];
        $periodoid = $_POST["periodoid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['dias'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['conceptoid'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['dias']) == 0) || (strlen($_DATOS_EXCEL[$i]['conceptoid']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;

            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'NOVEDADES DE LIQUIDACION'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($desperiodo,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];

                $valreg = 0;

                // valido que el empleado exista
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],'terceros',"dni","terid");
                
                if($terid != "")
                {
                    $dias = $_DATOS_EXCEL[$j]['dias'];
                    $conceptoid = $_DATOS_EXCEL[$j]['conceptoid'];                    
                    
                    // Valido la entrada de los datos de la hoja de Excel
                    $lb_valido = $io_fecha->uf_solo_numeros($dias);         // Valido la columna de los días

                    // Valido que el concepto sea una licencia
                    $vsql = "SELECT eslicencia
                               FROM conceptosnomina 
                              WHERE conceptoid = ".$conceptoid;
                    $eslicencia = $clase->SeleccionarUno($vsql);

                    if(($lb_valido) && ($eslicencia == "CHECKED"))
                    {
                        // Valido si el empleado tiene quincena procesada 
                        $listaperiodos = generarlistaper($codperiodo);

                        $vsql78 = "SELECT COUNT(*) numregquin FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)";
                        $numregquin = $clase->SeleccionarUno($vsql78);                        

                        if($numregquin > 0)
                        {
                            // periodo a procesar
                            $vsql33 = "SELECT pernominaid FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 1 AND pernominaid IN ($listaperiodos)";
                            $periodoidanterior = $clase->SeleccionarUno($vsql33);
                            
                            // inicialización de variables
                            $difendias = 0;                         $basico = 0;                        $diastrab = 0;
                            $detalleid = 0;                         $numid = 0;                         $formulabasico = "";
                            $formulalice = "";                      $montolicencia = 0;                 $porcbasico = 0;
                            $tipodc = "";                           $repetida = 0;                      $valor = 0;
                            $descuentos = 0;                        $cargoid = 0;                       $diaspendiente = 0;
                            $aplicatransporte = "";                 $auxtrans = 0;                      $formulatransporte = "";
                            $subsidiotransporte = 0;                $numreg = 0;                        $totnovedades = 0;
                            $sueldodeducciones = 0;                 $sueldo = 0;                        $epsid = 0;
                            $pensionesid = 0;                       $aplicapension = "";                $aplicasalud = "";
                            $pension = 0;                           $salud = 0;                         $formulapension = "";
                            $formulasalud = "";                     $idpension = 0;                     $idsalud = 0;
                            $cesantiasyearanterior = "";            $cesantiasyearactual = "";          $intcesantiasyearanterior = "";
                            $intcesantiasyearactual = "";           $vacaciones = "";                   $primasprimersemestre = "";
                            $primassegundosemestre = "";

                            // Obtengo el salario mínimo legal vigente
                            $smlv = $_SESSION['N_SALMIN2020'];

                            // Obtengo el salario básico del empleado
                            $vsql17 = "SELECT hc.ultsueldo 
                                         FROM histcontrato hc
                                        WHERE hc.terid = ".$terid." 
                                              AND hc.id = (SELECT MAX(id)
                                                             FROM histcontrato
                                                            WHERE terid = ".$terid.")";
                            $basico = $clase->SeleccionarUno($vsql17);
                
                            // Obtengo la formula del sueldo
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                            $formulabasico = $clase->SeleccionarUno($vsql);                            

                            // Obtengo los días trabajados en el periodo
                            $vsql = "SELECT valor
                                       FROM detalleliquidacion 
                                      WHERE conceptoid = 1  
                                            AND pernominaid = ".$periodoidanterior."
                                            AND terid = ".$terid."";
                            $diastrab = $clase->SeleccionarUno($vsql);
                
                            // Obtengo el ID del registro que se modificará
                            $vsql = "SELECT detalleid
                                       FROM detalleliquidacion 
                                      WHERE conceptoid = 1  
                                            AND pernominaid = ".$periodoidanterior."
                                            AND terid = ".$terid."";
                            $detalleid = $clase->SeleccionarUno($vsql);

                            $diastrab -= $dias;

                            eval("\$sueldo = $formulabasico;");
                            $sueldo = round($sueldo,0);
                
                            // Almaceno en nuevo sueldo
                            $vsql = "UPDATE detalleliquidacion SET 
                                            devengados = ".$sueldo.", 
                                            valor = ".$diastrab."
                                      WHERE detalleid = ".$detalleid."";
                            $clase->EjecutarSQL($vsql);

                            // Calculo el nuevo ID
                            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                            $numid = $clase->SeleccionarUno($vsql);
                            $numid++;

                            // Inserto la nueva licencia

                            // Obtengo la formula de la licencia
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                            $formulalice = $clase->SeleccionarUno($vsql);

                            // Calculo la licencia
                            if($conceptoid!=10)
                            {
                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);
                            }
                            else
                            {
                                // Calculo la incapacidad

                                // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                                if($basico<=$smlv)
                                {
                                    $montolicencia = ($smlv*$dias)/30;
                                    $montolicencia = round($montolicencia,0);
                                }
                                else
                                {
                                    $porcbasico = ($basico*66.67)/100;
                                    $porcbasico = round($porcbasico,0);

                                    // Calculo la incapacidad si el básico sea mayor al mínimo
                                    if($porcbasico>$smlv)
                                    {
                                        $montolicencia = ($porcbasico*$dias)/30;
                                        $montolicencia = round($montolicencia,0);
                                    }
                                    else
                                    {
                                        if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                        if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                                        $montolicencia = round($montolicencia,0);
                                    }
                                }
                            }

                            // Obtengo el tipo de licencia
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                            // ------------------------------------------------------------------------------------------------------------------- //
                            // Determino si el registro existe para modificarlo o incluirlo
                            $vsql = "SELECT COUNT(*) AS repetida 
                                       FROM detalleliquidacion
                                      WHERE pernominaid = ".$periodoidanterior."
                                            AND conceptoid = ".$conceptoid."
                                            AND terid = ".$terid."";
                            $repetida = $clase->SeleccionarUno($vsql);

                            if($repetida==0)
                            {
                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidanterior.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidanterior.",0,".$montolicencia.",".$dias.",".$basico.")";
                            }
                            else
                            {
                                // Determino el id del registro
                                $vsql = "SELECT detalleid AS detalleid 
                                           FROM detalleliquidacion
                                          WHERE pernominaid = ".$periodoidanterior."
                                                AND conceptoid = ".$conceptoid."
                                                AND terid = ".$terid."";
                                $detalleid = $clase->SeleccionarUno($vsql);
        
                                $valor = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','valor');
                                $valor += $dias;
        
                                // Actualizo la licencia
                                if($tipodc=="C")
                                {
                                    $devengados = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','devengados');
                                    $devengados += $montolicencia;
                                    
                                    $vsql = "UPDATE detalleliquidacion SET 
                                                    devengados = ".$devengados.", 
                                                    valor = ".$valor."
                                              WHERE detalleid = ".$detalleid."";
                                }
                                else
                                {
                                    $descuentos = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','descuentos');
                                    $descuentos += $montolicencia;
        
                                    $vsql = "UPDATE detalleliquidacion SET 
                                                    descuentos = ".$descuentos.", 
                                                    valor = ".$valor."
                                              WHERE detalleid = ".$detalleid."";
                                }
                            }
                            $clase->EjecutarSQL($vsql);

                            if(mysql_affected_rows() < 1)
                                $lbpaso = false;
                            else
                            {
                                $lbpaso = true;
                                $grabados++;
                                $lbgrabo = true;
                            }

                            if($lbpaso)
                            {
                                if($diastrab > 0)
                                {
                                    // ---------------------------------------------------------------------------------------------------------- //
                                    // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos
    
                                    $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
                                    $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte
                        
                                    // Variable para la validación del auxilio de transporte
                                    $valsubtrasp = $smlv * 2;
                        
                                    if(($basico<=$valsubtrasp) && ($aplicatransporte=="CHECKED"))
                                    {
                                        // Obtengo el ID del registro que se modificará
                                        $vsql = "SELECT detalleid
                                                   FROM detalleliquidacion 
                                                  WHERE conceptoid = 3  
                                                        AND pernominaid = ".$periodoidanterior."
                                                        AND terid = ".$terid."";
                                        $detalleid = $clase->SeleccionarUno($vsql);
                        
                                        // Obtengo la formula del subsidio de transporte
                                        $auxtrans = $_SESSION['N_AUXTRANS2020'];
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                                        $formulatransporte = $clase->SeleccionarUno($vsql);
                        
                                        eval("\$subsidiotransporte = $formulatransporte;");
                                        $subsidiotransporte = round($subsidiotransporte,0);
                                    }
                                    else
                                        $subsidiotransporte = 0;
    
                                    // ID transporte
                                    $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 3";
                                    $idtransporte = $clase->SeleccionarUno($vsql);
                            
                                    // Grabo el subsidio de transporte
                                    if($idtransporte!="")
                                        $vsql = "UPDATE detalleliquidacion SET 
                                                        devengados = ".$subsidiotransporte.",
                                                        valor = ".$diastrab."
                                                  WHERE detalleid = ".$idtransporte."";
                                    else
                                    {
                                        // Obtengo el valor del subsidio de transporte
                                        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
                            
                                        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                        $numreg = $clase->SeleccionarUno($vsql);
                            
                                        $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",3,".$periodoidanterior.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                                    }
                                    $clase->EjecutarSQL($vsql);
                                }
                                else
                                {
                                    $subsidiotransporte = 0;

                                    // ID transporte
                                    $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 3";
                                    $idtransporte = $clase->SeleccionarUno($vsql);

                                    // Grabo el subsidio de transporte
                                    if($idtransporte!="")
                                    {
                                        $vsql = "UPDATE detalleliquidacion SET 
                                                        devengados = ".$subsidiotransporte.",
                                                        valor = ".$diastrab."
                                                  WHERE detalleid = ".$idtransporte;
                                        $clase->EjecutarSQL($vsql);
                                    }

                                    // elimino el subsidio de transporte
                                    $vsql = "DELETE FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 3";
                                    $clase->EjecutarSQL($vsql);

                                    $sueldo = 0;
                                }

                                // ----------------------------------------------------------------------------------------------------------- //
                                // Ahora recalculo la pensión y la salud

                                // ----------------------------------------------------------------------------------------------------------- //
                                // Obtengo el total devengado por novedades
                                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                           FROM detalleliquidacion d
                                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                          WHERE d.terid = ".$terid."
                                                AND d.pernominaid = ".$periodoidanterior." 
                                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                                $totnovedades = $clase->SeleccionarUno($vsql);

                                $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                           FROM detallenomina d
                                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                          WHERE d.terid = ".$terid."
                                                AND d.pernominaid = ".$periodoidanterior." 
                                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                                $totrecargos = $clase->SeleccionarUno($vsql);
                        
                                // Actualizo el sueldo
                                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;                                

                                if($sueldodeducciones == 0)
                                {
                                    $vsql = "DELETE FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid IN (4,5)";
                                    $clase->EjecutarSQL($vsql);
                                }
                                else
                                {
                                    $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                                    $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                                    $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                                    
                                    if($epsid==NULL)                $epsid=0;
                                    if($pensionesid==NULL)          $pensionesid=0;
    
                                    $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                                    $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
                                    if($extralegal=="CHECKED")
                                    {
                                        $pension = 0;
                                        $salud = 0;
                                    }
                                    else
                                    {
                                        // Recalculo pensión y salud
                                        if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                            $pension = 0;
                                        else
                                        {
                                            // Obtengo la formula para el descuento por pensión
                                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                            $formulapension = $clase->SeleccionarUno($vsql);
                        
                                            // Calculo la pensión
                                            eval("\$pension = $formulapension;");
                                            $pension = round($pension,0);
                                        }
                        
                                        if(($epsid==37)||($aplicasalud!="CHECKED"))
                                            $salud = 0;
                                        else
                                        {
                                            // Obtengo la formula para el descuento de salud
                                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                            $formulasalud = $clase->SeleccionarUno($vsql);
                                            
                                            // Calculo la salud
                                            eval("\$salud = $formulasalud;");
                                            $salud = round($salud,0);
                                        }
                                    }
    
                                    //  ID pensión
                                    $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 4";
                                    $idpension = $clase->SeleccionarUno($vsql);
                        
                                    // Grabo la pensión
                                    if($idpension!="")
                                        $vsql = "UPDATE detalleliquidacion SET 
                                                        descuentos = ".$pension.",
                                                        saldo = ".$sueldodeducciones."
                                                  WHERE detalleid = ".$idpension."";
                                    else
                                    {
                                        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                        $numreg = $clase->SeleccionarUno($vsql);
                        
                                        $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoidanterior.",0,".$pension.",0,$sueldodeducciones)";
                                    }
                                    $clase->EjecutarSQL($vsql);
    
                                    // ID salud
                                    $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 5";
                                    $idsalud = $clase->SeleccionarUno($vsql);
                        
                                    // Grabo la salud
                                    if($idsalud!="")
                                        $vsql = "UPDATE detalleliquidacion SET 
                                                        descuentos = ".$salud.",
                                                        saldo = ".$sueldodeducciones."
                                                  WHERE detalleid = ".$idsalud."";
                                    else
                                    {
                                        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                        $numreg = $clase->SeleccionarUno($vsql);
                        
                                        $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoidanterior.",0,".$salud.",0,$sueldodeducciones)";
                                    }
                                    $clase->EjecutarSQL($vsql);
                                }

                                // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                                $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoidanterior." AND terid = ".$terid."";
                                $clase->EjecutarSQL($vsql);

                                // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
                                // Recalculo las primas, cesantías y vacaciones

                                // obtengo los parámetros de cálculo
                                $vsql41 = "SELECT cesantiasyearanterior FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $cesantiasyearanterior = $clase->SeleccionarUno($vsql41);

                                $vsql42 = "SELECT cesantiasyearactual FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $cesantiasyearactual = $clase->SeleccionarUno($vsql42);

                                $vsql43 = "SELECT intcesantiasyearanterior FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $intcesantiasyearanterior = $clase->SeleccionarUno($vsql43);

                                $vsql44 = "SELECT intcesantiasyearactual FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $intcesantiasyearactual = $clase->SeleccionarUno($vsql44);

                                $vsql45 = "SELECT vacaciones FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $vacaciones = $clase->SeleccionarUno($vsql45);

                                $vsql46 = "SELECT primasprimersemestre FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $primasprimersemestre = $clase->SeleccionarUno($vsql46);

                                $vsql47 = "SELECT primassegundosemestre FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $primassegundosemestre = $clase->SeleccionarUno($vsql47);                                

                                // Inicialización de variables
                                $diasps = 0;
                                $diasss = 0;

                                // $fecingreso = $clase->BDLockup($terid,'terceros','terid','fecingreso');             // fecha de ingreso

                                // fechas de ingreso y retiro
                                $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                                $idhistorico = $clase->SeleccionarUno($vsql18);

                                $vsql21 = "SELECT hc.fecingreso
                                             FROM histcontrato hc
                                            WHERE hc.terid = ".$terid." 
                                                  AND hc.id = ".$idhistorico;
                                $fecingreso = $clase->SeleccionarUno($vsql21);

                                $vsql21 = "SELECT hc.fecretiro 
                                             FROM histcontrato hc
                                            WHERE hc.terid = ".$terid." 
                                                  AND hc.id = ".$idhistorico;
                                $fecretiro = $clase->SeleccionarUno($vsql21);

                                $yearingreso = intval(substr($fecingreso,0,4));                                     // año de la fecha de ingreso

                                // // Obtengo el id del último contrato
                                // $vsql = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
                                // $id = $clase->SeleccionarUno($vsql);
                                // $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');

                                // if(($fecretiro == NULL) || ($fecretiro == '0000-00-00') || ($fecretiro == ''))
                                //     $fecretiro = $clase->BDLockup($terid,'terceros','terid','fecharetiro');
                                
                                // $sueldointegralact = $basico + $auxtrans;                                           // sueldo integral año actual

                                // validación del subsidio de transporte
                                $smlv = $_SESSION['N_SALMIN2020'];
                                $valtransporte = $smlv * 2;

                                if($basico > $valtransporte)
                                    $auxtrans = 0;
                                else
                                    $auxtrans = $_SESSION['N_AUXTRANS2020'];

                                // Determino si hubo un cambio de salario en los últimos tres meses
                                $tienecambio = tienecambiosalario($terid,$fecretiro);

                                if($tienecambio)
                                {
                                    $promsueldoact = calsueldopromedio($terid,$fecingreso);
                                    $basico = $promsueldoact;
                                }

                                // año anterior
                                $yearprev = date("Y") - 1;

                                if($yearingreso>$yearprev)
                                {
                                    $basicoant = 0;
                                    $auxtransant = 0;
                                    $diasyearant = 0;
                                    $sueldointegralant = 0;
                                }
                                else
                                {
                                    // máximo periodo del año anterior
                                    $vsql = " SELECT MAX(periodoid) AS periodoidant FROM periodosnomina WHERE YEAR(fechasta) = ".$yearprev." ";
                                    $periodoidant = $clase->SeleccionarUno($vsql);
                            
                                    // básico de año anterior            
                                    $vsql = "SELECT saldo 
                                               FROM hisdetallenomina 
                                              WHERE terid = ".$terid." 
                                                    AND pernominaid = ".$periodoidant." 
                                                    AND conceptoid IN (1,10,11,12,13,31,38,40,43)";
                                    $basicoant = $clase->SeleccionarUno($vsql);

                                    // ------------------------------------------------------------------------------------------- //
                                    $vsql25 = "SELECT MIN(periodoid) permin2
                                                 FROM periodosnomina 
                                                WHERE fecdesde >= '".$fecingreso."' 
                                                      AND YEAR(fecdesde) = ".$yearprev." 
                                                      AND cerrado = 'CHECKED' ";
                                    $permin2 = $clase->SeleccionarUno($vsql25);

                                    if(strlen($permin2) == 0)
                                    {
                                        $vsql25 = "SELECT MIN(periodoid) permin2
                                                     FROM periodosnomina 
                                                    WHERE fecdesde >= '".$fecingreso."'
                                                          AND cerrado = 'CHECKED' ";
                                        $permin2 = $clase->SeleccionarUno($vsql25);
                                        $permin2--;
                                    }
                                    
                                    $vsql26 = "SELECT MAX(periodoid) permax2
                                                 FROM periodosnomina 
                                                WHERE fecdesde >= '".$fecingreso."' 
                                                      AND YEAR(fecdesde) = ".$yearprev." 
                                                      AND cerrado = 'CHECKED' ";
                                    $permax2 = $clase->SeleccionarUno($vsql26);

                                    if(strlen($permax2) == 0)
                                        $permax2 = $permin2;

                                    // ------------------------------------------------------------------------------------------- //
                            
                                    if(($basicoant==0)||($basicoant==NULL))
                                    {
                                        $basicoant = 0;
                                        $auxtransant = 0;
                                        $diasyearant = 0;
                                        $sueldointegralant = 0;
                                    }
                                    else
                                    {
                                        // auxilio de transporte del año anterior
                                        $vsql = "SELECT saldo FROM hisdetallenomina WHERE conceptoid = 3 AND pernominaid = ".$periodoidant." AND terid = ".$terid;
                                        $auxtransant = $clase->SeleccionarUno($vsql);
                            
                                        // Sueldo integral del año anterior
                                        $sueldointegralant = $basicoant + $auxtransant;
                            
                                        // días laborados el año anterior
                                        $vsql = "SELECT periodoid
                                                   FROM periodosnomina
                                                  WHERE fecdesde <= '".$fecingreso."'
                                                        AND fechasta >= '".$fecingreso."'";
                                        $eneroant = $clase->SeleccionarUno($vsql);
                                
                                        $vsql = "SELECT SUM(valor) AS diasyearant 
                                                   FROM hisdetallenomina 
                                                  WHERE terid = ".$terid." 
                                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                        AND pernominaid BETWEEN ".$eneroant." AND ".$periodoidant."
                                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros 
                                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                                       AND periodoterceros.pernominaid BETWEEN ".$permin2." AND ".$permax2." 
                                                                                     AND periodoterceros.extralegal = 'CHECKED')";
                                        $diasyearant = $clase->SeleccionarUno($vsql);
                                    }
                                }

                                // ----------------------------------------------------------------------------------------------- //
                                // Días laborados en el primer trimestre del año actual
                                $yeartoday = date("Y");

                                $comienzoprimersemestre = $yeartoday."-01-01";
                                $finprimersemestre = $yeartoday."-06-30";

                                // si el empleado ingresó en este periodo
                                if($fecingreso>=$comienzoprimersemestre)
                                {            
                                    $vsql = " SELECT MAX(periodoid) AS primeroenero FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
                                    $primeroenero = $clase->SeleccionarUno($vsql);
                            
                                    $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
                                    $treintajunio = $clase->SeleccionarUno($vsql);
                            
                                    // Días en el histórico
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                                               FROM hisdetallenomina 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40)
                                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                                    $diasps = $clase->SeleccionarUno($vsql);
                            
                                    // Días en la liquidación        
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                               FROM detalleliquidacion 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
                                    $diasliq = $clase->SeleccionarUno($vsql);
                            
                                    $diasps += $diasliq;
                                }

                                if(($fecingreso<$comienzoprimersemestre)&&($diasyearant>0))
                                {
                                    $diasliq = 0;
                                    $vsql = " SELECT periodoid AS primeroenero FROM periodosnomina WHERE fecdesde = '".$comienzoprimersemestre."' ";
                                    $primeroenero = $clase->SeleccionarUno($vsql);

                                    $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
                                    $treintajunio = $clase->SeleccionarUno($vsql);
                            
                                    // Días en el histórico
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                                               FROM hisdetallenomina 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                                    $diasps = $clase->SeleccionarUno($vsql);
                            
                                    // Días en la liquidación        
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                               FROM detalleliquidacion 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40)
                                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
                                    $diasliq = $clase->SeleccionarUno($vsql);
                            
                                    $diasps += $diasliq;
                                }

                                // Días laborados en el segundo semestre del año
                                $inisegsemestre = $yeartoday."-07-01";
                                $finsegsemestre = $yeartoday."-12-31";

                                // si el empleado ingresó en este periodo
                                if($fecingreso>=$inisegsemestre)
                                {
                                    $vsql = " SELECT MAX(periodoid) AS primerojulio FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
                                    $primerojulio = $clase->SeleccionarUno($vsql);

                                    $vsql = " SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."' ";
                                    $treintayuno = $clase->SeleccionarUno($vsql);
                            
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss 
                                               FROM hisdetallenomina 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                                    $diasss = $clase->SeleccionarUno($vsql);
                            
                                    // Días en la liquidación        
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq 
                                               FROM detalleliquidacion 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
                                    $diasliq = $clase->SeleccionarUno($vsql);
                            
                                    $diasss += $diasliq;
                                }

                                if(($fecingreso<$inisegsemestre)&&($diasps>0))
                                {
                                    $vsql = "SELECT periodoid AS primerojulio FROM periodosnomina WHERE fecdesde = '".$inisegsemestre."'";
                                    $primerojulio = $clase->SeleccionarUno($vsql);

                                    $vsql = "SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."'";
                                    $treintayuno = $clase->SeleccionarUno($vsql);
                            
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss 
                                               FROM hisdetallenomina 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                                    $diasss = $clase->SeleccionarUno($vsql);
                            
                                    // Días en la liquidación
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq 
                                               FROM detalleliquidacion 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
                                    $diasliq = $clase->SeleccionarUno($vsql);
                            
                                    $diasss += $diasliq;
                                }

                                // Inicialización de variables
                                $pagocenact = 0;                            $cantidad = 0;                          $porcentaje = 0;                        $pagointereses = 0;
                                $pagovaca = 0;                              $diasvaca = 0;                          $diasprima = 0;                         $pagoprimasps = 0;
                                $lbprocesado = false;                       $pagocesant = 0;                        $cantidadact = 0;                       $cantidadant = 0;
                                $pagocesantias = 0;                         $interesesact = 0;                      $interesesant = 0;                      $pagoprimasss = 0;
                                $pagoprimas = 0;                            $recarnonocturno = 0;                   $ultimobasico = 0;                      $auxtrans = $_SESSION['N_AUXTRANS2020'];

                                // ---------------------------------------------------------- //
                                // Cálculo de cesantías
                                if(($cesantiasyearactual == "SI")||($cesantiasyearanterior == "SI")||($intcesantiasyearactual == "SI")||($intcesantiasyearanterior == "SI"))
                                {
                                    // Cálculo de cesantías del año actual
                                    if($cesantiasyearactual == "SI")
                                    {
                                        $cantidadact = $diasps + $diasss;
                                        $pagocenact = ($basico + $auxtrans) * $cantidadact / 360;
                                    }
                                    else
                                    {
                                        $pagocenact = 0;
                                        $cantidadact = 0;
                                    }
                                    
                                    // Cálculo de cesantías del año anterior
                                    if($cesantiasyearanterior == "SI")
                                    {
                                        $pagocesant = ($sueldointegralant + $auxtrans) * $diasyearant / 360;
                                        $cantidadant = $diasyearant;
                                    }
                                    else
                                    {
                                        $pagocesant = 0;
                                        $cantidadant = 0;
                                    }
                                    
                                    // sub totales
                                    $pagocesantias = $pagocenact + $pagocesant;
                                    $pagocesantias = round($pagocesantias,2);
                                    $cantidad = $cantidadact + $cantidadant;
                                    $porcentaje = 12;

                                    // Intereses año actual
                                    if($intcesantiasyearactual == "SI")
                                        $interesesact = (($pagocenact * ($diasps + $diasss)) * 0.12 / 360);
                                    else
                                        $interesesact = 0;

                                    // intereses del año anterior
                                    if($intcesantiasyearanterior == "SI")
                                        $interesesant = (($pagocesant * $diasyearant) * 0.12 / 360);
                                    else
                                        $interesesant = 0;

                                    $pagointereses = $interesesact + $interesesant;
                                    $pagointereses = round($pagointereses,2);

                                    // Valido la existencia de este concepto
                                    $repetido = 0;          $vsql22 = "";               $vsql23 = "";               $vsql24 = "";

                                    $vsql22 = "SELECT COUNT(*) repetido FROM liquidacion WHERE terid = ".$terid." AND tipo = 'cesantias' AND periodonomina = '".$codperiodo."'";
                                    $repetido = $clase->SeleccionarUno($vsql22);

                                    if($repetido > 0)
                                    {
                                        $vsql23 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND tipo = 'cesantias'  AND periodonomina = '".$codperiodo."'";
                                        $idliquidacion = $clase->SeleccionarUno($vsql23);

                                        $vsql24 = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
                                        $clase->EjecutarSQL($vsql24);
                                    }

                                    // Guardo en la tabla
                                    $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                                            VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcentaje.",".$pagointereses.")";
                                    $clase->EjecutarSQL($vsql);

                                }

                                // ---------------------------------------------------------- //
                                // Cálculo de vacaciones
                                if($vacaciones == "SI")
                                {
                                    // // sueldo básico
                                    // // $basico = $clase->BDLockup($terid,'terceros','terid','basico');
                                    // $diasvaca = $diasyearant + $diasps + $diasss;


                                    // Determino si hay vacaciones canceladas previamente
                                    $vsql22 = "SELECT MIN(periodoid) permin
                                                 FROM periodosnomina 
                                                WHERE fecdesde >= '".$fecingreso."' 
                                                      AND cerrado = 'CHECKED' ";
                                    $permin = $clase->SeleccionarUno($vsql22);

                                    // Determino si hay vacaciones canceladas previamente
                                    $vsql23 = "SELECT MAX(periodoid) permax
                                                 FROM periodosnomina 
                                                WHERE fecdesde >= '".$fecingreso."' 
                                                      AND cerrado = 'CHECKED' ";
                                    $permax = $clase->SeleccionarUno($vsql23);

                                    $vsql24 = "SELECT pernominaid pervacaciones
                                                 FROM hisdetallenomina 
                                                WHERE terid = ".$terid."         
                                                      AND conceptoid = 38 
                                                      AND pernominaid >= ".$permin." AND pernominaid <= ".$permax."";
                                    $pervacaciones = $clase->SeleccionarUno($vsql24);

                                    if(strlen($pervacaciones) > 0)
                                    {
                                        $pervacaciones++;

                                        $vsql31 = "SELECT IFNULL(SUM(valor),0) AS diasvaca  
                                                     FROM hisdetallenomina 
                                                    WHERE terid = ".$terid."         
                                                          AND (pernominaid >= ".$pervacaciones." AND pernominaid <= ".$permax.")  
                                                          AND conceptoid IN (1,10,11,12,13,23,31,38,40)";
                                        $diasvaca = $clase->SeleccionarUno($vsql31);
                                    }
                                    else
                                        $diasvaca = $diasyearant + $diasps + $diasss;

                                    // sueldo básico
                                    $vsql19 = "SELECT saldo FROM detalleliquidacion WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                                    $ultimobasico = $clase->SeleccionarUno($vsql19);
                                    
                                    if($ultimobasico == 0)
                                    {
                                        $vsql20 = "SELECT MAX(pernominaid) FROM detallenomina WHERE conceptoid = 1 AND terid = ".$terid;
                                        $ultimoperbasico = $clase->SeleccionarUno($vsql20);
                        
                                        $vsql19 = "SELECT saldo FROM detallenomina WHERE conceptoid = 1 AND pernominaid = ".$ultimoperbasico." AND terid = ".$terid;
                                        $ultimobasico = $clase->SeleccionarUno($vsql19);
                                    }

                                    // busco recargo nocturno
                                    $recarnonocturno = buscarrecargonoc($terid,$periodoid);

                                    $pagovaca = ($ultimobasico + $recarnonocturno) * $diasvaca / 720;
                                    $pagovaca = round($pagovaca,2);

                                    // Valido la existencia de este concepto
                                    $repetido = 0;          $vsql22 = "";               $vsql23 = "";               $vsql24 = "";
                                    
                                    $vsql22 = "SELECT COUNT(*) repetido FROM liquidacion WHERE terid = ".$terid." AND tipo = 'vacaciones'";
                                    $repetido = $clase->SeleccionarUno($vsql22);

                                    if($repetido > 0)
                                    {
                                        $vsql23 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND tipo = 'vacaciones'";
                                        $idliquidacion = $clase->SeleccionarUno($vsql23);

                                        $vsql24 = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
                                        $clase->EjecutarSQL($vsql24);
                                    }

                                    // Almaceno en la tabla
                                    $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                                  VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovaca.",".$diasvaca.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }

                                // ---------------------------------------------------------- //
                                // Cálculo de primas
                                if(($primasprimersemestre == "SI") || ($primassegundosemestre == "SI"))
                                {
                                    // Primas primer semestre
                                    if($primasprimersemestre == "SI")
                                    {
                                        $diasprima += $diasps;
                                        $pagoprimasps = ($basico + $auxtrans) * $diasps / 360;
                                    }

                                    // Primas segundo semestre
                                    if($primassegundosemestre == "SI")
                                    {
                                        $diasprima += $diasss;
                                        $pagoprimasss = ($basico + $auxtrans) * $diasss / 360;
                                    }

                                    $pagoprimas = $pagoprimasps + $pagoprimasss;
                                    $pagoprimas = round($pagoprimas,2);

                                    // Valido la existencia de este concepto
                                    $repetido = 0;          $vsql22 = "";               $vsql23 = "";               $vsql24 = "";

                                    $vsql22 = "SELECT COUNT(*) repetido FROM liquidacion WHERE terid = ".$terid." AND tipo = 'primas'  AND periodonomina = '".$codperiodo."'";
                                    $repetido = $clase->SeleccionarUno($vsql22);

                                    if($repetido > 0)
                                    {
                                        $vsql23 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND tipo = 'primas'  AND periodonomina = '".$codperiodo."'";
                                        $idliquidacion = $clase->SeleccionarUno($vsql23);

                                        $vsql24 = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
                                        $clase->EjecutarSQL($vsql24);
                                    }                                    

                                    // Almaceno en la tabla
                                    $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                                  VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimas.",".$diasprima.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresliquidacion.txt";                        // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresliquidacion.txt";                                        // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                    // Grabas
            fclose($fd);                                                                // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);

            $descripcion = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las licencias para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados licencias para el periodo $descripcion");
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererroresliquidaciones
    // Creación: 10/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que muestra los posibles registros no almacenados en el último 
    //              proceso de importación desde una hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererroresliquidaciones")
    {
        $codperiodo = $_GET['codperiodo'];

        // Inicialización de variables
        $archivoerror = "reportes/erroresliquidacion.txt";
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        $txt = trim(str_replace("<br />","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Documentos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
                   <a href="importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'"> 
                    <input type="button" value="aceptar" class="button blue"> 
                   </a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarocasionalesliq
    // Creación: 10/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel en la cual se 
    //              importarán los descuentos ocasionales para liquidaciones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarocasionalesliq")
    {
        $codperiodo = $_GET['codperiodo'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b> </td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor diríjase al servidor </font><br> 
        //                <font color=blue> 192.168.14.248:9999 </font> <br>
        //                <font color=red>o al servidor </font> <br> 
        //                <font color=blue> dromedicas.sytes.net:9996 </font> <br>
        //                <font color=red> para poder importar estos datos </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">        
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'" id="theform" enctype="multipart/form-data">
        //                 <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
        //                </form> 
        //               </td>    
        //              </tr>
        //             </table>';
        // else
        // {
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

            // Combo de Periodos
            $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto
                                    FROM conceptosnomina 
                                   WHERE montoocasional = 'CHECKED'
                                ORDER BY conceptoid ASC";
            $params = ' class="Texto12" ';
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar descuentos ocasionales <br> de liquidaciones <font color="blue">'.strtolower($desperiodo).'</font></b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarocasionalesliq2" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       concepto: '.$clase->CrearComboEsp("conceptoid",$vsqlcomboconcepto,"conceptoid","nomperiodo",$conceptoid,"N",$params).'
                       <br> <br>
                       <input type="file" name="excel" /><br><br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            // estructura de hoja de Excel
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Monto (solo n&uacute;meros) </td> </tr>                 
                    </table>';
    
            // imagen de ejemplo
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocompras.png" width="260" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        // }
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarocasionalesliq2
    // Creación: 10/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los descuentos ocasionales para liquidación 
    //              importados desde una hoja de Excel 
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarocasionalesliq2")
    {
		set_time_limit(0);
		extract($_POST);
		$conceptoid = $_POST["conceptoid"];
        $codperiodo = $_POST["codperiodo"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)&&(strlen($_DATOS_EXCEL[$i]['monto']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;

            // Nombres del concepto y del periodo
            $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = ''.str_pad($nomconcepto,1,"").' DE LIQUIDACION'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($desperiodo,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $valreg = 0;
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");

                if($terid != "")
                {
                    $monto = $_DATOS_EXCEL[$j]['monto'];

                    // llamado al procedimiento para validar el monto
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($monto);
                    if($lb_valido)
                    {
                        $listaperiodos = generarlistaper($codperiodo);

                        // obtengo los parámetros de cálculo
                        $vsql48 = "SELECT nroquincena FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                        $nroquincena = $clase->SeleccionarUno($vsql48);

                        // determinino la quincena a la cual corresponde el concepto
                        if($nroquincena == 1)
                            $periodoid = intval(substr($listaperiodos,0,2));

                        if($nroquincena == 2)
                            $periodoid = intval(substr($listaperiodos,3,2));

                        // Valido que el concepto asignado a un empleado no esté repetido
                        $vsql3 = "SELECT count(*) AS valreg
                                    FROM detalleliquidacion
                                   WHERE pernominaid = ".$periodoid." 
                                         AND terid = ".$terid." 
                                         AND conceptoid = ".$conceptoid;
                        $valreg = $clase->SeleccionarUno($vsql3);

                        if($valreg==0)
                        {
                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $vsql = "SELECT MAX(detalleid) FROM detalleliquidacion";
                            $numeroid = $clase->SeleccionarUno($vsql);
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);

                            // Incremento el contados de registros almacenados
                            if(mysql_affected_rows() == 1)
                            {
                                $grabados++;
                                $lbgrabo = true;
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresliquidacion.txt";                        // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);         // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresliquidacion.txt";                                            // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                                 // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                        // Grabas
            fclose($fd);                                                                    // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los registros de $nomconcepto para el periodo $desperiodo");
            else
                $clase->Aviso(1,"Se cargaron $grabados registros de $nomconcepto para el periodo $desperiodo");
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarlibranzasliq
    // Creación: 12/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con las 
    //              libranzas de liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarlibranzasliq")
    {
        $codperiodo = $_GET['codperiodo'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b></td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor diríjase al servidor </font><br> 
        //                <font color=blue> 192.168.14.248:9999 </font> <br>
        //                <font color=red>o al servidor </font> <br> 
        //                <font color=blue> dromedicas.sytes.net:9996 </font> <br>
        //                <font color=red> para poder importar estos datos </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">        
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'" id="theform" enctype="multipart/form-data">
        //                 <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
        //                </form> 
        //               </td>    
        //              </tr>
        //             </table>';
        // else
        // {
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Importar libranzas<br> de liquidaciones <font color="blue">'.strtolower($desperiodo).'</font> </b> <br><br> </td>
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarlibranzasliq2" id="theform" enctype="multipart/form-data">
                        <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                        <input type="file" name="excel" /><br><br>
                        <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                        <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>
                     </tr>
                    </table>';

            // Descripción de la estructura de la hoja de Excel
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Monto (solo n&uacute;meros) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Tipo: </td> </tr> 
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>14</b></font> OPTICA DE TODOS <font color="blue"><b>15</b></font> OPTICA PRACSO <font color="blue"><b>16</b></font> PROGRESSA
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>17</b></font> COOPTELECUC <font color="blue"><b>18</b></font> DAVIVIENDA <font color="blue"><b>19</b></font> RECORDAR
                      </td>
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp;  <font color="blue"><b>20</b></font> LOS OLIVOS <font color="blue"><b>21</b></font> LA ESPERANZA 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>27</b></font> SEGURO DE VIDA SURAMERICANA <font color="blue"><b>29</b></font> BANCOLOMBIA
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>30</b></font> EMBARGO <font color="blue"><b>42</b></font> OPTICA MM
                      </td> 
                     </tr>
                    </table>';
        
            // Advertencia de la extensión de la hoja de Excel 
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocompras2.png" width="280" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        // }
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarlibranzasliq2
    // Creación: 12/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena las libranzas de liquidación desde la hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarlibranzasliq2")
    {
		set_time_limit(0);
		extract($_POST);
        $codperiodo = $_POST["codperiodo"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['conceptoid'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)||(strlen($_DATOS_EXCEL[$i]['monto']) == 0)||(strlen($_DATOS_EXCEL[$i]['conceptoid']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;

            // Nombre del periodo
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');            

            // carpeta
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados            
            $nocedulas = 'LIBRANZAS DE LIQUIDACION'.Chr(13).Chr(10);
            $nocedulas.= ' '.str_pad($desperiodo,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $dni = $_DATOS_EXCEL[$j]['dni'];                
                $valreg = 0;
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");

                if($terid != "")
                {
                    $monto = $_DATOS_EXCEL[$j]['monto'];

                    // llamado al procedimiento para validar el monto
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($monto);
                    if($lb_valido)
                    {
                        $conceptoid = $_DATOS_EXCEL[$j]['conceptoid'];

                        // Validación del concepto libranza
                        $lb_valido2 = false;
                        $lb_valido2 = valida_concepto($conceptoid);

                        if($lb_valido2)
                        {
                            $listaperiodos = generarlistaper($codperiodo);

                            // obtengo los parámetros de cálculo
                            $vsql48 = "SELECT nroquincena FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                            $nroquincena = $clase->SeleccionarUno($vsql48);
    
                            // determinino la quincena a la cual corresponde el concepto
                            if($nroquincena == 1)
                                $periodoid = intval(substr($listaperiodos,0,2));
    
                            if($nroquincena == 2)
                                $periodoid = intval(substr($listaperiodos,3,2));

                            // Valido que el concepto asignado a un empleado no esté repetido
                            $vsql3 = "SELECT count(*) AS valreg
                                        FROM detalleliquidacion 
                                       WHERE pernominaid = ".$periodoid."
                                             AND terid = ".$terid."
                                             AND conceptoid = ".$conceptoid;
                            $valreg = $clase->SeleccionarUno($vsql3);
    
                            if($valreg==0)
                            {
                                // Obtengo el número de registros de la tabla detalleliquidacion
                                $vsql = "SELECT MAX(detalleid) FROM detalleliquidacion";
                                $numeroid = $clase->SeleccionarUno($vsql);
                        
                                // Incremento el ID
                                $numeroid++;
        
                                // Determino el tipo de concepto
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
        
                                // Construyo la instrucción
                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                  VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                  VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
        
                                // Almaceno en la tabla
                                $clase->EjecutarSQL($vsql);
                
                                // Incremento el contados de registros almacenados
                                if(mysql_affected_rows() >= 1)
                                {
                                    $grabados++;
                                    $lbgrabo = true;
                                }
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresliquidacion.txt";                        // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }                
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresliquidacion.txt";                                        // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                    // Grabas
            fclose($fd);                                                                // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);            
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los registros para el periodo $desperiodo");
            else
                $clase->Aviso(1,"Se cargaron $grabados registros para el periodo $desperiodo");            
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo");
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: recalcularliquidaciones
    // Creación: 16/02/2024		última modificación: 05/03/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que recalcula las liquidaciones del periodo
    // Última modificación: Incremento de los días de la quincena y los días del primer 
    //                      semestre en caso de ser un año bisiesto
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "recalcularliquidaciones")
    {
        $codperiodo = $_POST["codperiodo"];
        $periodoidvaca = $_POST["periodoid"];

        $listaperiodos = generarlistaper($codperiodo);

        $vsql15 = "SELECT * FROM parametrosliquidacion p WHERE p.codperiodo = '".$codperiodo."' AND p.norecalcular = ''";
        $conex = $clase->Conectar();

        $result15 = mysql_query($vsql15,$conex);
        $cant15 = mysql_num_rows($result15);
        if($cant15 > 0)
        {
            $regquincena = 0;
            $auxtrans = $_SESSION['N_AUXTRANS2020'];
            $vsql10 = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
            $formulatransporte = $clase->SeleccionarUno($vsql10);
            $smlv = $_SESSION['N_SALMIN2020'];
            $valsubtrasp = $smlv * 2;
            $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

            while($row15 = mysql_fetch_array($result15))
            {
                $terid = $row15['terid'];

                // determino si tiene quincena
                $vsql21 = "SELECT COUNT(*) regquincena FROM detallenomina WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos)";
                $regquincena = $clase->SeleccionarUno($vsql21);

                if($regquincena > 0)
                {
                    // obtengo los parámetros de cálculo
                    $nroquincena = $row15['nroquincena'];

                    // determinino la quincena a la cual corresponde el concepto
                    if($nroquincena == 1)
                        $periodoid = intval(substr($listaperiodos,0,2));

                    if($nroquincena == 2)
                        $periodoid = intval(substr($listaperiodos,3,2));                        

                    // // días trabajados
                    // $vsql16 = "SELECT valor FROM detalleliquidacion WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                    // $diastrab = $clase->SeleccionarUno($vsql16);

                    $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                    $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

                    // Obtengo el salario básico del empleado
                    $vsql17 = "SELECT hc.ultsueldo 
                                 FROM histcontrato hc
                                WHERE hc.terid = ".$terid." 
                                      AND hc.id = (SELECT MAX(id)
                                                     FROM histcontrato
                                                    WHERE terid = ".$terid.")";
                    $basico = $clase->SeleccionarUno($vsql17);

                    // fechas de ingreso y retiro
                    $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                    $idhistorico = $clase->SeleccionarUno($vsql18);

                    $vsql21 = "SELECT hc.fecingreso
                                 FROM histcontrato hc
                                WHERE hc.terid = ".$terid." 
                                      AND hc.id = ".$idhistorico;
                    $fecingreso = $clase->SeleccionarUno($vsql21);

                    $vsql21 = "SELECT hc.fecretiro 
                                 FROM histcontrato hc
                                WHERE hc.terid = ".$terid." 
                                      AND hc.id = ".$idhistorico;
                    $fecretiro = $clase->SeleccionarUno($vsql21);

                    // condición del empleado
                    $idcondicion = $clase->BDLockup($idhistorico,'histcontrato','id','idcondicion');

                    if($idcondicion == 0)
                        $idcondicion = $clase->BDLockup($terid,'terceros','terid','idcondicion');

                    if($idcondicion == 3)
                        $extralegal = "CHECKED";
                    else
                        $extralegal = "";

                    // previsión del año bisiesto
                    $yearbisiesto = date("Y");
                    $fechabisiesto = date("Y")."-02-29";

                    if($fecretiro == $fechabisiesto)
                    {
                        $diastrab++;

                        $vsql4 = "DELETE FROM detalleliquidacion WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                        $clase->EjecutarSQL($vsql4);
                        
                        $basico = $clase->BDLockup($terid,'terceros','terid','basico');             // salario básico

                        // Obtengo la formula del sueldo
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                        $formulabasico = $clase->SeleccionarUno($vsql);

                        // Calculo el sueldo básico
                        eval("\$sueldo = $formulabasico;");
                        $sueldo = round($sueldo,0);
                        
                        $vsql1 = "INSERT INTO detalleliquidacion (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) VALUES (".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",".$basico.")";
                        $clase->EjecutarSQL($vsql1);
                    }

                    // Cálculo los días trabajados en caso de que el empleado haya ingresado durante este periodo
                    if(($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta))
                    {
                        $diastrab = 0;

                        // Procedo a calcular los días que trabajó durante el periodo
                        $fecha1= new DateTime($fecingreso);
                        $fecha2= new DateTime($fechasta);
                        $diff = $fecha1->diff($fecha2);
                        
                        $difendias = $diff->days;
                        $diastrab = $difendias + 1;
    
                        $diadesde = substr($fecdesde, -2);
                        if($diadesde=="16")
                        {
                            $fechaEntera = strtotime($fechasta);
                            $valdias = date("d", $fechaEntera);
                            if($valdias=="28")          $diastrab += 2;
                            if($valdias=="29")          $diastrab += 1;
                            if($valdias=="31")          $diastrab -= 1;
                        }

                        $diastrab2 = $diastrab;
                    }

                    // Valido si la fecha de retiro está dentro del rango de periodo
                    if(($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta))
                    {
                        $diastrab = 0;

                        // Procedo a calcular los días que trabajó durante el periodo
                        $fecha1= new DateTime($fecdesde);
                        $fecha2= new DateTime($fecretiro);
                        $diff = $fecha1->diff($fecha2);
                        
                        $difendias = $diff->days;
                        $diastrab = $difendias + 1;

                        $diastrab2 = $diastrab;
                    }                                

                    // valido si el empleado tiene fecha de ingreso y retiro dentro del periodo
                    if((($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta)) && (($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta)))
                    {
                        $diastrab = 0;

                        // Procedo a calcular los días que trabajó durante el periodo
                        $fecha1= new DateTime($fecingreso);
                        $fecha2= new DateTime($fecretiro);
                        $diff = $fecha1->diff($fecha2);
                        
                        $difendias = $diff->days;
                        $diastrab = $difendias + 1;

                        $diastrab2 = $diastrab;
                    }

                    if($diastrab >= 16)
                        $diastrab = 15;

                    if($diastrab2 >= 16)
                        $diastrab2 = 15;                                    

                    // ---------------------------------------------------------------------- //

                    // Recalculo el subsidio de transporte
                    if($diastrab == 0)
                    {
                        $vsql = "DELETE FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 3 AND pernominaid = ".$periodoid;
                        $clase->EjecutarSQL($vsql);
                    }
                    else
                    {
                        $basico = $clase->BDLockup($terid,'terceros','terid','basico');             // salario básico

                        // Obtengo la formula del sueldo
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                        $formulabasico = $clase->SeleccionarUno($vsql);

                        // Calculo el sueldo básico
                        eval("\$sueldo = $formulabasico;");
                        $sueldo = round($sueldo,0);

                        $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
                        $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte

                        if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                        {
                            eval("\$subsidiotransporte = $formulatransporte;");
                            $subsidiotransporte = round($subsidiotransporte,0);

                            // ID transporte
                            $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                            $idtransporte = $clase->SeleccionarUno($vsql);

                            if(strlen($idtransporte) == 0)
                            {                    
                                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                $numreg = $clase->SeleccionarUno($vsql);
                    
                                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                            }
                            else
                                $vsql = "UPDATE detalleliquidacion SET devengados = ".$subsidiotransporte." WHERE detalleid = ".$idtransporte."";                    

                            $clase->EjecutarSQL($vsql);
                        }
                        else
                        {
                            $vsql = "DELETE FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 3 AND pernominaid = ".$periodoid;
                            $clase->EjecutarSQL($vsql);
                        }
                    }

                    // Recalculo la salud y la pensión

                    // Obtengo el total devengado por novedades
                    $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                               FROM detalleliquidacion d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.eslicencia = 'CHECKED' AND c.tipodc = 'C')";
                    $totnovedades = $clase->SeleccionarUno($vsql);

                    // sueldo
                    $vsql66 = "SELECT devengados FROM detalleliquidacion WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                    $sueldo = $clase->SeleccionarUno($vsql66);

                    $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                               FROM detallenomina d
                                    INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                              WHERE d.terid = ".$terid."
                                    AND d.pernominaid = ".$periodoid." 
                                    AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                    $totrecargos = $clase->SeleccionarUno($vsql);
            
                    $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                    if($sueldodeducciones == 0)
                    {
                        $vsql = "DELETE FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid IN (4,5)";
                        $clase->EjecutarSQL($vsql);
                    }
                    else
                    {
                        // $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                        $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                        $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                        
                        if($epsid==NULL)                $epsid=0;
                        if($pensionesid==NULL)          $pensionesid=0;

                        $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                        $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

                        if($extralegal=="CHECKED")
                        {
                            $pension = 0;
                            $salud = 0;
                        }
                        else
                        {
                            // Recalculo pensión y salud
                            if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                $pension = 0;
                            else
                            {
                                // Obtengo la formula para el descuento por pensión
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                $formulapension = $clase->SeleccionarUno($vsql);
            
                                // Calculo la pensión
                                eval("\$pension = $formulapension;");
                                $pension = round($pension,0);
                            }
            
                            if(($epsid==37)||($aplicasalud!="CHECKED"))
                                $salud = 0;
                            else
                            {
                                // Obtengo la formula para el descuento de salud
                                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                $formulasalud = $clase->SeleccionarUno($vsql);
                                
                                // Calculo la salud
                                eval("\$salud = $formulasalud;");
                                $salud = round($salud,0);
                            }
                        }

                        //  ID pensión
                        $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                        $idpension = $clase->SeleccionarUno($vsql);
            
                        // Grabo la pensión
                        if($idpension!="")
                            $vsql = "UPDATE detalleliquidacion SET 
                                            descuentos = ".$pension.",
                                            saldo = ".$sueldodeducciones."
                                      WHERE detalleid = ".$idpension."";
                        else
                        {
                            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                            $numreg = $clase->SeleccionarUno($vsql);
            
                            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                        }
                        $clase->EjecutarSQL($vsql);

                        // ID salud
                        $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                        $idsalud = $clase->SeleccionarUno($vsql);
            
                        // Grabo la salud
                        if($idsalud!="")
                            $vsql = "UPDATE detalleliquidacion SET 
                                            descuentos = ".$salud.",
                                            saldo = ".$sueldodeducciones."
                                      WHERE detalleid = ".$idsalud."";
                        else
                        {
                            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                            $numreg = $clase->SeleccionarUno($vsql);
            
                            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                        }
                        $clase->EjecutarSQL($vsql);
                    }

                    // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                    $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoid." AND terid = ".$terid."";
                    $clase->EjecutarSQL($vsql);
                }

                // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
                // Recalculo las primas, cesantías y vacaciones

                // obtengo los parámetros de cálculo
                $cesantiasyearanterior = $row15['cesantiasyearanterior'];
                $cesantiasyearactual = $row15['cesantiasyearactual'];
                $intcesantiasyearanterior = $row15['intcesantiasyearanterior'];
                $intcesantiasyearactual = $row15['intcesantiasyearactual'];
                $vacaciones = $row15['vacaciones'];
                $primasprimersemestre = $row15['primasprimersemestre'];
                $primassegundosemestre = $row15['primassegundosemestre'];

                // Inicialización de variables
                $diasps = 0;
                $diasss = 0;

                // año de la fecha de ingreso
                $yearingreso = intval(substr($fecingreso,0,4));

                // validación del subsidio de transporte
                $smlv = $_SESSION['N_SALMIN2020'];
                $valtransporte = $smlv * 2;

                if($basico > $valtransporte)
                    $auxtrans = 0;
                else
                    $auxtrans = $_SESSION['N_AUXTRANS2020'];

                // ------------------------------------------------------------------------------------------- //
                // Determino si hubo un cambio de salario en los últimos tres meses
                $tienecambio = tienecambiosalario($terid,$fecretiro);

                if($tienecambio)
                {
                    $promsueldoact = calsueldopromedio($terid,$fecingreso);
                    $sueldointegralact = $promsueldoact + $auxtrans;
                }
                else
                    $sueldointegralact = $basico + $auxtrans;

                // año anterior
                $yearprev = date("Y") - 1;

                if($yearingreso>$yearprev)
                {
                    $basicoant = 0;
                    $auxtransant = 0;
                    $diasyearant = 0;
                    $sueldointegralant = 0;
                }
                else
                {
                    // máximo periodo del año anterior
                    $vsql = " SELECT MAX(periodoid) AS periodoidant FROM periodosnomina WHERE YEAR(fechasta) = ".$yearprev." ";
                    $periodoidant = $clase->SeleccionarUno($vsql);
            
                    // básico de año anterior            
                    $vsql = "SELECT saldo 
                               FROM hisdetallenomina 
                              WHERE terid = ".$terid." 
                                    AND pernominaid = ".$periodoidant." 
                                    AND conceptoid IN (1,10,11,12,13,31,38,40,43)";
                    $basicoant = $clase->SeleccionarUno($vsql);

                    // ------------------------------------------------------------------------------------------- //
                    $vsql25 = "SELECT MIN(periodoid) permin2
                                 FROM periodosnomina 
                                WHERE fecdesde >= '".$fecingreso."' 
                                      AND YEAR(fecdesde) = ".$yearprev." 
                                      AND cerrado = 'CHECKED' ";
                    $permin2 = $clase->SeleccionarUno($vsql25);
                    
                    $vsql26 = "SELECT MAX(periodoid) permax2
                                 FROM periodosnomina 
                                WHERE fecdesde >= '".$fecingreso."' 
                                      AND YEAR(fecdesde) = ".$yearprev." 
                                      AND cerrado = 'CHECKED' ";
                    $permax2 = $clase->SeleccionarUno($vsql26);
                    // ------------------------------------------------------------------------------------------- //                    
            
                    if(($basicoant==0)||($basicoant==NULL))
                    {
                        $basicoant = 0;
                        $auxtransant = 0;
                        $diasyearant = 0;
                        $sueldointegralant = 0;
                    }
                    else
                    {
                        // auxilio de transporte del año anterior
                        $vsql = "SELECT saldo FROM hisdetallenomina WHERE conceptoid = 3 AND pernominaid = ".$periodoidant." AND terid = ".$terid;
                        $auxtransant = $clase->SeleccionarUno($vsql);
            
                        // Sueldo integral del año anterior
                        $sueldointegralant = $basicoant + $auxtransant;
            
                        // días laborados el año anterior
                        $vsql = "SELECT periodoid
                                   FROM periodosnomina
                                  WHERE fecdesde <= '".$fecingreso."'
                                        AND fechasta >= '".$fecingreso."'";
                        $eneroant = $clase->SeleccionarUno($vsql);
                
                        $vsql = "SELECT SUM(valor) AS diasyearant 
                                   FROM hisdetallenomina 
                                  WHERE terid = ".$terid." 
                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                        AND pernominaid BETWEEN ".$eneroant." AND ".$periodoidant." 
                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                  FROM periodoterceros 
                                                                 WHERE periodoterceros.terid = ".$terid." 
                                                                       AND periodoterceros.pernominaid BETWEEN ".$permin2." AND ".$permax2." 
                                                                       AND periodoterceros.extralegal = 'CHECKED')";
                        $diasyearant = $clase->SeleccionarUno($vsql);
                    }
                }

                // ----------------------------------------------------------------------------------------------- //
                // Días laborados en el primer trimestre del año actual
                $yeartoday = date("Y");

                $comienzoprimersemestre = $yeartoday."-01-01";
                $finprimersemestre = $yeartoday."-06-30";

                // si el empleado ingresó en este periodo
                if($fecingreso>=$comienzoprimersemestre)
                {            
                    $vsql = "SELECT MAX(periodoid) AS primeroenero FROM periodosnomina WHERE fecdesde <= '".$fecingreso."'";
                    $primeroenero = $clase->SeleccionarUno($vsql);
            
                    $vsql = "SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."'";
                    $treintajunio = $clase->SeleccionarUno($vsql);
            
                    // Días en el histórico
                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                               FROM hisdetallenomina 
                              WHERE terid = ".$terid." 
                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio." 
                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                              FROM periodoterceros
                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                    $diasps = $clase->SeleccionarUno($vsql);

                    // --------------------------------------------------- //
                    // $yearbisiesto = date("Y");
                    // $fechabisiesto = date("Y")."-02-29";

                    // if($fecretiro == $fechabisiesto)
                    //     $diasps++;
                    // --------------------------------------------------- //                    
            
                    // Días en la liquidación        
                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                               FROM detalleliquidacion 
                              WHERE terid = ".$terid." 
                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
                    $diasliq = $clase->SeleccionarUno($vsql);
            
                    $diasps += $diasliq;
                }

                if(($fecingreso<$comienzoprimersemestre)&&($diasyearant>0))
                {
                    $diasliq = 0;
                    $vsql = "SELECT periodoid AS primeroenero FROM periodosnomina WHERE fecdesde = '".$comienzoprimersemestre."'";
                    $primeroenero = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."'";
                    $treintajunio = $clase->SeleccionarUno($vsql);
            
                    // Días en el histórico
                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                               FROM hisdetallenomina 
                              WHERE terid = ".$terid." 
                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                              FROM periodoterceros
                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                    $diasps = $clase->SeleccionarUno($vsql);
            
                    // Días en la liquidación        
                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                               FROM detalleliquidacion 
                              WHERE terid = ".$terid." 
                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40)
                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
                    $diasliq = $clase->SeleccionarUno($vsql);
            
                    $diasps += $diasliq;
                }

                // Días laborados en el segundo semestre del año
                $inisegsemestre = $yeartoday."-07-01";
                $finsegsemestre = $yeartoday."-12-31";

                // si el empleado ingresó en este periodo
                if($fecingreso>=$inisegsemestre)
                {
                    $vsql = " SELECT MAX(periodoid) AS primerojulio FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
                    $primerojulio = $clase->SeleccionarUno($vsql);

                    $vsql = " SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."' ";
                    $treintayuno = $clase->SeleccionarUno($vsql);
            
                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                               FROM hisdetallenomina 
                              WHERE terid = ".$terid." 
                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                              FROM periodoterceros
                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                    $diasss = $clase->SeleccionarUno($vsql);
            
                    // Días en la liquidación        
                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq 
                               FROM detalleliquidacion 
                              WHERE terid = ".$terid." 
                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
                    $diasliq = $clase->SeleccionarUno($vsql);
            
                    $diasss += $diasliq;
                }

                if(($fecingreso<$inisegsemestre)&&($diasps>0))
                {
                    $vsql = "SELECT periodoid AS primerojulio FROM periodosnomina WHERE fecdesde = '".$inisegsemestre."'";
                    $primerojulio = $clase->SeleccionarUno($vsql);

                    $vsql = "SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."'";
                    $treintayuno = $clase->SeleccionarUno($vsql);
            
                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                               FROM hisdetallenomina 
                              WHERE terid = ".$terid." 
                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                              FROM periodoterceros
                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                    $diasss = $clase->SeleccionarUno($vsql);
            
                    // Días en la liquidación
                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq 
                               FROM detalleliquidacion 
                              WHERE terid = ".$terid." 
                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
                    $diasliq = $clase->SeleccionarUno($vsql);
            
                    $diasss += $diasliq;
                }

                // Inicialización de variables
                $pagocenact = 0;                            $cantidad = 0;                          $porcentaje = 0;                        $pagointereses = 0;
                $pagovaca = 0;                              $diasvaca = 0;                          $diasprima = 0;                         $pagoprimasps = 0;
                $lbprocesado = false;                       $pagocesant = 0;                        $cantidadact = 0;                       $cantidadant = 0;
                $pagocesantias = 0;                         $interesesact = 0;                      $interesesant = 0;                      $pagoprimasss = 0;
                $pagoprimas = 0;                            $recarnonocturno = 0;

                // ------------------------------------------------------------------------------------------------------ //
                // Limpio la tabla liquidación
                $vsql = "DELETE FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."'";
                $clase->EjecutarSQL($vsql);
                // ------------------------------------------------------------------------------------------------------ //                

                // ---------------------------------------------------------- //
                // Cálculo de cesantías
                if(($cesantiasyearactual == "SI")||($cesantiasyearanterior == "SI")||($intcesantiasyearactual == "SI")||($intcesantiasyearanterior == "SI"))
                {
                    // Cálculo de cesantías del año actual
                    if($cesantiasyearactual == "SI")
                    {
                        $cantidadact = $diasps + $diasss;
                        $pagocenact = $sueldointegralact * $cantidadact / 360;
                    }
                    else
                    {
                        $pagocenact = 0;
                        $cantidadact = 0;
                    }
                    
                    // Cálculo de cesantías del año anterior
                    if($cesantiasyearanterior == "SI")
                    {
                        $pagocesant = $sueldointegralant * $diasyearant / 360;
                        $cantidadant = $diasyearant;
                    }
                    else
                    {
                        $pagocesant = 0;
                        $cantidadant = 0;
                    }
                    
                    // sub totales
                    $pagocesantias = $pagocenact + $pagocesant;
                    $pagocesantias = round($pagocesantias,2);
                    $cantidad = $cantidadact + $cantidadant;
                    $porcentaje = 12;

                    // Intereses año actual
                    if($intcesantiasyearactual == "SI")
                        $interesesact = (($pagocenact * ($diasps + $diasss)) * 0.12 / 360);
                    else
                        $interesesact = 0;

                    // intereses del año anterior
                    if($intcesantiasyearanterior == "SI")
                        $interesesant = (($pagocesant * $diasyearant) * 0.12 / 360);
                    else
                        $interesesant = 0;

                    $pagointereses = $interesesact + $interesesant;
                    $pagointereses = round($pagointereses,2);

                    // Guardo en la tabla
                    $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                            VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcentaje.",".$pagointereses.")";
                    $clase->EjecutarSQL($vsql);
                }

                // ---------------------------------------------------------- //
                // Cálculo de vacaciones
                if($vacaciones == "SI")
                {
                    // Determino si hay vacaciones canceladas previamente
                    $vsql22 = "SELECT MIN(periodoid) permin
                                 FROM periodosnomina 
                                WHERE fecdesde >= '".$fecingreso."' 
                                      AND cerrado = 'CHECKED' ";
                    $permin = $clase->SeleccionarUno($vsql22);

                    // Determino si hay vacaciones canceladas previamente
                    $vsql23 = "SELECT MAX(periodoid) permax
                                 FROM periodosnomina 
                                WHERE fecdesde >= '".$fecingreso."' 
                                      AND cerrado = 'CHECKED' ";
                    $permax = $clase->SeleccionarUno($vsql23);

                    $vsql24 = "SELECT pernominaid pervacaciones
                                 FROM hisdetallenomina 
                                WHERE terid = ".$terid."         
                                      AND conceptoid = 38 
                                      AND pernominaid >= ".$permin." AND pernominaid <= ".$permax."";
                    $pervacaciones = $clase->SeleccionarUno($vsql24);

                    if(strlen($pervacaciones) > 0)
                    {
                        $pervacaciones++;

                        $vsql31 = "SELECT IFNULL(SUM(valor),0) AS diasvaca  
                                     FROM hisdetallenomina 
                                    WHERE terid = ".$terid."         
                                          AND (pernominaid >= ".$pervacaciones." AND pernominaid <= ".$permax.")  
                                          AND conceptoid IN (1,10,11,12,13,23,31,38,40)";
                        $diasvaca = $clase->SeleccionarUno($vsql31);
                    }
                    else
                        $diasvaca = $diasyearant + $diasps + $diasss;

                    // busco recargo nocturno
                    $recarnonocturno = buscarrecargonoc($terid,$periodoidvaca);

                    $pagovaca = ($basico + $recarnonocturno) * $diasvaca / 720;                    

                    $pagovaca = round($pagovaca,2);

                    // Almaceno en la tabla
                    $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                    VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovaca.",".$diasvaca.",0,0)";
                    $clase->EjecutarSQL($vsql);
                }

                // ---------------------------------------------------------- //
                // Cálculo de primas
                if(($primasprimersemestre == "SI") || ($primassegundosemestre == "SI"))
                {
                    // Primas primer semestre
                    if($primasprimersemestre == "SI")
                    {
                        $diasprima += $diasps;
                        $pagoprimasps = $sueldointegralact * $diasps / 360;
                    }

                    // Primas segundo semestre
                    if($primassegundosemestre == "SI")
                    {
                        $diasprima += $diasss;
                        $pagoprimasss = $sueldointegralact * $diasss / 360;
                    }

                    $pagoprimas = $pagoprimasps + $pagoprimasss;
                    $pagoprimas = round($pagoprimas,2);

                    // Almaceno en la tabla
                    $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                    VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimas.",".$diasprima.",0,0)";
                    $clase->EjecutarSQL($vsql);
                }
            }
        }

        // Emito el mensaje correspondiente
        $clase->Aviso(1,"Liquidaciones recalculadas satisfactoriamente");

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarrecalculo
    // Creación: 20/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar el recalculo de las 
    //              liquidaciones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarrecalculo")
    {
        $codperiodo = $_GET['codperiodo'];
        $periodoid = $_GET['periodoid'];
        
        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        
        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Recalcular liquidaciones </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">¿Confirma que desea recalcular las liquidaciones del periodo <br> <b>'.trim($desperiodo).'</b>? </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=recalcularliquidaciones" method="POST">
                   <input type="hidden" name="codperiodo" value="'.$codperiodo.'"> 
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'" > <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel17
    // Creación: 04/03/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con los 
    //              retirados en un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel17")
    {
        $periodoidanterior = $_GET["periodoidanterior"];

        // para las pruebas
        $periodoidanterior = 88;

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b></td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor diríjase al servidor </font><br> 
        //                <font color=blue> 192.168.14.248:9999 </font> <br>
        //                <font color=red>o al servidor </font> <br> 
        //                <font color=blue> dromedicas.sytes.net:9996 </font> <br>
        //                <font color=red> para poder importar estos datos </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">        
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
        //                 <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
        //                </form> 
        //               </td>    
        //              </tr>
        //             </table>';
        // else
        // {
            $descripcionant = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');            

            // // Combo de conceptos
            // $params = ' class="Texto12" ';
            // $vsqlcomboconcepto = "SELECT conceptoid, nomconcepto
            //                         FROM conceptosnomina 
            //                        WHERE eslicencia = 'CHECKED' 
            //                     ORDER BY conceptoid ASC";

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar retirados<br> <font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcel18" id="theform" enctype="multipart/form-data">
                        <input type="hidden" name="periodoidanterior" value="'.$periodoidanterior.'">        
                        <input type="file" name="excel" /><br><br>                            
                        <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                        <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';

            // // Valido que existan licencias pendientes para emitir el mensaje correspondiente
            // $vsql = "SELECT COUNT(d.conceptoid) AS numlicenciaspro
            //            FROM detallenomina d
            //                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
            //           WHERE d.pernominaid = ".$periodoidanterior."
            //                 AND c.eslicencia = 'CHECKED'";
            // $numlicenciaspro = $clase->SeleccionarUno($vsql);

            // if($numlicenciaspro > 0)
            //     $cont.='<table width="400">
            //              <tr class="TablaDocsPar"> 
            //               <td width="10" align="right">                           
            //                <img src="images/iconos/alerta.png" width="30" height="30" border="0">
            //               </td>
            //               <td width="390" align="center">
            //                <font color="red"> <b>Advertencia: Ya existen novedades procesadas <br>en el periodo </b></font>
            //               </td>
            //              </tr>
            //             </table>';            

            // $variab = 'G_NOFECHALIC';
            // $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

            // if($nofechalic == "CHECKED")
            // {
            //     $fecdesde = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','fecdesde');
            //     $fecdesde2  = substr($fecdesde,8,2)."/".substr($fecdesde,5,2)."/".substr($fecdesde,0,4);
            //     $mensajefecha = 'Fecha <b>'.$fecdesde2.'</b> para todas';
            // }
            // else
            //     $mensajefecha = 'Fecha <b>(formato texto)</b>';

            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: D&iacute;as </td> </tr>
                    </table>';

            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemploretirosenperiodo.png" width="300" height="200" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx </font>
                      </td> 
                     </tr>
                    </table>';
        // }

        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel18
    // Creación: 04/03/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que procesa a los empleados retirados en un periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel18")
    {
        set_time_limit(0);
		extract($_POST);
        $periodoidanterior = $_POST["periodoidanterior"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['dias'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['dias']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            $calculado = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";

            // Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            
            $descripcion = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'RETIRADOS EN EL PERIODO'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($descripcion,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $numreg = 0;
                $dni = $_DATOS_EXCEL[$j]['dni'];
                
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],$tabla,"dni","terid");
                
                if($terid != "")
                {
                    // Valido la columna de los días
                    $lb_valido = false;
                    $dias = $_DATOS_EXCEL[$j]['dias'];

                    $lb_valido = $io_fecha->uf_solo_numeros($dias);

                    if($lb_valido)
                    {
                        // valido que el dato sea correcto
                        if($dias > 0)
                        {
                            // elimino los registros que este empleado pueda tener
                            $vsql4 = "DELETE FROM detallenomina WHERE pernominaid = ".$periodoidanterior." AND terid = ".$terid;
                            $clase->EjecutarSQL($vsql4);
    
                            // calculo el sueldo
                            $basico = $clase->BDLockup($terid,$tabla,'terid','basico');             // salario básico
                            $diastrab = $dias;
    
                            // Obtengo la formula del sueldo
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                            $formulabasico = $clase->SeleccionarUno($vsql);
    
                            // Calculo el sueldo básico
                            eval("\$sueldo = $formulabasico;");
                            $sueldo = round($sueldo,0);
                            
                            $vsql1 = "INSERT INTO detallenomina (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) VALUES (".$terid.",1,".$periodoidanterior.",".$sueldo.",0,".$diastrab.",".$basico.")";
                            $clase->EjecutarSQL($vsql1);

                            if(mysql_affected_rows() >= 1)
                            {
                                $grabados++;
                                $lbgrabo = true;
                            }
    
                            // calculo el subsidio de transporte
                            $valsubtrasp = $smlv * 2;       // Variable para la validación del auxilio de transporte
    
                            // Obtengo la formula para el subsidio de transporte
                            $auxtrans = $_SESSION['N_AUXTRANS2020'];
                            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                            $formulatransporte = $clase->SeleccionarUno($vsql);
    
                            $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');
                            $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');           // Obtengo el control del cálculo de subsidio de transporte
    
                            if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                            {
                                // Calculo el subsidio de transporte
                                eval("\$subsidiotransporte = $formulatransporte;");
                                $subsidiotransporte = round($subsidiotransporte,0);
                            }
                            else
                                $subsidiotransporte = 0;
    
                            $vsql1 = "INSERT INTO detallenomina (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                         VALUES (".$terid.",3,".$periodoidanterior.",".$subsidiotransporte.",0,".$diastrab.",".$basico.")";
                            $clase->EjecutarSQL($vsql1);
    
                            // calculo la salud y a pensión
                            $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                            $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
                            $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
    
                            if($epsid==NULL)                $epsid=0;
                            if($pensionesid==NULL)          $pensionesid=0;
                
                            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                       FROM detallenomina d
                                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                      WHERE d.terid = ".$terid."
                                            AND d.pernominaid = ".$periodoidanterior." 
                                            AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                            $totnovedades = $clase->SeleccionarUno($vsql);

                            $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                       FROM detallenomina d
                                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                      WHERE d.terid = ".$terid."
                                            AND d.pernominaid = ".$periodoidanterior." 
                                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                            $totrecargos = $clase->SeleccionarUno($vsql);
                    
                            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
    
                            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
                            if($extralegal=="CHECKED")
                            {
                                $pension = 0;
                                $salud = 0;
                            }
                            else
                            {
                                // Recalculo pensión y salud
                                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                    $pension = 0;
                                else
                                {
                                    // Obtengo la formula para el descuento por pensión
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                    $formulapension = $clase->SeleccionarUno($vsql);
                
                                    // Calculo la pensión
                                    eval("\$pension = $formulapension;");
                                    $pension = round($pension,0);
                                }
                
                                if(($epsid==37)||($aplicasalud!="CHECKED"))
                                    $salud = 0;
                                else
                                {
                                    // Obtengo la formula para el descuento de salud
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                    $formulasalud = $clase->SeleccionarUno($vsql);
                                    
                                    // Calculo la salud
                                    eval("\$salud = $formulasalud;");
                                    $salud = round($salud,0);
                                }
                            }
                            
                            $vsql1 = "INSERT INTO detallenomina (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) VALUES (".$terid.",4,".$periodoidanterior.",0,".$pension.",0,$sueldodeducciones)";
                            $clase->EjecutarSQL($vsql1);
    
                            $vsql2 = "INSERT INTO detallenomina (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) VALUES (".$terid.",5,".$periodoidanterior.",0,".$salud.",0,$sueldodeducciones)";
                            $clase->EjecutarSQL($vsql2);
    
                            // Aquí depuro los conceptos que estén en cero
                            $vsql3 = "DELETE FROM detallenomina WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoidanterior." AND terid = ".$terid;
                            $clase->EjecutarSQL($vsql3);
                    
                            // Elimino el empleado de la tabla de enlace sección terceros
                            $vsqld = "DELETE FROM seccionterceros WHERE terid = ".$terid;
                            $clase->EjecutarSQL($vsqld);
                        }
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);                     // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresretipoper.txt";                                      // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                         // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                                // Grabas
                    fclose($fd);                                                            // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);                 // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresretipoper.txt";                                                      // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                                         // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                                // Grabas
            fclose($fd);                                                                            // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron los retiros para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados retiros para el periodo $descripcion");
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel18
    // Creación: 06/03/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar el concepto que se eliminará 
    //              en el periodo correspondiente
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanalimpiarconpliq")
    {
        $codperiodo = $_GET['codperiodo'];
        
        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Parámetro del combo de conceptos
        $params = ' class="Texto11" ';
        
        // Combo de los conceptos que se pueden eliminar
        $vsqlcomboconcepto = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) 
                                FROM conceptosnomina 
                               WHERE (eslicencia <> 'CHECKED' AND esdeley <> 'CHECKED')
                                     OR conceptoid = 3
                            ORDER BY conceptoid";

        $comboconcepto = $clase->CrearComboBuscar("conceptoid",$vsqlcomboconcepto,"nombres","conceptoid","","S",$params,420);

        // Pinto la ventana para eliminar el concepto
        $cont = $clase->Header("S","W");

        // encabezado
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/anulardoc.png" width="32" height="32" border="0"> </td>
                  <td width="900" alling="left"> <b> Limpiar concepto del periodo <font color="blue">'.$desperiodo.'</font></b> </td>
                  <td width="20"> &nbsp; </td>
                  <td width="24"> <a href="importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'"><input type="button" value="<<" class="button blue"></a> </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        // filtros
        $cont.='<table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!">  
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                   <form action="?opcion=confirmarlimpiarconpliq" method="POST" name="x">                  
                   <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                  <td width="900"> <label class="Texto12"> Concepto: </label>
                   &nbsp; '.$comboconcepto.'
                  </td>
                 </tr>
                </table>';

        // botón de confirmación
        $cont.='<table width="100%">                     
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>                       
                 </tr> 
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarlimpiarconpliq
    // Creación: 12/03/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción donde se confirma la eliminación de los registros previamente 
    //              seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiarconpliq")
    {
        $codperiodo = $_POST['codperiodo'];
        $conceptoid = $_POST['conceptoid'];

        // Nombres del concepto y del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');        

        // Lista de periodos de nómina asociados al periodo mensual
        $listaperiodos = generarlistaper($codperiodo);

        $vsql = "SELECT COUNT(*) numreg
                   FROM detalleliquidacion d
                  WHERE d.pernominaid IN ($listaperiodos)       
                        AND d.conceptoid = ".$conceptoid."
                        AND d.terid NOT IN (SELECT terid 
                                              FROM parametrosliquidacion 
                                             WHERE norecalcular = 'CHECKED' 
                                                   AND codperiodo = '".$codperiodo."')";
        $numreg = $clase->SeleccionarUno($vsql);        

        // Validación de la eliminación de los registros        
        if($numreg == 0)
        {
            $clase->Aviso(3,"No existen $nomconcepto en el periodo $desperiodo");
            header("Location: importacionexcelnom.php?opcion=ventanalimpiarconpliq&codperiodo=$codperiodo");
        }
        else
        {
            // Pinto la ventana para eliminar el concepto
            $cont = $clase->Header("S","W");

            // encabezado
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/anulardoc.png" width="32" height="32" border="0"> </td>
                      <td width="900" alling="left"> <b> Limpiar concepto del periodo <font color="blue"> '.$desperiodo.' </font> </b> </td>
                      <td width="20"> &nbsp; </td>
                      <td width="24"> &nbsp; </td>
                      <td width="10"> &nbsp; </td>
                     </tr>
                    </table>';

            // verificación
            $cont.='<table width="100%">
                     <tr class="BarraDocumentos" style="height:50px;Important!">  
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td>
                       <form action="?opcion=limpiarconceptoliq" method="POST" name="x">
                       <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                      <td width="900">
                       <font size="2"> <center> Se proceder&aacute; a eliminar el concepto <b> '.$nomconcepto.' </b> a <b> '.$numreg.' </b> empleados <br> ¿est&aacute; seguro de eliminarlos? </center> </font>
                      </td>
                     </tr>
                    </table>';

            // botones
            $cont.='<table width="100%">
                     <tr class="BarraDocumentos" style="height:50px;Important!"> 
                      <td align="center">
                       <input type="submit" value="aceptar" class="button blue">
                       &nbsp;&nbsp;
                       <a href="importacionexcelnom.php?opcion=ventanalimpiarconpliq&codperiodo='.$codperiodo.'">
                        <input type="button" value="CANCELAR" class="button red">
                       </a>
                       </form>
                      </td>
                     </tr> 
                    </table>';

            // Pie de página
            $cont.='<table width="100%"> 
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: limpiarconceptoliq
    // Creación: 13/03/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para eliminar los registros previamente seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "limpiarconceptoliq")
    {
        $conceptoid = $_POST['conceptoid'];
        $listaperiodos = $_POST['listaperiodos'];
        $codperiodo = $_POST['codperiodo'];

        // Instrucción para eliminar los registros
        $vsql = "DELETE FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND conceptoid = ".$conceptoid;
        $clase->EjecutarSQL($vsql);        

        // Emito el mensaje y redirecciono el formulario
        $clase->Aviso(1,"Registros eliminados satisfactoriamente");
        header("Location: importacionexcelnom.php?opcion=ventanalimpiarconpliq&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel19
    // Creación: 16/04/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel para actualizar
    //              datos en terceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel19")
    {
        $periodoidanterior = $_GET["periodoidanterior"];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventanaimportacion" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            $descripcionant = $clase->BDLockup($periodoidanterior,'periodosnomina','periodoid','descripcion');

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Cambiar cargo, básico y recalcular<br> <font color="blue">'.strtolower($descripcionant).'</font></b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcel20" id="theform" enctype="multipart/form-data">
                        <input type="hidden" name="periodoidanterior" value="'.$periodoidanterior.'">        
                        <input type="file" name="excel" /><br><br>                            
                        <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                        <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';

            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: ID del cargo </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Sueldo </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: Afecta terceros (SI/NO) </td> </tr>
                    </table>';

            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemploactualizacionterceros.png" width="300" height="200" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx </font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel20
    // Creación: 16/04/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que actualiza masivamente los cargos, sueldos y recalcula la 
    //              quincena
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel20")
    {
        set_time_limit(0);
		extract($_POST);
        $periodoidanterior = $_POST["periodoidanterior"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cargoid'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['basico'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['afectaterceros'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['cargoid']) == 0) || (strlen($_DATOS_EXCEL[$i]['basico']) == 0) || (strlen($_DATOS_EXCEL[$i]['afectaterceros']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // inicialización de variables
            $idsueldo = 0;                  $smlv = $_SESSION['N_SALMIN2020'];                  $diastrab = 0;
            $sueldo = 0;                    $cant2 = 0;                                         $idtransporte = 0;
            $lb_valido1 = false;            $numcargos = 0;                                     $lb_valido2 = false;
            $auxtrans = $_SESSION['N_AUXTRANS2020'];                                            $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

            // formula del concepto
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
            $formulatransporte = $clase->SeleccionarUno($vsql);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $numreg = 0;
                $dni = $_DATOS_EXCEL[$j]['dni'];
                
                // Validación de la existencia del tercero
                $terid = $clase->BDLockup($dni,"terceros","dni","terid");
                
                if($terid != "")
                {
                    // Validación del ID del cargo
                    $cargoid = $_DATOS_EXCEL[$j]['cargoid'];
                    $lb_valido1 = $io_fecha->uf_solo_numeros($cargoid);

                    if($lb_valido1)
                    {
                        $vsql14 = "SELECT COUNT(*) numcargos FROM cargos WHERE cargoid = ".$cargoid;
                        $numcargos = $clase->SeleccionarUno($vsql14);

                        if($numcargos > 0)
                        {
                            // Validación del básico
                            $basico = $_DATOS_EXCEL[$j]['basico'];
                            $lb_valido2 = $io_fecha->uf_solo_numeros($basico);

                            if($lb_valido2)
                            {
                                $afectaterceros = $_DATOS_EXCEL[$j]['afectaterceros'];

                                if($afectaterceros == "SI")
                                {
                                    // grabo en la tabla terceros
                                    $vsql = "UPDATE terceros SET 
                                                    cargoid = ".$cargoid.",
                                                    basico = ".$basico." 
                                              WHERE terid = ".$terid;
                                    $clase->EjecutarSQL($vsql);
                                }
                                
                                // grabo en la tabla tercerosactual
                                $vsql34 = "SELECT idteract FROM tercerosactual WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior;
                                $idteract = $clase->SeleccionarUno($vsql34);

                                $vsql = "UPDATE tercerosactual SET 
                                                cargoid = ".$cargoid.", 
                                                basico = ".$basico."  
                                          WHERE idteract = ".$idteract;
                                $clase->EjecutarSQL($vsql);

                                // -------------------------------------------------------------------------------------------------------------------------------------------------------- //
                                // recalculo el sueldo
                                $vsql = "SELECT detalleid idsueldo FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 1";
                                $idsueldo = $clase->SeleccionarUno($vsql);

                                if($idsueldo > 0)
                                {
                                    // Obtengo la formula del sueldo
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                                    $formulabasico = $clase->SeleccionarUno($vsql);

                                    // días trabajados
                                    $vsql = "SELECT valor diastrab FROM detallenomina WHERE detalleid = ".$idsueldo;
                                    $diastrab = $clase->SeleccionarUno($vsql);

                                    // Calculo el sueldo básico
                                    eval("\$sueldo = $formulabasico;");
                                    $sueldo = round($sueldo,0);

                                    // grabo la modificación
                                    $vsql = "UPDATE detallenomina SET devengados = ".$sueldo.", saldo = ".$basico." WHERE detalleid = ".$idsueldo."";
                                    $clase->EjecutarSQL($vsql);
                                }

                                // recalculo las licencias remuneradas
                                $vsql6 = "SELECT d.detalleid, d.conceptoid, d.valor, c.formula  
                                            FROM detallenomina d
                                                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                           WHERE d.terid = ".$terid." 
                                                 AND d.pernominaid = ".$periodoidanterior." 
                                                 AND (c.eslicencia = 'CHECKED' AND c.tipodc = 'C')";
                                $conex  = $clase->Conectar();
                                $result2 = mysql_query($vsql6,$conex);
                                $cant2 = mysql_num_rows($result2);

                                if($cant2 > 0)
                                {
                                    $montolicencia = 0;
                                    $porcbasico = 0;
                                    
                                    while($row2 = mysql_fetch_array($result2))
                                    {
                                        $detalleid = $row2['detalleid'];
                                        $conceptoid = $row2['conceptoid'];
                                        $dias = $row2['valor'];
                                        $formulalice = $row2['formula'];

                                        // Calculo la licencia
                                        if($conceptoid!=10)
                                        {
                                            eval("\$montolicencia = $formulalice;");
                                            $montolicencia = round($montolicencia,0);
                                        }
                                        else
                                        {
                                            // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                                            if($basico<=$smlv)
                                            {
                                                $montolicencia = ($smlv*$dias)/30;
                                                $montolicencia = round($montolicencia,0);
                                            }
                                            else
                                            {
                                                $porcbasico = ($basico*66.67)/100;
                                                $porcbasico = round($porcbasico,0);

                                                // Calculo la incapacidad si el básico sea mayor al mínimo 
                                                if($porcbasico>$smlv)
                                                {
                                                    $montolicencia = ($porcbasico*$dias)/30;
                                                    $montolicencia = round($montolicencia,0);
                                                }
                                                else
                                                {
                                                    if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                                                    if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                                                    $montolicencia = round($montolicencia,0);
                                                }
                                            }
                                        }

                                        // guardo el nuevo monto
                                        $vsql = "UPDATE detallenomina SET devengados = ".$montolicencia.", saldo = ".$basico." WHERE detalleid = ".$detalleid;
                                        $clase->EjecutarSQL($vsql);
                                    }
                                }

                                // recalculo el subsidio de transporte
                                $valsubtrasp = $smlv * 2;
                                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');

                                $vsql = "SELECT detalleid idtransporte FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 3";
                                $idtransporte = $clase->SeleccionarUno($vsql);

                                if(($basico > $valsubtrasp) || ($aplicatransporte == ""))
                                {
                                    if(strlen($idtransporte) > 0)
                                    {
                                        $vsql = "DELETE FROM detallenomina WHERE detalleid = ".$idtransporte;
                                        $clase->EjecutarSQL($vsql);
                                    }
                                }
                                else
                                {
                                    if($diastrab == 0)
                                        $subsidiotransporte = 0;
                                    else
                                    {
                                        // Calculo el subsidio de transporte
                                        eval("\$subsidiotransporte = $formulatransporte;");
                                        $subsidiotransporte = round($subsidiotransporte,0);

                                        if(strlen($idtransporte) > 0)
                                            $vsql = "UPDATE detallenomina SET devengados = ".$subsidiotransporte." WHERE detalleid = ".$idtransporte;
                                        else
                                        {
                                            $vsql = "SELECT max(detalleid) FROM detallenomina";
                                            $numreg = $clase->SeleccionarUno($vsql);
                        
                                            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",3,".$periodoidanterior.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                                        }
                                        $clase->EjecutarSQL($vsql);
                                    }
                                }

                                // recalculo pensión y salud
                                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                           FROM detallenomina d
                                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                          WHERE d.terid = ".$terid." 
                                                AND d.pernominaid = ".$periodoidanterior." 
                                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                                $totnovedades = $clase->SeleccionarUno($vsql);

                                $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                            FROM detallenomina d
                                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                          WHERE d.terid = ".$terid."
                                                AND d.pernominaid = ".$periodoidanterior." 
                                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                                $totrecargos = $clase->SeleccionarUno($vsql);
                        
                                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                                // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
                                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

                                if($extralegal=="CHECKED")
                                {
                                    $pension = 0;
                                    $salud = 0;
                                }
                                else
                                {
                                    // Recalculo pensión y salud
                                    if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                        $pension = 0;
                                    else
                                    {
                                        // Obtengo la formula para el descuento por pensión
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                        $formulapension = $clase->SeleccionarUno($vsql);

                                        // Calculo la pensión
                                        eval("\$pension = $formulapension;");
                                        $pension = round($pension,0);
                                    }

                                    if(($epsid==37)||($aplicasalud!="CHECKED"))
                                        $salud = 0;
                                    else
                                    {
                                        // Obtengo la formula para el descuento de salud
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                        $formulasalud = $clase->SeleccionarUno($vsql);
                                        
                                        // Calculo la salud
                                        eval("\$salud = $formulasalud;");
                                        $salud = round($salud,0);
                                    }
                                }

                                //  ID pensión
                                $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 4";
                                $idpension = $clase->SeleccionarUno($vsql);

                                // Grabo la pensión
                                if($idpension!="")
                                    $vsql = "UPDATE detallenomina SET 
                                                    descuentos = ".$pension.",
                                                    saldo = ".$sueldodeducciones."
                                              WHERE detalleid = ".$idpension;
                                else
                                {
                                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                                    $numreg = $clase->SeleccionarUno($vsql);

                                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoidanterior.",0,".$pension.",0,$sueldodeducciones)";
                                }
                                $clase->EjecutarSQL($vsql);

                                // ID salud
                                $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoidanterior." AND conceptoid = 5";
                                $idsalud = $clase->SeleccionarUno($vsql);

                                // Grabo la salud
                                if($idsalud!="")
                                    $vsql = "UPDATE detallenomina SET 
                                                    descuentos = ".$salud.",
                                                    saldo = ".$sueldodeducciones."
                                              WHERE detalleid = ".$idsalud;
                                else
                                {
                                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                                    $numreg = $clase->SeleccionarUno($vsql);

                                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoidanterior.",0,".$salud.",0,$sueldodeducciones)";
                                }
                                $clase->EjecutarSQL($vsql);
                                
                                // Aquí depuro los conceptos que estén en cero
                                $vsql = "DELETE FROM detallenomina WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoidanterior." AND terid = ".$terid;
                                $clase->EjecutarSQL($vsql);
                            }
                        }
                    }
                }
            }

            $clase->Aviso(1,"Proceso culminado");
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventanaimportacion");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: recargonocturno
    // Creación: 31/05/2024		última modificación: 12/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que procesa los recargos nocturnos de un periodo
    // Última modificación: Inclusión de los totales
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "recargonocturno")
    {
        $periodoid = $_GET["periodoidanterior"];

        // nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // validación de servidor 248
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $btoimportarnoc = '<img src="images/iconos/cargar.png" title="subir recargos nocturnos - debe ir al servidor 248" border="0" width="32" height="32">';
        else
            $btoimportarnoc = '<a href="?opcion=importarexcelrecaargo1&periodoid='.$periodoid.'" rel="facebox">
                                <img src="images/iconos/cargar.png" title="Subir recargos nocturnos" border="0" width="32" height="32"> 
                               </a> ';

        // $btoimportarnoc = '<a href="?opcion=importarexcelrecaargo1&periodoid='.$periodoid.'" rel="facebox"> 
        //                     <img src="images/iconos/cargar.png" title="Subir recargos nocturnos" border="0" width="32" height="32"> 
        //                    </a> ';

        // valido que el archivo de mostrar errores exista
        $archivoerror = "reportes/erroresrecargos.txt";
        if (file_exists ($archivoerror))
            $htmlarchivoerror = '<a href="?opcion=vererroresrecargos&periodoid='.$periodoid.'" rel="facebox">
                                  <img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&eacute;dulas de empleados no guardados en el &uacute;ltimo proceso de importaci&oacute;n">
                                 </a>';
        else
            $htmlarchivoerror = '<img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&eacute;dulas de empleados no guardados en el &uacute;ltimo proceso de importaci&oacute;n">';

        // consulta de la vista
        $vsql = "SELECT d.detalleid, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, d.valor, d.devengados, c.nomconcepto 
                   FROM tercerosactual t
                        INNER JOIN detallenomina d ON (t.terid = d.terid)
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.pernominaid = ".$periodoid."
                        AND c.recargo = 'CHECKED'";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                  <td width="800"> <b> Recargos <br> <font color="blue"> '.$descripcion.' </font> </b> </td>
                  <td width="30"> '.$btoimportarnoc.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30" align="center"> '.$htmlarchivoerror.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=ventanaincregargo&periodoid='.$periodoid.'" rel="facebox"> 
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="nuevo recargo nocturno"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=descargarrecargos&periodoid='.$periodoid.'" target="_blank"> 
                    <img src="images/iconos/descargar.png" width="32" height="32" border="0" title="bajar informaci&oacute;n de recargos"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="40" align="center"> 
                   <a href="importacionexcelnom.php?opcion=ventanaimportacion"> 
                    <input type="button" value="<<" class="button blue" title="ventana principal"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>                  
                 </tr> 
                </table>';

        // detalle de la ventana
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="11"> &nbsp; </td>
                   <td width="120" align="left"> Documento </td>
                   <td width="300" align="left"> Empleado </td>                   
                   <td width="280" align="left"> Concepto </td>
                   <td width="110" align="right"> Cantidad </td>
                   <td width="150" align="right"> Monto </td>
                   <td width="60"> &nbsp; </td>
                   <td width="60"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';

        $i = 0;         $totalrecargos = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $cont.=' <td width="11"> &nbsp; </td>
                     <td width="120" align="left"> '.$row['dni'].' </td>
                     <td width="300" align="left"> '.$row['nombreemp'].' </td>
                     <td width="280" align="left"> '.$row['nomconcepto'].' </td>
                     <td width="110" align="right"> '.number_format($row['valor']).' </td>
                     <td width="150" align="right"> '.number_format($row['devengados']).' </td>
                     <td width="50" align="right"> &nbsp; </td>
                     <td width="26" align="center">
                      <a href="?opcion=confirmareliminarrecargo&detalleid='.$row['detalleid'].'&periodoid='.$periodoid.'" rel="facebox">
                       <img src="images/basicas/borrados.png" title="eliminar y recalcular" border="0" width="20" height="20">
                      </a>
                     </td>
                     <td width="26" align="center">
                      <a href="recibodepago.php?opcion=negativo&periodoid='.$periodoid.'&dni='.$row['dni'].'" target="_blank">
                       <img src="images/basicas/pdf.png" title="ver recibo de pago" border="0" width="20" height="20">
                      </a>                     
                     </td>
                    </tr>';

            $totalrecargos += $row['devengados'];
        }

        $cont.=' </tbody>
                </table>';

        // Impresión de los totales
        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="1051"> &nbsp; </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Neto a pagar: </b> '.number_format($totalrecargos).' </font> </td>
                  <td width="182"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmareliminarrecargo
    // Creación: 31/05/2024		última modificación: 05/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de un recargo 
    //              nocturno
    // Última modificación: Adaptación para que se muestre cualquier recargo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmareliminarrecargo")
    {
        $detalleid = $_GET["detalleid"];
        $periodoid = $_GET["periodoid"];

        // determino la tabla
        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado == "CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";        

        // determino el empleado
        $vsql = "SELECT terid FROM detallenomina WHERE detalleid = ".$detalleid;
        $terid = $clase->SeleccionarUno($vsql);
        
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM ".$tabla." WHERE terid= ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql);

        // datos del concepto
        $conceptoid = $clase->BDLockup($detalleid,'detallenomina','detalleid','conceptoid');
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        $cantidad = $clase->BDLockup($detalleid,'detallenomina','detalleid','valor');
        $monto = $clase->BDLockup($detalleid,'detallenomina','detalleid','devengados');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="350" align="center"><br><label class="Texto12"><b>Eliminar recargo </b> </label> <br><br> </td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <br>
                   <label class="Texto12">
                   ¿Confirma que desea eliminar <br> <b> '.$nomconcepto.' </b> de <br> <b> '.$nombreemp.' </b> <br> de cantidad <b> '.number_format($cantidad).' </b> por un monto de <b> '.number_format($monto).' </b> pesos? 
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarecargo" method="POST">
                   <input type="hidden" name="detalleid" value="'.$detalleid.'"> 
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">                   
                   <input type="submit" value="ACEPTAR" class="button blue">                   
                   <a href="importacionexcelnom.php?opcion=recargonocturno&periodoidanterior='.$periodoid.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarecargo
    // Creación: 31/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un recargo nocturno y recalcula al empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarecargo")
    {
        $detalleid = $_POST["detalleid"];
        $periodoid = $_POST["periodoid"];

        // determino el empleado
        $vsql = "SELECT terid FROM detallenomina WHERE detalleid = ".$detalleid;
        $terid = $clase->SeleccionarUno($vsql);

        // determino la tabla
        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado == "CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        // determino su sueldo básico
        $basico = $clase->BDLockup($terid,$tabla,'terid','basico');

        // elimino el recargo
        $vsql = "DELETE FROM detallenomina WHERE detalleid = ".$detalleid;
        $clase->EjecutarSQL($vsql);

        // recalculo salud y pensión
        $vsql = "SELECT IFNULL(devengados,0) FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
        $sueldo = $clase->SeleccionarUno($vsql);

        $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');

        // recalculo pensión y salud
        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
        $totnovedades = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
        $totrecargos = $clase->SeleccionarUno($vsql);

        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

        $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
        $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

        if($extralegal=="CHECKED")
        {
            $pension = 0;
            $salud = 0;
        }
        else
        {
            // Recalculo pensión y salud
            if(($pensionesid==5)||($aplicapension!="CHECKED"))
                $pension = 0;
            else
            {
                // Obtengo la formula para el descuento por pensión
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                $formulapension = $clase->SeleccionarUno($vsql);

                // Calculo la pensión
                eval("\$pension = $formulapension;");
                $pension = round($pension,0);
            }

            if(($epsid==37)||($aplicasalud!="CHECKED"))
                $salud = 0;
            else
            {
                // Obtengo la formula para el descuento de salud
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                $formulasalud = $clase->SeleccionarUno($vsql);
                
                // Calculo la salud
                eval("\$salud = $formulasalud;");
                $salud = round($salud,0);
            }
        }

        //  ID pensión
        $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
        $idpension = $clase->SeleccionarUno($vsql);

        // Grabo la pensión
        if($idpension!="")
            $vsql = "UPDATE detallenomina SET 
                            descuentos = ".$pension.",
                            saldo = ".$sueldodeducciones."
                      WHERE detalleid = ".$idpension;
        else
        {
            $vsql = "SELECT max(detalleid) FROM detallenomina";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // ID salud
        $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
        $idsalud = $clase->SeleccionarUno($vsql);

        // Grabo la salud
        if($idsalud!="")
            $vsql = "UPDATE detallenomina SET 
                            descuentos = ".$salud.",
                            saldo = ".$sueldodeducciones."
                      WHERE detalleid = ".$idsalud;
        else
        {
            $vsql = "SELECT max(detalleid) FROM detallenomina";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);
        
        // Aquí depuro los conceptos que estén en cero
        $vsql = "DELETE FROM detallenomina WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
        $clase->EjecutarSQL($vsql);

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Recargo nocturno almacenado satisfactoriamente");

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=recargonocturno&periodoidanterior=$periodoid");
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaincregargo
    // Creación: 31/05/2024		última modificación: 17/01/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para captar los datos del nuevo recargo 
    //              nocturno
    // Última modificación: Inclusión del campo monto
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaincregargo")
    {
        $periodoid = $_GET["periodoid"];

        // combo de empleado de acuerdo al periodo
        $params = ' class="Texto12" ';

        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado == "CHECKED")
            $tabla = "tercerosactual";
        else
            $tabla = "terceros";

        // combo de empleados
        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                           FROM ".$tabla."
                          WHERE basico > 0 
                                AND (primernombre <> '' AND primerapellido <> '') 
                       ORDER BY primernombre";
        $comboemp  = $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombreemp","terid","","S",$params,500);

        // combo de recargos
        $vsqlcomborecargo = "SELECT conceptoid, nomconcepto descripcion FROM conceptosnomina WHERE recargo = 'CHECKED'";
        $comborecargo = $clase->CrearComboBuscar("conceptoid",$vsqlcomborecargo,"descripcion","conceptoid","","S",$params,400);

        // cantidad
        $cantidad = 1;
        $monto = 0;

        // pinto la ventana
        $cont ='<table width="700">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
                  <td width="650" align="center"> <b> Incluir recargo </b> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardarrecargo" method="POST" name="x">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="700">
                 <center>
				 <tr class="BarraDocumentos" style="height:40px;Important!">
				  <td width="100" align="right"> <label class="Texto12"> Empleado: </label> </td>
				  <td width="600"> &nbsp; '.$comboemp.' </td>
				 </tr>
				 <tr class="BarraDocumentos" style="height:40px;Important!">
				  <td width="100" align="right"> <label class="Texto12"> Concepto: </label> </td>
				  <td width="600"> &nbsp; '.$comborecargo.' </td>
				 </tr>
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <td width="100" align="right"> <label class="Texto12"> Cantidad: </label> </td>
                  <td width="600">
                   &nbsp;
                   <input type="number" name="cantidad" class="Texto12New" size="4" min="1" style="width:60px;height:25px" value="'.$cantidad.'">
                  </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <td width="100" align="right"> <label class="Texto12"> Monto: </label> </td>
                  <td width="600">
                   &nbsp;
                   <input type="number" name="monto" class="Texto12New" size="30" min="0" style="width:120px;height:25px" value="'.$monto.'">
                  </td>
                 </tr>
                </table>
                <table width="700">
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="700" align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="importacionexcelnom.php?opcion=recargonocturno&periodoidanterior='.$periodoid.'"> <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarrecargo
    // Creación: 31/05/2024		última modificación: 17/01/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda el nuevo recargo nocturno
    // Última modificación: Inclusión del monto no calculado
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarrecargo")
    {
        $terid = $_POST["terid"];
        $periodoid = $_POST["periodoid"];
        $conceptoid = $_POST["conceptoid"];
        $cantidad = $_POST["cantidad"];
        $monto = $_POST["monto"];

        if(strlen($monto) == 0)
            $monto = 0;

        // valido la entrada de los datos
        if((strlen($conceptoid == 0)) || (strlen($terid) == 0))
            $clase->Aviso(3,"Debe incluir empleado y concepto");
        else
        {
            // inicialización de variables
            $calculado = "";                                        $tabla = "";                                        $basico = 0;
            $recargo = 0;                                           $numreg = 0;                                        $sueldo = 0;
            $cargoid = 0;                                           $totnovedades = 0;                                  $totrecargos = 0;
            $sueldodeducciones = 0;
    
            // determino la tabla
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');
    
            if($calculado == "CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";
    
            // básico del empleado
            $basico = $clase->BDLockup($terid,$tabla,'terid','basico');

            if($monto > 0)
            {
                // incremento el id
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);

                // almaceno el recargo
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,".$cantidad.",$basico)";
                $clase->EjecutarSQL($vsql);
            }
            else
            {
                // Obtengo la formula del recargo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                $formularecargo = $clase->SeleccionarUno($vsql);        
        
                // Calculo el recargo
                eval("\$recargo = $formularecargo;");
                $recargo = round($recargo,0);
        
                // incremento el id
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);
                
                // almaceno el recargo
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",".$conceptoid.",".$periodoid.",".$recargo.",0,".$cantidad.",$basico)";
                $clase->EjecutarSQL($vsql);
            }
    
            // recalculo salud y pensión
            $vsql = "SELECT IFNULL(devengados,0) FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
            $sueldo = $clase->SeleccionarUno($vsql);        
    
            // recalculo pensión y salud
            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
            $totnovedades = $clase->SeleccionarUno($vsql);
    
            $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                       FROM detallenomina d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
            $totrecargos = $clase->SeleccionarUno($vsql);
    
            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
    
            $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
            $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
            $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
            $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
            
            if($epsid==NULL)                $epsid=0;
            if($pensionesid==NULL)          $pensionesid=0;        
    
            if($extralegal=="CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5) || ($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);
    
                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }
    
                if(($epsid==37) || ($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }
            }
    
            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);
    
            // Grabo la pensión
            if($idpension!="")
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension;
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);
    
            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);
    
            // Grabo la salud
            if($idsalud!="")
                $vsql = "UPDATE detallenomina SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud;
            else
            {
                $vsql = "SELECT max(detalleid) FROM detallenomina";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);
            
            // Aquí depuro los conceptos que estén en cero
            $vsql = "DELETE FROM detallenomina WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
            $clase->EjecutarSQL($vsql);
    
            // emito el mensaje correspondiente
            $clase->Aviso(1,"Recargo almacenado satisfactoriamente");
        }

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=recargonocturno&periodoidanterior=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcelrecaargo1
    // Creación: 01/06/2024		última modificación: 15/01/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con los 
    //              empleados con recargo nocturno
    // Última modificación: Adaptación para todos los conceptos de nómina tipo recargo
    //                      (06/11/2024)
    //                      Inclusión de la columna del monto para los recargos no 
    //                      calculados
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcelrecaargo1")
    {
        $periodoid = $_GET["periodoid"];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor dir&iacute;jase al servidor </font> <br>
                       <a href="http://192.168.14.248:9999/dropos/login/" target="_blank"> 
                        <font color=blue> 192.168.14.248:9999 </font> <br>                        
                       </a>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=recargonocturno&periodoidanterior='.$periodoid.'" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // nombre del periodo
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');            
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Importar recargos nocturnos <br> <font color="blue">'.strtolower($descripcion).'</font></b> </td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcelrecaargo2" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="file" name="excel" /> <br> <br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Concepto </td> </tr> 
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Cantidad </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: Monto </td> </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp;  <font color="blue"> <b> 47 y 56 </b> </font> RECARGO NOCTURNO <font color="blue"> <b> 49 </b> </font> HORA EXTRA DIURNA
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b> 50 </b> </font> HORA EXTRA NOCTURNA  <font color="blue"> <b> 51 </b> </font> HORA EXTRA DIURNA DOMINICAL
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b> 52 </b> </font> HORA EXTRA NOCTURNA DOMINICAL Y FESTIVO 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b> 53 </b> </font> DOMINGOS Y FESTIVOS
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b> 54 </b> </font> RECARGO NOCTURNO DOMINICAL Y FESTIVO
                      </td> 
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplorecargos.png" width="320" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcelrecaargo2
    // Creación: 01/06/2024		última modificación: 15/01/2025
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que procesa los empleados con recargo nocturno desde una hoja de 
    //              Excel
    // Última modificación: Adaptación para todos los conceptos de nómina tipo recargo
    //                      (06/11/2024)
    //                      Exclusión de la validación de la repetición de recargos en el 
    //                      mismo periodo (30/11/2024)
    //                      Inclusión de la columna del monto para los recargos no 
    //                      calculados
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcelrecaargo2")
    {
		set_time_limit(0);
		extract($_POST);
        $periodoid = $_POST["periodoid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;
        
        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
					$_DATOS_EXCEL[$i]['conceptoid'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cantidad'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['monto'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['conceptoid']) == 0) || (strlen($_DATOS_EXCEL[$i]['cantidad']) == 0) || (strlen($_DATOS_EXCEL[$i]['monto']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocodigos = 'RECARGOS'.Chr(13).Chr(10);
            $nocodigos.= 'CEDULAS NO GRABADAS:'.Chr(13).Chr(10);
            $nocodigos.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                // inicialización de variables
                $lbgrabo = false;
                $motivo = "";
                $lb_valido = false;
                $lb_valido2 = false;
                $numrecargo = 0;

                $dni = $_DATOS_EXCEL[$j]['dni'];

                // valido que el empleado exista
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],'terceros',"dni","terid");
                
                if($terid == "")
                    $motivo = "Empleado no existe";
                else
                {
                    // valido el concepto
                    $conceptoid = $_DATOS_EXCEL[$j]['conceptoid'];

                    $lb_valido = $io_fecha->uf_solo_numeros($conceptoid);

                    if(!$lb_valido)
                        $motivo = "Formato del concepto es invalido";
                    else
                    {
                        $recargo = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','recargo');
    
                        if($recargo != "CHECKED")
                            $motivo = "El concepto no es un recargo";
                        else
                        {
                            // valido el formato de la cantidad
                            $cantidad = $_DATOS_EXCEL[$j]['cantidad'];

                            $lb_valido2 = $io_fecha->uf_solo_numeros($cantidad);
        
                            if(!$lb_valido2)
                                $motivo = "Formato de la cantidad es invalido";
                            else
                            {
                                // inicialización de variables
                                $calculado = "";                                        $tabla = "";                                        $basico = 0;
                                $recargo = 0;                                           $numreg = 0;                                        $sueldo = 0;
                                $cargoid = 0;                                           $totnovedades = 0;                                  $totrecargos = 0;
                                $sueldodeducciones = 0;

                                // determino la tabla
                                $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

                                if($calculado == "CHECKED")
                                    $tabla = "tercerosactual";
                                else
                                    $tabla = "terceros";

                                // básico del empleado
                                $basico = $clase->BDLockup($terid,$tabla,'terid','basico');

                                // Determino si se calcula el recargo
                                $monto = $_DATOS_EXCEL[$j]['monto'];                                

                                if($monto > 0)
                                {
                                    // incremento el id
                                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                                    $numreg = $clase->SeleccionarUno($vsql);

                                    // almaceno el recargo
                                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,".$cantidad.",$basico)";
                                    $clase->EjecutarSQL($vsql);
                                }
                                else
                                {
                                    // Obtengo la formula del recargo                                    
                                    $formularecargo = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");
    
                                    // Calculo el recargo
                                    eval("\$recargo = $formularecargo;");
                                    $recargo = round($recargo,0);
    
                                    // incremento el id
                                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                                    $numreg = $clase->SeleccionarUno($vsql);
                                    
                                    // almaceno el recargo
                                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",".$conceptoid.",".$periodoid.",".$recargo.",0,".$cantidad.",$basico)";
                                    $clase->EjecutarSQL($vsql);
                                }

                                // recalculo salud y pensión
                                $vsql = "SELECT IFNULL(devengados,0) FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                                $sueldo = $clase->SeleccionarUno($vsql);                                    

                                // recalculo pensión y salud
                                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                           FROM detallenomina d
                                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                          WHERE d.terid = ".$terid."
                                                AND d.pernominaid = ".$periodoid." 
                                                AND (c.eslicencia = 'CHECKED' AND c.tipodc = 'C')";
                                $totnovedades = $clase->SeleccionarUno($vsql);

                                $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                                           FROM detallenomina d
                                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                          WHERE d.terid = ".$terid."
                                                AND d.pernominaid = ".$periodoid." 
                                                AND (c.recargo = 'CHECKED' AND c.tipodc = 'C')";
                                $totrecargos = $clase->SeleccionarUno($vsql);

                                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                                $cargoid = $clase->BDLockup($terid,$tabla,'terid','cargoid');                       // obtengo el cargo del empleado
                                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

                                $extralegal = $clase->BDLockup($terid,$tabla,'terid','extralegal');
                                $epsid = $clase->BDLockup($terid,$tabla,'terid','epsid');
                                $pensionesid = $clase->BDLockup($terid,$tabla,'terid','pensionesid');
                                
                                if($epsid==NULL)                $epsid=0;
                                if($pensionesid==NULL)          $pensionesid=0;

                                if($extralegal=="CHECKED")
                                {
                                    $pension = 0;
                                    $salud = 0;
                                }
                                else
                                {
                                    // Recalculo pensión y salud
                                    if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                        $pension = 0;
                                    else
                                    {
                                        // Obtengo la formula para el descuento por pensión
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                        $formulapension = $clase->SeleccionarUno($vsql);

                                        // Calculo la pensión
                                        eval("\$pension = $formulapension;");
                                        $pension = round($pension,0);
                                    }

                                    if(($epsid==37)||($aplicasalud!="CHECKED"))
                                        $salud = 0;
                                    else
                                    {
                                        // Obtengo la formula para el descuento de salud
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                        $formulasalud = $clase->SeleccionarUno($vsql);
                                        
                                        // Calculo la salud
                                        eval("\$salud = $formulasalud;");
                                        $salud = round($salud,0);
                                    }
                                }

                                //  ID pensión
                                $vsql = "SELECT detalleid AS idpension FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                                $idpension = $clase->SeleccionarUno($vsql);

                                // Grabo la pensión
                                if($idpension!="")
                                    $vsql = "UPDATE detallenomina SET 
                                                    descuentos = ".$pension.",
                                                    saldo = ".$sueldodeducciones."
                                              WHERE detalleid = ".$idpension;
                                else
                                {
                                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                                    $numreg = $clase->SeleccionarUno($vsql);

                                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                                }
                                $clase->EjecutarSQL($vsql);

                                // ID salud
                                $vsql = "SELECT detalleid AS idsalud FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                                $idsalud = $clase->SeleccionarUno($vsql);

                                // Grabo la salud
                                if($idsalud!="")
                                    $vsql = "UPDATE detallenomina SET 
                                                    descuentos = ".$salud.",
                                                    saldo = ".$sueldodeducciones."
                                              WHERE detalleid = ".$idsalud;
                                else
                                {
                                    $vsql = "SELECT max(detalleid) FROM detallenomina";
                                    $numreg = $clase->SeleccionarUno($vsql);

                                    $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                                }
                                $clase->EjecutarSQL($vsql);

                                $lbgrabo = true;
                                
                                // Aquí depuro los conceptos que estén en cero
                                $vsql = "DELETE FROM detallenomina WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                                $clase->EjecutarSQL($vsql);
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las códigos que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocodigos.= str_pad($dni,1,"").' -- '.str_pad($motivo,1,"").Chr(13).Chr(10);                       // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresrecargos.txt";                                                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                                                     // se abre el archivo para escribir
                    fwrite($fd, $nocodigos);                                                                            // Grabas
                    fclose($fd);                                                                                        // Cierras el archivo
                }
            }

            // --------------------------------------------------------------------------------------------------------------- //
            // Impresión de la fecha del último proceso ejecutado
            $mesimp = date('F');
            if($mesimp == "January")       $mesimp = "enero";
            if($mesimp == "February")      $mesimp = "febrero";
            if($mesimp == "March")         $mesimp = "marzo";
            if($mesimp == "April")         $mesimp = "abril";
            if($mesimp == "May")           $mesimp = "mayo";
            if($mesimp == "June")          $mesimp = "junio";
            if($mesimp == "July")          $mesimp = "julio";
            if($mesimp == "August")        $mesimp = "agosto";
            if($mesimp == "September")     $mesimp = "septiembre";
            if($mesimp == "October")       $mesimp = "octubre";
            if($mesimp == "November")      $mesimp = "noviembre";
            if($mesimp == "December")      $mesimp = "diciembre";

            $dayweek = date("l");
            if($dayweek == "Monday")       $dayweek = "lunes";
            if($dayweek == "Tuesday")      $dayweek = "martes";
            if($dayweek == "Wednesday")    $dayweek = "miércoles";
            if($dayweek == "Thursday")     $dayweek = "jueves";
            if($dayweek == "Friday")       $dayweek = "viernes";
            if($dayweek == "Saturday")     $dayweek = "sábado";
            if($dayweek == "Sunday")       $dayweek = "domingo";

            $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');

            $nocodigos.= ''.Chr(13).Chr(10);
            $nocodigos.= str_pad($fechoraimp,1,"").''.Chr(13).Chr(10);      // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresrecargos.txt";                               // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                 // se abre el archivo para escribir
            fwrite($fd, $nocodigos);                                        // Grabas
            fclose($fd);                                                    // Cierras el archivo
            // --------------------------------------------------------------------------------------------------------------- //
      
            // Elimino el Archivo
            unlink($destino);

            $clase->Aviso(1,"proceso culminado satisfactoriamente");
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=recargonocturno&periodoidanterior=$periodoid");
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererroresrecargos
    // Creación: 01/06/2024		última modificación: 06/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para ver los errores en el último proceso 
    //              de importación desde una hoja de Excel
    // Última modificación: Corrección del mensaje cuando todos pasan
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererroresrecargos")
    {
        $periodoid = $_GET['periodoid'];

        $htmlaceptar = '<a href="importacionexcelnom.php?opcion=recargonocturno&periodoidanterior='.$periodoid.'">';            

        // Inicialización de variables
        $archivoerror = "reportes/erroresrecargos.txt";
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        $txt = trim(str_replace("<br />","",$txt));
        $txt = trim(str_replace(" -- El concepto no es un recargo","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Documentos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
				   '.$htmlaceptar.' <input type="button" value="aceptar" class="button blue"> </a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: recargonocturnoliq
    // Creación: 05/06/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que procesa los recargos nocturnos de un periodo para liquidados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "recargonocturnoliq")
    {
        $periodoid = $_GET["periodoid"];
        $codperiodo = $_GET["codperiodo"];

        // nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // validación de servidor 248
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $btoimportarnoc = '<img src="images/iconos/cargar.png" title="subir recargos nocturnos - debe ir al servidor 248" border="0" width="32" height="32">';
        else
            $btoimportarnoc = '<a href="?opcion=importarexcelrecaargo1liq&periodoid='.$periodoid.'&codperiodo='.$codperiodo.'" rel="facebox">
                                <img src="images/iconos/cargar.png" title="Subir recargos nocturnos" border="0" width="32" height="32"> 
                               </a> ';
                               
        // valido que el archivo de mostrar errores exista
        $archivoerror = "reportes/erroresrecargos.txt";
        if (file_exists ($archivoerror))
            $htmlarchivoerror = '<a href="?opcion=vererroresrecargos&periodoid='.$periodoid.'" rel="facebox">
                                  <img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&eacute;dulas de empleados no guardados en el &uacute;ltimo proceso de importaci&oacute;n">
                                 </a>';
        else
            $htmlarchivoerror = '<img src="images/iconos/notas.png" border="0" width="32" height="32" title="c&eacute;dulas de empleados no guardados en el &uacute;ltimo proceso de importaci&oacute;n">';

        // consulta de la vista
        $vsql = "SELECT d.detalleid, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, d.valor, d.devengados, c.nomconcepto 
                   FROM terceros t
                        INNER JOIN detalleliquidacion d ON (t.terid = d.terid)  
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)      
                  WHERE d.pernominaid = ".$periodoid."
                        AND c.recargo = 'CHECKED'";

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Recargos para liquidados <br> <font color="blue"> '.$descripcion.' </font> </b> </td>
                  <td width="30"> '.$btoimportarnoc.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30" align="center"> '.$htmlarchivoerror.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=ventanaincregargoliq&periodoid='.$periodoid.'" rel="facebox"> 
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="nuevo recargo nocturno"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="40" align="center"> 
                   <a href="importacionexcelnom.php?opcion=ventanaimportacion"> 
                    <input type="button" value="<<" class="button blue" title="ventana principal"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>                  
                 </tr> 
                </table>';

        // detalle de la ventana
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="11"> &nbsp; </td>
                   <td width="120" align="left"> Documento </td>
                   <td width="300" align="left"> Empleado </td>                   
                   <td width="280" align="left"> Concepto </td>
                   <td width="110" align="right"> Cantidad </td>
                   <td width="150" align="right"> Monto </td>
                   <td width="60"> &nbsp; </td>
                   <td width="60"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';        

        $i = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
            
            $cont.=' <td width="11"> &nbsp; </td>
                     <td width="120" align="left"> '.$row['dni'].' </td>
                     <td width="300" align="left"> '.$row['nombreemp'].' </td>
                     <td width="280" align="left"> '.$row['nomconcepto'].' </td>
                     <td width="110" align="right"> '.number_format($row['valor']).' </td>
                     <td width="150" align="right"> '.number_format($row['devengados']).' </td>
                     <td width="50" align="right"> &nbsp; </td>
                     <td width="26" align="center"> &nbsp; </td>
                     <td width="26" align="center">
                      <a href="?opcion=confirmareliminarrecargoliq&detalleid='.$row['detalleid'].'&periodoid='.$periodoid.'" rel="facebox">
                       <img src="images/basicas/borrados.png" title="eliminar y recalcular" border="0" width="20" height="20">
                      </a>
                     </td>
                    </tr>';
        }

        $cont.=' </tbody>
                </table>';
   
        // pie de página
        $cont.='<table width="100%"> <tr class="TituloTabla"> <td width="1608"> &nbsp; </td> </tr> </table>';        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmareliminarrecargoliq
    // Creación: 05/06/2024		última modificación: 07/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de un recargo 
    //              nocturno para liquidados
    // Última modificación: Ajuste para todos los tipos de recargo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmareliminarrecargoliq")
    {
        $detalleid = $_GET["detalleid"];
        $periodoid = $_GET["periodoid"];        

        // determino el empleado
        $vsql = "SELECT terid FROM detalleliquidacion WHERE detalleid = ".$detalleid;
        $terid = $clase->SeleccionarUno($vsql);
        
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid= ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql);

        // dias y monto
        $conceptoid = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','conceptoid');
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        $cantidad = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','valor');
        $monto = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','devengados');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="350" align="center"> <br> <label class="Texto12"> <b> Eliminar recargo para liquidaci&oacute;n </b> </label> <br><br> </td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <br>
                   <label class="Texto12">
                   ¿Confirma que desea eliminar <br> <b> '.$nomconcepto.' </b> de <br> <b> '.$nombreemp.' </b> <br> de cantidad <b> '.number_format($cantidad).' </b> por un monto de <b> '.number_format($monto).' </b> pesos? 
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarecargoliq" method="POST">
                   <input type="hidden" name="detalleid" value="'.$detalleid.'"> 
                   <input type="hidden" name="periodoid" value="'.$periodoid.'">                   
                   <input type="submit" value="ACEPTAR" class="button blue">                   
                   <a href="importacionexcelnom.php?opcion=recargonocturnoliq&periodoid='.$periodoid.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarecargoliq
    // Creación: 05/06/2024		última modificación: 07/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que elimina un recargo nocturno y recalcula al empleado para
    //              liquidados
    // Última modificación: Ajuste para todos los tipos de recargo y validación de 
    //                      liquidación cerrada
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarecargoliq")
    {
        $detalleid = $_POST["detalleid"];
        $periodoid = $_POST["periodoid"];

        // determino el empleado
        $vsql = "SELECT terid FROM detalleliquidacion WHERE detalleid = ".$detalleid;
        $terid = $clase->SeleccionarUno($vsql);

        // valido que la liquidación no esté cerrada
        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
        $codperiodoaux = substr($fechasta,5,2).substr($fechasta,0,4);
        $norecalcular = $clase->SeleccionarUno("SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodoaux."'");

        if($norecalcular == "CHECKED")
            $clase->Aviso(3,"Esta liquidación está cerrada");
        else
        {
            // determino su sueldo básiuco
            $basico = $clase->BDLockup($terid,'terceros','terid','basico');

            // elimino el recargo
            $vsql = "DELETE FROM detalleliquidacion WHERE detalleid = ".$detalleid;
            $clase->EjecutarSQL($vsql);
    
            // recalculo salud y pensión
            $vsql = "SELECT IFNULL(devengados,0) FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
            $sueldo = $clase->SeleccionarUno($vsql);        
    
            // recalculo pensión y salud
            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                       FROM detalleliquidacion d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
            $totnovedades = $clase->SeleccionarUno($vsql);
    
            $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                       FROM detalleliquidacion d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
            $totrecargos = $clase->SeleccionarUno($vsql);
    
            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
    
            $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
            if($extralegal=="CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);
    
                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }
    
                if(($epsid==37)||($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }
            }
    
            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);
    
            // Grabo la pensión
            if($idpension!="")
                $vsql = "UPDATE detalleliquidacion SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension;
            else
            {
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);
    
            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);
    
            // Grabo la salud
            if($idsalud!="")
                $vsql = "UPDATE detalleliquidacion SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud;
            else
            {
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);
            
            // Aquí depuro los conceptos que estén en cero
            $vsql = "DELETE FROM detalleliquidacion WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
            $clase->EjecutarSQL($vsql);

            // actualizo la tabla tmpinfliquidados
            $idliquidados = $clase->SeleccionarUno("SELECT idliquidados FROM tmpinfliquidados WHERE terid = ".$terid." AND codperiodo = '".$codperiodoaux."'");            

            if(strlen($idliquidados) > 0)
            {
                $totaldevengado = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','totaldevengado');                

                $listaperiodos = generarlistaper($codperiodoaux);

                // otros descuentos
                $vsq23 = "SELECT SUM(IF(descuentos>0,descuentos,0)) otrosdescuentos
                            FROM detalleliquidacion 
                           WHERE terid = ".$terid." 
                                 AND pernominaid IN ($listaperiodos) 
                                 AND conceptoid NOT IN (4,5,6,9,43,58) LIMIT 0,1";
                $otrosdescuentos = $clase->SeleccionarUno($vsq23);                

                // total descuento
                $totaldescuento = $pension + $salud + $otrosdescuentos;

                // neto a pagar
                $netoapagar = $totaldevengado - $totaldescuento;

                // grabo los totales
                $vsql = "UPDATE tmpinfliquidados SET  
                                pension = ".$pension.",
                                salud = ".$salud.",
                                totaldescuento = ".$totaldescuento.",
                                netoapagar = ".$netoapagar."
                        WHERE idliquidados = ".$idliquidados;
                $clase->EjecutarSQL($vsql);
            }
    
            // emito el mensaje correspondiente
            $clase->Aviso(1,"Recargo eliminado satisfactoriamente");
        }

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=recargonocturnoliq&periodoid=$periodoid");
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaincregargoliq
    // Creación: 05/06/2024		última modificación: 08/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para captar los datos del nuevo recargo 
    //              nocturno para liquidados
    // Última modificación: Adaptación para todos los tipos de recargo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaincregargoliq")
    {
        $periodoid = $_GET["periodoid"];

        // combo de empleado de acuerdo al periodo
        $params = ' class="Texto12" ';

        // consulta del combo
        $vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                           FROM terceros 
                          WHERE basico > 0 
                                AND (primernombre <> '' AND primerapellido <> '') 
                       ORDER BY primernombre";
        $comboemp  = $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombreemp","terid",$terid,"S",$params,500);

        // combo de recargos
        $vsqlcomborecargo = "SELECT conceptoid, nomconcepto descripcion FROM conceptosnomina WHERE recargo = 'CHECKED'";
        $comborecargo = $clase->CrearComboBuscar("conceptoid",$vsqlcomborecargo,"descripcion","conceptoid","","S",$params,400);

        // cantidad
        $cantidad = 1;

        // pinto la ventana
        $cont ='<table width="700">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
                  <td width="650" align="center"> <b> Incluir recargo para liquidaci&oacute;n </b> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardarrecargoliq" method="POST" name="x">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <table width="700">
                 <center>
				 <tr class="TablaDocsImPar" style="height:40px;Important!">
				  <td width="100" align="right"> <label class="Texto12"> Empleado: </label> </td>
				  <td width="600"> &nbsp; '.$comboemp.' </td>
				 </tr>
				 <tr class="TablaDocsImPar" style="height:40px;Important!">
				  <td width="100" align="right"> <label class="Texto12"> Concepto: </label> </td>
				  <td width="600"> &nbsp; '.$comborecargo.' </td>
				 </tr>
                 <tr class="TablaDocsImPar" style="height:40px;Important!">
                  <td width="100" align="right"> <label class="Texto12"> D&iacute;as: </label> </td>
                  <td width="600">
                   &nbsp;
                   <input type="number" name="cantidad" class="Texto12New" size="4" min="1" style="width:60px;height:25px" value="'.$cantidad.'">
                  </td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="importacionexcelnom.php?opcion=recargonocturnoliq&periodoid='.$periodoid.'"><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarrecargoliq
    // Creación: 05/06/2024		última modificación: 08/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda el nuevo recargo nocturno
    // Última modificación: Adaptación para todos los tipos de recargo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarrecargoliq")
    {
        $terid = $_POST["terid"];
        $periodoid = $_POST["periodoid"];
        $conceptoid = $_POST["conceptoid"];
        $cantidad = $_POST["cantidad"];        
    
        // valido la entrada de datos
        if((strlen($conceptoid == 0)) || (strlen($terid) == 0))
            $clase->Aviso(3,"Debe incluir empleado y concepto");
        else
        {
            // valido que la liquidación no esté cerrada
            $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
            $codperiodoaux = substr($fechasta,5,2).substr($fechasta,0,4);
            $norecalcular = $clase->SeleccionarUno("SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodoaux."'");

            if($norecalcular == "CHECKED")
                $clase->Aviso(3,"Esta liquidación está cerrada");
            else
            {
                // inicialización de variables
                $calculado = "";                                        $tabla = "";                                        $basico = 0;
                $recargo = 0;                                           $numreg = 0;                                        $sueldo = 0;
                $cargoid = 0;                                           $totnovedades = 0;                                  $totrecargos = 0;
                $sueldodeducciones = 0;
        
                // básico del empleado
                $vsql17 = "SELECT IFNULL(hc.ultsueldo,0) basico 
                             FROM histcontrato hc
                            WHERE hc.terid = ".$terid." 
                                  AND hc.id = (SELECT MAX(id)
                                                 FROM histcontrato
                                                WHERE terid = ".$terid.")";
                $basico = $clase->SeleccionarUno($vsql17);
    
                if(($basico == "") || ($basico == 0))
                    $basico = $clase->BDLockup($terid,'terceros','terid','basico');
        
                // Obtengo la formula del recargo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
                $formularecargo = $clase->SeleccionarUno($vsql);
        
                // Calculo el recargo
                eval("\$recargo = $formularecargo;");
                $recargo = round($recargo,0);
        
                // incremento el id
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);
                
                // almaceno el recargo
                $vsql = "INSERT INTO detallenomina VALUES ($numreg+1,".$terid.",".$conceptoid.",".$periodoid.",".$recargo.",0,".$cantidad.",$basico)";
                $clase->EjecutarSQL($vsql);
        
                // recalculo salud y pensión
                $vsql = "SELECT IFNULL(devengados,0) FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                $sueldo = $clase->SeleccionarUno($vsql);
        
                // recalculo pensión y salud
                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                           FROM detalleliquidacion d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                $totnovedades = $clase->SeleccionarUno($vsql);
        
                $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                           FROM detalleliquidacion d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoid." 
                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                $totrecargos = $clase->SeleccionarUno($vsql);
        
                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
        
                $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');
                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
        
                if($extralegal=="CHECKED")
                {
                    $pension = 0;
                    $salud = 0;
                }
                else
                {
                    // Recalculo pensión y salud
                    if(($pensionesid==5)||($aplicapension!="CHECKED"))
                        $pension = 0;
                    else
                    {
                        // Obtengo la formula para el descuento por pensión
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                        $formulapension = $clase->SeleccionarUno($vsql);
        
                        // Calculo la pensión
                        eval("\$pension = $formulapension;");
                        $pension = round($pension,0);
                    }
        
                    if(($epsid==37)||($aplicasalud!="CHECKED"))
                        $salud = 0;
                    else
                    {
                        // Obtengo la formula para el descuento de salud
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                        $formulasalud = $clase->SeleccionarUno($vsql);
                        
                        // Calculo la salud
                        eval("\$salud = $formulasalud;");
                        $salud = round($salud,0);
                    }
                }
        
                //  ID pensión
                $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                $idpension = $clase->SeleccionarUno($vsql);
        
                // Grabo la pensión
                if($idpension!="")
                    $vsql = "UPDATE detalleliquidacion SET 
                                    descuentos = ".$pension.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idpension;
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
        
                // ID salud
                $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                $idsalud = $clase->SeleccionarUno($vsql);
        
                // Grabo la salud
                if($idsalud!="")
                    $vsql = "UPDATE detalleliquidacion SET 
                                    descuentos = ".$salud.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idsalud;
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);
                
                // Aquí depuro los conceptos que estén en cero
                $vsql = "DELETE FROM detalleliquidacion WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                $clase->EjecutarSQL($vsql);
        
                // emito el mensaje correspondiente
                $clase->Aviso(1,"Recargo nocturno almacenado satisfactoriamente");
            }
        }

        // Redirecciona el formulario
        header("Location: importacionexcelnom.php?opcion=recargonocturnoliq&periodoid=$periodoid");
    } 
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcelrecaargo1liq
    // Creación: 05/06/2024		última modificación: 08/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con los 
    //              empleados con recargo nocturno
    // Última modificación: Adaptación para todos los tipos de recargo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcelrecaargo1liq")
    {
        $periodoid = $_GET["periodoid"];
        $codperiodo = $_GET["codperiodo"];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor dir&iacute;jase al servidor </font> <br>
                       <a href="http://192.168.14.248:9999/dropos/login/" target="_blank"> 
                        <font color=blue> 192.168.14.248:9999 </font> <br>                        
                       </a>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=recargonocturnoliq&periodoidanterior='.$periodoid.'" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // nombre del periodo
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');            
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Importar recargos nocturnos para liquidaci&oacute;n <br> <font color="blue">'.strtolower($descripcion).'</font></b> </td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=importarexcelrecaargo2liq" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="file" name="excel" /> <br> <br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Concepto </td> </tr> 
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Cantidad </td> </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp;  <font color="blue"> <b> 47 </b> </font> RECARGO NOCTURNO <font color="blue"> <b> 49 </b> </font> HORA EXTRA DIURNA
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b> 50 </b> </font> HORA EXTRA NOCTURNA  <font color="blue"> <b> 51 </b> </font> HORA EXTRA DIURNA DOMINICAL
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b> 52 </b> </font> HORA EXTRA NOCTURNA DOMINICAL Y FESTIVO 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b> 53 </b> </font> DOMINGOS Y FESTIVOS
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"> <b> 54 </b> </font> RECARGO NOCTURNO DOMINICAL Y FESTIVO
                      </td> 
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplorecargos.png" width="280" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcelrecaargo2liq
    // Creación: 05/06/2024		última modificación: 08/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que procesa los empleados con recargo nocturno desde una hoja de 
    //              Excel
    // Última modificación: Adaptación para todos los tipos de recargo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcelrecaargo2liq")
    {
		set_time_limit(0);
		extract($_POST);
        $periodoid = $_POST["periodoid"];
        $codperiodo = $_POST["codperiodo"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;
        
        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
					$_DATOS_EXCEL[$i]['conceptoid'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cantidad'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();                    
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0) || (strlen($_DATOS_EXCEL[$i]['conceptoid']) == 0) || (strlen($_DATOS_EXCEL[$i]['cantidad']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocodigos = 'RECARGOS'.Chr(13).Chr(10);
            $nocodigos.= 'CEDULAS NO GRABADAS:'.Chr(13).Chr(10);
            $nocodigos.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                // inicialización de variables
                $lbgrabo = false;
                $motivo = "";
                $lb_valido = false;
                $lb_valido2 = false;
                $numrecargo = 0;

                $dni = $_DATOS_EXCEL[$j]['dni'];

                // valido que el empleado exista
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],'terceros',"dni","terid");
                
                if($terid == "")
                    $motivo = "Empleado no existe";
                else
                {
                    // valido el concepto
                    $conceptoid = $_DATOS_EXCEL[$j]['conceptoid'];

                    $lb_valido = $io_fecha->uf_solo_numeros($conceptoid);

                    if(!$lb_valido)
                        $motivo = "Formato del concepto es invalido";
                    else
                    {
                        $recargo = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','recargo');
    
                        if($recargo != "CHECKED")
                            $motivo = "El concepto no es un recargo";
                        else
                        {
                            // Valido que el empleado no posea recargo 
                            $numrecargo = $clase->SeleccionarUno("SELECT COUNT(*) numrecargo FROM detalleliquidacion WHERE pernominaid = ".$periodoid." AND conceptoid = ".$conceptoid." AND terid = ".$terid."");
                            
                            if($numrecargo > 0)
                            {
                                $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
                                $motivo = "Empleado ya tiene ".trim($nomconcepto)." en este periodo";                                
                            }
                            else
                            {
                                // inicialización de variables
                                $calculado = "";                                        $tabla = "";                                        $basico = 0;
                                $recargo = 0;                                           $numreg = 0;                                        $sueldo = 0;
                                $cargoid = 0;                                           $totnovedades = 0;                                  $totrecargos = 0;
                                $sueldodeducciones = 0;

                                // básico del empleado
                                $basico = $clase->BDLockup($terid,$tabla,'terid','basico');

                                // Obtengo la formula del recargo                                    
                                $formularecargo = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                                // Calculo el recargo
                                eval("\$recargo = $formularecargo;");
                                $recargo = round($recargo,0);

                                // incremento el id
                                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                $numreg = $clase->SeleccionarUno($vsql);

                                // almaceno el recargo
                                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",".$conceptoid.",".$periodoid.",".$recargo.",0,".$cantidad.",$basico)";
                                $clase->EjecutarSQL($vsql);

                                // recalculo salud y pensión
                                $vsql = "SELECT IFNULL(devengados,0) FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                                $sueldo = $clase->SeleccionarUno($vsql);

                                $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');

                                // recalculo pensión y salud
                                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                           FROM detalleliquidacion d
                                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                          WHERE d.terid = ".$terid."
                                                AND d.pernominaid = ".$periodoid." 
                                                AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                                $totnovedades = $clase->SeleccionarUno($vsql);

                                $vsql = "SELECT SUM(d.devengados) AS totrecargos 
                                           FROM detalleliquidacion d
                                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                          WHERE d.terid = ".$terid."
                                                AND d.pernominaid = ".$periodoid." 
                                                AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                                $totrecargos = $clase->SeleccionarUno($vsql);

                                $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

                                $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                                $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                                $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                                
                                if($epsid==NULL)                $epsid=0;
                                if($pensionesid==NULL)          $pensionesid=0;

                                if($extralegal=="CHECKED")
                                {
                                    $pension = 0;
                                    $salud = 0;
                                }
                                else
                                {
                                    // Recalculo pensión y salud
                                    if(($pensionesid==5)||($aplicapension!="CHECKED"))
                                        $pension = 0;
                                    else
                                    {
                                        // Obtengo la formula para el descuento por pensión
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                        $formulapension = $clase->SeleccionarUno($vsql);

                                        // Calculo la pensión
                                        eval("\$pension = $formulapension;");
                                        $pension = round($pension,0);
                                    }

                                    if(($epsid==37)||($aplicasalud!="CHECKED"))
                                        $salud = 0;
                                    else
                                    {
                                        // Obtengo la formula para el descuento de salud
                                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                        $formulasalud = $clase->SeleccionarUno($vsql);
                                        
                                        // Calculo la salud
                                        eval("\$salud = $formulasalud;");
                                        $salud = round($salud,0);
                                    }
                                }

                                //  ID pensión
                                $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                                $idpension = $clase->SeleccionarUno($vsql);

                                // Grabo la pensión
                                if($idpension!="")
                                    $vsql = "UPDATE detalleliquidacion SET 
                                                    descuentos = ".$pension.",
                                                    saldo = ".$sueldodeducciones."
                                              WHERE detalleid = ".$idpension;
                                else
                                {
                                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                    $numreg = $clase->SeleccionarUno($vsql);

                                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
                                }
                                $clase->EjecutarSQL($vsql);

                                // ID salud
                                $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                                $idsalud = $clase->SeleccionarUno($vsql);

                                // Grabo la salud
                                if($idsalud!="")
                                    $vsql = "UPDATE detalleliquidacion SET 
                                                    descuentos = ".$salud.",
                                                    saldo = ".$sueldodeducciones."
                                              WHERE detalleid = ".$idsalud;
                                else
                                {
                                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                                    $numreg = $clase->SeleccionarUno($vsql);

                                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
                                }
                                $clase->EjecutarSQL($vsql);
                                
                                // Aquí depuro los conceptos que estén en cero
                                $vsql = "DELETE FROM detalleliquidacion WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                                $clase->EjecutarSQL($vsql);

                                $lbgrabo = true;

                                // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
                                // Recalculo las primas, cesantías y vacaciones

                                // obtengo los parámetros de cálculo
                                $vsql41 = "SELECT cesantiasyearanterior FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $cesantiasyearanterior = $clase->SeleccionarUno($vsql41);

                                $vsql42 = "SELECT cesantiasyearactual FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $cesantiasyearactual = $clase->SeleccionarUno($vsql42);

                                $vsql43 = "SELECT intcesantiasyearanterior FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $intcesantiasyearanterior = $clase->SeleccionarUno($vsql43);

                                $vsql44 = "SELECT intcesantiasyearactual FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $intcesantiasyearactual = $clase->SeleccionarUno($vsql44);

                                $vsql45 = "SELECT vacaciones FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $vacaciones = $clase->SeleccionarUno($vsql45);

                                $vsql46 = "SELECT primasprimersemestre FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $primasprimersemestre = $clase->SeleccionarUno($vsql46);

                                $vsql47 = "SELECT primassegundosemestre FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                                $primassegundosemestre = $clase->SeleccionarUno($vsql47);                                

                                // Inicialización de variables
                                $diasps = 0;
                                $diasss = 0;

                                // fechas de ingreso y retiro
                                $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                                $idhistorico = $clase->SeleccionarUno($vsql18);

                                $vsql21 = "SELECT hc.fecingreso
                                             FROM histcontrato hc
                                            WHERE hc.terid = ".$terid." 
                                                  AND hc.id = ".$idhistorico;
                                $fecingreso = $clase->SeleccionarUno($vsql21);

                                $vsql21 = "SELECT hc.fecretiro 
                                             FROM histcontrato hc
                                            WHERE hc.terid = ".$terid." 
                                                  AND hc.id = ".$idhistorico;
                                $fecretiro = $clase->SeleccionarUno($vsql21);

                                $yearingreso = intval(substr($fecingreso,0,4));         // año de la fecha de ingreso

                                // validación del subsidio de transporte
                                $smlv = $_SESSION['N_SALMIN2020'];
                                $valtransporte = $smlv * 2;

                                if($basico > $valtransporte)
                                    $auxtrans = 0;
                                else
                                    $auxtrans = $_SESSION['N_AUXTRANS2020'];                            

                                // Determino si hubo un cambio de salario en los últimos tres meses
                                $tienecambio = tienecambiosalario($terid,$fecretiro);        

                                if($tienecambio)
                                {
                                    $promsueldoact = calsueldopromedio($terid,$fecingreso);
                                    $basico = $promsueldoact;
                                }

                                // año anterior
                                $yearprev = date("Y") - 1;

                                if($yearingreso>$yearprev)
                                {
                                    $basicoant = 0;
                                    $auxtransant = 0;
                                    $diasyearant = 0;
                                    $sueldointegralant = 0;
                                }
                                else
                                {
                                    // máximo periodo del año anterior
                                    $vsql = " SELECT MAX(periodoid) AS periodoidant FROM periodosnomina WHERE YEAR(fechasta) = ".$yearprev." ";
                                    $periodoidant = $clase->SeleccionarUno($vsql);
                            
                                    // básico de año anterior            
                                    $vsql = "SELECT saldo 
                                               FROM hisdetallenomina 
                                              WHERE terid = ".$terid." 
                                                    AND pernominaid = ".$periodoidant." 
                                                    AND conceptoid IN (1,10,11,12,13,31,38,40,43)";
                                    $basicoant = $clase->SeleccionarUno($vsql);

                                    // ------------------------------------------------------------------------------------------- //
                                    $vsql25 = "SELECT MIN(periodoid) permin2
                                                 FROM periodosnomina 
                                                WHERE fecdesde >= '".$fecingreso."' 
                                                      AND YEAR(fecdesde) = ".$yearprev." 
                                                      AND cerrado = 'CHECKED' ";
                                    $permin2 = $clase->SeleccionarUno($vsql25);

                                    if(strlen($permin2) == 0)
                                    {
                                        $vsql25 = "SELECT MIN(periodoid) permin2
                                                     FROM periodosnomina 
                                                    WHERE fecdesde >= '".$fecingreso."'
                                                          AND cerrado = 'CHECKED' ";
                                        $permin2 = $clase->SeleccionarUno($vsql25);
                                        $permin2--;
                                    }                                
                                    
                                    $vsql26 = "SELECT MAX(periodoid) permax2
                                                 FROM periodosnomina 
                                                WHERE fecdesde >= '".$fecingreso."' 
                                                      AND YEAR(fecdesde) = ".$yearprev." 
                                                      AND cerrado = 'CHECKED' ";
                                    $permax2 = $clase->SeleccionarUno($vsql26);

                                    if(strlen($permax2) == 0)
                                        $permax2 = $permin2;
                                    // ------------------------------------------------------------------------------------------- //                                
                            
                                    if(($basicoant==0)||($basicoant==NULL))
                                    {
                                        $basicoant = 0;
                                        $auxtransant = 0;
                                        $diasyearant = 0;
                                        $sueldointegralant = 0;
                                    }
                                    else
                                    {
                                        // auxilio de transporte del año anterior
                                        $vsql = "SELECT saldo FROM hisdetallenomina WHERE conceptoid = 3 AND pernominaid = ".$periodoidant." AND terid = ".$terid;
                                        $auxtransant = $clase->SeleccionarUno($vsql);
                            
                                        // Sueldo integral del año anterior
                                        $sueldointegralant = $basicoant + $auxtransant;
                            
                                        // días laborados el año anterior
                                        $vsql = "SELECT periodoid
                                                   FROM periodosnomina
                                                  WHERE fecdesde <= '".$fecingreso."'
                                                        AND fechasta >= '".$fecingreso."'";
                                        $eneroant = $clase->SeleccionarUno($vsql);

                                        $vsql = "SELECT SUM(valor) AS diasyearant 
                                                   FROM hisdetallenomina 
                                                  WHERE terid = ".$terid." 
                                                        AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                        AND pernominaid BETWEEN ".$eneroant." AND ".$periodoidant." 
                                                        AND pernominaid NOT IN (SELECT pernominaid 
                                                                                  FROM periodoterceros 
                                                                                  WHERE periodoterceros.terid = ".$terid." 
                                                                                        AND periodoterceros.pernominaid BETWEEN ".$permin2." AND ".$permax2." 
                                                                                        AND periodoterceros.extralegal = 'CHECKED')";
                                        $diasyearant = $clase->SeleccionarUno($vsql);
                                    }
                                }

                                // ----------------------------------------------------------------------------------------------- //
                                // Días laborados en el primer trimestre del año actual
                                $yeartoday = date("Y");

                                $comienzoprimersemestre = $yeartoday."-01-01";
                                $finprimersemestre = $yeartoday."-06-30";

                                // si el empleado ingresó en este periodo
                                if($fecingreso>=$comienzoprimersemestre)
                                {            
                                    $vsql = " SELECT MAX(periodoid) AS primeroenero FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
                                    $primeroenero = $clase->SeleccionarUno($vsql);
                            
                                    $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
                                    $treintajunio = $clase->SeleccionarUno($vsql);
                            
                                    // Días en el histórico
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                                               FROM hisdetallenomina 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio." 
                                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                                    $diasps = $clase->SeleccionarUno($vsql);
                            
                                    // Días en la liquidación        
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                               FROM detalleliquidacion 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
                                    $diasliq = $clase->SeleccionarUno($vsql);
                            
                                    $diasps += $diasliq;
                                }

                                if(($fecingreso<$comienzoprimersemestre)&&($diasyearant>0))
                                {
                                    $diasliq = 0;
                                    $vsql = " SELECT periodoid AS primeroenero FROM periodosnomina WHERE fecdesde = '".$comienzoprimersemestre."' ";
                                    $primeroenero = $clase->SeleccionarUno($vsql);

                                    $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
                                    $treintajunio = $clase->SeleccionarUno($vsql);
                            
                                    // Días en el histórico
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                                               FROM hisdetallenomina 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                                    $diasps = $clase->SeleccionarUno($vsql);
                            
                                    // Días en la liquidación        
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                               FROM detalleliquidacion 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40)
                                                    AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
                                    $diasliq = $clase->SeleccionarUno($vsql);
                            
                                    $diasps += $diasliq;
                                }

                                // Días laborados en el segundo semestre del año
                                $inisegsemestre = $yeartoday."-07-01";
                                $finsegsemestre = $yeartoday."-12-31";

                                // si el empleado ingresó en este periodo
                                if($fecingreso>=$inisegsemestre)
                                {
                                    $vsql = " SELECT MAX(periodoid) AS primerojulio FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
                                    $primerojulio = $clase->SeleccionarUno($vsql);

                                    $vsql = " SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."' ";
                                    $treintayuno = $clase->SeleccionarUno($vsql);

                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                                               FROM hisdetallenomina 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                              WHERE periodoterceros.terid = ".$terid." 
                                                                                    AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                                    AND periodoterceros.extralegal = 'CHECKED')";
                                    $diasss = $clase->SeleccionarUno($vsql);
                            
                                    // Días en la liquidación        
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq 
                                               FROM detalleliquidacion 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
                                    $diasliq = $clase->SeleccionarUno($vsql);
                            
                                    $diasss += $diasliq;
                                }

                                if(($fecingreso<$inisegsemestre)&&($diasps>0))
                                {
                                    $vsql = "SELECT periodoid AS primerojulio FROM periodosnomina WHERE fecdesde = '".$inisegsemestre."'";
                                    $primerojulio = $clase->SeleccionarUno($vsql);

                                    $vsql = "SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."'";
                                    $treintayuno = $clase->SeleccionarUno($vsql);

                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                                               FROM hisdetallenomina 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                                                    AND pernominaid NOT IN (SELECT pernominaid 
                                                                              FROM periodoterceros
                                                                             WHERE periodoterceros.terid = ".$terid." 
                                                                                   AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                                   AND periodoterceros.extralegal = 'CHECKED')";
                                    $diasss = $clase->SeleccionarUno($vsql);
                            
                                    // Días en la liquidación
                                    $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq 
                                               FROM detalleliquidacion 
                                              WHERE terid = ".$terid." 
                                                    AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                    AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
                                    $diasliq = $clase->SeleccionarUno($vsql);
                            
                                    $diasss += $diasliq;
                                }

                                // Inicialización de variables
                                $pagocenact = 0;                            $cantidad = 0;                          $porcentaje = 0;                        $pagointereses = 0;
                                $pagovaca = 0;                              $diasvaca = 0;                          $diasprima = 0;                         $pagoprimasps = 0;
                                $lbprocesado = false;                       $pagocesant = 0;                        $cantidadact = 0;                       $cantidadant = 0;
                                $pagocesantias = 0;                         $interesesact = 0;                      $interesesant = 0;                      $pagoprimasss = 0;
                                $pagoprimas = 0;                            $recarnonocturno = 0;                   $ultimobasico = 0;                      $auxtrans = $_SESSION['N_AUXTRANS2020'];

                                // ---------------------------------------------------------- //
                                // Cálculo de cesantías
                                if(($cesantiasyearactual == "SI")||($cesantiasyearanterior == "SI")||($intcesantiasyearactual == "SI")||($intcesantiasyearanterior == "SI"))
                                {
                                    // Cálculo de cesantías del año actual
                                    if($cesantiasyearactual == "SI")
                                    {
                                        $cantidadact = $diasps + $diasss;
                                        $pagocenact = ($basico + $auxtrans) * $cantidadact / 360;

                                    }
                                    else
                                    {
                                        $pagocenact = 0;
                                        $cantidadact = 0;
                                    }
                                    
                                    // Cálculo de cesantías del año anterior
                                    if($cesantiasyearanterior == "SI")
                                    {
                                        $pagocesant = ($sueldointegralant + $auxtrans) * $diasyearant / 360;
                                        $cantidadant = $diasyearant;
                                    }
                                    else
                                    {
                                        $pagocesant = 0;
                                        $cantidadant = 0;
                                    }
                                    
                                    // sub totales
                                    $pagocesantias = $pagocenact + $pagocesant;
                                    $pagocesantias = round($pagocesantias,2);
                                    $cantidad = $cantidadact + $cantidadant;
                                    $porcentaje = 12;

                                    // Intereses año actual
                                    if($intcesantiasyearactual == "SI")
                                        $interesesact = (($pagocenact * ($diasps + $diasss)) * 0.12 / 360);
                                    else
                                        $interesesact = 0;

                                    // intereses del año anterior
                                    if($intcesantiasyearanterior == "SI")
                                        $interesesant = (($pagocesant * $diasyearant) * 0.12 / 360);
                                    else
                                        $interesesant = 0;

                                    $pagointereses = $interesesact + $interesesant;
                                    $pagointereses = round($pagointereses,2);

                                    // Valido la existencia de este concepto
                                    $repetido = 0;          $vsql22 = "";               $vsql23 = "";               $vsql24 = "";

                                    $vsql22 = "SELECT COUNT(*) repetido FROM liquidacion WHERE terid = ".$terid." AND tipo = 'cesantias' AND periodonomina = '".$codperiodo."'";
                                    $repetido = $clase->SeleccionarUno($vsql22);

                                    if($repetido > 0)
                                    {
                                        $vsql23 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND tipo = 'cesantias' AND periodonomina = '".$codperiodo."'";
                                        $idliquidacion = $clase->SeleccionarUno($vsql23);

                                        $vsql24 = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
                                        $clase->EjecutarSQL($vsql24);
                                    }

                                    // Guardo en la tabla
                                    $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                                            VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcentaje.",".$pagointereses.")";
                                    $clase->EjecutarSQL($vsql);
                                }

                                // ---------------------------------------------------------- //
                                // Cálculo de vacaciones
                                if($vacaciones == "SI")
                                {
                                    // Determino si hay vacaciones canceladas previamente
                                    $vsql22 = "SELECT MIN(periodoid) permin
                                                 FROM periodosnomina 
                                                WHERE fecdesde >= '".$fecingreso."' 
                                                      AND cerrado = 'CHECKED' ";
                                    $permin = $clase->SeleccionarUno($vsql22);

                                    // Determino si hay vacaciones canceladas previamente
                                    $vsql23 = "SELECT MAX(periodoid) permax
                                                 FROM periodosnomina 
                                                WHERE fecdesde >= '".$fecingreso."' 
                                                      AND cerrado = 'CHECKED' ";
                                    $permax = $clase->SeleccionarUno($vsql23);

                                    $vsql24 = "SELECT pernominaid pervacaciones
                                                 FROM hisdetallenomina 
                                                WHERE terid = ".$terid."         
                                                      AND conceptoid = 38 
                                                      AND pernominaid >= ".$permin." AND pernominaid <= ".$permax."";
                                    $pervacaciones = $clase->SeleccionarUno($vsql24);

                                    if(strlen($pervacaciones) > 0)
                                    {
                                        $pervacaciones++;

                                        $vsql31 = "SELECT IFNULL(SUM(valor),0) AS diasvaca  
                                                     FROM hisdetallenomina 
                                                    WHERE terid = ".$terid."         
                                                          AND (pernominaid >= ".$pervacaciones." AND pernominaid <= ".$permax.")  
                                                          AND conceptoid IN (1,10,11,12,13,23,31,38,40)";
                                        $diasvaca = $clase->SeleccionarUno($vsql31);
                                    }
                                    else
                                        $diasvaca = $diasyearant + $diasps + $diasss;

                                    // sueldo básico
                                    $vsql19 = "SELECT saldo FROM detalleliquidacion WHERE conceptoid = 1 AND pernominaid = ".$periodoid." AND terid = ".$terid;
                                    $ultimobasico = $clase->SeleccionarUno($vsql19);
                                    
                                    if($ultimobasico == 0)
                                    {
                                        $vsql20 = "SELECT MAX(pernominaid) FROM detallenomina WHERE conceptoid = 1 AND terid = ".$terid;
                                        $ultimoperbasico = $clase->SeleccionarUno($vsql20);
                        
                                        $vsql19 = "SELECT saldo FROM detallenomina WHERE conceptoid = 1 AND pernominaid = ".$ultimoperbasico." AND terid = ".$terid;
                                        $ultimobasico = $clase->SeleccionarUno($vsql19);
                                    }

                                    // busco recargo nocturno
                                    $recarnonocturno = buscarrecargonoc($terid,$periodoid);

                                    $pagovaca = ($ultimobasico + $recarnonocturno) * $diasvaca / 720;

                                    $pagovaca = round($pagovaca,2);

                                    // Valido la existencia de este concepto
                                    $repetido = 0;          $vsql22 = "";               $vsql23 = "";               $vsql24 = "";
                                    
                                    $vsql22 = "SELECT COUNT(*) repetido FROM liquidacion WHERE terid = ".$terid." AND tipo = 'vacaciones' AND periodonomina = '".$codperiodo."'";
                                    $repetido = $clase->SeleccionarUno($vsql22);

                                    if($repetido > 0)
                                    {
                                        $vsql23 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND tipo = 'vacaciones' AND periodonomina = '".$codperiodo."'";
                                        $idliquidacion = $clase->SeleccionarUno($vsql23);

                                        $vsql24 = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
                                        $clase->EjecutarSQL($vsql24);
                                    }

                                    // Almaceno en la tabla
                                    $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                                    VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovaca.",".$diasvaca.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }

                                // ---------------------------------------------------------- //
                                // Cálculo de primas
                                if(($primasprimersemestre == "SI") || ($primassegundosemestre == "SI"))
                                {
                                    // Primas primer semestre
                                    if($primasprimersemestre == "SI")
                                    {
                                        $diasprima += $diasps;
                                        $pagoprimasps = ($basico + $auxtrans) * $diasps / 360;
                                    }

                                    // Primas segundo semestre
                                    if($primassegundosemestre == "SI")
                                    {
                                        $diasprima += $diasss;
                                        $pagoprimasss = ($basico + $auxtrans) * $diasss / 360;
                                    }

                                    $pagoprimas = $pagoprimasps + $pagoprimasss;
                                    $pagoprimas = round($pagoprimas,2);

                                    // Valido la existencia de este concepto
                                    $repetido = 0;          $vsql22 = "";               $vsql23 = "";               $vsql24 = "";

                                    $vsql22 = "SELECT COUNT(*) repetido FROM liquidacion WHERE terid = ".$terid." AND tipo = 'primas' AND periodonomina = '".$codperiodo."'";
                                    $repetido = $clase->SeleccionarUno($vsql22);

                                    if($repetido > 0)
                                    {
                                        $vsql23 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND tipo = 'primas' AND periodonomina = '".$codperiodo."'";
                                        $idliquidacion = $clase->SeleccionarUno($vsql23);

                                        $vsql24 = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
                                        $clase->EjecutarSQL($vsql24);
                                    }                                    

                                    // Almaceno en la tabla
                                    $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                                VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimas.",".$diasprima.",0,0)";
                                    $clase->EjecutarSQL($vsql);
                                }
                            }
                        }
                    }
                }

                // Almaceno en un archivo de texto las códigos que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocodigos.= str_pad($dni,1,"").' -- '.str_pad($motivo,1,"").Chr(13).Chr(10);                       // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresrecargos.txt";                                                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                                                     // se abre el archivo para escribir
                    fwrite($fd, $nocodigos);                                                                            // Grabas
                    fclose($fd);                                                                                        // Cierras el archivo
                }
            }

            // --------------------------------------------------------------------------------------------------------------- //
            // Impresión de la fecha del último proceso ejecutado
            $mesimp = date('F');
            if($mesimp == "January")       $mesimp = "enero";
            if($mesimp == "February")      $mesimp = "febrero";
            if($mesimp == "March")         $mesimp = "marzo";
            if($mesimp == "April")         $mesimp = "abril";
            if($mesimp == "May")           $mesimp = "mayo";
            if($mesimp == "June")          $mesimp = "junio";
            if($mesimp == "July")          $mesimp = "julio";
            if($mesimp == "August")        $mesimp = "agosto";
            if($mesimp == "September")     $mesimp = "septiembre";
            if($mesimp == "October")       $mesimp = "octubre";
            if($mesimp == "November")      $mesimp = "noviembre";
            if($mesimp == "December")      $mesimp = "diciembre";

            $dayweek = date("l");
            if($dayweek == "Monday")       $dayweek = "lunes";
            if($dayweek == "Tuesday")      $dayweek = "martes";
            if($dayweek == "Wednesday")    $dayweek = "miércoles";
            if($dayweek == "Thursday")     $dayweek = "jueves";
            if($dayweek == "Friday")       $dayweek = "viernes";
            if($dayweek == "Saturday")     $dayweek = "sábado";
            if($dayweek == "Sunday")       $dayweek = "domingo";

            $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');

            $nocodigos.= ''.Chr(13).Chr(10);
            $nocodigos.= str_pad($fechoraimp,1,"").''.Chr(13).Chr(10);      // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresrecargos.txt";                               // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                 // se abre el archivo para escribir
            fwrite($fd, $nocodigos);                                        // Grabas
            fclose($fd);                                                    // Cierras el archivo
            // --------------------------------------------------------------------------------------------------------------- //
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            $clase->Aviso(1,"proceso culminado satisfactoriamente");
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=recargonocturnoliq&periodoid=$periodoid");
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: correcionliquidaciones
    // Creación: 16/07/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que procesa los empleados con recargo nocturno desde una hoja de 
    //              Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "correcionliquidaciones")
    {
        $codperiodo = $_GET["codperiodo"];
        $periodoid = $_GET["periodoid"];        

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b></td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor diríjase al servidor </font><br> 
        //                <font color=blue> 192.168.14.248:9999 </font> <br>
        //                <font color=red>o al servidor </font> <br> 
        //                <font color=blue> dromedicas.sytes.net:9996 </font> <br>
        //                <font color=red> para poder importar primas </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">        
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'" id="theform" enctype="multipart/form-data">
        //                 <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
        //                </form> 
        //               </td>    
        //              </tr>
        //             </table>';
        // else
        // {
            // nombre del periodo            
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="800">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Corrección de liquidaciones <br> <font color="blue">'.strtolower($desperiodo).'</font> </b> </td> 
                     </tr> 
                    </table>
                    <table width="800">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="importacionexcelnom.php?opcion=aplicacorreccion" id="theform" enctype="multipart/form-data">                       
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="file" name="excel" /> <br> <br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="800">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> 
                     </tr>
                     </table>
                     <table width="800">
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>A</b>: c&eacute;dula </td> 
                      <td align="left"> &nbsp; Columna <b>B</b>: sueldo </td>
                      <td align="left"> &nbsp; Columna <b>C</b>: transporte </td>
                     </tr>
                     <tr class="TablaDocsPar">
                      <td align="left"> &nbsp; Columna <b>D</b>: pensi&oacute;n </td>
                      <td align="left"> &nbsp; Columna <b>E</b>: salud </td>
                      <td align="left"> &nbsp; Columna <b>F</b>: pago vacaciones </td>
                     </tr> 
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>G</b>: d&iacute;as vacaciones </td>
                      <td align="left"> &nbsp; Columna <b>H</b>: pago prima </td>
                      <td align="left"> &nbsp; Columna <b>I</b>: d&iacute;as prima </td>
                     </tr> 
                     <tr class="TablaDocsPar">
                      <td align="left"> &nbsp; Columna <b>J</b>: pago cesant&iacute;as </td>
                      <td align="left"> &nbsp; Columna <b>K</b>: pago intereses </td>
                      <td align="left"> &nbsp; Columna <b>L</b>: d&iacute;as cesant&iacute;as </td>
                     </tr>
                    </table>';
    
            $cont.='<table width="800">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocorrecionliq.png" width="780" height="280" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        // }

        echo $cont;
        exit();
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: aplicacorreccion
    // Creación: 16/07/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que aplica los correctivos masivamente a las liquidaciones 
    //              seleccionadas en una hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "aplicacorreccion")
    {
		set_time_limit(0);
		extract($_POST);        
        $codperiodo = $_POST["codperiodo"];
        $periodoid = $_POST["periodoid"];        
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;
        
        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
					$_DATOS_EXCEL[$i]['sueldo'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['auxtrasporte'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pension'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['salud'] = $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['vacaciones'] = $objPHPExcel->getActiveSheet()->getCell('F'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['diasvacaciones'] = $objPHPExcel->getActiveSheet()->getCell('G'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['prima'] = $objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['diasprima'] = $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagocesantias'] = $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['interesescesantias'] = $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['diascesantias'] = $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0)
                        $recorrer = false;
                    
                    $i++;
                }   /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo            

            // ------------------------------------------------------------------------------------------ //
            // Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;
            $listaperiodos = generarlistaper($codperiodo);
            $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocodigos = 'CORRECCION LIQUIDACIONES'.Chr(13).Chr(10);
            $nocodigos.= 'CEDULAS NO GRABADAS:'.Chr(13).Chr(10);
            $nocodigos.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $motivo = "";
                $dni = $_DATOS_EXCEL[$j]['dni'];

                // valido que el empleado exista
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],'terceros',"dni","terid");
                
                if($terid == "")
                    $motivo = "Empleado no existe";
                else
                {
                    // inicialización de variables
                    $lbgrabo = false;                                           $idhistorico = 0;                                   $vsql18 = "";
                    $detalleid = 0;                                             $numeroreg = 0;                                     $periodoidliq = 0;
                    $porcentaje = 12;                                           $mesperiodoliq = substr($codperiodo,0,2);           $numreg = 0;
                    $vsql17 = "";                                               $basico = 0;                                        $diastrab = 0;
                    $sueldodeducciones = 0;                                     $diasliq = 0;

                    // valido la entrada del sueldo
                    $sueldo = $_DATOS_EXCEL[$j]['sueldo'];

                    // ------------------------------------------------------------------------------------------------------------------------------------------------------------------ //
                    if($sueldo > 1)
                    {
                        // busco el sueldo
                        $vsql = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 1 AND pernominaid IN ($listaperiodos) ";
                        $detalleid = $clase->SeleccionarUno($vsql);

                        if($detalleid!="")
                            $vsql = "UPDATE detalleliquidacion SET devengados = ".$sueldo." WHERE detalleid = ".$detalleid;
                        else
                        {
                            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                            $numreg = $clase->SeleccionarUno($vsql);

                            // Obtengo el salario básico del empleado
                            $vsql17 = "SELECT hc.ultsueldo 
                                         FROM histcontrato hc
                                        WHERE hc.terid = ".$terid." 
                                              AND hc.id = (SELECT MAX(id)
                                                             FROM histcontrato
                                                            WHERE terid = ".$terid.")";
                            $basico = $clase->SeleccionarUno($vsql17);

                            $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                            $idhistorico = $clase->SeleccionarUno($vsql18);
                            
                            // obtengo la fecha de retiro
                            $vsql21 = "SELECT hc.fecretiro 
                                         FROM histcontrato hc
                                        WHERE hc.terid = ".$terid." 
                                              AND hc.id = ".$idhistorico;
                            $fecretiro = $clase->SeleccionarUno($vsql21);

                            $diaretiro = substr($fecretiro,-2);

                            // determino el periodo y los días trabajados
                            if($diaretiro <=15)
                            {
                                $periodoidliq = intval(substr($listaperiodos,0,2));
                                $diastrab = $diaretiro;
                            }
                            else
                            {
                                $periodoidliq = intval(substr($listaperiodos,3,2));
                                $diastrab = $diaretiro - 15;
                            }
                            $diastrab = intval($diastrab);
                
                            // construyo la instrucción
                            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",1,".$periodoidliq.",".$sueldo.",0,".$diastrab.",$basico)";
                        }

                        // guardo el nuevo sueldo
                        $clase->EjecutarSQL($vsql);
                        
                        $detalleid = 0;
                    }

                    // ------------------------------------------------------------------------------------------------------------------------------------------------------------------ //
                    // Valido la entrada del subsidio de transporte
                    $auxtrasporte = $_DATOS_EXCEL[$j]['auxtrasporte'];                    

                    if($auxtrasporte > 1)
                    {
                        // busco el auxilio de transporte
                        $vsql = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 3 AND pernominaid IN ($listaperiodos) ";
                        $detalleid = $clase->SeleccionarUno($vsql);

                        if($detalleid!="")
                            $vsql = "UPDATE detalleliquidacion SET devengados = ".$auxtrasporte." WHERE detalleid = ".$detalleid;
                        else
                        {
                            // obtengo la fecha de retiro
                            $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                            $idhistorico = $clase->SeleccionarUno($vsql18);
                            
                            $vsql21 = "SELECT hc.fecretiro 
                                         FROM histcontrato hc
                                        WHERE hc.terid = ".$terid." 
                                              AND hc.id = ".$idhistorico;
                            $fecretiro = $clase->SeleccionarUno($vsql21);

                            $diaretiro = substr($fecretiro,-2);

                            // obtengo el periodo y los días trabajados
                            if($diaretiro <=15)
                            {
                                $periodoidliq = intval(substr($listaperiodos,0,2));
                                $diastrab = $diaretiro;
                            }
                            else
                            {
                                $periodoidliq = intval(substr($listaperiodos,3,2));
                                $diastrab = $diaretiro - 15;
                            }
                            $diastrab = intval($diastrab);

                            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                            $numreg = $clase->SeleccionarUno($vsql);
                            $numreg++;
                    
                            // construyo la instrucción
                            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",3,".$periodoidliq.",".$auxtrasporte.",0,".$diastrab.",$valsubtransporte)";
                        }

                        // guardo el nuevo sueldo
                        $clase->EjecutarSQL($vsql);
                        
                        $detalleid = 0;
                    }

                    // ------------------------------------------------------------------------------------------------------------------------------------------------------------------ //
                    // Valido la entrada de la pensión
                    $pension = $_DATOS_EXCEL[$j]['pension'];

                    if($pension > 1)
                    {
                        // busco el auxilio de transporte
                        $vsql = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 4 AND pernominaid IN ($listaperiodos) ";
                        $detalleid = $clase->SeleccionarUno($vsql);

                        if($detalleid!="")
                            $vsql = "UPDATE detalleliquidacion SET descuentos = ".$pension." WHERE detalleid = ".$detalleid;
                        else
                        {
                            // obtengo la fecha de retiro
                            $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                            $idhistorico = $clase->SeleccionarUno($vsql18);
                            
                            $vsql21 = "SELECT hc.fecretiro 
                                         FROM histcontrato hc
                                        WHERE hc.terid = ".$terid." 
                                              AND hc.id = ".$idhistorico;
                            $fecretiro = $clase->SeleccionarUno($vsql21);

                            $diaretiro = substr($fecretiro,-2);

                            // obtengo el periodo 
                            if($diaretiro <=15)
                                $periodoidliq = intval(substr($listaperiodos,0,2));
                            else
                                $periodoidliq = intval(substr($listaperiodos,3,2));

                            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                            $numreg = $clase->SeleccionarUno($vsql);
                            $numreg++;

                            $sueldodeducciones = $pension * 25;
                    
                            // construyo lainstrucción
                            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",4,".$periodoidliq.",0,".$pension.",0,$sueldodeducciones)";
                        }                        

                        // guardo el nuevo sueldo
                        $clase->EjecutarSQL($vsql);
                        
                        $detalleid = 0;
                    }

                    // ------------------------------------------------------------------------------------------------------------------------------------------------------------------ //
                    // Valido la entrada de la salud
                    $salud = $_DATOS_EXCEL[$j]['salud'];

                    if($salud > 1)
                    {
                        $vsql = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = 5 AND pernominaid IN ($listaperiodos) ";
                        $detalleid = $clase->SeleccionarUno($vsql);

                        if($detalleid!="")
                            $vsql = "UPDATE detalleliquidacion SET descuentos = ".$salud." WHERE detalleid = ".$detalleid;
                        else
                        {
                            // obtengo la fecha de retiro
                            $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                            $idhistorico = $clase->SeleccionarUno($vsql18);
                            
                            $vsql21 = "SELECT hc.fecretiro 
                                         FROM histcontrato hc
                                        WHERE hc.terid = ".$terid." 
                                              AND hc.id = ".$idhistorico;
                            $fecretiro = $clase->SeleccionarUno($vsql21);

                            // determino el periodo
                            $diaretiro = substr($fecretiro,-2);

                            if($diaretiro <=15)
                                $periodoidliq = intval(substr($listaperiodos,0,2));
                            else
                                $periodoidliq = intval(substr($listaperiodos,3,2));

                            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                            $numreg = $clase->SeleccionarUno($vsql);
                            $numreg++;

                            $sueldodeducciones = $salud * 25;

                            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoidliq.",0,".$salud.",0,$sueldodeducciones)";
                            $clase->EjecutarSQL($vsql);
                        }

                        // guardo el nuevo sueldo
                        $clase->EjecutarSQL($vsql);
                        
                        $detalleid = 0;
                    }

                    // ------------------------------------------------------------------------------------------------------------------------------------------------------------------ //
                    // Aquí depuro los conceptos que estén en cero
                    $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid IN ($listaperiodos) AND terid = ".$terid;
                    $clase->EjecutarSQL($vsql);

                    // ------------------------------------------------------------------------------------------------------------------------------------------------------------------ //
                    // valido la entrada de las vacaciones
                    $vacaciones = $_DATOS_EXCEL[$j]['vacaciones'];

                    if($vacaciones > 1)
                    {
                        $vacaciones = round($vacaciones,2);

                        $vsql = "SELECT COUNT(*) FROM liquidacion WHERE terid = ".$terid." AND tipo = 'vacaciones' AND periodonomina = '".$codperiodo."'";
                        $numeroreg = $clase->SeleccionarUno($vsql);

                        if($numeroreg == 1)
                        {
                            $vsql = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND tipo = 'vacaciones' AND periodonomina = '".$codperiodo."'";
                            $idliquidacion = $clase->SeleccionarUno($vsql);

                            $vsql = "UPDATE liquidacion SET pago = ".$vacaciones." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $diasvacaciones = $_DATOS_EXCEL[$j]['diasvacaciones'];

                            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                          VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$vacaciones.",".$diasvacaciones.",0,0)";
                        }
                        $clase->EjecutarSQL($vsql);
                    }

                    // ------------------------------------------------------------------------------------------------------------------------------------------------------------------ //
                    // valido la entrada de las primas
                    $prima = $_DATOS_EXCEL[$j]['prima'];                    

                    if($prima > 1)
                    {
                        $prima = round($prima,2);

                        $vsql = "SELECT COUNT(*) FROM liquidacion WHERE terid = ".$terid." AND tipo = 'primas' AND periodonomina = '".$codperiodo."'";
                        $numeroreg = $clase->SeleccionarUno($vsql);

                        if($numeroreg == 0)
                        {
                            $diasprima = $_DATOS_EXCEL[$j]['diasprima'];

                            $vsql = "INSERT INTO liquidacion (periodonomina,terid,tipo,pago,cantidad,porcentaje,pagointereses) 
                                              VALUES ('".$codperiodo."',".$terid.",'primas',".$prima.",".$diasprima.",0,0)";
                        }
                        
                        if($numeroreg == 1)
                        {
                            $diasprima = $_DATOS_EXCEL[$j]['diasprima'];

                            // determino la cantidad de días
                            $vsql = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND tipo = 'primas' AND periodonomina = '".$codperiodo."'";
                            $idliquidacion = $clase->SeleccionarUno($vsql);

                            $vsql = "SELECT cantidad FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
                            $diasliq = $clase->SeleccionarUno($vsql);

                            if((($mesperiodoliq == "06") || ($mesperiodoliq == "12")) && ($diasprima != $diasliq))
                                $vsql = "INSERT INTO liquidacion (periodonomina,terid,tipo,pago,cantidad,porcentaje,pagointereses) 
                                              VALUES ('".$codperiodo."',".$terid.",'primas',".$prima.",".$diasprima.",0,0)";
                            else    
                                $vsql = "UPDATE liquidacion SET pago = ".$prima." WHERE idliquidacion = ".$idliquidacion;                            
                        }

                        if($numeroreg > 1)
                        {
                            $vsql = "SELECT MAX(idliquidacion) FROM liquidacion WHERE terid = ".$terid." AND tipo = 'primas' AND periodonomina = '".$codperiodo."'";
                            $idliquidacion = $clase->SeleccionarUno($vsql);
    
                            $vsql = "UPDATE liquidacion SET pago = ".$prima." WHERE idliquidacion = ".$idliquidacion;
                        }                        
                        $clase->EjecutarSQL($vsql);                        
                    }

                    // ------------------------------------------------------------------------------------------------------------------------------------------------------------------ //
                    // valido la entrada de las cesantías
                    $pagocesantias = $_DATOS_EXCEL[$j]['pagocesantias'];
                    $interesescesantias = $_DATOS_EXCEL[$j]['interesescesantias'];
                    $diascesantias = $_DATOS_EXCEL[$j]['diascesantias'];

                    if(($pagocesantias > 1) || ($interesescesantias > 1))
                    {
                        $pagocesantias = round($pagocesantias,2);
                        $interesescesantias = round($interesescesantias,2);
                        $diascesantias = intval($diascesantias);

                        $vsql = "SELECT COUNT(*) FROM liquidacion WHERE terid = ".$terid." AND tipo = 'cesantias' AND periodonomina = '".$codperiodo."'";
                        $numeroreg = $clase->SeleccionarUno($vsql);

                        if($numeroreg == 0)
                            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                          VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$diascesantias.",".$porcentaje.",".$interesescesantias.")";
                        
                        if($numeroreg == 1)
                        {
                            if($mesperiodoliq == "01")
                                $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                          VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$diascesantias.",".$porcentaje.",".$interesescesantias.")";                            
                            else
                            {
                                $vsql = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND tipo = 'cesantias' AND periodonomina = '".$codperiodo."'";
                                $idliquidacion = $clase->SeleccionarUno($vsql);
    
                                $vsql = "UPDATE liquidacion SET 
                                                pago = ".$pagocesantias." , 
                                                cantidad = ".$diascesantias.", 
                                                pagointereses = ".$interesescesantias." 
                                          WHERE idliquidacion = ".$idliquidacion;
                            }
                        }

                        if($numeroreg > 1)
                        {
                            $vsql = "SELECT MAX(idliquidacion) FROM liquidacion WHERE terid = ".$terid." AND tipo = 'cesantias' AND periodonomina = '".$codperiodo."'";
                            $idliquidacion = $clase->SeleccionarUno($vsql);                            
    
                            $vsql = "UPDATE liquidacion SET 
                                            pago = ".$pagocesantias." , 
                                            cantidad = ".$diascesantias.", 
                                            pagointereses = ".$interesescesantias." 
                                      WHERE idliquidacion = ".$idliquidacion;
                        }
                        $clase->EjecutarSQL($vsql);
                    }
                }

                // ------------------------------------------------------------------------------------------------------------------------------------------------------------------ //
                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "errores.txt";                                                   // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                    // Grabas
            fclose($fd);                                                                // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se corrigieron las liquidaciones");
            else
                $clase->Aviso(1,"Se corrigieron $grabados liquidaciones");    
    
            // Redirecciona el formulario
            header("Location: importacionexcelnom.php?opcion=ventliquidacionesxls&codperiodo=$codperiodo&periodoid=$periodoid");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: descargarrecargos
    // Creación: 03/02/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción emite la salida en una hoja de Excel de los recargos de un 
    //              periodo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "descargarrecargos")
    {
        $periodoid = $_GET['periodoid'];
        
        // nombre del periodo
        $descripcionperiodo = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // nombre de la hoja de excel
        $nombrearchivo = "recargos del periodo ".strtolower($descripcionperiodo).".xls";
        
        // consulta de la hoja de Excel
        $vsql = "SELECT d.detalleid, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, d.valor, d.devengados, c.nomconcepto 
                   FROM tercerosactual t
                        INNER JOIN detallenomina d ON (t.terid = d.terid)
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.pernominaid = ".$periodoid."
                        AND c.recargo = 'CHECKED'";

        // Preparación del entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("recargos de un periodo - DROPOS")
                                     ->setSubject("recargos de un periodo - DROPOS")
                                     ->setDescription("recargos de un periodo - DROPOS")
                                     ->setKeywords("recargos de un periodo - DROPOS")
                                     ->setCategory("Categoria General");        

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'RECARGOS')
                    ->setCellValue('A2', $descripcionperiodo)
                    ->setCellValue('A4', 'DOCUMENTO')
                    ->setCellValue('B4', 'EMPLEADO')
                    ->setCellValue('C4', 'CONCEPTOS')
                    ->setCellValue('D4', 'CANTIDAD')
                    ->setCellValue('E4', 'MONTO');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,5);
        
        $i = 5;
        $totalrecargos = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);        
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['dni'])
                        ->setCellValue('B'.$i, $row['nombreemp'])
                        ->setCellValue('C'.$i, $row['nomconcepto'])
                        ->setCellValue('D'.$i, number_format($row['valor']))
                        ->setCellValue('E'.$i, number_format($row['devengados']));
            $i++;
            $cant++;
            $totalrecargos += $row['devengados'];
        }

        // Impresión de los totales
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('C'.$i, "NETO A PAGAR:")
                    ->setCellValue('E'.$i, number_format($totalrecargos));


        $rangoEncabezado = 'A4:E4';
        $rangoCeldas     = 'A4:E'.($cant+1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(20);

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('recargos');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$nombrearchivo.'"');
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función validar_fecha_espanol
    // Parámetro de entrada:    $fecha --> Fecha que se va a evaluar
    // Valor de retorno:        true o false
    // Descripción: Función que valida el formato de fecha dd/mm/aaaa
    ////////////////////////////////////////////////////////////////////////////////////////
    function validar_fecha_espanol($fecha)
    {
        $valores = explode('/', $fecha);
        if(count($valores) == 3 && checkdate($valores[1], $valores[0], $valores[2]))
        {
            return true;
        }
        return false;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función verifica_rango
    // Parámetro de entrada:    $date_inicio --> Fecha de inicio del periodo
    //                          $date_fin    --> Fecha fin del periodo
    //                          $date_nueva  --> Fecha que se va a evaluar
    // Valor de retorno:        true o false
    // Descripción: Función que valida si una fecha está en un rango especifico
    ////////////////////////////////////////////////////////////////////////////////////////    
    function verifica_rango($date_inicio, $date_fin, $date_nueva) 
    {
        $date_inicio = strtotime($date_inicio);
        $date_fin = strtotime($date_fin);
        $date_nueva = strtotime($date_nueva);

        if (($date_nueva >= $date_inicio) && ($date_nueva <= $date_fin))
            return true;
        else
            return false;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función valida_concepto
    // Parámetro de entrada:    $conceptoid --> id del concepto de nómina
    // Valor de retorno:        true o false
    // Descripción: Función que verifica si el concepto de nómina que viene de la hoja de 
    //              Excel es una libranza o descuento permanente
    ////////////////////////////////////////////////////////////////////////////////////////
    function valida_concepto($conceptoid) 
    {
        $valido = false;

        $clase2 = new Sistema();
        
        $vsql2 = "SELECT conceptoid
                    FROM conceptosnomina 
                   WHERE eslibranza = 'CHECKED' OR montopermanente = 'CHECKED' 
                ORDER BY conceptoid ASC";

        $conex = $clase2->Conectar();
        $result2 = mysql_query($vsql2,$conex);
        $cant = mysql_num_rows($result2);

        if($cant>0)
        {
            $lista_libranza = [];
            $i = 0;
            while($row = mysql_fetch_array($result2))
            {
                $i++;
                $lista_libranza[$i] = $row['conceptoid'];
            }
            
            if (in_array($conceptoid, $lista_libranza))
                $valido = true;
        }

        return($valido);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función fechayhoraejecucion
    // Parámetro de entrada:    Ninguno
    // Valor de retorno:        $fechoraimp --> día, fecha y hora
    // Descripción: Función que devuelve la fecha con día, fecha y hora de ejecución del 
    //              último proceso
    ////////////////////////////////////////////////////////////////////////////////////////
    function fechayhoraejecucion()
    {
        $mesimp = date('F');
        if($mesimp == "January")       $mesimp = "enero";
        if($mesimp == "February")      $mesimp = "febrero";
        if($mesimp == "March")         $mesimp = "marzo";
        if($mesimp == "April")         $mesimp = "abril";
        if($mesimp == "May")           $mesimp = "mayo";
        if($mesimp == "June")          $mesimp = "junio";
        if($mesimp == "July")          $mesimp = "julio";
        if($mesimp == "August")        $mesimp = "agosto";
        if($mesimp == "September")     $mesimp = "septiembre";
        if($mesimp == "October")       $mesimp = "octubre";
        if($mesimp == "November")      $mesimp = "noviembre";
        if($mesimp == "December")      $mesimp = "diciembre";

        $dayweek = date("l");
        if($dayweek == "Monday")       $dayweek = "lunes";
        if($dayweek == "Tuesday")      $dayweek = "martes";
        if($dayweek == "Wednesday")    $dayweek = "miércoles";
        if($dayweek == "Thursday")     $dayweek = "jueves";
        if($dayweek == "Friday")       $dayweek = "viernes";
        if($dayweek == "Saturday")     $dayweek = "sábado";
        if($dayweek == "Sunday")       $dayweek = "domingo";

        $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');
        return($fechoraimp);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función generarlistaper
    // Parámetro de entrada:    $codperiodo    --> código del periodo
    // Valor de retorno:        $listaperiodos --> lista de periodos de nómina del periodo
    // Descripción: Función que devuelve la lista de periodos de nómina del periodo que se 
    //              está procesando
    ////////////////////////////////////////////////////////////////////////////////////////
    function generarlistaper($codperiodo)
    {
        $clase2 = new Sistema();

        $yeartoday = date("Y");

        $monthtoday = date("m");
        $daytoday = date("j");
        if(($monthtoday=="01")&&($daytoday<=16))   $yeartoday--;
        // ------------------------------------------------------------- //

        // Determino los periodos de nómina que se eliminarán
        $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                         FROM periodosnomina 
                        WHERE consecutivone <> ''
                              AND YEAR(fechasta) = ".$yeartoday."";
        $nummesval = $clase2->SeleccionarUno($vsqlmesval);
        
        $nummesval++;

        if($nummesval==13)      $nummesval = 1;

        $vsqlcodmesrep  = "SELECT codperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
        $codperiodo = $clase2->SeleccionarUno($vsqlcodmesrep);

        if(($codperiodo=="")||($codperiodo==NULL))
        {
            $yeartoday--;
            $nummesval--;
            $vsqlcodmesrep = "SELECT codperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
            $codperiodo = $clase2->SeleccionarUno($vsqlcodmesrep);
        }

        $vsqldesmesrep  = "SELECT desperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
        $desmesrep = $clase2->SeleccionarUno($vsqldesmesrep);

        $desperiodo = $clase2->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $mesperiodo = substr($desperiodo,0,-5);

        // fechas del periodo
        $fecinicio = substr($desperiodo,-4)."-".substr($codperiodo,0,2)."-01";
        $fecfinal = date("Y-m-t", strtotime($fecinicio));

        // Consulta de los periodos de nómina
        $vsql = "SELECT periodoid 
                   FROM periodosnomina 
                  WHERE descripcion LIKE '%".$mesperiodo."%' 
                        AND descripcion LIKE '%".$yeartoday."%'";
        $conex  = $clase2->Conectar();
        $result = mysql_query($vsql,$conex);
        $periodosreportar = mysql_num_rows($result);

        // Periodos a procesar
        if($periodosreportar>0)
        {
            $j = 0;
            while($row = mysql_fetch_array($result))
            {
                $listaperiodos.= $row['periodoid'].",";
                $segundaquinper = $row['periodoid'];

                $j++;
                if($j==1)   $pquin = $row['periodoid'];
                if($j==2)   $squin = $row['periodoid'];
            }
            $listaperiodos = substr($listaperiodos, 0, -1);
        }
        return($listaperiodos);
    }


    function procesarretiroper($terid,$pernominaid,$devengados,$valor,$saldo)
    {
        $clase2 = new Sistema();

        $conceptoid = 1;

        // Grabo en la tabla detallenomina
        $vsql1 = "INSERT INTO detallenomina (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) VALUES (".$terid.",".$conceptoid.",".$pernominaid.",".$devengados.",0,".$valor.",".$saldo.")";
        // $clase2->EjecutarSQL($vsql1);

        // Paso a retiro a este empleado

        // Determino qué condición de empleado posee
        $fecingreso = $clase2->BDLockup($terid,'terceros','terid','fecingreso');
        $cargoid = $clase2->BDLockup($terid,'terceros','terid','cargoid');
        $extralegal = $clase2->BDLockup($terid,'terceros','terid','extralegal');
        $esempleadoactivo = $clase2->BDLockup($terid,'terceros','terid','esempleadoactivo');
        $basico = $saldo;
        $dias = $valor;
        $idcondicionact = $clase2->BDLockup($terid,'terceros','terid','idcondicion');

        if($idcondicionact == 0)
        {
            $idcondicion = 0;
    
            if($cargoid==70)
                $idcondicion = 1;
            elseif($cargoid==71)
                $idcondicion = 2;
            elseif(($extralegal=="CHECKED")&&($esempleadoactivo=="CHECKED"))
                $idcondicion = 3;
            elseif(($extralegal!="CHECKED")&&($esempleadoactivo=="CHECKED"))
                $idcondicion = 4;
        }
        else
            $idcondicion = $idcondicionact;

        $esempleado = "";
        $esempleadoactivo = "";
        $enliquidacion = "CHECKED";

        // grabo en la tabla terceros
        $vsql2 = "UPDATE terceros SET 
                         esempleado = '".$esempleado."',
                         esempleadoactivo = '".$esempleadoactivo."',
                         enliquidacion = '".$enliquidacion."',
                         idcondicion = ".$idcondicion."
                   WHERE terid = ".$terid;
        // $clase2->EjecutarSQL($vsql2);

        // determino la fecha de retiro
        $fecdesde = $clase2->BDLockup($pernominaid,'periodosnomina','periodoid','fecdesde');

        // fecretiro = = strtotime($date."- 2 days");
        $suma = "+".strval($dias-1)." day";
        $fecretiro = strtotime(".$suma.", strtotime($fecdesde));
        $fecretiro = date('Y-m-d', $fecretiro);

        $vsql3 = "INSERT INTO histcontrato (terid,fecingreso,fecretiro,ultsueldo,idcondicion) VALUES (".$terid.",'".$fecingreso."','".$fecretiro."',".$basico.",".$idcondicion.")";
        // $clase2->EjecutarSQL($vsql3);

        // Elimino el empleado de la tabla de enlace sección terceros
        $vsqld = "DELETE FROM seccionterceros WHERE terid = ".$terid;
        // $clase2->EjecutarSQL($vsqld);

        // echo $vsql1.' -- '.$vsql2.' -- '.$vsql3.' -- '.$vsqld; exit();

        return;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función tienecambiosalario
    // Parámetros de entrada:    $terid --> ID del empelado
    //                           $fecretiro --> Fecha de retiro
    // Valor de retorno:         $tienecambio --> true o false si tiene cambio de salario
    // Descripción: Función que determina si un empleado tiene cambio de salario en los 
    //              últimos tres meses
    ////////////////////////////////////////////////////////////////////////////////////////
    function tienecambiosalario($terid,$fecretiro)
    {
        $clase2 = new Sistema();

        $vsql28 = "SELECT MAX(periodoid) maxper4 FROM periodosnomina WHERE fechasta <= '".$fecretiro."'";
        $maxper4 = $clase2->SeleccionarUno($vsql28);        

        // --------------------------------------------------------------------------------------------------------------------------------------------------- //
        $maxper4++;                

        $i = 1;
        $tienecambio = false;
        $recarnonocturno = 0;

        // consulta de los últimos tres meses o seis quincenas laboradas
        $vsql29 = "SELECT pernominaid, basico saldo 
                     FROM periodoterceros 
                    WHERE terid = ".$terid."
                          AND pernominaid <= ".$maxper4."
                    UNION ALL
                   SELECT pernominaid, saldo 
                     FROM detalleliquidacion 
                    WHERE terid = ".$terid." 
                          AND conceptoid IN (1,10,11,12,13,31,38,43) 
                          AND pernominaid <= ".$maxper4."
                 ORDER BY 1 DESC LIMIT 0,6";

        $conex = $clase2->Conectar();
        $result3 = mysql_query($vsql29,$conex);
        while($row3 = mysql_fetch_array($result3))
        {
            $saldo = $row3['saldo'];
            $pernominaid = $row3['pernominaid'];

            // busco recargo nocturno
            $recarnonocturno = buscarrecargonoc($terid,$pernominaid);
            $saldo += $recarnonocturno;

            // determino si existe variación
            if($i == 1)
                $auxcambio = $saldo;
            else
            {
                if($saldo > 0)
                {
                    if($saldo != $auxcambio)
                        $tienecambio = true;
                    
                    $auxcambio = $saldo;
                }
            }
            $i++;
        }
        
        // --------------------------------------------------------------------------------------------------------------------------------------------------- //
        // $maxper5 = $maxper4 - 1;
        // $minper5 = $maxper4 - 6;        

        // $yearretiro = intval(substr($fecretiro,0,4));
        // $tienecambio = false;        

        // $i = 1;

        // $vsql29 = "SELECT periodoid FROM periodosnomina WHERE periodoid BETWEEN ".$minper5." AND ".$maxper5." AND YEAR(fechasta) = ".$yearretiro."";        
        // $conex = $clase2->Conectar();
        // $result3 = mysql_query($vsql29,$conex);        

        // while($row3 = mysql_fetch_array($result3))
        // {
        //     $periodoid2 = $row3['periodoid'];

        //     $vsql30 = "SELECT saldo 
        //                  FROM hisdetallenomina 
        //                 WHERE terid = ".$terid." 
        //                       AND conceptoid = 1 
        //                       AND pernominaid = ".$periodoid2."";
        //     $saldo = $clase2->SeleccionarUno($vsql30);            

        //     if($i == 1)
        //         $auxcambio = $saldo;
        //     else
        //     {
        //         if($saldo > 0)
        //         {
        //             if($saldo != $auxcambio)
        //                 $tienecambio = true;
                    
        //             $auxcambio = $saldo;
        //         }
        //     }
        //     $i++;
        // }
        // --------------------------------------------------------------------------------------------------------------------------------------------------- //        

        return $tienecambio;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función buscarrecargonoc
    // Parámetros de entrada:    $terid --> ID del empelado
    //                           $fecretiro --> ID del periodo
    // Valor de retorno:         $recargonocper --> Monto del recargo nocturno
    // Descripción: Función que busca el recargo nocturno de un empleado en un periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    function buscarrecargonoc($terid,$pernominaid)
    {
        $clase2 = new Sistema();

        $recargonochis = 0;                 $recargonocliq = 0;                 $recargonocper = 0;
        $vsql11 = "";                       $vsql12 = "";

        $vsql11 = "SELECT IFNULL(devengados,0) recargonochis FROM hisdetallenomina WHERE terid = ".$terid." AND  pernominaid = ".$pernominaid." AND conceptoid = 47";
        $recargonochis = $clase2->SeleccionarUno($vsql11);

        $vsql12 = "SELECT IFNULL(devengados,0) recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND  pernominaid = ".$pernominaid." AND conceptoid = 47";
        $recargonocliq = $clase2->SeleccionarUno($vsql12);

        $recargonocper = $recargonochis + $recargonocliq;

        return $recargonocper;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función calsueldopromedio
    // Parámetro2 de entrada:    $terid --> ID del empelado
    //                           $fecingreso --> fecha de ingreso
    // Valor de retorno:         $salpromedio --> salario promedio
    // Descripción: Función que calcula el sueldo promedio de un empleado en el año actual
    ////////////////////////////////////////////////////////////////////////////////////////    
    function calsueldopromedio($terid,$fecingreso)
    {
        $clase2 = new Sistema();

        // inicializaión de variables
        $yearactual2 = date("Y");           $acumsueldo = 0;
        $nroquinceda = 0;                   $cant1 = 0;
        $cant2 = 0;                         $salpromedio = 0;
        $recarnonocturno = 0;

        // rango de periodos 
        $vsql36 = "SELECT MIN(periodoid) permin3
                     FROM periodosnomina 
                    WHERE fecdesde >= '".$fecingreso."' 
                          AND YEAR(fecdesde) = ".$yearactual2." 
                          AND calculado = 'CHECKED'";
        $permin3 = $clase2->SeleccionarUno($vsql36);
        
        $vsql37 = "SELECT MAX(periodoid) permax3
                     FROM periodosnomina 
                    WHERE fecdesde >= '".$fecingreso."' 
                          AND YEAR(fecdesde) = ".$yearactual2." 
                          AND calculado = 'CHECKED'";
        $permax3 = $clase2->SeleccionarUno($vsql37);

        // promedio en hisdetallenomina
        $vsql38 = "SELECT pernominaid, saldo 
                     FROM hisdetallenomina 
                    WHERE terid = ".$terid." 
                          AND conceptoid IN (1,6,10,11,12,13,23,31,40,43,46) 
                          AND (pernominaid >= ".$permin3." AND pernominaid <= ".$permax3.")";                         

        $conex = $clase2->Conectar();
        $result4 = mysql_query($vsql38,$conex);
        $cant1 = mysql_num_rows($result4);

        if($cant1 > 0)
        {
            $saldo = 0;
            while($row4 = mysql_fetch_array($result4))
            {
                $nroquinceda++;                
                $saldo = $row4['saldo'] / 2;
                $pernominaid = $row4['pernominaid'];

                // busco recargo nocturno
                $recarnonocturno = buscarrecargonoc($terid,$pernominaid);
                $saldo += $recarnonocturno;
    
                $acumsueldo += $saldo;
            }
        }                

        // promedio en detalleliquidacion
        $permax3++;
        $vsql39 = "SELECT pernominaid, saldo 
                     FROM detalleliquidacion  
                    WHERE terid = ".$terid." 
                          AND conceptoid IN (1,6,10,11,12,13,23,31,40,43,46) 
                          AND (pernominaid >= ".$permin3." AND pernominaid <= ".$permax3.")";

        $conex = $clase2->Conectar();
        $result6 = mysql_query($vsql39,$conex);
        $cant2 = mysql_num_rows($result6);

        if($cant2 > 0)
        {
            $saldo = 0;
            while($row5 = mysql_fetch_array($result6))
            {
                $nroquinceda++;
                $saldo = $row5['saldo'] / 2;
                $pernominaid = $row5['pernominaid'];

                // busco recargo nocturno
                $recarnonocturno = buscarrecargonoc($terid,$pernominaid);
                $saldo += $recarnonocturno;
    
                $acumsueldo += $saldo;
            }
        }        

        // cálculo el sueldo promedio        
        $salpromedio = $acumsueldo / $nroquinceda;        
        $salpromedio = intval($salpromedio) * 2;

        return $salpromedio;
    }

    ////////////////////////////////
    echo $cont.$clase->PiePagina();
?>